/**
 * @author Pritam.Patil
 * This is used for Currently & previously Locked user Search form
 */
Ext.define('Academia.view.securitysetup.unlockuser.CurrentlyLockedUserSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.currentlylockedusersearchform',
    frame: false,
    cls:'customSearchPanel',
    autoScroll:true,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('USER_ID'),            
            name: 'USER_ID',
            itemId: 'user_id',
            store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchLockedUserCode'),
			msgTarget: 'qtip',
			valueField: 'value',
			displayField: 'value',
			queryParam:'code',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getUserModuleTranslation('USER_NAME'),
            itemId: 'user_name',
            name: 'USER_NAME',
            store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchLockedUserName'),
			msgTarget: 'qtip',
			valueField: 'value',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        }, {
            xtype: 'textfield',
            fieldLabel: getUserModuleTranslation('LOCKED_REASON'),
            
            itemId: 'reason',
            name: 'LOCKED_REASON'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
//            width: 167,
        	width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getUserModuleTranslation('FROM_DATE'),
            name: 'FROM_DATE',
          //--submitFormat: CONSTANTS.DATE_TIME_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            //minValue : new Date(),
            itemId: 'fromdate',
             //Select from time
            vtype: 'daterange',
            endDateField: 'todate'
        }, {
            xtype: 'datefield',
            fieldLabel: getUserModuleTranslation('TO_DATE'),
            name: 'TO_DATE',
          //--submitFormat: CONSTANTS.DATE_TIME_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            itemId: 'todate',
             //Select from time
            vtype: 'daterange',
            startDateField: 'fromdate'
        }]},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
//                width: 167,
            	width: 226,
                labelAlign: 'top'
            },
            items: [ {
            xtype: 'numberfield',
            fieldLabel: getUserModuleTranslation('MIN_NO_OF_TIMES_LOCKED'),
            
            itemId: 'min',
            name: 'MIN_NO_OF_TIMES_LOCKED',
            minValue: 0
        }, {
            xtype: 'numberfield',
            fieldLabel: getUserModuleTranslation('MAX_NO_OF_TIMES_LOCKED'),
            
            itemId: 'max',
            name: 'MAX_NO_OF_TIMES_LOCKED',
            minValue: 0

        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'lockedUserSearchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'lockedUserClearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});