/**
 * @author sumit.dhage
 * this form is used for student track request
 */
Ext.define('Academia.view.servicerequest.FindFacultyPortalRequestForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.findfacultyportalrequestform',
    frame: false,
    style:{
    	marginLeft: '10px'
    },
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'REQUEST_ID',
			fieldLabel: getServiceRequestTranslation('REQUEST_ID'),
			store: 'servicerequest.studentservicerequest.StudentRequestStore',
			itemId: 'request_id',
	        msgTarget: 'qtip',
			valueField: 'code',
			displayField: 'code',
			queryParam:'serviceRequestNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        	
    },{
        xtype: 'customcombobox',
        fieldLabel: getServiceRequestTranslation('REQUESTERS_TYPE'),
        store: 'servicerequest.common.RequesterTypes',
        editable: false,
        queryMode: 'local',
        name: 'selectedNameField',
        itemId: 'selectedNameField',
        valueField: 'id',
        displayField: 'value',
        value: 'STUDENT'	
   },{
		xtype: 'customcombobox',
		name: 'STUDENT_ID',
		fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
		store: 'feeandpayment.managebill.Student',
		itemId: 'student_id',
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'studentNameOrCode',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		minChars:3,
		typeAhead:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
		hideTrigger:false,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{studentCode} / {studentName}' +
				'</div>';
			}
		}
   
   },{
  	 xtype: 'customcombobox',
     fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
     name: 'FACULTY_CODE',
     itemId:'facultyCodeItemId',
     store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
     hidden:true,
     valueField: 'id',
		 displayField: 'valueCode',
		 queryParam:'codeOrName',
		 minChars:3,
		 typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	triggerAction: '',
		 //hideTrigger:true,
	 forceSelection:true,
	 //allowBlank:false,
	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 listConfig: {
		 listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		loadingText: getCommonTranslation('SEARCHING'),
		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		getInnerTpl: function() {
			return '<div class="search-item">' +
			'{value}' +
			'</div>';
		}
	}
}]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [ {
            xtype: 'customcombobox',
            name: 'REQUESTER_TYPE',
            fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
            itemId: 'requester_type',
            editable: false,
            store: 'servicerequest.common.RequesterBy',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            msgTarget: 'qtip'
        },{
            xtype: 'customcombobox',
            name: 'STATUS',
            fieldLabel: getServiceRequestTranslation('SERVICE_REQUEST_STATUS'),
            itemId: 'status',
            editable: false,            
            store: 'servicerequest.common.ServiceRequestStatus',
            displayField: 'value',
            valueField: 'id',
            msgTarget: 'qtip'
        }]
    },
    {
        xtype: 'requestsubrequesttypefieldcontainer',
        itemId: 'requestTypeFieldContainer',
        layout:'hbox'
    },
    {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [
    {
            xtype: 'datefield',
            name: 'FROM_DATE',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            format : CONSTANTS.DATE_FORMAT,
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
	        endDateField : 'till_date',
	        vtype : 'daterange'
        }, {
            xtype: 'datefield',
            name: 'TILL_DATE',
            fieldLabel: getServiceRequestTranslation('TILL_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            format : CONSTANTS.DATE_FORMAT,
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
	        startDateField : 'from_date',
	        vtype : 'daterange'
        }]
    }
    ,{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'findButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});