/**
 * @author Sandeep.Ladvikar
 * This file is use to store the map of the request xtypes and id of the request type in data base.
 */

Ext.define('Academia.view.servicerequest.ServiceRequestViewMap',{
	singleton:true,
	config: {
		requestViewMap : null,
		requestTypeUrlMap:null,
		studentOtherRequestMap:null,
		requestTypeSaveUrlMap:null,
		otherRequestTypeUrlMap:null
	},
	constructor: function(config) {
		this.initConfig(config);
		requestViewMap = new Ext.util.HashMap();
		requestViewMap.add(2,'courserequestdetailspanel'); 
		requestViewMap.add(4,'requestdetailspanel'); 
		requestViewMap.add(15,'leaverequestdetailspanel');
		requestViewMap.add(1,'programrequestdetailspanel');
		requestViewMap.add(6,'withdrawfromprogramdetailspanel');
		requestViewMap.add(5,'withdrawfromcoursedetailspanel');
		requestViewMap.add(14,'withdrawformservicedetailspanel');
		requestViewMap.add(16,'changeofexamdateform');
		requestViewMap.add(17,'changeofexamcenterform');
		requestViewMap.add(19,'withdrawalofexam'); 
		requestViewMap.add(18,'revaluationofexampaperform');
		//Commented because not required right now
		//requestViewMap.add(47,'applyforplacementdetailspanel');		
		requestViewMap.add(47,'employeeleaverequestdetailspanel');	
		requestViewMap.add(21,'lackofothercriteriaform');
		requestViewMap.add(23,'examleaverequestform');
		requestViewMap.add(20,'lackofattendanceform');
		requestViewMap.add(22,'requestforreexaminationform');
		requestViewMap.add(3,'sectionrequestdetailspanel');
		
		requestViewMap.add(36,'feerequestdetailspanel');
		requestViewMap.add(37,'feerequestdetailspanel');
		
		requestViewMap.add(49,'studenttransferrequestdetailspanel');
		requestViewMap.add(50,'schoolleavingrequestdetailspanel');
		requestViewMap.add(52,'examconcessionrequestform');
		requestViewMap.add(53,'leaveofabsencerequestform');
		requestViewMap.add(54,'exchangesemesterrequestdetailspanel');
		
		this.requestViewMap = requestViewMap;
		
		requestTypeUrlMap =  new Ext.util.HashMap();
		requestTypeUrlMap.add('CERTIFICATE',SERVERURL.CERTIFICATE_URL);
		requestTypeUrlMap.add('Certificate',SERVERURL.CERTIFICATE_URL);
		requestTypeUrlMap.add('Issue of certificate',SERVERURL.CERTIFICATE_URL);
		requestTypeUrlMap.add('LEAVE',SERVERURL.LEAVE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('Leave',SERVERURL.LEAVE_REQUEST_FIND_BY_ID);
		//@Admin Bhanu PS
		requestTypeUrlMap.add('EMPLOYEELEAVE',SERVERURL.EMPLOYEE_LEAVE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('Employeeleave',SERVERURL.EMPLOYEE_LEAVE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('PERSONAL_DATA_CHANGE', SERVERURL.PERSONAL_DATA_TRACK_REQUEST);
		requestTypeUrlMap.add('Personal Data Change', SERVERURL.PERSONAL_DATA_TRACK_REQUEST);
		requestTypeUrlMap.add('SCHOLARSHIP', SERVERURL.SCHOLARSHIP_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('Scholarship', SERVERURL.SCHOLARSHIP_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('FREE_FORM', SERVERURL.FREE_FORM_TRACK_REQUEST);
		requestTypeUrlMap.add('Free Form', SERVERURL.FREE_FORM_TRACK_REQUEST);
		requestTypeUrlMap.add('GENERAL', SERVERURL.FREE_FORM_TRACK_REQUEST);
		requestTypeUrlMap.add('PROGRAM_TRANSFER', SERVERURL.PROGRAM_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('Program Transfer', SERVERURL.PROGRAM_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('PROGRAM_WITHDRAWAL', SERVERURL.PROGRAM_WITHDRAWAL_TRACK_REQUEST);
		requestTypeUrlMap.add('Withdrawal from program', SERVERURL.PROGRAM_WITHDRAWAL_TRACK_REQUEST);
		requestTypeUrlMap.add('COURSE_TRANSFER', SERVERURL.COURSE_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('Course Transfer', SERVERURL.COURSE_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('COURSE_WITHDRAWAL', SERVERURL.COURSE_WITHDRAWAL_TRACK_REQUEST);
		requestTypeUrlMap.add('Withdrawal from course', SERVERURL.COURSE_WITHDRAWAL_TRACK_REQUEST);
		requestTypeUrlMap.add('SERVICE_SUBSCRIBE_WITHDRAW',SERVERURL.FIND_WITHDRAW_SUBSCRIBE_REQUEST);
		requestTypeUrlMap.add('Subscribe/withdraw service',SERVERURL.FIND_WITHDRAW_SUBSCRIBE_REQUEST);
		requestTypeUrlMap.add('PLACEMENT', SERVERURL.PLACEMENT_TRACK_REQUEST);
		requestTypeUrlMap.add('Placement', SERVERURL.PLACEMENT_TRACK_REQUEST);
		requestTypeUrlMap.add('SECTION_TRANSFER', SERVERURL.SECTION_TRANSFER_FIND_BY_ID);
		requestTypeUrlMap.add('Section Transfer', SERVERURL.SECTION_TRANSFER_FIND_BY_ID);
		requestTypeUrlMap.add('Service Subscribe Withdraw',SERVERURL.FIND_WITHDRAW_SUBSCRIBE_REQUEST);
		
		requestTypeUrlMap.add('TERMINATION',SERVERURL.STUDENT_TERMINATION_TRACK_REQUEST);
		requestTypeUrlMap.add('Termination',SERVERURL.STUDENT_TERMINATION_TRACK_REQUEST);
		requestTypeUrlMap.add('TRANSFER',SERVERURL.STUDENT_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('Transfer from academy',SERVERURL.STUDENT_TRANSFER_TRACK_REQUEST);
		requestTypeUrlMap.add('DEBARMENT',SERVERURL.STUDENT_DEBARMENT_TRACK_REQUEST);
		requestTypeUrlMap.add('Debarment',SERVERURL.STUDENT_DEBARMENT_TRACK_REQUEST);
		
		requestTypeUrlMap.add('FEE_RELATED',SERVERURL.FEE_REQUEST_URL);
		requestTypeUrlMap.add('Fee Related',SERVERURL.FEE_REQUEST_URL);
		
		requestTypeUrlMap.add('LACK_OF_OTHER_CRITERIA',SERVERURL.LACK_OF_OTHER_CRITERIA_TRACK_REQUEST);
		requestTypeUrlMap.add('EXAM_LEAVE',SERVERURL.EXAM_LEAVE_TRACK_REQUEST);
		requestTypeUrlMap.add('EXAM_WITHDRAWAL',SERVERURL.EXAM_WITHDRAWAL_TRACK_REQUEST);
		requestTypeUrlMap.add('CHANGE_EXAM_CENTRE',SERVERURL.CHANGE_EXAM_CENTRE_TRACK_REQUEST);
		requestTypeUrlMap.add('CHANGE_EXAM_DATE',SERVERURL.CHANGE_EXAM_DATE_TRACK_REQUEST);
		requestTypeUrlMap.add('LACK_OF_ATTENDANCE',SERVERURL.LACK_OF_ATTENDANCE_TRACK_REQUEST);
		requestTypeUrlMap.add('RE_EXAM',SERVERURL.RE_EXAM_TRACK_REQUEST);
		requestTypeUrlMap.add('REVALUATION_EXAM_PAPER',SERVERURL.REVALUATION_OF_EXAM_TRACK_REQUEST);
		requestTypeUrlMap.add('STUDENT_TRANSFER',SERVERURL.TRAKE_STUDENT_TRANSFER_REQUEST);
		requestTypeUrlMap.add('SCHOOL_LEAVING',SERVERURL.TRAKE_SCHOOL_LEAVING_REQUEST);
		requestTypeUrlMap.add('HOSTEL_LEAVE', SERVERURL.PATH_FIND_HOSTEL_SERVICE_REQUEST);
		requestTypeUrlMap.add('EXAM_CONCESSION',SERVERURL.EXAM_CONCESSION_SERVICE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('LEAVE_OF_ABSENCE',SERVERURL.LEAVE_OF_ABSENCE_SERVICE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('EXCHANGE_SEMESTER',SERVERURL.EXCHANGE_SEMESTER_SERVICE_REQUEST_FIND_BY_ID);
		requestTypeUrlMap.add('READMISSION',SERVERURL.READMISSION_TRACK_REQUEST);
		
		this.requestTypeUrlMap = requestTypeUrlMap;
		
		studentOtherRequestMap = new Ext.util.HashMap();
		
		studentOtherRequestMap.add('TERMINATION_REQUEST',25);
		studentOtherRequestMap.add('TRANSFER_REQUEST',26);
		studentOtherRequestMap.add('DEBRAMENT_REQUEST',45);
		this.studentOtherRequestMap = studentOtherRequestMap;
		
		requestTypeSaveUrlMap = new Ext.util.HashMap();
		
		requestTypeSaveUrlMap.add('CERTIFICATE',SERVERURL.SAVE_CERTIFICATE_REQUEST);		
		
		requestTypeSaveUrlMap.add('FREE_FORM',SERVERURL.SAVE_FREE_FORM_REQUEST);
		requestTypeSaveUrlMap.add('GENERAL',SERVERURL.SAVE_FREE_FORM_REQUEST);	
		
		requestTypeSaveUrlMap.add('TERMINATION_REQUEST',SERVERURL.SAVE_TERMINATION_REQUEST);
		
		requestTypeSaveUrlMap.add('TRANSFER_REQUEST',SERVERURL.SAVE_TRANSFER_REQUEST);
		
		requestTypeSaveUrlMap.add('DEBRAMENT_REQUEST',SERVERURL.SAVE_DEBARMENT_REQUEST);
		
		requestTypeSaveUrlMap.add('PERSONAL_DATA_CHANGE', SERVERURL.SAVE_PERSONAL_DATA_CHANGE_REQUEST);
		requestTypeSaveUrlMap.add('OTHER', SERVERURL.PATH_SAVE_HOSTEL_LEAVE_REQUEST);
		requestTypeSaveUrlMap.add('EXAM_CONCESSION', SERVERURL.SAVE_EXAM_CONCESSION_SERVICE_REQUEST);
		this.requestTypeSaveUrlMap = requestTypeSaveUrlMap;
		
		
		otherRequestTypeUrlMap = new Ext.util.HashMap();
		otherRequestTypeUrlMap.add(4,SERVERURL.SAVE_SCHOLARSHIP_REQUEST);
		
		otherRequestTypeUrlMap.add(1,SERVERURL.SAVE_PROGRAM_TRANSFER_REQUEST);
		
		otherRequestTypeUrlMap.add(15,SERVERURL.SAVE_LEAVE_REQUEST);
		
		otherRequestTypeUrlMap.add(2,SERVERURL.SAVE_COURSE_TRANSFER_REQUEST);
		
		otherRequestTypeUrlMap.add(6,SERVERURL.SAVE_WITHDRAW_PROGRAM_REQUEST);
		
		otherRequestTypeUrlMap.add(5,SERVERURL.WITHDRAW_COURSE_SERVICE_REQUEST);
		
		otherRequestTypeUrlMap.add(14,SERVERURL.SAVE_WITHDRAW_SUBSCRIBE_REQUEST);
		
		otherRequestTypeUrlMap.add(47,SERVERURL.SAVE_APPLY_FOR_PLACEMENT_REQUEST);
	
		otherRequestTypeUrlMap.add(16,SERVERURL.SAVE_CHANGE_OF_EXAM_DATE_REQUEST);
		otherRequestTypeUrlMap.add(17,SERVERURL.SAVE_CHANGE_OF_EXAM_CENTER_REQUEST);
		otherRequestTypeUrlMap.add(18,SERVERURL.SAVE_REVALUATION_OF_EXAM_REQUEST);
		otherRequestTypeUrlMap.add(19,SERVERURL.SAVE_WITHDRAW_FROM_EXAM_REQUEST);
		otherRequestTypeUrlMap.add(20,SERVERURL.SAVE_LACK_OF_ATTENDANCE_REQUEST);
		otherRequestTypeUrlMap.add(21,SERVERURL.SAVE_LACK_OF_OTHER_CRITERIA_REQUEST);
		otherRequestTypeUrlMap.add(22,SERVERURL.SAVE_REEXAMINATION_REQUEST);
		otherRequestTypeUrlMap.add(23,SERVERURL.SAVE_EXAM_LEAVE_REQUEST);
		otherRequestTypeUrlMap.add(3,SERVERURL.SAVE_SECTION_TRANSFER_REQUEST);
		otherRequestTypeUrlMap.add(47,SERVERURL.SAVE_EMPLOYEE_LEAVE_REQUEST);
		otherRequestTypeUrlMap.add(49,SERVERURL.SAVE_STUDENT_TRANSFER_REQUEST);
		otherRequestTypeUrlMap.add(50,SERVERURL.SAVE_SCHOOL_LEAVING_REQUEST);
		otherRequestTypeUrlMap.add(52,SERVERURL.SAVE_EXAM_CONCESSION_SERVICE_REQUEST);
		otherRequestTypeUrlMap.add(53,SERVERURL.SAVE_LEAVE_OF_ABSENCE_REQUEST);
		otherRequestTypeUrlMap.add(54,SERVERURL.SAVE_EXCHANGE_SEMESTER_SERVICE_REQUEST);
		this.otherRequestTypeUrlMap = otherRequestTypeUrlMap;
		
	},
	
	getRequestView:function(key){
		return(this.requestViewMap.get(key));
	},
	
	getRequestTypeUrl:function(key) {
		return(this.requestTypeUrlMap.get(key));
	},
	
	getStudentRequetsId:function(key){
		return(this.studentOtherRequestMap.get(key));
	},
	
	getSaveUrlForRequestType:function(requestType) {
		return(this.requestTypeSaveUrlMap.get(requestType));
	},
	
	getSaveUrlForOtherRequestType:function(requestType) {
		return(this.otherRequestTypeUrlMap.get(requestType));
	}
});
