Ext.define('Academia.view.servicerequest.servicerequestsettings.AssigneeApproverEditableGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.assigneeapprovereditablegrid',
	border:true,
	cls:'clsAssigneeApproverGrid',
	store:'servicerequest.servicerequestsettings.AssigneeApproverGridStore',
	requires: [
	            'Ext.selection.CellModel',
	            'Ext.grid.*'
	        ],
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		deferEmptyText: false
	},
	plugins: [
		Ext.create('Ext.grid.plugin.CellEditing', {
			clicksToEdit: 1
		})
	],
	selModel: Ext.create('selection.cellmodel', {
		onEditorTab: function(ep, e) {
			return false;
		}
	}),
	columns:[{
		dataIndex:'id',
		hidden:true,
		sortable:false,
		menuDisabled: true
	},{
		header: getCommonTranslation('PROGRAM_GROUP_NAME'),
		dataIndex:'value',
		renderer:function(value){
			return value;
		},
		flex:0.2,
		sortable:false,
		menuDisabled: true
	},{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'assigneeId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultAssignee',
            itemId: 'defaultAssignee',
            //store: 'eventmeetingminutes.EventMeetingMinutesParticipantStore',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            //allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
            listeners:{
            	render:function(combo) {
            		//combo.reset();
            		baseController = Academia.app.getController('Academia.controller.base.BaseController');
            		var academyLocationId = baseController.getCurrentAcademyLocation();
            		var store = combo.getStore();
            		store.on('beforeload', function(){
				    	store.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
            		});
            	},
            	/*blur:function(combo,e,eOpts){
            		combo.lastQuery=null;
            		var store = combo.getStore();
            		delete store.getProxy().extraParams.name;
            		store.load();
            	}*/
            }
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						//rec.column.getEditor().store.load();
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}	/*
					else{
						if(isArray(value) && value.length>0) {
							return value[0].data.valueCode;
						}
						else{
							rec.tdCls = 'gridInputCustomStyle';
			                return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}*/
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('assigneeId')) && isNullOrEmpty(record.get('assigneeId'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else{
					var grid = view.up();
					var progGroupList =  grid.config.programGroupList;
					if(!isNullOrEmpty(progGroupList) && progGroupList.length>0){
						var recId = record.get('id');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();
						editor.store.load({
							callback:function(){
								//progGroupList.forEach(function(obj){
									for(var i=0;i<progGroupList.length;i++){
										
									if(progGroupList[i] && progGroupList[i].programGroupDetails && progGroupList[i].programGroupDetails.programGroup && progGroupList[i].programGroupDetails.programGroup.id) {
									var pgId = progGroupList[i].programGroupDetails.programGroup.id;
									var programId = progGroupList[i].id;
									if(pgId == recId){
										if(!isNullOrEmpty(progGroupList[i].defaultAssignee)){
											models[rowIndex].set("assigneeId", progGroupList[i].defaultAssignee.id);
											models[rowIndex].set("programDetailsId", programId);
											editor.setValue(progGroupList[i].defaultAssignee.id);
											break;
										}else{
											rec.tdCls = 'gridInputCustomStyle';
							                 models[rowIndex].set("assigneeId", getExaminationTranslation('CLICK_TO_ENTER'));
							                // return false;
										}	
										}
									}else{
										rec.tdCls = 'gridInputCustomStyle';
										 models[rowIndex].set("assigneeId", getExaminationTranslation('CLICK_TO_ENTER'));
										//return false;
									}	
									}
								//});
							}
						});
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}	
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'defaultAssigneeAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('assigneeId',null);
        	
        	var grid = view.up();
			var progGroupList =  grid.config.programGroupList;
			if(!isNullOrEmpty(progGroupList) && progGroupList.length>0){
				var recId = record.get('id');
				var models = grid.getStore().getRange();
						progGroupList.forEach(function(obj){
							var pgId = obj.programGroupDetails.programGroup.id;
							var programId = obj.id;
							if(pgId == recId){
								//if(isNullOrEmpty(obj.defaultAssignee)){
									//models[rowIndex].set("assigneeId", obj.defaultAssignee.id);
									models[rowIndex].set("programDetailsId", programId);
								//}
							}
						});
			}
        	return getServiceRequestTranslation('STUDENTS_ASSIGNEE');
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    },{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'assigneeIdAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('assigneeId',null);
        	return 'Auto';
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultApprover',
            itemId: 'defaultApprover',
            store: Ext.create('Academia.store.servicerequest.servicerequestsettings.QuickSearchNameApprover'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            //allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
            listeners:{
            	render:function(combo) {
            		//combo.reset();
            		baseController = Academia.app.getController('Academia.controller.base.BaseController');
            		var academyLocationId = baseController.getCurrentAcademyLocation();
            		var store = combo.getStore();
            		store.on('beforeload', function(){
				    	store.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
            		});
            	}
            }
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}	
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('approverId')) && isNullOrEmpty(record.get('approverId'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else{
					var grid = view.up();
					var progGroupList =  grid.config.programGroupList;
					if(!isNullOrEmpty(progGroupList) && progGroupList.length>0){
						var recId = record.get('id');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();
						editor.store.load({
							callback:function(){
								//progGroupList.forEach(function(obj){
								for(var i=0;i<progGroupList.length;i++){
									if(!isNullOrEmpty(progGroupList[i].programGroupDetails)){
										var pgId = progGroupList[i].programGroupDetails.programGroup.id;
										if(pgId == recId){
											if(!isNullOrEmpty(progGroupList[i].defaultApprover)){
												models[rowIndex].set("approverId", progGroupList[i].defaultApprover.id);
												editor.setValue(progGroupList[i].defaultApprover.id);
												break;
											}else{
												rec.tdCls = 'gridInputCustomStyle';
								                 models[rowIndex].set("approverId", getExaminationTranslation('CLICK_TO_ENTER'));
											}	
										}else{
											rec.tdCls = 'gridInputCustomStyle';
											 models[rowIndex].set("approverId", getExaminationTranslation('CLICK_TO_ENTER'));
										}
									}
								}	
								//});
							}
						});
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverIdAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('approverId',null);
        	return 'Auto';
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    }],
    listeners: {
        cellclick: function(gridView,htmlElement,columnIndex,dataRecord){
        	var column = gridView.getGridColumns()[columnIndex];
            if(column.dataIndex == "approverIdAuto" || column.dataIndex == "defaultAssigneeAuto"){
            	return false;
            }
        }
    }
});