/**
 * @author Deepak S
 */
Ext.define('Academia.view.setup.campaignmaster.MapSchoolPriorityForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.mapschoolpriorityform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	layout: {
        type: 'vbox'
    },
    margin:'10px 10px 10px 10px',
	items: [{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'brandCampus',
			itemId: 'brandCampusId',
			fieldLabel: getCommonTranslation("BRAND_CAMPUS"),
			valueField: 'id',
			displayField: 'value',
			store: 'user.UserAcademyLocationStore',
			minChars:3,
			queryParam:'qry',
			width : 462,
			typeAhead:false,
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			//enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			name: 'intakeYear',
			itemId: 'intakeYearId',
			fieldLabel: getCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField: 'id',
			displayField: 'value',
			emptyText: getCommonTranslation('SELECT'),
			editable: false,
			forceSelection: true,
			allowBlank: false
		}]
	}/*,{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}]	
	}*/]});
