/**
 * @author Pritam.Patil
 * This component is used  to show transaction details View Grid
 */
Ext.define('Academia.view.setup.dashboard.TransactionDetailsGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.transactiondetailsgrid',
    title : getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
    	header: getCommonTranslation('ID'),
        dataIndex: 'id',
        hidden: true
    },{
    	header: getCommonTranslation('REVISION_ID'),
        dataIndex: 'revisionId',
        hidden: true
    },{
        header: getCommonTranslation('NATURE_OF_CHANGE'),
        dataIndex: 'operationModeId',
        align: 'center',
        sortable: true,
        renderer  : function(value) {
        		if(value === 0){
        			return getCommonTranslation('ADD');
        		}else if(value === 1){
        			return getCommonTranslation('EDIT');
        		}else if(value === 2){
        			return getCommonTranslation('DELETE');
        		}
        },
        flex: .1

    }, {
        header: getCommonTranslation('IP_ADDRESS'),
        dataIndex: 'ipAddress',
        align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('TABLE_CHANGED'),
        dataIndex: 'classNames',
        align: 'center',
        sortable: true,
        flex: .4
    },  {
        header: getCommonTranslation('DATA_CHANGED'),
        dataIndex: 'dataChanges',
        align: 'center',
        sortable: true,
        renderer  : function(Value) {
            return '<a href="#">'+ getCommonTranslation('VIEW_CHANGE')+'</a>';
        },
        flex: .2

    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.setup.dashboard.TransactionDetailsGridStore');
    }
});