/**
 *  @author Shashank Jain
 */

Ext.define('Academia.view.setup.quickLink.QuickLinkGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.quicklinkgrid',
	store : 'setup.quickLink.QuickLinkGridStore',
	title: getCommonTranslation('QUICK_LINK'),
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header : getCommonTranslation("PORTAL"),
		dataIndex : 'portal',
		flex:1,
		sortable:true,
		renderer: function(value) {
			return value.portalName;
		}
	},{
		header : getCommonTranslation('LINK_NAME'),
		dataIndex : 'linkName',
		flex:1,
		sortable:true,
	},{
		header : getCommonTranslation('LINK_URL'),
		dataIndex : 'linkUrl',
		flex:1,
		sortable:true,
	},{
		header : getCommonTranslation('LOGO'),
		dataIndex : 'docId',
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.docId.id != "") {					
					return '<a href="#">' + "View" + '</a>';
				} 
			}                        
		},
		flex:1
	},{
		header : getCommonTranslation('SEQUENCE_NO'),
		dataIndex : 'sequenceNo',
		flex:1,
		sortable:true,
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'whetherActive',
		flex:1,
		sortable:true,
	}]
});