/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.setup.translationmapping.TranslationMappingGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.translationmappinggrid',
	store: 'setup.translationmapping.TranslationMappingStore',
	title: getCommonTranslation('REPORT_TRANSLATION_MAPPING'),
	collapsible: false,
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		checkOnly : true,
		allowDeselect: false
	},
	columns: [{
		header: getCommonTranslation('DEFAULT_LABEL'),	
		dataIndex: 'defaultValue',
		sortable: true,
		flex: .5,
		maxLength:255
	}, {
		header: getCommonTranslation('CUSTOM_LABEL'),
		dataIndex: 'customValue',
		sortable: true,
		flex: .5,
		editor: {
			xtype: 'textfield',
			name:'customValueField',
			itemId:'customValueFieldItemId',
			maxLength:2000
		},
		renderer:function(val,rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				return val;
			}
		}
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnSaveGrid',
		tooltip: getCommonTranslation('SAVE'),
		text : getCommonTranslation('SAVE')
	}, {
		xtype: 'button',
		itemId: 'btnResetGrid',
		tooltip: getCommonTranslation('RESET'),
		text : getCommonTranslation('RESET')
	},{
    	xtype:'textfield',
    	emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	width: 300,
    	name:'translationLocalSearchText',
    	itemId:'translationLocalSearchText',
    	enableKeyEvents: true
    }],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});