/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.sgappointment.sgappointment.SGApplicantAppointmentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgapplicantappointmentgrid',
	store: 'sgappointment.sgappointment.SGApplicantAppointmentGridStore',
	title: getServiceRequestTranslation('SG_MANAGE_APPOINTMENTS'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.sgappointment.sgappointment.SGApplicantAppointmentGridStore');
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [/*{
		header:  getCommonTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
		},*/{
			header:  getServiceRequestTranslation('BOOKING_ID'),
			dataIndex: 'bookingId',
			flex:.1,
			sortable:true
		},{
			header:  getServiceRequestTranslation('APPOINTEE_NAME'),
			dataIndex: 'appointeeName',
			flex:.1,
			sortable:true,
		},{
			header:  getServiceRequestTranslation('APPOINTEE_CONTACT_NO'),
			dataIndex: 'appointeeContactNo',
			flex:.1,
			sortable:true,
		},{
			header:  getServiceRequestTranslation('BOOKING_DATE'),
			dataIndex: 'bookingDate',
			flex:.1,
			sortable:true,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header:  getServiceRequestTranslation('APPOINTMENT_DATE'),
			dataIndex: 'appointmentDate',
			flex:.1,
			sortable:true,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header:  getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academyLocation',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}
			}  
		},{
			header:  getCommonTranslation('PROGRAM'),
			dataIndex: 'program',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}
			}  
		},{
			header:  getCommonTranslation('BATCH'),
			dataIndex: 'batch',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}
			}  
		},{
			header:  getCommonTranslation('SEAT_TYPE'),
			dataIndex: 'progBatchSeatConfig',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}
			}   
		},{
			header:  getServiceRequestTranslation('PERSON_TO_MEET'),
			dataIndex: 'personToMeet',
			flex:.1,
			sortable:true,
		},{
			header:  getServiceRequestTranslation('VISIT_TIME'),
			dataIndex: 'visitTime',
			flex:.1,
			sortable:true,
			renderer:function(value, record){
				return timeRender(value);
			}
		}, {
			header:  getServiceRequestTranslation('OUT_TIME'),
			dataIndex: 'expectedOutTime',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value, record){
				return timeRender(value);
			}
		},/*{
		header:  getServiceRequestTranslation('REASON_TO_MEET'),
		dataIndex: 'reasonToVisit',
		flex:.1,
		sortable:true,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+getPlacementTranslation('VIEW')+"</a>";
			}else{
				return "-";
			}

		}   

	}*/{
			header:  getServiceRequestTranslation('REASON_TO_MEET'),
			dataIndex: 'sgReasonForVisit',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}			
			}
		},{
			header:  getServiceRequestTranslation('SG_VISIT_STATUS'),
			dataIndex: 'sgVisitStatus',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					return value.value;
				}else{
					return "-";
				}
			}
		},{
			header: getServiceRequestTranslation('ENTRY_BY'),
			dataIndex: 'entryByName',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.get('submitPortalId'))){
					if(record.get('submitPortalId')==6){
						return record.get('appointeeName');}
					else if(!isNullOrEmpty(value)){
						return value;
					}
				}else{
					return "-";
				}
			}  
		},{
			header:  getCommonTranslation('APPOINTMENT_COMPLETION_DATE_TIME'),
			dataIndex: 'appointmentCompletionDateTime',
			flex:.2,
			sortable:true,
			hidden:true,
			renderer:function(date) {
				return '<div>'+dateRender(date)+'</div>'+" "+'<div>'+timeRender(date)+'</div>';
			}
		}]
});

