/**
 * screen which contains the search fields of the sponsorship master
 * @author akshay.kalbhor
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.sponsorshipmastersearchform',
    autoScroll: true,
    frame: false,
    //layout: 'vbox',
   // cls: 'customSearchPanel',
    margin:0,
    items: [{
        xtype: 'form',
        itemId: 'sponsorshipMaster',
        cls: 'customSearchPanel',
        width: '100%',
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{

            	xtype: 'customcombobox',
            	name: 'SPONSOR_ID',
            	itemId: 'sponMaster_sponId',
            	fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'),
            	store:'sponsorship.SponsorsNameCodeStore',
            	valueField: 'id',
            	displayField: 'value',
            	queryParam:'sponsorNameOrCode',
            	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	enableKeyEvents  : 'true',
            	minChars:3,
            	typeAhead:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	triggerAction: '',
            	hideTrigger:false,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{sponsorshipCode} / {sponsorshipName}' +
            			'</div>';
            		}
            	}
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SPONSOR_TYPE'),
                name: 'SPONSOR_TYPE',
                itemId: 'scholMaster_scholType',
                editable: false,
                //store: 'sponsorship.SponsorTypes',
                store: 'sponsorship.SponsorTypesStore',
                displayField: 'value',
                valueField: 'id',
                selectOnFocus: true,
                queryMode: 'local',
                value: 'All',
                forceSelection: false
            },{
            	xtype: 'customcombobox',
            	name: 'academyLocations',
            	itemId: 'sponsorAcademyLocations',
            	fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            	store:'common.AcademyLocationNameSeparated',
            	valueField: 'id',
            	displayField: 'value',
            	width: 300,
                queryParam:'qry',
            	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	enableKeyEvents  : 'true',
            	minChars:3,
            	typeAhead:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	triggerAction: '',
            	hideTrigger:false,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
	                    return '<div class="search-item">' +
                        '{code} / {value}'+ 
                    '</div>';
                }
            	}
        	
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [/*{
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('PROGRAM'),
                itemId: 'sponMaster_program',
                name: 'PROGRAM_NAME'
            },*/ {
                xtype: 'numberfield',
                fieldLabel: getCommonTranslation('AMT_RANGE_FROM'),
                itemId: 'sponMaster_amountRangeFrom',
                name: 'AMOUNT_RANGE_FROM',
                vtype: 'numberrange',
                totalNumberField: 'sponMaster_amountRangeTo',
                minValue: 0,
                spinDownEnabled: false,
                spinUpEnabled: false,
                allowExponential: false,
                hideTrigger: true,
                allowBlank: false,
                listeners:{
					afterrender: function(field){
						var label = getCommonTranslation('AMT_RANGE_FROM');
						if(field && field.labelEl){
							if(!field.labelEl.dom.textContent.includes('*')){
								field.labelEl.dom.innerHTML=label+':<span class="required" style="color:red">*</span>';
							}
						}
					}
				}
            }, {
                xtype: 'numberfield',
                fieldLabel: getCommonTranslation('AMT_RANGE_TO'),
                itemId: 'sponMaster_amountRangeTo',
                name: 'AMOUNT_RANGE_TO',
                vtype: 'numberrange',
                variableNumberField: 'sponMaster_amountRangeFrom',
                minValue: 0,
                spinDownEnabled: false,
                spinUpEnabled: false,
                allowExponential: false,
                hideTrigger: true,
                allowBlank: false,
                listeners:{
					afterrender: function(field){
						var label = getCommonTranslation('AMT_RANGE_TO');
						if(field && field.labelEl){
							if(!field.labelEl.dom.textContent.includes('*')){
								field.labelEl.dom.innerHTML=label+':<span class="required" style="color:red">*</span>';
							}
						}
					}
				}
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',

            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'SponsorshipMasterSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'SponsorshipMasterResetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function(button, eOpts) {
                        this.up('form').getForm().reset();
                    }
                }
            }]
        }]
    }]
});