/**
 * @author Amit G
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterSearchResultGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sponsorshipmastersearchresultgrid',
	store: 'sponsorship.SponsorshipMasterSearchResultGridStore',
	title: getCommonTranslation('LIST_OF_SPONSORS'),
	border: true,
	refreshStoreData:true,
	margin:0,
	frame:false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sponsorshipmasterscreen': 1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sponsorship.SponsorshipMasterSearchResultGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		//itemId: 'searchResultGridBtnAdd',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		//itemId: 'searchResultGridBtnEdit',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		//itemId: 'searchResultGridBtnView',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		//itemId: 'searchResultGridBtnDelete',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'splitbutton',
		itemId: 'spBtnMoreActions',
		text: getCommonTranslation('MOREACTIONS'),
		menu: [{
			text:getCommonTranslation('MAP_ACADEMY_LOCATIONS'),
			itemId:'mapSponsorAcademyLocationsLink'
		},{
			text:getCommonTranslation('MANAGE_QUOTATION'),
			itemId:'manageQuatationLink',
			disabled:true
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getCommonTranslation('SPONSOR_Id'),
		dataIndex: 'sponsorCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SPONSOR_NAME'),
		dataIndex: 'sponsorName',
		flex:1,
		sortable:true
	}, {
		header:  getFeeAndPaymentCommonTranslation('SPONSOR_NAME_IN_OTHER_LANGUAGE'), 
		dataIndex: 'sponsorNameInOtherLanguage',
		flex:1,
		hidden:true,
		sortable:true,
	}, {
		header:  getCommonTranslation('SPONSOR_TYPE'),
		dataIndex: 'sponsorType',
		flex:1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				if(value == 'INT')
				{
					return 'Internal';
				}else{
					return 'External';	
				}
			}else{ 
				return null;
			}
		}
	},{
		header:  getCommonTranslation('SPONSOR_STATUS'),
		dataIndex: 'sponsorStatus',
		flex:1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				if(value == true)
				{
					return 'Active';
				}else{
					return 'Inactive';	
				}
			}else{ 
				return null;
			}
		}
	}/*,{
		header:  getCommonTranslation('AMT_SPONSORED_TILL_DATE'),
		dataIndex: 'amountSponsored',
		flex:1,
	}*/,{
		header:  getCommonTranslation('NO_OF_SPONSOR_STUDENTS'),
		flex:1,
		dataIndex: 'noOfStudentSponsored',
		renderer:function(value,meta,record){
			if(record.data.noOfStudentSponsored>0){
				return '<a href=#>'+record.data.noOfStudentSponsored+'</a>';
			} else {
				return '-';
			}
		}
	}]
});