/**
 * @author Amit G
 * 
 * This component is used for to show Number Of Sponsored Students for selected sponsorship in grid 
 */
Ext.define('Academia.view.sponsorship.SponsorshipReceiptGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sponsorshipreceiptgrid',	
	title :getCommonTranslation('SPONSOR_SHIP_RECEIPT_GRID'),
	store:'sponsorship.SponsoredReceiptStudentSearchStore',
	border: true,	
	margin:0,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS		
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sponsorship.SponsoredReceiptStudentSearchStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [ {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns :[{
		header:  getCommonTranslation('SPONSOR_Id'),
		dataIndex: 'sponsorCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SPONSOR_NAME'),
		dataIndex: 'sponsorName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentPrintName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex: 'firstName',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex: 'middleName',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex: 'lastName',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('NATIONAL_ID'),
		dataIndex: 'nationalId',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('ACADEMY'),
		dataIndex: 'academyLocationPrintName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programPrintName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:1,
		sortable:true
	},{
		header:  getAdmissionTranslation('RECEIPT_NO'),
		dataIndex: 'receiptNo',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				//return '<a href=#>'+value+'</a>'
				return value;
			}                        
		}
	},{
		header:  getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
		dataIndex: 'receiptAmount',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			return currencyRenderer(value,record.get("receiptCurrencyId"));
		}
	},{
		header:  getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
		dataIndex: 'transactionDate',
		flex:1,
		sortable:true,
		renderer : function(value){
			return  dateRender(value);
		}
	},{
		header:  getCommonTranslation('BILL_NO'),
		dataIndex: 'billNo',
		flex:1,
		sortable:true
	},{
		header:  getFeeAndPaymentCommonTranslation('BILL_AMOUNT'),
		dataIndex: 'installmentAmountSponsored',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			return currencyRenderer(value,record.get("billCurrencyId"));
		}
	},{
		header:  getCommonTranslation('SATTLED_AMOUNT'),
		dataIndex: 'settledAmount',
		flex:1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value,meta,record){
			return currencyRenderer(value,record.get("billCurrencyId"));
		}
	},{
		header:  getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex: 'balanceAmount',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			return currencyRenderer(value,record.get("billCurrencyId"));
		}
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'alExchangeRate',
		flex : 1,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'acadLocCurrCovertedbalanceAmount',
		flex : 1,
		hidden:true,
		itemId:'acadLocCurrCovertedbalanceAmount',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("convertedBalAmountCurrencyId"));
			}else{
				return '-';
			}                    
		}
	},{
		header:  getFeeAndPaymentCommonTranslation('ADJUSTMENT_DETAILS'),
		dataIndex: 'settlementDetails',
		flex:1,
		renderer:function(value,meta,record){
			return '<a href=#>View</a>';
			// return value;
		}
	}] 
});