/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show fees and payment related transactions in grid  
 */
Ext.define('Academia.view.sponsorship.SponsorshipReceiptsTransactionFeesAndPaymentDetailsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feesandpaymentdetailsgrid',
	store : 'sponsorship.SponsorshipReceiptFeePlanStore',
	title :getCommonTranslation('FEES_AND_PAYMENT_DETAILS'),//Fees and Payment Details
    border: true,
    autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	columns :[{
		header : getCommonTranslation('FEE_PLAN'),//Fee Plan
		dataIndex : 'feePlanName',
		flex:.2,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header : getCommonTranslation('FEE_PLAN_STAGES'),//Fee Plan Stages
		dataIndex : 'stageName',		
		flex:.2
	},{
		header :getCommonTranslation('FEE_HEAD_TYPE'),//Fee Head Type
		dataIndex : 'feeHeadName',
		flex:.2
	},{
		header :getCommonTranslation('TOTAL_AMOUNT'),//Total Amount
		dataIndex : 'totalAmount',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
			 return Ext.util.Format.currency(value,'',record.get("billCurrencyId"),false);
			}
		}
	},{
		header :getCommonTranslation('AMOUNT_SPONSORED'),//Amount Sponsored
		dataIndex : 'amountSponsored',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
			 return Ext.util.Format.currency(value,'',record.get("billCurrencyId"),false);
			}
		}
	},{
		header :getFeeAndPaymentCommonTranslation('BILL_AMOUNT'),//Amount Sponsored
		dataIndex : 'generatedBillAmount',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
			 return Ext.util.Format.currency(value,'',record.get("billCurrencyId"),false);
			}
		}
	},{
		header :getCommonTranslation('PENDING_AMOUNT'),//Pending Amount
		dataIndex : 'pendingAmount',
		flex:.2,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
			 return Ext.util.Format.currency(value,'',record.get("billCurrencyId"),false);
			}
		}
	}],    	
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'sponsorship.SponsorshipReceiptFeePlanStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }]
});