/**
 * Search fields form present on the add sponsor window
 * @author akshay.kalbhor
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.AddSponsorSearchForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.addsponsorsearchform',
	autoScroll: true,
	frame: true,
	layout: 'vbox',
	plugins : 'formlabelrequired',
	items: [{
		xtype: 'form',
		width: '100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'hidden',
				name: 'id',
				itemId: 'id'
			},{
				xtype: 'hidden',
				name: 'sponsorshipAwardeeId',
				itemId: 'sponsorshipAwardeeId'
			
			},{
				xtype: 'hidden',
				name: 'studentId',
				itemId: 'studentId'
			},{
				xtype: 'hidden',
				name: 'admissionId',
				itemId: 'admissionId'
			},{
				xtype: 'hidden',
				name: 'feeStageHeadConfigurationId',
				itemId: 'feeStageHeadConfigId'
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('SPONSOR_NAME'), 
				name: 'sponsorId',
				itemId: 'sponsorId',
				editable: false,
				store: 'sponsorship.Sponsors',
				displayField: 'value',
				valueField: 'id',
				allowBlank: false,
				listeners: {
					change: function(combo, newValue, oldValue, eOpts) {
						if(combo.findRecordByValue(newValue)) {
							this.up('form').down('textfield#sponsorType').setValue(combo.findRecordByValue(newValue).get('code'));
						}
					}
				}
			}, {
				xtype: 'textfield',
				itemId: 'sponsorType',
				fieldLabel: getCommonTranslation('SPONSOR_TYPE'), 
				name: 'SPONSOR_TYPE',
				
				editable: false,
				readOnly: true
			}, {
				xtype: 'datefield',
				fieldLabel: getCommonTranslation('AWARD_DATE'),
				itemId: 'awardeeDate',
				name: 'awardedDate',
				//format: 'd-m-Y',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAMS'),
				name: 'programId',
				itemId: 'programCombo',
				editable: false,
				store: 'servicerequest.placementrequest.PlacementPrograms',
				displayField: 'programName',
				valueField: 'programId',
				allowBlank: false
			},,{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('FEE_PLAN_TYPE'),
				name: 'feePlanTypeId',
				itemId: 'feePlanTypeId',
				editable: false,
				disabled: true,
				store: 'sponsorship.FeePlanTypeStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank: false
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('FEE_PLAN'),
				name: 'feePlanId',
				itemId: 'feePlan',
				editable: false,
				disabled: true,
				store: 'sponsorship.FeePlanStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank: false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('STAGE_NAMES'),
				name: 'feePlanRuleStageId',
				itemId: 'stageName',
				editable: false,
				disabled: true,
				//store: 'sponsorship.StageNames',
				store:'sponsorship.SponsorStageNameByFeePlanIdStore',
				displayField: 'value',
				valueField: 'id',
				allowBlank: false
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEQUENCE'),
				name: 'feeSequenceId',
				itemId: 'feePlanSequence',
				editable: false,
				disabled: true,
				store: 'sponsorship.FeePlanSequences',
				displayField: 'code',
				valueField: 'id',
				allowBlank: false
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('FEE_HEADS'),
				name: 'feeHeadId',
				itemId: 'feeHeads',
				editable: false,
				disabled: true,
				store: 'sponsorship.FeeHeads',
				displayField: 'feeHeadName',
				valueField: 'id',
				allowBlank: false,
				listeners: {
					change: function(combo, newValue, oldValue, eOpts) {
						if(combo.findRecordByValue(newValue)) {
							this.up('form').down('textfield#totalAmount').setValue(combo.findRecordByValue(newValue).get('feeAmount'));
							this.up('form').down('hidden#feeStageHeadConfigId').setValue(combo.findRecordByValue(newValue).get('feeStageHeadConfigId'));
						}
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getCommonTranslation('TOTAL_AMOUNT'),
				name: 'totalFeeHeadAmount',
				itemId: 'totalAmount',
				editable: false,
				readOnly: true
			}]
		}]
	}]
});