/**
 * @author akshay.kalbhor 
 * This component is used for to show Number Of Sponsored Students for selected sponsorship in grid 
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.ConfigureSponsorFeeHeadGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.configuresponsorfeeheadgrid',
    store: 'sponsorship.ConfiguredSponsorFeeHeads',
    title: getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'),
    disabled : true,
    itemId:'configuresponsorfeeheadgridId',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selType: 'cellmodel',
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
    	beforeedit: function(editor, context) {
    		if(editor.context.field=='sponsorshipPercentage'){
    			if(context.record.data.amountType == 'FIXED_AMOUNT'){
    				context.grid.columns[5].getEditor().setReadOnly(true);
    				return context.colIdx !== 0;
    			}else{
    				context.grid.columns[5].getEditor().setReadOnly(false);
    			}
    		}	
    	}
    },
    border: true,
    autoScroll: true,
    columns: [/*{
      text: getCommonTranslation('FEE_STAGE_HEAD_CONFIG_ID'),
        dataIndex: 'feeStageHeadConfigId',
        hidden: true
     }, {
    	 text: getCommonTranslation('FEE_STAGE_HEAD_CONFIG_ID'),
         dataIndex: 'id',
         hidden: true
     },{
         text: getCommonTranslation('FEE_HEAD_ID'),
        dataIndex: 'feeHeadId',
        hidden: true
    }, {
        text: getCommonTranslation('FEE_PLAN_ID'),
        dataIndex: 'feePlanId',
        hidden: true
    },*/ {
        header: getCommonTranslation('INSTALLMENT'),
        dataIndex: 'sequence',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('AMOUNT'),
        dataIndex: 'amount',
        flex: .2
    }, {
        header: getCommonTranslation('BILL_DATE'),
        dataIndex: 'billingDate',
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('AMOUNT_TYPE'),
        dataIndex: 'amountType',
        itemId: 'amountType',
        name:'amountType',
        flex: .2,
        renderer: function(value) {
            return getCommonTranslation(value);
        },
        editor: {
        	
            xtype: 'customcombobox',
          //  allowBlank: false,
            triggerAction: 'all',
            itemId:'amountTypecombo',
            editable: false,
            selectOnTab: true,
            emptyText: getCommonTranslation('SELECT_AMOUNT_TYPE'),
            /*store: [
                ['FIXED_AMOUNT', getCommonTranslation('FIXED_AMOUNT')],
                ['PERCENTAGE', getCommonTranslation('PERCENTAGE')]
            ],*/           
            store: Ext.create('Ext.data.Store', {
            	fields: ['value', 'name'],
            	data : [
            	        {"value":"FIXED_AMOUNT", "name":getCommonTranslation('FIXED_AMOUNT')},
            	        {"value":"PERCENTAGE", "name": getCommonTranslation('PERCENTAGE')},
            	        ]
            }),
            displayField: 'name',
            valueField: 'value',
           // renderTo: Ext.getBody(),	

            lazyRender: true
        },
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(record.data.disableReason == 'Bills already generated for installment')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLS_ALREADY_GENERATED_FOR_INSTALLMENT')+ '"';
        		
        	}else if (record.data.disableReason == 'Installment is already covered')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_INSTALLMENT_IS_ALREADY_COVERED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing date passed')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_DATE_PASSED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing for the Fee Plan has been done for today')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_FOR_FEEPLAN_DONE_TODAY')+ '"';
        	}
        	valtext = getCommonTranslation(record.data.amountType);
        	return valtext;
        }

    }, {
        header: getCommonTranslation('PERCENT_SPONSORED'),
        dataIndex: 'sponsorshipPercentage',
        itemId: 'sponsorshipPercentage',
        flex: .2,
        editor: {
            xtype: 'numberfield',
            itemId: 'sponsorshipPercentageNumberField',
            minValue: 0,
            maxValue: 100,
            //emptyText: getCommonTranslation('ENTER_PERCENTAGE'),
            allowBlank: false
        },
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(record.data.disableReason == 'Bills already generated for installment')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLS_ALREADY_GENERATED_FOR_INSTALLMENT')+ '"';
        		
        	}else if (record.data.disableReason == 'Installment is already covered')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_INSTALLMENT_IS_ALREADY_COVERED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing date passed')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_DATE_PASSED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing for the Fee Plan has been done for today')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_FOR_FEEPLAN_DONE_TODAY')+ '"';
        	}
        	valtext = record.data.sponsorshipPercentage;
        	return valtext;
        }
    }, {
        header: getCommonTranslation('AMOUNT_SPONSORED'), //Fee Head Type
        dataIndex: 'amountSponsored',
        itemId: 'amountSponsored',
        flex: .2,
        editor: {
            xtype: 'numberfield',
            itemId: 'amountSponsoredEdit',
            emptyText: getCommonTranslation('ENTER_AMOUNT'),
            minValue: 0,
            allowBlank: false
        },
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(record.data.disableReason == 'Bills already generated for installment')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLS_ALREADY_GENERATED_FOR_INSTALLMENT')+ '"';
        		
        	}else if (record.data.disableReason == 'Installment is already covered')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_INSTALLMENT_IS_ALREADY_COVERED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing date passed')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_DATE_PASSED')+ '"';
        		
        	}else if(record.data.disableReason == 'Billing for the Fee Plan has been done for today')
        	{
        		rec.tdAttr = 'data-qtip="' + getCommonTranslation('MESSAGE_BILLING_FOR_FEEPLAN_DONE_TODAY')+ '"';
        	}
        	valtext = record.data.amountSponsored;
        	return valtext;
        }
    }],
    dockedItems: [/*{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'sponsorship.ConfiguredSponsorFeeHeads',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }, */{
    	 xtype: 'toolbar',
    	 itemId: 'buttonToolbar',
         dock: 'top',
    	items: [{
            xtype: 'button',
            itemId: 'btnSave',
            tooltip: getCommonTranslation('SAVE'),
            text: getCommonTranslation('SAVE')
        }]
    }]
   /* tbar: [{
        xtype: 'button',
        itemId: 'btnSave',
        tooltip: getCommonTranslation('SAVE'),
        text: getCommonTranslation('SAVE')
    }]*/
});