/*@author <a href="sooraj.prasad@serosoft.in">Sooraj Prasad</a>*/
Ext.define('Academia.view.student.postGraduateManagement.ProofOfActivityGrid', {
	alias: 'widget.proofofactivitygrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation('PROOF_OF_ACTIVITY'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [{
		header: getCommonTranslation('RESEARCH_ACTIVITY'),
		dataIndex: 'researchActivity',
		itemId: 'researchActivity',
		sortable: true,
		flex: 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.researchActivity.value;
			}                        
		}
	},{
		header: getCommonTranslation('RESEARCH_ACTIVITY_NAME'),
		dataIndex: 'researchActivityName',
		itemId: 'researchActivityName',
		sortable: true,
		flex: 1,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
				return value;
			}	
		}
	},{
		header: getCommonTranslation('RESEARCH_ACTIVITY_DATE'),
		dataIndex: 'researchActivityDate',
		itemId: 'researchActivityDate',
		sortable: true,
		flex:1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditId',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	},{
		header: getCommonTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDate',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	}, {
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'proofOfActivityDocuments',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(value)) {
				if(record.data.proofOfActivityDocuments.length>1) {					
					return '<a href=#>'+record.data.proofOfActivityDocuments.length+'<a>';
				} else if(record.data.proofOfActivityDocuments.length==1) {
					return '<a href=#>'+record.data.proofOfActivityDocuments[0].name+'<a>';
				} 
			}                        
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.postGraduateManagement.ProofOfActivityStore');
	}
});