/**
 *  This form is used for student and faculty disciplinary action
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentOwnProgressReportForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentownprogressreportform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'student_own_progress_report_hidden_field',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('PROGRESS_REPORT_START_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'progressReportStartDate',
            name: 'progressReportStartDate',
            endDateField:'progressReportEndDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('PROGRESS_REPORT_END_DATE'),
            itemId: 'progressReportEndDate',
            name: 'progressReportEndDate',
            startDateField : 'progressReportStartDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('AUDIT_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'auditDate',
            name: 'auditDate',
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
              },
            allowBlank: false,
            vtype : 'daterange',
            readOnly:true
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('AUDIT_ID'),
            itemId: 'auditId',
            name: 'auditId',
            allowBlank: false,
            readOnly:true
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRESS_REPORT_RATING'),
			store: 'common.ReportRatingStore',
			itemId: 'reportRating',
			name: 'reportRating',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentownprogressreportdocumentgrid',
			itemId:'studentownprogressreportdocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width:460,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentOwnProgressReportItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
