/**
 * @author Ashwin Rawal
 */
Ext.define('Academia.view.student.studentFeePayerReport.ValidationStatusFeePayerReport', {
	extend: 'Ext.window.Window',
	alias: 'widget.validationstatusfeepayerreport',
	modal: true,
	autoScroll:true,
	title:getCommonTranslation('VALIDATION_STATUS'),
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		defaults:{
			labelAlign:'top',
			autoScroll:false
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
					xtype: 'customcombobox',
					name: 'validationStatus',
					itemId:'validationStatusId',
					fieldLabel: getCommonTranslation('VALIDATION_STATUS'),
					store: 'student.report.ValidationStatusStore',
					valueField: 'id',
					displayField: 'code',
					typeAhead:true,
					forceSelection:true,
					allowBlank: false,
					width:460,
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
				}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				formBind: true,
				text: getCommonTranslation('SAVE'),
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'CancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]

});
