/**
 * @author Amit G
 */
var studentLeaversReportGridStore = Ext.create('Academia.store.student.report.StudentLeaversReportStore');
Ext.define('Academia.view.student.studentLeaversReport.StudentLeaversReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentleaversreportgrid',
	title: getCommonTranslation('STUDENT_LEAVERS_REPORT'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            //store: store,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
	}],*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);

		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: studentLeaversReportGridStore,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: studentLeaversReportGridStore,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return studentLeaversReportGridStore;
	},
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'fromAlName',
		flex:.1
	},{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1
	},{
		header:  getCommonTranslation('LEAVING_DATE'),
		dataIndex: 'transferDate',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('LEAVING_TO'),
		dataIndex: 'leavingTo',
		flex:.1,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(val == 'PRIVATESCHOOL'){
				val = 'Private School';
			}
			else if(val == 'PUBLICSCHOOL'){
				val = 'Public School';
			}
			else{
				val = 'Unknown';
			}
			return val;
		}
	},{
		header:  getCommonTranslation('SCHOOL_LEAVING_TO'),
		dataIndex: 'schoolLeavingTo',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('REASON_FOR_LEAVING'),
		dataIndex: 'reasonForLeaving',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('BILLING_END_DATE'),
		dataIndex: 'termEndDate',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('REQUEST_DATE'),
		dataIndex: 'requestDate',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('REMARKS'),
		dataIndex: 'remarks',
		flex:.1,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 55px;min-width: 16ch;max-width: 17ch;';
			return val;
		}
	},{
		header:  getCommonTranslation('USER_ID'),
		dataIndex: 'usedIdClosed',
		flex:.1
	},{
		header:  getPersonModuleTranslation('CLOSED_BY'),
		dataIndex: 'closedBy',
		flex:.1
	}]
});
