/**
 *  @author Niklesh Tiwane
 */
Ext.define('Academia.view.student.studentprofile.StudentInternalTransferCreditRequestGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentInternalTransferCreditRequestGrid',
	title: getCommonTranslation('LIST_OF_COURSES'),
	store: Ext.create("Academia.store.student.studentprofile.StudentInternalTransferCreditRequestGridStore"),
	selType:'checkboxmodel',
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1,
    },
	itemId: 'studentInternalTransferCreditRequestGridId',
	autoscroll: true,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	refreshStoreData: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	autoscroll: true,
	tbar: [{
		xtype: 'button',
		itemId: 'btnApprove',
		text: getCommonTranslation('APPROVE'),
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnReject',
		text: getCommonTranslation('REJECT'),
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnResubmit',
		text: getCommonTranslation('RESUBMIT'),
		disabled:true
	},'->'],
	columns: [{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'programPeriodName',
		flex: 1
	},
		{
			header: getCommonTranslation('COURSE_CODE'),
			dataIndex: 'courseCode',
			flex: 2
		},
		{
			header: getCommonTranslation('COURSE_NAME'),
			dataIndex: 'courseName',
			flex: 2, 
			renderer: function(value) { 
				if (value && typeof value === 'string') {
					var parts = value.split(' / ');
					if (parts.length > 1) {
						return parts[1];
					}
				}
				return value;
			}
		}, {
			header: getCommonTranslation('CREDITS'),
			dataIndex: 'courseCredit',
			flex: 0.5
		},
    {
        header: getCommonTranslation('MARKS_OR_GRADE'),
        dataIndex: 'marksGrade',
        flex: 1,

        getEditor: function(record) {
        	var courseGradeType = record.get('courseGradeType')
            var type = record.get('courseMarksGrades');

            if (type === 'G') {
                var gradeStore = Ext.create('Ext.data.Store', {
                    fields: ['gradeType', 'id', 'value', 'doubleValue'],
                    proxy: {
                        type: 'ajax',
                        url: SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_GRADE_DROP_DOWN,
                        extraParams: {
                        	gradeType: courseGradeType
                        },
                        reader: {
                            type: 'json',
                            root: 'data'
                        }
                    },
                    autoLoad: false
                });
                return Ext.create('Ext.grid.CellEditor', {
					field: Ext.create('Ext.form.field.ComboBox', {
						name: 'finalGrade',
						store: gradeStore,
						valueField: 'value',
						displayField: 'value',
						editable: false,
						listeners: {
	                        expand: function() {
	                            if (!isNullOrEmpty(gradeStore)) {
	                                gradeStore.load();
	                            }
	                        },
	                        select: function(combo, records) {
	                            /*var selectedValue = records[0].get('value');
	                            record.set('gradeType', selectedValue);*/
								record.set('gradeType', records[0].get('value'));
								record.set('doubleValue', records[0].get('doubleValue'));
	                        }
	                    }
					})
				});
            }
            if(type === 'M'){
            	{
            		return Ext.create('Ext.grid.CellEditor', {
						field: Ext.create('Ext.form.field.Number', {
							name: 'totalMarks',
							maxLength: 100,
							minValue: 0,
							maxValue: 100,
							decimalPrecision: 4,
							allowDecimals: true,
							mouseWheelEnabled: false
						})
					});
                }
            }

            return null;
        },

        renderer: function (value, meta, rec) {
            if (isNullOrEmpty(value)) {
                meta.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            }
            return value;
        }
    },
    {
        header: getCommonTranslation('EQUIVALENT_COURSE_CODE'),
        dataIndex: 'equivalentCourseCode',
        flex: 1,
        /*editor: {
			xtype: 'textfield',
			name: 'equivalentCourseCode',
			minValue:0,
			//maxValue:99,
			maxLength: 99,
			width: 12,
			enforceMaxLength : true, 
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},*/
    }, {
        header: getCommonTranslation('EQUIVALENT_COURSE_NAME'),
        dataIndex: 'equivalentCourseName',
        flex: 1,
        /*editor: {
			xtype: 'textfield',
			name: 'equivalentCourseName',
			minValue:0,
			//maxValue:99,
			maxLength: 99,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},*/
    },
	
		{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
			flex: 1
		},
		{
			header: getCommonTranslation('BATCH'),
			dataIndex: 'batchName',
			flex: 1
		},
		{
			header: getCommonTranslation('TRANSFER_PERIOD'),
			dataIndex: 'transferProgramPeriodName',
			flex: 1
		},
	 {
        header: getCommonTranslation('INSTITUTE_NAME'),
        dataIndex: 'institueName',
        flex: 1,
        /*editor: {
			xtype: 'textfield',
			name: 'institueName',
			minValue:0,
			//maxValue:99,
			maxLength: 99,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},*/
    }, {
        header: getCommonTranslation('EQUIVALENT_COURSE_CREDIT'),
        dataIndex: 'equivalentCourseCredit',
        flex: 1,
        /*editor: {
			xtype: 'numberfield',
			name: 'equivalentCourseCredit',
			minValue:0,
			//maxValue:99,
			maxLength: 99,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},*/
    }, {
        header: getCommonTranslation('OBTAINED_MARKS_GRADES'),
        dataIndex: 'obtainedMarksGrade',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'obtainedMarksGrade',
			minValue:0,
			//maxValue:99,
			maxLength: 99,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},
    }, 
    {
    	header: getCommonTranslation('STATUS'),
           dataIndex: 'applicantTransferCreditStatus',
           flex: 1,
           renderer: function(value) {
               if (value === 'APPROVE') {
                   return getCommonTranslation('APPROVED');
               } else if (value === 'PENDING') {
                   return getCommonTranslation('PENDING');
               } else if (value === 'REJECT') {
                   return getCommonTranslation('REJECTED');
               } else if (value === 'NEED_TO_RESUBMIT') {
                   return getCommonTranslation('NEED_TO_RESUBMIT');
               } else if (value === 'SUBMIT') {
                   return getCommonTranslation('SUBMIT');
               }else if (value === 'PENDING') {
                   return getCommonTranslation('PENDING');
               } else {
                   return value || '';
               }
           }
       }, 
    {
        header: getCommonTranslation('STUDENT_REMARK'),
        dataIndex: 'studentRemark',
        flex: 1,
       /*  editor: {
			xtype: 'textfield',
			name: 'studentRemark',
			minValue:0,
			maxLength: 255,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			//itemId: 'sequenceNoItemId'
		},   
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if (isNullOrEmpty(value)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return value;
			}
		},*/
    }, 
	{
		       header: getCommonTranslation('FACULTY_REMARK'),
		       dataIndex: 'facultyRemark',
		       flex: 1,
		       editor: {
				xtype: 'textfield',
				name: 'facultyRemark',
				minValue:0,
				maxLength: 255,
				width: 12,
				enforceMaxLength : true,
				keyNavEnabled: true,
				mouseWheelEnabled: false,
				allowDecimals:false,
				//itemId: 'sequenceNoItemId'
			},
			renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
				if (isNullOrEmpty(value)) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				} else {
					return value;
				}
			},
		   },
		{
			header: getCommonTranslation('FACULTY_APPROVER_DATE'),
			dataIndex: 'facultyApproverDate',
			flex: 1,
			renderer: function(date) {
				return dateRender(date);
			}
		}, {
			header: getCommonTranslation('FACULTY_APPROVER_NAME'),
			dataIndex: 'facultyApproverName',
			flex: 0.5
		},
		   
		{
			    xtype: 'gridcolumn',
			    header: getCommonTranslation('COMPLETION_DATE'),
			    dataIndex: 'completionDate',
			    flex: 1,
			    editor: {
			        xtype: 'datefield',
			        format: 'd/m/Y',
			        maxValue: new Date(),
			        listeners: {
			            change: function(field, newValue) {
			                var today = Ext.Date.clearTime(new Date());
			                var selectedDate = Ext.Date.clearTime(newValue);

			                if (selectedDate > today) {
			                    showWarningMessage(getCommonTranslation('ALERT'), 'Date must be today or previous.');
			                    field.setValue(null);
			                    return;
			                }

			                var grid = field.up('grid');
			                var selection = grid.getSelectionModel().getSelection();
			                if (selection.length > 0) {
			                    var record = selection[0];
			                    record.set('completionDate', Ext.Date.format(selectedDate, 'd/m/Y'));
			                }
			            }
			        }
			    },
			renderer: function(date) {
				return dateRender(date);
			}
			},
	{
        header: getCommonTranslation('EQUIVALENT_COURSE_SYLLABUS'),
        dataIndex: 'document',
        flex: 1,
        renderer: function(val, meta, rec) { 
            var docPath = rec.get('documentId');
            var isDocExist = rec.get('id')
			var isDocumentUploaded = rec.get('isDocumentUploaded')
            
            var uploadIcon = '<span class="upload-icon-v2" style="margin-right:5px;">' +
                             '<input type="file" style="opacity:0;width:22px;cursor:pointer;" class="grid-upload-input"/>' +
                             '</span>';
            if (isDocumentUploaded && docPath) {
                downloadIcon = '<span class="download-icon-v2" data-doc-path="' + docPath + '" style="cursor:pointer;"></span>';
            } else {
                downloadIcon = '<span class="download-icon-v2 disabled" style="cursor:not-allowed; opacity:0.4;"></span>';
            }

            return '<div class="upload-download-wrapper" style="display:flex;">' + uploadIcon + downloadIcon + '</div>';
          },
    }]
});