/**
 *  @priyanshi Sharma
 *  Elections Grid
 */
Ext.define('Academia.view.studentPortal.Elections.SPElectionsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.spelectionsgrid',
	title: getCommonTranslation("LIST_OF_ELECTIONS"),
	store: 'election.election.SPElectionGridStore',
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'election.election.SPElectionGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	columns: [{
		header: getCommonTranslation("ELECTION_CODE"),
		dataIndex: 'electionCode',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation("ELECTION_NAME"),
		dataIndex: 'electionName',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation("ELECTION_TYPE"),
		dataIndex: 'electionType',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation("ACADEMIC_TERM"),
		dataIndex: 'academicTerm',
		sortable:true,
		flex: .2
	},{
		header:  getCommonTranslation("VOTING_START_DATE_TIME"),
		dataIndex: 'votingStartDate',
		flex:.2,
		renderer: function(value, metadata, record) {
			var votingtime=  dateRender(value)+ " " + timeRender(record.data.votingStartTime);
			return votingtime;
		}
	},{
		header:  getCommonTranslation("VOTING_END_DATE_TIME"),
		dataIndex: 'votingEndDate',
		flex:.2,
		renderer: function(value, metadata, record) {
			var votingendTime=  dateRender(value)+ " " + timeRender(record.data.votingEndTime);
			return votingendTime;
		}
	},{
		header: getCommonTranslation("VOTING_ACTION"),
		dataIndex: 'votingAction',
		sortable:true,
		flex: .2,
		renderer:function(value) {
			if(!isNullOrEmpty(value)){
				var val;
				if(value == 'VOTED') {
					val = '<span  style="color:Green;">' +getCommonTranslation("VOTED")+ '</span>';
				}else if(value == 'NOT_VOTED') {
					val = '<a href="#" style="color:red;">' +getCommonTranslation("NOT_VOTED")+ '</a>';
				}else if(value == 'VOTE'){
					val = '<a href="#">' +getCommonTranslation("VOTE")+ '</a>';
				}
				return val;
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation("CAPTURED_BY"),
		dataIndex: 'voteCaptureBy',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value) {
			if(!isNullOrEmpty(value)){
				return  getCommonTranslation(value);
			} else {
				return value;
			}
		}
	},{
		header: getCommonTranslation("CAPTURED_ON"),
		dataIndex: 'votedOn',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value) {
			return dateRender(value);
		}
	}]
});