/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.businessruleapplytowindow',
	modal: true,
	autoScroll: true,
	title: getExaminationTranslation('APPLY_TO'),
	height: 245,
	width: 600,
	frame: true,
	bodyPadding: '12 0 0 12',
	plugins: "formlabelrequired",
	items: [{
		xtype: 'radiogroup',
		fieldLabel: getExaminationTranslation('BUSINESS_RULE_APPLY_TO'),
		labelAlign: 'top',
		allowBlank: false,
		itemId:'applytoId',
		defaults: {
			name: 'applyTo'
		},
		items: [{
			boxLabel: getExaminationTranslation('PROGRAM_BATCH_PERIOD'),
			checked: true,
			inputValue:'programbatch',
			margin: '8 0 0 0'
		}, {
			boxLabel: getExaminationTranslation('COURSES'),
			inputValue:'course',
			margin: '8 16 0 16'
		}, {
			boxLabel: getExaminationTranslation('STUDENT_GROUP'),
			inputValue:'studentgroup',
			margin: '8 0 0 0'
		}]
	}, { 	
		xtype: 'fieldcontainer',
		width: 'auto',
		margin: '62 0 8 0',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getAdmissionTranslation('PROCEED'),
			formBind: true,
			itemId: 'proceedBtnWin',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'cancelBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});