/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.survey.sendSurvey.CreateSurveyPBSWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.createsurveypbswindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getCommonTranslation('CREATE_NEW_SURVEY'),
    width: 550,
    height: 400,
    items: [{
        xtype: 'form',
        itemId: 'createSurveyForm',
        layout: 'vbox',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'copyFromSurvey',
    			itemId: 'copyFromSurveyPBSItemId',
    			fieldLabel:getCommonTranslation('COPY_FROM'),
    			store: Ext.create('Academia.store.survey.ActiveSurveyListStore'),	    
                valueField:'sid',
                displayField:'surveyls_title',
    			width:460,
    			disabled:false,
    			typeAhead : true,
    			forceSelection : true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			allowBlank: false,
    			matchFieldWidth:true,
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				}
    			}
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
            	xtype: 'textfield',
            	name: 'surveyNamePrefix',
            	itemId: 'surveyNamePrefixPBSItemId',
            	allowBlank: false,
            	fieldLabel:getCommonTranslation('SURVEY_NAME_PREFIX'),
            	width: 226
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 446
            },
            items: [{
            	xtype: 'checkboxfield',
    			labelAlign: 'right',
            	name: 'includePeriodCheckBoxPBS',
            	itemId: 'includePeriodCheckBoxPBSItemId',
            	boxLabel:getCommonTranslation('INCLUDE_PERIOD_NAME'),
            	inputValue: true
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 446
            },
            items: [{
            	xtype: 'checkboxfield',
    			labelAlign: 'right',
            	name: 'includeFacultyCheckBoxPBS',
            	itemId: 'includeFacultyCheckBoxPBSItemId',
            	boxLabel:getCommonTranslation('INCLUDE_FACULTY_NAME'),
            	inputValue: true
            }]
        },{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('CREATE'),
				itemId : 'createSurveyCreatePBSBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'createSurveyCancelPBSBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
    }]

});