/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TMTaskReportsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.tmtaskreportsgrid',
	store: 'taskmanagement.TMTaskReportsStore',
	title: getServiceRequestTranslation('TM_TASKS_REPORT'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'taskmanagement.TMTaskReportsStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [],
	columns: [{
		header: getServiceRequestTranslation('TM_TASK_OWNER_NAME'),
		dataIndex: 'ownerPrintName',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('TM_TASK_TITLE'),
		dataIndex: 'minuteSubject',
		flex: 1,
		sortable: true,
	}, {
		header: getServiceRequestTranslation('EMM_ASSIGNED_DATE'),
		dataIndex: 'assignDate',
		flex: 1,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex: 2,
		sortable: true
	}, {
		header: getServiceRequestTranslation('DUE_DATE'),
		dataIndex: 'dueDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('EMM_TASK_STATUS'),
		dataIndex: 'status',
		flex: 1,
		sortable: true,
		renderer: function(val) {
			var colorValue = '';
			if (val == 'PENDING') {
				colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
			} else if (val == 'COMPLETED') {
				colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
			}
			return colorValue;
		}
	},
	{
		header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
		dataIndex: 'completionDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
		dataIndex: 'noOfDaysOverdue',
		flex: 1,
		sortable: true
	},
	{
        header: getCommonTranslation('ATTACHMENTS'),
        dataIndex: 'attachments',
        sortable: true,
        flex: 1,
        renderer: function(value, metadata, record) {
    		return '<a href="#">' + "View" + '</a>';
    	}
    },
    {
		header: getServiceRequestTranslation('TM_TASK_TAKER'),
		dataIndex: 'minuteTakerPrintName',
		flex: 1,
		sortable: true
	}]
});