/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.PeopleCoveredGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.peoplecoveredgrid',
	store : 'transport.serviceRoute.PeopleCoveredGrid',
	title: getTransportTranslation('PEOPLE_COVERED_LIST'),
	border: true,
	width:1270,
	reserveScrollbar:true,
	selType :'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.serviceRoute.PeopleCoveredGrid',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype: 'button',
		itemId: 'sendMessageBtn',
		text:getCommonTranslation('SEND_MESSAGE')
	},{
		xtype: 'button',
		itemId: 'printBusPassStd',
		text:getTransportTranslation('PRINT_BUSS_PASS')
	}],
	columns: [{
		header : getTransportTranslation('SERVICE_ROUTE_NAME'),
		dataIndex : 'serviceName',
		hidden:true,
		flex:1,
		renderer: function(value, metaData, record, row, col, store, gridView) {
			var transServiceRoute = record.get("transServiceRoute");
			if(!isNullOrEmpty(transServiceRoute)) {
				return transServiceRoute.value;
			}
		}
	},{
		header : getTransportTranslation('ROUTE_NAME'),
		dataIndex : 'routeName',
		hidden:true,
		flex:1
	},{
		header : getTransportTranslation('CAPACITY'),
		dataIndex : 'capacity',
		hidden:true,
		flex:1
	},{
		header : getTransportTranslation('USER_TYPE'),
		dataIndex : 'user',
		flex:1,
		sortable : true,
		renderer: function(value, metaData, record, row, col, store, gridView) {
			var user = record.get("user");
			if(!isNullOrEmpty(user)) {
				if(!isNullOrEmpty(user.userGroup) && user.userGroup.value.toUpperCase() == "FACULTY"){
					return getCommonTranslation('FACULTY');	
				}
				else{
					return user.userGroup.value;
				}
			}else{
				return 'External';
			}
		}
	},{
		header : getTransportTranslation('USER_NAME'),
		dataIndex : 'userName',
		flex:1,
		sortable : true/*,
		renderer: function(value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(record.get("user"))) {

						return record.get("user").value;

			}else{
				return record.get("userName");
			}
		}*/
	},{
		header : getTransportTranslation('DATE_ADDED'),
		dataIndex : 'dateAdded',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ADDITION_EFFECTIVE_FROM'),
		dataIndex : 'addtionEffectiveFrom',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('DATE_REMOVED'),
		dataIndex : 'dateRemoved',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('REMOVAL_EFFECTIVE_FORM'),
		dataIndex : 'removalEffectiveForm',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('USAGE_STATUS'),
		dataIndex : 'usageStatus',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='YES'){
					return getTransportTranslation('YES');
				}else{
					return getTransportTranslation('NO');
				}
			}
		}
	}]
});