/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.transport.serviceRoute.ServiceRoutesForUserCoveredGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.serviceroutesforusercoveredgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '60%',
	width: '60%',
	title:getTransportTranslation('USERS_COVERED'),
	items: [{
		xtype: 'grid',
		store : 'transport.serviceRoute.ServiceRouteForUserCovered',
		frame: false,
		border:true,
		autoScroll: false,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'transport.serviceRoute.ServiceRouteForUserCovered',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getTransportTranslation('USER_TYPE'),
			dataIndex : 'user',
			flex:1,
			renderer: function(value, metaData, record, row, col, store, gridView) {
				if(!isNullOrEmpty(record.get("user"))) {
					if(!isNullOrEmpty(record.get("user").userGroup) && record.get("user").userGroup.value.toUpperCase() == "FACULTY"){
						return getCommonTranslation('FACULTY');	
					}
					else{
						return record.get("user").userGroup.value;
					}
				}else{
					return 'External';
				}
			}
		},{
			header : getTransportTranslation('USER'),
			dataIndex : 'user',
			flex:1,
			renderer: function(value, metaData, record, row, col, store, gridView) {
				if(!isNullOrEmpty(record.get("user"))) {
					return record.get("user").value;
				}else{
					return record.get("userName");
				}
			}
		}]
	}]
});
