/*
    This file is generated and updated by Sencha Cmd. You can edit this file as
    needed for your application, but these edits will have to be merged by
    Sencha Cmd when upgrading.
 */
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false,
	paths: {
		'Ext.calendar': 'app/utilities/calendar'
	}
});
Ext.application({
	name: 'Academia', // application name that becomes the namespace
	extend: 'Academia.Application',
	init: function(){
		Academia.enumStore = {};
		Academia.dataStore = {};
	},
	autoCreateViewport: false, //// automatically refer Viewport.js
	controllers: [ 
		'Academia.controller.menu.CoreERPNavigationController',
		'Academia.controller.base.BaseController',
		'Academia.controller.authentication.AuthenticationController',
		'Academia.controller.dashboard.DashboardController',
		'Academia.controller.criteriabuilder.CriteriaBuilderController',
		'Academia.controller.criteriabuilder.SavedAdvanceSearchCriteriaController',
		'Academia.controller.datasetting.IdGeneratorController',
		'Academia.controller.webcam.ImageCaptureController',
		
		
		//-------comment below function for devlopment mode------------ - 
		'Academia.controller.organization.AcademyController',
		'Academia.controller.organization.AddressController',
		'Academia.controller.organization.LocationStructureController',
		'Academia.controller.organization.ManagementAccountingController',
		'Academia.controller.organization.MappingErrorController',
		'Academia.controller.organization.OrganizationInfoController',
		'Academia.controller.organization.SU-SAU-MAUMappingController',
		'Academia.controller.organization.StatutoryAccounting',
		'Academia.controller.organization.Supervision',
		'Academia.controller.organization.academylocations.AcademyLocationController',
		'Academia.controller.organization.academylocations.AcademyLocationPurposeController',
		'Academia.controller.othermasters.bankmaster.BankMasterController',
		'Academia.controller.othermasters.certificatemaster.CertificateMasterController',
		'Academia.controller.othermasters.communitymaster.CommunityMasterController',
		'Academia.controller.othermasters.currencymaster.CurrencyMasterController',
		'Academia.controller.othermasters.deficitmaster.DeficitCreditMasterController',
//		'Academia.controller.othermasters.requeststatusmaster.RequestStatusMasterController',
		'Academia.controller.othermasters.servicemaster.ServiceMasterController',
		'Academia.controller.customcategories.CustomCategoryController',
		'Academia.controller.customfields.CustomFieldController',
		'Academia.controller.dashboard.DashletRoleMappingController',
		'Academia.controller.dashboard.OveriddenUserDashletsController',
		'Academia.controller.datasetting.DataSettingController',
		'Academia.controller.department.DepartmentController',
		'Academia.controller.department.SubDepartmentController',
		'Academia.controller.document.DocumentController',
		'Academia.controller.documentmanagement.DocumentTemplateController',
		'Academia.controller.dynamicformrendering.DynamicFormRenderingController',
		'Academia.controller.calendar.CalendarController',
		'Academia.controller.gradeMaster.GradeMasterController',
		'Academia.controller.gradeMaster.GradeMasterSearchController',
		'Academia.controller.importutility.ImportUtilityController',
		'Academia.controller.messaging.AdhocMessagingEventController',
		'Academia.controller.messaging.SystemEventConfigurationController',
		'Academia.controller.messaging.TemplateConfigurationController',
		'Academia.controller.setup.dashboard.TablesDashboardController',
		'Academia.controller.setup.templatemapping.TemplateMappingController',
		'Academia.controller.standardMaster.StandardMaster',
		'Academia.controller.quartz.QuartzController',

		// enquiry
		'Academia.controller.enquiry.EnquiryController',
		'Academia.controller.enquiry.TrackEnquiryController',
		'Academia.controller.enquiry.admission.AdmissionReqmntDetailController',
		'Academia.controller.campaign.CampaignController',
		'Academia.controller.enquiry.EnquiryReportsController',
		'Academia.controller.enquiry.closure.ClosureDetailController',
		'Academia.controller.enquiry.enquirydetail.EnquiryDetailController',
		'Academia.controller.enquiry.exam.ExamDetailController',
		'Academia.controller.enquiry.followup.FollowUpDetailController',
		'Academia.controller.enquiry.student.StudentDetailController',
		'Academia.controller.enquiry.EnquiryRevampController',
		'Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController',
		'Academia.controller.enquiry.student.StudentDetailRevampController',


		//Program
		'Academia.controller.program.ProgramAssignExamCentersController',
		'Academia.controller.program.ProgramController',
		'Academia.controller.program.ProgramCourseGroupsController',
		'Academia.controller.program.ProgramCourseParameterController',
		'Academia.controller.program.ProgramCourseSpecializationController',
		'Academia.controller.program.ProgramCoursesController',
		'Academia.controller.program.ProgramPeriodsBreaksController',
		'Academia.controller.program.ProgramPeriodsController',
		'Academia.controller.program.ProgramRelatedCoursesController',
		'Academia.controller.program.programDetail.BasicDetailProgramController',
		'Academia.controller.program.programDetail.ProgramBatchDetailController',
		'Academia.controller.program.programDetail.batchdetail.ProgramBatchDetailSeatTypeController',
		'Academia.controller.program.reports.ProgramReportController',
		'Academia.controller.programCourseDashboard.DashboardController',
		'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
		'Academia.controller.reports.admission.AdmissionDashboardController',
		'Academia.controller.reports.admission.AdmissionReportController',
		'Academia.controller.program.CourseFeeDefinitionCentersController',

		//course
		'Academia.controller.course.CourseListController',
		'Academia.controller.course.CreateCourseController',
		'Academia.controller.course.academylocation.AcademyLocationController',
		'Academia.controller.course.basicdetail.BasicDetailController',
		'Academia.controller.course.courseComponent.CourseComponentController',
		'Academia.controller.course.courseEquivalence.CourseEquivalenceController',
		'Academia.controller.course.coursegroup.AssignCoursesController',
		'Academia.controller.course.coursegroup.CourseGroupController',
		'Academia.controller.course.coursegroup.ViewPerformanceController',
		'Academia.controller.course.coursespecialization.CourseSpecializationController',
		'Academia.controller.course.coursevariants.CourseVariantController',
		'Academia.controller.course.history.HistoryController',
		'Academia.controller.course.reports.CourseReportController',
		'Academia.controller.course.topic.TopicController',
		'Academia.controller.coursetracker.CourseTrackerController',
		'Academia.controller.course.readingmaterial.ReadingMaterialController',

		//coursetransaction
		'Academia.controller.coursetransaction.coursereading.CourseReadingController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListController',
		'Academia.controller.coursetransaction.homework.HomeworkAssignmentController',
		'Academia.controller.coursetransaction.homework.HomeworkEvaluationController',
		'Academia.controller.coursetransaction.homework.HomeworkSubmissionController',
		'Academia.controller.coursetransaction.promotion.PromotionController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanDetailsController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanGridController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.MasterTimeTableController',
		'Academia.controller.coursetransaction.sectionmanagement.SectionManagementController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseMasterController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController',
		'Academia.controller.coursetransaction.studentcourseenrollment.courseGroup.StudentCourseGroupController',
		'Academia.controller.coursetransaction.studymaterialdistribution.StudyMaterialDistributionController',
		'Academia.controller.coursetransaction.viewschedule.ViewScheduleController',
		'Academia.controller.coursetransaction.managedistribution.ManageDistributionController',
		'Academia.controller.coursetransaction.studymaterialdistributionnew.StudyMaterialDistributionNewController',

		//User securitysetup
		'Academia.controller.securitysetup.User',
		'Academia.controller.systemusage.SystemUsageController',
		'Academia.controller.securitysetup.Role',
		'Academia.controller.securitysetup.unlockUser.CurrentLockUserController',
		'Academia.controller.securitysetup.unlockUser.NeverLockUserController',
		'Academia.controller.securitysetup.unlockUser.PreviousLockedUserController',
		'Academia.controller.reports.systemutilization.loginFrequency.LoginFrequencyController',

		//feeandpayment
		'Academia.controller.feeandpayment.AccountStatementReportController',
		'Academia.controller.feeandpayment.AdvanceFeeReportController',
		'Academia.controller.feeandpayment.FeeAndPaymentController',
		'Academia.controller.feeandpayment.FeeAndPaymentReportController',
		'Academia.controller.feeandpayment.accountingConfiguration.AccountingConfigurationController',
		'Academia.controller.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingController',
		'Academia.controller.feeandpayment.adjustment.AdjustmentController',
		'Academia.controller.feeandpayment.controlAccount.ControlAccountController',
//		'Academia.controller.feeandpayment.dashboardAndReports.FeeAndPaymentDashboardController',
		'Academia.controller.feeandpayment.feerequest.FeeRequestController',
		'Academia.controller.feeandpayment.managebill.ManageBillController',
		'Academia.controller.feeandpayment.payment.PaymentController',
		'Academia.controller.feeandpayment.receipts.ReceiptsController',
		'Academia.controller.feeandpayment.voucherMode.VoucherModeController',
		'Academia.controller.feeandpayment.receipts.FeeLedgerMasterController',
//		'Academia.controller.feeandpayment.FeeAndPaymentSequenceController',
		'Academia.controller.feeandpayment.FeeAndPaymentConfigureController',
//		'Academia.controller.feeandpayment.managebill.ManageBillInnerController',

//		examinationcenters
		'Academia.controller.examinationcenters.evaluation.EvaluationMasterController',
		'Academia.controller.examinationcenters.evaluation.EvaluationPlanController',
		'Academia.controller.examinationcenters.evaluation.applyrule.ApplyRuleController',
		'Academia.controller.examinationcenters.ExaminationCentersController',
		'Academia.controller.examinationcenters.examlogistic.ExamLogisticController',
		'Academia.controller.examinationcenters.centerunavailability.CenterUnavailabilityMasterController',
//
		'Academia.controller.examinationcenters.evaluation.coverageDetails.CoverageDetailsController',
		'Academia.controller.examinationcenters.evaluation.evaluationDetail.EvaluationDetailTabController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationCreateGroupController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationLevelOneAndTwoFormController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationPalnSequenceController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationPlanHierarchyController',
		'Academia.controller.examinationcenters.evaluationgroup.EvalGroupMasterController',
		'Academia.controller.examinationcenters.evaluationgroup.detailsequenceCovered.DetailSequenceCoveredController',
		'Academia.controller.examinationcenters.evaluationgroup.documents.EvalGroupDocumentController',
		'Academia.controller.examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailController',
		'Academia.controller.examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.applicationdetail.ApplicationDetailController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAlllocationController',
		'Academia.controller.examinationcenters.dasboard.ExamLogisticStatisticsController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentSubmitController',
		'Academia.controller.examinationcenters.evaluationplanstatus.EvaluationStatusController',
		'Academia.controller.examinationcenters.evaluationresult.EvaluationResultController',
		'Academia.controller.examinationcenters.evalresultlisting.EvalResultListingMasterController',
		'Academia.controller.examinationcenters.roomallocation.RoomAllocationController',
		'Academia.controller.examinationcenters.examstaffallocation.ExamStaffAllocationController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageEvalResultSearchController',
		'Academia.controller.examinationcenters.markgrade.MarkGradeSearchController',
		'Academia.controller.examinationcenters.markgrade.markgradedetail.ResultStatisticController',
		'Academia.controller.examinationcenters.marksheet.MarksheetGenerationController',
		'Academia.controller.examinationcenters.remark.EvaluationRemarkController',
		'Academia.controller.examinationcenters.repetitioncompletion.RepetitionCompletionController',
//
		'Academia.controller.examCenter.sequenceManagement.AssignSequenceController',
		'Academia.controller.examCenter.sequenceManagement.CreateSequenceHeaderController',

		// personinfo
		'Academia.controller.personinfo.common.PersonCommonController',
		'Academia.controller.personinfo.common.PersonCourseExecutionController',
		'Academia.controller.personinfo.common.PersonDisciplinaryController',
		'Academia.controller.personinfo.common.PersonFeedbackSurveyController',
		'Academia.controller.personinfo.common.PersonInfoController',
		'Academia.controller.personinfo.common.PersonPastHistoryController',
		'Academia.controller.personinfo.common.PersonPaymentRefundController',
		'Academia.controller.personinfo.common.PersonRequestActionController',
		'Academia.controller.personinfo.common.PersonServiceController',
		'Academia.controller.personinfo.faculty.FacultyCourseExecutionController',
//		'Academia.controller.personinfo.faculty.FacultyDisciplinaryController',
		'Academia.controller.personinfo.faculty.FacultyDocumentController',
//		'Academia.controller.personinfo.faculty.FacultyFeedbackSurveyController',
		'Academia.controller.personinfo.faculty.FacultyListController',
//		'Academia.controller.personinfo.faculty.FacultyPastHistoryController',
//		'Academia.controller.personinfo.faculty.FacultyPaymentRefundController',
		'Academia.controller.personinfo.faculty.FacultyPersonalController',
		'Academia.controller.personinfo.faculty.FacultyRequestActionController',
//		'Academia.controller.personinfo.faculty.FacultyServiceController',
		'Academia.controller.personinfo.student.StudentCourseExecutionController',
		'Academia.controller.personinfo.student.StudentDebarmentController',
		'Academia.controller.personinfo.student.StudentDisciplinaryController',
		'Academia.controller.personinfo.student.StudentDocumentController',
		'Academia.controller.personinfo.student.StudentFeedbackController',
		'Academia.controller.personinfo.student.StudentKYSController',
		'Academia.controller.personinfo.student.StudentListController',
		'Academia.controller.personinfo.student.StudentPastHistoryController',
		'Academia.controller.personinfo.student.StudentPaymentRefundController',
		'Academia.controller.personinfo.student.StudentPersonalController',
		'Academia.controller.personinfo.student.StudentRequestActionController',
		'Academia.controller.personinfo.student.StudentServiceController',
		'Academia.controller.personinfo.student.StudentTerminationController',
//		'Academia.controller.personinfo.student.StudentTrackRequestController',
		'Academia.controller.personinfo.student.StudentTransferController',
		'Academia.controller.personinfo.dashlet.PersonInfoDashboardController',
		'Academia.controller.hrm.EmployeeAvailabilityController',
		'Academia.controller.hrm.EmployeePatentReportController',
		//servicerequest
		'Academia.controller.servicerequest.PersonalDataChangeRequestController',
		'Academia.controller.servicerequest.ServiceRequestBaseController',
		'Academia.controller.servicerequest.ServiceRequestController',
		'Academia.controller.servicerequest.ServiceRequestSetting',

		//attendance

		'Academia.controller.attendance.AttendanceMasterController',
		'Academia.controller.attendance.attendancesettings.AttendanceSettingController',
		'Academia.controller.attendance.attendancereport.AttendanceReportController',
		'Academia.controller.attendance.FacultyAttendanceController',
		'Academia.controller.attendance.PendingAttendanceController',
		'Academia.controller.attendance.attendancecheck.AttendanceCheckController',
		'Academia.controller.attendance.LeaveReportController',
		'Academia.controller.attendance.AttendanceController',
//		'Academia.controller.attendance.EditAttendanceController',

		//scholarship
		'Academia.controller.scholarship.ScholarshipListingController',
		'Academia.controller.scholarship.ScholarshipMasterController',
		'Academia.controller.scholarship.ScholarshipReceiptController',
		'Academia.controller.sponsorship.SponsorshipListingController',
		'Academia.controller.sponsorship.SponsorshipMasterController',
		'Academia.controller.sponsorship.SponsorshipReceiptController',
		'Academia.controller.sponsorship.SponsorshipBillingController',

		//facilitiesresources
		'Academia.controller.facilitiesresources.resourcemaster.ResourceMaster',
		'Academia.controller.facilitiesresources.resourcebooking.ResourceBookingController',

		//reports
		'Academia.controller.reports.complaints.ComplaintsDashboardReportController',
		'Academia.controller.reports.completion.CompletionDashboardController',
		'Academia.controller.reports.faculty.FacultyDashboardController',
		'Academia.controller.reports.faculty.FacultyReportsController',
		'Academia.controller.reports.programcourse.coursegroupcompletion.CourseGroupCompletionController',
		'Academia.controller.reports.programcourse.specialization.SpecializationReportController',
		'Academia.controller.reports.student.StudentDashboardController',
		'Academia.controller.reports.student.StudentReportController',
		'Academia.controller.reports.systemutilization.inactiveusers.InactiveUserByTimeReportController',
		'Academia.controller.reports.systemutilization.inactiveusers.InactiveUserReportController',
		'Academia.controller.reports.systemutilization.onlineusers.OnlineUserReportController',
		'Academia.controller.examinationcenters.reports.ExamReportCommonController',
		'Academia.controller.student.report.StudentFeePayerReportController',
//		'Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController',

		//completion
		'Academia.controller.completion.CompletionCbController',
		'Academia.controller.completion.CompletionFormController',
		'Academia.controller.completion.CompletionSettingController',

		//admission
		'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
		'Academia.controller.admission.applicationFormSale.ApplicationFormSaleController',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
		'Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController',
		'Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController',
		'Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController',
		'Academia.controller.admission.applications.applicantService.ApplicantServiceController',
		'Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController',
		'Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController',
		'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
		'Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController',
		'Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController',
		'Academia.controller.admission.assignApplicationID.AssignApplicationIdController',
		'Academia.controller.admission.directSubmission.DirectSubmissionController',
		'Academia.controller.admission.finalAdmissionList.FinalAdmissionListController',
		'Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController',
		'Academia.controller.admission.quotas.QuotaSettingController',
		'Academia.controller.admission.replacement.ReplacementController',
		'Academia.controller.admission.selectionProcess.SelectionProcessController',
		'Academia.controller.admission.selectionStage.SelectionStageController',
		'Academia.controller.admission.admissionCycle.AdmissionCycleController',

		//transport
		'Academia.controller.transport.vehicle.VehicleController',
		'Academia.controller.transport.route.RouteController',
		'Academia.controller.transport.serviceRoute.ServiceRouteController',
		'Academia.controller.transport.reports.JourneyAssignmentReportController',
		'Academia.controller.portal.StudentAttendanceReportController',
		'Academia.controller.feeandpayment.reports.FeeReportCommonController',
		'Academia.controller.reports.programcourse.creditbasedreport.CreditBasedReportController',
		'Academia.controller.reports.survey.SurveyReportController',
		'Academia.controller.admission.applicantFormSaleDirectSubmission.ApplicationFormCommonController',
		'Academia.controller.admission.manageForm.ManageFormController',
//		'Academia.controller.portal.MasterScheduleController',

		// hostel
		'Academia.controller.hostel.manageroomtype.ManageRoomTypeController',
		'Academia.controller.hostel.managerestrictiontype.ManageRestrictionTypeController',
		'Academia.controller.hostel.managehostel.ManageHostelController',
		'Academia.controller.hostel.roomallocation.RoomAllocationStructureController',
		'Academia.controller.hostel.manageallocation.ManageAllocationController',

		//Exam calculate Results
		'Academia.controller.examinationcenters.examcalculateresult.examcalculateresultController',
		// hostel report
		'Academia.controller.hostel.reports.RoomAllocationReportController',
		'Academia.controller.hostel.reports.ManageAllocationReportController',
		'Academia.controller.hostel.reports.HostelFeeReportController',
		//************** Application Report******
		'Academia.controller.applicationreport.ApplicationController',
		'Academia.controller.manageDetention.ManageDetentionController',
		'Academia.controller.leavemanagement.LeaveTypeController',
		'Academia.controller.leavemanagement.LeaveSettingController',
		'Academia.controller.hostel.hostelattendance.HostelAttendanceController',
		'Academia.controller.leavemanagement.sanctionleave.LeaveSanctionSettingController',
		'Academia.controller.examinationcenters.reports.ExaminationDocumentController',
		'Academia.controller.servicerequest.eventcalendar.EventCalendarController',
		// Placement
		'Academia.controller.placement.placementtype.PlacementTypeController',
		'Academia.controller.placement.placementcampus.PlacementCampusController',
		'Academia.controller.placement.createcompany.CreateCompanyController',

		'Academia.controller.leavemanagement.administrativeleave.AdministrativeSettingController',
		'Academia.controller.examinationcenters.questionPaperBank.questionPaperBankController',
		'Academia.controller.placement.placementjob.PlacementJobController',
		'Academia.controller.placement.placementjobapplication.PlacementJobApplicationController',
		'Academia.controller.student.report.StudentTransferReportController',

		'Academia.controller.placement.recruitmentStage.PlacementRecruitmentStageController',
//		'Academia.controller.examinationcenters.dutychart.ExaminationDutyChartController',
		'Academia.controller.examinationcenters.examinationRemark.ExaminationRemarkController',
		'Academia.controller.placement.placementMaster.PlacementMaster',
		'Academia.controller.mobile.mobilesyncreport.MobileSyncController',
		'Academia.controller.filemanagement.ManageFileController',
		'Academia.controller.securitysetup.UserRoleAssociationController',
		'Academia.controller.facilitiesresources.eventAwards.EventAwardsController',
		'Academia.controller.personinfo.student.StudentEnrollmentGenerationController',
		'Academia.controller.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentController',
		'Academia.controller.coursesessiondiary.CourseSessionDiaryController',
		'Academia.controller.program.sessionReport.SessionReportController',
		'Academia.controller.personinfo.student.StudentProgressController',
		'Academia.controller.committee.committee.CommitteeController',
		'Academia.controller.sgmanagement.sgvisitor.sgVisitorController',
		'Academia.controller.sgappointment.sgappointment.SGAppointmentController',
		'Academia.controller.fdmanagement.FDManagementController',
//		'Academia.controller.feeandpayment.feerequest.StudentPortalFeeRequestController',
		'Academia.controller.programCourseDashboard.enrollmentSummaryReport.EnrollmentSummaryReportController',
//		'Academia.controller.personinfo.student.StudentComplaintController',
//		'Academia.controller.personinfo.student.StudentExaminationDocumentsController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageSpecialGradeController',
		'Academia.controller.student.demographicReport.StudentDemographicReportController',
		'Academia.controller.eventmeetingminutes.EventMeetingMinutesController',
		'Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController',
//		'Academia.controller.examinationcenters.reports.faculty.FacultyPendingMarksController',
		'Academia.controller.program.SpecializationEnollmentController',
		'Academia.controller.program.transfercredits.TransferCreditsController',
		'Academia.controller.taskmanagement.TaskManagementController',
		'Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController',
//		'Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController',
		'Academia.controller.examinationcenters.manageEvaluation.RevaluationMarkentryController',
		'Academia.controller.examinationcenters.revaluation.RevaluationSetupController',
		'Academia.controller.organization.academylocations.AcademyLocationAddressController',
		'Academia.controller.othermasters.programgroupmaster.ProgramGroupMasterController',
		'Academia.controller.managetarget.ManageTargetController',
		'Academia.controller.transport.reports.TransportDuesReportController',
		'Academia.controller.resourceutilization.ResourceUtilizationController',
		'Academia.controller.examinationcenters.assessmentEvent.AssessmentEventController',
//		'Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseRegistrationController',
		'Academia.controller.admission.applications.applicantDocuments.ApplicationBulkDownloadStatusController',
		'Academia.controller.feeandpayment.discounts.DiscountController',
		'Academia.controller.feeandpayment.discounts.ManageDiscountController',
		'Academia.controller.examinationcenters.calculateAverage.CalculateAverageController',
		'Academia.controller.hrm.HRManagementController',
		'Academia.controller.leavemanagement.approvalsetup.LMApprovalSetupController',
		'Academia.controller.configureloader.ConfigureLoaderController',
		'Academia.controller.receipt.receiptsettings.ReceiptSettingsController',
		'Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController',				  
		'Academia.controller.examinationcenters.marksheet.AssessmentGroupMarksheetController',
		'Academia.controller.bulkdocumentupload.BulkDocumentUploadController',
		'Academia.controller.sgappointment.sgappointment.SGApplicantAppointmentController',
		'Academia.controller.reports.userroleprivilege.UserRolePrivilegeController',
		'Academia.controller.manageMarksModeration.ManageMarksModerationController',
		'Academia.controller.resourceavailability.ResourceAvailabilityReportController',
		'Academia.controller.feeandpayment.finance.ManageFinanceHoldController',
//		'Academia.controller.program.periodTerm.PeriodTermController',
		'Academia.controller.student.incidentsReport.StudentIncidentsReportController',
		'Academia.controller.student.disciplinaryActionsReport.StudentDisciplinaryActionsReportController',
		'Academia.controller.student.studentServiceOptInReport.StudentServiceOptInReportController',
		'Academia.controller.leavemanagement.report.FacultyLeaveReportsController',
		'Academia.controller.admission.selectionStageReport.SelectionStageReportController',
		'Academia.controller.program.lessonplanning.LessonPlanningController',
//		'Academia.controller.committee.committee.StudentCommitteeController',
		'Academia.controller.program.customReports.CustomReportController',
		'Academia.controller.student.studentIdentityDocumentReport.StudentIdentityDocumentReportController',
		'Academia.controller.hrm.BiometricMachineIntegrationController',
		'Academia.controller.inventorymanagement.InventoryMgtController',
//		'Academia.controller.examinationcenters.marksheet.FacultyMarksheetGenerationController',
		'Academia.controller.program.lessonplanning.LessonPlanningInnerController',
		'Academia.controller.examinationcenters.revaluation.RevaluationController',
		'Academia.controller.documentmanagement.DocumentMasterController',
//		'Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController',
		'Academia.controller.hostel.hostelapplication.HostelApplicationController',
		'Academia.controller.student.currentEnrollmentReport.StudentCurrentEnrollmentReportController',
		'Academia.controller.facilitiesresources.managegallery.ManageGalleryController',
		'Academia.controller.student.studentLeaversReport.StudentLeaversReportController',
		'Academia.controller.translation.TranslationController',
		'Academia.controller.examinationcenters.studentresultreport.StudentResultReportController',
		'Academia.controller.leavemanagement.leavegeneralsetting.LeaveGeneralSettingController',
		'Academia.controller.attendance.ConsolidateAttendanceController',
		'Academia.controller.student.studentDeletedReport.StudentDeletedReportController',
		'Academia.controller.setup.droolrules.DroolRulesController',
		'Academia.controller.facilitiesresources.resourcebooking.EmployeeResourceBookingController',
		'Academia.controller.examinationcenters.evaluationresult.ExamResultPublishController', //till Capetown
		'Academia.controller.setup.campaignmaster.CampaignMasterController',
		'Academia.controller.campaignnew.CampaignNewController',
		'Academia.controller.powerBI.AnalyticsCommonController',
		'Academia.controller.leavemanagement.leavecreditsetting.LeaveCreditSettingController',
		'Academia.controller.examinationdegreeremark.ExaminationDegreeRemarkController',
		'Academia.controller.servicerequest.infirmarymanage.ManageInterventionController',

		'Academia.controller.setup.loginpage.LoginPageConfigurationController',
		'Academia.controller.DMSController.DMSCommonController',
		'Academia.controller.datagridconfiguration.DataGridConfigurationController',
		'Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController',
		'Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController',
		'Academia.controller.signupreport.signUpReportController',
		'Academia.controller.program.outcomebasededucation.OutcomeBasedEducationController',
		'Academia.controller.coursetransaction.sectionmanagement.CourseSectionManagementController',
		'Academia.controller.examinationOBEAttainment.ObeAttainmenRuleController',
		'Academia.controller.hrRecruitmentProcess.jobPosting.JobPostingController',
		'Academia.controller.course.requisite.CourseRequisiteController',
		'Academia.controller.admission.applicationOwnerSetup.ApplicationOwnerSetupController',
		'Academia.controller.outcomebasededucation.ObeCorrelationPercentController',
		'Academia.controller.admission.signupAdditionalSetup.SignupAdditionSetupController',
		'Academia.controller.documentmanagement.DocumentGroupMasterController',
		'Academia.controller.registrationsetup.RegistrationTermSetupController',
		'Academia.controller.hrRecruitmentProcess.jobApplication.JobApplicationController',
		'Academia.controller.examinationcenters.averagereport.StudentAverageReportController',
		'Academia.controller.examcancellation.ExamCancellationController',
		'Academia.controller.course.reports.CourseCreditGradeReportController',
		'Academia.controller.election.election.ElectionController',
		'Academia.controller.feeandpayment.coursefeedefinition.CourseFeeDefinitionController',
		'Academia.controller.enquiry.enquirySettings.CtrlPadmEnquiryFormSetupController',
		'Academia.controller.feeandpayment.creditfeemapping.CreditFeeMappingController',
		'Academia.controller.examexecution.StudentMarkRemarkEntryController',
		'Academia.controller.placement.placementReport.PlacementDetailReportController',
		'Academia.controller.examinationcenters.thesisManagement.thesisManagementController',
		'Academia.controller.personinfo.student.StudentManageHoldController',
		'Academia.controller.tvet.TVETReportController',
		'Academia.controller.student.report.StudentMedicalDetailsReportController',
		'Academia.controller.setup.sessionlogouttimesetup.SessionLogoutTimeSetupController',
		'Academia.controller.examconcession.ExamConcessionController',
		'Academia.controller.examinationattendancerule.ExaminationAttendanceRuleController',
		'Academia.controller.reports.completion.CompletionReportController',
		'Academia.controller.setup.manageportalpermission.ManagePortalPermissionController',
		'Academia.controller.program.CatalogueContentController',
		'Academia.controller.setup.dashboard.LicenseDetailsReportController',
		'Academia.controller.examinationcenters.reports.UpdatedMarksRemarksReportController',
		'Academia.controller.student.feeregistrationreset.StudentFeeRegistrationResetController',
        'Academia.controller.powerBI.MarkSummaryAnalyticsReportController',
        'Academia.controller.setup.quickLink.QuickLinkController',
        'Academia.controller.hostel.accommodationProvider.AccommodationProviderController',
        'Academia.controller.feeandpayment.debitOrders.ManageDebitOrdersController',
        'Academia.controller.personinfo.faculty.LearningTargetsController',
        'Academia.controller.sunsuccess.SunSuccessController' ,
        'Academia.controller.personinfo.student.StudentJourneyCoreErpController',
        'Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController',
        'Academia.controller.admission.applications.pandadoc.PandaDocController',
        'Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController',
        'Academia.controller.examinationtimetable.ExamTimetableController',
        'Academia.controller.eventlevelremark.EventLevelRemarkController' ,
		'Academia.controller.scholarship.PoetMasterController',
		'Academia.controller.facultyCourseInterest.FacultyCourseInterestController',
		'Academia.controller.student.bulkUploadDocumentAndNotes.BulkUploadDocumentAndNotesController',
		'Academia.controller.manageCeremony.ManageCeremonyController',
		'Academia.controller.emailAccountStatement.EmailAccountStatementController', 
		'Academia.controller.prereqnotmetreport.PreReqNotmetReportController',
		'Academia.controller.coursetransaction.promotionpanel.PromotionPanelController',
		'Academia.controller.alumniManagementSystem.AlumniManagementController',
		'Academia.controller.alumniManagementSystem.AlumniPortalSetUpController',
		'Academia.controller.alumniManagementSystem.AlumniFundsRaisingController',
		'Academia.controller.alumniManagementSystem.AlumniNewsAndFeedsController', 
		'Academia.controller.lecturerCostingDefinition.LecturerCostingDefinitionController',
		'Academia.controller.hostel.hostelApplicationSetup.HostelApplicationSetupController',
		'Academia.controller.examination.RoomAndStaffAllocationController',
		'Academia.controller.examination.ExamConcessionStaffAllocationController',
		'Academia.controller.examination.ImportPreExamDetailController',
		'Academia.controller.setup.controlPanel.ControlPanelController',
		'Academia.controller.student.report.StudentHealthInformationReportController',
		'Academia.controller.personinfo.studentportalangularsetup.StudentPortalAngularLoginSetupController',
		'Academia.controller.survey.createSurvey.CreateSurveyController',
		'Academia.controller.survey.sendSurvey.SendSurveyController',
		'Academia.controller.survey.surveyReport.SurveyReportController',
		'Academia.controller.student.feeRegistrationFormSetup.FeeRegistrationFormSetupController',
		'Academia.controller.users.userProfileLastActivity.UserProfileController',
		'Academia.controller.personinfo.student.StudentProfileController',
		'Academia.controller.alumniManagementSystem.AlumniCommunicationHistoryController',
		'Academia.controller.personinfo.facultyPortalAngularSetup.FacultyPortalAngularLoginSetupController',
       	'Academia.controller.setup.dashboard.TermsandConditionReportController',
       	'Academia.controller.reports.allReports.ReportsMainController',
		 'Academia.controller.AssessmentGroupRegistration.AssessmentGroupRegistrationController'
		       
	],
	views: [
		'common.StatusCombo','common.StatusCombos',
              'Academia.view.baselayout.contentarea.ContentPanel',
	          'Academia.view.CustomAlerts',
	          // from base controller
		'reports.admission.admsnDataNullReport',
		'common.LiveSearchCombo',
		'Academia.view.common.AcadLocProgBatchSeattypeComponent',
		'common.NestedTextField',
		'common.IdGeneratorCustomForm',
		'common.DynamicFieldForm',
		'common.DynamicFieldFormWin',
		'common.IdGeneratorCustomFormWin',
		'common.IdGeneratorFormWin',
		'common.AddressDetailPanel',
		'common.CustomFieldForm',
		'messaging.sendmessage.SendMessageWindow',
  			 // form CoreERPNavigationController
            'Academia.view.organization.OrganizationStructure',
            'Academia.utilities.ux.CustomTopPagingToolBar'
          			 ],
	stores: [
		'common.StatusComboStore',
		'common.LiveSearchCombos',
		'Academia.store.common.AcademyStore',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.LocationStore',
		'Academia.store.common.ProgramsByAcademyIdLocationId',
		'Academia.store.common.BatchesByProgramId',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.Checklist',
		'Academia.store.common.DocumentTypeStore',
		'common.ActiveUserStore',
		'Academia.store.messaging.MessageTemplate'
	],
    models:[
    	'customfields.CustomFieldDataModel',
    	'singleton.Organization',
    	'menu.MegaMenuDataModel',
    	'Academia.model.common.OrgSettingDateTimeModel'
    ],
	requires:[
	          'Academia.constants.CurrencyFormatConstants',
	          'Academia.utilities.CommonUtil',
               'Academia.utilities.vTypeValidations.Validation',
               'Academia.utilities.ErrorHandler',
               'Academia.utilities.plugins.AsteriskPlugin',
               'Academia.utilities.CustomAlerts',
               'Academia.utilities.JsonAjaxRequest',
               'Academia.utilities.ImageActionColumn',
               'Academia.utilities.accessControl.AccessControlManager',
               'Academia.utilities.accessControl.FeaturePrivilegeManager',
               // from base controller
               'Academia.utilities.plugins.TreeFilter',
               'Academia.utilities.ckEditor.CkEditor',
               'Academia.utilities.gridExporter',
               'Academia.utilities.DisplayFormatMap',
               'Academia.utilities.CurrencyFormatMap',
               'Academia.utilities.plugins.SessionMonitor',
               'Academia.utilities.currency.CurrencyManager',
               'Academia.utilities.date.DateHelper',
               'Academia.utilities.ux.PageSize', 
               'Academia.utilities.ux.CustomPagingToolBar',
               'Academia.utilities.ux.AutoGroupedColumn',
               'Academia.utilities.ux.GroupingComboBox',
               'Academia.utilities.ux.CustomCheckboxField',
               'Academia.utilities.reader.CacheRest',
               'Academia.utilities.reader.CustomArrayReader',
               'Academia.config.Runtime',
               'Academia.utilities.AllOverrides',
     ],
     launch :function(){
    	 	Ext.app.autoCallAPIs = true;
	    	//--- code for separating tabs ---//
	    	setTabId();
	    	initGoogleAnalytics();
	    //	document.head.insertAdjacentHTML("beforeend", '<style>#placeholderLbar{height:'+(Ext.getBody().getHeight()-127)+'px !important;}</style>');
	    	var getParams = document.URL.split("?");
    		var params = Ext.urlDecode(getParams[getParams.length - 1]);
    		localStorage.setItem('userHash','');
    		if(params["userHash"])
    		{
    			localStorage.setItem('userHash',params["userHash"]);
    			window.history.pushState("", "", getParams[0]);
    		}
    	       
    	      var tokenApiResponse = Ext.decode(localStorage.getItem('tokenApiResponse'));
    	      var academylocationid = Ext.decode(localStorage.getItem('academylocationid'));
    	      var wheatherSchool = Ext.decode(localStorage.getItem('wheatherSchool'));
		if(isNullOrEmpty(localStorage.getItem('maxLength'))){
  	    		localStorage.setItem('maxLength',160);
		}
  	    		if(!isNullOrEmpty(localStorage.getItem('defaultPage'))){
  	  	    		var defaultPage = localStorage.getItem('defaultPage');
  	  	    		setTimeout(function(){
  	  	    		try{
  	  	    			var defaultPageSplitted = defaultPage.split('-');
  	  	    			this$.openTab(getMegaMenuTranslation(defaultPageSplitted[0]), defaultPageSplitted[1] );
  	  	    			localStorage.setItem('defaultPage','');
  	  	    		}
  	  	    		catch(e){
  	  	    			localStorage.setItem('defaultPage','');
  	  	    		}
  	  	    		},5000);
  	    		}
		if(!isNullOrEmpty(tokenApiResponse) && !isNullOrEmpty(tokenApiResponse.Authorization) && !isNullOrEmpty(academylocationid)){
			Ext.Ajax.defaultHeaders = {
					Authorization: "Bearer " + tokenApiResponse.access_token,
					expires_in: tokenApiResponse.expires_in,
					access_token: tokenApiResponse.access_token,
					refresh_token: tokenApiResponse.refresh_token
			};
			var userInfo = Academia.model.authentication.UserInfoModel;

			userInfo.set("accessToken", tokenApiResponse.access_token);
			userInfo.set("refreshToken", tokenApiResponse.refresh_token);
			userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);

			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loginAccessLoadMainPanel();
			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadMultipleLangFilePerAL(academylocationid); //adding for coreERP only for hiding links by school/college
			/*setTimeout(function(){
				Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadDataAfterLogin(); 
			},2000);*/
			loadApisFunction();
		}
		var style = document.createElement('style');
		style.type = 'text/css';
		var fullWidth = window.innerWidth;
		//style.innerHTML = '.x-grid .x-header-text { margin-left: 494px !important; } .x-grid .x-header-text-container { left: 0 !important; }';4
		style.innerHTML = '.contentPanel .x-grid .x-header-text-container { width: '+fullWidth+'px !important;left: -245px !important; } .contentPanel .x-grid .x-header-text { margin-left: 110px !important; }';
		document.getElementsByTagName('head')[0].appendChild(style);
		var style2 = document.createElement('style');
        style2.type = 'text/css';
        style2.innerHTML='.centerAlignTitle.x-grid .x-header-text-container { width: inherit !important;;left: unset!important; text-align: left !important; }';
        document.getElementsByTagName('head')[0].appendChild(style2);
        var style3 = document.createElement('style');
        style3.type = 'text/css';
        style3.innerHTML='.parallelGridCenterAlignTitle.x-grid .x-header-text { margin-left: 145px !important; }';
        document.getElementsByTagName('head')[0].appendChild(style3);
        
       // var mainSearchBoxPos = (window.innerWidth - 540) / 2;
        //var style4 = document.createElement('style');
        //style4.type = 'text/css';
        //style4.innerHTML='.searchComboBoxPosCls { left: '+mainSearchBoxPos+'px !important; }';
        //document.getElementsByTagName('head')[0].appendChild(style4);
        
        var style5 = document.createElement('style');
        style5.type = 'text/css';
        style5.innerHTML='.centerAlignTitle.x-grid .x-header-text-container .x-header-text { margin-left: 0 !important; left: 0px !important;letter-spacing: 0px;font: var(--title-regular-font-style);color: var(--text-icon-color-primary); }';
        document.getElementsByTagName('head')[0].appendChild(style5);
        
		window.addEventListener('keydown', function(e) {
    		if(e.keyCode == 32 && e.target == document.body) {
    	    	e.preventDefault();
    	  	}
    	});
	},
	runAction:function(controllerName, actionName){
		var controller = this.getController(controllerName);
	},
	ctrls: []                              
});

Ext.Msg.on('show', function (msg) {
    msg.maxWidth=900;
    msg.setWidth(400);
    msg.center();
});



