/*
/ * @author prathamesh.sheth
 * 
 * This controller contains common method or common reference or common code 
 * which can be used by other controllers in this module 
 * by extending this controller.
 *    
 */
Ext.define('Academia.controller.admission.admissionCommon.AdmissionFormCommonController', {
    
	extend: 'Academia.controller.base.BaseController',

    alias: "widget.admissionformcommoncontroller",

    
    init: function(application) {
        //this.control({});
    	this.callParent(arguments);
    },        
    
    /**
     * This function is used for to create search criteria and return params object   
     */
    createSearchCriteria: function(container) {
        var params = new Object();

        if (container) {
            var txtReceiptNo = container.down('#txtReceiptNo');
            if (txtReceiptNo) {
                var txtReceiptNoValue = txtReceiptNo.getValue().trim();
                if (!isNullOrEmpty(txtReceiptNoValue)) {
                    params.receiptNo = txtReceiptNoValue;
                }
            }

            var txtTokenId = container.down('#txtTokenId');
            if (txtTokenId) {
                var txtTokenIdValue = txtTokenId.getValue().trim();
                if (!isNullOrEmpty(txtTokenIdValue)) {
                    params.token = txtTokenIdValue;
                }
            }

            var txtApplicationId = container.down('#txtApplicationId');
            if (txtApplicationId) {
                var txtApplicationIdValue = txtApplicationId.getValue().trim();
                if (!isNullOrEmpty(txtApplicationIdValue)) {
                    params.applicationId = txtApplicationIdValue;
                }
            }

            var txtApplicantName = container.down('#txtApplicantName');
            if (txtApplicantName) {
                var txtApplicantNameVaue = txtApplicantName.getValue().trim();
                if (!isNullOrEmpty(txtApplicantNameVaue)) {
                    params.applicantName = txtApplicantNameVaue;
                }
            }
        }

        return params;
    },

    /**
     * This function is used for to hide or show search button after entering values in search fields.   
     */
    hideShowSearchButton: function(searchField, newValue, grid) {
    	if(grid){
    		var isButtonDisable=true;
    		var searchButton = grid.down("#btnFindApplication");    		
    		var toolBars=grid.getDockedItems('toolbar[dock="top"]');
    		for(var toolBarCount=0;toolBarCount<toolBars.length;toolBarCount++){
    			for(var itemCount=0;itemCount<toolBars[toolBarCount].items.items.length; itemCount++){
        			var item=toolBars[toolBarCount].items.items[itemCount];
                    if(item.isXType('textfield') && !isNullOrEmpty(item.getValue())){    			
                    	isButtonDisable=false;
                    	break;
                    }		           	
    		    }   
    		}    		
    		if (isButtonDisable) {
                searchButton.setDisabled(true);
            } else {
                searchButton.setDisabled(false);
            }
    	}            	        
    },

    /**
     * This function is used for to assign Application Id to application after clicking on 'Assign Application Id' button.   
     */
    assignApplicationId: function(me, grid) {
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if (isNullOrEmpty(record.get("applicationId"))) {
            	if (!isNullOrEmpty(record.get("id"))) {	            
	                Ext.Ajax.request({
	                    type: 'rest',
	                    url: SERVERURL.ASSIGN_APPLICATION_ID, //URL-:rest/application/assignApplicationID													 
	                    method: 'POST',
	                    headers: {
	                        'Content-Type': 'application/json'
	                    },
	                    params: {
	                        applicationId: record.get("id")
	                    },
	                    success: function(form, action) {
	                        grid.getStore().reload();
	                        Ext.getBody().unmask();
	                        grid.getSelectionModel().deselectAll();
	                        showSuccessMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getAdmissionTranslation('ASSIGN_APPLICATION_ID_MSG')); //Application Id assigned successfully.
	                    }
	                });
	            }
	        } else {
	            showInfoMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getAdmissionTranslation('ASSIGNED_APPLICATION_ID')); //Application Id already assigned
	            Ext.getBody().unmask();
	        }   
        } else {
        	showWarningMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        	Ext.getBody().unmask();
        }
    },
    
    /**
     * This function is used for to show make payment form after clicking on 'Make Payment' button.
     * first Calls the server and checks if payment is done or no
     * if payment is not done, Then opens the payment window.
     * feeStageName hardcoded as per the inputs from Serosoft team
     * @author Akshay.Kalbhor
     */
    showMakePaymentWindow: function(me, grid, window, itemIdValue) {
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if(record.get('totalFee') > 0) {
	            var url = SERVERURL.CHECK_FOR_PAYMENT;
	            url = url.concat('?applicationId='+record.get('id'));
	            var feeStageName = record.get("feeStage");
	           /* if(itemIdValue === 'assignApplicationMakePayment'|| itemIdValue === 'applicationFeeMakePayment') {
	            	feeStageName = 'Application form sale';
	              } else if (itemIdValue === 'submissionFeeMakePayment') {
	            	feeStageName = 'Application submission';
	              } else if (itemIdValue === 'applicationFeeMakePayment') {
	            	feeStageName ='Selection process';
	              }*/
	            
	            url = url.concat('&feeStageName='+feeStageName);
	            Ext.Ajax.request({
	                type: 'rest',
	                url: url,											 
	                method: 'GET',
	                async: true,
	                params: null,
	                //jsonData: Ext.encode(formValues),
	                headers: {
	                    'Content-Type': 'application/json'
	                },
	                success: function(response, action) {
	                	var responseObj = Ext.decode(response.responseText);
			  			if(!responseObj) {
		  		            if (!isEmpty(record)) {
		  		                if (!window) {
		  		                    window = Ext.widget('makepaymentwin', { // Equivalent to Ext.create('widget.panel')
		  		                        itemId: itemIdValue
		  		                    });
		  		                }
		  		                window.show();
		  		                var form = window.down('form');
		  		                
		  		                var currency = form.getForm().findField('currency')
		  		                var academyLocationId= record.data.academyLocationId;
		  		                var feeId=record.data.feeId;
		  		                currency.getStore().getProxy().extraParams = {
		  		                	academyLocationId : academyLocationId,
		  		                	feeId : feeId,
		  						};
		  		                currency.getStore().load();
		  		                form.loadRecord(record);
		  		                
		  		                var stageNameField = form.down('hidden[name=stageName]');
		  		                var feePlanTypeField = form.down('hidden[name=feePlanType]');
		  		                if(itemIdValue === 'assignApplicationMakePayment'|| itemIdValue === 'applicationFeeMakePayment') {
		  		                	//stageNameField.setValue('Application form sale');
		  		                	feePlanTypeField.setValue('Application');
		  		                } else if (itemIdValue === 'submissionFeeMakePayment') {
		  		                	//stageNameField.setValue('Application submission');
		  		                	feePlanTypeField.setValue('Application');
		  		                } else if (itemIdValue === 'applicationFeeMakePayment') {
		  		                	//stageNameField.setValue('Selection process');
		  		                	feePlanTypeField.setValue('Program');
		  		                }
		  		                stageNameField.setValue(feeStageName);
		  		                var billTypeCombo = form.down('customcombobox#billType');
		  		                billTypeCombo.setValue('P_AND_C_FEE');
		  		                billTypeCombo.setEditable(false);
		  		                billTypeCombo.setReadOnly(true);
		  		                
		  		                var recieptFormCombo = form.down('nestedJsonCombo#receiptForm');
		  		                recieptFormCombo.setValue('APPLICANT');
		  		                recieptFormCombo.setEditable(false);
		  		                recieptFormCombo.setReadOnly(true);
		  		                
		  		                var amountField = form.down('numberfield#amount');
		  		                var instrumentAmountField = form.down('numberfield#instrumentAmount');
		  		                amountField.setValue(record.get('totalFee'));
		  		                instrumentAmountField.setValue(record.get('totalFee'));
		  		                amountField.setEditable(false);
		  		                instrumentAmountField.setEditable(false);
		  		                
		  		                var studentField = form.down('textfield#student');
		  		                studentField.setValue(record.get('applicantName'));
		  		                studentField.setReadOnly(true);
		  		                
		  		                var currencyField = form.down('nestedJsonCombo#receivingCurrency');
		  		              //  currencyField.setValue(record.raw.currencyName);
		  		              var crStore = currencyField.getStore();
		  		            setTimeout(function(){
		  		              crStore.load({
		  		            	  callback: function(records, operation, success) {
		  		            		  for(var i in records){
		  		            			  if (record.raw.currencyId == records[i].data.id) {
		  		            				  currencyField.setValue(records[i].data.id);
		  		            			  }
		  		            		  }
		  		            	  }
                    		});
		  		          },100);
		  		            }
			  			}
	                },
	                failure: function(form, action) {
                    	var data = Ext.decode(form.responseText);
                    	if(data[0].key == 'PAYMENT_ALREADY_DONE'){
                    		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PAYMENT_ALREADY_DONE')); 
                    	}
                    }
	            });
            } else {
            	//TODO: Call to be integrated
            	this.saveMakePayment(record);
            	showWarningMessage(getAdmissionTranslation('COLLECT_PAYMENT'), getAdmissionTranslation('CANNOT_MAKE_PAYMENT'));
            }
        } else {
        	showWarningMessage(getAdmissionTranslation('COLLECT_PAYMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /**
     * This function is used for to cancel make payment form window after clicking on cancel button on Make Payment window.
     *    
     */
    cancelMakePaymentWindow: function(window) {
        window.close();
    },

    /**
     * This function is used for to save make payment form after clicking on save button on Make Payment window.
     *    
     */
    saveMakePayment: function(record) {
    	var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
  		serverUrl = serverUrl.concat('?applicationId='+record.get('id'));
  		this.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){
  		});
    },

    /**
     * This function is used for to enable or disable menu items after clicking on 'More Operations' menu.
     *    
     */
    EnableDisableMenuItems: function(me, grid, cmb, menu) {
        var assignApplicationIdMenuItem = cmb.down('#assignApplicationId');
        var makePaymentMenuItem = cmb.down('#makePayment');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
                var receiptNo = record.get('receiptNo');
                var applicationId = record.get('applicationId');
                if (isNullOrEmpty(receiptNo)) {
                    makePaymentMenuItem.setDisabled(false);
                } else {
                    makePaymentMenuItem.setDisabled(true);
                }
                if (isNullOrEmpty(applicationId)) {
                    assignApplicationIdMenuItem.setDisabled(false);
                } else {
                    assignApplicationIdMenuItem.setDisabled(true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /**
     * This function is used for to expand row body after clicking on Row Expander.
     *    
     */
    ExpandRowBody: function(me, grid, record, expandRow, plugInName) {
        var expander = grid.getPlugin(plugInName);                                   
        var recordId = record.get('id');
        var stageName=grid.stageName;
        if((record.get('currentStatus')=="FORM_SALE_TOKEN_GENERATED")){
        	stageName='Application form sale';
        }else if((record.get('currentStatus')=="DIRECT_SUBMISSION_TOKEN_GENERATED")){
        	stageName='Application submission';
        }
        if (!isNullOrEmpty(recordId)) {        	
        	var submitURL=SERVERURL.FEES_PAYMENTS_APPLICATION_FEE_GRID_API; //URL -:'rest/feePlan/findAllFeeAdmissionListingDetails'
            if(!isNullOrEmpty(submitURL)){
    			submitURL=submitURL.concat("?stageName="+stageName+"&feePlanType="+grid.feePlanType+"&applicationId="+recordId);            			
            }
            Ext.Ajax.request({            	
                url: submitURL,
                method: 'GET',
                success: function(result, request) {
                    var jsonArrayData = eval("(" + result.responseText + ")");
                    var objectArray = new Array();
                    if (jsonArrayData.rows.length > 0) {
                    	for (var count = 0; count < jsonArrayData.rows.length; count++) {
                            var recordData = jsonArrayData.rows[count];
                            var object = new Object();
                            if (!isEmpty(recordData)) {
                                object.academy = recordData.academyName;
                                object.location = recordData.locationName;
                                object.program = recordData.programNameToBePrint;
                                object.batch = recordData.batchName;
                                object.seatType = recordData.seatName;
                                object.feeAmount = recordData.feeAmount;
                                object.feePlan = recordData.feePlanName;
                                object.receiptNo = recordData.receiptNo;
                                objectArray.push(object);
                            }
                        }
                        expandRow.style.height = '150px';
                        expander.rowBodyTpl.overwrite(expandRow, objectArray);
                    } else {
                        expander.rowBodyTpl.applyTemplate('<div>No Record To display</div>');
                    }
                    grid.doLayout();
                },
                failure: function(result, request) {
                    showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                    return false;
                }
            });
        }
        return true;
    },

    /**
     * This function is used for to search result after clicking on search button in Applicant Form.
     *    
     */
    onSearchButtonClick: function(me, searchWindow, applicantForm, itemIdValue) {
        var searchResult = me.getSearchResult(me, applicantForm);
        if (isEmpty(searchResult)) {
            showSuccessMessage(getCommonTranslation('SUCCESS'), getAdmissionTranslation('SEARCH_RESULT_MSG')); //No search result found
        } else {
            if (!searchWindow) {
                searchWindow = Ext.widget('searchapplicantwindow', { // Equivalent to Ext.create('widget.panel')
                    itemId: itemIdValue
                });
            }
            searchWindow.show();
            me.loadDataInSearchWindow(me, searchResult, applicantForm);
        }
    },

    /**
     * This function is used for to get search result and return search result   
     */
    getSearchResult: function(me, applicantForm) {
        var searchResult = null;
        if (applicantForm) {
            var cmbApplicationType = applicantForm.down('#cmbApplicationType');
            var selectedApplicationType = cmbApplicationType.getValue();
            if (!isNullOrEmpty(selectedApplicationType)) {
                if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                    var searchCriteria = me.getSearchCriteria(me, applicantForm, selectedApplicationType);
                    searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
                } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                    var searchCriteria = me.getSearchCriteria(me, applicantForm, selectedApplicationType);
                    searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
                } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                    var searchCriteria = me.getSearchCriteria(me, applicantForm, selectedApplicationType);
                    searchResult = me.sendSearchRequest(me, searchCriteria, selectedApplicationType);
                }
            }
        }
        return searchResult;
    },

    /**
     * This function is used for to create search criteria    
     */
    getSearchCriteria: function(me, applicantForm, applicantFormType) {
        var searchObject = new Object();

        var enqId = applicantForm.down('#enqId');
        //console.log('xtype :', applicantForm.down('#enqId').getXType());
        var enqName = applicantForm.down('#enqName');
        var enqContactNo = applicantForm.down('#enqContactNo');
        var enqEmailId = applicantForm.down('#enqEmailId');
        var appId = applicantForm.down('#appId');
        var appEmailId = applicantForm.down('#appEmailId');
        var idTypeCombo = applicantForm.down('#idTypeCombo');
        var nationalId = applicantForm.down('#nationalId');
        var studentId = applicantForm.down('#studentId');
        var studentCodeId = applicantForm.down('#admStudentIAppNameItemId');
        var admNationalIDItemId = applicantForm.down('#admNationalIDItemId');
        var admContactNoItemId = applicantForm.down('#admContactNoItemId');
        var admSTDEmailIdItemId = applicantForm.down('#admSTDEmailIdItemId');

        if (applicantFormType === 'ENQUIRED_EARLIER') {
        	if(enqId.getXType()=="customcombobox"){
        		  searchObject.enquirerID = (!isNullOrEmpty(enqId.getValue())) ? enqId.getRawValue() : "";
                  enqId.reset();
        	}
        	else{
        		 searchObject.enquirerID = (!isNullOrEmpty(enqId.getValue())) ? enqId.getValue() : "";
                 enqId.reset();
        	}
        	if(enqName.getXType()=="customcombobox"){
        		if(!isNullOrEmpty(enqName)){
        			if(!isNullOrEmpty(enqName.valueModels)){
            			if(enqName.valueModels.length!=0){
	        			  searchObject.enquirerName = (!isNullOrEmpty(enqName.valueModels[0].get('value'))) ? enqName.valueModels[0].get('value') : "";
	            		  enqName.reset();
            			}
        			}
        		}
	      	}
	      	else{
	      		 searchObject.enquirerName = (!isNullOrEmpty(enqName.getValue())) ? enqName.getValue() : "";
	      		 enqName.reset();
	      	}
            searchObject.enquirerContactNo = (!isNullOrEmpty(enqContactNo.getValue())) ? enqContactNo.getValue() : "";
            enqContactNo.reset();
            searchObject.enquirerEmailId = (!isNullOrEmpty(enqEmailId.getValue())) ? enqEmailId.getValue() : "";
            enqEmailId.reset();
        } else if (applicantFormType === 'APPLIED_EARLIER') {
            searchObject.applicationId = (!isNullOrEmpty(appId.getValue())) ? appId.getValue() : "";
            appId.reset();
            searchObject.emailId = (!isNullOrEmpty(appEmailId.getValue())) ? appEmailId.getValue() : "";
            appEmailId.reset();
            searchObject.idType = (!isNullOrEmpty(idTypeCombo.getValue())) ? idTypeCombo.getValue() : "";
            idTypeCombo.reset();
            searchObject.nationalId = (!isNullOrEmpty(nationalId.getValue())) ? nationalId.getValue() : "";
            nationalId.reset();
            searchObject.isAppliedEarlierScreen=true;
        } else if (applicantFormType === 'EXISTING_STUDENT') {
            searchObject.studentId  = (!isNullOrEmpty(studentCodeId.getValue())) ? studentCodeId.getValue() : "";
            searchObject.nationalId = (!isNullOrEmpty(admNationalIDItemId.getValue())) ? admNationalIDItemId.getValue() : "";
            searchObject.extContactNo = (!isNullOrEmpty(admContactNoItemId.getValue())) ? admContactNoItemId.getValue() : "";
            searchObject.extEmailId = (!isNullOrEmpty(admSTDEmailIdItemId.getValue())) ? admSTDEmailIdItemId.getValue() : "";
            studentCodeId.reset();
        }

        return searchObject;
    },

    
    /**
     * This function is used for to send search request
     *     
     */
    sendSearchRequest: function(me, searchCriteria, applicantFormType) {
        var searchResult = null;
        if (!isEmpty(searchCriteria) && !isNullOrEmpty(applicantFormType)) {
            var url = "",
                method = "",
                jsonFormatData = "";
            if (applicantFormType === 'ENQUIRED_EARLIER') {
                url = SERVERURL.APPLICATION_FORM_SALE_SEARCH_ENQUIRY_STUDENT_ACCESSIBLE_AL+"?academyLocationId="+this.getCurrentAcademyLocation(); //URL-:rest/enquiryStudent/enquiryStudentDetails
                method = 'POST';
                jsonFormatData = Ext.encode(searchCriteria);
            } else if (applicantFormType === 'APPLIED_EARLIER') {
                url = SERVERURL.APPLICATION_FORM_SALE_SEARCH_APPLIED_STUDENT; //URL-:rest/application/findByApplicationIdAndName
                method = 'GET';
            } else if (applicantFormType === 'EXISTING_STUDENT') {
                url = SERVERURL.APPLICATION_FORM_SALE_SEARCH_EXISTING_STUDENT_FOR_APPLICANT; //URL-:rest/student/findAllByStudentCode    
                method = 'GET';
            }

            Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: method,
                async: false,
                headers: {
                    'Content-Type': 'application/json'
                },
                jsonData: (method === 'POST') ? jsonFormatData : "",
                params: (method === 'GET') ? searchCriteria : null,
                success: function(response, form) {
                    searchResult = eval("(" + response.responseText + ")");
                }
            });
        }
        return searchResult;
    },
    
    /**
     * This function is used for to load search result data in search window
     *     
     */
    loadDataInSearchWindow: function(me, searchResult, applicantForm) {
        if (applicantForm) {
            var cmbApplicationType = applicantForm.down('#cmbApplicationType');
            var selectedApplicationType = cmbApplicationType.getValue();
            if (!isNullOrEmpty(selectedApplicationType)) {
                var columns = null,
                    store = null;
                if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                    var columnNames = [getAdmissionTranslation('ENQUIRY_ID'), getAdmissionTranslation('STUDENT_NAME'), getAdmissionTranslation('CONTACT_NO'), getAdmissionTranslation('EMAIL_ID')];
                    var columnDataIndexes = ['code', 'name', 'mobileNumber', 'emailId'];
                    columns = me.getSearchGridColumns(columnNames, columnDataIndexes);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                    var columnNames = [getAdmissionTranslation('APPLICATION_ID'), getAdmissionTranslation('APPLICANT_NAME'), getAdmissionTranslation('ID_NUMBER'), getAdmissionTranslation('EMAIL_ID')];
                    var columnDataIndexes = ['code', 'name', 'nationalID', 'emailId'];
                    columns = me.getSearchGridColumns(columnNames, columnDataIndexes);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                    var columnNames = [getAdmissionTranslation('STUDENT_ID'), getAdmissionTranslation('STUDENT_NAME'), getAdmissionTranslation('CONTACT_NO'), getAdmissionTranslation('EMAIL_ID')];
                    var columnDataIndexes = ['code', 'name', 'number', 'email'];
                    columns = me.getSearchGridColumns(columnNames, columnDataIndexes);
                    store = me.getSearchGridData(me, selectedApplicationType, searchResult);
                }
                if (!isEmpty(columns)) {
                    var grid = me.getSearchWindow().down('grid');
                    grid.reconfigure(store, columns);
                    if(grid.getStore().data.length==1){
                    	grid.getSelectionModel().select(grid.getStore().getAt(0));
                    }else{
                    	grid.getSelectionModel().deselectAll(true);
                    }
                    //grid.down('pagingtoolbar').bind(store);
                    //grid.down('pagingtoolbar').totalCount = store.data.length;
                }
            }
        }
    },

    /**
     * This function is used to create search grid columns
     *     
     */
    getSearchGridColumns: function(columnNames, columnDataIndexes) {
        var columns = new Array();
        for (var count = 0; count < columnNames.length && count < columnDataIndexes.length; count++) {
            columns.push({
                header: columnNames[count],
                dataIndex: columnDataIndexes[count],
                flex: .2
            });
        }
        return columns;
    },

    /**
     * This function is used for to arrange search result data for to display in search grid
     *     
     */
    getSearchGridData: function(me, selectedApplicationType, searchResult) {
        var store = Ext.create('Academia.store.admission.applicationFormSale.SearchResultGridStore');
        var records = [];
        var this$=this;
        Ext.each(searchResult, function(data) {
            if (!isEmpty(data)) {
                if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                	var enquiryStatus;
                	var admissionRecords = [];
                	for(var i = 0; i<data.admissionEnquiryDetails.length;i++) {
                        
                	if(data.admissionEnquiryDetails[i].status=='O'){
                		enquiryStatus = getAdmissionTranslation('OPEN_STATUS');
                	}else{
                		enquiryStatus = getAdmissionTranslation('CLOSED_STATUS');
                	}
                	admissionRecords.push({
                		academyLocation: data.admissionEnquiryDetails[i].academyLocation.value,
                        program: data.admissionEnquiryDetails[i].program.value,
                        batch: data.admissionEnquiryDetails[i].batch.value,
                        programBatchSeatConfiguration:data.admissionEnquiryDetails[i].programBatchSeatConfiguration.value,
                        status: enquiryStatus,
                        admissionEnquiryDetails:data.admissionEnquiryDetails[i]
                	});
                	records.push({
                        //id: data.id,
                        saleRefPrimaryId:data.id,
                        saleRefId: (!isEmpty(data.enquiry)) ? data.enquiry.code : "",
                        saleRefType: selectedApplicationType,
                        version: data.version,
                        salutation: (!isEmpty(data.salutation)) ? data.salutation.id : "",
                        firstName: data.studentFirstName,
                        middleName: data.studentMiddleName,
                        lastName: data.studentLastName,
                        shortName: data.studentFirstName +  (!isNullOrEmpty(data.studentMiddleName)?" " +data.studentMiddleName:"") + " " + (!isNullOrEmpty(data.studentLastName)?" " +data.studentLastName:""),
                        firstNameOtherLanguage:data.studentFirstNameOtherLanguage,
                        lastNameOtherLanguage:data.studentLastNameOtherLanguage,
                        middleNameOtherLanguage:data.studentMiddleNameOtherLanguage,
                        shortNameOtherLanguage:data.studentFirstNameOtherLanguage,
                        printNameOtherLanguage: (!isNullOrEmpty(data.studentFirstNameOtherLanguage)) ? data.studentFirstNameOtherLanguage + (!isNullOrEmpty(data.studentMiddleNameOtherLanguage)?" " +data.studentMiddleNameOtherLanguage:"") + " " + (!isNullOrEmpty(data.studentLastNameOtherLanguage)?" " +data.studentLastNameOtherLanguage:"") : "",
                        birthDate: data.studentDateOfBirth,
                        gender: data.gender,
                        genderCSM:data.genderCSM,
                        cellNo: data.cellNo,
                        bloodGroup:data.bloodGroup,
                        phoneAreaCode: data.phoneAreaCode,
                        phoneNo: data.phoneNo,
                        castCategory:!isNullOrEmpty(data.reservationCategoryId) ? data.reservationCategoryId : "",
                        nationality:!isNullOrEmpty(data.nationality) ? data.nationality.id : "",
                        phoneCountryCode:data.phoneCountryCode,
                        primaryEmailId: (!isNullOrEmpty(data.primaryEmailId)) ? data.primaryEmailId : data.alternateEmailId,
                        code: (!isEmpty(data.enquiry)) ? data.enquiry.code : "",
                        name: data.studentFirstName +  (!isNullOrEmpty(data.studentMiddleName)?" " +data.studentMiddleName:"") + " " + (!isNullOrEmpty(data.studentLastName)?" " +data.studentLastName:""),
                        printName: data.studentFirstName + (!isNullOrEmpty(data.studentMiddleName)?" " +data.studentMiddleName:"") + " " + (!isNullOrEmpty(data.studentLastName)?" " +data.studentLastName:""),
                        number: data.cellNo,
                        email: (!isNullOrEmpty(data.primaryEmailId)) ? data.primaryEmailId : data.alternateEmailId,
                        emailId: (!isNullOrEmpty(data.emailId)) ? data.emailId : data.alternateEmailId,
                        mobileNumber:   data.mobileNumber ,
                        mobileCountryCode:data.mobileCountryCode,
                        alternateMobileNo:data.alternateMobileNo,
                        alternateMobileCountryCode:data.alternateMobileCountryCode,
                        emergencyFirstName:data.emergencyFirstName,
                        emergencyLastName:data.emergencyLastName,
                        emergencyMobileCountryCode:data.emergencyMobileCountryCode,
                        emergencyMobileNumber:data.emergencyMobileNumber,
                        currentStatus:data.currentStatus,		
                        country:(!isEmpty(data.country)) ? data.country.id : "",
                        academyLocation: data.admissionEnquiryDetails[i].academyLocation.value,
                        program: data.admissionEnquiryDetails[i].program.value,
                        batch: data.admissionEnquiryDetails[i].batch.value,
                        programBatchSeatConfiguration:data.admissionEnquiryDetails[i].programBatchSeatConfiguration.value,
                        status: enquiryStatus,
                        admissionEnquiryDetails:data.admissionEnquiryDetails[i],
                        fatherSalution:data.fatherSalutation,
                        fatherFirstName:data.fatherFirstName,
                        fatherMiddleName:data.fatherMiddleName,
                        fatherLastName:data.fatherLastName,
                        fatherEmployed:data.fatherEmployed,
                        fatherEmailId:data.fatherEmailId,
                        fatherPhoneCountryCode:data.fatherPhoneCountryCode,
                        fatherPhoneNo:data.fatherPhoneNo,
                        motherSalutation:data.motherSalutation,
                        motherFirstName:data.motherFirstName,
                        motherMiddleName:data.motherMiddleName,
                        motherLastName:data.motherLastName,
                        motherEmployed:data.motherEmployed,
                        sibilingUser1:data.sibilingUser1,
                        sibilingUser2:data.sibilingUser2,
                        sibilingUser3:data.sibilingUser3,
                        userByFatherEmployeeId:data.userByFatherEmployeeId,
                        userByMotherEmployeeId:data.userByMotherEmployeeId,
                        whetherSiblingStudying:data.whetherSiblingStudying,
                        enquirerEmailId: data.enquirerEmailId,
                        enquirerMobileCountryCode: data.enquirerMobileCountryCode,
                        enquirerMobileNo: data.enquirerMobileNo,
                        enquirerFirstName: data.enquirerFirstName,
                        enquirerMiddleName: data.enquirerMiddleName,
                        enquirerLastName: data.enquirerLastName,
                        enquirerSalutation:data.enquirerSalutation,
                        enquiryOwnerId: data.enquiryOwnerId,
                        wsenquiryMultipleMode:data.wsenquiryMultipleMode,
                        campaignNew:data.campaignNewId,
                        campaignSchool:data.campaignSchoolId,
                        enquirySource:data.enquirySourceId,
                        whetherCompanySponsored:data.whetherCompanySponsored,
                        isLearnerSACitizen:data.isLearnerSACitizen,
                        nationalID:data.nationalId,
                        campaignNew:data.campaignNewId,
                        campaignSchool:data.campaignSchoolId,
                        enquirySource:data.enquirySourceId,
                        whetherCompanySponsored:data.whetherCompanySponsored,
                        externalSysRefOne :data.externalSysRefOne,
                        externalSysRefTwo :data.externalSysRefTwo,
                        externalSysRefThree :data.externalSysRefThree,
                        applicantSchoolPriority:data.schoolPriority,
                        admissionRecords :admissionRecords,
                        linkStudentId :data.linkStudentId,
                        haveYouStudiedAtUWC :data.haveYouStudiedAtUWC,
                        areYouRegisteredAtOtherSAU :data.areYouRegisteredAtOtherSAU,
                        studentNoAtUWC :data.studentNoAtUWC,
                        studentNoAtOtherSAU :data.studentNoAtOtherSAU
                       
                    });
                  }
                } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                    var studentAddress = me.getStudentAddress(data);
                    var recordObject = new Object();
                    if (!isNullOrEmpty(data.personId)) {                		
                		recordObject.id= data.id;
                		recordObject.saleRefPrimaryId=data.id;
                		recordObject.code= (!isNullOrEmpty(data.code)) ? data.code : "";        
                		recordObject.studentCode= (!isNullOrEmpty(data.studentCode)) ? data.studentCode : "";         
                		recordObject.saleRefId= (!isNullOrEmpty(data.code)) ? data.code : "";
                		recordObject.existingStudentId=data.id;
                        recordObject.saleRefType= selectedApplicationType;
                        recordObject.studentCode= (!isNullOrEmpty(data.studentCode)) ? data.studentCode : ""; 
                        recordObject.studentName= (!isNullOrEmpty(data.studentName)) ? data.studentName : ""; 
                        recordObject.nationalId= (!isNullOrEmpty(data.nationalId)) ? data.nationalId : ""; 
                        recordObject.admissionID= (!isNullOrEmpty(data.admissionID)) ? data.admissionID : ""; 
                        recordObject.academyLocationName= (!isNullOrEmpty(data.academyLocationName)) ? data.academyLocationName : ""; 
                        recordObject.programName= (!isNullOrEmpty(data.programName)) ? data.programName : "";
                        recordObject.batch= (!isNullOrEmpty(data.batch)) ? data.batch : ""; 
                        recordObject.seatType= (!isNullOrEmpty(data.seatType)) ? data.seatType : ""; 
                        recordObject.admissionStatus= (!isNullOrEmpty(data.admissionStatus)) ? ((data.admissionStatus=="true")?"Active":"Inactive") : ""; 
                        recordObject.fatherSalution=data.fatherSalutation;
                        recordObject.fatherFirstName=data.fatherFirstName;
                        recordObject.fatherMiddleName=data.fatherMiddleName;
                        recordObject.fatherLastName=data.fatherLastName;
                        recordObject.fatherEmployed=data.fatherEmployed;
                        recordObject.fatherEmailId=data.fatherEmailId;
                        recordObject.fatherPhoneCountryCode=data.fatherMobileCountryCode;
                        recordObject.fatherPhoneNo=data.fatherMobileNumber;
                        recordObject.userByFatherEmployeeId=data.userByFatherEmployeeId;
                        //this$.copyPersonalData(data,recordObject);
                	}                                        
                    records.push(recordObject);                    
                } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                    var recordObject = new Object();
                    recordObject.id= data.id;
                    recordObject.refApplicationId= data.id;
            		recordObject.saleRefPrimaryId=data.id;
                    recordObject.saleRefId = (!isNullOrEmpty(data.code)) ? data.code : "";
                    recordObject.saleRefType = selectedApplicationType;
                    recordObject.version = data.version;
                    
                    recordObject.primaryEmailId = data.primaryEmailId;
                    recordObject.code = (!isNullOrEmpty(data.code)) ? data.code : "";
                    recordObject.currentStatus=data.currentStatus;
                    recordObject.emailId =   recordObject.email ;
                    recordObject.mobileNumber =   recordObject.cellNo ;
                    if (!isNullOrEmpty(data.person)) {
                        this$.copyPersonalDataForAppliedEarlier(data,recordObject);
                    }
                    records.push(recordObject);
                }
            }
        });
        store.loadData(records);
        return store;
    },
    
    copyPersonalData:function(fromObject,toObject){
		toObject.firstName = fromObject.person.firstName;
		toObject.middleName = fromObject.person.middleName;
		toObject.lastName = fromObject.person.lastName;
		toObject.shortName = fromObject.person.shortName;
		toObject.printName = fromObject.person.printName;
		toObject.birthDate = fromObject.person.birthDate;
		toObject.gender = fromObject.person.gender;
		toObject.category= fromObject.person.category;
		toObject.castCategory= fromObject.person.castCategory;
		toObject.country= fromObject.person.country;                        
		toObject.nationality= fromObject.person.nationality;
		toObject.religion= fromObject.person.religion;
		toObject.maritalStatus= fromObject.person.maritalStatus;                        
		toObject.personalIncome= fromObject.person.personalIncome;                                                                                                
		toObject.bankDetail= fromObject.person.bankDetail;
		toObject.bloodGroup= fromObject.person.bloodGroup;
		toObject.name = fromObject.person.firstName + (!isNullOrEmpty(fromObject.person.middleName)?" " +fromObject.person.middleName:"") +(!isNullOrEmpty(fromObject.person.lastName)?" " +fromObject.person.lastName:"");
           
    },

    /**
     * This function is used for to display person address 
     *     
     */
    getStudentAddress: function(data) {
        var studentAddress = new Object();
        if (!isEmpty(data) && !isEmpty(data.person) && data.person.personAddresses.length > 0) {
            if (!isEmpty(data.person.personAddresses[0].address)) {
                studentAddress.cellNo = data.person.personAddresses[0].address.cellNo;
                studentAddress.phoneAreaCode = data.person.personAddresses[0].address.phoneAreaCode;
                studentAddress.phoneNo = data.person.personAddresses[0].address.phoneNo;
                studentAddress.primaryEmailId = data.person.personAddresses[0].address.primaryEmailId;
                studentAddress.alternateEmailId = data.person.personAddresses[0].address.alternateEmailId;
                studentAddress.emergencyFirstNameId = data.person.personAddresses[0].address.emergencyFirstNameId;
                studentAddress.emergencyLastNameId = data.person.personAddresses[0].address.emergencyLastNameId;
                studentAddress.emergencyCellCountryCode = data.person.personAddresses[0].address.emergencyCellCountryCode;
                studentAddress.emergencyMobileNumberId = data.person.personAddresses[0].address.emergencyMobileNumberId;
                
                
            }
        }
        return studentAddress;
    },

    /**
     * method to show and hide search fields on the basis of search criteria.				     
     * 
     * @param {String} selected search method
     * 
     */
    showHideSearchCriteriaFields: function(selectedApplicationType, applicantform) {
        if (applicantform) {
            var searchComponent = applicantform.down("#searchComponent");
         	var enquiryPanel =  searchComponent.down('#enquiryPanel');
        	var applicantPanel =searchComponent.down('#applicantPanel');
        	var studentId=	searchComponent.down('#studentId');
        	var searchBtn =searchComponent.down('#searchButton');
        	searchComponent.down('#contactFieldSet');
        	searchComponent.down('#personalDetailFieldset');
        	this.resetFormFields(applicantform);
                        if (selectedApplicationType === 'ENQUIRED_EARLIER' ) {
                        	enquiryPanel.setVisible(true);
                        	applicantPanel.setVisible(false);
                        	studentId.setVisible(false);
                        } else if (selectedApplicationType === 'APPLIED_EARLIER' ) {
                        	enquiryPanel.setVisible(false);
                        	applicantPanel.setVisible(true);
                        	studentId.setVisible(false);
                        } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                        	enquiryPanel.setVisible(false);
                        	applicantPanel.setVisible(false);
                        	studentId.setVisible(true);
                        } else {
                        	enquiryPanel.setVisible(false);
                        	applicantPanel.setVisible(false);
                        	studentId.setVisible(false);
                        }
                    if (selectedApplicationType === 'FRESH_APPLICANT') {
                    	searchBtn.setVisible(false);
                    } else {
                    	searchBtn.setVisible(true);
                    }
        }
    },
    
    /**
     * This method is used to reset applicant form fields except applicant type
     * @param form
     */
    resetFormFields : function(form){
    	var fields = form.getForm().getFields();
		for(var i = 0;i< fields.length; i++){
			if(fields.items[i].itemId !== 'cmbApplicationType'){
				fields.items[i].reset();
			}
			
		}
    },
    
    /**
     * This function is used for to display type Id
     *     
     */
    displayTypeId:function(applicantForm,selectedApplicationType){
    	if(applicantForm){
    		var dispalyCode=applicantForm.down('#dispalyCode');
            if(selectedApplicationType === 'ENQUIRED_EARLIER'){
            	dispalyCode.setFieldLabel(getAdmissionTranslation('ENQUIRY_ID'));
            }else if(selectedApplicationType === 'APPLIED_EARLIER'){
            	dispalyCode.setFieldLabel(getAdmissionTranslation('APPLICATION_ID'));
            }else if(selectedApplicationType === 'EXISTING_STUDENT'){
            	dispalyCode.setFieldLabel(getAdmissionTranslation('STUDENT_ID'));
            }                        
        	if(selectedApplicationType !== 'FRESH_APPLICANT'){
        		dispalyCode.setVisible(true);
        	}else{
        		dispalyCode.setVisible(false);
        	}
    	}    	
    },

    /**
     * This function is used for to load selected search grid record data in form
     *     
     */
    onSearchImportButtonClick: function(me, searchWindow, applicantForm) {
        if (searchWindow) {
            var grid = searchWindow.down('grid');
            if (grid.getSelectionModel().getCount() > 0) {
                var selectedRecord = grid.getSelectionModel().getSelection()[0];
                if (!isEmpty(selectedRecord.data)) {
                	Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
                	if (applicantForm) {  
                		if(!isNullOrEmpty(selectedRecord.data.birthDate))
                			selectedRecord.data.birthDate = new Date(selectedRecord.data.birthDate);
                		var model = new Academia.model.admission.applicationFormSale.ApplicationFormModel(selectedRecord.data);                        
                		applicantForm.loadRecord(model);
                		searchWindow.close();                        
                		var dispalyCode=applicantForm.down('#dispalyCode');
                		applicantForm.down('#applicationDate').setValue(dateFormatRender(new Date()));
                		if(dispalyCode && !isNullOrEmpty(selectedRecord.data.code)){
                			dispalyCode.setVisible(true);
                		}else{
                			dispalyCode.setVisible(false);
                		}
                		
                		var tempArr = [];
                		if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                			tempArr.push({
                				firstName:selectedRecord.data.enquirerFirstName,
                				lastName:(!isNullOrEmpty(selectedRecord.data.enquirerLastName)?selectedRecord.data.enquirerLastName:null),
                				middleName:(!isNullOrEmpty(selectedRecord.data.enquirerMiddleName)?selectedRecord.data.enquirerMiddleName:null),
                				isEmp:selectedRecord.data.fatherEmployed,
                				//userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId.id:null), 
                				relationShipType:'FATHER', isSibling:false,
                				enquirerEmailId:selectedRecord.data.enquirerEmailId,
                				enquirerMobileNo:selectedRecord.data.enquirerMobileNo,
                				enquirerMobileCountryCode:selectedRecord.data.enquirerMobileCountryCode,
                				enquirerSalutationID:selectedRecord.data.enquirerSalutation.id
                			});
                		} else {
                			if(!isNullOrEmpty(selectedRecord.data.fatherFirstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.fatherFirstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.fatherLastName)?selectedRecord.data.fatherLastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.fatherMiddleName)?selectedRecord.data.fatherMiddleName:null),
                    				isEmp:selectedRecord.data.fatherEmployed,
                    				userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId.id:null),
                    				enquirerEmailId:selectedRecord.data.enquirerEmailId,
                    				enquirerMobileNo:selectedRecord.data.enquirerMobileNo,
                    				enquirerMobileCountryCode:selectedRecord.data.enquirerMobileCountryCode,
                    				relationShipType:'FATHER', isSibling:false
                    				});
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.motherFirstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.motherFirstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.motherLastName)?selectedRecord.data.motherLastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.motherMiddleName)?selectedRecord.data.motherMiddleName:null),
                    				isEmp:selectedRecord.data.motherEmployed,
                    				userId:((selectedRecord.data.motherEmployed)?selectedRecord.data.userByMotherEmployeeId.id:null), 
                    				relationShipType:'MOTHER', isSibling:false
                    				});
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser1) && !isNullOrEmpty(selectedRecord.data.sibilingUser1.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser1.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser1.lastName)?selectedRecord.data.sibilingUser1.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser1.middleName)?selectedRecord.data.sibilingUser1.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying, 
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser1.id:null),
                    				relationShipType:'BROTHER', isSibling:true
                    				});
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser2) && !isNullOrEmpty(selectedRecord.data.sibilingUser2.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser2.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser2.lastName)?selectedRecord.data.sibilingUser2.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser2.middleName)?selectedRecord.data.sibilingUser2.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying, 
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser2.id:null),
                    				relationShipType:'SISTER', isSibling:true
                    				});
                    			}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser3) && !isNullOrEmpty(selectedRecord.data.sibilingUser3.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser3.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser3.lastName)?selectedRecord.data.sibilingUser3.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser3.middleName)?selectedRecord.data.sibilingUser3.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying,
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser3.id:null),
                    				relationShipType:'SISTER', isSibling:true
                    				});                		
                    			}
                		}
                		var this$ = this;
                		Academia.app.getStore('criteriabuilder.userquicksearch.QuickSearchCode').load({
                			callback: function(){
                				scope:this,
                				Academia.app.getStore('admission.manageForm.StudentWithOutAL').load({
                					scope:this,
                					callback: function(){
                						if(applicantForm.down('#relationshipDetailsId')){
                							for (i in tempArr) {
                							    if (i == 0) {
                							        applicantForm.down('#relationshipDetailsId').down('#relationShipField').setValue(tempArr[i].relationShipType);
                							        applicantForm.down('#relationshipDetailsId').down('#relationshipName').setValue(tempArr[i].firstName + (!isNullOrEmpty(tempArr[i].middleName) ? (' ' + tempArr[i].middleName) : '') + ' ' + (!isNullOrEmpty(tempArr[i].lastName) ? tempArr[i].lastName : ''));
                							       
                							        if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                							        	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileCountryCodeItemId').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileCountryCode) ? tempArr[i].enquirerMobileCountryCode : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileNo').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileNo) ? tempArr[i].enquirerMobileNo : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipEmail').setValue( !isNullOrEmpty(tempArr[i].enquirerEmailId) ? tempArr[i].enquirerEmailId : '');
            							            	
            							            	applicantForm.down('#cellCountryCode').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileCountryCode) ? tempArr[i].enquirerMobileCountryCode : '');
            							            	applicantForm.down('#mobileNumber').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileNo) ? tempArr[i].enquirerMobileNo : '');
            							            	applicantForm.down('#emailId').setValue( !isNullOrEmpty(tempArr[i].enquirerEmailId) ? tempArr[i].enquirerEmailId : '');
            							            	applicantForm.down('#enquirerSalutationID').setValue( !isNullOrEmpty(tempArr[i].enquirerSalutationID) ? tempArr[i].enquirerSalutationID : '');
            							            }
                							        
                							        if (tempArr[i].isEmp) {
                							            var relationshipCheckbox = applicantForm.down('#relationshipDetailsId');
                							            relationshipCheckbox.down('#relationshipCheckbox').setValue(true);
                							            //              									relationshipCheckbox.nextSibling().setValue(tempArr[i].userId);
                							            if (tempArr[i].isSibling) {
                							                relationshipCheckbox.down('#relationshipStudent').setValue(tempArr[i].userId);
                							            } else {
                							                relationshipCheckbox.down('#relationshipUser').setValue(tempArr[i].userId);
                							            }
                							        }
                							    } else {
                							        var form = this$.getApplicantCommonForm();
                							        var panelItem = new Array();

                							        panelItem.push({
                							            xtype: 'panel',
                							            layout: 'vbox',
                							            cls: 'panelNoSpace',
                							            items: [{
                							                xtype: 'fieldcontainer',
                							                width: 'auto',
                							                layout: 'hbox',
                							                defaults: {
                							                    labelAlign: 'top',
                							                    width: 256
                							                },
                							                items: [{
                							                    xtype: 'customcombobox',
                							                    fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
                							                    name: 'relationship',
                							                    valueField: 'name',
                							                    displayField: 'value',
                							                    itemId: 'relationShipFieldId',
                							                    store: 'common.RelationshipStore',
                							                    value: tempArr[i].relationShipType,
                							                    editable: false,
                							                    allowBlank: true,
                							                    listeners: {
                							                        change: function(obj, value) {
                							                            this$.setMoreRelationShipDetails(obj, value);
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'checkboxfield',
                							                    itemId: 'relationshipCheckboxId' + i,
                							                    labelAlign: 'right',
                							                    boxLabel: getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'),
                							                    name: 'relationshipCheckbox',
                							                    inputValue: true,
                							                    uncheckedValue: false,
                							                    style: {
                							                        marginTop: '23px'
                							                    },
                							                    listeners: {
                							                        change: function(obj) {
                							                            this$.ShowHideMoreOrganizationDetails(obj, obj.getValue());
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'customcombobox',
                							                    name: 'relationshipStudent',
                							                    itemId: 'relationshipStudentId' + i,
                							                    fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
                							                    store: 'admission.manageForm.StudentWithOutAL',
                							                    valueField: 'id',
                							                    hidden: true,
                							                    displayField: 'valueCode',
                							                    queryParam: 'studentNameOrCode',
                							                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                							                    enableKeyEvents: 'true',
                							                    minChars: 3,
                							                    typeAhead: false,
                							                    forceSelection: true,
                							                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                							                    triggerAction: '',
                							                    hideTrigger: false,
                							                    listConfig: {
                							                        listeners: {
                							                            beforeshow: function(picker) {
                							                                picker.minWidth = picker.up('combobox').getSize().width;
                							                            }
                							                        },
                							                        loadingText: getCommonTranslation('SEARCHING'),
                							                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                							                        getInnerTpl: function() {
                							                            return '<div class="search-item">' +
                							                                '{studentCode} / {studentName}' +
                							                                '</div>';
                							                        }
                							                    },
                							                    listeners: {
                							                        select: function(obj, record) {
                							                            this$.setMoreStudentRelatedDetails(obj, record);
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'customcombobox',
                							                    name: 'relationshipUser',
                							                    itemId: 'relationshipUserId' + i,
                							                    fieldLabel: getAdmissionTranslation('EMPLOYEE_NAME'),
                							                    store: 'criteriabuilder.userquicksearch.QuickSearchCode',
                							                    valueField: 'id',
                							                    displayField: 'value',
                							                    queryParam: 'code',
                							                    minChars: 3,
                							                    hidden: true,
                							                    typeAhead: false,
                							                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                							                    enableKeyEvents: 'true',
                							                    hideTrigger: false,
                							                    //cls:'gridInputCustomStyle',
                							                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                							                    triggerAction: '',
                							                    forceSelection: true,
                							                    listConfig: {
                							                        listeners: {
                							                            beforeshow: function(picker) {
                							                                picker.minWidth = picker.up('combobox').getSize().width;
                							                            }
                							                        },
                							                        loadingText: getCommonTranslation('SEARCHING'),
                							                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                							                        getInnerTpl: function() {
                							                            return '<div class="search-item">' +
                							                                '{value}' +
                							                                '</div>';
                							                        }
                							                    },
                							                    listeners: {
                							                        select: function(obj, record) {
                							                            this$.setMoreEmployeeRelatedDetails(obj, record);
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'personRelationshipsId'
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'personRelationshipsVersion'
                							                }]
                							            }, {
                							                xtype: 'fieldcontainer',
                							                width: 'auto',
                							                layout: {
                							                    type: 'hbox',
                							                    align: 'bottom'
                							                },
                							                defaults: {
                							                    labelAlign: 'top',
                							                    width: 256
                							                },
                							                items: [{
                							                    xtype: 'textfield',
                							                    name: 'relationshipName',
                							                    itemId: 'relationshipNameId',
                							                    value: (tempArr[i].firstName + ' ' + (!isNullOrEmpty(tempArr[i].lastName) ? tempArr[i].lastName : '')).trim(),
                							                    fieldLabel: getAdmissionTranslation('NAME'), //Last Name       
                							                    allowBlank: true,
                							                    readOnly: true
                							                }, {
                												xtype: 'fieldcontainer',
                												fieldLabel: getAdmissionTranslation('MOBILE_NO'),
                												layout : {
                													type : 'hbox'
                												},
                												items : [{
                													xtype : 'customcombobox',
                													name : 'relationshipMobileCountryCode',
                													itemId : 'relationshipMobileCountryCodeItemId',
                													valueField : 'isdCode',
                													displayField : 'isdCode',
                													store:'common.CountryStore',
                													triggerAction : 'all',
                													readOnly:true,
                													editable : false,
                													width: 80
                												}, {
                													xtype : 'numberfield',
                													name: 'relationshipMobileNo',
                													itemId: 'relationshipMobileNo',
                													hideTrigger: true,
                													mouseWheelEnabled:false,
                													maxLength: 11,
                													enforceMaxLength : true,
                													readOnly:true,
                													minValue:0,
                													allowExponential:false,
                													keyNavEnabled: false,
                													width:  146
                													//fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
                												}]
                											}, {
                							                    xtype: 'textfield',
                							                    name: 'relationshipEmail',
                							                    vtype: 'email',
                							                    readOnly: true,
                							                    itemId: 'relationshipEmail',
                							                    fieldLabel: getAdmissionTranslation('EMAIL_ID') //Email ID,
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'relatedPersonId'
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'relatedPersonVersion'
                							                }, {
                							                    xtype: 'button',
                							                    itemId: 'addRelationBtn',
                							                    cls: 'CustomBodyBtnSettings',
                							                    text: getCommonTranslation('ADDBUTTONTEXT'),
                							                    tooltip: getCommonTranslation('ADD'),
                							                    width: 40
                							                }, {
                							                    xtype: 'button',
                							                    glyph: ICONGLYPH.DELETEGLYPH,
                							                    cls: 'CustomBodyBtnReject',
                							                    tooltip: getCommonTranslation('DELETETOOLTIP'),
                							                    width: 35,
                							                    listeners: {
                							                        click: function(obj) {
                							                            var name = obj.previousSibling().previousSibling().previousSibling().previousSibling().previousSibling();
                							                            name.validate();
                							                            var frm = obj.up('applicantcommonform');
                							                            var receiptPanel = frm.down('#relationshipDetailsId');
                							                            var container = obj.up('panel');
                							                            receiptPanel.remove(container);
                							                            frm.doLayout();
                							                        }
                							                    }
                							                }]
                							            }]
                							        });
                							        var receiptheaderPanel = form.down('#relationshipDetailsId');
                							        receiptheaderPanel.add(panelItem);
                							        form.doLayout();
                							        if (tempArr[i].isEmp) {
                							            var relationshipCheckboxDynamic = form.down('#relationshipCheckboxId' + i);
                							            relationshipCheckboxDynamic.setValue(true);
                							            //              									form.down('#relationshipCheckboxId'+i).nextSibling().setValue(tempArr[i].userId);
                							            if (tempArr[i].isSibling) {
                							                form.down('#relationshipStudentId' + i).setValue(tempArr[i].userId);
                							            } else {
                							                form.down('#relationshipUserId' + i).setValue(tempArr[i].userId);
                							            }
                							        }
                							    }
                							}
                						}
                						Ext.getBody().unmask();
                						}
                				
                				})
                			}
                		});
                	}
                }
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
        }
    },
    onSearchImportButtonForApplicantFormClick: function(me, searchWindow, applicantForm) {
        if (searchWindow) {
            var grid = searchWindow.down('grid');
            if (grid.getSelectionModel().getCount() > 0) {
                var selectedRecord = grid.getSelectionModel().getSelection()[0];
                var linkStudentIdField = applicantForm.down('#linkStudentId');
                var linkStudentCodeField = applicantForm.down('#linkStudentCode');
                linkStudentIdField.reset();
                linkStudentCodeField.reset();
                linkStudentCodeField.setVisible(false);
                if (!isEmpty(selectedRecord.data)) {
                	Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
                	if (applicantForm) { 
                		var saleRefType = null;
                		var model;
                		if(selectedRecord.data.saleRefType == 'EXISTING_STUDENT'){
                			var submitUrl = SERVERURL.APPLICATION_FORM_SALE_SEARCH_EXISTING_STUDENT;
                			var URL = submitUrl.concat('?studentCode='+selectedRecord.data.studentCode);
                			Ext.Ajax.request({
                                type: 'rest',
                                url: URL,
                                method: 'GET',
                                async: false,
                                success: function(response, form) {
                                	var fathersalution=selectedRecord.data.fathersalution;
                                	var fatherFirstName=selectedRecord.data.fatherFirstName;
                                	var fatherMiddleName=selectedRecord.data.fatherMiddleName;
                                	var fatherLastName=selectedRecord.data.fatherLastName;
                                	var fatherFirstName=selectedRecord.data.fatherFirstName;
                                	var fatherEmployed=selectedRecord.data.fatherEmployed;
                                	var fatherEmailId=selectedRecord.data.fatherEmailId;
                                	var fatherPhoneCountryCode=selectedRecord.data.fatherPhoneCountryCode;
                                	var fatherPhoneNo=selectedRecord.data.fatherPhoneNo;
                                	var userByFatherEmployeeId=selectedRecord.data.userByFatherEmployeeId;
                                	saleRefType='EXISTING_STUDENT';
                                	selectedRecord.data = Ext.decode(response.responseText)[0];
                                	var genderStore = applicantForm.down('#gender').getStore();
                            		genderStore.load();
                            		//TimeZone Changes
                            		if(!isNullOrEmpty(selectedRecord.data.person.birthDate) && !isNullOrEmpty(selectedRecord.data.person.dobString)){
                            			selectedRecord.data.person.birthDate = selectedRecord.data.person.dobString;
                            		}else{
                            		    selectedRecord.data.person.birthDate = new Date(selectedRecord.data.person.birthDate);
                            		}
                            		if(!isNullOrEmpty(selectedRecord.data.person.genderCSM) && !isNullOrEmpty(selectedRecord.data.person.genderCSM.id)){
                            			selectedRecord.data.person.genderCSM = selectedRecord.data.person.genderCSM.id;
                        			}
                            		selectedRecord.data.person.code=selectedRecord.data.code;
                        			selectedRecord.data.person.id=selectedRecord.data.id;
                        			selectedRecord.data.person.saleRefType='EXISTING_STUDENT';
                        			selectedRecord.data.person.saleRefId=selectedRecord.data.code;
                        			selectedRecord.data.fathersalution=fathersalution;
                        			selectedRecord.data.fatherFirstName=fatherFirstName;
                        			selectedRecord.data.fatherMiddleName=fatherMiddleName;
                        			selectedRecord.data.fatherLastName=fatherLastName;
                        			selectedRecord.data.fatherFirstName=fatherFirstName;
                        			selectedRecord.data.fatherEmployed=fatherEmployed;
                        			selectedRecord.data.fatherEmailId=fatherEmailId;
                        			selectedRecord.data.fatherPhoneCountryCode=fatherPhoneCountryCode;
                        			selectedRecord.data.fatherPhoneNo=fatherPhoneNo;
                        			selectedRecord.data.userByFatherEmployeeId=userByFatherEmployeeId;
                        			model = new Academia.model.admission.applicationFormSale.ApplicationFormModel(selectedRecord.data.person);
                            		applicantForm.loadRecord(model);
                                }
                			});
                		}else{
							var genderStore = applicantForm.down('#gender').getStore();
							genderStore.load();
							//TimeZone Changes   
							if (selectedRecord.data.saleRefType === 'ENQUIRED_EARLIER') {
								var admissionForm = me.getAddAdmissionDetailWindow();
								var cmbApplicationType = applicantForm.down('#cmbApplicationType');
								var selectedApplicationType = cmbApplicationType.getValue();
								var searchCriteria = me.getSearchCriteria(me, admissionForm, selectedApplicationType);
								if (selectedRecord && selectedRecord.data && selectedRecord.data.code) {
									searchCriteria.enquirerID = selectedRecord.data.code;
								}
								jsonFormatData = Ext.encode(searchCriteria);
								var submitUrl = SERVERURL.APPLICATION_FORM_SALE_SEARCH_ENQUIRY_STUDENT_ACCESSIBLE_AL;
								var URL = submitUrl.concat("?academyLocationId=" + this.getCurrentAcademyLocation());
								Ext.Ajax.request({
									type: 'rest',
									url: URL,
									method: 'POST',
									jsonData: jsonFormatData,
									success: function(response, form) {
										var data = Ext.decode(response.responseText)[0];
										if (!isNullOrEmpty(data.studentDateOfBirth) && !isNullOrEmpty(data.dobString)) {
											selectedRecord.data.birthDate = data.dobString;
										}
										if (!isNullOrEmpty(data.genderCSM) && !isNullOrEmpty(data.genderCSM.id)) {
											selectedRecord.data.genderCSM = data.genderCSM.id;
										}
										model = new Academia.model.admission.applicationFormSale.ApplicationFormModel(selectedRecord.data);
										applicantForm.loadRecord(model);
									}
								});
							} else {
								if (!isNullOrEmpty(selectedRecord.data.birthDate))
									selectedRecord.data.birthDate = new Date(selectedRecord.data.birthDate);
								if (!isNullOrEmpty(selectedRecord.data.genderCSM) && !isNullOrEmpty(selectedRecord.data.genderCSM.id)) {
									selectedRecord.data.genderCSM = selectedRecord.data.genderCSM.id;
								}
								model = new Academia.model.admission.applicationFormSale.ApplicationFormModel(selectedRecord.data);
								applicantForm.loadRecord(model);
							}
                			model = new Academia.model.admission.applicationFormSale.ApplicationFormModel(selectedRecord.data);
                    		applicantForm.loadRecord(model);
                    		
                    		if(!isNullOrEmpty(selectedRecord.data.linkStudentId)) {
                    			linkStudentIdField.setValue(selectedRecord.data.linkStudentId.id);
                                linkStudentCodeField.setValue(selectedRecord.data.linkStudentId.code);
                                linkStudentCodeField.setVisible(true);
                    		}
                    		var applicantModeOfEnquiryField = applicantForm.getForm().findField("applicantModeOfEnquiry");
            				if( !isNullOrEmpty(selectedRecord.data.wsenquiryMultipleMode) && selectedRecord.data.wsenquiryMultipleMode.length>0){
            					applicantModeOfEnquiryField.getStore().load({
                    				callback: function(records, operation, success) {
                    					if (success) {
                    						var applicantModeOfEnquiryArray= [];
                    						if(records.length > 0){
                    							selectedRecord.data.wsenquiryMultipleMode.forEach(function(modeOfObj){
                    								var result = records.filter(function (obj) {
                    									  return obj.data.id === modeOfObj.enquiryMode.id;
                    									})[0];
                    								applicantModeOfEnquiryArray.push(result);
                    							});
                    							applicantModeOfEnquiryField.setValue(applicantModeOfEnquiryArray);
                    						}
                    					}
                    				}
                    	        });
            				}
                    		
                		}
                		searchWindow.close();                        
                		var dispalyCode=applicantForm.down('#dispalyCode');
                		applicantForm.down('#applicationDate').setValue(dateFormatRender(new Date()));
                		if(dispalyCode && !isNullOrEmpty(selectedRecord.data.code)){
                			dispalyCode.setVisible(true);
                		}else{
                			dispalyCode.setVisible(false);
                		}
                		
                		var applicationOwnerCombo = applicantForm.down('#applicationOwner');
                		if( !isNullOrEmpty(applicationOwnerCombo) ){
                			enquryOenerStore = applicationOwnerCombo.getStore();
                			if(model.data.saleRefType == 'EXISTING_STUDENT') {
                			var locations = [];
                    		var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
                    		for(var i=0; i<academyLocationList.length; i++){
                    			locations.push(academyLocationList[i].id);
                    		}
                    		enquryOenerStore.getProxy().extraParams = {
                    			academyLocationIds: locations.join()
                    		};
                    		var loggedInUser=this.getCurrentlyLoggedInUser();
                    		var loggedInUserId = loggedInUser.id;
                    		enquryOenerStore.load({
                    			callback: function(record, operation, success) {
                    				if (success) {
                    					applicationOwnerCombo.setValue(loggedInUserId);
                    				}
                    			}
                    		});
                			}
                    		else {
                    		/*enquryOenerStore.getProxy().extraParams = {
                    			academyLocationIds: locations.join()
                    		};*/
                    		//var user=this.getCurrentlyLoggedInUser();
                			if( !isNullOrEmpty(selectedRecord.data.enquiryOwnerId) ){
                				var userId = selectedRecord.data.enquiryOwnerId;
                        		enquryOenerStore.load({
                        			callback: function(record, operation, success) {
                        				if (success) {
                        					applicationOwnerCombo.setValue(userId);
                        				}
                        			}
                        		});
                			}
                			}
                		}
                		
                		var tempArr = [];
                		if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                			if(!isNullOrEmpty(saleRefType) && saleRefType=='EXISTING_STUDENT' && 
                					!isNullOrEmpty(selectedRecord.data.fatherFirstName)) {
                			tempArr.push({
                				firstName:selectedRecord.data.fatherFirstName,
                				lastName:(!isNullOrEmpty(selectedRecord.data.fatherLastName)?selectedRecord.data.fatherLastName:null),
                				middleName:(!isNullOrEmpty(selectedRecord.data.fatherMiddleName)?selectedRecord.data.fatherMiddleName:null),
                				isEmp:selectedRecord.data.fatherEmployed,
                				userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId:null), 
                				relationShipType:'FATHER', isSibling:false,
                				enquirerEmailId:selectedRecord.data.fatherEmailId,
                				enquirerMobileNo:selectedRecord.data.fatherPhoneNo,
                				enquirerMobileCountryCode:selectedRecord.data.fatherPhoneCountryCode,
                				enquirerSalutationID:(!isNullOrEmpty(selectedRecord.data.fathersalution)?selectedRecord.data.fathersalution:null)
                			});
                			} else {
                			tempArr.push({
                				firstName:selectedRecord.data.enquirerFirstName,
                				lastName:(!isNullOrEmpty(selectedRecord.data.enquirerLastName)?selectedRecord.data.enquirerLastName:null),
                				middleName:(!isNullOrEmpty(selectedRecord.data.enquirerMiddleName)?selectedRecord.data.enquirerMiddleName:null),
                				isEmp:selectedRecord.data.fatherEmployed,
                				userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId.id:null), 
                				relationShipType:'FATHER', isSibling:false,
                				enquirerEmailId:selectedRecord.data.enquirerEmailId,
                				enquirerMobileNo:selectedRecord.data.enquirerMobileNo,
                				enquirerMobileCountryCode:selectedRecord.data.enquirerMobileCountryCode,
                				enquirerSalutationID:(!isNullOrEmpty(selectedRecord.data.enquirerSalutation)?selectedRecord.data.enquirerSalutation.id:null)
                			});
                			}
                		} else {
                			if(!isNullOrEmpty(selectedRecord.data.fatherFirstName)){
                				if(!isNullOrEmpty(saleRefType) && saleRefType=='EXISTING_STUDENT') {
                    			tempArr.push({
                    				firstName:selectedRecord.data.fatherFirstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.fatherLastName)?selectedRecord.data.fatherLastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.fatherMiddleName)?selectedRecord.data.fatherMiddleName:null),
                    				isEmp:selectedRecord.data.fatherEmployed,
                    				userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId:null), 
                    				relationShipType:'FATHER', isSibling:false,
                    				enquirerEmailId:selectedRecord.data.fatherEmailId,
                    				enquirerMobileNo:selectedRecord.data.fatherPhoneNo,
                    				enquirerMobileCountryCode:selectedRecord.data.fatherPhoneCountryCode
                    				});
                    			} else {
                    			tempArr.push({
                    				firstName:selectedRecord.data.fatherFirstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.fatherLastName)?selectedRecord.data.fatherLastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.fatherMiddleName)?selectedRecord.data.fatherMiddleName:null),
                    				isEmp:selectedRecord.data.fatherEmployed,
                    				userId:((selectedRecord.data.fatherEmployed)?selectedRecord.data.userByFatherEmployeeId.id:null), 
                    				enquirerEmailId:(!isNullOrEmpty(selectedRecord.data.fatherEmailId)?selectedRecord.data.fatherEmailId:null),
                    				enquirerMobileCountryCode:(!isNullOrEmpty(selectedRecord.data.fatherPhoneCountryCode)?selectedRecord.data.fatherPhoneCountryCode:null),
                    				enquirerMobileNo:(!isNullOrEmpty(selectedRecord.data.fatherPhoneNo)?selectedRecord.data.fatherPhoneNo:null),
                    				relationShipType:'FATHER', isSibling:false
                    				});
                    			}
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.motherFirstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.motherFirstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.motherLastName)?selectedRecord.data.motherLastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.motherMiddleName)?selectedRecord.data.motherMiddleName:null),
                    				isEmp:selectedRecord.data.motherEmployed,
                    				userId:((selectedRecord.data.motherEmployed)?selectedRecord.data.userByMotherEmployeeId.id:null), 
                    				relationShipType:'MOTHER', isSibling:false
                    				});
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser1) && !isNullOrEmpty(selectedRecord.data.sibilingUser1.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser1.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser1.lastName)?selectedRecord.data.sibilingUser1.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser1.middleName)?selectedRecord.data.sibilingUser1.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying, 
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser1.id:null),
                    				emailId:selectedRecord.data.sibilingUser1.emailId,
                    				enquirerMobileCountryCode:selectedRecord.data.sibilingUser1.accountingKey,
                    				enquirerMobileNo:selectedRecord.data.sibilingUser1.printName,
                    				relationShipType:'BROTHER', isSibling:true
                    				});
                    		}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser2) && !isNullOrEmpty(selectedRecord.data.sibilingUser2.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser2.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser2.lastName)?selectedRecord.data.sibilingUser2.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser2.middleName)?selectedRecord.data.sibilingUser2.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying, 
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser2.id:null),
                    				emailId:selectedRecord.data.sibilingUser2.emailId,
                    				relationShipType:'SISTER', isSibling:true
                    				});
                    			}
                    		if(!isNullOrEmpty(selectedRecord.data.sibilingUser3) && !isNullOrEmpty(selectedRecord.data.sibilingUser3.firstName)){
                    			tempArr.push({
                    				firstName:selectedRecord.data.sibilingUser3.firstName,
                    				lastName:(!isNullOrEmpty(selectedRecord.data.sibilingUser3.lastName)?selectedRecord.data.sibilingUser3.lastName:null),
                    				middleName:(!isNullOrEmpty(selectedRecord.data.sibilingUser3.middleName)?selectedRecord.data.sibilingUser3.middleName:null),
                    				isEmp:selectedRecord.data.whetherSiblingStudying,
                    				userId:((selectedRecord.data.whetherSiblingStudying)?selectedRecord.data.sibilingUser3.id:null),
                    				emailId:selectedRecord.data.sibilingUser3.emailId,
                    				relationShipType:'SISTER', isSibling:true
                    				});                		
                    			}
                		}
                		var this$ = this;
                		var siblingId = '';
                		var fatherId = '';
                		var motherId = '';
                		var motherIdAdd ='';
                		var ids='';
                		var siblingIdAdd3='';
                		var siblingIdAdd2='';
                		var siblingIdAdd1='';
                		var motherIdAdd ='';
                		var fatherIdAdd='';
                		if(selectedRecord.data.sibilingUser1){
                			siblingId1 = selectedRecord.data.sibilingUser1;
                			 siblingIdAdd1 = siblingId1.id+',';
                		}
                		if(selectedRecord.data.sibilingUser2){
                			siblingId2 = selectedRecord.data.sibilingUser2;
                			 siblingIdAdd2 = siblingId2.id+',';
                		}
                		if(selectedRecord.data.sibilingUser3){
                			siblingId3 = selectedRecord.data.sibilingUser3;
                			 siblingIdAdd3 = siblingId3.id;
                		}
                		if(selectedRecord.data.userByFatherEmployeeId!=null){
                			fatherId = selectedRecord.data.userByFatherEmployeeId.id;
                			fatherIdAdd = fatherId+','; 
                		}
                		if(selectedRecord.data.userByMotherEmployeeId!=null){
                			motherId = selectedRecord.data.userByMotherEmployeeId.id;
                			motherIdAdd = motherId+','; 
                		}
                		 var siblingIdSeprated = siblingIdAdd1+siblingIdAdd2+siblingIdAdd3;
                		if(!isNullOrEmpty(saleRefType) && saleRefType == 'EXISTING_STUDENT'){
                			var parentIdSeprated = selectedRecord.data.userByFatherEmployeeId;
                			if(isNullOrEmpty(parentIdSeprated)){
                				parentIdSeprated = 0;
                			}
                			siblingIdSeprated = 0;
                		}else{
                			var parentIdSeprated = fatherIdAdd+motherIdAdd;
                			if(!isNullOrEmpty(parentIdSeprated)){
                				parentIdSeprated = parentIdSeprated.replace(/,(\s+)?$/, '');
                			}else{
                				parentIdSeprated = 0;
                			} 
                			if(!isNullOrEmpty(siblingIdSeprated)){
                				siblingIdSeprated = siblingIdSeprated.replace(/,(\s+)?$/, '');
                			}else{
                				siblingIdSeprated = 0;
                			}
                		}
                		/*if(!isNullOrEmpty(siblingIdSeprated) && !isNullOrEmpty(parentIdSeprated)){
                			if(!isNaN(siblingIdSeprated) && !isNaN(parentIdSeprated))
                				{
                    			ids=parentIdSeprated+siblingIdSeprated;
                				}else if(!isNaN(parentIdSeprated))
                					{
                					ids=parentIdSeprated;
                					}else
                					{
                					ids=siblingIdSeprated;
                					}
                			ids = ids.replace(/,(\s+)?$/, '');
                		}*/
                		
                		//if(selectedRecord.data.whetherSiblingStudying != false || selectedRecord.data.fatherEmployed!=false || selectedRecord.data.motherEmployed!=false){
                		Academia.app.getStore('criteriabuilder.userquicksearch.QuickSearchCode').load({
                			params: {
                				parentId:parentIdSeprated
                            },
                			callback: function(){
                				scope:this,
                				Academia.app.getStore('admission.manageForm.StudentWithOutAL').load({
                					params: {
                						ids: siblingIdSeprated
                                    },
                					scope:this,
                					callback: function(){
                						if(applicantForm.down('#relationshipDetailsId')){
                							for (i in tempArr) {
                							    if (i == 0) {
                							        applicantForm.down('#relationshipDetailsId').down('#relationShipField').setValue(tempArr[i].relationShipType);
                							        applicantForm.down('#relationshipDetailsId').down('#relationshipName').setValue(tempArr[i].firstName + (!isNullOrEmpty(tempArr[i].middleName) ? (' ' + tempArr[i].middleName) : '') + ' ' + (!isNullOrEmpty(tempArr[i].lastName) ? tempArr[i].lastName : ''));
                							       
                							        if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                							        	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileCountryCodeItemId').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileCountryCode) ? tempArr[i].enquirerMobileCountryCode : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileNo').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileNo) ? tempArr[i].enquirerMobileNo : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipEmail').setValue( !isNullOrEmpty(tempArr[i].enquirerEmailId) ? tempArr[i].enquirerEmailId : '');
            							            	
            							            	if(isNullOrEmpty(saleRefType) || saleRefType != 'EXISTING_STUDENT') {
            							            	applicantForm.down('#cellCountryCode').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileCountryCode) ? tempArr[i].enquirerMobileCountryCode : '');
            							            	applicantForm.down('#mobileNumber').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileNo) ? tempArr[i].enquirerMobileNo : '');
            							            	applicantForm.down('#emailId').setValue( !isNullOrEmpty(tempArr[i].enquirerEmailId) ? tempArr[i].enquirerEmailId : '');
            							            	applicantForm.down('#enquirerSalutationID').setValue( !isNullOrEmpty(tempArr[i].enquirerSalutationID) ? tempArr[i].enquirerSalutationID : '');
            							            	}
            							            } else {
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileCountryCodeItemId').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileCountryCode) ? tempArr[i].enquirerMobileCountryCode : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipMobileNo').setValue( !isNullOrEmpty(tempArr[i].enquirerMobileNo) ? tempArr[i].enquirerMobileNo : '');
            							            	applicantForm.down('#relationshipDetailsId').down('#relationshipEmail').setValue( !isNullOrEmpty(tempArr[i].enquirerEmailId) ? tempArr[i].enquirerEmailId : '');
            							            }
                							        
                							        if (tempArr[i].isEmp) {
                							            var relationshipCheckbox = applicantForm.down('#relationshipDetailsId');
                							            relationshipCheckbox.down('#relationshipCheckbox').setValue(true);
                							            //              									relationshipCheckbox.nextSibling().setValue(tempArr[i].userId);
                							            if (tempArr[i].isSibling) {
                							            	relationshipCheckbox.down('#relationshipStudent').setValue(tempArr[i].userId);
                							            } else {
                							            	relationshipCheckbox.down('#relationshipUser').setValue(tempArr[i].userId);
                							            }
                							        }
                							    } else {
                							        var form = this$.getApplicantCommonForm();
                							        var panelItem = new Array();

                							        panelItem.push({
                							            xtype: 'panel',
                							            layout: 'vbox',
                							            cls: 'panelNoSpace',
                							            items: [{
                							                xtype: 'fieldcontainer',
                							                width: 'auto',
                							                layout: 'hbox',
                							                defaults: {
                							                    labelAlign: 'top',
                							                    width: 256
                							                },
                							                items: [{
                							                    xtype: 'customcombobox',
                							                    fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
                							                    name: 'relationship',
                							                    valueField: 'name',
                							                    displayField: 'value',
                							                    itemId: 'relationShipFieldId',
                							                    store: 'common.RelationshipStore',
                							                    value: tempArr[i].relationShipType,
                							                    editable: false,
                							                    allowBlank: true,
                							                    listeners: {
                							                        change: function(obj, value) {
                							                            this$.setMoreRelationShipDetails(obj, value);
                							                        }
                							                    }
                							                },{
                												xtype: 'textfield',
                												name: 'relationshipUserExternal'+ i,
                												itemId:'relationshipUserExternal',
                												//readOnly:true,
                												fieldLabel: getAdmissionTranslation('EMPLOYEE_ID'), //Last Name       
                												allowBlank: true
                											}, {
                							                    xtype: 'checkboxfield',
                							                    itemId: 'relationshipCheckboxId' + i,
                							                    labelAlign: 'right',
                							                    boxLabel: getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'),
                							                    name: 'relationshipCheckbox',
                							                    inputValue: true,
                							                    uncheckedValue: false,
                							                    width: 227,
                							                    style: {
                							                        marginTop: '23px'
                							                    },
                							                    listeners: {
                							                        change: function(obj) {
                							                            this$.ShowHideMoreOrganizationDetails(obj, obj.getValue());
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'customcombobox',
                							                    name: 'relationshipStudent',
                							                    itemId: 'relationshipStudentId' + i,
                							                    fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
                							                    store: 'admission.manageForm.StudentWithOutAL',
                							                    valueField: 'id',
                							                    hidden: true,
                							                    displayField: 'valueCode',
                							                    queryParam: 'studentNameOrCode',
                							                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                							                    enableKeyEvents: 'true',
                							                    minChars: 3,
                							                    typeAhead: false,
                							                    forceSelection: true,
                							                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                							                    triggerAction: '',
                							                    hideTrigger: false,
                							                    listConfig: {
                							                        listeners: {
                							                            beforeshow: function(picker) {
                							                                picker.minWidth = picker.up('combobox').getSize().width;
                							                            }
                							                        },
                							                        loadingText: getCommonTranslation('SEARCHING'),
                							                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                							                        getInnerTpl: function() {
                							                            return '<div class="search-item">' +
                							                                '{studentCode} / {studentName}' +
                							                                '</div>';
                							                        }
                							                    },
                							                    listeners: {
                							                        select: function(obj, record) {
                							                            this$.setMoreStudentRelatedDetails(obj, record);
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'customcombobox',
                							                    name: 'relationshipUser',
                							                    itemId: 'relationshipUserId' + i,
                							                    fieldLabel: getAdmissionTranslation('USER_ID'),
                							                    store: 'criteriabuilder.userquicksearch.QuickSearchCode',
                							                    valueField: 'id',
                							                    displayField: 'value',
                							                    queryParam: 'code',
                							                    minChars: 3,
                							                    hidden: true,
                							                    typeAhead: false,
                							                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                							                    enableKeyEvents: 'true',
                							                    hideTrigger: false,
                							                    //cls:'gridInputCustomStyle',
                							                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                							                    triggerAction: '',
                							                    forceSelection: true,
                							                    listConfig: {
                							                        listeners: {
                							                            beforeshow: function(picker) {
                							                                picker.minWidth = picker.up('combobox').getSize().width;
                							                            }
                							                        },
                							                        loadingText: getCommonTranslation('SEARCHING'),
                							                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                							                        getInnerTpl: function() {
                							                            return '<div class="search-item">' +
                							                                '{value}' +
                							                                '</div>';
                							                        }
                							                    },
                							                    listeners: {
                							                        select: function(obj, record) {
                							                            this$.setMoreEmployeeRelatedDetails(obj, record);
                							                        }
                							                    }
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'personRelationshipsId'
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'personRelationshipsVersion'
                							                }]
                							            }, {
                							                xtype: 'fieldcontainer',
                							                width: 'auto',
                							                layout: {
                							                    type: 'hbox',
                							                    //align: 'bottom'
                							                },
                							                defaults: {
                							                    labelAlign: 'top',
                							                    width: 256
                							                },
                							                items: [{
                							                    xtype: 'textfield',
                							                    name: 'relationshipName',
                							                    itemId: 'relationshipNameId',
                							                    value: (tempArr[i].firstName + (!isNullOrEmpty(tempArr[i].middleName) ? (' ' + tempArr[i].middleName) : '') + ' ' + (!isNullOrEmpty(tempArr[i].lastName) ? tempArr[i].lastName : '')).trim(),
                							                    fieldLabel: getAdmissionTranslation('NAME'), //Last Name       
                							                    allowBlank: true,
                							                   // readOnly: true
                							                }, {
                												xtype: 'fieldcontainer',
                												fieldLabel: getAdmissionTranslation('MOBILE_NO'),
                												layout : {
                													type : 'hbox'
                												},
                												items : [{
                													xtype : 'customcombobox',
                													name : 'relationshipMobileCountryCode',
                													itemId : 'relationshipMobileCountryCodeItemId',
                													valueField : 'isdCode',
                													displayField : 'isdCode',
                													store:'common.CountryStore',
                													triggerAction : 'all',
                													//readOnly:true,
                													editable : false,
                													width: 80
                												}, {
                													xtype : 'numberfield',
                													name: 'relationshipMobileNo',
                													itemId: 'relationshipMobileNo',
                													hideTrigger: true,
                													mouseWheelEnabled:false,
                													maxLength: 11,
                													enforceMaxLength : true,
                													//readOnly:true,
                													minValue:0,
                													allowExponential:false,
                													keyNavEnabled: false,
                													width:  146
                													//fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
                												}]
                											}, {
                							                    xtype: 'textfield',
                							                    name: 'relationshipEmail',
                							                    vtype: 'email',
                							                    value: tempArr[i].emailId,
                							                    itemId: 'relationshipEmail',
                							                    fieldLabel: getAdmissionTranslation('EMAIL_ID') //Email ID,
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'relatedPersonId'
                							                }, {
                							                    xtype: 'hidden',
                							                    name: 'relatedPersonVersion'
                							                }, {
                							                    xtype: 'button',
                							                    itemId: 'addRelationBtn',
                							                    cls: 'CustomBodyBtnSettings',
                							                    text: getCommonTranslation('ADDBUTTONTEXT'),
                							                    tooltip: getCommonTranslation('ADD'),
                							                    width: 40
                							                }, {
                							                    xtype: 'button',
                							                    glyph: ICONGLYPH.DELETEGLYPH,
                							                    cls: 'CustomBodyBtnReject',
                							                    tooltip: getCommonTranslation('DELETETOOLTIP'),
                							                    width: 35,
                							                    listeners: {
                							                        click: function(obj) {
                							                            var name = obj.previousSibling().previousSibling().previousSibling().previousSibling().previousSibling();
                							                            name.validate();
                							                            var frm = obj.up('applicantcommonform');
                							                            var receiptPanel = frm.down('#relationshipDetailsId');
                							                            var container = obj.up('panel');
                							                            receiptPanel.remove(container);
                							                            frm.doLayout();
                							                        }
                							                    }
                							                }]
                							            }]
                							        });
                							        var receiptheaderPanel = form.down('#relationshipDetailsId');
                							        receiptheaderPanel.add(panelItem);
                							        form.doLayout();
                							        if (tempArr[i].isEmp) {
                							            var relationshipCheckboxDynamic = form.down('#relationshipCheckboxId' + i);
                							            relationshipCheckboxDynamic.setValue(true);
                							            //              									form.down('#relationshipCheckboxId'+i).nextSibling().setValue(tempArr[i].userId);
                							            if (tempArr[i].isSibling) {
                							                form.down('#relationshipStudentId' + i).setValue(tempArr[i].userId);
                							            } else {
                							                form.down('#relationshipUserId' + i).setValue(tempArr[i].userId);
                							            }
                							            if (tempArr[i].relationShipType == 'BROTHER' || tempArr[i].relationShipType == 'SISTER') {
                							            	relationshipCheckboxDynamic.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
                							            } else {
                							            	relationshipCheckboxDynamic.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
                							            }
                							        }
                							    }
                							}
                						}
                						Ext.getBody().unmask();
                						}
                				
                				})
                			}
                		});
                		//}
                		Ext.getBody().unmask();
                	}
                }
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
        }
    },
    /*
     * This method is used to validate form contact details
     */
    validatePhone:function(data){
    	var isValid;
    	if(!(data.phoneNo && data.phoneCountryCode && data.phoneAreaCode) && !(data.mobileNumber && data.mobileCountryCode)){
    		//showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO')); //title changed from address to "alert" @ravi.patidar as discusse with prabhat
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ADD_PHONE_NO'));
    		isValid= false;
    	}
    	else{
    		isValid=true;
    	}
    	return isValid;
    },
    
    /**
     * This function is used for to save application form details
     *     
     */
    saveApplicationForm: function(me, applicantForm, programTabGrid, applicantRelatives, applicationFormSale, formId, grid,buttonPanel,collectionForm) {        
        var submitUrl, isUpdate = false;
        if (applicantForm) {
            var applicantId = applicantForm.down('#applicantId');
            if (isNullOrEmpty(applicantId.getSubmitValue())) {
                submitUrl = SERVERURL.APPLICATION_FORM_SALE_APPLICANT_CREATE,
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.APPLICATION_FORM_SALE_APPLICANT_UPDATE,
                isUpdate = true;
            }
            var formData = applicantForm.getForm().getValues();
            var jsonFormatFormData = me.getApplicationFormJsonData(formData, applicationFormSale, formId);
            
            if (!isNullOrEmpty(jsonFormatFormData) &&  this.validatePhone( formData)) {
            	
            	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            	
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    jsonData: jsonFormatFormData,
                    method: 'POST',
                    success: function(response, form) {
                    	 Ext.getBody().unmask();
                        //applicantForm.getForm().reset();
                    	var saveApplicantFormButton=applicantForm.down('#saveApplicantFormDetails');
                    	var searchComponent=applicantForm.down('#searchComponent');
                    	saveApplicantFormButton.setDisabled(true);
                    	searchComponent.setDisabled(true);
                    	
                    	toggleReadOnlyFormItems(applicantForm.getForm(),true);
                    	
                        if (grid) {
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                        }
                        applicantRelatives.setApplicationId(response.responseText);
                        programTabGrid.getStore().load({
                            params: {
                                applicationID: applicantRelatives.getApplicationId()
                            }
                        });
                        
                        Ext.each(applicantRelatives.items.items, function(tab) {
                            if (tab.disabled) {
                                tab.setDisabled(false);
                            }                            
                        });
                        if(applicantRelatives){
                        	var programPreferencesTab=applicantRelatives.down('#programPreferences');
                        	if(programPreferencesTab){
                        		applicantRelatives.setActiveTab(programPreferencesTab);
                        	}
                        }                        
                                               
                        if(buttonPanel && !buttonPanel.isVisible()){
                        	buttonPanel.setVisible(true);
                		}
                        if(collectionForm && !collectionForm.isVisible()){
                        	collectionForm.setVisible(true);
                		}
                        
                        if (isUpdate) {
                            showSuccessMessage(getAdmissionTranslation('UPDATE_APPLICATION'), getAdmissionTranslation('UPDATE_APPLICATION_MSG')); //Application updated successfully.
                        } else {
                            showSuccessMessage(getAdmissionTranslation('ADD_APPLICATION'), getAdmissionTranslation('ADD_APPLICATION_MSG')); //Application saved successfully.
                        }
                        me.onSaveLaodParentGuardianSiblingDetailsTab(applicantRelatives);
                    }
                });
            }
        }
    },
    
    onSaveLaodParentGuardianSiblingDetailsTab : function(applicantRelatives){
    	var params = {
        		id: applicantRelatives.getApplicationId()
        };
        Ext.Ajax.request({
 			type:'rest',
 			method:'GET',
 			url:SERVERURL.APPLICANT_FIND_BY_APPLICATION_ID,
 			params:params,
 			success: function(response, form) {
 				var personId = Ext.decode(response.responseText);
         		applicantRelatives.setPersonId(personId);
         		var applicantionParentGuardianGrid = applicantRelatives.down('#applicantionParentGuardianGrid');
         		applicantionParentGuardianGrid.getStore().load({
         			params : {
         	        		personId: personId
         	        }
         		});
         		var applicantionSiblingDetailsGrid = applicantRelatives.down('#applicantionSiblingDetailsGrid');
         		applicantionSiblingDetailsGrid.getStore().load({
         			params : {
         	        		personId: personId
         	        }
         		});
         		
 			}
 		});
    },

    /**
     * This function is used for to give application form data in json format 
     *     
     */
    getApplicationFormJsonData: function(formData, applicationFormSale, formId) {							
        var applicationFormData = new Object();
        var jsonFormatFormData = "";
        if (!isEmpty(formData)) {
            var applicationFormDataModel = new Academia.model.admission.applicationFormSale.ApplicationFormEntityDataModel(formData);
            applicationFormData = applicationFormDataModel.data;

            var personEntity = new Academia.model.admission.applicationFormSale.PersonEnityModel(formData);
            personEntity.data.id = null;
            personEntity.data.version = 0;
            
            if(isNullOrEmpty(personEntity.data.employeeId)){ 
            	personEntity.data.employeeId=null;
        	}
            if(isNullOrEmpty(personEntity.data.nationality)){ 
            	delete personEntity.data.nationality;
        	}
            
            
            //personEntity.data.personType = 'PERSON';
            personEntity.data.status = 'ACTIVE';
            applicationFormData.person = personEntity.data;

            applicationFormData.id = formData.applicantId;
            applicationFormData.currentStatus = 'APPLIED';

            if (applicationFormSale) {
                applicationFormData.applicationFormId = formId;
            }

            var selectedApplicationType = formData.saleRefType;
            if (!isNullOrEmpty(selectedApplicationType)) {
                if (selectedApplicationType === 'ENQUIRED_EARLIER') {
                    applicationFormData.code = "";
                    applicationFormData.existingStudentId = "";
                    applicationFormData.enquiryStudentDetailId =formData.saleRefPrimaryId; 
                } else if (selectedApplicationType === 'APPLIED_EARLIER') {
                    applicationFormData.code = "";
                    applicationFormData.existingStudentId = "";
                    applicationFormData.enquiryStudentDetailId = "";
                } else if (selectedApplicationType === 'EXISTING_STUDENT') {
                    applicationFormData.code = "";
                    applicationFormData.existingStudentId = formData.saleRefPrimaryId;
                    applicationFormData.enquiryStudentDetailId = "";
                }
            } else {
                applicationFormData.code = "";
                applicationFormData.existingStudentId = "";
                applicationFormData.enquiryStudentDetailId = "";
            }

            jsonFormatFormData = Ext.encode(applicationFormData);
        }
        return jsonFormatFormData;
    },

    /**
     * method is used for to check record selected in grid (GENERIC METHOD)
     *    
     */
    checkGridRecordSelection: function(me, grid, recordId, confirmMessageHeader, url, deleteSuccessMsg,snapShotGrid) {
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var id = record.get(recordId);
            if (!isNullOrEmpty(id)) {
                me.deleteFunction(me, id, confirmMessageHeader, url, deleteSuccessMsg, grid,null,snapShotGrid);
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /**
     * method is used for to send delete request(GENERIC METHOD)
     *    
     */
    deleteFunction: function(me, recordId, confirmMessageHeader, url, deleteSuccessMsg, grid, component,snapShotGrid) {
    	var this$ = this;
    	var snapshotGridObj = snapShotGrid;
        showConfirmMessage(confirmMessageHeader, getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            if (btn == 'yes') {
                url = url.concat("/" + recordId);
                Ext.Ajax.request({
                    type: 'rest',
                    url: url,
                    async: false,
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    success: function(form, action) {
						var res = Ext.JSON.decode(form.responseText);
						if (res == 0) {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DELETE_SG_APPOINTMENT_FIRST'));
						} else {
                        if (grid) {
                            grid.getStore().reload();
                        }
                        if(snapshotGridObj){
                        	snapshotGridObj.getStore().reload();
                        }
                       
                        if (component) {
                        	var title = component.title;
                        	var xtype = component.xtype;
                        	component.close();
                        	this$.openTab(title,xtype);
                        }
                        showSuccessMessage(getCommonTranslation('SUCCESS'), deleteSuccessMsg);
                    }
					}
                });
            }
        });
    },

    /**
     * method is used for to load program grid against selected program group
     *    
     */
    loadAddProgramGrid: function(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, selectedProgramGroupIds,
    		selectedAcademyLocationIds, selectedProgramIds,modeDeliveryId,regTypeEnum) {
    	var this$=this;
    	var params = new Object();
    	if (addProgramWindowGrid && !isNullOrEmpty(selectedProgramGroup)) {
    		if(this.getCurrentLoggedPortalId() == '6')
    		{
    			params = {
    					isformSaleSelection: true,
    					isformSubmissionSelection:false,
    					whetherAdmissionOpen :false
    			};
    		}
    		else
    		{
    			if(!isNullOrEmpty(isformSaleSelection) && !isNullOrEmpty(isformSubmissionSelection)){
    				params = {
    						isformSaleSelection: isformSaleSelection,
    						isformSubmissionSelection: isformSubmissionSelection,
    						whetherAdmissionOpen : whetherAdmissionOpen || false
    				};
    			}
    		}
            if(selectedAcademyLocationIds != 0){
            	params.academyLocationId = selectedAcademyLocationIds;
            }
            
            if(selectedProgramGroup != 0){
            	params.programGroupId = selectedProgramGroup;
            }
            
            if(selectedProgramGroup == 0){
	            if(selectedProgramGroupIds.length > 0){
	            	params.programGroupIds = selectedProgramGroupIds.join();
	            }
            }
            
            if(selectedProgramIds != 0){
            	params.programId = selectedProgramIds;
            }
            
            if(modeDeliveryId != 0){
            	params.modeDeliveryId = modeDeliveryId;
            }
            
            if(regTypeEnum != null){
            	params.registrationTypeEnum = regTypeEnum;
            }
            var store =  addProgramWindowGrid.store;
            store.getProxy().extraParams=params;
            
            this.resetPageSetting(store);
            store.load({
                callback: function(records, operation, success) {
                	this$.hideWindowMask();
                   if (!success) {
                	   addProgramWindowGrid.getStore().removeAll();
                   }
                }
            });
        }
    },

    /**
     * method is used for to add programs to applications
     *    
     */
    addProgramToApplication: function(me, programTabGrid, programWindow, addProgramWindowGrid, applicationId,applicantProfile,applicantGrid) {
    	var this$ = this;
        if (addProgramWindowGrid.getSelectionModel().getCount() > 0) {
        	var programGroupId="";
        	if(addProgramWindowGrid){
        		var cmbPgmGroupCombo=addProgramWindowGrid.down("#cmbPgmGroup");
        		if(cmbPgmGroupCombo){
        			programGroupId=cmbPgmGroupCombo.getValue();
        		}
        	}
        	var records = addProgramWindowGrid.getSelectionModel().getSelection();
        	var duplicatePBS=false;
        	if (!isNullOrEmpty(applicantProfile)) {
				var selectedApplicationProgramGrid = applicantProfile
						.down('#selectedApplicantApplicationProgramGrid');
				for ( var i in selectedApplicationProgramGrid.getStore().data.items) {
					if (records[0].data.programBatchSeatConfigurationId == selectedApplicationProgramGrid
							.getStore().data.items[i].data.programBatchSeatConfigurationId) {
						duplicatePBS = true;
					}
				}
			}
			if(!duplicatePBS){
            var selectedRecords = new Array();
            for (var count = 0; count < records.length; count++) {
                var selectedRecord = records[count];
                if (!isEmpty(selectedRecord.data)) {
                    var selectedRecordObject = new Object();
                    selectedRecordObject.id = null;
                    selectedRecordObject.version = "";
                    selectedRecordObject.applicationId = applicationId;
                    selectedRecordObject.progBatchSeatConfigId = (!isNullOrEmpty(selectedRecord.get('programBatchSeatConfigurationId'))) ? selectedRecord.get('programBatchSeatConfigurationId') : null;
                    selectedRecordObject.programId = getObjectValue(selectedRecord.get('program'),'id');
                    selectedRecordObject.currentStatus = (!isNullOrEmpty(selectedRecord.get('currentStatus'))) ? selectedRecord.get('currentStatus') : 'ACTIVE';
                    selectedRecordObject.priority = (!isNullOrEmpty(selectedRecord.priority)) ? selectedRecord.priority : count+1;
                    selectedRecordObject.academyLocationId = (!isNullOrEmpty(selectedRecord.get('academyLocationId'))) ? selectedRecord.get('academyLocationId') :null;
                    selectedRecordObject.distancetoTravel = (!isNullOrEmpty(selectedRecord.get('distancetoTravel'))) ? selectedRecord.get('distancetoTravel') : 0;
                    selectedRecordObject.programGroupId = (!isNullOrEmpty(programGroupId)) ? programGroupId : null;
					var schoolAttendanceStartDateValue = selectedRecord.get('schoolAttendanceStartDate');
					// Optional: convert to timestamp if it's a Date object
					if (schoolAttendanceStartDateValue instanceof Date) {
						selectedRecordObject.schoolAttendanceStartDate = schoolAttendanceStartDateValue.getTime();
					} else {
						selectedRecordObject.schoolAttendanceStartDate = schoolAttendanceStartDateValue || null;
					}
                    selectedRecordObject = me.getStatus(selectedRecordObject,selectedRecord,'whetherHostelApplicable','whetherHostelApplicable');
                    selectedRecordObject = me.getStatus(selectedRecordObject,selectedRecord,'whetherTransportApplicable','whetherTransportApplicable');                    
                    selectedRecords.push(selectedRecordObject);
                }
            }
            if (selectedRecords.length > 0) {
                var jsonFormatFormData = Ext.encode(selectedRecords);
                if (!isNullOrEmpty(jsonFormatFormData)) {
                	this$.applyWindowMask(); 
                	  
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.APPLICATION_FORM_SALE_ADD_PROGRAM, //URL-:rest/applicationProgram/saveAll
                        jsonData: jsonFormatFormData,
                        method: 'POST',
                        success: function(form, action) {
                        	this$.hideWindowMask();
                            programTabGrid.getStore().reload();
                            programWindow.close();
                            showSuccessMessage(getAdmissionTranslation('APPLICATION_PROGRAM_ADD'), getAdmissionTranslation('APPLICATION_PROGRAM_ADD_MSG')); //Application programs added successfully.
                            if(applicantProfile){
                            	me.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);
                            }
                            if(applicantGrid){
                            	applicantGrid.getStore().reload();
                            }
                        }
                    });
                }
            } else {
            	this$.hideWindowMask();
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
            } else {
            	this$.hideWindowMask();
            	showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('PLEASE_SELECT_ANOTHER_PROGRAM_FOR_APPLICATION')); //Please select a record.
            }
        } else {
        	this$.hideWindowMask();
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    getStatus:function(data,selectedRecord,dataField,formField){
    	if(!isNullOrEmpty(selectedRecord.data[formField]) && (selectedRecord.data[formField]==='YES')){
    		data[dataField] = true;
    	}else{
    		data[dataField] = false;    		 
    	}       	     
    	return data;
    },

    /**
     * method to save the priority.				     						     
     * 
     */
    savePriority: function(me, grid) {
        var store = grid.getStore();
        var updatedRecords = store.getUpdatedRecords();
        var modifiedRecords = new Ext.util.HashMap();
        Ext.each(updatedRecords, function(rec) {
            modifiedRecords.add(rec.get('id'), rec.get('priority'));
        });
        var formValues = Ext.encode(modifiedRecords.map);
        if (formValues !== '{}' && formValues !== "") {
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.APPLICATION_FORM_SALE_UPDATE_PRIORITY, //rest/applicationProgram/updatePriority
                jsonData: formValues,
                method: 'PUT',
                success: function() {
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll(true);
                    showSuccessMessage(getAdmissionTranslation('PRIORITY'), getAdmissionTranslation('PRIORITY_MSG')); //Priority saved successfully.
                }
            });
        } else {
        	showWarningMessage(getAdmissionTranslation('PRIORITY'), getAdmissionTranslation('UPDATE_PRIORITY_MSG')); //Please update priority of atleast one record to save priority
        }
    },


    /**
     *method used for to set program group and load grid data with selected program group
     * 
     */
    loadProgramGroupWithGridData: function(me, programGroup, addProgramWindowGrid, addProgramTabGrid) {   
    	var me=this;
        var addProgramTabGridStore = addProgramTabGrid.getStore();
        if (addProgramTabGridStore.data.length > 0) { //Edit Program Case
            var programGroupId = addProgramTabGridStore.data.items[0].get('programGroupId');
            if (!isNullOrEmpty(programGroupId)) {
                programGroup.getStore().load({
                    callback: function() {
                        programGroup.setValue(programGroupId);
                        //programGroup.setDisabled(true);
                        addProgramWindowGrid.getStore().load({
                            params: {
                                programGroupId: programGroupId
                            },
                            callback: function() {
                                //Show already selected programs
                            	var selectedRecords=new Array();
                                addProgramTabGridStore.each(function(selectedRecord) {
                                    addProgramWindowGrid.getStore().each(function(visitedRecord) {
                                        if (selectedRecord.data.programBatchSeatConfigurationId === visitedRecord.data.programBatchSeatConfigurationId) {
                                        	if(!isNullOrEmpty(selectedRecord.data.distancetoTravel) && selectedRecord.data.distancetoTravel > 0)
                                        	visitedRecord.set('distancetoTravel',selectedRecord.data.distancetoTravel);
                                        	if((selectedRecord.data.whetherHostelApplicable == true)){
                                            	visitedRecord.set('whetherHostelApplicable', 'Yes');
                                        	}
                                        	if((selectedRecord.data.whetherHostelApplicable == false)){
                                        		visitedRecord.set('whetherHostelApplicable', 'No');
                                        	}
                                        	if((selectedRecord.data.whetherTransportApplicable == true)){
                                        		visitedRecord.set('whetherTransportApplicable' , 'Yes');
                                        	}
                                        	if((selectedRecord.data.whetherTransportApplicable == false)){
                                        		visitedRecord.set('whetherTransportApplicable' , 'No');
                                        	}
                                        	selectedRecords.push(visitedRecord);
                                        }
                                        
                                    });
                                });
                                if(selectedRecords.length>0){
                                	addProgramWindowGrid.getSelectionModel().select(selectedRecords);
                                }                                
                            }
                        });
                    }
                });
            }
        } else { //Add Program Case
            programGroup.getStore().load();
            addProgramWindowGrid.getStore().load();
        }

        addProgramWindowGrid.getStore().on('beforeload', function(store, operation) {
            var selectedProgramGroup = programGroup.getValue();
            store.proxy.extraParams = {
                programGroupId: selectedProgramGroup
            };
        });

    },
    
    openApplicationFeeTab:function(applicationFormSale, windowXtype){
    	var me=this;
    	if (applicationFormSale) {
       	 	var applicationFeeTab=me.getTabReferenceByTabTitle(getAdmissionTranslation('APPLICATION_FEE'));                    
            if (applicationFeeTab) {
            	me.closeTab(applicationFeeTab);
            }
            applicationFeeTab=me.openTab(getAdmissionTranslation('APPLICATION_FEE'), windowXtype);	
            if(applicationFeeTab){
              	 var grid=applicationFeeTab.down('#ApplicationFeeApplicantGrid');
              	 if(grid){
              		 grid.down('#txtTokenId').setValue(applicationFormSale.getGeneratedToken());           		 
              		 var findApplication = grid.down('#btnFindApplication');
              		findApplication.fireEvent('click');
              	 }
               }
        }
    },
    
    openSubmissionFeeTab:function(applicationFormSale, windowXtype){
    	var me=this;
    	if (applicationFormSale) {
       	 	var submissionFeeTab=me.getTabReferenceByTabTitle(getAdmissionTranslation('SUBMISSION_FEE'));                    
            if (submissionFeeTab) {
            	me.closeTab(submissionFeeTab);
            }
            
            submissionFeeTab=me.openTab(getAdmissionTranslation('SUBMISSION_FEE'), windowXtype);
            //applicationFeeTab=me.openTab(getAdmissionTranslation('APPLICATION_FEE'),'applicationfee');
            
            if(submissionFeeTab){
              	 var grid=submissionFeeTab.down('#SubmissionFeeApplicantGrid');
              	 if(grid){
              		 grid.down('#txtTokenId').setValue(applicationFormSale.getGeneratedToken());           		 
              		 var findApplication = grid.down('#btnFindApplication');
              		findApplication.fireEvent('click');
              	 }
               }
        }
    },
    
    openAssignApplicationTab:function(applicationFormSale,stageName){
    	var me=this;
    	if (applicationFormSale) {
       	 	var assignAppLicationTab=me.getTabReferenceByTabTitle(getAdmissionTranslation('ASSIGN_APP_ID'));                    
            if (assignAppLicationTab) {
            	me.closeTab(assignAppLicationTab);
            }
            

        	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
        	coreErpNavigationController.loadContollers('assignapplicationid');
            assignAppLicationTab=me.openTab(getAdmissionTranslation('ASSIGN_APP_ID'),null,CONSTANTS.MENU_COLOR_TWO);
            if(assignAppLicationTab){
             var assignApplicationIdGrid={
                 xtype: 'assignapplicationidgrid',
                 itemId:'assignApplicationIdGrid',
                 stageName:'Application form sale',
                 feePlanType:'Application'
             };
             Ext.apply(assignApplicationIdGrid, {
            	 gridFilterWithTokenFlag: true
             });
             assignAppLicationTab.add(assignApplicationIdGrid);
           	 var grid=assignAppLicationTab.down('#assignApplicationIdGrid');
           	 if(grid){
           		 
                 grid.down('#txtTokenId').setValue(applicationFormSale.getGeneratedToken());          
           		 
           		var searchCriteria = me.createSearchCriteria(grid);
                 searchCriteria.stageName=stageName;
                 
                 if(!isNullOrEmpty(applicationFormSale.getGeneratedToken())){
                	 searchCriteria.requestType=null; 
                 }                        
                 
                 grid.getStore().load({
                     params: searchCriteria
                 });           		
           	 }
            }
        }
    },

    /**
     * method used for to submit application form
     * 
     */
    submitApplicationForm: function(me, applicantGrid, applicationFormSale, applicationformbuttonpanel, collectionForm, formId, formValues, applicationStatus,applicantRelatives,applicationForm) {
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.APPLICATION_FORM_SALE_GENERATE_TOKEN, //URL-:rest/applicationForm/token						                
            method: 'GET',
            params: {
                applicationFormId: formId	
            },
            success: function(response, form) {
                var tokenValue = response.responseText;
                             
                if (!isNullOrEmpty(tokenValue)) {
                	applicationFormSale.setGeneratedToken(tokenValue);
                    var jsonFormatFormData = me.getJsonDataForApplicationFormSale(me, formValues, tokenValue, formId, applicationStatus);
                    if (!isNullOrEmpty(jsonFormatFormData)) {
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.APPLICATION_FORM_SALE_UPDATE, //URL-:rest/application/update
                            jsonData: jsonFormatFormData,
                            method: 'PUT',
                            success: function(form, action) {
                            	Ext.getBody().unmask();  
                                if (collectionForm) {                                    
                                	toggleReadOnlyFormItems(collectionForm.getForm(),true);
                                }
                                
                                if(applicantGrid){                                	                       	
                                    applicantGrid.down('#btnAdd').setDisabled(true);
                                    applicantGrid.down('#btnDelete').setDisabled(true);                                                                       
                                }      
                                
                                if(applicationForm){
                                	toggleReadOnlyFormItems(applicationForm.getForm(),true);
                                }
                                
                                if(applicantRelatives){
                                	Ext.each(applicantRelatives.items.items, function(tab) {
                                        if (!tab.disabled) {
                                            tab.setDisabled(true);
                                        }                            
                                    });
                                }                                                               
                                
                                applicationformbuttonpanel.down('#submitApplicationFormDetails').setDisabled(true);
                                applicationformbuttonpanel.down('#makePaymentButton').setDisabled(false);
                                applicationformbuttonpanel.down('#assignAppIdButton').setDisabled(false);
                                applicationformbuttonpanel.down('#cancelApplicationFormButton').setDisabled(true);
                                //applicationFormSale.close();
                                showSuccessMessage(getAdmissionTranslation('SUBMIT_APPLICATION_FORM'), getAdmissionTranslation('SUBMIT_APPLICATION_FORM_MSG')); //Application form submitted successfully						                    
                            }
                        });
                    }
                }
            }
        });
    },

    /**
     * This function is used for to give application form data in json format
     *     
     */
    getJsonDataForApplicationFormSale: function(me, data, token, formId, applicationStatus) {
        var applicationFormSaleObject = new Object();       
        applicationFormSaleObject.id = formId;
        applicationFormSaleObject.token = token;
        applicationFormSaleObject.applicationStatus = applicationStatus;
        if (!isEmpty(data)) {
        	 applicationFormSaleObject.collectedBy = data.collectedBy;
             applicationFormSaleObject.saleDate = data.appFormSaleDate;
             applicationFormSaleObject.collectedByFirstName = data.firstName;
             applicationFormSaleObject.collectedByMiddleName = data.middleName;
             applicationFormSaleObject.collectedByLastName = data.lastName;
             applicationFormSaleObject.collectedByCountryCode = data.mobileCountryCode;
             applicationFormSaleObject.collectedByPhoneNo = data.mobileNumber;
             applicationFormSaleObject.collectedByLLCountryCode = data.phoneCountryCode;
             applicationFormSaleObject.collectedByLLAreaCode = data.phoneAreaCode;
             applicationFormSaleObject.collectedByLandlineNo = data.phoneNo;
             applicationFormSaleObject.collectedByEmail = data.emailId;
             applicationFormSaleObject.collectedByAddress = data.address;
             applicationFormSaleObject.handedOverToApplicant = null;
             applicationFormSaleObject.handedOverToEnquirer = null;
        }
        return Ext.encode(applicationFormSaleObject);
    },
    
    /*
     *  Load store on grid renderer
     */
    loadGridStore: function(grid, applicantRelatives, url) {
        var this$ = this;
        if (grid) {
        	var personId = applicantRelatives.getPersonId();
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.load({
                params: {
                    personId: personId
                }
            });

            store.on('beforeload', function(store, operation) {
            	var personId = applicantRelatives.getPersonId();
                store.proxy.extraParams = {
                    personId: personId
                };
            });
        }
    },
    resetNameFields : function(form){
    	form.getForm().getFields().each(function(field) {
    		if(field.name == 'firstName' || field.name == 'middleName' || field.name == 'laseName' || field.name=='shortName' || field.name=='printName') {
    			field.reset();	
    		}
    	});
    	Ext.resumeLayouts();
    },
    copyPersonalDataForAppliedEarlier:function(fromObject,toObject){
    	toObject.salutation = (!isEmpty(fromObject.person.salutation)) ? fromObject.person.salutation.id : "";
		toObject.firstName = fromObject.person.firstName;
		toObject.middleName = fromObject.person.middleName;
		toObject.lastName = fromObject.person.lastName;
		toObject.shortName = fromObject.person.shortName;
		toObject.printName = fromObject.person.printName;
		toObject.birthDate = fromObject.person.birthDate;
		toObject.genderCSM = fromObject.person.genderCSM;
		toObject.category= fromObject.person.category;
		toObject.castCategory= fromObject.person.casteCategory;
		toObject.country= fromObject.person.country;                        
		toObject.nationality= fromObject.person.nationality;
		toObject.religion= fromObject.person.religion;
		toObject.maritalStatus = (!isNullOrEmpty(fromObject.person.maritalStatusId)) ? fromObject.person.maritalStatusId.id : null;
		toObject.personalIncome= fromObject.person.personalIncome;                                                                                                
		toObject.bankDetail= fromObject.person.bankDetail;
		toObject.bloodGroup= fromObject.person.bloodGroup;
		toObject.name = fromObject.person.firstName + (!isNullOrEmpty(fromObject.person.middleName)?" " +fromObject.person.middleName:"") +(!isNullOrEmpty(fromObject.person.lastName)?" " +fromObject.person.lastName:"");
		toObject.firstNameOtherLanguage = fromObject.person.firstNameOtherLanguage,
		toObject.lastNameOtherLanguage = fromObject.person.lastNameOtherLanguage;
		toObject.middleNameOtherLanguage = fromObject.person.middleNameOtherLanguage;
		toObject.printNameOtherLanguage = fromObject.person.printNameOtherLanguage;
		toObject.shortNameOtherLanguage = fromObject.person.shortNameOtherLanguage;
		toObject.birthPlace = fromObject.person.birthPlace;
		toObject.birthPlaceOtherLanguage = fromObject.person.birthPlaceOtherLanguage;
		
		toObject.cellNo = fromObject.person.mobileNumber;
		toObject.mobileNumber = fromObject.person.mobileNumber;
		toObject.mobileCountryCode = fromObject.person.mobileCountryCode;
		toObject.alternateMobileCountryCode = fromObject.person.alternateMobileCountryCode;
		toObject.alternateMobileNo = fromObject.person.alternateMobileNo;
		
                    
		toObject.phoneNo = fromObject.person.phoneNo;
		toObject.phoneAreaCode = fromObject.person.phoneAreaCode;
		toObject.phoneCountryCode = fromObject.person.phoneCountryCode;
                    
		toObject.emailId = (!isNullOrEmpty(fromObject.person.emailId)) ? fromObject.person.emailId : null;
		toObject.alternateEmailId = (!isNullOrEmpty(fromObject.person.alternateEmailId)) ? fromObject.person.alternateEmailId : null;
		toObject.nationalID = fromObject.person.nationalID;
		toObject.fieldOfInterest = fromObject.person.fieldOfInterest;
		toObject.secondaryCitizenship = fromObject.person.secondaryCitizenship;
		toObject.sadcCitizenship = fromObject.person.sadcCitizenship;
		toObject.wsenquiryMultipleMode = fromObject.applicationEnquiryMultipleMode;
		toObject.idtype = fromObject.person.idtype;
		toObject.identityExpiryDate = fromObject.person.identityExpiryDate;
		toObject.domicile = fromObject.person.domicile;
		toObject.examCenterCSM = fromObject.person.examCenterCSM;
		toObject.currentActivity = fromObject.person.currentActivity;
		toObject.applicantPersonDisability = fromObject.person.applicantPersonDisability;
		toObject.applicantPersonEducationInterventions = fromObject.person.applicantPersonEducationInterventions;
		toObject.areaOfResearch = fromObject.person.areaOfResearch;
		toObject.homeLanguage = fromObject.person.homeLanguage;
		toObject.advisorId = fromObject.person.advisorId;
		toObject.secondLanguage = fromObject.person.secondLanguage;
		toObject.correspondenceLanguage = fromObject.person.correspondenceLanguage;
		toObject.contactLanguage = fromObject.person.contactLanguage;
		toObject.comments = fromObject.person.comments;
		
		toObject.campaignNew = (!isNullOrEmpty(fromObject.person.campaignNew)) ? fromObject.person.campaignNew.id : null;
		toObject.campaignSchool = (!isNullOrEmpty(fromObject.person.campaignSchool)) ? fromObject.person.campaignSchool.id : null;
		toObject.enquirySource = (!isNullOrEmpty(fromObject.person.enquirySource)) ? fromObject.person.enquirySource.id : null;
		toObject.whetherCompanySponsored = fromObject.person.whetherCompanySponsored;
		toObject.isLearnerSACitizen = fromObject.person.isLearnerSACitizen;
		toObject.externalSysRefOne = fromObject.person.externalSysRefOne;
		toObject.externalSysRefTwo = fromObject.person.externalSysRefTwo;
		toObject.externalSysRefThree = fromObject.person.externalSysRefThree;
		toObject.applicantSchoolPriority = fromObject.person.applicantSchoolPriority;
		
		toObject.isWheelChairRequired = fromObject.person.isWheelChairRequired;
		toObject.isPermanentResident = fromObject.person.isPermanentResident;
		toObject.isAsylumSeeker = fromObject.person.isAsylumSeeker;
		toObject.areYouRefugee = fromObject.person.areYouRefugee;
		toObject.isTertiaryInstitution = fromObject.person.isTertiaryInstitution;
		toObject.isMilitarySponsored = fromObject.person.isMilitarySponsored;
		toObject.pHDSponsor = fromObject.person.pHDSponsor;
		toObject.isBursaryRequirements = fromObject.person.isBursaryRequirements;
		toObject.boardNumber = fromObject.person.boardNumber;
		toObject.postNumber = fromObject.person.postNumber;
		toObject.accountingKey = fromObject.person.accountingKey;
		toObject.hpcsaRegNo = fromObject.person.hpcsaRegNo;
		toObject.armsOfService = (!isNullOrEmpty(fromObject.person.armsOfService)) ? fromObject.person.armsOfService.id : null;
		toObject.mustering = (!isNullOrEmpty(fromObject.person.mustering)) ? fromObject.person.mustering.id : null;
		toObject.enquiryOwnerId = (!isNullOrEmpty(fromObject.applicationOwner)) ? fromObject.applicationOwner.id : null;
		toObject.areYouRegisteredAtOtherSAU = fromObject.person.areYouRegisteredAtOtherSAU;
		toObject.haveYouStudiedAtUWC = fromObject.person.haveYouStudiedAtUWC;
		toObject.studentNoAtUWC = fromObject.person.studentNoAtUWC;
		toObject.studentNoAtOtherSAU= fromObject.person.studentNoAtOtherSAU;
		toObject.emergencyFirstName= fromObject.person.emergencyFirstName;
		toObject.emergencyLastName= fromObject.person.emergencyLastName;
		toObject.emergencyMobileCountryCode= fromObject.person.emergencyMobileCountryCode;
		toObject.emergencyMobileNumber= fromObject.person.emergencyMobileNumber;

		
		
		
    }
});
