/**
 * This controller is used for applicant documents information actions.   
 */
Ext.define('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController', {
	
    extend: 'Academia.controller.personinfo.common.PersonCommonController',        

    mixins: {
    	ApplicationBaseController: 'Academia.controller.admission.applications.applicationBase.ApplicationBaseController'
    },
    
    models: ['personinfo.common.documents.DocumentModel','Academia.model.dashboard.EmployeeRequestedDocumentsModel'],

    stores: ['personinfo.common.documents.DocumentStore','common.DocumentTypeStore','common.DocTypeStore','documentmanagement.DocumentMasterStore',
             'examinationcenters.evaluationgrouplisting.documentsubmit.DocumentNameByEvalGroup',
             'common.LiveSearchCombos','document.DocumentModeSubmissionStore','document.DocumentModeSubmissionStore',
             'document.DocumentStatusStore','admission.selectionProcess.Applicabilities',
             'admission.applications.applicantdocuments.ApplicantDocumentStore',
             'Academia.store.common.AcademyStore', 
			 'Academia.store.common.LocationStore', 			
			 'Academia.store.facilitiesresources.resourcemaster.LocationListStore',
			 'Academia.store.common.ProgramsByAcademyIdLocationId', 			
			 'common.BatchesByProgramId',
			 'Academia.store.program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore',
			 'Academia.store.course.CourseStageStore',
			 'Academia.store.admission.applications.applicationBase.ApplicationStageStatusComboStore',
			 "Academia.store.admission.selectionStage.SelectionStageFromSeatType","common.ProgramByAcademyLocationStore",
			 "user.UserAcademyLocationStore","common.SeatTypesByBatchId",
			 "common.ProgramByApplicantStore","user.UserAcademyLocationWithApplicantStore",'personinfo.common.documents.ProgramBatchSeatTypeDocumentStore'
			,'common.DocumentStatusCSMStore', 'common.documentRequstedByPersonId','common.documentRequstedByGroupMasterId',
			'admission.applications.applicantdocuments.ApplicantAdhocDocumentStore'],

    views: ['personinfo.common.documents.DocumentGrid', 'document.DocumentFormWindow', 
            'document.SimpleDocumentForm', 'document.ExtendedDocumentForm',
            'Academia.view.personinfo.common.documents.DocumentSearchForm',
            'Academia.view.personinfo.common.documents.DocumentSearchPanel',
            'admission.applications.applicantProfileBase.ApplicantProfile','personinfo.common.pasthistory.ApplicantUploadDocStructure',
            'personinfo.common.documents.ProgramBatchSeatTypeGridWindow','personinfo.common.documentrequested.ApplicantDocumentRequestedStructure',
            'personinfo.common.documentrequested.ApplicantDocumentRequestedGrid','personinfo.common.documentrequested.DocumentRequestedWin',
            'personinfo.common.documentrequested.DocumentRequestedWinGrid','Academia.view.document.SimpleDocumentForm',
            'personinfo.common.documentrequested.DocumentRequestedWinGrid','Academia.view.document.SimpleDocumentForm','admission.applications.applicationBase.DocumentNoteWindow',
            'personinfo.common.documents.AdhocDocumentGrid','document.AdhocDocumentFormWindow','document.AddDocumentFormWindow',
            'personinfo.common.documents.DocumentRemarkFormWin','document.ApplicantBulkDocUpdateForm','document.DocumentPreviewWindow'],

    alias: "widget.applicantdocumentcontroller",

    refs: [{
        ref: 'documentGrid',
        selector: 'documentgrid[itemId=applicantDocumentGrid]'
    },{
    	ref: 'applicantProfile',
    	selector : 'applicantprofile'
    },{
    	ref: 'extendeddocumentform',
    	selector : 'extendeddocumentform[itemId=extendedDocumentForm]'
    },{
    	ref:'documentsearchform',
    	selector:'documentsearchform'
    },{
    	ref:'programbatchseattypegridwindow',
    	selector:'programbatchseattypegridwindow'
    },{
    	ref:'applicantdocumentrequestedstructure',
    	selector:'applicantdocumentrequestedstructure'
    },{
    	ref:'applicantdocumentrequestedgrid',
    	selector:'applicantdocumentrequestedgrid'
    },{
    	ref:'documentrequestedwin',
    	selector:'documentrequestedwin'
    },{
    	ref:'documentrequestedwingrid',
    	selector:'documentrequestedwingrid'
    },{
    	ref:'simpledocumentform',
    	selector:'simpledocumentform'
    },{
    	ref :'documentNoteWindow',
    	selector : 'documentNoteWindow'
    },{
    	ref: 'adhocDocumentGrid',
    	selector : 'adhocdocumentgrid[itemId=adhocDocumentGridItemId]'
    },{
    	ref: 'applicantadhocdocumentformwindow',
    	selector : 'adhocdocumentformwindow[itemId=applicantAdhocDocumentFormWindow]'
    },{
        ref: 'applicantadhocdocumentremarkformwin',
        selector: 'documentremarkformwin[itemId=applicantAdhocDocumentRemarkFormWin]'
    },{
        ref: 'applicantbulkdocupdateform',
        selector: 'applicantbulkdocupdateform'
    },{
    	ref: 'applicantdocumentformwindow',
    	selector : 'adddocumentformwindow[itemId=applicantDocumentFormWindow]'
    },{
    	ref: 'documentpreviewwindow',
    	selector: 'documentpreviewwindow'
    }],
    
    config: {
    	APPLICANT_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_DOCUMENTS_PRIVILEGES'),
    	AD_HOC_APPLICANT_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('AD_HOC_APPLICATION_DOCUMENTS_PRIVILEGES'),
    	APPLICANT_DOCUMENT_REQUESTED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_DOCUMENT_REQUESTED_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            /*Documents Details*/

        	'documentgrid[itemId=applicantDocumentGrid]': {
        		render: function(grid) {
        			this.doAccessControlValidation(grid, this.getAPPLICANT_DOCUMENTS_PERMISSIONS());
        			this.disableUploadDocumentPivileges(grid, this.getAPPLICANT_DOCUMENTS_PERMISSIONS());
        			this.showContainerInViewMode(grid);    
        			this.loadGridStore('#applicantDocumentGrid', '#applicantDocumentForm');
        			var portalId = this.getCurrentLoggedPortalId();
        			if(portalId==6){
        				grid.down('toolbar').down('#btnEdit').setVisible(false);
        			}
        			if(portalId!=1){
        				grid.down('toolbar').down('#btnAdd').setVisible(false);
        			}
        			grid.down('#documentApplicabilityItem').setVisible(true);
        			var form=this.getDocumentsearchform();
        			var applicantProfile= this.getContentPanelActiveTab();
        			if(form!=undefined){
        				var store = form.getForm().findField('academyLocation').getStore();
            			store.getProxy().extraParams = {
            				applicantId:applicantProfile.applicationId
            			};	
        			}
        			grid.getStore().getProxy().extraParams={
        				applicationId:applicantProfile.applicationId
        			};
        			var applicantProfileView = applicantProfile.down('#applicantProfileTemplate');
					if (!isNullOrEmpty(applicantProfile.applicationId)) {
						var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
						if (!isNullOrEmpty(url)) {
							url = url.concat("?id=" + applicantProfile.applicationId);
							Ext.Ajax.request({
								type: 'rest',
								url: url,
								method: 'GET',
								success: function(res, action) {
									if (portalId == 6) {
										if (Ext.ComponentQuery.query('dashboardhomepage').length != 0) {
											Ext.ComponentQuery.query('dashboardhomepage')[0].close();
										}
										if (Ext.ComponentQuery.query('userinfo').length != 0) {
											var dashBoardMenu = Ext.ComponentQuery.query('userinfo')[0];
											dashBoardMenu.down("#myDashboard").setVisible(false);
										}
									}
									var data = Ext.decode(res.responseText);
									if (!isNullOrEmpty(data) && !isNullOrEmpty(data.currentStatus)) {
										data.currentStatus = getAdmissionTranslation(data.currentStatus);
									}
									var tpl = applicantProfileView.tpl;
									if (Ext.isDefined(applicantProfileView.el)) {
										tpl.overwrite(applicantProfileView.el.dom, data);
									}
									if (portalId == 6) {
										if (!isNullOrEmpty(applicantProfileView.up().down('form'))) {
											applicantProfileView.up().down('form').getForm().setValues(data);
											var formFields = applicantProfileView.up().down('form').getForm().getFields().items;
											Ext.each(formFields, function(currentField) {
												if (isNullOrEmpty(currentField.getValue())) {
													currentField.hide();
												} else {
													currentField.show();
												}
											});
										}
									}
								}
							});
						}
					}
        		},
  
        		afterrender:function(grid){
        			var me=this;
        			setTimeout(function(){
        				me.addDataGridConfigButton(grid, me.getAPPLICANT_DOCUMENTS_PERMISSIONS());
        			},
        			1500);
        			},
        		cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
        			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
        			 if(columnName=='documentType'){
        				 if (e.target.tagName == 'A') {
             				this.cellClickApplicantDocumentGrid(grid, td, cellIndex, record, tr, rowIndex, e, eOpts);
             			} 
        			 }
        			 if(columnName=='programBatchSeatTypeAssociated'){
        				 if (e.target.tagName == 'A') {
        					 this.openProgramBtachSeatTypeDetailsWindow(grid,record);
             			} 
        			 }
        				 if(columnName =='documentNote'){
            				 if (e.target.tagName == 'A') {
        				 var window = this.getDocumentNoteWindow();
        	    			if(!window){
        	    				window = Ext.widget('documentNoteWindow');
        	    			}
        	    			window.show();
        	    			var record = grid.getSelectionModel().getSelection()[0];
        	    			var documentNoteField = window.down('#documentnote');
        	    			documentNoteField.setValue(record.data.documentNote);
        			 }
        				 }
        				 
                		 if(e.target.tagName == "A" &&(columnName == "previewDoc") ){
                 			var previewWindow = this.getDocumentpreviewwindow();
     						if (!previewWindow) {
     							Ext.widget('documentpreviewwindow', {
     								documentRecord: record,
     								width: '100%',
     								height: Ext.getBody().getHeight(),
     								itemId: 'appDocPreviewWindow'
     							});
     							previewWindow = this.getDocumentpreviewwindow();
     						}

     						previewWindow.show();
                 		}
        		},
        		selectionchange: function(column, selected, eOpts){
        			var this$ = this;
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down('#applicantDocumentGrid');
        			var editButton = grid.down('#btnEdit');
        			var uploadDocButton = grid.down('#uploadDocumentBtn');
        			var updateBulkDocumentButton = grid.down('#updateBulkDocumentBtn');
        			if(grid.getSelectionModel().getCount()>1) {
        				editButton.setDisabled(true);
        				uploadDocButton.setDisabled(true);
        				updateBulkDocumentButton.setDisabled(false);
        			} else if(grid.getSelectionModel().getCount()==1) {
        				editButton.setDisabled(false);
        				uploadDocButton.setDisabled(false);
        				updateBulkDocumentButton.setDisabled(true);
        			} else {
        				editButton.setDisabled(true);
        				uploadDocButton.setDisabled(true);
        				updateBulkDocumentButton.setDisabled(true);
        			}
                }
        	},
        	'documentpreviewwindow[itemId=appDocPreviewWindow]':{
            	afterrender: function(win){
            		var me = this;
            		var documentRecord = win.documentRecord;
            		var documentId = documentRecord.data.documentId;
            		var id = documentRecord.data.id;
            		var fileExtension = documentRecord.data.path.split('.').pop();
            		win.setTitle(documentRecord.data.documentName);
            		if(!isNullOrEmpty(documentId) && documentId){
            				Ext.Ajax.request({
            					type: 'rest',
            					url: SERVERURL.PATH_GET_BASE64_DOCUMENT_BY_DOCUMENT,
            					params: {
            						documentId: documentId
                                },
            					method: 'GET',
            					success: function(res, action) {
            						var responseTxt = res.responseText;
            						if(responseTxt != ''){
                						if(fileExtension.toUpperCase() == "PDF"){
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
                						}
                						else{
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
                						}
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
            						}
            					}
            				});
            		}else if(!isNullOrEmpty(id) && id){
        				Ext.Ajax.request({
        					type: 'rest',
        					url: SERVERURL.PATH_GET_BASE64_DYNAMIC_DOCUMENT_BY_ID + id,
        					method: 'GET',
        					success: function(res, action) {
        						var responseTxt = res.responseText;
        						if(responseTxt != ''){
            						if(fileExtension.toUpperCase() == "PDF"){
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
            						}
        						}
        						else{
        							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
        						}
        					}
        				});
        		     }
            	}
            },
        	 'documentgrid[itemId=applicantDocumentGrid] button[itemId=btnAdd]': {                
        		 click: function() {
	            		var $this = this;
	            		var personProfile = $this.getContentPanelActiveTab();
						var grid = personProfile.down('#applicantDocumentGrid');
	            		grid.getSelectionModel().deselectAll();
	            		$this.showApplicantDocumentFormWindow();
	            	}
             },
            'documentgrid[itemId=applicantDocumentGrid] button[itemId=btnEdit]': {                
                click: function(){
                	var isView = false;
                	this.editDocumentFormWindow(isView);                                                 	
                }
            },
            'documentgrid[itemId=applicantDocumentGrid] button[itemId=btnView]': {
            	click: function(){
                	var isView = true;
                	this.editDocumentFormWindow(isView);                                                 	
                }                                 
            },
            'documentgrid[itemId=applicantDocumentGrid] button[itemId=updateBulkDocumentBtn]': {                
                click: function(){
                	var this$ = this;
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down('#applicantDocumentGrid');
                    var pendingCount = 0;
                    var statusCode = null;
            		if (grid.getSelectionModel().getCount() > 0) {
            			var records = grid.getSelectionModel().getSelection();
            			var documentName="";
            			for(var i in records){
            				if(!isNullOrEmpty(records[i].data.documentStatusCSM) && !isNullOrEmpty(records[i].data.documentStatusCSM.code)) {
            					if(records[i].data.documentStatusCSM.code=='PENDING' || records[i].data.documentStatusCSM.code=='PENDING_OPTIONAL') {
            						pendingCount++;
            					} else if(isNullOrEmpty(statusCode)) {
            						statusCode=records[i].data.documentStatusCSM.code;
            					} else if(statusCode!=records[i].data.documentStatusCSM.code) {
            						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_SIMILAR_RECORDS_FOR_BULK_DOC_UPDATE'));
            						return false;
            					}
            				} else {
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_SIMILAR_RECORDS_FOR_BULK_DOC_UPDATE'));
            					return false;
            				}
            				if(!isNullOrEmpty(records[i].data.documentType) && !isNullOrEmpty(records[i].data.documentType.value)) {
            					if(!isNullOrEmpty(documentName)) {
            						documentName = documentName + ", " + records[i].data.documentType.value;
            					} else {
            						documentName = records[i].data.documentType.value;
            					}
            				}
            			} 
            			if(pendingCount==grid.getSelectionModel().getCount()) {
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CAN_NOT_WORK_WITH_PENDING_STATUS'));
            				return false;
            			} else if(pendingCount>0) {
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_SIMILAR_RECORDS_FOR_BULK_DOC_UPDATE'));
            				return false;
            			}
            			var window = this$.getApplicantbulkdocupdateform();
            			if(!window){
            				window = Ext.widget('applicantbulkdocupdateform');
            			}
            			var documentNameField = window.down('#documentNameId');
            			documentNameField.setValue(documentName);
            			documentNameField.setReadOnly(true);
            			window.show();
            			window.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
            		} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}  
                }
            },
            'applicantbulkdocupdateform radiogroup[itemId=inspectionDoneRadioGroupField]': {
                change: function(radioField,newValue,oldValue,eOpts){
            		var this$ = this;
                    var form = this$.getApplicantbulkdocupdateform().down('idgeneratorformwin');
                    var inspectionDateField = form.down('#inspectionDateField');
        			var inspectionDoneByField = form.down('#inspectionDoneByField');
            		if(newValue.isInspectionDone) {
            			inspectionDateField.setDisabled(false);
            			inspectionDoneByField.setDisabled(false);
            			inspectionDateField.setValue(dateRender(new Date()));
            			inspectionDoneByField.getStore().load({
                			scope:this,
            				callback: function(rec, callback){
            					var currentUserId = this$.getCurrentlyLoggedInUser().id;
            					inspectionDoneByField.setValue(currentUserId);
            				}
            			});
            			form.getForm().isValid();
            		} else {
            			inspectionDateField.reset();
            			inspectionDoneByField.reset();
            			inspectionDateField.setDisabled(true);
            			inspectionDoneByField.setDisabled(true);
            		}
            		form.getForm().checkValidity();
                }
            },
            'applicantbulkdocupdateform button[itemId=documentFormSubmitButtonId]': {
            	click: function() {
            		this.editBulkDocumentUpdateFormData();
            	}
            },
            'applicantbulkdocupdateform button[itemId=documentCancelButtonId]': {
            	click: function(obj) {
            		obj.up('window').close();
            	}
            },
              'documentNoteWindow button#document_cancelbuttonId': {
	        	click: function(obj) {
	        		 obj.up('window').close();
	        	}
	        },
            'documentformwindow[itemId=applicantDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: function(){
                	this.saveApplicantDocumentForm();
                }
            },
            'documentformwindow[itemId=applicantDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
                click: function(){
                	this.closeDocumentFormWindow();
                }
            },
            'adddocumentformwindow[itemId=applicantDocumentFormWindow] button[itemId=documentCancelButtonId]': {
            	click: function() {
            		var formWindow = this.getApplicantdocumentformwindow();
            		formWindow.close();
            	}
            },
            'adddocumentformwindow[itemId=applicantDocumentFormWindow] button[itemId=documentFormSubmitButtonId]': {
            	click: function() {
            		this.saveApplicantDocumentFormData();
            	}
            },
            'extendeddocumentform[itemId=extendedDocumentForm]':{
            	afterrender: function(form) {
            		//this.loadFieldByDFR(form);
            	}
            },
            'documentsearchform[itemId=applicantDocumentForm] acadlocprogbatchseattypecomponent customcombobox#seatTypeCombo': {
            	select: function(seatTypeCombo) {
            		this.loadSelectionStageCombo(seatTypeCombo, seatTypeCombo.getValue());
            	}
            },
            'documentsearchform[itemId=applicantDocumentForm] button[itemId=searchButtonId]': {            	
            	click: function(button) {
            		this.loadGridStore('#applicantDocumentGrid', '#applicantDocumentForm');
            	}                                                   
            },
            'documentsearchform[itemId=applicantDocumentForm] button[itemId=clearSearch]': {            	
            	click: function(button) {
            		var form = button.up('#applicantDocumentForm');
            		this.resetAllFormField(form);
            	}                                                   
            },
            'documentformwindow[itemId=applicantDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] #fileDisplayField': {
                render: function(component) {
                	var me = this;
	                component.getEl().on('click', function(e) {
	                	me.downloadApplicantDocumentFile();
	                });
                }
            },
             
            'documentsearchform[itemId=applicantDocumentForm] acadlocprogbatchseattypecomponent combo': {
            	select: function(combo) {
            		this.resetSelectionStageCombo(combo);
            	}
            },
            'documentgrid[itemId=applicantDocumentGrid] button[itemId=uploadDocumentBtn]': {                
            click: function(){
            	var isView = false;
            	this.uploadDocumentFormWindow(isView);                                                 	
            }
        },
           'documentformwindow[itemId=applicantDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] filefield[itemId=uploadFileField]': {
        	   change: function(fileField, value, eOpts) {
        		   if (!isNullOrEmpty(value)) {
        			   var $this = this;
        			   value = value.replace('C:\\fakepath\\', '');
            		   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		   fileField.setRawValue(newValue);
            		   var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                       var specialCharsExist=false;
                            for(i = 0; i < specialChars.length;i++){
                              if(newValue.indexOf(specialChars[i]) > -1){
                                  specialCharsExist= true;
                               }
                            }
                           if(specialCharsExist){
                        	   fileField.reset();
                               showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                           }
                           
        		       var form = fileField.up().up();
        		       var fileInfoContainer = form.down('#fileInfoContainer');
        		       var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
        		       if ($this.isValidFileExtension(extension)) {
        		           var file = fileField.fileInputEl.dom.files[0];
        		           if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
        		               fileInfoContainer.setVisible(false);
        		               fileField.reset();
        		               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_FIVE_MB'));
        		           } else {
        		               var form = fileField.up().up();
        		               var fileInfoContainer = form.down('#fileInfoContainer');
        		               fileInfoContainer.setVisible(true);
        		               var docDetails = form.down('#docDetails');
        		               docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
        		           }
        		       } else {
        		           fileInfoContainer.setVisible(false);
        		           fileField.reset();
        		           showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
        		       }
        		   }
        	   }
            },
            'documentsearchform[itemId=applicantDocumentForm] combo[itemId=academyCombo]':{
            	select:function(combo){
            		var form = combo.up('documentsearchform');
            		var program = form.down('#programId');
            		program.setDisabled(false);
            		program.reset();
            		var applicantProfile= this.getApplicantProfile();
            		var academyLocationId = combo.getValue();
            		var store = program.getStore();
            		store.getProxy().extraParams = {
            			academyLocationId: academyLocationId,
            			applicationID:applicantProfile.applicationId
            		};
            		store.load();
				}
			},
			'documentsearchform[itemId=applicantDocumentForm] combo[itemId=programId]':{
				select:function(combo){
					var form = combo.up('documentsearchform');
            		var batchField = form.down('#batchCombo');
            		var programId=combo.getValue();
            		batchField.setDisabled(false);
        			batchField.reset();
        			batchField.getStore().getProxy().extraParams={
        				id:programId
        			};
        			batchField.getStore().load();
				}
			},
			'documentsearchform[itemId=applicantDocumentForm] combo[itemId=batchCombo]':{
				select:function(combo){
					var form = combo.up('documentsearchform');
            		var seatTypeField = form.down('#seatTypeCombo');
            		var batchId=combo.getValue();
            		seatTypeField.setDisabled(false);
            		seatTypeField.reset();
            		seatTypeField.getStore().getProxy().extraParams={
            			batchId:batchId
        			};
            		seatTypeField.getStore().load();
				}
			},
			'documentsearchform[itemId=applicantDocumentForm] combo[itemId=seatTypeCombo]':{
				select:function(combo){
					var form = combo.up('documentsearchform');
            		var selectionStageComboField = form.down('#selectionStageCombo');
            		var programBatchSeatConfigId=combo.getValue();
            		selectionStageComboField.setDisabled(false);
            		selectionStageComboField.reset();
            		selectionStageComboField.getStore().getProxy().extraParams={
            			programBatchSeatConfigId:programBatchSeatConfigId
        			};
            		selectionStageComboField.getStore().load();
				}
			},
			'applicantdocumentrequestedgrid':{
				render: function(grid) {
					var applicantProfile= this.getApplicantProfile();
					var gridStore = grid.getStore();
					grid.getStore().getProxy().extraParams={
						applicantPersonId:applicantProfile.personId
        			};
					grid.getStore().load();
        		},
        		cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
        			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
        			 if(columnName=='groupName'){
        				 if (e.target.tagName == 'A') {
        					var windowRef = Ext.widget('documentrequestedwin');
        				    windowRef.show();
             			} 
        			 }
        		}
			},
			'documentrequestedwingrid':{
				render: function(grid) {
					var this$ = this;
					var window = this$.getDocumentrequestedwin();
					var documentGrid = this$.getApplicantdocumentrequestedgrid();
					var record = documentGrid.getSelectionModel().getSelection()[0];
					window.setTitle(record.get('groupName'));
			    	var docId = record.get('id');
			    	var applicantProfile= this.getApplicantProfile();
			    	if(!isNullOrEmpty(docId)){
			    		grid.getStore().getProxy().extraParams={
			    			documentGroupMasterId:docId,
			    			applicantPersonId:applicantProfile.personId
	        			};
						grid.getStore().load();
			        }
        		},
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					 var $this = this;
					 var columnName =grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if (columnName == "upload") {
						this.getDocumentController().showDocumentFormWindow('ApplicantListOfDocument','DOCUMENT');	
					}else if (columnName == "referenceDocumentId"){
						if (e.target.tagName == 'A') {
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							var refDocId = selectedRecord.raw.referenceDocumentId;
							if(!isNullOrEmpty(refDocId)) {
								this.getDownloadDocumentFile(refDocId);

							}	
						}
					}  
				}
			},
			'documentrequestedwingrid button[itemId=downloadDocumentItemId]':{
	  			click: this.documentReportDocumentZip
	  		},
	  		'documentrequestedwingrid button[itemId=btnDelete]':{
	  			click: this.deleteDocumentsByPersonId
	  		},
	  		'documentformwindow[itemId=ApplicantListOfDocument] simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]':{
				change: function(fileField, val) {
					var $this=this;
			    	var form= $this.getSimpledocumentform();
			    	var saveBtn = form.down('#documentFormSubmitButtonId');
					var grid = $this.getDocumentrequestedwingrid();
					var record = grid.getSelectionModel().getSelection()[0];
					var docFormat ="";
					
					
					
					var format;
			    	var data;
			    	var extension = val.substring(val.lastIndexOf('.')+1);
			    	if(!isNullOrEmpty(record.raw.documentFormat)){
			    		data = record.raw.documentFormat.split(',');
			    		for(var i=0;i<data.length;i++){
			    			if(data[i]==extension.toUpperCase()){
			    				format = data[i];
			    				break;
			    			}
			    		}
			    	}
					if(format=="TXT"){
						docFormat = /^.*\.(txt)$/i;
					}else if(format=="PDF"){
						docFormat = /^.*\.(pdf)$/i;
					}else if(format=="XLSX"){
						docFormat = /^.*\.(xlsx)$/i;
					}else if(format=="ZIP"){
						docFormat = /^.*\.(zip)$/i;
					}else if(format=="JPEG"){
						docFormat = /^.*\.(jpeg)$/i;
					}else if(format=="PNG"){
						docFormat = /^.*\.(png)$/i;
					}else if(format=="JPG"){
						docFormat = /^.*\.(jpg)$/i;
					}
					
					/*if(!isNullOrEmpty(record.raw.documentFormat)&&record.raw.documentFormat=="TXT"){
						docFormat = /^.*\.(txt)$/i;
					}else if(!isNullOrEmpty(record.raw.documentFormat)&&record.raw.documentFormat=="PDF"){
						docFormat = /^.*\.(pdf)$/i;
					}else if(!isNullOrEmpty(record.raw.documentFormat)&&record.raw.documentFormat=="XLSX"){
						docFormat = /^.*\.(xlsx)$/i;
					}else if(!isNullOrEmpty(record.raw.documentFormat)&&record.raw.documentFormat=="ZIP"){
						docFormat = /^.*\.(zip)$/i;
					}*/
					var file = fileField.fileInputEl.dom.files[0];
					if (!isNullOrEmpty(record.raw.documentFormat)&&isNullOrEmpty(docFormat)) {
						fileField.reset();
						form.config.documentDashlet=true
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
					}else if(isNullOrEmpty(record.raw.size)||(file.size/1024)<=(record.raw.size)){
						
					}else{
						form.config.documentDashlet=true
						fileField.reset()
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_SIZE'));
					}
				}
			  },
			'documentformwindow[itemId=ApplicantListOfDocument] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
				  click: this.getUploadALPDocument
			  },
			  'adhocdocumentgrid[itemId=adhocDocumentGridItemId]': {
	            	afterrender: function(grid) {
	            		var $this = this;
	            		$this.doAccessControlValidation(grid, $this.getAD_HOC_APPLICANT_DOCUMENTS_PERMISSIONS());
	            		var personProfile = $this.getContentPanelActiveTab();
	            		var applicationId = personProfile.getApplicationId();
	            		var store = grid.getStore();
	            		$this.resetPageSetting(store);
	            		store.getProxy().extraParams = {
	            			applicationId: applicationId
	            		}
	            		store.load();
	            		var structure = grid.up('applicantprofile');
	    				var panel = structure.down('panel');
	    				$this.getAdhocDocGridHeaderFreeze(grid,panel);
	            	},
	            	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
	            		 var $this = this;
	            		
	            		 if (e.target.tagName == 'A') {
	            			 
	            			 var personProfile = $this.getContentPanelActiveTab();
	                         var grid = personProfile.down('#adhocDocumentGridItemId');
	            			 if (grid.getSelectionModel().getCount() > 0) {
	            				 if (grid.getSelectionModel().getCount() > 1) {
	                				 showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	                			 }else
	                			 {
	                				 var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	                				 var record = grid.getSelectionModel().getSelection()[0];
	                				 if (columnName == 'remark') {
	                					 var formWindow = $this.getApplicantadhocdocumentremarkformwin();
	                					 if (!formWindow) {

	                						 formWindow = Ext.widget('documentremarkformwin', {
	                							 itemId: 'applicantAdhocDocumentRemarkFormWin'
	                						 });
	                					 }
	                					 formWindow.show();
	                					 var remark = record.get("remark");
	                					 var documentRemarkArea = formWindow.down('#documentRemarkItemId');
	                					 documentRemarkArea.setValue(remark);

	                				 }else if (columnName == "documentName") {
	                					 var documentId = record.get("documentId");
	                					 if(!isNullOrEmpty(documentId)){
	                						 if (e.target.tagName == 'A') {
	                							 $this.getDocumentController().downloadDocumentFile(documentId);
	                						 }
	                					 }
	                				 }
	                				 if(e.target.tagName == "A" &&(columnName == "previewDoc") ){
	                          			var previewWindow = $this.getDocumentpreviewwindow();
	             						if (!previewWindow) {
	             							Ext.widget('documentpreviewwindow', {
	             								documentRecord: record,
	             								width: '100%',
	             								height: Ext.getBody().getHeight(),
	             								itemId: 'appadhocDocPreviewWindow'
	             							});
	             							previewWindow = $this.getDocumentpreviewwindow();
	             						}

	             						previewWindow.show();
	                         		}
	                			 } 
	            			 }else {
	            				 showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            			 }
	            		 }
	        	   },
	 			   select :function($this, record, index){
	 				   var personProfile = this.getContentPanelActiveTab();
	 				   var grid = personProfile.down('#adhocDocumentGridItemId');
	 				   this.getCheckedAdhocDocumentGrid($this, grid);
				   },
				   deselect :function($this, record, index){
					   var personProfile = this.getContentPanelActiveTab();
					   var grid = personProfile.down('#adhocDocumentGridItemId');
					   this.getCheckedAdhocDocumentGrid($this, grid);
				   }
	           },
	           'documentpreviewwindow[itemId=appadhocDocPreviewWindow]':{
	            	afterrender: function(win){
	            		var me = this;
	            		var documentRecord = win.documentRecord;
	            		var documentId = documentRecord.data.documentId;
	            		var id = documentRecord.data.id;
	            		var fileExtension = documentRecord.data.path.split('.').pop();
	            		win.setTitle(documentRecord.data.documentName);
	            		if(!isNullOrEmpty(documentId) && documentId){
	            				Ext.Ajax.request({
	            					type: 'rest',
	            					url: SERVERURL.PATH_GET_BASE64_DOCUMENT_BY_DOCUMENT,
	            					params: {
	            						documentId: documentId
	                                },
	            					method: 'GET',
	            					success: function(res, action) {
	            						var responseTxt = res.responseText;
	            						if(responseTxt != ''){
	                						if(fileExtension.toUpperCase() == "PDF"){
	                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
	                						}
	                						else{
	                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
	                						}
	            						}
	            						else{
	            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
	            						}
	            					}
	            				});
	            		}else if(!isNullOrEmpty(id) && id){
	        				Ext.Ajax.request({
	        					type: 'rest',
	        					url: SERVERURL.PATH_GET_BASE64_DYNAMIC_DOCUMENT_BY_ID + id,
	        					method: 'GET',
	        					success: function(res, action) {
	        						var responseTxt = res.responseText;
	        						if(responseTxt != ''){
	            						if(fileExtension.toUpperCase() == "PDF"){
	            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
	            						}
	            						else{
	            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
	            						}
	        						}
	        						else{
	        							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
	        						}
	        					}
	        				});
	        		     }
	            	}
	            },
			  'adhocdocumentgrid[itemId=adhocDocumentGridItemId] button[itemId=btnAdd]': {
	            	click: function() {
	            		var $this = this;
	            		var personProfile = $this.getContentPanelActiveTab();
						var grid = personProfile.down('#adhocDocumentGridItemId');
	            		grid.getSelectionModel().deselectAll();
	            		$this.showApplicantAdhocDocumentFormWindow();
	            	}
	            },
	            'adhocdocumentgrid[itemId=adhocDocumentGridItemId] button[itemId=btnEdit]': {
	        	    click: function() {
	        	    	this.editApplicantAdhocDocumentFormWindow();
	        	    }
	        	},
	            'adhocdocumentgrid[itemId=adhocDocumentGridItemId] button[itemId=btnDelete]': {
	            	click: function() {
	            		this.deleteApplicantAdhocDocumentRecord();
	            	}
	            },
	            'adhocdocumentformwindow[itemId=applicantAdhocDocumentFormWindow] button[itemId=documentCancelButtonId]': {
	            	click: function() {
	            		var formWindow = this.getApplicantadhocdocumentformwindow();
	            		formWindow.close();
	            	}
	            },
	            'adhocdocumentformwindow[itemId=applicantAdhocDocumentFormWindow] button[itemId=documentFormSubmitButtonId]': {
	            	click: function() {
	            		this.saveApplicantAdhocDocumentFormData();
	            	}
	            },
	            'adhocdocumentformwindow[itemId=applicantAdhocDocumentFormWindow] filefield[itemId=uploadFileField]': {
	                change: function(fileField, value, eOpts) {
	                    if (!isNullOrEmpty(value)) {
	                        var $this = this;
	                        value = value.replace('C:\\fakepath\\', '');
	                        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                        fileField.setRawValue(newValue);
	                        var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
	                        var specialCharsExist=false;
	                             for(i = 0; i < specialChars.length;i++){
	                               if(newValue.indexOf(specialChars[i]) > -1){
	                                   specialCharsExist= true;
	                                }
	                             }
	                            if(specialCharsExist){
	                            	fileField.reset();
	                                showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
	                            }
	                        var file = fileField.fileInputEl.dom.files[0];
	                        var form = fileField.up().up();
	                        var fileInfoContainer = form.down('#fileInfoContainer');
	                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                        var docDetails = form.down('#docDetails');
	                        var docType = form.down('#documentTypeCombo');
	                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                        if ($this.isValidFileExtension(extension)) {
	                       	 var file = fileField.fileInputEl.dom.files[0];
	                       	 if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
	                       		 fileInfoContainer.setVisible(false);
	                       		 fileField.reset();
	                       		 showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_FIVE_MB'));
	                       	 } else {
	                       		 var form = fileField.up().up();
	                       		 var fileInfoContainer = form.down('#fileInfoContainer');
	                       		 fileInfoContainer.setVisible(true);
	                       		 var docDetails = form.down('#docDetails');
	                       		 docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
	                       	 }
	                        } else {
	                       	 fileInfoContainer.setVisible(false);
	                       	 fileField.reset();
	                       	 showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
	                        }
	                    }
	                }
	            },
	            'documentremarkformwin[itemId=applicantAdhocDocumentRemarkFormWin] button[itemId=cancelBtnRemarkItemId]': {
	        	    click: function() {
	        	        var formWindow = this.getApplicantadhocdocumentremarkformwin();
	        	        formWindow.close();
	        	    }
	        	},
        });
    },
    /**
     * Reset all form field's
     * @param form document form field
     */
    resetAllFormField: function(form){
    	form.getForm().reset();
    	this.clearCombo(form.down('#programId'));
    	this.clearCombo(form.down('#batchCombo'));
    	this.clearCombo(form.down('#seatTypeCombo'));
    	this.clearCombo(form.down('#selectionStageCombo'));
    },
    
    /**
     * Method to load the next combo based on the selection of the previous combo value.
     * @param {Object} dependentCombo is the reference of the next dropdown which should be populated with values.
     * @param {Object} selectedRecord is the record of the previous dropdown which is selected.
     * @param {Object} parameter is the value that should be attached in the url.
     * @param {Object} extraParameter (optional) If there is any extra parameter to be sent for loading the
     *  dependent dropdown.
     * @param {Object} extraParamValue (optional) The value of the extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, selectedRecord, parameter, extraParameter, extraParamValue) {
    	this.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = selectedRecord[0].get('id');
        var url = store.getProxy().proxyConfig.api.read;
        if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
            url = url.concat('?' + parameter + '=' + id);
        } else {
            url = url.concat('?' + parameter + '=' + id);
            url = url.concat('&' + extraParameter + '=' + extraParamValue);
        }
        store.getProxy().api.read = url;
        store.reload();
    }, 
 	/**
 	 * function to clear the combo store, clear its existing value
 	 *  and remove all the records from the store.
 	 *  @param {Object} the reference of the combo whose store should be cleared.
 	 */
 	clearCombo: function(combo) {
 		combo.clearValue();
 		combo.store.removeAll();
 	},
 	/**
     * load applicant document grid
     * @param gridItemId
     * @param formItemId
     */
    loadGridStore: function(gridItemId, formItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();        
        var grid = personProfile.down(gridItemId);
        var form = personProfile.down(formItemId);
        if (grid) {
        	var params=this$.createCriteria(form,personProfile);
            var store = grid.getStore();
            store.load({
                params: params
            });

            store.on('beforeload', function(store, operation) {
            	var params=this$.createCriteria(grid,personProfile);
                store.proxy.extraParams = params;
            });
        }
    },
    /**
     * Get document controller
     */
    getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    /**
     * Cell click download file
     * @param grid
     * @param td
     * @param cellIndex
     * @param record
     * @param tr
     * @param rowIndex
     * @param e
     * @param eOpts
     */
    cellClickApplicantDocumentGrid : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var documentGrid = this.getDocumentGrid();
        var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        if (columnName == "documentType" && record.get('isElectronic')) {
            var this$ = this;
            var docId = record.get("documentId");
            if(!isNullOrEmpty(docId)){
            	this$.getDocumentController().downloadDocumentFile(docId);
            }
            
        }
    },
    /** 
     * Download applicant doc file 
     */
    downloadApplicantDocumentFile : function(){
    	var this$ = this;
    	var documentGrid = this$.getDocumentGrid();
    	var record = documentGrid.getSelectionModel().getSelection()[0];
    	var docId = record.get("documentId");
    	if(!isNullOrEmpty(docId)){
        	this$.getDocumentController().downloadDocumentFile(docId);
        }
    },
    /**
     * Show document form 
     */
    showDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().showDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT');
    },
    /**
     * Close document form 
     */
    closeDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().closeDocumentFormWindow();
    },
    
    /**
     * Save new document form 
     */
    saveApplicantDocumentFormData: function(){
	    var this$ = this;
    	var successMsg, submitUrl;
    	var personProfile = this$.getContentPanelActiveTab();
    	var applicationId = personProfile.getApplicationId();
        var grid = personProfile.down('#applicantDocumentGrid');
    	var isTransient = false;
    	var module = 'applicant';
    	var entityId = applicationId;
    	var entityType = 'applicant';
    	var formWin = this$.getApplicantdocumentformwindow();
    	var form = formWin.down('#documentFormWindowItemId')
    	var records =grid.getSelectionModel().getSelection()[0];
    	
    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'NEW_DOCUMENT', function(success, response, isCallBackTransient){
    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var formWin = this$.getApplicantdocumentformwindow();
				    	var form = formWin.down('#documentFormWindowItemId');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    						submitUrl = SERVERURL.APPLICANT_DOCUMENTS_SAVE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						submitUrl = SERVERURL.APPLICANT_DOCUMENTS_SAVE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');

    					}
    					var documentId = Ext.JSON.decode(response.responseText);
						
    					documentJson.applicableAt = "GENERAL";
    					var documentStatus = form.down('#documentStatus').getValue();
    					if(!isNullOrEmpty(documentStatus)) {
    					    	documentJson.documentStatusCSM = {
    					    	id: documentStatus
    					    	};
    					  }
    					documentJson.applicationId = applicationId;
    					documentJson.documentId = documentId;
    					documentJson.documentTypeId = form.down('#documentTypeCombo').getValue();
    					documentJson.generalDocType = form.down('#docType').getValue();
    				    form.down('#documentFormSubmitButtonId').setDisabled(true);
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.APPLICANT_DOCUMENTS_SAVE,
    						jsonData: documentJson,
    						method: 'PUT',
    						
    						success : function(response, action) {
    							if (response.responseText == '0') {
    								form.down('#docDetails').setValue('');
    								showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
    							} else {
    								this$.getApplicantdocumentformwindow().close();
    								grid.getSelectionModel().deselectAll();
                        			grid.getStore().getProxy().extraParams = {
                        				applicationId : applicationId
                        			};
    								grid.getStore().reload();
    								showSuccessMessage(getPersonModuleTranslation('DOCUMENTS'), successMsg);
									var applicantProfileView = personProfile.down('#applicantProfileTemplate');
									if (!isNullOrEmpty(applicationId)) {
										var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
										if (!isNullOrEmpty(url)) {
											url = url.concat("?id=" + applicationId);
											Ext.Ajax.request({
												type: 'rest',
												url: url,
												method: 'GET',
												success: function(res, action) {
													if (portalId == 6) {
														if (Ext.ComponentQuery.query('dashboardhomepage').length != 0) {
															Ext.ComponentQuery.query('dashboardhomepage')[0].close();
														}
														if (Ext.ComponentQuery.query('userinfo').length != 0) {
															var dashBoardMenu = Ext.ComponentQuery.query('userinfo')[0];
															dashBoardMenu.down("#myDashboard").setVisible(false);
														}
													}
													var data = Ext.decode(res.responseText);
													if (!isNullOrEmpty(data) && !isNullOrEmpty(data.currentStatus)) {
														data.currentStatus = getAdmissionTranslation(data.currentStatus);
													}
													var tpl = applicantProfileView.tpl;
													if (Ext.isDefined(applicantProfileView.el)) {
														tpl.overwrite(applicantProfileView.el.dom, data);
													}
													if (portalId == 6) {
														if (!isNullOrEmpty(applicantProfileView.up().down('form'))) {
															applicantProfileView.up().down('form').getForm().setValues(data);
															var formFields = applicantProfileView.up().down('form').getForm().getFields().items;
															Ext.each(formFields, function(currentField) {
																if (isNullOrEmpty(currentField.getValue())) {
																	currentField.hide();
																} else {
																	currentField.show();
																}
															});
														}
													}
												}
											});
										}
									}  
    							}
    						}
    					});
    				}
    			}
    		}, isTransient);
    	
	},
    
    /**
     * Edit document form
     * @param isView
     */
    editDocumentFormWindow : function(isView){
    	var this$ = this;
    	var form = null;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#applicantDocumentGrid');

        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	if(!isEmpty(records)){
        			var documentId = records.get("documentId");
        			if (isNullOrEmpty(documentId)) {
        				if(records.get('isElectronic')){
        					this$.getDocumentController().showDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT',432);
        				}else{
        					this$.getDocumentController().showDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT');
        				}
        				form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        				form.down('#documentTypeCombo').setValue(records.get('documentType'));
        			}else {
        				if(records.get('isElectronic')){
            				this$.getDocumentController().editDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT', documentId, isView,432);
        				}else{
            				this$.getDocumentController().editDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT', documentId, isView);

        				}
        				form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        				form.down('#documentTypeRadioGroup').setReadOnly(true);
        			}
        			if(isNullOrEmpty(records.get('submissionDate'))){
        				form.down('#submissionDate').setValue(new Date());
        			}
        			if (isView) {
        				form.down('#documentFormSubmitButtonId').setVisible(false);
        				form = form.getForm();
        				toggleReadOnlyFormItems(form, true);
        			}else{
        				form.down('#documentTypeCombo').setReadOnly(true);
        			}
        			form.down('#lastDateSubmissionId').setVisible(false)
        			if(records.get('isElectronic')){
        				form.down('#modeOfSubmission').setDisabled(false);
        				form.down('#modeOfSubmission').setReadOnly(true);
        				form.down('#modeOfSubmission').setValue('ONLINE');
            			form.down('#documentTypeRadioGroup').setVisible(false);
            			form.down('#responsibleUserField').setVisible(false);
            			form.down('#uploadFileField').setDisabled(true);
            			form.down('#uploadFileField').setVisible(false);
            			form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
            			form.down('#inspectionRequiredRadioGroupField').setVisible(false);
            			form.down('#inspectionDoneRadioGroupField').setDisabled(false);
            			form.down('#inspectionDoneRadioGroupField').setVisible(true);
            			form.down('#inspectionDateField').setVisible(true);
            			form.down('#inspectionDoneByField').setVisible(true);
            			form.down('#returnableRadioGroup').setVisible(false);
            			form.down('#returnDateField').setVisible(false);
            			form.down('#returnByField').setVisible(false);
            			form.down('#modeOfReturnField').setVisible(false);
            			form.down('#returnedToUserField').setVisible(false);
            			form.down('#lastDateSubmissionId').setVisible(false);
            		}else{
            			form.down('#modeOfSubmission').setDisabled(false);
            			var modeSubmissionStore=form.down('#modeOfSubmission').getStore();
            			modeSubmissionStore.on('load', function(){
            				for(var i=0; i< modeSubmissionStore.data.items.length;i++){
            					if(modeSubmissionStore.data.items[i].data.value == 'Online'){
            						modeSubmissionStore.removeAt(i);
            					} 
            				}
            			});
            			form.down('#documentTypeRadioGroup').setVisible(false);
            			form.down('#responsibleUserField').setDisabled(false);
            			form.down('#responsibleUserField').setVisible(true);
            			form.down('#uploadFileField').setDisabled(true);
            			form.down('#uploadFileField').setVisible(false);
            			form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
            			form.down('#inspectionRequiredRadioGroupField').setVisible(false);
            			form.down('#inspectionDoneRadioGroupField').setDisabled(false);
            			form.down('#inspectionDoneRadioGroupField').setVisible(true);
            			form.down('#inspectionDateField').setVisible(true);
            			form.down('#inspectionDoneByField').setVisible(true);
            			form.down('#returnableRadioGroup').setDisabled(false);
            			form.down('#returnableRadioGroup').setVisible(true);
            			form.down('#returnDateField').setVisible(true);
            			form.down('#returnByField').setVisible(true);
            			form.down('#modeOfReturnField').setDisabled(true);
            			form.down('#returnedToUserField').setDisabled(true);
            			form.down('#modeOfReturnField').allowBlank=true;
            			form.down('#returnedToUserField').allowBlank=true;
            			form.down('#modeOfReturnField').setVisible(false);
            			form.down('#returnedToUserField').setVisible(false);
            			form.down('#lastDateSubmissionId').setVisible(false);
            		}
        			
        			if(records.get('documentApplicabilityTemp') == 'GENERAL'){
        				form.down('#docTypeId').setVisible(true);
        				var documentType = form.down('#docTypeId');
        				documentType.setValue(records.get('documentApplicability'));
        				form.down('#docTypeId').allowBlank=false;
        			}else{
        				form.down('#docTypeId').setVisible(false);
        				form.down('#docTypeId').allowBlank=true;
        			}
        			var portalId = this.getCurrentLoggedPortalId();
        			if(portalId == 1){
        				form.down('#documentStatus').setReadOnly(false);
        			}
        			
        			//form.down('#inspectionDateField').setMaxValue(new Date());
        			//form.down('#returnDateField').setValue(new Date());
        			form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
        			form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
        			form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
        		
        			var documentStatusCSM = form.down('#documentStatus');
       			 if(records.data.documentStatusCSM)
       				 if (!isNullOrEmpty(records.data.documentStatusCSM)) {
       					 documentStatusCSM.getStore().load({
       	   	     		   callback: function(record, operation, success) {
       	   	     			  for(var i in record){
       	   	     				  if(record[i].data.code == records.data.documentStatusCSM.code){
       	   	     					documentStatusCSM.setValue(record[i].data.id);
       	   	     				  }
       	   	     			  }
       	   	     		  } 
       	   				  });
       	                }else{
      		         documentStatusCSM.getStore().load({
   	     		   callback: function(records, operation, success) {
   	     			  for(var i in records){
   	     				  if(records[i].data.code =="SUBMITTED"){
   	     					documentStatusCSM.setValue(records[i].data.id);
   	     				  }
   	     			  }
   	     		  } 
   				  });
   	      	   }
        		}
            
        } else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    	
    },
    /**
     * Save document form
     */
    saveApplicantDocumentForm: function(){
    	var this$ = this;
    	var successMsg;
    	var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#applicantDocumentGrid');
        var portalId = this$.getCurrentLoggedPortalId();
        try {
    		personProfile.getApplicationId();
    	} catch(e){
    		personProfile = this$.getContentPanel().items.items[0];
    	}
        var applicantProfile= personProfile;
    	var personObj = this$.getPersonObj();
    	var isTransient = false;
    	var module = 'applicant';
    	
    	if(!isNullOrEmpty(applicantProfile) && !isNullOrEmpty(personProfile)
    			&& !isNullOrEmpty(applicantProfile.applicationId) && !isNullOrEmpty(personProfile.applicationId)){
    		applicantProfile.applicationId = personProfile.applicationId
    	}
    	
    	var entityId = applicantProfile.applicationId;
    	var entityType = 'applicant';
    	var form = this$.getExtendeddocumentform();
    	var uploadBtn=form.down('#uploadFileField');
    	var records = grid.getSelectionModel().getSelection()[0];
    	if(!uploadBtn.isVisible() && !records.get('isElectronic')){
    		var isPhysicalFile=form.down('#physicalField');
        	isPhysicalFile.setValue(true);
    	}
    	form.down('#modeOfReturnField').setDisabled(true);
		form.down('#returnedToUserField').setDisabled(true);
		form.down('#modeOfReturnField').allowBlank=true;
		form.down('#returnedToUserField').allowBlank=true;
		form.down('#modeOfReturnField').setVisible(false);
		form.down('#returnedToUserField').setVisible(false);
		if(records.get('isElectronic') && !uploadBtn.isVisible()){//for edit mode
	    	var formData = null;
	    	var path=null;
	        var fileField = form.down('#fileDisplayField');
        	formData = form.getValues();
        	 Ext.Ajax.request({
                 type: 'rest',
                 url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
                 method: 'GET',
                 success: function(res, action) {
                 	var data = Ext.decode(res.responseText);
                 	if(!isEmpty(data)){
                 		if(!isNullOrEmpty(data.path)){
                 			path=data.path;
                 		}
                 	}
                 }
             });
			this$.getDocumentController().saveDocumentFormValue(isTransient, 'EXT_DOCUMENT', true, formData, path, function(success, response, isCallBackTransient){
    			if(success){
    				var documentJson = new Object();
    					var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue())) {
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    					}
    					var documentId = records.get("documentId");
    					var docType = form.down('#documentTypeCombo').getValue();
    					documentJson.id =  records.get("id");
    					documentJson.documentTypeId = docType;
    					documentJson.documentId = documentId;
    					documentJson.applicationId = applicantProfile.applicationId;
    					documentJson.currentDocumentStatus = records.get("status");
    					documentJson.generalDocType = form.down('#docTypeId').getValue();
    					var isInspectionRequiredYes = form.getValues().isInspectionDone;
    					if(isInspectionRequiredYes==true){
    						documentJson.isInspectionRequiredYes=isInspectionRequiredYes;
    					}
    					var documentStatus = form.down('#documentStatus').getValue();
    					if(!isNullOrEmpty(documentStatus)) {
    						documentJson.documentStatusCSM = {
    								id: documentStatus
    						};
    					}
    					//documentJson.documentStatus = documentStatus;
    					this$.applyWindowMask(); 
                        form.down('#documentFormSubmitButtonId').setDisabled(true);
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.APPLICANT_DOCUMENTS_UPDATE,
    						jsonData: documentJson,
    						method: 'PUT',
    						success : function(){
    							this$.hideWindowMask();
    							this$.getDocumentController().closeDocumentFormWindow();
    							grid.getStore().reload();
    							grid.getSelectionModel().deselectAll();
    							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    							if(Ext.isDefined(Ext.ComponentQuery.query('#applicationsListGrid')[0])){
				        			var apGrid = Ext.ComponentQuery.query('#applicationsListGrid')[0]
				        			apGrid.getStore().reload();
				        		}
    							this$.mixins.ApplicationBaseController.getApplicantProfileInformation(applicantProfile);
    						}
    					});
    			}});
		}else{
			this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue())) {
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');

    					}
    					var documentId = Ext.JSON.decode(response.responseText);
    					var docType = form.down('#documentTypeCombo').getValue();
    					documentJson.id =  records.get("id");
    					documentJson.documentTypeId = docType;
    					documentJson.documentId = documentId;
    					documentJson.applicationId = applicantProfile.applicationId;
    					documentJson.currentDocumentStatus = records.get("status");
    					documentJson.generalDocType = form.down('#docTypeId').getValue();
    					documentJson.isUpload = true;
    					if(!isNullOrEmpty(portalId) && portalId==6) {
    						documentJson.isApplicantPortal = true;
    					}
    					var documentStatus = form.down('#documentStatus').getValue();
    					var isInspectionRequiredYes = form.getValues().isInspectionDone;
    					if(isInspectionRequiredYes==true){
    						documentJson.isInspectionRequiredYes=isInspectionRequiredYes;
    					}
    					if(!isNullOrEmpty(documentStatus)) {
    						documentJson.documentStatusCSM = {
    								id: documentStatus
    						};
    					}
    					//documentJson.documentStatus = documentStatus;
    					
    					this$.applyWindowMask(); 
                        form.down('#documentFormSubmitButtonId').setDisabled(true);
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.APPLICANT_DOCUMENTS_UPDATE,
    						jsonData: documentJson,
    						method: 'PUT',
    						success : function(){
    							this$.hideWindowMask();
    							this$.getDocumentController().closeDocumentFormWindow();
    							grid.getStore().reload();
    							grid.getSelectionModel().deselectAll();
    							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    							if(Ext.isDefined(Ext.ComponentQuery.query('#applicationsListGrid')[0])){
				        			var apGrid = Ext.ComponentQuery.query('#applicationsListGrid')[0]
				        			apGrid.getStore().reload();
				        		}
    							this$.mixins.ApplicationBaseController.getApplicantProfileInformation(applicantProfile);
    						}
    					});
    				}
    			}
        		
        	}, isTransient);
		}
    },
    

    /*
     * This function is used for to create criteria and return params object    
     */
    createCriteria: function(container,applicantProfile) {
    	var me=this;
        var params = new Object();
        
        if(applicantProfile){
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = me.getContentPanel().items.items[0];
        	}
        	params.applicationId = applicantProfile.getApplicationId();        
        	
            if(container){
            	
            	/*params=me.getFieldParam(container,'#academyCombo','academyId',params);
            	params=me.getFieldParam(container,'#locationCombo','locationId',params);*/
            	params=me.getFieldParam(container,'#academyCombo','academyLocationId',params);
            	params=me.getFieldParam(container,'#programId','programId',params);
            	params=me.getFieldParam(container,'#batchCombo','batchId',params);
            	params=me.getFieldParam(container,'#seatTypeCombo','seatTypeId',params);
            	params=me.getFieldParam(container,'#selectionStageCombo','stageId',params);
            	
            }        
        }
                
        return params;
    },
    
    /*
     * This function is used for to return field value inside param object    
     */
    
    getFieldParam:function(container,fieldItemId,key,params){
    	
    	var field = container.down(fieldItemId);
        if (field) {
            var fieldValue = field.getValue();
            if (!isNullOrEmpty(fieldValue)) {
            	params[key]=fieldValue;
            }                             
        }
        
        return params;
    },
    
    /**
     *  To display container in view only mode
     */
    showContainerInViewMode: function(container) {
    	var me = this;
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e) {
        		applicantProfile = me.getContentPanel().items.items[0];
        	}
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		if(applicantProfile.getApplicationInfo()['isViewMode']){
            		me.mixins.ApplicationBaseController.setContainerInViewMode(container);
            	}        		
        	}
        }    
   },
   /**
	 * code to load the selection stage combo from the filter.
	 * @param {Object} the reference of the seatTypeCombo, based on which the selection stage combo should be loaded.
	 * @param {Number} the value of the programBatchSeatConfigId which has to be passed in the url.
    * @author trupti.paoneker
	 */
   loadSelectionStageCombo: function(seatTypeCombo, value) {
		acadLocProgComponent = seatTypeCombo.up('acadlocprogbatchseattypecomponent');
		var form = seatTypeCombo.up('documentsearchform');
		var dependentCombo=form.down('#selectionStageCombo');
		/*
		 * Code to reset the value of the SelectionStage dropdown based on the selection of the seatype combo.
		 */
		this.resetSelectionStageCombo(seatTypeCombo);
		
	   var store = dependentCombo.getStore();
       var url = store.getProxy().proxyConfig.api.read;
       url = url.concat('?programBatchSeatConfigId=' + seatTypeCombo.progBatchSeatConfigId);
       store.getProxy().api.read = url;
       store.reload();
	},
    
	/**
	 * code to reset the values of the selection stage combo on selection of academy loc prog batch seatType dropdowns.
	 * @author trupti.paoneker
	 */
	resetSelectionStageCombo: function(combo) {
		var form = combo.up('documentsearchform');
		var stageCombo=form.down('#selectionStageCombo');
		stageCombo.clearValue();
		stageCombo.store.removeAll();
	},
	/**
     * code to reset other dropdowns based on the selection of any dropdown which is previous in the hierarchy.
     * eg: if all the dropdowns are loaded and the Academy is changed then subsequent dropdowns should be
     * changed accordingly, so their value is cleared and reset and reloaded.
     * @param: {Object} combo The reference of the dropdown which is the dependent/next combo. 
     */
    resetOtherDropdowns: function(combo) {
    	var form = combo.up('documentsearchform');
    	switch(combo.name) {
    	case 'academy':
    		break;
    	case 'academyLocation':
    		this.clearCombo(combo);
    		programCombo = form.down('customcombobox[name=program]');
    		this.clearCombo(programCombo);
    		batchCombo = form.down('customcombobox[name=batch]');
    		this.clearCombo(batchCombo);
    		seatTypeCombo = form.down('customcombobox[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		selectionStageCombo = form.down('customcombobox[name=selectionStage]');
    		this.clearCombo(selectionStageCombo);
    		break;
    	case 'program':
    		this.clearCombo(combo);
    		batchCombo = form.down('customcombobox[name=batch]');
    		this.clearCombo(batchCombo);
    		seatTypeCombo = form.down('customcombobox[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		selectionStageCombo = form.down('customcombobox[name=selectionStage]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'batch':
    		this.clearCombo(combo);
    		seatTypeCombo = form.down('customcombobox[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		selectionStageCombo = form.down('customcombobox[name=selectionStage]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'seatType':
    		this.clearCombo(combo);
    		selectionStageCombo = form.down('customcombobox[name=selectionStage]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'selectionStage':
    		this.clearCombo(combo);
    		break;
    	}
 	}
	,
 	/**
     * upload document form
     * @param isView
     */
    uploadDocumentFormWindow : function(isView){
    	var this$ = this;
    	var form = null;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#applicantDocumentGrid');
        var portalId = this.getCurrentLoggedPortalId();

        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	if(!isEmpty(records)){
	          if((portalId == 6) && records.raw.whetherRestrictUpdateDocument) {
				   var status = records.get("documentStatusCSM").value;
				   showWarningMessage(getCommonTranslation('ALERT'), status + " " +"Document can not be edited" );
			  }
	          else {
        		if(records.get('isElectronic') || records.get('modeOfSubmission')==null){
        			
        			var documentId = records.get("documentId");
        			if (isNullOrEmpty(documentId)) {
        				this$.getDocumentController().showDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT',422);
        				form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        				form.down('#documentTypeCombo').setValue(records.get('documentType'));
        			}else {
        				this$.getDocumentController().editDocumentFormWindow('applicantDocumentForm', 'EXT_DOCUMENT', documentId, isView,422);
        				form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        				form.down('#documentTypeRadioGroup').setReadOnly(true);
        			}
        			if(isNullOrEmpty(records.get('submissionDate'))){
        				form.down('#submissionDate').setValue(new Date());
        			}
        			//container hiding
        			form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
        			form.down('#modeReturnContainer').setVisible(false);
        			form.down('#modeReturnContainer').setVisible(false);
        			form.down('#returnableContainer').setVisible(false);
        			form.down('#inspectionDateContainer').setVisible(false);
        			form.down('#inspectionRequiredContainer').setVisible(false);
        			form.down('#documentTypeContainer').setVisible(false);
        			
        			form.down('#documentNoteId').setVisible(false);
        			
        			form.down('#modeOfSubmission').setDisabled(false);
        			form.down('#modeOfSubmission').setValue('ONLINE');
        			form.down('#modeOfSubmission').setReadOnly(true);
        			
        			form.down('#documentTypeRadioGroup').setVisible(false);
        			form.down('#responsibleUserField').setVisible(false);
        			var documentStatusCSM = form.down('#documentStatus'); 
 
       		         documentStatusCSM.getStore().load({
    	     		   callback: function(records, operation, success) {
    	     			  for(var i in records){
    	     				  if(records[i].data.code =="SUBMITTED"){
    	     					documentStatusCSM.setValue(records[i].data.id);
    	     				  }
    	     			  }
    	     		  } 
    				  });
    	      	   
        			form.down('#inspectionRequiredRadioGroupField').setVisible(false);
        			form.down('#inspectionDoneRadioGroupField').setVisible(false);
        			
        			form.down('#inspectionDateField').setVisible(false);
        			form.down('#inspectionDoneByField').setVisible(false);
        			form.down('#returnDateField').setVisible(false);
        			form.down('#returnByField').setVisible(false);
        			form.down('#returnableRadioGroup').setVisible(false);
        			form.down('#modeOfReturnField').setVisible(false);
        			form.down('#returnedToUserField').setVisible(false);
        			form.down('#lastDateSubmissionId').setVisible(false);
        			if(portalId == 6){
        			form.down('#visibleNoteOnPortal').setVisible(false);	
        			}
        			if (isView) {
        				form.down('#documentFormSubmitButtonId').setVisible(false);
        				form = form.getForm();
        				toggleReadOnlyFormItems(form, true);
        			}else{
        				form.down('#documentTypeCombo').setReadOnly(true);
        			}
        			form.up('window').setHeight(form.getHeight()+90);
        		}else{
        			showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getPersonModuleTranslation('DOCUMENT_ALRAEDY_SUBMITTED'));
        		}
        	}
            }
        	}
         else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    	
    },
    /** Upload document Privileges button */
    disableUploadDocumentPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var editBtn = gridReference.down('#btnEdit');
        editBtn.setDisabled(true);
        var uploadDocumentBtn = gridReference.down('#uploadDocumentBtn');
        uploadDocumentBtn.setVisible(false);
        uploadDocumentBtn.setDisabled(true);
        var bulkDocUpdateBtn = gridReference.down('#updateBulkDocumentBtn');
        bulkDocUpdateBtn.setVisible(false);
        bulkDocUpdateBtn.setDisabled(true);
        
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'UPLOAD_DOCUMENT') {
                if (!isNullOrEmpty(uploadDocumentBtn)) {
                	uploadDocumentBtn.setVisible(true);
                }
            }
            if (privilege === 'BULK_DOCUMENT_UPDATE') {
                if (!isNullOrEmpty(bulkDocUpdateBtn)) {
                	bulkDocUpdateBtn.setVisible(true);
                }
            }
        });
    },
    //**********Program Batch SeatType Detail Grid************//
    openProgramBtachSeatTypeDetailsWindow : function(grid,record){
   	 var $this=this;
   	 var documentApplicability = record.get("documentApplicability");
   	 var applicationId = record.get("applicationId");
   	 var documentTypeId = record.data.documentType.id;
   	 var formWindow = $this.getProgrambatchseattypegridwindow();
   	 if (!formWindow) {
   		 Ext.widget('programbatchseattypegridwindow');
   		 formWindow = $this.getProgrambatchseattypegridwindow();
   	 }
   	 var listGrid=formWindow.down('grid');
   	 var store = listGrid.getStore();
   	 store.getProxy().extraParams = {
   		documentApplicability: documentApplicability,
   		applicationId:applicationId,
   		documentTypeId:documentTypeId
   	 };
   	 store.load();
   	 formWindow.show();
    },
    documentReportDocumentZip : function() {
    	var $this = this;
 	   var grid = $this.getDocumentrequestedwingrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var records = grid.getSelectionModel().getSelection();
 		   var dispatchZipName = "Document Group Master";
 		   var saveModel=[];  
 		   for(var i in records){
 			   if(!isNullOrEmpty(records[i].raw.path)) {
 				   saveModel.push(records[i].raw.path);
 			   }
 			   showConfirmMessage(getPersonModuleTranslation('DOCUMENTS'),
 					   getPersonModuleTranslation('GROUP_MASTER_DOCUMENTS_ALERT'),
 					   function(btn, text) {
 				   if (btn == 'yes') {
 					   if (!isNullOrEmpty(saveModel) && saveModel.length > 0) {
 						  var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
 	 					   $this.getController('Academia.controller.document.DocumentController')
 	 					   .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
					}else{
						setTimeout(function(){
							showWarningMessage(getMessagingModuleTranslation('ALERT'), getCommonTranslation('DOCUMENT_IS_NOT_UPLOADED'));
	 	 				},500);
						
					}
 				   }
 			   });

 		   }
 	   }
 	   else {
 		   $this.hideWindowMask();
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    deleteDocumentsByPersonId : function() {
    	var $this = this;
    	var grid = $this.getDocumentrequestedwingrid();
    	var store = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
			var ids = [];
			var docstatus =false;
			for(var i in record) {
				ids.push(record[i].raw.personRequiredDGMId);
			}
			for(var i in record) {
				if(record[i].raw.documentStatus=="Submitted"){
				docstatus =true;	
				};
			}
			if(docstatus){
				showConfirmMessage(getMessagingModuleTranslation('DOCUMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					if (btn == 'yes') {

						var id = ids.join(',');
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_DELETE_REQUESTED_DOCUMENT_UPLOADED+'?id='+id,
							method: 'DELETE',
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								//store.remove(record);
								store.reload();
								showSuccessMessage(getMessagingModuleTranslation('DOCUMENT'), getCommonTranslation('SUCCESS'));
								$this.reloadMainGrid();

							}
						});

					}
				});
			}else{
				showWarningMessage(getMessagingModuleTranslation('ALERT'), getCommonTranslation('DOCUMENT_IS_NOT_UPLOADED'));
			}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    getUploadALPDocument : function(){
    	var $this=this;
    	var grid = $this.getDocumentrequestedwingrid();
    	var isTransient = false;
    	var module = 'applicantRequestDoc';
    	var entityId ;
    	var entityType = 'applicantRequestDoc';
    	var record = grid.getSelectionModel().getSelection()[0];
    	var isAfterDate = false;
    	if(record.raw.isMultipleTimeUpload){
    		if(record.raw.allowUploadAfterDueDate){
	    		$this.applyWindowMask(); 
	        	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	        		if (grid.getSelectionModel().getCount() > 0) {
	        			var applicantProfile= $this.getApplicantProfile();
	        			var personId = applicantProfile.personId;
	        			var personRequiredDGMId = record.raw.personRequiredDGMId;
	        			var documentId = Ext.decode(response.responseText);
	        			 var data={
	        					   "applicantPersonId":personId,
	        					   "documentId":documentId,
	        					   "personRequiredDGMId":personRequiredDGMId
	        			   };
	        			var updateUrl = SERVERURL.PATH_EMPLOYEE_REQUESTED_DOCUMENT_UPLOADED;
	        			Ext.Ajax.request({
	        				type : 'rest',
	        				url : updateUrl,
	        				jsonData:data,
	        				method : 'POST',
	        				success : function(response, action) {
	        					$this.hideWindowMask();
	        					showSuccessMessage(getCommonTranslation('DOCUMENT'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	        					grid.getStore().reload();
	        					$this.reloadMainGrid();
	        				}
	        			});    
	        		}
	        		$this.getDocumentController().closeDocumentFormWindow();
	        	}, isTransient);
    		}
    		else{
    			var dueDate = Ext.Date.format(new Date(record.raw.dueDate), 'd-m-Y');
    			var currentDate = Ext.Date.format(new Date(), 'd-m-Y');
    			//var currentDate = new Date().getTime();
    			//var dueDate = record.raw.dueDate;
    			 if(dueDate>=currentDate){
    		    		    		    		
    	 	    		$this.applyWindowMask(); 
    	 	        	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
    	 	        		if (grid.getSelectionModel().getCount() > 0) {
    	 	        			var applicantProfile= $this.getApplicantProfile();
    		        			var personId = applicantProfile.personId;
    		        			var personRequiredDGMId = record.raw.personRequiredDGMId;
    		        			var documentId = Ext.decode(response.responseText);
    		        			 var data={
    		        					   "applicantPersonId":personId,
    		        					   "documentId":documentId,
    		        					   "personRequiredDGMId":personRequiredDGMId
    		        			   };
    	 	        			var updateUrl = SERVERURL.PATH_EMPLOYEE_REQUESTED_DOCUMENT_UPLOADED;
    	 	        			Ext.Ajax.request({
    	 	        				type : 'rest',
    	 	        				url : updateUrl,
    	 	        				jsonData:data,
    	 	        				method : 'POST',
    	 	        				success : function(response, action) {
    	 	        					$this.hideWindowMask();
    	 	        					showSuccessMessage(getCommonTranslation('DOCUMENT'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
    	 	        					grid.getStore().reload();
    	 	        					$this.reloadMainGrid();
    	 	        				}
    	 	        			});    
    	 	        		}
    	 	        		$this.getDocumentController().closeDocumentFormWindow();
    	 	        	}, isTransient);
    	    		 
    	 			}else{
    	 				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUE_DATE_IS_EXPIRED_MSG'));
    	 			}
    		}
    	}else{
            if(record.raw.documentStatus=="Submitted"){
            	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ONLY_ALLOW_SINGLE_TIME'));
            }else{
         		if(record.raw.allowUploadAfterDueDate){
    	    		$this.applyWindowMask(); 
    	        	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
    	        		if (grid.getSelectionModel().getCount() > 0) {
    	        			var applicantProfile= $this.getApplicantProfile();
    	        			var personId = applicantProfile.personId;
    	        			var personRequiredDGMId = record.raw.personRequiredDGMId;
    	        			var documentId = Ext.decode(response.responseText);
    	        			 var data={
    	        					   "applicantPersonId":personId,
    	        					   "documentId":documentId,
    	        					   "personRequiredDGMId":personRequiredDGMId
    	        			   };
    	        			var updateUrl = SERVERURL.PATH_EMPLOYEE_REQUESTED_DOCUMENT_UPLOADED;
    	        			Ext.Ajax.request({
    	        				type : 'rest',
    	        				url : updateUrl,
    	        				jsonData:data,
    	        				method : 'POST',
    	        				success : function(response, action) {
    	        					$this.hideWindowMask();
    	        					showSuccessMessage(getCommonTranslation('DOCUMENT'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
    	        					grid.getStore().reload();
    	        					$this.reloadMainGrid();
    	        				}
    	        			});    
    	        		}
    	        		$this.getDocumentController().closeDocumentFormWindow();
    	        	}, isTransient);
        		}
        		else{
        			var dueDate = Ext.Date.format(new Date(record.raw.dueDate), 'd-m-Y');
        		    var currentDate = Ext.Date.format(new Date(), 'd-m-Y');
        			 if(dueDate>=currentDate){
        		    		
        	 	    		$this.applyWindowMask(); 
        	 	        	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
        	 	        		if (grid.getSelectionModel().getCount() > 0) {
        	 	        			var applicantProfile= $this.getApplicantProfile();
        		        			var personId = applicantProfile.personId;
        		        			var personRequiredDGMId = record.raw.personRequiredDGMId;
        		        			var documentId = Ext.decode(response.responseText);
        		        			 var data={
        		        					   "applicantPersonId":personId,
        		        					   "documentId":documentId,
        		        					   "personRequiredDGMId":personRequiredDGMId
        		        			   };
        	 	        			var updateUrl = SERVERURL.PATH_EMPLOYEE_REQUESTED_DOCUMENT_UPLOADED;
        	 	        			Ext.Ajax.request({
        	 	        				type : 'rest',
        	 	        				url : updateUrl,
        	 	        				jsonData:data,
        	 	        				method : 'POST',
        	 	        				success : function(response, action) {
        	 	        					$this.hideWindowMask();
        	 	        					showSuccessMessage(getCommonTranslation('DOCUMENT'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
        	 	        					grid.getStore().reload();
        	 	        					$this.reloadMainGrid();
        	 	        				}
        	 	        			});    
        	 	        		}
        	 	        		$this.getDocumentController().closeDocumentFormWindow();
        	 	        	}, isTransient);
        	    		 
        	 			}else{
        	 				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUE_DATE_IS_EXPIRED_MSG'));
        	 			}
        		}
            }
   
    	
    	}
    },
    reloadMainGrid : function() {
    	/** refresh main grid **/
    	var $this=this;
    	var documentGrid = $this.getApplicantdocumentrequestedgrid();
    	var applicantProfile= this.getApplicantProfile();
		var gridStore = documentGrid.getStore();
		gridStore.getProxy().extraParams={
			applicantPersonId:applicantProfile.personId
		};
		gridStore.reload();
		
	},
	loadFieldByDFR : function(form) {
		var $this = this;
		var isInspectionRadioGroupNotVisible = false;
		var inspectionDoneField = form.down('#inspectionDoneRadioGroupField');
		var inspectionDateField = form.down('#inspectionDateField');
		var inspectionDoneByField = form.down('#inspectionDoneByField');
		inspectionDoneField.setVisible(false);
		inspectionDateField.setVisible(false);
		inspectionDoneByField.setVisible(false);
		Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'extendeddocumentform',
    			academyLocationId: $this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.extendeddocumentform;
    				for(i in records){  
    					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='inspectionDoneRadioGroupField' && records[i].isVisible==true){
    						inspectionDoneField.setVisible(true);
    					}
    					if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='inspectionDateField' && records[i].isVisible==true){
    						inspectionDateField.setVisible(true);
    					}
    					if(records[i].formFieldInputType=='livesearchcombo' && records[i].formFieldId=='inspectionDoneByField' && records[i].isVisible==true){
    						inspectionDoneByField.setVisible(true);
    					}
    					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='inspectionDoneRadioGroupField' && records[i].isVisible==false){
    						isInspectionRadioGroupNotVisible = true;
    					}
    					
    				}
    			}else{
    				if(inspectionDoneField!=null){
    					inspectionDoneField.setVisible(true);
    				}
    				
    				if(inspectionDateField!=null){
    					inspectionDateField.setVisible(true);
    				}
    				
    				if(inspectionDoneByField!=null){
    					inspectionDoneByField.setVisible(true);
    				}
    			}
    		}
    	});
		
		if (isInspectionRadioGroupNotVisible) {
			inspectionDoneField.items.items[0].setValue(true);
		}
	},
	getDownloadDocumentFile : function(documentId){
	  	 if(!isNullOrEmpty(documentId)){
	  		 var $this = this;
	  		 $this.getDocumentController()
	  		 .downloadDocumentFile(
	  				 documentId);
	  	 }
	},
	showApplicantAdhocDocumentFormWindow : function(){
		var $this = this;
		var formWindow = $this.getApplicantadhocdocumentformwindow();
		if (!formWindow) {
			formWindow = Ext.widget('adhocdocumentformwindow',{
				itemId : 'applicantAdhocDocumentFormWindow'
			});
		}
		formWindow.show();
		var documentStatusCSM = formWindow.down('#documentStatus');
		documentStatusCSM.getStore().load({
			callback: function(records, operation, success) {
				for(var i in records){
					if(records[i].data.code =="SUBMITTED"){
						documentStatusCSM.setValue(records[i].data.id);
					}
				}
			} 
		});
		formWindow.down('#submissionDate').setReadOnly(true);
	},
	showApplicantDocumentFormWindow : function(){
		var $this = this;
		var formWindow = $this.getApplicantdocumentformwindow();
		if (!formWindow) {
			formWindow = Ext.widget('adddocumentformwindow',{
				itemId : 'applicantDocumentFormWindow'
			});
		}
		formWindow.show();
		var documentType = formWindow.down('#documentTypeCombo');
        documentType.getStore().proxy.extraParams = {
                    limit :  -1
        };
        documentType.getStore().load();
		var documentStatusCSM = formWindow.down('#documentStatus');
		documentStatusCSM.getStore().load({
			callback: function(records, operation, success) {
				for(var i in records){
					if(records[i].data.code =="PENDING"){
						documentStatusCSM.setValue(records[i].data.id);
					}
				}
			} 
		});
		//formWindow.down('#submissionDate').setReadOnly(true);
	},
	getCheckedAdhocDocumentGrid: function(selmodel, grid){
  	  	if(selmodel.selected.length == 1){
			grid.down('#btnEdit').setDisabled(false);
			grid.down('#btnDelete').setDisabled(false);
		} else if(selmodel.selected.length > 1){
			grid.down('#btnEdit').setDisabled(true);
			grid.down('#btnDelete').setDisabled(false);
  		} else {
			grid.down('#btnEdit').setDisabled(true);
			grid.down('#btnDelete').setDisabled(true);
  		}
	},
	saveApplicantAdhocDocumentFormData: function(){
	    var this$ = this;
    	var successMsg, submitUrl;
    	var personProfile = this$.getContentPanelActiveTab();
    	var applicationId = personProfile.getApplicationId();
        var grid = personProfile.down('#adhocDocumentGridItemId');
    	var isTransient = false;
    	var module = 'applicantAdhocDoc';
    	var entityId = applicationId;
    	var entityType = 'applicantAdhocDocument';
    	var formWin = this$.getApplicantadhocdocumentformwindow();
    	var form = formWin.down('#adhocDocumentFormWindowItemId');
    	var uploadBtn=formWin.down('#uploadFileField');
    	var records =grid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(records)){
    		var formData = null;
			var editedPath=form.down('#uploadFileField');
			var path=null;
			var fileField = form.down('#fileDisplayField');
			formData = form.getValues();    
			if(isNullOrEmpty(editedPath.getValue())){
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
					method: 'GET',
					success: function(res, action) {
						var data = Ext.decode(res.responseText);
						if(!isEmpty(data)){
							if(!isNullOrEmpty(data.path)){
								path=data.path;
							}
						}
					}
				});
				
				this$.getDocumentController().saveDocumentFormValue(isTransient, 'ADHOC_DOC_FORM', true, formData, path, function(success, response, isCallBackTransient){
					this$.hideWindowMask();
					if(success){
						var documentJson = new Object();
						if(isCallBackTransient == false){
							var formWin = this$.getApplicantadhocdocumentformwindow();
					    	var form = formWin.down('#adhocDocumentFormWindowItemId');
							var id = form.down('#document_hidden_field');
							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
								submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_SAVE;
								successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_SAVE_SUCCESS_MSG');
							}else{
								submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_UPDATE;
								successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_UPDATE_SUCCESS_MSG');
								if (grid.getSelectionModel().getCount() > 0) {
									var records = grid.getSelectionModel().getSelection()[0];
									documentJson.id = records.get("id");
								}

							}
							var documentId = Ext.JSON.decode(response.responseText);
							var application = new Object();
							var document = new Object();

							application.id = applicationId;
							document.id = documentId;
							documentJson.application = application;
							documentJson.document = document;
							documentJson.remark = form.down('#remarkItemId').getValue();
							form.down('#documentFormSubmitButtonId').setDisabled(true);
							Ext.Ajax.request({
								type: 'rest',
								url: submitUrl,
								jsonData: documentJson,
								method: 'POST',
								success : function(){
									this$.getApplicantadhocdocumentformwindow().close();
									grid.getSelectionModel().deselectAll();
	                    			grid.getStore().getProxy().extraParams = {
	                    				applicationId : applicationId
	                    			};
									grid.getStore().reload();
									showSuccessMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), successMsg);
								}
							});
						}
					}

				}, isTransient);

			} else {
				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ADHOC_DOC_FORM', function(success, response, isCallBackTransient){

					if(success){
						var documentJson = new Object();
						if(isCallBackTransient == false){
							var formWin = this$.getApplicantadhocdocumentformwindow();
					    	var form = formWin.down('#adhocDocumentFormWindowItemId');
			    	    	var id = form.down('#document_hidden_field');
							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
								submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_SAVE;
								successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_SAVE_SUCCESS_MSG');
							}else{
								submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_UPDATE;
								successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_UPDATE_SUCCESS_MSG');
								if (grid.getSelectionModel().getCount() > 0) {
									var records = grid.getSelectionModel().getSelection()[0];
									documentJson.id = records.get("id");
								}

							}
							var documentId = Ext.JSON.decode(response.responseText);
							var application = new Object();
							var document = new Object();

							application.id = applicationId;
	    					document.id = documentId;
	    					documentJson.application = application;
	    					documentJson.document = document;
	    					documentJson.remark = form.down('#remarkItemId').getValue();
	    					form.down('#documentFormSubmitButtonId').setDisabled(true);
							Ext.Ajax.request({
								type: 'rest',
								url: submitUrl,
								jsonData: documentJson,
								method: 'POST',
								success : function(){
									this$.getApplicantadhocdocumentformwindow().close();
									grid.getSelectionModel().deselectAll();
	                    			grid.getStore().getProxy().extraParams = {
	                    				applicationId : applicationId
	                    			};
									grid.getStore().reload();
									showSuccessMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), successMsg);
								}
							});
						}
					}
				}, isTransient);
			
			}
    	}else {
    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ADHOC_DOC_FORM', function(success, response, isCallBackTransient){
    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var formWin = this$.getApplicantadhocdocumentformwindow();
				    	var form = formWin.down('#adhocDocumentFormWindowItemId');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    						submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_SAVE;
    						successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_SAVE_SUCCESS_MSG');
    					}else{
    						submitUrl = SERVERURL.APPLICANT_ADHOC_DOCUMENT_UPDATE;
    						successMsg = getPersonModuleTranslation('AD_HOC_DOCUMENT_UPDATE_SUCCESS_MSG');
    						if (grid.getSelectionModel().getCount() > 0) {
    							var records = grid.getSelectionModel().getSelection()[0];
    							documentJson.id = records.get("id");
    						}

    					}
    					var documentId = Ext.JSON.decode(response.responseText);
    					var application = new Object();
    					var document = new Object();

    					application.id = applicationId;
    					document.id = documentId;
    					documentJson.application = application;
    					documentJson.document = document;
    					documentJson.remark = form.down('#remarkItemId').getValue();
    					form.down('#documentFormSubmitButtonId').setDisabled(true);
    					Ext.Ajax.request({
    						type: 'rest',
    						url: submitUrl,
    						jsonData: documentJson,
    						method: 'POST',
    						success : function(response, action) {
    							if (response.responseText == '0') {
    								form.down('#docDetails').setValue('');
    								showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
    							} else {
    								this$.getApplicantadhocdocumentformwindow().close();
    								grid.getSelectionModel().deselectAll();
                        			grid.getStore().getProxy().extraParams = {
                        				applicationId : applicationId
                        			};
    								grid.getStore().reload();
    								showSuccessMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), successMsg);
    							}
    						}
    					});
    				}
    			}
    		}, isTransient);
    	}
	},
	editApplicantAdhocDocumentFormWindow : function() {
		var this$ = this;
		var form = null;
		var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#adhocDocumentGridItemId');
        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	if(!isEmpty(records)){	
				 var documentId = records.get("documentId");
				 var formWindow = this$.getApplicantadhocdocumentformwindow();
				 if (!formWindow) {
					 formWindow = Ext.widget('adhocdocumentformwindow',{
						 itemId : 'applicantAdhocDocumentFormWindow'
					 });
				 }
				 formWindow.down('#uploadFileField').allowBlank = true;
            	 Ext.Ajax.request({
                     type: 'rest',
                     url: SERVERURL.DOCUMENT_FORM_FIND_BY + documentId,
                     method: 'GET',
                     success: function(res, action) {
                    	 var data = Ext.decode(res.responseText);
                    	 if(!isEmpty(data)){
                    		 var form = formWindow.down('#adhocDocumentFormWindowItemId');
                    		 this$.setApplicantAdhocDocFormValue(form, data);
                    	 }
                     }
            	 });
	             formWindow.show();
				 var documentName = formWindow.down('#documentNameItemId');
				 documentName.setValue(records.get('documentName'));
				 documentName.setReadOnly(true);
				 formWindow.down('#remarkItemId').setValue(records.get('remark'));
				 formWindow.down('#submissionDate').setReadOnly(true);
				 formWindow.down('#remarkItemId').setReadOnly(true);
				 formWindow.down('#documentNameItemId').setReadOnly(true);
        	}	
		 }else {
			 showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }

	},
	setApplicantAdhocDocFormValue : function(form, data){
    	var this$ = this;
    	var filePath = '';
    	var uploadFileField = form.down('#uploadFileField');
    	if(!isNullOrEmpty(data.path)){
    		filePath = data.path;
    		var filePathArray = new Array();
    		if(filePath.indexOf('/') !=-1){
    			filePathArray = filePath.split("/");
    		}else if(filePath.indexOf('\\')){
    			filePathArray = filePath.split("\\");
    		}
    		var length = filePathArray.length;
    		if(length > 0){
    			var fileName = "";
    			filePath = filePathArray[length - 1];
    			fileName = filePath;
    			if(filePath.length > 30) {
    				filePath = filePath.substring(0,29)+"...";
    			}else{
    				fileName = filePath;
    			}
    			filePath = '<a href="#" title="'+fileName+'">'+filePath+'</a>';
    			
    		}else{
    			filePath = '';
    		}
    	}
    	var fileDisplayField = Ext.create('Ext.Component',{
            itemId: 'fileDisplayField',
            width : 256,
            autoEl: {
                tag: 'a',
                href: '#',
                html: filePath
            }
        });
    	
    	form.getForm().setValues(data);
    		
    	form.getForm().findField('submissionDate').setValue(dateRender(data.submissionDate));
    	form.down('#documentStatus').getStore().load();
    	if(!isNullOrEmpty(data.documentStatusCSM)){
    		form.down('#documentStatus').setValue(data.documentStatusCSM.id);
    	}
	},
	deleteApplicantAdhocDocumentRecord : function(){
		var this$ = this;
     	var personProfile = this$.getContentPanelActiveTab();
     	var grid = personProfile.down('#adhocDocumentGridItemId');
     	if (grid.getSelectionModel().getCount() > 0) {
     		showConfirmMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getPersonModuleTranslation('AD_HOC_DOCUMENT_DELETE_CONFIRM_MSG'), function(btn, text) {
     			if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                    	var gridModel = grid.getSelectionModel().getSelection();
                    	var id = [];
                    	gridModel.forEach(function(obj){
                    		id.push(obj.get('id'));
                    	});
                    	var delId = id.join();
                    	Ext.Ajax.request({
                    		type: 'rest',
                    		url: SERVERURL.APPLICANT_ADHOC_DOCUMENT_DELETE+'?applicantAdhocDocumentIds='+delId,
                    		method: 'DELETE',
                    		headers: {
                    			'Content-Type': 'application/json'
                    		},
                    		success: function(form, action) {
                    			grid.getSelectionModel().deselectAll();
                    			var applicationId = personProfile.getApplicationId();
                    			store.getProxy().extraParams = {
                    				applicationId : applicationId
                    			};
                    			grid.getStore().reload();
                    			showSuccessMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getPersonModuleTranslation('AD_HOC_DOCUMENT_DELETE_SUCCESS_MSG'));
                    		}
                    	});
                    }
     			}
     		});
     	} else {
     		showWarningMessage(getPersonModuleTranslation('AD_HOC_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
     	}
	},
	editBulkDocumentUpdateFormData: function(){
	    var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var applicationId = personProfile.getApplicationId();
        var grid = personProfile.down('#applicantDocumentGrid');
        var formWin = this$.getApplicantbulkdocupdateform();
        var form = formWin.down('idgeneratorformwin');
        var formValues = form.getValues();
    	var records =grid.getSelectionModel().getSelection();
    	var jsonDataArray = [];
    	if(!isNullOrEmpty(records)){
    		var documentIds = [];
    		for(i in records) {
    			if(!isNullOrEmpty(records[i].data.documentId)) {
    				documentIds.push(records[i].data.documentId);
    			}
    			var jsonObj = new Object();
    			jsonObj.documentId = records[i].data.documentId;
    			jsonObj.applicationId = applicationId;
    			jsonObj.currentDocumentStatus = records[i].data.status;
    			jsonObj.id = records[i].data.id;
    			if(Ext.isObject(records[i].data.documentType) && !isNullOrEmpty(records[i].data.documentType.id)) {
    				jsonObj.documentTypeId = records[i].data.documentType.id;
    			} else {
    				jsonObj.documentTypeId = records[i].data.documentType;
    			}
    			jsonObj.documentStatusCSM = this$.getIdValueJson(formValues.documentStatusCSM);
    			jsonDataArray.push(jsonObj);
    		}
    		var jsonFormFieldData = new Object();
    		var jsonData = new Object();
    		
    		var finalJsonData = new Object();
    		finalJsonData = Ext.encode(jsonDataArray);
    		
    		jsonFormFieldData.documentIds=documentIds;
    		jsonFormFieldData.isInspectionDone=formValues.isInspectionDone;
    		jsonFormFieldData.inspectionDate=formValues.inspectionDate;
    		jsonFormFieldData.inspectionDoneBy=formValues.inspectionDoneBy;
    		jsonFormFieldData.documentNote=formValues.documentNote;
    		jsonFormFieldData.visibleNoteOnPortal=formValues.visibleNoteOnPortal;
    		jsonFormFieldData.documentStatusCSM=this$.getIdValueJson(formValues.documentStatusCSM);
    		
    		var documentIdJsonData = new Object();
    		documentIdJsonData = Ext.encode(documentIds);
    		
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		form.down('#documentFormSubmitButtonId').setDisabled(true);
    		Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.FIND_PATH_BULK_DOCUMENTS_INFO,
				method: 'GET',
				params: {
	    			ids: documentIds.join()
	    		},
				success: function(response, action) {
					
					if(!isNullOrEmpty(response.responseText)) {
					var data = Ext.decode(response.responseText);
					if(data.length>0) {
						var dataArray = [];
						for(i in data) {
							var jsonObj ={
								"isInspectionDone":jsonFormFieldData.isInspectionDone,
						    	"inspectionDate":jsonFormFieldData.inspectionDate,
						    	"inspectionDoneBy":jsonFormFieldData.inspectionDoneBy,
						    	"documentNote":jsonFormFieldData.documentNote,
						    	"visibleNoteOnPortal":jsonFormFieldData.visibleNoteOnPortal,
						    	"documentStatusCSM":jsonFormFieldData.documentStatusCSM,
						    	"id":data[i].id,
						    	"type":"EXT_DOCUMENT",
						    	"submissionDate":data[i].submissionDate,
						    	"isElectronic":data[i].isElectronic,
						    	"documentType":data[i].documentType,
						    	"responsibleUser":data[i].responsibleUser,
						    	"modeOfSubmission":data[i].modeOfSubmission,
						    	"isInspectionRequired":data[i].isInspectionRequired,
						    	"isReturnable":data[i].isReturnable,
						    	"returnedDate":data[i].returnedDate,
						    	"returnedBy":data[i].returnedBy,
						    	"modeOfReturn":data[i].modeOfReturn,
						    	"returnedToUser":data[i].returnedToUser,
						    	"validTillDate":data[i].validTillDate
							}
							dataArray.push(jsonObj);
						}
					
						jsonData = Ext.encode(dataArray);
						
			    		Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.FIND_PATH_BULK_DOCUMENT_UPDATE,
							method: 'POST',
							jsonData: jsonData,
							success: function(res, action) {
								
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.FIND_PATH_BULK_APPLICANT_DOCUMENT_UPDATE,
									method: 'POST',
									jsonData: finalJsonData,
									success: function(response) {
										Ext.getBody().unmask();
										grid.getSelectionModel().deselectAll();
			                			store.getProxy().extraParams = {
			                				applicationId : applicationId
			                			};
			                			grid.getStore().reload();
			                			formWin.close();
			                			showSuccessMessage(getCommonTranslation('BULK_DOCUMENT_STATUS_UPDATE'), getCommonTranslation('BULK_DOCUMENT_STATUS_UPDATED_SUCCESSFULLY'));
									    var applicantProfileView = personProfile.down('#applicantProfileTemplate');
										if (!isNullOrEmpty(applicationId)) {
											var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
											if (!isNullOrEmpty(url)) {
												url = url.concat("?id=" + applicationId);
												Ext.Ajax.request({
													type: 'rest',
													url: url,
													method: 'GET',
													success: function(res, action) {
														if (portalId == 6) {
															if (Ext.ComponentQuery.query('dashboardhomepage').length != 0) {
																Ext.ComponentQuery.query('dashboardhomepage')[0].close();
															}
															if (Ext.ComponentQuery.query('userinfo').length != 0) {
																var dashBoardMenu = Ext.ComponentQuery.query('userinfo')[0];
																dashBoardMenu.down("#myDashboard").setVisible(false);
															}
														}
														var data = Ext.decode(res.responseText);
														if (!isNullOrEmpty(data) && !isNullOrEmpty(data.currentStatus)) {
															data.currentStatus = getAdmissionTranslation(data.currentStatus);
														}
														var tpl = applicantProfileView.tpl;
														if (Ext.isDefined(applicantProfileView.el)) {
															tpl.overwrite(applicantProfileView.el.dom, data);
														}
														if (portalId == 6) {
															if (!isNullOrEmpty(applicantProfileView.up().down('form'))) {
																applicantProfileView.up().down('form').getForm().setValues(data);
																var formFields = applicantProfileView.up().down('form').getForm().getFields().items;
																Ext.each(formFields, function(currentField) {
																	if (isNullOrEmpty(currentField.getValue())) {
																		currentField.hide();
																	} else {
																		currentField.show();
																	}
																});
															}
														}
													}
												});
											}
										}  
									},
				                    failure: function(){
				                    	Ext.getBody().unmask();
				                    }
								});
							},
			                failure: function(res, action){
			                	Ext.getBody().unmask();
			                }
						});
					}
					}
				},
				failure: function(res, action){
                	Ext.getBody().unmask();
                }
    		});
    	}
	},
});
