
/**
 * @author Deepak.Nigam
 */

Ext.define('Academia.controller.admission.applications.applicantDocuments.ApplicationBulkDownloadStatusController', {
    extend: 'Academia.controller.base.BaseController',

    alias: "widget.applicationbulkdownloadstatuscontroller",

    stores: ['admission.applications.applicationBase.ApplicationDownloadStatusGridStore',
             'student.report.StudentDownloadStatusGridStore',
             'personinfo.faculty.EmployeeDownloadStatusGridStore'],

    views: [ 'Academia.view.admission.applications.applicationBase.ApplicationBulkDownloadStatusGrid', 
             'Academia.view.admission.applications.applicationBase.ApplicationBulkDownloadStatusStructure',
             'Academia.view.student.studentBulkdownload.StudentBulkDownloadStatusStructure',
             'Academia.view.student.studentBulkdownload.StudentBulkDownloadStatusGrid',
             'Academia.view.personinfo.faculty.facultyBulkdownload.EmployeeBulkDownloadStatusStructure',
             'Academia.view.personinfo.faculty.facultyBulkdownload.EmployeeBulkDownloadStatusGrid'],
    
    refs: [{
        ref: 'applicationbulkdownloadstatusgrid',
        selector: 'applicationbulkdownloadstatusgrid'
    },{
        ref: 'applicationbulkdownloadstatusstructure',
        selector: 'applicationbulkdownloadstatusstructure [itemId=applicationbulkdownloadstatusstructureId]'
    },{
    	ref:'studentbulkdownloadstatusstructure',
    	selector:'studentbulkdownloadstatusstructure [itemId=studentbulkdownloadstatusstructureId]'
    },{
    	ref:'studentbulkdownloadstatusgrid',
    	selector:'studentbulkdownloadstatusgrid'
    },{
    	ref:'employeebulkdownloadstatusstructure',
    	selector:'employeebulkdownloadstatusstructure [itemId=employeebulkdownloadstatusstructureId]'
    },{
    	ref:'employeebulkdownloadstatusgrid',
    	selector:'employeebulkdownloadstatusgrid'
    }],
    config: {
    	
    },
    init: function(application) {
        this.control({
        	
        	'applicationbulkdownloadstatusstructure applicationbulkdownloadstatusgrid': {
            	render: function(grid) {
            		this.loadApplicationBulkDocumentDownloadstatusGrid();
            	},
            },
            
            'applicationbulkdownloadstatusgrid button[itemId=btnRefresh]': {
            	click: function(){
            		this.loadApplicationBulkDocumentDownloadstatusGrid();
            	}
            },
            
            'studentbulkdownloadstatusstructure studentbulkdownloadstatusgrid': {
            	render: function(grid) {
            		this.loadStudentBulkDocumentDownloadstatusGrid();
            	},
            },
            
            'studentbulkdownloadstatusgrid button[itemId=btnRefresh]': {
            	click: function(){
            		this.loadStudentBulkDocumentDownloadstatusGrid();
            	}
            },
            
            'employeebulkdownloadstatusstructure employeebulkdownloadstatusgrid': {
            	render: function(grid) {
            		this.loadEmployeeBulkDocumentDownloadstatusGrid();
            	},
            },
            
            'employeebulkdownloadstatusgrid button[itemId=btnRefresh]': {
            	click: function(){
            		this.loadEmployeeBulkDocumentDownloadstatusGrid();
            	}
            }
        });
    },
    
    loadApplicationBulkDocumentDownloadstatusGrid : function() {
    	
    	var grid = this.getApplicationbulkdownloadstatusgrid();
    	var store = grid.getStore()
    	store.getProxy().extraParams = {
    		requestFor:'APPLICANT'
    	};
    	store.load();
    },
    
    loadStudentBulkDocumentDownloadstatusGrid : function() {
    	
    	var grid = this.getStudentbulkdownloadstatusgrid();
    	var store = grid.getStore()
    	store.getProxy().extraParams = {
    		requestFor:'STUDENT'
    	};
    	grid.getStore().load();
    },
    
    loadEmployeeBulkDocumentDownloadstatusGrid : function() {
    	
    	var grid = this.getEmployeebulkdownloadstatusgrid();
    	var store = grid.getStore()
    	store.getProxy().extraParams = {
    		requestFor:'EMPLOYEE'
    	};
    	grid.getStore().load();
    }
    
});
