/*
 * @author prathamesh.sheth

 * 
 * This controller is used for application profile tab.
 *    
 */

Ext.define('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController', {

    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    alias: "widget.applicationprofilebasecontroller",
    
    mixins: { 
    	ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
    	ButtonPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
    	LinkPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
    	PersonDetailsLinkPanel:'Academia.view.personinfo.common.PersonDetailsLinkPanel'
    },		

    models: [
    					'admission.applications.applicantProfileBase.ApplicationProgramGridModel',
    					'admission.applications.applicantProfileBase.ApplicationDocumentAndNotesModel'
    			  ],

    stores: [
    				'admission.applications.applicantProfileBase.ReasonsForApprovalComboStore', 
    				'admission.applications.applicantProfileBase.ReasonsForRejectionComboStore', 
    				'admission.applications.applicantProfileBase.ReasonsForWithdrawalComboStore', 
    				'admission.applications.applicantProfileBase.ApplicationProgramGridStore', 
    				'admission.applications.applicantProfileBase.AdmissionGridStore',
    				'Academia.store.admission.applicationFormSale.ProgramTabGridStore',
    				'Academia.store.admission.applicationFormSale.ApplicantSelectionSnapshotStore',
    				'feeandpayment.managebill.InstallmentRuleStore',
    				'admission.applications.applicantdocuments.ApplicantDocumentStore',
    				'admission.applications.applicationReviewer.ApplicationReviewerComboStore',
    				'Academia.store.admission.applications.applicationReviewer.ReviewParamaterComboStore',
    				'Academia.store.admission.applications.applicationReviewer.ReviewRatingComboStore',
    				'Academia.store.admission.applications.applicationReviewer.ApplicationReviewerDetailStore',
					'admission.applications.eligibilitydetails.AchievementTypeStore',
					'course.readingmaterial.ReadingTypeStore',
					'admission.applications.eligibilitydetails.ProgEndorsedStatusStore',
					'examinationcenters.YesNo',
					'admission.applications.eligibilitydetails.HEQSFLevelStore',
					'admission.applications.eligibilitydetails.EligibilityStatusStore',
					'admission.applicationFormSale.ApplicationCheckListDetailStore',
					'admission.applicationFormSale.SalesforceAdmissionDetailsStore',
					'Academia.store.admission.applications.applicationReviewer.ApplicationDocumentAndNotesStore',
					'student.studentprofile.AcademicTopicUserIdStore','student.studentprofile.AcademicSubTopicStore',
					'student.studentprofile.AcademicTopicStatusStore',
					'admission.applications.applicantProfileBase.DocumentAndNotesDocumentGridStore',
					'admission.applications.applicantProfileBase.DocumentAndNotesUrlGridStore',
					'common.ApplicantProgramByApplicationIdStore','common.ApplicantBatchByProgramIdStore','common.ApplicantPeriodByBatchIdStore',
					'admission.applications.applicantProfileBase.DocumentsAndNotesDocumentsGridStore','admission.applications.applicantProfileBase.DocumentAndNoteUrlsStore',
					'admission.applications.applicantProfileBase.programCodeOrNameATCStore',
					'admission.applications.applicantProfileBase.BatchesByProgramIdATCStore',
					'admission.applications.applicantTransferCredits.AllApplicantTransferCreditDetailStore'
    			],

    views: [
    				'Academia.view.admission.applicationFormSale.ApplicantGrid',
    				'Academia.view.personinfo.common.PersonInfoPanel', 
    				'Academia.view.personinfo.common.PersonDetailsLinkPanel', 
    				'admission.applications.applicantProfileBase.ApplicantProfile', 
    				'admission.applications.applicantProfileBase.ActionButtonPanel', 
    				'admission.applications.applicantProfileBase.SelectionSnapshotGrid', 
    				'admission.applications.applicantProfileBase.ProfileTemplate', 
    				'admission.applications.applicantProfileBase.ApproveRejectWithdrawAdmissionWindow', 
    				'admission.applications.applicantProfileBase.ApplicationProgramGrid', 
    				'admission.applications.applicantProfileBase.ApproveRejectWithdrawApplicationWindow',
    				'admission.applications.applicationBase.ApplicationConditionsForAdmission',
    				'admission.applications.applicationBase.ApplicationConditionsDocumentList',
    				'admission.applications.applicationBase.ApplicationConditionsDocumentsUpdateStructure',
    				'admission.applications.applicationBase.ApplicationConditionsDocumentUpdateList',
    				'personinfo.common.documents.OnlineDocumentGrid',
    				'personinfo.common.documents.OnlineDocumentFormWin',
    				'personinfo.common.documents.PhysicalDocumentFormWin',
    				'admission.applications.applicationBase.ApplicationReviewDetails',
    				'admission.applications.applicationBase.ReviewDetailsPanel',
    				'admission.applications.applicationBase.ApplicationConditionsReviewDetails',
    				'admission.applications.applicationBase.ApplicationProgramConditionsReviewAdmGrid',
    				'admission.applications.applicationBase.ApplicationDetailsCheckListGrid',
    				'admission.applications.applicationBase.ApplicationAndAdmissionComments',
    				'admission.applications.applicationBase.AdmissionConditionsReviewAdmForm',
    				'admission.applications.applicationBase.ConditionsReviewerDetailsAdmGrid',
    				'admission.applications.applicationBase.ApplicationProgramWiseConditionsForAdmission',
    				'admission.applications.applicationBase.ApplicationProgramWiseConditionsAdmissionAdmGrid',
    				'admission.applications.applicationBase.ApplicantPWConditionsAdminAdmDocumentGrid',
    				'admission.applications.applicationBase.ApplicantListOfApplicableConditionsAdmGrid',
    				'admission.applications.applicantProfileBase.AdmissionGrid',
					'admission.applications.applicationBase.EligibilityDetailsForm',
					'admission.applications.applicantProfileBase.ApproveApplicationProgramForm',
					'admission.applications.applicantProfileBase.ApproveAdmissionProgramForm',
					'common.ScrollableAlertYesNoWindow',
					'admission.applications.applicationBase.SalesforceAdmissionDetailsGrid',
					'admission.applications.applicationBase.ApplicationDocumentsAndNotesGrid',
					'admission.applications.applicationBase.ApplicantSalesforceAdmissionDetailsForm',
					'admission.applications.applicationBase.ApplicantSalesforceAdmissionDetailsWindow',
					'admission.applications.applicationBase.DocumentAndNotesForm',
					'admission.applications.applicationBase.DocumentAndNotesFormWindow',
					'admission.applications.applicantProfileBase.DocumentAndNotesDocumentGrid',
					'admission.applications.applicantProfileBase.DocumentAndNotesUrlGrid',
					'admission.applications.applicantProfileBase.ApplicationAcademicTopicStructure',
					'admission.applications.applicantProfileBase.ApplicationAcademicsTopicQuickSearchForm',
					'admission.applications.applicationBase.DocumentsAndNotesDocumentsPopUp',
					'admission.applications.applicationBase.DocumentsAndNotesDocumentsGrid',
					'admission.applications.applicationBase.DocumentsAndNotesUrlPopup',
					'admission.applications.applicationBase.DocumentAndNotesUrlPopupGrid',
					 'personinfo.student.StudentUploadPhotoWindow','admission.applications.applicantProfileBase.TransferCreditsStructure',
					 'admission.applications.applicantProfileBase.TransferCreditsQuickSearchForm','admission.applications.applicationBase.TransferCreditsGrid',
					 'admission.applications.applicantProfileBase.TransferCreditsGridFormValues'
    			],
    			 config: {
    			    	APPROVE_APPLICATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPROVE_APPLICATION_PRIVILEGES'),
    			    	APPLICANT_PERSONAL_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PERSONAL_INFORMATION_PRIVILEGES'),
    			    	APPLICANT_APPLICATION_REVIEW_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_REVIEW_DETAILS_PRIVILEGES'),
    			    	APPLICATIONS_ELIGIBILITY_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATIONS_ELIGIBILITY_DETAILS_PRIVILEGES'),
    			    	APPLICANT_PORTEL_PERSONAL_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_PERSONAL_INFORMATION_PRIVILEGES'),
    			    	APPLICANT_APPLICATION_CONDITIONS_REVIEW_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_CONDITIONS_REVIEW_DETAILS_PRIVILEGES'),
    			    	APPLICANT_APPLICATION_PW_CONDITIONS_REVIEW_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_PROGRAM_WISE_CONDITIONS_REVIEW_DETAILS_PRIVILEGES'),
    			    	WITHDRAW_ADMISSION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('WITHDRAW_ADMISSION_PRIVILEGES'),
    			    	REJECT_ADMISSION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REJECT_ADMISSION_PRIVILEGES'),
    			    	APPROVE_ADMISSION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPROVE_ADMISSION_PRIVILEGES'),
    			    	APPLICATIONS_CHECK_LIST_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATIONS_CHECK_LIST_DETAILS_PRIVILEGES'),
    			    	APPLICATION_AND_ADMISSION_COMMENTS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_AND_ADMISSION_COMMENTS_PRIVILEGES'),
    			    	SALESFORCE_ADMISSION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SALESFORCE_ADMISSION_DETAILS_PRIVILEGES'),
    			    	APPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_DOCUMENTS_AND_NOTES_PRIVILEGES'),
    			    	APPLICATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_PRIVILEGES'),
    			    	WITHDRAW_FROM_PROGRAM_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('WITHDRAW_FROM_PROGRAM_PRIVILEGES'),
    			    	APPLICANT_TRANSFER_CREDITS_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_TRANSFER_CREDITS_PRIVILEGES')
    			 },
    refs: [{
    ref: 'applicantprofile',
    selector: 'applicantprofile',
    
}, 
           {
        ref: 'approveApplicantAdmissionWindow',
        selector: 'approverejectwithdrawadmissionwindow[itemId=approveApplicantAdmissionWindow]'
    }, {
        ref: 'rejectApplicantAdmissionWindow',
        selector: 'approverejectwithdrawadmissionwindow[itemId=rejectApplicantAdmissionWindow]'
    }, {
        ref: 'withdrawApplicantAdmissionWindow',
        selector: 'approverejectwithdrawadmissionwindow[itemId=withdrawApplicantAdmissionWindow]'
    }, {
        ref: 'approveApplicantApplicationWindow',
        selector: 'approverejectwithdrawapplicationwindow[itemId=approveApplicantApplicationWindow]'
    }, {
        ref: 'rejectApplicantApplicationWindow',
        selector: 'approverejectwithdrawapplicationwindow[itemId=rejectApplicantApplicationWindow]'
    }, {
        ref: 'withdrawApplicantApplicationWindow',
        selector: 'approverejectwithdrawapplicationwindow[itemId=withdrawApplicantApplicationWindow]'
    },{
        ref: 'actionButtonPanel',
        selector: 'ActionButtonPanel'
    },{
    	ref : 'applicationsListGrid',
    	selector : 'searchresultgrid[itemId=applicationsListGrid]'
    },{
    	ref : 'applicationProfileConditionsForAdmission', 
    	selector : 'applicationconditionsforadmission'
    },{
    	ref : 'applicationProfileReviewDetails', 
    	selector : 'applicationreviewdetails'
    },{
    	ref : 'reviewdetailspanel', 
    	selector : 'reviewdetailspanel'
    },{
    	ref : 'applicationProfileConditionsDocumentList',
    	selector : 'applicationconditionsdocumentlist'
    },{
    	ref : 'applicationconditionsdocumentsupdatestructure',
    	selector : 'applicationconditionsdocumentsupdatestructure'
    	
    },{
    	ref : 'applicationconditionsdocumentupdatelist',
    	selector : 'applicationconditionsdocumentupdatelist'
    },{
    	ref : 'applicantPortalConditionsForAdmission',
    	selector : 'applicationconditionsforadmission[itemId=applicationconditionsforadmissionItemId]'
    },{
    	ref : 'applicantPortalConditionsDocumentList',
    	selector : 'applicationconditionsdocumentlist[itemId=applicationconditionsdocumentlistItemId]'
    },{
        ref: 'applicantOnlineDocumentGrid',
        selector: 'onlinedocumentgrid[itemId=applicantOnlineDocumentGridItemId]'
    },{
        ref: 'applicantPhysicalDocumentGrid',
        selector: 'physicaldocumentgrid[itemId=applicantPhysicalDocumentGridItemId]'
    },{
    	ref : 'applicationconditionsreviewdetails', 
    	selector : 'applicationconditionsreviewdetails'
    },{
    	ref : 'applicationprogramconditionsreviewadmgrid', 
    	selector : 'applicationprogramconditionsreviewadmgrid'
    },{
    	ref : 'admissionconditionsreviewadmform', 
    	selector : 'admissionconditionsreviewadmform'
    },{
    	ref : 'conditionsreviewerdetailsadmgrid', 
    	selector : 'conditionsreviewerdetailsadmgrid'
    },{
    	ref : 'applicationprogramwiseconditionsadmissionadmgrid', 
    	selector : 'applicationprogramwiseconditionsadmissionadmgrid'
    },{
    	ref : 'applicationprogramwiseconditionsforadmission',
    	selector : 'applicationprogramwiseconditionsforadmission'
    },{
    	ref : 'applicantpwconditionsadminadmdocumentgrid',
    	selector : 'applicantpwconditionsadminadmdocumentgrid'
    },{
    	ref : 'applicantlistofapplicableconditionsadmgrid',
    	selector : 'applicantlistofapplicableconditionsadmgrid'
    }/*,{
        ref: 'applicantonlinedocumentformwin',
        selector: 'onlinedocumentformwin[itemId=applicantOnlineDocumentFormWin]'
    },{
        ref: 'applicantphysicaldocumentformwin',
        selector: 'physicaldocumentformwin[itemId=applicantPhysicalDocumentFormWin]'
    }*/,{
        ref: 'applicantEligibilityDetailsForm',
        selector: 'eligibilitydetailsform[itemId=eligibilitydetailsformItemId]'
    },{
    	ref:'scrollablealertyesnowindow',
    	selector:'scrollablealertyesnowindow'
    },{
        ref: 'approveadmissionprogramform',
        selector: 'approveadmissionprogramform'
    },
    {
    	ref : 'applicationdetailschecklistgrid', 
    	selector : 'applicationdetailschecklistgrid'
    },{
    	ref : 'applicationandadmissioncomments', 
    	selector : 'applicationandadmissioncomments'
    },{
    	ref : 'salesforceadmissiondetailsgrid', 
    	selector : 'salesforceadmissiondetailsgrid'
    },{
    	ref : 'applicationdocumentsandnotesgrid', 
    	selector : 'applicationdocumentsandnotesgrid[itemId=applicationdocumentsandnotesgrid]'
    },{
    	ref : 'applicantsalesforceadmissiondetailsform', 
    	selector : 'applicantsalesforceadmissiondetailsform'
    },{
    	ref : 'applicantsalesforceadmissiondetailswindow', 
    	selector : 'applicantsalesforceadmissiondetailswindow'
    }, {
        ref: 'applicationacademicstopicquicksearchform',
        selector: 'applicationacademicstopicquicksearchform'
    },{
        ref: 'documentAndNotesFormWindow',
        selector: 'documentandnotesformwindow[itemId=documentAndNotesFormWindow]'
    },{
    	ref : 'documentandnotesdocumentgrid', 
    	selector : 'documentandnotesdocumentgrid'
    },{
    	ref : 'documentandnotesurlgrid', 
    	selector : 'documentandnotesurlgrid'
    }, {
        ref: 'documentformwindow',
        selector: 'documentformwindow'
    }, {
        ref: 'applicationacademicstopicquicksearchform',
        selector: 'applicationacademicstopicquicksearchform'
    }, {
        ref: 'applicationacademictopicStructure',
        selector: 'applicationacademictopicStructure'
    }, {
        ref: 'documentsandnotesdocumentspopup',
        selector: 'documentsandnotesdocumentspopup'
    }, {
        ref: 'documentsandnotesdocumentsgrid',
        selector: 'documentsandnotesdocumentsgrid'
    }, {
        ref: 'documentsandnotesurlpopup',
        selector: 'documentsandnotesurlpopup'
    }, {
        ref: 'documentandnotesurlpopupgrid',
        selector: 'documentandnotesurlpopupgrid'
    },{
		ref : 'documenteditwithfileform',
		selector : 'documenteditwithfileform'

	},{
		ref: 'studentuploadphotowindow',
		selector: 'studentuploadphotowindow[itemId=studentuploadphotowindowItemId]'
	},
	{
		ref: 'admissiongrid',
		selector: 'admissiongrid'
	},{
		ref: 'transfercreditsstructure',
		selector: 'transfercreditsstructure'
	},{
		ref: 'transfercreditsquicksearchform',
		selector: 'transfercreditsquicksearchform'
	},{
		ref: 'transfercreditsgrid',
		selector: 'transfercreditsgrid'
	},{
		ref: 'transfercreditsgridformvalues',
		selector: 'transfercreditsgridformvalues'
	}
    ],

    init: function(application) {
        this.APPROVE = 'APPROVE';
        this.REJECT = 'REJECT';
        this.WITHDRAW = 'WITHDRAW';
        this.isAdd=true;
        this.control({
        	"persondetailslinkpanel[itemId=applicantPersonDetailsLinkPanel]":{
        		afterrender: function(sidePanel){
        			var me = this,
        			storeRecords = [],
        			sidePanelSearchCombo = sidePanel.down('#applicantPersonalDetailLinkSearchComboBox'),
        			sidePanelSearchStore = sidePanelSearchCombo.getStore(),
        			sidePanelItems,
        			upperTabTitle,
        			currentDataView,
        			currentItemIndex;

        			sidePanel.up('applicantprofile').on('activate', function(){
        				setTimeout(function(){
        					sidePanelItems = sidePanel.items.items,
        					Ext.each(sidePanelItems, function(sidePanelItem){
        						upperTabTitle = sidePanelItem.title;
        						currentDataView = sidePanelItem.down('dataview');
        						currentItemIndex = 0;

        						Ext.each(currentDataView.store.data.items, function(currentElement){
        							storeRecords.push({
        								displayPath: upperTabTitle,
        								title: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
        								parentPanelSelector: currentDataView.el.id,
        								currentElementSelector: currentDataView.itemSelector,
        								currentItemIndex: currentItemIndex,
        								searchText: getPersonModuleTranslation(currentElement.get('tabPanelTitle'))
        							});
        							currentItemIndex = currentItemIndex + 1;
        						});
        					});

        					sidePanelSearchStore.removeAll();
        					sidePanelSearchStore.add(storeRecords);
        					sidePanel.up('applicantprofile').un('activate');
        				},100);
        			},this);
        		},
        		beforecollapse:function(obj, direction, animate, eOpts){
        			try{
        				if(event.target.classList.contains('x-form-text')){
        					return false;
        				}
        			}
        			catch(e){
        				if(Ext.ComponentQuery.query('#applicantPersonalDetailLinkSearchComboBox')[0].hasFocus && Ext.ComponentQuery.query('#applicantPersonalDetailLinkSearchComboBox')[0].allowCollapse==false){
        					return false;
        				}
        			}
        		}
        	},
            "persondetailslinkpanel[itemId=applicantPersonDetailsLinkPanel] dataview": {
                itemclick: function(view, record) {
                	var me=this;
                    var tabPanelTitle = record.get('tabPanelTitle');
                    var tabPanelItemId = record.get('tabPanelItemId');
                    var tabPanelItemXtype = record.get('tabPanelItemXtype');
                    var xtypeItemId = record.get('xtypeItemId');
                    var defaultPanel = record.get('defaultPanel');

                    var isProceed=false;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	var LinkPanelSettingArray=me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);
	                    for(var count=0;count<LinkPanelSettingArray.length;count++){
							if(tabPanelItemXtype===LinkPanelSettingArray[count].linkXtype){
								isProceed=LinkPanelSettingArray[count].isAllowToOpenTab;
								break;
				           	}
						}	
	                    if(isProceed){
	                    	me.addPersonTabPanel('APPLICANT', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
	                    }else{
	                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NOT_HAVING_PERMISSION')); //You do not have permission to open this tab
	                    }
                    }    
                }
            }, 
            'applicantprofile panel[itemId=actionButtonPanel]': {
                render: function(form) {
                	//var form=this.getActionButtonPanel();
                	/*console.log('this',this);
                	var from = this.getApplicantprofile().down('#actionButtonPanel');
                	var form=from.getForm();
                	console.log('form',form);
                	this.doAccessControlValidation(form, this.getAPPROVE_APPLICATION_PERMISSIONS());
            		console.log('perm...',this.getAPPROVE_APPLICATION_PERMISSIONS());
            		console.log('form...',form);*/
//                	
                this.disableMoreActionPivileges(form,this.getAPPROVE_APPLICATION_PERMISSIONS());
                
               // V2D-18957
                var portalId = this.getCurrentLoggedPortalId();
                if(portalId==6){
                  this.disableApplicantPortelPrint(form,this.getAPPLICANT_PORTEL_PERSONAL_INFORMATION_PERMISSIONS());
                }else{
               this.disableApplicantProfilePrint(form,this.getAPPLICANT_PERSONAL_INFORMATION_PERMISSIONS());
                }
                var grid = this.getApplicationsListGrid();
                if(grid != undefined){
                	if (grid.getSelectionModel().getCount() > 0) {
                		var record = grid.getSelectionModel().getSelection()[0];
                		if(record.get('APPLICATION_STATUS')==='APPROVED'){
                			form.down('#approveApplicationBtn').setVisible(false);
                		}
                	}
                }
                }
            },
			'applicantprofile fieldset[itemId=applicantExpandContainerItemId]':{
				expand: function(label){
					var applicantprofile = label.up('applicantprofile');
					var lblFld = applicantprofile.down('#applicantExpandContainerItemId');
					lblFld.setTitle(getCommonTranslation('COLLAPSE_SELECTION_SNAPSHOT'));
				},
				collapse: function(label){
					var applicantprofile = label.up('applicantprofile');
					var lblFld = applicantprofile.down('#applicantExpandContainerItemId');
					lblFld.setTitle(getCommonTranslation('EXPAND_SELECTION_SNAPSHOT'));
				}
			},
			'applicantprofile fieldset[itemId=applicantPortalExpandContainerItemId]':{
				expand: function(label){
					var applicantprofile = Ext.ComponentQuery.query('applicantprofile')[0];
					var lblFld = applicantprofile.down('#applicantPortalExpandContainerItemId');
					lblFld.setTitle(getCommonTranslation('COLLAPSE_SELECTION_SNAPSHOT'));
				},
				collapse: function(label){
					var applicantprofile = Ext.ComponentQuery.query('applicantprofile')[0];
					var lblFld = applicantprofile.down('#applicantPortalExpandContainerItemId');
					lblFld.setTitle(getCommonTranslation('EXPAND_SELECTION_SNAPSHOT'));
				}
			},
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=approveApplicationBtn]': {
                click: function() {
                    var window = this.getApproveApplicantApplicationWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawapplicationwindow', {
                            itemId: 'approveApplicantApplicationWindow',
                            applicationType: this.APPROVE
                        });
                    }
                    window.show();
                }
            },
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=rejectApplicationBtn]': {
                click: function() {
                    var window = this.getRejectApplicantApplicationWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawapplicationwindow', {
                            itemId: 'rejectApplicantApplicationWindow',
                            applicationType: this.REJECT
                        });
                    }
                    window.show();
                }
            },
            'applicantprofile panel[itemId=imageParentPanel]':{
            	beforerender:function(me, eOpts ){
            		var thi$ = this;
            		if(!Ext.isDefined(Ext.ComponentQuery.query('#newApplicantPortalWindow')[0]) && portalId==6)
            		{       
        				//-- removing old grid
        				//me.up().remove(me.up().down('grid'));
            			this.getApplicantprofile().down('grid').setVisible(false);
        				
        				//-- removing old profile  image
        				me.items.items[0].setVisible(false);
        				
            			//--- removing old profile info
            			me.items.items[1].setVisible(false);
            			
            			//--- getting center panel to render window
            			var centerPanel = me.up().up();
            			
            			//-- creating new window
            			var newApplicantPortalWindow = Ext.create('Ext.panel.Panel',{
//            				width: centerPanel.getWidth()-30,
            				width:'100%',
            				height : centerPanel.getHeight(),
            				minHeight : 450,
            				itemId : 'newApplicantPortalWindow',
            				border : false,
            				frame : false,
            				layout: 'vbox',
            				padding: 0,
            				margin: 0,
            				autoScroll:true,
            				items:[
            				       {
            				    	   xtype: 'panel',
            				    	   layout: 'hbox',
            				    	   padding: 0,
            				    	   items: [
            				    	           /*{
            				    	        	   xtype: 'image',
            				    	        	   height: 150,
            				    	        	   width: 150,
            				    	        	   style: 'border: 5px double rgb(102, 106, 115);border-radius:50%;'
            				    	           },*/
            				    	           {
            				    	        	   xtype: 'image',
            				    	        	   height: 100,
            				    	        	   width: 100,
            				    	        	   src:  "data:image/jpeg;base64,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",	
            				    	        	   style: 'border: 1px solid #e0e0e0;border-radius:50%;'
            				    	           },
            				    	           {
            				    	        	   xtype: 'form',
            				    	        	   border: false,
            				    	        	   width: centerPanel.getWidth()-250,
            				    	        	   bodyPadding: '0 15',
            				    	        	   margin: '0 15',
            				    	        	   fieldDefaults: {
            				    	        		   labelAlign: 'top',
            				    	        		   labelWidth: 100,
            				    	        		   labelStyle: 'font-weight:bold;text-align:left;',
            				    	        		   border: false
            				    	        	   },
            				    	        	   defaults: {
            				    	        		   anchor: '100%',
            				    	        		   margins: '0 0 10 0',
            				    	        		   style: 'text-align:left;'
            				    	        	   },
            				    	        	   items: [{
            				    	        	        xtype: 'fieldcontainer',
            				    	        	        layout: {
            				    	        	        	type: 'column'
            				    	        	        },
            				    	        	        defaultType: 'displayfield',
            				    	        	        fieldDefaults: {
            				    	        	            labelAlign: 'top',
            				    	        	            border: '0',
            				    	        	            width: '24%',
            				    	        	            margin: '0 0 0 1%'
            				    	        	        },
                 				    	        	   defaults: {
                				    	        		   anchor: '100%'
                				    	        	   },
            				    	        	        items: [{
            				    	        	            fieldLabel: getAdmissionTranslation('APPLICATION_NO'),
            				    	        	            name: 'currentApplicationId',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('APPLICANT_NAME'),
            				    	        	            name: 'applicantName',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('PHONE_NO'),
            				    	        	            name: 'phoneNo',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('EMAIL_ID'),
            				    	        	            name: 'email',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('COUNT_PENDING_DOCUMENTS'),
            				    	        	            name: 'noOfDocumentsPending',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('APPLICATION_STATUS'),
            				    	        	            name: 'currentStatus',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('IS_HOSTEL_REQUIRED'),
            				    	        	            name: 'whetherHostelApplicable',
            				    	        	            value: '-',
            				    	        	            renderer: function(val, rec,e){
            				    	        	            	if(!isNullOrEmpty(val)){
            				    	        	            		if(val == 'true'){
                				    	        	            		return 'Yes';
                				    	        	            	} else {
                				    	        	            		return 'No';
                				    	        	            	}
            				    	        	            	}
            				    	        	            }
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('STUDENT_ID'),
            				    	        	            name: 'studentCode',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('ADMISSION_ID'),
            				    	        	            name: 'admissionCode',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('LINKED_ENQUIRY'),
            				    	        	            name: 'linkedEnquiryId',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('LINKED_APPLICATION_ID'),
            				    	        	            name: 'linkedApplicationId',
            				    	        	            value: '-'
            				    	        	        },
            				    	        	        {
            				    	        	            fieldLabel: getAdmissionTranslation('LINKED_STUDENT_ID'),
            				    	        	            name: 'linkedStudentId',
            				    	        	            value: '-'
            				    	        	        }]
            				    	        	    }],	            				    	   
            				    	           }
            				    	   ]
            				       },
            				       {
            				    	   xtype: 'fieldset',            
            				    	   title:getCommonTranslation('COLLAPSE_SELECTION_SNAPSHOT'),
            				    	   collapsible:true,
            				    	   itemId: 'applicantPortalExpandContainerItemId',
            				    	   border:true,
            				    	   style:{'margin-left': '10px !important'},
            				    	   frame:true,	
            				    	   width: '97%',
            				    	   collapsed:false,
            				    	   items:[{
            				    		   xtype:'selectionsnapshotgrid',
            				    		   itemId: 'selectionsnapshotgrid',
            				    		   flex:1,
            				    		   height: 280,
            				    		   width: '90%',
            				    		   style: {
            				    			   margin: '0 0 50 8',
            				    			   borderBottom: '1px solid #e0e0e0',
            				    			   paddingBottom:'0 !important'
   				  		    				}
            				    	   }]
            				       }
            				]
            			});
            			setTimeout(function(){
            				
            				//-- adding new created panel at first position
            				me.insert(0, newApplicantPortalWindow);
            				
            				//-- removing overflow/scrollbar
            				me.up('applicantprofile').down('panel').body.dom.style.overflow = 'hidden';
            			
            				//-- hiding buttons from newly added grid
            				//newApplicantPortalWindow.down('selectionsnapshotgrid').down('fieldcontainer').setVisible(false);
            			
            				thi$.mixins.ApplicationBaseController.gettingDataInSummaryGridExpand(me.up('applicantprofile'));
            			},10);
            		}
            	}
            },
            'applicantprofile image[itemId=profile_image]': {
            	show: function( me, eOpts ) {
            		if(portalId==6)
        			{
            			var imageSrc = me.getEl().dom.src;
                		me.up('applicantprofile').down('image').getEl().dom.src =(imageSrc);
                		me.hide();
                		me.up('applicantprofile').down('profiletemplate').hide();
        			}
            	}
            },
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=withdrawApplicationBtn]': {
                click: function() {
                    var window = this.getWithdrawApplicantApplicationWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawapplicationwindow', {
                            itemId: 'withdrawApplicantApplicationWindow',
                            applicationType: this.WITHDRAW
                        });
                    }
                    window.show();
                }
            },
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=approveAdmissionBtn]': {
                click: function() {
                    var window = this.getApproveApplicantAdmissionWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawadmissionwindow', {
                            itemId: 'approveApplicantAdmissionWindow',
                            admissionType: this.APPROVE
                        });
                    }
                    window.show();
                }
            },
            
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=printBtn]': {
                click: function() {
                    /*var window = this.getApproveApplicantAdmissionWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawadmissionwindow', {
                            itemId: 'approveApplicantAdmissionWindow',
                            admissionType: this.APPROVE
                        });
                    }
                    window.show();*/
                	this.printButtonAction();
                }
            },
            
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=printprofileBtn]': {
            	 click: function() {
            		 this.printButtonAction();
            	 }
            },
            
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=rejectAdmissionBtn]': {
                click: function() {
                    var window = this.getRejectApplicantAdmissionWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawadmissionwindow', {
                            itemId: 'rejectApplicantAdmissionWindow',
                            admissionType: this.REJECT
                        });
                    }
                    window.show();
                }
            },
            'applicantprofile panel[itemId=actionButtonPanel] button[itemId=withdrawAdmissionBtn]': {
                click: function() {
                    var window = this.getWithdrawApplicantAdmissionWindow();
                    if (!window) {
                        window = Ext.widget('approverejectwithdrawadmissionwindow', {
                            itemId: 'withdrawApplicantAdmissionWindow',
                            admissionType: this.WITHDRAW
                        });
                    }
                    window.show();
                }
            },
            'approverejectwithdrawapplicationwindow': {
                afterrender: function(window) {
                	var me = this;                                        
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(applicantProfile.getApplicationInfo()['isViewMode']){                    		
                    		me.mixins.ApplicationBaseController.setContainerInViewMode(window,"approverejectwithdrawapplicationwindow>fieldcontainer>button",applicantProfile);
                    	}                    	
                    }
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=approveApplicantApplicationWindow] grid[itemId=applicationProgramGrid]': {
                render: function(grid) {
                	var me = this;
                    var url = SERVERURL.APPLICATIONS_APPROVE_PROGRAM_GRIDDATA; //rest/applicationProgram/applicationsToApprove                    
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    			var paramObject = {
                    				 applicationID: applicantProfile.getApplicationId()
                                };
                    			grid.getStore().getProxy().extraParams = {
                    				applicationID: applicantProfile.getApplicationId()
                    			};
                                this.loadGridStore(grid, url, paramObject);                    		                             
                    	}
                    }
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=rejectApplicantApplicationWindow] grid[itemId=applicationProgramGrid]': {
                render: function(grid) {
                	var me = this;
                    var url = SERVERURL.APPLICATIONS_REJECT_PROGRAM_GRIDDATA; //rest/applicationProgram/applicationsToReject
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    			var paramObject = {
                    					applicationID: applicantProfile.getApplicationId()
                                };
                                this.loadGridStore(grid, url, paramObject);                    		                             
                    	}
                    }
                }   
            },
            'approverejectwithdrawapplicationwindow[itemId=withdrawApplicantApplicationWindow] grid[itemId=applicationProgramGrid]': {
                render: function(grid) {
                	var me = this;
                    var url = SERVERURL.APPLICATIONS_WITHDRAW_PROGRAM_GRIDDATA; //rest/applicationProgram/applicationsToWithdraw
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    			var paramObject = {
                    					applicationID: applicantProfile.getApplicationId()
                                };
                                this.loadGridStore(grid, url, paramObject);                    		                             
                    	}
                    }
                }
            },
            'approverejectwithdrawadmissionwindow': {
                afterrender: function(window) {
                	var me = this;                                        
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(applicantProfile.getApplicationInfo()['isViewMode']){                    		
                    		me.mixins.ApplicationBaseController.setContainerInViewMode(window,"approverejectwithdrawadmissionwindow>fieldcontainer>button",applicantProfile);
                    	}                    	
                    }
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=approveApplicantAdmissionWindow] grid[itemId=admissionGrid]': {
            	render: function(grid) {
            		var me = this;                	                	
            		var url = SERVERURL.APPLICATIONS_APPROVE_ADMISSION_GRIDDATA; //rest/applicationAdmissionDetails/admissionsToApprove
            		var applicantProfile = me.getContentPanelActiveTab();
            		if (applicantProfile) {
            			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
            				var paramObject = {
            						applicationId: applicantProfile.getApplicationId()
            				};
            				grid.getStore().getProxy().extraParams = {
            					applicationId: applicantProfile.getApplicationId()
                			};
            				this.loadGridStore(grid, url, paramObject);
            			}
            		}
            	},
            	afterrender:function(grid){
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getAPPROVE_ADMISSION_PERMISSIONS());
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var window = this.getApproveApplicantAdmissionWindow();
            		var combo = window.down('#installmentRuleItemId');
            		combo.setDisabled(false);
            		var store = combo.getStore();
            		store.getProxy().extraParams={
            			progBatchSeatId : record.get('programBatchSeatConfigurationId'),
            			progBatchPeriodId : record.get('programBatchPeriodConfigurationId')
            		};
            		store.load();
            	}
            },
         /*   'approverejectwithdrawadmissionwindow[itemId=approveApplicantAdmissionWindow] customcombobox[itemId=installmentRuleItemId]': {
                change: function(obj) {
                	var me = this;                	                	
                	var form = me.getApproveApplicantAdmissionWindow();
                	var installmentFiled = form.down('#installmentRuleItemId');
                	installmentFiled.getStore().getProxy().extraParams= {
                		progBatchSeatId:grid.getCode()
                	};
                	installmentFiled.getStore().load();
                }
            },*/
            
            'approverejectwithdrawadmissionwindow[itemId=rejectApplicantAdmissionWindow] grid[itemId=admissionGrid]': {
                render: function(grid) {
                	var me = this;
                    var url = SERVERURL.APPLICATIONS_REJECT_ADMISSION_GRIDDATA; //rest/admission/admissionsToReject
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    			var paramObject = {
                                    applicationId: applicantProfile.getApplicationId()
                                };
                                grid.getStore().getProxy().extraParams = {
                    				applicationId: applicantProfile.getApplicationId()
                    			};
                                this.loadGridStore(grid, url, paramObject);                    		                             
                    	}
                    }                    
                },
                afterrender:function(grid){
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getREJECT_ADMISSION_PERMISSIONS());
                }
            },
            'approveadmissionprogramform[itemId=approveAdmissionProgramForm]' :{
            	afterrender: function(form){
            		var me = this;
            		var applicantProfile = me.getContentPanelActiveTab();
            		setTimeout(function(){
            			var form = me.getApproveadmissionprogramform();
            			var billingStartDate = form.down('#billingStartDateId');
            			billingStartDate.hide();
            			billingStartDate.setFieldLabel(getCommonTranslation('BILLING_START_DATE'));
            		},500);
            		var admissionApprovedOn	= form.down('#admissionApprovedOn');
            		this.loadDFRForAdmissionApprovedOn(admissionApprovedOn);
            		var schoolAttendanceStartDate = form.down('#schoolAttendanceStartDate');
            		Ext.Ajax.request({
								type: 'rest',
								async: false,
								url: SERVERURL.APPLICATIONS_APPROVE_ADMISSION_GRIDDATA,
								params: {
									applicationId: applicantProfile.getApplicationId()
								},
								method: 'GET',
								success: function(res, action) {
									var response = Ext.decode(res.responseText);
									schoolAttendanceStartDate.setValue(dateRender(response[0].schoolAttendanceStartDate));
								}
							});
            	}
            },
            'approverejectwithdrawadmissionwindow[itemId=rejectApplicantAdmissionWindow] form[itemId=approveAdmissionProgramForm]': {
            	afterrender:function(form){
            		var sectionsCombo = form.down('#allSectionsVerifiedItemId');
            		var documentsCombo = form.down('#allDocumentsVerifiedItemId');
            		var admissionApprovedOn = form.down('#admissionApprovedOn');
            		sectionsCombo.setVisible(false);
            		documentsCombo.setVisible(false);
            		sectionsCombo.allowBlank = true;
            		documentsCombo.setVisible(false);
            		documentsCombo.allowBlank = true;
            		admissionApprovedOn.allowBlank = true;
            		admissionApprovedOn.setVisible(false);
            	}
            },
            'approverejectwithdrawadmissionwindow[itemId=withdrawApplicantAdmissionWindow] grid[itemId=admissionGrid]': {
                render: function(grid) {
                	var me = this;
                    var url = SERVERURL.APPLICATIONS_WITHDRAW_ADMISSION_GRIDDATA; //rest/admission/admissionsToWithdraw
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    			var paramObject = {
                                    applicationId: applicantProfile.getApplicationId()
                                };
                                grid.getStore().getProxy().extraParams = {
                    				applicationId: applicantProfile.getApplicationId()
                    			};
                                this.loadGridStore(grid, url, paramObject);                    		                             
                    	}
                    }                    
                },
                afterrender:function(grid){
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getWITHDRAW_ADMISSION_PERMISSIONS());
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var grid = grid.up('grid');
					var form = this.getApproveadmissionprogramform();
					var withdrawbtn = form.down('#withdrawFromProgramBtn');
					var button = form.down('#submitBtn');
            		if(record.data.admissionStatus=="ADMISSION_CONFIRMED"){
            			withdrawbtn.setDisabled(false);	
            			button.setDisabled(true);	
            		}else{
            			withdrawbtn.setDisabled(true);	
            			button.setDisabled(false);
            		}
            	}
            },
            'approverejectwithdrawadmissionwindow[itemId=withdrawApplicantAdmissionWindow] form[itemId=approveAdmissionProgramForm]': {
            	afterrender:function(form){
            		this.disableWithdrawFromProgramPivileges(form,this.getWITHDRAW_FROM_PROGRAM_PERMISSIONS());
            		var sectionsCombo = form.down('#allSectionsVerifiedItemId');
            		var documentsCombo = form.down('#allDocumentsVerifiedItemId');
            		var admissionApprovedOn = form.down('#admissionApprovedOn');
            		sectionsCombo.setVisible(false);
            		documentsCombo.setVisible(false);
            		sectionsCombo.allowBlank = true;
            		documentsCombo.setVisible(false);
            		documentsCombo.allowBlank = true;
            		admissionApprovedOn.allowBlank = true;
            		admissionApprovedOn.setVisible(false);
            	}
            },
            'approverejectwithdrawadmissionwindow[itemId=approveApplicantAdmissionWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getApproveApplicantAdmissionWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=rejectApplicantAdmissionWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getRejectApplicantAdmissionWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=withdrawApplicantAdmissionWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getWithdrawApplicantAdmissionWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=approveApplicantApplicationWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getApproveApplicantApplicationWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=rejectApplicantApplicationWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getRejectApplicantApplicationWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=withdrawApplicantApplicationWindow] button[itemId=cancelBtn]': {
                click: function(grid) {
                    var window = this.getWithdrawApplicantApplicationWindow();
                    this.closeFormWindow(window);
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=approveApplicantAdmissionWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                    var window = this.getApproveApplicantAdmissionWindow();
                    //window.down('#submitBtn').setDisabled(true);
                    this.saveAdmissionProgramGridData(window, this.APPROVE, getAdmissionTranslation('APPROVE_ADMISSION_MSG'));
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=rejectApplicantAdmissionWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                    var window = this.getRejectApplicantAdmissionWindow();
                    this.saveAdmissionProgramGridData(window, this.REJECT, getAdmissionTranslation('REJECT_ADMISSION_MSG'));
                }
            },
            'approverejectwithdrawadmissionwindow[itemId=withdrawApplicantAdmissionWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                    var window = this.getWithdrawApplicantAdmissionWindow();
                    this.saveAdmissionProgramGridData(window, this.WITHDRAW, getAdmissionTranslation('WITHDRAWN_ADMISSION_MSG'));
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=approveApplicantApplicationWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();                      
                    if (applicantProfile) {
                    	var applicationId=applicantProfile.getApplicationId();
                    	if(!isNullOrEmpty(applicationId)){
                            var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
                            if(!isNullOrEmpty(url)){
                            	url = url.concat("?id=" + applicationId);
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: url,
                                    method: 'GET',
                                    success: function(res, action) {
                                        var data = Ext.decode(res.responseText);
                                        if(data.currentStatus!='INCOMPLETE')
                                        	{
                                        	var window = me.getApproveApplicantApplicationWindow();
                                			me.saveApplicationProgramGridData(window, "APPROVED", getAdmissionTranslation('APPROVE_APPLICATION_MSG'),applicationId,applicantProfile);
                                        	}else{
                                        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('APPLICATION_INCOMPLETE_MESSAGE'));
                                        	}
                                    }
                                });
                            }          	
                    	}                    	                         
                    }                      
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=rejectApplicantApplicationWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();                      
                    if (applicantProfile) {
                    	var applicationId=applicantProfile.getApplicationId();
                    	if(!isNullOrEmpty(applicationId)){
                    		var window = this.getRejectApplicantApplicationWindow();
                    		this.saveApplicationProgramGridData(window, "REJECTED", getAdmissionTranslation('REJECT_APPLICATION_MSG'),applicationId,applicantProfile);
                    	}                    	                         
                    }                      
                }
            },
            'approverejectwithdrawapplicationwindow[itemId=withdrawApplicantApplicationWindow] button[itemId=submitBtn]': {
                click: function(grid) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();                      
                    if (applicantProfile) {
                    	var applicationId=applicantProfile.getApplicationId();
                    	if(!isNullOrEmpty(applicationId)){
                    		var window = this.getWithdrawApplicantApplicationWindow();
                            this.saveApplicationProgramGridData(window, "WITHDRAWN", getAdmissionTranslation('WITHDRAWN_APPLICATION_MSG'),applicationId,applicantProfile);
                    	}                    	                         
                    }                      
                }
            }, 
            'applicationconditionsforadmission': {
                render: this.getRenderApplicationConditionDocumentList
            },
            'applicationreviewdetails':{
            	afterrender: this.getRenderApplicationReviewDetails
            },
            'applicationconditionsdocumentlist button[itemId=btnUploadDocument]':{
            	click: function() {
                    this.showApplicantConditionsForAdmissionWindow();
                }
            },
            'applicationconditionsforadmission button[itemId=btnSave]':{
            	click: function() {
            	this.saveApplicationConditionsForAdmission();
            	}
            },
            'applicationconditionsdocumentsupdatestructure button[itemId=btnAdd]':{
            	click: this.updateConditionsDocumentsForAdmission
            },
     		'reviewdetailspanel button[itemId=btnAdd]':{
    			click: function(button) {
    				var grid  =this.getContentPanel().getActiveTab().down('reviewdetailspanel');
    		        var getApplicationReviewStructure = grid.up('applicationreviewdetails');
    				this.addNewRowInReviewDetailsGrid(1, grid, getApplicationReviewStructure);
    			}
     		},
     		'reviewdetailspanel button[itemId=btnDelete]':{
    			click: function(button) {
    				this.deleteReviewerDetails('#reviewdetails',SERVERURL.PATH_DELETE_APPLICATION_REVIEWER);
    			}
     		},
     		'applicationreviewdetails button[itemId=SubmitBtn]':{
     			click: this.saveApplicationReviewerWithDetails
    		},
    		  'applicationreviewdetails combo#reviewerId': {
                  change: function(obj, record) {
                	  var $this = this;
                	  var userId=$this.getCurrentlyLoggedInUser();
                	  var rec = Ext.isObject(record) ? record[0] : obj.store.getById(record);

					  if (!rec) {
						  obj.store.on('load', function() {
							  rec = obj.store.getById(record);
							  if (rec && rec.get("id")!=null) {
								  $this.getReviewerDetails(rec.get("id"), rec.get("userId"), rec.get("applicationOwnerId"), userId);
							  }
						  }, this, { single: true });
						  return;
					  }
					  if (rec.get("id")!=null) {
					      $this.getReviewerDetails(rec.get("id"), rec.get("userId"), rec.get("applicationOwnerId"), userId);
					  }
                  }
              },
              'applicationconditionsreviewdetails':{
              	render: this.getRenderApplicationConditionsReviewDetails
              },
              'applicationprogramconditionsreviewadmgrid': {
            	  beforeselect: function(rowModel, record, index, eOpts) {
                      var me = this;
                      var applicantProfile = me.getContentPanelActiveTab();
                      var conditionReviewGrid =  applicantProfile.down('conditionsreviewerdetailsadmgrid');
                      var form =  applicantProfile.down('admissionconditionsreviewadmform');
                      var admissionConditionPanel = form.down('#applicableAdmissionReviewPanelId');
              		  for(var i=admissionConditionPanel.items.length-1; i>0;i--){
              		      admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
              	      }
              		  form.doLayout();
                      form.getForm().reset();
                      conditionReviewGrid.getStore().removeAll();
                    	  if (!isEmpty(record.data)) {
                    		  if (!isNullOrEmpty(record.data.id)) {
                    			  var applicationProgramID = record.data.id;
                    			  var submitUrl = SERVERURL.PATH_FIND_APPLICATION_PROGRAMS_ADMISSION_DETAILS_BY_ID +"?applicationProgramID="+applicationProgramID;
                    			  if (!isNullOrEmpty(submitUrl)) {
                    				  Ext.Ajax.request({
                    					  type: 'rest',
                    					  url: submitUrl,
                    					  method: 'GET',
                    					  success: function(success) {
                    						if(!isNullOrEmpty(success.responseText)) {
                    						  var data = Ext.decode(success.responseText);
                    						  me.setAdmissionConditionReviewFormValues(form,data,record.data.currentStatus);
                    						  if(!isNullOrEmpty(data.applicationProgram)){
                    							  var conditionReviewStore = conditionReviewGrid.getStore();
                    							  conditionReviewStore.getProxy().extraParams = {
                    								  applicationProgramID: data.applicationProgram.id
                    							  }
                    							  conditionReviewStore.load();
                    						  }
                    					  }
                    				  	}
                    				  });

                    			  }
                    		  }
                    	  }
                  } 
              },
              'applicationconditionsreviewdetails button[itemId=pAdmConReviewSubmitBtn]':{
              	click: function() {
              	this.saveAdmConditionsForReviewAdmission();
              	}
              },
              'admissionconditionsreviewadmform button[itemId=addConditionBtn]':{
            	  click: function(obj) {
          			this.addMultipleConditionForReviewScreen(obj.up('form'));
          		}
              },
              'admissionconditionsreviewadmform customcombobox[itemId=dliAdmApplicableAdmissionConditionItemId]':{
            	  afterrender: function(obj) {
            	  		
            		  var form = obj.up('form');
            		  var offerType = form.down('#isOfferType').getValue();
           		   
            		  if(!isNullOrEmpty(offerType)) {
            			  obj.getStore().proxy.extraParams = {
            				  offerType:offerType 
            			  };
            			  obj.getStore().load();
            		  }
            	  },
            	  select: function(obj,record,value) {
          			var form = obj.up('form');
          			var additionalCondition = obj.nextSibling();
          			var satisfactionDate = obj.nextSibling().nextSibling();
          			additionalCondition.reset();
          			satisfactionDate.reset();
          			var selectedConditionId = record[0].get('id');
  					var count = 0;
  					var subjectMarkPanel = obj.up("#applicableAdmissionReviewPanelId");
  					var rowIndx = obj.rowIndx;
  					if(!isNullOrEmpty(subjectMarkPanel)){
  						subjectMarkPanel.items.each(function(item, index, items) {
  							var conditionId = item.down("[name=dliAdmApplicableAdmissionCondition]").getValue();
  							if(selectedConditionId == conditionId){
  								count++;
  							}
  						});
  					}
  					if(count==1) {
  						if(!isNullOrEmpty(record[0].data) && !isNullOrEmpty(record[0].data.code)) {
  	        				additionalCondition.setValue(record[0].data.code);
  	        			}
  					} else {
  						obj.reset();
  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('APPLICABLE_CONDITION_ALREADY_SELECTED_MSG'));
  						return false;
  					}
          		}
              },
              'applicationprogramwiseconditionsforadmission':{
              	render: this.getRenderApplicationProgramWiseConditionsForAdmission
              },
              'applicationprogramwiseconditionsadmissionadmgrid': {
            	  beforeselect: function(rowModel, record, index, eOpts) {
                      var me = this;
                      var applicantProfile = me.getContentPanelActiveTab();
                      var documentGrid =  me.getContentPanel().getActiveTab().down('applicantpwconditionsadminadmdocumentgrid');
                      var conditionGrid = me.getContentPanel().getActiveTab().down('applicantlistofapplicableconditionsadmgrid');
                      if(portalId==6){
          	    		var applicantProfile = 	me.getContentPanel().items.items[0];
          	    		 var form =me.getContentPanel().getActiveTab();
          	    		form.down('#admPWCSubmitBtn').setVisible(false);
          	    		documentGrid.down('#btnUploadDocument').setVisible(false);
          	    		}else{
          	    		var applicantProfile = me.getContentPanelActiveTab();
          	    		 var form =me.getContentPanel().getActiveTab().down('applicationprogramwiseconditionsforadmission');
          	    		}
                      var applicationId = applicantProfile.getApplicationId();
                      form.getForm().reset();
            		  form.down('#admPWCSubmitBtn').setDisabled(true);
            		  documentGrid.getStore().removeAll();
            		  conditionGrid.getStore().removeAll();
                    	  if (!isEmpty(record.data)) {
                    		  if (!isNullOrEmpty(record.data.id)) {
                    			  var applicationProgramID = record.data.id;
                    			  var submitUrl = SERVERURL.PATH_FIND_APPLICATION_PROGRAMS_ADMISSION_DETAILS_BY_ID +"?applicationProgramID="+applicationProgramID;
                    			  if (!isNullOrEmpty(submitUrl)) {
                    				  Ext.Ajax.request({
                    					  type: 'rest',
                    					  url: submitUrl,
                    					  method: 'GET',
                    					  success: function(success) {
                    						  if(!isNullOrEmpty(success.responseText)) {
                    						  var data = Ext.decode(success.responseText);
                    						  var applicantpwconditionsadminadmdocumentgrid =  me.getContentPanel().getActiveTab().down('applicantpwconditionsadminadmdocumentgrid');
                    						  applicantpwconditionsadminadmdocumentgrid.getStore().load({
                								  params: {
                									  applicationId: applicationId,
                									  applicationProgramId: data.applicationProgram.id
                								  }
                    						  });
                                    		  var applicantlistofapplicableconditionsadmgrid = me.getContentPanel().getActiveTab().down('applicantlistofapplicableconditionsadmgrid');
                                    		  applicantlistofapplicableconditionsadmgrid.getStore().load({
            								  params: {
            									  applicationProgramID: data.applicationProgram.id
            								  },
            								  callback: function(record, operation, success) {
            				   					if (success) {
            				    					if(record.length>0) {
            				    						form.down('#admPWCSubmitBtn').setDisabled(false);
            				    					}
            				    				}
            								  }
                						  });
                    					  }
                    				  	}
                    				  });

                    			  }
                    		  }
                    	  }
                  } 
              },
              'applicantpwconditionsadminadmdocumentgrid button[itemId=btnUploadDocument]': {                
                  click: function(){
                  	this.uploadDocumentAdmApplicantFormWindow();                                                 	
                  }
              },
              'documentformwindow[itemId=applicantConditionProgramDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                  click: function(){
                  	this.saveApplicantConditionalAdmProgramDocumentForm();
                  }
              },
              'documentformwindow[itemId=applicantConditionProgramDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
            	  click: function(){
            		  var this$ = this;
            		this$.getAdmApplicantProfileDocumentController().closeDocumentFormWindow();
            	  }
              },
		 	  'applicationprogramwiseconditionsforadmission button[itemId=admPWCSubmitBtn]':{
			 			click: function(obj) {
			 				this.saveAdmApplicantProgramWiseCondition(obj);
			 			}
			 },
/**
               *  Eligibility Details
               */
			'eligibilitydetailsform[itemId=eligibilitydetailsformItemId]': {
                  render: function(form) {
                      var url = SERVERURL.ED_APPLICANT_ELIGIBILITY_DETAIL_FIND_BY_PERSON_ID + '?personId=';
                      this.onRenderEligibilityDetailsForm(url);
                  }
              },
			'eligibilitydetailsform[itemId=eligibilitydetailsformItemId] button[itemId=submitButtonId]': {
				click: function() {
					var getUrl = SERVERURL.ED_APPLICANT_ELIGIBILITY_DETAIL_FIND_BY_PERSON_ID + '?personId=';
					this.saveEligibilityDetails(SERVERURL.ED_APPLICANT_ELIGIBILITY_DETAIL_UPDATE, getUrl);
				}
			},
			'eligibilitydetailsform[itemId=eligibilitydetailsformItemId] customcombobox#achievementTypeItemId':{
           	 	select: function(combo, record) {
					var personProfile = this.getContentPanelActiveTab(); 
        			var eligibilitydetailsform = personProfile.down('eligibilitydetailsform');      
            		var achievementTypeOtherItemId = eligibilitydetailsform.down("#achievementTypeOtherItemId");
					if (!isNullOrEmpty(record[0].data.code) && record[0].data.code == 'Other') {
						achievementTypeOtherItemId.setVisible(true);
					} else {
						achievementTypeOtherItemId.setVisible(false);
					}
					achievementTypeOtherItemId.reset();
				}
			},
			'scrollablealertyesnowindow button[itemId=popupConfirmYes]':{
				click : function(btn) {					
					var alertWin = this.getScrollablealertyesnowindow();
					alertWin.close();
					var window = this.getApproveApplicantAdmissionWindow();
                    this.saveAdmissionProgramGridData(window, this.APPROVE, getAdmissionTranslation('APPROVE_ADMISSION_MSG'),true);
				}
			},
			'scrollablealertyesnowindow button[itemId=popupConfirmNo]':{
				click : function(btn) {
					var alertWin = this.getScrollablealertyesnowindow();
					alertWin.close();
				}
			},
			
			'approveadmissionprogramform button[itemId=withdrawFromProgramBtn]':{
				click : function(btn) {
					var $this = this;
					var approvalAdmissionForm = this.getApproveadmissionprogramform();
					var serviceRequestField = approvalAdmissionForm.down('#serviceRequestCombo');
					var admissionGridStore = this.getAdmissiongrid().getStore();
					var programId=null;
					var applicationProgramId = null;
					if(!isNullOrEmpty(admissionGridStore.data) && !isNullOrEmpty(admissionGridStore.data.items[0]) && !isNullOrEmpty(admissionGridStore.data.items[0].data.program))
					{
						programId=admissionGridStore.data.items[0].data.program.id;
						applicationProgramId = admissionGridStore.data.items[0].data.id;
					}
					var window = btn.up('window');
                   
					
					serviceRequestField.getStore().getProxy().extraParams = {
						serviceRequestCategory: 'STUDENT_REQUEST',
						academyLocationId: this.getCurrentAcademyLocation(),
						programId:programId,
						serviceRequestRequiredForInActiveStudent: false
	                }
					serviceRequestField.getStore().load({
	                     callback: function(records, operation, success) {
	                    	 for(var i in records){
								 if(records[i].data.code=='WFPO'&& records[i].data.translatedCode == 'WFPO'){
									 //serviceRequestField.setValue(records[i].data.id);
									 
									 Ext.Ajax.request({
			        	    			  type : 'rest',
			        	    			  url : SERVERURL.PATH_APPLICATION_DETAILS+'?applicationProgramId=' + applicationProgramId,
			        	    			  method : 'GET',
			        	    			  success : function(form, action) {
			        	    				  var res = Ext.JSON.decode(form.responseText);
                                               var admissionId = res.applicationAdmissionDetailId;
                                               var studentCode = res.applicationCode;
                                               var studentId = res.existingStudentId;
                                               var personId = res.preEligibilityId;
                                               var setConfigId = res.programBatchSeatConfigurationId;
                                               var programId = res.programId;
                                               var programName = res.program;
                                               var batchId = res.batchId;
                                               var applicationId = res.applicationId;
                                               
                                               var record ={};
                                              
                                               record.data={
                                                  'ADMISSION_ID':admissionId,
                                                  'STUDENT_ID': studentId,
                                                  'PROGRAM_BATCH_SEAT_CONFIG_ID': setConfigId,
                                                  'PROGRAM_BATCH_ID': batchId,
                                                  'PROGRAM_ID': programId,
                                                  'PROGRAM_NAME':programName,
                                                  'ID':studentId
                                               }
                                               
                                               
                                               window.close();
												 var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
													serviceRequestController.getRequestPanel('STUDENT_REQUEST','TRANSFER',studentId,personId,records[i],record);
													//$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
			        	    			  }
			        	    		  });
								 }
							 }
	                     }
	                 });
					
					
					
				}
			},
			/*'approveadmissionprogramform':{
				afterrender:function(){
					var me = this;
					setTimeout(function(){
					var form = me.getApproveadmissionprogramform();
					var billingStartDate = form.down('#billingStartDateId');
					billingStartDate.hide();
					billingStartDate.setFieldLabel(getCommonTranslation('BILLING_START_DATE'));
					},500);
				}

			},*/
			'approveadmissionprogramform combo#installmentRuleItemId' :{
				  select: function(obj, record) {

					  	 var form = this.getApproveadmissionprogramform();
						  var billingDateField = form.down('#billingStartDateId');
						  //billingDateField.setVisible(true);
						  var me = this; 
						  var applicantProfile = me.getContentPanelActiveTab();
		            		
							Ext.Ajax.request({
								type: 'rest',
								async: false,
								url: SERVERURL.COMMON_FORM_FIELD_INFO,
								params: {
									//screenName: 'Manage Receipt',
									academyLocationId: this.getCurrentAcademyLocation(),
									languageCode:'en',
								},
								method: 'GET',
								success: function(res, action) {
									var response = Ext.decode(res.responseText);
		
									if( Object.keys(response).length > 0 ){
										var records=response.approveadmissionprogramform;
										if(records){
											for(i in records){
												if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='billingStartDateId' && records[i].isVisible==true){
													billingDateField.setVisible(true);
												}
												if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='billingStartDateId' && records[i].isMandatory==true){
													billingDateField.allowBlank = false;
													billingDateField.labelSeparator = '';
		   				                            billingDateField.setFieldLabel( getFeeAndPaymentCommonTranslation('BILLING_START_DATE')+'<span class="required" style="color:red"> *</span>');
													break;
												}
												
		
											}
										}
		
									}
								}
							})
						 
						  Ext.Ajax.request({
								type: 'rest',
								async: false,
								url: SERVERURL.APPLICATIONS_APPROVE_ADMISSION_GRIDDATA,
								params: {
									applicationId: applicantProfile.getApplicationId()
								},
								method: 'GET',
								success: function(res, action) {
									var response = Ext.decode(res.responseText);
									billingDateField.setValue(dateRender(response[0].admissionDate));
									
								}
							});
					  }
				
			},
			
			  'applicationdetailschecklistgrid': {
	                render: function(grid) {
	                	var me = this;
	                	grid.getSelectionModel().deselectAll();
	                	var applicantProfile = me.getContentPanelActiveTab();
	                	var snapShotgrid=applicantProfile.down('#selectionSnapShotGrid');
	                var snapShotGridStore =snapShotgrid.getStore();
	                var idsArray = [];
	                var selectedStatus =[];
	                if(snapShotGridStore.getCount()>0){
	                	snapShotGridStore.data.items.forEach(function(obj){
	                		idsArray.push(obj.get('programBatchSeatConfigurationId')) 
	                	});
	                }
	                grid.getStore().getProxy().extraParams = {
	                	progBatchSeatConfigId:idsArray.join()
	                }
	                 grid.getStore().load({
	                     callback: function(records, operation, success) {
	                    	 for(var i in records){
								 if(records[i].data.status==true){
									 selectedStatus.push(records[i]);
								 }
							 }
	                    	 grid.getSelectionModel().select(selectedStatus);
	                     }
	                 });
	                }   
	            },
				  'applicationandadmissioncomments': {
					  afterrender: function(grid) {
		                	var me = this;
		                    var applicantProfile = me.getContentPanelActiveTab();
		                    if (applicantProfile) {
		                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
//		                    		var paramObject =
//		                    		{
//		                    				applicationID: applicantProfile.getApplicationId()
//		                    		};
		                    		grid.getStore().getProxy().extraParams = {
		                    			applicationId: applicantProfile.getApplicationId()
		                    		};
		                    		grid.getStore().load();         		                             
		                    	}
		                    }
		                }
		            },
		            'salesforceadmissiondetailsgrid': {
						  afterrender: function(grid) {
			                	var me = this;
			                	me.doAccessControlValidation(grid, me.getSALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
			                	me.addDataGridConfigButton(grid,me.getSALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
			                    var applicantProfile = me.getContentPanelActiveTab();
			                    if (applicantProfile) {
			                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
			                    		grid.getStore().getProxy().extraParams = {
			                    			applicantPersonId: applicantProfile.personInfo.id
			                    		};
			                    		grid.getStore().load();         		                             
			                    	}
			                    }
			                }
			            },
			                        'applicationacademicstopicquicksearchform customcombobox[itemId=academicTopicItemId]': {
							   afterrender: function(academicTopic, records, eOpts) {
								   var this$ = this;
								   var user = this.getCurrentlyLoggedInUser();
								   var academicTopicStore = academicTopic.getStore();
								   academicTopicStore.proxy.extraParams = {
										   userId:user.id
			                       };
								   academicTopicStore.load();
							   },
							   select: function(academicTopic, records, eOpts) {
								   var academicSubTopic = academicTopic.up('form').down('#academicSubTopicItemId');
								   academicSubTopic.setDisabled(false);
								   var academicSubTopicValue = academicTopic.getValue();
								   this.loadAcademicTopicDependentCombo(academicSubTopic, academicSubTopicValue, 'academicTopicId');
							   }
						   },
						   
						   
						   'applicationacademicstopicquicksearchform customcombobox[itemId=programItemId]': {
							   render: function(obj){
								   var $this=this;
									var form=obj.up('form').getForm();
									var academyLocationId = $this.getCurrentAcademyLocation();
									var applicantProfile = $this.getContentPanelActiveTab();
									var applicationId = applicantProfile.getApplicationId();
			        			    var programId =form.findField('programId');
			        			    var ProgramIdStore = programId.getStore();
			        			    ProgramIdStore.proxy.extraParams = {
			        			    		applicationId : applicationId,
			        			    		academyLocationId : academyLocationId
			                        };
			        			    ProgramIdStore.load({
			        			    	callback: function(record) {if (record && record.length == 1) {
			        			    	    programId.setValue(record[0].data.id);
			        			    	    programId.setReadOnly(true);

			        			    	    var batchCombo = form.findField('batch');
			        			    	    batchCombo.enable();

			        			    	    var applicantProfile = $this.getContentPanelActiveTab();
			        			    	    var applicationId = applicantProfile.getApplicationId();

			        			    	    var batchStore = batchCombo.getStore();
			        			    	    batchStore.getProxy().extraParams = {
			        			    	        applicationId: applicationId,
			        			    	        programId: record[0].get('id')
			        			    	    };

			        			    	    batchStore.load({
			        			    	        callback: function (records, operation, success) {
			        			    	            if (success && records && records.length == 1) {
			        			    	                batchCombo.setValue(records[0].data.id);
			        			    	                batchCombo.setDisabled(false);
			        			    	                batchCombo.setReadOnly(true);

			        			    	                var periodCombo = form.findField('period');
			        			    	                periodCombo.enable();

			        			    	                var applicantProfile = $this.getContentPanelActiveTab();
			        			    	                var applicationId = applicantProfile.getApplicationId();

			        			    	                var periodStore = periodCombo.getStore();
			        			    	                periodStore.getProxy().extraParams = {
			        			    	                    applicationId: applicationId,
			        			    	                    batchId: records[0].get('id')
			        			    	                };

			        			    	                periodStore.load({
			        			    	                    callback: function (records, operation, success) {
			        			    	                        if (success && records && records.length == 1) {
			        			    	                            periodCombo.setValue(records[0].data.id);
			        			    	                            periodCombo.setReadOnly(true);
			        			    	                        }
			        			    	                    }
			        			    	                });
			        			    	            }
			        			    	        }
			        			    	    });
			        			    	}
		}
			        			    });
							   },afterrender: function(program, records, eOpts) {
								   var this$ = this;
								   var applicantProfile = $this.getContentPanelActiveTab();
								   var applicationId = applicantProfile.getApplicationId();
								   this.loadAcademicTopicDependentCombo(program, applicationId/*, 'studentId'*/);
							   },
							   select: function(combo, records, eOpts) {
								   var batch = combo.up('form').down('#batchCombo');
								   var period = combo.up('form').down('#periodId');
								   period.clearValue();
								   period.store.removeAll();
								   period.reset();
								   batch.reset();
								   batch.setDisabled(false);
								   var comboValue = combo.getValue();
								   var activeTab = this.getContentPanelActiveTab();
				                   var applicationId = activeTab.getApplicationId();
								   this.loadAcademicTopicDependentCombo(batch, comboValue, 'programId', 'applicationId',applicationId);
							   }
						   },
						   
						   'applicationacademicstopicquicksearchform customcombobox[itemId=batchCombo]': {
							   select: function(combo, records, eOpts) {
								   var period = combo.up('form').down('#periodId');
								   period.reset();
								   period.setDisabled(false);
								   var comboValue = combo.getValue();
								   var activeTab = this.getContentPanelActiveTab();
				                   var applicationId = activeTab.getApplicationId();
								   this.loadAcademicTopicDependentCombo(period, comboValue, 'batchId', 'applicationId',applicationId);
							   }
						   },        
			    'applicationacademicstopicquicksearchform button[itemId=applicationAcademicTopicSearchButtonId]': {
						click:this.loadAcademicTopicData
				},
				'applicationacademicstopicquicksearchform button[itemId=clearSearch]': {
					click:function(obj, rec){
						this.resetAcademicTopicFormDropdowns();
					}
				},
			            'salesforceadmissiondetailsgrid button[itemId=btnView]': {
			                click: function(){
			                	this.viewSalesForceAdmissionDetailFormWindow();
			                }
			            },
			            'applicantsalesforceadmissiondetailsform button[itemId=cancelButtonId]': {
			                click: function(grid) {
			                    var window = this.getApplicantsalesforceadmissiondetailswindow();
			                    this.closeFormWindow(window);
			                }
			            },
			            'applicationdocumentsandnotesgrid[itemId=applicationdocumentsandnotesgrid]': {
							  render: function(grid) {
				                	var me = this;
				                	me.doAccessControlValidation(grid, me.getAPPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS());
				                    var applicantProfile = me.getContentPanelActiveTab();
				                    
				                },
				                afterrender: function(grid) {
				                	var me = this;
				                	me.addDataGridConfigButton(grid,me.getAPPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS());
				                },
				 				 cellclick: function(gridview, td, cellIndex, record, tr, rowIndex, e, eOpts) {
									   var $this = this;
									   var grid = gridview.up('grid');
									   var columnName = grid.columnManager.columns[cellIndex].dataIndex;
									   if(e.target.tagName == 'A' && columnName == 'uploadedDocuments') {
										   if(record.data.documents.length == 1){
											   var whetherFile = false;
											   var documentId= record.data.documents["0"].encryptedDocId;
											   if(!isNullOrEmpty(documentId)){
												   Ext.Ajax.request({
													   type: 'rest',
													   url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
													   method: 'GET',
													   callback : function(opt, success, response){
														   if(response.responseText == 'true') {
															   var csvForm = Ext.create('Ext.form.Panel'); 
															   csvForm.getForm().submit({
																   target: '_blank',
																   method:'GET',
																   params :{
																	   access_token : Ext.Ajax.defaultHeaders.access_token
																   },
																   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																   standardSubmit :true
															   });
														   }
														   else {
															   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
														   }
													   }
												   });
											   }
										   }
										   else if(record.data.documents.length > 1){
											   var docWindow = this.getDocumentsandnotesdocumentspopup();
											   if (!docWindow) {
												   docWindow = Ext.widget('documentsandnotesdocumentspopup',{
													   itemId:'documentsandnotesdocumentspopup'
												   });
											   }
											   docWindow.show();
											   docWindow.center();
											   var documentsandnotesdocumentsgrid = docWindow.down('#documentsandnotesdocumentsgridItemId');
											   var store = documentsandnotesdocumentsgrid.getStore();
											   store.getProxy().extraParams = {
												   applicationAcademicTopicId: record.data.id
											   };
											   store.load({
												   callback: function() {
													   docWindow.center();
												   }
											   });
										   }
									   }
									   else if(e.target.tagName == 'A' && columnName == 'applicantAcademicTopicUrl') {
										   if(record.data.applicantAcademicTopicUrl.length == 1){
											   var whetherFile = false;
											   var documentId= record.data.urlName["0"].id;
											   if(!isNullOrEmpty(documentId)){
												   Ext.Ajax.request({
													   type: 'rest',
													   url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
													   method: 'GET',
													   callback : function(opt, success, response){
														   if(response.responseText == 'true') {
															   var csvForm = Ext.create('Ext.form.Panel'); 
															   csvForm.getForm().submit({
																   target: '_blank',
																   method:'GET',
																   params :{
																	   access_token : Ext.Ajax.defaultHeaders.access_token
																   },
																   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																   standardSubmit :true
															   });
														   }
														   else {
															   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
														   }
													   }
												   });
											   }
										   }
										   else if(record.data.applicantAcademicTopicUrl.length > 1){
											   var docWindow = this.getDocumentsandnotesurlpopup();
											   if (!docWindow) {
												   docWindow = Ext.widget('documentsandnotesurlpopup',{
													   itemId:'documentsandnotesurlpopup'
												   });
											   }
											   docWindow.show();
											   docWindow.center();
											   var documentandnotesurlgrid = docWindow.down('#documentandnotesurlpopupgridItemId');
											   var store = documentandnotesurlgrid.getStore();
											   store.getProxy().extraParams = {
												   applicationAcademicTopicId: record.data.id
											   };
											   store.load({
												   callback: function() {
													   docWindow.center();
												   }
											   });
										   }
									   }
								   }
				            },
			   'applicationacademictopicStructure[itemId=applicationacademictopicStructureId]': {
					render: function(structure) {
				       var me = this;
				       var contentPanelTab = me.getContentPanelActiveTab();
	 					var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	 					var structure1  = personInfoPanel.down('#applicationacademictopicStructureId');
						var grid= structure1.down('#applicationdocumentsandnotesgrid');
				       var url = SERVERURL.GET_APPLICANT_ACADEMIC_TOPIC_GRID_DATA; 
				       var applicantProfile = me.getContentPanelActiveTab();
				       var structure = applicantProfile.down('[region=center]');
				       me.getGridHeaderFreeze(grid,structure1,true);
				       if (applicantProfile) {
				    	   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
				    		   var paramObject = {
				    				   applicationId: applicantProfile.getApplicationId(),
				  					   userId : me.getCurrentlyLoggedInUser().id

	                                };
	                    			grid.getStore().getProxy().extraParams = {
	                    				applicationId: applicantProfile.getApplicationId(),
					  					   userId : me.getCurrentlyLoggedInUser().id
	                    			};
	                                this.loadGridStore(grid, url, paramObject);
				    	   }
				       }
				       me.doAccessControlValidation(grid, me.getAPPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS());
				       
				       
				    },
				    afterrender: function(grid) {
				       var me = this;
				       me.addDataGridConfigButton(grid,me.getAPPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS());
				    }
				},
				/*Start Applicant Transfer Credit*/
				'transfercreditsquicksearchform': {
					afterrender: function(form){
						var me = this;
 				        var applicantId = me.getContentPanelActiveTab().getApplicationId();
                          //var activeTab =me.getContentPanelActiveTab();
						  //var form = activeTab.down('transfercreditsquicksearchform');
 				        var programField = form.getForm().findField('programCodeNameATC');
 				        var batchField = form.getForm().findField('batchATC');
 				        
 				        if (!programField || !batchField) {
				            return;
				        }

				        var programStore = programField.getStore();
				        programStore.getProxy().extraParams = {
				        	applicationID: applicantId
				        };
				        
				        programStore.load({
 				            callback: function(records, success) {
 				                if (!success || records.length === 0) return;

 				                var selectedProgram = records.length == 1 ? records[0] : Ext.Array.findBy(records, function(rec) {
 				                    return !!rec.get('value');
 				                });

 				                if (selectedProgram) {
 				                    var programId = selectedProgram.get('programId');
 				                    programField.setValue(programId);
 				                    
 				                   batchField.setDisabled(false);
 				                    var batchStore = batchField.getStore();

 				                    if (!batchStore) return;

 				                    batchStore.getProxy().extraParams = {
 				                    	id: programId
 				                    };

 				                    batchStore.load({
 				                        callback: function(batchRecords, batchSuccess) {
 				                            if (batchSuccess && batchRecords.length > 0) {
 				                                batchField.setValue(batchRecords[0].get('id'));
 				                            }
 				                        }
 				                    });
 				                }
 				            }
 				        });
					}
				},
				'transfercreditsstructure[itemId=transfercreditsstructureId]': {
					  render: function(grid) {
		                	var me = this;
		                	me.doAccessControlValidation(grid, me.getAPPLICANT_TRANSFER_CREDITS_PRIVILEGES());
		                    var applicantProfile = me.getContentPanelActiveTab();
		                    
		                },
		                afterrender: function(grid) {
		                	var me = this;
		                	me.addDataGridConfigButton(grid,me.getAPPLICANT_TRANSFER_CREDITS_PRIVILEGES());
		                	me.getGridButtonsPivileges(grid, me.getAPPLICANT_TRANSFER_CREDITS_PRIVILEGES());
		                }
		         },
		        'transfercreditsgrid': {
		        	viewready: this.onGridViewReady,
		        	selectionchange: function(column, selected,eOpts){
 						var me  = this
 					    var grid = me.getTransfercreditsgrid();
 						var gridStructure = me.getTransfercreditsstructure();
 					    var btnApprove = grid.down('#approveATCBtnitemId');
 					    var btnReject = grid.down('#rejectATCBtnitemId');
 					    var btnResubmit = grid.down('#resubmitATCBtnitemId');
 					    var btnSubmit = gridStructure.down('#btnSaveATCItemId');
 					    var btnReset = gridStructure.down('#btnResetATCItemId');
 					    var btnRepeat = gridStructure.down('#applicantTrnsRepeatId');
 					    var disableFlag = false;
 					   /* if (selected.length === 0) {
 					        btnApprove.setDisabled(true);
 					        btnReject.setDisabled(true);
 					        btnResubmit.setDisabled(true);
 					       btnResubmit.setDisabled(true);

 					        return;
 					    }*/
 					   if (selected.length > 0) {
                           btnSubmit.setDisabled(false);
                           btnReset.setDisabled(false);
                           btnRepeat.setDisabled(false);

                           selected.forEach(function(record) {
                               var status = record.get('applicantTransferCreditStatus');
                               var exemptionType = record.get('exemptionType');
                               if (status == 'APPROVE' || status == 'REJECT') {
                                       disableFlag = true;
                                   }
                               if (exemptionType == 'REPEAT') {
                                       btnRepeat.setDisabled(true);
                               }
                               });
                               if(disableFlag) {
                                  btnSubmit.disable();
                                }
                                else {
                                    btnSubmit.enable();
                                }
                               
                       } else {
                           btnSubmit.setDisabled(true);
                           btnReset.setDisabled(true);
                           btnApprove.setDisabled(true);
                           btnReject.setDisabled(true);
                           btnResubmit.setDisabled(true);
                           btnRepeat.setDisabled(true);
                           return;
                       }
 					    var statuses = [];
 					    Ext.Array.each(selected, function (rec) {
 					        statuses.push(rec.get('applicantTransferCreditStatus'));
 					    });

 					    var hasPending = Ext.Array.contains(statuses, 'PENDING');

 					    if (hasPending) {
 					        btnApprove.setDisabled(true);
 					        btnReject.setDisabled(true);
 					        btnResubmit.setDisabled(true);
 					        return;
 					    }
// 					   var hasApproveOrReject = Ext.Array.some(statuses, function (status) {
//                           return status == 'APPROVE' || status == 'REJECT';
//                       });
 					    var canApprove = Ext.Array.every(statuses, function (status) {
 					        return status == 'SUBMIT' || status == 'REJECT' || status == 'NEED_TO_RESUBMIT';
 					    });

 					    var canReject = Ext.Array.every(statuses, function (status) {
 					        return status == 'SUBMIT' || status == 'APPROVE' || status == 'NEED_TO_RESUBMIT';
 					    });

 					    var canResubmit = Ext.Array.every(statuses, function (status) {
 					        return status == 'SUBMIT' || status == 'APPROVE' || status == 'REJECT';
 					    });

 					 
 					    btnApprove.setDisabled(!canApprove);
 					    btnReject.setDisabled(!canReject);
 					    btnResubmit.setDisabled(!canResubmit);
// 					   btnSubmit.setDisabled(hasApproveOrReject);
 					   },
 					  afterrender: function(grid){
 		                 var me=this;

 		                 me.addDataGridConfigButton(grid,me.getAPPLICANT_TRANSFER_CREDITS_PRIVILEGES());
 		             }
		        },
	            'transfercreditsquicksearchform customcombobox[itemId=programCodeNameATCItemId]': {
	            	select: function(combo, record) {
	             		var appForm = combo.up('form');
	             		var batchCombo = appForm.down('#batchATCItemId');
	             		batchCombo.setDisabled(false);
	             		batchCombo.reset();
	             		var programId = record[0].get('programId');
	             		var store = batchCombo.getStore();
	             		store.getProxy().extraParams = {
	             			id: programId
	             		};
	             		store.load();
	            	}
		       },
	           'transfercreditsquicksearchform button[itemId=applicantTranferCreditsSearchButtonId]': {
	        	   click: this.loadApplicantTranferCredits
	           },
	           'transfercreditsquicksearchform button[itemId=clearSearchATCItemID]': {
	        	   click: function(cmp){
	                    var me = this;
	                    form = me.getTransfercreditsquicksearchform();
	                    var batch = form.down("#batchATCItemId");
	                    batch.setDisabled(true);
	                    form.getForm().reset();                  
	                }
	           },
	           'transfercreditsstructure button[itemId=btnSaveATCItemId]': {
	        	   click: this.saveApplicantTransferGridData
	           },
	           'transfercreditsstructure button[itemId=btnResetATCItemId]': {
	        	   click: function(btn){
        				var me = this;
        				var grid = me.getTransfercreditsgrid();
        				if (grid && grid.getSelectionModel) {
        					var selectedRecords = grid.getSelectionModel().getSelection();

        		            Ext.each(selectedRecords, function(record) {
        		                record.reject();
        		            });
        		            grid.getSelectionModel().deselectAll();
        		        }
        			}
	           },
	           'transfercreditsgrid button[itemId=approveATCBtnitemId]': {
	        	   click:function(btn){
						this.transferCreditApproveRejectResubmit('approve', btn, false)
					}
	           },
	           'transfercreditsgrid button[itemId=rejectATCBtnitemId]': {
	        	   click:function(btn){
						this.transferCreditApproveRejectResubmit('reject', btn, false)
					}
	           },
	           'transfercreditsgrid button[itemId=resubmitATCBtnitemId]': {
	        	   click:function(btn){
						this.transferCreditApproveRejectResubmit('resubmit', btn, false)
					}
	           },
	           'transfercreditsgrid button[itemId=applicantTrnsRepeatId]': {
	        	   click:function(btn){
						this.transferCreditApproveRejectResubmit('Mark As Repeat', btn, true)
					}
	           },
				/*End Applicant Transfer Credit*/
				'applicationacademictopicStructure[itemId=applicationacademictopicStructureId] button[itemId=btnAdd]': {
					click: function() {
						var $this =this;
						this.isAdd=true;
						var formWindow = $this.getDocumentAndNotesFormWindow();
						if (!formWindow) {
							formWindow = Ext.widget('documentandnotesformwindow', {
								          itemId: 'documentAndNotesFormWindow'
							});
						}
						formWindow.show();
						if( formWindow != null ){
							var isPublished = formWindow.down('#public');
							isPublished.setValue(false);
						    var createdDate = formWindow.down('#createdDate');
						    createdDate.setValue(dateRender(new Date()));
						    createdDate.setReadOnly(true);
						    var user = this$.getCurrentlyLoggedInUser();
						    var createdById = formWindow.down('#createdById');
						    createdById.setValue(user.code+'/'+user.value); 
						        			  
						    var updatedDate = formWindow.down('#updatedDate');
						    updatedDate.setValue(dateRender(new Date()));
						    updatedDate.setReadOnly(true);
						    var user = this$.getCurrentlyLoggedInUser();
						    var updatedById = formWindow.down('#updatedById');
						    updatedById.setValue(user.code+'/'+user.value);
						    var document = formWindow.down('documentandnotesdocumentgrid');
						    var documenturl = formWindow.down('documentandnotesurlgrid');
                            document.getStore().removeAll();
                            documenturl.getStore().removeAll();
						    setTimeout(function(){
						       formWindow.down('#dateId').setValue(dateRender(new Date()));
						    },500);
					  }
					}
				},
				'applicationacademictopicStructure[itemId=applicationacademictopicStructureId] button[itemId=btnEdit]': {
					click: function(){
						 this.isAdd=false;
						 this.editApplicantDocumentAndNotes('DOCUMENTS_AND_NOTES','documentAndNotesFormWindow', 'applicationdocumentsandnotesgrid');
						 this.applicantDocDocumentAndNotesContainerWindow();
						 this.applicantUrlDocumentAndNotesContainerWindow();
					}
				},
				
				'applicationacademictopicStructure[itemId=applicationacademictopicStructureId] button[itemId=btnView]': {
					click: function(){
						 this.viewApplicantDocumentAndNotes('DOCUMENTS_AND_NOTES','documentAndNotesFormWindow', 'applicationdocumentsandnotesgrid');
						 this.applicantDocDocumentAndNotesContainerWindow();
						 this.applicantUrlDocumentAndNotesContainerWindow();
					}
				},
				 'applicationacademictopicStructure[itemId=applicationacademictopicStructureId] button[itemId=btnDelete]': {
		            	click: function() {
		            		 var me = this;
								var structure1 = me.getApplicationacademictopicStructure();
								var grid= structure1.down('#applicationdocumentsandnotesgrid');
		            		me.deleteApplicantDocumentAndNotes(grid, SERVERURL.PATH_APPLICANT_ACADEMIC_RECORD_DELETE);
		            	}
		            },
		           
				'documentandnotesformwindow[itemId=documentAndNotesFormWindow] button[itemId=submitButtonId]': {
					   click: function(){
						   this.saveApplicantDocumentAndNotes('#applicationdocumentsandnotesgrid', SERVERURL.SAVE_APPLICANT_ACADEMIC_TOPIC_DATA, SERVERURL.UPDATE_APPLICANT_ACADEMIC_TOPIC_DATA);
					   }
				},
			   'documentandnotesformwindow[itemId=documentAndNotesFormWindow] button[itemId=cancelButtonId]': {
					click: function() {
					   this.getDocumentAndNotesFormWindow().close();
					}
				},
			   'documentandnotesformwindow[itemId=documentAndNotesFormWindow] customcombobox[itemId=academicTopicItemId]': {
				afterrender: function(academicTopic, records, eOpts) {
					 var this$ = this;
					 var user = this.getCurrentlyLoggedInUser();
					 var academicTopicStore = academicTopic.getStore();
					 academicTopicStore.proxy.extraParams = {
					       userId:user.id
					 };
					 academicTopicStore.load();
				 },
				 select: function(academicTopic, records, eOpts) {
						var academicSubTopic = academicTopic.up('form').down('#academicSubTopicItemId');
						academicSubTopic.setDisabled(false);
						var academicSubTopicValue = academicTopic.getValue();
						this.loadAcademicTopicDependentCombo(academicSubTopic, academicSubTopicValue, 'academicTopicId');
				 }
				},
				'documentandnotesformwindow[itemId=documentAndNotesFormWindow] customcombobox[itemId=programItemId]':  {
					   render: function(obj){
						   var $this=this;
							var form=obj.up('form').getForm();
							var academyLocationId = $this.getCurrentAcademyLocation();
							var applicantProfile = $this.getContentPanelActiveTab();
							var applicationId = applicantProfile.getApplicationId();
	        			    var programId =form.findField('programId');
	        			    var ProgramIdStore = programId.getStore();
	        			    ProgramIdStore.proxy.extraParams = {
	        			    		applicationId : applicationId,
	        			    		academyLocationId : academyLocationId
	                        };
	        			    ProgramIdStore.load({
	        			    	callback: function(record) {if (record && record.length == 1) {
	        			    	    programId.setValue(record[0].data.id);
	        			    	    programId.setReadOnly(true);

	        			    	    var batchCombo = form.findField('batch');
	        			    	    batchCombo.enable();

	        			    	    var applicantProfile = $this.getContentPanelActiveTab();
	        			    	    var applicationId = applicantProfile.getApplicationId();

	        			    	    var batchStore = batchCombo.getStore();
	        			    	    batchStore.getProxy().extraParams = {
	        			    	        applicationId: applicationId,
	        			    	        programId: record[0].get('id')
	        			    	    };

	        			    	    batchStore.load({
	        			    	        callback: function (records, operation, success) {
	        			    	            if (success && records && records.length == 1) {
	        			    	                batchCombo.setValue(records[0].data.id);
	        			    	                batchCombo.setDisabled(false);
	        			    	                batchCombo.setReadOnly(true);

	        			    	                var periodCombo = form.findField('period');
	        			    	                periodCombo.enable();

	        			    	                var applicantProfile = $this.getContentPanelActiveTab();
	        			    	                var applicationId = applicantProfile.getApplicationId();

	        			    	                var periodStore = periodCombo.getStore();
	        			    	                periodStore.getProxy().extraParams = {
	        			    	                    applicationId: applicationId,
	        			    	                    batchId: records[0].get('id')
	        			    	                };

	        			    	                periodStore.load({
	        			    	                    callback: function (records, operation, success) {
	        			    	                        if (success && records && records.length == 1) {
	        			    	                            periodCombo.setValue(records[0].data.id);
	        			    	                            periodCombo.setReadOnly(true);
	        			    	                        }
	        			    	                    }
	        			    	                });
	        			    	            }
	        			    	        }
	        			    	    });
	        			    	}
}
	        			    });
					   },afterrender: function(program, records, eOpts) {
						   var this$ = this;
						   var applicantProfile = $this.getContentPanelActiveTab();
						   var applicationId = applicantProfile.getApplicationId();
						   this.loadAcademicTopicDependentCombo(program, applicationId/*, 'studentId'*/);
					   },
					   select: function(combo, records, eOpts) {
						   var batch = combo.up('form').down('#batchCombo');
						   var period = combo.up('form').down('#periodId');
						   period.clearValue();
						   period.store.removeAll();
						   period.reset();
						   batch.setDisabled(false);
						   var comboValue = combo.getValue();
						   var activeTab = this.getContentPanelActiveTab();
		                   var applicationId = activeTab.getApplicationId();
						   this.loadAcademicTopicDependentCombo(batch, comboValue, 'programId', 'applicationId',applicationId);
					   }
				   },
				   'documentandnotesformwindow[itemId=documentAndNotesFormWindow] customcombobox[itemId=batchCombo]': {
					   select: function(combo, records, eOpts) {
						   var period = combo.up('form').down('#periodId');
						   period.setDisabled(false);
						   var comboValue = combo.getValue();
						   var activeTab = this.getContentPanelActiveTab();
		                   var applicationId = activeTab.getApplicationId();
						   this.loadAcademicTopicDependentCombo(period, comboValue, 'batchId', 'applicationId',applicationId);
					   }
				   },
				 'documentandnotesformwindow[itemId=documentAndNotesFormWindow] button#academicTopicDocument': {
					 click : function() {
						 var grid = this.getDocumentandnotesdocumentgrid();
						 grid.down('#btnEdit').setDisabled(true);	
						 var recordCount = grid.getStore().getCount();
						 if(recordCount == 5){
							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_UPLOAD_LIMIT_EXIT'));

						 }else{
							 this.getAdmApplicantProfileDocumentController().showDocumentFormWindow('documentAndNotesFormHiddenId','DOCUMENT');
							 }
						 
					 }
				 },
				'documentformwindow[itemId=documentAndNotesFormHiddenId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
					 click : function() {
						 var $this = this;
						 var isTransient = true;
						 var module = 'applicant';
						 var entityId;
						 var entityType = 'documentAndNotes';

						 $this.getAdmApplicantProfileDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
								 function(success,response,isCallBackTransient) {
							 var documentModel = new Academia.model.course.QuestionPaperDocument();
							 documentModel.set("documentName",response.name);
							 documentModel.set("path",response.path);
							 documentModel.set("type",response.type);
							 documentModel.set("documentName",response.name);
							 documentModel.set("isNewRecord",true);
							 documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
							 var window = $this.getDocumentAndNotesFormWindow();
							 var documentGrid = window.down('documentandnotesdocumentgrid');
							 var store = documentGrid.getStore();
							 store.add(documentModel);

							 $this.getAdmApplicantProfileDocumentController().closeDocumentFormWindow();
							 if (documentGrid.isHidden() && store.data.items.length > 0) {
								 documentGrid.setVisible(true);
								 documentGrid.down('#btnEdit').setVisible(false);
		 						}
							 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));
						 }, isTransient);
					 }
				 },
				 'documentformwindow[itemId=documentAndNotesFormHiddenId] simpledocumentform[itemId=simpleDocumentForm] filefield#uploadFileField' : {
					 change : function(fileField, value, eOpts) {
						 var this$ = this;
						 var fileUploadPath=value;
						 fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
						 fileField.setRawValue(fileUploadPath);
						 var file = fileField.fileInputEl.dom.files[0];
						 fileField.setRawValue(fileUploadPath);
						 var fileSizeLimit = '25';
						 if((file.size / 1048576) <=  fileSizeLimit ){
							 if(!isNullOrEmpty(fileUploadPath)){
								 var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
								 if (extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
									 || extension == "doc" || extension == "docx" || extension == "xls"  || extension == "xlsx") {
								 }else{
									 fileField.reset();
									 showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
									 return false;
								 }
							 }
						 }else{
							 fileField.reset();
							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_SIZE_CAN_NOT_MORETHAN_25'));
							 return false;
						 }
							
						
					 }
				 },
				 'documentandnotesdocumentgrid button#btnEdit' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getDocumentandnotesdocumentgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 var gridData = grid.getSelectionModel().getSelection();
							 var docId = gridData[0].data.offlinePaymentDocumentId;
							 var documentName = gridData[0].data.name;
							 var pathValue = gridData[0].data.path;
							 $this.getDocumentController().showDocumentFormWindow('applicant_Document_positive_hidden_field','EDIT_DOCUMENT');
							 var docWindow = $this.getDocumentformwindow();
							 var form =	docWindow.down('form');
							 form.down('#document_hidden_field').setValue(docId);
							 form.down('#documentNameField').setValue(documentName);
							 form.down('#uploaded_document_file_hidden_field').setValue(pathValue);
						 }else {
							 showWarningMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
						 }
					 }
				 },
				 
				 'documentformwindow[itemId=applicant_Document_positive_hidden_field] documenteditwithfileform[itemId=documenteditwithfileform] button#documentFormSubmitButtonId' : {
					 click : function() {
						 
						 var $this = this;
						 var isTransient = true;
						 var module = 'applicant';
						 var entityId;
						 var entityType = 'documentAndNotes';
                          var getWindow = $this.getDocumenteditwithfileform();
						 var documentID = getWindow.down('#document_hidden_field').getValue();
						 var uploadedDoc ='';
						 var uploadedDocRepeat ='';
						 uploadedDocRepeat = getWindow.down('#uploadFileField').getValue();
						 uploadedDoc = getWindow.down('#uploaded_document_file_hidden_field').getValue();
						 
						 if(uploadedDocRepeat==''){
							var docGrid = $this.getDocumentandnotesdocumentgrid();
							var gridDataRecord = docGrid.getSelectionModel().getSelection()[0];
							 var documentName = getWindow.down('#documentNameField').getValue();
							gridDataRecord.set("documentName", documentName);
							gridDataRecord.set("isEdit",true);
							  $this.getDocumentController().closeDocumentFormWindow();
								 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));

						 }else{
							 getWindow.down('#document_hidden_field').setValue(null);
									 $this.getDocumentController().saveDocumentForm(entityId,module,entityType, 'EDIT_DOCUMENT', function(success,response,isCallBackTransient) {
										 var docGrid = $this.getDocumentandnotesdocumentgrid();
											var gridDataRecord = docGrid.getSelectionModel().getSelection()[0];
											gridDataRecord.set("documentName", response.name);
										gridDataRecord.set("isEdit",true);
										gridDataRecord.set("id", documentID);
										gridDataRecord.set("path", response.path);
										gridDataRecord.set("type", response.type);
										gridDataRecord.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
										 $this.getDocumentController().closeDocumentFormWindow();
										 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));

											 }, isTransient); 
						 }
					 }
	},

	getDocumentController : function() {
		var this$ = this;
		return this$
		.getController('Academia.controller.document.DocumentController');
	},
	getIdValueJson : function(id, value) {
		if (id)
			return {
			id : id,
			value : value
		};
	},
	getIdNameJson : function(id, name) {
		if (id)
			return {
			id : id,
			nameToBePrinted : name
		};
	},

	'documentandnotesurlgrid button#btnEdit' : {
        click : function() {
            var $this = this;
            var grid = $this.getDocumentandnotesurlgrid(); 
            if (grid.getSelectionModel().getCount() > 0) {
                var records = grid.getSelectionModel().getSelection();
                this.getAdmApplicantProfileDocumentController().showDocumentFormWindow('documentAndNotesFormHiddenId','DOCUMENT_URL');
				 var formWindow = this.getDocumentformwindow();
				 if (!formWindow) {
					 Ext.widget('documentformwindow');
					 formWindow = this.getDocumentformwindow();
				 }
				 formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
				 this.setAllowBlank(formWindow.down('#documentNameField'),false);
			
			 }              
                
                var documentNameFields = formWindow.down('#documentNameField');
                documentNameFields.setValue(records[0].data.name);
                var documentUrlFields = formWindow.down('#documentUrlField');
                documentUrlFields.setValue(records[0].data.path);
                
                formWindow.add({
                    xtype: 'hiddenfield',
                    name: 'documentId',
                    value: records[0].data.id
                });
            } 
            },

				 'documentandnotesdocumentgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getDocumentandnotesdocumentgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 showConfirmMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn,	text) {
								 if (btn == 'yes') {
									 var records = grid.getSelectionModel().getSelection();
									 var id = records[0].get("id");
									 if(!isNullOrEmpty(id)){
												 grid.getStore().remove(records[0]);
												 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_DOCUMENT_SUCCESS_DELETE_MSG'));
												 if(grid.getStore().getCount() == 0) {
													 grid.hide();
												 }
									 }else{
										 grid.getStore().remove(records[0]);
										 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_DOCUMENT_SUCCESS_DELETE_MSG'));
										 if(grid.getStore().getCount() == 0) {
											 grid.hide();
										 }
									 }
									grid.down('#btnEdit').setDisabled(true);
								 }
							 });
						 } else {
							 showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
					 }
				 },
				 'documentandnotesformwindow[itemId=documentAndNotesFormWindow] button#academicTopicDocumentUrl': {
					 click : function() {
						 var grid = this.getDocumentandnotesurlgrid();
						 grid.down('#btnEdit').setDisabled(true);	
						
						 this.getAdmApplicantProfileDocumentController().showDocumentFormWindow('documentAndNotesFormHiddenId','DOCUMENT_URL');
						 var formWindow = this.getDocumentformwindow();
						 if (!formWindow) {
							 Ext.widget('documentformwindow');
							 formWindow = this.getDocumentformwindow();
						 }
						 formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
						 this.setAllowBlank(formWindow.down('#documentNameField'),false);
					 }
				 },
				 'documentformwindow[itemId=documentAndNotesFormHiddenId] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
			 	    	click: this.saveDocumentUrl
			 	},
			 	'documentandnotesurlgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getDocumentandnotesurlgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 showConfirmMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn,	text) {
								 if (btn == 'yes') {
									 var records = grid.getSelectionModel().getSelection();
									 var id = records[0].get("id");
									 if(!isNullOrEmpty(id)){
												 grid.getStore().remove(records[0]);
												 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_URL_SUCCESS_DELETE_MSG'));
												 if(grid.getStore().getCount() == 0) {
													 grid.hide();
												 }
									 }else{
										 grid.getStore().remove(records[0]);
										 showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_URL_SUCCESS_DELETE_MSG'));
										 if(grid.getStore().getCount() == 0) {
											 grid.hide();
										 }
									 }
									
								 }
									grid.down('#btnEdit').setDisabled(true);
							 });
						 } else {
							 showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
					 }
				 },
				 'documentandnotesdocumentgrid' : {
						 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							 var $this = this;
							 var documentGrid = $this.getDocumentandnotesdocumentgrid();
							 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
							 if (columnName == "documentName") {
								 if (e.target.tagName == 'A') {
									 var documentId = record
									 .get("encryptedDocId");
									 if (!isNullOrEmpty(documentId)) {
										 $this.getDocumentController().downloadDocumentFile(documentId);
									 }
								 }

							 }
						 },
						 select : function (grid) {
							 var $this = this;
							 var documentGrid = $this.getDocumentandnotesdocumentgrid();
				                var selectedItems = grid.getSelection();
				                if(selectedItems.length==0){
				                	documentGrid.down('#btnEdit').setDisabled(true);	
				                }else{
				                	documentGrid.down('#btnEdit').setDisabled(false);	
				                }
						 }
				 },
				 
				 'documentandnotesurlgrid' : {
					 select:function(grid){
						 var $this = this;
						 var urlGrid = $this.getDocumentandnotesurlgrid();
			                var selectedItems = grid.getSelection();
			                if(selectedItems.length==0){
			                	urlGrid.down('#btnEdit').setDisabled(true);	
			                }else{
			                	urlGrid.down('#btnEdit').setDisabled(false);	
			                }
					 }
				 },
				'applicationdetailschecklistgrid button[itemId=saveRemark]':{
                   click: function(grid) {
                  var me = this; 
                  var checkListGr =me.getApplicationdetailschecklistgrid();
              	  var checkListStore = checkListGr.getStore();
                  var checkListRecordDetails = [];
                  var checkedItems = [];
                var selectedItems = checkListGr.getSelectionModel().getSelection();
                for (var count = 0; count < selectedItems.length; count++) {
                    var record = selectedItems[count];
                    var checklistItemIds = record.get('id');
                    if (!isEmpty(record) && !isNullOrEmpty(checklistItemIds)) {
                    	checkedItems.push(checklistItemIds);
                    }
                }
                   
					if(checkListStore.getCount()>0){
			    		checkListStore.data.items.every(function(obj){
			    		if(Ext.Array.contains(checkedItems,obj.data.id)){
			    			var jsonObj = {
		        					"id":obj.data.id,
		        					"status":true,
		        					"remark":obj.data.remark
		        			}
			    		}
			    		else{
			    			var jsonObj = {
		        					"id":obj.data.id,
		        					"status":false,
		        					"remark":obj.data.remark
		        			}
			    		}
			    		
							checkListRecordDetails.push(jsonObj);
							return true;
			    		});
					}
				   	
					if(!isNullOrEmpty(checkListRecordDetails) && checkListRecordDetails.length>0){
						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
						Ext.Ajax.request({
							method: "POST",
							type: 'rest',
							url: SERVERURL.PATH_SAVE_STATUS_REMARK_CHECKLIST,
							jsonData: checkListRecordDetails,
							success: function(response, action) {
								Ext.getBody().unmask();
								showSuccessMessage(getCommonTranslation('APPLICATION_CHECKLIST_DETAIL'), getCommonTranslation('APPLICATION_CHECKLIST_DETAIL_SAVED_MSG'));
							}
						});
					}
                }
            },
			 'documentsandnotesdocumentsgrid':{
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
     				var $this = this;
     				var documentGrid = $this.getDocumentsandnotesdocumentsgrid();
     				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
     				if (columnName == "name") {
     					if (e.target.tagName == 'A') {
     						var documentId = record.get("encryptedDocId");
     						if (!isNullOrEmpty(documentId)) {
     							$this.getDocumentController().downloadDocumentFile(documentId);
     						}
     					}
     				}
     			} 
			 },
			 'documentsandnotesdocumentsgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getDocumentsandnotesdocumentspopup();  
	 					var contentPanelTab = $this.getContentPanelActiveTab();
	 					var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	 					var appDocumentGrid  = personInfoPanel.down('#applicationdocumentsandnotesgrid');
	 					var detaillistgrid=form.down('#documentsandnotesdocumentsgridItemId');
	 					if (detaillistgrid.getSelectionModel().getCount() > 0) {
	 						var records = detaillistgrid.getSelectionModel().getSelection();
	 							var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.offlinePaymentDocumentId);
	 						});
	 							showConfirmMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_APPLICANT_ACADEMIC_DOCUMENT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {
	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										detaillistgrid.store.reload();
	 										appDocumentGrid.getStore().reload();
	 										detaillistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	       	 'documentandnotesurlpopupgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getDocumentsandnotesurlpopup();  
	 					var contentPanelTab = $this.getContentPanelActiveTab();
	 					var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	 					var appDocumentGrid  = personInfoPanel.down('applicationdocumentsandnotesgrid');
						var urlGrid = Ext.ComponentQuery.query('#documentandnotesurlpopupgridItemId')[0];
	 					if (urlGrid.getSelectionModel().getCount() > 0) {
	 						var records = urlGrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_APPLICANT_ACADEMIC_DOCUMENT_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_URL_SUCCESS_DELETE_MSG'));	 
	 										urlGrid.store.reload();
	 										appDocumentGrid.getStore().reload()
	 										urlGrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	       	 'documentsandnotesdocumentsgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
						var form = $this.getDocumentsandnotesdocumentspopup();
						var documentsandnotesdocumentsgrid=form.down('#documentsandnotesdocumentsgridItemId');
						if (documentsandnotesdocumentsgrid.getSelectionModel().getCount() > 0) {
							var records = documentsandnotesdocumentsgrid.getSelectionModel().getSelection();
							var dispatchZipName = "Documents And Notes";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),
										getCommonTranslation('DOCUMENT_AND_NOTES_DOWNLOAD_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										showSuccessMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'),getCommonTranslation('DOCUMENT_AND_NOTES_DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
									}
									
								});

								
							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
	      	 },
	      	'applicantprofile' : {
	      		afterrender: function(){
	      			var portalId = this.getCurrentLoggedPortalId();
	      			if(portalId==1){
                    var associatedAcadLocationIds = new Array();
                    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICATION_PERMISSION());
                    var form = this.getContentPanelActiveTab();
                    var applicantProfileImageIcon = form.down('#profile_image_icon_id');
                    applicantProfileImageIcon.setVisible(false)
                    permissionList.forEach(function(btnName){
                        if(btnName == 'APPLICANT_PROFILE_IMAGE_ICON'){
                        	applicantProfileImageIcon.setVisible(true);
                        }
                    });
                }
	      	}
	      	},
	      	  'applicantprofile container[itemId=profile_image_icon_id]': {
 				  afterrender: function(container) {
 				        container.getEl().on('click', this.openPhotoUploadPopup, this);
 				    }
 			 },
 			'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[name=btnEdit]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
//				        var btnSave = window.down('button[name=btnSave]');
				        
				        // Hide Edit and Remove buttons
				        btnEdit.setVisible(false);
				        btnRemove.setVisible(false);
				        btnCancel.setVisible(false);
//				        btnSave.setVisible(false);
				        
				        // Show Upload Photo and Take a Photo buttons
				        btnUploadPhoto.setVisible(true);
				        btnTakePhoto.setVisible(true);
				        btnBack.setVisible(true);
				   }
			   },
			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[name=btnBack]': {
				   click: function(button) {
				        var window = this.getStudentuploadphotowindow();
				        window.down('#profile_image_containerBox').removeAll(true);
				        window.down('#profile_image_containerBox').destroy();
					   	window.down('#profileRoatateImageIconId').hide();
					   	window.down('#profileImageFormItemId').insert(0,{
					   		// Profile Image Container
					   		xtype: 'container',
					   		width: 320,
					   		height: 280,
					   		layout: {
					   			type: 'vbox',
					   			align: 'center',
					   			style: {
					   				position: 'relative',
					   			}
					   		},
					   		itemId: 'profile_image_containerBox',
					   		items: [{
					   			xtype: 'image',
					   			itemId: 'profile_image',
					   			border: 1,
					   			style: {
					   				borderColor: '#e0e0e0',
					   				borderStyle: 'solid',
					   				borderRadius: '50%',
					   				marginTop:'67px !important'
					   			},
					   			width: 210,
					   			height: 210,
					   			src: 'resources/images/default-profile.png',
//					   			margin: '0 0 3 0', // Adds spacing around the image
					   		},{
					   			xtype: 'hidden',
					   			name: 'isImageRemoved',
					   			itemId: 'isImageRemovedItemId'
					   		}]
					   	},
					   	{
					   		id:'capture_panel',
					   		itemId:'capturePanelId',
					   		hidden:true,
					   		listeners:{
					   			show:function(obj){
					   				Webcam.set({
					   					width: 320,
					   					height: 240,
					   					crop_width: 320,
					   					crop_height: 240,
					   					flip_horiz: true,
					   					image_format: 'jpeg', // image format (may be jpeg or png)
					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					   				});
					   				Webcam.attach('#capture_panel-innerCt');
					   			},
					   			hide: function () {
					   				Webcam.reset();
					   			}
					   		}
					   	},{
					   		xtype:'panel',
					   		itemId:'previewPanelId',
					   		hidden:true
					   	},{
					   		xtype:'panel',
					   		hidden:true,
					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
					   	},
					   	// Button Container for Profile Actions
					   	{
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			align: 'middle',
					   			//pack: 'center',
					   		},
					   		margin: '20 0 0 0', // Adds spacing above the buttons
					   		/*defaults: {
					labelAlign: 'top',
					margin: '0 5', // Adds spacing between buttons
				},*/
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('EDIT'),
					   			name: 'btnEdit',
					   			itemId: 'btnEditItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('REMOVE'),
					   			name: 'btnRemove',
					   			itemId: 'btnRemoveItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		},{
					   			xtype: 'filefield',
					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
					   			name: 'file',
					   			itemId: 'btnUploadPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			buttonOnly: true
					   		}, {
					   			xtype: 'hidden',
					   			name: 'name',
					   			itemId: 'fileName'
					   		}, {
					   			xtype: 'hidden',
					   			name: 'personId',
					   			itemId: 'personId'
					   		}, {
					   			xtype: 'button',
					   			text: getCommonTranslation('TAKE_A_PHOTO'),
					   			name: 'btnTakePhoto',
					   			itemId: 'btnTakePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('CAPTURE'),
					   			name: 'capturePhoto',
					   			itemId: 'capturePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('RESET'),
					   			name: 'resetPhoto',
					   			itemId: 'resetPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		}]
					   	},
					   	{
					   		xtype: 'button',
					   		cls: 'profileRoatateImageIcon',	
					   		itemId: 'profileRoatateImageIconId',
					   		hidden: true,
					   		rotate: 0.1
					   	},{
					   		// Footer Button Container
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			pack: 'space-between',
					   			//align: 'middle'
					   		},
					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
					   		width: '100%',
					   		defaults: {
					   			//flex: 1,
					   			//margin: '0 100',
					   		},
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('CANCEL'),
					   			name: 'btnCancel',
					   			itemId: 'btnCancelItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,	
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('BACK'),
					   			name: 'btnBack',
					   			itemId: 'btnBackItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   		},{
					   			xtype: 'component', 
					   			flex: 2
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('SAVE'),
					   			name: 'btnSave',
					   			itemId: 'btnSaveItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		}]
					   	});
				        var personProfile = this.getContentPanelActiveTab();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
				        var capturePhoto = window.down('#capturePhotoItemId');
				        var resetPhoto = window.down('#resetPhotoItemId');
				        var profileImage = window.down('#profile_image');
				        var capturePanel = window.down('#capturePanelId');
				        var previewPanelId = window.down('#previewPanelId');
				        var btnSave = window.down('button[name=btnSave]');

				        if (window.lastSavedImageUrl) {
                            profileImage.setSrc(window.lastSavedImageUrl);
                        } else {
                        	var fallbackImg = generateInitialsImage(
                    				personProfile.getPersonInfo().firstName,
                    				personProfile.getPersonInfo().middleName,
                    				personProfile.getPersonInfo().lastName
							 );
                            profileImage.setSrc(fallbackImg);
                        }
				        
				        // Restore the previous image if available
				        if (window.previousProfileImage) {
				            profileImage.setSrc(window.previousProfileImage);
				            profileImage.setVisible(true);
				        }
				        
				        // Reset the file field so it detects the same image when uploaded again
	                       btnUploadPhoto.reset();

				        btnEdit.setVisible(true);
				        btnRemove.setVisible(true);
				        btnCancel.setVisible(true);

				        btnUploadPhoto.setVisible(false);
				        btnTakePhoto.setVisible(false);
				        btnBack.setVisible(false);
				        capturePhoto.setVisible(false);
				        resetPhoto.setVisible(false);
				        capturePanel.setVisible(false);
				        previewPanelId.setVisible(false);
				        btnSave.setDisabled(true);
				        
				     // Re-enable capture/reset buttons for future actions
				        capturePhoto.setDisabled(false);
				        resetPhoto.setDisabled(true);
				        window.down('#btnUploadPhotoItemId').reset();
				        var imageDiv = document.getElementById('testing');
				        if(imageDiv){
				        	imageDiv.remove();
				        }
				   }
				},
			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[name=btnCancel]': {
				   click: function(button) {
					   var window = this.getStudentuploadphotowindow();
					   window.close();
				   }
			   },
			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=btnTakePhotoItemId]': {
				   click: function(button) {
					   this.openApplicantCapturePhoto();
				   }
			   },
			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId][itemId=studentuploadphotowindowItemId]' : {
					close : function(obj){
						Webcam.userMedia=true;
						Webcam.reset();
					}
				},
				'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=capturePhotoItemId]': {
 				   click: function(button) {
 					   this.captureApplicantUserPhoto(button);
 				   }
 			   },
 			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=resetPhotoItemId]': {
                    click: function(button) {
                        var window = this.getStudentuploadphotowindow();
                        window.down('#capturePanelId').setVisible(true);
                        window.down('#previewPanelId').setVisible(false);
                        window.down('#previewPanelId').update('');
                        window.down('#capturePhotoItemId').setDisabled(false);
                        window.down('#resetPhotoItemId').setDisabled(true);
                        window.down('#btnSaveItemId').setDisabled(true);
                        window.cropData = null;
                        window.component = null;
                    }
                },
 			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] filefield[itemId=btnUploadPhotoItemId]': {
 				   change: this.uploadApplicantProfilePhoto
 			   },
 			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=btnSaveItemId]': {
 				   click: this.uploadApplicantCapturedImage
 			   },
 			   'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=btnRemoveItemId]': {
 				   click:function(){
 					   this.removeUploadApplicantCapturedImage();
 				   }
 			   },
               'studentuploadphotowindow[itemId=studentuploadphotowindowItemId] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
					   button.rotate = parseFloat(button.rotate) + .50;
				   }
			   }
        });
    },
    removeUploadApplicantCapturedImage: function(){
    	 var win = this.getStudentuploadphotowindow();
    	 var personProfile = this.getContentPanelActiveTab();
         var saveBtn = win.down('#btnSaveItemId');
         var removeBtn = win.down('#btnRemoveItemId');
         var profileImage = win.down('#profile_image');
         var isImageRemoved = win.down('#isImageRemovedItemId');
         var fallbackImg = generateInitialsImage(
 				personProfile.getPersonInfo().firstName,
 				personProfile.getPersonInfo().middleName,
 				personProfile.getPersonInfo().lastName
			 );
         profileImage.setSrc(fallbackImg);
         isImageRemoved.setValue(true);
         saveBtn.setDisabled(false);
         removeBtn.setDisabled(true);
   },
    
    getUploadCaptureToApplicantProfile : function(){
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var personId = personProfile.getPersonId();
        if(!isNullOrEmpty(personId)){
            Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: SERVERURL.APPLICANT_IMAGE_DOWNLOAD+'?personId='+personId,
                method: 'GET',
                success : function(response){
                    if(response.responseBytes.length>0){
                        var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                        var url = window.URL.createObjectURL(blob);
                        var a=personProfile.down("#profile_image");
                        a.getEl().dom.src=url;
                        a.setVisible(true);
                    }
                }
            });
        }
    },
    openPhotoUploadPopup: function() {
    	var profileUploadWindow = this.getStudentuploadphotowindow();
    	
        if (!profileUploadWindow) {
        	profileUploadWindow =  Ext.widget('studentuploadphotowindow',{
   			 itemId : 'studentuploadphotowindowItemId'
   		 }); 
        }
        if (!profileUploadWindow.hasAfterRenderHandler) {
        	profileUploadWindow.on('afterrender', function () {
                var personProfile = this.getContentPanelActiveTab();
                var personId = personProfile.getPersonId();
                if (!isNullOrEmpty(personId)) {
                    Ext.Ajax.request({
                        url: SERVERURL.APPLICANT_IMAGE_DOWNLOAD + '?personId=' + personId+'&isDefaultImageRequired=false',
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                var profileImage = profileUploadWindow.down("#profile_image");

                                profileImage.setVisible(true);
                                 if(personProfile.getPersonInfo().photoUrl){
                                	 profileImage.getEl().dom.src = url;
                                	// **Store the last saved image URL**
                                	 profileUploadWindow.lastSavedImageUrl = url;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
                                }else{
                                	profileImage.getEl().dom.src = '';
                                	var fallbackImg = generateInitialsImage(
                            				personProfile.getPersonInfo().firstName,
                            				personProfile.getPersonInfo().middleName,
                            				personProfile.getPersonInfo().lastName
    								 );
                                	// **Store the last saved image URL**
                                	profileUploadWindow.lastSavedImageUrl = fallbackImg;
                            		profileImage.getEl().dom.src = fallbackImg;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
                                }
                            }
                        },
                    });
                }
            }, this);
            
            // Mark handler as attached to avoid duplicate bindings
        	profileUploadWindow.hasAfterRenderHandler = true;
        }
        
        profileUploadWindow.show();
     },
     openApplicantCapturePhoto:function(){
    	    var window = this.getStudentuploadphotowindow(),
    	        profileImage = window.down('#profile_image'),
    	        capturePanelId = window.down('#capturePanelId'),
    	        btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
    	        btnTakePhoto = window.down('#btnTakePhotoItemId'),
    	        capturePhoto = window.down('#capturePhotoItemId'),
    	        resetPhoto = window.down('#resetPhotoItemId'),
    	        btnBack = window.down('#btnBackItemId'),
    	        btnSave = window.down('#btnSaveItemId');
    	    window.down('#profile_image_containerBox').hide();
       		window.down('#profileRoatateImageIconId').hide();

    	    // **Store the current profile image before hiding it**
    	    window.previousProfileImage = profileImage.el.dom.src;

    	    btnUploadPhoto.reset();
    	    btnUploadPhoto.setVisible(false);
    	    btnTakePhoto.setVisible(false);
    	    profileImage.setSrc('');
    	    profileImage.setVisible(false);
    	    capturePanelId.setVisible(true);
    	    capturePhoto.setVisible(true);
    	    resetPhoto.setVisible(true);
    	    resetPhoto.setDisabled(true);
    	    btnBack.setVisible(true);
    	    btnSave.setVisible(true);
    	},

     captureApplicantUserPhoto: function(btn){
		var $this = btn.up('window');
		var form = btn.up('window').down('form');
		var imageUrl;
		Webcam.snap( function(data_uri) {
			imageUrl = data_uri;
		});
        Ext.defer(function() {
        	var imgLoad = new Image();
    		imgLoad.onload = (function(){
    			var crop = new Academia.utilities.ImageCrop({
    				id:'testing',
    				width: 310,
    				height: 272,
    				src:imageUrl
    			});
    			crop.on('changeCrop', function(component,region) {
    				$this.cropData = region;
    				$this.component = component;
    			});
    			var PREVIEW_TEST = form.down('#previewPanelId');
    			PREVIEW_TEST.add(crop);
    			$this.down('#capturePanelId').setVisible(false);
    			$this.down('#previewPanelId').setVisible(true);
    			btn.setDisabled(true);
    			$this.down('#resetPhotoItemId').setDisabled(false);
    			$this.down('#btnSaveItemId').setDisabled(false);
    			
    			var canvas = document.getElementById('canvas');
				var ctx = canvas.getContext("2d");
				var region = $this.cropData; 
				var component = $this.component;
				var sw = region.width - region.x;
				var sh = region.height - region.y;

				var imgWidth = component.width;
				var imgHeight = component.height;

				var img = new Image();
				img.src = component.src;

				ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
    			$this.captureImageaUrl = canvas.toDataURL("image/png");
    		}).bind($this);
    		imgLoad.src = imageUrl;
    		$this.imagesUrl = imageUrl;
  	  }, 500, $this);
   	},
    uploadApplicantCapturedImage: function() {
    	var me = this;
    	var personProfile = me.getContentPanelActiveTab();
    	var personId = Number(personProfile.getPersonId());
        var formPanel = me.getStudentuploadphotowindow();
        var form = formPanel.down('form');
        if(form.down('#profile_image_containerBox').isVisible()) {
       	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
       	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
       	 var finalImageBase64;
       	 var imageBlob;
       	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
       		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
       		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
       	 }
        }
//        var formValues = formPanel.getValues();
        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
        var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];     
        var formValues = form.getValues();
        
        // Check if there's an image to upload
        var imageField = formPanel.down('#profileImageFormItemId');
        var imageVal = formPanel.down('#btnUploadPhotoItemId');
        var profile_image = formPanel.down('#profile_image');
        var isImageRemoved = formPanel.down('#isImageRemovedItemId');

        if(isImageRemoved.value == 'true'){
        	me.saveuploadApplicantCapturedImage('');
        	return;
        }
        me.applyWindowMask();
        if (profile_image.isVisible()) {
            // If there's an image, upload it first
        	 var formData = new FormData();
        	 for (var key in formValues) {
        	     if (formValues.hasOwnProperty(key)) {
        	         formData.append(key, formValues[key]);
        	     }
        	 }
        	 formData.append('file', imageBlob, 'profile.png');
        	 
        	 var userInfo = Academia.model.authentication.UserInfoModel;
        	 var access_token = userInfo.get("accessToken");
        	 
        	 var url = SERVERURL.PERSON_IMAGE_UPLOAD+'?access_token='+access_token;        	
        	 
        	 var xhr = new XMLHttpRequest();
        	 xhr.open('POST', url);
        	 xhr.onload = function () {
        	     if (xhr.status >= 200 && xhr.status < 300) {
        	         var response = JSON.parse(xhr.responseText);
        	         var path = response.path;
        	         var updatedPath = path.replace(/^\/+/, "");
        	         me.saveuploadApplicantCapturedImage(path);
        	     }
        	 };
        	 xhr.send(formData);
        }else{
        	var userInfo = Academia.model.authentication.UserInfoModel;
			var access_token = userInfo.get("accessToken");
        	var canvas = document.getElementById('canvas');
			var ctx = canvas.getContext("2d");
			var region = formPanel.cropData; 
			var component = formPanel.component;
			var sw = region.width - region.x;
			var sh = region.height - region.y;
			var imgWidth = component.width;
			var imgHeight = component.height;
			var img = new Image();
			img.src = component.src;
			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
			var dataUrl = canvas.toDataURL("image/png");
			
			var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', '1.png');
			form.append('personId', personId);
			form.append('isApplicant', true);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);

			xhr.onreadystatechange = function () {
				if(personProfile.xtype=='applicantprofile'){
				if (xhr.readyState == 4 && xhr.status == 200) {
					if (xhr.responseText != "") {
						var data = Ext.decode(xhr.responseText);
						var personinfo = personProfile.getPersonInfo();
						personinfo.photoUrl = data.path;
						var updatedPath = data.path.replace(/^\/+/, "");
						//me.saveuploadApplicantCapturedImage(updatedPath);
						showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
						me.getUploadCaptureToApplicantProfile();
					}
				}
			}
				formPanel.close();	
				//me.hideWindowMask();
			};
			xhr.send(form);
        } 
    },
    saveuploadApplicantCapturedImage: function(imageUrl){
    	var me = this;
    	var win = me.getStudentuploadphotowindow();
    	var form = this.getApplicantprofile();
    	var personProfile = me.getContentPanelActiveTab();
    	var personId = Number(personProfile.getPersonId());
    	personProfile.getPersonInfo().photoUrl=imageUrl;
    	var payload = {
    			personId: personId,
    			path: imageUrl
    	};
    	
    	var firstName = personProfile.personInfo.firstName;
		var middleName = personProfile.personInfo.middleName; 
		var lastName = personProfile.personInfo.lastName;
    	
    	var submitUrl = SERVERURL.PATH_UPLOAD_APPLICANT_PROFILE_PHOTOS;
    	
    	var data = Ext.encode(payload);
    	
    	Ext.Ajax.request({
    		url: submitUrl,
    		method: 'POST',
    		jsonData:data,
            success: function(response){
            	var responseData = response.responseText;
            	if (responseData=='fail') {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
            	}else{
            		if(imageUrl==''){
            			 var profileImage = personProfile.down('#profile_image');
   	   					 var newImgUrl = generateInitialsImage(firstName, middleName, lastName);
   	   					 profileImage.setVisible(true);
   	   					 profileImage.setSrc(newImgUrl);
              			 showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
            		}
            		else{
            			me.getUploadCaptureToApplicantProfile();
            			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
            		}
            	}
            	win.close();
            	me.hideWindowMask();
            },
            failure: function(response){
            	me.hideWindowMask();
            }
    	})
    },
    
    uploadApplicantProfilePhoto: function(cmp, value) {
    	var window = this.getStudentuploadphotowindow();
        var form = window.down('form');
        var image = form.down('#profile_image');
        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        var btnSave = window.down('button[name=btnSave]');
        var file = cmp.el.down('input[type=file]').dom.files[0];
        var isImageRemoved = window.down('#isImageRemovedItemId');

        // File extension validation
        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
        if (!isNullOrEmpty(value)) {
            if (extension === "png" || extension === "jpeg" || extension === "jpg") {
            	if(file){
              		 if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
              			 cmp.reset();
                           showWarningMessage(
                               getPersonModuleTranslation('PHOTO_UPLOAD'),
                               getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
                           );
                           return;
                       }else {
                           isImageRemoved.setValue(false);
                       }
               	}
            } else {
                cmp.reset();
                showWarningMessage(
                    getPersonModuleTranslation('PHOTO_UPLOAD'),
                    getPersonModuleTranslation('UPLOAD_VALID_FILE')
                );
                return;
            }
        } else {
            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
            return;
        }

        // Process the valid file
        if (file) {
            form.down('#fileName').setValue(file.name);
            var personProfile = this.getContentPanelActiveTab();
            var personId = Number(personProfile.getPersonId());
            form.down('#personId').setValue(personId);

            var reader = new FileReader();
            reader.onload = function(e) {
            	var crop;
	        	var imageSrc;
	        	var canvasDiv ;
                image.setSrc(e.target.result);
                Ext.defer(function(){
	            	imageSrc = imageInnerContainerBox.children[0].src;
			        image.setVisible(false);    	
			        window.down('#profileRoatateImageIconId').show();
	            	 crop = cropper(imageInnerContainerBox, {
    				    area: [ 210, 210 ],
    				    crop: [ 115, 115 ],
    				    value: imageSrc,
    				    allowResize: true,
    		            allowZoom: true,
    		            allowRotation: true,         		            
    				})
    				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
	            	 if (jcropArea) {
	            		    var innerJcropDiv1 = document.createElement('div');
	            		    innerJcropDiv1.className = 'border-left';

	            		    var innerJcropDiv2 = document.createElement('div');
	            		    innerJcropDiv2.className = 'border-right';

	            		    jcropArea.appendChild(innerJcropDiv1);
	            		    jcropArea.appendChild(innerJcropDiv2);
	            		}
    				canvasDiv = jcropArea.nextSibling;
    				if(!isNullOrEmpty(canvasDiv)){
    					var mouseEventOccurred = false;
    				if (canvasDiv) {
    				    // Listen for mouse events and set the flag to true when one occurs
    					canvasDiv.addEventListener('mousemove', function () {
    						mouseEventOccurred = true;
				            if (mouseEventOccurred) {    				                
				                var croppedImage = crop.getCroppedImage().src;
    				            image.setSrc(croppedImage);
    				            image.setVisible(true);
				            }    				            
				        })
				        if(mouseEventOccurred == false) {
    				    image.setSrc(imageSrc);
    				    image.setVisible(true);
    				}
    				} 
    			} 
				else {
				    image.setSrc(imageSrc);
				    image.setVisible(true);
				}
	            },500)
                btnSave.setDisabled(false);
            };
            reader.readAsDataURL(file);
        }
    },

    applicantDocDocumentAndNotesContainerWindow: function(){
    	var applicantDocGrid = Ext.ComponentQuery.query('documentandnotesdocumentgrid');
        
        var $this = this;
        var store = applicantDocGrid[0].store;
         	
        var contentPanelTab = $this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicationdocumentsandnotesgrid');
		var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			   applicationAcademicTopicId: selectedRec.getSelection()[0].data.id

			};
        	var applicantDocDocumentAndNotesGrid = $this.getDocumentandnotesdocumentgrid();
			store.load({
				callback:function(){
					if(store.getCount()) {
						if (applicantDocDocumentAndNotesGrid.isHidden()) {
							applicantDocDocumentAndNotesGrid.setVisible(true);
						}	  					
						
					}
				}
			});
    },	
    applicantUrlDocumentAndNotesContainerWindow: function(){
    	var applicantUrlGrid = Ext.ComponentQuery.query('documentandnotesurlgrid');
        
        var $this = this;
        var store = applicantUrlGrid[0].store;
         	
        var contentPanelTab = $this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicationdocumentsandnotesgrid'); 	
        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
        		applicationAcademicTopicId: selectedRec.getSelection()[0].data.id
			};
        	var applicantUrlDocumentAndNotesGrid = $this.getDocumentandnotesurlgrid();
			store.load({
				callback:function(){
					if(store.getCount()) {
						if (applicantUrlDocumentAndNotesGrid.isHidden()) {
							applicantUrlDocumentAndNotesGrid.setVisible(true);
						}	  					
					}
				}
			});
    },
    
     onRenderEligibilityDetailsForm: function(geturl) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 try {
			 personProfile.getPersonId();
		 } catch(e){
			 personProfile = this$.getContentPanel().items.items[0];
		 }
		 var personId = personProfile.getPersonId();
		 if (!isNullOrEmpty(personId)) {
			 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			 var url = geturl + personId;
			 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
				 Ext.getBody().unmask();
				 if (success) {
					 if (!isNullOrEmpty(response.responseText)) {
						 var data = Ext.decode(response.responseText);
						 if (!isEmpty(data)) {
							 this$.setValueToEligibilityDetails(data);
						 }
					 }
				 }
			 });
		 }
	 },
 	setValueToEligibilityDetails: function(data) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 var eligibilitydetailsform = personProfile.down('eligibilitydetailsform');
		 if (eligibilitydetailsform) {
			 eligibilitydetailsform.getForm().setValues(data);
		 }
	
            var achievementTypeItemId = eligibilitydetailsform.down('#achievementTypeItemId');
            var achievementTypeOtherItemId = eligibilitydetailsform.down('#achievementTypeOtherItemId');
            var progEndorsedStatusItemId = eligibilitydetailsform.down('#progEndorsedStatusItemId');
            var heqsfLevelItemId = eligibilitydetailsform.down('#heqsfLevelItemId');
            var eligibilityStatusItemId = eligibilitydetailsform.down('#eligibilityStatusItemId');
            var additionalReqMetItemId = eligibilitydetailsform.down('#additionalReqMetItemId');
            var pgRequirementMetItemId = eligibilitydetailsform.down('#pgRequirementMetItemId');
            var pgMarksItemId = eligibilitydetailsform.down('#pgMarksItemId');
            var rplItemId = eligibilitydetailsform.down('#rplItemId');
            var achievedNSCItemId = eligibilitydetailsform.down('#achievedNSCItemId');
            var examinationMonthAndYearItemId = eligibilitydetailsform.down('#examinationMonthAndYearItemId');
	
			if (!isNullOrEmpty(data.achievementType)) {
                achievementTypeItemId.getStore().load({
                    callback: function(records, operation, success) {
                        achievementTypeItemId.setValue(data.achievementType.id);
						if (data.achievementType.code == 'Other') {
							achievementTypeOtherItemId.setVisible(true);
						}
                    }
                });
            }
			if (!isNullOrEmpty(data.progEndorsedStatus)) {
                progEndorsedStatusItemId.getStore().load({
                    callback: function(records, operation, success) {
                        progEndorsedStatusItemId.setValue(data.progEndorsedStatus.id);
                    }
                });
            }
			if (!isNullOrEmpty(data.heqsfLevel)) {
                heqsfLevelItemId.getStore().load({
                    callback: function(records, operation, success) {
                        heqsfLevelItemId.setValue(data.heqsfLevel.id);
                    }
                });
            }
			if (!isNullOrEmpty(data.eligibilityStatus)) {
                eligibilityStatusItemId.getStore().load({
                    callback: function(records, operation, success) {
                        eligibilityStatusItemId.setValue(data.eligibilityStatus.id);
                    }
                });
            }
			if (!isNullOrEmpty(data.additionalReqMet)) {
				additionalReqMetItemId.getStore().load({
                    callback: function(records, operation, success) {
                        if (data.additionalReqMet)
							additionalReqMetItemId.setValue('YES');
						else 
							additionalReqMetItemId.setValue('NO');
                    }
                });
			}
			if (!isNullOrEmpty(data.pgRequirementMet)) {
				pgRequirementMetItemId.getStore().load({
                    callback: function(records, operation, success) {
                        if (data.pgRequirementMet)
					pgRequirementMetItemId.setValue('YES');
				else 
					pgRequirementMetItemId.setValue('NO');
                    }
                });
				
			}
			if (!isNullOrEmpty(data.pgMarks)) {
				pgMarksItemId.getStore().load({
                    callback: function(records, operation, success) {
                       if (data.pgMarks)
					pgMarksItemId.setValue('YES');
				else 
					pgMarksItemId.setValue('NO');
                    }
                });
				
			}
			if (!isNullOrEmpty(data.rpl)) {
				rplItemId.getStore().load({
                    callback: function(records, operation, success) {
                       if (data.rpl)
					rplItemId.setValue('YES');
				else 
					rplItemId.setValue('NO');
                    }
                });
			}
			if (!isNullOrEmpty(data.achievedNSC)) {
				achievedNSCItemId.getStore().load({
                    callback: function(records, operation, success) {
                       if (data.achievedNSC)
							achievedNSCItemId.setValue('YES');
						else 
							achievedNSCItemId.setValue('NO');
                    }
                });
			}
			if (!isNullOrEmpty(data.examMonth) && !isNullOrEmpty(data.examYear)) {
				examinationMonthAndYearItemId.setValue(data.examMonth + '/'+ data.examYear);
			}
	 },
    saveEligibilityDetails: function(saveUrl, getUrl) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 var form = personProfile.down('eligibilitydetailsform');
	
		 var jsonFormatFormData = this$.getJsonEligibilityDetailsSubmitData(form);

		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 this$.sendSaveAjaxRequest(saveUrl, 'PUT', jsonFormatFormData, function(option, success, response) {
			 Ext.getBody().unmask();
			 if (success, form) {
				 this$.onRenderEligibilityDetailsForm(getUrl);
				 showSuccessMessage(getPersonModuleTranslation('ELIGIBILITY_DETAILS'), getPersonModuleTranslation('ED_ELIGIBILITY_DETAILS_ADD_SUCCESS'));
			 }
		 });
	 },

 	 getJsonEligibilityDetailsSubmitData: function(form) {
		 var this$ = this;
		 var jsonFormFieldData = new Object();
		 var formData = form.getValues();
		 if (!isEmpty(formData)) {
			 var personObj = this$.getPersonObj();
			 formData.person = personObj;
		 }
		 if (!isNullOrEmpty(formData.achievementTypeId)) {
			formData.achievementType = {
				id: formData.achievementTypeId
			};
		 }
		 if (!isNullOrEmpty(formData.progEndorsedStatusId)) {
			formData.progEndorsedStatus = {
				id: formData.progEndorsedStatusId
			};
		 }
		 if (!isNullOrEmpty(formData.heqsfLevelId)) {
			formData.heqsfLevel = {
				id: formData.heqsfLevelId
			};
		 }
		 if (!isNullOrEmpty(formData.eligibilityStatusId)) {
			formData.eligibilityStatus = {
				id: formData.eligibilityStatusId
			};
		 }
		if (!isNullOrEmpty(formData.additionalReqMet)) {
			if (formData.additionalReqMet == 'YES') {
				formData.additionalReqMet = true;
			} else {
				formData.additionalReqMet = false;
			}
		 }
		if (!isNullOrEmpty(formData.pgRequirementMet)) {
			if (formData.pgRequirementMet == 'YES') {
				formData.pgRequirementMet = true;
			} else {
				formData.pgRequirementMet = false;
			}
		 }
		if (!isNullOrEmpty(formData.pgMarks)) {
			if (formData.pgMarks == 'YES') {
				formData.pgMarks = true;
			} else {
				formData.pgMarks = false;
			}
		 }
		if (!isNullOrEmpty(formData.rpl)) {
			if (formData.rpl == 'YES') {
				formData.rpl = true;
			} else {
				formData.rpl = false;
			}
		 }
		if (!isNullOrEmpty(formData.achievedNSC)) {
			if (formData.achievedNSC == 'YES') {
				formData.achievedNSC = true;
			} else {
				formData.achievedNSC = false;
			}
		 }
		if (!isNullOrEmpty(formData.examinationMonthAndYear)) {
			var examinationMonthAndYearArr = formData.examinationMonthAndYear.split("/");
			if (examinationMonthAndYearArr.length == 2) {
				formData.examMonth = examinationMonthAndYearArr[0];
				formData.examYear = examinationMonthAndYearArr[1];
			}
		}
	
		 delete formData.achievementTypeId;
		 delete formData.progEndorsedStatusId;
		 delete formData.heqsfLevelId;
		 delete formData.eligibilityStatusId;
		 delete formData.examinationMonthAndYear;
	
		 jsonFormFieldData = Ext.encode(formData);
		 return jsonFormFieldData;
	 },
	/*
	 *This function is used for to load grid store with params
	 *	 
	 */
    loadGridStore: function(grid, storeURL, paramObject) {
        var gridStore = grid.getStore();
        gridStore.getProxy().api.read = storeURL;
        grid.getStore().load({
            params: paramObject,
        });
    },

	/*
	 *This function is used for to save admission program grid data
	 *	 
	 */
    saveAdmissionProgramGridData: function(window, admissionType, successMessage,callFromScrollableAlertWindow) {
    	var me=this;
        var grid = window.down('#admissionGrid');
        form = window.down('#approveAdmissionProgramForm');
        if (!isEmpty(form) && form.getForm().isValid()) {
            if (!isEmpty(grid) && grid.getSelectionModel().getCount() > 0) {
                var record = grid.getSelectionModel().getSelection()[0];
                var admissionId = record.get("id");
                if (!isNullOrEmpty(admissionId)) {
                    var url = '' ;
                    var serverurl =	'';
                    var isApproveAdmission = false;
                    var responseResult;
                    if (admissionType === this.APPROVE) { 
                    	serverurl =	SERVERURL.APPLICATIONS_APPROVE_ADMISSION; //rest/applicationAdmissionDetails/approveAdmission
                    	var feePlanRuleId = window.down('#installmentRuleItemId').getValue();
                    	var remarkField = window.down('#remarkItemId').getValue();
                    	var allSectionsVerified = window.down('#allSectionsVerifiedItemId').getValue();
                    	var allDocumentsVerified = window.down('#allDocumentsVerifiedItemId').getValue();
                    	var billingStartDate =Ext.Date.format(window.down('#billingStartDateId').getValue(),'Y-m-d');
                    	var admissionApprovedOnDate = window.down('#admissionApprovedOn').getRawValue();
                    	var admissionApprovedOn = admissionApprovedOnDate.split("/").reverse().join("-");
                    	var schoolAttendanceStartDate = Ext.Date.format(window.down('#schoolAttendanceStartDate').getValue(),'Y-m-d');
                    	if(!isNullOrEmpty(feePlanRuleId)){
                    		url = serverurl.concat("?id="+admissionId+"&feePlanRuleId="+feePlanRuleId+"&approvalRemark="+remarkField+"&allSectionsVerified="+allSectionsVerified+"&allDocumentsVerified="+allDocumentsVerified+"&billingStartDate="+billingStartDate+"&admissionApprovedOn="+admissionApprovedOn+"&schoolAttendanceStartDate="+schoolAttendanceStartDate);
                    	}else{
                    		url = serverurl.concat("?id="+admissionId+"&approvalRemark="+remarkField+"&allSectionsVerified="+allSectionsVerified+"&allDocumentsVerified="+allDocumentsVerified+"&admissionApprovedOn="+admissionApprovedOn+"&schoolAttendanceStartDate="+schoolAttendanceStartDate);
                    	}
                    
                    	if( !isNullOrEmpty(callFromScrollableAlertWindow) && callFromScrollableAlertWindow == true ){
                    		
                    	} else {
                    		isApproveAdmission = true;                    	                    	
                        	var applicantProfile = me.getContentPanelActiveTab();
                    		var applicationId = applicantProfile.getApplicationId();
                    		var wheatherOnlyAdmitted = '&wheatherOnlyAdmitted=true';
                        	
                        Ext.Ajax.request({
                            type: 'rest',
                                url: SERVERURL.APPLICATIONS_ADMISSION_GRID_DATA+'?applicationId='+applicationId+wheatherOnlyAdmitted,
                            method: 'GET',
                            headers: {
                              'Content-Type': 'application/json'
                            },
                            success: function(form, action) {
                                
                                	if(!isNullOrEmpty(form.responseText)){
                                		responseResult = Ext.decode(form.responseText);                                		
                                		if( Array.isArray(responseResult) && responseResult.length > 0 ){
                                			var pbstArray = [];
                                			var prevMsg = "Are you Sure you want to Approve Admission for the selected Program?";
                                			prevMsg = getCommonTranslation('APPROVE_ADMISSION_ALERT_ALREADY_ADMITTED_MSG_1');
                                        	var resultMsg = "This user is already admitted in the following Program(s):";
                                        	resultMsg = getCommonTranslation('APPROVE_ADMISSION_ALERT_ALREADY_ADMITTED_MSG_2');
                                        	var value = prevMsg + "<br/>" + resultMsg;
                                			for(var index in responseResult){
                                				var pbst = responseResult[index];
                                				var pbstName = "";
                                				var programName = pbst.program.value;
                                				var batchName = pbst.batch.value;
                                				pbstName = programName + " - " + batchName;
                                				var modeOfDelievery = pbst.modeOfDelivery;
                                				if( !isNullOrEmpty(modeOfDelievery) ){
                                					pbstName = pbstName + " - " + "(" + "Mode of Delivery -"+ modeOfDelievery.value + ")";
                                				}
                                				value = value + "<br/>" + pbstName;
                                				var studentId=pbst.studentId;
                                                var record1 = grid.getSelectionModel().getSelection()[0];
                                                value=value+"<br/><b>" + "Detail of this Program "+ record1.data.program.value + " will be merge with the Existing Student ID " + studentId +"</b>";
                                			}
                                			value = value + "<br/>";
                                			
                                			var alertWin = me.getScrollablealertyesnowindow();
                                        	if(!alertWin){
                                        		alertWin = Ext.widget('scrollablealertyesnowindow');
                                        	}
                                        	
                                        	alertWin.down('#popupContentItemId').setValue(value);
                                        	alertWin.show();
                                
                                }else{
                                			me.approveAdmissionCall(url,me,grid,window, admissionType,successMessage);
                                }
                                	} else {
                                		me.approveAdmissionCall(url,me,grid,window, admissionType,successMessage);
                                }
                            },
                                failure: function(form, action) {} 
                            });
                    	}
                    } else if (admissionType === this.REJECT) {
                    	var remarkField = window.down('#remarkItemId').getValue();
                    	serverurl = SERVERURL.APPLICATIONS_REJECT_ADMISSION; //rest/admission/rejectAdmission
                    	url = serverurl.concat("?id="+admissionId+"&rejectionRemark="+remarkField);
                    } else if (admissionType === this.WITHDRAW) {
                    	var remarkField = window.down('#remarkItemId').getValue();
                    	serverurl = SERVERURL.APPLICATIONS_WITHDRAW_ADMISSION; //rest/admission/withdrawAdmission
                    	url = serverurl.concat("?id="+admissionId+"&withdrawalRemark="+remarkField);
                            	}
                                        
                    if (!isNullOrEmpty(url) && !isApproveAdmission) {
                    	me.applyWindowMask();
                    	if(!isNullOrEmpty(responseResult)) {
                          var studentCode=responseResult[0].studentId;
                    	if(studentCode!=null){
                    		var applicantProfile = me.getContentPanelActiveTab();
                    		var applicationId = applicantProfile.getApplicationId();
                    	me.linkStudentIdupdate(applicationId,studentCode);
                    	}
                    	}
                    	me.approveAdmissionCall(url,me,grid,window,admissionType,successMessage);                    	
                    }
                }
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            	
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
        }
    },

	/*
	 *This function is used for to save application program grid data
	 *	 
	 */
    saveApplicationProgramGridData: function(window, applicationType, successMessage,applicationId,applicantProfile) {
        var me = this;
        var grid = window.down('#applicationProgramGrid');
        var form = window.down('#applicationProgramForm');
        if (!isEmpty(form) && form.getForm().isValid()) {
            if (!isEmpty(grid) && grid.getSelectionModel().getCount() > 0) {
            	var applicationProgramJsonObject=new Object();            	
                var formData = form.getValues();
                var selectedApplicationPrograms = me.getSelectedApplicationPrograms(grid);
                if (!isEmpty(formData) && !isEmpty(selectedApplicationPrograms)) {
                	                		
                		applicationProgramJsonObject.currentStatus = applicationType;
                		if(applicationType!='APPROVED'){
                			applicationProgramJsonObject.applicationIds = [(!isNullOrEmpty(applicationId)) ? applicationId : null];
                		}else{
                			applicationProgramJsonObject.applicationId = (!isNullOrEmpty(applicationId)) ? applicationId : null;
                			applicationProgramJsonObject.allSectionsVerified = (!isNullOrEmpty(formData.allSectionsVerified)) ? formData.allSectionsVerified : null;
                        	applicationProgramJsonObject.allDocumentsVerified = (!isNullOrEmpty(formData.allDocumentsVerified)) ? formData.allDocumentsVerified : null;
                		}
                    	applicationProgramJsonObject.reasonId = (!isNullOrEmpty(formData.reasonId)) ? formData.reasonId : null;
                    	applicationProgramJsonObject.remark = (!isNullOrEmpty(formData.remark)) ? formData.remark : null;                     
                    	applicationProgramJsonObject.applicationProgramIds = selectedApplicationPrograms;

                    	me.applyWindowMask();
                    	
                    	Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.APPLICATIONS_APPROVE_REJECT_WITHDRAW_APPLICATION_PROGRAM, //rest/applicationProgram/approveOrRejectOrWithdrawnApplication										 
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            jsonData: Ext.encode(applicationProgramJsonObject),
                            success: function(form, action) {
                                grid.getStore().reload();
                                grid.getSelectionModel().deselectAll();
                              
                                /*
                                 * after APPROVED button will invisible 
                                 */
                                if(applicationType=='APPROVED'){
                                	var approveApplicationBtn = Ext.ComponentQuery.query('button#approveApplicationBtn')[0]
                                	if(!approveApplicationBtn.isHidden()){
                                		approveApplicationBtn.setVisible(false);                                		
                                	}
                                	showSuccessMessage(getCommonTranslation('APPROVE_APPLICATION'), successMessage);
                                }else{
                                	showSuccessMessage(getCommonTranslation('SUCCESS'), successMessage);
                                }
                                //showSuccessMessage(getCommonTranslation('SUCCESS'), successMessage);
                                me.closeAllTabsExceptPersonInfoTab(applicantProfile);
                                me.setPermissionAccordingToStatus(applicantProfile);
                                me.mixins.ApplicationBaseController.gettingDataInSummaryGridExpand(applicantProfile);
                                me.mixins.ApplicationBaseController.loadApplications(applicationId);
                                setTimeout(function(){
                                window.close();
                                me.hideWindowMask();
                                },10000);
                            },
                            failure: function(form, action) {/*
                            	var data = Ext.decode(form.responseText);
                            	if(data[0].key == 'document_not_submitted')
                            	{
                            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_SUBMITTED')); //Please select a record.
                            	}
                            	if(data[0].key == 'cant_send_offer_letter_document_not_mapped')
                            	{
                            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('You have not mapped offer letter with applicant program batch seat type. Please configure')); 
                            	}
                            	if(data[0].key == 'CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED')
                            	{
                            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED')); 
                            	}
                            	if(data[0].key == 'submit_characteristics_document'){
                            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('submit_characteristics_document')); 
                            	}                            	
                            */}
                        });                	                	                                             
                }
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
        }
    },

	/*
	 *This function is used for to getting selected application programs
	 *	 
	 */
    getSelectedApplicationPrograms: function(grid) {
        var applicationProgramIds = new Array();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            for (var count = 0; count < records.length; count++) {
                var record = records[count];
                var applicationProgramId = record.get('id');
                if (!isEmpty(record) && !isNullOrEmpty(applicationProgramId)) {
                    applicationProgramIds.push(applicationProgramId);
                }
            }
        }
        return applicationProgramIds;
    },
    
    /*
	 *This function is used for to set Permissions According to various statuses
	 *	 
	 */
    setPermissionAccordingToStatus: function(applicantProfile) {
    	var applicationId=applicantProfile.getApplicationId();
    	if(!isNullOrEmpty(applicationId)){
	    	var me=this;    	    	 
	    	var url = SERVERURL.APPLICANT_APPLICATION_STATUS_BY_ID;  //URL-:rest/application/applicantAdmissionProgressStatus        	           	
	       	url=url.concat("?id="+applicationId);           	
	       	me.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
	    		if(success){	
	    			var data = Ext.decode(response.responseText);
	    			if(!isEmpty(data)){    				
	    		    		var applicationStatusObject=applicantProfile.getApplicationInfo();
	    		    		if(isNullOrEmpty(applicationStatusObject['applicationID'])){
	    		    			applicationStatusObject['applicationID']=applicantProfile.getApplicationId();
	    		    		}
	    		    		applicationStatusObject['applicationStatus']=getObjectValue(data,'applicationStatus');
	    		    		//applicationStatusObject['admissionID']=me.getResponseDataValue(responseData,'ADMISSION_PRIMERY_ID');
	    		    		//me.getResponseDataValue(responseData,'APPLICATION_STATUS');
	    		    		/*applicationStatusObject['admissionStatus']=me.getResponseDataValue(responseData,'ADMISSION_STATUS');
	    		    		applicationStatusObject['programStatus']= me.getResponseDataValue(responseData,'PROGRAM_STATUS');
	    		    		applicationStatusObject['stageStatus']= me.getResponseDataValue(responseData,'CURRENT_STAGE');*/
	    		    		
	    		    		me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
	    					me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);	    		    		    		    			    		    	
	                }
	    		}        		
	    	});    	
    	}
    },
    
    
    /*
	 *This function is used for to close all tabs in person Info Tab Panel except Personal Information Tab
	 *	 
	 */
    closeAllTabsExceptPersonInfoTab:function(applicantProfile){
    	var me=this;
    	if(applicantProfile){
    		var personinfopanel=applicantProfile.down('personinfopanel');
    		if(personinfopanel){
				var tabArray=new Array();				
				Ext.Array.each(personinfopanel.items.items, function(tab) {
					tabArray.push(tab);				
    			});
				for(var tabCount=0;tabCount<tabArray.length;tabCount++){
					var tabCmp= tabArray[tabCount];					
                   	 if(tabCmp.itemId==='applicantPersonalDetails'){                   		
                   		personinfopanel.down('#'+tabCmp.itemId).close();
                   		me.getUpdatedApplicationStatus(applicantProfile);
                   	 }else{
                   		personinfopanel.down('#'+tabCmp.itemId).close();
                   	 }                   	            	            	                     
                }
    		}    		      
    	}    	          	                 	                	
   },
   
   getUpdatedApplicationStatus:function(applicantProfile){
	   var me=this;
	   var applicationId=applicantProfile.getApplicationId();        
       if(!isNullOrEmpty(applicationId)){ 
    	    applicant_Personal_Information_Url = SERVERURL.APPLICANT_PERSONAL_INFORMATION_BY_ID;  //URL-:rest/applicantPerson/findApplicationWithPersonDetail        	           	
          	applicant_Personal_Information_Url=applicant_Personal_Information_Url.concat("?id="+applicationId);           	
          	me.sendGetAjaxRequest(applicant_Personal_Information_Url, 'GET', null, function(option, success, response) {
       		if(success){	
       			var data = Ext.decode(response.responseText);
                   if(!isEmpty(data)){                   	
	                   	applicantProfile.setApplicationDataObject(data);                        	
	                   	applicantProfile.setPersonInfo(data.person);
	                   	applicantProfile.setPersonId(data.person.id);
	                   	if(!isNullOrEmpty(data.code)){
	                   		applicantProfile.setTitle(data.code);
	                   	}
	                   	applicantProfile.getApplicationInfo()['applicationStatus']=data.currentStatus;
	                   	
	                   	var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
	        			if(!isEmpty(applicantLinkPanelObject)){
	        				var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];                            				
	        				me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel,'Approve_Admission_Button');
	        			}                     	                       
                   }
       		}        		
          	});
       }
   },
   
   printButtonAction:function(){
		   var $this = this;
		   user=$this.getCurrentlyLoggedInUser();
		   var code ="ApplicationSummaryReport"; 
		   var applicantProfile = $this.getContentPanelActiveTab();
		   var reportParams =new Object();
		   var title= applicantProfile.applicationDataObject.person.printName+"-"+ new Date().getTime();
		   reportParams.reportTitle=title;
		   reportParams.userId=user.code;
		   reportParams.applicationId=String(applicantProfile.getApplicationId());
		   reportParams.applicantPersionId = applicantProfile.applicationDataObject.person.id;
		   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
		   reportParams.code = code;
		   
		   $$this = Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		   var returnJson = new Object();
		   returnJson = $$this.getAllPermissions();
		  
		   reportParams.isAddress = returnJson.map.isAddress;
		   reportParams.isParentAndGuardian = returnJson.map.isParentAndGuardian;
		   reportParams.isIdentity = returnJson.map.isIdentity;
		   reportParams.isPNC = returnJson.map.isPNC;
		   reportParams.isEducation = returnJson.map.isEducation;
		   reportParams.isCompetitive = returnJson.map.isCompetitive;
		   reportParams.isWorkExp = returnJson.map.isWorkExp;
		   reportParams.isReceiptPayment = returnJson.map.isReceiptPayment;
		   reportParams.isDocument = returnJson.map.isDocument;
		   reportParams.isMedical = returnJson.map.isMedical;
		   reportParams.isVaccination = returnJson.map.isVaccination;
		   reportParams.isExtracurricularActivity = returnJson.map.isExtracurricularActivity;
		   reportParams.isApplicationDetail = returnJson.map.isApplicationDetail;
		   reportParams.isApplicationRef = returnJson.map.isApplicationRef;
		   reportParams.isMidTermAdmission = returnJson.map.isMidTermAdmission;
		   reportParams.isAdmissionDetails = returnJson.map.isAdmissionDetails;
		   reportParams.isSiblingDetails = returnJson.map.isSiblingDetails
		   reportParams.isFeePayerDetail = returnJson.map.isFeePayerDetail;
		   reportParams.isFeePlan = returnJson.map.isFeePlan;
		   reportParams.isServiceOptIn = returnJson.map.isServiceOptIn;
		   reportParams.isCommunityOptIn = returnJson.map.isCommunityOptIn;
		   
		   var exportUrl = SERVERURL.PATH_PRINT_APPLICATION;
		   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);

   },
   
 //*****************************disable profile print for applicant ****************************************
   disableApplicantProfilePrint: function(form,permissionsMap) {
	   var $this=this;
	   var associatedAcadLocationIds = new Array();
	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   //var printBtn = form.down('#printprofileBtn');
	   var printBtn = form.down('#printBtn');
	   //printBtn.setText(getServiceRequestTranslation('PARENT_ADDRESS'));
	 
	   printBtn.setVisible(false);

	   Ext.each(permissionList, function(privilege) {
		   if (privilege === 'PRINT') {
			   if(!isNullOrEmpty(printBtn)){
				   printBtn.setVisible(true);
				 
			   }        		
		   }
	   });
   },
   
 //*****************************disable portel print  for applicant ****************************************
   disableApplicantPortelPrint: function(form,permissionsMap) {
	   var $this=this;
	   var associatedAcadLocationIds = new Array();
	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   //var printBtn = form.down('#printprofileBtn');
	   var printBtn = form.down('#printBtn');
	   //printBtn.setText(getServiceRequestTranslation('PARENT_ADDRESS'));
	 
	   printBtn.setVisible(false);

	   Ext.each(permissionList, function(privilege) {
		   if (privilege === 'ProfilePrint') {
			   if(!isNullOrEmpty(printBtn)){
				   printBtn.setVisible(true);
				 
			   }        		
		   }
	   });
   },
   
   //*****************************disable ****************************************
   disableMoreActionPivileges: function(from,permissionsMap) {

  	 var associatedAcadLocationIds = new Array();
  	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
  	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
  	 var approveApplicationButton = from.down('#approveApplicationBtn');
  	 var rejectApplicationBtn = from.down('#rejectApplicationBtn');
  	 var withdrawApplicationBtn = from.down('#withdrawApplicationBtn');
  	 var withdrawAdmissionBtn = from.down('#withdrawAdmissionBtn');
  	 var rejectAdmissionBtn = from.down('#rejectAdmissionBtn');
  	 var approveAdmissionBtn = from.down('#approveAdmissionBtn');
  	 var printBtn = from.down('#printBtn');
//  	 buttonsToolBar = gridReference.query('toolbar')[0];

//  	 var addCoverageDetailsButton = buttonsToolBar.query('#addCoverageDetails')[0];
  	approveApplicationButton.setVisible(false);
  	rejectApplicationBtn.setVisible(false);
  	withdrawApplicationBtn.setVisible(false);
  	withdrawAdmissionBtn.setVisible(false);
  	rejectAdmissionBtn.setVisible(false);
  	approveAdmissionBtn.setVisible(false);
  	printBtn.setVisible(false);
  	 
  	 /*var addNewSessionButton = buttonsToolBar.query('#addNewSession')[0];
  	 addNewSessionButton.setVisible(false);*/

  	/* Ext.each(splitbuttons.menu.items.items, function(menuItems) {
  		 menuItems.setVisible(false);
  	 });*/
	
  	 Ext.each(permissionList, function(privilege) {
  		
  		 if (privilege === 'APPROVEAPPLICATION') {
  			 if(!isNullOrEmpty(approveApplicationButton)){
  				approveApplicationButton.setVisible(true);	 
  			 }
  		 }
  		 if (privilege === 'REJECTAPPLICATION') {
			 if(!isNullOrEmpty(rejectApplicationBtn)){
				 rejectApplicationBtn.setVisible(true);
			 }        		
		 }
  		 if (privilege === 'WITHDRAWAPPLICATION') {
  			 if(!isNullOrEmpty(withdrawApplicationBtn)){
  				withdrawApplicationBtn.setVisible(true);
  			 }        		
  		 }
  		 if (privilege === 'WITHDRAWADMISSION') {
  			 if(!isNullOrEmpty(withdrawAdmissionBtn)){
  				withdrawAdmissionBtn.setVisible(true);
  			 }        		
  		 }
  		 if (privilege === 'REJECTADMISSION') {
  			 if(!isNullOrEmpty(rejectAdmissionBtn)){
  				rejectAdmissionBtn.setVisible(true);
  			 }        		
  		 }
  		 if (privilege === 'APPROVEADMISSION') {
  			 if(!isNullOrEmpty(approveAdmissionBtn)){
  				approveAdmissionBtn.setVisible(true);
  			 }        		
  		 }
  		 if (privilege === 'PRINT') {
  			// var button = buttonsToolBar.query('#addNewSession');
  			 if(!isNullOrEmpty(printBtn)){
  				printBtn.setVisible(true);
  			 }        		
  		 } /*if (privilege === 'PROFILE_PRINT') {
  			// var button = buttonsToolBar.query('#addNewSession');
  			 if(!isNullOrEmpty(printBtn)){
  				printBtn.setVisible(true);
  			 }        		
  		 }*/
  	 });
   },  
   
   disableWithdrawFromProgramPivileges: function(from,permissionsMap) {

	  	 var associatedAcadLocationIds = new Array();
	  	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	  	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	  	 var withdrawFromProgramBtn = from.down('#withdrawFromProgramBtn');
	  	 withdrawFromProgramBtn.setVisible(false);
	  	 
	  	 Ext.each(permissionList, function(privilege) {
	  		
	  		 if (privilege === 'WITHDRAW_FROM_PROGRAM') {
	  			 if(!isNullOrEmpty(withdrawFromProgramBtn)){
	  				withdrawFromProgramBtn.setVisible(true);	 
	  			 }
	  		 }
	  	 });
	   },  
   
	getRenderApplicationReviewDetails: function() {

		var $this = this;
		var user = $this.getCurrentlyLoggedInUser();
		var applicantProfile = $this.getContentPanelActiveTab();
		var applicationReviewForm = applicantProfile.down('#reviewdetails');
		var reviewDetailGrid = $this.getContentPanel().getActiveTab().down('reviewdetailspanel');
		var reviewer = applicationReviewForm.down('#reviewerId');
		var reviewerStore = reviewer.getStore();

		reviewDetailGrid.down('#btnAdd').setVisible(false);
		reviewDetailGrid.down('#btnDelete').setVisible(false);
		applicationReviewForm.down('#willingToSuperwise').setVisible(false);

		if (applicantProfile) {
			try {
				var applicationId = applicantProfile.getApplicationId();
			}
			catch (e) {
				var applicationId = Ext.ComponentQuery.query('applicantprofile')[0].getApplicationId();
			}

			reviewerStore.getProxy().extraParams = {
				applicationId: applicationId,
				userId: user.id
			};
			reviewerStore.load({
				callback: function(records) {
					var found = false;

					Ext.Array.each(records, function(rec) {
						if (rec.get('userId') == user.id) {
							reviewer.setValue(rec.get('id'));
							found = true;
							return false;
						}
					});

					if (!found) {
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_FIND_ALL_APPLICATION_REVIEWER_DETAILS_GRID_DATA + '?applicationId=' + applicationId,
							method: 'GET',
							success: function(form) {
								if (!isNullOrEmpty(form.responseText)) {
									var responseResult = Ext.decode(form.responseText);
									if (Ext.isArray(responseResult) && responseResult.length > 0) {
										reviewDetailGrid.getStore().loadRawData(responseResult);
										var formObj = applicationReviewForm.getForm();
										if (!isNullOrEmpty(responseResult[0])) {
											$this.loadReviewerCustomFieldData(formObj, responseResult);
										}
									}
								}
							}
						});
					}
				}
			});
		}
	},
   getRenderApplicationConditionDocumentList : function(){
   	var $this = this;
   	var functionArguments = arguments;
    var applicantProfile = $this.getContentPanelActiveTab();
	var applicationConditionsForm = applicantProfile.down('#applicationconditionsforadmissionFormId');
	var grid = applicantProfile.down('#applicationconditionsdocumentlistId');
       if (applicantProfile) {
    	   try{
    		   var applicationId = applicantProfile.getApplicationId();
    	   }
    	   catch(e){
    		   var applicationId = Ext.ComponentQuery.query('applicantprofile')[0].getApplicationId();
    	   }
    	   if(!isNullOrEmpty(applicationId)){
    		   var url = SERVERURL.FIND_CONDITION_BY_APPLICATION_ID;
    		   Ext.Ajax.request({
    			   type: 'rest',
    			   url: url+'?applicationId='+applicationId,
    			   method: 'GET',
    			   success: function(form, action) {
    				   if(!isNullOrEmpty(form.responseText))
    				   {
    					   responseResult = Ext.decode(form.responseText);
    					   //if(typeof functionArguments[0]!="string"){
    					   applicationConditionsForm.down('#conditionApplicableId').setValue(responseResult.condition);
    					   applicationConditionsForm.down('#Id').setValue(responseResult.id);
    					   grid.getStore().removeAll();
    					   grid.getStore().add(responseResult.requiredDocuments);
    					   
						   if(responseResult.isEditable){
							   grid.down('button[itemId=btnUploadDocument]').setDisabled(false);
							   grid.up('form').down('button[itemId=btnSave]').setDisabled(false);
						   }
						   else
						   {
							   setTimeout(function(){
								   grid.down('button[itemId=btnUploadDocument]').setDisabled(true);
								   grid.up('form').down('button[itemId=btnSave]').setDisabled(true);
							   },300);
						   }
    					   //}
    					   /*else if(functionArguments[0]=="onlyGrid"){
    					   grid.getStore().removeAll();
    					   grid.getStore().add(responseResult.requiredDocuments);
    				   }*/
    				   }else
    					   {
    					   applicationConditionsForm.down('#conditionApplicableId').setDisabled(true);
    					   grid.down('button[itemId=btnUploadDocument]').setDisabled(true);
						   grid.up('form').down('button[itemId=btnSave]').setDisabled(true);
    					   }
    			   }
    		   });
    		   if(portalId==6){
				   grid.down('button[itemId=btnUploadDocument]').hide();
				   grid.up('form').down('button[itemId=btnSave]').hide();
				   applicationConditionsForm.down('#conditionApplicableId').setReadOnly(true);
				   
			   }
    	   }
       }             
   },
   showApplicantConditionsForAdmissionWindow:function() {
	   $this = this;
	   var gridWindow = $this.getApplicationconditionsdocumentsupdatestructure();
	   if (!gridWindow) {
		   Ext.widget('applicationconditionsdocumentsupdatestructure');
		   gridWindow = $this.getApplicationconditionsdocumentsupdatestructure();
	   }
	   gridWindow.show();
	   var applicantProfile = $this.getContentPanelActiveTab();
	   if (applicantProfile) {
		   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
			   var grid = $this.getApplicationconditionsdocumentupdatelist();
			   var store = grid.getStore();
			    store.getProxy().extraParams = {
			    applicationId: applicantProfile.getApplicationId()
		       };
			   store.load({
				   callback: function(records, operation, success) {

					   var urlAPPLICATION_ID =  SERVERURL.APPLICATION_FIND_CONDITIONAL_DOC;
					   Ext.Ajax.request({
						   type: 'rest',
						   url: urlAPPLICATION_ID+'?applicationId='+applicantProfile.getApplicationId(),
						   method: 'GET',
						   success: function(form, action) {
							   Ext.getBody().unmask();
							   if(!isNullOrEmpty(form.responseText))
							   {
								   responseResult = Ext.decode(form.responseText);
								   for(var j=0; j<responseResult.length; j++){
									   var index = store.find('id',responseResult[j].id);
									   grid.getSelectionModel().select(index,true);

								   }
							   }
						   }
					   });
				   }
			   });

		   }
	   }
   },
   saveApplicationConditionsForAdmission:function() {
	   var this$ = this;
	   var applicantProfile = this$.getContentPanelActiveTab();
	   var applicationConditionsForm = applicantProfile.down('#applicationconditionsforadmissionFormId');
	   var conditionGrid = applicantProfile.down('#applicationconditionsdocumentlistId');
	   var appliCationconditionsForm = applicationConditionsForm.getForm().getValues();
	   var records = conditionGrid.getStore(); 
		   var docArray = new Array();
		   for(var j=0; j<records.data.items.length; j++){
			   var pbpsPanelContainer=records.data.items[j].data.id;
			   docArray.push({
				   id:pbpsPanelContainer,
			   });
		   }
		   var jsonData= {"id":appliCationconditionsForm.id,
				   "applicationId": applicantProfile.getApplicationId(),
				   "condition": appliCationconditionsForm.conditionApplicable,
				   requiredDocuments:docArray	
		   };

		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		   var urlCONDITIONUPDATE = SERVERURL.APPLICATION_CONDITIONUPDATE;
		   Ext.Ajax.request({
			   type: 'rest',
			   url: urlCONDITIONUPDATE,
			   jsonData: jsonData,
			   method: 'POST',
			   success: function(form, action) {
				   //this$.getSelectionstageconditionsadmission().close();
				   showSuccessMessage(getAdmissionTranslation('CONDITIONS_FOR_ADMISSION'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
				   var urlAPPLICATION_ID = SERVERURL.FIND_CONDITION_BY_APPLICATION_ID;
				   Ext.Ajax.request({
					   type: 'rest',
					   url: urlAPPLICATION_ID+'?applicationId='+applicantProfile.getApplicationId(),
					   method: 'GET',
					   success: function(form, action) {
						   Ext.getBody().unmask();
						   if(!isNullOrEmpty(form.responseText))
						   {
							   responseResult = Ext.decode(form.responseText);
							   tabPanel.down('#Id').setValue(responseResult.id);
						   }
					   }
				   });
			   }
		   });
	   
   },
   updateConditionsDocumentsForAdmission:function(btn) {
	   $this = this;
	   var applicantProfile = $this.getContentPanelActiveTab();
	   var docConditionalWindow = btn.up('#applicationconditionsdocumentsupdatestructureFormId');
	   var conditionGrid = applicantProfile.down('#applicationconditionsdocumentlistId');
	   var grid = docConditionalWindow.down('#applicationconditionsdocumentupdatelistId');

	   if (grid.getSelectionModel().getCount() > 0) {
		   
		   var records=grid.getSelectionModel().getSelection();

		   conditionGrid.getStore().load({
			   callback:function(){
				   conditionGrid.getStore().add(records);
			   }
		   });

		   docConditionalWindow.up().close();

	   }else{

		   showConfirmMessage(getCommonTranslation('LIST_OF_APPLICABLE_DOCUMENTS'), getAdmissionTranslation('APPLICANT_TO_DESELECT_DOC_CONFIRM_MESSAGE'),

				   function(btn, text) {
			   if (btn == 'yes') {

				   var records=grid.getSelectionModel().getSelection();

				   conditionGrid.getStore().load({
					   callback:function(){
						   conditionGrid.getStore().add(records);
					   }
				   });

				   docConditionalWindow.up().close();

			   }
		   });

	   }
   },
	
	 showApplicantOnlineDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getApplicantonlinedocumentformwin();
		 if (!formWindow) {
			 Ext.widget('onlinedocumentformwin',{
				 itemId : 'applicantOnlineDocumentFormWin'
			 });
			 formWindow = $this.getApplicantonlinedocumentformwin();
		 }
		 formWindow.show();
	 },
	 showApplicantPhysicalDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getApplicantphysicaldocumentformwin();
		 if (!formWindow) {
			 Ext.widget('physicaldocumentformwin',{
				 itemId : 'applicantPhysicalDocumentFormWin'
			 });
			 var formWindow = $this.getApplicantphysicaldocumentformwin();
		 }
		 var modeSubmissionStore=formWindow.down('#modeOfSubmission').getStore();
		 modeSubmissionStore.on('load', function(){
			 for(var i=0; i< modeSubmissionStore.data.items.length;i++){
				 if(modeSubmissionStore.data.items[i].data.value == 'Online'){
					 modeSubmissionStore.removeAt(i);
				 } 
			 }
		 });
		 formWindow.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		 var form = formWindow.down('#physicalDocumentFormItemId');
		 Ext.apply(form, {
			 isEditable: false
		 });
		 formWindow.show();
	 },
	 onChangeApplicantPredefinedRadioGroup : function(formWin, newValue, formType) { // formType(ONLINE, PHYSICAL)
		 
	     	var store = formWin.down('#documentTypeCombo').getStore();
	     	var documentTypeCombo = formWin.down('#documentTypeCombo');
	     	var documentName = formWin.down('#documentNameItemId');
	     	var remarkItemId = formWin.down('#remarkItemId');
	     	if (formType == 'ONLINE') {
	     		formWin.down('#uploadFileField').reset();
	     		formWin.down('#docDetails').setValue('');
	     	}
	     	if (formType == 'PHYSICAL') {
	     		formWin.down('#responsibleUserField').reset();
	         	formWin.down('#modeOfSubmission').reset();
	     	}
	     	if(newValue.isPreDefined == false){
	     		documentTypeCombo.reset();
	     		documentName.reset();
	     		store.removeAll();
	     		documentTypeCombo.setVisible(false);
	     		documentName.setVisible(true);
	     		documentTypeCombo.allowBlank = true;
	     		documentName.allowBlank = false;
	     	} else {
	     		documentTypeCombo.reset();
	     		documentName.reset();
	     		store.load();
	     		documentTypeCombo.setVisible(true);
	     		documentName.setVisible(false);
	     		documentTypeCombo.allowBlank = false;
	     		documentName.allowBlank = true;
	     	}
	     	remarkItemId.reset();
		 },
			
		 loadApplicantDocumentGridStore:function(grid, isElectronic) {
			 var this$ = this;
			 var personProfile = this$.getContentPanelActiveTab();
			 var applicantId = personProfile.getApplicationId();
			 var store = this$.getStore('admission.applications.applicantdocuments.ApplicantDocumentStore');
			 this$.resetPageSetting(store);
			 store.getProxy().extraParams = {
				 applicantId: applicantId,
				 isElectronic: isElectronic
			 };
			 store.load();
		 },
		    addNewRowInReviewDetailsGrid: function(serialNo, grid, getApplicationReviewStructure) {
		        var $this = this;
		        var ObjModel = [];
		        var applicantProfile = $this.getContentPanelActiveTab();
		        var applicationReviewForm = applicantProfile.down('#reviewdetails');
		        var reviewerField = applicationReviewForm.down('#reviewerId');
		        var reviewerId = reviewerField.getValue();
		        var reviewer = reviewerField.getRawValue();
		        var applicationReviewerGridModel = new Academia.model.admission.applications.applicationReviewer.ModAdmApplicationReviewerGrid();
		        applicationReviewerGridModel.set("serialNo", serialNo);
		        applicationReviewerGridModel.set("reviewerId", reviewerId);
		        applicationReviewerGridModel.set("reviewer", reviewer);
		        applicationReviewerGridModel.set("reviewParameterId", '');
		        applicationReviewerGridModel.set("reviewRatingId", '');
		        applicationReviewerGridModel.set("remarks", '');
//		        ObjModel.push(applicationReviewerGridModel);
				var models = grid.getStore().getRange();
				models.push(applicationReviewerGridModel);

		        grid.getStore().loadRawData(models, true);
		        if(serialNo == 1){
		        	applicationReviewForm.down('#SubmitBtn').setDisabled(false);
		        }
		        
		    },
	deleteReviewerDetails: function(gridItemId, deleteUrl) {
		 var this$ = this;
		 var applicantProfile = this$.getContentPanelActiveTab();	   
		 var applicationReviewForm = applicantProfile.down('#reviewdetails');
		 var reviewerId = applicationReviewForm.down('#reviewerId').getValue();
         var grid  =this$.getContentPanel().getActiveTab().down('reviewdetailspanel');
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getAdmissionTranslation('REVIEW_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn) {
				if (btn === 'yes') {
					var records = grid.getSelectionModel().getSelection();

					Ext.each(records, function(record) {
						var id = record.get('id');
						if (!isNullOrEmpty(id)) {
							Ext.Ajax.request({
								type: 'rest',
								url: deleteUrl + '?id=' + id,
								method: 'DELETE',
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {
									grid.getStore().getProxy().extraParams = {
										reviewerId: reviewerId,
										applicationId: applicantProfile.getApplicationId()
									};
									 grid.getStore().reload({
                                        callback: function () {
                                            showSuccessMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('REVIEWER_DELETE_MSG'));
                                        }
                                    });
								}
							});
						}else{
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SAVE_ALL_DATA_BEFORE_USING_THIS_FUNCTIONALITY'));
						}
					});
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
		    saveApplicationReviewerWithDetails: function(){
		    	var $this=this;
                var reviewDetailGrid  =$this.getContentPanel().getActiveTab().down('reviewdetailspanel');
		    	var jsonReviewerDetail = [];

		    	var reviewDetailGridStore = reviewDetailGrid.getStore();
		    	var getApplicationreviewerStructure = reviewDetailGrid.up('applicationreviewdetails');
		    	var reviewerId = getApplicationreviewerStructure.down('#reviewerId').getValue();
		    	var willingToSuperwise = getApplicationreviewerStructure.down('#willingToSuperwise').getValue().willingToSuperwise;
		    	var customDataJson = getApplicationreviewerStructure.form.getValues().customData;
		    	var flagIsSave = true;
		    	if(reviewDetailGridStore.getCount()>0){
		    		reviewDetailGridStore.data.items.every(function(obj){
		    			if (isNullOrEmpty(reviewerId)) {
		    				showWarningMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_APPLICATION_REVIEWER'));
		    				flagIsSave = false;
		    				return false;
		    			}
		    			if (isNullOrEmpty(obj.data.reviewParameterId) || obj.data.reviewParameterId.length == 0) {
		    				showWarningMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_REVIEW_PARAMETER'));
		    				flagIsSave = false;
		    				return false;
		    			}
		    			if (isNullOrEmpty(obj.data.reviewRatingId) || obj.data.reviewRatingId.length == 0) {
		    				showWarningMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_REVIEW_RATING'));
		    				flagIsSave = false;
		    				return false;
		    			}
		    			else{
		    				var jsonObj = {
		    						"id":obj.data.id,
		        					"applicationReviewerId":reviewerId,
		        					"isWillingSuperwise":willingToSuperwise,
		        					"reviewParameterId":obj.data.reviewParameterId,
		        					"reviewRatingId":obj.data.reviewRatingId,
		        					"remarks":obj.data.remarks,
		        					"customData":customDataJson
		        					
		        			}
		    				jsonReviewerDetail.push(jsonObj);
		    				return true;
		    			}
		    		});
		    		}else{
			            showWarningMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('PLEASE_ADD_REVIEW_DETAILS'));
		                flagIsSave = false;
		    			return false;
		            }
		    	if(flagIsSave){
		    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		    		Ext.Ajax.request({
		    			type: 'rest',
		    			url: SERVERURL.PATH_SAVE_APPLICATION_REVIEW,
		    			jsonData: jsonReviewerDetail,
		    			method: 'POST',
		    			success: function(frm, action) {
		    				Ext.getBody().unmask();
		    				var data = frm.responseText;
		    				var tabName = getAdmissionTranslation('REVIEW_DETAILS');
		    				var contentPanel =reviewDetailGrid;
		    				
		    				var getTab = null;
		    				for(var i =0 ;i<contentPanel.items.length;i++){
		    					if(contentPanel.items.items[i].title == tabName){
		    						getTab= contentPanel.items.items[i];
		    					}
		    				}
		    				if(getTab!=null){
		    					contentPanel.remove(getTab, true);
		    				}		 
		    				getApplicationreviewerStructure.down('#reviewerId').fireEvent('change',getApplicationreviewerStructure.down('#reviewerId'), getApplicationreviewerStructure.down('#reviewerId').getValue());
		    				showSuccessMessage(getAdmissionTranslation('REVIEW_DETAILS'), getAdmissionTranslation('REVIEWER_DETAILS_SAVED_MSG'));
		    			}
		    		});
		    	}
		    },
		    getReviewerDetails : function(reviewerId,reviewerUserId,appOwnerId,userId){
		    	var $this = this;
		    	var grid = $this.getContentPanel().getActiveTab().down('reviewdetailspanel');
		    	var applicantProfile = $this.getContentPanelActiveTab();	   
		        var applicationReviewForm = applicantProfile.down('#reviewdetails');
		    	 grid.getStore().removeAll();
		    	 Ext.Ajax.request({
		    		 type: 'rest',
		    		 url: SERVERURL.PATH_GET_APPLICATION_REVIEWER_DETAIL+'?reviewerId=' + reviewerId + '&applicationId=' + applicantProfile.getApplicationId(),
		    		 method: 'GET',
		    		 success: function(form, action) {
		    			 if(!isNullOrEmpty(form.responseText))
		    			 {
		    				 responseResult = Ext.decode(form.responseText);
	    					 grid.getStore().loadRawData(responseResult);
	    					 grid.down('#btnAdd').hide();
	    					 grid.down('#btnDelete').hide();
	    					 applicationReviewForm.down('#SubmitBtn').setVisible(false);
	    					 
	    					 if(responseResult.length!=0){
	    					 if(responseResult[0].isWillingSuperwise == true){
	    						 applicationReviewForm.down("#willingToSuperwise").items.items[0].setValue(true);
	    						 applicationReviewForm.down("#willingToSuperwise").items.items[1].setValue(false);
	    					 }else{
	    						 applicationReviewForm.down("#willingToSuperwise").items.items[0].setValue(false);
	    						 applicationReviewForm.down("#willingToSuperwise").items.items[1].setValue(true); 
	    					 }
	    					 applicationReviewForm.down("#willingToSuperwise").setVisible(true);
	    					 }else{
	    						 applicationReviewForm.down("#willingToSuperwise").setVisible(false);
	    					 }
		    				 if(userId.id == reviewerUserId){
		    					 
		    					 applicationReviewForm.down("#willingToSuperwise").setVisible(true);
		    					 
		    					 if(responseResult.length == 0){
		    					 applicationReviewForm.down("#willingToSuperwise").items.items[0].setValue(false);
	    						 applicationReviewForm.down("#willingToSuperwise").items.items[1].setValue(true); 
		    					 }
                                 $this.doAccessControlValidation(grid, $this.getAPPLICANT_APPLICATION_REVIEW_DETAILS_PERMISSIONS());
		    					 applicationReviewForm.down('#SubmitBtn').setVisible(true);		    					 
		    					 grid.reconfigure();
		    				 }else{
		    					 grid.reconfigure();
		    					 applicationReviewForm.down('#SubmitBtn').setVisible(false);
		    				 }
		    				 //custom field data
		    				 form =  applicationReviewForm.getForm();
		    				 if(!isNullOrEmpty(responseResult[0])){
		    					 $this.loadReviewerCustomFieldData(form,responseResult); 
		    				 }

		    			 }
		    		 }
		    	 });
		    },

		    loadReviewerCustomFieldData: function(form, jData){
		    	if(!isNullOrEmpty(jData[0].customData)){
		    		var customDataItem = jData[0].customData;
		    		if(!isNullOrEmpty(customDataItem)){
		    			var customDataProperty = customDataItem[0];
		    			if (!isNullOrEmpty(customDataProperty)) {
		    				for (var property in customDataProperty) {
		    					if(property.startsWith("C") || property.startsWith("c") ){
		    						if(!isNullOrEmpty(form.findField(property)) ){
		    							if( form.findField(property).xtype == 'datefield' ){
		    								form.findField(property).setValue(dateRender(customDataProperty[property]));
		    							} else {
		    								form.findField(property).setValue(customDataProperty[property]);
		    							}
		    						}
		    					}
		    					if(property.startsWith("id") || property.startsWith("version") ){
		    						if(property.startsWith("id")){
		    							form.findField('customHiddenId').setValue(customDataProperty[property]);
		    						}
		    						if(property.startsWith("version")){
		    							form.findField('customHiddenVersion').setValue(customDataProperty[property]);
		    						}
		    					}
		    				}
		    			}	
		    		}
		    	}
		    },
		   getRenderApplicationConditionsReviewDetails: function() {
		        var me = this;
		        var grid = me.getContentPanel().getActiveTab().down('applicationprogramconditionsreviewadmgrid');
		        var form = me.getContentPanel().getActiveTab().down('admissionconditionsreviewadmform');
		        var mainForm = me.getContentPanel().getActiveTab().down('applicationconditionsreviewdetails');
		        var rbnAdmEscalationRequired = form.down('#rbnAdmEscalationRequiredItemId');
		        var applicantProfile = me.getContentPanelActiveTab();
		        var currentStatus = null;

		        if (applicantProfile) {
		            if (!isNullOrEmpty(applicantProfile.getApplicationId())) {
		                grid.getStore().load({
		                    params: {
		                        applicationID: applicantProfile.getApplicationId(),
		                        escalatedOnly: true
		                    },
		                    callback: function(record, operation, success) {
		                        if (success && record.length > 0) {
		                            currentStatus = record[0].data.currentStatus;
		                            grid.getSelectionModel().select(grid.getStore().getAt(0));
		                            me.loadDFRForEscalationRequred(rbnAdmEscalationRequired);
		                        }
		                    }
		                });
		                
		                grid.getStore().on('beforeload', function(store, operation) {
		                    var applicationId = applicantProfile.getApplicationId();
		                    store.proxy.extraParams = {
		                        applicationID: applicationId,
		                        escalatedOnly: true
		                    };
		                });
		            }
		            }
		    },
		    saveAdmConditionsForReviewAdmission:function() {
		    	var this$ = this;
		    	var applicantProfile = this$.getContentPanelActiveTab();
		    	var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
		    	var applicationProgramGrid = this$.getContentPanel().getActiveTab().down('applicationprogramconditionsreviewadmgrid');
		    	var conditionReviewHistoryGrid = this$.getContentPanel().getActiveTab().down('conditionsreviewerdetailsadmgrid');
		    	var admConditionform = applicantProfile.down('admissionconditionsreviewadmform');
		    	var appDetailform = applicantProfile.down('applicationconditionsreviewdetails');
		    	var jsonData = new Object();
		    	jsonData = this$.createConditionsForReviewAdmissionFormJsonData(appDetailform);
		    	var flag = false;
		    	var isEscalationRequired = admConditionform.down('#rbnAdmEscalationRequiredItemId').getValue();
		    	var dliAdmAssignToItemId = admConditionform.down('#dliAdmAssignToItemId').getValue();
		    	if(isEscalationRequired.isEscalationRequired == "true" && isNullOrEmpty(dliAdmAssignToItemId)) {
		    		 flag = false;
	            }else{
	            	 flag = true;  
	            }
		    	 if(flag){
		    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				    	var urlCONDITIONUPDATE = SERVERURL.PATH_UPDATE_APPLICATION_PROGRAM_OFFER_DETAIL_BY_REVIEWER;
				    	Ext.Ajax.request({
				    		type: 'rest',
				    		url: urlCONDITIONUPDATE,
				    		jsonData: jsonData,
				    		method: 'POST',
				    		success: function(form, action) {
				    			Ext.getBody().unmask();
				    			applicationProgramGrid.getSelectionModel().deselectAll();
				    			this$.resetPageSetting(applicationProgramGrid.getStore());
				    			applicationProgramGrid.getStore().load({
				                    params: {
				                        applicationID: applicantProfile.getApplicationId(),
				                        escalatedOnly:true
				                    }
				                });
				    			if(!isNullOrEmpty(snapShotGrid)){
	        	    				snapShotGrid.getStore().load({
					                    params: {
					                    	applicationID: applicantProfile.getApplicationId(),
					                    	portalId:this$.getCurrentLoggedPortalId()
					                    }
	               	    	 		});
	        	    			}
				    			conditionReviewHistoryGrid.getStore().removeAll();
				    			var admissionConditionPanel = admConditionform.down('#applicableAdmissionReviewPanelId');
			              		for(var i=admissionConditionPanel.items.length-1; i>0;i--){
			              			admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
			              		}
			              		admConditionform.doLayout();
				    			admConditionform.getForm().reset();
				    			appDetailform.getForm().reset();
				    			appDetailform.down('#pAdmConReviewSubmitBtn').setVisible(false);
				    			showSuccessMessage(getPersonModuleTranslation('CONDITIONS_REVIEW_DETAILS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
				    		}
				    	}); 
		    	 }else{
		    		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILL_MANDATORY_FIELDS')); 
		    	 }
		    	

		    },
		   createConditionsForReviewAdmissionFormJsonData: function(form) {
		       var $this = this;
		       var applicantProfile = $this.getContentPanelActiveTab();
		       var appConditionReviewDetail = $this.getContentPanel().getActiveTab().down('applicationconditionsreviewdetails');
		       var applicationId;
	           if (applicantProfile) {
	        	   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
	        		   applicationId = applicantProfile.getApplicationId();
	        	   }
	           }
	           var jsonFormFieldData = new Object();
	           var formData = form.getValues();

	           jsonFormFieldData.applicationId = applicationId;
	           if (!isEmpty(formData)) {  
	        	   jsonFormFieldData.applicationProgramId = formData.applicationProgramId;
	        	   var applicationProgramAdmissionDetails = new Object();
	               if(formData.isOfferType=="true") {
	            	   applicationProgramAdmissionDetails.offerType = "FIRM";
	               }
	               if(formData.isOfferType=="false") {
	            	   applicationProgramAdmissionDetails.offerType = "PROVISIONAL";
	               }
	               
	               var applicableConditionInfo = new Array();
            	   if (!isNullOrEmpty(formData["dliAdmApplicableAdmissionCondition"])) {
                   	if(!isArray(formData["dliAdmApplicableAdmissionCondition"]))
                       {
                       formData["dliAdmApplicableAdmissionCondition"] = [formData["dliAdmApplicableAdmissionCondition"]];
                       }
                       var isApplicableConditionArray = isArray(formData["dliAdmApplicableAdmissionCondition"]);
                       var isAdditionalConditionArray = [];
                       var isDateOfSatisfactionArray = [];
                       if(formData["txtAdmAdditionlConditions"] != undefined) {
                       	 if(!isArray(formData["txtAdmAdditionlConditions"]))
                            {
                            formData["txtAdmAdditionlConditions"] = [formData["txtAdmAdditionlConditions"]];
                            }
                       	isAdditionalConditionArray = isArray(formData["txtAdmAdditionlConditions"]);
                       }
                       if(formData["admDateOfSatisfactionCondition"] != undefined) {
                      	 if(!isArray(formData["admDateOfSatisfactionCondition"]))
                           {
                           formData["admDateOfSatisfactionCondition"] = [formData["admDateOfSatisfactionCondition"]];
                           }
                      	isDateOfSatisfactionArray = isArray(formData["admDateOfSatisfactionCondition"]);
                      }
                       if (isApplicableConditionArray || isAdditionalConditionArray || isDateOfSatisfactionArray) {
                           for (var i = 0; i < formData["dliAdmApplicableAdmissionCondition"].length; i++) {
                           	if(!isNullOrEmpty(formData["dliAdmApplicableAdmissionCondition"][i])){
                           		var obj = new Object();
                           	    var modes2 = {
              						"id": applicantProfile.getPersonId()
              						}
              	                   obj.applicantPerson =  modes2;
                                   obj.admissionCondition = $this.getIdValueJson(formData["dliAdmApplicableAdmissionCondition"][i]);
                                   if(formData["txtAdmAdditionlConditions"] != undefined){
                                   	obj.additionalCondition = formData["txtAdmAdditionlConditions"][i];
                                   }
                                   if(formData["admDateOfSatisfactionCondition"] != undefined){
                                   	obj.conditionSatisfactionDate = formData["admDateOfSatisfactionCondition"][i];
                                   }
                                   applicableConditionInfo.push(obj);
                           	}
                         }
                       } else {
                           var obj = new Object();
                           if(!isNullOrEmpty(formData["dliAdmApplicableAdmissionCondition"])){
                        	   var modes2 = {
                						"id": applicantProfile.getPersonId()
                        	   }
                	           obj.applicantPerson =  modes2;
                               obj.admissionCondition = $this.getIdValueJson(formData["dliAdmApplicableAdmissionCondition"][i]);
                               obj.additionalCondition = formData["txtAdmAdditionlConditions"];
                               obj.conditionSatisfactionDate = formData["admDateOfSatisfactionCondition"];
                               applicableConditionInfo.push(obj);
                           }
                       }
                      
                       jsonFormFieldData.admissionConditionIds = applicableConditionInfo;
                   }
            	   
	            	   var documentArray = [];
	            	   if(!isNullOrEmpty(formData.dliAdmdocumentApplicable)){
	            		   if(typeof formData.dliAdmdocumentApplicable == "object"){
	   	               			Ext.each(formData.dliAdmdocumentApplicable, function(currentDocumentId){
	   	               				if(!isNullOrEmpty(currentDocumentId)){
		   	               				var singleDocumentArray = new Object();
		   	               				singleDocumentArray.id = currentDocumentId.data.id;
		   	               				singleDocumentArray.code = currentDocumentId.data.code;
		   	               				singleDocumentArray.value = currentDocumentId.data.value;
		   	               				documentArray.push(singleDocumentArray);
	   	               				}
	   	               			});
	   	           			}
	   	           			else{
	   	           				if(!isNullOrEmpty(formData.dliAdmdocumentApplicable)){
	   	           					documentArray.push(formData.dliAdmdocumentApplicable);
	   	           				}
	   	           			}
	   	           	   }
	            	   jsonFormFieldData.applicableDocuemntIds = documentArray;
	               applicationProgramAdmissionDetails.escalationRequired = formData.isEscalationRequired;
	               applicationProgramAdmissionDetails.approvalRequiredBy = formData.isRegistrarEqu;
	               applicationProgramAdmissionDetails.escalationComments = appConditionReviewDetail.down('#txtAdmEscalationCommentsItemId').getValue();
	               if(formData.isEscalationRequired=="true") {
	            	   var users = new Object();
	            	   users.id = formData.dliAdmAssignTo;
	            	   applicationProgramAdmissionDetails.users = users;
	               }
	              
	               jsonFormFieldData.applicationProgramAdmissionDetails = applicationProgramAdmissionDetails;
	               
	           }
	           return jsonFormFieldData;
	       },
		   setAdmissionConditionReviewFormValues: function(form,record,applicationProgramStatus) {
			   var $this = this;
    		   var offerType = record.offerType;
    		   var txtAdmassignedToItemId = form.down('#txtAdmassignedToItemId');
    		   var applicationProgramId = form.down('#applicationProgramId');
    		   var applicableAdmissionCondition = form.down('#dliAdmApplicableAdmissionConditionItemId');
    		   var documentApplicable = form.down('#dliAdmdocumentApplicableItemId');
    		   var offerTypeStatus = false;
    		   var applicantProfile = $this.getContentPanelActiveTab();
               var appConditionReviewDetail =  applicantProfile.down('applicationconditionsreviewdetails');
    		   var userId=this.getCurrentlyLoggedInUser();
    		   /*if(!isNullOrEmpty(record.users) && record.users.id == userId.id && !isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus=="ESCALATED"){
    			   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true); 
    		   } else {
    			   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false); 
    		   }*/
			   if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'OFFER_LETTER_ACCEPTED') {
				   form.down('#txtAdmassignedToItemId').setReadOnly(true);
				   form.down('#rbnAdmFinalApprovalRequireItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').allowBlank = true;
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setFieldLabel(
					   form.down('#dliAdmApplicableAdmissionConditionItemId').fieldLabel.replace(/\*$/, '')
				   );
				   form.down('#txtAdmdditionlConditionsItemId').setReadOnly(true);
				   form.down('#admDateOfSatisfactionConditionItemId').setReadOnly(true);
				   form.down('#addConditionBtn').setDisabled(true);
				   form.down('#dliAdmdocumentApplicableItemId').setReadOnly(true);
				   appConditionReviewDetail.down('#txtAdmEscalationCommentsItemId').setReadOnly(false);
				   if (form.down('#rbnAdmEscalationRequiredItemId')) {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
				   } else {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
				   }
			   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATION_AFTER_ACCEPTANCE') {
				   form.down('#txtAdmassignedToItemId').setReadOnly(true);
				   form.down('#rbnAdmFinalApprovalRequireItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').allowBlank = true;
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setFieldLabel(
					   form.down('#dliAdmApplicableAdmissionConditionItemId').fieldLabel.replace(/\*$/, '')
				   );
				   form.down('#txtAdmdditionlConditionsItemId').setReadOnly(true);
				   form.down('#admDateOfSatisfactionConditionItemId').setReadOnly(true);
				   form.down('#addConditionBtn').setDisabled(true);
				   form.down('#dliAdmdocumentApplicableItemId').setReadOnly(true);
				   form.down('#rbnAdmEscalationRequiredItemId').setReadOnly(false);
				   appConditionReviewDetail.down('#txtAdmEscalationCommentsItemId').setReadOnly(false);
				   if (!isNullOrEmpty(record.users) && record.users.id == userId.id) {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
				   } else {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
				   }
			   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATED_OFFER_REVIEWED_AFTER_ACCEPTANCE') {
				   form.down('#txtAdmassignedToItemId').setReadOnly(true);
				   form.down('#rbnAdmFinalApprovalRequireItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setReadOnly(true);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').allowBlank = true;
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setFieldLabel(
					   form.down('#dliAdmApplicableAdmissionConditionItemId').fieldLabel.replace(/\*$/, '')
				   );
				   form.down('#txtAdmdditionlConditionsItemId').setReadOnly(true);
				   form.down('#admDateOfSatisfactionConditionItemId').setReadOnly(true);
				   form.down('#addConditionBtn').setDisabled(true);
				   form.down('#dliAdmdocumentApplicableItemId').setReadOnly(true);
				   form.down('#rbnAdmEscalationRequiredItemId').setReadOnly(true);
				   form.down('#rbnAdmEscalationRequiredItemId').items.items[0].setValue(false);
				   form.down('#rbnAdmEscalationRequiredItemId').items.items[1].setValue(true);
				   form.down('#dliAdmAssignToItemId').setVisible(false);
				   form.down('#dliAdmAssignToItemId').allowBlank = true;
				   appConditionReviewDetail.down('#txtAdmEscalationCommentsItemId').setReadOnly(true);
				   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
			   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATED') {
				   form.down('#txtAdmassignedToItemId').setReadOnly(false);
				   form.down('#rbnAdmFinalApprovalRequireItemId').setReadOnly(false);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').setReadOnly(false);
				   form.down('#dliAdmApplicableAdmissionConditionItemId').allowBlank = false;
				   form.down('#txtAdmdditionlConditionsItemId').setReadOnly(true);
				   form.down('#admDateOfSatisfactionConditionItemId').setReadOnly(false);
				   form.down('#addConditionBtn').setDisabled(false);
				   form.down('#dliAdmdocumentApplicableItemId').setReadOnly(false);
				   form.down('#rbnAdmEscalationRequiredItemId').setReadOnly(false);
				   appConditionReviewDetail.down('#txtAdmEscalationCommentsItemId').setReadOnly(false);
				   if (!isNullOrEmpty(record.users) && record.users.id == userId.id) {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
				   } else {
					   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
				   }
			   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATED_OFFER_REVIEWED') {
				   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
			   }
    		   
    		   form.down('radiogroup[itemId=rbnAdmEscalationRequiredItemId]').on('change', function(radio) {
                   var form = radio.up('form');
                   var radioValue = radio.getValue();
                   var dliAdmAssignToItemId = form.down('#dliAdmAssignToItemId');
				   if (radioValue.isEscalationRequired === "true") {
					   dliAdmAssignToItemId.setVisible(true);
					   dliAdmAssignToItemId.allowBlank = false;
					   form.getForm().isValid();
					   form.getForm().checkValidity();

					   if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'OFFER_LETTER_ACCEPTED') {
						   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
					   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATED') {
						   if (!isNullOrEmpty(record.users) && record.users.id == userId.id) {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
						   } else {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
						   }
					   }
				   } else if (radioValue.isEscalationRequired === "false") {
					   dliAdmAssignToItemId.setVisible(false);
					   dliAdmAssignToItemId.allowBlank = true;
					   dliAdmAssignToItemId.reset();
					   form.getForm().isValid();
					   form.getForm().checkValidity();

					   if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'OFFER_LETTER_ACCEPTED') {
						   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
					   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATED') {
						   if (!isNullOrEmpty(record.users) && record.users.id == userId.id) {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
						   } else {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
						   }
					   } else if (!isNullOrEmpty(applicationProgramStatus) && applicationProgramStatus == 'ESCALATION_AFTER_ACCEPTANCE') {
						   if (!isNullOrEmpty(record.users) && record.users.id == userId.id) {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(true);
						   } else {
							   appConditionReviewDetail.down('#pAdmConReviewSubmitBtn').setVisible(false);
						   }
					   }
				   }
                });

    		   if(!isNullOrEmpty(record.users)) {
    			   txtAdmassignedToItemId.setValue(record.users.value);
    		   }
    		   applicationProgramId.setValue(record.applicationProgram.id);
    		   if(offerType == "FIRM"){
    			   offerTypeStatus = true;
    			   form.down('#isOfferType').setValue(true);
    		   }
    		   if(offerType == "PROVISIONAL"){
    			   offerTypeStatus = false;
    			   form.down('#isOfferType').setValue(false);
    		   }
    		   
    		   if(typeof record.conditionApplicable == "boolean"){
    			   if(record.conditionApplicable) {
    				   applicableAdmissionCondition.getStore().proxy.extraParams = {
    					   offerType:offerTypeStatus 
                    };
    				   
    				   if(record.admissionConditionDetail.length>0){
	    					var data = [];
	    					for (var i = 0; i < record.admissionConditionDetail.length; i++) {
	    						if(!isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition) && !isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition.id)) {
	    							data.push(record.admissionConditionDetail[i]);
	    						}
	    					}
	    					applicableAdmissionCondition.getStore().load();
	    					if(!isNullOrEmpty(data) && data.length>0){
		    					for (var i = 0; i < data.length; i++) {
		    						var applicableAdmissionPanel = form.down('#applicableAdmissionReviewPanelId');
		    						var formContainer = applicableAdmissionPanel.getComponent(i);
		    						formContainer.down('#dliAdmApplicableAdmissionConditionItemId').setValue(data[i].admissionCondition.id);
		    						if(!isNullOrEmpty(data[i].additionalCondition)) {
		    							formContainer.down('#txtAdmdditionlConditionsItemId').setValue(data[i].additionalCondition);
		    						}
		    						if(!isNullOrEmpty(data[i].conditionSatisfactionDate)) {
		    							formContainer.down('#admDateOfSatisfactionConditionItemId').setValue(dateRender(data[i].conditionSatisfactionDate));
		    						}
		    						if (i < (data.length - 1)) {
		    							$this.addMultipleConditionForReviewScreen(form);
		    						}
		    					}
	    					}
	    				}
    				   
    				   documentApplicable.getStore().proxy.extraParams = {
    					   isApplicableForStudent:true 
                       };
    				   if(record.admissionConditionDetail.length>0){
    					   documentApplicable.getStore().load({
               				callback: function(records, operation, success) {
               					if (success) {
               						var documentArray = [];
               						if(records.length > 0){
               							record.admissionConditionDetail.forEach(function(documentObj){
               								if(!isNullOrEmpty(documentObj.documentType)) {
               								var result = records.filter(function (obj) {
               									  return obj.data.id === documentObj.documentType.id;
               									})[0];
               								documentArray.push(result);
               								}
               							});
               							documentApplicable.setValue(documentArray);
               						}
               					}
               				}
               	        });
       				}	
    				   
    			   }
    		   }
			   if (!isNullOrEmpty(record.approvalRequiredBy)) {
				   if (record.approvalRequiredBy == true) {
					   form.down('#rbnAdmFinalApprovalRequireItemId').items.items[0].setValue(true);
					   form.down('#rbnAdmFinalApprovalRequireItemId').items.items[1].setValue(false);
				   } else {
					   form.down('#rbnAdmFinalApprovalRequireItemId').items.items[0].setValue(false);
					   form.down('#rbnAdmFinalApprovalRequireItemId').items.items[1].setValue(true);
				   }
			   }
       },
       getRenderApplicationProgramWiseConditionsForAdmission : function(){
	    	var me = this;
	    	var grid  =me.getContentPanel().getActiveTab().down('applicationprogramwiseconditionsadmissionadmgrid');
	    	if(portalId==6){
	    		var applicantProfile = 	me.getContentPanel().items.items[0];
	    		var form = me.getContentPanel().getActiveTab();
	    	}else{
	    		var applicantProfile = me.getContentPanelActiveTab();
	    		var form = me.getContentPanel().getActiveTab().down('applicationprogramwiseconditionsforadmission');
	    	}
	    	if (applicantProfile) {
	    		if(!isNullOrEmpty(applicantProfile.getApplicationId())){
	    			grid.getStore().load({
	    				params: {
	    					applicationID: applicantProfile.getApplicationId(),
	    					isIssuedAndAccepted:true
	    				},
	    				callback: function(record, operation, success) {
	    					if (success) {
	    						if(record.length>0) {
	    							var sm = grid.getSelectionModel();
	    					        sm.suspendEvents();   
	    							grid.getSelectionModel().select(grid.getStore().getAt(0));
	    							sm.resumeEvents();
	    							if(portalId==6){
	    							form.down('#admPWCSubmitBtn').setVisible(false);
	    							}else{
	    								form.down('#admPWCSubmitBtn').setVisible(true);
	    							}
	    							form.down('#applicantPWConditionsAdminAdmDocumentGridItemId').setVisible(true);
	    							form.down('#applicantListofApplicableConditionsAdmgridItemId').setVisible(true);
	    							form.down('#formFieldContainerItemId').setVisible(true);
	    						}else{
	    							form.down('#admPWCSubmitBtn').setVisible(false);
	    							form.down('#applicantPWConditionsAdminAdmDocumentGridItemId').setVisible(false);
	    							form.down('#applicantListofApplicableConditionsAdmgridItemId').setVisible(false);
	    							form.down('#formFieldContainerItemId').setVisible(false);
	    						}
	    					}
	    				}
	    			});

	    			grid.getStore().on('beforeload', function(store, operation) {
	    				var applicationId = applicantProfile.getApplicationId();
	    				store.proxy.extraParams = {
	    						applicationID:applicationId ,
	    						isIssuedAndAccepted:true
	    				};
	    			});
	    		}
	    	}             
	    },
        /**
         * upload document form
         */
	    uploadDocumentAdmApplicantFormWindow : function(){
        	var this$ = this;
        	var form = null;
            var personProfile = this$.getContentPanelActiveTab();
            var grid = personProfile.down('#applicantPWConditionsAdminAdmDocumentGridItemId');

            if (grid.getSelectionModel().getCount() > 0) {
            	var records = grid.getSelectionModel().getSelection()[0];
            	if(!isEmpty(records)){
            			var documentId = records.get("id");
            			this$.getAdmApplicantProfileDocumentController().showDocumentFormWindow('applicantConditionProgramDocumentForm', 'EXT_DOCUMENT');
            			form = this$.getAdmApplicantProfileDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
            			form.down('#documentTypeRadioGroup').setReadOnly(true);
            			if(!isNullOrEmpty(records.get('submissionDate'))){
            				form.down('#submissionDate').setValue(dateRender(records.get('submissionDate')));
            			}
            			else{
            				form.down('#submissionDate').setValue(new Date());
            			}
            			//container hiding
            			form.down('#modeReturnContainer').setVisible(false);
            			form.down('#modeReturnContainer').setVisible(false);
            			form.down('#returnableContainer').setVisible(false);
            			form.down('#inspectionDateContainer').setVisible(false);
            			form.down('#inspectionRequiredContainer').setVisible(false);
            			form.down('#documentTypeContainer').setVisible(false);
            			
            			form.down('#documentNoteId').setVisible(false);
            			
            			form.down('#modeOfSubmission').setDisabled(false);
            			form.down('#modeOfSubmission').setValue('ONLINE');
            			form.down('#modeOfSubmission').setReadOnly(true);
            			
            			form.down('#documentTypeRadioGroup').setVisible(false);
            			form.down('#responsibleUserField').setVisible(false);
            			form.down('#documentTypeCombo').setValue(records.data.documentTypeValue);
            			form.down('#documentTypeCombo').setReadOnly(true);
            			form.down('#inspectionRequiredRadioGroupField').setVisible(false);
            			form.down('#inspectionDoneRadioGroupField').setVisible(false);
            			
            			form.down('#inspectionDateField').setVisible(false);
            			form.down('#inspectionDoneByField').setVisible(false);
            			form.down('#returnDateField').setVisible(false);
            			form.down('#returnByField').setVisible(false);
            			form.down('#returnableRadioGroup').setVisible(false);
            			form.down('#modeOfReturnField').setVisible(false);
            			form.down('#returnedToUserField').setVisible(false);
            			form.down('#lastDateSubmissionId').setVisible(false);
            			form.up('window').setHeight(form.getHeight()+90);
            			var documentTypeCombo = form.down('#documentTypeCombo');
            			documentTypeCombo.getStore().load({
     					   callback: function(record, operation, success) {						 
       						   for(var i in record){
       							   if(record[i].data.id==records.data.documentTypeId){
       								documentTypeCombo.setValue(record[i].data.id);  								
       							   }
       						   }
       					   }	   
       				   });
            			var documentStatusCSM = form.down('#documentStatus');
            			documentStatusCSM.getStore().load({
            				callback: function(record, operation, success) {						 
            					for(var i in record){
            						if(record[i].data.code=="SUBMITTED"){
            							documentStatusCSM.setValue(record[i].data.id);  
            						}
            					}
            				}	   
            			});
            			
            	}
            	}
             else {
                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            }
        	
        },
        /**
	     * Get document controller
	     */
	    getAdmApplicantProfileDocumentController : function(){
	    	var this$ = this;
	    	return this$.getController('Academia.controller.document.DocumentController');
	    },
	    /**
	     * Save document form
	     */
	    saveApplicantConditionalAdmProgramDocumentForm: function(){
	    	var this$ = this;
	    	var successMsg;
	    	var personProfile = this$.getContentPanelActiveTab();
	        var grid = personProfile.down('#applicantPWConditionsAdminAdmDocumentGridItemId');
	        var applicantProfile= this$.getApplicantprofile();
	    	var personObj = this$.getPersonObj();
	    	var isTransient = false;
	    	var module = 'applicant';
	    	var entityId = applicantProfile.applicationId;
	    	var entityType = 'applicant';
	    	var form = this$.getAdmApplicantProfileDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
	    	var uploadBtn=form.down('#uploadFileField');
	    	var records = grid.getSelectionModel().getSelection()[0];
	    	if(!uploadBtn.isVisible() && !records.get('isElectronic')){
	    		var isPhysicalFile=form.down('#physicalField');
	        	isPhysicalFile.setValue(true);
	    	}
	    	form.down('#modeOfReturnField').setDisabled(true);
			form.down('#returnedToUserField').setDisabled(true);
			form.down('#modeOfReturnField').allowBlank=true;
			form.down('#returnedToUserField').allowBlank=true;
			form.down('#modeOfReturnField').setVisible(false);
			form.down('#returnedToUserField').setVisible(false);
			this$.getAdmApplicantProfileDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
	    			if(success){
	    				var documentJson = new Object();
	    				if(isCallBackTransient == false){
	    					var form = this$.getAdmApplicantProfileDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
	    					var id = form.down('#document_hidden_field');
	    					if (isNullOrEmpty(id.getSubmitValue())) {
	    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
	    					}else{
	    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');

	    					}
	    					var documentId = Ext.JSON.decode(response.responseText);
	    					var docType = form.down('#documentTypeCombo').getValue();
	    					documentJson.id =  records.get("id");
	    					documentJson.documentTypeId = docType;
	    					documentJson.documentId = documentId;
	    					documentJson.applicationId = applicantProfile.applicationId;
	    					documentJson.currentDocumentStatus = records.get("status");
	    					var documentStatus = form.down('#documentStatus').getValue();
	    					var isInspectionRequiredYes = form.getValues().isInspectionDone;
	    					if(isInspectionRequiredYes==true){
	    						documentJson.isInspectionRequiredYes=isInspectionRequiredYes;
	    					}
	    					if(!isNullOrEmpty(documentStatus)) {
	    						documentJson.documentStatusCSM = {
	    								id: documentStatus
	    						};
	    					}
	    					this$.applyWindowMask(); 
	    					Ext.Ajax.request({
	    						type: 'rest',
	    						url: SERVERURL.APPLICANT_DOCUMENTS_UPDATE,
	    						jsonData: documentJson,
	    						method: 'PUT',
	    						success : function(){
	    							this$.hideWindowMask();
	    							this$.getAdmApplicantProfileDocumentController().closeDocumentFormWindow();
	    							grid.getStore().reload();
	    							grid.getSelectionModel().deselectAll();
	    							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
	    							this$.mixins.ApplicationBaseController.getApplicantProfileInformation(applicantProfile);
	    						}
	    					});
	    				}
	    			}
	        		
	        	}, isTransient);
			},
			saveAdmApplicantProgramWiseCondition: function(obj){
        		var $this = this;
        		var programWiseConditionForm = obj.up('form');
				var applicableConditionGrid = programWiseConditionForm.down('#applicantListofApplicableConditionsAdmgridItemId');
				var applicableConditionGridStore = applicableConditionGrid.getStore();
				var ApplicantProgramQulGrid = programWiseConditionForm.down('#applicationProgramWiseConditionsAdmissionAdmGridItemId');
				var ApplicantProgramQulGridStore = ApplicantProgramQulGrid.getStore();
				var flagIsSave = true;
				
				var form =   $this.getApplicationprogramwiseconditionsforadmission();
					if(flagIsSave){
						var putItems = [];
						var count = 1;
						var applicantProfile = $this.getContentPanelActiveTab();
						applicableConditionGridStore.data.items.forEach(function(itemObj){
							if(!isNullOrEmpty(itemObj.data.admissionConditionId)){
								var modes = {
										'id': itemObj.data.admissionConditionId,
										'value': itemObj.data.admissionConditionValue,
										'code': itemObj.data.admissionConditionCode,
										'sequence': null
								}
							}
							var modes1 = {
									"id": itemObj.data.applicationProgramAdmissionDetails.id,
									'value': null,
									'code': null,
									'sequence': null
							}
							var modes2 = {
									"id": applicantProfile.getPersonId(),
									'value': null,
									'code': null,
									'sequence': null
							}
							putItems.push({
								'id': itemObj.data.id,
								'applicantPerson':modes2,
								'admissionCondition': modes,
								'conditionCheck':itemObj.data.conditionCheck,
								'saqaTrackingNumber':itemObj.data.saqaTrackingNumber,
								'applicationProgramAdmissionDetails':modes1,
								"documentType": null,
								'conditionSatisfactionDate':itemObj.data.conditionSatisfactionDate
							});
							count = count+1;
						});
		        		var submitData;
		        		var submitUrl;
		        	  submitUrl = SERVERURL.PATH_UPDATE_APPLICABLE_ADMISSION_CONDITION_STATUS; 
		        	  submitData = Ext.encode(putItems);
		       		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		       	 	  Ext.Ajax.request({
		       			  type : 'rest',
		       			  url : submitUrl,
		       			  jsonData : submitData,
		       			  method : 'POST',
		       			  success : function(response, action) {
		       				  Ext.getBody().unmask();
		       				 showSuccessMessage(getPersonModuleTranslation('PROGRAM_WISE_CONDITIONS_FOR_ADMISSION'), getCommonTranslation('DETAILS_SUCCESSFULLY_SAVED_MSG'));
		       			  },
		                  failure: function(form, action) {
		                	  Ext.getBody().unmask();
		                    	var data = Ext.decode(form.responseText);
		                    }
		       	 	  });
					}
        	
			},
			loadDFRForEscalationRequred: function(rbnAdmEscalationRequired){
			   	var $this = this;
			    var form = $this.getContentPanel().getActiveTab().down('admissionconditionsreviewadmform');
			   	var dliAdmAssignTo = form.down('#dliAdmAssignToItemId');
			   	Ext.Ajax.request({
			   		type: 'rest',
			   		async: false,
			   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
			   		params: {
			   			screenName: 'admissionconditionsreviewadmform',
			   			academyLocationId: this.getCurrentAcademyLocation(),
			   			languageCode:'en'
			   		},
			   		method: 'GET',
			   		success: function(res, action) {
			   			var response = Ext.decode(res.responseText);
			   			if( Object.keys(response).length > 0 ){
			   				var records=response.admissionconditionsreviewadmform;
			   				for(i in records){
			   					if(records[i].formFieldId=='rbnAdmEscalationRequiredItemId' && records[i].isVisible==false){
			   						rbnAdmEscalationRequired.setVisible(false);
			   						dliAdmAssignTo.setVisible(false);
			   						dliAdmAssignTo.allowBlank = true;
			   						break;
			   					}else{
			   						rbnAdmEscalationRequired.setVisible(true);
			   						if(rbnAdmEscalationRequired){
			   							dliAdmAssignTo.setVisible(true);
			   						}else{
			   							dliAdmAssignTo.setVisible(false);
			   						}
			   					}
			   				}
			   			}
			   		}
			   		
			   	});
			 },
			loadDFRForAdmissionApprovedOn: function(admissionApprovedOn){
			   	var $this = this;
			   	Ext.Ajax.request({
			   		type: 'rest',
			   		async: false,
			   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
			   		params: {
			   			screenName: 'approveadmissionprogramform',
			   			academyLocationId: this.getCurrentAcademyLocation(),
			   			languageCode:'en'
			   		},
			   		method: 'GET',
			   		success: function(res, action) {
			   			var response = Ext.decode(res.responseText);
			   			if( Object.keys(response).length > 0 ){
			   				var records=response.approveadmissionprogramform;
			   				for(i in records){
			   					if(records[i].formFieldId=='admissionApprovedOn' && records[i].isVisible==true){
			   						admissionApprovedOn.setVisible(true);
			   						admissionApprovedOn.setValue(new Date());
			   						
			   					}
			   					
			   				}
			}
			   		}
			   		
			   	});
			   	
			 },
			 linkStudentIdupdate: function(applicationId,studentCode){
				   	var $this = this;
				   	var submitData= {
							   "studentId": studentCode,
							   "applicationId": applicationId,
							   
					   };
				   	Ext.Ajax.request({
				   		type: 'rest',
				   		async: false,
				   		url: SERVERURL.PATH_UPDATE_APPLICATIONS,
		       			jsonData : submitData,
				   		method: 'POST',   
				   		success: function(res, action) {}
				   		
				   	});
				   	
				 },

			 approveAdmissionCall: function(url,me,grid,window,admissionType,successMessage){
				 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				Ext.Ajax.request({
                    type: 'rest',
                    url: url,
                    method: 'GET',
                    headers: {
                      'Content-Type': 'application/json'
                    },
                    /*params: {
                        id: admissionId
                    },*/
                    success: function(form, action) {
                        grid.getStore().reload();
                        me.hideWindowMask();
                        Ext.getBody().unmask();
                        grid.getSelectionModel().deselectAll();
                        window.close();
                        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                        if (admissionType === me.APPROVE) {
                        	showSuccessMessage(getCommonTranslation('APPROVE_ADMISSION'), successMessage);
                        }else if (admissionType === me.REJECT) {
                        	showSuccessMessage(getCommonTranslation('REJECT_ADMISSION'), successMessage);
                        }else{
                        	showSuccessMessage(getCommonTranslation('SUCCESS'), successMessage);	
                        }
                        var applicantProfile = me.getContentPanelActiveTab();                      
                        if (applicantProfile) {
                        	var applicationId=applicantProfile.getApplicationId();
                        	me.closeAllTabsExceptPersonInfoTab(applicantProfile);
                        	me.setPermissionAccordingToStatus(applicantProfile);
                        	me.mixins.ApplicationBaseController.loadApplications(applicationId);                                	                                	
                            me.mixins.ApplicationBaseController.gettingDataInSummaryGridExpand(applicantProfile);
                        }
                        setTimeout(function(){
                        	Ext.getBody().unmask();
                        },10000);
                    },
                    failure: function(form, action) {/*
                    	var data = Ext.decode(form.responseText);
                    	if(data[0].key == 'document_not_submitted'){
                    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_SUBMITTED')); 
                    	}else if(data[0].key == 'ADMISSION_COMMITMENT_FEE_NOT_PAID'){
                    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ADMISSION_COMMITMENT_FEE_NOT_PAID')+' '+data[0].messageParams[0]); 
                    	}else if(data[0].key == 'SEAT_CAPACITY_FULL'){
                    		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('SEAT_CAPACITY_FULL')); 
                    	}else if(data[0].key == 'submit_characteristics_document'){
                    		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('submit_characteristics_document')); 
                    	}
                    */} 
                });
			},
			addMultipleConditionForReviewScreen:function(form){
		    	   var $this = this;
			   	   
			   	   var stopContiner = form.down('#applicableAdmissionReviewPanelId');
			   	   var formFieldContainer = stopContiner.items.items[0];
			   	   var isConditionAllowBlank = formFieldContainer.down('#dliAdmApplicableAdmissionConditionItemId').allowBlank;
			   	   var isConditionHidden = formFieldContainer.down('#dliAdmApplicableAdmissionConditionItemId').hidden;
			   	   var conditionFieldLabel = formFieldContainer.down('#dliAdmApplicableAdmissionConditionItemId').fieldLabel;
			   	   if(!conditionFieldLabel.includes(":")) {
			   		   conditionFieldLabel = conditionFieldLabel+':';
			   	   }
			   	   if(!isConditionAllowBlank && !conditionFieldLabel.includes("*")) {
			   		   conditionFieldLabel = conditionFieldLabel+'<span class="required" style="color:red"> *</span>';
			   	   }
			   	   
			   	   var isAddConditionAllowBlank = formFieldContainer.down('#txtAdmdditionlConditionsItemId').allowBlank;
			   	   var isAddConditionHidden = formFieldContainer.down('#txtAdmdditionlConditionsItemId').hidden;
			   	   var addconditionFieldLabel = formFieldContainer.down('#txtAdmdditionlConditionsItemId').fieldLabel;
			   	   if(!addconditionFieldLabel.includes(":")) {
			   		   addconditionFieldLabel = addconditionFieldLabel+':';
			   	   }
			   	   if(!isAddConditionAllowBlank && !addconditionFieldLabel.includes("*")) {
			   		   addconditionFieldLabel = addconditionFieldLabel+'<span class="required" style="color:red"> *</span>';
			   	   }
			   	   
			   	   var isDateOfSatisfactionAllowBlank = formFieldContainer.down('#admDateOfSatisfactionConditionItemId').allowBlank;
			   	   var isDateOfSatisfactionHidden = formFieldContainer.down('#admDateOfSatisfactionConditionItemId').hidden;
			   	   var dateOfSatisfactionFieldLabel = formFieldContainer.down('#admDateOfSatisfactionConditionItemId').fieldLabel;
			   	   if(!dateOfSatisfactionFieldLabel.includes(":")) {
			   		   dateOfSatisfactionFieldLabel = dateOfSatisfactionFieldLabel+':';
			   	   }
			   	   if(!isDateOfSatisfactionAllowBlank && !dateOfSatisfactionFieldLabel.includes("*")) {
			   		   dateOfSatisfactionFieldLabel = dateOfSatisfactionFieldLabel+'<span class="required" style="color:red"> *</span>';
			   	   }
			   	   
			   	   var indx = stopContiner.items.length;
			   	   var panelItem = new Array();
				   var insertPosition=indx;
				    panelItem.push({
				   		   xtype:'fieldcontainer',
				   		   width: '100%',
				   		   layout : 'hbox',
				   		   defaults : {
				   			   labelAlign : 'top'
				   		   },
				   		   items : [{
				   			   xtype: 'customcombobox',
				   			   name: 'dliAdmApplicableAdmissionCondition',
				   			   itemId: 'dliAdmApplicableAdmissionConditionItemId',
				   			   allowBlank: isConditionAllowBlank,
				   			   hidden: isConditionHidden,
				   			   fieldLabel: conditionFieldLabel,
				   			   store: Ext.create('Academia.store.admission.applicationFormSale.AdmissionConditionByOfferTypeStore'),
				   			   displayField: 'value',
				   			   valueField: 'id',
				   			   forceSelection:true,
				   			   queryParam:'qry',
				   			   editable:false,
				   			   labelSeparator : '',
				   			   width: 256,
								listeners:{
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
							},{
								xtype: 'textarea',
								name: 'txtAdmAdditionlConditions',
				     			itemId: 'txtAdmdditionlConditionsItemId',
				     			fieldLabel: addconditionFieldLabel,
				     			editable:false,
				     			readOnly: true,
				     			maxLength:2000,
				     			allowBlank: isAddConditionAllowBlank,
					   			hidden: isAddConditionHidden,
					   			labelSeparator : '',
					   			width: 256,
					   			listeners: {
		                            change:function(obj,value){
		                            	obj.getEl().dom.setAttribute('data-qtip',value);
		                            	obj.getEl().dom.style.textAlign = 'left';
		                            	obj.getEl().dom.style.overflow = 'hidden'; 
		                            	return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + value + '} </div>';
		                           }
		                        }
							},{
				        		xtype: 'datefield',
				        		fieldLabel: dateOfSatisfactionFieldLabel,
				        		name: 'admDateOfSatisfactionCondition',
								itemId: 'admDateOfSatisfactionConditionItemId',
				        		vtype: 'daterange',
				        		width: 256,
				        		listeners: {
				        			render: function(field) {
				        				return dateFormatRender(field);
				        			}
				        		},
				        		minValue: new Date(),
				        		allowBlank: isDateOfSatisfactionAllowBlank,
					   			hidden: isDateOfSatisfactionHidden,
					   			labelSeparator : ''
					   	   },{
				   			   xtype: 'button',
				   			   glyph: ICONGLYPH.DELETEGLYPH,
				   			   cls: 'CustomBodyBtnReject',
				   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
				   			   width:30,
				   			   style:{
				   				   marginTop:'23px'
				   			   },
				   			   listeners:{
				   				   click:function(obj){
				   					   var container = obj.up('fieldcontainer');
				   					   var panelContiner = form.down('#applicableAdmissionReviewPanelId');
				   					   panelContiner.remove(container);
				   					   form.getForm().checkValidity();
				   					   form.getForm().isValid();
				   					   form.getForm().clearInvalid();
				   					   var mainForm = form.up('form');
				   					   mainForm.getForm().checkValidity();
				   					   mainForm.getForm().isValid();
				   					   mainForm.getForm().clearInvalid();
				   				   }
				   			   }
				   		   }]
				   	   });
				    stopContiner.insert(insertPosition,panelItem);
			     	stopContiner.doLayout();
			     	
				    var grid = $this.getContentPanel().getActiveTab().down('applicationprogramconditionsreviewadmgrid');
				    var applicantProfile = $this.getContentPanelActiveTab();
			        var currentStatus = null;

			        if (applicantProfile) {
			            if (!isNullOrEmpty(applicantProfile.getApplicationId())) {
			                grid.getStore().load({
			                    params: {
			                        applicationID: applicantProfile.getApplicationId(),
			                        escalatedOnly: true
			                    },
			                    callback: function(record, operation, success) {
			                        if (success && record.length > 0) {
			                            currentStatus = record[0].data.currentStatus;
			                            if (currentStatus === 'OFFER_LETTER_ACCEPTED' || currentStatus === 'ESCALATION_AFTER_ACCEPTANCE' || currentStatus === 'ESCALATED_OFFER_REVIEWED_AFTER_ACCEPTANCE') {
			                            	stopContiner.items.each(function(formFieldContainer) {
			                            	     if (formFieldContainer && formFieldContainer.isContainer) {
			                            	         var applicableAdmissionConditionItem = formFieldContainer.down('#dliAdmApplicableAdmissionConditionItemId');
			                            	         var additionalConditionsItem = formFieldContainer.down('#txtAdmdditionlConditionsItemId');
			                            	         var dateOfSatisfactionItem = formFieldContainer.down('#admDateOfSatisfactionConditionItemId');
			                            	         var deleteButton = formFieldContainer.down('button');

			                            	         if (applicableAdmissionConditionItem) {
			                            	             applicableAdmissionConditionItem.setReadOnly(true);
			                            	         }
			                            	         if (additionalConditionsItem) {
			                            	             additionalConditionsItem.setReadOnly(true);
			                            	         }
			                            	         if (dateOfSatisfactionItem) {
			                            	             dateOfSatisfactionItem.setReadOnly(true);
			                            	         }
			                            	         if (deleteButton) {
			                            	             deleteButton.setDisabled(true);
			                            	         }
			                            	     }
			                            	 });
			                        }
			                    }
			                    }
			                });
			            }
			        }
			      },
			      viewSalesForceAdmissionDetailFormWindow: function() {
			      	var $this = this;
			    	var salesFourceApplicationGrid = null;
			    	var applicantProfile = $this.getContentPanelActiveTab();
			    	var salesFourceApplicationGrid = applicantProfile.down('#salesforceadmissiondetailsgridId');
			    	if (salesFourceApplicationGrid.getSelectionModel().getCount() > 0) {
			    		if (applicantProfile) {
			    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
			    					var window = $this.getApplicantsalesforceadmissiondetailswindow();
			    					if (!window) {
			    						window = Ext.widget('applicantsalesforceadmissiondetailswindow', {
			    							itemId: 'applicantsalesforceadmissiondetailswindow'
			    						});
			    					}
			    					window.show();
			    					var selectedRecord = salesFourceApplicationGrid.getSelectionModel().selected.items[0].data;
			    					var form = window.down('#applicantsalesforceadmissiondetailsformId');
			    					form.getForm().setValues(selectedRecord);
			    					$this.toggleReadOnlyFormItems(form.getForm(),true);
			    					
			    				}
			    		}

			    	}else{
			    		showWarningMessage(getCommonTranslation('SALESFORCE_ADMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
			    	}
			    },
			    getAcademicTopicIdValueJson: function(id, value) {
					if (id) return {
						id: id,
						value: value
					};
				},
				loadAcademicTopicDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
			  		var this$ = this;
			  		dependentCombo.clearValue();
			  		dependentCombo.store.removeAll();
			  		dependentCombo.reset();
			  		var store = dependentCombo.getStore();
			  		var id = comboValue;
			  		if (id!=null) {
			  			var url = store.getProxy().proxyConfig.api.read;
			  			if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
			  				url = url.concat('?' + parameter + '=' + id);
			  			} else {
			  				url = url.concat('?' + parameter + '=' + id);
			  				url = url.concat('&' + extraParameter + '=' + extraParamValue);
			  			}
			  			store.getProxy().api.read = url;
			  			store.load();
			  		}
			  	},
			  	saveApplicantDocumentAndNotes:function(gridItemId, saveUrl, updateUrl){
			        var this$ = this;
			        var window = this$.getDocumentAndNotesFormWindow();
			        var form = window.down('#documentAndNotesForm');
			        var isPublished=form.down('#public').getValue();
			        var applicantProfile = this$.getContentPanelActiveTab();
			        var grid = applicantProfile.down(gridItemId);
			        var records= grid.getSelectionModel().getSelection();
		        	var loggedInUserId=this$.getCurrentlyLoggedInUser().id;
					var submitBtn = form.down("#submitButtonId");
			        var values=form.getForm().getValues();

					if(submitBtn) 
					{
						submitBtn.disable();	
					}
			        var periodId=null;
			        var submitUrl, isUpdate = false;
			        var id = form.down('#documentAndNotesFormHiddenId');
			        if (isNullOrEmpty(id) || isNullOrEmpty(id.getSubmitValue())) {
			            submitUrl = SERVERURL.SAVE_APPLICANT_ACADEMIC_TOPIC_DATA;
			            isUpdate = false;
			            periodId=values.period;
			        } else {
			            submitUrl = SERVERURL.UPDATE_APPLICANT_ACADEMIC_TOPIC_DATA;
			            isUpdate = true;
			            periodId=records[0].data.period.id;
			        }
					var applicationId = applicantProfile.getApplicationId();
			        
			        var documentGrid = this.getDocumentandnotesdocumentgrid();
			   	    var docStore = documentGrid.getStore();
			   	    var isUploadFlag = false;
			   	    if(docStore.getCount()) {
			   	    	isUploadFlag = true;
			   	    }
			        data={
			        	   "id":values.id,
			      		   "academicSubTopics" : this$.getAcademicTopicIdValueJson(values.academicSubTopicId),
			      		   "batch" : this$.getAcademicTopicIdValueJson(values.batch),
			      		   "period": this$.getAcademicTopicIdValueJson(periodId),
			     		   "application" : this$.getAcademicTopicIdValueJson(applicationId),
			    		   "description": values.description,
			    		   "isUploadDocument": isUploadFlag,
			    		   "createdBy": {
			    			   id: this$.getCurrentlyLoggedInUser().id
			    		   },
			    		   "updatedBy": {
			    			   id: this$.getCurrentlyLoggedInUser().id
			    		   },
			    		   "updatedAt": values.updatedDate,
			    		   "createdAt": values.createdDate,
			    		   "status": values.status,
			    		   "isPublished": isPublished
			     	   };
			            	var docArray = [];
			            	if (docStore.data.items != null && docStore.data.items.length > 0 && (documentGrid.isVisible() == true)) {
			            		var user = this$.getCurrentlyLoggedInUser();
			            		Ext.each(docStore.data.items, function(val) {
			            				if(!val.data.isEdit){
											var newData = {
													"name" : val.data.documentName!=""? val.data.documentName : val.data.name,
													"path" : val.data.path,
													"type" : "DOCUMENT",
													"id" : val.data.offlinePaymentDocumentId,
													"createdBy" : this$.getIdValueJson(
															user.id,
					             							user.value),
											};
										}else{
										var newData = {
												"name" : val.data.documentName!=""? val.data.documentName : val.data.name,
												"path" : val.data.path,
												"type" : "DOCUMENT",
												"id" : val.data.offlinePaymentDocumentId,
												"createdBy" : this$.getIdValueJson(
														user.id,
				             							user.value),
												"isEdit" : val.data.isEdit		
										};
										}
			            				docArray.push(newData);
			            			
			            		});
			            	}
			            	data.documents= docArray;
			        
			            	var urlGrid = this.getDocumentandnotesurlgrid();
			            	if(urlGrid) {
			            		var urlStore = urlGrid.getStore();
			            		var urlArray = [];
			                	if (urlStore.data.items != null && urlStore.data.items.length > 0 && (urlGrid.isVisible() == true)) {
			                		Ext.each(urlStore.data.items, function(val) {
			                				var newData = {
			                						"id" : val.data.id,
			    	             					"name" : val.data.documentName ? val.data.documentName : val.data.name,
			    	             					"path" : val.data.path,
			    	             					"type" : "DOCUMENT",
			    	             					"submissionDate":val.data.submissionDate?new Date(val.data.submissionDate):val.data.submissionDate,
			    	             					"createdBy" : this$.getIdValueJson(
			    	             							this$.getCurrentlyLoggedInUser().id,
			    	             							this$.getCurrentlyLoggedInUser().value)
			    	             			};
			                				urlArray.push(newData);
			                			
			                		});
			                	}
			                	data.applicantAcademicTopicUrl = urlArray;
			            	}
			        
			        this$.applyWindowMask(); 
			        
			        this.sendSaveAjaxRequest(submitUrl, 'POST', data, function(option, success, response) {
			        	this$.hideWindowMask();
			        	if(success) {
				        	if(response.responseText!=0){
				        		window.close();
				        		var applicationId = applicantProfile.getApplicationId();
				        		grid.getStore().getProxy().extraParams={
				        			applicationId : applicationId
				        		};
				        		var form = grid.up('form');
					        	var values = form.getForm().getValues();
					        	grid.getStore().getProxy().extraParams ={
					        		acadmicTypeId:values.academicTopicId,
					    			academicSubTypeId:values.academicSubTopicId,
					    			programId:values.programId,
					    			batchId:values.batch,
					    			periodId:values.period,
					    			applicationId:applicationId,
									userId : loggedInUserId

					    		};
					    		grid.getStore().load();
				                if (isUpdate) {
				                    showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'), getCommonTranslation('DOCUMENT_AND_NOTES_UPDATE_SUCCESS'));
				                } else {
				                    showSuccessMessage(getCommonTranslation('DOCUMENT_AND_NOTES'), getCommonTranslation('DOCUMENT_AND_NOTES_ADD_SUCCESS'));
				                }
				    		} else {
				    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_AND_NOTES_RECORD_EXIST'));
				    			setTimeout(function(){
					    			if(submitBtn) 
					    			{ 
					    				submitBtn.enable();	
					    			}
					    			},500);
				    		}
			        	}else{
			                  this$.hideWindowMask();
			                  window.close();
			                  grid.getStore().reload();
			                  submitBtn.setDisabled(false);
			        	}
			        });
			    },
			    
			    editApplicantDocumentAndNotes: function(informationType, formItemId, gridItemId) {

			        var this$ = this;
			        var applicantProfile = this$.getContentPanelActiveTab();
			        var grid = applicantProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			        	this.showFormWindow();
			        	var window = this.getDocumentAndNotesFormWindow();
			        	var filterForm = window.down('#documentAndNotesForm');
			            var records= grid.getSelectionModel().getSelection();
			            var documentGrid = window.down('documentandnotesdocumentgrid');
			            var urlGrid = window.down('documentandnotesurlgrid');
			            /*filterForm.down('#academicTopicItemId').setReadOnly(true);
			            filterForm.down('#academicSubTopicItemId').setReadOnly(true);
			            */filterForm.down('#programItemId').setReadOnly(true);
			            filterForm.down('#batchCombo').setReadOnly(true);
			            filterForm.down('#periodId').setReadOnly(true);
			             var serverUrl=SERVERURL.FIND_APPLICANT_ACADEMIC_TOPIC_BY_ID;
						 Ext.Ajax.request({
			      		 method: "GET",
			      		 type: 'rest',
			      		 url: serverUrl,
			      		 headers: {
			      			 'Content-Type': 'application/json'
			      		 },
			      		 params: {
			      			 id: records[0].data.id
			      		 },
			      		 success: function(f, action) {
			      			var data = f.responseText;
			      			var jData=Ext.JSON.decode(data);
			      			filterForm.down('#documentAndNotesFormHiddenId').setValue(jData.id);
			      			var programIdField=filterForm.down('#programItemId');
			      			programIdField.store.load({
			     				 callback: function(records, operation, success) {
									   if (success) {
										   for(var i = 0; i< records.length; i++){
											   if(records[i].data.id == jData.program.id){
												   programIdField.setValue(jData.program.id);	
												   programIdField.setDisabled(false);
											   }
										   }
									   }
			     				 }
			      			});
			      			var academicTopicIdField=filterForm.down('#academicTopicItemId');
			      			academicTopicIdField.store.load({
			     				 callback: function(records, operation, success) {
									   if (success) {
										   for(var i = 0; i< records.length; i++){
											   if(records[i].data.value == jData.academicTopics.value){
												   academicTopicIdField.setValue(jData.academicTopics.value);	
											   }
										   }
									   }
			     				 }
			      			});
			      			//academicTopicIdField.setValue(records[0].data.category);
			      			var batchIdField=filterForm.down('#batchCombo');
			      			batchIdField.getStore().getProxy().extraParams={
			      				programId:jData.program.id,
			      				applicationId: jData.application.id
			      			};
			      			batchIdField.store.load({
			     				 callback: function(records, operation, success) {
									   if (success) {
										   for(var i = 0; i< records.length; i++){
											   if(records[i].data.id == jData.batch.id){
												   batchIdField.setValue(jData.batch.id);	
												   batchIdField.setDisabled(false);
											   }
										   }
									   }
			     				 }
			      			});
			      			var periodIdField=filterForm.down('#periodId');
			      			periodIdField.getStore().getProxy().extraParams={
			      				batchId: jData.batch.id,
			      				applicationId: jData.application.id
			      			};
			      			periodIdField.getStore().load({
			      				callback:function(){
			      					periodIdField.setValue(jData.period.value);
			      					periodIdField.setDisabled(false);
			                  	}
			      			});
			      			var academicSubTopicIdField=filterForm.down('#academicSubTopicItemId');
			      			var store=academicSubTopicIdField.getStore();
			      			store.load({
                                callback: function(records, operation, success) {
                                    if (success) {
                                        for (var i in records) {
                                            if (records[i].data.id == jData.academicSubTopics.id) {
                                                academicSubTopicIdField.setValue(records[i].data.id);
                                            }
                                        }
                                        academicSubTopicIdField.setDisabled(false);
                                    }
                                }
                          });
			      			filterForm.down('#descriptionId').setValue(jData.description);
			      			filterForm.down('#uploadDocumentItemId').setValue(jData.isUploadDocument);

			      			filterForm.down('#public').setValue(jData.isPublished);
			      			filterForm.down('#updatedDate').setValue(dateRender(new Date()));
			      			filterForm.down('#createdById').setValue(jData.createdBy.code.toLowerCase() + '/' + jData.createdBy.value);
			      			filterForm.down('#createdDate').setValue(dateRender(jData.createdAt));
			      			filterForm.down('#updatedById').setValue(jData.updatedBy.code.toLowerCase() + '/' + jData.updatedBy.value);
			      			 setTimeout(function(){
			      				filterForm.down('#dateId').setValue(dateRender(new Date()));
			     			  },500);
			      			var statusField=filterForm.down('#status');
			      			statusField.getStore().getProxy().extraParams={
			      				id:jData.batch.id
			      			};
			      			statusField.getStore().load({
			      				callback:function(){
			      					statusField.setValue(jData.status);
			                  	}
			      			});
			       		 }
					 });
			        } else {
			            showWarningMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    viewApplicantDocumentAndNotes:function(informationType, formItemId, gridItemId){

			  	  var this$ = this;
			  	  var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			  	      this$.editApplicantDocumentAndNotes(informationType, formItemId, gridItemId);
			  	    var window = this$.getDocumentAndNotesFormWindow();
		        	var form = window.down('#documentAndNotesForm');
			  	      form.down('#academicTopicDocument').setVisible(false);
			  	      form.down('#academicTopicDocumentUrl').setVisible(false);
			  	      var UrlGrid = this$.getDocumentandnotesurlgrid();
			  	      var DocGrid = this$.getDocumentandnotesdocumentgrid();
			  	      DocGrid.down('#btnDelete').setDisabled(true);
			  	      UrlGrid.down('#btnDelete').setDisabled(true);
			  	      DocGrid.down('#btnEdit').setVisible(false);
			  	      UrlGrid.down('#btnEdit').setVisible(false);
			  	        form.down('#submitButtonId').setVisible(false);
			           form = form.getForm();
			           toggleReadOnlyFormItems(form, true);
			        } else {
			      	  showWarningMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    
			    },

			    deleteApplicantDocumentAndNotes:function(gridItemId, deleteUrl) {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'), getCommonTranslation('DOCUMENTS_AND_NOTES_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        var flag=false;
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl+'?id='+id,
			                                async:false,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                success: function(form, action) {
			                              	  flag=true;
			                                  }
			                            });
			                        }
			                        if(flag) {
			                        grid.getStore().reload();
			                        showSuccessMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'), getCommonTranslation('DOCUMENTS_AND_NOTES_DELETE_SUCCESS')); 
			                      	  }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('DOCUMENTS_AND_NOTES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    	saveDocumentUrl: function(btn) {
			  		var $this = this;
			  		var docAddEditWin = btn.up('documentformwindow');
			  		var form = Ext.ComponentQuery.query('simpleurlform')[0];
			  		form.down('#documentFormSubmitButtonId').setDisabled(true);
			  		var formUrl = Ext.ComponentQuery.query('documentandnotesform')[0];
			  		var urlGrid = Ext.ComponentQuery.query('documentandnotesurlgrid')[0];
			  		var store2 = urlGrid.getStore();
			  		var id='';
			  		if(docAddEditWin.down('hiddenfield[name=documentId]')) {
			  	         id = docAddEditWin.down('hiddenfield[name=documentId]').getValue();
			  	     }else{
			  	    	urlGrid.getSelectionModel().deselectAll();
			  	     }

			  		fields : ['id','documentId','documentName','path']
			  		var documentModelUrl = new Academia.model.course.QuestionPaperDocument();
			  		var documentName=form.down('#documentNameField').getValue();
			  		var UrlName=form.down('#documentUrlField').getValue();

			  		documentModelUrl.set("name",documentName);
			  		documentModelUrl.set("path",UrlName);
			  		if(urlGrid.getSelectionModel().getSelection() == 0) {
			  	         store2.add(documentModelUrl);
			  	     }else {
			  	         var documentModelUrl = urlGrid.getSelectionModel().getSelection()[0];
			  	         documentModelUrl.set("id",id);
			  	         documentModelUrl.set("name",documentName);
			  	         documentModelUrl.set("path",UrlName);
			  	     }
			  	//	store2.add(documentModelUrl);
			  		if (urlGrid.isHidden() && store2.data.items.length > 0) {
			  			urlGrid.setVisible(true);
			  			if(isAdd=true){
			  				urlGrid.down('#btnEdit').setVisible(false);	
			  			}else{
			  				urlGrid.down('#btnEdit').setVisible(true);	
			  			}
			  		}
			  		$this.getAdmApplicantProfileDocumentController().closeDocumentFormWindow();
			  		showSuccessMessage(getCommonTranslation('URL'),getCommonTranslation('URL_ADD_SUCCESSFULLY'));

			  	},
			    getAcademicTopicIdValueJson: function(id, value) {
					if (id) return {
						id: id,
						value: value
					};
				},
				showFormWindow : function(){
					var $this =this;
					var formWindow = $this.getDocumentAndNotesFormWindow();
					if (!formWindow) {
						formWindow = Ext.widget('documentandnotesformwindow', {
							          itemId: 'documentAndNotesFormWindow'
						});
					}
					formWindow.show();
				 },
				 loadAcademicTopicData: function(obj){
						var $this = this;
						var grid = obj.up('applicationacademictopicStructure').down('applicationdocumentsandnotesgrid');
						var addbtn=grid.down('#btnAdd');
						var editbtn=grid.down('#btnEdit');
						var deletebtn=grid.down('#btnDelete');
						
						var form = obj.up('form').getForm();
						var applicantProfile = $this.getContentPanelActiveTab();
						var applicationId = applicantProfile.getApplicationId();
					
						var values = form.getValues();
						grid.getStore().getProxy().extraParams ={
							acadmicTypeId:values.academicTopicId,
							academicSubTypeId:values.academicSubTopicId,
							programId:values.programId,
							batchId:values.batch,
							periodId:values.period,
							applicationId:applicationId,
							userId : $this.getCurrentlyLoggedInUser().id
						};
						grid.getStore().load();
					},
					resetAcademicTopicFormDropdowns: function() {
						var form=this.getApplicationacademicstopicquicksearchform().getForm();
						var programIdField=form.findField('programId');
						programIdField.reset();
						var academicTopicIdField=form.findField('academicTopicId');
						academicTopicIdField.reset();
						var batchIdField=form.findField('batch');
						batchIdField.reset();
						batchIdField.setDisabled(true);
						var periodIdField=form.findField('period');
						periodIdField.reset();
						periodIdField.setDisabled(true);
						var academicSubTopicIdField=form.findField('academicSubTopicId');
						academicSubTopicIdField.reset();
						academicSubTopicIdField.setDisabled(true);
				 },
				 //******* get Doc Controller**********
				      getDocumentController : function(){
				        	var this$ = this;
				        	return this$.getController('Academia.controller.document.DocumentController');
				        },
				      // ************* downLoad Doc**************
				        
				    /*Applicant Tranfer Credit*/
				    getGridButtonsPivileges:function(grid,permissionMap){

			        	var associatedAcadLocationIds = new Array();
			        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
			        	
			    		var approveATCBtnitemId = grid.down('#approveATCBtnitemId');
			    		approveATCBtnitemId.setVisible(false);
			    		
			    		var rejectATCBtnitemId = grid.down('#rejectATCBtnitemId');
			    		rejectATCBtnitemId.setVisible(false);
			    		
			    		var resubmitATCBtnitemId = grid.down('#resubmitATCBtnitemId');
			    		resubmitATCBtnitemId.setVisible(false);

			    		var applicantTrnsRepeatId = grid.down('#applicantTrnsRepeatId');
			    		applicantTrnsRepeatId.setVisible(false);

			        	Ext.each(permissionList, function(privilege) {
			        		
			        		if (privilege === 'APPROVE') {
			            		if(!isNullOrEmpty(approveATCBtnitemId)){
			            			approveATCBtnitemId.setVisible(true);
			            		}        		
			            	}
			        		
			        		if (privilege === 'REJECT') {
			            		if(!isNullOrEmpty(rejectATCBtnitemId)){
			            			rejectATCBtnitemId.setVisible(true);
			            		}        		
			            	}
			        		
			        		if (privilege === 'RESUBMIT') {
			            		if(!isNullOrEmpty(resubmitATCBtnitemId)){
			            			resubmitATCBtnitemId.setVisible(true);
			            		}        		
			            	}

			            	if (privilege === 'MARK_AS_REPEAT') {
			            		if(!isNullOrEmpty(applicantTrnsRepeatId)){
			            			applicantTrnsRepeatId.setVisible(true);
			            		}
			            	}
			        	});
			        },
			        loadApplicantTranferCredits: function() {
			        	 var me = this,
						     activeTab = me.getContentPanelActiveTab(),
				             form = me.getTransfercreditsquicksearchform(),
				             formGrid = me.getTransfercreditsgridformvalues(),
				             grid = activeTab.down('#transfercreditsgrid'),   
				             applicantId = activeTab.getApplicationId(),
				             programId = form.down('#programCodeNameATCItemId') ? form.down('#programCodeNameATCItemId').getValue() : null,
						     batchId = form.down('#batchATCItemId') ? form.down('#batchATCItemId').getValue() : null,
				             formVal = form.getForm().getValues(),
				             store = grid.getStore();
			        	 	 store.getProxy().extraParams = {
				        		applicationId: applicantId,                   
				        		programId: formVal.programCodeNameATC,                     
				        		batchId: formVal.batchATC,               
				             };
//			             	 grid.getStore().load();
			        	 	 store.on('load', function(store, records, success) {
			        	 		if(!success || !records || records.length == 0) {
			        	 			showWarningMessage(getCommonTranslation('INFO'), 'No transfer credits found.');
			        				return;
			        	 		}
			        	 		grid.getSelectionModel().deselectAll();
//			        	 		var markType = 
			        	 		
			        	 	 }, this, { single: true });
			        	 	 store.load();
			        	 	 
			        	 	Ext.Ajax.request({
			            		url: SERVERURL.PATH_FIND_APPLICANT_TRANSFER_CREDIT_COMPLETION+'?applicationId='+applicantId+"&programId="+programId+"&batchId="+batchId,
			            		type: 'rest',
			                    method: 'GET',
			                    headers: {
			                        'Content-Type': 'application/json'
			                    },
			                    success: function(response){
			                    	var data = Ext.JSON.decode(response.responseText);
			                    	formGrid.down('#exemptedCreditItemId').setValue(data.exemptedCredit);
			                    	formGrid.down('#programDurationItemId').setValue(data.programDuration);
			                    	var expectedCompletionDate = isNullOrEmpty(data.expectedCompletionDate) ? '' : new Date(data.expectedCompletionDate);
			                    	formGrid.down('#expectedCompletionDateItemId').setValue(expectedCompletionDate);
			                    }
			            	})
			        },
			        saveApplicantTransferGridData: function () {
			            var me = this,
			                form = me.getTransfercreditsquicksearchform(),
			                grid = me.getTransfercreditsgrid(),
			                applicantProfile = me.getContentPanelActiveTab(),
			                applicantId = applicantProfile.getApplicationId(),
			                gridFormValues = me.getTransfercreditsgridformvalues(),
			                programId = form.down('#programCodeNameATCItemId') ? form.down('#programCodeNameATCItemId').getValue() : null,
			                batchId = form.down('#batchATCItemId') ? form.down('#batchATCItemId').getValue() : null,
			                expectedCompletionDate = gridFormValues.down('#expectedCompletionDateItemId'),
			                programDuration = gridFormValues.down('#programDurationItemId'),
			                exemptedCredit = gridFormValues.down('#exemptedCreditItemId');

			            if (!grid) {
			                showWarningMessage(getCommonTranslation('ALERTS'), 'Grid not found!');
			                return;
			            }

			            var selectedRecords = grid.getSelectionModel().getSelection();
			            if (selectedRecords.length === 0) {
			                showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('SELECT_ATLEAST_ONE_RECORD'));
			                return;
			            }

			            var finalData = [];
			            var flag = false;

			            Ext.Array.forEach(selectedRecords, function (rec) {
			                var data = rec.data;
			                /*if (isNullOrEmpty(rec.get('equivalenceCourseName') && rec.get('equivalenceCourseCode'))) {
			                    Ext.Msg.alert(getExaminationTranslation('REQUIRED_FIELDS'),
			                        getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
			                    flag = true;
			                    return;
			                }*/
			                var mappedData = {
			                    applicantId: isNullOrEmpty(applicantId) ? null : applicantId,
			                    programId: isNullOrEmpty(data.programId) ? programId : data.programId,
			                    batchId: isNullOrEmpty(data.batchId) ? batchId : data.batchId,
			                    progBatchPeriodConfigId: isNullOrEmpty(data.progBatchPeriodConfigId) ? null : data.progBatchPeriodConfigId,

			                    courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
			                    courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
			                    courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
			                    courseCredits: isNullOrEmpty(data.courseCredits) ? null : data.courseCredits,

			                    obtainedMarkGrade: isNullOrEmpty(data.obtainedMarkGrade) ? null : data.obtainedMarkGrade,
			                    markType: isNullOrEmpty(data.markType) ? null : data.markType,
			                    gradeType: isNullOrEmpty(data.gradeType) ? null : data.gradeType,
			                    gradePoint: isNullOrEmpty(data.doubleValue) ? null : data.doubleValue,

			                    programName: isNullOrEmpty(data.programName) ? null : data.programName,
			                    batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
			                    programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,

			                    equivalenceCourseCode: isNullOrEmpty(data.equivalenceCourseCode) ? null : data.equivalenceCourseCode,
			                    equivalenceCourseName: isNullOrEmpty(data.equivalenceCourseName) ? null : data.equivalenceCourseName,
			                    equivalenceCourseCredit: isNullOrEmpty(data.equivalenceCourseCredit) ? null : data.equivalenceCourseCredit,
			                    institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,

			                    applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
			                    applicantRemark: isNullOrEmpty(data.applicantRemark) ? null : data.applicantRemark,
			                    facultyRemark: isNullOrEmpty(data.facultyRemark) ? null : data.facultyRemark,
			                    completionDate: isNullOrEmpty(data.completionDate) ? null : data.completionDate,
			                    admissionStatus: isNullOrEmpty(data.admissionStatus) ? null : data.admissionStatus,
			                    admissionId: isNullOrEmpty(data.admissionId) ? null : data.admissionId,
			                    approverBy: isNullOrEmpty(data.approverBy) ? null : data.approverBy,
			                    whetherCalculstionDone: data.whetherCalculstionDone,
			                    documentId: data.documentId
			                };

			                finalData.push(mappedData);
			            });

			            if (flag) {
			                return; 
			            }

			            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

			            var requestsCompleted = 0;
			            var hasError = false;

			            function checkAndShowMessage(success) {
			                requestsCompleted++;
			                if (!success) {
			                    hasError = true;
			                }
			                if (requestsCompleted === 2) {
			                    Ext.getBody().unmask();
			                    if (!hasError) {
			                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
			                        grid.getStore().reload();
			                    } else {
			                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
			                    }
			                }
			            }

			            Ext.Ajax.request({
			                url: SERVERURL.PATH_APPLICANT_TRANSFER_SAVE_DATA,
			                method: 'POST',
			                headers: { 'Content-Type': 'application/json' },
			                jsonData: finalData,
			                success: function () { 
			                	checkAndShowMessage(true);
			                },
			                failure: function () { checkAndShowMessage(false); }
			            });

			            var gridFormData = {
			                applicantId: applicantId,
			                programId: programId,
			                batchId: batchId,
			                expectedCompletionDate: isNullOrEmpty(expectedCompletionDate.getValue()) ? null : expectedCompletionDate.getValue(),
			                programDuration: isNullOrEmpty(programDuration.getValue()) ? null : programDuration.getValue(),
			                exemptedCredit: isNullOrEmpty(exemptedCredit.getValue()) ? null : exemptedCredit.getValue()
			            };

			            Ext.Ajax.request({
			                url: SERVERURL.PATH_APPLICANT_TRANSFER_CREDIT_COMPLETION_SAVE,
			                method: 'POST',
			                headers: { 'Content-Type': 'application/json' },
			                jsonData: gridFormData,
			                success: function () {
			                	checkAndShowMessage(true);
			                	grid.getSelectionModel().deselectAll();
			                	grid.getStore().load();
			                },
			                failure: function () { checkAndShowMessage(false); }
			            });
			        }
,

			        onGridViewReady: function (view) {
			        	var grid = this.getTransfercreditsgrid();  

			            view.el.on('change', function (e, input) {
			                var file = input.files[0];
			                if (!file) return;

			                var formData = new FormData();
			                formData.append('file', file);

			                var userInfo = Academia.model.authentication.UserInfoModel;
			                var access_token = userInfo.get("accessToken");
			                var url = SERVERURL.PATH_UPLOAD_APPLICANT_TRANSFER_CREDIT + '?access_token=' + access_token;

			                var xhr = new XMLHttpRequest();
			                xhr.open('POST', url);
			                xhr.onload = function () {
			                    if (xhr.status >= 200 && xhr.status < 300) {
			                        var response = xhr.responseText;
			                        var documentId = response;

			                        var rowEl = Ext.get(input).up('tr.x-grid-row');
			                        if (!rowEl) return;

			                        var allRows = view.el.query('tr.x-grid-row');
			                        var rowIndex = -1;
			                        for (var i = 0; i < allRows.length; i++) {
			                            if (allRows[i] === rowEl.dom) {
			                                rowIndex = i;
			                                break;
			                            }
			                        }

			                        if (rowIndex !== -1) {
			                            var record = grid.getStore().getAt(rowIndex);
			                            if (record) {
			                                var cleanedValue = input.value.replace('C:\\fakepath\\', '').replace(/ +/g, " ").split(' ').join('_');
			                                record.set('documentId', documentId);
			                                record.set('document', cleanedValue);
			                                record.commit();
			                            }
			                        }
			                    } else {
			                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
			                    }
			                };

			                xhr.send(formData);
			            }, this, {
			                delegate: 'input.grid-upload-input',
			                capture: true
			            });

			            view.el.on('click', function (e, t) {
			            	var target = Ext.get(t);

                            if (target && target.hasCls('download-icon-v2')) {
                                var rowEl = Ext.get(t).up('tr.x-grid-row');
                                if (!rowEl) return;

                                var allRows = view.el.query('tr.x-grid-row');
                                var rowIndex = -1;
                                for (var i = 0; i < allRows.length; i++) {
                                    if (allRows[i] === rowEl.dom) {
                                        rowIndex = i;
                                        break;
                                    }
                                }
                                if (rowIndex === -1) return;

                                var record = grid.getStore().getAt(rowIndex);
                                var documentId = record.get('documentId');

                                if (!documentId) {
                                    Ext.Msg.alert('Info', 'No document available to download.');
                                    return;
                                }

                                var access_token = Academia.model.authentication.UserInfoModel.get("accessToken");
                                var downloadUrl = SERVERURL.PATH_DOWNLOAD_APPLICANT_TRANSFER_CREDIT + '?id=' + documentId;
                                
                                
                                /*var csvForm = Ext.create('Ext.form.Panel'); 
                                csvForm.getForm().submit({
                                	target: '_blank',
                                	method:'POST',
                                	params :{
                                		access_token : access_token
                                	},
                                	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                                	url: downloadUrl,
                                	standardSubmit :true
                                });*/
                                
                                Ext.Ajax.request({
		    	                    url: downloadUrl,
		    	                    method: 'POST',
		    	                    headers: {
		    	                        'Content-Type': 'application/json'
		    	                    },
		    	                    params: {
		    	                    	access_token : access_token
		    	                    },
		    	                    success: function (response) {
		    	                    	Ext.getBody().unmask();

		    	                    	var data = Ext.decode(response.responseText);

		    	                    	var fileName = data.fileName;
		    	                    	var fileData = data.fileData;

		    	                    	var byteCharacters = atob(fileData);
		    	                    	var byteNumbers = new Array(byteCharacters.length);

		    	                    	for (var i = 0; i < byteCharacters.length; i++) {
		    	                    	    byteNumbers[i] = byteCharacters.charCodeAt(i);
		    	                    	}

		    	                    	var byteArray = new Uint8Array(byteNumbers);
		    	                    	var blob = new Blob([byteArray]);

		    	                    	var link = document.createElement("a");
		    	                    	link.href = window.URL.createObjectURL(blob);
		    	                    	link.download = fileName;
		    	                    	document.body.appendChild(link);
		    	                    	link.click();
		    	                    	document.body.removeChild(link);
		    	                    },
		    	                    failure: function () {
		    	                        Ext.getBody().unmask();
		    	                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_DOWNLOAD'));
		    	                    }
		    	                });

                                //window.open(downloadUrl, '_blank');
			                }
			            }, this, { delegate: '.download-icon-v2' });
			        },
			        transferCreditApproveRejectResubmit: function(apcStatus, btn, whetherRepeatCourse){
			    		var this$ = this;
				    	var grid = this$.getTransfercreditsgrid();
				    	var user = this$.getCurrentlyLoggedInUser(),
				    	    form = this$.getTransfercreditsquicksearchform(),
				    	 	applicantProfile = this$.getContentPanelActiveTab(),
			                applicantId = applicantProfile.getApplicationId(),
			                gridFormValues = this$.getTransfercreditsgridformvalues();
			                programId = form.down('#programCodeNameATCItemId') ? form.down('#programCodeNameATCItemId').getValue() : null,
			                batchId = form.down('#batchATCItemId') ? form.down('#batchATCItemId').getValue() : null,
			                expectedCompletionDate = gridFormValues.down('#expectedCompletionDateItemId'),
				            programDuration = gridFormValues.down('#programDurationItemId'),
				            exemptedCredit = gridFormValues.down('#exemptedCreditItemId');
				    	
//				    	var atcMess = 'TRANSFER_CREDIT_LIST';
				    	var atcSure = 'DO_YOU_WANT_TO_APPROVE?';
				    	
				    	if(apcStatus == 'approve') {
				    		atcSure = 'DO_YOU_WANT_TO_APPROVE?';
				    	}
				    	else if(apcStatus == 'reject') {
				    		atcSure = 'DO_YOU_WANT_TO_REJECT?';
				    	}
				    	else if(apcStatus == 'resubmit') {
				    		apcStatus = "need_to_resubmit"
				    		atcSure = 'DO_YOU_WANT_TO_RESUBMIT?';
				    	}
				    	if(apcStatus == 'Mark As Repeat'){
				    		showConfirmMessage(
						    		getCommonTranslation('REQUEST_FOR_REPEAT'),
						    		getCommonTranslation('CONFIRMATION_REPEAT_RECORD'),
						    	    function (btn) {
						    	        if (btn === 'yes') {
						    	            var selectionModel = grid.getSelectionModel().getSelection();

						    	            if (selectionModel.length > 0) {
						    	                var recordsData = [];

						    	                Ext.each(selectionModel, function (rec) {
						    	                	rec.data.approveById = user.id;
						    	                	if(apcStatus == 'Mark As Repeat'){
						    	                		rec.data.whetherRepeatCourse=whetherRepeatCourse;
						    	                		rec.data.exemptionType='REPEAT';
						    	                		rec.data.applicantTransferCreditStatus='SUBMIT';
						    	                		rec.data.applicantId=applicantId;
						    	                	}else{
						    	                		rec.data.whetherRepeatCourse=whetherRepeatCourse;
						    	                	}
						    	                	delete rec.data.doubleValue;
						    	                    recordsData.push(rec.data);
						    	                });

						    	                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

						    	                Ext.Ajax.request({
						    	                    url: SERVERURL.PATH_APPLICANT_TRANSFER_APPROVE_REJECT,
						    	                    method: 'POST',
						    	                    headers: {
						    	                        'Content-Type': 'application/json'
						    	                    },
						    	                    params: {
						    	                        status: 'Submit'
						    	                    },
						    	                    jsonData: recordsData,
						    	                    success: function (response) {
						    	                        Ext.getBody().unmask();
						    	                        showSuccessMessage(
						    	                            getCommonTranslation('SUCCESS'),
						    	                            getCommonTranslation('TRANSFER_CREDIT_REPEAT_SUCCESSFULLY')
						    	                        );
						    	                        grid.getSelectionModel().deselectAll();
						    	                        this$.loadApplicantTranferCredits();
						    	                    },
						    	                    failure: function () {
						    	                        Ext.getBody().unmask();
						    	                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
						    	                    }
						    	                });
						    	            }
						    	        }
						    	    }
						    	);
				    	}else{
				    		showConfirmMessage(
						    		getExaminationTranslation('TRANSFER_CREDIT_LIST'),
						    		getExaminationTranslation(atcSure),
						    	    function (btn) {
						    	        if (btn === 'yes') {
						    	            var selectionModel = grid.getSelectionModel().getSelection();

						    	            if (selectionModel.length > 0) {
						    	                var recordsData = [];

						    	                Ext.each(selectionModel, function (rec) {
						    	                	rec.data.approveById = user.id;
						    	                	rec.data.exemptionType = 'TRANSFER_CREDIT';
						    	                	delete rec.data.doubleValue;
						    	                    recordsData.push(rec.data);
						    	                });

						    	                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

						    	                Ext.Ajax.request({
						    	                    url: SERVERURL.PATH_APPLICANT_TRANSFER_APPROVE_REJECT,
						    	                    method: 'POST',
						    	                    headers: {
						    	                        'Content-Type': 'application/json'
						    	                    },
						    	                    params: {
						    	                        status: apcStatus
						    	                    },
						    	                    jsonData: recordsData,
						    	                    success: function (response) {
						    	                        Ext.getBody().unmask();
														if (response.responseText != "") {
															var mssg = response.responseText;
															if (mssg == 'approve') {
																var selectedCourseCreditArray = [];
																var selectedRecord = grid.getSelectionModel().getSelection();
																if (selectedRecord.length) {
																	selectedCourseCreditArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecord, 'data'), 'courseCredits');
																}

																var creditsSum = 0;
																Ext.Array.each(selectedCourseCreditArray, function(credit) {
																	creditsSum += parseFloat(credit) || 0;
																});

																var gridAllRecords = grid.store.data.items;
																var totalApprovedCredits = 0;

																Ext.Array.each(gridAllRecords, function(record) {
																	var data = record.data;
																	if (data.applicantTransferCreditStatus === 'APPROVE') {
																		var credit = parseFloat(data.courseCredits);
																		totalApprovedCredits += credit || 0;
																	}
																});
																var grandTotalCredits = creditsSum + totalApprovedCredits;
																if (!isNullOrEmpty(selectedRecord[0].data.programExemptedCreditLimit) && selectedRecord[0].data.programExemptedCreditLimit > '0' && grandTotalCredits > selectedRecord[0].data.programExemptedCreditLimit) {
																	Ext.getBody().unmask();
																	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('EXEMPTED_CREDIT_LIMIT'));
																	return;
																} else {
																	exemptedCredit.setValue(grandTotalCredits);
																	var gridFormData = {
																		applicantId: applicantId,
																		programId: programId,
																		batchId: batchId,
																		expectedCompletionDate: isNullOrEmpty(expectedCompletionDate.getValue()) ? null : expectedCompletionDate.getValue(),
																		programDuration: isNullOrEmpty(programDuration.getValue()) ? null : programDuration.getValue(),
																		exemptedCredit: isNullOrEmpty(exemptedCredit.getValue()) ? null : exemptedCredit.getValue()
																	};

																	Ext.Ajax.request({
																		url: SERVERURL.PATH_APPLICANT_TRANSFER_CREDIT_COMPLETION_SAVE,
																		method: 'POST',
																		headers: {
																			'Content-Type': 'application/json'
																		},
																		jsonData: gridFormData,
																		success: function(response) {
																		}
																	});
																}
																showSuccessMessage(
																	getCommonTranslation('SUCCESS'),
																	getCommonTranslation('TRANSFER_CREDIT_APPROVED_SUCCESSFULLY')
																);
															} else if (mssg=='reject') {
																var selectedCourseCreditArray = [];
																var selectedRecord = grid.getSelectionModel().getSelection();
																if (selectedRecord.length) {
																	selectedCourseCreditArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecord, 'data'), 'courseCredits');
																}

																var creditsSum = 0;
																Ext.Array.each(selectedCourseCreditArray, function(credit) {
																	creditsSum += parseFloat(credit) || 0;
																});

																var gridAllRecords = grid.store.data.items;
																var totalApprovedCredits = 0;

																Ext.Array.each(gridAllRecords, function(record) {
																	var data = record.data;
																	if (data.applicantTransferCreditStatus === 'APPROVE') {
																		var credit = parseFloat(data.courseCredits);
																		totalApprovedCredits += credit || 0;
																	}
																});

																// Subtract selected credits from approved total
																var grandTotalCredits = totalApprovedCredits - creditsSum;

																// Ensure it doesn’t go negative
																if (grandTotalCredits < 0) {
																	grandTotalCredits = 0;
																}

																exemptedCredit.setValue(grandTotalCredits);

																var gridFormData = {
																	applicantId: applicantId,
																	programId: programId,
																	batchId: batchId,
																	expectedCompletionDate: isNullOrEmpty(expectedCompletionDate.getValue()) ? null : expectedCompletionDate.getValue(),
																	programDuration: isNullOrEmpty(programDuration.getValue()) ? null : programDuration.getValue(),
																	exemptedCredit: isNullOrEmpty(exemptedCredit.getValue()) ? null : exemptedCredit.getValue()
																};

																Ext.Ajax.request({
																	url: SERVERURL.PATH_APPLICANT_TRANSFER_CREDIT_COMPLETION_SAVE,
																	method: 'POST',
																	headers: {
																		'Content-Type': 'application/json'
																	},
																	jsonData: gridFormData,
																	success: function(response) {
																	}
																});
																showSuccessMessage(
																	getCommonTranslation('SUCCESS'),
																	getCommonTranslation('TRANSFER_CREDIT_REJECT_SUCCESSFULLY')
																);
															} else if (mssg=='resubmit'|| mssg=='need_to_resubmit') {
																var selectedCourseCreditArray = [];
																var selectedRecord = grid.getSelectionModel().getSelection();
																if (selectedRecord.length) {
																	selectedCourseCreditArray = Ext.Array.pluck(Ext.Array.pluck(selectedRecord, 'data'), 'courseCredits');
																}

																var creditsSum = 0;
																Ext.Array.each(selectedCourseCreditArray, function(credit) {
																	creditsSum += parseFloat(credit) || 0;
																});

																var gridAllRecords = grid.store.data.items;
																var totalApprovedCredits = 0;

																Ext.Array.each(gridAllRecords, function(record) {
																	var data = record.data;
																	if (data.applicantTransferCreditStatus === 'APPROVE') {
																		var credit = parseFloat(data.courseCredits);
																		totalApprovedCredits += credit || 0;
																	}
																});

																if (selectedRecord[0].data.applicantTransferCreditStatus === 'APPROVE') {
																	var grandTotalCredits = totalApprovedCredits - creditsSum;

																	// Ensure it doesn’t go negative
																	if (grandTotalCredits < 0) {
																		grandTotalCredits = 0;
																	}

																	exemptedCredit.setValue(grandTotalCredits);

																	var gridFormData = {
																		applicantId: applicantId,
																		programId: programId,
																		batchId: batchId,
																		expectedCompletionDate: isNullOrEmpty(expectedCompletionDate.getValue()) ? null : expectedCompletionDate.getValue(),
																		programDuration: isNullOrEmpty(programDuration.getValue()) ? null : programDuration.getValue(),
																		exemptedCredit: isNullOrEmpty(exemptedCredit.getValue()) ? null : exemptedCredit.getValue()
																	};

																	Ext.Ajax.request({
																		url: SERVERURL.PATH_APPLICANT_TRANSFER_CREDIT_COMPLETION_SAVE,
																		method: 'POST',
																		headers: {
																			'Content-Type': 'application/json'
																		},
																		jsonData: gridFormData,
																		success: function(response) {
																		}
																	});
																}
																showSuccessMessage(
																	getCommonTranslation('SUCCESS'),
																	getCommonTranslation('TRANSFER_CREDIT_RESUBMIT_SUCCESSFULLY')
																);
															}
															grid.getSelectionModel().deselectAll();
															this$.loadApplicantTranferCredits();
														}
						    	                    },
						    	                    failure: function () {
						    	                        Ext.getBody().unmask();
						    	                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
						    	                    }
						    	                });
						    	            }
						    	        }
						    	    }
						    	);
				    	}

			     },

			        
				    /*Applicant Tranfer Credit*/
});

