/**
 * This controller is used for admission final list controller
 * @author Pravin.Surve
 */
Ext.define('Academia.controller.admission.finalAdmissionList.FinalAdmissionListController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['Academia.store.common.AcademyStore', 'Academia.store.common.AcademyStore',
             'Academia.store.common.ProgramsByAcademyIdLocationId','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
             'Academia.store.common.BatchesByProgramId', 'Academia.store.common.SeatTypesByBatchId',
             'admission.selectionProcess.QuotaTypes', 'admission.quotas.QuotaLists',
             'admission.selectionStage.SelectionStageFromSeatType','admission.admissionCycle.QuotaTypePickList',
             'reports.admission.QuotaViolationGridStore','Academia.store.campaign.AllActiveCampaignsStore', 'common.IntakeYearStore',
             'common.AcademicTermStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentFieldPaginationStore',
             'coursetransaction.studentenrollment.studentenrollmentdetail.ApplicantFieldPaginationStore'],

    views: ['Academia.view.criteriabuilder.grid.SearchResultGrid',
            'Academia.view.admission.finalAdmissionList.FinalAdmissionListView',
            'Academia.view.admission.finalAdmissionList.FinalAdmissionListSearchView',
            'Academia.view.admission.finalAdmissionList.FinalAdmissionQuickSeachForm'],
/*config: {
	FINALADMISSIONLISTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FINALADMISSIONLISTDASHBOARD_PRIVILEGES'),

}   ,*/         
    refs: [{
        ref: 'FinalAdmissionListSearchView',
        selector: 'finaladmissionlistsearchview'
    },{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	  ref:'finalAdmissionListOrganizationUnit',
    	  selector:'organizationunit[itemId=finalAdmissionListOrganizationUnit]'
      },{
    	ref: 'finalAdmissionListQuickSearchForm',
    	selector: 'finaladmissionquickseachform[itemId=finalAdmissionListQuickSearch]'
    },{
    	ref: 'finalAdmissionListSearchResultGrid',
    	selector: 'searchresultgrid[itemId=finalAdmissionListSearchResultGrid]'
    }],        
    config: {
    	FINALADMISSIONLISTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FINALADMISSIONLISTDASHBOARD_PRIVILEGES'),
    	FINAL_ADMISSION_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FINAL_ADMISSION_LIST_PRIVILEGES'),
//    	ADMISSIONDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSIONDASHBOARD_PRIVILEGES'),

    },
	init: function(application){
		this.control({
			/*FixingHeaderColumn*/
			'finaladmissionlistsearchview':{
				afterrender : function(structure){
					var $this = this;
					structure.body.on('scroll', function(e, target) {
						 var grid = structure.down('searchresultgrid');
						// $this.getCBGridHeaderFreeze(grid,structure);
						 $this.getMultipleCBGridHeaderFreezeMultipleStructureWithOutTab(grid,structure, true);
					 });
					
				}
     		},
			'organizationunit[itemId=finalAdmissionListOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
				
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			
    			},
    			render:function(obj){
    				var permission = this.getFINALADMISSIONLISTDASHBOARD_PERMISSIONS();
    				
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=finalAdmissionListOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},	

    		'fieldcontainer[itemId=finalAdmissionProgBatSeatContainer] combo[itemId=programId]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, records, eOpts);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	'fieldcontainer[itemId=finalAdmissionProgBatSeatContainer] combo[itemId=batchId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchId');
                }
        	},
        	
        	'fieldcontainer[itemId=finalAdmissionListQuotaContainer] combo[itemId=quotaTypeId]': {
        		select : function(combo,records, eOpts){
        			var quotaComboField = combo.up('form').down('#quotaId');
        			var comboValue = combo.getValue();
        			this.loadDependentCombo(quotaComboField, comboValue, 'quotaTypeId');
        		}
        	},
        	
        	'fieldcontainer[itemId=admissionStatusConatiner] combo[itemId=admissionStatus]': {
        		render: function(combo){
        			var records = new Array();
        			records.push(combo.getStore().findRecord('name', 'ADMISSION_IN_PROGRESS'));
        			records.push(combo.getStore().findRecord('name', 'ADMISSION_REJECTED'));
        			records.push(combo.getStore().findRecord('value', getCommonTranslation('ALL')));
        			for(var i= 0; i< records.length ; i++){
        				combo.getStore().remove(records);
           			 	combo.getStore().commitChanges();
        			}
        		}
        	},

        	/*  'fieldcontainer[itemId=studentCodeFilter] combo[itemId=studentItemId]': {
        		focus : function(studentComboField, records, eOpts) {
        			this.loadStudentComboByApplyingMAUFilter(studentComboField, records, eOpts);
        		}
        	},
        	
        	'fieldcontainer[itemId=admissionStatusConatiner] combo[itemId=applicationID]': {
        		focus : function(ComboField, records, eOpts) {
        			var academyLocationIds = this.getAcademyLocationIds();
					var appStore = ComboField.getStore();
					appStore.proxy.extraParams = {
							academyLocationId : academyLocationIds
					};
					appStore.load();
        		}
        	},*/
     	
        	'finaladmissionquickseachform[itemId=finalAdmissionListQuickSearch] button[itemId=finalAdmissionListSearchButtonId]':{
        		click: function(){
        			this.loadFinalAdmissionListGrid(true);
        		},
        		afterrender: function(){
        			var $this=this;
        			//$this.loadFinalAdmissionListGrid(false);
        			setTimeout(function(){
        				$this.loadFinalAdmissionListGrid(false);
        			},1000);
        		}
        	},
			/**
             * Export function for final admission list
             */
            'searchresultgrid[itemId=finalAdmissionListSearchResultGrid]': {
            	cellclick: this.cellClickStudentApplicantProfileView,
            	render:function(grid){
            		this.gridRenderFunction(grid);
            	},
            	 afterrender: function(grid) {
                 	//this.gridRenderFunction(grid);
                 	this.genericCBGridAccessControlValidation(grid, this.getFINAL_ADMISSION_LIST_PERMISSIONS());
                 	var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
                 }
            },
            'searchresultgrid[itemId=finalAdmissionListSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportFinalAdmissionList(SERVERURL.PDFEXPORT,'pdf',false,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=finalAdmissionListSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportFinalAdmissionList(SERVERURL.PDFEXPORT,'pdf',true,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=finalAdmissionListSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportFinalAdmissionList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=finalAdmissionListSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportFinalAdmissionList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'PROVISIONAL');
	            }
	        }
		});
	},


	/**
	 * This is for export function final admission list
	 */
	exportFinalAdmissionList : function(exportUrl,filetype,whetherAll,requestType) {
	   var quickSearchForm=this.getFinalAdmissionListQuickSearchForm();
	   var searchResultGrid = this.getFinalAdmissionListSearchResultGrid();
	   var pagingtoolbaroptions = this.getFinalAdmissionListSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	   var jsonFormatFormData=this.createFinalAdmissionListJsonFormat(quickSearchForm);
	   var reportTitle=getCommonTranslation("FINAL_ADMISSION_LIST");
	   var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	
	/**
	 * This function is to get the search criteria string
	 */
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    /**
     * This function is to add export button on grid
     */
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    /**
     *This function is to open student profile 
     */
    cellClickStudentApplicantProfileView: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        var grid = view.up('grid');
        if (columnName == "STUDENT_ID") {
            var tabTitle = record.get('STUDENT_ID');
            var personId = record.get('STUDENT_PERSON_ID');
            var userId = record.get('USER_ID');
            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
            var personController = this.getController('Academia.controller.personinfo.common.PersonCommonController');
            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
        }
        if(columnName == "APPLICATION_ID"){
        	var applicationId=record.get('APPLICATION_PRIMERY_ID');
        	var applicationBaceController = this.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
        	applicationBaceController.openApplicantProfile(applicationId,false,grid);
        }
        return false; 
    },
    
    /**
     *This is to load final admission list grid 
     */
    loadFinalAdmissionListGrid: function(isClicked,model, records) {
	    var AL= this.getFinalAdmissionListOrganizationUnit().down('#multiselectAcademyLocationId');
        if(isClicked) {
           if(AL.value != undefined && !isNullOrEmpty(AL.value[0])){
    	         this.getFinalAdmissionListQuickSearchForm().down('#finalAdmissionListSearchButtonId').setDisabled(true);
    	         var btn = this.getFinalAdmissionListQuickSearchForm().down('#finalAdmissionListSearchButtonId');
                 var SearchForm = this.getFinalAdmissionListQuickSearchForm();
                 var jsonFormatFormData = this.createFinalAdmissionListJsonFormat(SearchForm);
                 var ResultGrid = this.getFinalAdmissionListSearchResultGrid();
                 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
                 resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FINAL_ADMISSION_LIST_VIEWCODE);
                 //At the place of extra columns. we are passing the Search button.
                 ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,btn);
           }
           else {
	             showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_ACADEMY_LOCATION')); 
           }
        }
        else {
	        this.getFinalAdmissionListQuickSearchForm().down('#finalAdmissionListSearchButtonId').setDisabled(true);
    	    var btn = this.getFinalAdmissionListQuickSearchForm().down('#finalAdmissionListSearchButtonId');
            var SearchForm = this.getFinalAdmissionListQuickSearchForm();
            var jsonFormatFormData = this.createFinalAdmissionListJsonFormat(SearchForm);
            var ResultGrid = this.getFinalAdmissionListSearchResultGrid();
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FINAL_ADMISSION_LIST_VIEWCODE);
            	//At the place of extra columns. we are passing the Search button.
            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,btn);
        }
    },
    
    /**
     * Create final admission list search criteria json
     * @params searchCriteriaForm
     */
    createFinalAdmissionListJsonFormat: function(searchForm){
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.FINAL_ADMISSION_LIST_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();        
        
        var startDate = searchForm.down('#START_DATE').getValue();
 	    var endDate = searchForm.down('#END_DATE').getValue();
 	   
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' 
            	&& key !== 'START_DATE' && key !== 'END_DATE' ){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        var multiselectAcademyLocation = this.getAcademyLocationIds();
    	if(!isNullOrEmpty(multiselectAcademyLocation)){
    		multiselectAcademyLocation = multiselectAcademyLocation.toString();
    		var commaIndex = multiselectAcademyLocation.indexOf(",");
    		if(commaIndex != -1){    			
            	formValues= multiselectAcademyLocation.split(",");
    		}else{
    			formValues = [multiselectAcademyLocation];
    		}        	
    	}
    	if(formValues.length>0){
    		var keyValueJsonObject = this$.getJsonObject('multiselectAcademyLocation', formValues, null, true);
            this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);                		
    	}
    	
    	if(startDate != "" && startDate != null){
 		   var fromDate = Ext.Date.format(new Date(startDate), 'Y-m-d');
 		   
 		   var tillDate;
 		   if(!isNullOrEmpty(endDate)){
 			   tillDate = Ext.Date.format(new Date(endDate), 'Y-m-d');
 		   }else{
 			   tillDate = Ext.Date.format(new Date(), 'Y-m-d');
 		   }
 			   
 		   searchcriteria.push({paramCode:"ADMISSIONDATE", paramValues:[fromDate,tillDate]});
 	   }
    	
    	
    	
    	values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue,extraParam) {
    	if(extraParam){
      		 if (value != '' && additionalValue == undefined) {
      	            return {
      	                "paramCode": key,
      	                "paramValues": value
      	            };
      	        }
      	}
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    /**
     * On focus program combo load data according with MAU filter's
     * @param programComboField
     * @param records
     * @param eOpts
     */
    
    loadProgramComboByApplyingMAUFilter: function(programComboField, records, eOpts){
		var academyLocationIds = this.getAcademyLocationIds();
		var store = programComboField.getStore();
		store.load({
			params: {
				academyLocationIds: academyLocationIds
			}
		});
	},
	

					
				/*		loadStudentComboByApplyingMAUFilter : function(
							studentComboField, records, eOpts) {

						var academyLocationIds = this.getAcademyLocationIds();
						var studentStore = studentComboField.getStore();
						studentStore.proxy.extraParams = {
							academyLocationIds : academyLocationIds
						};
						studentStore.load();

					},*/
//	
	/**
	 * Method to load the next combo based on the selection of the previous
	 * combo value.
	 * 
	 * @param {Object}
	 *            dependentCombo is the reference of the next dropdown which
	 *            should be populated with values.
	 * @param {Object}
	 *            selectedRecord is the record of the previous dropdown which is
	 *            selected.
	 * @param {Object}
	 *            parameter is the value that should be attached in the url.
	 * @param {Object}
	 *            extraParameter (optional) If there is any extra parameter to
	 *            be sent for loading the dependent dropdown.
	 * @param {Object}
	 *            extraParamValue (optional) The value of the extraParam that is
	 *            sent for loading the store.
	 */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.setDisabled(false);
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            break;
        case 'batchId':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            break;
        case 'quotaTypeId':
        	this.clearCombo(combo);
        	quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	break;
        case 'quotaId':
        	this.clearCombo(combo);
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    
    /**
	 *This is to load campaign combo 
	 */
    loadCamapignCombo:function(combo){
    	combo.getStore().load();
    }
    
});
