/**
 * This controller is used for Signup Additional Setup
 * @author Prakash Sharma
 * FIXME: [AKR] Extend the BASE CONTROLLER
 */
Ext.define('Academia.controller.admission.signupAdditionalSetup.SignupAdditionSetupController', {
    extend: 'Academia.controller.base.BaseController',
    
    models: ['Academia.model.applicantportalsetup.UploadGuidelinesDocumentModel'],
    stores: ['user.UserAcademyLocationStore', 'program.ProgramByGroupIdStore','dynamicformrendering.configurescreen.ConfigureScreenGrid',
    	'applicantPortalSetup.GuidelinesDocumentListStore','Academia.store.signupAdditionalSetup.GuidelinesDocumentListStore'],

    views: ['signupSetup.SignupAdditionalSetupConfigureScreen','signupSetup.SignupAdditionalSetupView','signupSetup.VWAdmSignupSetupConfigureScreenGrid',
    	'signupSetup.SignupAdditionalSetupDataForm','Academia.view.signupSetup.SignupUploadDocumentList','Academia.view.signupSetup.SignupGuidelineDocumentForm',
    	'document.SimpleDocumentForm','Academia.view.applicantportalsetup.VWAdmissionSignupHelpTextForm'],

    	refs: [{
    	   	  ref: 'signupadditionalsetupdataform',
    		  selector: 'signupadditionalsetupdataform'
    	    },{
    		ref: 'vwadmsignupsetupconfigurescreengrid',
    		selector: 'vwadmsignupsetupconfigurescreengrid'
	    	},{
	    		ref : 'signupuploaddocumentlist',
	    		selector : 'signupuploaddocumentlist'
	    	},{
	    		ref : 'signupguidelinedocumentform',
	    		selector : 'signupguidelinedocumentform'
	    	},{
	    		ref : 'vwadmissionsignuphelptextform',
	    		selector : 'vwadmissionsignuphelptextform'
	    			
	    	},{
	    		ref : 'vwadmissionsignuphelptextForm',
	    		selector : 'vwadmissionsignuphelptextform form'
	    	}],
    config: {
    	//APPLICANT_PORTAL_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_SETUP_PROFILE_PRIVILEGES')
    },
    init: function(application) {
        this.control({
    		
        	'vwadmsignupsetupconfigurescreengrid':{
        		render : function(grid){
        			var $this = this;
        			grid.getStore().getProxy().extraParams={
        				academyLocationId:1,
        				screenName:'Applicant Sign Up Page',
        				screenMode:'Create, Edit, and View',
        				languageId :1
        			}
        			grid.getStore().load();
        			
        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var $this=this;
            		var searchResultGrid = $this.getVwadmsignupsetupconfigurescreengrid();
            		//if(searchResultGrid.columnManager.columns !=null){
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		var selectedRecord = searchResultGrid.getSelectionModel().getSelection()[0];

            		if(columnName=='helpText' && searchResultGrid.getSelectionModel().getSelection().length>0 /* && record.data.helpText ==null || record.data.helpText ==""*/){ 
            			if(searchResultGrid.getSelectionModel().getSelection().length==1 &&  (record.data.formFieldId == selectedRecord.data.formFieldId)){

            				if (e.target.tagName == 'A') {
            					var formWindow = $this.getVwadmissionsignuphelptextform();
            					if (!formWindow) {
            						Ext.widget('vwadmissionsignuphelptextform');
            						formWindow = $this.getVwadmissionsignuphelptextform();
            					}
            					formWindow.show();

            					var defaultHelpText = record.data.defaultHelpText;
            					var helpTextForm = $this.getVwadmissionsignuphelptextForm().getForm();
            					helpTextForm.findField('defaultHelpText').setValue(defaultHelpText);

            					if(!isNullOrEmpty(record.data.helpText)){
            						helpTextForm.findField('helpText').setValue(record.data.helpText);
            					}
            				}
            			}else{
            				if(searchResultGrid.getSelectionModel().getSelection().length>1 ){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); 
            				}
            				else if(record.data.formFieldId != selectedRecord.data.formFieldId){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_CURRENT_RECORD'));
            				}
            			}
            		}
            		else{

            			if(columnName=='helpText' && (!searchResultGrid.getSelectionModel().getSelection().length>0 || (record.data.formFieldId != selectedRecord.data.formFieldId)) )
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 

            		}
            	}
            	
            },
            'vwadmissionsignuphelptextform button[itemId=cancelBtn]':{
            	click:function(obj){
            		this.getVwadmissionsignuphelptextform().close();
            	}
            },
            'vwadmsignupsetupconfigurescreengrid button[itemId=btnSave]':{
			 click:function(){
				 this.admSaveSignUpConfigureScreenData();
			 }
            },'signupadditionalsetupdataform button[itemId=SubmitBtn]':{
				click:function(obj, record){
					var $this = this;
					var form = $this.getSignupadditionalsetupdataform();
					$this.validateUploadFiles(form, false);
				}
    		},
    		'signupadditionalsetupdataform filefield[itemId=logofileItemId]':{
    			 change: function(fileField, value, eOpts) {
    				 var $this = this;
 					var form = $this.getSignupadditionalsetupdataform();
 					$this.validateUploadFiles(form, true);
				}
    		},
    		'signupadditionalsetupdataform filefield[itemId=backgroundfileItemId]':{
    			 change: function(fileField, value, eOpts) {
    				 var $this = this;
 					var form = $this.getSignupadditionalsetupdataform();
 					$this.validateUploadFiles(form, true);
				}
    		},
    		'signupadditionalsetupdataform filefield[itemId=helpButtonUploadFileField]':{
    			 change: function(fileField, value, eOpts) {
    				 var $this = this;
 					var form = $this.getSignupadditionalsetupdataform();
 					$this.validateUploadFiles(form, true);
				}
    		},
    	
            'vwadmissionsignuphelptextform button[itemId=submitBtn]':{
            	click:function(obj){
            		var $this =this;
            		var form = obj.up('form').getForm();
            		var values = form.getValues();
            		var helpText =values.helpText;
            		var helpTextDefault = values.defaultHelpText
            		var grid = $this.getVwadmsignupsetupconfigurescreengrid();
            		var getRange = grid.getSelectionModel().selected.getRange();
            		getRange[0].set("helpText",helpText);
            		getRange[0].set("defaultHelpText",helpTextDefault);
            		$this.getVwadmissionsignuphelptextform().close();
            	}
            },
    		'signupadditionalsetupdataform': {
    			afterrender: function(form) {
                	this.loadForm(form);
                }
    		},
    		'signupadditionalsetupdataform button[itemId=removeLogoFile]':{
				click:function(obj, record){
					var $this = this;
					$this.removeFile('logo');
				}
    		},
    		'signupadditionalsetupdataform button[itemId=removeBackgroundFile]':{
				click:function(obj, record){
					var $this = this;
					$this.removeFile('backgroundImagePath');
				}
    		},
    		'signupadditionalsetupdataform button[itemId=removeDocFile]':{
				click:function(obj, record){
					var $this = this;
					$this.removeFile('guideline');
				}
    		},
    		'signupuploaddocumentlist button#addGuidelineDocumentItemId' : {
    			 click : function() {
    				 this.getDocumentController().showDocumentFormWindow('uploaddocumentlistItemId','SIGNUP_GUIDELINES_DOCUMENT');
    			 }
    		 },
    		 'signupuploaddocumentlist button#deleteGuidelineDocumentItemId' : {
    			 click:function(obj){
    				 this.deleteGuidelineDocument(obj);
    			 }
    		 }, 		 
    		 'guidelinedocumentform button#documentCancelButtonId':{
   			  click:function(){
   				  this.getDocumentController().closeDocumentFormWindow();
   			  }
   		  },
   		  'signupguidelinedocumentform button#documentFormSubmitButtonId':{
   			  click : function(obj) {
   				  this.saveGuidelinesDocument(obj);
   			  }
   		  },
   	 	 'signupguidelinedocumentform filefield[itemId=uploadFileField]': {
   	        	   change: function(fileField, value, eOpts) {
   	        		   if (!isNullOrEmpty(value)) {
   	        			   var $this = this;
   	        			   value = value.replace('C:\\fakepath\\', '');
   	            		   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
   	            		   fileField.setRawValue(newValue);
   	        		       var form = fileField.up().up();
   	        		       var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
   	        		       if ($this.isValidFileExtensionForGuidelinesDocument(extension)) {
   	        		    	   var file = fileField.fileInputEl.dom.files[0];
   	        		    	   if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
   	        		               fileField.reset();
   	        		               showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
   	        		               return false;
   	        		           } 
   	        		       } else {
   	        		           fileField.reset();
   	        		           showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
   	        		           return false;
   	        		       }
   	        		   }
   	        	   }
   	            },
   	         'signupuploaddocumentlist':{
   	 			 cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
   	 				 if (e.target.tagName == 'A') {
   	 					 if(!isNullOrEmpty(record.get("id"))){
   	 						 var documentId = record.get("id");
   	 					 }else{
   	 						 var documentId = record.get("documentId");
   	 					 }

   	 					 if (!isNullOrEmpty(documentId)) {
   	 						 this.getDownloadFileForGuidelinesDocument(documentId);
   	 					 }
   	 				 }
   	 			 },
   	 			 afterrender:function(grid){
   	 				 Ext.defer(function(){
   	 					 if (grid) {
   	 						 grid.updateLayout();
   	 						 grid.getView().refresh();
   	 					 }
   	 				 }, 50);
   	 			 }
   	 		 },
   	 		 'simpledocumentform':{
   	 			render:function(form){
    				var $this = this
    				form.body.on('click', function() {
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
   	 		 },
   	 		 'signupadditionalsetupdataform checkboxfield[itemId=enableChkHelpButtonItemId]': {
            	change:function(checkbox, newValue, oldValue, eOpts){ 
            		var form = checkbox.up('signupadditionalsetupdataform');
            		var helpButtonNameField = form.down('#helpButtonNameItemId');
            		var helpButtonUploadFileField = form.down('#helpButtonUploadFileField');
            		helpButtonNameField.reset();
            		helpButtonUploadFileField.reset();
            		if(newValue==true){
            			helpButtonNameField.setVisible(true);
            			helpButtonUploadFileField.setVisible(true);
                	}else if(newValue==false){
                		helpButtonNameField.setVisible(false);
                		helpButtonUploadFileField.setVisible(false);
                	}
				}
			
			}
        });
    },
    /// Save methods
    admSaveSignUpConfigureScreenData:function(){
		 var $this = this;
		 var grid = $this.getVwadmsignupsetupconfigurescreengrid();
		 var languageId;
		 var screenMode;
		 var screenName;
		 var configureArray = [];
		 var selectedRecord = grid.getSelectionModel().getSelection().length;
		 if(selectedRecord > 0){
			 screenMode = 'Create, Edit, and View';
			 languageId = 1;
			 screenName = 'Applicant Sign Up Page';
			 var record = grid.getSelectionModel().getSelection();
			 
			 if(record.length > 0) {
				 for(var i=0;i<record.length;i++){
					 var rec=record[i];
						var isVisibleField = rec.data.isVisible;
						 var isVisible; 
						 if(isVisibleField == null || isVisibleField == 'Yes'){
							 isVisible = true;
						 }else{
							 isVisible =false;
						 }

						 var helpText;
						 if(!isNullOrEmpty(rec.data.helpText)){
							 helpText =rec.data.helpText;
						 }else{
							 helpText = null;
						 }
						 var defaultHelpText;
						 if(!isNullOrEmpty(rec.data.defaultHelpText)){
							 defaultHelpText =rec.data.defaultHelpText;
						 }else{
							 defaultHelpText = null;
						 }
						 configureArray.push({
						 "formFieldId": rec.data.formFieldId,
						 "formFieldDisplaySettingId": rec.data.formFieldDisplaySettingId,
						 "screenName": screenName,
						 "screenMode": screenMode,
						 "defaultLabel": rec.data.defaultLabel,
						 "newLabel": rec.data.newLabel,
						 "isFieldLocked": rec.data.isFieldLocked,
						 "isMandatory": rec.data.isMandatory,
						 "isVisible": isVisible,
						 "helpText": helpText,
						 "defaultHelpText":defaultHelpText,
						 "defaultValue": rec.data.defaultValue,
						 "languageId": languageId,
						 "academyLocationId": 1,
						 "whetherForAllAcademyLocation": false
					  });
			     }
			 }
			 if(configureArray.length > 0){
			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 Ext.Ajax.request({
				 type : 'rest',
				 url : SERVERURL.CONFIGURE_SCREEN_SAVE,
				 jsonData : configureArray,
				 method : 'POST',
				 success : function(form, action) {
					 Ext.getBody().unmask();
					 showSuccessMessage(getCommonTranslation('DYNAMIC_FORM_RENDERING'),getCommonTranslation('SUCCESS'));
					 grid.getStore().reload();
					 grid.getSelectionModel().deselectAll();
				 }
			 });
		}else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		}
	   } 
	  else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	   }
	 },
	 validateUploadFiles: function(form, isFileCheck) {
	        var this$ = this;
	        var logoPathField = form.down('#logofileItemId');
	        var logoPath = logoPathField.getValue();
	        var logoUploadPath = logoPathField.getValue();
	        var backgroundfile = form.down('#backgroundfileItemId');
	        var backgroundUploadPath = backgroundfile.getValue();
	        
	        var helpButtonUploadField= form.down('#helpButtonUploadFileField');
	        var helpButtonUploadPath = helpButtonUploadField.getValue();
	    	if(!isNullOrEmpty(logoUploadPath)){
	    		var extension = logoUploadPath.substring(logoUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    		if (extension == "pdf" || extension == "png" || extension == "jpeg" || extension == "jpg") {
	    			
	    		}else{
	    			logoPathField.reset();
	    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	    		}
	    	}
	    	if(!isNullOrEmpty(backgroundUploadPath)){
	    		var extension1 = backgroundUploadPath.substring(backgroundUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    		if (extension1 == "pdf" || extension1 == "png" || extension1 == "jpeg" || extension1 == "jpg") {
	    			
	    		}else{
	    			backgroundfile.reset();
	    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	    		}
	    	}
	    	if(!isNullOrEmpty(helpButtonUploadPath)){
	    		var extension2 = helpButtonUploadPath.substring(helpButtonUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    		if (extension2 == "pdf" || extension2 == "png" || extension2 == "jpeg" || extension2 == "jpg") {
	    			
	    		}else{
	    			helpButtonUploadField.reset();
	    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	    		}
	    	}
	    	
	    	if (!isFileCheck) {
				this$.saveSignupAddtionalSetup(form);
			}/*else{
	    		this$.saveSignupAddtionalSetup(form);
	    	}*/
	    },
	    saveSignupAddtionalSetup : function(form){
	    	 var this$ = this;
	    	 var logoPath = form.getForm().findField('logoPath').getValue();
	    	 var backgroundFieldPath = form.getForm().findField('backgroundImagePath').getValue();
	    	 var helpButtonFile = form.getForm().findField('helpButtonImagePath').getValue();
		     var docPath = form.getForm().findField('documentPath').getValue();
		     var logoPathField = form.down('#logofileItemId').getValue();
		     var backgroundPathField = form.down('#backgroundfileItemId').getValue();
		     var helpButtonUploadFileField = form.down('#helpButtonUploadFileField').getValue();
		     //var guideLineDocPath = form.down('#DocumentfileItemId').getValue();
	    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				if (!isNullOrEmpty(logoPathField) || !isNullOrEmpty(backgroundPathField) || !isNullOrEmpty(helpButtonUploadFileField)) {
		            form.getForm().submit({
		                method: 'POST',
		                url: SERVERURL.PATH_UPLOAD_SIGNUP_ADDITIONAL_DOCUMENT,
		                success: function(form1, action) {
		                    var responseData = Ext.decode(action.response.responseText);
		                    if(responseData.success) {
		                    	 var path = responseData.path;
		                    	 var backgroundpath = responseData.pathForThirdFile;
		                    	 var helpButtonImagepath = responseData.pathForFourthFile;
		                         var pathForSecondFile = responseData.pathForSecondFile;
		                         if (path != null && path !='') {
		                        	 form.getForm().findField('logoPath').setValue(path);
								}else{
									 form.getForm().findField('logoPath').setValue(logoPath);
								}
		                        if (backgroundpath != null && backgroundpath !='') {
		                        	 form.getForm().findField('backgroundImagePath').setValue(backgroundpath);
								}else{
									 form.getForm().findField('backgroundImagePath').setValue(backgroundFieldPath);
								}
		                        if (helpButtonImagepath != null && helpButtonImagepath !='') {
		                        	 form.getForm().findField('helpButtonImagePath').setValue(helpButtonImagepath);
								}else{
									 form.getForm().findField('helpButtonImagePath').setValue(helpButtonFile);
								}
		                         if (pathForSecondFile != null && pathForSecondFile !='') {
		                        	 form.getForm().findField('documentPath').setValue(pathForSecondFile);
								}else{
									form.getForm().findField('documentPath').setValue(docPath);
								}
		                         this$.saveSignupAdditionalSetupRecord(form);
		                    } 
		                },
		                failure: function(d, f, s) {
		                    console.log('hello');
		                }
		            });
		        } else {
		            this$.saveSignupAdditionalSetupRecord( form);
		        }
	    },
	    
	    saveSignupAdditionalSetupRecord: function(from) {
	        var this$ = this;
	        var form = this$.getSignupadditionalsetupdataform();
	        var id = form.down('#Id');
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            isUpdate = false;
	        } else {
	            isUpdate = true;
	        }

	        var path = form.getForm().findField('logoPath').getValue();
	        var backgroundPath = form.getForm().findField('backgroundImagePath').getValue();
	        var helpButtonFile = form.getForm().findField('helpButtonImagePath').getValue();
	        var pathForSecondFile = form.getForm().findField('documentPath').getValue();
	        var jsonFormatFormData = this$.getJsonSignupAdditionSetupSubmitData(form, path, pathForSecondFile,backgroundPath);
	        this$.sendSaveAjaxRequest(SERVERURL.PATH_SAVE_SIGNUP_ADDTIONAL_SETUP_RECORD, 'POST', jsonFormatFormData, function(option, success, response) {
	        	Ext.getBody().unmask();
	            if (success, form) {
	                var data = Ext.decode(response.responseText);
	                this$.reloadFormFields(data, form);
	                if (isUpdate) {
	                    showSuccessMessage(getCommonTranslation('SIGN_UP_PAGE_SETUP'), getCommonTranslation('SIGNUP_ADDITIONAL_SETUP_UPDATE_SUCCESS'));
	                } else {
	                    showSuccessMessage(getCommonTranslation('SIGN_UP_PAGE_SETUP'), getCommonTranslation('SIGNUP_ADDITIONAL_SETUP_ADD_SUCCESS'));
	                }
	            } 
	        });
	    },
	    getJsonSignupAdditionSetupSubmitData: function(form, path, pathForSecondFile,backgroundPath) {
	        var this$ = this;
	        var jsonFormFieldData = new Object();
	        var formData = form.getValues();
	        var academyLocation = {
	                id: 1
	            };
	        formData.academyLocation = academyLocation;
	        Ext.Object.each(formData, function(key, value) {
	            if (key.includes("hiddenfield")) {
	                delete formData[key];
	            }
	        });
	        delete formData.pageSize;
	        delete formData.pageSizeCombo;
	        //delete formData.hiddenfield-2642-inputEl;
	        jsonFormFieldData = Ext.encode(formData);
	        return jsonFormFieldData;
	    },
	    reloadFormFields : function(data, form){
	    var this$ = this;
	    //var form = this$.getSignupadditionalsetupdataform();
	    form.down('#Id').setValue(data.id);
	    form.down('#logoPath').setValue(data.logoPath);
	    form.down('#backgroundImagePath').setValue(data.backgroundImagePath);
	    form.down('#helpButtonImagePath').setValue(data.helpButtonImagePath);
	    form.down('#documentPath').setValue(data.documentPath);
	    form.down('#instructionsItemId').setValue(data.guideline);
	    form.down('#instructionsOtherLanguageItemId').setValue(data.guidelineOtherLanguage);
	    form.down('#emailVerificationItemId').setValue(data.emailVerification);
	    form.down('#smsVerificationItemId').setValue(data.smsVerification);
	    form.down('#captchaVerificationItemId').setValue(data.captchaVerification);
	    form.down('#logofileItemId').setRawValue(data.logoPath);
	    form.down('#backgroundfileItemId').setRawValue(data.backgroundImagePath);
	    form.down('#welcomeTextItemId').setValue(data.welcomeText);
	   // form.down('#DocumentfileItemId').setRawValue(data.documentPath);
	    
	    if (data.logoPath != null && data.logoPath != '') {
	    	form.down('#removeLogoFile').setVisible(true);
		}else{
			form.down('#removeLogoFile').setVisible(false);
		}
	    if (data.backgroundImagePath != null && data.backgroundImagePath != '') {
	    	form.down('#removeBackgroundFile').setVisible(true);
		}else{
			form.down('#removeBackgroundFile').setVisible(false);
		}
	    if(data.isEnableHelpButton!='' && data.isEnableHelpButton == true){
	    	form.down('#enableChkHelpButtonItemId').setValue(true);
	    	form.down('#helpButtonNameItemId').setValue(data.helpButtonName);
	    	form.down('#helpButtonUploadFileField').setRawValue(data.helpButtonImagePath);
	    }else{
	    	form.down('#enableChkHelpButtonItemId').setValue(false);
	    }
	   /* if (data.documentPath != null && data.documentPath !='') {
	    	 form.down('#removeDocFile').setVisible(true);
		}else{
			form.down('#removeDocFile').setVisible(false);	
		}*/
	    
	    },
	    loadForm : function(form) {
	    	 var this$ = this;
	    	 var uploaddocumentlist = form.down('#uploaddocumentlistItemId');
	    	 Ext.Ajax.request({
	            	type: 'rest',
	            	url: SERVERURL.PATH_FIND_SIGNUP_ADDTIONAL_SETUP_RECORD+'?academyLocationId='+1,
	            	method: 'GET',
	            	callback : function(opt, success, response){
	            		var data = Ext.decode(response.responseText);
	            		this$.reloadFormFields(data, form);
	            		var store = uploaddocumentlist.getStore();
          				store.getProxy().extraParams = {
          					signupSetupId: data.id
          					};
        					store.load(); 
	            		}
	            	});
		},
		removeFile : function(fileType) {
			 var this$ = this;
			 var form = this$.getSignupadditionalsetupdataform();
			 Ext.Ajax.request({
	         	type: 'rest',
	         	url: SERVERURL.PATH_REMOVE_SIGNUP_ADDITIONAL_SETUP_DOC+'?documentType='+fileType,
	         	method: 'GET',
	         	callback : function(opt, success, response){
	         		var data = Ext.decode(response.responseText);
	         		this$.reloadFormFields(data, form);
	         		}
	         	});
		},
		 //******* get Doc Controller**********
	      getDocumentController : function(){
	        	var this$ = this;
	        	return this$.getController('Academia.controller.document.DocumentController');
	        },
	      isValidFileExtensionForGuidelinesDocument: function(extension) {
			if (!isNullOrEmpty(extension)) {
				extension = extension.toLowerCase();
				if (extension == "gif" || extension == "png" || extension == "jpeg" || extension == "jpg"
					|| extension == "pdf" || extension == "doc" || extension == "docx" || extension == "txt"
	   				|| extension == "xls" || extension == "xlsx" || extension == "odt" || extension == "ods"
	   				|| extension == "ppt" || extension == "pptx") {
					return true;
				}
			}
			return false;
		},
	    // *********** Upload Guidelines document ************
		saveGuidelinesDocument : function(obj){

	    	var $this=this;
	    	var isTransient = true;
	    	var module = 'singupAdditionSetup';
	    	var entityId ;
	    	var entityType = 'singupAdditionSetup';

	    	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'SIGNUP_GUIDELINES_DOCUMENT', function(success, response, isCallBackTransient){
				var id = null;
				var isGrid = false;
				var signupSetupId = null;
				var form = $this.getSignupadditionalsetupdataform();
				id = form.down('#Id');
				signupSetupId = id.getValue();
	    		var values = new Object();
	    	
	    			var data = [{
	    				"createdBy": $this.getIdValueJson(response.createdBy.id),
	    				"name": response.name,
	    				"path": response.path,
	    				"type": response.type
	    		    	}];
	    					values.id = signupSetupId;
	    					values.documents = data;

	    					var submitData = Ext.encode(values);

	    					Ext.Ajax.request({
	    						type : 'rest',
	    						url : SERVERURL.PATH_UPDATE_SIGNUPUP_GUIDELINES_DOCUMENT,
	    						jsonData : submitData,
	    						method : 'POST',
	    						success : function(response, action) {
	    							$this.hideWindowMask();
	    							if (!isNullOrEmpty(response.responseText)) {
	    							var data = Ext.decode(response.responseText);
	    							id.setValue(data);
	    							if(signupSetupId == null || signupSetupId == ""){
	    								signupSetupId = data;
	    							}
									}
	    							var URL = SERVERURL.PATH_FIND_ALL_SIGNUP_GUIDELINES_DOCUEMNTS +'?signupSetupId='+signupSetupId;
	    							Ext.Ajax.request({
	    	    						type: 'rest',
	    	    						url: URL,
	    	    						method: 'GET',
	    	    						success: function(res, action) {
	    	    							var data = Ext.decode(res.responseText);
	    	    							if(!isEmpty(data)){
	    	    	    							var uploaddocumentlist = $this.getSignupuploaddocumentlist();
	    	    	    							var store = uploaddocumentlist.getStore();
	    	    	               					store.getProxy().extraParams = {
	    	    	               						signupSetupId: signupSetupId
	    	    	               					};
	    	    	    							store.load();
	    	    	    					//showSuccessMessage(getCommonTranslation('APPLICANT_PORTAL_CONFIGURATION'),getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS'));
	    	    							}
	    	    						}
	    	    					});
	    							showSuccessMessage(getCommonTranslation('SIGN_UP_PAGE_SETUP'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	    						}
	    					});    
	    		$this.getDocumentController().closeDocumentFormWindow();
	    	}, isTransient);
	    },
	   getDownloadFileForGuidelinesDocument : function(documentId){
      	if(!isNullOrEmpty(documentId)){
      		var csvForm = Ext.create('Ext.form.Panel'); 
      		csvForm.getForm().submit({
      			target: '_blank',
      			method:'GET',
      			params :{
      				access_token : Ext.Ajax.defaultHeaders.access_token
      			},
      			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
      			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
      			standardSubmit :true
      		});
      	}
      },
      deleteGuidelineDocument:function(obj){
     	 var $this=this;
		 var uploaddocumentlist = null;
		 var uploaddocumentlist = obj.up('form').down('#uploaddocumentlistItemId');
      	 if (uploaddocumentlist.getSelectionModel().getCount() > 0) {
      		 var records = uploaddocumentlist.getSelectionModel().getSelection()[0];
	        		if(!isNullOrEmpty(records.data.signupSetupDocumentId)){
	        			var submitURL = SERVERURL.PATH_SIGNUP_GUIDELINES_DOC_DELETE+'?id='+records.data.signupSetupDocumentId;
	        		}
      		 showConfirmMessage(getCommonTranslation('SIGN_UP_PAGE_SETUP'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
      			 if (btn == 'yes'){
      				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      				 Ext.Ajax.request({
      					 method: "DELETE",
      					 type: 'rest',
      					 url : submitURL,
      					 headers: {
      						 'Content-Type': 'application/json'
      					 },
      					 success: function(form, action) {
      						 Ext.getBody().unmask();
      						 showSuccessMessage(getCommonTranslation('SIGN_UP_PAGE_SETUP'),getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));	 
      						 uploaddocumentlist.store.reload();
      						 uploaddocumentlist.getSelectionModel().deselectAll(true);
      					 }
      				 });
      			 }
      		 });
      	 } else {
      		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
      	 }
       },
       getIdValueJson: function(id, value) {
    	   if (id) return {
    		   id: id,
    		   value: value
    	   };
       }
});