/**
 *  @author Harshit Satya
 */
Ext.define('Academia.controller.alumniManagementSystem.AlumniFundsRaisingController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['alumni.alumniFundsRaising.AlumniFundsRaiseFilterGridModel',
    		 'alumni.alumniFundsRaising.AlumniFundsDonorTransactionGridModel'],
    stores: ['alumni.alumniFundsRaising.AlumniFundsCurrencyStore',
    		 'alumni.alumniFundsRaising.AlumniFundsRaiseFilterStore',
    		 'alumni.alumniFundsRaising.AlumniFundsTitleStore',
    		 'alumni.alumniFundsRaising.AlumniFundsCodeStore',
    		 'alumni.alumniFundsRaising.AlumniFundsDonorNameStore',
    		 'alumni.alumniFundsRaising.AlumniFundsPaymentCodeStore',
    		 'alumni.alumniFundsRaising.AlumniFundsPaymentTransactionIdStore',
    		 'alumni.alumniFundsRaising.AlumniFundsDonorTransactionFilterStore'],
    views: [
        'alumniSystem.alumniFundsRaising.AlumniFundsRaisingStructure',
        'alumniSystem.alumniFundsRaising.AlumniFundsRaisingFilter',
        'alumniSystem.alumniFundsRaising.AlumniFundsRaisingGrid',
        'alumniSystem.alumniFundsRaising.AlumniFundsRaisingAddRaiseFund',
        'alumniSystem.alumniFundsRaising.AlumniFundsRaisingViewRaiseFund',
        'alumniSystem.alumniFundsRaising.AlumniFundsViewTransactionStructure',
        'alumniSystem.alumniFundsRaising.AlumniFundsTransactionFilter',
        'alumniSystem.alumniFundsRaising.AlumniFundsTransactionListingGrid'
    ],
    config: {
        TNS_MANAGE_CEREMONY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_CEREMONY_PRIVILEGES'),
        ALUMNI_RAISE_FUNDS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_RAISE_FUNDS_PRIVILEGES'),
        ALUMNI_RAISE_FUNDS_DONORLIST_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_RAISE_FUNDS_DONORLIST_PRIVILEGES')
    },
    refs: [{
        ref: 'alumnifundsraisinggrid',
        selector: 'alumnifundsraisinggrid'
    }, {
        ref: 'alumnifundsraisingaddraisefund',
        selector: 'alumnifundsraisingaddraisefund'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref: 'alumnifundsraisingfilter',
    	selector: 'alumnifundsraisingfilter'
    },{
    	ref: 'alumnifundsviewtransaction',
    	selector: 'alumnifundsviewtransaction'
    },{
    	ref: 'alumnifundstransactionlistinggrid',
    	selector: 'alumnifundstransactionlistinggrid'
    },{
    	ref: 'alumnifundstransactionfilter',
    	selector: 'alumnifundstransactionfilter'
    }],
    init: function(application) {
        this.control({
        	'alumnifundsraisingaddraisefund':{
        		afterrender:function(form){
        			if(form.mode=='edit'){
        			  form.down('#btnResetItemId').setVisible(false);
        			}
        		}
        	},
            'alumnifundsraisingaddraisefund numberfield[name=maxAmt]': {
                change: this.checkAddButtonState
            },
            'alumnifundsraisingaddraisefund numberfield[name=minAmt]': {
                change: this.checkAddButtonState
            },
            'alumnifundsraisingaddraisefund button[itemId=btnAddRange]': {
                click: this.addDonationRangeFields
            },
			'alumnifundsraisinggrid':{
				render: function(grid){
					this.doAccessControlValidation(grid, this.getALUMNI_RAISE_FUNDS_PRIVILEGES());
					this.addDataGridConfigButton(grid,this.getALUMNI_RAISE_FUNDS_PRIVILEGES());
					this.getGridButtonsPivileges(grid, this.getALUMNI_RAISE_FUNDS_PRIVILEGES());
				},
				selectionchange: function(column, selected, eOpts ){  
					var $this = this                
                    var grid = $this.getAlumnifundsraisinggrid();
                    var gridSeletion = grid.getSelectionModel().getCount();
                    if(grid.getSelectionModel().getCount()==1) { 
                        grid.down('#btnEdit').setDisabled(false)
                        grid.down('#btnView').setDisabled(false)
                        grid.down('#btnViewTransactions').setDisabled(false)       
                    }
                    else{
                        grid.down('#btnEdit').setDisabled(true)
                        grid.down('#btnView').setDisabled(true)
                        grid.down('#btnViewTransactions').setDisabled(true)                  
                    }
                    if(grid.getSelectionModel().getCount()==0){
                    	grid.down('#btnDelete').setDisabled(true)
                    }else {
                    	grid.down('#btnDelete').setDisabled(false)
                    }
                },
			},
            'alumnifundsraisinggrid button[itemId=btnAdd]': {
                click: this.openAddRaiseFundPage
            },
            'alumnifundsraisinggrid button[itemId=btnViewTransactions]': {
                click: this.openViewFundTransactionPage	
            },
            'alumnifundsraisinggrid button[itemId=btnEdit]': {
            	click: this.editAddRaiseFundPage
            },
            'alumnifundsraisinggrid button[itemId=btnView]': {
            	click: this.viewAddRaiseFundPage
            },
            'alumnifundsraisinggrid button[itemId=btnDelete]':{
            	click: this.deleteAlumniFunds
            },
            'alumnifundsraisingaddraisefund button[name=btnSave]': {  
                click: this.createAlumniFunds
            },
    		'alumnifundsraisingfilter button[name=submitBtn]': {
                click: this.showFilterFundsData
            },
            'alumnifundstransactionfilter button[name=submitBtn]': {
                click: this.showDonorTransactionFundsData
            },
            'alumnifundsraisingfilter button[name=btnReset]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumnifundsraisingfilter();
                    grid = me.getAlumnifundsraisinggrid();
                    form.getForm().reset();                  
                }
            },
            'alumnifundstransactionfilter button[name=btnReset]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumnifundstransactionfilter();
                    form.getForm().reset();                  
                }
            },
            'alumnifundsraisingaddraisefund button[name=btnReset]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumnifundsraisingaddraisefund();
                    form.getForm().reset();                  
                }
            },  
            'alumnifundsraisingaddraisefund photouploadform[itemId=alumniRaiseFunduploadImageItemId] filefield[itemId=photoFileImage]' : {
                change: function(photoFileImage, value, eOpts) {
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    photoFileImage.setRawValue(newValue);
                    
                    var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
                    
                    if (!isNullOrEmpty(value)) {
                        // Check for valid file extension
                        if (extension == "gif" || extension == "png" || extension == "jpeg" || extension == "jpg") {
                            // Check for file size
                            var file = photoFileImage.fileInputEl.dom.files[0];
                            if (file && file.size > 5 * 1024 * 1024) { // 5 MB limit
                                photoFileImage.reset();
                                showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_FILE_SIZE_EXCEEDED'));
                            }
                        } else {
                            photoFileImage.reset();
//                            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
                        }
                    }
                }
            }, 
            'alumnifundstransactionlistinggrid': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getALUMNI_RAISE_FUNDS_DONORLIST_PRIVILEGES());
            		this.addDataGridConfigButton(grid,this.getALUMNI_RAISE_FUNDS_DONORLIST_PRIVILEGES());
				},
            	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
            	    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
            	    if(columnName == "receiptPath") {
                        if(e.target.tagName=='A'){
                                if(record.data.receiptPath){
                                    var documentURL= record.data.receiptPath;
                                    var csvForm = Ext.create('Ext.form.Panel'); 
                                        csvForm.getForm().submit({
                                            target: '_blank',
                                            method:'GET',
                                            params :{
                                                access_token : Ext.Ajax.defaultHeaders.access_token,
                                                documentUrlPath:documentURL
                                            },
                                            headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                                            url: SERVERURL.PATH_ALUMNI_FUNDS_RECEIPT_DOWNLOAD,
                                            standardSubmit :true
                                        });
                                    }
                            }
                    }
            	}
            }
        });
     },
     
     minUpdateValue: 1.00, // minimum value to update donation range value

    // Open Add Raise Fund Page
    openAddRaiseFundPage: function() {
        var $this = this;
        var contentpanel = $this.getContentPanel();
        var tabName = getAlumni('ADD_RAISE_FUND');
        var addRaiseFundTab = Ext.widget('alumnifundsraisingaddraisefund', {
            mode: 'create' // Set mode to 'create'
        });
        var navigationController = $this.getController('menu.CoreERPNavigationController');
        var existingTab = navigationController.getTab(tabName);
        if (existingTab != null) {
            contentpanel.remove(existingTab, true);
        }
     
        var oppositeTab =  $this.getController('menu.CoreERPNavigationController').getTab(getAlumni('EDIT_RAISE_FUND')) 
        if (oppositeTab) {
          $this.getContentPanel().remove(oppositeTab, true);
       }
		
        openTab(contentpanel, tabName, addRaiseFundTab, CONSTANTS.MENU_COLOR_ONE);
        var  uploadBtn = Ext.ComponentQuery.query('alumnifundsraisingaddraisefund')[0];
        var imgbtn = uploadBtn.down('#photoFileImage');
        imgbtn.setReadOnly(false);
    },

    // Add Donation Range Fields
    addDonationRangeFields: function(button) {
        var me = this;
        var formPanel = this.getAlumnifundsraisingaddraisefund(),
            fieldContainer = button.up('#dynamicMainPanel');

        // Get the donation goal from the form
        var donationGoal = formPanel.down('numberfield[name=donationGoal]').getValue();

        // Check if any existing ranges exceed or match the donation goal
        var fieldContainers = fieldContainer.query('container[xtype=fieldcontainer]');
        var isValid = true;
        var lastMaxValue = 0; // Keep track of the maximum value from the last field container
        var latestMin = 0;

        Ext.each(fieldContainers, function(container) {
            var minAmt = container.down('numberfield[name=minAmt]').getValue();
            var maxAmt = container.down('numberfield[name=maxAmt]').getValue();

            if (minAmt >= donationGoal || (maxAmt+1) >= donationGoal) {
                isValid = false;
                showWarningMessage('Alert', 'Existing ranges already exceed or match the Donation Goal. Cannot add more ranges.');
                return false; 
            }

            // Update the lastMaxValue for new field validation
            lastMaxValue = Math.max(lastMaxValue, maxAmt);
            latestMin = lastMaxValue + 1;
            
        });

        if (!isValid) {
            return;
        }

        // Create and add the new field container
        var newFieldContainer = Ext.create('Ext.container.Container', {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256,
                margin: '0 10px 10px 0'
            },
            items: [{
                xtype: 'numberfield',
                name: 'minAmt',
                allowBlank: false,
                minValue: lastMaxValue + 1, // Ensure new min value is greater than last max value
                allowExponential: false,
                margin: '0 24 0 0',
                listeners: {
                    change: function(field, newValue) {
                        var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                        if (maxAmtField) {
                            maxAmtField.setMinValue(newValue + 1);
                            var maxAmtValue = maxAmtField.getValue();
                            if (maxAmtValue <= newValue) {
                                maxAmtField.setValue(newValue + 1);  
                            }
                        }
                    }
                }
            }, {
                xtype: 'numberfield',
                name: 'maxAmt',
                allowBlank: false,
                allowExponential: false,
                minValue: latestMin
            }]
        });

        // Add the new field container
        fieldContainer.add(newFieldContainer);

        // Update buttons and set min value of new row
        me.updateButtons(fieldContainer);
        me.updateMinValueOfNewRow(newFieldContainer);

        // Force layout recalculation
        fieldContainer.doLayout(); // Ensure layout is updated after changes

        // Validate the newly added field
        me.checkAddButtonState(); // Ensure the 'Add' button state is correctly updated
    },

    // Update the "Add" and "Delete" buttons
    updateButtons: function(fieldContainer) {
        var me = this;
        var allFieldContainers = fieldContainer.query('container[xtype=fieldcontainer]');

        // Remove "Add" and "Delete" buttons from all containers
        Ext.each(allFieldContainers, function(container) {
            var addButton = container.down('button[itemId=btnAddRange]');
            var deleteButton = container.down('button[cls=CustomBodyBtnReject]');
            if (addButton) {
                container.remove(addButton);
            }
            if (deleteButton) {
                container.remove(deleteButton);
            }
            
        });
        
        
        if(allFieldContainers.length==1) {
        	var lastContainer = allFieldContainers[allFieldContainers.length - 1];
        	if (lastContainer) {
                lastContainer.add({
                    xtype: 'button',
                    itemId: 'btnAddRange',
                    cls: 'CustomBodyBtnSettings',
                    tooltip: getCommonTranslation('ADD'),
                    disabled: true, 
                    style: {
                        marginTop: '24px',
//                        marginLeft: '10px',
                    },
                    width: 30,
                    height: 28
                });
            }
        } // Add "Add" button if the total number of containers is less than or equal to 9
        else if (allFieldContainers.length <= 9) {
            var lastContainer = allFieldContainers[allFieldContainers.length - 1];
            if (lastContainer) {
                lastContainer.add({
                    xtype: 'button',
                    itemId: 'btnAddRange',
                    cls: 'CustomBodyBtnSettings',
                    tooltip: getCommonTranslation('ADD'),
                    disabled: true,  // Initially disabled
                    style: {
//                        marginTop: '30px',
                        marginLeft: '12px',
                    },
                    width: 30,
                    height: 28
                });
            }
        }

        // Add "Delete" button to the last container if there are more than one container
        if (allFieldContainers.length > 1) {
            var lastContainer = allFieldContainers[allFieldContainers.length - 1];
            if (lastContainer) {
                lastContainer.add({
                    xtype: 'button',
                    glyph: ICONGLYPH.DELETEGLYPH,
                    cls: 'CustomBodyBtnReject',
                    tooltip: getCommonTranslation('DELETE'),
                    style: {
//                        marginTop: '10px',
//                        marginLeft: '5px',
                    },
                    width: 30,
                    height: 28,
                    handler: function(btn) {
                        if (allFieldContainers.length > 1) {
                            fieldContainer.remove(lastContainer);
                            me.updateButtons(fieldContainer); // Ensure buttons are updated after removal
                        }
                    }
                });
            }
        }
    },


    // Update the min value of the new row based on the previous row's max value
    updateMinValueOfNewRow: function(newFieldContainer) {
        var fieldContainer = newFieldContainer.up('#dynamicMainPanel');
        var allFieldContainers = fieldContainer.query('container[xtype=fieldcontainer]');

        if (allFieldContainers.length > 1) {
            var previousContainer = allFieldContainers[allFieldContainers.length - 2];
            var newMinAmtField = newFieldContainer.down('numberfield[name=minAmt]');
            var previousMaxAmtField = previousContainer.down('numberfield[name=maxAmt]');

            if (previousMaxAmtField) {
                var newMinValue = (previousMaxAmtField.getValue() || 0) + this.minUpdateValue;
                newMinAmtField.setValue(newMinValue);
                newMinAmtField.setReadOnly(true);  // Make the field read-only
            }

            // Update the max value of the new row when min value changes
            newMinAmtField.on('change', function(field, newValue) {
                var previousMaxAmtField = previousContainer.down('numberfield[name=maxAmt]');
                if (previousMaxAmtField) {
                    previousMaxAmtField.setValue(newValue - 1); // Adjust previous max value if needed
                }
            });
        }
    },


    // Check if the "Add" button should be enabled or disabled
    checkAddButtonState: function() {
        var formPanel = this.getAlumnifundsraisingaddraisefund(),
            fieldContainer = formPanel.down('#dynamicMainPanel'),
            lastContainer = fieldContainer.query('container[xtype=fieldcontainer]').slice(-1)[0];

        if (lastContainer) {
            var minAmtField = lastContainer.down('numberfield[name=minAmt]');
            var maxAmtField = lastContainer.down('numberfield[name=maxAmt]');
            var addButton = lastContainer.down('button[itemId=btnAddRange]');

            // Enable the "Add" button only if both fields have values and maxAmt is greater than minAmt
            if (minAmtField && maxAmtField && addButton) {
                var minValue = minAmtField.getValue();
                var maxValue = maxAmtField.getValue();

                addButton.setDisabled(!(minValue > 0 && maxValue > minValue));
            }
        }
    },

    // Method to create Alumni Funds (AJAX POST request)
    createAlumniFunds: function(button) {
        var me = this;
        var formPanel = me.getAlumnifundsraisingaddraisefund();
        var formValues = formPanel.getValues();
        
        // Check if there's an image to upload
        var imageField = formPanel.down('#alumniRaiseFunduploadImageItemId');
        var imageVal = imageField.down('#photoFileImage');
        
        if (imageVal.getValue()) {
            // If there's an image, upload it first
            imageField.getForm().submit({
                method: 'POST',
                url: SERVERURL.PATH_ALUMNI_FILE_UPLOAD,
                success: function(form, action) {
                    var responseData = Ext.decode(action.response.responseText);
                    var path = responseData.path;
                    if(path.split('.')[1] == '') {
                    	var existingImageUrl = formPanel.down('#hiddenImageItemId').getValue();
                        me.saveAluminiFundRaiseData(existingImageUrl);
                    } else {
                    	me.saveAluminiFundRaiseData(path);                    	
                    }
                }
            });
        } else {
            me.saveAluminiFundRaiseData();  // Proceed without image
        }
    },

    saveAluminiFundRaiseData: function(imageUrl) {
        var me = this;
        var formPanel = me.getAlumnifundsraisingaddraisefund();
        var formValues = formPanel.getValues();
            
        // Collect donation ranges
        var donationRanges = [];
        var donationGoal = formPanel.down('numberfield[name=donationGoal]').getValue();
        var fieldContainers = formPanel.down('#dynamicMainPanel');
        var lastMaxValue = 0;
        var isValid = true;

        Ext.each(fieldContainers.items.items, function(container) {
            if (container.xtype !== 'container') {
                var minAmt = container.down('numberfield[name=minAmt]').getValue();
                var maxAmt = container.down('numberfield[name=maxAmt]').getValue();

                if (minAmt >= donationGoal || (maxAmt) > donationGoal || maxAmt < minAmt) {
                    isValid = false;
                    showErrorMessage('Error', 'Please ensure that each range has a valid minimum and maximum value, with the minimum less than the maximum.');
                    return false;
                }

                donationRanges.push({
                    minimumValue: minAmt,
                    maximumValue: maxAmt
                });

                lastMaxValue = Math.max(lastMaxValue, maxAmt);
            }
        });

        if (!isValid) {
            return;
        }


        // Collect academy locations
        var alumniFundAcademyLocation = [];
        Ext.each(formValues.academyLocations, function(location) {
            alumniFundAcademyLocation.push({
                "academyLocation": { "id": location.data ? location.data.id : location }
            });
        });
        

        var dataPayload = {
            fundsTitle: formValues.title || "",
            currency: { id: formValues.currency || "1" },
            donationGoal: formValues.donationGoal || "",
            imageUrl: imageUrl || "",
            status: formValues.status == "active" ? true : false,
            startDate: formValues.startDate || "",
            endDate: formValues.endDate || "",
            description: formValues.description || null,
            alumniFundAcademyLocationMapping: alumniFundAcademyLocation,
            alumniDonationRange: donationRanges
        };
        
        var isEditMode = formPanel.mode === 'edit';
        
        if (isEditMode) {
            dataPayload.id = formValues.recordId;
            dataPayload.fundsCode = formValues.fundsCode
        }

        var submitUrl = isEditMode ? SERVERURL.PATH_ALUMNI_FUND_RAISE_EDIT : SERVERURL.PATH_ALUMNI_FUND_RAISE_CREATE;
        var method = isEditMode ? 'PUT' : 'POST';

       
        Ext.Ajax.request({
            url: submitUrl,
            method: method,
            jsonData: Ext.encode(dataPayload),
            success: function(response) {
                Ext.getBody().unmask();

                // Parse response
                var responseData = Ext.decode(response.responseText);

                // Check if response is 0
                if (responseData === 0) {
                    // Handle case where response is 0
                	showErrorMessage(getCommonTranslation('ERROR'), getAlumni('DUPLICATE_DATA'));
                } else {
                	showSuccessMessage(getAlumni('FUNDS_RAISE'), getAlumni('NEWS_AND_FEEDS_SAVE'));

                    var grid = me.getAlumnifundsraisinggrid();
                    grid.getStore().load();

                    var currentTab = me.getController('menu.CoreERPNavigationController').getTab(
                        isEditMode ? getAlumni('EDIT_RAISE_FUND') : getAlumni('ADD_RAISE_FUND')
                    );

                    if (currentTab) {
                        me.getContentPanel().remove(currentTab, true);
                    }
                }
            },
            failure: function(response) {
                Ext.getBody().unmask();
//                Ext.Msg.alert(getCommonTranslation('ERROR'), getCommonTranslation('SERVER_ERROR'));
            }
        });

    },
  
    // Function to show search funds data on grid
    showFilterFundsData: function() {
        var me = this,
            form = me.getAlumnifundsraisingfilter(), 
            grid = me.getAlumnifundsraisinggrid(),   
            formVal = form.getForm().getValues();    

        grid.getStore().getProxy().extraParams = {
        	fundCode: formVal.fundsCode,                   
        	fundsTitle: formVal.title,                     
            currency: formVal.currency,               
            startDate: formVal.startDate,             
            endDate: formVal.endDate,                 
            status: formVal.status,
            donationGoal: formVal.donationGoal,
            currencyName: formVal.currency,
            academyLocationId: formVal.academyLocation
        };

        // Load the grid's store with the updated parameters
//        grid.getStore().load();
        
        grid.down('pagingtoolbar').moveFirst();
        grid.config.searchFilterForm = me.getAlumnifundsraisingfilter();
    },
    
    // Function to show search donor transaction funds data on grid
    showDonorTransactionFundsData: function() {
        var me = this,
            form = me.getAlumnifundstransactionfilter(), 
            viewTransFilter  = me.getAlumnifundstransactionfilter();
            grid = me.getAlumnifundstransactionlistinggrid(),   
            formVal = form.getForm().getValues();  
            raiseFundId = viewTransFilter.recordId;
            
            var idsArr = [];
            
            var ids;
            
            if (formVal.academyLocations && formVal.academyLocations.length > 0 && formVal.academyLocations[0] !== '') {
            	formVal.academyLocations.forEach(function (record) {
                    idsArr.push(record.get('id')); 
                });
            	ids = idsArr.join();
            } 
            else {
            	ids = null;
            }
            
	        grid.getStore().getProxy().extraParams = {
	            id:raiseFundId,
	            donorName: formVal.donorName,                   
	            alumniCode: formVal.alumniId,                     
	            academyLocationId: ids,               
	            transactionId: formVal.transactionId,
	            paymentStatus: formVal.paymentStatus
	        };
	
	        // Load the grid's store with the updated parameters
//	        grid.getStore().load();
	        grid.down('pagingtoolbar').moveFirst();
	        grid.config.searchFilterForm = me.getAlumnifundstransactionfilter();
    },
    
    // Function to Edit Add Raise Fund record
    editAddRaiseFundPage: function() {
        var $this = this;
        var contentpanel = $this.getContentPanel();
        var grid = $this.getAlumnifundsraisinggrid();
        var tabName = getAlumni('EDIT_RAISE_FUND');
        var addRaiseFundTab = Ext.widget('alumnifundsraisingaddraisefund', {
            mode: 'edit' // Set mode to 'edit'
        });
        var navigationController = $this.getController('menu.CoreERPNavigationController');
        var existingTab = navigationController.getTab(tabName);
        
        var formPanel = this.getAlumnifundsraisingaddraisefund(),
        fieldContainer = formPanel.down('#dynamicMainPanel'),
        lastContainer = fieldContainer.query('container[xtype=fieldcontainer]').slice(-1)[0];

        
        var oppositeTab = $this.getController('menu.CoreERPNavigationController').getTab(getAlumni('ADD_RAISE_FUND'));

        if (oppositeTab) {
          $this.getContentPanel().remove(oppositeTab, true);
       }
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];

            // Make AJAX request to fetch data by fundId
            Ext.Ajax.request({
                url: SERVERURL.PATH_ALUMNI_FUND_FETCH_FUNDID,
                type: 'rest',
                method: 'GET',
                params: { 
                    fundId: record.data.id
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(response) {
                    var data = Ext.decode(response.responseText);

                    // Access the form panel of the tab
                    var form = addRaiseFundTab.getForm();
                    
                    if (!existingTab) {
                        openTab(contentpanel, tabName, addRaiseFundTab, CONSTANTS.MENU_COLOR_ONE);
                        var  uploadBtn = Ext.ComponentQuery.query('alumnifundsraisingaddraisefund')[0];
                        var imgbtn = uploadBtn.down('#photoFileImage');
                        imgbtn.setReadOnly(false);
                    } else {
                        contentpanel.remove(existingTab, true);
                        openTab(contentpanel, tabName, addRaiseFundTab, CONSTANTS.MENU_COLOR_ONE);
                        var  uploadBtn = Ext.ComponentQuery.query('alumnifundsraisingaddraisefund')[0];
                        var imgbtn = uploadBtn.down('#photoFileImage');
                        imgbtn.setReadOnly(false);
                    }
                    

                    // Set basic form fields
                    form.findField('recordId').setValue(data.id);
                    form.findField('fundsCode').setValue(data.fundsCode);
                    form.findField('title').setValue(data.fundsTitle);
                    form.findField('donationGoal').setValue(data.donationGoal);
                    form.findField('status').setValue(data.status ? 'active' : 'inactive');
                    form.findField('description').setValue(data.description);
                    
                    if(data.startDate) {	
                    	form.findField('startDate').setValue(new Date(data.startDate));
                    } else {
                    	form.findField('startDate').setValue(null);
                    }
                    if(data.endDate) {	
                    	form.findField('endDate').setValue(new Date(data.endDate));
                    } else {
                    	form.findField('endDate').setValue(null);
                    }
                    
                    
                    

                    // Set currency
                    var currencyCombo = form.findField('currency');
                    currencyCombo.getStore().load({
                    	callback:function(rec) {
                    		currencyCombo.setValue(data.currency.id)
                    	}
                    })
                    
                    var startDateField = addRaiseFundTab.down('#startDateItemId');
					var endDateField = addRaiseFundTab.down('#endDateItemId');
					var currentDate = new Date();
					
					if (startDateField) {
					    // Set initial minValue for startDateField
					    var validFromDate = data.startDate ? new Date(data.startDate) : null;
					    if(validFromDate) {
					    	startDateField.setMinValue(validFromDate > currentDate ? currentDate : validFromDate);
					    } else {
					    	startDateField.setMinValue(currentDate)
					    }
					    startDateField.validate();
					
					    // Add change listener to dynamically update endDateField minValue
					    startDateField.on('change', function(field, newValue) {
					        if (endDateField) {
					            var selectedStartDate = new Date(newValue);
					
					            // Set the endDateField minValue
					            if (selectedStartDate < currentDate) {
					                endDateField.setMinValue(currentDate);
					            } else {
					                endDateField.setMinValue(selectedStartDate);
					            }
					
					            // Validate the endDateField to enforce the updated minValue
					            endDateField.validate();
					        }
					    });
					}
					
					if (endDateField) {
					    // Set initial minValue for endDateField
					    var startDate = data.startDate ? new Date(data.startDate) : null;
					    if (startDate && !data.endDate) {
					        endDateField.setMinValue(startDate > currentDate ? startDate : currentDate);
					    } else {
					        endDateField.setMinValue(currentDate);
					    }
					    endDateField.validate();
					}


                    // Handle nested data: alumniFundAcademyLocationMapping
                    var academyLocations = [];
                    Ext.each(data.alumniFundAcademyLocationMapping, function(item) {
                        academyLocations.push(item.academyLocation.id);
                    });

                    form.findField('academyLocations').getStore().load({
                        callback:function(records){
                        	form.findField('academyLocations').setValue(academyLocations);    
                            }
                    });

                    // Handle nested data: alumniDonationRange
                    var donationRangeContainer = addRaiseFundTab.down('#dynamicMainPanel');
                    // Sort the donationRanges array based on minimumValue
                    data.alumniDonationRange.sort(function(a, b) {
                        return a.minimumValue - b.minimumValue;
                    });
                    var count = 0;
                        
                    // Ensure donation ranges exist
                    if (data.alumniDonationRange.length) {
                        // Set the first donation range values
                        donationRangeContainer.down('#minAmt').setValue(data.alumniDonationRange[0].minimumValue);
                        donationRangeContainer.down('#maxAmt').setValue(data.alumniDonationRange[0].maximumValue);
                        
                        // If there is only one donation range, show the Add button
                        if (data.alumniDonationRange.length === 1) {
                            donationRangeContainer.down('#btnAddRange').setVisible(true);
                            donationRangeContainer.down('#btnAddRange').setDisabled(true);
                        } else {
                            donationRangeContainer.down('#btnAddRange').setVisible(false); // Hide Add button if more than one range exists
                        }
                        
                        count++;
                    }

                    // Loop through remaining donation ranges
                    for (; count < data.alumniDonationRange.length; count++) {
                        // Add a donation range field for all but the last item
                        if (count !== data.alumniDonationRange.length - 1) {
                            donationRangeContainer.add({
                                xtype: 'fieldcontainer',
                                layout: 'hbox',
                                defaults: {
                                    labelAlign: 'top',
                                    allowBlank: false,
                                    allowExponential: false
                                },
                                items: [{
                                    xtype: 'numberfield',
                                    name: 'minAmt',
                                    value: data.alumniDonationRange[count].minimumValue,
                                    width: 256,
                                    minValue: 1,
                                    listeners: {
                                        change: function(field, newValue) {
                                            var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                                            if (maxAmtField) {
                                                maxAmtField.setMinValue(newValue + 1);
                                                var maxAmtValue = maxAmtField.getValue();
                                                if (maxAmtValue <= newValue) {
                                                    maxAmtField.setValue(newValue + 1);  
                                                }
                                            }
                                        }
                                    }
                                }, {
                                    xtype: 'numberfield',
                                    name: 'maxAmt',
                                    value: data.alumniDonationRange[count].maximumValue,
                                    width: 256,
                                    minValue: 1
                                }]
                            });
                        } else {
                            // For the last item, include the add button
                            donationRangeContainer.add({
                                xtype: 'fieldcontainer',
                                layout: 'hbox',
                                defaults: {
                                    labelAlign: 'top',
                                    allowBlank: false,
                                    allowExponential: false
                                },
                                items: [{
                                    xtype: 'numberfield',
                                    name: 'minAmt',
                                    width: 256,
                                    value: data.alumniDonationRange[count].minimumValue,
                                    minValue: 1,
                                    listeners: {
                                        change: function(field, newValue) {
                                            var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                                            if (maxAmtField) {
                                                maxAmtField.setMinValue(newValue + 1);
                                                var maxAmtValue = maxAmtField.getValue();
                                                if (maxAmtValue <= newValue) {
                                                    maxAmtField.setValue(newValue + 1);  
                                                }
                                            }
                                        }
                                    }
                                }, {
                                    xtype: 'numberfield',
                                    name: 'maxAmt',
                                    width: 256,
                                    value: data.alumniDonationRange[count].maximumValue
                                }, {
                                    xtype: 'button',
                                    itemId: 'btnAddRange',
                                    cls: 'CustomBodyBtnSettings',
                                    style: {
//                                    	marginTop: '-2px',
//                                        marginLeft: '5px',
                                    },
                                    width: 30,
                                    height: 28,
                                    text: getAlumni('+'),
                                    disabled: true
                                }, {
                                    xtype: 'button',
                                    glyph: ICONGLYPH.DELETEGLYPH,
                                    itemId: 'btnDelRange',
                                    cls: 'CustomBodyBtnSettings',
                                    style: {
//                                        marginTop: '30px',
//                                        marginLeft: '10px',
                                    },
                                    width: 30,
                                    height: 28,
                                    handler: function(btn) {
                                    	var fieldContainer = btn.up('#dynamicMainPanel');
                                        var containers = fieldContainer.query('container[xtype=fieldcontainer]');
                                        
                                        if (containers.length > 1) {
                                            var lastContainer = containers[containers.length - 1];
                                            fieldContainer.remove(lastContainer);
                                            
                                            // Update the add/delete button states
                                            $this.updateButtons(fieldContainer);
                                        }
                                    }
                                }]
                            });
                        }
                    }  
                    
                    var alumniRaiseFunduploadImage = addRaiseFundTab.down('#alumniRaiseFunduploadImageItemId');
                    var imageFileName = data.imageUrl;

                    if(data.imageUrl){
                    	alumniRaiseFunduploadImage.down('#photoFileImage').setRawValue(imageFileName);
                    	form.findField('hiddenImage').setValue(imageFileName);
                    }
 
                    addRaiseFundTab.down('#startDateItemId').clearInvalid();
                    addRaiseFundTab.down('#endDateItemId').clearInvalid();
                    form.checkValidity();

                    
                    
                    $this.getAlumnifundsraisingaddraisefund().down('#btnResetItemId').setVisible(false);
                },
                failure: function() {
                    showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_LOAD_DATA'));
                }
            });
        }
    },
    
    viewAddRaiseFundPage: function() {
        var $this = this;
        var contentpanel = $this.getContentPanel();
        var grid = $this.getAlumnifundsraisinggrid();
        var tabName = getAlumni('VIEW_RAISE_FUND');
        var addRaiseFundTab = Ext.widget('alumnifundsraisingviewraisefund');
        var navigationController = $this.getController('menu.CoreERPNavigationController');
        var existingTab = navigationController.getTab(tabName);

        
        var oppositeTab = $this.getController('menu.CoreERPNavigationController').getTab(getAlumni('ADD_RAISE_FUND'));

        if (oppositeTab) {
          $this.getContentPanel().remove(oppositeTab, true);
       }
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];

            // Make AJAX request to fetch data by fundId
            Ext.Ajax.request({
                url: SERVERURL.PATH_ALUMNI_FUND_FETCH_FUNDID,
                type: 'rest',
                method: 'GET',
                params: { 
                    fundId: record.data.id
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(response) {
                    var data = Ext.decode(response.responseText);

                    // Access the form panel of the tab
                    var form = addRaiseFundTab.getForm();
                    

                    // Set basic form fields
                    form.findField('recordId').setValue(data.id);
                    form.findField('fundsCode').setValue(data.fundsCode);
                    form.findField('title').setValue(data.fundsTitle);
                    form.findField('donationGoal').setValue(data.donationGoal);
                    form.findField('status').setValue(data.status ? 'active' : 'inactive');
                    form.findField('description').setValue(data.description);
                    
                    if(data.startDate) {	
                    	form.findField('startDate').setValue(new Date(data.startDate));
                    } else {
                    	form.findField('startDate').setValue(null);
                    }
                    if(data.endDate) {	
                    	form.findField('endDate').setValue(new Date(data.endDate));
                    } else {
                    	form.findField('endDate').setValue(null);
                    }

                    // Set currency
                    var currencyCombo = form.findField('currency');
                    currencyCombo.getStore().load({
                    	callback:function(rec) {
                    		currencyCombo.setValue(data.currency.id)
                    	}
                    });
                    

                    // Handle nested data: alumniFundAcademyLocationMapping
                    var academyLocations = [];
                    Ext.each(data.alumniFundAcademyLocationMapping, function(item) {
                        academyLocations.push(item.academyLocation.id);
                    });
                    
                    form.findField('academyLocations').getStore().load({
                        callback:function(records){
                        		form.findField('academyLocations').setValue(academyLocations);    
                            }
                    });

                    // Handle nested data: alumniDonationRange
                    var donationRangeContainer = addRaiseFundTab.down('#dynamicMainPanel'); 
                    // Sort the donationRanges array based on minimumValue
                    data.alumniDonationRange.sort(function(a, b) {
                        return a.minimumValue - b.minimumValue;
                    });
                    var count = 0;
                    
    
                    // Ensure donation ranges exist
                    if (data.alumniDonationRange.length) {
                        // Set the first donation range values
                        donationRangeContainer.down('#minAmt').setValue(data.alumniDonationRange[0].minimumValue);
                        donationRangeContainer.down('#maxAmt').setValue(data.alumniDonationRange[0].maximumValue);  
                        count++;
                    }

                    // Loop through remaining donation ranges
                    for (; count < data.alumniDonationRange.length; count++) {
                            donationRangeContainer.add({
                                xtype: 'fieldcontainer',
                                layout: 'hbox',
                                defaults: {
                                    labelAlign: 'top',
                                    allowBlank: false,
                                    allowExponential: false
                                },
                                items: [{
                                    xtype: 'numberfield',
                                    name: 'minAmt',
                                    value: data.alumniDonationRange[count].minimumValue,
                                    width: 256,
                                    minValue: 1,
                                    readOnly: true,
                                    listeners: {
                                        change: function(field, newValue) {
                                            var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                                            if (maxAmtField) {
                                                maxAmtField.setMinValue(newValue + 1);
                                                var maxAmtValue = maxAmtField.getValue();
                                                if (maxAmtValue <= newValue) {
                                                    maxAmtField.setValue(newValue + 1);  
                                                }
                                            }
                                        }
                                    }
                                }, {
                                    xtype: 'numberfield',
                                    name: 'maxAmt',
                                    value: data.alumniDonationRange[count].maximumValue,
                                    width: 256,
                                    readOnly: true,
                                    minValue: 1
                                }]
                            });
                    }
                    
                    addRaiseFundTab.down('#startDateItemId').clearInvalid();
                    addRaiseFundTab.down('#endDateItemId').clearInvalid();
                    form.checkValidity();

                    if (!existingTab) {
                        openTab(contentpanel, tabName, addRaiseFundTab, CONSTANTS.MENU_COLOR_ONE);
                    } else {
                        contentpanel.remove(existingTab, true);
                        openTab(contentpanel, tabName, addRaiseFundTab, CONSTANTS.MENU_COLOR_ONE);
                    }
//                    $this.getAlumnifundsraisingaddraisefund().down('#btnResetItemId').setVisible(false);
                },
                failure: function() {
                    showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_LOAD_DATA'));
                }
            });
        }
    },
    
    deleteAlumniFunds: function(obj){
    	var this$ = this;
        var grid = this.getAlumnifundsraisinggrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
            var selectionModel = grid.getSelectionModel().getSelection();
            var idsArr = [];

            selectionModel.forEach(function (record) {
                idsArr.push(record.get('id')); 
            });

            var ids = idsArr.join();

           
            showConfirmMessage(getAlumni('FUND_RAISING_LIST'), getAlumni('DO_YOU_WANT_TO_DELETE'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');

                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_ALUMNI_FUND_RAISE_DELETE,
                        params: {
                        	alumniFundsIds: ids, 
                        },
                        method: 'POST',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    	
    },
    getGridButtonsPivileges:function(grid,permissionMap){

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    	
		var btnViewTransactions = grid.down('#btnViewTransactions');
		btnViewTransactions.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		
    		if (privilege === 'VIEW_TRANSACTIONS') {
        		if(!isNullOrEmpty(btnViewTransactions)){
        			btnViewTransactions.setVisible(true);
        		}        		
        	}
    	});
    },
    openViewFundTransactionPage: function() {
        var $this = this;
        var contentpanel = $this.getContentPanel();
        var tabName = getAlumni('VIEW_FUND');
        var addViewTransactionTab = Ext.widget('alumnifundsviewtransactionstructure')
        var navigationController = $this.getController('menu.CoreERPNavigationController');
        var fundsTransFilter = $this.getAlumnifundstransactionfilter();
        /////////////////////////////////////////////////////////////
        var grid = $this.getAlumnifundsraisinggrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	Ext.Ajax.request({
                url: SERVERURL.PATH_ALUMNI_FUND_FETCH_FUNDID,
                type: 'rest',
                method: 'GET',
                params: { 
                    fundId: record.data.id
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(response) {
                    var data = Ext.decode(response.responseText);

                    fundsTransFilter.recordId=data.id; 
                    
                },
                failure: function() {
                    showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_LOAD_DATA'));
                }
            });
        }
        ////////////////////////////////////////////////////////////
        
        var existingTab = navigationController.getTab(tabName);
        if (existingTab != null) {
            contentpanel.remove(existingTab, true);
        }
		
        openTab(contentpanel, tabName, addViewTransactionTab, CONSTANTS.MENU_COLOR_ONE);
    },
    

});
