/**
 * @author Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.controller.attendance.FacultyAttendanceController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	models : ['genericmodels.dropdowns.EnumCombo','attendance.FacultyListForFaculty','attendance.CourseLevelFacultyBlankModel','attendance.CourseFacultyAttendance'],
	stores : ['attendance.StudentAttendanceType','common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.StudentAttendanceStatus',
	          'attendance.SectionAndFacultyByPeriodID','attendance.FacultyAttendanceStatus','attendance.FacultyTimeSlot','attendance.FacultyListForFaculty',
	          'attendance.FacultyGridCompleteNMultipleSession','attendance.StudentCourses', 'course.coursecomponent.CourseComponentCouseWise',
	          'attendance.adminOtherEmpGridCompleteday',
	          'attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse','common.BatchesByProgramId','attendance.adminOtherEmpGridCompleteday',
	          'attendance.CourseLevelFacultyBlank','attendance.FacultyTopicListCourseLevel','attendance.CourseTopicCoverageStatus',
	          'course.coursevariants.CourseVariantStore','attendance.AssignedCoursesFacultyStore'],
	          views : ['Academia.view.attendance.FacultyAttendance','attendance.FacultyAttendanceGrid',
	                   'attendance.FacultyTopicCoverageGrid','attendance.FacultyGridCompleteNMultipleSession',
	                   'attendance.OtherEmployeeAttendance','attendance.AdminGridForSession'
	                   ],	           
	                   refs : [{
	    	        	   ref : 'attendancestructure',
	    	        	   selector : 'attendancestructure'
	    	           },{
	                	   ref : 'facultyattendance',
	                	   selector : 'facultyattendance'
	                   },{
	                	   ref : 'facultyattendancegrid',
	                	   selector : 'facultyattendancegrid'
	                   },{
	                	   ref : 'facultytopiccoveragegrid',
	                	   selector : 'facultytopiccoveragegrid'
	                   },{
	                	   ref : 'facultygridcompletenmultiplesession',
	                	   selector : 'facultygridcompletenmultiplesession'
	                   },{
	                	   ref : 'facultypncattendancestructure',
	                	   selector : 'facultypncattendancestructure'
	                   },{
	                	   ref : 'otheremployeeattendance',
	                	   selector : 'otheremployeeattendance'
	                   },{
	                	   ref : 'otheremployeandadminattendancestructure',
	                	   selector : 'otheremployeandadminattendancestructure'
	                   },{
	                	   ref : 'admingridforsession',
	                	   selector : 'admingridforsession'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   /*'facultyattendance textfield[itemId=academyLocationId]':{
	                			   blur: this.getProgramByAcademyLocation
	                		   },*/
	                		   /*'facultyattendance button[itemId=submitBtn]':{
	                			   click: this.saveFacultyAttendance
	                		   },*/
	                		   'facultypncattendancestructure button[itemId=submitBtn]':{
	                			   click: this.saveFacultyAttendance
	                		   },
	                		   'facultypncattendancestructure button[itemId=cancelBtn]':{
	                			   click: this.cancelFacultyAttendance
	                		   },
	                		   /*'facultyattendance customcombobox#programBatch_programId': {
	                			   select: function(obj, record) {
	                				   var programId = record[0].get("id");
	                				   if(programId > 0){
	                					   var form = this.getFacultyattendance();
	                					   form.down("#programBatch_batchId").setDisabled(false);
	                					   var store = this.getStore('enquiry.AcademicBatchStore');
	                					   store.getProxy().extraParams = {
	                						   id: programId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#programBatch_batchId': {
	                			   select: function(obj, record) {
	                				   var batchId = record[0].get("id");
	                				   if(batchId > 0){
	                					   var form = this.getFacultyattendance();
	                					   form.down("#periodIdItemId").setDisabled(false);
	                					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                					   store.getProxy().extraParams = {
	                						   id: batchId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },*/
	                		   /*'facultyattendance customcombobox#periodIdItemId': {
	                			   select: function(obj, record) {
	                				   var periodId = record[0].get("id");
	                				   if(periodId > 0){
	                					   var form = this.getFacultyattendance();
	                					   form.down("#programCoursection_ID").setDisabled(false);
	                					   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
	                					   store.getProxy().extraParams = {
	                						   periodId: periodId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },*/
	                		   'facultyattendance customcombobox#studentAtt_studentAttendanceType': {
	                			   select: function(obj, record) {
	                				   this.facultyAttendanceTypeDropdown(obj, record);
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#programCoursection_ID':{
	                			   select:function(obj, record){
	                				   this.facultyList();
	                			   }
	                		   },
	                		   
	                		   'facultyattendance numberfield#studentAtt_noOfBackDays':{
	                			   blur:function(obj, record){
	                				   var form = this.getFacultyattendance();
	                				   var value = obj.getValue();
	                				   var date = new Date();
	                				   var minDate = Ext.Date.add(date, Ext.Date.DAY, -value);
	                				   form.down("#dateOfAttendance_Id").setMinValue(minDate);
	                			   }
	                		   },
	                		   
	                		   'facultyattendance customcombobox#courseId': {
	                			   select: function(obj, record) {
	                				   this.courseNprogramSection(obj, record);
	                			   }
	                		   },
	                		   'facultyattendance datefield#dateOfAttendance_Id': {
	                			   select: function() {
	                				   this.facultyList();
	                			   }
	                		   },
	                		   'facultyattendance button[itemId=searchBtn]':{
	                			   click: function() {
	                				   //this.facultyList();
	                				   this.loadFacultyData();
	                			   }
	                		   },
	                		   'facultyattendance button[itemId=resetBtn]':{
	                			   click: function() {
	                				   //this.facultyList();
	                				   this.cancelFacultyAttendance();
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#courseProgramID':{
	                			   select:function(obj, record){
	                				   var programCourseId = record[0].get("programId");
	                				   var form = this.getFacultyattendance();
	                				   form.down("#programBatchCourseID").setDisabled(false);
	                				   var store = this.getStore('common.BatchesByProgramId');
	                				   store.getProxy().extraParams = {
	                					   id: programCourseId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#programBatchCourseID':{
	                			   select:function(obj, record){
	                				   var programBatchId = record[0].get("id");
	                				   if(programBatchId !=''){
	                					   var form = this.getFacultyattendance();
	                					   form.down("#programBatchPeriodID").setDisabled(false);
	                					   var store = form.down("#programBatchPeriodID").getStore();
	                					   store.getProxy().extraParams = {
	                						   id: programBatchId,
	                						   isCurrentPeriod:true
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#programBatchPeriodID':{
	                			   select:function(obj, record){
	                				   var programBatchPeriodId = record[0].get("id");
	                				   this.getFacultyattendance().down("#programCoursection_ID").setDisabled(false);
	                				   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
	                				   store.getProxy().extraParams = {
	                					   periodId:programBatchPeriodId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   /*'facultyattendance customcombobox#CourseSection_ID':{
	                			   select:function(obj, record){
	                				   var courseVariantId = record[0].data.courseVariantId;
	                				   var form = this.getFacultyattendance().getForm();
	                				   form.findField('courseVariantId').setValue(courseVariantId);
	                				 this.facultyList();
	                			   }
	                		   },*/
	                		   'facultyattendance customcombobox#courseVariantId':{
	                			   select:function(obj, record){
	                				   var courseVariantId = record[0].data.id;
	                				   var form = this.getFacultyattendance().getForm();
	                				   form.findField('courseVariantId').setValue(courseVariantId);
	                				 this.facultyList();
	                			   }
	                		   }, 'facultyattendance customcombobox#componentId':{
	                			   select:function(obj, record){
	                				   var componentId = record[0].get("id");
	                				   var form = this.getFacultyattendance();
	                				   var courseId = form.getForm().findField('courseId').getValue();
	                				   var store = this.getStore('attendance.SectionByCourseNComponent');
	                				   store.getProxy().extraParams = {
	                					   parentCourseId: courseId,
	                					   componentId:componentId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   /*'facultyattendance customcombobox#timeSlotListId':{
	                			   select:function(obj, record){
	                				   this.facultyFromTimeSlot(obj, record);
	                			   }
	                		   },*/'facultyattendancegrid button[itemId=btnAdd]':{
	                			   click:function(){
	                				   this.facultyAddInGrid();
	                			   }
	                		   },
	                		   /*'facultytopiccoveragegrid button[itemId=btnAdd]':{
	                			   click:function(){
	                				   this.topicAddInGrid();
	                			   }
	                		   },*/
	                		   'facultyattendance button[itemId=timeBtn]':{
	                			   click: this.timeFieldsAdd
	                		   },
	                		   'facultyattendance':{
	                			   render:function(){
	                				   this.getSessionValues();
	                			   }
	                		   },
	                		   'facultyattendance customcombobox#timeSlotListId':{
	    	        			   select:function(obj, record){
	    	        				   var form = this.getFacultyattendance();
	    	        				   form.down('#fromTime').clearValue();
	            					   form.down('#toTime').clearValue();
	    	        				   if(record.length > 0){
	    	        					   form.down('#fromTime').setDisabled(true);
	    	        					   form.down('#toTime').setDisabled(true);
	    	        				   }else{
	    	        					   form.down('#fromTime').setDisabled(false);
	    	        					   form.down('#toTime').setDisabled(false);
	    	        				   }
	    	        			   }
	    	        		   },
	    	        		   'facultyattendance timefield#fromTime':{
	    	        			   change:function(obj, record){
	    	        				   var form = this.getFacultyattendance();
	    	        				   if (!isNullOrEmpty(record)) {
	    	        					   form.down('#timeSlotListId').setDisabled(true);
	    	        				   }else{
	    	        					   form.down('#timeSlotListId').setDisabled(false);
	    	        				   }
	    	        				   
	    	        			   }
	    	        		   },
	    	        		   'facultyattendance timefield#toTime':{
	    	        			   change:function(obj, record){
	    	        				   var form = this.getFacultyattendance();
	    	        				   if (!isNullOrEmpty(record)) {
	    	        					   form.down('#timeSlotListId').setDisabled(true);
	    	        				   }else{
	    	        					   form.down('#timeSlotListId').setDisabled(false);
	    	        				   }
	    	        			   }
	    	        		   },
	    	        		   
	                		   'otheremployeeattendance button[itemId=searchBtn]':{
	                			   click: function() {
	                				   this.loadOtherEmployeeData();
	                			   }
	                		   },
	                		   
	                		   'otheremployeandadminattendancestructure button[itemId=saveattendanceBtn]':{
	                			   click: this.saveAdminOtherEmpAttendance
	                		   },
	                	   });
	                   },
	                   
	                   /**
                	    * facultyFromTimeSlot method for get faculty and
                	    *  get topic list on select of time slot
                	    */
	                   facultyFromTimeSlot:function(obj, record){

	                	   var timeSlot = record[0].data.value;
	                	   var $this = this;
	                	   var form = $this.getFacultyattendance().getForm();

	                	   var courseId =  form.findField('courseId').getValue();
	                	   var attendanceDate = form.findField('dateOfAttendance').getValue();
	                	   var date = Ext.Date.format(new Date(attendanceDate), 'Y-m-d');
	                	   var section;
	                	   var sectionId = form.findField('sectionId').getValue();
//	                	   var courseSectionId = form.findField('courseSectionId').getValue();
	                	   var courseVariant = form.findField('courseVariant');
	                	   var courseSectionId =null;
	                	   if(courseVariant.valueModels.length > 0){
	                		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	                	   }
	                	   if(sectionId != null && sectionId != ''){
	                		   section = sectionId;
	                	   }else{
	                		   section = courseSectionId;
	                	   }
	                	   var componentId = form.findField('componentId').getValue();

	                	   var store =$this.getStore('attendance.FacultyListForFaculty');
	                	   
	                	   var component;
	                	   if(componentId!="" && componentId!= null){
	                		   component = componentId;
	                		   
	                		   store.getProxy().extraParams = {
		                		   courseId:courseId,
		                		   componentId:component,
		                		   sectionId:section,
		                		   attendanceDate:date,
		                		   timeSlot: timeSlot
		                	   };
	                		   store.load({
		                		   callback: function(records, operation, success) {
		                			   if (success) {
		                				   if(records.length > 0){
		                					   var variantId =  records[0].data.variantId;
		                					   $this.getFacultyattendance().getForm().findField('variantId').setValue(variantId);

		                				   }		 
		                			   }
		                		   }	   
		                	   });
	                		   
	                	   }else{		 
	                		   /**
	                		    * if component id is null then store will load without componentId
	                		    */
	                		   store.getProxy().extraParams = {
		                		   courseId:courseId,
		                		   sectionId:section,
		                		   attendanceDate:date,
		                		   timeSlot: timeSlot
		                	   };
	                		   store.load({
		                		   callback: function(records, operation, success) {
		                			   if (success) {
		                				   if(records.length > 0){
		                					   var variantId =  records[0].data.variantId;
		                					   $this.getFacultyattendance().getForm().findField('variantId').setValue(variantId);

		                				   }		 
		                			   }
		                		   }	   
		                	   });
	                	   }
	                   },
	                   facultyAttendanceTypeDropdown:function(){
	                	   var $this = this;
	                	   var form = $this.getFacultyattendance();
	                	   var attendanceType = form.getForm().findField('attendanceType').getValue();
	                	   //var attendanceType = record[0].get("id");
	                	   var academyLocationId = this.getCurrentAcademyLocation();

	                	   if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
	                		   $this.getFacultygridcompletenmultiplesession().getStore().removeAll();

	                		   form.down("#timeContainer").setVisible(true);
	                		   form.down("#courseId").setVisible(false);
	                		   form.down("#programCoursection_ID").setVisible(false);
//	                		   form.down("#CourseSection_ID").setVisible(false);
	                		   form.down("#courseVariantId").setVisible(false);

	                		   var panelContiner = this.getFacultyattendance().down('#panelId');
	                		   if(panelContiner.items.length > 1){
	                			   for(var i=panelContiner.items.length;i>=1;i--){
	                				   panelContiner.remove(panelContiner.items.items[i]);
	                			   }
	                		   }

	                		   form.down("#fromTime").reset();
	                		   form.down("#toTime").reset();
//	                		   form.down("#CourseSection_ID").reset();
	                		   form.down("#courseVariantId").reset();
	                		   form.getForm().findField('courseVariantId').reset();
	                		   form.down('#dateOfAttendance_Id').reset();

	                		   form.down("#programBatchContainer").setVisible(false);
	                		   form.down("#programBatchPeriodID").setVisible(false);

	                		   
	                		   $this.getFacultypncattendancestructure().down("#facultyattendancegrid_Id").setVisible(false);
	                		   $this.getFacultypncattendancestructure().down("#facultygridcompletenmultiplesession_Id").setVisible(true);
	                		   //form.down("#facultyattendancegrid_Id").setVisible(false);
	                		   //form.down("#facultygridcompletenmultiplesession_Id").setVisible(true);

	                		   var store = $this.getStore('attendance.FacultyListForFaculty');
	                		   store.removeAll();
	                		   /*var topicStore = $this.getStore('attendance.FacultyTopicListCourseLevel');
	                		   topicStore.removeAll();*/

	                		   form.down("#courseId").allowBlank=true;
//	                		   form.down("#CourseSection_ID").allowBlank=true;
	                		   form.down("#courseVariantId").allowBlank=true;

	                		   form.down("#courseProgramID").allowBlank=true;
	                		   form.down("#programBatchCourseID").allowBlank=true;
	                		   form.down("#programBatchPeriodID").allowBlank=true;

	                		   form.down("#fromTime").allowBlank=false;
	                		   form.down("#toTime").allowBlank=false;

	                	   }else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	                		   $this.getFacultygridcompletenmultiplesession().getStore().removeAll();

	                		   var portalId = $this.getCurrentLoggedPortalId();
	        	    		   var facultyId = $this.getCurrentlyLoggedInUser();
	                		   
	                		   var studentCoursesStore = this.getStore('attendance.AssignedCoursesFacultyStore');
	                		   studentCoursesStore.getProxy().extraParams = {
	                			   academyLocationId:academyLocationId				
	                		   };
	                		   
	                		   if(portalId == 2) {
	        	    			   studentCoursesStore.getProxy().extraParams = {	
	        	    				   facultyId : facultyId.id,
	        	    				   academyLocationId:academyLocationId
	        	    			   };
	        	    		   }
	                		   
	                		   studentCoursesStore.load();

	                		   form.down("#courseId").setVisible(true);
	                		   form.down("#timeContainer").setVisible(true);
	                		   form.down("#fromTime").reset();
	                		   form.down("#toTime").reset();
	                		   form.down("#fromTime").allowBlank=false;
	                		   form.down("#toTime").allowBlank=false;
	                		   form.down('#dateOfAttendance_Id').reset();
//	                		   form.down("#CourseSection_ID").setVisible(true);
	                		   form.down("#courseVariantId").setVisible(true);

	                		   var panelContiner = this.getFacultyattendance().down('#panelId');

	                		   if(panelContiner.items.length > 1){
	                			   for(var i=panelContiner.items.length;i>=1;i--){
	                				   panelContiner.remove(panelContiner.items.items[i]);
	                			   }
	                		   }


	                		   form.down("#programCoursection_ID").setVisible(false);
	                		   $this.getFacultypncattendancestructure().down("#facultyattendancegrid_Id").setVisible(true);
	                		   $this.getFacultypncattendancestructure().down("#facultygridcompletenmultiplesession_Id").setVisible(false);
	                		   form.down('#dateOfAttendance_Id').reset();
	                		   form.down("#programBatchPeriodID").setVisible(false);

	                		   var store = $this.getStore('attendance.FacultyListForFaculty');
	                		   store.removeAll();

	                		   form.down("#programCoursection_ID").allowBlank=true;

	                	   }else if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	                		   $this.getFacultygridcompletenmultiplesession().getStore().removeAll();

	                		   form.down("#courseId").setVisible(false);
	                		   form.down("#timeContainer").setVisible(false);
	                		   form.down("#fromTime").reset();
	                		   form.down("#toTime").reset();
	                		   form.down("#fromTime").allowBlank=true;
	                		   form.down("#toTime").allowBlank=true;
	                		   var timeContiner = this.getFacultyattendance().down('#panelId');
	                		   if(timeContiner.items.length > 1){
	                			   for(var i=1;i<timeContiner.items.length;i++){
	                				   timeContiner.items.items[i].removeAll();
	                			   }
	                		   }

//	                		   form.down("#CourseSection_ID").setVisible(false);
	                		   form.down("#courseVariantId").setVisible(false);
//	                		   form.down("#CourseSection_ID").reset();
	                		   form.down("#courseVariantId").reset();
	                		   form.down("#programCoursection_ID").setVisible(false);
	                		   form.down("#programCoursection_ID").allowBlank=true;
	                		   form.down("#programBatchContainer").setVisible(false);
	                		   form.down("#programBatchPeriodID").setVisible(false);

	                		   
	                		   $this.getFacultypncattendancestructure().down("#facultyattendancegrid_Id").setVisible(false);
	                		   $this.getFacultypncattendancestructure().down("#facultygridcompletenmultiplesession_Id").setVisible(true);
	                		   //form.down("#facultyattendancegrid_Id").setVisible(false);
	                		   //form.down("#facultygridcompletenmultiplesession_Id").setVisible(true);

	                		   var store = $this.getStore('attendance.FacultyListForFaculty');
	                		   store.removeAll();
	                		   /*var topicStore = $this.getStore('attendance.FacultyTopicListCourseLevel');
	                		   topicStore.removeAll();*/

	                		   form.down("#dateOfAttendance_Id").allowBlank=true;
	                		   form.down("#courseId").allowBlank=true;
//	                		   form.down("#CourseSection_ID").allowBlank=true;
	                		   form.down("#courseVariantId").allowBlank=true;
	                		   form.down("#fromTime").allowBlank=true;
	                		   form.down("#toTime").allowBlank=true;
	                		   form.down("#courseProgramID").allowBlank=true;
	                		   form.down("#programBatchCourseID").allowBlank=true;
	                		   form.down("#programBatchPeriodID").allowBlank=true;
	                	   }

	                   },
	                   courseNprogramSection:function(obj, record){
	                	   var $this =this;
	                	   var form = $this.getFacultyattendance();
	                	   var courseId = record[0].data.courseId;
	                	   var courseData = record[0].data;
	                	   if(courseData.sectionType == 'CourseSection'){

	                		   form.down("#programBatchContainer").setVisible(false);
	                		   form.down("#programBatchPeriodID").setVisible(false);
	                		   
//	                		   form.down("#CourseSection_ID").setVisible(true);
	                		   form.down("#courseVariantId").setVisible(true);
	                		   form.down("#programCoursection_ID").setVisible(false);
	                		   form.down("#programCoursection_ID").reset();
	                		   form.down("#variantId_Id").reset();
	                		   form.down("#dateOfAttendance_Id").reset();

	                		   form.down("#courseProgramID").reset();
	                		   form.down("#programBatchCourseID").reset();
	                		   form.down("#programBatchPeriodID").reset();

	                		   form.down("#courseProgramID").allowBlank=true;
	                		   form.down("#programBatchCourseID").allowBlank=true;
	                		   form.down("#programBatchPeriodID").allowBlank=true;

	                		   var store = $this.getStore('attendance.FacultyListForFaculty');
	                		   store.removeAll();
	                		   /*var topicStore = $this.getStore('attendance.FacultyTopicListCourseLevel');
	                		   topicStore.removeAll();*/


	                		   if(courseData.sectionAtComponentLevel == true){
	                			   form.down("#componentId").setVisible(true);
	                			   var componentField = form.down("#componentId");
	                			   componentField.allowBlank=false;
	                			   componentField.setFieldLabel( getCourseTxCommonTranslation('COMPONENT')+'<span class="required" style="color:red"> *</span>');

	                			   //var store = $this.getStore('course.courseequivalence.CourseComponentEquivalenceStore');
	                			   var store = this.getStore('course.coursecomponent.CourseComponentCouseWise');
	                			   store.getProxy().extraParams = {
	                				   courseId: courseId
	                			   };
	                			   store.load();
	                		   }else{
	                			   form.down("#componentId").setVisible(false);
	                			   form.down("#componentId").allowBlank=true;
	                			   form.down("#componentId").reset();
	                			   form.getForm().findField('componentId').setValue(null);
	                		   }
	                		   var componentId = form.getForm().findField('componentId').getValue();

	                		   if(componentId == "" && componentId == null){
	                			   componentId ='';
	                		   }

//	                		   var store = $this.getStore('attendance.SectionByCourseNComponent');
	                		   var store = $this.getStore('course.coursevariants.CourseVariantStore');
	                		   store.getProxy().extraParams = {
	                			   courseId: courseId,
	    	        			   sectionAtComponentLevel:courseData.sectionAtComponentLevel
	                		   };
	                		   store.load();

	                	   }else if(courseData.sectionType == 'ProgramBatchSection'){

	                		   form.down("#programBatchContainer").setVisible(true);
	                		   form.down("#programBatchPeriodID").setVisible(true);
	                		   
	                		   form.down("#courseProgramID").setDisabled(false);
//	                		   form.down("#CourseSection_ID").setVisible(false);
	                		   form.down("#courseVariantId").setVisible(false);
	                		   form.down("#programCoursection_ID").setVisible(true);
	                		   form.down("#courseVariantId_Id").reset();
	                		   form.down("#dateOfAttendance_Id").reset();
//	                		   form.down("#CourseSection_ID").allowBlank=true;
	                		   form.down("#courseVariantId").allowBlank=true;
//	                		   form.down("#CourseSection_ID").reset();
	                		   form.down("#courseVariantId").reset();

	                		   var store = $this.getStore('attendance.FacultyListForFaculty');
	                		   store.removeAll();
	                		   /*var topicStore = $this.getStore('attendance.FacultyTopicListCourseLevel');
	                		   topicStore.removeAll();*/

	                		   if(courseData.sectionAtComponentLevel == true){
	                			   form.down("#componentId").setVisible(true);
	                			   //var store = $this.getStore('course.courseequivalence.CourseComponentEquivalenceStore');
	                			   var store = this.getStore('course.coursecomponent.CourseComponentCouseWise');
	                			   store.getProxy().extraParams = {
	                				   courseId: courseId
	                			   };
	                			   store.load();
	                		   }else{
	                			   form.down("#componentId").setVisible(false);
	                		   }

	                		   var academyLocationId = this.getCurrentAcademyLocation();
	                		   var store = $this.getStore('attendance.AllProgramMappedByCourse');
	                		   store.getProxy().extraParams = {
	                			   courseId:courseId,
	                			   academyLocationId:academyLocationId
	                		   };
	                		   store.load();
	                	   }
	                   },
	                   facultyList:function(){
	                	   var $this = this;
	                	   var form = $this.getFacultyattendance().getForm();
//	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var attendanceType =  form.findField('attendanceType').getValue();
	                	   var courseId =  form.findField('courseId').getValue();
	                	   //var academyLocation =  form.findField('academyLocation').getValue();
	                	   
	                	   var dateOfAttendance =  form.findField('dateOfAttendance').getValue();
	                	   
	                	   var section;
	                	   var sectionId = form.findField('sectionId').getValue();
	                	   var courseVariant = form.findField('courseVariant');
	                	   var courseSectionId =null;
	                	   if(courseVariant.valueModels.length > 0){
	                		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	                	   }
//	                	   var courseSectionId = form.findField('courseSectionId').getValue();
	                	   
	                	   if(sectionId != null && sectionId != ''){
	                		   section = sectionId;
	                	   }else{
	                		   section = courseSectionId;
	                	   }
	                	   //var sessionPlanningFlag = form.findField('sessionPlanningFlag').getValue();
	                	   
	                	   var componentId = form.findField('componentId').getValue();
	                	   var component;
	                	   if(componentId!="" && componentId!= null){
	                		   component = componentId;   
	                	   }else{
	                		   component =null;
	                	   }
	                	   
	                	    var date = Ext.Date.format(new Date(dateOfAttendance), 'Y-m-d'); 
	                	    
	                	   if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	                		  var sessionPlanningDone;
	                		  var store =$this.getStore('attendance.FacultyTimeSlot');
	                		   store.getProxy().extraParams = {
	    								courseId:courseId,
	 	 	                		   componentId:component,
	 	 	                		   sectionId:section,
	 	 	                		   attendanceDate:date
	 	 	                		   //sessionPlanningFlag:sessionPlanningFlag
        					   };
        					   store.load({
        						   callback: function(records, operation, success) {
        							   if (success) {
        								   if(records.length > 0){

        									   sessionPlanningDone = true;
//        									   $this.getFacultyattendance().down("#timeContainer").setVisible(false);
        									   
//        									   $this.getFacultyattendance().down("#fromTime").setDisabled(true);
//        									   $this.getFacultyattendance().down("#toTime").setDisabled(true);
//        									   $this.getFacultyattendance().down("#fromTime").allowBlank=true;
//        									   $this.getFacultyattendance().down("#toTime").allowBlank=true;
        									   
//        									   $this.getFacultyattendance().down("#timeSlotListId").setVisible(true);
        									   $this.getFacultyattendance().down("#timeSlotListId").setDisabled(false);

        									   var facultyGrid = $this.getFacultyattendancegrid();
        									   var buttonsToolBar = facultyGrid.query('toolbar')[0];
        									   var facultyAddBtn = buttonsToolBar.query('#btnAdd')[0];
        									   facultyAddBtn.setDisabled(false);

        									   /*var topicGrid = $this.getFacultytopiccoveragegrid();
        									   var buttonsToolBar = topicGrid.query('toolbar')[0];
        									   var facultyAddBtn = buttonsToolBar.query('#btnAdd')[0];
        									   facultyAddBtn.setDisabled(false);*/

        								   }else{
        									   $this.getFacultyattendance().down("#timeContainer").setVisible(true);
//        									   $this.getFacultyattendance().down("#timeSlotListId").setVisible(false);
        									   $this.getFacultyattendance().down("#timeSlotListId").setDisabled(true);
        									   
//        									   $this.getFacultyattendance().down("#fromTime").setDisabled(false);
//        									   $this.getFacultyattendance().down("#toTime").setDisabled(false);
//        									   $this.getFacultyattendance().down("#timeBtn").setDisabled(false);
        									   
//        									   $this.getFacultyattendance().down("#fromTime").allowBlank=false;
//        									   $this.getFacultyattendance().down("#toTime").allowBlank=false;
        									   sessionPlanningDone = false;/*
        									   sessionPlanningDone = false;

        									   $this.getFacultyattendance().down("#timeContainer").setVisible(true);
        									   $this.getFacultyattendance().down("#timeSlotListId").setVisible(false);
        									   $this.getFacultyattendance().down("#fromTime").allowBlank=false;
        									   $this.getFacultyattendance().down("#toTime").allowBlank=false;

        									   var store =$this.getStore('attendance.FacultyListForFaculty');
        									   store.getProxy().extraParams = {
        										   courseId:courseId,
        										   componentId:component,
        										   sectionId:section,
        										   attendanceDate:date
        									   };
        									   store.load({
        										   callback: function(records, operation, success) {
        											   if (success) {
        												   if(records.length > 0){
        													   var variantId =  records[0].data.variantId;
        													   $this.getFacultyattendance().getForm().findField('variantId').setValue(variantId);

        												   }		 
        											   }
        										   }
        									   });

        								   */}
        								   $this.getFacultyattendance().getForm().findField('sessionPlanningDone').setValue(sessionPlanningDone);

        								   /*if(!sessionPlanningDone){
        									   var topicStore =$this.getStore('attendance.FacultyTopicListCourseLevel');
        									   topicStore.getProxy().extraParams = {
        										   courseId:courseId,
        										   componentId:component,
        										   sectionId:section,
        										   attendanceDate:date,
        										   sessionPlanningDone:sessionPlanningDone
        									   };
        									   topicStore.load();
        								   }*/

        							   }
        						   }
        					   });
        					
	                	  }/*else{
	                		  var store = this.getStore('attendance.FacultyGridCompleteNMultipleSession');
		                	    store.getProxy().extraParams = {
		                	    	academyLocationId:academyLocationId,
		                	    	date:date
		                	    };
		    	    	        store.load();
	                	  }*/
	                   },
	                   facultyAddInGrid:function(){
	                	   var $this = this;
	                	   var form = $this.getFacultyattendance().getForm();
	                	   var courseId =  form.findField('courseId').getValue();
	                	   var section;
	                	   var sectionId = form.findField('sectionId').getValue();
	                	   var courseVariant = form.findField('courseVariant');
	                	   var courseSectionId =null;
	                	   if(courseVariant.valueModels.length > 0){
	                		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	                	   }
//	                	   var courseSectionId = form.findField('courseSectionId').getValue();
	                	   if(sectionId != null && sectionId != ''){
	                		   section = sectionId;
	                	   }else{
	                		   section = courseSectionId;
	                	   }
	                	   var componentId = form.findField('componentId').getValue();
	                	   var component;
	                	   if(componentId!="" && componentId!= null){
	                		   component = componentId;   
	                	   }else{
	                		   component =null;
	                	   }

	                	   var store = $this.getStore('attendance.FacultyListForFaculty');
	                	   var ids=[];
	                	   for(var i=0; i< store.data.items.length ;i++){
	                		   ids.push(store.data.items[i].data.facultyId);
	                	   }
	                	   var topicIds =ids.join();

	                	   Ext.Ajax.request({
	                		   type : 'rest',
	                		   url : SERVERURL.FIND_FACULTIES_EXCEPT_PASSED_ID,
	                		   params : {
	                			   courseId:courseId,
	                			   componentId:component,
	                			   sectionId:section,
	                			   facultyList:topicIds
	                		   },
	                		   method : 'GET',
	                		   success : function(form, action) {
	                			   var res = Ext.JSON.decode(form.responseText);
	                			   var record = [];
	                			   for(var i=0;i<res.length;i++){
	                				   record.push({
	                					   "facultyName" :res[i].facultyName,
	                					   "facultyId":res[i].facultyId
	                				   });
	                			   }
	                			   var store = $this.getStore('attendance.FacultyListForFaculty');
	                			   store.loadRawData(record,true);
	                			   var coverageGrid = $this.getFacultyattendancegrid();
                  				   var buttonsToolBar = coverageGrid.query('toolbar')[0];
                  				   var addBtn = buttonsToolBar.query('#btnAdd')[0];
                  				   addBtn.setDisabled(true);
	                		   }
	                	   });
	                   },
	                   cancelFacultyAttendance:function(){
	                	   var $this =this;
	                	   var facultyForm = this.getFacultyattendance().getForm();
	                	   
	                	   facultyForm.findField("courseId").clearValue();
                		   facultyForm.findField("componentId").clearValue();
//                		   facultyForm.findField("courseSectionId").clearValue();
                		   facultyForm.findField("courseVariant").clearValue();
                		   facultyForm.findField("courseProgramId").clearValue();
                		   facultyForm.findField("programBatchCourse").clearValue();
                		   facultyForm.findField("programBatchPeriod").clearValue();
                		   facultyForm.findField("sectionId").clearValue();
                		   facultyForm.findField("courseProgramId").setDisabled(true);
                		   facultyForm.findField("programBatchCourse").setDisabled(true);
                		   facultyForm.findField("programBatchPeriod").setDisabled(true);
                		   facultyForm.findField("sectionId").setDisabled(true);
                		   
	                	   var store = $this.getStore('attendance.FacultyListForFaculty');
	                	   store.removeAll();
	     	        	  
	     	        	  var fromTime =facultyForm.findField("fromTime");
	     	        	  var toTime = facultyForm.findField("toTime");
	     	        	 fromTime.setDisabled(false);
	     	        	 toTime.setDisabled(false);
	     	        	 
	                	  var timeSlot = facultyForm.findField("timeSlotList");
	     	        	  if((!timeSlot.isHidden()) && (!timeSlot.isDisabled())){
	     	        		  timeSlot.clearValue();
	     	        		  timeSlot.setDisabled(true);
	     	        	  }
	     	        	 /*if((!fromTime.isDisabled() && !toTime.isDisabled()) && 
	     	        			 (!fromTime.isHidden() && !toTime.isHidden())){*/
	     	        		  fromTime.clearValue();
	     	        		  toTime.clearValue();
//	     	        	  }
	                	   /*var topicStore = this.getStore('attendance.FacultyTopicListCourseLevel');
	                	   topicStore.removeAll();*/
	                	   var facultyStore = $this.getStore('attendance.FacultyGridCompleteNMultipleSession');
	                	   facultyStore.removeAll();
	                	   $this.getFacultypncattendancestructure().down('#submitBtn').setDisabled(true);
	                	   
	                   },
	                   saveFacultyAttendance:function(){
	                	   var $this = this;
	                	   /*
	                	    * @author Surendra
	                	    * Fixed: without selecting faculty attendance should not mark
	                	    */
	                	   var facultyGrid = null;
	                	   facultyGrid = $this.getFacultypncattendancestructure().down("#facultyattendancegrid_Id");
	                	   if(facultyGrid.getSelectionModel().getCount()==0||facultyGrid==null){
	                		   facultyGrid =$this.getFacultypncattendancestructure().down("#facultygridcompletenmultiplesession_Id");
	                	   }
	                	   if(facultyGrid.getSelectionModel().getCount() <= 0) {
	                		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	                		   return;
	                	   }
	                	   // End
	                	   
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var form = $this.getFacultyattendance().getForm();
	                	   var values = form.getValues();
	                	   var timeContiner = this.getFacultyattendance().down('#panelId');
	     	        	   var timeFieldsCount = timeContiner.items.length;

	                	   if(values.attendanceType == 'Course Level' || values.attendanceType == 'COURSE_LEVEL'){

	                		   var courseFacultyAttendance = new Academia.model.attendance.CourseFacultyAttendance();

	                		   var variant;
	                		   var courseVariantId = form.findField('courseVariantId').getValue();
	                		   var variantId = form.findField('variantId').getValue();
	                		   if(courseVariantId !="" && courseVariantId !=null){
	                			   variant = courseVariantId;
	                		   }else{
	                			   variant = variantId;
	                		   }
	                		   
	                		   var courseVariant = form.findField('courseVariant');
		                	   var courseSectionId =null;
		                	   if(courseVariant.valueModels.length > 0){
		                		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
		                	   }
	                		   
	                		   var section;
//	                		   if(values.courseSectionId != "" && values.courseSectionId !=null){
	                		   if (!isNullOrEmpty(courseSectionId)) {
	                			   section = courseSectionId;
	                		   }else{
	                			   section =values.sectionId;
	                		   }
	                		   
	                		   var componentId = form.findField('componentId').getValue();
	                		   courseFacultyAttendance.set("courseId",values.courseId);
	                		   courseFacultyAttendance.set("sectionId",section);
	                		   courseFacultyAttendance.set("courseVariantId",variant );
	                		   courseFacultyAttendance.set("dateOfAttendance",values.dateOfAttendance);
	                		   courseFacultyAttendance.set("academyLocationId",academyLocationId);
	                		   if(componentId!="" && componentId!= null){
	                			   courseFacultyAttendance.set("componentId",componentId);
	                		   }

	                		   var dateTimeList =[];
	                		   
	                		   if(timeFieldsCount > 1){
	     	        			  for(var j=0; j<values.fromTime.length &&  values.toTime.length; j++){
	     	        				  dateTimeList.push({
	     	        					  "fromTime":values.fromTime[j],
	     	        					  "toTime": values.toTime[j]
	     	        				  });
	     	        			  }
	     	        			 courseFacultyAttendance.set("dateTimeList",dateTimeList);
	     	        		  }else{
	     	        			  dateTimeList.push({
	             					  "fromTime":values.fromTime,
	             					  "toTime": values.toTime
	             				  });
	     	        			 courseFacultyAttendance.set("dateTimeList",dateTimeList);
	     	        		  } 

	                		   
	                		   var timeSlotLists =[];
	                		   if(values.timeSlotList !=null && values.timeSlotList !=""){
	                			   timeSlotLists.push({
	                				   "timeSlot":values.timeSlotList
	                			   });
	                			   courseFacultyAttendance.set("timeSlots",timeSlotLists);
	                		   }else{
	                			   courseFacultyAttendance.set("timeSlots",null);   
	                		   }
	                		   

	                		   var facultyCourseAttendanceDetails =[];
	                		  /* var store = this.getFacultygridcompletenmultiplesession().getStore();
	                		   if(facultyGrid.length > 0 ){

	                			   for(var i=0;i<facultyGrid.length;i++){

	                				   if(!facultyGrid[i].data.attendance){
	                					   facultyCourseAttendanceDetails.push({
	                						   "facultyId":facultyGrid[i].data.facultyId,
	                						   "status": 'PRESENT',
	                						   "id":facultyGrid[i].data.id
	                					   }); 
	                				   }else{
	                					   var attendanceTest;
	                					   if(facultyGrid[i].data.attendance == 'Present'){
	                						   attendanceTest = 'PRESENT';
	                					   } else if(facultyGrid[i].data.attendance == 'Absent'){
	                						   attendanceTest = 'ABSENT';
	                					   }else{
	                						   attendanceTest = 'LEAVE';
	                					   }
	                					   facultyCourseAttendanceDetails.push({
	                						   "facultyId":facultyGrid[i].data.facultyId,
	                						   "status": attendanceTest,
	                						   "id":facultyGrid[i].data.id
	                					   });

	                				   } 
	                			   }
	                		   } */
	                		   var store = facultyGrid.getStore();
	                		   courseFacultyAttendance.set("id", store.data.items[0].data.attendanceId);
	                		   var records = facultyGrid.getSelectionModel().getSelection();
	                		   var models = store.getRange();
	                		   for(var i=0;i<store.data.length;i++){
	                			   var attendanceTest;
	                			   if(records[i].data.attendance == null || records[i].data.attendance == 'PRESENT' || records[i].data.attendance == 'Present'){
	                				   attendanceTest = 'PRESENT';
	                			   }else if(records[i].data.attendance == 'ABSENT' || records[i].data.attendance == 'Absent'){
	                				   attendanceTest = 'ABSENT';
	                			   }else if(records[i].data.attendance == 'LEAVE' || records[i].data.attendance == 'Leave'){
	                				   attendanceTest = 'LEAVE';
	                			   }else if(records[i].data.attendance == 'SICK_LEAVE' || records[i].data.attendance == 'Leave'){
	                				   attendanceTest = 'SICK_LEAVE';
	                			   }
	                			   facultyCourseAttendanceDetails.push({
	                				   "facultyId":store.data.items[i].data.facultyId,
	                				   "status":attendanceTest
	                			   });
	                		   }
	                		   courseFacultyAttendance.set("facultyCourseAttendanceDetails",facultyCourseAttendanceDetails);
	                		   courseFacultyAttendance.set("courseTopicCoverages",null);

	                		   var submitUrl;
	                		   if (form.findField('id').getSubmitValue() == null
	                				   || form.findField('id' ).getSubmitValue() == "") {
	                			   submitUrl = SERVERURL.SAVE_COURSE_FACULTY_ATTENDANCE;
	                		   } else {
	                			   courseReading.set("id", values.id);
//	                			   submitUrl = SERVERURL.;
	                		   }
	                		   var formData = Ext.encode(courseFacultyAttendance.data);
	                		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                		   Ext.Ajax.request({
	                			   type : 'rest',
	                			   url : submitUrl,
	                			   jsonData : formData,
	                			   method : 'POST',
	                			   success : function(form, action) {
	                				   Ext.getBody().unmask();
//	                				   Ext.JSON.decode(form.responseText);
	                				   var msg = form.responseText;
	                				   if(msg!='' && msg=='SUCCESS'){
	                					   showSuccessMessage(getProgramandcourseTranslation('FACULTY_ATTENDANCE'),getProgramandcourseTranslation('FACULTY_ATTENDANCE_SAVE'));
		                				   $this.cancelFacultyAttendance();
	                				   } else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	                					   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));  
	                				   } else {
	                				   }	                				   
	                			   }
	                		   });
	                	   }else{

	                		   var typeOfAttendanc;
	                		   if(values.attendanceType == 'Complete Day' || values.attendanceType == 'COMPLETE_DAY'){
	                			   typeOfAttendanc = 'COMPLETE_DAY';
	                		   }else if(values.attendanceType == 'Multiple Session' || values.attendanceType == 'MULTIPLE_SESSION'){
	                			   typeOfAttendanc = 'MULTIPLE_SESSION';
	                		   }else{
	                			   typeOfAttendanc = 'COURSE_LEVEL';
	                		   }

	                		   var statusOfAttendanc;
	                		   if(values.attendanceStatus == 'Present' || values.attendanceStatus == 'PRESENT'){
	                			   statusOfAttendanc = 'PRESENT';
	                		   }else if(values.attendanceStatus == 'Leave' || values.attendanceStatus == 'LEAVE'){
	                			   statusOfAttendanc = 'LEAVE';
	                		   }else{
	                			   statusOfAttendanc = 'ABSENT';
	                		   }


	                		   var store = this.getFacultygridcompletenmultiplesession().getStore();
	                		   var facultyAttendance =new Array();

	                		   for(var i=0; i<store.data.items.length ;i++ ){

	                			   var statusOfAttendanc;

	                			   if(!store.data.items[i].data.attendance){
	                				   statusOfAttendanc = 'PRESENT';
	                			   }else{

	                				   if(store.data.items[i].data.attendance == 'Present' || store.data.items[i].data.attendance == 'PRESENT'){
	                					   statusOfAttendanc = 'PRESENT';
	                				   }else if(store.data.items[i].data.attendance == 'Leave' || store.data.items[i].data.attendance == 'LEAVE'){
	                					   statusOfAttendanc = 'LEAVE';
	                				   }else{
	                					   statusOfAttendanc = 'ABSENT';
	                				   }
	                			   }
	                			   if(values.attendanceType == 'Complete Day' || values.attendanceType == 'COMPLETE_DAY'){  

	                				   facultyAttendance.push({
	                					   "academyLocationId":academyLocationId,
	                					   "dateOfAttendance":values.dateOfAttendance,
	                					   "attendanceType":typeOfAttendanc,
	                					   "facultyId":store.data.items[i].data.id,
	                					   "attendanceStatus":statusOfAttendanc,
	                					   "id":store.data.items[i].data.attendanceId
	                				   });
	                			   }else{
	                				   var dateTimeList =[];

	                				   if(timeFieldsCount > 1){
	                					   for(var j=0; j<values.fromTime.length &&  values.toTime.length; j++){
	                						   dateTimeList.push({
	                							   "fromTime":values.fromTime[j],
	                							   "toTime": values.toTime[j]
	                						   });
	                					   }
	                				   }else{
	                					   dateTimeList.push({
	                						   "fromTime":values.fromTime,
	                						   "toTime": values.toTime
	                					   });
	                				   }

	                				   facultyAttendance.push({
	                					   "academyLocationId":academyLocationId,
	                					   "dateOfAttendance":values.dateOfAttendance,
	                					   "attendanceType":typeOfAttendanc,
	                					   "facultyId":store.data.items[i].data.id,
	                					   "attendanceStatus":statusOfAttendanc,
	                					   "dateTimeList":dateTimeList,
	                					   "id":store.data.items[i].data.attendanceId
	                				   });
	                			   }
	                		   }
	                		   var submitUrl;
	                		   if (form.findField('id').getSubmitValue() == null
	                				   || form.findField('id' ).getSubmitValue() == "") {
	                			   submitUrl = SERVERURL.SAVE_FACULTY_PROGRAM_ATTENDANCE;
	                		   } else {
	                			   courseReading.set("id", values.id);
	                			   //submitUrl = SERVERURL.;
	                		   }
	                		   var formData = Ext.encode(facultyAttendance.data);
	                		   Ext.Ajax.request({
	                			   type : 'rest',
	                			   url : submitUrl,
	                			   //jsonData : formData,
	                			   jsonData : facultyAttendance,
	                			   method : 'POST',
	                			   success : function(form, action) {
	                				   //Ext.JSON.decode(form.responseText);
	                				   var msg = form.responseText;
	                				   if(msg!='' && msg=='SUCCESS'){
	                					   showSuccessMessage(getProgramandcourseTranslation('FACULTY_ATTENDANCE'),getProgramandcourseTranslation('FACULTY_ATTENDANCE_SAVE'));
		                				   $this.cancelFacultyAttendance();
	                				   } else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	         	        				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
	         	        			   } else{
	         	        				  console.log('error while fetching message, msg :'+msg);
	         	        			   }
	                				   
	                			   }
	                		   });

	                	   }
	                   },
	    	    
	                   saveAdminOtherEmpAttendance:function(){
	                	   
	                	   var $this = this;
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var form = $this.getOtheremployeeattendance().getForm();
	                	   var values = form.getValues();
	                	   /*var timeContiner = this.getFacultyattendance().down('#panelId');
	     	        	   var timeFieldsCount = timeContiner.items.length;*/

                		   typeOfAttendanc = 'COMPLETE_DAY';
                		   
                		   var statusOfAttendanc;
                		   if(values.attendanceStatus == 'Present' || values.attendanceStatus == 'PRESENT'){
                			   statusOfAttendanc = 'PRESENT';
                		   }else if(values.attendanceStatus == 'Leave' || values.attendanceStatus == 'LEAVE'){
                			   statusOfAttendanc = 'LEAVE';
                		   }else{
                			   statusOfAttendanc = 'ABSENT';
                		   }


                		   var store = this.getAdmingridforsession().getStore();
                		   var adminAttendance =new Array();

                		   for(var i=0; i<store.data.items.length ;i++ ){

                			   var statusOfAttendanc;

                			   if(!store.data.items[i].data.attendance){
                				   statusOfAttendanc = 'PRESENT';
                			   }else{

                				   if(store.data.items[i].data.attendance == 'Present' || store.data.items[i].data.attendance == 'PRESENT'){
                					   statusOfAttendanc = 'PRESENT';
                				   }else if(store.data.items[i].data.attendance == 'Leave' || store.data.items[i].data.attendance == 'LEAVE'){
                					   statusOfAttendanc = 'LEAVE';
                				   }else{
                					   statusOfAttendanc = 'ABSENT';
                				   }
                			   }
                			   if(typeOfAttendanc == 'Complete Day' || typeOfAttendanc == 'COMPLETE_DAY'){  

                				   adminAttendance.push({
                					   "academyLocationId":academyLocationId,
                					   "dateOfAttendance":values.dateOfAttendance,
                					   "attendanceType":typeOfAttendanc,
                					   "facultyId":store.data.items[i].data.id,
                					   "attendanceStatus":statusOfAttendanc
                				   });
                			   }else{
                				   var dateTimeList =[];

                				   if(timeFieldsCount > 1){
                					   for(var j=0; j<values.fromTime.length &&  values.toTime.length; j++){
                						   dateTimeList.push({
                							   "fromTime":values.fromTime[j],
                							   "toTime": values.toTime[j]
                						   });
                					   }
                				   }else{
                					   dateTimeList.push({
                						   "fromTime":values.fromTime,
                						   "toTime": values.toTime
                					   });
                				   }

                				   adminAttendance.push({
                					   "academyLocationId":academyLocationId,
                					   "dateOfAttendance":values.dateOfAttendance,
                					   "attendanceType":typeOfAttendanc,
                					   "facultyId":store.data.items[i].data.id,
                					   "attendanceStatus":statusOfAttendanc,
                					   "dateTimeList":dateTimeList
                				   });
                			   }
	                		   }
	                		   var submitUrl;
	                		   if (form.findField('id').getSubmitValue() == null
	                				   || form.findField('id' ).getSubmitValue() == "") {
	                			   submitUrl = SERVERURL.SAVE_FACULTY_PROGRAM_ATTENDANCE;
	                		   } else {
	                			   courseReading.set("id", values.id);
	                		   }
	                		   var formData = Ext.encode(adminAttendance);
	                		   Ext.Ajax.request({
	                			   type : 'rest',
	                			   url : submitUrl,
	                			   jsonData : formData,
	                			   method : 'POST',
	                			   success : function(form, action) {
	                				   //Ext.JSON.decode(form.responseText);
	                				   var msg = form.responseText;
	                				   if(msg!='' && msg=='SUCCESS'){
	                					   showSuccessMessage(getProgramandcourseTranslation('EMPLOYEE_ATTENDANCE'),getProgramandcourseTranslation('EMPLOYEE_ATTENDANCE_SAVE'));
		                				   $this.cancelFacultyAttendance();
	                				   } else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	         	        				  showWarningMessage(getProgramandcourseTranslation('EMPLOYEE_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
	         	        			   } else{
	         	        				  console.log('error while fetching message, msg :'+msg);
	         	        			   }
	                				   
	                			   }
	                		   });
	                   },
	                   
	                   timeFieldsAdd:function(){
	                	   var $this = this;
	                	   var timeContiner = this.getFacultyattendance().down('#panelId');
	                	   var timeFieldsCount = timeContiner.items.length;
	                	   var panelItem = new Array();
	                	   panelItem.push({
	                		   xtype:'fieldcontainer',
	                		   width: 'auto',
	                		   layout : 'hbox',
	                		   defaults : {
	                			   labelAlign : 'top'
	                		   },
	                		   items : [{
	                			   xtype : 'timefield',
	                			   name : 'fromTime',		
	                			   itemId : 'fromTime'+timeFieldsCount ,			
	                			   fieldLabel:getProgramandcourseTranslation('START_TIME')+'<span class="required" style="color:red"> *</span>',
	                			   format:'g:i A',
	                			   vtype: 'timerange',
//	                			   endTimeField : 'toTime'+timeFieldsCount ,
	                			   allowBlank:false,
	                			   width:100,
	                			   listeners:{
	                				   change:function(obj,val){
	                					   if (!isNullOrEmpty(val)) {
	                						   var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 15);
	                						   obj.nextSibling().setMinValue(sDate);	
	                					   }
	                				   }
	                			   }
	                		   },{
	                			   xtype : 'timefield',
	                			   name : 'toTime',		
	                			   itemId : 'toTime'+timeFieldsCount,			
	                			   fieldLabel:getProgramandcourseTranslation('END_TIME')+'<span class="required" style="color:red"> *</span>',
	                			   format:'g:i A',
	                			   vtype: 'timerange',
//	                			   startTimeField :'fromTime'+timeFieldsCount,
	                			   allowBlank:false,
	                			   width:100,
	                			   listeners:{
	                				   change:function(obj,val){
	                					   if (!isNullOrEmpty(val)) {
	                						   var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -15);
	                						   obj.previousSibling().setMaxValue(eDate);
	                					   }
	                				   }
	                			   }
	                		   },{
	                			   xtype: 'button',
	                			   glyph: ICONGLYPH.DELETEGLYPH,
	                			   cls: 'CustomBodyBtnReject',
	                			   tooltip: getCommonTranslation('DELETETOOLTIP'),
	                			   style:{
	                				   marginTop:'30px'
	                			   },
	                			   listeners:{
	                				   click:function(obj){
	                					   //obj.ownerCt.removeAll();
	                					   var container = obj.up('fieldcontainer');
	                					   var panelContiner = $this.getFacultyattendance().down('#panelId');
	                					   panelContiner.remove(container);
	                					   $this.getFacultyattendance().isValid();
	                				   }
	                			   }
	                		   }]
	                	   });
	                	   timeContiner.add(panelItem);
	                	   timeContiner.doLayout();
	                   },
	 	          getSessionValues:function(){
		        	   var $this = this;
		        	   var academyLocationId = this.getCurrentAcademyLocation();
		        	   var form = this.getFacultyattendance().getForm();
		        	   
		        	   Ext.Ajax.request({
	              		 type : 'rest',
	              		 url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	              		 params : {
	              			 academyLocatonId : academyLocationId
	              		 },
	              		 method : 'GET',
	              		 success : function(f, action) {
	              			 if(f.responseText == 'ENTRY_NOT_FOUND')
	               			{
	               				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
	               			}else{
	              			 var data = Ext.JSON.decode(f.responseText);
	              			form.findField('attendanceType').setValue(data.facultyAttendanceType);
	              			//form.findField('noOfBackDays').setValue(dateRender(data.backDateAllowed));
	              			form.findField('timeTablePlanning').setValue(data.timeTablePlanningFlag);
	              			$this.facultyAttendanceTypeDropdown();
	              			
	              			/*var studentForm = $this.getStudentattendance().getForm();
	              			studentForm.findField('attendanceType').setValue(data.studentAttendanceType);*/
	              			
	              			var date = new Date();
         				    var minDate = Ext.Date.add(date, Ext.Date.DAY, -data.backDateAllowed);
         				   form.findField('dateOfAttendance').setMinValue(minDate);
	              			
	               			}
	              		 }
	              	 });
	 	          },
	 	          
	 	          loadFacultyData:function(){

	 	        	  var $this = this;
	 	        	  var form = $this.getFacultyattendance().getForm();
	 	        	  var academyLocationId = this.getCurrentAcademyLocation();
	 	        	  var attendanceType =  form.findField('attendanceType').getValue();
	 	        	  var courseId =  form.findField('courseId').getValue();

	 	        	  var dateOfAttendance =  form.findField('dateOfAttendance').getValue();

	 	        	  var section;
	 	        	  var sectionId = form.findField('sectionId').getValue();
//	 	        	  var courseSectionId = form.findField('courseSectionId').getValue();
	 	        	  
	 	        	 var courseVariant = form.findField('courseVariant');
              	     var courseSectionId =null;
              	     if(courseVariant.valueModels.length > 0){
              		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
              	     }
	 	        	  if(sectionId != null && sectionId != ''){
	 	        		  section = sectionId;
	 	        	  }else{
	 	        		  section = courseSectionId;
	 	        	  }

	 	        	  var componentId = form.findField('componentId').getValue();
	 	        	  var component;
	 	        	  if(componentId!="" && componentId!= null){
	 	        		  component = componentId;   
	 	        	  }else{
	 	        		  component =null;
	 	        	  }

	 	        	  var date = Ext.Date.format(new Date(dateOfAttendance), 'Y-m-d'); 
	 	        	  var timeSlotData =  form.findField('timeSlotList').getValue();
	 	        	  var timeSlot; 
	 	        	 if(!isNullOrEmpty(timeSlotData)){
	 	        		timeSlot = timeSlotData;
	 	        	 }else{
	 	        		timeSlot = null;
	 	        	 }
	 	        	 
	 	        	 var values = form.getValues();
	 	        	 var fromTime = values.fromTime;
	 	        	 var toTime = values.toTime;
	 	        	 
	 	        	  if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){

	 	        		  
	 	        		  var store =$this.getStore('attendance.FacultyListForFaculty');
	 	        		  store.getProxy().api.read=SERVERURL.FACULTY_LIST_FOR_FACULTY;
	 	        		  store.getProxy().extraParams = {
	 	        			  courseId:courseId,
	 	        			  componentId:component,
	 	        			  sectionId:section,
	 	        			  attendanceDate:date,
	 	        			  timeSlot: timeSlot,
	 	        			  fromTime: fromTime,
	 	        			  toTime: toTime	 	        				  
	 	        		  };
	 	        		  store.load({
	 	        			  callback: function(records, operation, success) {
	 	        				  if (success) {
	 	        					  if(records.length > 0){
	 	        						 $this.getFacultypncattendancestructure().down('#submitBtn').setDisabled(false);
	 	        						  var variantId =  records[0].data.variantId;
	 	        						  $this.getFacultyattendance().getForm().findField('variantId').setValue(variantId);
	 	        					  }else{
	 	        						 $this.getFacultypncattendancestructure().down('#submitBtn').setDisabled(true);
	 	        					  }		 
	 	        				  }
	 	        			  }
	 	        		  });

	 	        	  }else{
	 	        		  //var store = this.getStore('attendance.FacultyGridCompleteNMultipleSession');
	 	        		  /*store.getProxy().extraParams = {
	 	        			  academyLocationId:academyLocationId,
	 	        			  date:date
	 	        		  };
	 	        		  store.load();*/
	 	        		  var store =$this.getStore('attendance.FacultyListForFaculty');
	 	        		  store.getProxy().api.read=SERVERURL.FIND_FACULTY_BY_AL_N_DATE;
	 	        		  store.getProxy().extraParams = {
	 	        			academyLocationId:academyLocationId,
	 	        			  date:date
	 	        		  };
	 	        		  store.load({
	 	        			  callback: function(records, operation, success) {
	 	        				  if (success) {
	 	        					  if(records.length > 0){
	 	        						 $this.getFacultypncattendancestructure().down('#submitBtn').setDisabled(false);
	 	        					  }else{
	 	        						 $this.getFacultypncattendancestructure().down('#submitBtn').setDisabled(true);
	 	        					  }		 
	 	        				  }
	 	        			  }
	 	        		  });
	 	        	  }
	 	          },
	 	          
	 	          loadOtherEmployeeData:function(){

	 	        	  var $this = this;
	 	        	  
	 	        	  var attendancestructure = $this.getAttendancestructure();
	 	        	  
	 	        	  var selectedAttendance = attendancestructure.down('#studentFacultyId').getValue();
	 	        	  
	 	        	  var val = selectedAttendance['attendance'];
	 	        	  var userGroup = 'Admin';
	 	        	  
	 	        	  if(val=='forAdmin') {
	 	        		 userGroup = 'Admin'
	 	        	  } else if(val=='forOtherEmployee') {
	 	        		 userGroup ='Other Employee'
	 	        	  }
	 	        	  
	 	        	  var form = $this.getOtheremployeeattendance().getForm();
	 	        	  var academyLocationId = this.getCurrentAcademyLocation();
	 	        	  
	 	        	  var dateOfAttendance =  form.findField('dateOfAttendance').getValue();

	 	        	  var date = Ext.Date.format(new Date(dateOfAttendance), 'Y-m-d'); 
	 	        	 
	 	        	  var store = this.getStore('attendance.adminOtherEmpGridCompleteday');
	 	        	  
	 	        	  store.getProxy().extraParams = {
	 	        		 academyLocationId:academyLocationId,
	 	        		 userGroup:userGroup
	 	        	  };
	 	        	  store.load({
	 	        		  callback: function(records, operation, success) {
	 	        				  if (success) {
	 	        					  if(records.length > 0){
	 	        						 $this.getOtheremployeandadminattendancestructure().down('#saveattendanceBtn').setDisabled(false);
	 	        					  }else{
	 	        						 $this.getOtheremployeandadminattendancestructure().down('#saveattendanceBtn').setDisabled(true);
	 	        					  }		 
	 	        				  }
	 	        			  }
	 	        		  });
	 	        	  }
				});
