/**
 * @author Utsav Chandvaniya
 * 
 */
Ext.define('Academia.controller.attendance.LeaveReportController', {
	extend : 'Academia.controller.base.BaseController',
	stores : ['attendance.UserGroup','attendance.StudentAttendanceType','common.ProgramByAcademyLocationStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.SectionAndFacultyByPeriodID',
	          'attendance.StudentCourses','course.CourseDepartmentStore','course.CourseSubDepartmentStore','attendance.LeaveStatus',
	          'attendance.FacultyCodeSmartSearch','attendance.FacultyNameSmartSearch', 'attendance.StudentSearch',
	          'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','enquiry.AcademicBatchStore',
	          'course.coursecomponent.CourseComponentCouseWise','attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse',
	          'common.BatchesByProgramId','common.AllAccessibleCVByperiodAndCourseId','common.AssignedProgramStore','program.programbatchdetail.BatchStore',
	          'coursetransaction.sectionmanagement.SectionsStore','attendance.MyLeaveReportStore','course.coursevariants.CourseVariantStore',
	          'attendance.StudentLeaveReportStore','course.AssignedPeriodCoursesFacultyStore'
	          ],
	          views : ['attendance.LeaveReportStructure','attendance.LeaveReportAllUser','attendance.LeaveReportStudent',
	                   'attendance.LeaveReportFaculty','attendance.LeaveReportMasterStrucure',
	                   'studentPortal.LeaveReportMasterStrucureForPortal','attendance.MyLeaveReportStructure','attendance.MyLeaveReportForm',
	                   'attendance.MyLeaveReportGrid','attendance.StudentLeaveReportGrid','attendance.StudentLeaveReportStructure',
	                   'attendance.StudentLeaveReportFilter'
	                   ],	
   config: {
	          PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PRIVILEGES'),
	          EMPLOYEE_MY_LEAVE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_MY_LEAVE_PRIVILEGES')
	       },                   
	                   refs : [{
	                	   ref : 'leavereportstructure',
	                	   selector : 'leavereportstructure'
	                   },{
	                	   ref : 'leavereportstudent',
	                	   selector : 'leavereportstudent'
	                   },{
	                	   ref:'leavereportfaculty',
	                	   selector:'leavereportfaculty'
	                   },{
	                	   ref:'leavereportalluser',
	                	   selector:'leavereportalluser'
	                   },{
	                	   ref:'leavereportmasterstrucure',
	                	   selector:'leavereportmasterstrucure'
	                   },{
	                	   ref: 'studentLeaveGridId',
	                	   selector: 'searchresultgrid[itemId=studentLeaveGridId]'
	                   },{
	                	   ref: 'facultyLeaveGridId',
	                	   selector: 'searchresultgrid[itemId=facultyLeaveGridId]'
	                   },{
	                	   ref: 'allLeaveGridId',
	                	   selector: 'searchresultgrid[itemId=allLeaveGridId]'
	                   },{
	                	   ref: 'myleavereportform',
	                	   selector: 'myleavereportform'
	                   },{
	                       ref: 'contentPanel',
	                       selector: 'contentpanel'
	                   },{
	                       ref: 'myleavereportgrid',
	                       selector: 'myleavereportgrid'
	                   },{
	                       ref: 'myleavereportstructure',
	                       selector: 'myleavereportstructure'
	                   },{
	                       ref: 'studentleavereportgrid',
	                       selector: 'studentleavereportgrid'
	                   },{
	                       ref: 'studentleavereportfilter',
	                       selector: 'studentleavereportfilter'
	                   },{
	                       ref: 'studentleavereportstructure',
	                       selector: 'studentleavereportstructure'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'leavereportmasterstrucure':{
	  	                		 afterrender:function(structure)  {
	  	                			var $this = this;
	  	                			
                   				 structure.body.on('scroll', function(e, target) {
                   					 var studentLeaveGridId = $this.getStudentLeaveGridId();
                   					 var facultyLeaveGridId = $this.getFacultyLeaveGridId();
                   					 var allLeaveGridId = $this.getAllLeaveGridId();
                   					 var grid = null;
                   					 
                   					 if(!studentLeaveGridId.isHidden()){
                   						 grid = studentLeaveGridId;
                   					 }
                   					 if(!facultyLeaveGridId.isHidden()){
                   						 grid = facultyLeaveGridId;
                   					 }
                   					 if(!allLeaveGridId.isHidden()){
                   						 grid = allLeaveGridId;
                   					 }
                   					
                   					 $this.getMultipleCBGridHeaderFreeze(grid,structure,true);
                   				 });
	  	                		 }
	  	                	   },
	                		   'searchresultgrid[itemId=facultyLeaveGridId]':{
	                			   render : function(grid){
	                				   this.gridRenderFunction(grid);
	                   				 this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
	                			   }
	                		   },
	                		   'searchresultgrid[itemId=studentLeaveGridId]':{
	                			   render : function(grid){
	                				   this.gridRenderFunction(grid);
	                   				 this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
	                			   }
	                		   },
	                		   'searchresultgrid[itemId=allLeaveGridId]':{
	                			   render : function(grid){
	                				   this.gridRenderFunction(grid);
	                   				 this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
	                			   }
	                		   },
	                		 //***1**************Export For Report**********************************************************************
	             			  'searchresultgrid[itemId=facultyLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	             		            click: function() {
	             		            	var grid = this.getFacultyLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=facultyLeaveGridId] button[itemId=exportToPdfBtn] #exportPdfAll': {
	             		            click: function() {
	             		            	var grid = this.getFacultyLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=facultyLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	             		            click: function() {
	             		            	var grid = this.getFacultyLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=facultyLeaveGridId] button[itemId=exportToPdfBtn] #exportExcelAll': {
	             		            click: function() {
	             		            	var grid = this.getFacultyLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_CONFIGCODE);
	             		            }
	             		        },
	             		       //***2*************************************************************************************************** 
	             		        'searchresultgrid[itemId=studentLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	             		            click: function() {
	             		            	var grid = this.getStudentLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=studentLeaveGridId] button[itemId=exportToPdfBtn] #exportPdfAll': {
	             		            click: function() {
	             		            	var grid = this.getStudentLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=studentLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	             		            click: function() {
	             		            	var grid = this.getStudentLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=studentLeaveGridId] button[itemId=exportToPdfBtn] #exportExcelAll': {
	             		            click: function() {
	             		            	var grid = this.getStudentLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_CONFIGCODE);
	             		            }
	             		        },  
	             		      //****3**********************************************************************************************************
	             		        'searchresultgrid[itemId=allLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	             		            click: function() {
	             		            	var grid = this.getAllLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.LEAVE_REPORT_ALL_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=allLeaveGridId] button[itemId=exportToPdfBtn] #exportPdfAll': {
	             		            click: function() {
	             		            	var grid = this.getAllLeaveGridId();
	             		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.LEAVE_REPORT_ALL_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=allLeaveGridId] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	             		            click: function() {
	             		            	var grid = this.getAllLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.LEAVE_REPORT_ALL_CONFIGCODE);
	             		            }
	             		        },
	             		        'searchresultgrid[itemId=allLeaveGridId] button[itemId=exportToPdfBtn] #exportExcelAll': {
	             		            click: function() {
	             		            	var grid = this.getAllLeaveGridId();
	             		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.LEAVE_REPORT_ALL_CONFIGCODE);
	             		            }
	             		        },	   
	             		    //*********************************************************************************************************************    
	             		       'leavereportstructure':{
	                			   render: function(){
//	                				   this.userDropDownByPortal();
//	                				   this.userTypeLeave();
	                				   var $this=this;
	                				   var form = this.getLeavereportstructure();
	                				   var userType = form.down("#leavereport_usertype");
	                				   userType.getStore().load({
			                   			   callback: function(rec, operation, success) {
			                   				   if (success) {
			                   					   if($this.getCurrentLoggedPortalId() == 3){
			                   						   userType.setValue(rec[2].get("id"));
			                   						   userType.setReadOnly(true);
			                   					   }else if($this.getCurrentLoggedPortalId() == 2){
			                   						   userType.setValue(rec[0].get("id"));
			                   						   userType.setReadOnly(true);
			                   					   }
			                   					   
			                   				   }
			                   				  $this.userTypeLeave();
			                   			   }
	                				 
			                   		   });
	                			   }
	                		   },
	             		       'leavereportstructure textfield[itemId=academyLocationId]':{
	                			   blur: this.getProgramByAcademyLocation
	                		   },
	                		   'leavereportstudent customcombobox#programId': {
	                			   select: function(obj, record) {
	                				   var programId = record[0].get("id");
	                				   if(programId > 0){	                					   	                					   
	                					   var store = this.getStore('enquiry.AcademicBatchStore');
	                					   store.getProxy().extraParams = {
	                						   id: programId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#batchId': {
	                			   select: function(obj, record) {
	                				   var batchId = record[0].get("id");
	                				   if(batchId > 0){	                					   	                					   
	                					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                					   store.getProxy().extraParams = {
	                						   id: batchId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#periodId': {
	                			   select: function(obj, record) {
	                				   var periodId = record[0].get("id");
	                				   if(periodId > 0){	                					   	                					   
	                					   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
	                					   store.getProxy().extraParams = {
	                						   periodId: periodId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'leavereportfaculty customcombobox#departmentId_itemId': {
	                			   select: function(obj, record) {
	                				   var departmentId = record[0].get("id");
	                				   if(departmentId > 0){	          
	                					   this.getLeavereportfaculty().down('#subDepartmentId_itemId').clearValue();
	                					   var store = this.getStore('course.CourseSubDepartmentStore');
	                					   store.getProxy().extraParams = {
	                						   parentId: departmentId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#courseProgramID': {
	                			   select: function(obj, record) {
	                				   var programId = record[0].get("id");
	                				   var form = this.getLeavereportstudent();
	                				   form.down("#courseBatchId").setDisabled(false);
	                				   var store = this.getStore('common.BatchesByProgramId');
	                				   store.getProxy().extraParams = {
	                					   id: programId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#courseBatchId':{
	                			   select:function(obj, record){
	                				   var programBatchId = record[0].get("id");
	                				   if(programBatchId !=''){
	                					   var form = this.getLeavereportstudent();
	                					   form.down("#coursePeriodID").setDisabled(false);
	                					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                					   store.getProxy().extraParams = {
	                						   id: programBatchId
	                					   };
	                					   store.load();
	                				   }
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#coursePeriodID':{
	                			   select:function(obj, record){
	                				   var programBatchPeriodId = record[0].get("id");
	                				   this.getLeavereportstudent().down("#programCoursection_ID").setDisabled(false);
	                				   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
	                				   store.getProxy().extraParams = {
	                					   periodId:programBatchPeriodId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#componentId':{
	                			   select:function(obj, record){
	                				   var componentId = record[0].get("id");
	                				   var form = this.getLeavereportstudent();
	                				   var courseId = form.getForm().findField('courseId').getValue();
	                				   var store = this.getStore('attendance.SectionByCourseNComponent');
	                				   store.getProxy().extraParams = {
	                					   parentCourseId: courseId,
	                					   componentId:componentId
	                				   };
	                				   store.load();
	                			   }
	                		   },
	                		   'leavereportstructure customcombobox#leaveTypeId': {
	                			   select: function(obj, record) {
	                				   this.leaveTypeChanges(obj, record);
	                			   }
	                		   },
	                		   'leavereportstudent customcombobox#courseId': {
	                			   select: function(obj, record) {
	                				   this.courseNprogramSection(obj, record);
	                			   }
	                		   },
	                		   'leavereportstructure customcombobox#leavereport_usertype': {
	                			   select: function(obj, record) {
	                				   this.userTypeLeave(obj, record);
	                			   }
	                		   },
	                		   'leavereportstructure button[itemId=searchBtn]': {
	                			   click: function(){
	                				   this.leaveTypeFilter();
	                			   }
	                		   },
	                		   'leavereportstructure button[itemId=resetBtn]': {
	                			   click: function(){
	                				   
	                				   
	                				   /*if(this.getCurrentLoggedPortalId()==3){
	                					   var form =  this.getLeavereportstructure().getForm();
	                					   form.getFields().each(function(field){
	                						   if(field.name !='userType'){
	                							   field.reset();
	                						   }
	                					   });
	                				   }else{*/
	                					   this.getLeavereportstudent().getForm().reset();
	                					   this.getLeavereportfaculty().getForm().reset();
	                					   this.getLeavereportalluser().getForm().reset();
	                					   this.getLeavereportstructure().getForm().reset();
	                					   this.getLeavereportstructure().down('#leavereportalluserId').setVisible(true);
	                					   this.getLeavereportstructure().down('#leavereportstudentId').setVisible(false);
	                					   this.getLeavereportstructure().down('#leavereportfacultyId').setVisible(false);
	                					   this.userDropDownByPortal();
		                				   this.userTypeLeave();
//	                				   }
	                			   }
	                		   },

	                		    'leavereportfaculty': {
	                               render: function(form){
	                                   var Form = form.getForm();
	                                   var field = Form.findField("facultyId");
	                                   //TODO
	                                   var store = field.getStore();
	                                   store.getProxy().extraParams = {
	                                	   restrictToAL : true,
	                                	   restrictToFacultyRole : true
	    	                		   };
	    	                		   store.load();
	    	                		   
	    	                		   
	    	                		   var nameField = Form.findField("facultyName");
	                                   var nameFieldStore = nameField.getStore();
	                                   nameFieldStore.getProxy().extraParams = {
	                                	   restrictToAL : true,
	                                	   restrictToFacultyRole : true
	    	                		   };
	                                   nameFieldStore.load();
	    	                		   
	                               }
	                		    },
	                               'leavereportstudent': {
		                               render: function(form){
		                                   var Form = form.getForm();
		                                   var field = Form.findField("studentName");
		                                   //TODO
		                                   var store = field.getStore();
		                                   store.getProxy().extraParams = {
		                                	   restrictToAL : true
		    	                		   };
		    	                		   store.load();
		                               },
		                               afterrender: function(){
		                            	   this.leaveTypeFilter();
		                               }
	                             },
	                             'studentleavereportfilter' : {
	                            	 afterrender : function(form){
	                            		 var this$ = this;
	                            		 this$.getAttendanceAndUserTypeDropDown(form);
	                            		 this.studentLeaveRecordSearch();
	                            	 }
	                             },
	                             'myleavereportform button[itemId=searchBtn]': {
	                            	 click: function(){
	                            		 this.myLeaveRecordSearch();
	                            	 }
	                             },
	                             'studentleavereportfilter button[itemId=searchBtn]': {
	                            	 click: function(){
	                            		 this.studentLeaveRecordSearch();
	                            	 }
	                             },
	                             'studentleavereportfilter customcombobox[itemId=programBatch_programId]': {
	                            	 select: function(obj, record) {
	                            		 var this$ = this;
	                            		 var programId = record[0].get("id");
	                            		 if(programId > 0){
	                            			 var form = this$.getStudentleavereportfilter();
	                            			 form.down("#programBatch_batchId").setDisabled(false);
	                            			 var store = form.down("#programBatch_batchId").getStore();
	                            			 store.getProxy().extraParams = {
	                            				 id: programId,
	                            				 isActive:true
	                            			 };
	                            			 store.load({
	                            				 callback: function(records, operation, success) {
	                            					 if (success) {
	                            						 if(records.length==1){
	                            							 form.down("#programBatch_batchId").setValue(records[0].get('id'));
	                            							 form.down("#periodIdItemId").setDisabled(false);
	                            							 var store = form.down("#periodIdItemId").getStore();
	                            							 store.getProxy().extraParams = {
	                            								 id: records[0].get('id'),
	                            								 isCurrentPeriod:true
	                            							 };
	                            							 store.load({
	                            								 callback: function(records, operation, success) {
	                            									 if (success) {
	                            										 if(records.length==1){
	                            											 form.down("#periodIdItemId").setValue(records[0].get('id'))
	                            											 form.down("#programCoursection_ID").setDisabled(false);
	                            											 var store = form.down("#programCoursection_ID").getStore();
	                            											 store.getProxy().extraParams = {
	                            												 periodId: records[0].get('id')
	                            											 };
	                            											 store.load({
	                            												 callback: function(records, operation, success) {
	                            													 if (success) {
	                            														 if(records.length==1){
	                            															 form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
	                            														 }
	                            													 }
	                            												 }
	                            											 });

	                            										 }
	                            									 }
	                            								 }
	                            							 });
	                            						 }
	                            					 }
	                            				 }
	                            			 });
	                            		 }
	                            	 }
	                             },
	                             'studentleavereportfilter combo#programBatch_batchId': {
	                            	 select: function(obj, record) {
	                            		 var this$  = this;
	                            		 var batchId = record[0].get("id");
	                            		 if(batchId > 0){
	                            			 var form = this$.getStudentleavereportfilter();
	                            			 form.down("#periodIdItemId").setDisabled(false);
	                            			 var store = form.down("#periodIdItemId").getStore();
	                            			 store.getProxy().extraParams = {
	                            				 id: batchId,
	                            				 isCurrentPeriod:true
	                            			 };
	                            			 store.load({
	                            				 callback: function(records, operation, success) {
	                            					 if (success) {
	                            						 if(records.length==1){
	                            							 form.down("#periodIdItemId").setValue(records[0].get('id'))
	                            							 form.down("#programCoursection_ID").setDisabled(false);
	                            							 var store = form.down("#programCoursection_ID").getStore();
	                            							 store.getProxy().extraParams = {
	                            								 periodId: records[0].get('id')
	                            							 };
	                            							 store.load({
	                            								 callback: function(records, operation, success) {
	                            									 if (success) {
	                            										 if(records.length==1){
	                            											 form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
	                            										 }
	                            									 }
	                            								 }
	                            							 });

	                            						 }
	                            					 }
	                            				 }
	                            			 });
	                            		 }
	                            	 }
	                             },
	                             'studentleavereportfilter combo#periodIdItemId': {
	                            	 select: function(obj, record) {
	                            		 var this$  =  this;
	                            		 var periodId = record[0].get("id");
	                            		 if(periodId > 0){
	                            			 var form = this$.getStudentleavereportfilter();
	                            			 form.down("#programCoursection_ID").setDisabled(false);
	                            			 var store = form.down("#programCoursection_ID").getStore();
	                            			 store.getProxy().extraParams = {
	                            				 periodId: periodId
	                            			 };
	                            			 store.load({
	                            				 callback: function(records, operation, success) {
	                            					 if (success) {
	                            						 if(records.length==1){
	                            							 form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
	                            						 }
	                            					 }
	                            				 }
	                            			 });
	                            		 }
	                            	 }
	                             },
	                             'studentleavereportfilter combo#course': {
	                            	 select: function(obj, record) {
	                            		 var this$  =  this;
	                            		 var courseId = record[0].get("courseId");
	                            		 if(courseId > 0){
	                            			 var form = this$.getStudentleavereportfilter();
	                            			 form.down("#courseVariantId").setDisabled(false);
	                            			 var store = form.down("#courseVariantId").getStore();
	                            			 store.getProxy().extraParams = {
	                            				 courseId: courseId,
	                            				 sectionAtComponentLevel:false,
	                            				 facultyId : this.getCurrentlyLoggedInUser().id
	                            			 };
	                            			 store.load({
	                            				 callback: function(records, operation, success) {
	                            					 if (success) {
	                            						 if(records.length==1){
	                            							 form.down("#courseVariantId").setValue(records[0].data.id);
	                            						 }
	                            					 }
	                            				 }
	                            			 });

	                            		 }
	                            	 }
	                             },
	                             'studentleavereportfilter button[itemId=resetBtn]':{
	                            	 click: function(obj,record) {
	                            		 var this$  =  this;
	                            		 var form = this$.getStudentleavereportfilter();
	                            		 form.getForm().reset();
	                            		 form.down('#moreDetailId').collapse(true);
	                            		 if(!(form.down('#programBatch_programId').isHidden())){
	                            			 form.down('#programBatch_programId').clearValue();
	                            		 }
	                            		 if(!(form.down('#programBatch_batchId').isHidden())){
	                            			 form.down('#programBatch_batchId').clearValue();
	                            			 form.down('#programBatch_batchId').setDisabled(true);
	                            		 }
	                            		 if(!(form.down('#periodIdItemId').isHidden())){
	                            			 form.down('#periodIdItemId').clearValue();
	                            			 form.down('#periodIdItemId').setDisabled(true);
	                            		 }
	                            		 if(!(form.down('#programCoursection_ID').isHidden())){
	                            			 form.down('#programCoursection_ID').clearValue();
	                            			 form.down('#programCoursection_ID').setDisabled(true);
	                            		 }
	                            		 if(!(form.down('#course').isHidden())){
	                            			 form.down('#course').clearValue();
	                            		 }
	                            		 if(!(form.down('#courseVariantId').isHidden())){
	                            			 form.down('#courseVariantId').clearValue();
	                            			 form.down('#courseVariantId').setDisabled(true);
	                            		 }
	                            	 }
	                             },
	                             'myleavereportform button[itemId=resetBtn]':{
	                            	 click: function(obj,record) {
	                            		 var this$  =  this;
	                            		 var form = this$.getMyleavereportform();
	                            		 form.getForm().reset();
	                            	 }
	                             },
	                             'myleavereportstructure' : {
	                            	 render : function(grid){
	                            		 this.doAccessControlValidation(grid,this.getEMPLOYEE_MY_LEAVE_PERMISSIONS());
	                            	 }
	                             },
	                             'studentleavereportstructure' : {
	                            	 render : function(grid){
	                            		 this.doAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
	                            	 }
	                             },
	                             'myleavereportform': {
	                            	 afterrender: function(){
	                            		 this.myLeaveRecordSearch();
	                            	 }
	                             },
	                	   });
	                   },
	                   getProgramByAcademyLocation : function(newRecord){
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var form = this.getLeavereportstructure().getForm();
	                	   var userType = form.findField('userGroupName').getValue();
	                	   var leaveType = form.findField('leaveType').getValue();


	                	   if(academyLocationId!='' && userType!='' && userType=='3' && leaveType!='Course Level'){
	                		   var store = this.getStore('common.ProgramByAcademyLocationStore');
	                		   store.getProxy().extraParams = {
	                			   academyLocationId:academyLocationId				
	                		   };
	                		   store.load();
	                	   }	

	                	   // if user type is student and leave type is 'COURSE_LEVEL' then call this code
	                	   if(academyLocationId!='' && userType!='' && userType=='3' && leaveType=='Course Level'){
	                		   var store = this.getStore('attendance.StudentCourses');
	                		   store.getProxy().extraParams = {
	                			   academyLocationId:academyLocationId				
	                		   };
	                		   store.load();
	                	   } else if(academyLocationId!='' && userType!='' && userType=='2'){
	                		   var store = this.getStore('course.CourseDepartmentStore');	     	        		  
	                		   store.load();
	                	   }
	                   },
	                   leaveTypeChanges:function(obj,record){
	                	   var $this = this;
	                	   var leaveType = record[0].get("value");
	                	   var form = $this.getLeavereportstudent();
	                	   if(leaveType == 'Complete Day' || leaveType == 'COMPLETE_DAY'){
	                		   form.down('#programId').setVisible(true);
	                		   form.down('#batchId').setVisible(true);
	                		   form.down('#periodId').setVisible(true);
	                		   form.down('#programCoursection_ID').setVisible(true);

	                		   form.down('#courseId').setVisible(false);
	                		   form.down('#courseId').reset();
	                		   form.down("#componentId").setVisible(false);
	                		   form.down("#componentId").reset();
	                		   form.down('#CourseSection_ID').setVisible(false);
	                		   form.down('#CourseSection_ID').reset();
	                		   form.down("#programBatchContainer").setVisible(false);
	                	   }else if(leaveType == 'Multiple Session' || leaveType == 'MULTIPLE_SESSION'){
	                		   form.down('#programId').setVisible(true);
	                		   form.down('#batchId').setVisible(true);
	                		   form.down('#periodId').setVisible(true);
	                		   form.down('#programCoursection_ID').setVisible(true);

	                		   form.down('#courseId').setVisible(false);
	                		   form.down('#courseId').reset();
	                		   form.down("#componentId").setVisible(false);
	                		   form.down("#componentId").reset();
	                		   form.down('#CourseSection_ID').setVisible(false);
	                		   form.down('#CourseSection_ID').reset();
	                		   form.down("#programBatchContainer").setVisible(false);
//	                		   form.down("#programBatchContainer").reset();
	                	   }else if(leaveType == 'Course Level' || leaveType == 'COURSE_LEVEL'){
	                		   form.down('#programId').setVisible(false);
	                		   form.down('#programId').reset();
	                		   form.down('#batchId').setVisible(false);
	                		   form.down('#batchId').reset();
	                		   form.down('#periodId').setVisible(false);
	                		   form.down('#periodId').reset();
	                		   form.down('#programCoursection_ID').setVisible(false);
	                		   form.down('#programCoursection_ID').reset();

	                		   form.down('#courseId').setVisible(true);
	                		   form.down('#courseId').reset();
	                		   form.down('#CourseSection_ID').setVisible(true);
	                		   form.down('#CourseSection_ID').reset();
	                	   }
	                   },
	                   courseNprogramSection:function(obj, record){
	                	   var form = this.getLeavereportstudent();
	                	   var courseId = record[0].data.courseId;
	                	   var courseData = record[0].data;
	                	   if(courseData.sectionType == 'CourseSection'){

	                		   form.down("#CourseSection_ID").setVisible(true);
	                		   form.down("#programBatchContainer").setVisible(false);

	                		   form.down("#programCoursection_ID").setVisible(false);

	                		   if(courseData.sectionAtComponentLevel == true){
	                			   form.down("#componentId").setVisible(true);

	                			   var store = this.getStore('course.coursecomponent.CourseComponentCouseWise');
	                			   store.getProxy().extraParams = {
	                				   courseId: courseId
	                			   };
	                			   store.load();
	                		   }else{
	                			   form.down("#componentId").setVisible(false);
	                			   form.down("#componentId").clearValue();
	                		   }

	                		   var componentId = form.getForm().findField('componentId').getValue();
	                		   var component;
	                		   if(componentId!="" && componentId!= null){
	                			   component = componentId;   
	                		   }else{
	                			   component =null;
	                		   } 

	                		   var store = this.getStore('attendance.SectionByCourseNComponent');
	                		   store.getProxy().extraParams = {
	                			   parentCourseId: courseId,
	                			   componentId:component
	                		   };
	                		   store.load();

	                	   }else if(courseData.sectionType == 'ProgramBatchSection'){

	                		   form.down("#programBatchContainer").setVisible(true);
	                		   form.down("#programCoursection_ID").setVisible(true);

	                		   form.down("#CourseSection_ID").setVisible(false);

	                		   if(courseData.sectionAtComponentLevel == true){
	                			   form.down("#componentId").setVisible(true);
	                			   var store = this.getStore('course.coursecomponent.CourseComponentCouseWise');
	                			   store.getProxy().extraParams = {
	                				   id: courseId
	                			   };
	                			   store.load();
	                		   }else{
	                			   form.down("#componentId").setVisible(false);
	                			   form.down("#componentId").clearValue();
	                		   }

	                		   var store = this.getStore('attendance.AllProgramMappedByCourse');
	                		   store.getProxy().extraParams = {
	                			   courseId:courseId
	                		   };
	                		   store.load();
	                	   }
	                   },
	                   userTypeLeave:function(){
//	                	   var userType = record[0].data.value;
//	                	   var form = obj.up('form');	
	                	   this.getProgramByAcademyLocation();
	                	   var form = this.getLeavereportstructure();
							var userType = form.down('#leavereport_usertype').getRawValue();
//	                	   var form = this.getLeavereportstructure();
							if(this.getCurrentLoggedPortalId()==2){
//	                	   if(userType == 'Faculty'){
	                		   this.getLeavereportstudent().getForm().reset();
	                		   form.down('#leavereportfacultyId').setVisible(true);
	                		   form.down('#leavereportstudentId').setVisible(false);
	                		   form.down('#leavereportalluserId').setVisible(false);
							}else if(this.getCurrentLoggedPortalId()==3){
//	                	   }else if(userType == 'Student'){
	                		   this.getLeavereportfaculty().getForm().reset();
	                		   form.down('#leavereportstudentId').setVisible(true);
	                		   form.down('#leavereportstudentId').down('#studentId_itemId').setVisible(false);
	                		   form.down('#leavereportstudentId').down('#studentName_itemId').setVisible(false);
	                		   form.down('#leavereportstudentId').down('#programId').setVisible(false);
	                		   form.down('#leavereportstudentId').down('#batchId').setVisible(false);
	                		   form.down('#leavereportstudentId').down('#periodId').setVisible(false);
	                		   form.down('#leavereportstudentId').down('#programCoursection_ID').setVisible(false);
	                		   form.down('#leavereportfacultyId').setVisible(false);
	                		   form.down('#leavereportalluserId').setVisible(false);
	                		   form.down('#leavereport_usertype').setVisible(false);
	                		   form.down('#leaveTypeId').setVisible(false);
	                	   }else{
	                		   if(userType == 'Faculty'){
	                			   this.getLeavereportstudent().getForm().reset();
		                		   form.down('#leavereportfacultyId').setVisible(true);
		                		   form.down('#leavereportstudentId').setVisible(false);
		                		   form.down('#leavereportalluserId').setVisible(false);
	                		   }else if(userType == 'Student'){
	                			   this.getLeavereportfaculty().getForm().reset();
	                			   form.down('#leavereportstudentId').setVisible(true);
		                		   form.down('#leavereportstudentId').down('#studentId_itemId').setVisible(false);
		                		   form.down('#leavereportstudentId').down('#studentName_itemId').setVisible(false);
		                		   form.down('#leavereportstudentId').down('#programId').setVisible(false);
		                		   form.down('#leavereportstudentId').down('#batchId').setVisible(false);
		                		   form.down('#leavereportstudentId').down('#periodId').setVisible(false);
		                		   form.down('#leavereportstudentId').down('#programCoursection_ID').setVisible(false);
		                		   form.down('#leavereportfacultyId').setVisible(false);
		                		   form.down('#leavereportalluserId').setVisible(false);		                		   
		                		   if(this.getCurrentLoggedPortalId()==1){
		                			   form.down('#leavereport_usertype').setVisible(true);
			                		   form.down('#leaveTypeId').setVisible(true);
		                		   }else{
		                			   form.down('#leavereport_usertype').setVisible(false);
			                		   form.down('#leaveTypeId').setVisible(false); 
		                		   }
	                		   }
	                		   else{
	                			   form.down('#leavereportstudentId').setVisible(false);
		                		   form.down('#leavereportfacultyId').setVisible(false);
		                		   form.down('#leavereportalluserId').setVisible(true);
	                		   }
	                	   }
	                   },
	                   leaveTypeFilter:function(){
	                	   var $this = this;
	                	   var form = $this.getLeavereportstructure().getForm();
	                	   var userType = form.findField('userGroupName').getRawValue();

	                	   if(userType == 'Faculty'){
	                		   var quickSearchForm = this.getLeavereportfaculty();
	                		   var RESULT_GRID = $this.getFacultyLeaveGridId();
	                		   $this.loadLeave(CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_VIEWCODE,
	                				   CONSTANTS.CB.LEAVE_REPORT_FACULTYWISE_CONFIGCODE,RESULT_GRID,quickSearchForm);
	                		   $this.getLeavereportmasterstrucure().down('#facultyLeaveGridId').setVisible(true);
	                		   $this.getLeavereportmasterstrucure().down('#studentLeaveGridId').setVisible(false);
	                		   $this.getLeavereportmasterstrucure().down('#allLeaveGridId').setVisible(false);
	                	   }else if(userType == 'Student' || this.getCurrentLoggedPortalId() == 3){
	                		   var quickSearchForm = this.getLeavereportstudent();
	                		   var RESULT_GRID = $this.getStudentLeaveGridId();
	                		   $this.loadLeave(CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_VIEWCODE,
	                				   CONSTANTS.CB.LEAVE_REPORT_STUDENTWISE_CONFIGCODE,RESULT_GRID,quickSearchForm);
	                		   $this.getLeavereportmasterstrucure().down('#studentLeaveGridId').setVisible(true);
	                		   $this.getLeavereportmasterstrucure().down('#facultyLeaveGridId').setVisible(false);
	                		   $this.getLeavereportmasterstrucure().down('#allLeaveGridId').setVisible(false);
	                		   
	                		   /***** Hide user name and user type for student portal *****/
		                	   
		                	   Ext.defer(function() {
	                			   var portalId = $this.getCurrentLoggedPortalId();
	                			   if(portalId == 3 && RESULT_GRID.columnManager.columns) {
	                				   for(var i=RESULT_GRID.columnManager.columns.length-1;i>=0;i--) {
	                					   var column = RESULT_GRID.columnManager.columns[i];
	                					   if(column.dataIndex == 'USER_NAME' || column.dataIndex == 'USER_TYPE'){
	                						   column.hide();
	                					   }
	                				   }
	                			   }
	                		   }, 2000, $this);
		                	   
	                	   }else {
	                		   var quickSearchForm = this.getLeavereportalluser();
	                		   var RESULT_GRID = $this.getAllLeaveGridId();
	                		   $this.loadLeave(CONSTANTS.CB.LEAVE_REPORT_ALL_VIEWCODE,
	                				   CONSTANTS.CB.LEAVE_REPORT_ALL_CONFIGCODE,RESULT_GRID,quickSearchForm);
	                		   $this.getLeavereportmasterstrucure().down('#allLeaveGridId').setVisible(true);
	                		   $this.getLeavereportmasterstrucure().down('#facultyLeaveGridId').setVisible(false);
	                		   $this.getLeavereportmasterstrucure().down('#studentLeaveGridId').setVisible(false);
	                	   }
	                   },
	                   loadLeave : function(respectiveLinkViewCode, respectiveLinkConfigCode,getResultGrid,quickSearchForm,model,records){
	                	   var jsonFormatFormData = this.createJsonFormat(quickSearchForm, respectiveLinkConfigCode,records);
	                	   var searchResultGrid = getResultGrid;
	                	   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                	   resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode);
	                	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                	   Ext.getBody().unmask();
	                   },

	                   createJsonFormat: function(quickSearchForm,respectiveLinkConfigCode ,record) {

	                	   var values = quickSearchForm.getForm().getValues();
	                	   var courseId = values.courseId;
	                	   var programId = values.programId;
	                	   var batchId =values.batchId;
	                	   var facultyId = values.facultyId;
	                	   var studentId = values.studentId;
	                	   var studentId = values.studentId;
	                	   var studentName = values.studentName;
	                	   var facultyName = values.facultyName;

	                	   var userIdv = this.getLeavereportstructure().getForm().findField("userGroupName").getValue();	
	                	   var startDate =values.fromDate;
	                	   var endDate = values.toDate;

	                	   if(userIdv==2) {
	                		   startDate = values.fromDate2;
	                		   endDate = values.toDate2;
	                	   } else if(userIdv==3) {
	                		   startDate = values.fromDate3;
	                		   endDate = values.toDate3;
	                	   }
	                	   var departmentId = values.departmentId;
	                	   var subDepartmentId = values.subDepartmentId;
	                	   var leaveStudentForm = this.getLeavereportstructure().getForm();
	                	   var leaveType = leaveStudentForm.findField('leaveType').getValue();
	                	   var leaveStatus = leaveStudentForm.findField('leaveStatus').getValue();
	                	   var typeOfAttendanc;
	                	   if(leaveType == 'Complete Day' || leaveType == 'COMPLETE_DAY'){
	                		   typeOfAttendanc = 'COMPLETE_DAY';
	                	   }else if(leaveType == 'Multiple Session' || leaveType == 'MULTIPLE_SESSION'){
	                		   typeOfAttendanc = 'MULTIPLE_SESSION';
	                	   }else if(leaveType == 'Course Level' || leaveType == 'COURSE_LEVEL'){
	                		   typeOfAttendanc = 'COURSE_LEVEL';
	                	   }

	                	   var section;
	                	   var sectionId = values.sectionId;
	                	   var courseSectionId = values.courseSectionId;
	                	   if(sectionId != null && sectionId != ''){
	                		   section = sectionId;
	                	   }else{
	                		   section = courseSectionId;
	                	   }


	                	   var values = new Object();
	                	   var searchcriteria = new Array();
	                	   values.configCode = respectiveLinkConfigCode;
	                	   
	                	   var userTypeId = this.getLeavereportstructure().getForm().findField("userGroupName").getValue();
	                	   if(respectiveLinkConfigCode == "LEAVE_REPORT_FACULTYWISE" || 
	                			   respectiveLinkConfigCode == "LEAVE_REPORT_STUDENTWISE"){
	                		   var USER_TYPE = this.getJsonObject('USER_TYPE', userTypeId);
	                		   this.pushJsonObjectInArray(USER_TYPE, searchcriteria);
	                	   }
	                	   
	                	   //TODO
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
	                	   this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
	                	   
	                	   var FACULTY_CODE = this.getJsonObject('FACULTY_CODE', facultyId);
	                	   this.pushJsonObjectInArray(FACULTY_CODE,searchcriteria);

	                	   var PRINT_NAME = this.getJsonObject('PRINT_NAME', facultyName);
	                	   this.pushJsonObjectInArray(PRINT_NAME,searchcriteria);

	                	   var PRINT_NAME = this.getJsonObject('PRINT_NAME', studentName);
	                	   this.pushJsonObjectInArray(PRINT_NAME,searchcriteria);

	                	   var STUDENT_CODE = this.getJsonObject('STUDENT_CODE', studentId);
	                	   this.pushJsonObjectInArray(STUDENT_CODE,searchcriteria);


	                	   var DEPARTMENT_ID = this.getJsonObject('DEPARTMENT_ID', departmentId);
	                	   this.pushJsonObjectInArray(DEPARTMENT_ID,searchcriteria);

	                	   var SUBDEPARTMENT_ID = this.getJsonObject('SUBDEPARTMENT_ID', subDepartmentId);
	                	   this.pushJsonObjectInArray(SUBDEPARTMENT_ID,searchcriteria);

	                	   /*var STUDENT_CODE = this.getJsonObject('STUDENT_CODE', courseId);
	   		    	     this.pushJsonObjectInArray(STUDENT_CODE,searchcriteria);*/

	                	   /*var PRINT_NAME = this.getJsonObject('PRINT_NAME', courseId);
	   		    	     this.pushJsonObjectInArray(PRINT_NAME,searchcriteria);*/

	                	   var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', programId);
	                	   this.pushJsonObjectInArray(PROGRAM_ID,searchcriteria);

	                	   var BATCH_ID = this.getJsonObject('BATCH_ID', batchId);
	                	   this.pushJsonObjectInArray(BATCH_ID,searchcriteria);

	                	   var COURSE_ID = this.getJsonObject('COURSE_ID', courseId);
	                	   this.pushJsonObjectInArray(COURSE_ID,searchcriteria);

	                	   var SECTION_ID = this.getJsonObject('SECTION_ID', section);
	                	   this.pushJsonObjectInArray(SECTION_ID,searchcriteria);

	                	   var DATE_OF_ABSENCE_AFTER = this.getJsonObject('DATE_OF_ABSENCE_AFTER', startDate);
	                	   this.pushJsonObjectInArray(DATE_OF_ABSENCE_AFTER,searchcriteria);

	                	   var DATE_OF_ABSENCE_BEFORER = this.getJsonObject('DATE_OF_ABSENCE_BEFORER', endDate);
	                	   this.pushJsonObjectInArray(DATE_OF_ABSENCE_BEFORER,searchcriteria);

	                	   var LEAVE_STATUS_ID = this.getJsonObject('LEAVE_STATUS_ID', leaveStatus);
	                	   this.pushJsonObjectInArray(LEAVE_STATUS_ID,searchcriteria);

	                	   var ATTENDANCE_TYPE = this.getJsonObject('ATTENDANCE_TYPE', typeOfAttendanc);
	                	   this.pushJsonObjectInArray(ATTENDANCE_TYPE,searchcriteria);
	                	   
	                	   if(this.getCurrentLoggedPortalId()==3){
	                		   var PRINTNAME = this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
	                		   var PRINT_NAME = this.getJsonObject('PRINT_NAME', PRINTNAME);
		                	   this.pushJsonObjectInArray(PRINT_NAME,searchcriteria);
	                	   }


	                	   values.searchCriterias = searchcriteria;
	                	   return values;
	                   },
	                   getJsonObject: function(key, value, additionalValue) {
	                	   if (value != '' && value != null && additionalValue == undefined) {
	                		   return {
	                			   "paramCode": key,
	                			   "paramValues": [value]
	                		   };
	                	   } else if (value != '' && additionalValue != undefined) {
	                		   return {
	                			   "paramCode": key,
	                			   "paramValues": [value, additionalValue]
	                		   };
	                	   }
	                   },
	                   pushJsonObjectInArray: function(object, array) {
	                	   if (object) {
	                		   array.push(object);
	                	   }
	                   },

	                   gridRenderFunction: function(grid) {
	                	   grid.addDocked({
	                		   xtype: 'toolbar',
	                		   dock: 'top',
	                		   items: [{
	                			   xtype: 'button',
	                			   itemId: 'btnAdd',
	                			   tooltip: getCommonTranslation('ADD'),
	                			   iconCls:'icon-addbutton',
	      						 cls:'addbutton'
	                		   }, {
	                			   xtype: 'button',
	                			   itemId: 'btnEdit',
	                			   tooltip: getCommonTranslation('EDIT'),
	                			   iconCls:'icon-editbutton',
	       						cls:'editbutton'
	                		   }]
	                	   });
	                   },
	                   gridRenderFunction:function(grid){
	                     	 grid.addButtonToolbar();
	                      },
	                    //**********************************Export Functionality********************************************************
	                      exportUserList : function(exportUrl,filetype,whetherAll,grid,configcode) {
	                   	   var quickSearchForm = null;
	                   	   var searchResultGrid = null;
	                   	   var pagingtoolbaroptions = null; 
	                   	   var searchCriteriaString = null;
	                   	   var jsonFormatFormData = null;
	                     
	                   	     quickSearchForm=this.getLeavereportstructure(); 
	                   	     searchResultGrid = grid;
	                   	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	                   	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	                   	     jsonFormatFormData=this.createJsonFormat(quickSearchForm,configcode,null);
	                   	  
	                   	   
	                   	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
	                   	   var reportTitle=getCommonTranslation("LEAVE_REPORT_LIST");
	                   	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                   		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	                   	   }
	                   	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	                   	   console.log("exportSuccess");
	                      }, 
	                    //**************************************End*********************************************************************  
	                   	   createSearchCriteriaString: function(searchForm) {
	                   		   var me=this;
	                   		   var formValues = new Array();
	                   		   formValues = searchForm.getValues();        
	                   		   var searchCriteriaString="";
	                   		   for (var key in formValues) {
	                   			   var value = formValues[key];            
	                   			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                   				     //var keyValueJsonObject = me.getJsonObject( key , value);
	                   				   //searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	                   			   }
	                   		   }
	                   		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	                   		   return searchCriteriaString;
	                   	   },
	                   	   userDropDownByPortal:function(){
	                   		   var $this=this;
	                   		   var form = this.getLeavereportstructure();
	                   		   var userType = form.down("#leavereport_usertype");
	                   		   userType.getStore().load({
	                   			   callback: function(rec, operation, success) {
	                   				   if (success) {
	                   					   if($this.getCurrentLoggedPortalId() == 3){
	                   						   userType.setValue(rec[2].get("id"));
	                   						   userType.setReadOnly(true);
	                   					   }else if($this.getCurrentLoggedPortalId() == 2){
	                   						   userType.setValue(rec[0].get("id"));
	                   						   userType.setReadOnly(true);
	                   					   }
	                   				   }
	                   			   }

	                   		   });
	                   	   },
	                   	   getAttendanceAndUserTypeDropDown : function(form){
	                   		   var this$ = this;
	                   		   var reportform = form.getForm();
	                   		   var academyLocationId = this.getCurrentAcademyLocation();
	                   		   var attendanceType = "";
	                   		   var facultyAttendanceType = "";
	                   		   var isCurrentPeriod = null;
	                   		   Ext.Ajax.request({
	                   			   type : 'rest',
	                   			   async: false,
	                   			   url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	                   			   params : {
	                   				   academyLocatonId : academyLocationId
	                   			   },
	                   			   method : 'GET',
	                   			   success : function(f, action) {
	                   				   if(f.responseText == 'ENTRY_NOT_FOUND')
	                   				   {
	                   					   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
	                   				   }else{
	                   					   var data = Ext.JSON.decode(f.responseText);
	                   					   attendanceType = data.studentAttendanceType;
	                   					   facultyAttendanceType = data.facultyAttendanceType;
	                   				   }
	                   			   }
	                   		   });
	                   		   form.down('#moreDetailId').setVisible(true);
	                   		   form.down('#studentName_itemId').setVisible(true);
	                   		   if(attendanceType == 'COMPLETE_DAY' || attendanceType == 'Complete Day'){
	                   			   var progStore = form.down('#programBatch_programId').getStore();
	                   			   progStore.getProxy().extraParams = {
	                   				   facultyId : this.getCurrentlyLoggedInUser().id,
	                   				   academyLocationIds : this.getCurrentAcademyLocation()
	                   			   }
	                   			   progStore.load();
	                   			   form.down('#programBatch_programId').setVisible(true);
	                   			   form.down('#programBatch_batchId').setVisible(true);
	                   			   form.down('#periodIdItemId').setVisible(true);
	                   			   form.down('#programCoursection_ID').setVisible(true);
	                   			   form.down('#course').setVisible(false);
	                   			   form.down('#CourseSection_ID').setVisible(false);
	                   			   form.down('#courseVariantId').setVisible(false);
	                   		   }else{
	                   			   var courseStore = form.down('#course').getStore();
	                   			   courseStore.getProxy().extraParams = {
	                   				academyLocationId: academyLocationId,
	     						   facultyId : this.getCurrentlyLoggedInUser().id,
	     						   sectionType : "ALL"
	                   			   }
	                   			   courseStore.load();
	                   			   form.down('#programBatch_programId').setVisible(false);
	                   			   form.down('#programBatch_batchId').setVisible(false);
	                   			   form.down('#periodIdItemId').setVisible(false);
	                   			   form.down('#programCoursection_ID').setVisible(false);
	                   			   form.down('#course').setVisible(true);
	                   			   form.down('#CourseSection_ID').setVisible(false);
	                   			   form.down('#courseVariantId').setVisible(true);
	                   		   }
	                   	   },

	                   	   myLeaveRecordSearch : function(){
	                   		   var contentpanel = this.getContentPanel();
	                   		   var title=contentPanel.getActiveTab().title;
	                   		   var form = this.getMyleavereportform().getForm();
	                   		   var values = form.getValues();
	                   		   var leaveStatus = values.leaveStatus;
	                   		   var fromDate = values.fromDate3;
	                   		   var toDate = values.toDate3;
	                   		   var userId = this.getCurrentlyLoggedInUser().id
	                   		   var grid  = this.getMyleavereportgrid();
	                   		   var gridStore = grid.getStore()
	                   		   grid.setVisible(true);
	                   		   gridStore.getProxy().extraParams = {
	                   			   userId : userId,
	                   			   statusId : leaveStatus,
	                   			   fromDate : fromDate,
	                   			   toDate : toDate,
	                   		   };
	                   		   this.resetPageSetting(gridStore);
	                   		   gridStore.load();
	                   	   },
	                   	   studentLeaveRecordSearch : function(){
	                   		   var form = this.getStudentleavereportfilter().getForm();
	                   		   var values = form.getValues();
	                   		   var leaveStatus = values.leaveStatus;
	                   		   var fromDate = values.fromDate3;
	                   		   var toDate = values.toDate3;
	                   		   var studentId = values.STUDENT_ID;
	                   		   var facultyId = this.getCurrentlyLoggedInUser().id;
	                   		   var programId = null;
	                   		   var batchId = null;
	                   		   var periodId = null;
	                   		   var courseId = null;
	                   		   var sectionId = null;
	                   		   var academylocationId = null;
	                   		   var attendanceType = null;
	                   		   var userId = this.getCurrentlyLoggedInUser().id
	                   		   var courseVariantId = null;
	                   		   var grid  = this.getStudentleavereportgrid();
	                   		   var gridStore = grid.getStore();
	                   		   grid.setVisible(true);
	                   		   academyLocationId = this.getCurrentAcademyLocation();
	                   		   Ext.Ajax.request({
	                   			   type : 'rest',
	                   			   async: false,
	                   			   url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	                   			   params : {
	                   				   academyLocatonId : academyLocationId
	                   			   },
	                   			   method : 'GET',
	                   			   success : function(f, action) {
	                   				   if(f.responseText == 'ENTRY_NOT_FOUND')
	                   				   {
	                   					   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
	                   				   }else{
	                   					   var data = Ext.JSON.decode(f.responseText);
	                   					   attendanceType = data.studentAttendanceType;
	                   				   }
	                   			   }
	                   		   });
	                   		   if(attendanceType == 'COMPLETE_DAY' || attendanceType == 'Complete Day'){
	                   			   attendanceType = "Complete Day";
	                   			   programId = values.programId;
	                   			   batchId = values.batchId;
	                   			   periodId = values.periodId;
	                   			   sectionId = values.sectionId;

	                   			   grid.columns[5].setVisible(false);
	                   			   grid.columns[5].hidden = true;

	                   		   }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
	                   			   attendanceType = "Course Level";
	                   			   courseId = values.COURSE_NAME;
	                   			   coursevariantId = values.courseVariant;
	                   			   grid.columns[2].setVisible(false);
	                   			   grid.columns[3].setVisible(false);
	                   			   grid.columns[4].setVisible(false);
	                   			   grid.columns[2].hidden = true;
	                   			   grid.columns[3].hidden = true;
	                   			   grid.columns[4].hidden = true;
	                   		   }
	                   		   gridStore.getProxy().extraParams = {
	                   			   statusId : leaveStatus,
	                   			   fromDate : fromDate,
	                   			   toDate : toDate,
	                   			   facultyId : facultyId,
	                   			   programId : programId,
	                   			   batchId :batchId,
	                   			   periodId : periodId,
	                   			   sectionId : sectionId,
	                   			   courseId : courseId,
	                   			   userId : studentId,
	                   			   coursevariantId : courseVariantId,
	                   			   attendanceType : attendanceType,
	                   			   academyLocationId: academyLocationId
	                   		   };
	                   		   this.resetPageSetting(gridStore);
	                   		   gridStore.load();
	                   	   },

});
