/**
 * @author pritam.patil
 * This controller is use to handle functionality for Completion CB's 
 */
Ext.define('Academia.controller.completion.CompletionCbController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['completion.completionlist.TerminationQuickSearchForm','completion.completionlist.PassingOutPanel', 
            'completion.completionlist.PassingOutView','completion.completionlist.TemporaryTerminationPanel', 
            'completion.completionlist.TemporaryTerminationView', 'completion.completionlist.TerminationPanel',
            'completion.completionlist.TerminationView','completion.completionlist.TransferPanel', 
            'completion.completionlist.TransferView','completion.completionlist.WithdrawalFromProgramPanel',
            'completion.completionlist.WithdrawalFromProgramView','completion.completionlist.WithdrawProgramQuickSearchForm',
            'criteriabuilder.grid.SearchResultGrid','completion.completionlist.PassingOutGrid',
            'completion.completionlist.CompletionDetailWindow','completion.PassOutRejectButtonWindow','completion.PassOutRejectButtonForm',
            'completion.completionlist.BulkImportPassoutRejectionPanel','completion.completionlist.BulkImportPassoutRejectionForm',
            'completion.completionlist.BulkImportPassoutRejectionGrid','UploadOptionRadioGroup'],

    stores: ['common.SelectNameComboStore','facilitiesresources.resourcebooking.AllProgramsStore',
             'facilitiesresources.resourcebooking.AllBatchesStore','facilitiesresources.resourcebooking.AllSectionsStore',
             'coursetransaction.sectionmanagement.SectionMultiSelect','completion.completionform.CompletionStatus',
             'servicerequest.TerminationReasons','completion.completionform.SectionByBatch','completion.completionform.PassingOutGridStore',
             'completion.completionform.ProgramCoordinatorStore','completion.completionform.BulkImportPassoutRejectionStore'],

    refs: [{
        ref: 'passingOutSearchForm',
        selector: 'withdrawprogramquicksearchform[itemId=passing_quickSearch]'
    }, {
        ref: 'transferSearchForm',
        selector: 'terminationquicksearchform[itemId=transfer_quickSearch]'
    }, {
        ref: 'withdrawalFromProgramSearchForm',
        selector: 'withdrawprogramquicksearchform[itemId=withdrawalFromProgram_quickSearch]'
    }, {
        ref: 'terminationSearchForm',
        selector: 'terminationquicksearchform[itemId=termination_quickSearch]'
    }, {
        ref: 'temporaryTerminationSearchForm',
        selector: 'terminationquicksearchform[itemId=tempTermination_quickSearch]'
    },
    /* Search Result Grid REf */
    {
        ref: 'passingoutgrid',
        selector: 'passingoutgrid'
    }, {
        ref: 'temporaryTerminationSearchResultGrid',
        selector: 'searchresultgrid[itemId=temporaryTerminationSearchResultGrid]'
    }, {
        ref: 'terminationSearchResultGrid',
        selector: 'searchresultgrid[itemId=terminationSearchResultGrid]'
    }, {
        ref: 'transferSearchResultGrid',
        selector: 'searchresultgrid[itemId=transferSearchResultGrid]'
    }, {
        ref: 'withdrawalProgramSearchResultGrid',
        selector: 'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid]'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    },
    {
        ref: 'passoutrejectbuttonwindow',
        selector: 'passoutrejectbuttonwindow'
    },
    {
        ref: 'passoutrejectbuttonform',
        selector: 'passoutrejectbuttonform'
    },{
        ref: 'bulkimportpassoutrejectionform',
        selector: 'bulkimportpassoutrejectionform'
    },{
        ref: 'bulkimportpassoutrejectiongrid',
        selector: 'bulkimportpassoutrejectiongrid'
    },{
     	ref: 'uploadoptionradiogroup',
    	selector: 'uploadoptionradiogroup'
    },{
     	ref: 'passingoutview',
    	selector: 'passingoutview'
    }],
    config: {
    	COMPLETION_PASSING_OUT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_PASSING_OUT_PRIVILEGES'),
    	COMPLETION_TERMINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_TERMINATION_PRIVILEGES'),
    	COMPLETION_TEMPORARY_TERMINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_TEMPORARY_TERMINATION_PRIVILEGES'),
    	COMPLETION_TRANSFER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_TRANSFER_PRIVILEGES'),
    	COMPLETION_WITHDRAW_FROM_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_WITHDRAW_FROM_PROGRAM_PRIVILEGES')
    },
    init: function() {
        this.control({

            'withdrawprogramquicksearchform[itemId=passing_quickSearch] button[itemId=passingOutFindButtonId]': {
                click: this.loadPassingOutGridAndSearchRequest
            },         
            'terminationquicksearchform[itemId=termination_quickSearch] button[itemId=terminationFindButtonId]': {
                click: this.loadTerminationGridAndSearchRequest
            },          
            'terminationquicksearchform[itemId=tempTermination_quickSearch] button[itemId=terminationFindButtonId]': {
                click: this.loadTemporaryTerminationGridAndSearchRequest
            },
            'terminationquicksearchform[itemId=transfer_quickSearch] button[itemId=terminationFindButtonId]': {
                click: this.loadTransferGridAndSearchRequest
            },            
            'withdrawprogramquicksearchform[itemId=withdrawalFromProgram_quickSearch] button[itemId=passingOutFindButtonId]': {
                click: this.loadWithdrawProgramGridAndSearchRequest
            },           
            'withdrawprogramquicksearchform button[itemId=passingOutClearSearch]': {
                click: this.clearSearchForm
            },
            'terminationquicksearchform button[itemId=terminationClearSearch]': {
                click: this.clearSearchForm
            },
            
            'withdrawprogramquicksearchform combo[itemId=programId]': {
            	afterrender : function(combo){
            		var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = combo.getStore();
                   	store.proxy.extraParams = {
  							 academyLocationId : academyLocationId
  					};
                },
	           	 select: function(programCombo, records, eOpts) {
	           		var this$ = this;
	           		var academyLocationId = this.getCurrentAcademyLocation();
	               	var batchCombo = programCombo.up('form').down('#batchId');
	            	var programCord = programCombo.up('form').down('#ProgramCoordinatorId');
	               	this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
	               	programCord.reset()
	               	var programComboVal = programCombo.getValue()
	               	var programCordStore = programCord.getStore();
	               	programCordStore.proxy.extraParams = {
	               			academyLocationId : academyLocationId,
	               			programId : programComboVal	 
	               			
  					};
	               	programCordStore.load()
	           	 }
                
            },
            
            'withdrawprogramquicksearchform combo[itemId=batchId]': {
             	 select: function(batchCombo, records) {
             		 var this$ = this;
             	 	var sectionCombo = batchCombo.up('form').down('#sectionId');
             		 this$.loadDependentCombo(sectionCombo, batchCombo.getValue(), 'batchIds');
             	 }
            },
            
            'terminationquicksearchform combo[itemId=programId]': {
            	afterrender : function(combo){
            		var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = combo.getStore();
                   	store.proxy.extraParams = {
  							 academyLocationId : academyLocationId
  					};
                },
	           	 select: function(programCombo, records, eOpts) {
	           		var this$ = this;
	               	var batchCombo = programCombo.up('form').down('#batchId');
	               	this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
	           	 }
                
            },
            
            'terminationquicksearchform combo[itemId=batchId]': {
             	 select: function(batchCombo, records) {
             		 var this$ = this;
             	 	var sectionCombo = batchCombo.up('form').down('#sectionId');
             		 this$.loadDependentCombo(sectionCombo, batchCombo.getValue(), 'batchIds');
             	 }
            },
            'searchresultgrid[itemId=terminationSearchResultGrid]': {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=temporaryTerminationSearchResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				},
 				afterrender:this.hideUpdateStatusButton
            },
            'searchresultgrid[itemId=transferSearchResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'terminationquicksearchform[itemId=tempTermination_quickSearch]' : {
            	render: function(form){ 
            			this.hideQuickBoxCheckbox(form);
            		}
            },
            'passingoutgrid': {
            	afterrender : function(grid){
 					this.doAccessControlValidation(grid, this.getCOMPLETION_PASSING_OUT_PERMISSIONS());
 					this.disableMoreActionPivileges(grid, this.getCOMPLETION_PASSING_OUT_PERMISSIONS());
					this.addDataGridConfigButton(grid, this.getCOMPLETION_PASSING_OUT_PERMISSIONS());
    							
 					grid.down('#certificateBtnId').setVisible(true);
 				}
 				
            },
            
            
            
            'terminationpanel grid[itemId=terminationSearchResultGrid]': {
            	afterrender : function(grid){
            		this.disableMoreActionPivileges(grid,this.getCOMPLETION_TERMINATION_PERMISSIONS());
 					/*this.genericCBGridAccessControlValidation(grid, this.getCOMPLETION_TERMINATION_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);*/
 				}	
            },
            'temporaryterminationpanel searchresultgrid[itemId=temporaryTerminationSearchResultGrid]': {
            	afterrender : function(grid){
            		this.disableMoreActionPivileges(grid,this.getCOMPLETION_TEMPORARY_TERMINATION_PERMISSIONS());
 					/*this.genericCBGridAccessControlValidation(grid, this.getCOMPLETION_TEMPORARY_TERMINATION_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);*/
 				}
            },
            'transferpanel grid[itemId=transferSearchResultGrid]': {
            	afterrender : function(grid){
            		this.disableMoreActionPivileges(grid,this.getCOMPLETION_TRANSFER_PERMISSIONS());
 					/*this.genericCBGridAccessControlValidation(grid, this.getCOMPLETION_TRANSFER_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);*/
 				}
            },
            'withdrawalfromprogrampanel grid[itemId=withdrawalFromProgramSearchResultGrid]' : {
            	afterrender : function(grid){
            		this.disableMoreActionPivileges(grid,this.getCOMPLETION_WITHDRAW_FROM_PROGRAM_PERMISSIONS());
 				}
            },
	        /**** Export button for termination ******/
	        'searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'TERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'TERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'TERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'TERMINATION');
	            }
	        },
	        /**** Export button for temporary termination ******/
	        'searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'TEMPTERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'TEMPTERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'TEMPTERMINATION');
	            }
	        },
	        'searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'TEMPTERMINATION');
	            }
	        },
	        /**** Export button for transfer ******/
	        'searchresultgrid[itemId=transferSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'TRANSFER');
	            }
	        },
	        'searchresultgrid[itemId=transferSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'TRANSFER');
	            }
	        },
	        'searchresultgrid[itemId=transferSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'TRANSFER');
	            }
	        },
	        'searchresultgrid[itemId=transferSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'TRANSFER');
	            }
	        },
	        /**** Export button for Withdraw from program ******/
	        'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'WITHDRAWFROMPROGRAM');
	            }
	        },
	        'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'WITHDRAWFROMPROGRAM');
	            }
	        },
	        'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'WITHDRAWFROMPROGRAM');
	            }
	        },
	        'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'WITHDRAWFROMPROGRAM');
	            }
	        },
	        'withdrawprogramquicksearchform customcombobox[itemId=ProgramCoordinatorId] ':{
	        	render : function(combo){            		
            		var academyLocationId = this.getCurrentAcademyLocation();                   
                   	var store = combo.getStore();
                   	store.proxy.extraParams = {
  							 academyLocationId : academyLocationId
  					};
                   	
                },
	        },
	        'bulkimportpassoutrejectionform':{
				render: function(obj){
					var $this = this;
					var temForm = $this.getBulkimportpassoutrejectionform();
					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
					var grid = $this.getBulkimportpassoutrejectiongrid();
					var form = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_IMPORT_PASSOUT_REJECTION');
					tempFormValue.getStore().load({
						callback:function(record){
							for(var i in record){
								if(record[i].data.value == 'Bulk Import Passout Rejection'){
									tempFormValue.setValue(record[i].data.id);
									tempFormValue.setReadOnly(true);
								}
							}
						}
					});
				}
			},
			'bulkimportpassoutrejectionform button[itemId=SubmitBtn]':{
				click: function(obj){
					var temForm = obj.up('bulkimportpassoutrejectionform');
			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getRawValue();
			    	var $this=this;
			    	var grdStore;
			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	            $this.getHashOfFile(temForm);
		            setTimeout(function() {
				    	temForm.getForm().submit({
				    		method : 'POST',
				    		url : submitUrl,
				    		success : function(form, action){
					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        	temForm.getForm().isValid();
				    		},
				    		failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				    	    }
				    	});
		        	},1000);
		            Ext.defer(function() {
		            	var grid = $this.getBulkimportpassoutrejectiongrid();
		            	var form = $this.getUploadoptionradiogroup();
		            	var isUploadAll = form.items.items[0].getValue().isUploadAll;
		            	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_IMPORT_PASSOUT_REJECTION');
		            }, 2000, this);
					
				}
			},
			'bulkimportpassoutrejectionform button[itemId=resetBtn]':{
				click: function(obj){
					var $this=this;
					var temForm = $this.getBulkimportpassoutrejectionform();
					temForm.down('#uploadFileField').reset();
					var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
					temForm.getForm().isValid();

					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
					var grid = $this.getBulkimportpassoutrejectiongrid();
					var form = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					var templateNameValue= "Bulk Import Passout Rejection";
                     	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_IMPORT_PASSOUT_REJECTION');
					tempFormValue.getStore().load({
						callback:function(record){
							for(var i in record){
								if(record[i].data.value == templateNameValue){
									tempFormValue.setValue(record[i].data.id);
									tempFormValue.setReadOnly(true);
								}
							}
						}
					});
				}
			},
			'bulkimportpassoutrejectionform uploadoptionradiogroup[itemId=bulkPassoutRejectionUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
				 change: function( radioGroup, newValue, oldValue, eOpts){
					 var grid =this.getBulkimportpassoutrejectiongrid();
					 var form =this.getUploadoptionradiogroup();
					 var isUploadAll = newValue.isUploadAll;
					 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_IMPORT_PASSOUT_REJECTION');
				 }   
			 },
			 'passingoutview': {
	             	 render:function(structure){
	    				 this.disableBulkImportPassoutRejectionTab(structure, this.getCOMPLETION_PASSING_OUT_PERMISSIONS());
	    			 }
	             },
			 'bulkimportpassoutrejectiongrid':{
 				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 					if (e.target.tagName == 'A') {
 						var fileType=null;
 						if(cellIndex==1){
 							fileType='successFile';
 						}else if(cellIndex==6){
 							fileType='errorFile';
 						}else if(cellIndex==7){
 							fileType='logFile';
 						}
 						var documentId = record.get("id");
 						if (!isNullOrEmpty(documentId)) {
 							this.getImportListDownloadFile(documentId,fileType);
 						}
 					}
 				}
 			},
 			
			'bulkimportpassoutrejectiongrid button[itemId=btnForce]':{
				 click : function(obj) {
					 var grid = this.getBulkimportpassoutrejectiongrid();
		            	if (grid.getSelectionModel().getCount() > 0) {
		            		if(grid.getSelectionModel().getCount() > 1){
			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			        		}else{
			        			var this$ = this;
	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
	 	                	var urlAppend="?jobName="+id;
	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	 	    	        	Ext.Ajax.request({
	 	    	        		url: submitURL,
	 	    	        		method: 'GET',
	 	    	        		success: function(response) {
	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	 	    	        			}else if(response.responseText==="SUCCESS"){
	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	        			}
	 	    	        		}
	 	    	        	});
			        		}
		            	} else {
		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            	}  
		            }
			 }
        });
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
	    
    exportReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var reportTitle = null;
	    	if(requestType == 'TERMINATION'){
	    	 quickSearchForm=this.getTerminationSearchForm();
	    	 searchResultGrid = this.getTerminationSearchResultGrid();	
	    	 pagingtoolbaroptions = this.getTerminationSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("COMPLETION_TERMINATION");
	    	}
	    	if(requestType == 'TEMPTERMINATION'){
	    	 quickSearchForm=this.getTemporaryTerminationSearchForm();
	    	 searchResultGrid = this.getTemporaryTerminationSearchResultGrid();
	    	 pagingtoolbaroptions = this.getTemporaryTerminationSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("COMPLETION_TEMPORARY_TERMINATION");
	    	}
	    	if(requestType == 'TRANSFER'){
	    	 quickSearchForm=this.getTransferSearchForm();
	    	 searchResultGrid = this.getTransferSearchResultGrid();
	    	 pagingtoolbaroptions = this.getTransferSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("COMPLETION_TRANSFER");
	    	}
	    	if(requestType == 'WITHDRAWFROMPROGRAM'){
	    	 quickSearchForm=this.getWithdrawalFromProgramSearchForm();
	    	 searchResultGrid = this.getWithdrawalProgramSearchResultGrid();
	    	 pagingtoolbaroptions = this.getWithdrawalProgramSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("COMPLETION_WITHDRAW_FROM_PROGRAM");
	    	}
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		hideQuickBoxCheckbox: function(form){
		form.down("#checkBoxFieldContainer").setVisible(false);
		},
		createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key];            
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                var keyValueJsonObject = me.getJsonObject( key , value);
	    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	    },
	    
	    gridRenderFunction:function(grid){
	    	  grid.addDocked({
	              xtype: 'toolbar',
	              itemId: 'functionButtonsToolbar',
	              dock: 'top',
	              items: [/*{
  					xtype: 'button',
					itemId: 'searchResultGridBtnView',
					tooltip : getCommonTranslation('VIEW'),
					iconCls: 'view-icon'	
				},*/{
	                  xtype: 'button',
	                  itemId: 'searchResultGridBtnUpdate',
			          text: getCompletionModuleTranslation('UPDATE')
	              },{
	                  xtype: 'button',
	                  text: getCompletionModuleTranslation('UPDATE_STATUS'),
	                  itemId: 'updateStatus'
	              },{
	  				xtype: 'button',
					text:getProgramandcourseTranslation('EMAIL_CERTIFICATE'),
					hidden:true,
					itemId: 'emailCertificate',
	              }, {
	            	    xtype: 'button',
	            	    itemId: 'exportToPdfBtn',
	            	    text: getCommonTranslation('PRINT_EXPORT_BTN'),
	            	    //iconCls: 'export-combo-icon', // Optional icon
	            	    cls: 'print_export_btn_cls',
	            	    menu: [{
	            	        text: 'Export to PDF',
	            	        //itemId: 'btnExportToPDF',
	            	        menu: [{
	            	            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
	            	            itemId: 'exportCurrentPagePdf'
	            	        }, {
	            	            text: getCommonTranslation('EXPORT_ALL_COMMON'),
	            	            itemId: 'exportPdfAll'
	            	        }]
	            	    }, {
	            	        text: 'Export to Excel',
	            	        itemId: 'exportToPdfBtn',
	            	        menu: [{
	            	            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
	            	            itemId: 'exportCurrentExcelPage'
	            	        }, {
	            	            text: getCommonTranslation('EXPORT_ALL_COMMON'),
	            	            itemId: 'exportExcelAll'
	            	        }]
	            	    }]
	            	}/*{
	  		        xtype: 'splitbutton',
	  		        itemId: 'exportToPdfBtn',
	  		      cls: 'CustomToolbarBtnExport export-cls',
	  		        iconCls:'export-pdf-icon',
	  		        //text: 'Export To Pdf',      
	  		        menu: [{
	  		            text: 'Export Current Page',
	  		            itemId: 'exportCurrentPagePdf'
	  		        }, {
	  		            text: 'Export All',
	  		            itemId: 'exportPdfAll'
	  		        } ],
	  		        listeners: { click: function() { this.showMenu(); } }
	  		    },{
	  		        xtype: 'splitbutton',
	  		        itemId: 'exportToPdfBtn',
	  		      cls: 'CustomToolbarBtnExport export-cls',
	  		        iconCls:'export-excel-icon',
	  		        //text: 'Export To Xcel',      
	  		        menu: [{
	  		            text: 'Export Current Page',
	  		            itemId: 'exportCurrentExcelPage'
	  		        }, {
	  		            text: 'Export All',
	  		            itemId: 'exportExcelAll'
	  		        } ],
	  		        listeners: { click: function() { this.showMenu(); } }
	  		    }*/]
	          });
	    },
	    
    /**
     * This method is used to load Passing Out request grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
	    loadPassingOutGridAndSearchRequest: function(model, records) {
	    	var $this = this;
	    	var SearchForm = this.getPassingOutSearchForm();
	    	var nameValue = SearchForm.down('#selectedName');
	    	formValues = SearchForm.getValues();
	    	if (formValues.STATUS !== 'ALL') {
	    		var status = formValues.STATUS
	    	}
	    	var passingOutGrid = this.getPassingoutgrid();
	    	var passingOutGridStore = passingOutGrid.getStore();
	    	passingOutGridStore.getProxy().extraParams = {
	    		academyLocationId : $this.getCurrentAcademyLocation(),
	    		programId:formValues.PROGRAM,
	    		batchId:formValues.BATCH,
	    		sectionId:formValues.SECTION,
	    		programCoordinatorId:formValues.ProgramCoordinator,
	    		admissionCode:formValues.ADMISSION_ID,
	    		studentCode:formValues.STUDENT_ID,
	    		studentSearchType:SearchForm.down('#selectedNameField').getRawValue(),
	    		studentName:nameValue.getValue(),
	    		effectiveFromDate:formValues.FROM_DATE,
	    		effectiveToDate:formValues.TO_DATE,
	    		status:status,
	    		isDocumentPending:formValues.IS_DOCUMENT_PENDING,
	    		isPaymentPending:formValues.IS_PAYMENT_PENDING,
	    		isRefundPending:formValues.IS_REFUND_PENDING
	    	};
	    	//this.resetPageSetting(passingOutGridStore);
	    	//passingOutGridStore.load();
	    	var searchGrid = this.getPassingoutgrid();
	    	searchGrid.down('#publishGraduationCertificate').disable();
	    	searchGrid.down('#rejectBtnId').disable();
	    	 $this.resetPageSetting(passingOutGridStore, passingOutGrid);
						passingOutGridStore.load(); 
						passingOutGrid.getSelectionModel().deselectAll();
						passingOutGridStore.pageSize=100;
	    	
	    },

    /**
     * This method is used to load termination request grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadTerminationGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getTerminationSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var searchResultGrid = this.getTerminationSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TERMINATION_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },

    /**
     * This method is used to load temporary termination request grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadTemporaryTerminationGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getTemporaryTerminationSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var searchResultGrid = this.getTemporaryTerminationSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TEMP_TERMINATION_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },

    /**
     * This method is used to load Transfer request grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadTransferGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getTransferSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var searchResultGrid = this.getTransferSearchResultGrid();
        var grid=searchResultGrid;  
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRANSFER_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
		this.resetPageSetting(grid.getStore(), grid);
		grid.getStore().load();    
    },

    /**
     * This method is used to load Withdraw Program request grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadWithdrawProgramGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getWithdrawalFromProgramSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var searchResultGrid = this.getWithdrawalProgramSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.WITHDRAW_PROGRAM_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(SearchForm) {

        var nameValue = SearchForm.down('#selectedName');

        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = this.getConfigCode(SearchForm.itemId);

        formValues = SearchForm.getValues();

        if (SearchForm.itemId === 'passing_quickSearch') {

            var ADMISSION_ID = this.getJsonObject('ADMISSION_ID', formValues.ADMISSION_ID);
            this.pushJsonObjectInArray(ADMISSION_ID, searchcriteria);
        }
        if (SearchForm.itemId === 'withdrawalFromProgram_quickSearch') {
        	
        	var ADMISSION_ID = this.getJsonObject('ADMISSION_ID', formValues.ADMISSION_ID);
            this.pushJsonObjectInArray(ADMISSION_ID, searchcriteria);

            var WITHDRWAL_REASON = this.getJsonObject('WITHDRWAL_REASON', formValues.WITHDRWAL_REASON);
            this.pushJsonObjectInArray(WITHDRWAL_REASON, searchcriteria);
        }
        var STUDENT_ID = this.getJsonObject('STUDENT_ID', formValues.STUDENT_ID);
        this.pushJsonObjectInArray(STUDENT_ID, searchcriteria);

        var STUDENT_NAME = this.getJsonObject(nameValue.name, nameValue.getValue());
        this.pushJsonObjectInArray(STUDENT_NAME, searchcriteria);

        var PROGRAM = this.getJsonObject('PROGRAM', formValues.PROGRAM);
        this.pushJsonObjectInArray(PROGRAM, searchcriteria);

        if (!isNullOrEmpty(formValues.BATCH) && formValues.BATCH !== undefined) {
	        var BATCH = this.getJsonObject('BATCH', formValues.BATCH);
	        this.pushJsonObjectInArray(BATCH, searchcriteria);
        }

        if (!isNullOrEmpty(formValues.SECTION) && formValues.SECTION !== undefined) {
	        var SECTION = this.getJsonObject('SECTION', formValues.SECTION);
	        this.pushJsonObjectInArray(SECTION, searchcriteria);
        }

        if (SearchForm.itemId === 'termination_quickSearch' || SearchForm.itemId === 'tempTermination_quickSearch') {
            var TERMINATION_REASON = this.getJsonObject('TERMINATION_REASON', formValues.TERMINATION_REASON);
            this.pushJsonObjectInArray(TERMINATION_REASON, searchcriteria);
        }

        if (SearchForm.itemId === 'transfer_quickSearch') {
            var TRANSFER_REASON = this.getJsonObject('TRANSFER_REASON', formValues.TRANSFER_REASON);
            this.pushJsonObjectInArray(TRANSFER_REASON, searchcriteria);
        }
        if (formValues.STATUS !== 'ALL') {
        		var STATUS = this.getJsonObject('STATUS', formValues.STATUS);
        		this.pushJsonObjectInArray(STATUS, searchcriteria);
        }
        
    		
		 var EFFECTIVE_FROM_DATE = this.getJsonObject('EFFECTIVE_FROM_DATE', formValues.FROM_DATE, formValues.TO_DATE);
		 this.pushJsonObjectInArray(EFFECTIVE_FROM_DATE, searchcriteria);
		
		    if (SearchForm.itemId === 'passing_quickSearch' || SearchForm.itemId === 'termination_quickSearch' || SearchForm.itemId ==='transfer_quickSearch' ||SearchForm.itemId === 'withdrawalFromProgram_quickSearch')
		{	
			var IS_PAYMENT_PENDING = this.getJsonObject('IS_PAYMENT_PENDING', formValues.IS_PAYMENT_PENDING);
			this.pushJsonObjectInArray(IS_PAYMENT_PENDING, searchcriteria);
			
			var IS_DOCUMENT_PENDING = this.getJsonObject('IS_DOCUMENT_PENDING', formValues.IS_DOCUMENT_PENDING);
			this.pushJsonObjectInArray(IS_DOCUMENT_PENDING, searchcriteria);
			
			var IS_REFUND_PENDING = this.getJsonObject('IS_REFUND_PENDING', formValues.IS_REFUND_PENDING);
			this.pushJsonObjectInArray(IS_REFUND_PENDING, searchcriteria);
			
			var IS_DOCUMENT_RETURNED = this.getJsonObject('IS_DOCUMENT_RETURNED', formValues.IS_DOCUMENT_RETURNED);
			this.pushJsonObjectInArray(IS_DOCUMENT_RETURNED, searchcriteria);
			
			var CERTIFICATE_STATUS = this.getJsonObject('CERTIFICATE_STATUS', formValues.CERTIFICATE_STATUS);
			this.pushJsonObjectInArray(CERTIFICATE_STATUS, searchcriteria);
		}

        var academyLocationId = this.getCurrentAcademyLocation();
        var academyLocationObj = this.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
        this.pushJsonObjectInArray(academyLocationObj,searchcriteria);

        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This method is used to set config code according to search form 
     * @param searchform.xtype
     * @return config code
     */
    getConfigCode: function(searchForm) {

        var code;
        switch (searchForm) {
        case 'passing_quickSearch':
            {
                code = CONSTANTS.CB.PASSING_OUT_BASIC_CONFIGCODE;
                return code;
                break;
            }
        case 'termination_quickSearch':
            {
                code = CONSTANTS.CB.TERMINATION_BASIC_CONFIGCODE;
                return code;
                break;
            }
        case 'tempTermination_quickSearch':
            {
                code = CONSTANTS.CB.TEMP_TERMINATION_BASIC_CONFIGCODE;
                return code;
                break;
            }
        case 'transfer_quickSearch':
            {
                code = CONSTANTS.CB.TRANSFER_BASIC_CONFIGCODE;
                return code;
                break;
            }
        case 'withdrawalFromProgram_quickSearch':
            {
                code = CONSTANTS.CB.WITHDRAW_PROGRAM_BASIC_CONFIGCODE;
                return code;
                break;
            }
        }
    },

    /**
     * This method is used to get active tab from content panel 
     * @return active tab
     */
    getContentPanelActiveTab: function() {
        var this$ = this;
        var activeTab = null;
        var contentPanel = this$.getContentPanel();
        if (contentPanel) {
            activeTab = contentPanel.getActiveTab();
        }
        return activeTab;
    },

    /**
     * This method is used to clear fields on student REquest & faculty REquest's search Form
     * @param button which is reference of buttton
     */
    clearSearchForm: function(button) {
    	var $this=this;
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var form =button.up('form');
		form.getForm().reset();
        this.clearCombo(form.down('#sectionId'), true);
    	this.clearCombo(form.down('#batchId'), true);
    	
    	var programCoordinator = form.down('#ProgramCoordinatorId');
    	programCoordinator.getStore().load({
    		callback: function(){				
    			programCoordinator.getStore().getProxy().extraParams={
    				academyLocationId:academyLocationId
    	    	}
    			programCoordinator.getStore().load();
    		}
    	})
//    			var academyLocationId = this.getCurrentAcademyLocation();                   
//               	var store = combo.getStore();
//               	store.proxy.extraParams = {
//							 academyLocationId : academyLocationId
//					};
			
    },
    
    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo, isDisabled) {
        combo.clearValue();
        combo.store.removeAll();
        combo.setDisabled(isDisabled);
    },      
    
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },
    
    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
    	var form = combo.up('form');
        switch (combo.name) {
        case 'PROGRAM_NAME':
            break;
        case 'BATCH':
            this.clearCombo(combo, false);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'SECTION':
            this.clearCombo(combo, false);
            break;
        }
    },
    
    hideUpdateStatusButton:function(form) {
    	var button = form.down('#updateStatus');
    	button.setVisible(false);
    },
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var updateButton = gridReference.down('#updateButtonId');
    	var moreActionButton = gridReference.down('#spBtnMoreActions');
    	var rejectbtn=gridReference.down("#rejectBtnId");
    	var emailCertificate = gridReference.down('#emailCertificate');
    	
    	if(!isNullOrEmpty(updateButton)){
    		updateButton.setVisible(false);
    	}
    	if(!isNullOrEmpty(rejectbtn)){
    		rejectbtn.setVisible(false);
    	}
    	if(!isNullOrEmpty(moreActionButton)){
    		moreActionButton.setVisible(false);
    	}
    	if(!isNullOrEmpty(emailCertificate)){
    		emailCertificate.setVisible(false);
    	}
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'UPDATE') {
    			if(!isNullOrEmpty(updateButton)){
    				updateButton.setVisible(true);
    			}        		
    		}
    		if (privilege === 'MOREACTION') {
    			if(!isNullOrEmpty(moreActionButton)){
    				moreActionButton.setVisible(true);
    			}        		
    		}
    		if (privilege === 'REJECTED') {
    			if(!isNullOrEmpty(rejectbtn)){
    				gridReference.down("#rejectBtnId").setVisible(true); 
    			}        		
    		}
    		if (privilege === 'EMAIL_CERTIFICATE') {
    			if(!isNullOrEmpty(emailCertificate)){
    				emailCertificate.setVisible(true); 
    			}        		
    		}
    	});
    	
    	
    },
    getImportListDownloadFile : function(documentId,fileType){

    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params :{
    				access_token : Ext.Ajax.defaultHeaders.access_token
    			},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
    			standardSubmit :true
    		});
    	}
    },
    
	disableBulkImportPassoutRejectionTab:function(structure,permissionsMap){
	   	 var associatedAcadLocationIds = new Array();
	   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   	 var bulkImportPassoutRejectionTab=false;
	   	 
	   	 for (var i = 0; i < permissionList.length; i++) {
	   		 if (permissionList[i] === "BULK_IMPORT_PASSOUT_REJECTION") {
	   			bulkImportPassoutRejectionTab=true;
	   		 }
	   	 }
	   	 this.showmBulkImportPassoutRejectionImportTab(bulkImportPassoutRejectionTab, structure);
	    
  },
  showmBulkImportPassoutRejectionImportTab: function(bulkImportPassoutRejectionTab, structure){
  	var panelItem = [];
  	var $this = this;
  	var newcont=structure.items.items.length;
  	var insertPosition=newcont+1;

  	var tabItems = [{
        xtype: 'passingoutpanel',
        itemId : 'passingOutPanelSearch',
        title: getCommonTranslation('SEARCH'),
        tabCls: 'right-tab'
    }, {
        xtype: 'advancedsearchquerybuilder',
    	searchConfigCode : CONSTANTS.CB.PASSING_OUT_CONFIGCODE,
		searchResultViewCode: CONSTANTS.CB.PASSING_OUT_VIEWCODE,
		permissionMapKey:'COMPLETION_PASSING_OUT_PRIVILEGES',
	    gridTitle: getCommonTranslation("COMPLETION_PASSING_OUT_LIST"),
		tabCls: 'right-tab'
    }];

  	if(bulkImportPassoutRejectionTab == true){
  		tabItems.push({
  			xtype: 'bulkimportpassoutrejectionpanel',
  	        itemId : 'bulkimportpassoutrejectionpanel',
  	        title: getCommonTranslation('BULK_IMPORT_PASSOUT_REJECTION'),
  	        tabCls: 'right-tab'
  	    });
  	}

  	panelItem.push({
  		xtype:'tabpanel',
  	    autoScroll: false,
        cls: 'noPaddingPanel',
        plain: true,
  		items: tabItems
  	});

  	structure.insert(insertPosition, panelItem);
  },
  

});
