Ext.define('Academia.controller.course.CreateCourseController',{
	extend : 'Ext.app.Controller',
	models : [ 'common.IdValueDataModel',
	           'genericmodels.dropdowns.EnumCombo',
	           'course.CreateCourseModel',
	           'course.CourseCoordinatorModel',
	            'course.CourseDocument'
	           ],
       stores : [ 'course.CourseDepartmentStore',
                  'course.CourseMarkGradeStore',
                  'course.CourseStageStore',
                  'course.CourseCoordinatorStore',
                  'course.CourseSubDepartmentStore',
                  'course.CourseGradeStore',
                  'course.CourseDocument','course.CourseCoordinatorSmartSearch',
                  'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades','course.CourseCategoryStore','course.CourseSubjectTypeStore',
                  'examinationcenters.evaluation.applyrule.CalculationBussinessRule','course.CourseDeficitsStore','course.CourseCESMCodeStoreFromCSM',
                  'course.CourseNQFLevelStoreFromCSM'],
              views : [ 'course.CreateCourseForm',
                        'baselayout.contentarea.ContentPanel',
                        'course.CourseDocumentGrid' ],

                    refs : [ {
                    	ref : 'createcourseform',
                    	selector : 'createcourseform'
                    }, {
                    	ref : 'contentpanel',
                    	selector : 'contentpanel'
                    }, {
                    	ref : 'basicdetailform',
                    	selector : 'basicdetailform'
                    }, {
                    	ref : 'coursetabstructure',
                    	selector : 'coursetabstructure'

                    }, {
                    	ref : 'simpledocumentform',
                    	selector : 'simpledocumentform'

                    }, {
                    	ref : 'coursedocumentgrid',
                    	selector : 'coursedocumentgrid'

                    } ],

                    init : function() {
                    	this
                    	.control({
                    		'createcourseform':{
                    			render : function(obj) {
                    				var this$ =this;
                    				var form=this.getCreatecourseform();
                    				obj.body.on('click', function() {
                    					this$.getController('Academia.controller.base.BaseController').hideInvalidIconFromField(obj);
            	    	    	       });
                    				var sectionType=form.down('#assignSectionTypeId');
                    				var sectionTypeStore=sectionType.getStore();
                    				sectionTypeStore.load({
                    					callback : function(record,operation, success) {
                    					if (success) {
                    						sectionType.setValue("COURSE_SECTION");
                    					}
                    				}});
                    				var stageType=form.down('#stage_Type');
                    				var stageTypeStore=stageType.getStore();
                    				stageTypeStore.load({
                    					callback : function(record,operation, success) {
                    					if (success) {
                    						stageType.setValue("COURSE_EXECUTION");
                    					}
                    				}});
                    				
                    				var subjectType = form.down("#subjectType_Id");
                    				if(!isNullOrEmpty(subjectType))
                    				{
										subjectTypeStore = subjectType.getStore();
										subjectTypeStore.load();
									}
                    				
                    			}
                    		},
                    		'createcourseform button[itemId=createform_addmorebuttonId]' : {
                    			click : this.createNewTab
                    		},
                    		'createcourseform button[itemId=createdetail_FormSubmitButtonId]' : {
                    			click : this.addCreateCourse
                    		},
                    		'createcourseform button[itemId=courseResetBtn]' : {
                    			click : this.addCreateCourseformReset
                    		},
                    		// 'basicdetailform
                    		// button[itemId=basicdetail_FormSubmitButtonId]'
                    		// : {
                    		// click : this.addCreateCourse
                    		// },
                    		'createcourseform radiogroup[itemId=course_Deficiency_Status_Id]' : {
                    			change : this.courseDeficiencyStatusChange
                    		},
                    		'createcourseform radiogroup[itemId=sectionAtComponentLevel_id]' : {
                    			change : function(cb, nv, ov){
                    				var form=this.getCreatecourseform();
                    				var calcualtionRuleId=form.down('#calcualtionRuleId');
                    				calcualtionRuleId.reset();
                    				if (nv.sectionAtComponentLevel==1) {
                    					calcualtionRuleId.show();
                    				}else{
                    					calcualtionRuleId.hide();
                    				}
                    			}
                    		},
                    		'createcourseform radiogroup[itemId=isLMSCoursesId]' : {
                    			change : function(cb, nv, ov){
                    				var form=this.getCreatecourseform();
                    				var lMSCourseOfferYearItemId=form.down('#lMSCourseOfferYearItemId');
                    				var isPublishToLMS=form.down('#isPublishToLMS');
                    				lMSCourseOfferYearItemId.reset();
                    				isPublishToLMS.reset();
                    				if (nv.isLMSCourses) {
                    					lMSCourseOfferYearItemId.show();
                    					isPublishToLMS.show();
                    					isPublishToLMS.setValue(true);
                    				}else{
                    					lMSCourseOfferYearItemId.hide();
                    					isPublishToLMS.hide();
                    				}
                    			}
                    		},
                    		'createcourseform radiogroup[itemId=modulePrerequisitesRadioItemId]' : {
                    			change : function(cb, nv, ov){
                    				var me = this;
                    				var form=this.getCreatecourseform();
                    				var modulePrerequisitesFieldset = form.down('#modulePrerequisitesFieldsetItemId');
                    				var radioValue = cb.getValue();
                    				if(radioValue.modulePrerequisitesRadio == 0){
                    					modulePrerequisitesFieldset.setVisible(false);
                    				}
                    				else{
                    					modulePrerequisitesFieldset.setVisible(true);
                    				}
                    			}
                    		},
                    		/*'createcourseform combo#courseCoordinat.or' : {
                    			select : function(obj, record) {
                    				var code = record[0].get("code");
                    				var form = this.getCreatecourseform().getForm();
                    				form.findField('userCode').setValue(code);
                    			}
                    		},*/
                    		'createcourseform combo[itemId=courseMarksGrades_id]' : {
                    			select : function(o, r) {
                    				this.courseMarkGrade(o, r);
                    			}
                    		},
                    		'createcourseform combo[itemId=stage_Type]' : {
                    			change : function(o, r) {
                    				this.stageTypeChange(o, r);
                    			}
                    		},
                    		'createcourseform customcombobox[itemId=course_Deficits_Id]' : {
                    			change : this.courseDeficitsChange
                    		},
                    		'createcourseform radiogroup[itemId=hasCourseComponents_id]' : {
                    			change : this.hasCourseComponentsChange
                    		},
                    		'createcourseform combo#courseDepartment' : {
                    			select : function(obj, record) {
                    				var subDept = obj.up('form').down('#courseSubDepartment');
                    				if(!isNullOrEmpty(subDept)){
                    					subDept.clearValue();
                    				}
                    				var departmentId = record[0].get("id");
                    				if (departmentId > 0) {
                    					var store=subDept.getStore();
                    					store.getProxy().extraParams = {
                    						parentId : departmentId
                    					};
                    					store.load();
                    				}
                    			}
                    		},
                    		'createcourseform textfield#courseCode' : {
                    			blur : function(obj, record) {
                    				this.showHideAddMoreButton(obj,
                    						record);
                    				var form = this.getCreatecourseform().getForm();
                    				var courseCode = form.findField('courseCode').getValue();
                    				form.findField('courseCodeToBePrinted').setValue(courseCode);
                    			}
                    		},
                    		'createcourseform numberfield#courseOff_id' : {
                    			blur : this.MinMaxValidate
                    		},
                    		'createcourseform numberfield#courseMaxMarks_Id' : {
                    			blur : this.MinMaxValidate
                    		},
                    		'createcourseform button#uploadCourseItemId' : {
                    			click : function() {
                    				this
                    				.getDocumentController()
                    				.showDocumentFormWindow(
                    						'createcourseformItemId',
                    						'DOCUMENT');
                    			}
                    		},
                    		'basicdetailform button#uploadCourseItemId' : {
                    			click : function() {
                    				this
                    				.getDocumentController()
                    				.showDocumentFormWindow(
                    						'createcourseformItemId',
                    						'DOCUMENT');
                    			}
                    		},
                    		'basicdetailform' : {    
                    			afterrender : function() {
                    				var courseDocGrid = this.getCoursedocumentgrid();
                    				var store = courseDocGrid.getStore();
                    				store.on('load', function(){
                    					if (courseDocGrid.isHidden()
                    							&& store.data.items.length > 0) {
                    						courseDocGrid.setVisible(true);
                    					}
                    				});
                    			}},
                    		'createcourseform textfield[itemId=courseNameItemId]' : {
                    			blur : function() {
                    				var form = this.getCreatecourseform().getForm();
                    				var courseName = form.findField('courseName').getValue();
                    				form.findField('courseShortName').setValue(courseName);
                    				form.findField('nameToBePrinted').setValue(courseName);
                    			}
                    		},
                    		'createcourseform textfield[itemId=courseNameLanguageOneId]' : {
                    			blur : function() {
                    				//this.showHideAddMoreButton(obj,record);
                    				var form = this.getCreatecourseform().getForm();
                    				var courseNameLanguageOne = form.findField('courseNameLanguageOne').getValue();
                    				form.findField('courseShortNameLanguageOne').setValue(courseNameLanguageOne);
                    				form.findField('nameToBePrintedLanguageOne').setValue(courseNameLanguageOne);
                    			}
                    		},
                    		'createcourseform textfield[itemId=courseNameLanguageTwoId]' : {
                    			blur : function() {
                    				//this.showHideAddMoreButton(obj,record);
                    				var form = this.getCreatecourseform().getForm();
                    				var courseNameLanguageTwo = form.findField('courseNameLanguageTwo').getValue();
                    				form.findField('courseShortNameLanguageTwo').setValue(courseNameLanguageTwo);
                    				form.findField('nameToBePrintedLanguageTwo').setValue(courseNameLanguageTwo);
                    			}
                    		},
                    		'createcourseform textfield[itemId=courseNameLanguageThreeId]' : {
                    			blur : function() {
                    				//this.showHideAddMoreButton(obj,record);
                    				var form = this.getCreatecourseform().getForm();
                    				var courseNameLanguageThree = form.findField('courseNameLanguageThree').getValue();
                    				form.findField('courseShortNameLanguageThree').setValue(courseNameLanguageThree);
                    				form.findField('nameToBePrintedLanguageThree').setValue(courseNameLanguageThree);
                    			}
                    		},
                    		'createcourseform button[itemId=addDetailedBtn]' : {
                    			click : this.addMoreDetailedOfDepartment
                    		},
                    		'createcourseform button[itemId=addDetailedBtn1]' : {
                    			click : this.addMoreDetailedOfDepartment
                    		},
                    		'createcourseform button[itemId=addDetailedMSPBtn]' : {
                    			click : function() {
                    				this.addMoreDetailedOfModuleSubjectBasicDetail("Add");
                    			}
                    		},
                    		'createcourseform button[itemId=addDetailedMSPBtn1]' : {
                    			click : function() {
                    				this.addMoreDetailedOfModuleSubjectBasicDetail("Add");
                    			}
                    		},
                    		'createcourseform button[itemId=detailedDeleteButton1]':{
                				click : function(deleteButton) {
                   				 this.deleteMoreDetailedOfDepartment(deleteButton)
                   			 }
                			},
                			'createcourseform button[itemId=detailedDeleteMSPButton1]':{
                				click : function(deleteButton) {
                   				 this.deleteMoreDetailedOfModuleSubject(deleteButton)
                   			 }
                			},
                    		'documentformwindow[itemId=createcourseformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
                    			click : function() {
                    				var $this = this;
                    				var isTransient = true;
                    				var module = 'course';
                    				var entityId;
                    				var entityType = 'course';

                    				$this
                    				.getDocumentController()
                    				.saveDocumentForm(
                    						entityId,
                    						module,
                    						entityType,
                    						'DOCUMENT',
                    						function(success,
                    								response,
                    								isCallBackTransient) {
                    							var documentModel = new Academia.model.course.CourseDocument();
                    							documentModel
                    							.set(
                    									"documentName",
                    									response.name);
                    							documentModel
                    							.set(
                    									"path",
                    									response.path);
                    							documentModel
                    							.set(
                    									"type",
                    									response.type);
                    							documentModel
                    							.set(
                    									"documentName",
                    									response.name);
                    							documentModel
                    							.set(
                    									"createdBy",
                    									$this
                    									.getIdValueJson(
                    											response.createdBy.id,
                    											response.createdBy.value));
                    							var courseDocGrid = $this
                    							.getCoursedocumentgrid();
                    							var store = courseDocGrid
                    							.getStore();
                    							store
                    							.add(documentModel);
                    							if (courseDocGrid
                    									.isHidden()
                    									&& store.data.items.length > 0) {
                    								courseDocGrid
                    								.setVisible(true);
                    							}
                    							$this
                    							.getDocumentController()
                    							.closeDocumentFormWindow();
                    						}, isTransient);
                    			}
                    		},
                    		'documentformwindow[itemId=createcourseformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
                    			click : function() {
                    				this.getDocumentController()
                    				.closeDocumentFormWindow();
                    			}
                    		},
                    		'coursedocumentgrid button#btnDelete' : {
                    			click : function() {
                    				var $this = this;
                    				var grid = $this
                    				.getCoursedocumentgrid();
                    				if (grid.getSelectionModel()
                    						.getCount() > 0) {
                    					Ext.MessageBox
                    					.confirm(
                    							getCommonTranslation('COURSE'),
                    							getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                    							function(btn,
                    									text) {
                    								if (btn == 'yes') {
                    									var store = grid.getStore();
	                									var record = grid.getSelectionModel().getSelection()[0];
	                									var id = record.get("id");
                    									 if (!isNullOrEmpty(id)) {
                    										 Ext.Ajax
                         									.request({
                         										method : "DELETE",
                         										type : 'rest',
                         										url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL
                         										+ '?id='
                         										+ id,
                         										headers : {
                         											'Content-Type' : 'application/json'
                         										},
                         										success : function(
                         												form,
                         												action) {
                         											store.reload();
                         											showSuccessMessage(
                         													getCommonTranslation('COURSE'),
                         													getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                         										}
                         									});
                    									 }else{
                    										 if (record) {
 	               	                 							store.remove(record);
 	               	                 						showSuccessMessage(
 	               	                 							getCommonTranslation('COURSE'),
              													   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 	               	                 						}
                    									 }
                    									
                    								}
                    							});
                    				} else {
                    					showWarningMessage(
                    							getCommonTranslation('COURSE'),
                    							getCommonTranslation('PLEASE_SELECT_RECORD')); 
                    				}
                    			}
                    		},
                    		'coursedocumentgrid' : {
                    			cellclick : function(grid, td,
                    					cellIndex, record, tr,
                    					rowIndex, e, eOpts) {
                    				var $this = this;
                    				var documentGrid = $this
                    				.getCoursedocumentgrid();
                    				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    				if (columnName == "documentName") {
                    					if (e.target.tagName == 'A') {
                    						var documentId = record
                    						.get("documentId");
                    						if (!isNullOrEmpty(documentId)) {
                    							$this
                    							.getDocumentController()
                    							.downloadDocumentFile(
                    									documentId);
                    						}
                    					}
                    				}
                    			}
                    		},
                    		'createcourseform combo[itemId=courseMax_1]' : {
                    			select : function(obj, record) {
                    				var gradeType = record[0]
                    				.get('value');
                    				var store = this
                    				.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
                    				store.getProxy().extraParams = {
                    					gradeType : gradeType
                    				};
                    				store.load();
                    			}
                    		},
                    		'createcourseform combo[itemId=assignSectionTypeId]' : {
                    			change : function(obj, record) {
                    				var form = obj.up('form');
                    				var assignSectionType = record;
                    				if(assignSectionType == 'COURSE_SECTION'){
                    					form.down('#repeatablePeriods_Id').setDisabled(false);
                    					form.down('#repeatablePeriods_Id').show();
                    				}else{
                    					form.down('#repeatablePeriods_Id').setDisabled(true);
                    					form.down('#repeatablePeriods_Id').items.items[0].setValue(false);
                    					form.down('#repeatablePeriods_Id').items.items[1].setValue(true);
                    					form.down('#repeatablePeriods_Id').hide();
                    				}
                    			}
                    		},
                    		'createcourseform combo[itemId=departmentId]' : {
                    			select : function(obj, record) {
                    				var departmentId=record[0].get('id');
                    				var flag = true;
									var pnlMain = obj.up("#panelIdH");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=departmentName]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var subDept = obj.up('form').down('#subDepartmentId');
		                    				if(!isNullOrEmpty(subDept)){
		                    					subDept.clearValue();
		                    					subDept.setDisabled(false);
		                    					subDept.reset()
		                    				}
		                    				var departmentId = record[0].get("id");
		                    				if (departmentId > 0) {
		                    					var store=subDept.getStore();
		                    					store.getProxy().extraParams = {
		                    						parentId : departmentId
		                    					};
		                    					store.load();
		                    				}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											nextSiblingField.reset();
											nextSiblingField.setDisabled(true);
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
                    			}
                    		},
                    		'createcourseform combo[itemId=moduleSubjectId]' : {
                    			select : function(obj, record) {
                    				var departmentId=record[0].get('id');
                    				var flag = true;
									var pnlMain = obj.up("#panelMSP");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=moduleSubject]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var subDept = obj.up('form').down('#moduleSubjectsProportionId');
		                    				if(!isNullOrEmpty(subDept)){
		                    					subDept.setDisabled(false);
		                    					subDept.reset()
		                    				}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											nextSiblingField.reset();
											nextSiblingField.setDisabled(true);
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
                    			},
                    			change:function(obj,rec,value){
                    				if(isNullOrEmpty(rec)){
                    					var nextSiblingField = obj.nextSibling();
        								nextSiblingField.reset();
        								nextSiblingField.setDisabled(true);
                    				}
    							}
                    		}
                    	});
                    },
                    getDocumentController : function() {
                    	var this$ = this;
                    	return this$
                    	.getController('Academia.controller.document.DocumentController');
                    },
                    MinMaxValidate : function() {

                    	var $this = this;
                    	var form = $this.getCreatecourseform().getForm();

                    	var cutOffMarks = form.findField("courseCutOff")
                    	.getValue();
                    	var maxMarks = form.findField("courseMaxMark")
                    	.getValue();

                    	if (cutOffMarks != null && maxMarks != null) {
                    		if (cutOffMarks > maxMarks) {
                    			form.findField("courseMaxMark").setValue(null);
                    			form.findField("courseCutOff").setValue(null);
                    			showWarningMessage(getCommonTranslation('COURSE'),
                    					getCommonTranslation('COURSE_MAX_MIN_MSSG'));
                    		}
                    	}
                    },
	                                showHideAddMoreButton : function() {
	                                	var $this = this;
	                                	var form = $this.getCreatecourseform().getForm();
	                                	var courseId = form.findField("cId").getValue();

	                                	if (courseId > 0) {
	                                		Ext.ComponentQuery
	                                		.query('button#createform_addmorebuttonId')[0]
	                                		.hide();
	                                	}

	                                },
	                                createNewTab : function(model, record) {
	                                	var $this = this;
	                                	var contentpanel = this.getContentpanel();
	                                	var coursetabstructure = Ext
	                                	.widget('coursetabstructure');
	                                	var tabName = getCommonTranslation('COURSE_STRUCTURE');
	                                	openTab(contentpanel, tabName, coursetabstructure,
	                                			CONSTANTS.MENU_COLOR_THREE);

	                                	var tabStcrFrm = $this.getCoursetabstructure()
	                                	.getForm();
	                                	var courseForm = $this.getCreatecourseform().getForm();
	                                	var courseId = courseForm.findField("cId").getValue();
	                                	tabStcrFrm.findField("ids").setValue(courseId);

	                                	var form = this.getBasicdetailform();
	                                	var editUrl = SERVERURL.BASIC_COURSES_DETAILS;
	                                	Ext.Ajax
	                                	.request({
	                                		method : "GET",
	                                		type : 'rest',
	                                		url : editUrl,
	                                		params : {
	                                			id : courseId
	                                		},
	                                		success : function(f, action) {
	                                			var EId = Ext.JSON.decode(f.responseText);

	                                			var formModel = new Academia.model.course.CreateCourseModel(EId);
	                                			form.loadRecord(formModel);
	                                			tabStcrFrm.findField("sectionAtComponentLevelFlag").setValue(formModel.data.sectionAtComponentLevel);tabStcrFrm.findField("whetherCourseExempted").setValue(formModel.data.whetherCourseExemption);
	                                			if (formModel.data.courseMarksGrades == "M") {

	                                				Ext.ComponentQuery.query('combo#courseMarkGradeId')[0].setValue("MARK");
	                                				Ext.ComponentQuery.query('numberfield#courseCutOffId')[0].show();
	                                				Ext.ComponentQuery.query('numberfield#courseMax_Marks_Id')[0].show();

	                                				Ext.ComponentQuery.query('combo#courseMax_1')[0].hide();
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off')[0].hide();
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off_2')[0].hide();

	                                			} else if (formModel.data.courseMarksGrades == "G") {
	                                				Ext.ComponentQuery.query('numberfield#courseCutOffId')[0].hide();
	                                				Ext.ComponentQuery.query('numberfield#courseMax_Marks_Id')[0].hide();

	                                				Ext.ComponentQuery.query('combo#courseMax_1')[0].show();
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off')[0].show();
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off_2')[0].show();

	                                				Ext.ComponentQuery.query('combo#courseMarkGradeId')[0].setValue("GRADE");
	                                				Ext.ComponentQuery.query('combo#courseMax_1')[0].setValue(formModel.data.courseGradeType);
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off')[0].setValue(formModel.data.courseCutOff);
	                                				Ext.ComponentQuery.query('combo#coursePass_Cut_Off_2')[0].setValue(formModel.data.courseMaxMark);
	                                				
	                                			}
	                                			var fieldradio = Ext.ComponentQuery.query('fieldcontainer#repeatable_Period_Id')[0];
	                                			var whetherEvaluationExte = Ext.ComponentQuery.query('fieldcontainer#whetherEvaluationExternal_Id')[0];
	                                			var deficiencyStatusBasic = Ext.ComponentQuery.query('fieldcontainer#deficiencyStatusBasicDetail')[0];
	                                			var hasCourseComponentsBasic = Ext.ComponentQuery.query('fieldcontainer#hasCourseComponents_Id')[0];
	                                			var courseRankBasic = Ext.ComponentQuery.query('fieldcontainer#course_Rank_Id')[0];
	                                			 var assignSectionType = Ext.ComponentQuery.query('radiogroup#assign_Section_Id')[0];

	                                			if (formModel.data.hasCourseComponents == 1) {

	                                				hasCourseComponentsBasic.items.items[0].setValue(true);
	                                				hasCourseComponentsBasic.items.items[1].setValue(false);
	                                			} else if (formModel.data.hasCourseComponents == 0) {
	                                				var tabPanel = $this.getCoursetabstructure().items.items[3];
	                                				tabPanel.items.items[3].disabled = true;
	                                				hasCourseComponentsBasic.items.items[0].setValue(false);
	                                				hasCourseComponentsBasic.items.items[1].setValue(true);
	                                			}

	                                			if (formModel.data.courseRankConsidered == 'Y') {
	                                				
	                                				courseRankBasic.items.items[0].setValue(true);
	                                				courseRankBasic.items.items[1].setValue(false);
	                                			} else if (formModel.data.courseRankConsidered == 'N') {
	                                				courseRankBasic.items.items[0].setValue(false);
	                                				courseRankBasic.items.items[1].setValue(true);
	                                			}

	                                			if (formModel.data.whetherRepeatable) {

	                                				fieldradio.items.items[0].setValue(true);
	                                				fieldradio.items.items[1].setValue(false);
	                                			} else {
	                                				fieldradio.items.items[0].setValue(false);
	                                				fieldradio.items.items[1].setValue(true);
	                                			}
	                                			if (formModel.data.whetherEvaluationExternal) {

	                                				whetherEvaluationExte.items.items[0].setValue(true);
	                                				whetherEvaluationExte.items.items[1].setValue(false);
	                                			} else {
	                                				whetherEvaluationExte.items.items[0].setValue(false);
	                                				whetherEvaluationExte.items.items[1].setValue(true);
	                                			}
	                                			if (formModel.data.deficiencyStatus) {

	                                				deficiencyStatusBasic.items.items[0].setValue(true);
	                                				deficiencyStatusBasic.items.items[1].setValue(false);
	                                			} else {
	                                				deficiencyStatusBasic.items.items[0].setValue(false);
	                                				deficiencyStatusBasic.items.items[1].setValue(true);
	                                			}
	                                			
	                                			console.log('formModel',formModel);
	                                			console.log('formModel.data',formModel.data);
	                                			  if (formModel.data.assignSectionType=='ProgramBatchSection') {
	                                              	
	                                              	assignSectionType.items.items[0].setValue(true);
	                                              	assignSectionType.items.items[1].setValue(false);
	                                              } else {
	                                              	assignSectionType.items.items[0].setValue(false);
	                                              	assignSectionType.items.items[1].setValue(true);
	                                              }
	                                			  
	                                			var courseDepStore = $this
	                                			.getStore('course.CourseDepartmentStore');
	                                			var courseSubDepStore = $this
	                                			.getStore('course.CourseSubDepartmentStore');
	                                			var courseCooStore = $this
	                                			.getStore('course.CourseCoordinatorStore');
	                                			var courseStageStore = $this
	                                			.getStore('course.CourseStageStore');
	                                			/*var courseSubjectTypeStore = $this
	                                			.getStore('course.CourseSubjectTypeStore');*/
	                                			var dId;
	                                			if (formModel.data.department != null) {
	                                				dId = formModel.data.department.id;
	                                			}
	                                			courseDepStore
	                                			.load({
	                                				callback : function(record,
	                                						operation, success) {
	                                					if (success) {
	                                						form
	                                						.down(
	                                						'#courseDepartment')
	                                						.setValue(
	                                								dId);
	                                					}
	                                				}
	                                			});
	                                			courseSubDepStore
	                                			.load({
	                                				params : {
	                                					parentId : dId
	                                				},
	                                				callback : function(record,
	                                						operation, success) {
	                                					if (success) {
	                                						if (formModel.data.subDepartment != null) {
	                                							form
	                                							.down(
	                                							'#courseSubDepartment')
	                                							.setValue(
	                                									formModel.data.subDepartment.id);
	                                						}
	                                					}
	                                				}
	                                			});
	                                			courseCooStore
	                                			.load({
	                                				callback : function(record,
	                                						operation, success) {
	                                					if (success) {
	                                						if (formModel.data.user != null) {
	                                							form
	                                							.down(
	                                							'#courseCoordinatorId')
	                                							.setValue(
	                                									formModel.data.user.id);
	                                							form
	                                							.down(
	                                							'#courseCoordinatorCode')
	                                							.setValue(
	                                									formModel.data.user.code);
	                                						}
	                                					}
	                                				}
	                                			});
	                                			courseStageStore
	                                			.load({
	                                				callback : function(record,
	                                						operation, success) {
	                                					if (success) {
	                                						if (formModel.data.selectionStage != null) {
	                                							form
	                                							.down(
	                                							'#stage_Type_Id')
	                                							.setValue(
	                                									formModel.data.selectionStage);
	                                						}
	                                					}
	                                				}
	                                			});
	                                			/**
	                                			 * Load document grid on the bases of
	                                			 * course id
	                                			 */
	                                			var documentStore = $this
	                                			.getStore('course.CourseDocument');
	                                			documentStore.getProxy().extraParams = {
	                                				courseId : courseId
	                                			};
	                                			documentStore.load();
	                                		}
	                                	});

	                                },

	                                addCreateCourse : function() {
	                                	var $this = this;
	                                	var form = $this.getCreatecourseform().getForm();

	                                	var isMarkType = form.findField("courseMarkGrad").getValue();
	                                	var cutOffMarks = form.findField("courseCutOff").getValue();
	                                	var maxMarks = form.findField("courseMaxMark").getValue();

	                                	var isValidData = true;
	                                	if (isMarkType != null && isMarkType == "MARK") {
	                                		if (cutOffMarks > maxMarks || isNullOrEmpty(cutOffMarks) || isNullOrEmpty(maxMarks)) {
	                                			isValidData = false;
	                                		}
	                                	}
	                                	if(isValidData){
	                                		var value = form.getValues();
		                                	var cdPoint = value.courseDeficitsPoint;
		                                	if (!cdPoint) {
		                                		cdPoint = 0;
		                                	}
		                                	var ccPoint = value.courseCredits;
		                                	if (!ccPoint) {
		                                		ccPoint = 0;
		                                	}
		                                	var ectsCredits = value.ectsCredits;
		                                	if (!ectsCredits) {
		                                		ectsCredits = 0;
		                                	}
		                                	var courseCooId = form.findField('user').getValue();
		                                	var courseCooValue = form.findField('user').getRawValue();
		                                	
		                                	
		                                	var courseCategoryId = form.findField('courseCategory').getValue();
		                                	var courseCategoryValue = form.findField('courseCategory').getRawValue();
		                                	
		                                	var subjectTypeId = form.findField('subjectType').getValue();
		                                	var subjectTypeValue = form.findField('subjectType').getRawValue();
		                                	
		                                	var courseCombo = this.getIdNameJson(courseCooId,courseCooValue);
		                                	var courseCategoryCombo = this.getIdValueJson(courseCategoryId,courseCategoryValue);
		                                	
		                                	var subjectTypeCombo = this.getIdValueJson(subjectTypeId, subjectTypeValue);
		                                	
		                                	var calcuationRuleId = form.findField('CalculationRule').getValue();
		                                	var calcuationRuleValue = form.findField('CalculationRule').getRawValue();
		                                	
		                                	var CalculationRuleCombo = this.getIdValueJson(calcuationRuleId, calcuationRuleValue);
		                                	var createCourse = new Academia.model.course.CreateCourseModel();
		                                	
		                                	var courseNQFLevelId = form.findField('courseNQFLevel').getValue();
		                                	var courseNQFLevelValue = form.findField('courseNQFLevel').getRawValue();
		                                	
		                                	var  courseNQFLevelCombo = this.getIdValueJson(courseNQFLevelId, courseNQFLevelValue);

		                                	var courseCESMCodeId = form.findField('courseCESMCode').getValue();
		                                	var courseCESMCodeValue = form.findField('courseCESMCode').getRawValue();

                                            var metaCourseOne = form.findField('metaCourseOne').getValue();
                                            var metaCourseOneValue = form.findField('metaCourseOne').getRawValue();
      	                                    var metaCourseOneValueCombo=this.getIdValueJson(metaCourseOne,metaCourseOneValue);
      	  
                                            var metaCourseTwo = form.findField('metaCourseTwo').getValue();
        	                                var metaCourseTwoValue = form.findField('metaCourseTwo').getRawValue();
      	                                    var metaCourseTwoValueCombo=this.getIdValueJson(metaCourseTwo,metaCourseTwoValue);


                                            var metaCourseThree = form.findField('metaCourseThree').getValue();
        	                                var metaCourseThreeValue = form.findField('metaCourseThree').getRawValue();
      	                                    var metaCourseThreeValueCombo=this.getIdValueJson(metaCourseThree,metaCourseThreeValue);
		                                	
		                                	var courseCESMCodeCombo = this.getIdValueJson(courseCESMCodeId, courseCESMCodeValue);
		                                	createCourse.set("courseSequence", value.courseSequence);
		                                	createCourse.set("courseCode", value.courseCode);
		                                	createCourse.set("courseCodeToBePrinted", value.courseCodeToBePrinted);
		                                	createCourse.set("courseName", value.courseName);
		                                	createCourse.set("courseShortName",value.courseShortName);
		                                	createCourse.set("nameToBePrinted",value.nameToBePrinted);
		                                	createCourse.set("courseSyllabus", value.courseSyllabus);
		                                	createCourse.set("assignSectionType",value.assignSectionType=="PROGRAM_BATCH_SECTION"?"ProgramBatchSection":"CourseSection");
		                                	createCourse.set("hasCourseComponents",value.hasCourseComponents);
		                                	createCourse.set("courseNameLanguageOne",value.courseNameLanguageOne);
		                                	createCourse.set("courseShortNameLanguageOne",value.courseShortNameLanguageOne);
		                                	createCourse.set("courseNameLanguageTwo",value.courseNameLanguageTwo);
		                                	createCourse.set("courseShortNameLanguageTwo",value.courseShortNameLanguageTwo);
		                                	createCourse.set("courseNameLanguageThree",value.courseNameLanguageThree);
		                                	createCourse.set("courseShortNameLanguageThree",value.courseShortNameLanguageThree);
		                                	//createCourse.set("courseCESMCode",value.courseCESMCode);
		                                //	createCourse.set("courseNQFLevel",this.getIdValueJson(value.courseNQFLevel));
		                                	createCourse.set("courseCESMCode",courseCESMCodeCombo);
		                                	createCourse.set("weightGPA",value.weightGPA);
		                                //	createCourse.set("courseNQFLevel",value.courseNQFLevel);
		                                	createCourse.set("isLMSCourses",value.isLMSCourses);
		                                	createCourse.set("lMSCourseOfferYear",value.lMSCourseOfferYear);
		                                	createCourse.set("isPublishToLMS",isNullOrEmpty(value.isPublishToLMS)?false:true);
		                                	createCourse.set("nameToBePrintedLanguageOne",value.nameToBePrintedLanguageOne);
		                                	createCourse.set("nameToBePrintedLanguageTwo",value.nameToBePrintedLanguageTwo);
		                                	createCourse.set("nameToBePrintedLanguageThree",value.nameToBePrintedLanguageThree);
		                                	createCourse.set("calculationRule",calcuationRuleId);
		                                	createCourse.set("isFeeApplicable",value.isFeeApplicable);
		                                	createCourse.set("hybridModule",value.hybridModule);
		                                	createCourse.set("modulePrerequisite",value.modulePrerequisite);
		                                	createCourse.set("isPublishInCatalogue",value.isPublishInCatalogue);
		                                	createCourse.set("courseShortDescriptionInOtherLanguage",value.courseShortDescriptionInOtherLanguage);
		                                	createCourse.set("subjectAdditionalCode",value.subjectAdditionalCode);
		                                	createCourse.set("isModulePrerequisites",value.modulePrerequisitesRadio==0 ? false : true);
		                                	createCourse.set("moduleHEQSFLevel", value.moduleHEQSFLevel);
		                                	createCourse.set("eligibleTransferCredit", value.eligibleTransferCredit);
		                                	if (value.hasCourseComponents == 1) {
		                                		createCourse.set("sectionAtComponentLevel",
		                                				value.sectionAtComponentLevel);
		                                	} else {
		                                		createCourse.set("sectionAtComponentLevel", false);
		                                	}

		                                	
		                                	createCourse.set("whetherEvaluationExternal",
		                                			value.whetherEvaluationExternal);

		                                	createCourse.set("courseCredits", ccPoint);
		                                	createCourse.set("ectsCredits", ectsCredits);
		                                	
		                                	// createCourse.set("whetherFixed",value);
		                                	
		                                	
		                                	createCourse.set("courseShortDescription",
		                                			value.courseShortDescription);
		                                	createCourse.set("courseRankConsidered",
		                                			value.courseRankConsidered);
		                                	// createCourse.set("sectionType",value.);
		                                	createCourse.set("courseEntryCriteriaQuery",
		                                			"");
		                                	createCourse.set("courseExitCriteriaQuery","");
		                                	
		                                	if(value.assignSectionType == 'PROGRAM_BATCH_SECTION'){
		                                	createCourse.set("whetherRepeatable",false);
		                                	}else{
		                                		createCourse.set("whetherRepeatable",value.whetherRepeatable);
		                                	}
		                                	createCourse.set("includeinPromotion",
		                                			value.includeinPromotion);
		                                	
		                                	console.log('customData...',value.customData);
		                                createCourse.set("customData",value.customData);
		                                var departmentArray = [];
		                                var totalWeightage=0;
		                                var duplicateIdMap = new Ext.util.HashMap();
		                                var duplicateIdFlag=false;
		                                var courseDepartmentCombo=null;
		                               var courseSubDepartmentCombo=null
		                                if (!isNullOrEmpty($this.getCreatecourseform().down('#panelIdH').items.items)
	                                			&& $this.getCreatecourseform().down('#panelIdH').items.items.length > 1) {
		                                	courseDepartmentCombo = this.getIdValueJson(value.departmentName[0], value.departmentName[0]);
		                                	courseSubDepartmentCombo = this.getIdValueJson(value.subDepartmentName[0],value.subDepartmentName[0]);

		                                	for (var i = 0; i < $this.getCreatecourseform().down('#panelIdH').items.items.length; i++) {
		                                		var newData = {
	                                					"department" : $this.getIdValueJson(value.departmentName[i],value.departmentName[i]),
	                                					"subDepartment" :  $this.getIdValueJson(value.subDepartmentName[i],value.subDepartmentName[i]),
	                                					"weightage" : value.weightage[i]
	                                			};
		                                		if(duplicateIdMap.containsKey(value.departmentName[i])){
		                                			duplicateIdFlag=true;
		                                			break;
		                                		}
		                                		duplicateIdMap.add(value.departmentName[i], i);
		                                		totalWeightage=totalWeightage+parseInt(value.weightage[i]);
		                                		departmentArray.push(newData);
		                                		}
	                                		
		                                }else if(!isNullOrEmpty($this.getCreatecourseform().down('#panelIdH').items.items)
	                                			&& $this.getCreatecourseform().down('#panelIdH').items.items.length == 1){
		                                	courseDepartmentCombo = this.getIdValueJson(value.departmentName, value.departmentName);
		                                	courseSubDepartmentCombo = this.getIdValueJson(value.subDepartmentName,value.subDepartmentName);

		                                	var newData = {
	                            					"department" : $this.getIdValueJson(value.departmentName,value.departmentName),
	                            					"subDepartment" :  $this.getIdValueJson(value.subDepartmentName,value.subDepartmentName),
	                            					"weightage" : value.weightage
	                            			};
		                                	departmentArray.push(newData);
		                                	totalWeightage=totalWeightage+parseInt(value.weightage);
		                                }
		                               
		                               if(duplicateIdFlag){
		                                	showWarningMessage(getCommonTranslation('COURSE'),
	                    							getCommonTranslation('Duplicate department selected')); 
		                                	return false;
		                                }
		                                if(totalWeightage!=100){
		                                	showWarningMessage(getCommonTranslation('COURSE'),
	                    							getCommonTranslation('The sum of all the departments weights should be 100')); 
		                                	return false;
		                                }
		                               
		                               var moduleArray = [];
		                               var moduleString = null;
		                               var totalWeightageMSP=0;
		                                var duplicateIdMap = new Ext.util.HashMap();
		                                var duplicateIdFlagMSP=false;
		                                var moduleDepartmentCombo=null;
		                                var newData1 = null;
		                               if (!isNullOrEmpty($this.getCreatecourseform().down('#panelMSP').items.items)
	                                			&& $this.getCreatecourseform().down('#panelMSP').items.items.length > 1) {

		                                	for (var i = 0; i < $this.getCreatecourseform().down('#panelMSP').items.items.length; i++) {
		                                		if(!isNullOrEmpty(value.moduleSubject[i])){
		                                			var newData1 = {
		                                					"hesaSubjectId" : value.moduleSubject[i],
		                                					"weightage" : value.moduleSubjectsProportion[i]
		                                			};	
		                                		}
		                                		
		                                		if(duplicateIdMap.containsKey(value.moduleSubject[i])){
		                                			duplicateIdFlagMSP=true;
		                                			break;
		                                		}
		                                		duplicateIdMap.add(value.moduleSubject[i], i);
		                                		totalWeightageMSP=totalWeightageMSP+parseInt(value.moduleSubjectsProportion[i]);
		                                		moduleArray.push(newData1);
		                                		}
	                                		
		                                }else if(!isNullOrEmpty($this.getCreatecourseform().down('#panelMSP').items.items)
	                                			&& $this.getCreatecourseform().down('#panelMSP').items.items.length == 1){
		                                	if(!isNullOrEmpty(value.moduleSubject)){
		                                		var newData1 = {
		                            					"hesaSubjectId" : value.moduleSubject,
		                            					"weightage" : value.moduleSubjectsProportion
		                            			};	
		                                	}
		                                	
		                                	moduleArray.push(newData1);
		                                	totalWeightageMSP=totalWeightageMSP+parseInt(value.moduleSubjectsProportion);
		                                }
		                               
		                                if(duplicateIdFlagMSP){
		                                	showWarningMessage(getCommonTranslation('COURSE'),
	                    							getCommonTranslation('Duplicate Module Subject selected')); 
		                                	return false;
		                                }
		                                if(form.findField("moduleSubject").isHidden()==false && form.findField("moduleSubjectsProportion").isHidden()==false && form.findField("moduleSubjectsProportion").isDisabled()==false ){
		                                	if(totalWeightageMSP!=100){
			                                	showWarningMessage(getCommonTranslation('COURSE'),
		                    							getCommonTranslation('The sum of all the Module Subject weights should be 100')); 
			                                	return false;
			                                }
		                                }
		                                createCourse.set("courseDepartments", departmentArray);
		                                if(moduleArray[0] != null){
		                                	createCourse.set("subjectMapping", moduleArray);
		                                }else{
		                                	createCourse.set("subjectMapping", []);
		                                }
		                                
		                                var multipleLanguageArray = [];
		                                var multipleLanguage=form.findField("multipleLanguage").getValue();
		        		            	if(multipleLanguage !=undefined && multipleLanguage.length > 0 && multipleLanguage[0] != ""){
		        		            		for(var i in multipleLanguage){
		        		            			if(Ext.isObject(multipleLanguage[i])){
		        		            				var newMultipleData = {
		                                					"multiLanguage" : $this.getIdValueJson(multipleLanguage[i].get("id"),multipleLanguage[i].get("id")),
		                                			};
		        		            				multipleLanguageArray.push(newMultipleData);
		        		            			}
		        		            		}
		        		            	}
		                                
		                                createCourse.set("courseMultipleLanguages", multipleLanguageArray);
		                                
		                                	var docStore = $this.getStore('course.CourseDocument');
		                                	var docArray = [];
		                                	if (docStore.data.items != null
		                                			&& docStore.data.items.length > 0) {
		                                		Ext.each(docStore.data.items, function(val) {
		                                			var newData = {
		                                					"name" : val.data.documentName,
		                                					"path" : val.data.path,
		                                					"type" : val.data.type,
		                                					"createdBy" : $this.getIdValueJson(
		                                							val.data.createdBy.id,
		                                							val.data.createdBy.value)
		                                			};
		                                			docArray.push(newData);
		                                		});
		                                	}
		                                	createCourse.set("documents", docArray);

		                                	createCourse.set("user", courseCombo);
		                                	
		                                	createCourse.set("department", courseDepartmentCombo);
		                                	createCourse.set("subDepartment",
		                                			courseSubDepartmentCombo);
		                                	createCourse.set("subjectType",
		                                			subjectTypeCombo);
		                                	
		                                	createCourse.set("courseNQFLevel",
		                                			courseNQFLevelCombo);
		                                	createCourse.set("courseCategory",
		                                			courseCategoryCombo);
                                            createCourse.set("metaCourseOne",metaCourseOneValueCombo);
                                            createCourse.set("metaCourseTwo",metaCourseTwoValueCombo);
                                            createCourse.set("metaCourseThree",metaCourseThreeValueCombo);   
		                                	if (value.courseMarkGrad == 'MARK') {
		                                		createCourse.set("courseMarksGrades", 'M');
		                                		createCourse
		                                		.set("courseCutOff", value.courseCutOff);
		                                		createCourse.set("courseMaxMark",
		                                				value.courseMaxMark);
		                                	} else if (value.courseMarkGrad == 'GRADE') {
		                                		createCourse.set("courseMarksGrades", 'G');

		                                		createCourse.set("courseGradeType",
		                                				value.courseMaxMarkCombo);
		                                		createCourse.set("courseCutOff",
		                                				value.courseCutOffComboMin);
		                                		createCourse.set("courseMaxMark",
		                                				value.courseCutOffComboMax);
		                                	}
		                                	var alinfomodel = Academia.model.authentication.ALInfoModel;
		                                	var wheatherSchool = alinfomodel.get('wheatherSchool');
		                                	if(wheatherSchool){
		                                		createCourse.set("selectionStage", 'COURSE_EXECUTION');
		                                		createCourse.set("courseDeficits", 'F');
		                                		createCourse.set("whetherCourseExemption",0);
		                                		createCourse.set("whetherEvaluationExternal",true);
		                                	}else{
		                                		createCourse.set("selectionStage", value.selectionStage);
		                                		createCourse.set("courseDeficits", value.courseDeficits==getCommonTranslation('FIXED')?"F":"R");
		                                		createCourse.set("whetherCourseExemption",value.whetherCourseExemption);
		                                		createCourse.set("whetherEvaluationExternal",value.whetherEvaluationExternal);
		                                	}
		                                	createCourse.set("courseDeficitsPoint", cdPoint);
		                                	createCourse.set("deficiencyStatus",value.deficiencyStatus);
		                                	var formData = Ext.encode(createCourse.data);
		                                	var submitUrl = SERVERURL.COURSES_CREATE;
		                                	if(value.modulePrerequisite.length>5000){
		                                		showWarningMessage(getCommonTranslation('ALERT'), 
		                        						getProgramandcourseTranslation('MODULE_PREREQUISITE_LENGTH'));
		                                	
		                                	}else{
		                                		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 	                                	Ext.Ajax
		 	                                	.request({
		 	                                		type : 'rest',
		 	                                		url : submitUrl,
		 	                                		jsonData : formData,
		 	                                		scope : $this,
		 	                                		method : 'POST',
		 	                                		success : function(frm, action) {
		 	                                			Ext.getBody().unmask();
		 	                                			var courseForms=$this.getCreatecourseform();
		 	                                			var EId = Ext.JSON
		 	                                			.decode(frm.responseText);
		 	                                			showSuccessMessage(
		 	                                					getCommonTranslation('COURSE'),
		 	                                					getCommonTranslation('COURSE_CREATED_SUCCESS'));
		 	                                			//form.reset();
		 	                                			/*This Field Added For DFR on reset button*/
		 	                                			var resetButton=courseForms.down('#resetBtn');
		 	                                			resetButton.fireEvent('click', resetButton);
		 	                                			if(wheatherSchool){
		 	                                				var stage_Type=courseForms.down('#stage_Type');
		 	                                				stage_Type.allowBlank=true;
		 	                                			}
		 	                                			docStore.removeAll();
		 	                                			form.findField("cId").setValue(EId);
		 	                                			Ext.ComponentQuery
		 	                                			.query('button#createform_addmorebuttonId')[0]
		 	                                			.hide();
		 	                                			$this.getContentpanel().getActiveTab().close();
		 	                                		}
		 	                                	});
		                            	}
	                                	}

	                                },addCreateCourseformReset:function(){
	                                	var $this = this;
	                                	var form = $this.getCreatecourseform().getForm();
	                                	form.reset();
	                                	/*This Field Added For DFR On Reset Button*/
	                                	form.findField('deficiencyStatus').items.items[1].setValue(true);
	                                	form.findField('hasCourseComponents').items.items[1].setValue(true);
	                                	form.findField('selectionStage').setValue('COURSE_EXECUTION');
	                                	
	                                },
	                                getIdValueJson : function(id, value) {
	                                	if (id)
	                                		return {
	                                		id : id,
	                                		value : value
	                                	};
	                                },
	                                getIdNameJson : function(id, name) {
	                                	if (id)
	                                		return {
	                                		id : id,
	                                		nameToBePrinted : name
	                                	};
	                                },
	                                courseDeficiencyStatusChange : function(cb, nv, ov) {
                                		var scrollBody = this.getContentpanel().getActiveTab().body;
	                                	try{
		                                	var scrollPosition = scrollBody.getScroll();
		                                	var leftPosition = scrollPosition.left;
		                                	var topPosition = scrollPosition.top;
	                                	}
	                                	catch(e){
	                                		var leftPosition = 0;
		                                	var topPosition = 0;
	                                	}
	                                	
	                                	var courseDeficitsId = Ext.ComponentQuery.query('customcombobox#course_Deficits_Id')[0];
	                                	var courseDeficitsPointId = Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0];
	                                	courseDeficitsPointId.reset();
	                                	if (nv.deficiencyStatus) {
	                                		courseDeficitsId.setValue(getCommonTranslation('FIXED'));
	                                		courseDeficitsId.setVisible(true);
	                                		courseDeficitsPointId.setVisible(true);
	                                	} else if (!nv.deficiencyStatus) {
	                                		courseDeficitsId.setVisible(false);
	                                		courseDeficitsPointId.setVisible(false);
	                                	}
	                                	scrollBody.setScrollTop(topPosition);
	                                	setTimeout(function(){
		                                	scrollBody.setScrollTop(topPosition);
	                                	},10);
	                                },
	                                courseDeficitsChange : function(cb, nv, ov) {
	                                	Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].reset();
	                                	if (nv== getCommonTranslation('FIXED')) {
	                                		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
	                                	} else if (nv== getCommonTranslation('RULE_BASED')) {
	                                		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
	                                	};
	                                },
	                                hasCourseComponentsChange : function(cb, nv, ov) {
	                                	if (nv.hasCourseComponents == 1) {
	                                		Ext.ComponentQuery
	                                		.query('radiogroup#sectionAtComponentLevel_id')[0]
	                                		.show();
	                                	} else {
	                                		Ext.ComponentQuery
	                                		.query('radiogroup#sectionAtComponentLevel_id')[0]
	                                		.hide();
	                                	}
	                                },
	                                courseMarkGrade : function(o, r) {
	                                	var allowblankFalse = '<span class="required" style="color:red"> *</span>';
	                                	var createcourseform= this.getCreatecourseform();
	                                	if (r[0].data.id == 'MARK') {
	                                		createcourseform.down('#courseOff_id').show();
	                                		createcourseform.down('#courseMaxMarks_Id').show();
	                                		createcourseform.down('#courseOff_id').allowBlank=false;
	                                		createcourseform.down('#courseMaxMarks_Id').allowBlank=false;
	                                		
	                                		createcourseform.down('#courseOff_id').labelSeparator = '';
	                                		createcourseform.down('#courseOff_id').setFieldLabel(getCommonTranslation('COURSE_MINIMUM_PASSING_MARKS')+allowblankFalse);

	                                		createcourseform.down('#courseMaxMarks_Id').labelSeparator = '';
	                                		createcourseform.down('#courseMaxMarks_Id').setFieldLabel(getCommonTranslation('COURSE_MAXIMUM_PASSING_MARKS')+allowblankFalse);
	                                		
	                                		createcourseform.down('#courseOff_1').allowBlank=true;
	                                		createcourseform.down('#courseMax_1').allowBlank=true;
	                                		createcourseform.down('#courseOff_2').allowBlank=true;
	                                		
	                                		createcourseform.down('#courseOff_1').hide();
	                                		createcourseform.down('#courseMax_1').hide();
	                                		createcourseform.down('#courseOff_2').hide();
	                                	} else if (r[0].data.id == 'GRADE') {
	                                		createcourseform.down('#courseOff_id').allowBlank=true;
	                                		createcourseform.down('#courseMaxMarks_Id').allowBlank=true;
	                                		
	                                		createcourseform.down('#courseOff_id').hide();
	                                		createcourseform.down('#courseMaxMarks_Id').hide();
	                                		

	                                		createcourseform.down('#courseOff_1').show();
	                                		createcourseform.down('#courseMax_1').show();
	                                		createcourseform.down('#courseOff_2').show();
	                                		createcourseform.down('#courseOff_1').allowBlank=false;
	                                		createcourseform.down('#courseMax_1').allowBlank=false;
	                                		createcourseform.down('#courseOff_2').allowBlank=false;
	                                		
	                                		createcourseform.down('#courseOff_1').labelSeparator = '';
	                                		createcourseform.down('#courseOff_1').setFieldLabel(getCommonTranslation('COURSE_MINIMUM_PASSING_GRADE')+allowblankFalse);
	                                		
	                                		createcourseform.down('#courseMax_1').labelSeparator = '';
	                                		createcourseform.down('#courseMax_1').setFieldLabel(getCommonTranslation('COURSE_GRADES')+allowblankFalse);
	                                		
	                                		createcourseform.down('#courseOff_2').labelSeparator = '';
	                                		createcourseform.down('#courseOff_2').setFieldLabel(getCommonTranslation('COURSE_MAXIMUM_PASSING_GRADE')+allowblankFalse);
	                                		
	                                		
	                                	}
	                                },
	                                stageTypeChange : function(o, r) {
	                                	if (r== getProgramandcourseTranslation('SELECTION')) {
	                                		Ext.ComponentQuery.query('radiogroup#repeatablePeriods_Id')[0].hide();
	                                		Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].hide();
	                                		Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].hide();
	                                		Ext.ComponentQuery.query('customcombobox#course_Deficits_Id')[0].hide();
	                                		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
	                                		Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].hide();
	                                		Ext.ComponentQuery.query('customcombobox#assignSectionTypeId')[0].hide();
	                                	} else if (r == getProgramandcourseTranslation('COURSE_EXECUTION')) {
	                                		Ext.ComponentQuery.query('radiogroup#repeatablePeriods_Id')[0].show();
	                                		Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].show();
	                                		Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].show();
	                                		Ext.ComponentQuery.query('customcombobox#course_Deficits_Id')[0].show();
	                                		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
	                                		Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].show();
	                                		Ext.ComponentQuery.query('customcombobox#assignSectionTypeId')[0].show();
	                                	}
	                                },
	                                addMoreDetailedOfDepartment:function(){
	                        			var $this = this;
	                        			var createcourseform=$this.getCreatecourseform();
	                        			var panelContiner = createcourseform.down('#panelIdH');
	                        			var indx;
	                        			if(panelContiner.items.items.length<=3){
	                        				var panelItem = new Array();
	                        				indx = panelContiner.items.items.length;
	                        				panelItem.push({

	                        					xtype : 'fieldcontainer',
	                        					layout : 'hbox',
	                        					width: '100%',
	                        					scope: $this,
	                        					defaults : {
	                        						labelAlign : 'top',
	                        						width:'256'
	                        					},
	                        					layout : {
	                        						type : 'hbox'
	                        					},
	                        					margin: '10 0 0 0',
	                        					padding: '0 0 0 0',
	                        					items:[{
	                        						xtype: 'customcombobox',
	                        						width: 256,
	                        						name: 'departmentName',
	                        						store: Ext.create('Academia.store.course.CourseDepartmentStore'),
	                        						valueField: 'id',
	                        						displayField: 'value',
	                        						allowBlank: false,
	                        						typeAhead: false,
	                        						queryParam:'qry',
	                        	        			minChars:3,
	                        	        			rowIndx:indx,
	                        	                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                        	                    forceSelection:true,
	                        	                    listConfig: {
	                        	        				  listeners: {
	                        	        						beforeshow: function(picker) {
	                        	        							picker.minWidth = picker.up('combobox').getSize().width;
	                        	        						}
	                        	        					},
	                        	        	                loadingText: getCommonTranslation('SEARCHING'),
	                        	        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                        	        	                getInnerTpl: function() {
	                        	        	                    return '<div class="search-item">' +
	                        	        	                        '{value}' +
	                        	        	                    '</div>';
	                        	        	                }
	                        	        	            },
	                        						listeners:{
	                        							select:function(obj,rec,value){
	                        								var departmentId=rec[0].get('id');
	                        								var flag = true;
	                        								var pnlMain = obj.up("#panelIdH");
	                        								var rowIndx = obj.rowIndx;
	                        								if(!isNullOrEmpty(pnlMain)){
	                        									pnlMain.items.each(function(item, index, items) {
	                        										var deptNameVal = item.down("[name=departmentName]").getValue();
	                        										if(departmentId == deptNameVal && rowIndx != index){
	                        											flag = false;
	                        											return false;
	                        										}
	                        									});

	                        									if(flag){
	                        										var nextSiblingField = obj.nextSibling();
	                        										nextSiblingField.setDisabled(false);
	                        										nextSiblingField.reset();
	                        										if (departmentId > 0) {
	                        											var store=nextSiblingField.getStore();
	                        											store.getProxy().extraParams = {
	                        												parentId : departmentId
	                        											};
	                        											store.load();
	                        										}
	                        									}
	                        									else{
	                        										obj.reset();
	                        										var nextSiblingField = obj.nextSibling();
	                        										nextSiblingField.reset();
	                        										nextSiblingField.setDisabled(true);
	                        										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
	                        										return false;
	                        									}
	                        								}
	                        							},
	                        							change:function(obj,rec,value){
	                        								var nextSiblingField = obj.nextSibling();
	                        								nextSiblingField.reset();
	                        								nextSiblingField.setDisabled(true);

	                        							}
	                        						}
	                        					},
	                        					{
	                        						xtype: 'customcombobox',
	                        						name: 'subDepartmentName',
	                        						disabled: true,
	                        						editable: false,
	                        						queryMode: 'local',
	                        						valueField: 'id',
	                        						displayField: 'value',
	                        						width: 256,
	                        						listeners: {
	                        							render: function(combo) {
	                        								var store = Ext
	                        								.create('Academia.store.course.CourseSubDepartmentStore');
	                        								combo.bindStore(store);
	                        							}
	                        						}
	                        					},
	                        					{    
	                        						xtype: 'numberfield',
	                        						name: 'weightage',
	                        						minValue : 1,
	                        						maxValue:100,
	                        	    				maxLength: 3,
	                        	    				width: 256,
	                        	    				allowBlank:false,
	                        	    				allowExponential:false,
	                        	    				keyNavEnabled: false,
	                        	    				mouseWheelEnabled: false,
	                        					},
	                        					{
	                        						xtype: 'button',
	                        						glyph: ICONGLYPH.DELETEGLYPH,
	                        						itemId: 'detailedDeleteButton1',
	                        						width: 'auto',
	                        						cls: 'CustomBodyBtnReject',
	                        						tooltip: getCommonTranslation('DELETETOOLTIP'),
	                        						listeners:{
	                        							click:function(obj){
	                        								var container = obj.up('fieldcontainer');
	                        								//panelContiner.remove(container);
	                        								//$this.getCreatecourseform().getForm().isValid();
	                        								//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
	                        							}
	                        						},
	                        						style:{
	                        	    					marginLeft:'10px'
	                        	    				}
	                        					},
	                        					{
	                        						xtype: 'button',
	                        						itemId: 'addDetailedBtn1',
	                        						width: 'auto',
	                        						cls: 'CustomBodyBtnSettings',
	                        						width: 'auto',
	                        						text: getCommonTranslation('ADDBUTTONTEXT'),
	                        						tooltip: getCommonTranslation('ADD'),
	                        						
	                        					}]

	                        				});
	                        				panelContiner.add(panelItem);
	                        				this.departmentHideShowDetails(panelContiner);
	                        				panelContiner.doLayout();
	                        			}
	                        			if(createcourseform.isValid()){
                                            createcourseform.down('#createdetail_FormSubmitButtonId').setDisabled(false);
                                        }
                                        else{
                                            createcourseform.down('#createdetail_FormSubmitButtonId').setDisabled(true);
                                        }
	                        			
	                        		},
	                        		departmentHideShowDetails: function(detailedPanel) {
	                                	 var this$ = this;
	                                	 var form = this.getCreatecourseform();
	                                	 var cnt = detailedPanel.items.length;
	                                	 detailedPanel.items.each(function(item, index, items) {
	                                		 var addButton = item.getComponent(item.items.length - 1);
	                                		 if (index == (items - 1)) {
	                                			 if (addButton != null) {
	                                				 addButton.show();
	                                				 if(cnt == 4){
	                                					 addButton.hide();
	                                				 }
	                                			 }
	                                		 } else {
	                                			 if (addButton != null) {
	                                				 addButton.hide();
	                                			 }
	                                		 }
	                                	 });
	                                 },
	                                 deleteMoreDetailedOfDepartment: function(deleteButton) {
	                                	 var this$ = this;
	                                	 var form=this$.getCreatecourseform();
	                                	 var departmentPanel = form.down('#panelIdH');
	                                	 var container = deleteButton.up('fieldcontainer');

	                                	 if (container != null && departmentPanel != null) {
	                                		 if (departmentPanel.items.length > 1) {
	                                			 departmentPanel.remove(container);
	                                			 this$.departmentHideShowDetails(departmentPanel);
	                                		 }
	                                	 }
	                                	 
	                                	 if(form.isValid()){
                                             form.down('#createdetail_FormSubmitButtonId').setDisabled(false);
                                         }
                                         else{
                                             form.down('#createdetail_FormSubmitButtonId').setDisabled(true);
                                         }
	                                	 //departmentPanel.doLayout();
	                                 },
	                                 moduleHideShowDetailsOfBasic: function(detailedPanel) {
	                                	 var this$ = this;
	                                	 var form = this.getCreatecourseform();
	                                	 var cnt = detailedPanel.items.length;
	                                	 detailedPanel.items.each(function(item, index, items) {
	                                		 var addButton = item.getComponent(item.items.length - 1);
	                                		 if (index == (items - 1)) {
	                                			 if (addButton != null) {
	                                				 addButton.show();
	                                				 if(cnt == 4){
	                                					 addButton.hide();
	                                				 }
	                                			 }
	                                		 } else {
	                                			 if (addButton != null) {
	                                				 addButton.hide();
	                                			 }
	                                		 }
	                                	 });
	                                 },
	                                 deleteMoreDetailedOfModuleSubject: function(deleteButton) {
	                                	 var this$ = this;
	                                	 var form=this$.getCreatecourseform();
	                                	 var departmentPanel = form.down('#panelMSP');
	                                	 var container = deleteButton.up('fieldcontainer');

	                                	 if (container != null && departmentPanel != null) {
	                                		 if (departmentPanel.items.length > 1) {
	                                			 departmentPanel.remove(container);
	                                			 this$.moduleHideShowDetailsOfBasic(departmentPanel);
	                                		 }
	                                	 }
	                                	 
	                                	 if(form.isValid()){
                                             form.down('#createdetail_FormSubmitButtonId').setDisabled(false);
                                         }
                                         else{
                                             form.down('#createdetail_FormSubmitButtonId').setDisabled(true);
                                         }
	                                	 //departmentPanel.doLayout();
	                                 },
	                              	addMoreDetailedOfModuleSubjectBasicDetail:function(isEdit,record, isView){
	                            		var $this = this;
	                            		var createcourseform=$this.getCreatecourseform();
	                            		if(isEdit == "Add"){
	                            			var panelContiner = createcourseform.down('#panelMSP');
	                            			var indx;
	                            			if(panelContiner.items.items.length<=3){
	                            				var panelItem = new Array();
	                            				indx = panelContiner.items.items.length;
	                            				panelItem.push({

	                            					xtype : 'fieldcontainer',
	                            					layout : 'hbox',
	                            					width: '100%',
	                            					scope: $this,
	                            					defaults : {
	                            						labelAlign : 'top',
	                            						width:'256'
	                            					},
	                            					layout : {
	                            						type : 'hbox'
	                            					},
	                            					margin: '10 0 0 0',
	                            					padding: '0 0 0 0',
	                            					items:[{
	                            						xtype: 'customcombobox',
	                            						width: 256,
	                            						name: 'moduleSubject',
	                            						store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
	                            						valueField: 'id',
	                            						displayField: 'value',
	                            						allowBlank: false,
	                            						typeAhead: false,
	                            						queryParam:'qry',
	                            	        			minChars:3,
	                            	        			rowIndx:indx,
	                            	                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                            	                    forceSelection:true,
	                            	                    listConfig: {
	                            	        				  listeners: {
	                            	        						beforeshow: function(picker) {
	                            	        							picker.minWidth = picker.up('combobox').getSize().width;
	                            	        						}
	                            	        					},
	                            	        	                loadingText: getCommonTranslation('SEARCHING'),
	                            	        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                            	        	                getInnerTpl: function() {
	                            	        	                    return '<div class="search-item">' +
	                            	        	                        '{value}' +
	                            	        	                    '</div>';
	                            	        	                }
	                            	        	            },
	                            						listeners:{
	                            							select:function(obj,rec,value){
	                            								

	                            								var moduleId=rec[0].get('id');
	                            								var flag = true;
	                            								var pnlMain = obj.up("#panelMSP");
	                            								var rowIndx = obj.rowIndx;
	                            								if(!isNullOrEmpty(pnlMain)){
	                            									pnlMain.items.each(function(item, index, items) {
	                            										var deptNameVal = item.down("[name=moduleSubject]").getValue();
	                            										if(moduleId == deptNameVal && rowIndx != index){
	                            											flag = false;
	                            											return false;
	                            										}
	                            									});

	                            									if(flag){
	                            										var nextSiblingField = obj.nextSibling();
	                            										nextSiblingField.setDisabled(false);
	                            										nextSiblingField.reset();
	                            									}
	                            									else{
	                            										obj.reset();
	                            										var nextSiblingField = obj.nextSibling();
	                            										nextSiblingField.reset();
	                            										nextSiblingField.setDisabled(true);
	                            										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
	                            										return false;
	                            									}
	                            								}
	                            								
	                            							},
	                            							change:function(obj,rec,value){
	                            								var nextSiblingField = obj.nextSibling();
	                            								nextSiblingField.reset();
	                            								nextSiblingField.setDisabled(true);

	                            							}
	                            						}
	                            					},{    
	                            						xtype: 'numberfield',
	                            						name: 'moduleSubjectsProportion',
	                            						minValue : 1,
	                            						maxValue:100,
	                            	    				maxLength: 3,
	                            	    				width: 256,
	                            	    				allowBlank:false,
	                            	    				disabled:true,
	                            	    				allowExponential:false,
	                            	    				keyNavEnabled: false,
	                            	    				mouseWheelEnabled: false,
	                            					},{
	                            	    				xtype: 'hidden',
	                            	    				name: 'courseModuleId',
	                            					},
	                            					{
	                            						xtype: 'button',
	                            						glyph: ICONGLYPH.DELETEGLYPH,
	                            						itemId: 'detailedDeleteMSPButton1',
	                            						width: 'auto',
	                            						cls: 'CustomBodyBtnReject',
	                            						tooltip: getCommonTranslation('DELETETOOLTIP'),
	                            						style:{
	                            							marginTop:'8px',
	                            							marginLeft:'10px'
	                            						},
	                            						listeners:{
	                            							click:function(obj){
	                            								var container = obj.up('fieldcontainer');
	                            								//panelContiner.remove(container);
	                            								//$this.getCreatecourseform().getForm().isValid();
	                            								//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
	                            							}
	                            						}
	                            					},
	                            					{
	                            						xtype: 'button',
	                            						itemId: 'addDetailedMSPBtn1',
	                            						width: 'auto',
	                            						cls: 'CustomBodyBtnSettings',
	                            						width: 'auto',
	                            						text: getCommonTranslation('ADDBUTTONTEXT'),
	                            						tooltip: getCommonTranslation('ADD'),
	                            						style:{
	                            							marginTop:'8px'
	                            						}
	                            					}]

	                            				});
	                            				panelContiner.add(panelItem);
	                            				this.moduleHideShowDetailsOfBasic(panelContiner);
	                            				panelContiner.doLayout();
	                            			}
	                            		}else{
	                            			var panelContiner = createcourseform.down('#panelMSP');
	                            			panelContiner.removeAll();
	                            			var indx = 0;
	                            			if(record.length>0){
	                            				record.forEach(function(obj){
	                            					var panelItem = new Array();
	                            					var departmentId = obj.department.id;
	                            					var moduleSubjectsProportion = obj.moduleSubjectsProportion;
	                            					if(panelContiner.items.length == 0){
	                            						panelItem.push({
	                            							xtype : 'fieldcontainer',
	                            							layout : 'hbox',
	                            							width: '100%',
	                            							scope: $this,
	                            							defaults : {
	                            								labelAlign : 'top',
	                            								width:'256'
	                            							},
	                            							layout : {
	                            								type : 'hbox'
	                            							},
	                            							margin: '10 0 0 0',
	                            							padding: '0 0 0 0',
	                            							items:[{
	                            								xtype: 'customcombobox',
	                            								width: 256,
	                            								name: 'moduleSubject',
	                            								fieldLabel: getCommonTranslation('MODULE_SUBJECTS'),
	                            								store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
	                            								valueField: 'id',
	                            								displayField: 'value',
	                            								allowBlank: false,
	                            								typeAhead: false,
	                            								queryParam:'qry',
	                            								minChars:3,
	                            								rowIndx:indx,
	                            								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                            								forceSelection:true,
	                            								listConfig: {
	                            									listeners: {
	                            										beforeshow: function(picker) {
	                            											picker.minWidth = picker.up('combobox').getSize().width;
	                            										}
	                            									},
	                            									loadingText: getCommonTranslation('SEARCHING'),
	                            									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                            									getInnerTpl: function() {
	                            										return '<div class="search-item">' +
	                            										'{value}' +
	                            										'</div>';
	                            									}
	                            								},
	                            								listeners:{
	                            									render: function(combo){
	                            										var cDepartmentStore= combo.getStore();
	                            										cDepartmentStore.getProxy().extraParams = {
	                            											limit:-1
	                            										};
	                            										cDepartmentStore.load({
	                            											callback:function(record, operation, success){
	                            												combo.setValue(departmentId);
	                            												if(isView){
	                            													combo.setReadOnly(true);
	                            												}
	                            											}
	                            										});
	                            									},
	                            									select:function(obj,rec,value){
	                            										var departmentId=rec[0].get('id');
	                            										var flag = true;
	                            										var pnlMain = obj.up("#panelMSP");
	                            										var rowIndx = obj.rowIndx;
	                            										if(!isNullOrEmpty(pnlMain)){
	                            											pnlMain.items.each(function(item, index, items) {
	                            												var deptNameVal = item.down("[name=moduleSubject]").getValue();
	                            												if(departmentId == deptNameVal && rowIndx != index){
	                            													flag = false;
	                            						        					return false;
	                            												}
	                            											});
	                            											
	                            											if(flag){
	                            												var nextSiblingField = obj.nextSibling();
	                            												nextSiblingField.setDisabled(false);
	                            												nextSiblingField.reset();
	                            											}
	                            											else{
	                            												obj.reset();
	                            												var nextSiblingField = obj.nextSibling();
	                            												nextSiblingField.reset();
	                            												nextSiblingField.setDisabled(true);
	                            												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
	                            												return false;
	                            											}
	                            										}
	                            									},
	                            								}
	                            							},{    
	                            								xtype: 'numberfield',
	                            								name: 'moduleSubjectsProportion',
	                            								minValue : 1,
	                            								maxValue:100,
	                            								fieldLabel: getCommonTranslation('MODULE_SUBJECTS_PROPORTION'),
	                            								maxLength: 3,
	                            								width: 256,
	                            								allowBlank:false,
	                            								disabled:true,
	                            								allowExponential:false,
	                            								keyNavEnabled: false,
	                            								mouseWheelEnabled: false,
	                            								value:weightage,
	                            								readOnly:(isView ? true : false)
	                            							},{
	                            								xtype: 'hidden',
	                            								name: 'courseDepartmentId',
	                            							},
	                            							{
	                            								xtype: 'button',
	                            								itemId: 'addDetailedMSPBtn',
	                            								width: 'auto',
	                            								cls: 'CustomBodyBtnSettings',
	                            								disabled:(isView ? true : false),
	                            								text: getCommonTranslation('ADDBUTTONTEXT'),
	                            								tooltip: getCommonTranslation('ADD'),
	                            								style:{
	                            									marginTop:'30px'
	                            								}
	                            							}]

	                            						});
	                            					}else{
	                            						panelItem.push({
	                            							xtype : 'fieldcontainer',
	                            							layout : 'hbox',
	                            							width: '100%',
	                            							scope: $this,
	                            							defaults : {
	                            								labelAlign : 'top',
	                            								width:'256'
	                            							},
	                            							layout : {
	                            								type : 'hbox'
	                            							},
	                            							margin: '10 0 0 0',
	                            							padding: '0 0 0 0',
	                            							items:[{
	                            								xtype: 'customcombobox',
	                            								width: 256,
	                            								name: 'moduleSubject',
	                            								store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
	                            								valueField: 'id',
	                            								displayField: 'value',
	                            								allowBlank: false,
	                            								typeAhead: false,
	                            								queryParam:'qry',
	                            								minChars:3,
	                            								rowIndx:indx,
	                            								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                            								forceSelection:true,
	                            								listConfig: {
	                            									listeners: {
	                            										beforeshow: function(picker) {
	                            											picker.minWidth = picker.up('combobox').getSize().width;
	                            										}
	                            									},
	                            									loadingText: getCommonTranslation('SEARCHING'),
	                            									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                            									getInnerTpl: function() {
	                            										return '<div class="search-item">' +
	                            										'{value}' +
	                            										'</div>';
	                            									}
	                            								},
	                            								listeners:{
	                            									render: function(combo){
	                            										var cDepartmentStore= combo.getStore();
	                            										cDepartmentStore.getProxy().extraParams = {
	                            											limit:-1
	                            										};
	                            										cDepartmentStore.load({
	                            											callback:function(record, operation, success){
	                            												combo.setValue(departmentId);
	                            												if(isView){
	                            													combo.setReadOnly(true);
	                            												}
	                            											}
	                            										});
	                            									},
	                            									select:function(obj,rec,value){
	                            										var departmentId=rec[0].get('id');
	                            										var flag = true;
	                            										var pnlMain = obj.up("#panelMSP");
	                            										var rowIndx = obj.rowIndx;
	                            										if(!isNullOrEmpty(pnlMain)){
	                            											pnlMain.items.each(function(item, index, items) {
	                            												var deptNameVal = item.down("[name=moduleSubject]").getValue();
	                            												if(departmentId == deptNameVal && rowIndx != index){
	                            													flag = false;
	                            						        					return false;
	                            												}
	                            											});
	                            											
	                            											if(flag){
	                            												var nextSiblingField = obj.nextSibling();
	                            												nextSiblingField.setDisabled(false);
	                            												nextSiblingField.reset();
	                            											}
	                            											else{
	                            												obj.reset();
	                            												var nextSiblingField = obj.nextSibling();
	                            												nextSiblingField.reset();
	                            												nextSiblingField.setDisabled(true);
	                            												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
	                            												return false;
	                            											}
	                            										}
	                            									},
	                            								}
	                            							},
	                            							{    
	                            								xtype: 'numberfield',
	                            								name: 'moduleSubjectsProportion',
	                            								minValue : 1,
	                            								maxValue:100,
	                            								maxLength: 3,
	                            								width: 256,
	                            								allowBlank:false,
	                            								allowExponential:false,
	                            								disabled:true,
	                            								keyNavEnabled: false,
	                            								mouseWheelEnabled: false,
	                            								value:weightage,
	                            								readOnly:(isView ? true : false)
	                            							},{
	                            								xtype: 'hidden',
	                            								name: 'courseDepartmentId',
	                            							},
	                            							{
	                            								xtype: 'button',
	                            								glyph: ICONGLYPH.DELETEGLYPH,
	                            								itemId: 'detailedDeleteMSPButton1',
	                            								width: 'auto',
	                            								cls: 'CustomBodyBtnReject',
	                            								tooltip: getCommonTranslation('DELETETOOLTIP'),
	                            								disabled:(isView ? true : false),
	                            								style:{
	                            									marginTop:'8px',
	                            									marginLeft:'10px'
	                            								},
	                            								listeners:{
	                            									click:function(obj){
	                            										var container = obj.up('fieldcontainer');
	                            									}
	                            								}
	                            							},
	                            							{
	                            								xtype: 'button',
	                            								itemId: 'addDetailedMSPBtn1',
	                            								width: 'auto',
	                            								cls: 'CustomBodyBtnSettings',
	                            								width: 'auto',
	                            								disabled:(isView ? true : false),
	                            								text: getCommonTranslation('ADDBUTTONTEXT'),
	                            								tooltip: getCommonTranslation('ADD'),
	                            								style:{
	                            									marginTop:'8px'
	                            								}
	                            							}]

	                            						});
	                            					}

	                            					panelContiner.add(panelItem);
	                            					$this.moduleHideShowDetailsOfBasic(panelContiner);
	                            					indx = indx + 1; 
	                            					panelContiner.doLayout();
	                            				});
	                            			}
	                            		}
	                            		
	                            	},
});
