/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.homework.HomeworkAssignmentController', {
	extend: 'Academia.controller.base.BaseController',
	//extend: 'Ext.app.Controller',
	models : ['common.IdValueCodeDataModel','genericmodels.dropdowns.EnumCombo','coursetransaction.homework.assignmentdetails.AssignmentIndividualGrid',
	          'coursetransaction.homework.assignmentdetails.AssignmentDetails','coursetransaction.homework.assignmentdetails.AssignmentIndividualGrid',
	          'coursetransaction.homework.assignmentdetails.AssignmentGroupNameModel'
	          ],
    
	stores : [
	          'coursetransaction.homework.assignmentdetails.AssignmentIndividualBlank','coursetransaction.homework.assignmentdetails.AssignmentGroupBlank',
	          'coursetransaction.homework.assignmentdetails.AssignmentIndividualGrid',
	          'coursetransaction.homework.assignmentdetails.TopicsAvailability',
	          'coursetransaction.homework.assignmentdetails.Distribution',
	          'coursetransaction.homework.assignmentdetails.CourseVariant','coursetransaction.homework.assignmentdetails.Faculty',
	          'examinationcenters.manageEvaluation.EvaluationPlanNo','examinationcenters.manageEvaluation.DetailSequence',
	          
	          'common.ProgramByAcademyLocationStore','servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
	          'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
	          'coursetransaction.coursereading.CourseByPeriod','course.coursetopic.CourseComponentStore',
	          
	          'coursetransaction.sectionmanagement.CoruseVariantSectionStore','coursetransaction.homework.HW_AssignmentTypeDropDown',
	          'coursetransaction.homework.AssignmentNameDropDown','attendance.SectionByCourseNComponent',
	          
	          'coursetransaction.homework.HW_StudentNameDropDown',
	          'coursetransaction.coursereading.TopicType','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
	          'coursetransaction.coursereading.CourseByPeriod','coursetransaction.homework.assignmentdetails.CourseVariantByFacultyId',
	          'coursetransaction.homework.assignmentdetails.AssignmentIndividualStore',
	          'attendance.AssignedCoursesFacultyStore','course.CourseBasicDetailsStore','course.coursevariants.CourseVariantStore',
	          'common.CurrentBatchStore','coursetransaction.homework.submissiondetails.StudentHomeworkAssignmentDocument','servicerequest.programcoursesectiontransfer.FromPrograms',
	          'enquiry.AcademicBatchStore','coursetransaction.homework.assignmentdetails.hwStudentDetailsStore',
	          'coursetransaction.homework.assignmentdetails.AssignmentGroupNameStore',
	          'coursetransaction.homework.assignmentdetails.AssignmentDetailGridStore','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId',
	          'setup.templatemapping.TemplateNameForFoils'],
    
    views : [
             'Academia.view.coursetransaction.homework.HomeworkStructure','coursetransaction.homework.assignmentDetails.AssignmentDetails',
             'coursetransaction.homework.assignmentDetails.AssignDetailsGroupGrid','coursetransaction.homework.assignmentDetails.AssignDetailsIndividualGrid',
             'coursetransaction.homework.assignmentDetails.IdividualAssignmentGrid','coursetransaction.homework.assignmentDetails.UploadFile',
             'coursetransaction.homework.assignmentDetails.GroupsAssignmentGrid','coursetransaction.homework.assignmentDetails.AssignDetailsAllGrid',
             'coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
             'coursetransaction.homework.evaluationdetails.EvaluationDetailsGrid',
             'coursetransaction.homework.HomeworkAssignmentSearch',
             'coursetransaction.homework.HomeworkAdvListing','coursetransaction.homework.HomeWorkListStructure','studentPortal.HomeWorkListStructureForPortal',
             'coursetransaction.homework.submissiondetails.SubmissionDetailsGridStructure','coursetransaction.homework.evaluationdetails.EvaluationDetailsGridStructure'
             ,'coursetransaction.homework.submissiondetails.UploadStudentHomeworkAssignmentDocument','coursetransaction.homework.submissiondetails.HomeworkAssignmentDocumentGrid',
             'coursetransaction.homework.BulkDocumentDownloadWindow',
             'coursetransaction.homework.submissiondetails.SubmissionDetailsGridNew',
             'coursetransaction.homework.assignmentDetails.hwAssignmentGridNew',
             'coursetransaction.homework.evaluationdetails.EvaluationDetailsGridNew',
             'setup.templatemapping.PreviewTemplate',
             'facultyPortal.FacultyHomeworkListStructure','facultyPortal.FacultyHomeworkAssignmentSearch','coursetransaction.homework.assignmentDetails.hwAssignmentStudentDetailsGrid','coursetransaction.homework.assignmentDetails.hwAssignmentGrid',
             'coursetransaction.homework.StudentHomeworkAssignmentSearch','examinationcenters.generatehallticket.GenerateTabulationReportWin'],	           

             config: {

            	 /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.

            	  *//**
            	  * @cfg {Array} HOMEWORK_ASSIGNMENT_PERMISSIONS array (required)
            	  * The array of permissions to use for Access control wise enabling and disabling buttons.
            	  * @accessor
            	  */
            	 HOMEWORK_ASSIGNMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
            	 STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
            	 HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES'),
            	 FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES'),
            	 PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PRIVILEGES'),
            	 HOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES'),
            	 FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES')
             },
	         
	         refs : [{
	        	 ref : 'evaluationdetailsgrid',
	        	 selector : 'evaluationdetailsgrid'
	         },{
	        	 ref : 'submissiondetailsgrid',
	        	 selector : 'submissiondetailsgrid'
	         },{
	        	 ref : 'assigndetailsallgrid',
	        	 selector : 'assigndetailsallgrid'
	         },{
	        	 ref : 'groupsassignmentgrid',
	        	 selector : 'groupsassignmentgrid'
	         },{
	        	 ref : 'groupsassignmentGrid',
	        	 selector : 'groupsassignmentgrid grid'
	         },{
	        	 ref : 'assigndetailsindividualgrid',
	        	 selector : 'assigndetailsindividualgrid'
	         },{
	        	 ref : 'uploadfile',
	        	 selector : 'uploadfile'
	         },{
	        	 ref : 'idividualassignmentgrid',
	        	 selector : 'idividualassignmentgrid'
	         },{
	        	 ref : 'idividualassignmentGrid',
	        	 selector : 'idividualassignmentgrid grid'
	         },{
	        	 ref : 'assignmentdetails',
	        	 selector : 'assignmentdetails'
	         },{
	        	 ref: 'assigndetailsgroupgrid',
	        	 selector: 'assigndetailsgroupgrid'
	         },{
	        	 ref: 'contentPanel',
	        	 selector: 'contentPanel'
	         },{
	        	 ref: 'evaluationDetails',
	        	 selector: 'evaluationdetails form'
	         },{
	        	 ref: 'homeworkstructure',
	        	 selector: 'homeworkstructure'
	         }, {
	        	 ref: 'searchresultgrid',
	        	 selector: 'searchresultgrid[itemId=homeworklistId]'
	         }, {
	        	 ref: 'homeworkadvlisting',
	        	 selector: 'homeworkadvlisting'
	         }, {
	        	 ref: 'homeworksearch',
	        	 selector: 'homeworksearch'
	         },{
	        	 ref: 'homeworkassignmentsearch',
	        	 selector: 'homeworkassignmentsearch'
	         },{
	        	 ref: 'homeworkliststructure',
	        	 selector: 'homeworkliststructure'
	         },{
	        	 ref: 'uploadstudenthomeworkassignmentdocument',
	        	 selector: 'uploadstudenthomeworkassignmentdocument'
	         },{
	        	 ref: 'homeworkassignmentdocumentgrid',
	        	 selector: 'homeworkassignmentdocumentgrid'
	         },
	         {
	        	 ref: 'bulkdocumentdownloadwindow',
	        	 selector: 'bulkdocumentdownloadwindow'
	         },{
	        	 ref: 'evaluationdetailsgridstructure',
	        	 selector: 'evaluationdetailsgridstructure'
	         },{
	        	 ref: 'submissiondetailsgridstructure',
	        	 selector: 'submissiondetailsgridstructure'
	         },{
	        	 ref: 'submissiondetailsgridnew',
	        	 selector: 'submissiondetailsgridnew'
	         },{
	        	 ref: 'hwassignmentgridnew',
	        	 selector: 'hwassignmentgridnew'
	         },{
	        	 ref: 'evaluationdetailsgridnew',
	        	 selector: 'evaluationdetailsgridnew'
	         },{
	 			ref : 'facultyhomeworkliststructure',
				selector : 'facultyhomeworkliststructure'
			},{
				ref : 'facultyhomeworkassignmentsearch',
				selector : 'facultyhomeworkassignmentsearch'
			},{
				ref : 'hwassignmentstudentdetailsgrid',
				selector : 'hwassignmentstudentdetailsgrid'
			},{
				ref : 'studenthomeworkassignmentsearch',
				selector : 'studenthomeworkassignmentsearch'
			},{
				ref : 'homeworkliststructureforportal',
				selector : 'homeworkliststructureforportal'
			},{
		        ref : 'generateassignmentdetailsreportwin',
		        selector:'generatetabulationreportwin[itemId=generateassignmentdetailsreportwin]'
		    },{
		    	ref: 'previewtemplate',
		    	selector: 'previewtemplate'
		    }],
                 
			init : function() {
				this.control({
					'homeworkliststructure':{
						afterrender: function(structure){
							var grid = structure.down('#homeworklistId');
           				 this.getCBGridHeaderFreeze(grid,structure, false);
						}
					},
					'homeworkliststructureforportal':{
						afterrender: function(structure){
							var grid = structure.down('#homeworklistId');
							var newStructure = structure.up('personinfostudentportal');
							this.getCBGridHeaderFreeze(grid,newStructure, false);
						}
					},
					'evaluationdetailsgridstructure':{
						render: function(structure){
							var me = this;
							if(portalId==2){
								var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
								var hideIdentity = assignmentdetailsFormValue.hideIdentityRadio_ID;
								if(!hideIdentity){
									structure.down('evaluationdetailsgrid').setVisible(true);
									structure.down('evaluationdetailsgridnew').setVisible(false);
								}
								else{
									structure.down('evaluationdetailsgridnew').setVisible(true);
									structure.down('evaluationdetailsgrid').setVisible(false);
								}
							}
						}
					},
					'submissiondetailsgridstructure':{
						render: function(structure){
							var me = this;
							if(portalId==2){
								var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
								var hideIdentity = assignmentdetailsFormValue.hideIdentityRadio_ID;
								if(!hideIdentity){
									structure.down('submissiondetailsgrid').setVisible(true);
									structure.down('submissiondetailsgridnew').setVisible(false);
								}
								else{
									structure.down('submissiondetailsgridnew').setVisible(true);
									structure.down('submissiondetailsgrid').setVisible(false);
								}
							}
						}
					},
					'homeworkstructure':{
						render: function(me, eOpts) {
							me.up('panel').body.el.dom.style.overflowX='hidden';
						},
						afterrender:function(structure){
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId==7){
								this.tabVisibilityCheck(this.getPARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS()); 
							}else if(portalId==3){
								this.tabVisibilityCheck(this.getSTUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES()); 
							}else if (portalId == 2){
								this.tabVisibilityCheck(this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS()); 
							} else {
								this.tabVisibilityCheck(this.getHOMEWORK_ASSIGNMENT_PERMISSIONS()); 
							}
						},
						tabchange:function(tabPanel, newCard, oldCard, eOpts){
							var me = this;
							var assignmentdetailsForm = me.getAssignmentdetails();
							var isEvaluationRequired  = assignmentdetailsForm.down('#isEvaluationRequired').getValue();
							var courseId  = assignmentdetailsForm.down('#courseId');
							var courseVariant_Id  = assignmentdetailsForm.down('#courseVariant_Id');

							var assignmentId = assignmentdetailsForm.getForm().findField('responseId').getValue();
							var user=me.getCurrentlyLoggedInUser();
							var userId=user.id;
							var userPortalId=me.getCurrentLoggedPortalId();

							var courseHomeWorkAssignmentId = assignmentdetailsForm.config.courseHomeWorkAssignmentId;
							var evaluationPlanId_Id  = assignmentdetailsForm.down('#evaluationPlanId_Id').getValue();

							if(newCard.itemId == "evaluationDetailsGridStructureItemId"){
								var evaluationDetailsGridStructure = me.getHomeworkstructure().down('#evaluationDetailsGridStructureItemId');
								var evaluationDetailsFields = evaluationDetailsGridStructure.down('#evaluationDetailsFields');
								var evaluationdetailsform = evaluationDetailsGridStructure.down('#evaluationdetailsformItemId');
								var displayfieldprogramCodeAndNameId = evaluationDetailsFields.down('#displayfieldprogramCodeAndNameId');
								var displayfieldProgramGroupId = evaluationDetailsFields.down('#displayfieldProgramGroupId');
								var displayfieldMaxMarks = evaluationDetailsFields.down('#displayfieldMaxMarksId');
								
								if(!isNullOrEmpty(newCard.maxMarks)){
									displayfieldMaxMarks.show();
									displayfieldMaxMarks.setValue(newCard.maxMarks);
								}
								else{
									displayfieldMaxMarks.hide();
								}
								
								if(isEvaluationRequired){
									var evaluationdetailsgrid = me.getEvaluationdetailsgrid();
				       		    	var evaluationdetailsgridStore = evaluationdetailsgrid.getStore();
				       		    	evaluationDetailsFields.setVisible(false);
									evaluationdetailsform.setVisible(true);
									var courseVariantIds = courseVariant_Id.getValue();
									var evaludationDetailSequenceId = evaluationdetailsform.down('#evaludationDetailSequenceId_Id');
									var insert=true;
									if(userPortalId==3){
										insert=false;
									}else if(userPortalId==7){
										insert=false;
									}
									
									if(insert){
									var evaludationDetailStore=evaludationDetailSequenceId.getStore();
									evaludationDetailStore.getProxy().extraParams = {
										hwId : courseHomeWorkAssignmentId
									};
									//evaludationDetailSequenceId.reset();
									evaludationDetailStore.load({
										callback: function(record, operation, success) {
											if (success) {
												if(record.length==1){
													evaludationDetailSequenceId.setValue(record[0].data.id);
													evaluationdetailsgridStore.getProxy().api.read = SERVERURL.PATH_FIND_BY_HW_ASSESSMENT_ID_AND_AE_ID;
													evaluationdetailsgridStore.removeAll();
													evaluationdetailsgridStore.getProxy().extraParams = {
								       		    		evalSeqDetailId : record[0].data.id,
								       		    		hwAssignmentId:assignmentId,
								       		    		courseVariantId: courseVariantIds.join(),
								       		    		whetherExamAttended:true,
								       		    		whetherEvalAnonymous:false,
								       		    		portalId:userPortalId
								       		    	};
													evaluationdetailsgridStore.load({
							       		    			callback:function(record) {
							       		    				evaluationdetailsgrid.getSelectionModel().deselectAll();
							       		    				if(record.length != 0) {
							       		    					if(record[0].data.isDynamicScheme && record[0].data.dynamicEventStatus!=
							       		    						getExaminationTranslation('CNTRL_CONDUCTED')){
							       		    						evaluationdetailsgrid.down('#btnEdit').setVisible(false);
							       		    						evaluationdetailsgrid.down('#btnDelete').setVisible(false);
							       		    					} else if(!(record[0].data.isDynamicScheme) && record[0].data.eventStatus!=
							       		    						getExaminationTranslation('CNTRL_CONDUCTED')) {
							       		    						evaluationdetailsgrid.down('#btnEdit').setVisible(false);
							       		    						evaluationdetailsgrid.down('#btnDelete').setVisible(false);
							       		    					}else{
							       		    						evaluationdetailsgrid.down('#btnEdit').setVisible(true);
							       		    						evaluationdetailsgrid.down('#btnDelete').setVisible(true);
							       		    					}
							       		    				}
							       		    			}
													});
												}
											}	 
										}
									});
								
									}
									var evaluationPlanId = evaluationdetailsform.down('#evaluationPlanId_Id');
									//evaluationPlanId.reset();
									
									evaluationPlanId.getStore().getProxy().extraParams = {
										courseVariantIds : courseVariantIds.join()
									};
									evaluationPlanId.getStore().load({
										callback : function(records,operation,success) {
											if (success) {
												evaluationPlanId.setValue(evaluationPlanId_Id);
											}
										}
									});

									evaluationdetailsform.config.hwAssignmentId = courseHomeWorkAssignmentId;
									evaluationdetailsform.config.CourseVariantIDs = courseVariantIds;
								}
								else{
									evaluationDetailsFields.setVisible(true);
									evaluationdetailsform.setVisible(false);

									displayfieldprogramCodeAndNameId.setValue(courseId.getRawValue());
									displayfieldProgramGroupId.setValue(courseVariant_Id.getRawValue());
								}
								evaluationDetailsGridStructure.config.isEvaluationRequired = isEvaluationRequired;
								var store = this.getStore('coursetransaction.homework.submissiondetails.EvaluationDetailsGrid');
								var studentId=null;
								if(userPortalId==3){
									studentId = this.getCurrentlyLoggedInUser().id;
								}else if (userPortalId==7){
									studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id
								}
								if(!isEvaluationRequired){
									store.getProxy().actionMethods.read = 'GET';
									store.getProxy().api.read = SERVERURL.HW_SUBMISSION_DETAILS_GRID;
									store.removeAll();
									store.getProxy().extraParams = {
										id : assignmentId,
										docType:'EVALUATED_DOC',
										userId: studentId
									};
									store.load();
								}
								else{
									if(userPortalId==3 || userPortalId==7){
										evaluationdetailsform.setVisible(false);
										store.getProxy().actionMethods.read = 'GET';
					       		    	store.getProxy().api.read = SERVERURL.PATH_FIND_BY_HW_ASSESSMENT_ID_AND_AE_ID;
					       		    	store.removeAll();
					       		    	store.getProxy().extraParams = {
					       		    		evalSeqDetailId : null,
					       		    		hwAssignmentId:assignmentId,
					       		    		courseVariantId: courseVariantIds.join(),
					       		    		whetherExamAttended:true,
					       		    		whetherEvalAnonymous:false,
					       		    		studentId: studentId,
					       		    		portalId:userPortalId
					       		    	};
					       		    	store.load();
									}
									if(oldCard.title == getCourseTxCommonTranslation('HW_ASSIGNMENT_DETAILS')){
										var evaludationDetailSequenceId = evaluationdetailsform.down('#evaludationDetailSequenceId_Id');
										var evaludationDetailSequenceIdVal = evaludationDetailSequenceId.getValue();
										if(isNullOrEmpty(evaludationDetailSequenceIdVal)){
											store.removeAll();
										}
									}
								}
							}
						}
					},
					'searchresultgrid[itemId=homeworklistId]': {
						render: function(grid){
							this.gridRenderFunction(grid);
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId==7){
								this.genericCBGridAccessControlValidation(grid,this.getPARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS());
								this.disableUploadDocumentPivileges(grid,this.getPARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS());
							}else if(portalId==3){
								this.genericCBGridAccessControlValidation(grid,this.getSTUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES());
								this.disableUploadDocumentPivileges(grid,this.getSTUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES()); 
							}else{
								this.genericCBGridAccessControlValidation(grid,this.getHOMEWORK_ASSIGNMENT_PERMISSIONS());
								this.disableUploadDocumentPivileges(grid,this.getHOMEWORK_ASSIGNMENT_PERMISSIONS()); 
							}
							var portalId = this.getCurrentLoggedPortalId();

							if(portalId==3 || portalId==7){
								grid.down('#exportReportBtnId').setVisible(false);
							}

							if(portalId==1 || portalId==2){
								grid.down('#submitAssignmentDocument').setVisible(false);
							}else{
								grid.down('#bulkDownloadDocId').setVisible(false); 
							}
						},
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var searchResultGrid = this.getSearchresultgrid();
							var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "ASSIGNMENT_DOCUMENT") {
								if (e.target.tagName == 'A') {
									var documentId = record.get("DOC_ID");
									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
							if (columnName == "TOTAL_STUDENT_COUNT") {
								if (e.target.tagName == 'A') {
									var hwAssignmentId = record.get("ID");
									var userId = this.getCurrentlyLoggedInUser().id;
									if (!isNullOrEmpty(hwAssignmentId)) {
										this.findHWStudentCount(record, grid, null);
										this.openHWAssignmentForm(record.data.ID,userId);
									}
								}
							}
							if (columnName == "NO_OF_PENDING_STUDENT_COUNT") {
								if (e.target.tagName == 'A') {
									var hwAssignmentId = record.get("ID");
									if (!isNullOrEmpty(hwAssignmentId)) {
										this.findHWStudentCount(record, grid, 'Pending');
										this.openHWAssignmentForm(record.data.ID,userId);
									}
								}
							}
							if (columnName == "NO_OF_Completed_STUDENT_COUNT") {
								if (e.target.tagName == 'A') {
									var hwAssignmentId = record.get("ID");
									if (!isNullOrEmpty(hwAssignmentId)) {
										this.findHWStudentCount(record, grid, 'Completed');
										this.openHWAssignmentForm(record.data.ID,userId);
									}
								}
							}
						},
						selectionchange: function(column, selected,eOpts ){
							if(!isNullOrEmpty(selected) && !isNullOrEmpty(selected[0]) && !isNullOrEmpty(selected[0].data)) {
								var onlineSubmission = selected[0].data.HWONLINESUBMISSIONS;
								var searchResultGrid = this.getSearchresultgrid();
			                	if(onlineSubmission == 'Yes'){
			                		if(selected[0].data.WITHDRAWN == 'Yes'){
			                			searchResultGrid.down('#submitAssignmentDocument').setDisabled(true);
			                		}else{
			                			searchResultGrid.down('#submitAssignmentDocument').setDisabled(false);
			                		}
			                	} else {
			                		searchResultGrid.down('#submitAssignmentDocument').setDisabled(true);
			                	}
							}
		                }
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=searchResultGridBtnAdd]': {
						click: this.openAssignmentForm
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=searchResultGridBtnEdit]': {
						click: this.editAssignmentForm
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=searchResultGridBtnDelete]': {
						click: function() {
							this.deleteAssignmentRecords();
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=searchResultGridBtnView]': {
						click: this.viewAssignmentForm
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=submitAssignmentDocument]': {
						click: function(){
							this.submitAssignmentDocumentUpload()
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=bulkDownloadDocId]': {
						click: function(button){
							var me = this;
							var grid = me.getSearchresultgrid();
							if (grid.getSelectionModel().getCount() > 0) {
								var records = grid.getSelectionModel().getSelection();
								if (records != undefined && records != ""&& records != null) {
									var formWindow = this.getBulkdocumentdownloadwindow();
									if (!formWindow) {
										Ext.widget('bulkdocumentdownloadwindow');
										formWindow = this.getBulkdocumentdownloadwindow();
									}
									formWindow.show();
								}
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=exportReportBtnId]': {
						click: function(button){
							var $this = this;
							var tempalte = $this.getStore('setup.templatemapping.TemplateNameListFacultyByCode');
	      				    tempalte.getProxy().extraParams={
	     					    reportType:'Assignment Reports'
	  				   };
	  				   tempalte.load({
	   					   callback:function(record) {
	   						   if(record.length==1) {
	   							   var portalId = $this.getCurrentLoggedPortalId(); 
	   							   if(portalId==2){
	   								   $this.generateFacultyHomeworkAssignmentReport(record[0].data.value);
	   							   }else{
	   								   $this.generateHomeworkAssignmentReport(record[0].data.value);
	   							   }
	   						   } else {
	   							   var formWindow = $this.getGenerateassignmentdetailsreportwin();
	  							   if (!formWindow) {
	  								   formWindow = Ext.widget('generatetabulationreportwin',{
	       				        			itemId:'generateassignmentdetailsreportwin'
	       				        	   });
	  							   }
	   							   formWindow.setHeight(160);
	   							   formWindow.setWidth(500);
	   							   formWindow.show();
	   							   var tempalte = formWindow.down('#chooseTemplate').getStore();
	   							   tempalte.getProxy().extraParams={
	   								   reportType:'Assignment Reports'
	   							   };
	   							   tempalte.load();
	   						   }
	   					   }
	   				  });
							//$this.generateHomeworkAssignmentReport();
						}
					},
					'generatetabulationreportwin[itemId=generateassignmentdetailsreportwin] button[itemId=submitBtn]':{
						click:function(obj){
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId(); 
							if(portalId==2){
								$this.generateFacultyHomeworkAssignmentReport();
							}else{
								$this.generateHomeworkAssignmentReport();
							}
						}
			  		},
			  		'previewtemplate  button[itemId=cancelBtn]': {
		    			click: function(){
		    				this.getPreviewtemplate().close();
		    			}
		    		},
			  		'generatetabulationreportwin[itemId=generateassignmentdetailsreportwin] button[itemId=previewTemplateBtn]':{
						click:function(obj){
							this.previewTemplateFunction();
						}
			  		},
					'documentformwindow[itemId=homeworkAssignmentSubmissionDocument] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]' : {
						click : function() {
							this.saveAssignmetDocument();
						}
					},
					'bulkdocumentdownloadwindow button[itemId=submitBtn]':{
						click: this.bulkDownloadDocument
					},
					'bulkdocumentdownloadwindow button[itemId=cancelBtn]':{
						click: function(button){
							button.up('window').close();
						}
					},
					'homeworkassignmentsearch button[itemId=searchBtn]': {
						click: function(btn){
							var me = this;
							me.getSearchresultgrid().show();
							me.loadHomeWork(btn);
							if(Ext.isDefined(btn.up('homeworkliststructure'))){
								btn.up('homeworkliststructure').scrollBy(0,1);
								btn.up('homeworkliststructure').scrollBy(0,-1);
							}
						}
					},
					'homeworkassignmentsearch button[itemId=resetBtn]': {
						click: this.resetHomeWork
					},
					'idividualassignmentgrid button[itemId=individual_assignment_Add]':{
						click:function(){
							this.storeInAssignmentDetailsGrid();
						}
					},
					'idividualassignmentgrid button[itemId=individual_assignment_Cancel]':{
						click:function(){
							this.getIdividualassignmentgrid().close();
						}
					},
					'groupsassignmentgrid button[itemId=group_assignment_Add]':{
						click:function(){
							this.storeGroupDetailsGrid();
						}
					},
					'groupsassignmentgrid button[itemId=cancelBtn]':{
						click:function(){
							this.getGroupsassignmentgrid().close();
						}
					}, 
					'assigndetailsindividualgrid menuitem[itemId=textLinked]' : {
						click : function() {
							this.showUploadFileInividual();
						}
					},
					'assigndetailsgroupgrid button[itemId=uploadDocument]' : {
						click : function() {
							this.showUploadGroupFile();
						}
					},

					'assigndetailsindividualgrid button[itemId=indUploadDocument]' : {
						click : function() {
							this.showUploadFileInividual();
						}
					},
					'assigndetailsallgrid button[itemId=uploadDocument]' : {
						click : function() {
							this.showUploadFileAll();
						}
					},
					'assigndetailsallgrid button[itemId=btnAdd]' : {
						click : function() {
							this.showIndividualAssignment();
						}
					},
					'assigndetailsallgrid button[itemId=btnDelete]' : {
						click : function() {
							this.deleteAssignmentIndividualRecords();
						}
					},
					'assigndetailsgroupgrid button[itemId=btnAdd]' : {
						click : function() {
							this.showGroupAssignment();
						}
					},
					'assigndetailsindividualgrid button[itemId=btnAdd]' : {
						click : function() {
							this.showIndividualAssignment();
						}
					},	 
					'assigndetailsindividualgrid button[itemId=btnDelete]' : {
						click : function() {
							this.deleteAssignmentIndividualRecords();
						}
					},
					'assigndetailsgroupgrid button[itemId=btnDelete]' : {
						click : function() {
							this.deleteAssignmentGroupRecords();
						}
					},
					'assignmentdetails button[itemId=hwAssignment_Add]' : {
						click : function() {
							var $this = this;
							var form = this.getAssignmentdetails();
							var isEditable=form.getForm().findField('isEditable').getValue();
							var isEvaluationRequired=form.getForm().findField('isEvaluationRequired').getValue();
							if(!isNullOrEmpty(isEditable) && !isNullOrEmpty(isEvaluationRequired) && isEvaluationRequired && (!isEditable || isEditable == 'false')) {
								showConfirmMessage(getCourseTxCommonTranslation('ASSIGNMENT_DETAILS'),getProgramandcourseTranslation('MAP_ASSESMENT_EVENT_SCHEME'),
										function(btn,text) {
									if (btn == 'yes') {
										$this.addAssignmentDetails();
									}
								});
							} else {
								$this.addAssignmentDetails();
							}
						}
					},
					'assignmentdetails datefield[itemId=publishDate]' : {
						change: function(field, newValue, oldValue, eOpts ) {
							var formPnl = field.up('form');
							var mainFieldContainer = field.up('fieldcontainer');
							var publishDateField = mainFieldContainer.down('#publishDate');
							var publishTimeField = mainFieldContainer.down('#publishTime');
							var submittedDateField = mainFieldContainer.down('#dateSubmitted');
							var submittedTimeField = mainFieldContainer.down('#submittedTime');
							var extendedDateField = mainFieldContainer.down('#extendedDate');
							var extendedTimeField = mainFieldContainer.down('#extendedTime');
							var dateGivenField=publishDateField.up('form').down('#dateGiven');
							var timeGivenField=publishDateField.up('form').down('#timeGiven');
							var scheduleDateField = formPnl.down('#scheduleDate');
							var scheduleTimeField = formPnl.down('#scheduleTime');
							var configureNotificationFld = formPnl.down('#configureNotificationId');
							//-- resetting dependent fields
							publishTimeField.reset();
							submittedDateField.reset();
							submittedTimeField.reset();
							extendedDateField.reset();
							extendedTimeField.reset();

							scheduleDateField.reset();
							scheduleTimeField.reset();

							//-- resetting min & max values
							publishTimeField.setMinValue(false);
							publishTimeField.setMaxValue(false);
							submittedDateField.setMinValue(false);
							submittedDateField.setMaxValue(false);
							submittedTimeField.setMinValue(false);
							submittedTimeField.setMaxValue(false);
							extendedDateField.setMinValue(false);
							extendedDateField.setMaxValue(false);
							extendedTimeField.setMinValue(false);
							extendedTimeField.setMaxValue(false);
							scheduleTimeField.setMinValue(false);
							scheduleTimeField.setMaxValue(false);

							//-- setting dependent fields' min values
							if(dateGivenField.getSubmitValue()==publishDateField.getSubmitValue()){
								setTimeout(function(){
									if(!isNullOrEmpty(publishTimeField.getValue())){
										publishTimeField.setMinValue(publishTimeField.getValue());
									}
									else{
										publishTimeField.setMinValue(timeGivenField.getValue());
									}

									if(scheduleTimeField.readOnly){
										scheduleTimeField.setMinValue(false);
										scheduleTimeField.setMaxValue(false);
										scheduleTimeField.clearInvalid();
									}
								},500);
							}
							submittedDateField.setMinValue(publishDateField.getValue());
							extendedDateField.setMinValue(publishDateField.getValue());
							scheduleDateField.setMinValue(publishDateField.getValue());
							scheduleDateField.setValue(publishDateField.getValue());

							if(!isNullOrEmpty(publishDateField.getValue()) && !isNullOrEmpty(publishTimeField.getValue()) && !isNullOrEmpty(submittedDateField.getValue()) && !isNullOrEmpty(submittedTimeField.getValue())){
								configureNotificationFld.setDisabled(false);
							}
							else{
								configureNotificationFld.setDisabled(true);
								configureNotificationFld.setValue(false);
							}
						}
					},
					'assignmentdetails timefield[itemId=publishTime]' : {
						change: function(field, newValue, oldValue, eOpts ) {
							var formPnl = field.up('form');
							var mainFieldContainer = field.up('fieldcontainer');
							var publishDateField = mainFieldContainer.down('#publishDate');
							var publishTimeField = mainFieldContainer.down('#publishTime');
							var submittedDateField = mainFieldContainer.down('#dateSubmitted');
							var submittedTimeField = mainFieldContainer.down('#submittedTime');
							var extendedDateField = mainFieldContainer.down('#extendedDate');
							var extendedTimeField = mainFieldContainer.down('#extendedTime');
							var scheduleDateField = formPnl.down('#scheduleDate');
							var scheduleTimeField = formPnl.down('#scheduleTime');
							var configureNotificationFld = formPnl.down('#configureNotificationId');
							var timeGivenField=formPnl.down('#timeGiven');

							//-- resetting dependent fields
							submittedDateField.reset();
							submittedTimeField.reset();
							extendedDateField.reset();
							extendedTimeField.reset();

							//-- resetting min & max values
							submittedDateField.setMinValue(false);
							submittedDateField.setMaxValue(false);
							submittedTimeField.setMinValue(false);
							submittedTimeField.setMaxValue(false);
							extendedDateField.setMinValue(false);
							extendedDateField.setMaxValue(false);
							extendedTimeField.setMinValue(false);
							extendedTimeField.setMaxValue(false);

							//-- setting dependent fields' min values
							if(!isNullOrEmpty(publishDateField.getValue())){
								try{
									if(field.getValue().getHours()==23 && field.getValue().getMinutes()==59){
										var newDate = new Date(publishDateField.getValue());
										newDate.setDate(newDate.getDate() + 1);
										submittedDateField.setMinValue(newDate);
										extendedDateField.setMinValue(newDate);
									}
									else{
										submittedDateField.setMinValue(publishDateField.getValue());
										extendedDateField.setMinValue(publishDateField.getValue());
									}
									if(configureNotificationFld.getValue()){
										scheduleTimeField.setMinValue(timeGivenField.getValue());
									}

									if(scheduleTimeField.readOnly){
										scheduleTimeField.setMinValue(false);
										scheduleTimeField.setMaxValue(false);
										scheduleTimeField.clearInvalid();
									}
								}
								catch(e){
									console.log('');
								}
							}
							if(!isNullOrEmpty(publishDateField.getValue()) && !isNullOrEmpty(publishTimeField.getValue()) && !isNullOrEmpty(submittedDateField.getValue()) && !isNullOrEmpty(submittedTimeField.getValue())){
								configureNotificationFld.setDisabled(false);
							}else{
								configureNotificationFld.setDisabled(true);
								configureNotificationFld.setValue(false);
							}
						}
					},
					'assignmentdetails datefield[itemId=dateSubmitted]' : {
						change: function(field, newValue, oldValue, eOpts ) {
							var formPnl = field.up('form');
							var mainFieldContainer = field.up('fieldcontainer');
							var publishDateField = mainFieldContainer.down('#publishDate');
							var publishTimeField = mainFieldContainer.down('#publishTime');
							var submittedDateField = mainFieldContainer.down('#dateSubmitted');
							var submittedTimeField = mainFieldContainer.down('#submittedTime');
							var extendedDateField = mainFieldContainer.down('#extendedDate');
							var extendedTimeField = mainFieldContainer.down('#extendedTime');
							var scheduleDateField = formPnl.down('#scheduleDate');
							var configureNotificationFld = formPnl.down('#configureNotificationId');

							//-- resetting dependent fields
							submittedTimeField.reset();
							extendedDateField.reset();
							extendedTimeField.reset();
							scheduleDateField.reset();

							//-- resetting min & max values
							submittedTimeField.setMinValue(false);
							submittedTimeField.setMaxValue(false);
							extendedDateField.setMinValue(false);
							extendedDateField.setMaxValue(false);
							extendedTimeField.setMinValue(false);
							extendedTimeField.setMaxValue(false);
							scheduleDateField.setMaxValue(false);

							//-- setting dependent fields' min values
							try{
								if(!isNullOrEmpty(publishTimeField.getValue()) && !isNullOrEmpty(publishDateField.getValue()) && publishDateField.getValue().getTime()==submittedDateField.getValue().getTime()){
									var newTime = new Date(publishTimeField.getValue().getTime() + 60000);
									submittedTimeField.setMinValue(newTime);
								}
								extendedDateField.setMinValue(submittedDateField.getValue());
								scheduleDateField.setMaxValue(submittedDateField.getValue());
								if(!isNullOrEmpty(publishDateField.getValue()) && !isNullOrEmpty(publishTimeField.getValue()) && !isNullOrEmpty(submittedDateField.getValue()) && !isNullOrEmpty(submittedTimeField.getValue())){
									configureNotificationFld.setDisabled(false);
								}else{
									configureNotificationFld.setDisabled(true);
									configureNotificationFld.setValue(false);
								}
							}
							catch(e){
								console.log('');
							}
						}
					},
					'assignmentdetails timefield[itemId=submittedTime]' : {
						change: function(field, newValue, oldValue, eOpts ) {
							var formPnl = field.up('form');
							var mainFieldContainer = field.up('fieldcontainer');
							var publishDateField = mainFieldContainer.down('#publishDate');
							var publishTimeField = mainFieldContainer.down('#publishTime');
							var submittedDateField = mainFieldContainer.down('#dateSubmitted');
							var submittedTimeField = mainFieldContainer.down('#submittedTime');
							var extendedDateField = mainFieldContainer.down('#extendedDate');
							var extendedTimeField = mainFieldContainer.down('#extendedTime');
							var scheduleDateField = formPnl.down('#scheduleDate');
							var scheduleTimeField = formPnl.down('#scheduleTime');
							var configureNotificationFld = formPnl.down('#configureNotificationId');

							//-- resetting dependent fields
							extendedDateField.reset();
							extendedTimeField.reset();
							scheduleTimeField.reset();

							//-- resetting min & max values
							extendedDateField.setMinValue(false);
							extendedDateField.setMaxValue(false);
							extendedTimeField.setMinValue(false);
							extendedTimeField.setMaxValue(false);
							scheduleTimeField.setMaxValue(false);

							//-- setting dependent fields' min values
							if(!isNullOrEmpty(submittedDateField.getValue())){
								try{
									if(field.getValue().getHours()==23 && field.getValue().getMinutes()==59){
										var newDate = new Date(submittedDateField.getValue());
										newDate.setDate(newDate.getDate() + 1);
										extendedDateField.setMinValue(newDate);
									}
									else{
										extendedDateField.setMinValue(submittedDateField.getValue());
									}

									if(!isNullOrEmpty(publishDateField.getValue()) && !isNullOrEmpty(publishTimeField.getValue()) && !isNullOrEmpty(submittedDateField.getValue()) && !isNullOrEmpty(submittedTimeField.getValue())){
										configureNotificationFld.setDisabled(false);
										if(!isNullOrEmpty(scheduleDateField.getValue()) && (scheduleDateField.getValue().getDate()==submittedDateField.getValue().getDate())){
											var maxVal = submittedTimeField.getValue();
											scheduleTimeField.setMaxValue(maxVal);
										} else if(!isNullOrEmpty(scheduleDateField.getValue()) && (submittedDateField.getValue().getDate()>scheduleDateField.getValue().getDate())){
											scheduleTimeField.setMaxValue(false);
										}
									}else{
										configureNotificationFld.setDisabled(true);
										configureNotificationFld.setValue(false);
									}
								}
								catch(e){
									console.log('');
								}
							}
						}
					},
					'assignmentdetails datefield[itemId=extendedDate]' : {
						change: function(field, newValue, oldValue, eOpts ) {
							var mainFieldContainer = field.up('fieldcontainer');
							var publishDateField = mainFieldContainer.down('#publishDate');
							var publishTimeField = mainFieldContainer.down('#publishTime');
							var submittedDateField = mainFieldContainer.down('#dateSubmitted');
							var submittedTimeField = mainFieldContainer.down('#submittedTime');
							var extendedDateField = mainFieldContainer.down('#extendedDate');
							var extendedTimeField = mainFieldContainer.down('#extendedTime');

							//-- resetting dependent fields
							extendedTimeField.reset();

							//-- resetting min & max values
							extendedTimeField.setMinValue(false);
							extendedTimeField.setMaxValue(false);

							//-- setting dependent fields' min values
							try{
								if(!isNullOrEmpty(submittedTimeField.getValue()) && !isNullOrEmpty(submittedDateField.getValue()) && submittedDateField.getValue().getTime()==extendedDateField.getValue().getTime()){
									var newTime = new Date(submittedTimeField.getValue().getTime() + 60000);
									extendedTimeField.setMinValue(newTime);
								}
							}
							catch(e){
								console.log('');
							}
						}
					},
					'assignmentdetails datefield[itemId=scheduleDate]' : {
						select:function(fld,value,eOpts){
							var formPnl = fld.up('form');
							var scheduleTimeField = formPnl.down('#scheduleTime');
							var publishDateField = formPnl.down('#publishDate');
							var publishTimeField = formPnl.down('#publishTime');
							var submittedDateField = formPnl.down('#dateSubmitted');
							var submittedTimeField = formPnl.down('#submittedTime');
							var timeGivenField=formPnl.down('#timeGiven');
							var dateGivenField=formPnl.down('#dateGiven');

							scheduleTimeField.reset();
							scheduleTimeField.setMinValue(false);
							scheduleTimeField.setMaxValue(false);
							if(!isNullOrEmpty(fld.getValue()) && !isNullOrEmpty(publishDateField.getValue()) && fld.getValue().getDate()==publishDateField.getValue().getDate()){
								//var newTime = Ext.Date.add(timeGivenField.getValue(), Ext.Date.MINUTE, 30);
								//scheduleTimeField.setMinValue(newTime);
								scheduleTimeField.setMinValue(timeGivenField.getValue());
							}

							else if(dateGivenField.getValue().getDate() == fld.getValue().getDate()){
								scheduleTimeField.setMinValue(timeGivenField.getValue());
							}
							if(fld.getValue().getDate()>dateGivenField.getValue().getDate()){
								scheduleTimeField.setMinValue(false);
							}
							if(fld.getValue().getDate()==submittedDateField.getValue().getDate()){
								var maxVal = submittedTimeField.getValue();
								scheduleTimeField.setMaxValue(maxVal);
							} else if(submittedDateField.getValue().getDate()>fld.getValue().getDate()){
								scheduleTimeField.setMaxValue(false);
							}

							if(scheduleTimeField.readOnly){
								scheduleTimeField.setMinValue(false);
								scheduleTimeField.setMaxValue(false);
								scheduleTimeField.clearInvalid();
							}
						}
					},
					'assignmentdetails timefield[itemId=extendedTime]' : {
						change: function(field, newValue, oldValue, eOpts ) {

						}
					},
					'assignmentdetails':{
						afterrender:function(formMain){
							Ext.Ajax.request({
								type : 'rest',
								url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
								method : 'GET',
								async: false,
								success : function(response, action) {
									var resp = Ext.JSON.decode(response.responseText);

									setTimeout(function(){
										var id = formMain.down('[name=id]').getValue();
										if(isNullOrEmpty(id)){
											formMain.down('[name=dateGiven]').setValue(resp.stringServerDate);
											formMain.down('[name=dateGiven]').setMaxValue(resp.stringServerDate);
											formMain.down('[name=timeGiven]').setValue(resp.stringServerTime);
											formMain.down('#serverDateTime').setValue(resp.serverDate);
										}
									},500);
								}});
							var assignmentTypeRadioGroup = formMain.down("#assignmentType_Id");
							assignmentTypeRadioGroup.items.items[0].setValue(true);
						},
						render : function(adform) {
							var me = this;
							Ext.defer(function(){
								me.topicTypesShow();  							
								var form =  me.getAssignmentdetails();
								var courseField = form.down('#courseId');
								var portalId = me.getCurrentLoggedPortalId();
								var shortDescription = form.down('#shortDescriptionItemId');
						    	   runPlaceHolderTypeWriting(shortDescription,'Assignmentdetails');
								var academyLocationId = me.getCurrentAcademyLocation();
								var homeWorkCoursesStore = courseField.getStore();//this.getStore('attendance.AssignedCoursesFacultyStore');
								var facultyId = me.getCurrentlyLoggedInUser().id;
								if(portalId == 2) {
									me.hideConfigureNotificationPnl(form,me.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS());
									form.down('#faculty_Id').setVisible(false);
									form.down('#faculty_Id').allowBlank = true;
									homeWorkCoursesStore.getProxy().extraParams = {
										academyLocationIds:academyLocationId,
										facultyId:facultyId,
										isCurrentPeriod: true
									};
								}else{
									if(portalId == 1) {
										me.hideConfigureNotificationPnl(form,me.getHOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS());
									}
									homeWorkCoursesStore.getProxy().extraParams = {
										academyLocationIds:academyLocationId,
										isCurrentPeriod: true				
									};
								}  
							},500);
						}
					},
					'assignmentdetails button[itemId=hwAssignment_Cancel]' : {
						click : function() {
							var $this = this;
							var assignmentDetailForm = this.getAssignmentdetails().getForm();
							assignmentDetailForm.getFields().each(function(field) {
								flag=true;
								if(field.name === 'dateGiven'){
									flag=false;
								}
								if(field.name === 'timeGiven'){
									flag=false;
								}
								if(flag){
									field.reset();
								}
							});
							var forms = this.getAssignmentdetails();
							var assignmentTypeRadioGroup = forms.down("#assignmentType_Id");
							assignmentTypeRadioGroup.down('[inputValue=all]').setValue(true);
							forms.down('#faculty_Id').reset();
							forms.down('#faculty_Id').clearValue();
							forms.down('#faculty_Id').setDisabled(true);
							forms.down('#courseVariant_Id').reset();
							forms.down('#courseVariant_Id').clearValue();
							forms.down('#courseVariant_Id').setDisabled(true);
							forms.down('#topicType_ID').items.items[0].setValue(true);
							forms.down('#topicType_ID').items.items[1].setValue(false);
							try{
								$this.getHomeworkstructure().down('#submissionDetailsGridStructureItemId').setDisabled(true);
							} catch(e){}
							try{
								$this.getHomeworkstructure().down('#evaluationDetailsGridStructureItemId').setDisabled(true);
							} catch(e){}
							$this.getAssigndetailsindividualgrid().getStore().removeAll();
							$this.getAssigndetailsgroupgrid().getStore().removeAll();
							$this.getAssigndetailsallgrid().getStore().removeAll();
							var configureNotificationFld = forms.down('#configureNotificationId');
							configureNotificationFld.setDisabled(true);
//							var button =Ext.ComponentQuery.query('button#hwAssignment_Add')[0];
//							button.setDisabled(false);
						}
					},
					'assignmentdetails checkboxfield[itemId=isEvaluationRequired]' : {
						change : function(data){
							var $this = this;
							var form =this.getAssignmentdetails();
							var portalId = this.getCurrentLoggedPortalId();
							var EvalutionRequired= form.getForm().findField('isEvaluationRequired').getValue();
							var evaluationPlanId=form.down('#evaluationPlanId_Id');
							var courseVariantIds=form.down('#courseVariant_Id').getValue();
							var evaludationDetailSequenceId=form.down('#evaludationDetailSequenceId_Id');
							if(isNullOrEmpty(form.getForm().getValues().id)) {
								evaluationPlanId.reset();
								evaludationDetailSequenceId.reset();
							}
							var allCvs = [];
							Ext.each(courseVariantIds,function(currentCV){
								if(typeof currentCV=="number"){
									allCvs.push(currentCV);
								}else if(typeof currentCV == "object"){
									allCvs.push(currentCV.data.id);
								}
							});
							var courseVariantIds = allCvs.join();
							if(EvalutionRequired==true) {
								$this.setAllowBlank(evaluationPlanId, false);
								$this.setAllowBlank(evaludationDetailSequenceId, false);
								if(portalId==3 || portalId==7){
									evaluationPlanId.setVisible(false);
									evaludationDetailSequenceId.setVisible(false);
								} else{
									evaluationPlanId.setVisible(true);
									evaludationDetailSequenceId.setVisible(true);
								}
								if(!isNullOrEmpty(courseVariantIds)) {
									evaluationPlanId.setDisabled(false);
									evaludationDetailSequenceId.setDisabled(true);
									var evaluationPlanStore =  evaluationPlanId.getStore();
									evaluationPlanStore.getProxy().extraParams = {	
										courseVariantIds: courseVariantIds
									}
									evaluationPlanStore.load({
										callback: function(rec, success) {
											if (success) {
												if(rec.length == 1) {
													evaluationPlanId.setValue(rec[0].data.id);
												}
											}
										}
									});
								}
								form.down('#hideIdentityOnSubmissionItemId').setVisible(false);
								form.down('#hideIdentityOnSubmissionItemId').reset();
							} else {
								this.setAllowBlank(evaluationPlanId, true);
								this.setAllowBlank(evaludationDetailSequenceId, true);
								evaluationPlanId.setDisabled(true);
								evaluationPlanId.setVisible(false);
								evaludationDetailSequenceId.setVisible(false);
								evaludationDetailSequenceId.setDisabled(true);
								form.down('#hideIdentityOnSubmissionItemId').setVisible(true);
								form.down('#hideIdentityOnSubmissionItemId').reset();
								
					  			  
							}
							form.getForm().checkValidity();
							form.getForm().clearInvalid();
						}
					},
					'uploadfile button[itemId=btnSubmit]' : {
						click : function() {
							var assignmentTypeRadio =Ext.ComponentQuery.query('radiogroup#assignmentType_Id')[0];
							if(assignmentTypeRadio.items.items[0].checked){
								this.storeIndividualFile();
							}else if(assignmentTypeRadio.items.items[1].checked){
								this.storeGroupFile();
							}else{
								this.storeAllFile();
							}
						}
					},
					'assignmentdetails combo#courseVariant_Id' : {
						change : function(obj, record) {
							var $this = this;
							var form = obj.up('form');
							var allCvs = [];
							Ext.each(obj.getValue(),function(currentCV){
								if(typeof currentCV=="number"){
									allCvs.push(currentCV);
								}else if(typeof currentCV == "object"){
									allCvs.push(currentCV.data.id);
								}
							});

							var assignmentTypeRadioGroup = form.down("#assignmentType_Id");
							if(allCvs.length>1){
								assignmentTypeRadioGroup.down('[inputValue=all]').setValue(true)
								assignmentTypeRadioGroup.down('[inputValue=all]').setDisabled(false);
								assignmentTypeRadioGroup.down('[inputValue=group]').setDisabled(true);
								assignmentTypeRadioGroup.down('[inputValue=individual]').setDisabled(true);
							}
							else{
								assignmentTypeRadioGroup.down('[inputValue=all]').setDisabled(false);
								assignmentTypeRadioGroup.down('[inputValue=group]').setDisabled(false);
								assignmentTypeRadioGroup.down('[inputValue=individual]').setDisabled(false);
							}

							var courseVariantId = allCvs.join();
							try{
								var topicsAvailCombo= this.getAssignmentdetails().down('multiselectcombofield#hw_topicsAvailabilty_id');
								topicsAvailCombo.reset();
							}
							catch(e){}
							var userPortalId=this.getCurrentLoggedPortalId();
							if(userPortalId != 3 && userPortalId != 7) {
								var radioValue = assignmentTypeRadioGroup.down('[inputValue=all]').getValue();
								if(radioValue || radioValue == 'true') {
									var allGrid = this.getAssigndetailsallgrid();
									var storeAllGrid = allGrid.getStore();
									var submitURL=SERVERURL.PATH_FIND_ASSIGNMENT_DETAIL_GRID_ADD;
									if(!isNullOrEmpty(form.getForm().getValues().id)) {
										submitURL=SERVERURL.PATH_FIND_ASSIGNMENT_DETAIL_GRID_EDIT;
										storeAllGrid.getProxy().extraParams = {	
											homeWorkAssignmentId: form.getForm().getValues().id
										}
									} else {
										storeAllGrid.getProxy().extraParams = {	
											courseVariantId: courseVariantId
										} 
									}
									storeAllGrid.getProxy().api.read=submitURL;

									if(allCvs.length > 0){
										storeAllGrid.load();
									}
									else{
										storeAllGrid.removeAll();
									}
								}
							}

							if(userPortalId == 7 && !isNullOrEmpty(courseVariantId)){
								var courseVariantCombo= this.getAssignmentdetails().down('combo#courseVariant_Id');
								var allGrid = this.getAssigndetailsallgrid();
								var storeAllGrid = allGrid.getStore();
								storeAllGrid.getProxy().extraParams = {	
									courseVariantId: courseVariantId
								}
								storeAllGrid.load();
							}

							var isEvaluationRequired= form.getForm().findField('isEvaluationRequired').getValue();
							var evaluationPlanId=form.down('#evaluationPlanId_Id');
							var evaludationDetailSequenceId=form.down('#evaludationDetailSequenceId_Id');
							if(isNullOrEmpty(form.getForm().getValues().id)) {
								evaluationPlanId.reset();
								evaludationDetailSequenceId.reset();
							}
							if(isEvaluationRequired==true) {
								evaluationPlanId.setDisabled(false);
								if(userPortalId==3 || userPortalId==7){
									evaluationPlanId.setVisible(false);
									evaludationDetailSequenceId.setVisible(false);
								} else{
									evaluationPlanId.setVisible(true);
									evaludationDetailSequenceId.setVisible(true);
								}
								var evaluationPlanStore =  evaluationPlanId.getStore();
								evaluationPlanStore.getProxy().extraParams = {	
									courseVariantIds: courseVariantId
								}
								if(isNullOrEmpty(form.getForm().getValues().id)) {
									if(allCvs.length > 0){
										evaludationDetailSequenceId.setDisabled(true);
										if(isNullOrEmpty(form.getForm().getValues().id)) {
											evaluationPlanStore.load({
												callback : function(records,operation,success) {
													if (success) {
														if(records.length == 1){
															evaluationPlanId.setValue(records[0].data.id)
														}	
													}
												}
											});
										}
									} else {
										evaludationDetailSequenceId.setDisabled(true);
										evaluationPlanId.setDisabled(true);
									}
								}
							} else {
								evaludationDetailSequenceId.setDisabled(true);
								evaluationPlanId.setDisabled(true);
							}
						}
					},
					'homeworkassignmentsearch': {
						render: function(form) {
							var $this = this;
							var academicTermField = form.down("#academicTerm");
							var programId = form.down("#programId");
							var batchId = form.down("#batchId");
							var periodField = form.down('combo#periodId');
							var course_Id = form.down("#course_Id");
							var studentNameNew = form.down('[name=studentNameNew]');
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							var academyLocationId = $this.getCurrentAcademyLocation();
							var assignmentNameField = form.down('[name=assignmentName]');
							this.resetFieldParams(course_Id);
							this.resetFieldParams(programId);
							this.resetFieldParams(studentNameNew);
							this.resetFieldParams(assignmentNameField);

							if(wheatherSchool) {
								periodField.hide();
							}
							if(this.getCurrentLoggedPortalId() == 1){
								academicTermField.setVisible(true);
								$this.setAllowBlank(academicTermField, false);
								form.down('#searchBtn').setDisabled(true);

								var academicTermComboStore = academicTermField.getStore();
								academicTermComboStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId
								};
								academicTermComboStore.load({
									callback: function(rec, success) {
										if (success) {
											for(var i in rec){
												if(rec[i].get('sequence')==1){
													academicTermField.setValue(rec[i].get('id'));
													form.down('#searchBtn').setDisabled(false);
													$this.loadHomeWork();
												}
											}
										}
									}
								});
							}
							else{
								setTimeout(function(){
									academicTermField.setVisible(false);
									$this.setAllowBlank(academicTermField, true);
								},10);
							}
						}
					},
					'homeworkassignmentsearch combo#academicTerm' : {
						change : function(obj, record) {
							$this = this;
							var form = obj.up('form');
							var academicTerm = obj.value;

							var courseComboBox = form.down('#course_Id');
							var courseVarientField = form.down('#courseVarient_Id');
							var programComboBox = form.down('combo#programId');
							var batchComboBox = form.down('combo#batchId');
							var periodField=form.down('combo#periodId');
							var sectionComboBox = form.down('combo#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');
							var academyLocationId = $this.getCurrentAcademyLocation();
							var topicField = form.down('[name=topicName]');
							var assignmentNameField = form.down('[name=assignmentName]');
							var assignmentNameComboBox=form.down('combo#assignmentNameId');

							this.resetFieldParams(courseComboBox);
							this.resetFieldParams(programComboBox);
							this.resetFieldParams(batchComboBox);
							this.resetFieldParams(periodField);
							this.resetFieldParams(sectionComboBox);
							this.resetFieldParams(studentNameNewField);
							this.resetFieldParams(assignmentNameField);
							this.resetFieldParams(assignmentNameComboBox);

							topicField.reset();
							topicField.clearValue();
							topicField.setDisabled(true);

							courseComboBox.reset();
							courseComboBox.clearValue();
							courseComboBox.setDisabled(false);
							var courseStore = courseComboBox.getStore();

							courseVarientField.reset();
							courseVarientField.clearValue();
							courseVarientField.setDisabled(true);
							var courseVarientStore = courseVarientField.getStore();

							programComboBox.reset();
							programComboBox.clearValue();
							programComboBox.setDisabled(false);
							var programStore = programComboBox.getStore();

							assignmentNameComboBox.reset();
							assignmentNameComboBox.clearValue();
							assignmentNameComboBox.setDisabled(false);
							var assignmentNameStore = assignmentNameComboBox.getStore();

							batchComboBox.reset();
							batchComboBox.clearValue();
							batchComboBox.setDisabled(true);
							var batchStore = batchComboBox.getStore();

							periodField.reset();
							periodField.clearValue();
							periodField.setDisabled(true);
							var periodStore = periodField.getStore();

							sectionComboBox.reset();
							sectionComboBox.clearValue();
							sectionComboBox.setDisabled(true);
							var sectionStore = sectionComboBox.getStore();

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}

							courseStore.getProxy().extraParams.academicTermId = academicTerm;
							courseStore.getProxy().extraParams.academyLocationIds = academyLocationId;
							courseStore.getProxy().extraParams.isCurrentPeriod = false;

							courseVarientStore.getProxy().extraParams.academicTermId = academicTerm;
							courseVarientStore.getProxy().extraParams.academyLocationIds = academyLocationId;
							courseVarientStore.getProxy().extraParams.isCurrentPeriod = false;

							programStore.getProxy().extraParams.academicTermId = academicTerm;
							programStore.getProxy().extraParams.isAllProgram = true;
							programStore.getProxy().extraParams.academyLocationIds = academyLocationId;

							assignmentNameStore.getProxy().extraParams.academicTermId = academicTerm;
							assignmentNameStore.getProxy().extraParams.academyLocationIds = academyLocationId;

							batchStore.getProxy().extraParams.academicTermId = academicTerm;
							batchStore.getProxy().extraParams.isAllProgram = true;

							periodStore.getProxy().extraParams.academicTermId = academicTerm;
							periodStore.getProxy().extraParams.isAllProgram = true;

							sectionStore.getProxy().extraParams.academicTermId = academicTerm;
							sectionStore.getProxy().extraParams.isAllProgram = true;

							studentNameNewFieldStore.getProxy().extraParams.academicTermId = academicTerm;
							studentNameNewFieldStore.getProxy().extraParams.academyLocationIds = academyLocationId;

							if(academicTerm > 0) {
								courseStore.load();
								programStore.load();
								studentNameNewFieldStore.load();
							} else {
								form.down('#searchBtn').setDisabled(true);
							}
						}
					},
					'homeworkassignmentsearch combo#course_Id':{
						select : function(obj, record) {
							$this = this;
							var form = obj.up('form');
							var courseId = record[0].get("courseId");

							var courseVarientField = form.down('#courseVarient_Id');
							var programComboBox = form.down('combo#programId');
							var batchComboBox = form.down('combo#batchId');
							var periodField=form.down('combo#periodId');
							var sectionComboBox = form.down('combo#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');
							var topicField = form.down('[name=topicName]');

							topicField.reset();
							topicField.clearValue();
							topicField.setDisabled(false);

							courseVarientField.reset();
							courseVarientField.clearValue();
							courseVarientField.setDisabled(false);
							var courseVarientStore = courseVarientField.getStore();

							programComboBox.reset();
							programComboBox.clearValue();
							programComboBox.setDisabled(false);
							var programStore = programComboBox.getStore();

							batchComboBox.reset();
							batchComboBox.clearValue();
							batchComboBox.setDisabled(true);
							var batchStore = batchComboBox.getStore();

							periodField.reset();
							periodField.clearValue();
							periodField.setDisabled(true);
							var periodStore = periodField.getStore();

							sectionComboBox.reset();
							sectionComboBox.clearValue();
							sectionComboBox.setDisabled(true);
							var sectionStore = sectionComboBox.getStore();

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}
							courseVarientStore.getProxy().extraParams.courseId = courseId;
							programStore.getProxy().extraParams.courseId = courseId;
							batchStore.getProxy().extraParams.courseId = courseId;
							periodStore.getProxy().extraParams.courseId = courseId;
							studentNameNewFieldStore.getProxy().extraParams.courseId = courseId;

							programStore.getProxy().extraParams.courseVariantId = '';
							batchStore.getProxy().extraParams.courseVariantId = '';
							periodStore.getProxy().extraParams.courseVariantId = '';
							sectionStore.getProxy().extraParams.courseVariantId = '';
							studentNameNewFieldStore.getProxy().extraParams.courseVariantId = '';

							studentNameNewFieldStore.getProxy().extraParams.programId = '';
							studentNameNewFieldStore.getProxy().extraParams.batchId = '';
							studentNameNewFieldStore.getProxy().extraParams.periodId = '';
							studentNameNewFieldStore.getProxy().extraParams.sectionId ='';
							if(record[0].get("sectionType") == 'ProgramBatchSection') {
								programStore.load();
							} else {
								programComboBox.setDisabled(true);
								batchComboBox.setDisabled(true);
								periodField.setDisabled(true);
								sectionComboBox.setDisabled(true);
							}
							courseVarientStore.load({
								callback : function(records,operation,success) {
									if (success) {
										courseVarientField.reset();
										if(records.length == 1){
											courseVarientField.setValue(records[0].data.id);
										}	
									}

								}
							});
							studentNameNewFieldStore.load();

							var topicStore = this.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic');
							topicStore.getProxy().extraParams.courseId = courseId;
							topicStore.load();

							var assignmentStore = this.getStore('coursetransaction.homework.AssignmentNameDropDown');
							assignmentStore.getProxy().extraParams.courseId = courseId;
							assignmentStore.load();
						}
					},
					'homeworkassignmentsearch combo#courseVarient_Id':{
						select : function(obj, record) {
							$this = this;
							var form = obj.up('form');
							var courseVariantId = record[0].get("id");

							var programComboBox = form.down('combo#programId');
							var batchComboBox = form.down('combo#batchId');
							var periodField=form.down('combo#periodId');
							var sectionComboBox = form.down('combo#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');

							programComboBox.reset();
							programComboBox.clearValue();
							var programStore = programComboBox.getStore();

							batchComboBox.reset();
							batchComboBox.clearValue();
							batchComboBox.setDisabled(true);
							var batchStore = batchComboBox.getStore();

							periodField.reset();
							periodField.clearValue();
							periodField.setDisabled(true);
							var periodStore = periodField.getStore();

							sectionComboBox.reset();
							sectionComboBox.clearValue();
							sectionComboBox.setDisabled(true);
							var sectionStore = sectionComboBox.getStore();

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}
							studentNameNewFieldStore.getProxy().extraParams.courseVariantId = courseVariantId;
							studentNameNewFieldStore.getProxy().extraParams.programId = '';
							studentNameNewFieldStore.getProxy().extraParams.batchId = '';
							studentNameNewFieldStore.getProxy().extraParams.periodId = '';
							studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

							if(record[0].get("sectionType") == 'ProgramBatchSection') {
								programStore.getProxy().extraParams.courseVariantId = courseVariantId;
								batchStore.getProxy().extraParams.courseVariantId = courseVariantId;
								periodStore.getProxy().extraParams.courseVariantId = courseVariantId;
								sectionStore.getProxy().extraParams.coursVariantId = courseVariantId;
								programStore.load({
									callback: function(records, operation, success) {
										if (success) {
											programComboBox.setValue(records[0].get("id"));
											batchStore.getProxy().extraParams.programId = records[0].get("id");
											batchStore.load({
												callback: function(records, operation, success) {
													if (success) {
														batchComboBox.setDisabled(false);
														batchComboBox.setValue(records[0].get("id"));
														periodStore.getProxy().extraParams.batchId = records[0].get("id");
														periodStore.load({
															callback: function(records, operation, success) {
																if (success) {
																	periodField.setDisabled(false);
																	sectionComboBox.setDisabled(false);
																	periodField.setValue(records[0].get("id"));
																	sectionStore.getProxy().extraParams.periodId = records[0].get("id");
																	sectionStore.load({
																		callback: function(records, operation, success) {
																			if (success) {
																				studentNameNewFieldStore.getProxy().extraParams.sectionId = records[0].get("sectionId");
																				sectionComboBox.setDisabled(false);
																				sectionComboBox.setValue(records[0].get("sectionId"))
																			}
																		}
																	});
																}
															}
														});
													}
												}
											});
										}
									}
								});
							}
							var assignmentStore = this.getStore('coursetransaction.homework.AssignmentNameDropDown');
							assignmentStore.getProxy().extraParams.courseVariantId = courseVariantId;
							assignmentStore.load(); 
						}
					},
					'homeworkassignmentsearch combo#programId' : {
						select : function(obj, record) {
							$this = this;
							var form = obj.up('form');
							var programId = record[0].get("id");
							var batchComboBox = form.down('combo#batchId');
							var periodField=form.down('combo#periodId');
							var programCoursection_ID = form.down('#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');

							batchComboBox.reset();
							batchComboBox.clearValue();
							batchComboBox.setDisabled(false);
							var batchStore = batchComboBox.getStore();

							periodField.reset();
							periodField.clearValue();
							periodField.setDisabled(true);
							var periodStore = periodField.getStore();


							programCoursection_ID.reset();
							programCoursection_ID.setDisabled(true);

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();
							studentNameNewFieldStore.getProxy().extraParams.programId = programId;
							studentNameNewFieldStore.getProxy().extraParams.batchId = '';
							studentNameNewFieldStore.getProxy().extraParams.periodId = '';
							studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

							periodField.reset();

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}

							batchStore.getProxy().extraParams.programId = programId;

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}

							batchComboBox.getStore().load({
								callback: function(records, operation, success) {
									if (success) {
										var batchId = 0;
										if(records.length == 1) {
											batchId = records[0].data.id;
											batchComboBox.setValue(batchId);
											studentNameNewFieldStore.getProxy().extraParams.batchId = batchId;
											studentNameNewFieldStore.getProxy().extraParams.periodId = '';
											studentNameNewFieldStore.getProxy().extraParams.sectionId ='';
											periodField.enable();
											var storePeriod = periodField.getStore();
											storePeriod.getProxy().extraParams.batchId = batchId;

											storePeriod.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length==0){
															if(wheatherSchool) {
																showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
															}
														}else if(records.length == 1){
															periodField.setValue(records[0].data.id);
															var period_Id = records[0].data.id;
															var academyLocationId = $this.getCurrentAcademyLocation();

															var studentNameNewFieldStore = studentNameNewField.getStore();
															studentNameNewFieldStore.getProxy().extraParams.periodId = period_Id;
															studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

															programCoursection_ID.setDisabled(false);
															var store = programCoursection_ID.getStore();
															store.getProxy().extraParams.periodId = period_Id;
															store.load();

														}else{
															$this.getHomeworkassignmentsearch().down('#periodId').setVisible(true);
															if (wheatherSchool) {

															} else {
																$this.getHomeworkassignmentsearch().down('#periodId').setDisabled(false);
															}
														}
													}	 										
												}	   
											});
										}
									}
								}	  
							});
						}
					},
					'homeworkassignmentsearch combo#batchId' : {
						select : function(obj, record) {
							var $this = this;
							$this.getHomeworkassignmentsearch().down('#periodId').reset();
							var batch_Id = record[0].get("id");
							var form = obj.up('form');

							var periodField=form.down('combo#periodId');
							var programCoursection_ID = form.down('#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool) {
								periodField.setVisible(false);
							}
							periodField.setDisabled(false);

							programCoursection_ID.reset();
							programCoursection_ID.clearValue();
							programCoursection_ID.setDisabled(true);

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();
							studentNameNewFieldStore.getProxy().extraParams.batchId = batch_Id;
							studentNameNewFieldStore.getProxy().extraParams.periodId = '';
							studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

							var studentId=null;
							var periodStore = periodCombo.getStore();
							periodStore.getProxy().extraParams.batchId = batch_Id;
							periodStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 0){
											if(wheatherSchool){
												showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
												$this.getHomeworkassignmentsearch().down('#periodId').setVisible(false);
											}else {
												$this.getHomeworkassignmentsearch().down('#periodId').setDisabled(false);
											}
										}
										else if(records.length == 1){
											sectionComboBox.setDisabled(false);
											periodCombo.setValue(records[0].data.id);
											if(wheatherSchool) {
												$this.getHomeworkassignmentsearch().down('#periodId').setVisible(false);
											}else {
												$this.getHomeworkassignmentsearch().down('#periodId').setDisabled(false);
											}
											studentNameNewFieldStore.getProxy().extraParams.periodId = records[0].data.id;
											studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

											var store = programCoursection_ID.getStore();
											store.getProxy().extraParams.periodId = records[0].data.id;
											store.load();
										}else{
											$this.getHomeworkassignmentsearch().down('#periodId').setVisible(true);
											$this.getHomeworkassignmentsearch().down('#periodId').setDisabled(false);
										}		 
									}

								}	   
							});

						}
					},
					'homeworkassignmentsearch combo#periodId' : {
						select : function(obj, record) {
							var period_Id = record[0].get("id");
							var form = obj.up('form');

							var programCoursection_ID = form.down('#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();
							studentNameNewFieldStore.getProxy().extraParams.periodId = period_Id;
							studentNameNewFieldStore.getProxy().extraParams.sectionId ='';

							programCoursection_ID.clearValue();
							programCoursection_ID.setDisabled(false);
							var store = programCoursection_ID.getStore();
							store.getProxy().extraParams.periodId = period_Id;
						}
					},
					'homeworkassignmentsearch combo#programCoursection_ID' : {
						select : function(obj, record) {
							var sectionId = record[0].get("id");
							var form = obj.up('form');

							var programCoursection_ID = form.down('#programCoursection_ID');
							var studentNameNewField = form.down('[name=studentNameNew]');

							studentNameNewField.reset();
							studentNameNewField.clearValue();
							var studentNameNewFieldStore = studentNameNewField.getStore();
							studentNameNewFieldStore.getProxy().extraParams.sectionId = sectionId;
						}
					},
					'studenthomeworkassignmentsearch': {
						render : function(form) {
							var $this = this;
							var academyLocationId = this.getCurrentAcademyLocation();
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							
							programFilter.reset();
							batchFilter.reset();
							periodFilter.reset();
							sectionFilter.reset();
							courseFilter.reset();
							courseVariantFilter.reset();

							batchFilter.setDisabled(true);
							periodFilter.setDisabled(true);
							sectionFilter.setDisabled(true);
							courseFilter.setDisabled(true);
							courseVariantFilter.setDisabled(true);

							if(wheatherSchool){
								periodFilter.hide();
							}

							/*Comment Out Above code Because of program was come from admsission
							 * it was not correct now it comes from program Batch student */
							var studentprogramId = studentPortalInfo.programBatchDetails.programId;
							var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
							var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
							var studentId=studentPortalInfo.student.id;

							var programStore = programFilter.getStore();
							
							//----Student AL Field
							
							var studentALField = form.down("#studentAcademyLocation");
					    	var studentALStore = studentALField.getStore();

					    	var portalId = $this.getCurrentLoggedPortalId();
					    	var currentALId = $this.getCurrentAcademyLocation();
					    	
					    	if(portalId==7){
					    		var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
					    		var admissionDetails=portalInfo.admissionDetails;
					    	} else {
					    		var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
					    		var admissionDetails=portalInfo.admissionDetails;
					    	}

					    	var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

					    	studentALStore.getProxy().extraParams = {
					    		admissionIds:admissionIds
					    	};
							
							studentALStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length > 0){
											studentALField.setValue(currentALId);
											
											programStore.getProxy().extraParams = {
												studentId: studentId,
												onlyCurrentRecord:false,
												academyLocationId:currentALId
											};

											programStore.load({
												callback: function(records, operation, success) {
													if (success) {
														for(var i in records){
															if(records[i].data.id == studentprogramId){
																programFilter.setValue(records[i].data.id);
															} else if (records.length == 1) {
																programFilter.setValue(records[i].data.id);
															}
														}
													}
												}
											});
										}
									}
								}
							});
						}
					},
					'studenthomeworkassignmentsearch combo#studentAcademyLocation': {
						select: function(combo, records, eOpts) {
							var this$ = this;
							var form = combo.up('studenthomeworkassignmentsearch');
							var selectedAL = combo.getValue();
							
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var studentprogramId = studentPortalInfo.programBatchDetails.programId;
							var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
							var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
							var studentId=studentPortalInfo.student.id;

							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var assignmentType = form.down('#studentAassignmentTypeId');
							var assignmentName = form.down('#studentAssignmentNameId');

							programFilter.reset();
							batchFilter.reset();
							periodFilter.reset();
							sectionFilter.reset();
							courseFilter.reset();
							courseVariantFilter.reset();
							assignmentType.reset();
							assignmentName.reset();

							batchFilter.setDisabled(false);
							periodFilter.setDisabled(true);
							sectionFilter.setDisabled(true);
							courseFilter.setDisabled(true);
							courseVariantFilter.setDisabled(true);
							assignmentType.setDisabled(true);
							assignmentName.setDisabled(true);

							if(selectedAL > 0) {
								var programComboStore=programFilter.getStore();
								
								programComboStore.getProxy().extraParams = {
									studentId: studentId,
									onlyCurrentRecord:false,
									academyLocationId:selectedAL
								};

								programComboStore.load({
									callback: function(records, operation, success) {
										if (success) {
											for(var i in records){
												if(records[i].data.id == studentprogramId){
													programFilter.setValue(records[i].data.id);
												} else if (records.length == 1) {
													programFilter.setValue(records[i].data.id);
												}
											}
										}
									}
								});
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentProgramId': {
						change: function(obj, record) {
							var programId = obj.value;
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var studentprogramId = studentPortalInfo.programBatchDetails.programId;
							var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
							var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
							var studentId=studentPortalInfo.student.id;

							var form = obj.up('form');
							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var assignmentType = form.down('#studentAassignmentTypeId');
							var assignmentName = form.down('#studentAssignmentNameId');

							batchFilter.reset();
							periodFilter.reset();
							sectionFilter.reset();
							courseFilter.reset();
							courseVariantFilter.reset();
							assignmentType.reset();
							assignmentName.reset();

							batchFilter.setDisabled(false);
							periodFilter.setDisabled(true);
							sectionFilter.setDisabled(true);
							courseFilter.setDisabled(true);
							courseVariantFilter.setDisabled(true);
							assignmentType.setDisabled(true);
							assignmentName.setDisabled(true);

							if(programId > 0) {
								var batchComboStore=batchFilter.getStore();
								batchComboStore.getProxy().extraParams = {
									studentId: studentId,
									onlyCurrentRecord:false,
									programId:programId
								};
								batchComboStore.load({
									callback: function(records, operation, success) {
										if (success) {
											for(var i in records){
												if(records[i].data.id == studentbatchId){
													batchFilter.setValue(records[i].data.id);
												} else if (records.length == 1) {
													batchFilter.setValue(records[i].data.id);
												}
											}
										}
									}
								});
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentBatchId': {
						change: function(obj, record) {
							var batchId = obj.value;
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var studentprogramId = studentPortalInfo.programBatchDetails.programId;
							var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
							var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
							var studentId=studentPortalInfo.student.id;

							var form = obj.up('form');
							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var assignmentType = form.down('#studentAassignmentTypeId');
							var assignmentName = form.down('#studentAssignmentNameId');

							periodFilter.reset();
							sectionFilter.reset();
							courseFilter.reset();
							courseVariantFilter.reset();
							assignmentType.reset();
							assignmentName.reset();

							periodFilter.setDisabled(false);
							sectionFilter.setDisabled(true);
							courseFilter.setDisabled(true);
							courseVariantFilter.setDisabled(true);
							assignmentType.setDisabled(true);
							assignmentName.setDisabled(true);

							if(batchId > 0) {
								var periodComboStore=periodFilter.getStore();
								periodComboStore.getProxy().extraParams = {
									studentId: studentId,
									onlyCurrentRecord:false,
									batchId:batchId
								};
								periodComboStore.load({
									callback: function(records, operation, success) {
										if (success) {
											for(var i in records){
												if(records[i].data.id == studentperiodId){
													periodFilter.setValue(records[i].data.id);
												} else if (records.length == 1) {
													periodFilter.setValue(records[i].data.id);
												}
											}
										}
									}
								});
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentPeriodId': {
						change: function(obj, record) {
							var $this = this;
							var periodId = obj.value;
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var studentprogramId = studentPortalInfo.programBatchDetails.programId;
							var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
							var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
							var studentId=studentPortalInfo.student.id;

							var form = obj.up('form');
							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var assignmentType = form.down('#studentAassignmentTypeId');
							var assignmentName = form.down('#studentAssignmentNameId');

							sectionFilter.reset();
							courseFilter.reset();
							courseVariantFilter.reset();
							assignmentType.reset();
							assignmentName.reset();

							sectionFilter.setDisabled(false);
							courseFilter.setDisabled(false);
							courseVariantFilter.setDisabled(true);
							assignmentType.setDisabled(true);
							assignmentName.setDisabled(true);
							if(periodId > 0) {
								$this.loadHomeWork();
								var sectionFilterStore=sectionFilter.getStore();
								sectionFilterStore.getProxy().extraParams = {
									studentId: studentId,
									onlyCurrentRecord:false,
									periodId:periodId
								};
								sectionFilterStore.load();

								var courseFilterStore=courseFilter.getStore();
								courseFilterStore.getProxy().extraParams = {
									studentId: studentId,
									isCurrentPeriod:false,
									periodId:periodId
								};
								courseFilterStore.load();
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentCourseId': {
						change: function(obj, record) {
							var courseId = obj.value;
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							var studentId=studentPortalInfo.student.id;

							var form = obj.up('form');
							var assignmentType="";
							var programFilter = form.down('#studentProgramId');
							var batchFilter = form.down('#studentBatchId');
							var periodFilter = form.down('#studentPeriodId');
							var sectionFilter = form.down('#studentSectionId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							var assignmentTypeValue = form.down('#studentAassignmentTypeId');
							if(!isNullOrEmpty(assignmentTypeValue.getStore().findRecord("id", assignmentTypeValue.getValue()))){
								assignmentType=assignmentTypeValue.getStore().findRecord("id", assignmentTypeValue.getValue()).data.value;
							}
							
							var assignmentName = form.down('#studentAssignmentNameId');

							courseVariantFilter.reset();
							assignmentName.reset();

							courseVariantFilter.setDisabled(false);
							assignmentTypeValue.setDisabled(false);
							assignmentName.setDisabled(false);

							if(courseId > 0) {
								var courseVariantStore=courseVariantFilter.getStore();
								courseVariantStore.getProxy().extraParams = {
									studentId: studentId,
									isCurrentPeriod:false,
									periodId:periodFilter.getValue(),
									courseId:courseId
								};
								courseVariantStore.load({
									callback : function(records,operation,success) {
										if (success) {
											if(records.length == 1){
												courseVariantFilter.setValue(records[0].data.id);
											}	
										}

									}
								});

								var assignmentNameStore=assignmentName.getStore();
								assignmentNameStore.getProxy().extraParams = {
									courseId:courseId,
									assignmentType:assignmentType
								};
								assignmentNameStore.load();
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentCourseVarientId': {
						change: function(obj, record) {
							var courseVariantId = obj.value;
							var form = obj.up('form');
							var assignmentType="";
							var courseFilter = form.down('#studentCourseId');
							var assignmentTypeValue = form.down('#studentAassignmentTypeId');
							if(!isNullOrEmpty(assignmentTypeValue.getStore().findRecord("id", assignmentTypeValue.getValue()))){
								assignmentType=assignmentTypeValue.getStore().findRecord("id", assignmentTypeValue.getValue()).data.value;
							}
							var assignmentName = form.down('#studentAssignmentNameId');
							assignmentName.reset();
							if(courseVariantId > 0) {
								var assignmentNameStore=assignmentName.getStore();
								assignmentNameStore.getProxy().extraParams = {
									courseId:courseFilter.getValue(),
									courseVariantId:courseVariantId,
									assignmentType:assignmentType

								};
								assignmentNameStore.load();
							}
						}
					},
					'studenthomeworkassignmentsearch combo#studentAassignmentTypeId': {
						change: function(obj, record) {
							var assignmentType = "";
							if(!isNullOrEmpty(obj.getStore().findRecord("id", obj.value))){
								assignmentType=obj.getStore().findRecord("id", obj.value).data.value;
							}
							var form = obj.up('form');
							var assignmentName = form.down('#studentAssignmentNameId');
							var courseFilter = form.down('#studentCourseId');
							var courseVariantFilter = form.down('#studentCourseVarientId');
							assignmentName.reset();
							var assignmentNameStore=assignmentName.getStore();
							assignmentNameStore.getProxy().extraParams = {
								courseId:courseFilter.getValue(),
								courseVariantId:courseVariantFilter.getValue(),
								assignmentType:assignmentType
							};
							assignmentNameStore.load();
						}
					},
					'studenthomeworkassignmentsearch button[itemId=searchBtn]': {
						click: function(btn){
							var me = this;
							me.getSearchresultgrid().show();
							var searchResultGrid = this.getSearchresultgrid();
	                		searchResultGrid.down('#submitAssignmentDocument').setDisabled(true)
							me.loadHomeWork(btn);
						}
					},
					'studenthomeworkassignmentsearch button[itemId=resetBtn]': {
						click: this.resetStudentHomeWork
					},


					'assignmentdetails combo#faculty_Id' : {
						select : function(obj, record) {
							var $this = this;
							var facultyId = record[0].get("id");
							var form=this.getAssignmentdetails().getForm();
							var sectionId=form.findField('sectionId').getValue();
							var courseVarientCombo = form.findField('courseVariantId');
							courseVarientCombo.clearValue();
							this.topicsAvailabiltiy(facultyId,sectionId);
							courseVarientCombo.setDisabled(false);
							var courseVarientStore = courseVarientCombo.getStore();

							courseVarientStore.getProxy().extraParams.facultyId = facultyId;
							courseVarientStore.getProxy().extraParams.academyLocationIds= $this.getCurrentAcademyLocation();
							courseVarientStore.load({
								callback : function(records,operation,success) {
									if (success) {
										courseVarientCombo.reset();
										if(records.length == 1){
											courseVarientCombo.setValue(records[0].data.id);
											courseVarientCombo.setValue(records[0].data.id);
											var courseVariantId = records[0].get("id");
											var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualStore');
											store.getProxy().extraParams = {	
												courseVariantId: courseVariantId
											}
											store.load();
											$this.topicsAvailabiltiy(facultyId);
										}	
									}

								}
							});
						}
					},
					'assignmentdetails radiogroup[itemId=assignmentType_Id]': {
						change:function(o,r){
							this.assignmentTypeChange(o,r);
						}
					},
					'assignmentdetails radiogroup[itemId=topicType_ID]': {
						change:function(o,r){
							this.topicsAvailabiltiyChange(o,r);
						}
					},
					'assignmentdetails combo[itemId=courseId]': {
						select:function(obj,record){
							// var assignmentType = record[0].get("value");
							var $this = this;
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var whetherSchool = alinfomodel.get('wheatherSchool');
							var form = this.getAssignmentdetails();
							var values = form.getForm().getValues();
							var courseId = record[0].data.courseId;
							var courseComponentId = record[0].data.courseComponentId
							var sectionComponentLevel = record[0].data.sectionAtComponentLevel;
							var courseVarientCombo = form.down('#courseVariant_Id');
							var courseVarientStore = courseVarientCombo.getStore();//this.getStore('course.coursevariants.CourseVariantStore');
							var selectAssignmentType = form.down("#assignmentType_Id").getValue();   //form.down('#assignmentType_Id')
							var allGrid = null;
							if(this.getAssigndetailsallgrid().itemId == "assignAllGrid_Id" && selectAssignmentType.assignmentType == "all"){
								allGrid = this.getAssigndetailsallgrid();
							}
							if(this.getAssigndetailsgroupgrid().itemId == "groupGrid_Id" && selectAssignmentType.assignmentType == "group"){
								allGrid = this.getAssigndetailsgroupgrid();
							}
							if(this.getAssigndetailsindividualgrid().itemId == "individualGrid_Id"  && selectAssignmentType.assignmentType == "individual"){
								allGrid = this.getAssigndetailsindividualgrid();
							}
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId == 2) {
								var facultyId = this.getCurrentlyLoggedInUser().id;
								courseVarientCombo.setDisabled(false);
								courseVarientStore.getProxy().extraParams = {	
									courseId: courseId,
									sectionAtComponentLevel: sectionComponentLevel,
									page:null,
									facultyId: facultyId,
									whetherSchool : whetherSchool,
									isCurrentPeriod: true,
									academyLocationIds: $this.getCurrentAcademyLocation()
								};
								courseVarientStore.load({
									callback : function(records,operation,success) {
										if (success) {
											courseVarientCombo.reset();
											if(records.length == 1){
												courseVarientCombo.setValue(records[0].data.id);
												var courseVariantId = records[0].get("id");
												var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualStore');
												store.getProxy().extraParams = {	
													courseVariantId: courseVariantId
												}
												store.load();
												$this.topicsAvailabiltiy(facultyId);
											}	
										}

									}
								});
							} else {
								var facultyCombo= $this.getAssignmentdetails().down('combo#faculty_Id');
								facultyCombo.setDisabled(false);
								facultyCombo.reset();
								facultyCombo.clearValue();
								courseVarientCombo.setDisabled(true);
								courseVarientCombo.reset();
								courseVarientCombo.clearValue();
								courseVarientStore.getProxy().extraParams = {	
									courseId: courseId,
									page:null,
									isCurrentPeriod: true
								};
								var facultyStore = facultyCombo.getStore();
								facultyStore.getProxy().extraParams = {
									courseId: courseId,
									isCurrentPeriod: true,
									academyLocationIds: $this.getCurrentAcademyLocation()
								};
								facultyStore.load({
									callback: function(records, operation, success) {
										if (success) {
											if(records.length == 1){
												facultyCombo.setValue(records[0].data.id);
												courseVarientCombo.setDisabled(false);
												courseVarientStore.getProxy().extraParams = {	
													courseId: courseId,
													sectionAtComponentLevel: sectionComponentLevel,
													page:null,
													facultyId: facultyCombo.getValue(),
													whetherSchool : whetherSchool,
													isCurrentPeriod: true,
													academyLocationIds: $this.getCurrentAcademyLocation()
												};

												courseVarientStore.load({
													callback : function(records,operation,success) {
														if (success) {
															courseVarientCombo.reset();
															if(records.length == 1){
																courseVarientCombo.setValue([records[0].data.id]);
																courseVarientCombo.setValue([records[0].data.id]);
																$this.topicsAvailabiltiy(facultyCombo.getValue());
															}	
														}

													}
												});
											}		 
										}
									}	   
								});
							}

				        	var topicsAvailCombo= $this.getAssignmentdetails().down('multiselectcombofield#hw_topicsAvailabilty_id');
				        	topicsAvailCombo.clearValue();
								 
				        	var topicAvailStore = topicsAvailCombo.getStore();
				        	topicAvailStore.getProxy().extraParams = {	
						    	 courseId: courseId,
						    	 componentId : courseComponentId
		                     };
						     topicAvailStore.load();	     
							var assignmentTypeRadioGroup = form.down("#assignmentType_Id");
							assignmentTypeRadioGroup.down('[inputValue=all]').setDisabled(false);
							assignmentTypeRadioGroup.down('[inputValue=group]').setDisabled(false);
							assignmentTypeRadioGroup.down('[inputValue=individual]').setDisabled(false);

						}
					},

					'assignmentdetails radiogroup#sendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadStudentScheduleField(radio, newValue, oldValue);
						}
					},

					'assignmentdetails checkboxfield#configureNotificationId': {
						change: function( checkboxfield, newValue, oldValue, eOpts) {
							this.showSendingPriorityField(checkboxfield, newValue, oldValue);
						}
					},
					'assignmentdetails combo#evaluationPlanId_Id' : {
						change : function(obj, record) {
							var evaluationPlanId = obj.value;
							var forms = this.getAssignmentdetails();
							var evaludationDetailSequenceCombo = forms.down('#evaludationDetailSequenceId_Id');
							var assignmentId = forms.getForm().findField('id').getValue();
							var courseVariantValue = forms.down('#courseVariant_Id').getValue();
							var allCvs = [];
							Ext.each(courseVariantValue,function(currentCV){
								if(typeof currentCV=="number"){
									allCvs.push(currentCV);
								}else if(typeof currentCV == "object"){
									allCvs.push(currentCV.data.id);
								}
							});
							var courseVariantIds = allCvs.join();
							if(evaluationPlanId > 0) {
								evaludationDetailSequenceCombo.setDisabled(false);
								var store = evaludationDetailSequenceCombo.getStore();
								store.getProxy().extraParams = {
									evaluationPlanId: evaluationPlanId,
									isAssignmentEvaluation:true,
									courseVariantIds:courseVariantIds,
									assignmentId:assignmentId

								};
								store.load({
									callback : function(records,operation,success) {
										if (success) {
											if(records.length == 1){
												evaludationDetailSequenceCombo.setValue([records[0].data.id]);
												evaludationDetailSequenceCombo.setValue([records[0].data.id]);
												forms.getForm().isValid();
												forms.getForm().clearInvalid();
											}	
										}
									}
								});	
							}
						}
					},
					//
					'searchresultgrid[itemId=homeworklistId] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
						click: function() {
							this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=exportToPdfBtn] #exportPdfAll': {
						click: function() {
							this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
						click: function() {
							this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
						}
					},
					'searchresultgrid[itemId=homeworklistId] button[itemId=exportToPdfBtn] #exportExcelAll': {
						click: function() {
							this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
						}
					},
					'documentformwindow[itemId=individualItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
						click: function(){
							var $this = this;
							var grid = $this.getAssigndetailsindividualgrid();
							var module = 'individualAssignment';
							var entityType = 'individualAssignment';
							$this.getUploadDocument(grid,module,entityType);
						}
					},
					'documentformwindow[itemId=groupItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
						click: function(){
							var $this = this;
							var grid = $this.getAssigndetailsgroupgrid();
							var module = 'groupAssignment';
							var entityType = 'groupAssignment';
							$this.getUploadDocument(grid,module,entityType);
							//this.groupUploadDocument();
						}
					},
					'documentformwindow[itemId=allAssignmentItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
						click: function(){
							var $this = this;
							var grid = $this.getAssigndetailsallgrid();
							var module = 'allAssignment';
							var entityType = 'allAssignment';
							$this.getUploadDocument(grid,module,entityType);
						}
					},
					'assigndetailsindividualgrid' : {
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var documentGrid = $this.getAssigndetailsindividualgrid();
							var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "documentName") {

								if (e.target.tagName == 'A') {

									var documentId = record.data.documentId;

									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
						}
					},
					'assigndetailsgroupgrid' : {
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {

							var $this = this;
							var documentGrid = $this.getAssigndetailsgroupgrid();
							var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "documentName") {

								if (e.target.tagName == 'A') {
									var documentId = record.get("documentId");
									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
						}
					},
					'assigndetailsallgrid' : {
						render : function(grid) {				  
							grid.getStore().removeAll();
							grid.getStore().loadData([])
						},
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var documentGrid = $this.getAssigndetailsallgrid();
							var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "documentName") {
								if (e.target.tagName == 'A') {
									var documentId = record.get("documentId");
									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
						}
					},
					'documentformwindow[itemId=homeworkAssignmentSubmissionMultipleDocument] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]' : {
						click : function() {
							this.addMultipleAssignmentDocument();
						}
					},
					'homeworkassignmentdocumentgrid button#btnDelete' : {
						click : function() {
							var $this = this;
							var grid = $this.getHomeworkassignmentdocumentgrid();
							var windowForm = $this.getUploadstudenthomeworkassignmentdocument();
							if (grid.getSelectionModel().getCount() > 0) {
								showConfirmMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
										function(btn,text) {
									if (btn == 'yes') {
										var store = grid.getStore();
										var record = grid.getSelectionModel().getSelection()[0];
										var id = record.get("id");
										if(record){
											store.remove(record);
											getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS')
											if(store.data.items.length==0){
												windowForm.down('#saveBtn').setDisabled(true);
												windowForm.down('#submitBtn').setDisabled(true);
											}
										}
									}
								});
							} else {
								showWarningMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
							}
						}
					},

					'uploadstudenthomeworkassignmentdocument  button[itemId=uploadDocument]':{
						click : function() {
							var $this = this;
							$this.getDocumentController().showDocumentFormWindow('homeworkAssignmentSubmissionMultipleDocument', 'DOCUMENT');
						}
					},
					'uploadstudenthomeworkassignmentdocument  button[itemId=cancelBtn]':{
						click : function() {
							this.getUploadstudenthomeworkassignmentdocument().close(); 
						}
					},
					'uploadstudenthomeworkassignmentdocument button[itemId=saveBtn]':{
						click : function() {
							var $this = this;
							$this.saveHomeworkAssignmentMultipleDocument();
						}
					},
					'uploadstudenthomeworkassignmentdocument button[itemId=submitBtn]':{
						click : function() {
							var $this = this;
							var portalId = this.getCurrentLoggedPortalId();
							var submissiondetailsgrid=null;
							var uploadedBy=null;
							var status=null;
							var resubmissionDate=null;
							var winForm=$this.getUploadstudenthomeworkassignmentdocument();
							var homeWorkAssignmentStatus=winForm.down("#status").getValue();
							var grid = this.getSearchresultgrid();
							var selectedRecord = grid.getSelectionModel().getSelection()[0]; 
							var resubmissionDueDate=selectedRecord.data.RESUBMISSION_DUE_DATE_LONG;
				    		if(!isNullOrEmpty(homeWorkAssignmentStatus) && homeWorkAssignmentStatus=="Resubmitted"){
				    			status=homeWorkAssignmentStatus;
				    		}
				    		if(portalId==3 || portalId==7){
				    			uploadedBy="student";

				    			if(!isNullOrEmpty(resubmissionDueDate)){
				    				status="Resubmitted";
				    			}

				    		}else{
				    			uploadedBy="faculty";
				    			var assignmentdetailsFormValue = this.getAssignmentdetails().getForm().getValues();
								var hideIdentity = assignmentdetailsFormValue.hideIdentityRadio_ID;
				    			if(portalId==2 && hideIdentity){
				    				submissiondetailsgrid = $this.getSubmissiondetailsgridnew();
				    			}else{
				    				submissiondetailsgrid = $this.getSubmissiondetailsgrid();
				    			}
				    			var selectedRecord = submissiondetailsgrid.getSelectionModel().getSelection()[0]; 
				    			var resubmissionDueDate=selectedRecord.data.resubmissionDueDate;
				    			if(!isNullOrEmpty(resubmissionDueDate)){
				    				status="Resubmitted";
				    			}

				    			if(submissiondetailsgrid.isVisible()==false){
				    				var submissiondetailsgrid=this.getSubmissiondetailsgridnew();
				    			}
				    		}
							var searchgrid = $this.getSearchresultgrid();
							
							var grid=winForm.down('#homeworkassignmentdocumentgridItemId');
							var docStore=grid.getStore();
							var docArray = [];
							if (docStore.data.items != null && docStore.data.items.length > 0) {
								Ext.each(docStore.data.items, function(val) {
									var newData = {
											"name" : val.data.documentName,
											"path" : val.data.path,
											"type" : "DOCUMENT",
											"submissionDate":Ext.Date.format(new Date(val.data.submissionDate), CONSTANTS.NEW_SUBMIT_DATE_TIME_FORMAT)
									};
									docArray.push(newData);
								});
							}
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var id = winForm.down('#groupHwAssignmentId').getValue();
							winForm.down('#submitBtn').setDisabled(true);
							Ext.Ajax.request({
								type : 'rest',
								url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
								method : 'GET',
								async: false,
								success : function(form, action) {
									var data = Ext.JSON.decode(form.responseText);
									var todayDate = data.serverDateTimeYYYYMMDD;
									if(status=="Resubmitted"){
										resubmissionDate=todayDate;
									}
									var data = {
											"id": id,
											"docType": "SUBMITED_DOC",
											"submissionStatus": isNullOrEmpty(status) ?"Submitted":status,
											"submissionDate": todayDate,
											"resubmissionDate": resubmissionDate,
											"documents": docArray,
											"uploadedBy":uploadedBy
									};
									Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.HW_SUMBMISSION_SUBMIT_DOCUMENTS,
										jsonData : data,
										method : 'POST',
										success : function(response, action) {
											Ext.getBody().unmask();
											showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getPersonModuleTranslation('ASSIGNMENT_SUBMITTED_SUCCESSFULLY'));
											winForm.down('#submitBtn').setDisabled(false);
											if(!isNullOrEmpty(submissiondetailsgrid)){
												submissiondetailsgrid.getStore().load();
												submissiondetailsgrid.getSelectionModel().deselectAll(true);  
											}else{
												searchgrid.getStore().load();
												searchgrid.getSelectionModel().deselectAll(true);
											}
											winForm.close();
										}
									});	

								}});
						}
					},
					'submissiondetailsgrid':{
						render: function(grid){
							var me = this;
							if(portalId==1){
								var gridStore = grid.getStore();
								gridStore.on('load', function(){
									var submissiondetailgrid = me.getSubmissiondetailsgrid();
									if(submissiondetailgrid.isVisible()==false){
										var submissiondetailgrid=me.getSubmissiondetailsgridnew();
									}
									var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
									var hideIdentity = assignmentdetailsFormValue.hideIdentityRadio_ID;
									if(!hideIdentity){
										Ext.each(submissiondetailgrid.columns,function(currentColumn){
											if(currentColumn.dataIndex=="randomNumber"){
												currentColumn.hide();
											}
										});
									}
									else{
										Ext.each(submissiondetailgrid.columns,function(currentColumn){
											if(currentColumn.dataIndex=="randomNumber"){
												currentColumn.show();
											}
										});
									}
								});
							}
							else if(portalId==3 || portalId==7){
								var gridStore = grid.getStore();
								gridStore.on('load', function(){
									var submissiondetailgrid = me.getSubmissiondetailsgrid();
									Ext.each(submissiondetailgrid.columns,function(currentColumn){
										if(currentColumn.dataIndex=="randomNumber"){
											currentColumn.destroy();;
										}
									});
								});
							}
							else{

							}
						}
					},
					'evaluationdetailsgrid':{
						render: function(grid){
							var me = this;
							var assignmentdetailsFormValue = me.getAssignmentdetails().getForm().getValues();
							var assignmentType = assignmentdetailsFormValue.assignmentType;
							var portalId=me.getCurrentLoggedPortalId();
							if(assignmentType == 'group') {
								grid.down('[dataIndex=groupName]').show();
							} else {
								grid.down('[dataIndex=groupName]').hide();
							}
							if(portalId==1){
								var hideIdentity = assignmentdetailsFormValue.hideIdentityRadio_ID;
								var gridStore = grid.getStore();
							}
							else if(portalId==3 || portalId==7){
								grid.down('#btnEdit').setVisible(false);
								if(assignmentdetailsFormValue.isEvaluationRequired){
									grid.down('[dataIndex=eventName]').show();
								}
								var gridStore = grid.getStore();
								gridStore.on('load', function(){
									var evaluationdetailsgrid = me.getEvaluationdetailsgrid();
									Ext.each(evaluationdetailsgrid.columns,function(currentColumn){
										if(currentColumn.dataIndex=="randomNumber"){
											currentColumn.destroy();
										}
									});
								});
							}
						}
					},
					'groupsassignmentgrid radiogroup[itemId=sectionTypeId]' :{
						change : function(cb) {
							$this = this;
							var form = this.getGroupsassignmentgrid();
							var assginmentDetailsForm = this.getAssignmentdetails();
							var sectionType = cb.up('groupsassignmentgrid').down('#sectionTypeId').getValue();
							var groupNameField = form.down('#groupNameId');
							var courseVariantId = assginmentDetailsForm.down('#courseVariant_Id').getValue();
							var existingAssignmentgroupNameField = form.down('#existinAssignmentGroupNameId');
							groupNameField.reset();
							existingAssignmentgroupNameField.reset();
							if(sectionType.sectionType==="CREATE_GROUP_MANNUALLY"){
								groupNameField.setVisible(true); 
								existingAssignmentgroupNameField.setVisible(false);
								$this.setAllowBlank(groupNameField,false);
								$this.setAllowBlank(existingAssignmentgroupNameField,true);
								$this.showGroupAssignment();
							}else{
								groupNameField.setVisible(false); 
								existingAssignmentgroupNameField.setVisible(true);
								$this.setAllowBlank(groupNameField,true);
								$this.setAllowBlank(existingAssignmentgroupNameField,false);
								var groupgrid= Ext.ComponentQuery.query('form#groupAssignmentForm_Id');
								var gridColumns = groupgrid[0].down('#addAssignmentGroupNameId');
								gridColumns.getStore().removeAll();
								if(!isNullOrEmpty(courseVariantId)){
									$this.loadExisitingAssignmentGroupName(courseVariantId);

								}
							}
							form.down('#groupAssignmentForm_Id').getForm().checkValidity();
						}
					},
					'groupsassignmentgrid customcombobox[itemId=existinAssignmentGroupNameId]' :{
						select:function(combo, record){
							var form = combo.up('groupsassignmentgrid');
							var assignmentId = record[0].data.homeworkAssignmentId;
							if(assignmentId>0){
								this.showGroupOfStudentList(assignmentId);
							}
						}
					},
					'assignmentdetails button[itemId=generateBtnAssignment]': {
						  click: function(btn) {
							  btn.setDisabled(true);
							  btn.up('assignmentdetails').down('button[itemId=hwAssignment_Add]').setDisabled(true);
							  var assignmentForm = btn.up('form').getForm();
							  var ouput=assignmentForm.findField('description');
							  ouput.addCls('gpt-output');
							  ouput.reset();
							  var courseTopicId=new Array();
							  var courseTopicId =  assignmentForm.findField('courseTopicId').getValue();
		 			          var cTIds = [];
		 			          var courseTopicIds = null;
		 			          if (!isNullOrEmpty(courseTopicId) && courseTopicId.length > 0 && !isNullOrEmpty(courseTopicId[0])) {
		 			        	  for (var i in courseTopicId) {
		 			        		  if (Ext.isObject(courseTopicId[0])) {
		 			        			  if(Ext.isObject(courseTopicId[i]) && courseTopicId[i]!=""){
		 			        				  cTIds.push(courseTopicId[i].get("value"));
		 			        			  }else{
		 			        				  cTIds.push(courseTopicId[i]);
		 			        			  }
		 			        		  } else {
		 			        			  cTIds.push(courseTopicId[i]);
		 			        		  }
		 			        	  }
		 			        	  courseTopicIds = cTIds.join();
		 			          }else
		 			          {
		 			        	 courseTopicIds = courseTopicId;
		 			          }
		 			          
		 			          if(typeof courseTopicIds == "object" && courseTopicIds.length == 0){
		 			        	 courseTopicIds = "";
		 			          }
							  
							  var formValues = {
									  shortDescription:assignmentForm.findField('shortDescription').getValue(),
									  type:assignmentForm.findField('assignmentType').getValue().typeValue,
									  topics:courseTopicIds,
									  assignmentName:assignmentForm.findField('assignmentName').getValue()
							  }
							  var submitUrl = SERVERURL.PATH_GENERATE_ASSIGNMENT;
							  Ext.Ajax.request({
								  type: 'rest',
								  url: submitUrl,
								  params:formValues,
								  method: 'GET',
								  success: function(form, action) {
									  Ext.getBody().unmask();
									  ouput.removeCls('gpt-output');
									  ouput.setValue(form.responseText.trim());
									  btn.setDisabled(false);
									  if(assignmentForm.isValid()){
										 btn.up('assignmentdetails').down('button[itemId=hwAssignment_Add]').setDisabled(false);  
									  }
										
									//	 typeWriterAssignment(ouput, form.responseText.trim(), 0);
								  }
							  });
						  }
						},
						'assignmentdetails button[itemId=resetBtnAssignment]': {
							 click: function(btn) {
								 btn.up('form').down('#shortDescriptionItemId').reset();
							 }
						 },
							'assignmentdetails textfield[itemId=assignmentNameId]': {
								change: this.onChangeAssignmentNameTitle
							}
				});
			},
             resetHomeWork:function(btn){
            	 var $this = this;
            	 var homeworkassignmentsearch =btn.up('homeworkassignmentsearch');
            	 var homeworkassignmentsearchpanel = homeworkassignmentsearch.up('panel');
            	 homeworkassignmentsearch.destroy();
            	 homeworkassignmentsearchpanel.insert(0,{xtype:'homeworkassignmentsearch'});
             },
             resetStudentHomeWork:function(btn){
            	 var $this = this;
            	 var homeworkassignmentsearch =btn.up('studenthomeworkassignmentsearch');
            	 var homeworkassignmentsearchpanel = homeworkassignmentsearch.up('panel');
            	 homeworkassignmentsearch.destroy();
            	 homeworkassignmentsearchpanel.insert(0,{xtype:'studenthomeworkassignmentsearch'});
             },
             findHWStudentCount : function(record, grid, status){
            	 var $this = this;
            	 var assessmentIdentity;
         		var window =  this.getHwassignmentstudentdetailsgrid();
         		if (!window) {
         			Ext.widget('hwassignmentstudentdetailsgrid');
         			window = this.getHwassignmentstudentdetailsgrid();
         		}
         		//window.show();
         		var grid = window.down('grid');
         		var alinfomodel = Academia.model.authentication.ALInfoModel;
         		var wheatherSchool = alinfomodel.get('wheatherSchool');
         		if(wheatherSchool) {
         			//Hidden period column on window for school
         			grid.columns[4].hide();
         			grid.columns[4].setVisible(false);
         		}
         		
         		if(!isNullOrEmpty(record)){
         			var store = grid.getStore();
         			store.getProxy().extraParams = {
         				hwId: record.data.ID,
         				status:status,
         				limit:5
         			};
         			this.resetPageSetting(store);
         			
         			setTimeout(function(){
         				store.load({
             				callback: function(){
             	         		window.center();
             				}
             			});
        	    	},500);
         		}
         	},
         	openHWAssignmentForm : function(hwId,uId){
         		var assessmentIdentity;
         		var $this=this;
         		Ext.Ajax.request({
	           		   type : 'rest',
	          		   url : SERVERURL.HW_ASSIGNMENT_DETAILS_FINDBYID,
	          		   params : {
	          			 id : hwId,
	          		   },
	          		   method : 'GET',
	          		   success : function(frm, action) {
	          			  
	          			 assessmentIdentity= frm.responseText.split(",")[41].split(":")[1];
	          			$this.openHWAssignmentForm1(assessmentIdentity,uId);        
	          		   }
	          	   });	
         	
            },
         	openHWAssignmentForm1 : function(assessmentIdentity,uId){
         	
         		var userId = this.getCurrentlyLoggedInUser().id;
				if(assessmentIdentity=="true" && userId!='1'){
						this.getHwassignmentstudentdetailsgrid().down('hwassignmentgrid').setVisible(false);
						this.getHwassignmentstudentdetailsgrid().down('hwassignmentgridnew').setVisible(true);
					}
					else{
						this.getHwassignmentstudentdetailsgrid().down('hwassignmentgrid').setVisible(true);
						this.getHwassignmentstudentdetailsgrid().down('hwassignmentgridnew').setVisible(false);
					
					}
				var window =  this.getHwassignmentstudentdetailsgrid();
         		if (!window) {
         			Ext.widget('hwassignmentstudentdetailsgrid');
         			window = this.getHwassignmentstudentdetailsgrid();
         		}
         		window.show();
            },
         	    openAssignmentForm : function(){
            	 
            	 Academia.app.getController('Academia.controller.coursetransaction.homework.HomeworkEvaluationController');
            	 Academia.app.getController('Academia.controller.coursetransaction.homework.HomeworkSubmissionController');
            	 
            	 var $this = this;
            	 var contentpanel = this.getContentPanel();
            	 var assigncoursesId = Ext.widget('homeworkstructure');
            	 var tabName = getCourseTxCommonTranslation('HW_ASSIGNMENT_DETAILS');
            	 
            	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
            	 var getTab=getcontroller.getTab(tabName);
            	 if(getTab!=null){
            		 contentpanel.remove(getTab, true);
            	 }
            	 openTab(contentpanel, tabName, assigncoursesId,CONSTANTS.MENU_COLOR_ONE);
            	 var alinfomodel = Academia.model.authentication.ALInfoModel;
            	 var form=this.getAssignmentdetails().getForm();
            	 form.findField('noOfFile').setReadOnly(false);
            	 var store = this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualBlank');
				 store.removeAll();
				 store.loadRawData(null,true);
				 
				 var individualStore = this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualStore');
				 individualStore.removeAll();
             },
         		assignmentTypeChange:function(o,r){
         			var form = this.getAssignmentdetails();
         			var individualGrid=form.down('#individualGrid_Id');
         			individualGrid.hide();
         			var groupGrid=form.down('#groupGrid_Id')
         			groupGrid.hide();
         			var assignAllGrid=form.down('#assignAllGrid_Id')
         			assignAllGrid.hide();
         			var sectionType;
         			var sectionTypeCombo=this.getAssignmentdetails().down("#courseId");
         			var sectionTypeData=sectionTypeCombo.store.data.items;
         			for(i in sectionTypeData){
         				if(sectionTypeCombo.getValue() == sectionTypeData[i].data.courseId){
         					sectionType=sectionTypeData[i].data.sectionType
         				}
         			}
         			if(r.assignmentType == 'individual'){
         				individualGrid.show();
         				groupGrid.hide();
         				assignAllGrid.hide();
         				var permissionsMap = new Ext.util.HashMap();
         				 if(this.getCurrentLoggedPortalId()==2){
     				    	permissionsMap=this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     				    	this.doAccessControlValidation(individualGrid,this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }else{
     				    	permissionsMap=this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     					    this.doAccessControlValidation(individualGrid,this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }
    					this.disableMoreActionPivileges(individualGrid,permissionsMap);
         			}else if(r.assignmentType == 'group'){         				
         				groupGrid.show();
         				individualGrid.hide();
         				var permissionsMap = new Ext.util.HashMap();
         				 if(this.getCurrentLoggedPortalId()==2){
     				    	permissionsMap=this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     				    	this.doAccessControlValidation(groupGrid,this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }else{
     				    	permissionsMap=this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     					    this.doAccessControlValidation(groupGrid,this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }
    					this.disableMoreActionPivileges(groupGrid,permissionsMap);
         			}else if(r.assignmentType == 'all'){
         				assignAllGrid.show();         	  			
         				this.getAssigndetailsallgrid().getSelectionModel().selectAll();
         				individualGrid.hide();
         				groupGrid.hide();
         				var permissionsMap = new Ext.util.HashMap();
         				 if(this.getCurrentLoggedPortalId()==2){
     				    	permissionsMap=this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     				    	this.doAccessControlValidation(assignAllGrid,this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }else{
     				    	permissionsMap=this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
     					    this.doAccessControlValidation(assignAllGrid,this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
     				    }
         				 if(isNullOrEmpty(form.getForm().findField('id').getValue())) {
         					assignAllGrid.down('#btnAdd').setVisible(false);
             				assignAllGrid.down('#btnDelete').setVisible(false);
         				 }
    					this.disableMoreActionPivileges(assignAllGrid,permissionsMap);
         			}
         		},
         		
         topicTypesShow:function(){
 			var $this = this;
 			Ext.Ajax.request({
				type : 'rest',
				url :SERVERURL.TOPIC_TYPE,
				method : 'GET',
				async: false,
				success : function(form, action) {
		    	var topicType = 	Ext.JSON.decode(form.responseText);
		    	var topicTypeRadio = Ext.ComponentQuery.query('radiogroup#topicType_ID')[0];
		    	for(var i=0, n=topicType.length; i<n; i++ ){
		    		 if (topicType[i].code == 'General'){
		    				topicTypeRadio.add({
			    		    boxLabel:getCourseTxCommonTranslation('GENERAL'),
			    			name:'topicType',
			    			inputValue: topicType[i].code
		                    });
		    			 }
                       if (topicType[i].code == 'Specific'){
		    				topicTypeRadio.add({
			    			boxLabel:getCourseTxCommonTranslation('SPECIFIC'),
			    			name:'topicType',
			    			inputValue: topicType[i].code
		                    });
		    			 
		    		 }
			    	}
	  			  var forms = $this.getAssignmentdetails();
	  			forms.down('#topicType_ID').items.items[0] &&  forms.down('#topicType_ID').items.items[0].setValue(true);
	  			 forms.down('#topicType_ID').items.items[1] && forms.down('#topicType_ID').items.items[1].setValue(false);
				}
        			});
         		},
         		
         //******************* for dynamically set values in read only fields ********************************
         		
         topicsAvailabiltiy:function(facultyId,sectionId){
  			  var form = this.getAssignmentdetails().getForm();
        	  //var sectionId = form.findField('sectionId').getValue();
        	  var courseCombo = this.getAssignmentdetails().down('customcombobox#courseId');
        	  var courseId = form.findField('courseId').getValue();
        	  var courseComponentId =courseCombo.getStore().findRecord("courseId",courseId).data.courseComponentId;
        	  //var courseComponentId =courseCombo.getStore().data.items[0].data.courseComponentId;
        	  var topicsAvailCombo= this.getAssignmentdetails().down('multiselectcombofield#hw_topicsAvailabilty_id');
        	      topicsAvailCombo.clearValue();
				 
				 var topicAvailStore = topicsAvailCombo.getStore();
				     topicAvailStore.getProxy().extraParams = {	
				    	 courseId: courseId,
				    	 componentId : courseComponentId
                     };
				     topicAvailStore.load();
         },
         topicsAvailabiltiyChange:function(o,r){
        	 if(r.topicType == 'Specific'){
        		 Ext.ComponentQuery.query('multiselectcombofield#hw_topicsAvailabilty_id')[0].show();
        	 }else if(r.topicType == 'General'){
        		 Ext.ComponentQuery.query('multiselectcombofield#hw_topicsAvailabilty_id')[0].hide();
        	 }
         },
         showIndividualAssignment:function(){
        	
        	var $this = this; 
        	 
        	var formWindow = this.getIdividualassignmentgrid();
        	if (!formWindow) {
        		Ext.widget('idividualassignmentgrid');
        		formWindow = $this.getIdividualassignmentgrid();
        	}
        	var gridData = $this.getAssigndetailsindividualgrid().getStore();
        	var assignmentTypeRadioGroup = $this.getAssignmentdetails().down("#assignmentType_Id");
        	if(assignmentTypeRadioGroup.down('[inputValue=all]').getValue() || assignmentTypeRadioGroup.down('[inputValue=all]').getValue == 'true') {
        		gridData = $this.getAssigndetailsallgrid().getStore();
        	}
        	var assignmentdetailsForm = $this.getAssignmentdetails().getForm();
        	var assignmentName = assignmentdetailsForm.findField('assignmentName').getValue();
        	formWindow.down('#indAssignmentName').setValue(assignmentName);
        	var courseVarientCombo = assignmentdetailsForm.findField('courseVariantId');
        	var newCourseVariantVal = courseVarientCombo.getValue();
        	
        	var courseVariantVal;
			Ext.each(newCourseVariantVal,function(currentCV){
				if(typeof currentCV=="number"){
					courseVariantVal = currentCV;
				}else if(typeof currentCV == "object"){
					courseVariantVal = currentCV.data.id;
				}
			});
        	
			courseVarientCombo.store.load({
				params:{
					courseVariantId: courseVariantVal,
				},	
				callback : function(records,operation,success) {					
					if (success) {
						for(i in records){
							if(courseVariantVal == records[i].data.id ){
								formWindow.down('#indCourseVarient').setValue(records[i].data.courseVariantCode);								
							}							
						}						
					}
				}				
			});
        	var studentIds = [];
        	if(!isNullOrEmpty(gridData.getRange())) {
        		for(var i=0; i<gridData.getRange().length;i++) {
        			studentIds.push(gridData.getRange()[i].data.admissionNo);
        		}
        	}
        	var gridStore = this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualStore');
        	gridStore.getProxy().extraParams = {	
        		courseVariantId: courseVariantVal,
        		studentIds:studentIds.join()
        	};
        	gridStore.load();
        	 Ext.defer(function() {
             	formWindow.show();
 	        }, 50, this);
        	var idividualgrid= Ext.ComponentQuery.query('grid#idividualassignmentgridItemId');
        	var sectionType;
        	var sectionTypeCombo=this.getAssignmentdetails().down("#courseId");
        	var sectionType = sectionTypeCombo.getStore().findRecord("courseId", sectionTypeCombo.getValue()).data.sectionType;
        	
        	var gridColumns = idividualgrid[0];
        	for(i in gridColumns.columns ){
        	if(sectionType === "CourseSection"){
        		if(gridColumns.columns[i].dataIndex == "programName"){
        			gridColumns.columns[i].show();
        		}
        		if(gridColumns.columns[i].dataIndex == "batchName"){
        			gridColumns.columns[i].show();
        		}
        		if(gridColumns.columns[i].dataIndex == "periodName"){
        			gridColumns.columns[i].show();
        		}
        	} else {
        		if(gridColumns.columns[i].dataIndex == "programName"){
        			gridColumns.columns[i].hide();
        		}
        		if(gridColumns.columns[i].dataIndex == "batchName"){
        			gridColumns.columns[i].hide();
        		}
        		if(gridColumns.columns[i].dataIndex == "periodName"){
        			gridColumns.columns[i].hide();
        		}
        	} 
        	}
         },
         showGroupAssignment:function(){
        	 var formWindow = this.getGroupsassignmentgrid();
        	 if (!formWindow) {
        		 Ext.widget('groupsassignmentgrid');
        		 formWindow = this.getGroupsassignmentgrid();
        	 }
        	 formWindow.show();
        	 var assginmentDetailsForm = this.getAssignmentdetails();
        	 var courseVariantId = assginmentDetailsForm.down('#courseVariant_Id').getValue();
        	 var groupgrid= Ext.ComponentQuery.query('form#groupAssignmentForm_Id');
        	 groupgrid[0].down('#addAssignmentGroupNameId').getSelectionModel().setLocked(false);
        	 var sectionType;
        	 var sectionTypeCombo=this.getAssignmentdetails().down("#courseId");
        	 var sectionType = sectionTypeCombo.getStore().findRecord("courseId", sectionTypeCombo.getValue()).data.sectionType;

        	 var gridColumns = groupgrid[0].down('#addAssignmentGroupNameId');
        	 /* Start for remove selected student on GroupAssignmentGrid*/    	        
        	 var storeGroup = Ext.getStore('coursetransaction.homework.assignmentdetails.AssignmentGroupBlank');
        	 var gColumStr = gridColumns.getStore();
        	 gColumStr.getProxy().extraParams='';
        	 gColumStr.getProxy().api.read=SERVERURL.PATH_FIND_ASSIGNMENT_DETAIL_GRID_ADD;
        	 var variantIdArrays = [];
        	 var courseVariantIds = null;
        	 if(!isNullOrEmpty(courseVariantId)){
        		 if(courseVariantId.length > 0 && !isNullOrEmpty(courseVariantId[0])){
        			 for (var i in courseVariantId) {
        				 if (Ext.isObject(courseVariantId[0])) {
        					 variantIdArrays.push(courseVariantId[i].get("id"));
        				 } else {
        					 variantIdArrays.push(courseVariantId[i]);
        				 }
        			 }
        			 courseVariantIds = variantIdArrays.join();
        		 }
        		 else{
        			 courseVariantIds = courseVariantId;
        		 }
        	 } 
        	 if(!isNullOrEmpty(courseVariantIds)){
        		 gColumStr.getProxy().extraParams = {
        			 courseVariantId : courseVariantIds
        		 };
        	 }
        	 gColumStr.load({
        		 callback: function(){
        			 storeGroup.data.items.forEach(function(obj){
        				 var rec = gColumStr.findRecord('admissionNo',obj.data.admissionNo);
        				 if(rec){
        					 gColumStr.remove(rec);
        				 gColumStr.totalCount = gColumStr.totalCount-1;
        				 }
        			 });
        			 formWindow.down('grid').getView().refresh();
        	/* End for remove selected student on GroupAssignmentGrid*/

        			 for(i in gridColumns.columns){
        				 if(sectionType === "CourseSection"){
        					 if(gridColumns.columns[i].dataIndex == "programName"){
        						 gridColumns.columns[i].show();
        					 }
        					 if(gridColumns.columns[i].dataIndex == "batchName"){
        						 gridColumns.columns[i].show();
        					 }
        					 if(gridColumns.columns[i].dataIndex == "periodName"){
        						 gridColumns.columns[i].show();
        					 }
        				 } else {
        					 if(gridColumns.columns[i].dataIndex == "programName"){
        						 gridColumns.columns[i].hide();
        					 }
        					 if(gridColumns.columns[i].dataIndex == "batchName"){
        						 gridColumns.columns[i].hide();
        					 }
        					 if(gridColumns.columns[i].dataIndex == "periodName"){
        						 gridColumns.columns[i].hide();
        					 }
        				 } 
        			 }
        		 }
        	 });
         },
//         upload window open in case of individual *************
         showUploadFileInividual:function(){
        		var $this = this;
				var grid = $this.getAssigndetailsindividualgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					 var records = grid.getSelectionModel().getSelection();
					 var data = records[0].data;
				 this.getDocumentController().showDocumentFormWindow('individualItemId', 'DOCUMENT');
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
         },
//         upload window open in case of group ****************
         
         showUploadGroupFile:function(){
        		var $this = this;
				var grid = $this.getAssigndetailsgroupgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					 var records = grid.getSelectionModel().getSelection();
					 var data = records[0].data;
				this.getDocumentController().showDocumentFormWindow('groupItemId', 'DOCUMENT');
        		
	 		 
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
         },
         showUploadFileAll:function(){
        	 var $this = this;
        	 var grid = $this.getAssigndetailsallgrid();
        	 var records = grid.getSelectionModel().store.data.items[0]; //grid.getSelectionModel().getSelection();
        	 if(records != undefined){
        		 var data = records.data; // records[0].data;
        		 this.getDocumentController().showDocumentFormWindow('allAssignmentItemId', 'DOCUMENT');	
        	 }
        	 else{
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	 }
         },
         
//         delete selected record form assignment individual and group and all grid******************
         
         deleteAssignmentIndividualRecords:function(){
        	 var $this = this;
        	 var grid = this.getAssigndetailsindividualgrid();
        	 var store = grid.getStore();
         	var assignmentTypeRadioGroup = $this.getAssignmentdetails().down("#assignmentType_Id");
         	if(assignmentTypeRadioGroup.down('[inputValue=all]').getValue() || assignmentTypeRadioGroup.down('[inputValue=all]').getValue == 'true') {
         		store = $this.getAssigndetailsallgrid().getStore();
         		grid = $this.getAssigndetailsallgrid();
         	}
        	 if (grid.getSelectionModel().getCount() > 0) {
        		 showConfirmMessage(getCommonTranslation('ASSIGNMENT_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
        				 var selectedRecord  = grid.selModel.getSelection();
        				 store.remove(selectedRecord);
        			 }
        		 });
        	 } else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	 }
         },
         
         deleteAssignmentGroupRecords:function(){
        	 var grid = this.getAssigndetailsgroupgrid();
        	 var store = grid.getStore();
        	 
        	 if (grid.getSelectionModel().getCount() > 0) {
        		 showConfirmMessage(getCommonTranslation('ASSIGNMENT_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
        				 var selectedRecord  = grid.selModel.getSelection();
        				 store.remove(selectedRecord);
        			 }
        		 });
        	 } else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	 }
         },
         
         deleteAssignmentRecords:function(){

        	 var $this=this; 

        	 var grid = $this.getSearchresultgrid();

        	 if (grid.getSelectionModel().getCount() > 0) {
        		 var records = grid.getSelectionModel().getSelection()[0];
        		 var id = records.get("ID");
        		 showConfirmMessage(getCommonTranslation('ASSIGNMENT_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
        				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				 Ext.Ajax.request({
        					 method: "DELETE",
        					 type: 'rest',
        					 timeout:300000,
        					 url: SERVERURL.HW_ASSIGNMENT_DETAILS_DELETE+'?id='+id,
        					 headers: {
        						 'Content-Type': 'application/json'
        					 },
        					 params: {
        						 id: id
        					 },
        					 success: function(form, action) {
        						 Ext.getBody().unmask();
        						 grid.store.reload();
        						 showSuccessMessage(getCommonTranslation('ASSIGNMENT_DETAILS'), getProgramandcourseTranslation('HW_ASSIGNMENT_DETAILS_DELETE_SUCCESS'));
        					 },
        					 failure: function(form, action) {
        						 Ext.getBody().unmask();
        						 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('HW_MARK_ENTRY_DONE'));
        					 }

        				 });
        			 }
        		 });
        	 } else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
        	 }
         },
         //******************* for store data of individual grid to assignment grid ********************************
         
         storeInAssignmentDetailsGrid:function(){
        	 var $this = this;
        	var grid = $this.getIdividualassignmentGrid();
         	 if (grid.getSelectionModel().getCount() > 0) {
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		var record = [];
        		for( var i = 0; i < selected.length; i++) {
        		record.push({
        			"studentId" : selected[i].data.studentId,
        			"studentCode" : selected[i].data.studentCode,
        			"studentName" : selected[i].data.studentName,
        			"admissionCode" : selected[i].data.admissionCode,        			
   				   "admissionNo" : selected[i].data.admissionNo,
   				   "firstName"  :  selected[i].data.firstName,
   				   "middleName"  :  selected[i].data.middleName,
   				   "lastName"  :  selected[i].data.lastName,
   				   "programName"  :  selected[i].data.programName,
   				   "periodName"  :  selected[i].data.periodName,
   				   "batchName"  :  selected[i].data.batchName,
   				   "courseVariantId"  :  selected[i].data.courseVariantId,
   				   "periodId"  :  selected[i].data.periodId,
   				   "isWithDrawn"  :  selected[i].data.isWithDrawn,
   				   "submissionStatus"  :  "Pending"
   				  });
        		}
        	}
         	 } else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	 }
         	var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualBlank');
        	var assignmentTypeRadioGroup = $this.getAssignmentdetails().down("#assignmentType_Id");
        	if(assignmentTypeRadioGroup.down('[inputValue=all]').getValue() || assignmentTypeRadioGroup.down('[inputValue=all]').getValue == 'true') {
        		store = $this.getAssigndetailsallgrid().getStore();
        	}
        	store.loadRawData(record,true);
        	$this.getIdividualassignmentgrid().close();
         },
        storeIndividualFile:function(){
        	 var $this = this;
        	 var form = Ext.getCmp('upload_file_Id').getForm();
        	 var grid = $this.getAssigndetailsindividualgrid();
 	 		 var store = grid.getStore();
 	 		 
        	 	 if (grid.getSelectionModel().getCount() > 0) {
        	 		 var records = grid.getSelectionModel().getSelection();
        	 		 var data = records[0].data;
        	 		
        	 		 var studentId =   form.findField('studentId').getValue();
        	 		 var admissionNo = form.findField('admissionId').getValue();
        	 		 var studentName =  form.findField('studentName').getValue();
        	 		 var hwfile = form.findField('hwfile').getValue();
        	 		 var data = {
        	 				   "studentId" : studentId,
        	 				  "admissionNo" : admissionNo,
        	   				  "firstName"  :  studentName,
        	 				    "hwfile": hwfile
        	 		 };
       
               	     var rowIndex = store.indexOf(records[0]);
        	 		  
        	 		  if(rowIndex >=0){
                		  store.remove(records[0]);
                	  }
        	 		 store.loadRawData(data, true);
        	 		$this.getUploadfile().close();
        	 		 
        	 		 }
         },
         //******************* for store data of group grid to assignment grid ******************************** 
         
         storeGroupDetailsGrid:function(){
        	 var $this = this;
        	 var form = Ext.getCmp('groupAssignmentForm_Id').getForm();
        	 var grid = $this.getGroupsassignmentGrid();
        	 if (grid.getSelectionModel().getCount() > 0) {
        		 var selected = grid.selModel.getSelection();
        		 var assignmentDetailsGroupGrid = $this.getAssigndetailsgroupgrid();
        		 var groupName = form.findField('groupName').getValue();
        		 var isGroupExist = $this.isGroupExistOrNot(groupName);
        		 if(isGroupExist){
        			 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('HW_ASSIGNMENT_GROUP_NAME_ALREADY_EXIST'));
        		 }else{
        			 if(groupName.length == 0){
        				 groupName = form.findField('existinAssignmentGroupName').getDisplayValue();
        			 }
        			 var checkExistGroup = form.findField('existinAssignmentGroupName').getDisplayValue();
        			 var gridData = assignmentDetailsGroupGrid.getSelectionModel().store.data.items;
        			 var groupMap = new Ext.util.HashMap();
        			 var uniqueAdmissionMap = new Ext.util.HashMap();
        			 Ext.each(gridData, function(dataValue) {
        				 if(!isNullOrEmpty(dataValue)){
        					 groupMap.add(dataValue.data.groupName,dataValue.data.groupDetails);
        					 uniqueAdmissionMap.add(dataValue.data.groupDetails.admissionNo,dataValue.data.groupDetails);
        				 }

        			 });
        			 if(groupMap.containsKey(groupName)){
        				 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('HW_ASSIGNMENT_GROUP_ALREADY_ADDED'));
        			 }else{
        				 var grupLedr=null;
        				 var record = [];
        				 var uniqueStudent = false;
        				 if( selected.length > 0){
        					 var groupDetails= [];
        					 var flag = false;
        					 for( var i = 0; i < selected.length; i++) {
        						 if(uniqueAdmissionMap.containsKey(selected[i].data.admissionNo) || uniqueStudent){
        							 uniqueStudent = true;
        						 }else if(!uniqueStudent && !uniqueAdmissionMap.containsKey(selected[i].data.admissionNo)){
        							 if(selected[i].data.groupLeader == true){
        								 grupLedr=selected[i].data.firstName;
        								 flag = true; 
        								 groupDetails.push({
        									 "admissionNo" : selected[i].data.admissionNo,
        									 "studentId": selected[i].data.studentId,
        									 "groupLeader": selected[i].data.groupLeader,
        									 "studentName" : selected[i].data.firstName,
        									 "firstName" : selected[i].data.firstName,
        									 "middleName" : selected[i].data.middleName,
        									 "lastName" : selected[i].data.lastName,
        									 "courseVariantId" : selected[i].data.courseVariantId
        								 });
        							 }
        						 }
        					 }
        					 if(!flag || flag == 'false') {
        						 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GROUP_LEADER_SELECT'));
        						 return;
        					 } else if(uniqueStudent) {
        						 showWarningMessage(getCommonTranslation('ALERT'),getCourseTxCommonTranslation('HW_GROUP')+' '+groupName+' '+getProgramandcourseTranslation('HOMEWORK_ASSIGNMENT_GROUP_EXIST'));
        						 return;
        					 }
        				 }
        				 for(var i in selected){
        					 record.push({
        						 "groupName" : groupName,
        						 "groupDetails":groupDetails[0],
        						 "groupLeader":selected[i].data.groupLeader,
        						 "studentName":selected[i].data.studentName,
        						 "firstName":selected[i].data.firstName,
        						 "middleName":selected[i].data.middleName,
        						 "lastName":selected[i].data.lastName,
        						 "programName" :  selected[i].data.programName,
        						 "periodName"  :  selected[i].data.periodName,
        						 "batchName"   :  selected[i].data.batchName,
        						 "studentCode" : selected[i].data.studentCode,
        						 "admissionCode" :selected[i].data.admissionCode,
        						 "courseVariantId" : selected[i].data.courseVariantId,
        						 "admissionNo" : selected[i].data.admissionNo,
        						 "periodId" : selected[i].data.periodId,
        		   				  "submissionStatus"  :  "Pending"
        					 });
        				 }
        				 var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentGroupBlank');
        				 store.loadRawData(record,true);
        				 $this.getGroupsassignmentgrid().close();
        				 if(checkExistGroup.length > 0){
        					 assignmentDetailsGroupGrid.getSelectionModel().selectAll(true);
        				 }
        			 } 
        		 }
        	 }else {
        		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	 }
         },
         // store file on group grid to assignment group grid
         storeGroupFile:function(){
        	 var $this = this;
        	 var form = Ext.getCmp('upload_file_Id').getForm();
        	 var grid = $this.getAssigndetailsgroupgrid();
 	 		 var store = grid.getStore();
 	 		 
        	 	 if (grid.getSelectionModel().getCount() > 0) {
        	 		 var records = grid.getSelectionModel().getSelection();
        	 		 var data1 = records[0].data;
        	 		 var groupName =  form.findField('groupName').getValue();
        	 		 var hwfile = form.findField('hwfile').getValue();
        	 		 
        	 		 var data = {
        	 				  "groupName" : data1.groupName,
        	 				  "groupLeader": data1.groupLeader,
        					  "groupDetails":data1.groupDetails,
        					  "hwfile": hwfile
        	 		 };
       
               	     var rowIndex = store.indexOf(records[0]);
        	 		  if(rowIndex >=0){
                		  store.remove(records[0]);
                	  }
        	 		 store.loadRawData(data, true);
        	 		 $this.getUploadfile().close();
        	 		 }
         },
         storeAllFile:function(){
        	 var $this = this;
        	 var form = Ext.getCmp('upload_file_Id').getForm();
        	 var grid = $this.getAssigndetailsallgrid();
 	 		 var store = grid.getStore();
 	 		 
        	 	 if (grid.getSelectionModel().getCount() > 0) {
        	 		 var records = grid.getSelectionModel().getSelection();
        	 		 var data1 = records[0].data;
        	 		 var hwfile = form.findField('hwfile').getValue();
        	 		 var data = {
        	 				   "studentId" : data1.studentId,
        	 				  "admissionNo" : data1.admissionNo,
        	   				  "firstName"  :  data1.firstName,
        	 				    "hwfile": hwfile
        	 		 };
       
               	     var rowIndex = store.indexOf(records[0]);
        	 		  if(rowIndex >=0){
                		  store.remove(records[0]);
                	  }
        	 		 store.loadRawData(data, true);
        	 		$this.getUploadfile().close();
        	 		 
        	 		 }
         },
//       **********************   add assignment details record          **********************
         
     addAssignmentDetails:function(){
    	 
    	 var $this = this;
    	 var assignmentGridRecord=[];
    	 var assIndividualGrid = [];
    	 var assGroupGrid = [];
    	 var allGrid = [];
    	  
    	 assIndividualGrid = $this.getAssigndetailsindividualgrid().getSelectionModel().store.data.items;    	
    	 assGroupGrid =  $this.getAssigndetailsgroupgrid().getSelectionModel().store.data.items;
    	 allGrid = $this.getAssigndetailsallgrid().getSelectionModel().store.data.items;
    	 var assignmentTypeRadio =Ext.ComponentQuery.query('radiogroup#assignmentType_Id')[0];
		 var gridsRecords = [];
    	if(assignmentTypeRadio.items.items[1].checked){
			 var grid =  $this.getAssigndetailsgroupgrid();
			 assignmentGridRecord = grid.getSelectionModel().store.data.items;
			 var groupLeader;
			 if(assignmentGridRecord.length<=0){
				 Ext.getBody().unmask();
		   		 showWarningMessage(getCommonTranslation('ALERT'),
		   				 getCommonTranslation('PLEASE_SELECT_RECORD'));
		   		 return;
				 }
			 }else if(assignmentTypeRadio.items.items[2].checked){
				 var grid =  $this.getAssigndetailsindividualgrid();
				 assignmentGridRecord  = grid.getSelectionModel().store.data.items;
				 var groupLeader;
				 if(assignmentGridRecord.length<=0){
					 Ext.getBody().unmask();
			   		 showWarningMessage(getCommonTranslation('ALERT'),
			   				 getCommonTranslation('PLEASE_SELECT_RECORD'));
			   		 return;
					 }
				 }
		if(assIndividualGrid.length > 0 || assGroupGrid.length > 0 || allGrid.length > 0){
			 
		var form = $this.getAssignmentdetails().getForm();
		var values = form.getValues();
        
		var assignmentDetails = new Academia.model.coursetransaction.homework.assignmentdetails.AssignmentDetails();
		
		 var sectionId = form.findField('sectionId').getValue();
		 var programPeriodNameId = form.findField('programPeriodNameId').getValue();
		 var id = form.findField('id').getValue();
		assignmentDetails.set("assignmentName", values.assignmentName);
		assignmentDetails.set("assignmentType", values.assignmentType);
		assignmentDetails.set("dateGiven", values.dateGiven);
		assignmentDetails.set("dateSubmitted", values.dateSubmitted +' '+ values.submittedTime);
		if(isNullOrEmpty(values.facultyId)){
		var facultyId=this.getCurrentlyLoggedInUser().id;
		    assignmentDetails.set("facultyId", facultyId);
		}else{
			assignmentDetails.set("facultyId", values.facultyId);
		}
		assignmentDetails.set("hwonlineSubmission", values.onlineRadio_ID);
		assignmentDetails.set("topicType", values.topicType);
		assignmentDetails.set("programBatchPeriodConfigurationId", programPeriodNameId);
		assignmentDetails.set("sectionId", sectionId);
		
		assignmentDetails.set("evaluationPlanId", values.evaluationPlanId);
		
		assignmentDetails.set("customData", values.customData);
		assignmentDetails.set("version", values.version);
		assignmentDetails.set("description", values.description);
		assignmentDetails.set("publishDate",values.publishDate +' '+ values.publishTime);
		assignmentDetails.set("isEvaluationRequired", values.isEvaluationRequired);
		if(!isNullOrEmpty(values.extendedDate) && !isNullOrEmpty(values.extendedTime)){
			assignmentDetails.set("extendedDate", values.extendedDate +' '+ values.extendedTime);
		}
		else {
			assignmentDetails.set("extendedDate", null);
		}
		
		if(!isNullOrEmpty(values.maxMarks)){
			assignmentDetails.set("maxMarks", values.maxMarks);
		}
		else {
			assignmentDetails.set("maxMarks", null);
		}
		var topicMultiSelect=$this.getAssignmentdetails().down('#hw_topicsAvailabilty_id').getStore();
		var radioGroup = $this.getAssignmentdetails().down('#topicType_ID');
		var myJson =[];	
		
		var courseTopicIds = values.courseTopicId;
		var myJsonTopic = [];
		var multiTopicData;
		if(radioGroup.getValue().topicType == "Specific"){
			if(courseTopicIds !="" && courseTopicIds !=null){
				if(isArray(courseTopicIds)){
					for(var i in courseTopicIds){
						if(Ext.isObject(courseTopicIds[0])){
							multiTopicData = courseTopicIds[i].get("id");
							myJsonTopic.push(multiTopicData);
						}else{
							multiTopicData = courseTopicIds[i];
							myJsonTopic.push(multiTopicData);
						}
					}
					if(myJsonTopic.length>0){
						for(var i in myJsonTopic){
							if(!isNullOrEmpty(courseTopicIds[i].data)){
								myJson.push({
									"courseHomeWorkAssignmentId":id,
									"courseTopicId":courseTopicIds[i].data.id		//courseTopicIds[i]
								});
							}else{
								myJson.push({
									"courseHomeWorkAssignmentId":id,
									"courseTopicId":courseTopicIds[i]		//courseTopicIds[i]
								});
							}
							
						}
					 }
				} else {
					var recCourcesTopic = topicMultiSelect.findRecord('id',courseTopicIds);
					myJsonTopic.push(recCourcesTopic);
					if(myJsonTopic.length>0){
						for(var i in myJsonTopic){
							myJson.push({
								"courseHomeWorkAssignmentId":id,
								"courseTopicId":recCourcesTopic.data.id		//courseTopicIds[i]
							});
						}
					 }
				}
			}
			
		 } 
		assignmentDetails.set("courseHomeWorkTopics", myJson);
		
		myJson =[];	
		var homeworkSequentialDetailStore=$this.getAssignmentdetails().down('#evaludationDetailSequenceId_Id').getStore();
		var evaludationDetailSequenceIds = values.evaludationDetailSequenceId;
		if(!isNullOrEmpty(evaludationDetailSequenceIds)) {
			if(isArray(evaludationDetailSequenceIds)){
				for(var i in evaludationDetailSequenceIds){
					if(Ext.isObject(evaludationDetailSequenceIds[i])){
						var evaluationSequenceRec = homeworkSequentialDetailStore.findRecord('id',evaludationDetailSequenceIds[i].get("id"));
						myJson.push({
							"courseHomeWorkAssignment":$this.getIdValueJson(id),
							"evaluationSequenceDetail":$this.getIdValueJson(evaludationDetailSequenceIds[i].get("id")),
							"id":evaluationSequenceRec.data.secondId
						});
					}else{
						var evaluationSequenceRec = homeworkSequentialDetailStore.findRecord('id',evaludationDetailSequenceIds[i]);
						myJson.push({
							"courseHomeWorkAssignment":$this.getIdValueJson(id),
							"evaluationSequenceDetail":$this.getIdValueJson(evaludationDetailSequenceIds[i]),
							"id":evaluationSequenceRec.data.secondId
						});
					}
				}
			} else {
				var evaluationSequenceRec = homeworkSequentialDetailStore.findRecord('id',evaludationDetailSequenceIds);
				myJson.push({
					"courseHomeWorkAssignment":$this.getIdValueJson(id),
					"evaluationSequenceDetail":$this.getIdValueJson(evaluationSequenceRec.data.id)
				});
			}
		}
		assignmentDetails.set("homeworkAssignmentSequentialDetails", myJson);
		 
		 if(assignmentTypeRadio.items.items[2].checked){
			 var grid = $this.getAssigndetailsindividualgrid();
			 assignmentGridRecord  = grid.getSelectionModel().store.data.items;
			 
					for(var i=0; i< assignmentGridRecord.length; i++){
						
					/**
					 * Check document is null or not for the particular record.
					 */
			         var documentData=null;
			        	   if(!isNullOrEmpty(assignmentGridRecord[i].data.documentName)) {
			        	   documentData=  [{
						    	  "name":assignmentGridRecord[i].data.documentName,
		        				  "path":assignmentGridRecord[i].data.path,
		        				  "type":"DOCUMENT",
		        				  "createdBy":$this.getIdValueJson(assignmentGridRecord[i].data.createdBy.id,assignmentGridRecord[i].data.createdBy.value)
						      }];
			        	   }
						gridsRecords.push({
							      "id": assignmentGridRecord[i].data.id, 
								  "studentId": assignmentGridRecord[i].data.admissionNo,
							      "studentName": assignmentGridRecord[i].data.studentName,
							      "courseHomeWorkAssignmentId": id,
							      "courseVariantId": assignmentGridRecord[i].data.courseVariantId,
							      "groupName": null,
							      "whetherGroupLeader": null,
							      "randomNumber": (values.hideIdentityRadio_ID==false)?null:assignmentGridRecord[i].data.randomNumber,
							      "submissionStatus": isNullOrEmpty(assignmentGridRecord[i].data.submissionStatus)?"Pending":assignmentGridRecord[i].data.submissionStatus,
							      "submissionDate": isNullOrEmpty(assignmentGridRecord[i].data.submissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord[i].data.submissionDate), 'Y-m-d')+" 00:00 AM",
							      "resubmissionDate": isNullOrEmpty(assignmentGridRecord[i].data.reSubmissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord[i].data.reSubmissionDate), 'Y-m-d')+" 00:00 AM",
							      "markObtained": null,
							      "gradeObtained": null,
							      "remarks": null,
							      "markesGrade": null,
							      "documents":documentData,
							      "periodId":assignmentGridRecord[i].data.periodId
								  });
					}
					
		 }else if(assignmentTypeRadio.items.items[1].checked){
			 var grid =  $this.getAssigndetailsgroupgrid();
			 assignmentGridRecord  = grid.getSelectionModel().store.data.items;
			 var groupLeader;
			 if(assignmentGridRecord.length>0){
				 for(var i=0; i< assignmentGridRecord.length; i++){
					 /**
					  * Check document is null or not for the particular record. in case of update
					  */
					 var documentData=null;
					 if(!isNullOrEmpty(assignmentGridRecord[i].data.documentName)){
						 documentData=  [{
							 "encryptedDocId":assignmentGridRecord[i].data.documentId,
							 "name":assignmentGridRecord[i].data.documentName,
							 "path":assignmentGridRecord[i].data.path,
							 "type":"DOCUMENT",
							 "createdBy":$this.getIdValueJson(assignmentGridRecord[i].data.createdBy.id,assignmentGridRecord[i].data.createdBy.value)
						 }];
					 }
					 gridsRecords.push({
						 "id": assignmentGridRecord[i].data.id, 
						 "studentId": assignmentGridRecord[i].data.admissionNo,
						 "studentName": assignmentGridRecord[i].data.firstName,
						 "courseHomeWorkAssignmentId": id,
						 "courseVariantId": assignmentGridRecord[i].data.courseVariantId,
						 "groupName": assignmentGridRecord[i].data.groupName,
						 "randomNumber": (values.hideIdentityRadio_ID==false)?null:assignmentGridRecord[i].data.randomNumber,
						 "whetherGroupLeader": assignmentGridRecord[i].data.groupLeader,
						 "submissionStatus": isNullOrEmpty(assignmentGridRecord[i].data.submissionStatus)?"Pending":assignmentGridRecord[i].data.submissionStatus,
						 "submissionDate": isNullOrEmpty(assignmentGridRecord[i].data.submissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord[i].data.submissionDate), 'Y-m-d')+" 00:00 AM",
						 "resubmissionDate": isNullOrEmpty(assignmentGridRecord[i].data.reSubmissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord[i].data.reSubmissionDate), 'Y-m-d')+" 00:00 AM",
						 "markObtained": null,
						 "gradeObtained": null,
						 "remarks": null,
						 "markesGrade": null,
						 "documents":documentData,
						 "periodId":assignmentGridRecord[i].data.periodId

					 });
				 }
				 var groupMap = new Ext.util.HashMap();
				 Ext.each(gridsRecords, function(val) {
					 if(groupMap.containsKey(val.groupName)){
						 if(!isNullOrEmpty(val.whetherGroupLeader) && (val.whetherGroupLeader || val.whetherGroupLeader == 'true')){
							 groupMap.add(val.groupName,val.whetherGroupLeader);
						 }
					 } else {
						 groupMap.add(val.groupName,false);
						 if(!isNullOrEmpty(val.whetherGroupLeader) && (val.whetherGroupLeader || val.whetherGroupLeader == 'true')){
							 groupMap.add(val.groupName,val.whetherGroupLeader);
						 }
					 }
				 });
				 var groupLeaderFlag=false;
				 Ext.Object.each(groupMap.map, function(currentKey,currentVal) {
					 if(!currentVal){
						 groupLeaderFlag=true;
						 return;
					 }
				 });
				 if(groupLeaderFlag){
					 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GROUP_LEADER_SELECT'));
					 return;
				 }
			 } else{
				 Ext.getBody().unmask();
				 showWarningMessage(getCommonTranslation('ALERT'),
						 getCommonTranslation('PLEASE_SELECT_RECORD'));
				 return;
			 }
		 }else{
			 var grid = $this.getAssigndetailsallgrid();
			 assignmentGridRecord  = grid.getStore();
			 	 
				 if(assignmentGridRecord.data.length > 0 ){
						
						for(var i=0; i< assignmentGridRecord.data.length; i++){	 
							
					         var documentData=null;
					         if(!isNullOrEmpty(assignmentGridRecord.data.items[i].data.documentName)){
					        	 documentData=  [{
						        		 "encryptedDocId":assignmentGridRecord.data.items[i].data.documentId,
						        		 "name":assignmentGridRecord.data.items[i].data.documentName,
						        		 "path":assignmentGridRecord.data.items[i].data.path,
						        		 "type":"DOCUMENT",
						        		 "createdBy":$this.getIdValueJson(assignmentGridRecord.data.items[i].data.createdBy.id,assignmentGridRecord.data.items[i].data.createdBy.value)
						        	 }];
					         }
							
							gridsRecords.push({
								      "id": assignmentGridRecord.data.items[i].data.id, 
									  "studentId": assignmentGridRecord.data.items[i].data.admissionNo,
								      "studentName": assignmentGridRecord.data.items[i].data.firstName,
								      "courseHomeWorkAssignmentId": id,
								      "courseVariantId": assignmentGridRecord.data.items[i].data.courseVariantId,
								      "groupName": null,
								      "whetherGroupLeader": null,
								      "randomNumber": (values.hideIdentityRadio_ID==false)?null:assignmentGridRecord.data.items[i].data.randomNumber,
								      "submissionStatus": isNullOrEmpty(assignmentGridRecord.data.items[i].data.submissionStatus)?"Pending":assignmentGridRecord.data.items[i].data.submissionStatus,
								      "submissionDate": isNullOrEmpty(assignmentGridRecord.data.items[i].data.submissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord.data.items[i].data.submissionDate), 'Y-m-d')+" 00:00 AM",
								      "resubmissionDate": isNullOrEmpty(assignmentGridRecord.data.items[i].data.reSubmissionDate)?null:Ext.Date.format(new Date(assignmentGridRecord.data.items[i].data.reSubmissionDate), 'Y-m-d')+" 00:00 AM",
								      "markObtained": null,
								      "gradeObtained": null,
								      "remarks": null,
								      "markesGrade": null,
								      "documents":documentData,
								      "periodId":assignmentGridRecord.data.items[i].data.periodId
									  });
								}
							}
		 }
		
		assignmentDetails.set("wsGroupHomeworkAssignments", gridsRecords);
		assignmentDetails.set("configureNotification",values.configureNotification);
		if(values.configureNotification){
			if(values.sendingPriority==="SCHEDULE"){
				if(!isNullOrEmpty(values.msgDueDate) && !isNullOrEmpty(values.msgDueDateTime)){
					var dateString="";
					dateString=values.msgDueDate+" "+values.msgDueDateTime;
					assignmentDetails.set("msgDueDate",dateString);
				}else{
					assignmentDetails.set("msgDueDate",null);
				}
				assignmentDetails.set("isSchedule", true);
			}else if(values.sendingPriority==="IMMEDIATE"){
				assignmentDetails.set("msgDueDate",null);
				assignmentDetails.set("isSchedule", false);
			}else{
				assignmentDetails.set("msgDueDate",null);
				assignmentDetails.set("isSchedule", false);
			}
			assignmentDetails.set("sendingPriority",values.sendingPriority);
		}
		
		var submitUrl;
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") {
			
			submitUrl = SERVERURL.HW_ASSIGNMENT_DETAILS_CREATE;
		} else {
			assignmentDetails.set("id", values.id);
			submitUrl = SERVERURL.HW_ASSIGNMENT_DETAILS_UPDATE;
		}
		
		if(!isNullOrEmpty(values.isEvaluationRequired) && (values.isEvaluationRequired== true)){
			assignmentDetails.set("assessmentIdentity",false);
		}
		else {
			assignmentDetails.set("assessmentIdentity", values.hideIdentityRadio_ID);
		}
		
		
		assignmentDetails.set("noOfFileUploaded", values.noOfFile);
		
		var formData = [];
		var courseVariantStore = form.findField('courseVariantId').getStore();
		Ext.each(values.courseVariantId, function(currentCourseVariant){
			var tempAssignmentDetails = Object.assign({},assignmentDetails.data);
			if(typeof currentCourseVariant == "number"){
				tempAssignmentDetails.courseVariantId = currentCourseVariant;
				var variantData = courseVariantStore.findRecord('id', currentCourseVariant).data;
				tempAssignmentDetails.sectionId = variantData.sectionId;
			} else {
				tempAssignmentDetails.courseVariantId = currentCourseVariant.get('id');
				var variantData = courseVariantStore.findRecord('id', currentCourseVariant.get('id')).data;
				tempAssignmentDetails.sectionId = variantData.sectionId;
			}
			var newGridRecord = [];
			Ext.each(assignmentDetails.data.wsGroupHomeworkAssignments, function(currentGridRecord){
				if(currentGridRecord.courseVariantId==tempAssignmentDetails.courseVariantId){
					delete currentGridRecord.courseVariantId;
					newGridRecord.push(currentGridRecord);
				}
			});
			tempAssignmentDetails.wsGroupHomeworkAssignments = newGridRecord;
			formData.push(tempAssignmentDetails);
		});
		
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			timeout:300000,
			success : function(form, action) {
				Ext.getBody().unmask();
				var resData = Ext.JSON.decode(form.responseText);
				var forms = $this.getAssignmentdetails();
				var form =   forms.getForm();
				//
				if (submitUrl == SERVERURL.HW_ASSIGNMENT_DETAILS_CREATE){
					showSuccessMessage(getCourseTxCommonTranslation('HW_ASSIGNMENT_DETAILS'), getProgramandcourseTranslation('HW_ASSIGNMENT_DETAILS_SUCCESS'));
				} else {
					showSuccessMessage(getCourseTxCommonTranslation('HW_ASSIGNMENT_DETAILS'), getProgramandcourseTranslation('HW_ASSIGNMENT_DETAILS_UPDATE_SUCCESS'));
				}
				
				$this.getContentPanel().getActiveTab().close();
				try{
					Ext.ComponentQuery.query('#homeworklistId')[0].getStore().load();
				}
				catch(e){}
			},
	        failure: function(form, action) {
	            showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('HW_MARK_ENTRY_DONE'));
	            }
		});
		 }else {
			 Ext.getBody().unmask();
   		 showWarningMessage(getCommonTranslation('ALERT'),
   				 getCommonTranslation('PLEASE_SELECT_RECORD')); 
   	 }
	},
	loadHomeWork : function(model,records){
		var quickSearchForm = this.getHomeworksearch();
        var jsonFormatFormData = this.createJsonFormat(quickSearchForm, records);
        var searchResultGrid = this.getSearchresultgrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        var portalId = this.getCurrentLoggedPortalId();
		if(portalId == 3 || portalId == 7) {
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_STUDENT_VIEWCODE);
		}else{
			resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_VIEWCODE);	
		}
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	},
	createJsonFormat: function(quickSearchForm, record) {
		var portalId = this.getCurrentLoggedPortalId();
		if(portalId == 2) {
			return this.jsonCreationForFacultyPortal();
		} else if(portalId == 3 || portalId == 7){
			return this.jsonCreationForStudentPortal();
		} else {
			return this.jsonCreationForCoreErp();
		}
	},
	getJsonObject: function(key, value, additionalValue) {
		if (value != '' && value != null && additionalValue == undefined) {
			return {
				"paramCode": key,
				"paramValues": [value]
			};
		} else if (value != '' && additionalValue != undefined) {
			return {
				"paramCode": key,
				"paramValues": [value, additionalValue]
			};
		}
	},
	pushJsonObjectInArray: function(object, array) {
		if (object) {
			array.push(object);
		}
	},
	
	/**
	 *  On click of preview button
	 */
	previewTemplateFunction:function(){
		var $this = this;
		var form = $this.getGenerateassignmentdetailsreportwin().down('form').getForm();
		var templateIdField = form.findField('chooseTemplateId');
		var templateId = templateIdField.store.findRecord('id',templateIdField.getValue()).raw.scholarshipAmount;

		if(!isNullOrEmpty(templateId)){

			var formWindow = $this.getPreviewtemplate();
			if (!formWindow) {
				Ext.widget('previewtemplate');
				formWindow = $this.getPreviewtemplate();
			}
			formWindow.show();

			var previewForm = $this.getPreviewtemplate();

			var url = SERVERURL.TEMPLATE_PREVIEW;
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: url+'?id='+templateId,
				method: 'GET',
				success : function(response){
					if(response.responseBytes.length>0){
						var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
						if(!isNullOrEmpty(blob) && blob != undefined){
							var url = window.URL.createObjectURL(blob);
							var a=previewForm.down("#profile_image");
							a.getEl().dom.src=url;
						}

					}
				}

			});
		}
	},
	
	gridRenderFunction: function(grid) {
		grid.addButtonToolbar();
		var butonstoolbar=grid.down('#functionButtonsToolbar');
		 butonstoolbar.insert(5,{
			xtype: 'button',
			 itemId: 'submitAssignmentDocument',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 tooltip :getCommonTranslation('UPLOAD_DOC')
		 });
		 butonstoolbar.insert(6,{
			 xtype: 'button',
			 itemId: 'bulkDownloadDocId',
			 text:getCommonTranslation('BULK_DOWNLOAD_DOC'),
			 tooltip:getCommonTranslation('BULK_DOWNLOAD_DOC'),
		 });
		 butonstoolbar.insert(7,{
			 xtype: 'button',
			 itemId: 'exportReportBtnId',
			 text:getCommonTranslation('EXPORTREPORTS'),
			 tooltip:getCommonTranslation('EXPORTREPORTS'),
			 //disabled: true
		 });
       
    },
    editAssignmentForm:function(view){
    	var $this = this;
    	CVId=null;
    	var grid = $this.getSearchresultgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		Ext.apply(grid,{
    			code:null,
    			setCode : function(code){
    				grid.code = code;
    			},
    			getCode:function(){
    				return grid.code;
    			}
    		});
    		grid.setCode(true);
    		$this.openAssignmentForm();
    		$this.getAssigndetailsindividualgrid().getStore().removeAll();
    		$this.getAssigndetailsgroupgrid().getStore().removeAll();
    		$this.getAssigndetailsallgrid().getStore().removeAll();
    		try{
    			$this.getHomeworkstructure().down('#submissionDetailsGridStructureItemId').setDisabled(false);
    		} catch(e){}
    		
    		var records = grid.getSelectionModel().getSelection();
    		var assigmentdetailform = $this.getAssignmentdetails();
    		var onlineRadio = assigmentdetailform.down('#onlineSubmission_Id');
    		assigmentdetailform.down('#noOfFileItemId').setReadOnly(true);
    		var assignmentTypeRadioBtn = assigmentdetailform.down('#assignmentType_Id');
    	   	assignmentTypeRadioBtn.setReadOnly(true);
    	   	var assignSectionType=records[0].data.ASSIGN_SECTION_TYPE;
    		if(records[0].data.HWONLINESUBMISSIONS == 'Yes'){
    			onlineRadio.items.items[0].setValue(true);
    		}else{
    			onlineRadio.items.items[1].setValue(true);    			
    		}
    		if (records != undefined && records != ""&& records != null) {
    			var id = records[0].data.ID;
    			var dataCourseId ="";
    			Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.HW_ASSIGNMENT_DETAILS_FINDBYID,
    				params : {
    					id : id
    				},
    				method : 'GET',
    				scope:$this,
    				success : function(response) {
    					var form = $this.getAssignmentdetails().getForm();
    					var data = Ext.decode(response.responseText);
    					data.dateGiven = new Date(data.dateGiven);
    					data.publishDate = new Date(data.publishDate);
    					data.publishTime = data.publishDate;
    					data.dateSubmitted = new Date(data.dateSubmitted);
    					data.submittedTime = data.dateSubmitted;
    					
    					var isMarkType = (data.whetherMarkGrade == "M") ? true : false;
    					var maxMarks = data.maxMarks;
    					
    					var evaluationDetailsGridStructureItemId = $this.getContentPanel().getActiveTab().down('#evaluationDetailsGridStructureItemId');
    					if(evaluationDetailsGridStructureItemId){
    					evaluationDetailsGridStructureItemId.isMarkType = isMarkType;
    					evaluationDetailsGridStructureItemId.maxMarks = maxMarks;
	
							}
    					
    					if(!isNullOrEmpty(data.extendedDate)){
    						data.extendedDate = new Date(data.extendedDate);
    						data.extendedTime = data.extendedDate;
    					}else{
    						data.extendedDate = null;
    						data.extendedTime = null;
    					}
    					var CVId;
    					var assignmentDetails = new Academia.model.coursetransaction.homework.assignmentdetails.AssignmentDetails(data);
    					if(assignmentDetails.data.courseVariantId != undefined){
    						CVId = assignmentDetails.data.courseVariantId;
    					}

    					if(!isNullOrEmpty(data.id)){
    						$this.getAssignmentdetails().config.courseHomeWorkAssignmentId = id;
    					}

    					form.loadRecord(assignmentDetails);
    					var button =Ext.ComponentQuery.query('button#hwAssignment_Add')[0];
    					button.setText(getCommonTranslation('SAVE'));

    					var editButton =Ext.ComponentQuery.query('button#hwAssignment_Cancel')[0];
    					editButton.setVisible(false);

    					var scheduleTimeField = form.findField('msgDueDateTime');

    					form.findField('responseId').setValue(data.id);
    					form.findField('isEditable').setValue(data.isEditable);
    					form.findField('description').setValue(data.description);
    					form.findField('dateGiven').setValue(dateRender(data.dateGiven));
    					form.findField('timeGiven').setValue(data.stringServerTime);
    					form.findField('publishDate').setValue(data.stringPublishDate);
    					form.findField('publishTime').setValue(data.stringPublishTime);
    					form.findField('dateSubmitted').setValue(data.stringSubmittedDate);
    					form.findField('submittedTime').setValue(data.stringSubmittedTime);
    					form.findField('hideIdentityOnSubmission').setValue({hideIdentityRadio_ID:data.assessmentIdentity});
    					form.findField('noOfFile').setValue(data.noOfFileUploaded);
    					form.findField('hideIdentityOnSubmission').setReadOnly(true); 
    					
    					if(data.assignmentType=='individual')
                        {
                        form.findField('assignmentType_Id').items.items[2].setValue(true);
                        }
                    else if(data.assignmentType=='group')
                        {
                        form.findField('assignmentType_Id').items.items[1].setValue(true)
                        }
                    else{
                        form.findField('assignmentType_Id').items.items[0].setValue(true)
                    }
    					if(data.isEditable){
        					form.findField('maxMarks').setReadOnly(false); 
    					}
    					else{
    						form.findField('maxMarks').setReadOnly(true); 
    					}
    					if(!isNullOrEmpty(data.stringExtendedDate) && !isNullOrEmpty(data.stringExtendedTime)){
    						form.findField('extendedDate').setValue(data.stringExtendedDate);
    						form.findField('extendedTime').setValue(data.stringExtendedTime);
    					}
    					if(data.configureNotification){
    						form.findField('configureNotification').setValue(true);
    						if(data.isSchedule){
    							if(!isNullOrEmpty(data.adhocMsgDueDate) && !isNullOrEmpty(data.adhocMsgDueTime)){

    								form.findField('msgDueDate').setValue(data.stringAdhocMsgDueDate);
    								scheduleTimeField.setValue(data.stringAdhocMsgDueTime);

    								var newD = form.findField('msgDueDate').getValue().getDate();
    								if(data.publishDate.getDate() != newD){
    									scheduleTimeField.setMinValue(false);
    									form.checkValidity();
    									form.clearInvalid();
    								}

    								if(data.dateGiven.getDate() == newD){
    									scheduleTimeField.setMinValue(data.stringServerTime);
    									form.checkValidity();
    									form.clearInvalid();
    								}

    								var newSubDate = form.findField('dateSubmitted').getValue().getDate();
    								if(newSubDate == newD){
    									scheduleTimeField.setMaxValue(data.stringSubmittedTime);
    								}

    								if(scheduleTimeField.readOnly){
    									scheduleTimeField.setMinValue(false);
    									scheduleTimeField.setMaxValue(false);
    									scheduleTimeField.clearInvalid();
    								}
    							}
    						}
    						else{
    							var sendingPriority = form.findField('sendingPriority');
    							$this.setAllowBlank(sendingPriority,false);
    							sendingPriority.down('#immediate').setValue(true);
    							form.findField('msgDueDate').setVisible(false);
    							form.findField('msgDueDate').setDisabled(true);
    							scheduleTimeField.setVisible(false);
    							scheduleTimeField.setDisabled(true);
    							$this.setAllowBlank(form.findField('msgDueDate'),true);
    							$this.setAllowBlank(scheduleTimeField,true);
    							form.checkValidity();
    						}
    					}

    					var assigmentform = $this.getAssignmentdetails();
    					assigmentform.down('#courseVariant_Id').setDisabled(false);
    					
    					var courseCombo = form.findField('courseId');
    					dataCourseId = data.courseId;
    					var courseVarientCombo = form.findField('courseVariantId');
    					var portalId = $this.getCurrentLoggedPortalId();
    					var portalId = $this.getCurrentLoggedPortalId();
    					var studentLoggedID = null;
    					if(portalId == 3) {
    						var studentLoggedID = $this.getCurrentlyLoggedInUser().id;
    					}
    					if(portalId == 7) {
    						studentLoggedID = $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
    					}
    					courseCombo.setReadOnly(true);
    					courseVarientCombo.setReadOnly(true);
    					/* start set course and course variant in combo box */
    					var courseStore = courseCombo.getStore();
    					courseStore.getProxy().extraParams = {	    							
    						academyLocationIds: $this.getCurrentAcademyLocation(),
    						isCurrentPeriod:false,
    						studentId:studentLoggedID,
    						courseId:dataCourseId
    					};
    					courseCombo.getStore().load({
    						callback : function(records,operation,success) {
    							$this.getContentPanel().getActiveTab().body.setScrollTop(0);
    							if (success) {
    								courseCombo.reset();
    								var record = courseStore.findRecord('courseId', dataCourseId);
    								courseCombo.setValue(record.data.courseId);
    								var courseVarientStore = courseVarientCombo.getStore();
    								var facultyId = $this.getCurrentlyLoggedInUser().id;
    								if(portalId != 2){
    									facultyId = data.facultyId;
    								}
    								var topicCombo = assigmentform.down('#hw_topicsAvailabilty_id');
    		    					var topicStore = topicCombo.getStore();
    		    					topicStore.getProxy().extraParams = {	
    		    						courseId: record.data.courseId,
    		    						componentId : record.data.courseComponentId
    		    					};
    		    					$this.tempData = data;
    		    					topicStore.load({			// added for in edit and view mode show topic on Topic Combo
    		    						scope:$this,
    		    						callback : function(records,operation,success) {
    		    							if(success){
    		    								if(records.length == 1){
    		    									topicCombo.setValue(records[0].data.id); 
    		    								} else {
    		    									var tempData = $this.tempData;
    		    									tempArr = [];
    		    									tempData.courseHomeWorkTopics.forEach(function(obj){
    		    										tempArr.push(obj.courseTopicId);
    		    									});
    		    									topicCombo.setValue(tempArr);
    		    								} 
    		    								$this.getContentPanel().getActiveTab().body.setScrollTop(0);
    		    							}    							
    		    						}    						
    		    					});
    								courseVarientStore.getProxy().extraParams = {	
    									courseId: dataCourseId,
    									facultyId:facultyId,
    									academyLocationIds:$this.getCurrentAcademyLocation(),
    		    						studentId:studentLoggedID
    								};
    								courseVarientStore.load({
    									callback : function(records,operation,success) {
    										if (success) {
    											if(records.length > 0){
    												courseVarientCombo.setValue([CVId]);
    												courseVarientCombo.setValue([CVId]);
    												if(data.isEvaluationRequired || data.isEvaluationRequired == 'true') {
    						    						form.findField('isEvaluationRequired').setReadOnly(true);
    						    						form.findField('evaluationPlanId').setReadOnly(true);
    						    						form.findField('evaludationDetailSequenceId').setReadOnly(true);
    						    						var evaluationDetailSequenceCombo = form.findField('evaludationDetailSequenceId');
    						    						var evaluationPlanCombo = form.findField('evaluationPlanId');
    						    						evaluationPlanCombo.setDisabled(false);
    						        					evaluationPlanCombo.getStore().getProxy().extraParams = {
    						        						courseVariantIds: CVId
    						        					}
    						        					evaluationPlanCombo.getStore().load({
    						        						callback : function(records,operation,success) {
    						        							if (success) {
    						        								evaluationPlanCombo.setValue(data.evaluationPlanId);
    						        								var detailStore = evaluationDetailSequenceCombo.getStore();
    						        								evaluationDetailSequenceCombo.setDisabled(false);
    						        								detailStore.getProxy().extraParams = {
    						        									evaluationPlanId: data.evaluationPlanId,
    						        									isAssignmentEvaluation:true,
    						        									courseVariantIds:CVId,
    						        									assignmentId:data.id
    						        	        					}
    						        								detailStore.load({
    						        	        						callback : function(records,operation,success) {
    						        	        							if (success) {
    						        	        								var ids = [];
    						        	        								for(var i in data.homeworkAssignmentSequentialDetails) {
    						        	        									ids.push(data.homeworkAssignmentSequentialDetails[i].evaluationSequenceDetail.id)
    						        	        								}
    						        	        								evaluationDetailSequenceCombo.setValue(ids);
    						        	        								evaluationDetailSequenceCombo.setValue(ids);
    						        	        								form.isValid();
    						        	        								form.clearInvalid();
    						        	        							}
    						        	        						}
    						        	        					});
    						        								try{
    						        					    			$this.getHomeworkstructure().down('#evaluationDetailsGridStructureItemId').setDisabled(false);
    						        					    		} catch(e){}
    						        							}
    						        						}
    						        					});
    						    					}else{
    						    						try{
    						    			    			$this.getHomeworkstructure().down('#evaluationDetailsGridStructureItemId').setDisabled(false);
    						    			    		} catch(e){}
    						    					}
    											}
    										}
    									}
    								});
    							}
    						}
    					});
    					
    					var facultyCombo = form.findField('facultyId');
    					facultyCombo.store.getProxy().extraParams = {
    						courseVariantId: data.courseVariantId,
    						academyLocationIds: $this.getCurrentAcademyLocation(),
    					};
    					facultyCombo.store.load({
    						callback : function(records,operation,success) {
    							if (success) {
    								facultyCombo.setValue(data.facultyId);
    								facultyCombo.setReadOnly(true);
    								facultyCombo.setDisabled(false);
    							}
    						}
    					});
    					var portalId = $this.getCurrentLoggedPortalId();
    					var studentLoggedID = null;
    					if(portalId == 3) {
    						var studentLoggedID = $this.getCurrentlyLoggedInUser().id;
    					}
    					if(portalId == 7) {
    						studentLoggedID = $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
    					}
    					if(data.assignmentType == "individual"){
    						if(isNullOrEmpty(studentLoggedID)) {
    							var individualGrid = $this.getAssigndetailsindividualgrid();
        						var individualGridStore = individualGrid.getStore();
        						submitURL=SERVERURL.PATH_FIND_ASSIGNMENT_DETAIL_GRID_EDIT;
        						individualGridStore.getProxy().extraParams = {	
        							homeWorkAssignmentId: data.id
        						}
        						individualGridStore.getProxy().api.read=submitURL;
        						individualGridStore.load();
        						if(individualGrid != undefined ){
        							if(view == 'isView'){
        								individualGrid.down('#btnAdd').hide();
        								individualGrid.down('#btnDelete').hide();
        								if (!isNullOrEmpty(individualGrid.down('#indUploadDocument'))) {
        									individualGrid.down('#indUploadDocument').hide();
        								}
        							}
        						}
    						} else {
    							$this.getAssigndetailsindividualgrid().setVisible(false);
    						}
    					} else if (data.assignmentType == "group"){
    						var groupGrid = $this.getAssigndetailsgroupgrid();
    						var groupGridStore = groupGrid.getStore();
    						submitURL=SERVERURL.PATH_FIND_ASSIGNMENT_DETAIL_GRID_EDIT;
    						groupGridStore.getProxy().extraParams = {	
    							homeWorkAssignmentId: data.id,
    							studentId:studentLoggedID
    						}
    						groupGridStore.getProxy().api.read=submitURL;
    						groupGridStore.load();
    						/*V2D-13705*/
    						if(groupGrid != undefined ){
    							if(view == 'isView'){
    								groupGrid.down('#btnAdd').hide();
    								groupGrid.down('#btnDelete').hide();
    								if (!isNullOrEmpty(groupGrid.down('#uploadDocument'))) {
    									groupGrid.down('#uploadDocument').hide();
    								}
    							}
    						}
    					}else{
    						if(view != 'isView') {
    							var permissionsMap = new Ext.util.HashMap();
        						if(this.getCurrentLoggedPortalId()==2){
        							permissionsMap=this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
        							this.doAccessControlValidation($this.getAssigndetailsallgrid(),this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
        						}else{
        							permissionsMap=this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS();
        							this.doAccessControlValidation($this.getAssigndetailsallgrid(),this.getHOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
        						}
        						this.disableMoreActionPivileges($this.getAssigndetailsallgrid(),permissionsMap);
    						}
    						if(portalId == 3 || portalId == 7){
    							var allGird = $this.getAssigndetailsallgrid().setVisible(false);
    						}
    					}
    					$this.getHomeworkstructure().body.constrainScrollTop('top');
    				}
    			});
    		}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    bulkDownloadDocument:function(button){
    	var $this = this;
    	var submissionStatus = null;
    	
    	var selectedRadioValue = button.up('form').getForm().getValues().documentDownloadRadio;
    	if(selectedRadioValue==2){
    		submissionStatus = "Completed";
    	}
    	else if(selectedRadioValue==3){
    		submissionStatus = "Pending";
    	}

    	CVId=null;
    	var grid = $this.getSearchresultgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		if (records != undefined && records != ""&& records != null) {
    			var id = records[0].data.ID;
    			var dataCourseId ="";
    			Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.HW_ASSIGNMENT_BULK_DOCUMENT_DOWNLOAD,
    				params : {
    					id : id,
    					submissionStatus: submissionStatus
    				},
    				method : 'GET',
    				success : function(response) {
    					
    				}
    			});
    			showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
    			button.up('window').close();
    		}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    viewAssignmentForm:function(){
    	var $this = this;
    	$this.editAssignmentForm('isView');
    	var assignmentDetail = $this.getAssignmentdetails();
    	var form = $this.getAssignmentdetails();
    	var portalId = $this.getCurrentLoggedPortalId();
    	var evaluationdetailsgrid = $this.getEvaluationdetailsgrid();
    	if(evaluationdetailsgrid){
    	evaluationdetailsgrid.down('#btnDelete').setVisible(false);
		}
    	if (form) {
    		form.down('#hwAssignment_Add').hide();
    		form.down('#hwAssignment_Cancel').hide();
    		form.down('#assignmentType_Id').setReadOnly(true);
    		form.down('#topicType_ID').setReadOnly(true);
    		form.down('#hw_topicsAvailabilty_id').setReadOnly(true);
    		form.down('#assignmentType').setReadOnly(true);
    		if(portalId==3 || portalId==7){
    			form.down('#extendedDateFieldSet').setVisible(false);
    			form.down('#configureNotificationId').setVisible(false);
        		form.down('#fieldSendingPriorityItemId').setVisible(false);
        		form.down('#fieldScheduleDateItemId').setVisible(false);
        		form.down('#hideIdentityOnSubmissionItemId').setVisible(false);
        		form.down('#onlineSubmission_Id').setVisible(false);
        		form.down('#topicType_ID').setVisible(false);
        		form.down('#hw_topicsAvailabilty_id').setVisible(false);
        		form.down('#isEvaluationRequired').setVisible(false);
        		form.down('#evaluationPlanId_Id').setVisible(false);
        		form.down('#evaludationDetailSequenceId_Id').setVisible(false);
        		form.down('#assignmentType').setVisible(false);
        		form.down('#shortDescriptionItemId').setVisible(false);
        		form.down('#generateBtnAssignment').setVisible(false);
        		form.down('#resetBtnAssignment').setVisible(false);
    		}else{
    			form.down('#extendedDate').setReadOnly(true);
        		form.down('#extendedTime').setReadOnly(true);
    		}
    		
    		form.down('#configureNotificationId').setReadOnly(true);
    		form = form.getForm();
    		form.findField('courseVariantId').setReadOnly(true);
    		form.findField('facultyId').setReadOnly(true);
    		form.findField('evaluationPlanId').setReadOnly(true);
    		form.findField('evaludationDetailSequenceId').setReadOnly(true);
    		form.findField('assignmentName').setReadOnly(true);
    		form.findField('hwonlineSubmission').setReadOnly(true);
    		form.findField('dateGiven').setReadOnly(true);
    		form.findField('dateSubmitted').setReadOnly(true);
    		form.findField('submittedTime').setReadOnly(true);
    		form.findField('publishDate').setReadOnly(true);
    		form.findField('publishTime').setReadOnly(true);
    		
    		form.findField('msgDueDate').setReadOnly(true);
    		form.findField('msgDueDateTime').setReadOnly(true);
    		form.findField('msgDueDateTime').setMinValue(false);
    		form.findField('msgDueDateTime').clearInvalid();
    		form.findField('sendingPriority').setReadOnly(true);
    		form.findField('description').setReadOnly(true);
    		form.findField('courseId').setReadOnly(true);
    		form.findField('isEvaluationRequired').setReadOnly(true);
    		
    		//toggleReadOnlyFormItems(form, true);
    		form.findField('gridStatus').setValue('View');

    		var indvidualGrid = assignmentDetail.down('#individualGrid_Id');
    		if(indvidualGrid != undefined){
    			this.removeAssignmentDetailGridBtn(indvidualGrid);
    		}

    		var groupGrid = assignmentDetail.down('#groupGrid_Id');
    		if(groupGrid != undefined){
    			this.removeAssignmentDetailGridBtn(groupGrid);
    		}
    		groupGrid.selModel.setLocked(true);
    		var allDetailGrid = assignmentDetail.down('#assignAllGrid_Id');
    		if(allDetailGrid != undefined){
    			this.removeAssignmentDetailGridBtn(allDetailGrid);
    		}
    		
    		allDetailGrid.down('#uploadDocument').hide();
    		var topicTypeRadio = Ext.ComponentQuery.query('radiogroup#topicType_ID')[0];
    		topicTypeRadio.setReadOnly(true); 
    	}
    },

	removeAssignmentDetailGridBtn: function(grid) {
		if (!isNullOrEmpty(grid.down('#uploadDocument'))) {
			grid.down('#uploadDocument').hide();
		}else if (!isNullOrEmpty(grid.down('#indUploadDocument'))){
			grid.down('#indUploadDocument').hide();
		}else if (!isNullOrEmpty(grid.down('#btnAdd'))){
			grid.down('#btnAdd').hide();
		}else if (!isNullOrEmpty(grid.down('#btnDelete'))){
			grid.down('#btnDelete').hide();
		}		
	},	
	
	disableMoreActionPivileges: function(gridReference,permissionsMap) {

		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		buttonsToolBar = gridReference.query('toolbar')[0];
		var uploadButton=gridReference.down("#uploadDocument");
		if(isNullOrEmpty(uploadButton)){
			uploadButton=gridReference.down("#indUploadDocument");
		}
		uploadButton.setVisible(false);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'UPLOADFILE') {
				if(!isNullOrEmpty(uploadButton)){
					uploadButton.setVisible(true);
				}         		
			}
		});
	},
	exportUserList : function(exportUrl,filetype,whetherAll) {
		var $this=this;
		var portalId = $this.getCurrentLoggedPortalId();
		var quickSearchForm=null;
		if(portalId==3 || portalId==7){
			quickSearchForm = $this.getStudenthomeworkassignmentsearch();
		}else if(portalId==2){
			quickSearchForm = $this.getFacultyhomeworkassignmentsearch();
		}else{
			quickSearchForm = $this.getHomeworkassignmentsearch();
		}
		var searchResultGrid = this.getSearchresultgrid();
		var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		var reportTitle=getCommonTranslation('HOMEWORK_AND_ASSIGNMENT_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		}
		searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

},
    	createSearchCriteriaString: function(searchForm) {
    	    	 var me=this;
    	        var formValues = new Array();
    	        formValues = searchForm.getValues();        
    	        var searchCriteriaString="";
    	        for (var key in formValues) {
    	        	var value = formValues[key];            
    	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
    	                var keyValueJsonObject = me.getJsonObject( key , value);
    	searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
    	            }
    	        }
    	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    	        return searchCriteriaString;
    	},
    	  getDocumentController : function() {
				var this$ = this;
				return this$.getController('Academia.controller.document.DocumentController');
		},
		/**
		   *  for upload document for individual and all assignment type
		   */
	    getUploadDocument : function(grid,module,entityType){

	    	var $this=this;
	    	var isTransient = true;
	    	var entityId ;

	    	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){

	    		var getRange = grid.getStore().getRange();
	    			var selected = grid.selModel.getSelection();
	    			
	    			if(module == "individualAssignment"){
	    				selected.forEach(function(obj){
	    					obj.set("createdBy",$this.getIdValueJson(response.createdBy.id));
	    					obj.set("documentName",response.name);
	    					obj.set("path",response.path);
	    					obj.set("type",response.type);
	    					obj.set("groupDetails",obj.groupDetails);
	    					obj.set("documentId",null);
	    	    	        });
	    			}
	    			else if(module == "groupAssignment"){
	    				for(var j=0; j < selected.length ;j++){
	    					grid.getStore().filter("groupName", selected[j].data.groupName);
	    					for(var i=0; i < grid.getStore().getRange().length ;i++){
	    						grid.getStore().getRange()[i].set("createdBy",$this.getIdValueJson(response.createdBy.id));
	    						grid.getStore().getRange()[i].set("documentName",response.name);
	    						grid.getStore().getRange()[i].set("path",response.path);
	    						grid.getStore().getRange()[i].set("type",response.type);
	    						grid.getStore().getRange()[i].set("groupDetails",grid.getStore().getRange()[i].data.groupDetails);
	    						grid.getStore().getRange()[i].set("documentId",null);
	    					}
	    					grid.getStore().clearFilter();
	    				}
	    			}
	    			else{
	    				for(var i=0; i < getRange.length ;i++){
		    				getRange[i].set("createdBy",$this.getIdValueJson(response.createdBy.id));
			    			getRange[i].set("documentName",response.name);
			    			getRange[i].set("path",response.path);
			    			getRange[i].set("type",response.type);
			    			getRange[i].set("groupDetails",getRange[i].data.groupDetails);
			    			getRange[i].set("documentId",null);
		    			}
	    			}
	    		$this.getDocumentController().closeDocumentFormWindow();
	    		showSuccessMessage(getCommonTranslation('ASSIGNMENT_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	    	}, isTransient);
	    },
	    
	    
        getIdValueJson: function(id, value) {
      	  if (id) return {
      		  id: id,
      		  value: value
      	  };
        },
     /**
      *  editUploadAllDoc show uploaded doc at edit time in all grid
      */
     editUploadAllDoc:function(grid,id,records,editData){
    	 var $this = this;
    	 models = grid.getStore().getRange();
    	 Ext.Ajax.request({
    		 type : 'rest',
    		 url :SERVERURL.GROUP_HOMEWORK_ASSIGNMENT_DOCUMENT +'?&page=1&limit=-1',
    		 params : {
    			 courseHomeWorkAssignmentId : id
    		 },
    		 method : 'GET',
    		 success : function(form, action) {
    			 var data =  Ext.JSON.decode(form.responseText);
    			 if(data.rows.length==0){
    				 for(var i=0; i< records.length; i++){
    					 models[i].set("id",editData.wsGroupHomeworkAssignments[i].id);
						 models[i].set("randomNumber",editData.wsGroupHomeworkAssignments[i].randomNumber);
    					 if(Ext.isDefined(data.rows[i])){
    						 models[i].set("documentId",data.rows[i].documentId);
    						 models[i].set("documentName",data.rows[i].documentName);
    						 models[i].set("path",data.rows[i].path);
    					 }
    					 else{
    						 models[i].set("documentId","");
    						 models[i].set("documentName","");
    						 models[i].set("path","");
    					 }

    				 }
    			 }else{
    				 for(var i=0; i< models.length; i++){
    					 for(var j=0; j< data.rows.length; j++){
    						 if(models[i].data.admissionNo == data.rows[j].admissionId){
    							 models[i].set("randomNumber",data.rows[j].randomNumber);
    							 //grid.getSelectionModel().select(records[i],records[i]);
    							 models[i].set("id",data.rows[j].groupHomeworkAssignmentId);
    							 if(Ext.isDefined(data.rows[j])){
    								 models[i].set("documentId",data.rows[j].documentId);
    								 models[i].set("documentName",data.rows[j].documentName);
    								 models[i].set("path",data.rows[j].path);
    							 }
    							 else{
    								 models[i].set("documentId","");
    								 models[i].set("documentName","");
    								 models[i].set("path","");
    							 }
    						 }
    					 }	
    				 }
    			 }


    			 $this.getContentPanel().getActiveTab().body.setScrollTop(0);
    		 }
    	 });
     },
     submitAssignmentDocumentUpload : function(){
    	 var grid = this.getSearchresultgrid();
    	 var portalId = this.getCurrentLoggedPortalId();
    	 var serverCurrentDate=null;
    	 var serverTimeZone=null;
    	 if (grid.getSelectionModel().getCount() > 0) {
    		 $this = this;
    		 var selectedRecord = grid.getSelectionModel().getSelection()[0]; 
    		 var assignmentId=selectedRecord.data.ID;
    		 var groupHwAssignmentId=selectedRecord.data.HW_ASSIGNMENT_ID;
    		 var submitedOn=selectedRecord.data.HW_SUBMISSION_DATE;
    		 var resubmissionDueDate=selectedRecord.data.RESUBMISSION_DUE_DATE_LONG;
    		 var status=selectedRecord.data.STATUS;
    		var studentId= $this.getCurrentlyLoggedInUser().id;
    		 Ext.Ajax.request({
    			 type : 'rest',
    			 url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
    			 method : 'GET',
    			 async: false,
    			 success : function(form, action) {
    				 var data = Ext.JSON.decode(form.responseText);
    				 serverCurrentDate=data.serverDate;
    				 serverTimeZone=data.serverTimeZone;
    			 }});
    		 var todayDate=serverCurrentDate;
    		 var showDocumentWindow=false;
        	 // check for group leader upload document 
    		 if((portalId == 3 || portalId == 7) && selectedRecord.data.ASSIGNMENT_TYPE == 'Group'){
    			 if(!isNullOrEmpty(status) && status=="Resubmitted" && !isNullOrEmpty(resubmissionDueDate) && todayDate<=resubmissionDueDate){
    				 //$this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,"Resubmitted");
    				 showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED')); 
    				 return;
    			 }else if(!isNullOrEmpty(status) && status=="Pending" && !isNullOrEmpty(resubmissionDueDate) && todayDate<=resubmissionDueDate){
					var studentId = this.getCurrentlyLoggedInUser().id;
					var store = this.getStore('coursetransaction.homework.submissiondetails.SubmissionDetailsGrid');
					store.getProxy().extraParams = {
					    id: selectedRecord.data.ID,
					    docType: 'SUBMITED_DOC',
					    userId: studentId
					};
					store.load({
					    callback: function(records, operation, success) {
					        if (success) {
					            if (records[0].data.whetherGroupLeader == null) {
					                showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('GROUP_LEAD_ALERT'));
					            } else {
					            	 Ext.Ajax.request({
	                            		 type : 'rest',
	                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
	                            		 params : {
	                            			 studentIds : studentId,
	             						},
	                            		 method : 'GET',
	                            			 success: function(response) {
	                            				 if (!isNullOrEmpty(response.responseText)){
	                            					 	if (response.responseText=="true") {
	                            					 		$this.linkHomeworkAssignmentDocuments(groupHwAssignmentId, "Pending");
	                            					 	} else {
	                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
	                            					 	}
	                            				 }else{
	                            					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId, "Pending");
	                            					 }
	                            				 }
	                            	 });
					                
					            }
					        }
					    }
					});
				}else{
    				 if(!isNullOrEmpty(submitedOn)){
    					 showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED')); 
    					 return;
    				 }
    				 var studentId = this.getCurrentlyLoggedInUser().id;
    				 var store = this.getStore('coursetransaction.homework.submissiondetails.SubmissionDetailsGrid');
    				 store.getProxy().extraParams = {					  
    					 id:selectedRecord.data.ID,
    					 docType:'SUBMITED_DOC',
    					 userId:studentId
    				 };
    				 store.load({
    					 callback: function(records, operation, success) {
    						 if (success) {
    							 if(records[0].data.whetherGroupLeader == null){
    								 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GROUP_LEAD_ALERT'));									
    							 }
    							 else if(selectedRecord.data.HWONLINESUBMISSIONS == 'Yes' && records[0].data.whetherGroupLeader != null){
    								 showDocumentWindow=true;
    								 Ext.Ajax.request({
    									 method: "GET",
    									 type: 'rest',
    									 url: SERVERURL.HW_ASSIGNMENT_DETAILS_FINDBYID,
    									 headers: {
    										 'Content-Type': 'application/json'
    									 },
    									 params:{
    										 id : assignmentId
    									 },
    									 success:function(response, action){
    										 var data = Ext.decode(response.responseText);
    										 if(!isNullOrEmpty(data.extendedDate)){
    											 if(todayDate<=data.extendedDate){
    			                            			 Ext.Ajax.request({
    					                            		 type : 'rest',
    					                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
    					                            		 params : {
    					                            			 studentIds : studentId,
    					             						},
    					                            		 method : 'GET',
    					                            			 success: function(response) {
    					                            				 if (!isNullOrEmpty(response.responseText)){
    					                            					 	if (response.responseText=="true") {
    					                            					 		 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
    					                            					 	} else {
    					                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
    					                            					 	}
    					                            				 }else{
    					                            					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);;
    					                            					 }
    					                            				 }
    					                            	 });
    												 
    												 //1$this.getDocumentController().showDocumentFormWindow('homeworkAssignmentSubmissionDocument', 'DOCUMENT'); 
    											 }else{
    												 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('YOU_CANNOT_SUBMIT_THIS_ASSIGNMENT_AS_SUBMISSION_DEADLINE_HAS_ALREADY_PASSED'));
    											 }
    										 }else{
    											 if(todayDate<=data.dateSubmitted){
    												 Ext.Ajax.request({
					                            		 type : 'rest',
					                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
					                            		 params : {
					                            			 studentIds : studentId,
					             						},
					                            		 method : 'GET',
					                            			 success: function(response) {
					                            				 if (!isNullOrEmpty(response.responseText)){
					                            					 	if (response.responseText=="true") {
					                            					 		 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
					                            					 	} else {
					                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
					                            					 	}
					                            				 }else{
					                            					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);;
					                            					 }
					                            				 }
					                            	 });
    												 //2$this.getDocumentController().showDocumentFormWindow('homeworkAssignmentSubmissionDocument', 'DOCUMENT'); 
    											 }else{
    												 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('YOU_CANNOT_SUBMIT_THIS_ASSIGNMENT_AS_SUBMISSION_DEADLINE_HAS_ALREADY_PASSED')); 
    											 }
    										 }

    									 }
    								 });
    							 }else{
    								 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ONLINE_DOC_SUBMISSION')); 
    							 }
    						 }
    					 }
    				 });  
    			 }

    		 }else{
        		 if(selectedRecord.data.HWONLINESUBMISSIONS == 'Yes'){
        			 if(!isNullOrEmpty(status) && status=="Resubmitted" && !isNullOrEmpty(resubmissionDueDate) && todayDate<=resubmissionDueDate){
        				 //$this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,"Resubmitted");
        				 showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED')); 
        				 return;
        			 }else if(!isNullOrEmpty(status) && status=="Pending" && !isNullOrEmpty(resubmissionDueDate) && todayDate<=resubmissionDueDate){
        				 Ext.Ajax.request({
                    		 type : 'rest',
                    		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
                    		 params : {
                    			 studentIds : studentId,
     						},
                    		 method : 'GET',
                    			 success: function(response) {
                    				 if (!isNullOrEmpty(response.responseText)){
                    					 	if (response.responseText=="true") {
                    					 		 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,"Pending");
                    					 	} else {
                    					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
                    					 	}
                    				 }else{
                    					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,"Pending");
                    					 }
                    				 }
                    	 });
        				
        			 }else{
        				 if(!isNullOrEmpty(submitedOn)){
        					 showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED')); 
        					 return;
        				 }
        				 showDocumentWindow=true;

        				 Ext.Ajax.request({
        					 method: "GET",
        					 type: 'rest',
        					 url: SERVERURL.HW_ASSIGNMENT_DETAILS_FINDBYID,
        					 headers: {
        						 'Content-Type': 'application/json'
        					 },
        					 params:{
        						 id : assignmentId
        					 },
        					 success:function(response, action){
        						 var data = Ext.decode(response.responseText);
        						 if(!isNullOrEmpty(data.extendedDate)){
        							 if(todayDate<=data.extendedDate){
        								 Ext.Ajax.request({
		                            		 type : 'rest',
		                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
		                            		 params : {
		                            			 studentIds : studentId,
		             						},
		                            		 method : 'GET',
		                            			 success: function(response) {
		                            				 if (!isNullOrEmpty(response.responseText)){
		                            					 	if (response.responseText=="true") {
		                            					 		 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
		                            					 	} else {
		                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
		                            					 	}
		                            				 }else{
		                            					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);;
		                            					 }
		                            				 }
		                            	 });
        								
        							 }else{
        								 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('YOU_CANNOT_SUBMIT_THIS_ASSIGNMENT_AS_SUBMISSION_DEADLINE_HAS_ALREADY_PASSED'));
        							 }
        						 }else{
        							 if(todayDate<=data.dateSubmitted){
        								 Ext.Ajax.request({
		                            		 type : 'rest',
		                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
		                            		 params : {
		                            			 studentIds : studentId,
		             						},
		                            		 method : 'GET',
		                            			 success: function(response) {
		                            				 if (!isNullOrEmpty(response.responseText)){
		                            					 	if (response.responseText=="true") {
		                            					 		 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
		                            					 	} else {
		                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_LIME_SURVEY_IS_PENDING'));
		                            					 	}
		                            				 }else{
		                            					 $this.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);;
		                            					 }
		                            				 }
		                            	 });
        								 
        							 }else{
        								 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('YOU_CANNOT_SUBMIT_THIS_ASSIGNMENT_AS_SUBMISSION_DEADLINE_HAS_ALREADY_PASSED')); 
        							 }
        						 }

        					 }
        				 }); 
        			 }
        		 }else{
        			 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ONLINE_DOC_SUBMISSION')); 
        		 }        		 
        	 }
    	 }else{
    		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
    	 }
     },
     saveAssignmetDocument : function(){
    	 var $this=this;
    	 var grid = this.getSearchresultgrid();
    	 var isTransient = true;
    	 var module = 'homeworkAssignmentSubmission';
    	 var entityId ;
    	 var entityType = 'homeworkAssignmentSubmission';

    	 $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){

    		 if (grid.getSelectionModel().getCount() > 0) {
    			 var record = grid.getSelectionModel().getSelection()[0];
    			 var id = record.get("HW_ASSIGNMENT_ID");
    			 Ext.Ajax.request({
    				 type : 'rest',
    				 url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
    				 method : 'GET',
    				 async: false,
    				 success : function(form, action) {
    					 var data = Ext.JSON.decode(form.responseText);
    					 var todayDate = data.serverDateTimeYYYYMMDD;
    					 var data = {
    							 "id": id,
    							 "docType": "SUBMITED_DOC",
    							 "submissionStatus": "Completed",
    							 "submissionDate": todayDate,
    							 "documents": [{
    								 //"createdBy": $this.getIdValueJson(response.createdBy.id),
    								 "name": response.name,
    								 "path": response.path,
    								 "type": response.type
    							 }]
    					 };

    					 Ext.Ajax.request({
    						 type : 'rest',
    						 url : SERVERURL.HW_SUMBMISSION_DOC_UPLOAD,
    						 jsonData : data,
    						 method : 'POST',
    						 success : function(response, action) {
    							 showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
    							 //$this.getTopicgrid().getStore.reload();
    							 grid.getStore().load();
    							 grid.getSelectionModel().deselectAll(true);
    						 }
    					 });	

    				 }});
    		 }
    		 $this.getDocumentController().closeDocumentFormWindow();
    	 }, isTransient);
     
     },
     //******************Disable Upload Document  button**********************************
	    disableUploadDocumentPivileges: function(grid,permissionsMap) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	var uploadDocument = grid.down('#submitAssignmentDocument');
	    	var bulkDocumentDownload=grid.down('#bulkDownloadDocId');
	    	var exportReportBtn = grid.down('#exportReportBtnId');
	    	bulkDocumentDownload.setVisible(false);
	    	uploadDocument.setVisible(false);
	    	exportReportBtn.setVisible(false);
	    	
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'UPLOAD_DOCUMENT') {
	        		if(!isNullOrEmpty(uploadDocument)){
	        			uploadDocument.setVisible(true);
	        		}        		
	        	}
	    		if (privilege === 'BULK_DOCUMENT_DOWNLOAD') {
	        		if(!isNullOrEmpty(bulkDocumentDownload)){
	        			bulkDocumentDownload.setVisible(true);
	        		}        		
	        	}
	    		if (privilege === 'EXPORT_REPORT') {
	        		if(!isNullOrEmpty(exportReportBtn)){
	        			exportReportBtn.setVisible(true);
	        		}        		
	        	}
	    	});
	    	var portalId = this.getCurrentLoggedPortalId();
	    	if(portalId==3 || portalId==7){
	    		if(!isNullOrEmpty(uploadDocument)){
	    			uploadDocument.setDisabled(true);
	    		}
	    	}
	    },
	    tabVisibilityCheck: function(permissionsMap) {
	    	var panelItem = new Array();
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	
			var structure =  this.getHomeworkstructure();
	    	panelItem.push({
	    		xtype:'container',
	    		title : getCourseTxCommonTranslation('HW_ASSIGNMENT_DETAILS'),	
	    		items:[{
	    			xtype: 'assignmentdetails',
	    			itemId:'assignmentDetailsItemId',
	    		}]
	    	});
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'SUBMISSION_DETAILS') {
	    			panelItem.push({
	    				title : getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),	
	    				xtype: 'submissiondetailsgridstructure',
	    				itemId:'submissionDetailsGridStructureItemId',
	    				disabled :true
	    			});
	    		}
	    		if (privilege === 'ASSESSMENT_DETAILS') {
	    			panelItem.push({
	    				title : getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'),	
	    				xtype: 'evaluationdetailsgridstructure',
	    				itemId:'evaluationDetailsGridStructureItemId',
	    				disabled :true
	    			});
	    		}
	    	});
	    	structure.add(panelItem);
	    	setTimeout(function(){
	    		structure.setActiveTab(0);
	    	},300);
	    },
	    linkHomeworkAssignmentDocuments: function(groupHwAssignmentId,status) {
	    	var docWindow = this.getUploadstudenthomeworkassignmentdocument();
	    	var studentId = this.getCurrentlyLoggedInUser().id;
	    	var portalId = this.getCurrentLoggedPortalId();
	    	var homeWorkAssignmentStatus=null;
	    	if(!isNullOrEmpty(status) && status=="Resubmitted"){
	    		homeWorkAssignmentStatus=status;
	    	}
	    	if(portalId==3 || portalId==7){
	    		var uploadedBy="student";
	    	}else{
	    		var uploadedBy="faculty"
	    	}
	    	if (!docWindow) {
	    		Ext.widget('uploadstudenthomeworkassignmentdocument');
	    		docWindow = this.getUploadstudenthomeworkassignmentdocument();
	    	}
	    	docWindow.show();
	    	docWindow.down('#groupHwAssignmentId').setValue(groupHwAssignmentId);
	    	var grid = this.getHomeworkassignmentdocumentgrid();
	    	var store = grid.getStore();
	    	store.getProxy().extraParams = {
	    		groupHomeworkAssignmentId: groupHwAssignmentId,
	    		docType:'SUBMITED_DOC'
	    	};
	    	store.load();
	    	setTimeout(function(){
	    		if(store.data.items.length>0){
	    			docWindow.down('#saveBtn').setDisabled(false);
	    			docWindow.down('#submitBtn').setDisabled(false);
	    		}
	    		if(portalId!=3 && portalId!=7) {
	    			docWindow.down('#saveBtn').setVisible(false);
	    		}
	    		docWindow.down('#status').setValue(homeWorkAssignmentStatus);
	    	},300);
	    },
	    addMultipleAssignmentDocument : function(){
	    	 var $this=this;
	    	 var winform=$this.getUploadstudenthomeworkassignmentdocument();
	    	 var isTransient = true;
	    	 var module = 'homeworkAssignmentMultipleSubmission';
	    	 var entityId ;
	    	 var entityType = 'homeworkAssignmentMultipleSubmission';
	    	 $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', 
	    			 function(success, response, isCallBackTransient){
				   var documentModel = new Academia.model.course.CourseDocument();
				   documentModel.set("documentName",response.name);
				   documentModel.set("path",response.path);
				   documentModel.set("type",response.type);
				   documentModel.set("documentName",response.name);
				   documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
				   var HomeworkAssignmentDocument = $this.getHomeworkassignmentdocumentgrid();
				   var store = HomeworkAssignmentDocument.getStore();
				   store.add(documentModel);
				   if (HomeworkAssignmentDocument.isHidden() && store.data.items.length > 0) {
					   HomeworkAssignmentDocument.setVisible(true);
					}
				   winform.down('#saveBtn').setDisabled(false);
				   winform.down('#submitBtn').setDisabled(false);
				   $this.getDocumentController().closeDocumentFormWindow();
				   showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS'));
				}, isTransient);
	    },
	    saveHomeworkAssignmentMultipleDocument:function(){
	    	var $this=this;
	    	var portalId = this.getCurrentLoggedPortalId();
	    	var submissiondetailsgrid = null;
	    	var uploadedBy=null;
	    	var winForm=this.getUploadstudenthomeworkassignmentdocument();
	    	var status=null;
	    	if(portalId==3 || portalId==7){
	    		uploadedBy="student";
	    		var homeWorkAssignmentStatus=winForm.down("#status").getValue();
	    		if(!isNullOrEmpty(homeWorkAssignmentStatus) && homeWorkAssignmentStatus=="ReSubmitted"){
	    			status=homeWorkAssignmentStatus;
	    		}
	    	}else{
	    		uploadedBy="faculty";
	    		submissiondetailsgrid = $this.getSubmissiondetailsgrid();
	    		if(submissiondetailsgrid.isVisible()==false){
	    			submissiondetailsgrid = $this.getSubmissiondetailsgridnew();
	    		}
	    	}
	    	
	    	winForm.down('#saveBtn').setDisabled(true);
	    	var grid=this.getHomeworkassignmentdocumentgrid();
	    	var records = grid.getSelectionModel().getSelection();
	    	var id = winForm.down('#groupHwAssignmentId').getValue();
	    	var docStore=grid.getStore();
	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	var docArray = [];
	    	if (docStore.data.items != null && docStore.data.items.length > 0) {
     		   Ext.each(docStore.data.items, function(val) {
     			   var newData = {
     					   "name" : val.data.documentName,
     					   "path" : val.data.path,
     					   "type" : "DOCUMENT",
     					   "submissionDate":isNullOrEmpty(val.data.submissionDate) ? null: Ext.Date.format(new Date(val.data.submissionDate), CONSTANTS.NEW_SUBMIT_DATE_TIME_FORMAT),
     						"id":val.data.id,
     			   };
     			   docArray.push(newData);
     		   });
     	   }
	    	var data = {
	    			"id": id,
	    			"docType": "SUBMITED_DOC",
	    			"submissionStatus": isNullOrEmpty(status) ? "Drafted":status,
	    			"submissionDate": null,
	    			"uploadedBy":uploadedBy,
	    			"documents": docArray
	    	};
	    	Ext.Ajax.request({
					 type : 'rest',
					 url : SERVERURL.HW_SUMBMISSION_MULTIPLE_DOC_UPLOAD,
					 jsonData : data,
					 method : 'POST',
					 success : function(response, action) {
						 showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getPersonModuleTranslation('DOCUMENTS_SAVED_SUCCESSFULLY'));
						 winForm.down('#saveBtn').setDisabled(false);
						 Ext.getBody().unmask();
						 grid.getStore().load();
						 grid.getSelectionModel().deselectAll(true);
						 if(!isNullOrEmpty(submissiondetailsgrid)){
							 submissiondetailsgrid.getStore().load();
							 submissiondetailsgrid.getSelectionModel().deselectAll(true);
							 if(portalId!=3 || portalId!=7){
							 var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentDetailGridStore');
								store.reload();
							 }
						 }
						 winForm.close();
					 }
				 });
	    	 

	    },
	    loadStudentScheduleField : function(radio,newValue, oldValue){
	    	var me = this;
	    	var adhocMessageForm = radio.up('form');
	    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	    	var publishDateField = adhocMessageForm.down('#publishDate');
	    	var publishTimeField = adhocMessageForm.down('#publishTime');
	    	var timeGivenField=adhocMessageForm.down('#timeGiven');
	    	var dateGivenField=adhocMessageForm.down('#dateGiven');
	    	var radioValue = radio.getValue().sendingPriority;

	    	if(radioValue=='IMMEDIATE'){
	    		scheduleDateField.setVisible(false);
	    		scheduleDateField.setDisabled(true);
	    		scheduleTimeField.setVisible(false);
	    		scheduleTimeField.setDisabled(true);
	    		me.setAllowBlank(scheduleDateField,true);
	    		me.setAllowBlank(scheduleTimeField,true);
	    		adhocMessageForm.getForm().checkValidity();
	    	}
	    	else if(radioValue=='SCHEDULE'){
	    		scheduleDateField.setVisible(true);
	    		scheduleDateField.setDisabled(false);
	    		scheduleTimeField.setVisible(true);
	    		scheduleTimeField.setDisabled(false);
	    		scheduleDateField.reset();
	    		scheduleTimeField.reset();
	    		me.setAllowBlank(scheduleDateField,false);
	    		me.setAllowBlank(scheduleTimeField,false);
	    		if(!isNullOrEmpty(publishDateField.getValue())){
	    			scheduleDateField.setValue(publishDateField.getValue());
	    		}
	    		if(!isNullOrEmpty(publishTimeField.getValue())){
	    			if(publishDateField.getValue().getDate()==dateGivenField.getValue().getDate()){
	    				scheduleTimeField.setMinValue(timeGivenField.getValue());
	    			}
	    			else{
	    				scheduleTimeField.setMinValue(publishTimeField.getValue());
	    			}
//	    			var newTime = Ext.Date.add(timeGivenField.getValue(), Ext.Date.MINUTE, 30);
//	    			scheduleTimeField.setMinValue(newTime);
//	    			scheduleTimeField.setValue(newTime);
	    			scheduleTimeField.setValue(publishTimeField.getValue());
	    			if(scheduleTimeField.readOnly){
	    				scheduleTimeField.setMinValue(false);
	    				scheduleTimeField.setMaxValue(false);
	    				scheduleTimeField.clearInvalid();
	    			}
	    		}
	    		adhocMessageForm.getForm().checkValidity();
	    	}
	    },
	    showSendingPriorityField: function(checkboxfield,newValue, oldValue){
	    	var me = this;
	    	var adhocMessageForm = checkboxfield.up('form');
	    	var sendingPriority = adhocMessageForm.down('#sendingPriority');
	    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	    	var publishDateField = adhocMessageForm.down('#publishDate');
	    	var publishTimeField = adhocMessageForm.down('#publishTime');
	    	var dateSubmittedField = adhocMessageForm.down('#dateSubmitted');
	    	var submittedTimeField = adhocMessageForm.down('#submittedTime');
	    	var timeGivenField=adhocMessageForm.down('#timeGiven');
	    	var dateGivenField=adhocMessageForm.down('#dateGiven');
	    	
	    	if(newValue){
	    		sendingPriority.setVisible(true);
	    		me.setAllowBlank(sendingPriority,false);
	    		sendingPriority.down('#schedule').setValue(true);
	    		if(!isNullOrEmpty(publishDateField.getValue())){
	    			scheduleDateField.setValue(publishDateField.getValue());
	    			scheduleDateField.setMinValue(dateGivenField.getValue());
	    		}
	    		if(!isNullOrEmpty(publishTimeField.getValue())){
	    			//var newTime = Ext.Date.add(timeGivenField.getValue(), Ext.Date.MINUTE, 30);
	    			//scheduleTimeField.setMinValue(newTime);
	    			//scheduleTimeField.setValue(newTime);
	    			if(publishDateField.getValue().getDate()==dateGivenField.getValue().getDate()){
	    				scheduleTimeField.setMinValue(timeGivenField.getValue());
	    			}
	    			else{
	    				if(scheduleDateField.getValue().getDate()>dateGivenField.getValue().getDate()){
	    					scheduleTimeField.setMinValue(false);
	    				}
	    				else{
	    					scheduleTimeField.setMinValue(publishTimeField.getValue());
	    				}
	    			}
	    			scheduleTimeField.setValue(publishTimeField.getValue());
	    		}
	    		if(scheduleDateField.getValue().getDate()==dateSubmittedField.getValue().getDate()){
	    			var maxVal = submittedTimeField.getValue();
	    			scheduleTimeField.setMaxValue(maxVal);
	    		} else if(dateSubmittedField.getValue().getDate()>scheduleDateField.getValue().getDate()){
	    			scheduleTimeField.setMaxValue(false);
	    		}
	    		if(scheduleTimeField.readOnly){
    				scheduleTimeField.setMinValue(false);
    				scheduleTimeField.setMaxValue(false);
    				scheduleTimeField.clearInvalid();
    			}
	    		adhocMessageForm.getForm().checkValidity();
	    	}
	    	else{
	    		sendingPriority.setVisible(false);
	    		me.setAllowBlank(sendingPriority,true);
	    		sendingPriority.down('#immediate').setValue(true);
	    		adhocMessageForm.getForm().checkValidity();
	    	}
	    },
	    hideConfigureNotificationPnl: function(formReference,permissionMap){
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
	    	var configureNotificationFld = formReference.down('#configureNotificationId');
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'CONFIGURE_NOTIFICATIONS') {
	    			configureNotificationFld.setVisible(true);
	    		}
	    	});
	    },
	    generateHomeworkAssignmentReport:function(tempCode){
	    	var $this = this;
	    	var code = "RANDOM_CODE_REPORT";
	    	var homeworkassignmentsearch=$this.getHomeworkassignmentsearch();
	    	var homeworkassignmentsearchForm = homeworkassignmentsearch.getForm();
	    	var window = $this.getGenerateassignmentdetailsreportwin();
	    	var code;
    	    if(tempCode) {
    		   code = tempCode;
    	    } else {
    		   code = window.down('#chooseTemplate').valueModels[0].data.value;
    	    }

	    	var formValues = homeworkassignmentsearch.getValues();
	    	var academicTermId = formValues.ACADEMIC_TERM;
	    	var programId = formValues.program;
	    	var batchId = formValues.batch;
	    	var periodId = formValues.period;
	    	var sectionId = formValues.sectionId;
	    	var courseId = formValues.course;
	    	var componentId = formValues.COMPONENT_ID;
	    	var courseVariantId = formValues.courseVarient;
	    	var facultyId=null;
	    	var facultys = formValues.facultyName;
	    	for(var i in formValues.facultyName){
	    		if(!isNullOrEmpty(formValues.facultyName[i])){
	    			facultyId=formValues.facultyName[i];
	    			break;
	    		}
	    	}
	    	if(portalId==2){
	    		facultyid = this.getCurrentlyLoggedInUser().id;
	    	}
	    	var sw_AssignmentType = homeworkassignmentsearchForm.findField('assignmentType').getRawValue();
	    	var sw_AssignmentName = homeworkassignmentsearchForm.findField('assignmentName').getRawValue();
	    	
	    	var assignmentType = null;
	    	if(sw_AssignmentType!=null && sw_AssignmentType!=""){
	    		assignmentType = sw_AssignmentType;
	    	}

	    	var assignmentName =null;
	    	if(sw_AssignmentName!=null && sw_AssignmentName!=""){
	    		assignmentName = sw_AssignmentName;
	    	}

	    	var assessmentIdentity = null;
	    	for(var i in formValues.assessmentType){
	    		if(!isNullOrEmpty(formValues.assessmentType[i])){
	    			if(formValues.assessmentType[i]=="All"){
	    				assessmentIdentity = null;
	    			}
	    			else if(formValues.assessmentType[i]=="Random Code Assessment"){
	    				assessmentIdentity = true;
	    			}
	    			else if(formValues.assessmentType[i]=="Regular Assessment"){
	    				assessmentIdentity = false;
	    			}
	    			break;
	    		}
	    	}
	    	var topicType = homeworkassignmentsearch.down('#topicType_Id').getRawValue();;
	    	var fromDate = null;
	    	for(var i in formValues.fromDate){
	    		if(!isNullOrEmpty(formValues.fromDate[i])){
	    			fromDate=formValues.fromDate[i];
	    			break;
	    		}
	    	}
	    	var toDate = null
	    	for(var i in formValues.toDate){
	    		if(!isNullOrEmpty(formValues.toDate[i])){
	    			toDate=formValues.toDate[i];
	    			break;
	    		}
	    	}
	    	var studentId = formValues.studentNameNew;
	    	var academyLocationId= $this.getCurrentAcademyLocation();
	    	var reportParams = new Object();
	    	reportParams.programId = programId;
	    	reportParams.batchId = batchId;
	    	reportParams.periodId = periodId;
	    	reportParams.sectionId = sectionId;
	    	reportParams.academicTermId = academicTermId;
	    	reportParams.studentId = studentId;
	    	reportParams.courseId = courseId;
	    	reportParams.componentId = componentId;
	    	reportParams.courseVariantId = courseVariantId;
	    	reportParams.facultyId = facultyId;
	    	reportParams.assignmentType = assignmentType;
	    	reportParams.assignmentName = assignmentName;
	    	reportParams.assessmentIdentity = assessmentIdentity;
	    	reportParams.topicType = topicType;
	    	reportParams.fromDate = fromDate;
	    	reportParams.toDate = toDate;
	    	reportParams.academyLocationId = academyLocationId;
	    	var exportUrl = SERVERURL.PATH_GENERATE_HOMEWORK_ASSIGNMENT_REPORT;
	    	reportParams.headerName = "Random Code Report";
	    	if(window != undefined) {
	     		   window.close();
	        }
	    	var flag = true;
	    	if(code == 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT'){
	    		if(isNullOrEmpty(academicTermId) || isNullOrEmpty(courseId) || isNullOrEmpty(courseVariantId)){
	    			var flag = false;
	    		} else{
	    			reportParams.headerName = "GNA Homework and Assignment Assessment Report";
	    		}
	    	}
	    	if(flag){
	    		$this.exportJRXMLReport(code,reportParams,reportParams.headerName,'.vnd.ms-excel',exportUrl);
	    	} else{
	    		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT_MSG'));
	    	}
	    },
	    generateFacultyHomeworkAssignmentReport:function(tempCode){
	    	var $this = this;
	    	var code = "RANDOM_CODE_REPORT";
	    	var homeworkassignmentsearch=$this.getFacultyhomeworkassignmentsearch();
	    	var homeworkassignmentsearchForm = homeworkassignmentsearch.getForm();
	    	var window = $this.getGenerateassignmentdetailsreportwin();
	    	var code;
    	    if(tempCode) {
    		   code = tempCode;
    	    } else {
    		   code = window.down('#chooseTemplate').valueModels[0].data.value;
    	    }

	    	var formValues = homeworkassignmentsearch.getValues();
	    	var academicTermId = formValues.FACULTY_ACADEMIC_TERM;
	    	var programId = formValues.facultyprogram;
	    	var batchId = formValues.facultybatch;
	    	var periodId = formValues.facultyperiod;
	    	var sectionId = formValues.facultysectionId;
	    	var courseId = formValues.faculty_course_name;
	    	var componentId = formValues.COMPONENT_ID;
	    	var courseVariantId = formValues.facultycourseVarient;
	    	var facultyId=this.getCurrentlyLoggedInUser().id;
	    	
	    	var sw_AssignmentType = homeworkassignmentsearchForm.findField('facultyassignmentType').getRawValue();
	    	var sw_AssignmentName = homeworkassignmentsearchForm.findField('facultyassignmentName').getRawValue();
	    	
	    	var assignmentType = null;
	    	if(sw_AssignmentType!=null && sw_AssignmentType!=""){
	    		assignmentType = sw_AssignmentType;
	    	}

	    	var assignmentName =null;
	    	if(sw_AssignmentName!=null && sw_AssignmentName!=""){
	    		assignmentName = sw_AssignmentName;
	    	}

	    	var assessmentIdentity = null;
	    	for(var i in formValues.facultyassessmentType){
	    		if(!isNullOrEmpty(formValues.facultyassessmentType[i])){
	    			if(formValues.facultyassessmentType[i]=="All"){
	    				assessmentIdentity = null;
	    			}
	    			else if(formValues.facultyassessmentType[i]=="Random Code Assessment"){
	    				assessmentIdentity = true;
	    			}
	    			else if(formValues.facultyassessmentType[i]=="Regular Assessment"){
	    				assessmentIdentity = false;
	    			}
	    			break;
	    		}
	    	}
	    	var topicType = homeworkassignmentsearch.down('#facultytopicType_Id').getRawValue();;
	    	var fromDate = null;
	    	for(var i in formValues.facultyfromDate){
	    		if(!isNullOrEmpty(formValues.facultyfromDate[i])){
	    			fromDate=formValues.facultyfromDate[i];
	    			break;
	    		}
	    	}
	    	var toDate = null
	    	for(var i in formValues.facultytoDate){
	    		if(!isNullOrEmpty(formValues.facultytoDate[i])){
	    			toDate=formValues.facultytoDate[i];
	    			break;
	    		}
	    	}
	    	var studentId = formValues.facultystudentNameNew;
	    	var academyLocationId= $this.getCurrentAcademyLocation();
	    	var reportParams = new Object();
	    	reportParams.programId = programId;
	    	reportParams.batchId = batchId;
	    	reportParams.periodId = periodId;
	    	reportParams.sectionId = sectionId;
	    	reportParams.academicTermId = academicTermId;
	    	reportParams.studentId = studentId;
	    	reportParams.courseId = courseId;
	    	reportParams.componentId = componentId;
	    	reportParams.courseVariantId = courseVariantId;
	    	reportParams.facultyId = facultyId;
	    	reportParams.assignmentType = assignmentType;
	    	reportParams.assignmentName = assignmentName;
	    	reportParams.assessmentIdentity = assessmentIdentity;
	    	reportParams.topicType = topicType;
	    	reportParams.fromDate = fromDate;
	    	reportParams.toDate = toDate;
	    	reportParams.academyLocationId = academyLocationId;
	    	var exportUrl = SERVERURL.PATH_GENERATE_HOMEWORK_ASSIGNMENT_REPORT;
	    	reportParams.headerName = "Random Code Report";
	    	if(window != undefined) {
	     		   window.close();
	        }
	    	var flag = true;
	    	if(code == 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT'){
	    		if(isNullOrEmpty(academicTermId) || isNullOrEmpty(courseId) || isNullOrEmpty(courseVariantId)){
	    			var flag = false;
	    		} else{
	    			reportParams.headerName = "GNA Homework and Assignment Assessment Report";
	    		}
	    	}
	    	if(flag){
	    		$this.exportJRXMLReport(code,reportParams,reportParams.headerName,'.vnd.ms-excel',exportUrl);
	    	} else{
	    		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT_MSG'));
	    	}
	    },
	    
	    jsonCreationForCoreErp : function() {
	    	var courseId = this.getHomeworkassignmentsearch().getForm().findField('course').getValue();
			 var accCourseIds = [];
			 Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.FIND_ALL_ACCESSIBLE_COURSES,
					params : {
						academyLocationId : this.getCurrentAcademyLocation()
					},
					method : 'GET',
					async: false,
					success : function(response) {
						var data = Ext.decode(response.responseText);
						for(var i=0; i< data.length ;i++){
							if(!isNullOrEmpty(data[i])){
								accCourseIds.push(data[i]);
							}
	             	   }
					}
				});
			 var accessibleCourseIds =accCourseIds.join();
			 var homeworkAssignmentsearchForm = this.getHomeworkassignmentsearch().getForm();
			 
			 var academicTermId = homeworkAssignmentsearchForm.findField('ACADEMIC_TERM').value;
			 var programNameId = homeworkAssignmentsearchForm.findField('program').value;
			 var batchNameId = homeworkAssignmentsearchForm.findField('batch').getValue();
			 var periodNameId = homeworkAssignmentsearchForm.findField('period').getValue();
			 var sectionNameId = homeworkAssignmentsearchForm.findField('sectionId').getValue();
			 var academyLocationId = this.getCurrentAcademyLocation();
			 
			 
			 var sw_AssignmentType = homeworkAssignmentsearchForm.findField('assignmentType').getRawValue();
			 var sw_FromDate = homeworkAssignmentsearchForm.findField('fromDate').getValue();
			 var sw_ToDate = homeworkAssignmentsearchForm.findField('toDate').getValue();
			 var sw_AssignmentId = homeworkAssignmentsearchForm.findField('assignmentName').getValue();
			 var sw_assessmentType = homeworkAssignmentsearchForm.findField('assessmentType').getValue();
			 var sw_studentNameNew = homeworkAssignmentsearchForm.findField('studentNameNew').getValue();
			
			var tw_TopicType = homeworkAssignmentsearchForm.findField('topicTypeId').getRawValue();
			var tw_TopicName = homeworkAssignmentsearchForm.findField('topicName').getValue();

			var secWise_courseVarient = homeworkAssignmentsearchForm.findField('courseVarient').getValue();
			 
		     var values = new Object();
		     var searchcriteria = new Array();
		     var portalId = this.getCurrentLoggedPortalId();
				if(portalId == 3 || portalId == 7) {
					values.configCode = CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_STUDENT_CONFIGCODE;
				} else {
					values.configCode = CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_CONFIGCODE;
				}
		     
		     var COURSE_VARIANTS_ID = this.getJsonObject('COURSE_VARIANTS_ID', secWise_courseVarient);
		     this.pushJsonObjectInArray(COURSE_VARIANTS_ID,searchcriteria);
		     
		     var ACCESSIBLE_PARENT_COURSE_ID = this.getJsonObject('ACCESSIBLE_PARENT_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_PARENT_COURSE_ID,searchcriteria);
		     var ACCESSIBLE_COURSE_ID = this.getJsonObject('ACCESSIBLE_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_COURSE_ID,searchcriteria);
		     
		     var assignmentTypeFilter=null;
		     var facultyIdFilter=null;
		     var assessmentTypeFilter=null;
		     
		     if(sw_AssignmentType!=null && sw_AssignmentType!=""){
		    	 assignmentTypeFilter = sw_AssignmentType;
		     }
		     
		     if(sw_assessmentType!=null && sw_assessmentType!=""){
		    	 assessmentTypeFilter = sw_assessmentType;
		     }
		     
		     if(assessmentTypeFilter=="All"){
		    	 assessmentTypeFilter = null;
		     }
		     else if(assessmentTypeFilter=="Random Code Assessment"){
		    	 assessmentTypeFilter = true;
		     }
		     else if(assessmentTypeFilter=="Regular Assessment"){
		    	 assessmentTypeFilter = false;
		     }
		     	     
		     var ASSIGNMENT_TYPE = this.getJsonObject('ASSIGNMENT_TYPE', assignmentTypeFilter);
		     this.pushJsonObjectInArray(ASSIGNMENT_TYPE,searchcriteria);
		     
		     var FACULTY_ID = this.getJsonObject('FACULTY_ID', facultyIdFilter);
		     this.pushJsonObjectInArray(FACULTY_ID,searchcriteria);
		     if(!isNullOrEmpty(assessmentTypeFilter) && !assessmentTypeFilter){
		    	 var ASSESSMENT_IDENTITY = {
	                 "paramCode": 'ASSESSMENT_IDENTITY',
	                 "paramValues": [assessmentTypeFilter]
	             };
		    	 this.pushJsonObjectInArray(ASSESSMENT_IDENTITY,searchcriteria);
		     }else{
		    	 var ASSESSMENT_IDENTITY = this.getJsonObject('ASSESSMENT_IDENTITY', assessmentTypeFilter);
		    	 this.pushJsonObjectInArray(ASSESSMENT_IDENTITY,searchcriteria);
		     }
		     var COURSE_TOPIC_TYPE = this.getJsonObject('COURSE_TOPIC_TYPE', tw_TopicType);
		     this.pushJsonObjectInArray(COURSE_TOPIC_TYPE,searchcriteria);
		     
		    /* var COURSE_TOPIC_TYPE = this.getJsonObject('PROGRAM_CODE', programCodeId);
		     this.pushJsonObjectInArray(COURSE_TOPIC_TYPE,searchcriteria);*/
		     
		     var ACADEMIC_TERM_ID = this.getJsonObject('ACADEMIC_TERM_ID', academicTermId);
		     this.pushJsonObjectInArray(ACADEMIC_TERM_ID,searchcriteria);
		     
		     //var PROGRAM_TYPE = this.getJsonObject('PROGRAM_NAME', programNameId);
		     var PROGRAM_TYPE = this.getJsonObject('PROGRAM_ID', programNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('BATCH_ID', batchNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('PERIOD_ID', periodNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('SECTION_ID', sectionNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID',academyLocationId);
		     this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
		     
		     var fromDateFilter =null;
		     if(sw_FromDate!=null && sw_FromDate!=""){
		    	 fromDateFilter = sw_FromDate;
		     }
		     if(fromDateFilter !=null){
		     var sdate = Ext.Date.format(new Date(fromDateFilter), 'Y-m-d');
		     //if(sdate !=null){
		     var SUBMISSION_DATE_BEORE = this.getJsonObject('GIVEN_DATE_GREATER_OR_EQUAL', sdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_BEORE,searchcriteria);
		     }
		     
		     var toDateFilter = null;
		     if(sw_ToDate!=null && sw_ToDate!=""){
		    	 toDateFilter = sw_ToDate;
		     }
		     
		     if(toDateFilter !=null){
		     var tdate = Ext.Date.format(new Date(toDateFilter), 'Y-m-d');
		     
//		     if(tdate !=null){
		     var SUBMISSION_DATE_AFTER = this.getJsonObject('GIVEN_DATE_LESS_OR_EQUAL', tdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_AFTER,searchcriteria);
		     }
		     
		     // store the student id
		     if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
		    	 
		    	 var COURSE_ID = this.getJsonObject('COURSE_ID',studentCourseId);
			     this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
			     
			     var PROGRAM_TYPE = this.getJsonObject('PROGRAM_ID', attendanceProgramId)
			     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		    	
			     //var ADMISSION_ID = this.getJsonObject('ADMISSION_ID', this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id);
			     var STUDENT_ID = this.getJsonObject('STUDENT_ID', this.getCurrentlyLoggedInUserInfoForPortal().student.id);
		    	 this.pushJsonObjectInArray(STUDENT_ID,searchcriteria);
		    	 var serverCurrentDate=null;
				 Ext.Ajax.request({
	    			 type : 'rest',
	    			 url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
	    			 method : 'GET',
	    			 async: false,
	    			 success : function(form, action) {
	    				 data = Ext.JSON.decode(form.responseText);
	    				 serverCurrentDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
	    			 }});
		    	 var publishdate = serverCurrentDate;
			     var PUBLISH_DATE_AFTER = this.getJsonObject('PUBLISH_DATE_LESS_OR_EQUAL', publishdate);
			     this.pushJsonObjectInArray(PUBLISH_DATE_AFTER,searchcriteria);
		     
		     }else{
		    
		    	 var COURSE_ID = this.getJsonObject('COURSE_ID', courseId);
			     this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
		    	 
		    	 var STUDENT_ID = this.getJsonObject('STUDENT_ID', sw_studentNameNew);
		    	 this.pushJsonObjectInArray(STUDENT_ID,searchcriteria);
		     }
		     // from topic name dropdown
		     var COURSE_TOPIC_ID = this.getJsonObject('COURSE_TOPIC_ID', tw_TopicName);
		     this.pushJsonObjectInArray(COURSE_TOPIC_ID,searchcriteria);
		 
		     var courseAssignmentIdFilter=null;	   
		     if(sw_AssignmentId!=null && sw_AssignmentId!=""){
		    	 courseAssignmentIdFilter = sw_AssignmentId;
		     }
		     var COURSE_ASSIGNMENT_ID = this.getJsonObject('COURSE_ASSIGNMENT_ID', courseAssignmentIdFilter);
		     this.pushJsonObjectInArray(COURSE_ASSIGNMENT_ID,searchcriteria);
		     
		   //for faculty portal
		     var portalId = this.getCurrentLoggedPortalId();         
		     var facultyid=null;
		     if(portalId==2){
		    	 facultyid = this.getCurrentlyLoggedInUser().id;
		    	 var FACULTY_ID = this.getJsonObject('FACULTY_ID', facultyid);
		    	 this.pushJsonObjectInArray(FACULTY_ID,searchcriteria);
		     }
		    
	         values.searchCriterias = searchcriteria;
	         return values;
	    },
	    
	    jsonCreationForFacultyPortal : function() {
	    	var homeworkAssignmentsearchForm = this.getFacultyhomeworkassignmentsearch().getForm();
	    	var courseId = homeworkAssignmentsearchForm.findField('faculty_course_name').getValue();
			 var accCourseIds = [];
			 Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.FIND_ALL_ACCESSIBLE_COURSES,
					params : {
						academyLocationId : this.getCurrentAcademyLocation()
					},
					method : 'GET',
					async: false,
					success : function(response) {
						var data = Ext.decode(response.responseText);
						for(var i=0; i< data.length ;i++){
							if(!isNullOrEmpty(data[i])){
								accCourseIds.push(data[i]);
							}
	             	   }
					}
				});
			 var accessibleCourseIds =accCourseIds.join();
			 
			 var academicTermId = homeworkAssignmentsearchForm.findField('FACULTY_ACADEMIC_TERM').value;
			 var courseVariantId = homeworkAssignmentsearchForm.findField('facultycourseVarient').getValue();
			 var programNameId = homeworkAssignmentsearchForm.findField('facultyprogram').value;
			 var batchNameId = homeworkAssignmentsearchForm.findField('facultybatch').getValue();
			 var periodNameId = homeworkAssignmentsearchForm.findField('facultyperiod').getValue();
			 var sectionNameId = homeworkAssignmentsearchForm.findField('facultysectionId').getValue();
			 var academyLocationId = this.getCurrentAcademyLocation();
			 
			 var studentId = homeworkAssignmentsearchForm.findField('facultystudentNameNew').getValue();
			 
			 var topicType = homeworkAssignmentsearchForm.findField('facultytopicTypeId').getRawValue();
			 var topicName = homeworkAssignmentsearchForm.findField('facultytopicName').getValue();
				
			 var assignmentType = homeworkAssignmentsearchForm.findField('facultyassignmentType').getRawValue();
			 var assignmentId = homeworkAssignmentsearchForm.findField('facultyassignmentName').getValue();
			 var assessmentType = homeworkAssignmentsearchForm.findField('facultyassessmentType').getValue();
			 
			 var fromDate = homeworkAssignmentsearchForm.findField('facultyfromDate').getValue();
			 var toDate = homeworkAssignmentsearchForm.findField('facultytoDate').getValue();
			 
		     var values = new Object();
		     var searchcriteria = new Array();
	         
	         values.configCode = CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_CONFIGCODE;
		     
		     var COURSE_VARIANTS_ID = this.getJsonObject('COURSE_VARIANTS_ID', courseVariantId);
		     this.pushJsonObjectInArray(COURSE_VARIANTS_ID,searchcriteria);
		     
		     var ACCESSIBLE_PARENT_COURSE_ID = this.getJsonObject('ACCESSIBLE_PARENT_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_PARENT_COURSE_ID,searchcriteria);
		     var ACCESSIBLE_COURSE_ID = this.getJsonObject('ACCESSIBLE_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_COURSE_ID,searchcriteria);
		     
		     
		     var assessmentTypeFilter = '';
		     if(assessmentType=="All"){
		    	 assessmentTypeFilter = null;
		     }
		     else if(assessmentType=="Random Code Assessment"){
		    	 assessmentTypeFilter = true;
		     }
		     else if(assessmentType=="Regular Assessment"){
		    	 assessmentTypeFilter = false;
		     }
		     	     
		     var ASSIGNMENT_TYPE = this.getJsonObject('ASSIGNMENT_TYPE', assignmentType);
		     this.pushJsonObjectInArray(ASSIGNMENT_TYPE,searchcriteria);
		     
		     if(!isNullOrEmpty(assessmentTypeFilter) && !assessmentTypeFilter){
		    	 var ASSESSMENT_IDENTITY = {
	                 "paramCode": 'ASSESSMENT_IDENTITY',
	                 "paramValues": [assessmentTypeFilter]
	             };
		    	 this.pushJsonObjectInArray(ASSESSMENT_IDENTITY,searchcriteria);
		     }else{
		    	 var ASSESSMENT_IDENTITY = this.getJsonObject('ASSESSMENT_IDENTITY', assessmentTypeFilter);
		    	 this.pushJsonObjectInArray(ASSESSMENT_IDENTITY,searchcriteria);
		     }
		     
		     var COURSE_TOPIC_TYPE = this.getJsonObject('COURSE_TOPIC_TYPE', topicType);
		     this.pushJsonObjectInArray(COURSE_TOPIC_TYPE,searchcriteria);
		     
		     var ACADEMIC_TERM_ID = this.getJsonObject('ACADEMIC_TERM_ID', academicTermId);
		     this.pushJsonObjectInArray(ACADEMIC_TERM_ID,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('PROGRAM_ID', programNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('BATCH_ID', batchNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('PERIOD_ID', periodNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('SECTION_ID', sectionNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID',academyLocationId);
		     this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
		     
		     if(fromDate !=null){
		     var sdate = Ext.Date.format(new Date(fromDate), 'Y-m-d');
		     var SUBMISSION_DATE_BEORE = this.getJsonObject('GIVEN_DATE_GREATER_OR_EQUAL', sdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_BEORE,searchcriteria);
		     }
		     
		     if(toDate !=null){
		     var tdate = Ext.Date.format(new Date(toDate), 'Y-m-d');
		     var SUBMISSION_DATE_AFTER = this.getJsonObject('GIVEN_DATE_LESS_OR_EQUAL', tdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_AFTER,searchcriteria);
		     }
		     
		    	 var COURSE_ID = this.getJsonObject('COURSE_ID', courseId);
			     this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
		    	 
		    	 var STUDENT_ID = this.getJsonObject('STUDENT_ID', studentId);
		    	 this.pushJsonObjectInArray(STUDENT_ID,searchcriteria);
		     var COURSE_TOPIC_ID = this.getJsonObject('COURSE_TOPIC_ID', topicName);
		     this.pushJsonObjectInArray(COURSE_TOPIC_ID,searchcriteria);
		 
		     var COURSE_ASSIGNMENT_ID = this.getJsonObject('COURSE_ASSIGNMENT_ID', assignmentId);
		     this.pushJsonObjectInArray(COURSE_ASSIGNMENT_ID,searchcriteria);
		     
		    	 facultyId = this.getCurrentlyLoggedInUser().id;
		    	 var FACULTY_ID = this.getJsonObject('FACULTY_ID', facultyId);
		    	 this.pushJsonObjectInArray(FACULTY_ID,searchcriteria);
		    
	         values.searchCriterias = searchcriteria;
	         return values;
	    },
	    jsonCreationForStudentPortal : function() {
	    	var homeworkAssignmentsearchForm = this.getStudenthomeworkassignmentsearch().getForm();
	    	var courseId = homeworkAssignmentsearchForm.findField('studentCourse').getValue();
	    	 var academyLocationId =homeworkAssignmentsearchForm.findField('studentAcademyLocation').getValue();
			 var accCourseIds = [];
			 Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.FIND_ALL_ACCESSIBLE_COURSES,
					params : {
						academyLocationId :academyLocationId
					},
					method : 'GET',
					async: false,
					success : function(response) {
						var data = Ext.decode(response.responseText);
						for(var i=0; i< data.length ;i++){
							if(!isNullOrEmpty(data[i])){
								accCourseIds.push(data[i]);
							}
	             	   }
					}
				});
			 var accessibleCourseIds =accCourseIds.join();
			 
			 var courseVariantId = homeworkAssignmentsearchForm.findField('studentCourseVarient').getValue();
			 var programNameId = homeworkAssignmentsearchForm.findField('studentProgram').value;
			 var batchNameId = homeworkAssignmentsearchForm.findField('studentBatch').getValue();
			 var periodNameId = homeworkAssignmentsearchForm.findField('studentPeriod').getValue();
			 var sectionNameId = homeworkAssignmentsearchForm.findField('studentSection').getValue();
			 var academyLocationId =homeworkAssignmentsearchForm.findField('studentAcademyLocation').getValue();
			 
			 var assignmentType = homeworkAssignmentsearchForm.findField('studentAassignmentType').getRawValue();
			 var assignmentId = homeworkAssignmentsearchForm.findField('studentAssignmentName').getValue();
			 
			 var fromDate = homeworkAssignmentsearchForm.findField('studentFromDate').getValue();
			 var toDate = homeworkAssignmentsearchForm.findField('studentToDate').getValue();
			 
		     var values = new Object();
		     var searchcriteria = new Array();
		     values.configCode = CONSTANTS.CB.HOMEWORK_ASSIGNMENT_LISTING_STUDENT_CONFIGCODE;
		     
		     
		     var ACCESSIBLE_PARENT_COURSE_ID = this.getJsonObject('ACCESSIBLE_PARENT_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_PARENT_COURSE_ID,searchcriteria);
		     var ACCESSIBLE_COURSE_ID = this.getJsonObject('ACCESSIBLE_COURSE_ID', accessibleCourseIds);
		     this.pushJsonObjectInArray(ACCESSIBLE_COURSE_ID,searchcriteria);
		     
		     	     
		     var ASSIGNMENT_TYPE = this.getJsonObject('ASSIGNMENT_TYPE', assignmentType);
		     this.pushJsonObjectInArray(ASSIGNMENT_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('PROGRAM_ID', programNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('BATCH_ID', batchNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('PERIOD_ID', periodNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var PROGRAM_TYPE = this.getJsonObject('SECTION_ID', sectionNameId);
		     this.pushJsonObjectInArray(PROGRAM_TYPE,searchcriteria);
		     
		     var COURSE_ID = this.getJsonObject('COURSE_ID', courseId);
		     this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
		     
		     var COURSE_VARIANTS_ID = this.getJsonObject('COURSE_VARIANTS_ID', courseVariantId);
		     this.pushJsonObjectInArray(COURSE_VARIANTS_ID,searchcriteria);
		     
		     var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID',academyLocationId);
		     this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
		     
		     if(fromDate !=null){
		     var sdate = Ext.Date.format(new Date(fromDate), 'Y-m-d');
		     var SUBMISSION_DATE_BEORE = this.getJsonObject('GIVEN_DATE_GREATER_OR_EQUAL', sdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_BEORE,searchcriteria);
		     }
		     
		     if(toDate !=null){
		     var tdate = Ext.Date.format(new Date(toDate), 'Y-m-d');
		     var SUBMISSION_DATE_AFTER = this.getJsonObject('GIVEN_DATE_LESS_OR_EQUAL', tdate);
		     this.pushJsonObjectInArray(SUBMISSION_DATE_AFTER,searchcriteria);
		     }
		 
		     var COURSE_ASSIGNMENT_ID = this.getJsonObject('COURSE_ASSIGNMENT_ID', assignmentId);
		     this.pushJsonObjectInArray(COURSE_ASSIGNMENT_ID,searchcriteria);
		     
		     var STUDENT_ID = this.getJsonObject('STUDENT_ID', this.getCurrentlyLoggedInUserInfoForPortal().student.id);
	    	 this.pushJsonObjectInArray(STUDENT_ID,searchcriteria);
	    	 
	    	 var STUDENT_ID2 = this.getJsonObject('STUDENT_ID2', this.getCurrentlyLoggedInUserInfoForPortal().student.id);
	    	 this.pushJsonObjectInArray(STUDENT_ID2,searchcriteria);
	    	 var serverCurrentDate=null;
			 Ext.Ajax.request({
    			 type : 'rest',
    			 url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
    			 method : 'GET',
    			 async: false,
    			 success : function(form, action) {
    				 data = Ext.JSON.decode(form.responseText);
    				 serverCurrentDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
    			 }});
	    	 var publishdate = serverCurrentDate;
		     var PUBLISH_DATE_AFTER = this.getJsonObject('PUBLISH_DATE_LESS_OR_EQUAL', publishdate);
		     this.pushJsonObjectInArray(PUBLISH_DATE_AFTER,searchcriteria);
		    
	         values.searchCriterias = searchcriteria;
	         return values;
	    },
	    resetFieldParams: function(field){
	    	field.getStore().getProxy().extraParams = {};
	    },
	    
	    loadExisitingAssignmentGroupName : function(courseVariantId){
	    	var $this = this;
	    	var form = this.getGroupsassignmentgrid();
	    	var existingGroupNameField = form.down('#existinAssignmentGroupNameId');
	    	existingGroupNameField.reset();
	    	var existingGroupNameStore = existingGroupNameField.getStore();
	    	 var variantIdArrays = [];
        	 var courseVariantIds = null;
        	 if(!isNullOrEmpty(courseVariantId)){
        		 if(courseVariantId.length > 0 && !isNullOrEmpty(courseVariantId[0])){
        			 for (var i in courseVariantId) {
        				 if (Ext.isObject(courseVariantId[0])) {
        					 variantIdArrays.push(courseVariantId[i].get("id"));
        				 } else {
        					 variantIdArrays.push(courseVariantId[i]);
        				 }
        			 }
        			 courseVariantIds = variantIdArrays.join();
        		 }
        		 else{
        			 courseVariantIds = courseVariantId;
        		 }
        	 } 
		    	existingGroupNameStore.getProxy().extraParams={
		    		courseVariantId:courseVariantIds
				   };
		    	existingGroupNameStore.load({
					callback: function(record, operation, success) {
						if (success) {
							if(record.length == 1 ){
								existingGroupNameField.setValue(record[0].data.id)
								$this.showGroupOfStudentList(record[0].data.homeworkAssignmentId);
							}
						}
					}
				});
	    },
	    
	    showGroupOfStudentList:function(homeworkAssignmentId){
	    	    var groupForm = this.getGroupsassignmentgrid();
    	        var groupgrid= Ext.ComponentQuery.query('form#groupAssignmentForm_Id');
    	        var gridColumns = groupgrid[0].down('#addAssignmentGroupNameId');
    	        var groupName = groupForm.down('#existinAssignmentGroupNameId').rawValue;
    	        groupgrid[0].down('#addAssignmentGroupNameId').getSelectionModel().setLocked(false);
    	        
    	        /* Start for remove selected student on GroupAssignmentGrid*/    	        
    	        var storeGroup = Ext.getStore('coursetransaction.homework.assignmentdetails.AssignmentGroupBlank');
    	        gridColumns.getStore().removeAll();
    	        var gColumStr = gridColumns.getStore();
    	        gColumStr.getProxy().api.read=SERVERURL.PATH_FIND_EXISTING_GROUP_BY_ASSIGNMENTID;
    	        gColumStr.getProxy().extraParams = {
					hwId : homeworkAssignmentId,
					groupName : groupName
				};
    	       gColumStr.load({
				callback: function(record, operation, success) {
					if (success) {
						if(record.length > 0){
							setTimeout(function(){
								groupgrid[0].down('#addAssignmentGroupNameId').getSelectionModel().selectAll(true);
								groupgrid[0].down('#addAssignmentGroupNameId').getSelectionModel().setLocked(true);
							},200)
						}
						
					}
				}
			});
    	       
         },
         isGroupExistOrNot : function(groupName){
        	 $this = this;
        	 var isGroupExist = false;
        	 var assginmentDetailsForm = this.getAssignmentdetails();
			 var courseVariantId = assginmentDetailsForm.down('#courseVariant_Id').getValue();
			 var variantIdArrays = [];
        	 var courseVariantIds = null;
        	 if(groupName.length > 0){
            	 if(!isNullOrEmpty(courseVariantId)){
            		 if(courseVariantId.length > 0 && !isNullOrEmpty(courseVariantId[0])){
            			 for (var i in courseVariantId) {
            				 if (Ext.isObject(courseVariantId[0])) {
            					 variantIdArrays.push(courseVariantId[i].get("id"));
            				 } else {
            					 variantIdArrays.push(courseVariantId[i]);
            				 }
            			 }
            			 courseVariantIds = variantIdArrays.join();
            		 }
            		 else{
            			 courseVariantIds = courseVariantId;
            		 }
            	 } 
        		 Ext.Ajax.request({
 					type : 'rest',
 					url :SERVERURL.PATH_FIND_CHECK_EXISTING_GROUP_ORNOT+'?&groupName='+groupName+'&courseVariantId='+courseVariantIds,
 					method : 'GET',
 					async: false,
 					success : function(response, action) {
 						var resp = Ext.JSON.decode(response.responseText);
 						isGroupExist = resp;
 						
 					}}); 
        		 return isGroupExist;
        	 }
        	 
         },
         onChangeAssignmentNameTitle: function(cmp, nval) {
	    	   if(!isNullOrEmpty(nval)) {
					cmp.up('form').down('#generateBtnAssignment').enable();
				}
				else {
					cmp.up('form').down('#generateBtnAssignment').disable();
				}
	       }
});
