Ext.define('Academia.controller.dashboard.DashletRoleMappingController', {
    extend: 'Academia.controller.base.BaseController',

	views : ['dashboard.RoleMappingForm'],
	stores:['securitysetup.ActiveRolesStore','securitysetup.PortalStore','dashboard.DashletStore'],

	init : function() {
		this.control({
			'rolemappingform combo#role':{
				 afterrender:   function(combo){
					 combo.getStore().load();
				 },
				 'select': this.loadPortalCombo
			},
			'rolemappingform combo#comboPortal':{
				 'select': this.loadDashletsSelector
			},
			'rolemappingform customcombobox#role':{
				select:function(btn){
					var form = btn.up('form').getForm();
					var role = form.findField('role');
					var portal = form.findField('portal');
					
				}
			},
			'rolemappingform nestedJsonCombo#comboPortal':{
				select:function(btn){
					var form = btn.up('form').getForm();
					var role = form.findField('role');
					var portal = form.findField('portal');
					var checkbox = btn.up('rolemappingform').down('#showRemoveHoldId');
					
					if(role.rawValue && portal.rawValue){
						checkbox.setVisible(true);
						
					}
				}
			},
			
			'rolemappingform button#submitBtn':{
				click:this.save
			},
			'rolemappingform button#resetBtn':{
				click:function(btn){
					var form = btn.up('form').getForm();
					var dashletsSelector = form.findField('dashletsIds'); 
					dashletsSelector.reset();
				}
			},
			'rolemappingform itemselector#dashletsSelector':{
				afterrender:   function( dashletsSelector, eOpts ){
					dashletsSelector.getStore().removeAll();
					dashletsSelector.reset();
				}
			}
		});
	},
	
	save: function(button){
		var submitData= this.getJsonData(button);
		
		 this.sendSaveAjaxRequest(SERVERURL.ROLE_PORTAL_DASHLET_SAVE_ALL, 'POST', submitData, function(opt,success,response){
		  	if(success){
		  		showSuccessMessage(getCommonTranslation('ROLE_DASHLET_MAPPING'), getCommonTranslation('RECORD_ADD_SUCCESS'));
		  	}
  		});
	},
	/**
	 * This method gives the json format for save request.
	 */
	getJsonData : function(button){
		var form=button.up('rolemappingform'), portalId = form.down('#comboPortal').getValue(),roleId = form.down('#role').getValue();
		var isCheckBoxChecked = button.up('rolemappingform').down('#showRemoveHoldId').getValue();var data=[],formData= form.getValues(),dashletsIds=formData.dashletsIds,this$=this;
		
	
		
		if(formData){
			if (!isNullOrEmpty(dashletsIds) && dashletsIds.length > 0) {
				var serialNo = 1;
				for(var i=0;i<dashletsIds.length;i++){
					data.push({
						portal : this$.getNestedObject(portalId),
						role : this$.getNestedObject(roleId),
						dashlet : this$.getNestedObject(dashletsIds[i]),
						sequenceOrder :serialNo+i,
						showDefaultDashletsInExpandMode:isCheckBoxChecked
					});
				}
			}
		}
		console.log(data);	
		var submitData = new Object;
		submitData.wsRolePortalDashlets = data;
		submitData.roleId = roleId;
		submitData.portalId = portalId;
		return submitData;
	},
	
	loadPortalCombo: function(combo) {
		var id=combo.getValue(),comboPortal = combo.up('rolemappingform').down('#comboPortal'),
		dashletSelector= combo.up('rolemappingform').down('#dashletsSelector'), 
		submitBtn = combo.up('rolemappingform').down('#submitBtn');
		comboPortal.reset();
		this.disableDashletSelector(dashletSelector, submitBtn);
		if(!isNullOrEmpty(id)) { 
			this.loadComponentStore(comboPortal,'id',id,SERVERURL.ROLE_PORTAL_GET_PORTALS);
		}
	},
	
	disableDashletSelector: function(dashletSelector, submitBtn){
		dashletSelector.getStore().removeAll();
		dashletSelector.reset();
		dashletSelector.setDisabled(true);
		submitBtn.setDisabled(true);
	},
	
	loadDashletsSelector: function(comboPortal) {
		var form=comboPortal.up('rolemappingform'), portalId = comboPortal.getValue(),roleId = form.down('#role').getValue(),
			dashletSelector=form.down('#dashletsSelector'),applicationDashletURL = SERVERURL.DASHLETS_BY_ROLE_AND_PORRAL,dashletId=[],
			loadDashletsCompleted=false;
		dashletSelector.setDisabled(false);
		
		var submitBtn = form.down('#submitBtn');
		var showDefault = form.down('#showRemoveHoldId');
		
		
		applicationDashletURL = applicationDashletURL.concat('?roleId='+roleId+'&portalId='+portalId); 
		
        this.sendGetAjaxRequest(applicationDashletURL, 'GET', '', function(opt, success, response) {
            if (success) {
                var data =  Ext.decode(response.responseText); 
                if (data) {
        			if(data.length>0){
        			 showDefault.setValue(data[0].activeStatus);
        			} 
        			else{
        				showDefault.setValue(false);
        			}
                	loadDashletsCompleted=true;
                	Ext.each(data,function(obj){dashletId.push(obj.id);});
                	dashletSelector.setValue(dashletId);
                	
                	var store = dashletSelector.getStore();
                   	var url=  SERVERURL.DASHLETS_BY_PORRAL;
                    url = url.concat('?portalId='+portalId); 
                    store.getProxy().api.read = url;
                    dashletSelector.getStore().removeAll();
                    dashletSelector.reset();
                	store.load(function(records, operation, success) {
            		    if(loadDashletsCompleted){
                        	if (!isNullOrEmpty(records) && records.length > 0) {
                        		submitBtn.setDisabled(false);
                        	} else {
                        		submitBtn.setDisabled(true);
                        	}
            		    	dashletSelector.setValue(dashletId);
            		    }
            		});
                }
            }
        });
	}
	
	
});
