/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Data Setting details.   
 */
 
Ext.define('Academia.controller.datasetting.DataSettingController', {
    extend: 'Ext.app.Controller',

    models: ['datasetting.DataSettingSelectedIdFormatModel','datasetting.entitySettingDataModel','datasetting.IdFormatFormModel','datasetting.AlphaNumericFormModel'],    

    stores: ['datasetting.DataSettingEntityStore', 'datasetting.DynamicComboStore',
             'datasetting.DataSettingDynamicEntityStore','datasetting.DataSettingDynamicFieldStore',
             'datasetting.DataSettingSelectedIdFormatStore','datasetting.IdColumnDynamicFieldStore',
             'datasetting.IdTableMappingStore'],

    views: ['datasetting.DataSetting', 'datasetting.EntityLevelSettingsPanel', 'datasetting.FieldLevelSettingsPanel', 'datasetting.IdFormatFormWindow', 'datasetting.IdFormatSelectedPanel', 'datasetting.IdFormatSelectedGrid'],

    alias: "widget.datasettingcontroller",

    refs: [{
        ref: 'winIdFormatForm',
        selector: 'idformatFormwindow'
    },{
        ref: 'frmIdFormat',
        selector: 'idformatFormwindow form[itemId=idFormatForm]'
    },{
        ref: 'entityLevelSettingPanel',
        selector: 'entitylevelsettingpanel'
    },{
        ref: 'idformatselectedgrid',
        selector: 'idformatselectedgrid'
    },{
    	ref: 'selectedIdFormatDataView',
        selector: 'idformatselectedpanel dataview[itemId=selectedIdFormatDataView]'
    }],

    init: function(application) {
    	
    	this.DYNAMIC_FIELD = 1;
        this.ALPHANUMERIC_FIELD = 2;
        this.NUMERIC_COUNTER_FIELD = 3;

        this.DYNAMIC_FIELD_RADIO = 1;
        this.ALPHANUMERIC_FIELD_RADIO = 2;
        this.NUMERIC_COUNTER_FIELD_RADIO = 3;

        this.formData;
        this.control({
        	'entitylevelsettingpanel combo[itemId=cmbEntity]':{
            	render:function(cmb,evts){
            		cmb.getStore().load();
            	},
            	select:function(combo,records,eOpts){
            		if(!isNullOrEmpty(records) && (records[0].raw.tableName.toLowerCase() == 'students' || records[0].raw.tableName.toLowerCase() == 'application'||records[0].raw.tableName.toLowerCase() == 'admission')) {
            			this.getEntityLevelSettingPanel().down('#whetherEditableItemId').setVisible(true);
            		} else {
            			this.getEntityLevelSettingPanel().down('#whetherEditableItemId').setVisible(false);
            		}
            		if(!isNullOrEmpty(records) && (records[0].raw.tableName.toLowerCase() == 'students')) {
            			this.getEntityLevelSettingPanel().down('#isSyncWithApplicationItemId').setVisible(true);
            		} else {
            			this.getEntityLevelSettingPanel().down('#isSyncWithApplicationItemId').setVisible(false);
            		}
            		this.loadIdColumnCOmbo(combo,records,eOpts);
            		this.loadIdGeneratorFormat(combo,records);
        		}
            },
            'entitylevelsettingpanel button[itemId=btnConfigureIDFormat]': {
                click: this.showIDFormatWindow
            },
            'entitylevelsettingpanel button[itemId=btnSave]': {
                click: this.saveEntityLevelSetting
            },
            'entitylevelsettingpanel button[itemId=btnRestoreDefault]': {
                click: this.restoreDefaultIdFormat
            },
            'idformatFormwindow button[itemId=btnAddIDFormatType]': {
                click: this.addIdFormat
            },
            'idformatFormwindow button[itemId=btnDeleteIDFormatType]': {
                click: this.deleteIdFormat
            },
            'idformatselectedgrid': {
            	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
            		var $this = this;
                    var grid = $this.getIdformatselectedgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "deleteButton"){
                    	this.deleteSelectedRecord()
                    }
            	}                
            },
            'idformatFormwindow button[itemId=btnSaveIdFormatForm]': {
                click: this.saveIdFormatForm
            },
            'idformatFormwindow button[itemId=btnCancelIdFormatForm]': {
                click: this.cancelIdFormatForm
            },                        
			
			 'idformatFormwindow #isOriginalRadio': {
	        	  change: function(radio, newValue, oldValue) {
	                  this.hideShowPanel(radio, newValue);
	              }
	         },
            'idformatFormwindow combo[itemId=cmbDynamicEntity]':{
            	select:function(combo,records,eOpts){
            		var dependentComboStore=this.getFrmIdFormat().down('#cmbDynamicField').getStore();
            		dependentComboStore.removeAll();
            		if(!isEmpty(records[0])){
            			var columnArray=records[0].get('wsSearchTableColumns');
  							var uniqueArray = [];   var uniqueArray2 = [];
 						   for(var i=0;i<columnArray.length; i++) { 
							 var value=columnArray[i] ;
					            if(uniqueArray.indexOf(value.columnName) === -1){
					                uniqueArray.push(value.columnName);
					                uniqueArray2.push(value); 
					            	}
					        	}  
            			dependentComboStore.loadData(uniqueArray2);
            		}            		
            	}
            },
			'idformatFormwindow combo[itemId=cmbIdFormatType]':{
				select:function(combo,records,eOpts){
					var selectedValue=combo.getValue();
					
					var idFormatForm=combo.up('form#idFormatForm');
					
					var dynamicPanel=idFormatForm.down('#dynamicPanel');
					var numberOfDigit=idFormatForm.down('#numberOfDigit');
					var numCounterField=idFormatForm.down('#numCounter');
					var txtAlphaNumericField=idFormatForm.down('#txtAlphaNumeric');
					var cmbDynamicEntity=idFormatForm.down('#cmbDynamicEntity');
					var cmbDynamicField=idFormatForm.down('#cmbDynamicField');
            		
					this.setFieldVisible(txtAlphaNumericField,false);
					this.setFieldVisible(numCounterField,false);
					this.setFieldVisible(cmbDynamicEntity,false);
					this.setFieldVisible(cmbDynamicField,false);
        			this.setFieldVisible(numberOfDigit,false);
        			
            		if(this.DYNAMIC_FIELD==selectedValue){
            			this.setFieldVisible(cmbDynamicEntity,true);
            			this.setFieldVisible(cmbDynamicField,true);
            		}else if(this.ALPHANUMERIC_FIELD==selectedValue){
            			this.setFieldVisible(txtAlphaNumericField,true);
            		}else if(this.NUMERIC_COUNTER_FIELD==selectedValue){
            			this.setFieldVisible(numCounterField,true);
            			this.setFieldVisible(numberOfDigit,true);
            		}
            		dynamicPanel.doLayout();
            	}
			}
        });
    },
    
    setFieldVisible:function(field,visible){
    	field.setDisabled(!visible);
    	field.setVisible(visible);
    },
    
    loadIdColumnCOmbo: function(combo,records,eOpts){
		var dependentComboStore = combo.up('form').down('combo#idColumn').getStore();
		dependentComboStore.removeAll();
		
		if(!isEmpty(records[0])){
			var columnArray=records[0].get('columns');
			dependentComboStore.loadData(columnArray);
		} 
	},
    
    loadIdGeneratorFormat:function(combo,records){
    	var me=this;
    	
    	var entityLevelSettingPanel=me.getEntityLevelSettingPanel();
    	if(isNullOrEmpty(combo)){
    		combo=entityLevelSettingPanel.down('combo#cmbEntity');
    	}
    	var entityCombo=combo;
    	if(!isNullOrEmpty(combo.getValue())){
			var entitySettingForm=entityLevelSettingPanel.down('#entitySettingForm');
			entitySettingForm.setDisabled(false);
			
           Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.FIND_BY_ENTITY_ID, //URL-rest/idDefinition/findByEntityId  //?entityId=1                            
                method: 'GET',
                params: {
                	entityId: combo.getValue()
                },
                success: function(response,form, action) {
                	if(!isNullOrEmpty(response.responseText)){
                		var responseObject =  Ext.JSON.decode(response.responseText);//make object of response text
                		me.formData=responseObject;  
                    	if(!isEmpty(responseObject)){
                        	var selectedRecord,formModel=new Academia.model.datasetting.entitySettingDataModel(responseObject);  
                        	entityLevelSettingPanel.down('#whetherEditableItemId').setValue(responseObject.whetherEditable)
                        	entityLevelSettingPanel.down('#isSyncWithApplicationItemId').setValue(responseObject.isSyncWithApplication)
                        	if(records){
                        		selectedRecord=records[0];
                        	}else
                        		selectedRecord=entityCombo.getStore().getById(entityCombo.getValue());
                        	
                        	if(selectedRecord.get('whetherFullyConfigurable')==false){
                        		formModel.set({'whetherManualId':false});
                        		entityLevelSettingPanel.down('#whetherManualId').setDisabled(true);
                        	}
                        	else{
                        		entityLevelSettingPanel.down('#whetherManualId').setDisabled(false);
//                        		entityLevelSettingPanel.down('#whetherManualId').setReadOnly(false);
                        	}
                        	entitySettingForm.loadRecord(formModel);
                        	
                        	var dependentCombo = entityLevelSettingPanel.down('combo#idColumn');
                        	dependentCombo.setValue(responseObject.idColumn);
                        	if(!isNullOrEmpty(formModel.get('idFormatType'))){
                        		var idFT = getCommonTranslation(formModel.get('idFormatType')) ;
                        		entitySettingForm.down('#idFormatType').setText(idFT);
                        	}
                    	}
                	}else{
                		me.formData=null;  
                		entitySettingForm.getForm().reset();
                		var dependentCombo = entityLevelSettingPanel.down('combo#idColumn');
                		entitySettingForm.down('#idFormatType').setText(getCommonTranslation('NO_IDFORMAT_ASSIGNED'));
                		dependentCombo.reset();
                	}                   	                            	
                }	            
           });	
		}            		
	},
	
    /*
	 * This function is used for to show/hide Panel after clicking on radio
	 */
	hideShowPanel:function(radio,value){
		
		var frmIdFormat=this.getFrmIdFormat();
		var runningNumberPanel=frmIdFormat.down('#runningNumberPanel');
		var alphaNumericPanel=frmIdFormat.down('#alphaNumericPanel');
		var dynamicPanel=frmIdFormat.down('#dynamicPanel');
		var droolPanel=frmIdFormat.down('#droolPanel');
					
		this.setFieldVisible(runningNumberPanel,false);
		this.setFieldVisible(alphaNumericPanel,false);
		this.setFieldVisible(dynamicPanel,false);
		this.setFieldVisible(droolPanel,false);
		var cmpItemId = null;
		if(value){
		    cmpItemId = value.idFormatType ;
		}else{
			cmpItemId = radio.inputValue ;
		}
		if( cmpItemId ==='RUNNING_NUMBER'){
			this.setFieldVisible(runningNumberPanel,true);
		}else if(cmpItemId ==='ALPHA_NUMERIC'){ 
			this.setFieldVisible(alphaNumericPanel,true);
		}else if(cmpItemId ==='DYNAMIC'){
			var entityLevelSettingPanel=this.getEntityLevelSettingPanel();
    		var entityCombo=entityLevelSettingPanel.down('#cmbEntity');
    		var entityComboModel=entityCombo.getStore().getById(entityCombo.getValue());
    		combo=dynamicPanel.down('combo#cmbDynamicEntity');
    		combo.getStore().load({
    			params:{configCode:entityComboModel.get('searchConfigCode')}
    		});
    		this.setFieldVisible(dynamicPanel,true);
		}else if(cmpItemId==='DROOL'){
			this.setFieldVisible(droolPanel,true);
		}
	},

    /*
     * This function is used for to show ID Format Window Details Dialog box after clicking on Add button   
     */
	showIDFormatWindow: function() {        
			var me=this;
        	var idFormatWindow = Ext.widget('idformatFormwindow');
            idFormatWindow.show();
            
            var frmIdFormat=me.getFrmIdFormat();
    		var runningNumberRadio=frmIdFormat.down('#runningNumberIdFormat');
            if(!isEmpty(me.formData)){
            	if(!isNullOrEmpty(me.formData.idFormatType)){
            		var alphaNumericRadio=frmIdFormat.down('#alphaNumericIdFormat');
            		var dynamicIdFormatRadio=frmIdFormat.down('#dynamicIdFormat');
            		var droolFormatRadio=frmIdFormat.down('#droolFormat');
            		var runningNumberPanel=frmIdFormat.down('#runningNumberPanel');
            		var alphaNumericFormPanel=frmIdFormat.down('#alphaNumericPanel');
            		var droolPanel=frmIdFormat.down('#droolPanel');
            		var idformatselectedpanel=me.getIdformatselectedgrid();
            		
            		idformatselectedpanel.getStore().removeAll();
            		var idFormatFormModel=new Academia.model.datasetting.IdFormatFormModel(me.formData);    
            		frmIdFormat.loadRecord(idFormatFormModel);
            		
            		if(me.formData.idFormatType==='RUNNING_NUMBER'){
            			runningNumberRadio.setValue(true);
            			me.hideShowPanel(runningNumberRadio);
            			runningNumberPanel.getForm().setValues(me.formData.runningNoFormats[0]);
            		}else if(me.formData.idFormatType==='ALPHA_NUMERIC'){
            			alphaNumericRadio.setValue(true);
            			me.hideShowPanel(alphaNumericRadio);
            			var alphaNumericModel=new Academia.model.datasetting.AlphaNumericFormModel(me.formData.alphaNumericFormats[0]);            			
            			alphaNumericFormPanel.loadRecord(alphaNumericModel);            			
            		}else if(me.formData.idFormatType==='DYNAMIC'){
            			dynamicIdFormatRadio.setValue(true);
            			me.hideShowPanel(dynamicIdFormatRadio);
            			var recordsData=new Array();
            			recordsData=me.makeRecordData(me.DYNAMIC_FIELD,me.formData.dynamicIdFormats , recordsData);
            			recordsData=me.makeRecordData(me.ALPHANUMERIC_FIELD,me.formData.alphaNumericFormats , recordsData);
            			recordsData=me.makeRecordData(me.NUMERIC_COUNTER_FIELD,me.formData.runningNoFormats , recordsData);            			
            			idformatselectedpanel.getStore().loadData(recordsData);            			
            		}else if(me.formData.idFormatType==='DROOL'){
            			droolFormatRadio.setValue(true);
            			me.hideShowPanel(droolFormatRadio);
            			var store=droolPanel.items.items[0].getStore();
            			store.load({
							callback: function(records, operation, success) {
								records.forEach(function(record){
									if(!isNullOrEmpty(me.formData.droolId) && record.get('id')==me.formData.droolId){
		            					frmIdFormat.down("#droolName").setValue(record.get('id'));   			
		            	    		}
								});
							}
						});
            		}
            		
            	}
            }else{
            	runningNumberRadio.setValue(true);
    			me.hideShowPanel(runningNumberRadio);
            }
            idFormatWindow.center();
    	},

    /*
     * This function is used for to check Dynamic Field Details in selected panel store   
     */
    isDynamicFieldExist: function(store,column,field) {
    	var isExist=false;
    	store.each(function(record){
    		if(record.get('searchConfigTableId')==column && record.get('searchTableColumnId')==field){
    			isExist=true;    			
    		}
    	});
    	return isExist;
    },

    /*
     * This function is used for to check  Running Number Details in selected panel store   
     */
    isRunningNumberExist: function(store) {
    	var me=this;
    	var isExist=false;
    	store.each(function(record){
    		if(record.get('idFormatType')==me.NUMERIC_COUNTER_FIELD){
    			isExist=true;    			
    		}
    	});
    	return isExist;
    },
    
    /*
     * This function is used for to make ID Format Details   
     */
    makeFormat: function(selectType,model,value) {
    	var me=this;
    	if(me.DYNAMIC_FIELD==selectType){
    		model.set('selectedText',getCommonTranslation('DYNAMIC')+' : '+value);
    	}else if(me.ALPHANUMERIC_FIELD==selectType){
    		model.set('selectedText',getCommonTranslation('ALPHA_NUMERIC')+' : '+value);    		
    	}else if(me.NUMERIC_COUNTER_FIELD==selectType){
    		model.set('selectedText',getCommonTranslation('RUNNING_NUMBER')+' : '+value);    		
    	}
    	return model;
    },
    
    /*
     * This function is used for to create Record data ID Format Details   
     */
    makeRecordData: function(selectType,IdFormatData,recordData) {    	
    	var me=this;
    	for(var count=0;count<IdFormatData.length;count++){
    		if(!isEmpty(IdFormatData[count])){
    			var model=new Academia.model.datasetting.DataSettingSelectedIdFormatModel(IdFormatData[count]);
    			if(me.DYNAMIC_FIELD==selectType){
    				model.set('idFormatType',me.DYNAMIC_FIELD);
    				model=me.makeFormat(selectType,model,model.get('resultKey'));
    			}else if(me.ALPHANUMERIC_FIELD==selectType){
    				model.set('idFormatType',me.ALPHANUMERIC_FIELD);
    				model=me.makeFormat(selectType,model,model.get('prefix'));
    			}else if(me.NUMERIC_COUNTER_FIELD==selectType){
    				model.set('idFormatType',me.NUMERIC_COUNTER_FIELD);
    				model=me.makeFormat(selectType,model,model.get('startFrom'));
    			}
    			recordData.push(model);
    		}    		
    	}
    	return recordData;
    },
    
    /*
     * This function is used for to add ID Format Details after clicking on Add button   
     */
    addIdFormat: function(btn) {
    	var me=this;
    	var form=btn.up('form');
    	if(form.isValid()){    
    		//var selectedIdFormatStore=me.getSelectedIdFormatDataView().getStore();
    		var selectedIdFormatStore=me.getIdformatselectedgrid().getStore();

			var numberOfDigit=me.getFrmIdFormat().down('#numberOfDigit');
    		var numCounterField=me.getFrmIdFormat().down('#numCounter');
    		var txtAlphaNumericField=me.getFrmIdFormat().down('#txtAlphaNumeric');
    		var cmbIdFormatType=me.getFrmIdFormat().down('#cmbIdFormatType');
    		var cmbDynamicEntity=me.getFrmIdFormat().down('#cmbDynamicEntity');
    		var btnAddIDFormatType=me.getFrmIdFormat().down('#btnAddIDFormatType');
    		cmbDynamicField=me.getFrmIdFormat().down('#cmbDynamicField');
    		var selectedValue=cmbIdFormatType.getValue();
    		
    		var model=new Academia.model.datasetting.DataSettingSelectedIdFormatModel();
    		var seqNo=selectedIdFormatStore.data.length+1;
    		if(me.DYNAMIC_FIELD==selectedValue){
    			if(!me.isDynamicFieldExist(selectedIdFormatStore,cmbDynamicEntity.getValue(),cmbDynamicField.getValue())){
    				model.set('idFormatType',me.DYNAMIC_FIELD);
        			model.set('searchConfigTableId',cmbDynamicEntity.getValue());
        			model.set('searchTableColumnId',cmbDynamicField.getValue());
        			var record=cmbDynamicEntity.getStore().getById(cmbDynamicEntity.getValue());
        			model.set('resultKey',record.code+'_'+cmbDynamicField.getRawValue());
        			model.set('seqNo',seqNo);    
        			model=me.makeFormat(selectedValue,model,cmbDynamicEntity.getRawValue()+'_'+cmbDynamicField.getRawValue());
        			selectedIdFormatStore.add(model);			        			
        			showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADDED_ID_FORMAT_MSG')); //ID Format added successfully
    			}else{
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ALEADY_EXIST_MSG')); //Selected value is already added    				
    			}    			
    			cmbDynamicEntity.reset();
    			cmbDynamicField.reset();
    		}else if(me.ALPHANUMERIC_FIELD==selectedValue){
    			model.set('idFormatType',me.ALPHANUMERIC_FIELD);
    			model.set('seqNo',seqNo);
    			model.set('text',txtAlphaNumericField.getValue().toUpperCase());
    			model=me.makeFormat(selectedValue,model,txtAlphaNumericField.getValue().toUpperCase());
    			selectedIdFormatStore.add(model);
    			txtAlphaNumericField.reset();
    			showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADDED_ID_FORMAT_MSG')); //ID Format added successfully
    		}else if(me.NUMERIC_COUNTER_FIELD==selectedValue){
    			if(!me.isRunningNumberExist(selectedIdFormatStore)){
    				model.set('idFormatType',me.NUMERIC_COUNTER_FIELD);
        			model.set('seqNo',seqNo);
        			model.set('startFrom',numCounterField.getValue());
        			model.set('numberOfDigit',numberOfDigit.getValue());
        			model=me.makeFormat(selectedValue,model,numCounterField.getValue());        			
        			selectedIdFormatStore.add(model);      
        			//btnAddIDFormatType.setDisabled(true);
        			showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADDED_ID_FORMAT_MSG')); //ID Format added successfully
    			}else{
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RUNNING_NUMBER_EXIST_MSG')); //Running Number can select only ones.    				
    			}    			
    			numCounterField.reset();
    			numberOfDigit.reset();
    		}								    		
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    	}				
    },
    
    /*
     * This function is used for to delete ID Format Details after clicking on Delete button   
     */
    deleteIdFormat: function() {    	
    	var me=this;
    	var selectedIdFormatDataView=me.getIdformatselectedgrid();
		var selectedIdFormatStore=selectedIdFormatDataView.getStore();		    	
		
        if (selectedIdFormatDataView.getSelectionModel().getCount() > 0) {
                	
        	showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                            var records = selectedIdFormatDataView.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                            	selectedIdFormatStore.remove(records[count]);
                            }
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_ID_FORMAT_MSG')); //ID Format deleted successfully.
                        }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    deleteSelectedRecord: function() {    	
    	var me=this;
    	//var selectedIdFormatDataView=me.getSelectedIdFormatDataView();
		//var selectedIdFormatStore=me.getSelectedIdFormatDataView().getStore();		    	
    	var grid = me.getIdformatselectedgrid();
    	var store = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0){
        	showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                            	store.remove(records[count]);
                            }
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_ID_FORMAT_MSG')); //ID Format deleted successfully.
                        }
            });
    	}
    	else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    /*
     * This function is used for to create JSON Format of Entity Panel Details   
     */
    getEntityPanelJsonData: function(jsonObject) {    	
    	var entityLevelSettingPanel=this.getEntityLevelSettingPanel();
		var entityCombo=entityLevelSettingPanel.down('#cmbEntity');            		
		var entityComboModel=entityCombo.getStore().getById(entityCombo.getValue());
				
		jsonObject.idEntitySetting=entityCombo.getValue();
		jsonObject.whetherManualId=entityLevelSettingPanel.down('#whetherManualId').getValue();
		jsonObject.whetherEditable=entityLevelSettingPanel.down('#whetherEditableItemId').getValue();
		jsonObject.isSyncWithApplication=entityLevelSettingPanel.down('#isSyncWithApplicationItemId').getValue();
		jsonObject.whetherDefaultID=false,		
		jsonObject.configName=entityComboModel.get('searchConfigCode');
		
    	var dependentCombo = entityLevelSettingPanel.down('combo#idColumn');
    	jsonObject.idColumn=dependentCombo.getValue();
    	return jsonObject;
    },
    /*
     * This function is used for to create JSON Format of Form Details   
     */
    createJsonFormat: function(isRestoreDefaultIdFormat) {    	
    	var me=this;
    	var jsonObject=new Object();
    	
    	jsonObject.runningNoFormats=new Array();
		jsonObject.alphaNumericFormats=new Array();
		jsonObject.dynamicIdFormats=new Array();
		
		jsonObject=this.getEntityPanelJsonData(jsonObject);
		
    	var frmIdFormat=this.getFrmIdFormat();
    	if(frmIdFormat){
    		var runningNumberRadio=frmIdFormat.down('#runningNumberIdFormat');
    		var alphaNumericRadio=frmIdFormat.down('#alphaNumericIdFormat');
    		var dynamicIdFormatRadio=frmIdFormat.down('#dynamicIdFormat');										
    		var droolIdFormatRadio=frmIdFormat.down('#droolFormat');	
    		
    		var baseFormData=frmIdFormat.getValues();
    		jsonObject.id=baseFormData.id;
    		jsonObject.version=baseFormData.version;
    		
    		
    		if(runningNumberRadio.getValue()==true){
    			var runningNumberPanel=frmIdFormat.down('#runningNumberPanel');
    			var formData=runningNumberPanel.getValues();
    			jsonObject.idFormatType=runningNumberRadio.inputValue;
    			
    			var obj=new Object();
    			obj.seqNo=1;
    			obj.startFrom=formData.startFrom;
    			obj.numberOfDigit=formData.numberOfDigit;

    			jsonObject.runningNoFormats.push(obj);
    		}else if(alphaNumericRadio.getValue()==true){
    			var alphaNumericFormPanel=frmIdFormat.down('#alphaNumericPanel');
    			var formData=alphaNumericFormPanel.getValues();
    			jsonObject.idFormatType=alphaNumericRadio.inputValue;
    			
    			var obj=new Object();
    			obj.seqNo=1;
    			obj.prefix=formData.prefix.toUpperCase();
    			obj.suffix=formData.suffix.toUpperCase();
    			obj.startFrom=formData.startFrom;
    			obj.numberOfDigit=formData.numberOfDigit;
    			
    			jsonObject.alphaNumericFormats.push(obj);
    			
    		}else if(dynamicIdFormatRadio.getValue()==true){
    			//var idformatselectedpanel=this.getSelectedIdFormatDataView();
    			//var idformatselectedpanelStore=idformatselectedpanel.getStore();
    			var idformatselectedgrid=this.getIdformatselectedgrid();
    			var idformatselectedpanelStore=idformatselectedgrid.getStore();
    			jsonObject.idFormatType=dynamicIdFormatRadio.inputValue;
    			
    			idformatselectedpanelStore.each(function(record){				    				
    				if(record.get('idFormatType')==me.DYNAMIC_FIELD){
    					var obj=new Object();    				
        				obj.seqNo=record.get('seqNo');
    					obj.searchConfigTableId=record.get('searchConfigTableId');
        				obj.searchTableColumnId=record.get('searchTableColumnId');
        				obj.resultKey=record.get('resultKey');
        				jsonObject.dynamicIdFormats.push(obj);
    				}else if(record.get('idFormatType')==me.ALPHANUMERIC_FIELD){
    					var obj1=new Object();    				
        				obj1.seqNo=record.get('seqNo');
    					obj1.prefix=record.get('text');    	  
    					if(isNullOrEmpty(obj1.prefix)){
    						if(!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.prefix))
    							obj1.prefix = record.data.prefix;
    					}
    	    			obj1.startFrom=record.get('startFrom');
    	    			jsonObject.alphaNumericFormats.push(obj1);
    				}else if(record.get('idFormatType')==me.NUMERIC_COUNTER_FIELD){
    					var obj2=new Object();    				
        				obj2.seqNo=record.get('seqNo');
    	    			obj2.startFrom=record.get('startFrom');
    	    			obj2.numberOfDigit=record.get('numberOfDigit');
    	    			jsonObject.runningNoFormats.push(obj2);
    				}    				    				
    			});
    		}else if(droolIdFormatRadio.getValue()==true){
    			jsonObject.droolId=baseFormData.field;
    			jsonObject.idFormatType=droolIdFormatRadio.inputValue;
    		}
    	}
    	if(!isNullOrEmpty(isRestoreDefaultIdFormat)){
    		jsonObject.idFormatType='RUNNING_NUMBER';
    		var obj=new Object();
			obj.seqNo=1;
			obj.startFrom=1;
			jsonObject.whetherDefaultID=true,
			jsonObject.runningNoFormats.push(obj);
			jsonObject.id=me.formData.id;
			jsonObject.version=me.formData.version;
    	}
		return jsonObject;
    },
    
    /*
     * This function is used for to save Id Format Form Details after clicking on save button   
     */
    saveIdFormatForm: function(button) {
    	var me=this;    	    	
    	var frmIdFormat=button.up("form#idFormatForm");
    	var runningNumberRadio=frmIdFormat.down('#runningNumberIdFormat');
        var alphaNumericRadio=frmIdFormat.down('#alphaNumericIdFormat');
        var dynamicIdFormatRadio=frmIdFormat.down('#dynamicIdFormat');
        var droolIdFormatRadio=frmIdFormat.down('#droolFormat');
        
        
        if(droolIdFormatRadio.getValue()==true){
        	me.sendSaveIdFormatRequest();
        }
        
        if(runningNumberRadio.getValue()==true || alphaNumericRadio.getValue()==true){
        	if(frmIdFormat.isValid()){
        		if(runningNumberRadio.getValue()==true){
        			me.sendSaveIdFormatRequest();
        		}
        		if(alphaNumericRadio.getValue()==true){
	        		var alphaNumericFormPanel=frmIdFormat.down('#alphaNumericPanel');
	    			var formData=alphaNumericFormPanel.getValues();
	    			if(isNullOrEmpty(formData.prefix) && isNullOrEmpty(formData.suffix)){
	    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENETR_PREFIX_OR_SUFFIX')); //Please Enter prefix or suffix value    				   
	    				return false;
	    			}else{
	    				me.sendSaveIdFormatRequest();
	    			}
	        	}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
        	}
    	}
        		
    	if(dynamicIdFormatRadio.getValue()==true){
			var idformatselectedpanelStore=me.getIdformatselectedgrid().getStore();
			if(idformatselectedpanelStore.data.length==0){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENETR_DYNAMIC_FIELDS')); //Please Enter dynamic fields     				   
				return false;
			}else if(!me.isRunningNumberExist(idformatselectedpanelStore)){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENETR_NUMERIC_FIELD')); //Please Enter numeric fields     				   
			}else{
				me.sendSaveIdFormatRequest();
			}
    	} 
    	
    },
    
    
    saveEntityLevelSetting:function(){
    	var jsonFormatFormData = this.createJsonFormat( );
    	jsonFormatFormData.id=this.formData.id;
    	jsonFormatFormData.version=this.formData.version;
    	jsonFormatFormData.idFormatType=this.formData.idFormatType;
    	jsonFormatFormData.runningNoFormats=this.formData.runningNoFormats;
    	jsonFormatFormData.alphaNumericFormats=this.formData.alphaNumericFormats;
    	jsonFormatFormData.dynamicIdFormats=this.formData.dynamicIdFormats;
    	jsonFormatFormData.whetherEditable = this.getEntityLevelSettingPanel().down('#whetherEditableItemId').getValue();
    	jsonFormatFormData.isSyncWithApplication = this.getEntityLevelSettingPanel().down('#isSyncWithApplicationItemId').getValue();
    	jsonFormatFormData.droolName=this.formData.droolName; 
    	this.sendSaveRequest( Ext.encode(jsonFormatFormData));
    },
    /*
     * This function is used for to send save ID format request   
     */
    sendSaveIdFormatRequest:function(){
    	var jsonFormatFormData = Ext.encode(this.createJsonFormat());
    	this.sendSaveRequest(jsonFormatFormData);
    },
    sendSaveRequest:function(jsonFormatFormData){
    	var me=this;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.CONFIGURE_ID_FORMAT, //URL-rest/idDefinition/create,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {	
           	 Ext.getBody().unmask();
            	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_ID_FORMAT_MSG')); //ID Format saved successfully.
            	me.postSaveIdFormatOperarion();
            	var windowReference=me.getWinIdFormatForm() ;
            	if(windowReference != null || windowReference != undefined) {
                	windowReference.close();
        		}
            	
            }	            
        });
    },
    /**
     * Reload screen after id format update
     */
    postSaveIdFormatOperarion:function(){
    	this.loadIdGeneratorFormat();
        var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
    	if(idTableMappingStore){
    		idTableMappingStore.load();
    	}
    },
    /*
     * This function is used for to restore default Id Format Details after clicking on restore default button   
     */
    restoreDefaultIdFormat: function() {    	  
    	var me=this;
    	var jsonFormatFormData = Ext.encode(this.createJsonFormat(true));                      
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.CONFIGURE_ID_FORMAT, //URL-rest/idDefinition/create,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {	            
            	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_ID_FORMAT_MSG')); //ID Format saved successfully.	
            	me.postSaveIdFormatOperarion();
            }	            
        });              
    },

    /*
     * This function is used for to close Id Format Form window Details Dialog box after clicking on cancel button   
     */
    cancelIdFormatForm: function() {
        this.getWinIdFormatForm().close();
    }

});