/**
 * @author Deepak
 * This controller is used for document Group Master functionality
 */
Ext.define('Academia.controller.documentmanagement.DocumentGroupMasterController', {

	extend: 'Academia.controller.base.BaseController',

	models : [ 'documentgroupmaster.CreateDocumentGruopModel','documentmanagement.DocumentUserRequestModel','documentmanagement.DocumentUserRequestModel','common.IdValueCodeDataModel'],
	stores: ['facilitiesresources.resourcebooking.AcademyLocationListByUserStore','common.StatusComboStore',
		'documentmanagement.DocumentGroupMasterGridStore','documentmanagement.DocumentGroupMasterApplicableOnStore',
		'documentmanagement.DocumentGroupMasterFileTypeStore', 'documentmanagement.DocumentGroupMasterStore',
		'documentmanagement.DocumentUserRequestGridStore','documentmanagement.DocumentRequestShowGridStore',
		'documentmanagement.DocumentApplicantRequestGridStore','documentmanagement.DocumentStudentRequestGridStore','documentmanagement.BulkDocumentDownloadStore',
		'committee.committee.MessageTypeNotificationStore','messaging.MessagingTemplatesStore','messaging.StaticDocumentAttachmentGridStore'],

		views: ['documentmanagement.DocumentGroupMasterStructure','documentmanagement.DocumentGroupMasterSeachFilter',
			'documentmanagement.DocumentGroupMasterPanel','documentmanagement.DocumentGroupMasterGrid','documentmanagement.DocumentGroupForm',
			'documentmanagement.DocumentRequestToViewWindow','documentmanagement.GroupDocumentRequestGrid','documentmanagement.DocumentRequestToStructure',
			'documentmanagement.DocumentRequestDownloadGrid','documentmanagement.ApplicantGroupDocumentRequestGrid','documentmanagement.ApplicantDocumentRequestToStructure',
			'documentmanagement.StudentDocumentRequestToStructure','documentmanagement.StudentGroupDocumentRequestGrid',
			'documentmanagement.DgmBulkDocumentDownloadWindow','documentmanagement.BulkDocumentDownloadForm','Academia.view.document.SimpleDocumentForm','documentmanagement.StudentSendMessagesForDGM',
			'documentmanagement.StudentDGMStaticDocumentAttachmentGrid','documentmanagement.EmployeeSendMessagesForDGM',
			'documentmanagement.EmployeeDGMStaticDocumentAttachmentGrid','documentmanagement.ApplicantDGMStaticDocumentAttachmentGrid',
			'documentmanagement.ApplicantSendMessagesForDGM'],

			refs: [{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref: 'documentgroupmasterstructure',
				selector: 'documentgroupmasterstructure'
			},{
				ref: 'documentgroupmasterseachfilter',
				selector: 'documentgroupmasterseachfilter'
			},{
				ref: 'documentgroupmasterpanel',
				selector: 'documentgroupmasterpanel'
			},{
				ref: 'documentgroupmastergrid',
				selector: 'documentgroupmastergrid'
			},{
				ref: 'documentgroupform',
				selector: 'documentgroupform'
			},{
				ref: 'documentrequesttostructure',
				selector: 'documentrequesttostructure'
			},{
				ref: 'groupdocumentrequestgrid',
				selector: 'groupdocumentrequestgrid'
			},{
				ref: 'documentrequesttoviewwindow',
				selector: 'documentrequesttoviewwindow'
			},{
				ref: 'documentrequestdownloadgrid',
				selector: 'documentrequestdownloadgrid'
			},{
				ref: 'groupdocumentrequestgrid',
				selector: 'groupdocumentrequestgrid'
			},{
				ref: 'applicantdocumentrequesttostructure',
				selector: 'applicantdocumentrequesttostructure'
			},{
				ref: 'studentdocumentrequesttostructure',
				selector: 'studentdocumentrequesttostructure'
			},{
				ref: 'dgmbulkdocumentdownloadwindow',
				selector: 'dgmbulkdocumentdownloadwindow'
			},{
				ref: 'bulkdocumentdownloadform',
				selector: 'bulkdocumentdownloadform'
			},{
				ref:'simpledocumentform',
				selector:'simpledocumentform'
			},{
				ref:'studentgroupdocumentrequestgrid',
				selector:'studentgroupdocumentrequestgrid'
			},{
				ref:'studentsendmessagesfordgm',
				selector:'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs]'
			},{
				ref :'studentDGMStaticDocumentAttachmentGrid',
				selector : 'studentdgmstaticdocumentattachmentgrid [itemId=studentDGMStaticDocumentAttachmentGridMessage]'
			},{
				ref: 'employeesendmessagesfordgm',
				selector: 'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs]'
			},{
				ref :'employeeDGMStaticDocumentAttachmentGrid',
				selector : 'employeedgmstaticdocumentattachmentgrid [itemId=empDGMStaticDocumentAttachmentGridMessage]'
			},{
				ref :'applicantgroupdocumentrequestgrid',
				selector : 'applicantgroupdocumentrequestgrid'
			},{
				ref :'applicantsendmessagesfordgm',
				selector : 'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs]'
			},{
				ref :'applicantDGMStaticDocumentAttachmentGrid',
				selector : 'applicantdgmstaticdocumentattachmentgrid[itemId=appDGMStaticDocumentAttachmentGridMessage]'
			}],
			/*config: {
    	MANAGE_DOCUMENT_TYPE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_DOCUMENT_TYPE_PRIVILEGES'),
    	MANAGE_TEMPLATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_TEMPLATE_PRIVILEGES'),
    	DOCUMENT_TEMPLATE_MAPPING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DOCUMENT_TEMPLATE_MAPPING_PRIVILEGES')
    },*/
			init: function() {
				this.control({
					'documentgroupmasterseachfilter button[itemId=templateFindButtonId]': {
						click: this.loadDocumentGroupMasterGrid
					},
					'documentgroupmasterseachfilter button[itemId=resetBtn]': {
						click: this.resetDocumentGroupMasterFilter
					},
					'documentgroupmastergrid button[itemId=btnAdd]':{
						click:function(){
							this.openDocumentGroupForm('ADD');
						}
					},
					'documentgroupform[itemId=documentgroupformItemId] button[itemId=submitBtn]':{
						click: this.saveDocumentToUpload
					},
					'documentgroupform[itemId=documentgroupformItemId] button[itemId=addJobPostingBtn]':{
						click: function(obj){
							this.addMultipleDocumentToUpload("Add");
						}
					},
					'documentgroupmastergrid button[itemId=btnEdit]':{
						click: this.editDocumentRecord
					},
					'documentgroupform button[itemId=DGMDeleteBtn]':{
						click : function(deleteButton) {
							this.deleteDocRecordForm(deleteButton)
						}
					},
					'documentgroupmastergrid' : {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							var $this =this;
							if(columnName == "requestedTo"){
								if(e.target.tagName=='A'){
									$this.openRequestToViewLink(grid,record);
								}
							}
						},
						selectionchange: function(column, selected) {
							var $this = this;
							var grid = $this.getDocumentgroupmastergrid();
							var bulkDocDownloadBtn = grid.down('#bulkDocumentDownload');
							var record = grid.getSelectionModel().getSelection()[0];
							//if((!isNullOrEmpty(record))&& (record.data.applicableTo=="EMPLOYEE" || record.data.applicableTo=="STUDENT")){
							if(grid.getSelectionModel().getCount()==1){
								bulkDocDownloadBtn.setDisabled(false);
							}else{
								bulkDocDownloadBtn.setDisabled(true);
							}
							/* }else{
		    		 bulkDocDownloadBtn.setDisabled(true);
		    	 }*/
						} 	

					},
					'groupdocumentrequestgrid' : {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							var $this =this;
							if(columnName == "documentView"){
								if(e.target.tagName=='A'){
									$this.openDocumentViewWin(record);
								}
							}
						}
					},
					'applicantgroupdocumentrequestgrid' : {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							var $this =this;
							if(columnName == "documentView"){
								if(e.target.tagName=='A'){
									$this.openDocumentViewWin(record);
								}
							}
						}
					},
					'studentgroupdocumentrequestgrid' : {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							var $this =this;
							if(columnName == "documentView"){
								if(e.target.tagName=='A'){
									$this.openDocumentViewWin(record);
								}
							}
						}
					},

					'documentrequestdownloadgrid' : {
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							var $this =this;
							if(columnName == "name"){
								if(e.target.tagName=='A'){
									$this.getDownloadDocumentFile(record.raw.encryptedDocId);
								}
							}
						}
					},
					'documentrequestdownloadgrid button[itemId=downloadAll]':{
						click: this.documentReportDocumentZip
					},
					'documentgroupmastergrid button[itemId=bulkDocumentDownload]':{
						click: this.bulkDocumentDownloadWindow
					},
					'bulkdocumentdownloadform button[itemId=DgmsubmitBtn]': {	 			  
						click: function(obj) {
							this.sendDgmEmployeeBulkDocumentGenerateDetail(obj);
						}	 			  
					},
					'dgmbulkdocumentdownloadwindow button[itemId=dgmResetButtonId]': {	 			  
						click:function(obj){
							obj.up('window').close();
						}
					},
					/*'documentgroupform filefield[itemId=refDocument]':{
			change: function(refDocument, value, eOpts) {
				value = value.replace('C:\\fakepath\\', '');
				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
				refDocument.setRawValue(newValue);
			}
		},*/
					'documentgroupform button[itemId=refDocument]':{
						click:function(btn){
							var me = this;
							var fieldcontainerId = btn.up('fieldcontainer').id;

							me.getDocumentController().showDocumentFormWindow('documentgroupform', 'DOCUMENT');
							var formWin = me.getSimpledocumentform();

							setTimeout(function() {	
								formWin.config.id = fieldcontainerId;
							},300);
						}
					},

					'documentformwindow[itemId=documentgroupform] simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]':{
						change: function(refDocument, value) {

							var form =$this.getSimpledocumentform();
							var docFormat ="";
							var fileExtension = value.split('.');
							var fileExtension2 = fileExtension[1];

							if(!isNullOrEmpty(fileExtension2)&&fileExtension2=="pdf"){
								docFormat = /^.*\.(pdf)$/i;
							}else if(!isNullOrEmpty(fileExtension2)&&fileExtension2=="jpg"){
								docFormat = /^.*\.(jpg)$/i;
							}else if(!isNullOrEmpty(fileExtension2)&&fileExtension2=="jpeg"){
								docFormat = /^.*\.(jpeg)$/i;
							}else if(!isNullOrEmpty(fileExtension2)&&fileExtension2=="png"){
								docFormat = /^.*\.(png)$/i;
							}

							var file = refDocument.fileInputEl.dom.files[0];
							if (isNullOrEmpty(docFormat)) {
								refDocument.reset();
								form.config.documentDashlet=true
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ONLY_PDF_AND_IMAGE_FILES_FORMAT_IS_SUPPORTED'));
							}else if(!isNullOrEmpty(file.size)&&(file.size/1024)<=5120){
								// 5mb size of this files format should be
							}else{
								form.config.documentDashlet=true
								refDocument.reset()
								showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('FILE_SIZE_LESSTHAN_5MB_ERROR_MSG'));
							}

						}
					},
					'documentformwindow[itemId=documentgroupform] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
						click: this.getUploadALPDocument
					},
					'studentgroupdocumentrequestgrid button[itemId=sendMsgBtn]' : {
						click: this.openStudentSendMessageForDGM
					},
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.selectSectionMessageType(val,nV,oV);
						}
					},
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs] customcombobox[itemId=msgTempletId]':{
						select : function(obj,rec){
							this.selectMessageTemp(obj,rec);
						}
					},
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs] textarea[itemId=pushNotificationDiscription]':{
						change : function(val,nV,oV){
							var studentSendMessages = this.getStudentsendmessagesfordgm();
							var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
							var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs] button[itemId=adhocMsgSubmitBtn]':{
						click: function(obj) {
							var isForAll = false;
							var grid = this.getStudentgroupdocumentrequestgrid();
							var studentsendmessage = this.getStudentsendmessagesfordgm();
							var sendMessageLable = studentsendmessage.down("#sendMsgCountItemId");
							if (sendMessageLable.isVisible()) {
								isForAll = true;
							}
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.recieverType;
							if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var wsMsgEventRecipientConfigsUpdated = [];
							/*var wsMsgEventRecipientConfigsUpdated = [{ 
								                           	 	msgRecipientTypeId: 500,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            },{ 
								                           	 	msgRecipientTypeId: 600,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            }];*/

							var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.recieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;

							if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							//var abc = xyz.c;

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								//wsMsgEventRecipientConfigsUpdated = [];
								studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
							}else{
								var recipientIds;
								if(grid.itemId == 'StudentSearchResultGrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update wsMsgEventRecipientConfigsUpdated with parent ids
													var wsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update wsMsgEventRecipientConfigsUpdated with fee payer ids
															var wsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
															studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with parent ids
														var wsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with fee payer ids
														var wsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
													}
													studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
												}
											});
										}
									});

								}
								//studentsendmessage.sendMessage(obj,grid);
							}

						}
					},  
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs]  filefield[itemId=staticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							var form=this$.getStudentsendmessagesfordgm();
							var subject = form.down('#subject').getValue();
							if(isNullOrEmpty(subject)){
								form.down('#subject').setValue(' ');
							}
							this$.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
						}
					},
					'studentdgmstaticdocumentattachmentgrid[itemId=studentDGMStaticDocumentAttachmentGridMessage] actioncolumn': {
						click : function(view, rowIndex, colIndex, item, e, record, row){
							this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
						}
					},
					'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#studentDGMStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					}, 'studentsendmessagesfordgm[itemId=studentListSendMessageWindowForDGMs] radiogroup#sendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadStudentScheduleField(radio, newValue, oldValue);
						}
					},
					'groupdocumentrequestgrid button[itemId=sendMsgBtn]' : {
						click: this.openEmployeeSendMessageForDGM
					},
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.empSelectSectionMessageType(val,nV,oV);
						}
					},
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs] customcombobox[itemId=msgTempletId]':{
						select : function(obj,rec){
							this.empSelectMessageTemp(obj,rec);
						}
					},
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs] textarea[itemId=pushNotificationDiscription]':{
						change : function(val,nV,oV){
							var studentSendMessages = this.getStudentsendmessagesfordgm();
							var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
							var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs] button[itemId=adhocMsgSubmitBtn]':{
						click: function(obj) {
							var isForAll = false;
							var grid = this.getGroupdocumentrequestgrid();
							var studentsendmessage = this.getEmployeesendmessagesfordgm();
							var sendMessageLable = studentsendmessage.down("#sendMsgCountItemId");
							if (sendMessageLable.isVisible()) {
								isForAll = true;
							}
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.recieverType;
							if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var wsMsgEventRecipientConfigsUpdated = [];
							/*var wsMsgEventRecipientConfigsUpdated = [{ 
 								                           	 	msgRecipientTypeId: 500,
 								                           	 	msgTemplateConfigId: 0,	//formData.id, 
 								                           	 	selectiveRecipientIds: [] 
 								                            },{ 
 								                           	 	msgRecipientTypeId: 600,
 								                           	 	msgTemplateConfigId: 0,	//formData.id, 
 								                           	 	selectiveRecipientIds: [] 
 								                            }];*/

							var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.recieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;

							if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							//var abc = xyz.c;

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								//wsMsgEventRecipientConfigsUpdated = [];
								studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
							}else{
								var recipientIds;
								if(grid.itemId == 'StudentSearchResultGrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update wsMsgEventRecipientConfigsUpdated with parent ids
													var wsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update wsMsgEventRecipientConfigsUpdated with fee payer ids
															var wsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
															studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with parent ids
														var wsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with fee payer ids
														var wsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
													}
													studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
												}
											});
										}
									});

								}
								//studentsendmessage.sendMessage(obj,grid);
							}

						}
					},  
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs]  filefield[itemId=staticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							var form=this$.getEmployeesendmessagesfordgm();
							var subject = form.down('#subject').getValue();
							if(isNullOrEmpty(subject)){
								form.down('#subject').setValue(' ');
							}
							this$.uploadEmployeeStaticDocumentFileMessage(fileField, value, eOpts);
						}
					},
					'employeedgmstaticdocumentattachmentgrid[itemId=empDGMStaticDocumentAttachmentGridMessage] actioncolumn': {
						click : function(view, rowIndex, colIndex, item, e, record, row){
							this.deleteEmployeeStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
						}
					},
					'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#empDGMStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					}, 'employeesendmessagesfordgm[itemId=empListSendMessageWindowForDGMs] radiogroup#sendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadEmployeeScheduleField(radio, newValue, oldValue);
						}
					},
					
					'applicantgroupdocumentrequestgrid button[itemId=sendMsgBtn]' : {
						click: this.openApplicantSendMessageForDGM
					},
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs] radiogroup[itemId=messageType]':{
						change : function(val,nV,oV){
							this.appSelectSectionMessageType(val,nV,oV);
						}
					},
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs] customcombobox[itemId=msgTempletId]':{
						select : function(obj,rec){
							this.appSelectMessageTemp(obj,rec);
						}
					},
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs] textarea[itemId=pushNotificationDiscription]':{
						change : function(val,nV,oV){
							var studentSendMessages = this.getApplicantsendmessagesfordgm();
							var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
							var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
							var maxLength = 1000;
							var newValue = maxLength - pushTextField.getValue().length;
							pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
						}
					},
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs] button[itemId=adhocMsgSubmitBtn]':{
						click: function(obj) {
							var isForAll = false;
							var grid = this.getApplicantgroupdocumentrequestgrid();
							var studentsendmessage = this.getApplicantsendmessagesfordgm();
							var sendMessageLable = studentsendmessage.down("#sendMsgCountItemId");
							if (sendMessageLable.isVisible()) {
								isForAll = true;
							}
							var formPnl = obj.up('form');
							var isMySelfChecked = false;
							var fldValues = formPnl.getForm().getFieldValues();
							isMySelfChecked = fldValues.recieverType;
							if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
								return;
							}
							var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
							var wsMsgEventRecipientConfigsUpdated = [];
							/*var wsMsgEventRecipientConfigsUpdated = [{ 
 								                           	 	msgRecipientTypeId: 500,
 								                           	 	msgTemplateConfigId: 0,	//formData.id, 
 								                           	 	selectiveRecipientIds: [] 
 								                            },{ 
 								                           	 	msgRecipientTypeId: 600,
 								                           	 	msgTemplateConfigId: 0,	//formData.id, 
 								                           	 	selectiveRecipientIds: [] 
 								                            }];*/

							var formData = obj.up('form').getValues();

							var sendMessageToOptions = formData.recieverType;
							var isStudentChecked = false;
							var isParentChecked = false;
							var isFeePayerChecked = false;

							if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
								if(sendMessageToOptions.constructor === Array){
									if(sendMessageToOptions.length > 0){
										sendMessageToOptions.forEach(function(current_value, index, initial_array) {
											if(current_value == 1 || current_value == '1'){
												isStudentChecked = true;
											}
											if(current_value == 2 || current_value == '2'){
												isParentChecked = true;
											}
											if(current_value == 3 || current_value == '3'){
												isFeePayerChecked = true;
											}
										});
									}
								}else{
									if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
										isStudentChecked = true;
									}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
								}
							}

							//var abc = xyz.c;

							if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
								//wsMsgEventRecipientConfigsUpdated = [];
								studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
							}else{
								var recipientIds;
								if(grid.itemId == 'StudentSearchResultGrid'){
									recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
									recipientIds = Ext.encode(recipientIds);
									//typeId = 2;
									//recipientId = 2;
								}

								var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

								if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
									// Ajax Call to get Parent Ids by Admission Ids

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update wsMsgEventRecipientConfigsUpdated with parent ids
													var wsMsgEventRecipientConfigsParents = {
															msgRecipientTypeId: 66,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};
													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
														wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
													}
													wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

													// Ajax Call to get Fee Payer Ids by Admission Ids
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
														jsonData: recipientIds,
														method: 'POST',
														success: function(response) {
															// update wsMsgEventRecipientConfigsUpdated with fee payer ids
															var wsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};

															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}

															wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
															studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
														}
													});
												}
											});
										}
									});
								}else{ // Only one checkbox is selected
									var urlNew = '';
									if(isParentChecked) { // If Parent checkbox is selected
										// url for getting parent ids
										urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
									}
									if(isFeePayerChecked) { // If Fee Payer checkbox is selected
										// url for getting fee payer ids
										urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
									}

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
										jsonData: RecipientTypeCodes,
										method: 'POST',
										success: function(response) {
											var RecipientTypeCodesData = Ext.decode(response.responseText);

											Ext.Ajax.request({
												type: 'rest',
												url: urlNew,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													if(isParentChecked) { // If Parent checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with parent ids
														var wsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
													}
													if(isFeePayerChecked) { // If Fee Payer checkbox is selected
														// update wsMsgEventRecipientConfigsUpdated with fee payer ids
														var wsMsgEventRecipientConfigsFeePayer = {
																msgRecipientTypeId: 67,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
															wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
														}
														wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
													}
													studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
												}
											});
										}
									});

								}
								//studentsendmessage.sendMessage(obj,grid);
							}

						}
					},  
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs]  filefield[itemId=staticUploadFileField]': {
						change: function(fileField, value, eOpts){
							var this$ = this;
							var form=this$.getApplicantsendmessagesfordgm();
							var subject = form.down('#subject').getValue();
							if(isNullOrEmpty(subject)){
								form.down('#subject').setValue(' ');
							}
							this$.uploadApplicantStaticDocumentFileMessage(fileField, value, eOpts);
						}
					},
					'applicantdgmstaticdocumentattachmentgrid[itemId=appDGMStaticDocumentAttachmentGridMessage] actioncolumn': {
						click : function(view, rowIndex, colIndex, item, e, record, row){
							this.deleteApplicantStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
						}
					},
					'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs]': {
						render: function(grid){
							var this$ = this;
							var docGrid = grid.down('#appDGMStaticDocumentAttachmentGridMessage');
							docGrid.getStore().removeAll();
							docGrid.getStore().sync();
						}
					}, 'applicantsendmessagesfordgm[itemId=appListSendMessageWindowForDGMs]  radiogroup#sendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadApplicantScheduleField(radio, newValue, oldValue);
						}
					},



				});
			},

			// ********Open New Tab employee,student,applicant user **********
			openRequestToViewLink : function(grid,record){
				var $this = this; 
				var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				if(record.data.applicableTo=='EMPLOYEE'){
					var structure = Ext.widget('documentrequesttostructure');
					var tabName = getCommonTranslation('URP_USERS');
					var grid = structure.down('#groupdocumentrequestgridItemId');
				}else if(record.data.applicableTo=='APPLICANT'){
					var structure = Ext.widget('applicantdocumentrequesttostructure');
					var tabName = getCommonTranslation('APPLICANTS');
					var grid = structure.down('#applicantgroupdocumentrequestgridItemId');
				}else if(record.data.applicableTo=='STUDENT'){
					var structure = Ext.widget('studentdocumentrequesttostructure');
					var tabName = getCommonTranslation('STUDENTS');
					var grid = structure.down('#studentgroupdocumentrequestgridItemId');
				}
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);

				if(!isNullOrEmpty(record.data.groupName)){
					grid.down('#groupNameDisplayId').setVisible(true);
					grid.down('#groupNameDisplayId').setValue('<span style="color:strong;font-weight:bold">' +'Document Group : '+ '</span>'
							+ record.data.groupName+' '+'<span style="color:strong;font-weight:bold">' +'Due On : '+ '</span>'+dateRender(record.data.dueOn)
					);
				}
				$this.resetPageSetting(grid.getStore());
				var documentGroupMasterId = record.data.id
				grid.getStore().getProxy().extraParams={
					documentGroupMasterId:documentGroupMasterId
				};
				grid.getStore().load();
			},
			resetDocumentGroupMasterFilter: function() {
				var $this = this;
				var filter = $this.getDocumentgroupmasterseachfilter().getForm();
				filter.reset();
			},
			loadDocumentGroupMasterGrid: function(){
				var this$ = this;
				var formvalues = this$.getDocumentgroupmasterseachfilter().getValues();
				var grid = this$.getDocumentgroupmastergrid();
				var store = grid.getStore();

				var alids=[];
				var academyLocationId = formvalues.academyLocationId;
				var academyLocationIds = null;

				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
					for (var i in academyLocationId) {
						if (Ext.isObject(academyLocationId[0])) {
							alids.push(academyLocationId[i].get("id"));
						} else {
							alids.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alids.join();
				}
				else if(!isNullOrEmpty(academyLocationId)){
					academyLocationIds = academyLocationId;
				}

				var status = formvalues.status;
				if(status == "ACTIVE"){
					status = true;
				}
				else{
					status = false;
				}

				var dueOnBefore = formvalues.dueOnBefore;
				var dueOnAfter = formvalues.dueOnAfter;

				grid.getStore().getProxy().extraParams= {
					academyLocationId:academyLocationIds,
					dueOnAfter:dueOnAfter,
					dueOnBefore:dueOnBefore,
					applicableTo:formvalues.applicableOn,
					status:status,
					documentGroupMasterId :formvalues.groupName
				};
				grid.getSelectionModel().deselectAll();
				this$.resetGridSetting(grid);
				store.load();
			},
			openDocumentGroupForm:function(isView){
				$this = this;
				var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				var structure = Ext.widget('documentgroupform', {
					itemId : 'documentgroupformItemId'
				});
				var tabName = getCommonTranslation('CREATE_DOCUMENT_GROUP_MASTER');
				if (isView == 'ADD') {
					tabName = getCommonTranslation('CREATE_DOCUMENT_GROUP_MASTER')

				}
				else if (isView == 'EDIT') {
					tabName = getCommonTranslation('EDIT_DOCUMENT_GROUP_MASTER')
				} 
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
				var sgForm = $this.getDocumentgroupform();
				/* if(openView == 'ADD'){
		   var portalId = $this.getCurrentLoggedPortalId();
		   var submitPortalData = sgForm.down("#submitPortalId");
		   submitPortalData.setValue(portalId);
		   submitPortalData.resetOriginalValue();
		  // sgForm.down('#viewCalendar').setDisabled(true);
	   }*/

				var imageUploadFieldArr = ['refDocumentField'];
				var academyLocationId = this.getCurrentAcademyLocation();

				Ext.Ajax.request({
					url: SERVERURL.COMMON_FORM_FIELD_INFO,
					method: 'GET',
					async: false,
					params: {
						academyLocationId:academyLocationId,
						languageCode:'en'
					},
					success: function(response) {
						var json = JSON.parse(response.responseText);
						var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
						fieldInfo.set("formFieldsInfo", json);
						if( !isNullOrEmpty(json) ){
							if( !isNullOrEmpty(json.documentgroupform) ){
								var academyLocationDetailDFRConfig = json.documentgroupform;
								for( i in academyLocationDetailDFRConfig){
									var fieldConfig = academyLocationDetailDFRConfig[i];
									if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
										var refDocumentBtn = sgForm.down("#refDocument");
										if(!fieldConfig.isVisible){
											refDocumentBtn.setVisible(false);
										}else{
											refDocumentBtn.setVisible(true);
										}
									}
								}
							}
						}
					}
				});



			},
			saveDocumentToUpload: function(){

				var $this = this;
				var sgForm=this.getDocumentgroupform();
				var formValues=sgForm.getValues();
				var submitUrl,isUpdate = false;
				var contentPanel = this.getContentPanel();
				var tabName = getCommonTranslation('DOCUMENT_GROUP_MASTER');
				var grid = this.getDocumentgroupmastergrid();
				// var sgDetailGrid = $this.getDocumentgroupmastergrid();
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if (isNullOrEmpty(formValues.id)) {
					submitUrl = SERVERURL.PATH_DOCUMENT_GROUP_MASTER_CREATE;
					isUpdate = false;
					isView = 'ADD';
				} else {
					submitUrl =SERVERURL.PATH_DOCUMENT_GROUP_MASTER_UPDATE;
					isUpdate = true;
					isView = 'EDIT';
					grid.getSelectionModel().deselectAll();
				}
				var status = formValues.status;
				if(status == "ACTIVE"){
					status = true;
				}
				else{
					status = false;
				}
				var appointmentFormData=new Academia.model.documentgroupmaster.CreateDocumentGruopModel();
				if(!isNullOrEmpty(formValues.id)){
					appointmentFormData.set("id",formValues.id); 
				}
				if(!isNullOrEmpty(formValues.isDocumentRequested)){
					appointmentFormData.set("isDocumentRequested",formValues.isDocumentRequested); 
				}
				appointmentFormData.set("groupName",formValues.name);
				appointmentFormData.set("status",status);
				appointmentFormData.set("dueOn",formValues.dueOn);
				appointmentFormData.set("applicableTo",formValues.applicableOn);
				appointmentFormData.set("isMultipleTimeUpload",formValues.wetherConfigured);
				if(!isNullOrEmpty(formValues.allowafteduodate)){
					appointmentFormData.set("allowUploadAfterDueDate",formValues.allowafteduodate);
				}

				if(!isNullOrEmpty(formValues.description)){
					appointmentFormData.set("description",formValues.description);
				}
				var ALIds=[];
				if(formValues.id==null){
					// var ALIds=[];
					for (var i=0; i<formValues.academyLocationId.length; i++) {
						var alids ={
								"id":(formValues.academyLocationId[i].data!=undefined)?formValues.academyLocationId[i].data.id:formValues.academyLocationId
						}
						academyLocation={
								"academyLocation":alids
						}
						ALIds.push(academyLocation)
					}
				}else
				{
					for (var i=0; i<formValues.academyLocationId.length; i++) {
						academyLocation={
								"academyLocation":{
									"id":(formValues.academyLocationId[i].data!=undefined)?formValues.academyLocationId[i].data.id:formValues.academyLocationId[i]
								}
						}	
						ALIds.push(academyLocation)
					}
				}

				appointmentFormData.set("documentGroupMasterLocations",ALIds);

				var refDocList =[];

				if (!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
						&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length > 1) {
					for (var i = 0; i < $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length; i++) {

						var refDocList1 = {
								"name" : formValues.refDocumentField[i],
								"path" : formValues.refDocumentFieldHidden[i],
								"type" : "DOCUMENT",
								"createdBy" : $this.getCurrentlyLoggedInUser()
						};

						refDocList.push(refDocList1);
					}
				}else if(!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
						&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length == 1){
					for (var i = 0; i < $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length; i++) {

						var refDocList1 = {
								"name" : formValues.refDocumentField,
								"path" : formValues.refDocumentFieldHidden,
								"type" : "DOCUMENT",
								"createdBy" : $this.getCurrentlyLoggedInUser()
						};

						refDocList.push(refDocList1);
					}
				}

				var departmentArray = [];
				var totalWeightage=0;
				var duplicateIdMap = new Ext.util.HashMap();
				var duplicateIdFlag=false;
				var courseDepartmentCombo=null;
				var courseSubDepartmentCombo=null;
				var data;
				var typeName;
				if(!isEmpty(formValues.uploadName) || !isEmpty(formValues.sizeName)|| !isEmpty(formValues.typeName)){
					if(isEmpty(formValues.courseDepartmentId)){
						if (!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
								&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length > 1) {

							for (var i = 0; i < $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length; i++) {
								if(!isNullOrEmpty(formValues.uploadName[i]) && !isNullOrEmpty(formValues.sizeName[i]) && !isNullOrEmpty(formValues.typeName[i])){
									
									data = Ext.ComponentQuery.query('[name=typeName]')[i].getValue();
									typeName = Ext.Array.pluck(Ext.Array.pluck(data,'data'),'value').join(); 
									var newData = {
											"documentName" : formValues.uploadName[i],
											"documentFormat" : typeName,
											"size" :  formValues.sizeName[i],
											"referenceDocument" :  refDocList[i],
									};

									departmentArray.push(newData);
								}
							}

						}else if(!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
								&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length == 1){
							if(!isNullOrEmpty(formValues.uploadName) && !isNullOrEmpty(formValues.sizeName) && !isNullOrEmpty(formValues.typeName)){
								
								typeName = Ext.Array.pluck(Ext.Array.pluck(formValues.typeName,'data'),'value').join(); 
								var newData = {
										"documentName" : formValues.uploadName,// formValues.uploadNam,
										"documentFormat" :typeName, //formValues.typeName,
										"size" :formValues.sizeName, //formValues.sizeName,
										//"id" :  formValues.courseDepartmentId,
										"referenceDocument" :  refDocList[0],

								};
								departmentArray.push(newData);
							}

						}
					}else{
						if (!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
								&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length > 1) {

							for (var i = 0; i < $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length; i++) {
								if(!isNullOrEmpty(formValues.uploadName[i]) && !isNullOrEmpty(formValues.sizeName[i]) && !isNullOrEmpty(formValues.typeName[i])){
									
									data = Ext.ComponentQuery.query('[name=typeName]')[i].getValue();
									
									
									if(typeof data== 'object' && data.length>0 && typeof data[0]=='object'){
										typeName = Ext.Array.pluck(Ext.Array.pluck(data,'data'),'value').join(); 
									
									}else if(typeof data== 'object' && data.length>0 && typeof data[0]=='string'){
										typeName = data.join();
									}
									
									var newData = {
											"documentName" : formValues.uploadName[i],
											"documentFormat" : typeName,
											"size" :  formValues.sizeName[i],
											"id" :  formValues.jobMappingId[i],
											"referenceDocument" :  refDocList[i],
									};

									departmentArray.push(newData);
								}
							}

						}else if(!isNullOrEmpty($this.getDocumentgroupform().down('#serviceStopPanelId').items.items)
								&& $this.getDocumentgroupform().down('#serviceStopPanelId').items.items.length == 1){
							if(!isNullOrEmpty(formValues.uploadName[i]) && !isNullOrEmpty(formValues.sizeName[i]) && !isNullOrEmpty(formValues.typeName[i])){
								
								if(typeof formValues.typeName== 'object' && formValues.typeName.length>0 && typeof formValues.typeName[0]=='object'){
									typeName = Ext.Array.pluck(Ext.Array.pluck(formValues.typeName,'data'),'value').join(); 
								
								}else if(typeof formValues.typeName== 'object' && formValues.typeName.length>0 && typeof formValues.typeName[0]=='string'){
									typeName = formValues.typeName.join();
								}
								var newData = {
										"documentName" : formValues.uploadName,// formValues.uploadNam,
										"documentFormat" :typeName, //formValues.typeName,
										"size" :formValues.sizeName, //formValues.sizeName,
										"id" :  formValues.courseDepartmentId,
										"referenceDocument" :  refDocList[0],

								};
								departmentArray.push(newData);
							}
						}


					}

				}

				appointmentFormData.set("documentGroupMasterRequireds", departmentArray);

				var formData = Ext.encode(appointmentFormData.data);
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : formData,
					method : 'POST',
					success : function(frm, action) {
						Ext.getBody().unmask();
						if (isUpdate) {
							tabName = getCommonTranslation('EDIT_DOCUMENT_GROUP_MASTER');
							if(isNullOrEmpty(frm.responseText)){
                       		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEPENDENCY_EXIST_MSG')); 
                       	 }else{
                       		if(frm.responseText == "DUPLICATE_GROUP_NAME") {
					            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICATE_DOCUMENT_GROUP_NAME')); 
				              }else {
				            	  showSuccessMessage(getCommonTranslation('DOCUMENT_GROUP_MASTER'), getCommonTranslation('UPDATE_DOCUMENT_MASTER_MSG'));
				              }
                       	 }
							
							if(isNullOrEmpty(frm.responseText) || frm.responseText != "DUPLICATE_GROUP_NAME") {
								sgForm.getForm().reset();
								getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}
								// this.resetPageSetting(store);
								if(grid!=undefined){
									grid.getStore().reload();		                        				  
									grid.getSelectionModel().deselectAll();
								}/*else if(sgDetailGrid!=undefined){
						   sgDetailGrid.getStore().load();
						   sgDetailGrid.getSelectionModel().deselectAll();
					   }*/ 
				              }

						}else{
							if(frm.responseText == "DUPLICATE_GROUP_NAME") {
					            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DUPLICATE_DOCUMENT_GROUP_NAME')); 
				              }else {
				            	sgForm.getForm().reset();
								tabName = getCommonTranslation('CREATE_DOCUMENT_GROUP_MASTER');
								showSuccessMessage(getCommonTranslation('DOCUMENT_GROUP_MASTER'), getCommonTranslation('ADD_DOCUMENT_MASTER_MSG'));
								getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}else{
									tabName = getCommonTranslation('EDIT_DOCUMENT_GROUP_MASTER');
									showSuccessMessage(getCommonTranslation('DOCUMENT_GROUP_MASTER'), getCommonTranslation('ADD_DOCUMENT_MASTER_MSG'));
									getTab=getcontroller.getTab(tabName);
									if(getTab!=null){
										contentPanel.remove(getTab, true);
									}
								}   

								if(grid!=undefined){
									// grid.getStore().reload();		                        				  
									grid.getSelectionModel().deselectAll();
								}/*else if(sgDetailGrid!=undefined){
						   sgDetailGrid.getStore().load();
						   sgDetailGrid.getSelectionModel().deselectAll();
					   }*/
							
							}
						}

						var manageAppointmentTabName = getMegaMenuTranslation('TS_MANAGE_APPOINTMENTS');
						var getManageAppointmentTab = getcontroller.getTab(manageAppointmentTabName);
						if (getManageAppointmentTab != null) {
							contentPanel.setActiveTab(getManageAppointmentTab);
						}
					}
				});
			},

			saveDocGrpMasterDetails: function(btn) {
				var this$ = this;
				var docPath = [];
				var form = this$.getDocumentgroupform().down('form');
				var documentsSize = $this.getDocumentgroupform().down('#serviceStopPanelId').items.items;
				for (var i = 0; i < documentsSize.length; i++) {
					if(!isNullOrEmpty(form)){
						form.getForm().submit({
							method : 'POST',
							url : SERVERURL.DOCUMENT_FILE_ADD,
							success : function(form1, action){
								var responseData = Ext.decode(action.response.responseText);
								docPath.push(responseData.path);
								if(documentsSize.length==i){
									this$.saveDocumentToUpload(docPath);
								}
							},
							failure:function(){
								console.log('hello');
							}
						});
					}
				}
			},

			addMultipleDocumentToUpload:function(isEdit,record){
				var $this = this;
				var form = $this.getDocumentgroupform();
				if(isEdit == "Add"){
					var jobPostingContainer = form.down('#serviceStopPanelId');
					var panelItem = new Array();
					//var fieldContainer=obj.up('fieldcontainer');
					var newcont=jobPostingContainer.items.items.length;
					var insertPosition=newcont+1;
					panelItem.push({
						xtype : 'fieldcontainer',
						width: '100%',
						layout : 'hbox',
						defaults: {
							labelAlign: 'top'
						},
						items : [{
							xtype: 'hidden',
							name: 'jobMappingId',
						},{
							xtype: 'textfield',
							fieldLabel: getCommonTranslation('UPLOAD_NAME'),
							name: 'uploadName',
							itemId: 'uploadNameItemId',
							width:150,
							isplayField: 'value',
							valueField: 'id'

						},{
							xtype: 'multiselectcombofield',
							fieldLabel: getCommonTranslation('TYPE'),
							name: 'typeName',
							itemId: 'typeItemId',
							width:150,
							store: Ext.create('Academia.store.documentmanagement.DocumentGroupMasterFileTypeStore'),
							displayField:'name',
							valueField:'value',


						},{
							xtype: 'numberfield',
							fieldLabel: getCommonTranslation('MAX_SIZE'),
							name: 'sizeName',
							itemId: 'sizeNameItemId',
							width:150,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							maxLength:5,
							maxValue:25600,


						},{
							xtype: 'textfield',
							itemId:'refDocumentField',
							name: 'refDocumentField',
							fieldLabel: getCommonTranslation('REFERENCE_DOCUMENT'),
							width:150,
							listeners:{
								afterrender:function(obj){
									var form = $this.getDocumentgroupform();
									var imageUploadFieldArr = ['refDocumentField'];
									var academyLocationId = $this.getCurrentAcademyLocation();
									Ext.Ajax.request({
										url: SERVERURL.COMMON_FORM_FIELD_INFO,
										method: 'GET',
										async: false,
										params: {
											academyLocationId:academyLocationId,
											languageCode:'en'
										},
										success: function(response) {
											var json = JSON.parse(response.responseText);
											var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
											fieldInfo.set("formFieldsInfo", json);
											if( !isNullOrEmpty(json) ){
												if( !isNullOrEmpty(json.documentgroupform) ){
													var academyLocationDetailDFRConfig = json.documentgroupform;
													for( i in academyLocationDetailDFRConfig){
														var fieldConfig = academyLocationDetailDFRConfig[i];
														if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
															if(!fieldConfig.isVisible){
																obj.setVisible(false);
															}else{
																obj.setVisible(true);
															}
														}
													}
												}
											}
										}
									});
								}
							}
						},{
							xtype: 'hidden',
							itemId:'refDocumentFieldHidden',
							name: 'refDocumentFieldHidden',
						},{
							xtype: 'button',
							itemId:'refDocument',
							ui:'CustomBtnSubmit',
							text: getCommonTranslation('UPLOAD'),
							style:{
								marginTop:'30px',
								marginLeft:'-10px'
							},
							listeners:{
								afterrender:function(obj){
									var form = $this.getDocumentgroupform();
									var imageUploadFieldArr = ['refDocumentField'];
									var academyLocationId = $this.getCurrentAcademyLocation();
									Ext.Ajax.request({
										url: SERVERURL.COMMON_FORM_FIELD_INFO,
										method: 'GET',
										async: false,
										params: {
											academyLocationId:academyLocationId,
											languageCode:'en'
										},
										success: function(response) {
											var json = JSON.parse(response.responseText);
											var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
											fieldInfo.set("formFieldsInfo", json);
											if( !isNullOrEmpty(json) ){
												if( !isNullOrEmpty(json.documentgroupform) ){
													var academyLocationDetailDFRConfig = json.documentgroupform;
													for( i in academyLocationDetailDFRConfig){
														var fieldConfig = academyLocationDetailDFRConfig[i];
														if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
															if(!fieldConfig.isVisible){
																obj.setVisible(false);
															}else{
																obj.setVisible(true);
															}
														}
													}
												}
											}
										}
									});
								}
							}
						},,{
							xtype:'fieldcontainer',
							items:[{
								xtype: 'button',
								itemId: 'addJobPostingBtn',
								cls: 'CustomBodyBtnSettings',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px',
									//marginLeft:'-113px'
								}
							},{
								xtype: 'button',
								itemId: 'delJobPostingBtn',
								cls: 'CustomBodyBtnReject',
								glyph: ICONGLYPH.DELETEGLYPH,
								tooltip: getCommonTranslation('DELETE'),
								style:{
									marginTop:'30px'
								},
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer').up('fieldcontainer');
										var form = $this.getDocumentgroupform();
										var panelContiner = form.down('#serviceStopPanelId');
										panelContiner.remove(container);
										form.getForm().checkValidity();
									}}
							}]
						}]
					});

					jobPostingContainer.insert(insertPosition,panelItem);
					form.getForm().checkValidity();
					jobPostingContainer.doLayout();
				}else{
					var panelContiner = form.down('#serviceStopPanelId');
					panelContiner.removeAll();
					var indx = 0;
					if(record.length>0){
						record.forEach(function(obj){
							var panelItem = new Array();
							var documentName = obj.documentName;
							var documentFormat = obj.documentFormat;
							var size = obj.size;
							var id=obj.id;
							if(obj.referenceDocument){
								var refDocumentValue = obj.referenceDocument.name;	
								var refDocumentHiddenValue = obj.referenceDocument.path;
							}
							var typeArr = documentFormat.split(',');
							var typeName= [];
							for(var i in typeArr){
								typeName.push(typeArr[i]);
							}

							/*if(panelContiner.items.length == 0){
					panelItem.push({
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						scope: $this,
						defaults : {
							labelAlign : 'top',
						},
						layout : {
							type : 'hbox'
						},

						items:[{
				            xtype: 'textfield',
				            fieldLabel: getCommonTranslation('UPLOAD_NAME'),
				            name: 'uploadName',
				            itemId: 'uploadNameItemId',
				            width:150,
				            value:documentName
				           isplayField: 'value',
				            valueField: 'value'

				        },{
				        	xtype: 'customcombobox',
				            fieldLabel: getCommonTranslation('TYPE'),
				            name: 'typeName',
				            itemId: 'typeItemId',
				            width:150,
				            store: Ext.create('Academia.store.documentmanagement.DocumentGroupMasterFileTypeStore'),
				             displayField:'name',
				             value:documentFormat,
					        	valueField:'value',


				        },{
				            xtype: 'numberfield',
				            fieldLabel: getCommonTranslation('MAX_SIZE'),
				            name: 'sizeName',
				            itemId: 'sizeNameItemId',
				            width:150,
				            value:size,
				            hideTrigger: true,
					        keyNavEnabled: false,
					        mouseWheelEnabled: false,
					        allowExponential:false,
					        maxLength:4,
					        maxValue:2048,


				        },{
				    		xtype: 'textfield',
				    		itemId:'refDocumentField',
				    		name: 'refDocumentField',
				    		fieldLabel: getCommonTranslation('REFERENCE_DOCUMENT'),
				    		 width:150,
				    		 value:refDocumentValue,
				    		 listeners:{
				    			 afterrender:function(obj){
										var form = $this.getDocumentgroupform();
										var imageUploadFieldArr = ['refDocumentField'];
										var academyLocationId = $this.getCurrentAcademyLocation();
										Ext.Ajax.request({
											url: SERVERURL.COMMON_FORM_FIELD_INFO,
											method: 'GET',
											async: false,
											params: {
												academyLocationId:academyLocationId,
												languageCode:'en'
											},
											success: function(response) {
												var json = JSON.parse(response.responseText);
												var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
												fieldInfo.set("formFieldsInfo", json);
												if( !isNullOrEmpty(json) ){
													if( !isNullOrEmpty(json.documentgroupform) ){
														var academyLocationDetailDFRConfig = json.documentgroupform;
														for( i in academyLocationDetailDFRConfig){
															var fieldConfig = academyLocationDetailDFRConfig[i];
															if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
																if(!fieldConfig.isVisible){
																	obj.setVisible(false);
																}else{
																	obj.setVisible(true);
																}
															}
														}
													}
												}
											}
										});
									}
				               }
				    	},{
				    		xtype: 'hidden',
				    		itemId:'refDocumentFieldHidden',
				    		name: 'refDocumentFieldHidden',
				    		 value:refDocumentHiddenValue
				    	},{
				    		xtype: 'button',
				    		itemId:'refDocument',
				    		ui:'CustomBtnSubmit',
				    		text: getCommonTranslation('UPLOAD'),
				    		style:{
									marginTop:'30px',
									marginLeft:'-10px'
								},
								listeners:{
					    			 afterrender:function(obj){
											var form = $this.getDocumentgroupform();
											var imageUploadFieldArr = ['refDocumentField'];
											var academyLocationId = $this.getCurrentAcademyLocation();
											Ext.Ajax.request({
												url: SERVERURL.COMMON_FORM_FIELD_INFO,
												method: 'GET',
												async: false,
												params: {
													academyLocationId:academyLocationId,
													languageCode:'en'
												},
												success: function(response) {
													var json = JSON.parse(response.responseText);
													var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
													fieldInfo.set("formFieldsInfo", json);
													if( !isNullOrEmpty(json) ){
														if( !isNullOrEmpty(json.documentgroupform) ){
															var academyLocationDetailDFRConfig = json.documentgroupform;
															for( i in academyLocationDetailDFRConfig){
																var fieldConfig = academyLocationDetailDFRConfig[i];
																if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
																	if(!fieldConfig.isVisible){
																		obj.setVisible(false);
																	}else{
																		obj.setVisible(true);
																	}
																}
															}
														}
													}
												}
											});
										}
					               }
				    	},{
							xtype: 'hidden',
							name: 'courseDepartmentId',
							value:id

						},{
							xtype: 'button',
							itemId: 'addJobPostingBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px',
								//marginLeft:'-2px'
							}
						},{
							xtype: 'button',
							itemId: 'delJobPostingBtn',
							cls: 'CustomBodyBtnReject',
							glyph: ICONGLYPH.DELETEGLYPH,
							tooltip: getCommonTranslation('DELETE'),
							style:{
								marginTop:'30px',
								//marginLeft:'-200px'
							},
							listeners:{
								click:function(obj){
									var container = obj.up('fieldcontainer').up('fieldcontainer');
									var form = $this.getDocumentgroupform();
									var panelContiner = form.down('#serviceStopPanelId');
									panelContiner.remove(container);
									form.getForm().checkValidity();
								}}
						}]

					});
				}else{*/
							panelItem.push({
								xtype : 'fieldcontainer',
								layout : 'hbox',
								width: '100%',
								scope: $this,
								defaults : {
									labelAlign : 'top',
								},
								layout : {
									type : 'hbox'
								},
								//margin: '10 0 0 0',
								//padding: '0 0 0 0',
								items:[{
									xtype: 'hidden',
									name: 'jobMappingId',
									value:id
								},{
									xtype: 'textfield',
									fieldLabel: getCommonTranslation('UPLOAD_NAME'),
									name: 'uploadName',
									itemId: 'uploadNameItemId',
									width:150,
									value:documentName
									/*isplayField: 'value',
				            valueField: 'value'
									 */				           
								},{
									xtype: 'multiselectcombofield',
									fieldLabel: getCommonTranslation('TYPE'),
									name: 'typeName',
									itemId: 'typeItemId',
									width:150,
									store: Ext.create('Academia.store.documentmanagement.DocumentGroupMasterFileTypeStore'),
									displayField:'name',
									value:typeName,
									valueField:'value',


								},{
									xtype: 'numberfield',
									fieldLabel: getCommonTranslation('MAX_SIZE'),
									name: 'sizeName',
									itemId: 'sizeNameItemId',
									width:150,
									value:size,
									hideTrigger: true,
									keyNavEnabled: false,
									mouseWheelEnabled: false,
									allowExponential:false,
									maxLength:5,
									maxValue:25600,


								},{
									xtype: 'textfield',
									itemId:'refDocumentField',
									name: 'refDocumentField',
									fieldLabel: getCommonTranslation('REFERENCE_DOCUMENT'),
									width:150,
									value:refDocumentValue,
									listeners:{
										afterrender:function(obj){
											var form = $this.getDocumentgroupform();
											var imageUploadFieldArr = ['refDocumentField'];
											var academyLocationId = $this.getCurrentAcademyLocation();
											Ext.Ajax.request({
												url: SERVERURL.COMMON_FORM_FIELD_INFO,
												method: 'GET',
												async: false,
												params: {
													academyLocationId:academyLocationId,
													languageCode:'en'
												},
												success: function(response) {
													var json = JSON.parse(response.responseText);
													var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
													fieldInfo.set("formFieldsInfo", json);
													if( !isNullOrEmpty(json) ){
														if( !isNullOrEmpty(json.documentgroupform) ){
															var academyLocationDetailDFRConfig = json.documentgroupform;
															for( i in academyLocationDetailDFRConfig){
																var fieldConfig = academyLocationDetailDFRConfig[i];
																if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
																	if(!fieldConfig.isVisible){
																		obj.setVisible(false);
																	}else{
																		obj.setVisible(true);
																	}
																}
															}
														}
													}
												}
											});
										}
									}
								},{
									xtype: 'hidden',
									itemId:'refDocumentFieldHidden',
									name: 'refDocumentFieldHidden',
									value:refDocumentHiddenValue
								},{
									xtype: 'button',
									itemId:'refDocument',
									ui:'CustomBtnSubmit',
									text: getCommonTranslation('UPLOAD'),
									style:{
										marginTop:'30px',
										marginLeft:'-10px'
									},
									listeners:{
										afterrender:function(obj){
											var form = $this.getDocumentgroupform();
											var imageUploadFieldArr = ['refDocumentField'];
											var academyLocationId = $this.getCurrentAcademyLocation();
											Ext.Ajax.request({
												url: SERVERURL.COMMON_FORM_FIELD_INFO,
												method: 'GET',
												async: false,
												params: {
													academyLocationId:academyLocationId,
													languageCode:'en'
												},
												success: function(response) {
													var json = JSON.parse(response.responseText);
													var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
													fieldInfo.set("formFieldsInfo", json);
													if( !isNullOrEmpty(json) ){
														if( !isNullOrEmpty(json.documentgroupform) ){
															var academyLocationDetailDFRConfig = json.documentgroupform;
															for( i in academyLocationDetailDFRConfig){
																var fieldConfig = academyLocationDetailDFRConfig[i];
																if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
																	if(!fieldConfig.isVisible){
																		obj.setVisible(false);
																	}else{
																		obj.setVisible(true);
																	}
																}
															}
														}
													}
												}
											});
										}
									}
								},{
									xtype: 'hidden',
									name: 'courseDepartmentId',
									value:id
								},{
									xtype: 'button',
									itemId: 'addJobPostingBtn',
									cls: 'CustomBodyBtnSettings',
									text: getCommonTranslation('ADDBUTTONTEXT'),
									tooltip: getCommonTranslation('ADD'),
									style:{
										marginTop:'30px',
										//marginLeft:'173px'
									}
								},{
									xtype: 'button',
									itemId: 'DGMDeleteBtn',
									cls: 'CustomBodyBtnReject',
									glyph: ICONGLYPH.DELETEGLYPH,
									tooltip: getCommonTranslation('DELETE'),
									hidden: (insertPosition == 1 ? true : false),
									style: {
										marginTop: '30px'
									},
									listeners:{
										click:function(obj){
											var container = obj.up('fieldcontainer');
										}
									}

								}]

							});
							//}

							panelContiner.add(panelItem);
							indx = indx + 1; 
							panelContiner.doLayout();
						});
					}
				}

			},
			editDocumentRecord:function(){
				var $this = this;
				var grid = $this.getDocumentgroupmastergrid();
				if(grid.getSelectionModel().getCount()>0) {
					$this.openDocumentGroupForm('EDIT');
					var committeeform = $this.getDocumentgroupform().getForm();
					if(Ext.ComponentQuery.query('documentgroupform').length>1){
						var committeeform =Ext.ComponentQuery.query('documentgroupform')[1].getForm()
					}
					
					$this.populateCommitteeRecord(grid, committeeform, true);
					var record = grid.getSelectionModel().getSelection()[0];

				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			populateCommitteeRecord:function(grid, committeeform, isEditable){
				var $this = this;
				var record = grid.getSelectionModel().getSelection()[0];

				var submitUrl = SERVERURL.PATH_DOCUMENT_GROUP_MASTER_FIND_BY_ID;
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl+"?documentGroupMasterId="+record.data.id,
					method : 'GET',
					success : function(resp, action) {
						Ext.getBody().unmask();
						var data = Ext.decode(resp.responseText);
						var documentGroupName = committeeform.findField('name');
						documentGroupName.setValue(data.groupName);
						var documentGroupDescription = committeeform.findField('description');
						documentGroupDescription.setValue(data.description);
						var isDocumentRequested = committeeform.findField('isDocumentRequested');
						isDocumentRequested.setValue(data.isDocumentRequested);
						var status = committeeform.findField('status');
						status.getStore().load({
							callback:function(record) {
								if(data.status) {
									status.setValue(record[0].data.id);
								} else {
									status.setValue(record[1].data.id);
								}
							}
						});
						var documentGroupApplicableOn = committeeform.findField('applicableOn');
						documentGroupApplicableOn.setValue(data.applicableTo);
						var dueOn = committeeform.findField('dueOn');
						dueOn.setValue(dateRender(data.dueOn));
						var allowafteduodate = committeeform.findField('allowafteduodate');
						allowafteduodate.setValue(data.allowUploadAfterDueDate);
						var isMultipleTimeUpload = committeeform.findField('wetherConfigured');
						var isMultipleTimeUpload1 = committeeform.findField('wetherConfigured');
						if(data.isMultipleTimeUpload==true){
							isMultipleTimeUpload1.setValue(data.isMultipleTimeUpload);
						}else{
							isMultipleTimeUpload.setValue(data.isMultipleTimeUpload);
						}
						committeeform.findField('groupTypeRadio').setValue({
							wetherConfigured: data.isMultipleTimeUpload
						});

						var academyLocation = committeeform.findField('academyLocationId');
						var alArray= [];
						if(!isNullOrEmpty(data.documentGroupMasterLocations)) {
							for(var i in data.documentGroupMasterLocations){
								alArray.push(data.documentGroupMasterLocations[i].academyLocation.id);
							}
						}
						academyLocation.getStore().load({
							callback:function(record) {
								academyLocation.setValue(alArray);
							}
						});
						if(isDocumentRequested.getValue()=='true'){
							academyLocation.setReadOnly(true);

						}
						var id = committeeform.findField('id');
						id.setValue(data.id);
						if(data.documentGroupMasterRequireds.length>0){
							$this.addMultipleDocumentToUpload("Edit",data.documentGroupMasterRequireds);
						}
					}
				});
			},
			deleteDocRecordForm: function(deleteButton) {
				var this$ = this;
				var form=this$.getDocumentgroupform()
				var departmentPanel = form.down('#serviceStopPanelId');
				var container = deleteButton.up('fieldcontainer');
				if (container != null && departmentPanel != null) {
					if (departmentPanel.items.length > 1) {
						departmentPanel.remove(container);
						// this$.departmentHideShowDetailsOfBasic(departmentPanel);
					}
				}
				form.getForm().checkValidity();

			},
			openDocumentViewWin: function(record){
				var $this=this;
				var structure = Ext.widget('documentrequesttoviewwindow');
				var grid = structure.down('#documentrequestdownloadgridItemId');
				var documentGroupMasterId = record.data.documentGroupMasterId
				var personId = record.data.personId
				var applicantPersonId;
				if(record.data.applicantPersonId!=null){
					applicantPersonId=record.data.applicantPersonId
				}

				grid.getStore().getProxy().extraParams={
					documentGroupMasterId:documentGroupMasterId,
					personId:personId,
					applicantPersonId:applicantPersonId
				};
				grid.getStore().load();
				var formWindow = $this.getDocumentrequesttoviewwindow();
				if (!formWindow) {
					formWindow=Ext.widget('documentrequesttoviewwindow');
				}
				formWindow.show();
			},
			getDownloadDocumentFile : function(documentId){
				if(!isNullOrEmpty(documentId)){
					var $this = this;
					$this.getDocumentController()
					.downloadDocumentFile(
							documentId);
				}
			},
			getDocumentController : function() {
				var this$ = this;
				return this$
				.getController('Academia.controller.document.DocumentController');
			},
			documentReportDocumentZip : function() {
				var $this = this;
				// var structure = Ext.widget('documentrequesttoviewwindow');
				var structure = $this.getDocumentrequesttoviewwindow();

				var grid = structure.down('#documentrequestdownloadgridItemId');
				if (grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();
					var dispatchZipName = "Document Group Master";
					var saveModel=[];  
					for(var i in records){
						if(!isNullOrEmpty(records[i].get('path'))) {
							saveModel.push(records[i].get('path'));
						}
						showConfirmMessage(getPersonModuleTranslation('DOCUMENTS'),
								getPersonModuleTranslation('GROUP_MASTER_DOCUMENTS_ALERT'),
								function(btn, text) {
							if (btn == 'yes') {
								var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
								$this.getController('Academia.controller.document.DocumentController')
								.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
							}
						});

					}
				}
				else {
					$this.hideWindowMask();
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			}, 
			bulkDocumentDownloadWindow: function(btn) {      
				var $this = this;
				var grid = $this.getDocumentgroupmastergrid();
				var record;
				if(grid.getSelectionModel().getCount()>0) { 
					record = grid.getSelectionModel().getSelection()[0];
					if(record.data.isDocumentRequested == true){ 
						//if(record.data.applicableTo=="EMPLOYEE" || record.data.applicableTo=="STUDENT"){
						var formWindow = this.getDgmbulkdocumentdownloadwindow();
						if (isEmpty(formWindow)) {
							formWindow = Ext.widget('dgmbulkdocumentdownloadwindow');
						}
						formWindow.show();
						/*}else{
	    			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_VALID_RECORD'));
	    		 }
						 */	    	 }else{
							 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENTS_NOT_REQUESTED'));
						 }
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
				var bulkDocDownloadForm = this.getBulkdocumentdownloadform();
				var documentName = bulkDocDownloadForm.down('#dgmDocumentId');
				documentName.getStore().getProxy().extraParams={
					docGroupmMasterId:record.data.id
				};


				documentName.getStore().load({

					callback:function(record) {
						var alArray= [];
						for(var i in record){
							alArray.push(record[i].data.id);
						}
						documentName.setValue(alArray);
					}
				});    
			},
			sendDgmEmployeeBulkDocumentGenerateDetail:function(obj){          


				var $this = this;
				var grid = $this.getDocumentgroupmastergrid();
				var record = grid.getSelectionModel().getSelection()[0];

				if(record.data.documentStatus!="Pending"){
					var bulkDocDownloadForm = this.getBulkdocumentdownloadform();

					var fileNameFormat = bulkDocDownloadForm.down('#dgmFileNameFormat').getValue().dgmFileNameFormat;
					var folderStructure = bulkDocDownloadForm.down('#dgmFolderStructure').getValue().dgmFolderStructure;


					var applicableTo= record.data.applicableTo;
					var userId = $this.getCurrentlyLoggedInUser().id;

					var ids =bulkDocDownloadForm.down('#dgmDocumentId').getValue();
					var documentIdCodeArray = [];
					for(var i in ids){
						documentIdCodeArray.push(ids[i]);
					}

					var formData = {

							"docGrpMasterRequiredIds":documentIdCodeArray,
							"fileNameFormate":fileNameFormat,
							"folderStructureBy":folderStructure,
							"userId":userId,
							"requestFor":applicableTo,
					};  	        		


					submitUrl = SERVERURL.PATH_DOWNLOAD_ALL_REQ_DGM;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : formData,
						method : 'POST',
						success : function(form, action) {
							//obj.up('window').close();
							showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
						}
					});
					obj.up('window').close();
				} else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
				}
			},
			getUploadALPDocument : function(){
				var $this=this;
				var form =$this.getSimpledocumentform();
				var fieldConId = Ext.getCmp(form.config.id);
				var refDocumentField = fieldConId.down('#refDocumentField');
				var refDocumentFieldHidden = fieldConId.down('#refDocumentFieldHidden')
				var docName = form.down('#documentNameField').getValue();
				refDocumentField.setValue(docName);

				form.getForm().submit({
					method : 'POST',
					url : SERVERURL.DOCUMENT_FILE_ADD,
					success : function(form1, action){
						var responseData = Ext.decode(action.response.responseText);
						refDocumentFieldHidden.setValue(responseData.path);
						$this.getDocumentController().closeDocumentFormWindow();
					}

				});
			},

			openStudentSendMessageForDGM:function(obj){

				var grid = this.getStudentgroupdocumentrequestgrid();

				if(grid.getSelectionModel().getCount()>0) {

					var $this=this;
					var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					var structure = Ext.widget('studentsendmessagesfordgm',{
						itemId:'studentListSendMessageWindowForDGMs'
					});
					var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
					var formWindowTab = $this.getStudentsendmessagesfordgm();
					formWindowTab.down("#selectTemplate").allowBlank=true;
					formWindowTab.down("#selectTemplate").setVisible(false);
					formWindowTab.down("#messageName").allowBlank=true;   
					formWindowTab.down("#messageName").setVisible(false);
					var templateStore = formWindowTab.down('#selectTemplate').getStore();
					templateStore.getProxy().extraParams={
						msgRecipientTypeId:2
					};
					templateStore.load();

					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "GET",
						type : 'rest',
						url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
						headers : {
							'Content-Type' : 'application/json'
						},
						success : function(form,action) {
							var data = Ext.JSON.decode(form.responseText);
							formWindowTab.down("#id").setValue(data.id);
							formWindowTab.down("#code").setValue(data.code);
							formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
							formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
							formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
							Ext.getBody().unmask();

						}

					});

				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},

			selectSectionMessageType : function(val,nV,oV){

				var $this =  this;
				var formWin = $this.getStudentsendmessagesfordgm();

				//var value = nV.1;
				formWin.down('#recieverTypeIncludeMySelf').setValue(false);
				if(nV.messageType==2){
					formWin.down("#messageId").hide();
					formWin.down("#selectTemplate").allowBlank=true;
					formWin.down("#selectTemplate").setVisible(false);     		 
					formWin.down("#messageName").allowBlank=true;   
					formWin.down("#messageName").setVisible(false);
					formWin.down("#msgTempletId").setVisible(true);
					formWin.down("#msgTempletId").allowBlank=false;
					formWin.down("#msgTempletId").reset();
					formWin.down("#subject").setVisible(true);
					//formWin.down("#subject").allowBlank=false;
					formWin.down("#subject").reset();
					formWin.down("#discriptionId").setVisible(true);
					formWin.down("#discriptionId").reset();
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
					this.setAllowBlank (formWin.down("#subject"),false);
				}else{
					formWin.down("#msgTempletId").allowBlank=true;
					formWin.down("#msgTempletId").setVisible(false);     		
					formWin.down("#messageId").setVisible(true);
					formWin.down("#selectTemplate").setVisible(true);     		
					formWin.down("#messageName").setVisible(true);
					formWin.down("#messageName").reset();
					//formWin.down("#subject").allowBlank=true;
					this.setAllowBlank (formWin.down("#subject"),true);
					formWin.down("#subject").setVisible(false);
					formWin.down("#discriptionId").setVisible(false);
					formWin.down("#messageName").allowBlank=false;  
					formWin.down("#selectTemplate").allowBlank=false;
					formWin.down("#selectTemplate").reset();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").setVisible(false);
					formWin.down("#staticUploadFileField").setVisible(false);
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
					this.setAllowBlank (formWin.down("#messageName"),false);
					this.setAllowBlank (formWin.down("#selectTemplate"),false);
					// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
					// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
					//formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
				}
			},
			selectMessageTemp: function(obj,rec){
				var $this =  this;
				var formWin = $this.getStudentsendmessagesfordgm();
				var subject = formWin.down('#subject');
				var smsDiscription = formWin.down('#smsDiscription');
				var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
				var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
				var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
				if(rec[0].data.value == "SMS")
				{  
					this.setAllowBlank (formWin.down("#subject"),true);
					//formWin.down("#subject").allowBlank=true;
					formWin.down("#subject").hide();
					formWin.down("#staticUploadFileField").hide();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").hide();
					formWin.down('#discriptionId').reset();
					formWin.down('#discriptionId').hide();	       		 
					formWin.down('#subject').reset();
					formWin.down('#smsDiscription').show();
					formWin.down('#smsDiscriptionNotice').show();
					pushNotificationDiscription.hide();
					pushNotificationDiscriptionNotice.hide();
					pushNotificationDiscription.reset();
				}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
     		 subject.show();
     		 formWin.down("#staticUploadFileField").hide();
     		 this.setAllowBlank(subject,false);
     		 formWin.down("#StudentDGMStaticDocumentAttachmentGrid").hide();
     		 formWin.down('#discriptionId').reset();
     		 formWin.down('#discriptionId').hide();
     		 subject.reset();
     		 smsDiscription.reset();
     		 smsDiscription.hide();
     		 smsDiscriptionNotice.hide();
     		 pushNotificationDiscription.reset();
     		 pushNotificationDiscription.show();
     		 pushNotificationDiscriptionNotice.show();
     		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
     		 //formWin.down('#smsDiscription')
     	 }*/else{
     		 formWin.down('#discriptionId').reset();
     		 formWin.down('#smsDiscription').reset();
     		 formWin.down('#smsDiscription').hide();
     		 formWin.down('#smsDiscriptionNotice').hide();
     		 formWin.down("#staticUploadFileField").show();
     		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
     		 formWin.down("#studentDGMStaticDocumentAttachmentGrid").show();
     		 formWin.down("#subject").reset();
     		 formWin.down("#subject").show();
     		 this.setAllowBlank (formWin.down("#subject"),false);
     		 //formWin.down("#subject").allowBlank=false;
     		 formWin.down('#discriptionId').show();
     		 pushNotificationDiscription.hide();
     		 pushNotificationDiscriptionNotice.hide();
     		 pushNotificationDiscription.reset();
     	 }
			},
			/**
			 * upload static document file for Student
			 */
			uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
				var this$ = this;
				var setupForm = fileField.up('studentsendmessagesfordgm');
				var grid = setupForm.down('#studentDGMStaticDocumentAttachmentGridMessage');
				fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
				fileField.setRawValue(fileUploadPath);
				var file = fileField.fileInputEl.dom.files[0];
				fileField.setRawValue(fileUploadPath);
				if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
					if(!isNullOrEmpty(fileUploadPath)){
						var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
						if (extension == "gif" || extension == "png" || extension == "bmp"
							|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
								|| extension == "doc" || extension == "docx" || extension == "txt"
									|| extension == "xls" || extension == "csv" || extension == "xml" 
										|| extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
							var entityId = 'student';
							var module = 'messaging';
							var entityType = 'template';
							var documentType = 'DOCUMENT';
							var isTransient = true;
							var this$ = this;
							var formWin =  this$.getStudentsendmessagesfordgm();
							Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
							this$.saveStaticDocumentFormMessage(formWin,entityId, module, entityType, documentType, function(success, action, isTransient){
								if(success){
									Ext.getBody().unmask();
									var path = Ext.JSON.decode(action.response.responseText).path;
									var user = this$.getCurrentlyLoggedInUser();
									var store = grid.getStore();
									var documentStatus = "SUBMITTED";
									var documentType = null;
									if(!isNullOrEmpty(path)){
										store.add({
											id: '',
											name: fileUploadPath,
											path: path ,
											createdBy : {
												id :user.id,
												value : user.value,
												code : user.code
											},
											status : documentStatus,
											documentType : documentType,
											templateConfigDocId: '',
											submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

										});
										this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
										showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
									}
									var form=this$.getStudentsendmessagesfordgm();
									var subject = form.down('#subject').getValue();
									if(!isNullOrEmpty(subject)){
										if(subject == ' '){
											form.down('#subject').reset();
										}
									}
									fileField.reset();
								}

							}, isTransient);
						}else{
							fileField.reset();
							showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
						}
					}
				}else{
					fileField.reset();
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				}
			},

			saveStaticDocumentFormMessage : function(formWin,entityId, module, entityType, documentType, callBackFunction, isTransient){
				var submitUrl = '';
				var templateTab = this.getContentPanel();
				var form = formWin.down('#msgDetailsForm');
				var id = form.down('#document_hidden_field');
				if (isNullOrEmpty(id.getSubmitValue())) {
					submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
				}
				var data = new Object();
				if(!isNullOrEmpty(entityId)){
					data.entityId = entityId;
				}else{
					data.entityId = null;
				}
				if(!isNullOrEmpty(module)){
					data.module = module;
				}else{
					data.module = null;
				}
				if(!isNullOrEmpty(entityType)){
					data.entityType = entityType;
				}else{
					data.entityType = null;
				}
				form.getForm().setValues(data);
				form.getForm().submit({
					method : 'POST',
					url : submitUrl,
					success : function(form, action){
						callBackFunction(true, action, isTransient);

					}
				});
			}, 

			loadGridWithFileNameMessage:function(grid,value,store){
				grid.bindStore(store);
			},
			/**
			 * Remove entry from grid
			 */
			deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
				var grid = view.up('#studentDGMStaticDocumentAttachmentGridMessage');
				var panel = this.getContentPanel().getActiveTab();
				var tabTitle = panel.title;
				var store = grid.getStore();
				var templateConfigDocId = record.get('templateConfigDocId');
				var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
				if(!(tabTitle == viewTitle)){
					if(!isNullOrEmpty(templateConfigDocId)){
						showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.STATIC_DOC_DELETE,
									method: 'DELETE',
									params: {
										templateConfigDocId : templateConfigDocId
									},
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {
										store.remove(record);
										showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
									}
								});
							}
						});

					}else{
						store.remove(record);
						showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
					}
				}else{
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
				}

			},

			loadStudentScheduleField : function(radio,newValue, oldValue){
				var adhocMessageForm = radio.up('form');
				var scheduleDateField = adhocMessageForm.down('#scheduleDate');
				var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
				var radioValue = radio.getValue().sendingPriority;

				if(radioValue=='IMMEDIATE'){
					scheduleDateField.setVisible(false);
					scheduleDateField.setDisabled(true);
					scheduleTimeField.setVisible(false);
					scheduleTimeField.setDisabled(true);    		
				}
				else if(radioValue=='SCHEDULE'){
					scheduleDateField.setVisible(true);
					scheduleDateField.setDisabled(false);
					scheduleTimeField.setVisible(true);
					scheduleTimeField.setDisabled(false);
				}
			},

			getStudentReceipientIdsForSendingMessages : function(grid){

				if (grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();
					var ids=[];
					if(grid.itemId == 'StudentSearchResultGrid'){
						for(var i in records) {
							ids.push(records[i].data.ADMISSION_ID);
						}
					}			
				}
				return ids;
			},

			openEmployeeSendMessageForDGM:function(obj){

				var grid = this.getGroupdocumentrequestgrid();

				if(grid.getSelectionModel().getCount()>0) {

					var $this=this;
					var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					var structure = Ext.widget('employeesendmessagesfordgm',{
						itemId:'empListSendMessageWindowForDGMs'
					});
					var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
					var formWindowTab = $this.getEmployeesendmessagesfordgm();
					formWindowTab.down("#selectTemplate").allowBlank=true;
					formWindowTab.down("#selectTemplate").setVisible(false);
					formWindowTab.down("#messageName").allowBlank=true;   
					formWindowTab.down("#messageName").setVisible(false);
					var templateStore = formWindowTab.down('#selectTemplate').getStore();
					templateStore.getProxy().extraParams={
						msgRecipientTypeId:2
					};
					templateStore.load();

					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "GET",
						type : 'rest',
						url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=FacultyTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
						headers : {
							'Content-Type' : 'application/json'
						},
						success : function(form,action) {
							var data = Ext.JSON.decode(form.responseText);
							formWindowTab.down("#id").setValue(data.id);
							formWindowTab.down("#code").setValue(data.code);
							formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
							formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
							formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
							Ext.getBody().unmask();

						}

					});

				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},

			empSelectSectionMessageType : function(val,nV,oV){

				var $this =  this;
				var formWin = $this.getEmployeesendmessagesfordgm();

				//var value = nV.1;
				formWin.down('#recieverTypeIncludeMySelf').setValue(false);
				if(nV.messageType==2){
					formWin.down("#messageId").hide();
					formWin.down("#selectTemplate").allowBlank=true;
					formWin.down("#selectTemplate").setVisible(false);     		 
					formWin.down("#messageName").allowBlank=true;   
					formWin.down("#messageName").setVisible(false);
					formWin.down("#msgTempletId").setVisible(true);
					formWin.down("#msgTempletId").allowBlank=false;
					formWin.down("#msgTempletId").reset();
					formWin.down("#subject").setVisible(true);
					//formWin.down("#subject").allowBlank=false;
					formWin.down("#subject").reset();
					formWin.down("#discriptionId").setVisible(true);
					formWin.down("#discriptionId").reset();
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
					this.setAllowBlank (formWin.down("#subject"),false);
				}else{
					formWin.down("#msgTempletId").allowBlank=true;
					formWin.down("#msgTempletId").setVisible(false);     		
					formWin.down("#messageId").setVisible(true);
					formWin.down("#selectTemplate").setVisible(true);     		
					formWin.down("#messageName").setVisible(true);
					formWin.down("#messageName").reset();
					//formWin.down("#subject").allowBlank=true;
					this.setAllowBlank (formWin.down("#subject"),true);
					formWin.down("#subject").setVisible(false);
					formWin.down("#discriptionId").setVisible(false);
					formWin.down("#messageName").allowBlank=false;  
					formWin.down("#selectTemplate").allowBlank=false;
					formWin.down("#selectTemplate").reset();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").setVisible(false);
					formWin.down("#staticUploadFileField").setVisible(false);
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
					this.setAllowBlank (formWin.down("#messageName"),false);
					this.setAllowBlank (formWin.down("#selectTemplate"),false);
					// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
					// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
					//formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
				}
			},
			empSelectMessageTemp: function(obj,rec){
				var $this =  this;
				var formWin = $this.getEmployeesendmessagesfordgm();
				var subject = formWin.down('#subject');
				var smsDiscription = formWin.down('#smsDiscription');
				var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
				var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
				var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
				if(rec[0].data.value == "SMS")
				{  
					this.setAllowBlank (formWin.down("#subject"),true);
					//formWin.down("#subject").allowBlank=true;
					formWin.down("#subject").hide();
					formWin.down("#staticUploadFileField").hide();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").hide();
					formWin.down('#discriptionId').reset();
					formWin.down('#discriptionId').hide();	       		 
					formWin.down('#subject').reset();
					formWin.down('#smsDiscription').show();
					formWin.down('#smsDiscriptionNotice').show();
					pushNotificationDiscription.hide();
					pushNotificationDiscriptionNotice.hide();
					pushNotificationDiscription.reset();
				}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
		    	     		 subject.show();
		    	     		 formWin.down("#staticUploadFileField").hide();
		    	     		 this.setAllowBlank(subject,false);
		    	     		 formWin.down("#StudentDGMStaticDocumentAttachmentGrid").hide();
		    	     		 formWin.down('#discriptionId').reset();
		    	     		 formWin.down('#discriptionId').hide();
		    	     		 subject.reset();
		    	     		 smsDiscription.reset();
		    	     		 smsDiscription.hide();
		    	     		 smsDiscriptionNotice.hide();
		    	     		 pushNotificationDiscription.reset();
		    	     		 pushNotificationDiscription.show();
		    	     		 pushNotificationDiscriptionNotice.show();
		    	     		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
		    	     		 //formWin.down('#smsDiscription')
		    	     	 }*/else{
		    	     		 formWin.down('#discriptionId').reset();
		    	     		 formWin.down('#smsDiscription').reset();
		    	     		 formWin.down('#smsDiscription').hide();
		    	     		 formWin.down('#smsDiscriptionNotice').hide();
		    	     		 formWin.down("#staticUploadFileField").show();
		    	     		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
		    	     		 formWin.down("#studentDGMStaticDocumentAttachmentGrid").show();
		    	     		 formWin.down("#subject").reset();
		    	     		 formWin.down("#subject").show();
		    	     		 this.setAllowBlank (formWin.down("#subject"),false);
		    	     		 //formWin.down("#subject").allowBlank=false;
		    	     		 formWin.down('#discriptionId').show();
		    	     		 pushNotificationDiscription.hide();
		    	     		 pushNotificationDiscriptionNotice.hide();
		    	     		 pushNotificationDiscription.reset();
		    	     	 }
			},
			/**
			 * upload static document file for employee
			 */
			uploadEmployeeStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
				var this$ = this;
				var setupForm = fileField.up('employeesendmessagesfordgm');
				var grid = setupForm.down('#empDGMStaticDocumentAttachmentGridMessage');
				fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
				fileField.setRawValue(fileUploadPath);
				var file = fileField.fileInputEl.dom.files[0];
				fileField.setRawValue(fileUploadPath);
				if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
					if(!isNullOrEmpty(fileUploadPath)){
						var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
						if (extension == "gif" || extension == "png" || extension == "bmp"
							|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
								|| extension == "doc" || extension == "docx" || extension == "txt"
									|| extension == "xls" || extension == "csv" || extension == "xml" 
										|| extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
							var entityId = 'employee';
							var module = 'messaging';
							var entityType = 'template';
							var documentType = 'DOCUMENT';
							var isTransient = true;
							var this$ = this;
							var formWin =  this$.getEmployeesendmessagesfordgm();
							Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
							this$.saveStaticDocumentFormMessage(formWin,entityId, module, entityType, documentType, function(success, action, isTransient){
								if(success){
									Ext.getBody().unmask();
									var path = Ext.JSON.decode(action.response.responseText).path;
									var user = this$.getCurrentlyLoggedInUser();
									var store = grid.getStore();
									var documentStatus = "SUBMITTED";
									var documentType = null;
									if(!isNullOrEmpty(path)){
										store.add({
											id: '',
											name: fileUploadPath,
											path: path ,
											createdBy : {
												id :user.id,
												value : user.value,
												code : user.code
											},
											status : documentStatus,
											documentType : documentType,
											templateConfigDocId: '',
											submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

										});
										this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
										showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
									}
									var form=this$.getEmployeesendmessagesfordgm();
									var subject = form.down('#subject').getValue();
									if(!isNullOrEmpty(subject)){
										if(subject == ' '){
											form.down('#subject').reset();
										}
									}
									fileField.reset();
								}

							}, isTransient);
						}else{
							fileField.reset();
							showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
						}
					}
				}else{
					fileField.reset();
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				}
			},

			/**
			 * Remove entry from grid
			 */
			deleteEmployeeStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
				var grid = view.up('#empDGMStaticDocumentAttachmentGridMessage');
				var panel = this.getContentPanel().getActiveTab();
				var tabTitle = panel.title;
				var store = grid.getStore();
				var templateConfigDocId = record.get('templateConfigDocId');
				var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
				if(!(tabTitle == viewTitle)){
					if(!isNullOrEmpty(templateConfigDocId)){
						showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.STATIC_DOC_DELETE,
									method: 'DELETE',
									params: {
										templateConfigDocId : templateConfigDocId
									},
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {
										store.remove(record);
										showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
									}
								});
							}
						});

					}else{
						store.remove(record);
						showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
					}
				}else{
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
				}

			},

			loadEmployeeScheduleField : function(radio,newValue, oldValue){
				var adhocMessageForm = radio.up('form');
				var scheduleDateField = adhocMessageForm.down('#scheduleDate');
				var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
				var radioValue = radio.getValue().sendingPriority;

				if(radioValue=='IMMEDIATE'){
					scheduleDateField.setVisible(false);
					scheduleDateField.setDisabled(true);
					scheduleTimeField.setVisible(false);
					scheduleTimeField.setDisabled(true);    		
				}
				else if(radioValue=='SCHEDULE'){
					scheduleDateField.setVisible(true);
					scheduleDateField.setDisabled(false);
					scheduleTimeField.setVisible(true);
					scheduleTimeField.setDisabled(false);
				}
			},
	
			openApplicantSendMessageForDGM:function(obj){

				var grid = this.getApplicantgroupdocumentrequestgrid();

				if(grid.getSelectionModel().getCount()>0) {

					var $this=this;
					var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					var structure = Ext.widget('applicantsendmessagesfordgm',{
						itemId:'appListSendMessageWindowForDGMs'
					});
					var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
					var formWindowTab = $this.getApplicantsendmessagesfordgm();
					formWindowTab.down("#selectTemplate").allowBlank=true;
					formWindowTab.down("#selectTemplate").setVisible(false);
					formWindowTab.down("#messageName").allowBlank=true;   
					formWindowTab.down("#messageName").setVisible(false);
					var templateStore = formWindowTab.down('#selectTemplate').getStore();
					templateStore.getProxy().extraParams={
						msgRecipientTypeId:2
					};
					templateStore.load();

					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "GET",
						type : 'rest',
						url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=ApplicantTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
						headers : {
							'Content-Type' : 'application/json'
						},
						success : function(form,action) {
							var data = Ext.JSON.decode(form.responseText);
							formWindowTab.down("#id").setValue(data.id);
							formWindowTab.down("#code").setValue(data.code);
							formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
							formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
							formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
							Ext.getBody().unmask();

						}

					});
					

				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},

			appSelectSectionMessageType : function(val,nV,oV){

				var $this =  this;
				var formWin = $this.getApplicantsendmessagefordgm();

				//var value = nV.1;
				formWin.down('#recieverTypeIncludeMySelf').setValue(false);
				if(nV.messageType==2){
					formWin.down("#messageId").hide();
					formWin.down("#selectTemplate").allowBlank=true;
					formWin.down("#selectTemplate").setVisible(false);     		 
					formWin.down("#messageName").allowBlank=true;   
					formWin.down("#messageName").setVisible(false);
					formWin.down("#msgTempletId").setVisible(true);
					formWin.down("#msgTempletId").allowBlank=false;
					formWin.down("#msgTempletId").reset();
					formWin.down("#subject").setVisible(true);
					//formWin.down("#subject").allowBlank=false;
					formWin.down("#subject").reset();
					formWin.down("#discriptionId").setVisible(true);
					formWin.down("#discriptionId").reset();
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
					this.setAllowBlank (formWin.down("#subject"),false);
				}else{
					formWin.down("#msgTempletId").allowBlank=true;
					formWin.down("#msgTempletId").setVisible(false);     		
					formWin.down("#messageId").setVisible(true);
					formWin.down("#selectTemplate").setVisible(true);     		
					formWin.down("#messageName").setVisible(true);
					formWin.down("#messageName").reset();
					//formWin.down("#subject").allowBlank=true;
					this.setAllowBlank (formWin.down("#subject"),true);
					formWin.down("#subject").setVisible(false);
					formWin.down("#discriptionId").setVisible(false);
					formWin.down("#messageName").allowBlank=false;  
					formWin.down("#selectTemplate").allowBlank=false;
					formWin.down("#selectTemplate").reset();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").setVisible(false);
					formWin.down("#staticUploadFileField").setVisible(false);
					formWin.down('#smsDiscription').reset();
					formWin.down('#smsDiscription').hide();
					formWin.down('#smsDiscriptionNotice').hide();
					formWin.down('#pushNotificationDiscription').hide();
					formWin.down('#pushNotificationDiscriptionNotice').hide();
					formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
					this.setAllowBlank (formWin.down("#messageName"),false);
					this.setAllowBlank (formWin.down("#selectTemplate"),false);
					// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
					// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
					//formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
				}
			},
			appSelectMessageTemp: function(obj,rec){
				var $this =  this;
				var formWin = $this.getApplicantsendmessagesfordgm();
				//var formWin = $this.getStudentsendmessages();
				var subject = formWin.down('#subject');
				var smsDiscription = formWin.down('#smsDiscription');
				var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
				var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
				var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
				if(rec[0].data.value == "SMS")
				{  
					this.setAllowBlank (formWin.down("#subject"),true);
					//formWin.down("#subject").allowBlank=true;
					formWin.down("#subject").hide();
					formWin.down("#staticUploadFileField").hide();
					formWin.down("#studentDGMStaticDocumentAttachmentGrid").hide();
					formWin.down('#discriptionId').reset();
					formWin.down('#discriptionId').hide();	       		 
					formWin.down('#subject').reset();
					formWin.down('#smsDiscription').show();
					formWin.down('#smsDiscriptionNotice').show();
					pushNotificationDiscription.hide();
					pushNotificationDiscriptionNotice.hide();
					pushNotificationDiscription.reset();
				}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
		    	     		 subject.show();
		    	     		 formWin.down("#staticUploadFileField").hide();
		    	     		 this.setAllowBlank(subject,false);
		    	     		 formWin.down("#StudentDGMStaticDocumentAttachmentGrid").hide();
		    	     		 formWin.down('#discriptionId').reset();
		    	     		 formWin.down('#discriptionId').hide();
		    	     		 subject.reset();
		    	     		 smsDiscription.reset();
		    	     		 smsDiscription.hide();
		    	     		 smsDiscriptionNotice.hide();
		    	     		 pushNotificationDiscription.reset();
		    	     		 pushNotificationDiscription.show();
		    	     		 pushNotificationDiscriptionNotice.show();
		    	     		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
		    	     		 //formWin.down('#smsDiscription')
		    	     	 }*/else{
		    	     		 formWin.down('#discriptionId').reset();
		    	     		 formWin.down('#smsDiscription').reset();
		    	     		 formWin.down('#smsDiscription').hide();
		    	     		 formWin.down('#smsDiscriptionNotice').hide();
		    	     		 formWin.down("#staticUploadFileField").show();
		    	     		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
		    	     		 formWin.down("#studentDGMStaticDocumentAttachmentGrid").show();
		    	     		 formWin.down("#subject").reset();
		    	     		 formWin.down("#subject").show();
		    	     		 this.setAllowBlank (formWin.down("#subject"),false);
		    	     		 //formWin.down("#subject").allowBlank=false;
		    	     		 formWin.down('#discriptionId').show();
		    	     		 pushNotificationDiscription.hide();
		    	     		 pushNotificationDiscriptionNotice.hide();
		    	     		 pushNotificationDiscription.reset();
		    	     	 }
			},
			/**
			 * upload static document file for applicant
			 */
			uploadApplicantStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
				var this$ = this;
				var setupForm = fileField.up('applicantsendmessagesfordgm');
				var grid = setupForm.down('#appDGMStaticDocumentAttachmentGridMessage');
				fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
				fileField.setRawValue(fileUploadPath);
				var file = fileField.fileInputEl.dom.files[0];
				fileField.setRawValue(fileUploadPath);
				if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
					if(!isNullOrEmpty(fileUploadPath)){
						var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
						if (extension == "gif" || extension == "png" || extension == "bmp"
							|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
								|| extension == "doc" || extension == "docx" || extension == "txt"
									|| extension == "xls" || extension == "csv" || extension == "xml" 
										|| extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
							var entityId = 'applicant';
							var module = 'messaging';
							var entityType = 'template';
							var documentType = 'DOCUMENT';
							var isTransient = true;
							var this$ = this;
							var formWin =  this$.getApplicantsendmessagesfordgm();
							Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
							this$.saveStaticDocumentFormMessage(formWin,entityId, module, entityType, documentType, function(success, action, isTransient){
								if(success){
									Ext.getBody().unmask();
									var path = Ext.JSON.decode(action.response.responseText).path;
									var user = this$.getCurrentlyLoggedInUser();
									var store = grid.getStore();
									var documentStatus = "SUBMITTED";
									var documentType = null;
									if(!isNullOrEmpty(path)){
										store.add({
											id: '',
											name: fileUploadPath,
											path: path ,
											createdBy : {
												id :user.id,
												value : user.value,
												code : user.code
											},
											status : documentStatus,
											documentType : documentType,
											templateConfigDocId: '',
											submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

										});
										this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
										showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
									}
									var form=this$.getApplicantsendmessagesfordgm();
									var subject = form.down('#subject').getValue();
									if(!isNullOrEmpty(subject)){
										if(subject == ' '){
											form.down('#subject').reset();
										}
									}
									fileField.reset();
								}

							}, isTransient);
						}else{
							fileField.reset();
							showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
						}
					}
				}else{
					fileField.reset();
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				}
			},

			/**
			 * Remove entry from grid
			 */
			deleteApplicantStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
				var grid = view.up('#appDGMStaticDocumentAttachmentGridMessage');
				var panel = this.getContentPanel().getActiveTab();
				var tabTitle = panel.title;
				var store = grid.getStore();
				var templateConfigDocId = record.get('templateConfigDocId');
				var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
				if(!(tabTitle == viewTitle)){
					if(!isNullOrEmpty(templateConfigDocId)){
						showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.STATIC_DOC_DELETE,
									method: 'DELETE',
									params: {
										templateConfigDocId : templateConfigDocId
									},
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {
										store.remove(record);
										showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
									}
								});
							}
						});

					}else{
						store.remove(record);
						showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
					}
				}else{
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
				}

			},

			loadApplicantScheduleField : function(radio,newValue, oldValue){
				var adhocMessageForm = radio.up('form');
				var scheduleDateField = adhocMessageForm.down('#scheduleDate');
				var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
				var radioValue = radio.getValue().sendingPriority;

				if(radioValue=='IMMEDIATE'){
					scheduleDateField.setVisible(false);
					scheduleDateField.setDisabled(true);
					scheduleTimeField.setVisible(false);
					scheduleTimeField.setDisabled(true);    		
				}
				else if(radioValue=='SCHEDULE'){
					scheduleDateField.setVisible(true);
					scheduleDateField.setDisabled(false);
					scheduleTimeField.setVisible(true);
					scheduleTimeField.setDisabled(false);
				}
			},		
});