/**
 * @author deepak Sharma 
 * This controller is used for document master functionality
 */
Ext.define('Academia.controller.documentmanagement.DocumentMasterController', {

	extend: 'Academia.controller.base.BaseController',

	stores: ['documentmanagement.DocumentMasterStore','documentmanagement.DocumentMasterFileTypeStore'],

	views: ['documentmanagement.DocumentMasterStructure', 'documentmanagement.DocumentMasterGrid','documentmanagement.DocumentMasterFormWindow'],

	models : ['documentmanagement.DocumentMasterFileTypeModel'],

	refs: [{
		ref: 'contentpanel',
		selector: 'contentpanel'
	},{
		ref : 'documentmasterstructure',
		selector : 'documentmasterstructure'
	},{
		ref: 'documentmastergrid',
		selector: 'documentmastergrid'
	},{
		ref: 'documentmasterformwindow',
		selector: 'documentmasterformwindow'
	}],
	config: {
		DOCUMENT_MASTER_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DOCUMENT_MASTER_PRIVILEGES')
	},
	init: function() {
		this.control({
			'documentmastergrid[itemId=documentmastergridItemId]': {
				render: function(grid){
					var store = grid.getStore();
					store.load();
					this.doAccessControlValidation(grid, this.getDOCUMENT_MASTER_PERMISSIONS());
				}
			},
			'documentmastergrid button[itemId=btnAdd]':{
				click: this.addDocumentMaster
			},
			'documentmastergrid button[itemId=btnEdit]': {
				click: function() {
					this.editDocumentMaster(false);
				}
			},
			'documentmastergrid button[itemId=btnDelete]': {
				click: function() {
					this.deleteDocumentMaster();
				}
			},
			'documentmastergrid button[itemId=btnView]': {
				click: function() {
					this.editDocumentMaster(true);
				}
			},
			'documentmasterformwindow button[itemId=btnCancelDocumentMasterForm]': {
				click: this.cancelDocumentMasterForm
			},
			'documentmasterformwindow button[itemId=btnSaveDocumentMasterForm]': {
				click: this.saveDocumentMasterForm
			},
		});
	},
	addDocumentMaster: function() {
		var winDocumentMasterFormWindow = Ext.widget('documentmasterformwindow');
		winDocumentMasterFormWindow.show();
	},
	cancelDocumentMasterForm: function() {
		this.getDocumentmasterformwindow().close();
	},
	saveDocumentMasterForm: function() {
		var this$ = this,
		windocumentmasterformwindow = this$.getDocumentmasterformwindow(),
		grid = this$.getDocumentmastergrid(),
		submitUrl, isUpdate = false,
		winDocMasterFormPnl = windocumentmasterformwindow.down('idgeneratorformwin'),
		//winDocMasterFormPnlValues = winDocMasterFormPnl.getForm().getFieldValues(),
		docMaster = windocumentmasterformwindow.down('#hidDocumentMasterId');

		var code = winDocMasterFormPnl.down('#codeItemId').getValue();
		var value = winDocMasterFormPnl.down('#itemValueItemId').getValue();
		var size = winDocMasterFormPnl.down('#dmmaxsize').getValue();
		var isApplicableForStudent = winDocMasterFormPnl.down('#isApplicableForStudentItemId').getValue();
		var isApplicableForEmployee= winDocMasterFormPnl.down('#isApplicableForEmployeeItemId').getValue();
		var isApplicableForParent= winDocMasterFormPnl.down('#isApplicableForParentItemId').getValue();
		var dmFileType= winDocMasterFormPnl.down('#dmfiletype').getValue();
		var codeInOtherLanguage = winDocMasterFormPnl.down('#codeInOtherLanguage').getValue();

		var dmfiletypeArray=[];
		var id;
		if(!isNullOrEmpty(docMaster.getSubmitValue())){
			id=docMaster.getSubmitValue();
		}else{
			grid.getSelectionModel().deselectAll();
		}
		var ids =[];
		var dM ;
		if(grid.getSelectionModel().getCount() > 0){
			var record = grid.getSelectionModel().getSelection()[0];
			dM = record.raw.documentMasterFileType;
			var k=0;
			for(k in dM) {
				ids.push(dM[k].id)	
			}
			if(!isNullOrEmpty(record.data.id)){
				var documentTypeId=record.data.id;
			}
			var files;
			if(dmFileType!=undefined&&dmFileType.length>0&&dmFileType[0]!=""){

				for (var i=0; i<dmFileType.length; i++) {
					if(dM[i]!=undefined){
						files={
								"id": ids[i],
								"fileType":{'id':(dmFileType[i]!=undefined)?((dmFileType[i].data!=undefined)?dmFileType[i].data.id:dmFileType[i]):dmFileType[i]},
								"size":size,
								"documentType":{"id":documentTypeId}
						}	
					}else{
						files={
								//"id": ids[i],
								"fileType":{'id':(dmFileType[i]!=undefined)?dmFileType[i].data.id:dmFileType[i]},
								"size":size,
								"documentType":{"id":documentTypeId}
						}	 
					}

					dmfiletypeArray.push(files)
				}
			}else{
				if(!isNullOrEmpty(size)){
					files={
							"size":size,
							"documentType":{"id":documentTypeId}
					}
					dmfiletypeArray.push(files)
				}else{

					if(!isNullOrEmpty(dmFileType) && dmFileType.length==0 && dmFileType[0]!="" && isNullOrEmpty(size) && isNullOrEmpty(size)){
						for (var i=0; i<dM.length; i++) {
							files={
									"id":dM[i].id,
									"documentType":{"id":documentTypeId}
							}	
							dmfiletypeArray.push(files)
						}
					}
				}
			}
		}else{
			if(!isNullOrEmpty(dmFileType)){

				for (var i=0; i<dmFileType.length; i++) {
					files={
							"fileType":{'id':(dmFileType[i].data!=undefined)?dmFileType[i].data.id:dmFileType[i]},
							"size":size
					}	
					dmfiletypeArray.push(files)
				}
			}else{
				if(!isNullOrEmpty(size)){
					files={
							"size":size
					}	
				}
				if(files!=undefined){
					dmfiletypeArray.push(files)
				}
			}
		}
		json = {
				"id":id,
				"code":code,
				"value":value,
				"isApplicableForStudent":isApplicableForStudent,
				"isApplicableForEmployee":isApplicableForEmployee,
				"isApplicableForParent":isApplicableForParent,
				"documentMasterFileType":dmfiletypeArray,
				"codeInOtherLanguage":codeInOtherLanguage
		};

		if (docMaster.getSubmitValue() == null || docMaster.getSubmitValue() == "" || docMaster.getSubmitValue() === undefined) {
			submitUrl = SERVERURL.DOCUMENT_TYPE_CREATE, // URL-rest/document/create
			isUpdate = false;
		} else {
			submitUrl = SERVERURL.DOCUMENT_TYPE_UPDATE, // URL-rest/document/update
			isUpdate = true;
		}
		var jsonFormatFormData = Ext.encode(json);

		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: jsonFormatFormData,
			method: 'POST',
			success: function(form, action) {
				if (!isNullOrEmpty(form.responseText) && form.responseText.length > 0) {
					showWarningMessage(getTranslation('PLACEMENT_DOCUMENT_MASTER'), getErrorTranslation(form.responseText));
				} else {
					windocumentmasterformwindow.close();
					this$.resetPageSetting(grid.getStore());
					grid.getStore().load();
					grid.getSelectionModel().deselectAll();
					if (isUpdate) {
						showSuccessMessage(getTranslation('PLACEMENT_DOCUMENT_MASTER'), getCommonTranslation('UPDATE_DOCUMENT_MASTER_MSG'));
					} else {
						showSuccessMessage(getTranslation('PLACEMENT_DOCUMENT_MASTER'), getCommonTranslation('ADD_DOCUMENT_MASTER_MSG'));
					}
				}
			}
		});
	},
	editDocumentMaster: function(isView) {
		var me = this;
		var grid = me.getDocumentmastergrid();
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			me.showDocumentMasterForm(records);
			if (records != "" && records != null && records != undefined) {
				var documentmasterformwindow = me.getDocumentmasterformwindow();
				var formPnl = documentmasterformwindow.down('idgeneratorformwin');
				var rec = new Academia.model.documentmanagement.DocumentMasterModel(
						records[0].data);
				formPnl.loadRecord(rec);
				grid.getStore().reload();
				if (isView) {
					documentmasterformwindow.down('#btnSaveDocumentMasterForm').setVisible(false);
					var fileType=documentmasterformwindow.down("#dmfiletype");
					fileType.setReadOnly(true);
					var size=documentmasterformwindow.down("#dmmaxsize");
					size.setReadOnly(true);
					toggleReadOnlyFormItems(formPnl.getForm(), true);
				}
			}
		} else {
			showWarningMessage(getTranslation('PLACEMENT_DOCUMENT_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
		}
	},
	showDocumentMasterForm: function(record) {
		var windocumentmasterformwindow = this.getDocumentmasterformwindow();
		if (isEmpty(windocumentmasterformwindow)) {
			windocumentmasterformwindow = Ext.widget('documentmasterformwindow');
		}
		windocumentmasterformwindow.show();
		var fileType=windocumentmasterformwindow.down("#dmfiletype");
		var size=windocumentmasterformwindow.down("#dmmaxsize");
		if(record[0].raw.documentMasterFileType.length > 0){
			size.setValue(record[0].raw.documentMasterFileType[0].size);
		}
		var fileTypeIds= [];
		if(record[0].raw.documentMasterFileType.length > 0){
			var masterData=record[0].raw.documentMasterFileType;
			for(var j in masterData){
				if(!isNullOrEmpty(masterData[j].fileType)){
					//for(var i in masterData){
					fileTypeIds.push(masterData[j].fileType.id);
					//}
				}
			}
		}
		fileType.getStore().load({
			callback: function(records, operation, success) {
				if(record[0].raw.documentMasterFileType.length > 0){
					fileType.setValue(fileTypeIds);
				}
			}	   
		});
	},
	deleteDocumentMaster: function() {
		var grid = this.getDocumentmastergrid();
		var grdStore = grid.getStore();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getCommonTranslation('DELETE_DOCUMENT_MASTER_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection();
						for (var count = 0; count < records.length; count++) {
							var id = "";
							if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
								id = records[count].get("id");
							}
							Ext.Ajax.request({
								type: 'rest',
								method: 'DELETE',
								url: SERVERURL.DOCUMENT_TYPE_DELETE + '?id=' + id,
								headers: {
									'Content-Type': 'application/json'
								},
								params: {
									id: id
								},
								success: function(form, action) {
									if (form.responseText == 0) {
										showWarningMessage(getCommonTranslation('DOCUMENT_TYPE'), getCommonTranslation('DOCUMENT_TYPE_DEPENDENCY_EXIST_ON_DELETE'));
									} else {
										showSuccessMessage(getCommonTranslation('DELETE_DOCUMENT_MASTER_DETAILS'), getCommonTranslation('DELETE_DOCUMENT_MASTER_MSG'));
										grdStore.reload();
										grid.getStore().reload();
									}

								},
								failure: function(form, action) {
									showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
								}
							});
						}
					}
				}
			});
		} else {
			showWarningMessage(getTranslation('PLACEMENT_DOCUMENT_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	}
});