/**
 * Rajkumar
 *
 */
Ext.define('Academia.controller.enquiry.followup.FollowUpDetailController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['enquiry.closure.ClosureSubmitModel', 'enquiry.closure.ReopenSubmitModel', 
	         'enquiry.followup.FollowUpDetailModel'],
	stores: ['enquiry.followup.FollowUpDetailStore','enquiry.closure.ClosureStore',
	         'enquiry.followup.ClosureReasonStore', 'enquiry.EnqIntermediateType','enquiry.followup.ClosureReason',
		     'common.AcademyLocationNameSeparated', 'facilitiesresources.resourcemaster.ProgramGridStore',
		     'enquiry.AcademicBatchStore','enquiry.Priority','common.UsersWithDepartmentStore','enquiry.ReasonForFollowup','enquiry.FollowupActivityType','enquiry.FollowupActivityStatus',
		     'enquiry.ProgramBatchSeatTypeStore', 'enquiry.FollowUpUserWithDepartment','common.ProgramsByProgramCategoryWithALStore'],
	views: ['enquiry.followup.FollowUpStructure', 'enquiry.followup.FollowUpDetailGrid',
	        'enquiry.followup.ClosureFollowUpGrid', 'enquiry.followup.FollowUpDetailForm', 
		    'enquiry.followup.ClosureFollowUpDetailForm', 'enquiry.dashboard.CountOfEnquiriesFilter',
		    'enquiry.dashboard.EnquiryClosureRateFilterForm', 'enquiry.dashboard.GroupBarChartForCountofEnquiry'],
	
	config: {
		/*
		 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
		 */
		/**
		 * @cfg {Array} FOLLOWUP_DETAIL_PERMISSIONS array (required)
		 * The array of permissions to use for Access control wise enabling and disabling buttons.
		 * @accessor
		 */
		FOLLOWUP_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FOLLOWUP_DETAIL_PRIVILEGES')
	},
	alias: "widget.followupcontroller",
	refs: [{
		ref: 'followupdetailForm',
		selector: 'followupdetailform form'
	}, {
		ref: 'followupdetailform',
		selector: 'followupdetailform'
	}, {
		ref: 'closurefollowupdetailForm',
		selector: 'closurefollowupdetailform form'
	}, {
		ref: 'closurefollowupdetailform',
		selector: 'closurefollowupdetailform'
	}, {
		ref: 'followupdetailgrid',
		selector: 'followupdetailgrid'
	}, {
		ref: 'closurefollowupgrid',
		selector: 'closurefollowupgrid'
	}, {
		ref: 'followupdetailstructure',
		selector: 'followupdetailstructure'
	}, {
		ref: 'enquirytabstructure',
		selector: 'enquirytabstructure'
	}, {
		ref: 'countcfenquiriesfilter',
		selector: 'countcfenquiriesfilter'
	}, {
		ref: 'countOfEnquiriesGrid',
		selector: 'searchresultgrid[itemId=countofenquiriesgridItemId]'
	}, {
		ref: 'enquiryDashboardManagementStructure',
		selector: 'enquirydashboardmanagementstructure'
	}, {
		ref: 'organizationunit',
		selector: 'organizationunit[itemId=orgEnqDashboardItemId]'
	},{
    	ref:'enquiryclosureratefilter',
    	selector:'enquiryclosureratefilterform[itemId=enquiryclosurerateItemId]'
    },{
    	ref:'enquiryclosureratefilterform',
    	selector:'enquiryclosureratefilterform'
    },{
    	ref : 'countofEnquiriesStructure',
    	selector : 'countofenquiriesstructure'
    },{
    	ref : 'groupbarchartforcountofenquiry',
    	selector : 'groupbarchartforcountofenquiry'
    }],
	init: function() {
		this.control({
			/**
			 * these 2 validation is only on this form and it is used at 2 places closure reason and closure rate graph.
			 */
		/*	'enquiryclosureratefilterform datefield[itemId=startDateItemId]':{
				change:function(obj,value){
					obj.nextSibling().setMinValue(value);
				}
			},
			'enquiryclosureratefilterform datefield[itemId=endDateItemId]':{
				change:function(obj,value){
					obj.previousSibling().setMaxValue(value);
				}
			},*/
			
			'enquiryclosureratefilterform':{ 
				afterrender:function(obj,value){
					var form = obj.up('form');
					var date = new Date();
					var fromdate = new Date(date.setMonth(date.getMonth() - 3));
					form.down('#startDateItemId').setValue(dateRender(fromdate));
					form.down('#endDateItemId').setValue(new Date());
				}
			},
			
			/*'enquiryclosureratefilterform datefield[itemId=startDateItemId]':{
				blur:function(field){
					var fromDate = field.getValue();
					var filter = this.getEnquiryclosureratefilterform();
					var tillDateField = filter.down('#endDateItemId');
					var minTillDate = new Date(fromDate);
					var tillDate = tillDateField.getValue();
					if(tillDate <= field.getValue()){
						tillDateField.setValue(minTillDate);
					}
				}
			},
			'enquiryclosureratefilterform datefield[itemId=endDateItemId]':{
				 blur: function(field){
     				 var tillDate = field.getValue();
     				 var filter = this.getEnquiryclosureratefilterform();
     				 var fromDateField = filter.down('#startDateItemId');
     				 var minFromDate = new Date(tillDate);
     				 var fromDate = fromDateField.getValue();
     				 if(tillDate <=fromDate){
     					 fromDateField.setValue(minFromDate);
     				 }
     			 }
			},*/
			
			'countcfenquiriesfilter button[itemId=searchBtn]': {
				click: this.loadCountcfenquiriesfilter
			},
			
			'enquiryclosureratefilterform[itemId=enquiryclosurerateItemId] button[itemId=searchBtn]': {
				click: this.getSearchClosureRate
			},
			'enquiryclosureratefilterform[itemId=enquiryclosurerateItemId] button[itemId=resetBtn]': {
				click: function(obj) {
					obj.up('form').getForm().reset();
					var form = obj.up('form');
  					var date = new Date();
  					var fromdate = new Date(date.setMonth(date.getMonth() - 3));
  					form.down('#startDateItemId').setValue(dateRender(fromdate));
  					form.down('#endDateItemId').setValue(new Date());
				}
			},
			'searchresultgrid[itemId=countofenquiriesgridItemId]': {
				render: function(grid) {
					this.gridRenderFunction(grid);
				}
			},
			'followupdetailform': {
				render: function(obj) {
					var $this=this;
					var form = this.getFollowupdetailForm().getForm();
					var store = form.findField('userByAssignTo').getStore();
					var locations = [];

					var voipForm=this.getFollowupdetailForm();
					var voipCallSettingStore = Ext.create('Academia.store.user.VoipCallSettingStore');
					//var voipTabs = voipForm.up('tabpanel').items.items;
					var voipTabs = voipForm.up('tabpanel');
					voipCallSettingStore.load({
						callback: function(records, operation, success){
							if(!isNullOrEmpty(records[0].data.value)){
								voipForm.down('#emailAdress').setVisible(false);
								voipForm.down("#enquiryDetail_cellNumber").setVisible(false);
								voipForm.down("#callFollowupButton").setVisible(true);
								voipForm.down("#hiddenFollowUpUrl").setValue(records[0].data.value);
								var tabForm=voipTabs.getComponent('studentdetailsId').down('studentdetailform');
								tabForm.down("#mobileNoFldItemId").setVisible(false);
								tabForm.down("#stdEmailId").setVisible(false);
								tabForm.down("#alternateMobileNoFldItemId").setVisible(false);
								var sgappointmentTab=voipTabs.getComponent('sgappointmentdetailId');
								voipTabs.remove(sgappointmentTab);
								var communicationhistoryTab=voipTabs.getComponent('communicationhistoryId');
								voipTabs.remove(communicationhistoryTab);
							}
						}
					});
					
					
					var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
					for(var i=0; i<academyLocationList.length; i++){
						locations.push(academyLocationList[i].id);
					}
					store.getProxy().extraParams = {
						academyLocationIds:locations.join()
					};
					store.load();
					
					
					
					var store = $this.getStore('enquiry.followup.ClosureReason');
					store.on('load', function(){
						for(var i=0; i< store.data.items.length;i++){
							if(store.data.items[i].data.value == 'Closed Successfully'){
								store.removeAt(i);
							} 
						}
					});
				}
			},
			'followupdetailgrid': {
				render: function(grid) {
					this.renderFollowUpDetailGrid(grid);
					this.doAccessControlValidation(grid, this.getFOLLOWUP_DETAIL_PERMISSIONS());
					var commonForm = this.getEnquirytabstructure().getForm();
        	        var commonVal = commonForm.getValues();
        			var buttonId = commonVal.buttonType;
                    if(buttonId == 'View'){
                		grid.down('#btnEdit').setVisible(false);
                   }
				},
				afterrender:function(grid){
					var me = this;
					me.addDataGridConfigButton(grid,me.getFOLLOWUP_DETAIL_PERMISSIONS());
      	      	}
			},
			'closurefollowupgrid': {
				render: function(grid) {
					this.doAccessControlValidation(grid, this.getFOLLOWUP_DETAIL_PERMISSIONS());
					var commonForm = this.getEnquirytabstructure().getForm();
        	        var commonVal = commonForm.getValues();
        			var buttonId = commonVal.buttonType;
                    if(buttonId == 'View'){
                		grid.down('#btnEdit').setVisible(false);
                   }
				}
			},
			'followupdetailgrid button[itemId=btnAdd]': {
				click: this.showFormWindow
			},
			'followupdetailgrid button[itemId=btnEdit]': {
				click: this.editFormWindow
			},
			'followupdetailgrid button[itemId=btnDelete]': {
				click: this.deleteFormWindow
			},
			'followupdetailgrid button[itemId=btnView]': {
				click: this.viewFormWindow
			},
			'followupdetailform button[itemId=followdetail_submitbuttonId]': {
				click: this.saveFollowUpDetail
			
			},
			'followupdetailform button[itemId=callFollowupButton]': {
				click:function(){
					var me=this;
					var followupForm = me.getFollowupdetailForm().getForm();
					var enquiryTabForm= me.getEnquirytabstructure().getForm().getValues();
					
					
					var mobileNumber=enquiryTabForm.hiddenEnquiryMobileNo;
					
					if(mobileNumber!=null){
						var phoneNo=mobileNumber;
						var url=followupForm.findField('hiddenFollowUpUrl').value;
						var enquirerName=enquiryTabForm.firstName+" "+enquiryTabForm.lastName;
						var enquiryId=enquiryTabForm.enquiryTxtId;
						var userCode=Academia.model.authentication.UserInfoModel.data.code;
						var remark=followupForm.findField('remark').value;
						var callMessageButton= me.getFollowupdetailForm().down("#callButtonMessage");
						
						if(isNullOrEmpty(remark)){
							remark="followup";
						}
						
						if(isNullOrEmpty(enquiryId)){
							enquiryId=enquiryTabForm.enquiryId;
						}
						
						if(remark.length>50){
							remark=remark.substring(0,50);
						}
						url=url+"&name="+encodeURIComponent(enquirerName)+"&phoneno="+phoneNo+"&ClientID="+encodeURIComponent(enquiryId)+"&remark="+encodeURIComponent(remark)+"&AgentID="+userCode;
						 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	            		$.ajax({
	            			url : url,
	            			type : "get",
	            			success : function(data) {
	            				var message;
	            				Ext.getBody().unmask();
	            				if(data.indexOf('Success: Call re-scheduled')!=-1){
	            					callMessageButton.el.setHTML('<span style="font-weight: bold; color: #087d08;">'+getCommonTranslation('CALL_RESCHEDULED_SUCCESSFULLY_MSG')+'</span>');
	            					callMessageButton.setVisible(true);
	            					//alert("Call re-scheduled Successfully");
	            				}
	            				if(data.indexOf('Success: Call Saved')!=-1){
	            					callMessageButton.el.setHTML('<span style="font-weight: bold; color: #087d08;">'+getCommonTranslation('CALL_SAVED_MSG')+'</span>');
	            					callMessageButton.setVisible(true);
	            					//alert("Call re-scheduled Successfully");
	            				}
	            				if(data.indexOf('Failed:Rejected-Already Assigned')!=-1){
	            					var data1=data.split('-');
	            					var dataSplit=data1[2];
	            					var userCode=dataSplit.split(":");
	            					callMessageButton.el.setHTML('<span style="font-weight: bold; color: #de1f27;">'+getCommonTranslation('CALL_REJECTED_MSG')+" "+userCode[0]+'</span>');
	            					callMessageButton.setVisible(true);
	            					//alert("Call re-scheduled Successfully");
	            				}
	            					
	            			},
	            			error : function(eror) {
	            				Ext.getBody().unmask();
	            				if(eror.statusText == "error"){
	            					//alert('server not reachable');
	            					callMessageButton.el.setHTML('<span style="font-weight: bold; color: #de1f27;">'+getCommonTranslation('SERVER_ERROR_MSG_IVR')+'</span>');
	            					callMessageButton.setVisible(true);
	            				}
	            			}
	            		});

					}
					
					
            	}
			
			},
			
			'closurefollowupgrid button[itemId=btnEdit]': {
				click: function() {
					this.editClosureFollowupFormWindow();
				}
			},
			'closurefollowupdetailform button[itemId=closureFollowUp_SubmitbuttonId]': {
				click: this.saveClosureFormWindow
			},
			'closurefollowupdetailform button[itemId=closureFollowUp_CancelbuttonId]': {
				click: this.cancelClosureFormWindow
			},
			'followupdetailstructure': {
				render: function(f) {
					this.onFollowFormRender(f);
				}
			},
			/*'followupdetailform datefield[itemId=followUpdate]': {
				change: function(t, n, o) {
					var actualFollowUpDateSet = this.getFollowupdetailForm().getForm().findField('actualFollowUpDate');
					actualFollowUpDateSet.setMinValue(n);
				}
			},
			'followupdetailform combo#userByAssignTo': {
				select: function(obj, record) {
					var department = Ext.ComponentQuery.query('textfield#departmentName')[0];
					department.setValue(record[0].data.code);
				}
			},*/
			
			
			'followupdetailform checkboxfield[itemId=whetherNextFollowUpId]': {
            	change:function(checkbox, newValue, oldValue, eOpts){ 
            		var $this = this;
            		var form = $this.getFollowupdetailform();
//            		var enquiryStatus = form.down('#trackEnquiry_enquiryStatus');
            		var nextFollowUpDate = form.down('#nextFollowUpDateId');
            		var userByAssignTo = form.down('#userByAssignToId');
            		var closerReason = form.down('#closerReasonId');
//            		enquiryStatus.reset();
            		nextFollowUpDate.reset();
            		closerReason.setVisible(false);
            		userByAssignTo.reset();
            		closerReason.reset();
            		if(newValue==true){
            			nextFollowUpDate.setVisible(true);
            			userByAssignTo.setVisible(true);
            			$this.setAllowBlank (nextFollowUpDate,false);
            			$this.setAllowBlank (userByAssignTo,false);	
            		    var userByAssignToStore = userByAssignTo.getStore();
            	        var loggedUserId = this.getCurrentlyLoggedInUser().id;
            	        Ext.defer(function() {
            	        	userByAssignToStore.load({
            	        		scope:this,
            	        		callback: function(records, operation, success) {
            	            		if(success){
            	            			userByAssignTo.setValue(loggedUserId);
            	        			}
            	         		}
            	        	});
            	        });
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}else if(newValue==false){
                		nextFollowUpDate.setVisible(false);
            			userByAssignTo.setVisible(false);
            			$this.setAllowBlank (nextFollowUpDate,true);
            			$this.setAllowBlank (userByAssignTo,true);
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}
            		form.getForm().isValid();
				}
			},
			
			'followupdetailform combo[itemId=trackEnquiry_enquiryStatus]': {
            	select:function(obj, record){ 
            		var $this = this;
            		var form = $this.getFollowupdetailform();
            		var enquiryStatus = form.down('#trackEnquiry_enquiryStatus');
            		var nextFollowUpDate = form.down('#nextFollowUpDateId');
            		var userByAssignTo = form.down('#userByAssignToId');
            		var closerReason = form.down('#closerReasonId');
            		closerReason.reset();
            		if(record[0].data.value=="Closed") {
            			closerReason.setVisible(true);
            		} else {
            			closerReason.setVisible(false);
            		}
				}
			},
			'followupdetailform customcombobox[itemId=reasonforfollowup]': {		
            	change:function(obj, record){ 
            		var $this = this;
            		var form = $this.getFollowupdetailform();
            		var additionalReasonField = form.down('#additionalReason');
    
            		if(obj.getRawValue()=="Other") {
            			additionalReasonField.setDisabled(false);
            			$this.setAllowBlank (additionalReasonField,false);
            		} else {
            			additionalReasonField.setDisabled(true);
            			$this.setAllowBlank (additionalReasonField,true);
            		}
            		additionalReasonField.validate();
				}
			},			
			'followupdetailform datefield#nextFollowUpDate': {
				select: function(obj, record) {
					var userByAssignTo = Ext.ComponentQuery.query('combo#userByAssignTo')[0];
					userByAssignTo.allowBlank = false;
				}
			},
			'countcfenquiriesfilter combo#batchItemId': {
				select: function(obj, record) {
					var batchId = record[0].get("id");
					var form = obj.up('form').getForm();
					var seatTypeField = form.findField('seatType');
					seatTypeField.enable();
					seatTypeField.reset();
					var store = this.getStore('enquiry.ProgramBatchSeatTypeStore');
					store.getProxy().extraParams = {
						id: batchId
					};
					store.load();
				}
			},
			'countcfenquiriesfilter combo[itemId=programItemId]': {
				select: function(obj, rec) {
					var programId = rec[0].data.id;
					var form = obj.up('form').getForm();
					var batchField = form.findField('batch');
					batchField.enable();
					batchField.reset();
					var intakeYearId=form.findField('intakeYear').getValue();
					batchField.getStore().getProxy().extraParams = {
						id: programId,
						intakeYearId:intakeYearId
					};
					batchField.getStore().load();
					var seatTypeField = form.findField('seatType');
					seatTypeField.disable();
					seatTypeField.reset();
				}
			},
			/*'countcfenquiriesfilter combo[itemId=seatTypeItemId]': {
				select: function(obj, rec) {
					var data = rec[0].data.id;
					var form = obj.up('form').getForm();
					var assignToField = form.findField('assignTo');
					assignToField.enable();
					assignToField.reset();
				    assignToField.getStore().getProxy().extraParams = {
	    			  		 id: data
	    			  	   };
     		  		   assignToField.getStore().load();
				}
			},*/
			'countcfenquiriesfilter button[itemId=resetBtn]': {
				click: function(obj, rec) {
					this.getCountcfenquiriesfilter().getForm().reset();
					var form = obj.up('form').getForm();
					var seatTypeField = form.findField('seatType');
					var batchField = form.findField('batch');
					var assignToField = form.findField('assignTo');
					seatTypeField.setDisabled(true);
					batchField.setDisabled(true);
					var date = new Date();
					var fromdate = new Date(date.setMonth(date.getMonth() - 3));
					form.findField('countOfEnquiryStartDate').setValue(dateRender(fromdate));
					form.findField('countOfEnquiryToDate').setValue(new Date());
					this.getGroupbarchartforcountofenquiry().getStore().loadData(0);
					var programStore=form.findField('program').getStore();
					programStore.getProxy().extraParams.programCategoryId=null;
					programStore.load();
				}
			},
			
			'countcfenquiriesfilter':{ 
				afterrender:function(obj){
					var form = obj.up('form');
					var date = new Date();
					var fromdate = new Date(date.setMonth(date.getMonth() - 3));
					form.down('#startDateItemId').setValue(dateRender(fromdate));
					form.down('#toDateItemId').setValue(new Date());
					
					var academyLocationIds=this.getAcademyLocationFromOrgForm();
					var programFieldStore=form.down('#programItemId').getStore();
					programFieldStore.getProxy().extraParams={
						academyLocationIds:academyLocationIds.join()
					};
					var programCategoryField=form.down('#programCategoryItemId');
					var pcStore=programCategoryField.getStore();
					pcStore.getProxy().extraParams={
						academyLocationIds:academyLocationIds.join()
					};
				}
			},
			
			'countcfenquiriesfilter datefield[itemId=startDateItemId]':{ 
  			  blur:function(field){
  				  var fromDate = field.getValue();
				  var filter = this.getCountcfenquiriesfilter();
				  var tillDateField = filter.down('#toDateItemId');
				  var minTillDate = new Date(fromDate);
				  var tillDate = tillDateField.getValue();
				  if(tillDate <= field.getValue()){
					  tillDateField.setValue(dateRender(minTillDate));
				  }
				}
			},
			
			'countcfenquiriesfilter datefield[itemId=toDateItemId]':{ 
				blur:function(field){
	  				  var fromDate = field.getValue();
					  var filter = this.getCountcfenquiriesfilter();
					  var tillDateField = filter.down('#startDateItemId');
					  var minTillDate = new Date(fromDate);
					  var tillDate = tillDateField.getValue();
					  if(tillDate <= field.getValue()){
						  tillDateField.setValue(dateRender(minTillDate));
					  }
					}
				},
				'countcfenquiriesfilter customcombobox[itemId=programCategoryItemId]':{ 
					select:function(obj, rec){
						var data = rec[0].data.id;
						var form = obj.up('form').getForm();
						var programField = form.findField('program');
						programField.reset();
						var academyLocationIds=this.getAcademyLocationFromOrgForm();
						programField.getStore().getProxy().extraParams = {
							programCategoryId: data,
							academyLocationIds:academyLocationIds.join()
						};
						programField.getStore().load();
						var batchField = form.findField('batch');
						batchField.disable();
						batchField.reset();
						var seatTypeField = form.findField('seatType');
						seatTypeField.disable();
						seatTypeField.reset();
					}
				},
				'countcfenquiriesfilter combo[itemId=intakeYear]': {
					select: function(obj, rec) {
						var intakeYearId = rec[0].data.id;
						var form = obj.up('form').getForm();
						var programId = form.findField('program').getValue();
						var batchField = form.findField('batch');
						batchField.getStore().getProxy().extraParams = {
	   	    					intakeYearId:intakeYearId,
	   	    					id:programId
	   	    				   };
						batchField.reset();
	           		    batchField.getStore().load();
	           		    var seatTypeField = form.findField('seatType');
	           		    seatTypeField.disable();
	           		    seatTypeField.reset();
					}
				},
			'organizationunit[itemId=orgEnqDashboardItemId] combo[itemId=academyLocationId]':{
				change:function(obj,rec){
					var organizationForm=this.getOrganizationunit().getForm();
					var academyLocation=organizationForm.findField('academyLocation');
					var acdemyLocationArray=[];
					var countcfenquiriesfilter=this.getCountcfenquiriesfilter().getForm();
					var programField=countcfenquiriesfilter.findField('program');
					if(!academyLocation.isHidden()){
						Ext.Array.each(academyLocation.getValue(),function(value){
							if(Ext.isObject(value)){
								acdemyLocationArray.push(value.data.id);
							}else{
								acdemyLocationArray.push(value);	
							}	
						});
					}
					programField.getStore().getProxy().extraParams={
						academyLocationIds:acdemyLocationArray.join()
					};
					programField.getStore().load();
				}
			},
			'organizationunit[itemId=orgEnqDashboardItemId] combo[itemId=multiselectAcademyLocationId]':{
				change:function(obj,rec){
					var organizationForm=this.getOrganizationunit().getForm();
					var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
					var acdemyLocationArray=[];
				//	var countcfenquiriesfilter=this.getCountcfenquiriesfilter().getForm();
				//	var programField=countcfenquiriesfilter.findField('program');
					if(!multiselectAcademyLocation.isHidden()){
						Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
							if(Ext.isObject(value)){
								acdemyLocationArray.push(value.data.id);
							}else{
								acdemyLocationArray.push(value);	
							}
						});
					}
					/*programField.getStore().getProxy().extraParams={
						academyLocationIds:acdemyLocationArray.join()
					};
					programField.getStore().load();*/
				}
			},
			
			/**
			 * When enquiry is reopen then load followup grid. Load on click on tab
			 */
			'followupstructure': {
				activate: function(view){
					var $this = this;
					var grid = Ext.getCmp('followUpDetailGridId');
					var followupdetailgridStore = grid.getStore();
					var closurefollowupgridStore = view.down('closurefollowupgrid').getStore();
					var commonForm = $this.getEnquirytabstructure().getForm();
					var commonVal = commonForm.getValues();
					var buttonId = commonVal.buttonType;
					 
					followupdetailgridStore.load({

            			callback: function(record, operation, success) {
            				if (success) {
            					if(Ext.isDefined(grid)){
            						var recIndex = followupdetailgridStore.find('isLatestFollowUp', true);
            						if(recIndex == -1){
            							grid.getSelectionModel().select(followupdetailgridStore.getAt(followupdetailgridStore.getCount()-1));
            						}else{
            							grid.getSelectionModel().select(followupdetailgridStore.getAt(recIndex));	
            						}
            						

            						var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
            						var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
            						var form = Ext.getCmp('followUpDetailFormId');
            						var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
            						var getTabScroll = tabStructure1.up();
            						var getformPosition = form.getPosition()[1];
            						getTabScroll.body.scrollTo('top',getformPosition)
            						if(buttonId == 'View'){
            		                  		form.down('#followdetail_submitbuttonId').setVisible(false);
            		                  		this$.toggleReadOnlyFormItems(form.getForm(), true);
            		                }
            						var records = grid.getSelectionModel().getSelection();
            						if (records != undefined && records != "" && records != null) {
            							form.loadRecord(records[0]);
            							//form.getForm().findField('followUpDate').setValue(new Date(records[0].get('followUpDate')));
            							var emailIdValue = tabStructure1.down('#hiddenEnquiryStudentEmail').getValue();
            							var mobileNoValue = tabStructure1.down('#hiddenEnquiryMobileNo').getValue();
            							var mobileCodeValue = tabStructure1.down('#hiddenEnquiryMobileCode').getValue();
            							var displayStudentName = tabStructure1.down('#displayStudentName').getValue();
            							form.getForm().findField('actualFollowUpDate').setValue(new Date());
            							form.getForm().findField('emailAdress').setValue(emailIdValue);
            							var followupStatusUpdateTime = form.down('#followupStatusUpdateTime');
            							setTimeout(function(){
            							followupStatusUpdateTime.setReadOnly(true);
                                        var test=records[0].data.followupStatusUpdateTime;
                                        var testtime=Ext.Date.parse(test,'d-m-Y H:i:s').getTime();
                                        var newDate = dateRender(testtime)+" "+timeRender(testtime);
                                        followupStatusUpdateTime.setValue(newDate);
            							},1000);
            							if(!isNullOrEmpty(displayStudentName)){
            								form.getForm().findField('followupActivityTo').setValue(displayStudentName);
            							}else if(!isNullOrEmpty(records[0].data.enquiry)){
            								form.getForm().findField('followupActivityTo').setValue(records[0].data.enquiry.value);
            							}
            							
            							form.getForm().findField('phoneCountryCode').setValue(mobileCodeValue);
            							form.getForm().findField('cellNo').setValue(mobileNoValue);
            							form.getForm().findField('nextFollowUpDate').setValue(new Date());
            							setTimeout(function(){
            								form.getForm().findField('followupuser').setValue(records[0].data.users.value);
            								form.getForm().findField('followupTime').setValue(Ext.Date.format(new Date(), 'H:i'));
            							},300);
            							if(form.getForm().findField('whetherNextFollowUp').getValue()==false) {
            								form.getForm().findField('nextFollowUpDate').setVisible(false);
            								form.getForm().findField('userByAssignTo').setVisible(false);
            							}
            							var stageStore = $this.getStore('enquiry.EnqIntermediateType');
            							stageStore.load({
            								callback: function(record, operation, success) {
            									if (success) {
            										var enqIntermediateStage=form.down('#enqIntermediateStage');
            										if (!isNullOrEmpty(enqIntermediateStage)) {
            											if (stageId != null) {
            												enqIntermediateStage.setValue(parseInt(stageId));
            											} else {
            												enqIntermediateStage.setValue(1);
            											}
            											//enqIntermediateStage.setValue(stageId);
            										}
            									}
            								}
            							});
            							var priority = form.getForm().findField('priority');
            							if(!isNullOrEmpty(priority)) {
            								priority.store
            								.load({
            									callback : function(r, operation,
            											success) {
            										if (success) {
            											if (priorityId != null) {
            												priority
            												.setValue(parseInt(priorityId));
            											} else {
            												priority.setValue(1);
            											}

            										}
            									}
            								});
            							}
            							var followUpActivityType = form.getForm().findField('followUpActivityType');
        		            			if(!isNullOrEmpty(followUpActivityType)) {
        		            				followUpActivityType.getStore().load({
        		            					callback : function(r, operation,success) {
        		            						if (success) {
        		            							if(!isNullOrEmpty(records[0].data.followUpActivityType))
        		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
        		            						}
        		            					}
        		            				});
        		            			}
        		            			
        		            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
        		            			if(!isNullOrEmpty(reasonForFollowUp)) {
        		            				reasonForFollowUp.getStore().load({
        		            					callback : function(r, operation,success) {
        		            						if (success) {
        		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)){
        		            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
        		            							}
        		            						}
        		            					}
        		            				});
        		            			}
        		            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
        		            			if(!isNullOrEmpty(followUpActivityStatus)) {
        		            				followUpActivityStatus.getStore().load({
        		            					callback : function(r, operation,success) {
        		            						if (success) {
        		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus))
        		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
        		            						}
        		            					}
        		            				});
        		            			}
            						}

            					}
            				}
            				/*form.down('#whetherNextFollowUpId').setValue(true);
            				setTimeout(function(){
            					form.down('#whetherNextFollowUpId').setValue(false);
    						 },10);*/
            				
        				}
            		
					});
					closurefollowupgridStore.load();
					var recIndex = followupdetailgridStore.find('isLatestFollowUp', true);
					if(recIndex == -1){
						grid.getSelectionModel().select(followupdetailgridStore.getAt(followupdetailgridStore.getCount()-1));
					}else{
						grid.getSelectionModel().select(followupdetailgridStore.getAt(recIndex));	
					}
					var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
					var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
					var rec = grid.getSelectionModel().getSelection();
					var form = this.getFollowupdetailForm();
					var records = view.down('followupdetailgrid').getSelectionModel().getSelection();
					if (records != undefined && records != "" && records != null) {
						form.loadRecord(records[0]);
						//form.getForm().findField('followUpDate').setValue(new Date(records[0].get('followUpDate')));
						form.getForm().findField('actualFollowUpDate').setValue(new Date());
						var stageStore = $this.getStore('enquiry.EnqIntermediateType');
						stageStore.load({
							callback: function(record, operation, success) {
								if (success) {
									var enqIntermediateStage=form.down('#enqIntermediateStage');
									if (!isNullOrEmpty(enqIntermediateStage)) {
										if (stageId != null) {
											enqIntermediateStage.setValue(parseInt(stageId));
										} else {
											enqIntermediateStage.setValue(1);
										}
										//enqIntermediateStage.setValue(stageId);
									}
								}
							}
						});
						var priority = form.getForm().findField('priority');
						if(!isNullOrEmpty(priority)) {
							priority.store
							.load({
								callback : function(r, operation,
										success) {
									if (success) {
										if (priorityId != null) {
											priority
											.setValue(parseInt(priorityId));
										} else {
											priority.setValue(1);
										}

									}
								}
							});
						}
						var followUpActivityType = form.getForm().findField('followUpActivityType');
            			if(!isNullOrEmpty(followUpActivityType)) {
            				followUpActivityType.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
            							}
            						}
            					}
            				});
            			}
            			
            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
            			if(!isNullOrEmpty(reasonForFollowUp)) {
            				reasonForFollowUp.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
            								reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
            							}
            						}
            					}
            				});
            			}
            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
            			if(!isNullOrEmpty(followUpActivityStatus)) {
            				followUpActivityStatus.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
            								followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
            							}
            						}
            					}
            				});
            			}
					}
					var enquiryStatus=Ext.getCmp('dispalyEnquiryStatus').getValue();
					if(!isNullOrEmpty(enquiryStatus) && enquiryStatus!='Open'){
						var form = Ext.getCmp('followUpDetailFormId');
						form.down('#followdetail_submitbuttonId').setVisible(false);
      	 					form.down('#actualFollowUpDate').setReadOnly(true);
      	 					form.down('#followupTime').setReadOnly(true);
      	 					form.down('#enqIntermediateStage').setReadOnly(true);
      	 					form.down('#trackEnquiry_priority').setReadOnly(true);
      	 					form.down('#remarkItemId').setReadOnly(true);
      	 					form.down('#nextFollowUpDateId').setReadOnly(true);
      	 					this.setAllowBlank (form.down('#nextFollowUpDateId'),true);
      	 					form.down('#userByAssignToId').setReadOnly(true);
      	 					this.setAllowBlank (form.down('#userByAssignToId'),true);
      	 					form.down('#whetherNextFollowUpId').setValue(false);
      	 					form.down('#whetherNextFollowUpId').setDisabled(true);
					}else{
						form.down('#followdetail_submitbuttonId').setVisible(true);
  	 					form.down('#actualFollowUpDate').setReadOnly(false);
  	 					form.down('#followupTime').setReadOnly(false);
  	 					form.down('#enqIntermediateStage').setReadOnly(false);
  	 					form.down('#trackEnquiry_priority').setReadOnly(false);
  	 					form.down('#remarkItemId').setReadOnly(false);
  	 					form.down('#nextFollowUpDateId').setReadOnly(false);
  	 					form.down('#userByAssignToId').setReadOnly(false);
  	 					form.down('#whetherNextFollowUpId').setValue(false);
  	 					form.down('#whetherNextFollowUpId').setDisabled(false);
					}
					var whetherNextFollowUp = form.getForm().findField('whetherNextFollowUp').getValue();
					if(whetherNextFollowUp==false){
						form.down('#nextFollowUpDateId').allowBlank=true;
						form.down('#userByAssignToId').allowBlank=true;
						form.down('#followdetail_submitbuttonId').setDisabled(false);
					}
					/*setTimeout(function(){
						if(!form.getForm().isValid()){
							form.down('#followdetail_submitbuttonId').setDisabled(true);
	            		}else{
	            			form.down('#followdetail_submitbuttonId').setDisabled(false);
	            		}
					},500);*/
				},
				render:function(structure){
    				var $this = this
    				structure.body.on('click', function() {
    					var form = structure.down('followupdetailform');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
			},
			'countofenquiriesstructure':{
				render:function(structure){
    				var $this = this
    				structure.body.on('click', function() {
    					var filter = structure.down('countcfenquiriesfilter');
    					$this.hideInvalidIconFromField(filter);
    			       });
    			}
			},
			'followupdetailform customcombobox[itemId=followupactivitystatusId]':{
				    select:function(objval,record){
					var $this =this;
					var form = objval.up('followupdetailform');
					var followupStatusUpdateTime = form.down('#followupStatusUpdateTime');
					var todayDate= new Date();
					var newDate = dateRender(todayDate)+" "+timeRender(todayDate);
					followupStatusUpdateTime.setValue(newDate);
					followupStatusUpdateTime.setReadOnly(true);
					
					/*var date = todayDate.getDate() +'/'+(todayDate.getMonth()+1)+'/'+todayDate.getFullYear()+' '+ todayDate.getHours()+':'+
					(todayDate.getMinutes() <=9 ? '0'+todayDate.getMinutes() : todayDate.getMinutes())+':'
					+(todayDate.getSeconds() <=9 ? '0'+todayDate.getSeconds() : todayDate.getSeconds()) ;              
					followupStatusUpdateTime.setValue(date);
					followupStatusUpdateTime.setReadOnly(true);*/
					                   	
			                }
			            }
		});
	},
	renderFollowUpDetailGrid: function(grid) {
		var $this = this;
		var commonForm = $this.getEnquirytabstructure().getForm();
		var commonVal = commonForm.getValues();
		var enquiryId = commonVal.enqId;
		var studentId = commonVal.studentDetailId;
		
		Ext.apply(commonForm,{
    		code:null,
 		  setCode : function(code){
 			 commonForm.code = code;
 		  },
 		  getCode:function(){
 			  return commonForm.code;
 		  }
		});
		
		var store = $this.getStore('enquiry.followup.FollowUpDetailStore');
		store.getProxy().extraParams = {
			id: enquiryId
		};
		store.load();
		var store = $this.getStore('enquiry.closure.ClosureStore');
		store.getProxy().extraParams = {
			id: studentId
		};
		store.load({
			callback:function(record) {
				if(record.length > 0 && !isNullOrEmpty(record[0].data)) {
					commonForm.setCode(record[0].data.id);
				}
				Ext.defer(function() {
					grid.setHeight(grid.getHeight() + 8);
				}, 1);
			}
		});
		
		
	},
	showFormWindow: function() {
		var formWindow = this.getFollowupdetailform();
		if (!formWindow) {
			Ext.widget('followupdetailform');
			formWindow = this.getFollowupdetailform();
		}
		formWindow.show();
		// TODO remove this code once tested, we are fetching all users without academyLocationID
		/*store = formWindow.down("#userByAssignTo").getStore();
		store.getProxy().extraParams = {
			academyLocationId: this.getCurrentAcademyLocation()
		};
		store.load();*/
	},
	showClosureFollowupFormWindow: function() {
		var formWindow = this.getClosurefollowupdetailform();
		if (!formWindow) {
			Ext.widget('closurefollowupdetailform');
			formWindow = this.getClosurefollowupdetailform();
		}
		formWindow.show();
	},
	editClosureFollowupFormWindow: function() {
		var grid = this.getClosurefollowupgrid();
		var rec = grid.getSelectionModel().getSelection()[0];
		var sts = rec.get('status');
		if (sts == 'Open' || sts == '') {
			if (grid.getSelectionModel().getCount() > 0) {
				this.showClosureFollowupFormWindow();
				var records = grid.getSelectionModel().getSelection();
			}
		} else {
			showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('CLOSURE_FOLLOWUP_STATUS_MSG'));
		}
	},
	editFormWindow: function() {
		var $this = this;
		var grid = Ext.getCmp('followUpDetailGridId');
		var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
		var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
		var rec = grid.getSelectionModel().getSelection();
		var enquiryStatus=Ext.getCmp('dispalyEnquiryStatus').getValue();
		if (grid.getSelectionModel().getCount() > 0) {
			if (rec.length > 0 && !isNullOrEmpty(enquiryStatus) && enquiryStatus=='Open') {
				if (rec[0].get('status') == 'Open' || rec[0].get('isLatestFollowUp')) {
					this.showFormWindow();
					var form = this.getFollowupdetailForm();
					form.getForm().findField('followupTime').setValue(Ext.Date.format(new Date(), 'H:i'));
					
					setTimeout(function(){
						form.getForm().findField('followupuser').setValue(records[0].data.users.value);
					},300);
					
					form.getForm().findField('whetherNextFollowUp').setValue(false);
					var records = grid.getSelectionModel().getSelection();
					if (records != undefined && records != "" && records != null) {
						//form.loadRecord(records[0]);
						//form.getForm().findField('followUpDate').setValue(new Date(rec[0].get('followUpDate')));
						form.getForm().findField('actualFollowUpDate').setValue(new Date());
						// when followup is open in edit mode by default "assignedTo" is coming selected which is not required so commented below code  
						/* var userAssignToCombo=form.getForm().findField('userByAssignTo');
	        			  userAssignToCombo.store.load({
	                          callback: function(r, operation, success) {
	                              if (success) {
	                            	  if(records[0].data.userByAssignTo!=null){
	                            	   userAssignToCombo.setValue(records[0].data.userByAssignTo.id);
	                            	  }
	                              }
	                          }
	                      });*/
						var followupStatusUpdateTime=records[0].data.followupStatusUpdateTime;
                        var newDateTime=    Ext.Date.parse(followupStatusUpdateTime,'d-m-Y H:i:s').getTime();
                         var newDate = dateRender(newDateTime)+" "+timeRender(newDateTime);
                         form.getForm().findField('followupStatusUpdateTime').setValue(newDate);
						var stageStore = $this.getStore('enquiry.EnqIntermediateType');
						stageStore.load({
							callback: function(record, operation, success) {
								if (success) {
									var enqIntermediateStage=form.down('#enqIntermediateStage');
									if (!isNullOrEmpty(enqIntermediateStage)) {
										if (stageId != null) {
											enqIntermediateStage.setValue(parseInt(stageId));
										} else {
											enqIntermediateStage.setValue(1);
										}
										//enqIntermediateStage.setValue(stageId);
									}
								}
							}
						});
						var followUpActivityType = form.getForm().findField('followUpActivityType');
            			if(!isNullOrEmpty(followUpActivityType)) {
            				followUpActivityType.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
            							}	
            						}
            					}
            				});
            			}
            			
            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
            			if(!isNullOrEmpty(reasonForFollowUp)) {
            				reasonForFollowUp.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
            							reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
            							}
            						}
            					}
            				});
            			}
            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
            			if(!isNullOrEmpty(followUpActivityStatus)) {
            				followUpActivityStatus.getStore().load({
            					callback : function(r, operation,success) {
            						if (success) {
            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
            							}
            						}
            					}
            				});
            			}
						var priority = form.getForm().findField('priority');
						if(!isNullOrEmpty(priority)) {
							priority.store
							.load({
								callback : function(r, operation,
										success) {
									if (success) {
										if (priorityId != null) {
											priority
											.setValue(parseInt(priorityId));
										} else {
											priority.setValue(1);
										}

									}
								}
							});
						}
					}
				} else {
					showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('ALERT_FOLLOWUP_ALLOW_ONLY'));
				}
			}else{
				showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('ALERT_ENQUIRY_CLOSED')); 
			}
			}else {
			showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	deleteFormWindow: function() {
		alert('Under Coustruction');
	},
	viewFormWindow: function() {
		this.editFormWindow();
		var form = this.getFollowupdetailform();
		if (form) {
			form.down('#followdetail_submitbuttonId').setVisible(false);
			form = form.getForm();
			toggleReadOnlyFormItems(form, true);
		}
	},
	cancelClosureFormWindow: function() {
		var form = this.getClosurefollowupdetailform();
		if(form !=undefined || form !=null){
		form.close();
		}
	},
	resetFollowUpDetail: function() {
		var form = this.getFollowupdetailform().getForm();
			form.reset();
	},
	checkEmployeeLeave: function() {
		Ext.Ajax.request({
			type: 'rest',
			// rest call to check follow should be assigned or not according to academy location working hours
			url: checkFollowupUserURL + '?id=' + academyLocationId,
			method: 'GET',
			success: function(f, action) {
				var mssg = f.responseText;
			}
		});
	},
	saveFollowUpDetail: function() {
		var me = this;
		var academyLocationId = this.getCurrentAcademyLocation();
		var formWindow = this.getFollowupdetailForm();
		this.showInvalidIconOnField(formWindow);
		var form = formWindow.getForm();
		formWindow.down('#followdetail_submitbuttonId').setDisabled(true);
		var values = form.getValues();
		var grid = Ext.getCmp('followUpDetailGridId');
		
		var recIndex = grid.getStore().find('isLatestFollowUp', true);
		if(recIndex == -1){
		grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
		}else{
		grid.getSelectionModel().select(grid.getStore().getAt(recIndex));
		}
		var records = grid.getSelectionModel().getSelection()[0];
		var gridLastId = records.get('id');
		var assignToUser = form.findField('userByAssignTo');
		
		var whetherNextFollowUp = form.findField('whetherNextFollowUp').getValue();
		
		var enqIntermediateStage = form.findField('enqIntermediateStage');
		var priority = form.findField('priority');
		var commonForm = me.getEnquirytabstructure().getForm();
		var commonVal = commonForm.getValues();
		var enquiryId = commonVal.enqId;
		var followupDate = values.nextFollowUpDate;
		var assignToUserId = assignToUser.getValue();
		var assignToUserName = assignToUser.getRawValue();
		var folloupdateDetail = new Academia.model.enquiry.followup.FollowUpDetailModel();
		var status =form.findField('enquiryStatus').getValue();
		var reasonForFollowUp = form.findField('reasonForFollowUp');
		
		folloupdateDetail.set("followUpDate", values.followUpDate);
		folloupdateDetail.set("actualFollowUpDate", values.actualFollowUpDate);
		folloupdateDetail.set("nextFollowUpDate", followupDate);
		
		folloupdateDetail.set("enquiry", this.getIdValueJson(enquiryId));
		folloupdateDetail.set("userByAssignTo", this.getIdValueJson(assignToUserId, assignToUserName));
		folloupdateDetail.set("users", this.getIdValueJson(assignToUserId, assignToUserName));
		folloupdateDetail.set("followUpNo", 1);

		folloupdateDetail.set("whetherDeleted", false);
		folloupdateDetail.set("remark", values.remark);
		folloupdateDetail.set("lastFollowUpId", gridLastId);
		folloupdateDetail.set("enqIntermediateType", this.getIdValueJson(enqIntermediateStage.getValue(), enqIntermediateStage.getRawValue()));
		folloupdateDetail.set("enquiryPriority", this.getIdValueJson(values.priority));
		folloupdateDetail.set("status", status);
		folloupdateDetail.set("reasonForFollowUp", this.getIdValueJson(values.reasonForFollowUp));		
		folloupdateDetail.set("followUpActivityType", this.getIdValueJson(values.followUpActivityType));
		folloupdateDetail.set("followUpActivityStatus", this.getIdValueJson(values.followUpActivityStatus));
		folloupdateDetail.set("followupTime",values.followupTime);
		
		var date = values.followupStatusUpdateTime;
		var newDate = dateRender(date)+" "+timeRender(date);
		folloupdateDetail.set("followupStatusUpdateTime",newDate);
		
		var reasonForFollowUpValue = reasonForFollowUp.getRawValue();
		if(reasonForFollowUpValue == 'Other'){
			folloupdateDetail.set("additionalReason", values.additionalReason);
		}
		else{
			folloupdateDetail.set("additionalReason", "");
		}

		var clouserReason=new Object();
		clouserReason.enquiry={
				"id": enquiryId
		};
		if(!isNullOrEmpty(commonForm.getCode())) {
			clouserReason.admissionEnqDetailsId=commonForm.getCode();
		}
		clouserReason.closureReason=me.getIdValueJson(values.closerReason);
		clouserReason.enquiryStudentDetailId=commonVal.studentDetailId;
		clouserReason.closureDate=values.closureDate;
		clouserReason.reasonRemark=values.closureRemarks
		clouserReason.whetherDeleted=false;
		folloupdateDetail.set("closureReason", clouserReason);
		
		var fData = Ext.encode(folloupdateDetail.data);
		submitUrl = SERVERURL.CREATE_FOLLOWUP_DETAIL_URL;
		var checkFollowupUserURL = SERVERURL.ENQ_FOLLOWUP_USER;
		var checkLeaveURL = SERVERURL.ENQ_FOLLOWUP_CHECK_LEAVE;
		if (assignToUserId) {
			Ext.Ajax.request({
				type: 'rest',
				// rest call to check follow should be assigned or not according to academy location working hours
				url: checkFollowupUserURL + '?id=' + academyLocationId,
				method: 'GET',
				success: function(f, action) {
					var mssg = f.responseText;
					/*var todayDate= new Date()
					var date = todayDate.getDate() +'/'+(todayDate.getMonth()+1)+'/'+todayDate.getFullYear()+' '+ todayDate.getHours()+':'+(todayDate.getMinutes() <=9 ? '0'+todayDate.getMinutes() : todayDate.getMinutes())*/
					if (mssg == "FOLLOW_UP_ALLOWED") {
						Ext.Ajax.request({
							type: 'rest',
							url: checkLeaveURL + '?userId=' + assignToUserId + '&date=' + followupDate,
							method: 'GET',
							success: function(f, action) {
								var mssg = f.responseText;
								if (mssg == 'false') {
									Ext.Ajax.request({
										type: 'rest',
										url: submitUrl,
										jsonData: fData,
										method: 'POST',
										success: function(f, action) {
											showSuccessMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
											grid.store.load({
						            			callback: function(record, operation, success) {
					            					if (success) {
					            						var recIndex = grid.getStore().find('isLatestFollowUp', true);
					            						if(recIndex == -1){
					            							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
					            						}else{
					            							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
					            						}
					        		            		var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
					        		            		var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
					        		            		var rec = grid.getSelectionModel().getSelection();
					        		            		var form = Ext.getCmp('followUpDetailFormId');
					        		            		
					        		            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
					        		            		var getTabScroll = tabStructure1.up();
					        		            		var getformPosition = form.getPosition()[1];
					        		            		getTabScroll.body.scrollTo('top',getformPosition)
					        		            		
					        		            		var records = grid.getSelectionModel().getSelection();
					        		            		if (records != undefined && records != "" && records != null) {
					        		            			//form.loadRecord(records[0]);
					        		            			//form.getForm().findField('followUpDate').setValue(new Date(records[0].get('followUpDate')));
					        		            			form.getForm().findField('actualFollowUpDate').setValue(new Date());
					        		            			
					        		            			form.getForm().findField('followupuser').setValue(records[0].data.userByAssignTo.value);
					        		            			form.getForm().findField('followupActivityTo').setValue(tabStructure1.down("#displayStudentName").getValue());
					        		            			form.getForm().findField('phoneCountryCode').setValue(tabStructure1.down("#hiddenEnquiryMobileCode").getValue());
					        		            			var followupStatusUpdateTime=records[0].data.followupStatusUpdateTime;
					                                        var newDateTime=    Ext.Date.parse(followupStatusUpdateTime,'d-m-Y H:i:s').getTime();
					                                         var newDate = dateRender(newDateTime)+" "+timeRender(newDateTime);
					                                         form.getForm().findField('followupStatusUpdateTime').setValue(newDate);
					        		            			var stageStore = me.getStore('enquiry.EnqIntermediateType');
					        		            			stageStore.load({
					        		            				callback: function(record, operation, success) {
					        		            					if (success) {
					        		            						var enqIntermediateStage=form.down('#enqIntermediateStage');
					        		            						if (!isNullOrEmpty(enqIntermediateStage)) {
					        												if (stageId != null) {
					        													enqIntermediateStage.setValue(parseInt(stageId));
					        												} else {
					        													enqIntermediateStage.setValue(1);
					        												}
					        											}
					        		            					}
					        		            				}
					        		            			});
					        		            			
					        		            			var priority = form.getForm().findField('priority');
					        		            			if(!isNullOrEmpty(priority)) {
					        		            				priority.store
					        		            				.load({
					        		            					callback : function(r, operation,
					        		            							success) {
					        		            						if (success) {
					        		            							if (priorityId != null) {
					        		            								priority
					        		            								.setValue(parseInt(priorityId));
					        		            							} else {
					        		            								priority.setValue(1);
					        		            							}

					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			
					        		            			var followUpActivityType = form.getForm().findField('followUpActivityType');
					        		            			if(!isNullOrEmpty(followUpActivityType)) {
					        		            				followUpActivityType.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
					        		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
					        		            							}	
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			
					        		            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
					        		            			if(!isNullOrEmpty(reasonForFollowUp)) {
					        		            				reasonForFollowUp.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
					        		            							reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
					        		            							}
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
					        		            			if(!isNullOrEmpty(followUpActivityStatus)) {
					        		            				followUpActivityStatus.getStore().load({
					        		            					callback : function(r, operation,success) {
					        		            						if (success) {
					        		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
					        		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
					        		            							}
					        		            						}
					        		            					}
					        		            				});
					        		            			}
					        		            			
					        		            			var enquiryTabStructure = me.getEnquirytabstructure();
					        		            			
					        		            			var emailIdField = enquiryTabStructure.down("#hiddenEnquiryStudentEmail");
					        		            			form.getForm().findField('emailAdress').setValue(emailIdField.getValue());
					        		            			
					        		            		//	var enqMobileCodeFld = enquiryTabStructure.down("#hiddenEnquiryMobileCode");
					        		            			//form.getForm().findField('phoneCountryCode').setValue(enqMobileCodeFld.getValue);
					        		            		
					        		            			//var enqMobileCodeFld = enquiryTabStructure.down("#hiddenEnquiryMobileCode");
					        		            			
					        		            		//	form.getForm().findField('followupActivityTo').setValue(displayStudentName);
					        		            			
					        		            			var enqMobileNoFld = enquiryTabStructure.down("#hiddenEnquiryMobileNo");
					        		            			form.getForm().findField('cellNo').setValue(enqMobileNoFld.getValue());
					        		            			
					        		            		}
					            					}
					            				}
						            		
											});
											grid.getSelectionModel().deselectAll();
											Ext.getCmp('enqtab_intermediateStage').setValue(enqIntermediateStage.getRawValue());
											Ext.getCmp('enqtab_intermediateStageId').setValue(enqIntermediateStage.getValue());
											//Ext.getCmp('dispalyEnquiryStatus').setValue(getCommonTranslation('CLOSE'));
											Ext.getCmp('dispalyPriority').setValue(priority.getRawValue());
											Ext.getCmp('dispalyPriorityId').setValue(priority.getValue());
											whetherNextFollowUp = form.findField('whetherNextFollowUp');
											whetherNextFollowUp.setValue(false);
											
											var enquirydetailformrevampArr = Ext.ComponentQuery.query('[xtype=enquirydetailformrevamp]');
											if( !isNullOrEmpty(enquirydetailformrevampArr) ){
												var enquirydetailformrevamp = enquirydetailformrevampArr[0];
												if( !isNullOrEmpty(enquirydetailformrevamp) ){
													var enqIntermediateTypeIdField = enquirydetailformrevamp.getForm().findField('enqIntermediateTypeId');
													enqIntermediateTypeIdField.setValue(enqIntermediateStage.getValue());
												}
											}
										}
									});
								} else {
									showConfirmMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('FOLLOWUP_NOT_ASSIGN'), function(btn, text) {
										if (btn == 'yes') {
											Ext.Ajax.request({
												type: 'rest',
												url: submitUrl,
												jsonData: fData,
												method: 'POST',
												success: function(f, action) {
													showSuccessMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
													grid.store.load({
								            			callback: function(record, operation, success) {
							            					if (success) {
							            						var recIndex = grid.getStore().find('isLatestFollowUp', true);
							            						if(recIndex == -1){
							            							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
							            						}else{
							            							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
							            						}
							        		            		var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
							        		            		var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
							        		            		var rec = grid.getSelectionModel().getSelection();
							        		            		var form = Ext.getCmp('followUpDetailFormId');
							        		            		
							        		            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
							        		            		var getTabScroll = tabStructure1.up();
							        		            		var getformPosition = form.getPosition()[1];
							        		            		getTabScroll.body.scrollTo('top',getformPosition)
							        		            		
							        		            		var records = grid.getSelectionModel().getSelection();
							        		            		if (records != undefined && records != "" && records != null) {
							        		            			//form.loadRecord(records[0]);
							        		            			form.getForm().findField('followUpDate').setValue(new Date(records[0].get('followUpDate')));
							        		            			form.getForm().findField('actualFollowUpDate').setValue(new Date());
							        		            			var followupStatusUpdateTime=records[0].data.followupStatusUpdateTime;
							                                        var newDateTime=    Ext.Date.parse(followupStatusUpdateTime,'d-m-Y H:i:s').getTime();
							                                         var newDate = dateRender(newDateTime)+" "+timeRender(newDateTime);
							                                         form.getForm().findField('followupStatusUpdateTime').setValue(newDate);
							        		            			var stageStore = me.getStore('enquiry.EnqIntermediateType');
							        		            			stageStore.load({
							        		            				callback: function(record, operation, success) {
							        		            					if (success) {
							        		            						var enqIntermediateStage=form.down('#enqIntermediateStage');
							        		            						if (!isNullOrEmpty(enqIntermediateStage)) {
							        												if (stageId != null) {
							        													enqIntermediateStage.setValue(parseInt(stageId));
							        												} else {
							        													enqIntermediateStage.setValue(1);
							        												}
							        											}
							        		            					}
							        		            				}
							        		            			});
							        		            			var priority = form.getForm().findField('priority');
							        		            			if(!isNullOrEmpty(priority)) {
							        		            				priority.store
							        		            				.load({
							        		            					callback : function(r, operation,
							        		            							success) {
							        		            						if (success) {
							        		            							if (priorityId != null) {
							        		            								priority
							        		            								.setValue(parseInt(priorityId));
							        		            							} else {
							        		            								priority.setValue(1);
							        		            							}

							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            			var followUpActivityType = form.getForm().findField('followUpActivityType');
							        		            			if(!isNullOrEmpty(followUpActivityType)) {
							        		            				followUpActivityType.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
							        		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            			
							        		            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
							        		            			if(!isNullOrEmpty(reasonForFollowUp)) {
							        		            				reasonForFollowUp.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
							        		            							reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
							        		            			if(!isNullOrEmpty(followUpActivityStatus)) {
							        		            				followUpActivityStatus.getStore().load({
							        		            					callback : function(r, operation,success) {
							        		            						if (success) {
							        		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
							        		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
							        		            							}
							        		            						}
							        		            					}
							        		            				});
							        		            			}
							        		            		}
							            					}
							            				}
								            		
													});
													
													grid.getSelectionModel().deselectAll();
													Ext.getCmp('enqtab_intermediateStage').setValue(enqIntermediateStage.getRawValue());
													Ext.getCmp('enqtab_intermediateStageId').setValue(enqIntermediateStage.getValue());
													//Ext.getCmp('dispalyEnquiryStatus').setValue(getCommonTranslation('CLOSE'));
													Ext.getCmp('dispalyPriority').setValue(priority.getRawValue());
													Ext.getCmp('dispalyPriorityId').setValue(priority.getValue());
													whetherNextFollowUp = form.findField('whetherNextFollowUp');
													whetherNextFollowUp.setValue(false);
													
													var enquirydetailformrevampArr = Ext.ComponentQuery.query('[xtype=enquirydetailformrevamp]');
													if( !isNullOrEmpty(enquirydetailformrevampArr) ){
														var enquirydetailformrevamp = enquirydetailformrevampArr[0];
														if( !isNullOrEmpty(enquirydetailformrevamp) ){
															var enqIntermediateTypeIdField = enquirydetailformrevamp.getForm().findField('enqIntermediateTypeId');
															enqIntermediateTypeIdField.setValue(enqIntermediateStage.getValue());
														}
													}
												}
											});
										}
									});
								}
								setTimeout(function(){
									var formDetail = me.getFollowupdetailForm();
									if(formDetail.getForm().isValid()){
										var submitButton = formDetail.down('#followdetail_submitbuttonId');
										submitButton.setDisabled(false);
									}
									},100);
							}
						});
					} else {
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('FOLLOWUP_MSSG'));
					}
				}
			});
		} else {
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: fData,
				method: 'POST',
				success: function(f, action) {
					showSuccessMessage(getCommonTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
					grid.store.load({
            			callback: function(record, operation, success) {
        					if (success) {
        						var recIndex = grid.getStore().find('isLatestFollowUp', true);
        						if(recIndex == -1){
        							grid.getSelectionModel().select(grid.getStore().getAt(grid.getStore().getCount()-1));
        						}else{
        							grid.getSelectionModel().select(grid.getStore().getAt(recIndex));	
        						}
    		            		var stageId = Ext.getCmp('enqtab_intermediateStageId').getValue();
    		            		var priorityId = Ext.getCmp('dispalyPriorityId').getValue();
    		            		var rec = grid.getSelectionModel().getSelection();
    		            		var form = Ext.getCmp('followUpDetailFormId');
    		            		
    		            		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
    		            		var getTabScroll = tabStructure1.up();
    		            		var getformPosition = form.getPosition()[1];
    		            		getTabScroll.body.scrollTo('top',getformPosition)
    		            		
    		            		var records = grid.getSelectionModel().getSelection();
    		            		if (records != undefined && records != "" && records != null) {
    		            			//form.loadRecord(records[0]);
    		            			setTimeout(function(){
    		    						form.getForm().findField('followupuser').setValue(records[0].data.users.value);
    		    						//form.getForm().findField('followupTime').setValue(records[0].data.users.value);
    		    					},300);
    		            			//form.getForm().findField('followUpDate').setValue(new Date(records[0].get('followUpDate')));
    		            			form.getForm().findField('actualFollowUpDate').setValue(new Date());
    		            			var followupStatusUpdateTime=records[0].data.followupStatusUpdateTime;
                                    var newDateTime=    Ext.Date.parse(followupStatusUpdateTime,'d-m-Y H:i:s').getTime();
                                     var newDate = dateRender(newDateTime)+" "+timeRender(newDateTime);
                                     form.getForm().findField('followupStatusUpdateTime').setValue(newDate);
    		            			var stageStore = me.getStore('enquiry.EnqIntermediateType');
    		            			stageStore.load({
    		            				callback: function(record, operation, success) {
    		            					if (success) {
    		            						var enqIntermediateStage=form.down('#enqIntermediateStage');
    		            						if (!isNullOrEmpty(enqIntermediateStage)) {
    												if (stageId != null) {
    													enqIntermediateStage.setValue(parseInt(stageId));
    												} else {
    													enqIntermediateStage.setValue(1);
    												}
    											}
    		            					}
    		            				}
    		            			});
    		            			var priority = form.getForm().findField('priority');
    		            			if(!isNullOrEmpty(priority)) {
    		            				priority.store
    		            				.load({
    		            					callback : function(r, operation,
    		            							success) {
    		            						if (success) {
    		            							if (priorityId != null) {
    		            								priority
    		            								.setValue(parseInt(priorityId));
    		            							} else {
    		            								priority.setValue(1);
    		            							}

    		            						}
    		            					}
    		            				});
    		            			}
    		            			var followUpActivityType = form.getForm().findField('followUpActivityType');
    		            			if(!isNullOrEmpty(followUpActivityType)) {
    		            				followUpActivityType.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.followUpActivityType)) {
    		            								followUpActivityType.setValue(records[0].data.followUpActivityType.id);
    		            							}	
    		            						}
    		            					}
    		            				});
    		            			}
    		            			
    		            			var reasonForFollowUp = form.getForm().findField('reasonForFollowUp');
    		            			if(!isNullOrEmpty(reasonForFollowUp)) {
    		            				reasonForFollowUp.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.reasonForFollowUp)) {
    		            							reasonForFollowUp.setValue(records[0].data.reasonForFollowUp.id);
    		            							}
    		            						}
    		            					}
    		            				});
    		            			}
    		            			var followUpActivityStatus = form.getForm().findField('followUpActivityStatus');
    		            			if(!isNullOrEmpty(followUpActivityStatus)) {
    		            				followUpActivityStatus.getStore().load({
    		            					callback : function(r, operation,success) {
    		            						if (success) {
    		            							if(!isNullOrEmpty(records[0].data.followUpActivityStatus)) {
    		            							followUpActivityStatus.setValue(records[0].data.followUpActivityStatus.id);
    		            							}
    		            						}
    		            					}
    		            				});
    		            			}
    		            		}
        					}
        				}
            		
					});
					grid.getSelectionModel().deselectAll();
					Ext.getCmp('enqtab_intermediateStage').setValue(enqIntermediateStage.getRawValue());
					Ext.getCmp('enqtab_intermediateStageId').setValue(enqIntermediateStage.getValue());
//					Ext.getCmp('dispalyEnquiryStatus').setValue(getCommonTranslation('CLOSE'));
					Ext.getCmp('dispalyPriority').setValue(priority.getRawValue());
					Ext.getCmp('dispalyPriorityId').setValue(priority.getValue());
					whetherNextFollowUp = form.findField('whetherNextFollowUp');
					whetherNextFollowUp.setValue(false);
					
					var enquirydetailformrevampArr = Ext.ComponentQuery.query('[xtype=enquirydetailformrevamp]');
					if( !isNullOrEmpty(enquirydetailformrevampArr) ){
						var enquirydetailformrevamp = enquirydetailformrevampArr[0];
						if( !isNullOrEmpty(enquirydetailformrevamp) ){
							var enqIntermediateTypeIdField = enquirydetailformrevamp.getForm().findField('enqIntermediateTypeId');
							enqIntermediateTypeIdField.setValue(enqIntermediateStage.getValue());
						}
					}
					setTimeout(function(){
						var formDetail = me.getFollowupdetailForm();
						if(formDetail.getForm().isValid()){
							var submitButton = formDetail.down('#followdetail_submitbuttonId');
							submitButton.setDisabled(false);
						}
						},100);
				}
			});
		}
		/*	if(!whetherNextFollowUp) {
			var closerReason = form.findField('closerReason');
			var submitData = {
				    "enquiry": {
				        "id": parseInt(enquiryId)
				    },
				    "closureReason": {
				        "id": closerReason
				    },
				    "closureDate": new Date(),
				    "reasonRemark": "",
				    "whetherDeleted": "false"
				};
			submitUrl = SERVERURL.CLOSURE_DETAIL_FOR_OTHER_ENQUIRY_TYPE_CLOSER_CREATE_URL;
			Ext.Ajax.request({
	    		method: "POST",
	    		type:'rest',
	    		url: submitUrl,
	    		jsonData: submitData,
	    		headers: {
					'Content-Type': 'application/json'
				},
	    		success: function(response) {
	    			grid.getSelectionModel().deselectAll();
//	    			grdStore.reload();
//	    			$this.cancelClosureDetail();
//	    			showSuccessMessage(getCommonTranslation('CLOSURE_TITLE'),getCommonTranslation('SUCCESS'));
	    		}
	    	});
		}*/
	},
	saveClosureFormWindow: function() {
		var me = this;
		var closureformWindow = me.getClosurefollowupdetailForm();
		var form = closureformWindow.getForm();
		var values = form.getValues();
		var grid = me.getClosurefollowupgrid();
		var records = grid.getSelectionModel().getSelection();
		var commonForm = me.getEnquirytabstructure().getForm();
		var commonVal = commonForm.getValues();
		var dataArray=[];
		var fData={
				"enquiry":me.getIdValueJson(commonVal.enqId),
				"closureReason": me.getIdValueJson(values.closureReason),
				"enquiryStudentDetailId":commonVal.studentDetailId,
				"admissionEnqDetailsId":records[0].data.id,
				"closureDate": values.closureDate,
				"reasonRemark":values.closureRemarks,
				"whetherDeleted":false
		};
		dataArray.push(fData);
		//var fData = Ext.encode(closureFollowupadd.data);
		submitUrl = SERVERURL.CREATE_CLOSURE_FOLLOWUP_URL;
		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: dataArray,
			method: 'POST',
			success: function(f, action) {
				showSuccessMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('SUCCESS'));
				grid.store.load();
				me.cancelClosureFormWindow();
			}
		});
	},
	onFollowFormRender: function(f) {
		/*var examStructure = this.getExamdetailstructure();

	        	  var commonForm = this.getEnquirytabstructure().getForm();
	        	  var commonVal = commonForm.getValues();
	        	  var status = commonVal.enquiryStatus;
	        	  var enquiryType = commonVal.enquiryType;

	        	  if(enquiryType != 'Admission'){
	        		  examStructure.setVisible(false);
	        	  }

	        	  if(enquiryType=='Admission' && status=='Closed' || status=='Auto Closed'){
	        		  examStructure.setVisible(true);
	        	  }*/
	},
	getIdValueJson: function(id, value, code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	},
	//
	loadCountcfenquiriesfilter: function() {
		var $this = this;
		var structure = this.getCountofEnquiriesStructure();
		this.showInvalidIconOnField(structure);
		var quickSearchForm = this.getCountcfenquiriesfilter().getForm();
		var formValues=quickSearchForm.getValues();
		var form = this.getEnquiryDashboardManagementStructure();
		var groupedColumnChart = form.down("#countofenquiriesgridItemId"); 
		var organizationForm=this.getOrganizationunit().getForm();
		var academyLocation=organizationForm.findField('academyLocation');
		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
		if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
		var acdemyLocationArray=[];
		if(!academyLocation.isHidden()){
			Ext.Array.each(academyLocation.getValue(),function(value){
				if(Ext.isObject(value)){
					acdemyLocationArray.push(value.data.id);
				}else{
					acdemyLocationArray.push(value);	
				}	
			});
		}
		if(!multiselectAcademyLocation.isHidden()){
			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				if(Ext.isObject(value)){
					acdemyLocationArray.push(value.data.id);
				}else{
					acdemyLocationArray.push(value);	
				}
			});
		}
		submitData = {
			"programId":formValues.program,
		    "batchId":formValues.batch,
		    "seatTypeId":formValues.seatType,
			"startDate": formValues.countOfEnquiryStartDate,
			"endDate": formValues.countOfEnquiryToDate,
			"enquiryAssignTo":formValues.assignTo,
			"academyLocations": acdemyLocationArray.join(),
			"intakeYearId" : formValues.intakeYear,
			"programCategoryId": formValues.programCategory
		};
	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.COUNT_OF_ENQUIRY,
			jsonData: submitData,
			method: 'POST',
			success: function(response, action) {
				 Ext.getBody().unmask();
				var countOfEnquiry = Ext.decode(response.responseText);
				groupedColumnChart.getStore().loadData(countOfEnquiry);
				var enquiryCountExtraBtns = structure.down('#enquiryCountExtraBtns');
				enquiryCountExtraBtns.setVisible(true);
				$this.addExportToPngForDashboard(enquiryCountExtraBtns.menu,groupedColumnChart);
			}
		});
		}else
			{
				showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
			}
	},
	getSearchClosureRate: function() {
		var $this=this;
		var enqDashboardStructure=$this.getEnquiryDashboardManagementStructure();
		var form = $this.getEnquiryclosureratefilter();
		var enqDashBoardForm=form.getForm();
		var formValues=enqDashBoardForm.getValues();
		var enquiryClosureRateExtraBtns = enqDashboardStructure.down("#enquiryClosureRateExtraBtns");
		var enquiryClosureRatebyTypeExtraBtns = enqDashboardStructure.down("#enquiryClosureRatebyTypeExtraBtns");
		var richTipGraph = enqDashboardStructure.down("#richtipchartforclosurerateItemId");
		var columnGraph = enqDashboardStructure.down("#enqbarchartreportforaveragetimeId");
		var organizationForm=$this.getOrganizationunit().getForm();
		var academyLocation=organizationForm.findField('academyLocation');
		var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
		var acdemyLocationArray=[];
		if(!academyLocation.isHidden()){
			Ext.Array.each(academyLocation.getValue(),function(value){
				if(Ext.isObject(value)){
					acdemyLocationArray.push(value.data.id);
				}else{
					acdemyLocationArray.push(value);	
				}
			});
		}
		if(!multiselectAcademyLocation.isHidden()){
			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				if(Ext.isObject(value)){
					acdemyLocationArray.push(value.data.id);
				}else{
					acdemyLocationArray.push(value);	
				}
			});
		}
		var seatTypeIdsValue = [];
		var seatTypeIds = formValues.seatType;
        if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
        	var seatTypeIdsArray=[];
        	for(var i in seatTypeIds) {
        		if(typeof seatTypeIds[i] == "object") {
        			seatTypeIdsArray.push(seatTypeIds[i].data.id);
        		} else {
        			seatTypeIdsArray.push(seatTypeIds[i]);
        		}
        	}
        	var seatTypeIdsString = seatTypeIdsArray.join();
        	seatTypeIdsString = seatTypeIdsString.toString();
        	var seatTypeCommaIndex = seatTypeIdsString.indexOf(",");
        	if (seatTypeCommaIndex != -1) {
        		var seatTypeIdsArray = seatTypeIdsString.split(",");
        		seatTypeIdsValue = seatTypeIdsArray;
        	} else {
        		seatTypeIdsValue = [seatTypeIdsString];
        	}
        }
		submitData = {
				"startDate": formValues.startDate,
				"endDate": formValues.endDate,
				"academyLocations": acdemyLocationArray.join(),
				"intakeYearId" : formValues.intakeYear,
				"seatTypeIds" : seatTypeIdsValue
		};
		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.ENQUIRY_CLOSURE_RATE,
			jsonData: submitData,
			method: 'POST',
			success: function(response, action) {
				var countOfEnquiry = Ext.decode(response.responseText);
				richTipGraph.getStore().loadData(countOfEnquiry);
				$this.addExportToPngForDashboard(enquiryClosureRateExtraBtns.menu,richTipGraph);
				enquiryClosureRateExtraBtns.setVisible(true);
			}
		});
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.ENQUIRY_AVERAGE_TIME,
			jsonData: submitData,
			method: 'POST',
			success: function(response, action) {
				 Ext.getBody().unmask();
				var averageTimeEnquiry = Ext.decode(response.responseText);
				columnGraph.getStore().loadData(averageTimeEnquiry);
				$this.addExportToPngForDashboard(enquiryClosureRatebyTypeExtraBtns.menu,columnGraph);
				enquiryClosureRatebyTypeExtraBtns.setVisible(true);
			}
		});
	},
	gridRenderFunction: function(grid) {
		//grid.addButtonToolbar();
		grid.addDocked({
			xtype: 'toolbar',
			dock: 'top',
			items: [{
				xtype: 'button',
				itemId: 'btnAdd',
				tooltip: getCommonTranslation('ADD'),
				glyph: ICONGLYPH.ADDGLYPH
			}, {
				xtype: 'button',
				itemId: 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip: getCommonTranslation('DELETE'),
				glyph: ICONGLYPH.DELETEGLYPH
			}]
		});
	},
	getAcademyLocationFromOrgForm:function(){
		var $this=this;
		var organizationForm=$this.getOrganizationunit().getForm();
		var multiselectAcademyLocation = organizationForm.findField('multiselectAcademyLocation');
		var academyLocationIds = [];
		if(!multiselectAcademyLocation.isHidden()){
			Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
				if(Ext.isObject(value)){
					academyLocationIds.push(value.data.id);	
				}else {
					academyLocationIds.push(value);
				}
			});
		}
		return academyLocationIds;
	}
});