/**
 * @author Deepika Parmar
 * 
 **/
Ext.define('Academia.controller.examconcession.ExamConcessionController', {
	extend: 'Academia.controller.base.BaseController',
	models: [
	],
	stores: ['examconcession.ExamConcessionGridStore','examconcession.ExamConcessionStatusStore','examconcession.ExamConcessionCodeNameStore',
		'examconcession.ExamConcessionProgramStore','examconcession.ExamConcessionBatchStore','examconcession.ConcessionProgramBatchGridStore',
		'user.UserAcademyLocationStore','examcancellation.ECALProgramBatchList','examconcession.ExamConcessionDependentFieldTypeStore',
		'examconcession.ExamConcessionMappedProgramGridStore'],
	views: ['examconcession.ExamConcessionFilter','examconcession.ExamConcessionStructure','examconcession.ExamConcessionGrid','examconcession.AddExamConcessionWin',
		'examconcession.AddExamConcessionForm','examconcession.ConcessionProgramBatchGridWin','examconcession.ExamConcessionApplyToStructure',
		'examconcession.ExamConcessionAddMappingStructure','examconcession.ExamConcessionProgressTracker','examconcession.ExamConcessionAddMappingTabStructure',
		'examconcession.EConcessionAddMappingAcademyLocationTab','examconcession.EConcessionAddMappingProgramBatchTab','examconcession.ExamConcessionApplyToWindow'],
	config: {
		EXAMINATION_EXAM_CONCESSION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_CONCESSION_PRIVILEGES'),
		EXAMINATION_EXAM_CONCESSION_REQUEST_PRIVILEGES :Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_CONCESSION_REQUEST_PRIVILEGES'),
		EXAM_CONCESSION_PRIVILEGES_APPLY_TO :Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_CONCESSION_PRIVILEGES_APPLY_TO'),
	},
	refs: [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},{
		ref:'examconcessionfilter',
		selector:'examconcessionfilter'
	},{
		ref:'examconcessionstructure',
		selector:'examconcessionstructure'
	},{
		ref:'examconcessiongrid',
		selector:'examconcessiongrid'
	},{
		ref:'addexamconcessionform',
		selector:'addexamconcessionform'
	},{
		ref:'addexamconcessionwin',
		selector:'addexamconcessionwin'
	},{
		ref:'concessionprogrambatchgridwin',
		selector:'concessionprogrambatchgridwin'
	},{
		ref:'examconcessionapplytostructure',
		selector:'examconcessionapplytostructure'
	},{
		ref:'examconcessionaddmappingstructure',
		selector:'examconcessionaddmappingstructure'
	},{
		ref:'examconcessionprogresstracker',
		selector:'examconcessionprogresstracker'
	},{
		ref:'examconcessionaddmappingtabstructure',
		selector:'examconcessionaddmappingtabstructure'
	},{
		ref:'econcessionaddmappingacademylocationtab',
		selector:'econcessionaddmappingacademylocationtab'
	},{
		ref:'econcessionaddmappingprogrambatchtab',
		selector:'econcessionaddmappingprogrambatchtab'
	},{
		ref:'examconcessionapplytowindow',
		selector:'examconcessionapplytowindow'
	}],
	init: function() {
		this.control({
			'examconcessionstructure': {
				afterrender:function(structure){
					var grid = structure.down('examconcessiongrid');
					var searchTab = structure.down('form');
					this.getGridHeaderFreezeForGradeMaster(grid,searchTab);
				}
			},
			'examconcessionfilter': {
				afterrender:function(form){
					var examConcessionStatusId = form.down('#examConcessionStatusId');
					var examConcessionCodeNameId =form.down('#examConcessionCodeNameId');
					var examConcessionProgramId =program = form.down('#examConcessionProgramId');
					var currentAL = this.getCurrentAcademyLocation();
					examConcessionProgramId.getStore().getProxy().extraParams = {
						academyLocationId :currentAL,
						concessionId:examConcessionCodeNameId.getValue()
					}
					examConcessionProgramId.getStore().load();
					 examConcessionCodeNameId.getStore().load();
					 examConcessionStatusId.getStore().load({
						callback:function(rec,success){
							if(success){
								examConcessionStatusId.setValue(rec[0].data.id);
							}
						}
					});
				}
			},
			'examconcessionfilter customcombobox#examConcessionCodeNameId' : {
				select:function(obj,rec){
					var form = this.getExamconcessionfilter();
					var currentAL = this.getCurrentAcademyLocation();
					
					var examConcessionProgramId  =form.down('#examConcessionProgramId');
					var examConcessionBatchId = form.down('#examConcessionBatchId');
					examConcessionProgramId.reset();
					examConcessionBatchId.reset();
					examConcessionBatchId.disable();
					
					if(rec.length > 0){
						
						examConcessionProgramId.getStore().getProxy().extraParams = {
							concessionId:rec[0].data.id,
							academyLocationId :currentAL
						}
						examConcessionProgramId.getStore().load({
							callback:function(record){
								if(record.length ==1){
									examConcessionProgramId.setValue(record[0].data.id);
									examConcessionBatchId.enable();
									examConcessionBatchId.getStore().getProxy().extraParams = {
										id:record[0].data.id,
										/*concessionId:rec[0].data.id,
										academyLocationId :currentAL*/
									}
									examConcessionBatchId.getStore().load({
										callback:function(batchRecord){
											if(batchRecord.length ==1){
												examConcessionBatchId.setValue(batchRecord[0].data.id);
											}
										}
									});
								}
							}
						})
						
					}
				}
			},
			'examconcessionfilter customcombobox#examConcessionProgramId' : {
				select:function(obj,rec){
					var form = this.getExamconcessionfilter();
					var examConcessionBatchId = form.down('#examConcessionBatchId');
					var currentAL = this.getCurrentAcademyLocation();
					examConcessionBatchId.reset();
					
					var examConcessionCodeNameId = form.down('#examConcessionCodeNameId');
					if(rec.length > 0){
						examConcessionBatchId.enable();
						examConcessionBatchId.getStore().getProxy().extraParams = {
							id:rec[0].data.id
							//concessionId:examConcessionCodeNameId.getValue(),
							//academyLocationIds :currentAL
						}
						examConcessionBatchId.getStore().load({
							callback:function(record, operation, success){
								if(record.length ==1){
									examConcessionBatchId.setValue(record[0].data.id);
								}
							}
						});
					}
				}
			},
			'examconcessionfilter button#examConcessionSearchId':{
				click:function(){
					var form = this.getExamconcessionfilter();
					var formValues = form.getForm().getValues();
					var grid = this.getExamconcessiongrid();
					var editBtn = grid.down('#btnEdit');
					var btnView = grid.down('#btnView');
					var btnView = grid.down('#btnView');
					var btnDelete = grid.down('#btnDelete');
					var btnApplyTo = grid.down('#btnApplyTo');
					var exportPdfBtn = grid.down('#btnExportToPDF');
					var exportExcelbtn = grid.down('#btnExportToExcel');
					grid.config.searchFilterForm =form;
					 
					
					editBtn.disable();
					btnView.disable();
					btnDelete.disable();
					btnApplyTo.disable();
					grid.getStore().getProxy().extraParams ={
						examConcessionId : formValues.examConcessionCodeName,
						status:formValues.examConcessionStatus,
						programId:formValues.examConcessionProgram,
						batchId :formValues.examConcessionBatch
					} 
					this.resetPageSetting(grid.getStore(), grid);
					grid.getStore().load({
						callback:function(record){
							if(record.length > 0){
								exportPdfBtn.enable();
								 exportExcelbtn.enable();
								 
							}
						}
					});
					 grid.getSelectionModel().deselectAll();
				}
			},
			'examconcessionfilter button#examConcessionResetId':{
				click:function(){
					var form = this.getExamconcessionfilter();
					form.getForm().reset();
					var examConcessionStatusId = form.down('#examConcessionStatusId');
					var examConcessionCodeNameId =form.down('#examConcessionCodeNameId');
					var examConcessionProgramId =program = form.down('#examConcessionProgramId');
					var examConcessionBatchId = form.down('#examConcessionBatchId');
					
					var currentAL = this.getCurrentAcademyLocation();
					examConcessionBatchId.disable();
					examConcessionProgramId.getStore().getProxy().extraParams = {
						academyLocationId :currentAL,
						concessionId:examConcessionCodeNameId.getValue()
					}
					examConcessionProgramId.getStore().load();
					 examConcessionCodeNameId.getStore().load();
					 examConcessionStatusId.getStore().load({
						callback:function(rec,success){
							if(success){
								examConcessionStatusId.setValue(rec[0].data.id);
							}
						}
					});
				}
			},
			
			'examconcessiongrid':{
				afterrender:function(grid){
					this.disableToolbarButtonByPivileges(grid,this.getEXAMINATION_EXAM_CONCESSION_PRIVILEGES());
				},
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var form=this.getExamconcessionfilter().getForm();
					var examcConcessionGrid = View.up('grid');
					var editBtn = examcConcessionGrid.down('#btnEdit');
					var btnView = examcConcessionGrid.down('#btnView');
					var btnView = examcConcessionGrid.down('#btnView');
					var btnDelete = examcConcessionGrid.down('#btnDelete');
					var btnApplyTo = examcConcessionGrid.down('#btnApplyTo');
					var programId  =form.findField('examConcessionProgram').getValue();
					var batchId  =form.findField('examConcessionBatch').getValue();
					editBtn.enable();
					btnView.enable();
					btnDelete.enable();
					btnApplyTo.enable();
					var batchIDs = [];
					batchIDs.push(batchId);
					var columnName = View.getGridColumns()[ColIdx].dataIndex;
					
					if (e.target.tagName == 'A' && columnName == 'mappedProgramCount') {
						var examConcessionId = record.data.id;
						
						
						var concessionProgramWin = this.showWindow('concessionprogrambatchgridwin');
						concessionProgramGridStore = concessionProgramWin.down('grid').getStore();
						concessionProgramGridStore.removeAll();
						concessionProgramGridStore.getProxy().extraParams = {
							examConcessionId: examConcessionId,
							programId:programId,
							batchList:batchIDs.join(),
							
						};
						this.resetPageSetting(concessionProgramGridStore, concessionProgramWin.down('grid'));
						concessionProgramGridStore.loadPage(1);
						concessionProgramWin.down('grid').getSelectionModel().deselectAll(true);
						
					}
					
					
 			   },
			},
			'examconcessiongrid button[itemId=btnDelete]': {
				click: function(button) {
					var me = this;
					var examcConcessionGrid = button.up('grid');
					var jsonData = [];
					if (examcConcessionGrid.getSelectionModel().getCount() > 0) {
						var selectedRecord = examcConcessionGrid.getSelectionModel().getSelection()[0];	
						if(selectedRecord.data.mappedProgramCount >0){
							showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('RECORD_CANNOT_BE_DELETED_AS_IT_IS_USED_AS_A_REFERENCE'));
							
						}else{
							var submitUrl = SERVERURL.PATH_EXAM_CONCESSION_DELETE_DEPNDENT_FIELD;
							showConfirmMessage(getExaminationTranslation('EXAM_CONCESSION'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'), function(btn, text) {
								if (btn == 'yes') {
									Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
									Ext.Ajax.request({
										type: 'rest',
										url: submitUrl + '?id=' + selectedRecord.data.id,
										method: 'DELETE',
										success: function(response, action) {											
												Ext.getBody().unmask();
												examcConcessionGrid.getStore().loadPage(1);
												examcConcessionGrid.getSelectionModel().deselectAll();
												showSuccessMessage(getExaminationTranslation('EXAM_CONCESSION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
											
										}
									});
								}
							});
						}
						
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'examconcessiongrid button[itemId=btnApplyTo]': {
				click: function(button) {
					var me = this;
					var examConcessionGrid = button.up('grid');
					var gridRecord = examConcessionGrid.getSelectionModel().getSelection()[0];
					if (examConcessionGrid.getSelectionModel().getCount() > 0) {
						var examConcessionId = gridRecord.data.id;
						var examConcessionName = gridRecord.data.examConcessionName;
						var contentpanel = me.getContentPanel();
						var applyToTab = Ext.widget('examconcessionapplytostructure',{
							examConcessionId :examConcessionId,
							examConcessionName :examConcessionName
						});
						var tabName = getCommonTranslation('APPLY_TO');
						var getcontroller = this.getController('menu.CoreERPNavigationController');
						var getTab = getcontroller.getTab(tabName);
						if (getTab != null) {
							contentpanel.remove(getTab, true);
						}
						openTab(contentpanel, tabName, applyToTab,CONSTANTS.MENU_COLOR_FOUR);
						applyToTab.examConcessionId = examConcessionId;
						applyToTab.examConcessionName =examConcessionName;
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'examconcessionapplytostructure':{
				afterrender: function(structure){
					var me = this;
					var applyToGrid = structure.down('grid');
					var examConcessionId = structure.examConcessionId;
					var applyToGridStore = applyToGrid.getStore();
					applyToGridStore.getProxy().extraParams={
						examConcessionId: examConcessionId,
					};
					this.resetPageSetting(applyToGridStore, applyToGrid);
					applyToGridStore.load();
					applyToGrid.getSelectionModel().deselectAll(true);
					
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
					var permissionListThree = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
							associatedAcadLocationIds, me.getEXAM_CONCESSION_PRIVILEGES_APPLY_TO());

					var btnAdd_Apply_To = structure.down('#btnAdd');
					var btnView_Apply_To = structure.down('#btnView');
					var btnDelete_Apply_To = structure.down('#btnDelete');

					btnAdd_Apply_To.setVisible(false);
					btnView_Apply_To.setVisible(false);
					btnDelete_Apply_To.setVisible(false);

					if((Ext.Array.contains(permissionListThree, 'CREATE'))){
						btnAdd_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'VIEW'))){
						btnView_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'DELETE'))){
						btnDelete_Apply_To.setVisible(true);
					} 
			}
			},
			
			'examconcessionapplytostructure button[itemId=btnAdd]': {
				click: function(button) {
					var me = this;
					var applyToStructure = button.up('examconcessionapplytostructure');
					var examConcessionId = applyToStructure.examConcessionId;
					var examConcessionName = applyToStructure.examConcessionName;
					var contentpanel = me.getContentPanel();
					var addMappingTab = Ext.widget('examconcessionaddmappingstructure',{
						examConcessionName : examConcessionName,
						examConcessionId:examConcessionId
					});
					var tabName = getCommonTranslation('ADD_MAPPING');
					var getcontroller = this.getController('menu.CoreERPNavigationController');
					var getTab = getcontroller.getTab(tabName);
					if (getTab != null) {
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, addMappingTab,CONSTANTS.MENU_COLOR_FOUR);
				
				}
			},
			'examconcessionapplytowindow button[itemId=applyToWindowCancelBtn]':{
				click: function(button){
					var window = button.up('examconcessionapplytowindow');
					window.close();
				}
			},
			'examconcessionapplytostructure button[itemId=btnDelete]':{
				click: function(button){
					var me = this;
					var applyToGrid = button.up('grid');
					var gridRecord=applyToGrid.getSelectionModel().getSelection()[0];
					if(applyToGrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.PATH_FIND_ALL_EXAM_CONCESSION_BATCH_MAPPING_DELETE;
						showConfirmMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										Ext.getBody().unmask();
										applyToGrid.getStore().loadPage(1);
										applyToGrid.getSelectionModel().deselectAll();
										showSuccessMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'examconcessiongrid button#btnAdd' :{
				click:function(){
					var addConcessionWin = Ext.widget('addexamconcessionwin');
					addConcessionWin.show();
				}
			},
			'examconcessiongrid button[itemId=btnEdit]': {
				click: function(button) {
					  var examConcessionGrid = this.getExamconcessiongrid();
						if (examConcessionGrid.getSelectionModel().getSelection().length > 0) {
							var selectedRecord = examConcessionGrid.getSelectionModel().getSelection()[0];	
							if(selectedRecord.data.mappedProgramCount >0){
								showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('RECORD_CANNOT_BE_EDITED_AS_IT_IS_USED_AS_A_REFERENCE'));
								
							}else{
								this.editExamConcessionFormWin(false);		
							}
						}
			           
								
				}
			},
			'examconcessiongrid button[itemId=btnView]': {
				click: function(button) {
					this.editExamConcessionFormWin(true);					
				}
			},
			'addexamconcessionform checkboxfield[itemId=isDependentFieldRequiredId]':{
				afterrender:function(combo){
					
					var form =this.getAddexamconcessionform();
					var status =form.down('#examConcessionStatusId');
					var dependentCheckBox =form.down('#isDependentFieldRequiredId');
					
					if(status.hidden){
						dependentCheckBox.addCls('dependentCheckBoxCls');						
					}else{
						dependentCheckBox.addCls('dependentCheckBoxClsForStatus');
					}
				}
			},
			'addexamconcessionform button#SubmitBtn':{
				click:function(btn){
					if(!btn.isClicked){
						this.saveExamConcessionFormValue(btn);
					}					
				}
			},
			'addexamconcessionform button#CancelBtn':{
				click:function(){
					var addConcessionWin = this.getAddexamconcessionwin();
					if(!isNullOrEmpty(addConcessionWin)){
						addConcessionWin.close();
					}
				}
			},
			'addexamconcessionform button#addDetailedBtn':{
				click:function(){
    				var addConcessionForm=this.getAddexamconcessionform();
					this.addMultipleDependentField(addConcessionForm);
				}
			},
			'addexamconcessionform button#deleteDependentFldBtn':{
				click:function(deleteButton){
					var addConcessionForm=this.getAddexamconcessionform();
    				this.deleteDependentTypeFld(deleteButton,addConcessionForm)
				}
			},
			'addexamconcessionform checkboxfield#isDependentFieldRequiredId':{
				change:function(obj,newVal,oldVal){
					var addConcessionForm=this.getAddexamconcessionform();
					var dependentFldCont = addConcessionForm.down('#dependentfieldcontainerId');
					var dependentfieldPanelId =dependentFldCont.down('#dependentfieldPanelId');
					var dependentFldLength =dependentfieldPanelId.items.items.length;
					var count = dependentFldLength;
					if(newVal == true){
						dependentFldCont.show();
					}else{
						for(var i =dependentfieldPanelId.items.items.length;i >0  ; i--){
							var container = dependentfieldPanelId.items.items[i];
							if(container) {
								var dependentFldTypeId = container.down('#dependentFldTypeId');
							}

							if(!isNullOrEmpty(container)&& isNullOrEmpty(dependentFldTypeId.fieldLabel)){
								if (container != null && dependentfieldPanelId != null) {
									if (dependentfieldPanelId.items.length > 1) {
										container.items.items[0].reset();     			
										container.items.items[1].reset();
										dependentfieldPanelId.remove(container);
										this.dependentFieldHideShowDetails(dependentfieldPanelId,addConcessionForm);
									}
								}
							}
							else{
								dependentfieldPanelId.items.items[0].down('#dependentFldNameId').reset();
								dependentfieldPanelId.items.items[0].down('#dependentFldTypeId').reset();
							}
						}					
						dependentFldCont.hide();


					}
				}
			},
			'examconcessionaddmappingstructure':{
				afterrender: function(structure){
					var me = this;
					
					var ecProgresstracker = structure.down('examconcessionprogresstracker');
					ecProgresstracker.setVisible(true);
					var progresstracker1 = ecProgresstracker.down("#progresstracker1");
					var progresstracker2 = ecProgresstracker.down("#progresstracker2");
					var progresstracker3 = ecProgresstracker.down("#progresstracker3");
					
					progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker1.textEl.addCls("inProgressCss-progress-text");
					progresstracker1.updateText("Step 1 In Progress");
					
					progresstracker2.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.addCls("x-progress-text x-progress-text-back");
					progresstracker2.updateText("");
					
					var academyLocationTab = structure.down('econcessionaddmappingacademylocationtab');
					var programBatchTab = structure.down('econcessionaddmappingprogrambatchtab');
					
					academyLocationTab.down('#examConcessionLabelName').setText(getExaminationTranslation('EXAM_CONCESSION_NAME')+': '+structure.examConcessionName);
					
					academyLocationTab.setDisabled(false);
					programBatchTab.setDisabled(true);
					//var gridStore= academyLocationTab.down('grid').getStore();
					//this.resetPageSetting(gridStore);
					academyLocationTab.down('grid').getStore().load();
					academyLocationTab.down('#academyLocationCombo').getStore().load();
				}
			},
			'examconcessionapplytostructure button[itemId=btnView]': {
				click: function(button) {
					var me = this;
					var applyToStructure = button.up('examconcessionapplytostructure');
					var applyToGrid = button.up('grid');
					var applyToRecord = applyToGrid.getSelectionModel().getSelection()[0];

					var formRecord = {
						examConcessionName: applyToStructure.examConcessionName,
						academyLocationName: applyToRecord.get('academyLocationName'),
						programName: applyToRecord.get('programName'),
						batchName: applyToRecord.get('batchName')
					};
					var examconcessionapplytowindow = me.showWindow('examconcessionapplytowindow');
					setTimeout(function() {
						var form = examconcessionapplytowindow.down('form');
						form.getForm().setValues(formRecord);
					}, 300);
				}
			},
			'examconcessionapplytostructure grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var applyToGrid = row.view.up('grid');

						var btnView= applyToGrid.down('#btnView');
						var btnDelete= applyToGrid.down('#btnDelete');

						btnView.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
						btnDelete.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			'econcessionaddmappingacademylocationtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var ecaddmappingacademylocationtabgrid = row.view.up('grid');

						var btnNext= ecaddmappingacademylocationtabgrid.down('#academyLocationNextBtn');

						btnNext.setDisabled(!ecaddmappingacademylocationtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				},
				afterrender: function(grid) {
					var structure = grid.up('examconcessionaddmappingstructure').up('panel');
					this.getGridHeaderFreezeForExamCancellationAddMapping(grid, structure);
				}
			},
			'econcessionaddmappingacademylocationtab combo[itemId=academyLocationCombo]':{
				select: function(combo){
					var me = this;
					var alId = combo.getValue();

					var grid = combo.up('grid');
					grid.getStore().clearFilter();
					grid.getStore().filterBy(function(record, id){
						return (record.get('id') == alId);
					});
					var gridDom = grid.el ? grid.el.dom : null;
					gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
				}
			},
			'econcessionaddmappingacademylocationtab button[itemId=academyLocationResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#academyLocationCombo').reset();
					grid.down('#academyLocationCombo').clearValue();
					grid.down('#academyLocationCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			'econcessionaddmappingacademylocationtab button[itemId=academyLocationNextBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var ecaddmappingtabstructure = button.up('examconcessionaddmappingtabstructure');
					
					var selectedRecords = grid.getSelectionModel().getSelection();
					var selectedAls = [];
					Ext.each(selectedRecords, function(selectedRecord){
						selectedAls.push(selectedRecord.get('id'));
					});
					
					var structure = button.up('examconcessionaddmappingstructure');
					
					var degreeremarkprogresstracker = structure.down('examconcessionprogresstracker');
					degreeremarkprogresstracker.setVisible(true);
					var progresstracker1 = degreeremarkprogresstracker.down("#progresstracker1");
					var progresstracker2 = degreeremarkprogresstracker.down("#progresstracker2");
					
					for(var i = 0; i < 11; i ++ ){
		    			progresstracker1.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker1.textEl.addCls("custom-progress-text");
		    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
		    		for(var i = 0; i < 11; i ++ ){
		    			progresstracker2.updateProgress((i * 0.1), '');
		    		}
		    		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
		      		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
		      		  progresstracker2.updateText("Step 2 In Progress");
		      			
					var academyLocationTab = structure.down('econcessionaddmappingacademylocationtab');
					var programBatchTab = structure.down('econcessionaddmappingprogrambatchtab');
					
					programBatchTab.down('#examConcessionLabelName').setText(getExaminationTranslation('EXAM_CONCESSION_NAME')+': '+structure.examConcessionName);
					
					academyLocationTab.setDisabled(false);
					programBatchTab.setDisabled(false);
					
					ecaddmappingtabstructure.setActiveTab(1);
					
					programBatchTab.down('grid').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					//var gridStore =programBatchTab.down('grid').getStore();
					//this.resetPageSetting(gridStore);
					
					//programBatchTab.down('grid').getStore().load();
					programBatchTab.down('#batchCombo').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					//programBatchTab.down('#batchCombo').getStore().load();
						 var studentGrid=this.getEconcessionaddmappingprogrambatchtab().down('grid');
					 me.resetPageSetting(studentGrid.getStore(), studentGrid);
									   studentGrid.getStore().load();
									   studentGrid.getSelectionModel().deselectAll();
									   studentGrid.getStore().pageSize = 100;
				}
			},
			
			'econcessionaddmappingprogrambatchtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var ecaddmappingprogrambatchtabgrid = row.view.up('grid');

						var btnSubmit= ecaddmappingprogrambatchtabgrid.down('#batchSubmitBtn');

						btnSubmit.setDisabled(!ecaddmappingprogrambatchtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				},
				afterrender: function(grid) {
					var structure = grid.up('examconcessionaddmappingstructure').up('panel');
					this.getGridHeaderFreezeForExamConcessionAddMapping(grid, structure);
				}
			},
			'econcessionaddmappingprogrambatchtab combo[itemId=batchCombo]':{
				select: function(combo){
					var me = this;
					var batchId = combo.getValue();

					var grid = combo.up('grid');
					grid.getStore().clearFilter();
					grid.getStore().filterBy(function(record, id){
						return (record.get('batchId') == batchId);
					});
					var gridDom = grid.el ? grid.el.dom : null;
					gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
				}
			},
			'econcessionaddmappingprogrambatchtab button[itemId=batchResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#batchCombo').reset();
					grid.down('#batchCombo').clearValue();
					grid.down('#batchCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			
			'econcessionaddmappingprogrambatchtab button[itemId=batchSubmitBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var gridRecord = grid.getSelectionModel().getSelection();
					var examConcessionId = this.getExamconcessiongrid().getSelectionModel().getSelection()[0].data.id;;
					var examConcessionName=this.getExamconcessiongrid().getSelectionModel().getSelection()[0].data.examConcessionName;;
					
					var formData = [];
					Ext.each(gridRecord, function(currentRecord){
						formData.push({
							examConcessionId:examConcessionId,
							academyLocationId:currentRecord.get('academyLocationId'),
							programId:currentRecord.get('programId'),
							batchId:currentRecord.get('batchId'),
							examConcessionName:examConcessionName
						});
					});
					me.saveAllMappings(formData);
				}
			},
			'addexamconcessionform customcombobox[itemId=dependentFldTypeId]': {
				afterrender: function(cmp) {
					cmp.inputEl.dom.setAttribute('readOnly', true);
					Ext.defer(function() {
						cmp.inputEl.dom.setAttribute('readOnly', true);
					}, 1000);
				}
			},
			'examconcessionaddmappingtabstructure': {
				tabchange: function(tp, newCard) {
            		var grid = newCard.down('grid');
            		var gridTitle = grid.dockedItems.items[0];
            		var gridHeader = grid.dockedItems.items[1];
            		var gridBttns = grid.dockedItems.items[2];
            		if(grid.title == getCommonTranslation('PROGRAM_BATCH')) {
            			gridBttns = grid.dockedItems.items[3];
            		}
            		this.removeGridHeaderFreezCSSForExamCancellationAddMapping(gridTitle, gridBttns, gridHeader);
            		this.removeGridHeaderFreezCSSForExamConcessionAddMapping(gridTitle, gridBttns, gridHeader);
            	}
			}
		});
	},
	
	addMultipleDependentField :function(addConcessionForm,information,isView){

		var $this = this;
		var panelContiner = addConcessionForm.down('#dependentfieldPanelId');
		var indx;
        var fldContLen =panelContiner.items.items.length;
        var allFldIsNotEmpty= true;
		if(fldContLen > 0){
			for(var i =0 ;i < fldContLen ;i++){
				var fldTypeVal = panelContiner.items.items[i].down('#dependentFldTypeId').getValue();
				var fldTypeName = panelContiner.items.items[i].down('#dependentFldNameId').getValue();
				 if(isNullOrEmpty(fldTypeVal) && isNullOrEmpty(fldTypeName)){
			         allFldIsNotEmpty = false;
			         break;
			     }
			}
		}
        if(information) {
        	allFldIsNotEmpty = true;
        }
		if(allFldIsNotEmpty){
			if(panelContiner.items.items.length<=10){
			var panelItem = new Array();
			indx = panelContiner.items.items.length;
			panelItem.push({
    			xtype : 'fieldcontainer',
    			layout : 'hbox',
    			defaults : {
    				labelAlign : 'top',
    				width:'256'
    			},
    			items:[{
    				xtype: 'customcombobox',
    				width: 256,
    				name: 'dependentFieldType',
    				itemId:'dependentFldTypeId',
    				store: Ext.create('Academia.store.examconcession.ExamConcessionDependentFieldTypeStore'),
    				valueField: 'value',
    				displayField: 'value',
    				editable:false
    				
    		    	
    			},{
    				xtype : 'textfield',    	    		
    	    		name : 'dependentFieldName',
    	    		itemId : 'dependentFldNameId',   	    		
    				
    			},{
					xtype: 'hidden',
					itemId: 'dependentFldId',
					name:'dependentFldId',
				},{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					itemId: 'deleteDependentFldBtn',
					width: 'auto',
					disabled:(isView ? true : false),
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					listeners:{
						click:function(obj){
							var container = obj.up('fieldcontainer');
						}
					}
				},{
    				xtype: 'button',
    				itemId: 'addDetailedBtn',
    				name: 'addDetailedBtn',
    				width: 'auto',
    				cls: 'CustomBodyBtnSettings',
    				disabled:(isView ? true : false),
    				width: 'auto',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    				
    				
    			}]
    		});
			panelContiner.add(panelItem);
			this.dependentFieldHideShowDetails(panelContiner,addConcessionForm);
			panelContiner.doLayout();
			return panelContiner;
		  }
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_ENTER_THE_DETAILS_IN_THE_CURRENT_ROW_TO_ADD_MORE_ROWS'));
		}
		
	
	},
	dependentFieldHideShowDetails: function(detailedPanel,form) {
		var this$ = this;
		var cnt = detailedPanel.items.length;
		detailedPanel.items.each(function(item, index, items) {
			var addButton = item.getComponent(item.items.length - 1);
			if (index == (items - 1)) {
				if (addButton != null) {
					addButton.show();
					if(cnt == 10){
						addButton.hide();
					}
				}
			} else {
				if (addButton != null) {
					addButton.hide();
				}
			}
		});
	},
	deleteDependentTypeFld: function(deleteButton,form) {
     	var this$ = this;
     	var dependentfieldPanelId = form.down('#dependentfieldPanelId');
     	var container = deleteButton.up('fieldcontainer');
     	if (container != null && dependentfieldPanelId != null) {
     		if (dependentfieldPanelId.items.length > 1) {
     			container.items.items[0].reset();     			
     			container.items.items[0].validate();
     			dependentfieldPanelId.remove(container);
     			this$.dependentFieldHideShowDetails(dependentfieldPanelId,form);
     		}
     	}
     },
     editExamConcessionFormWin :function(isView){
    	 var $this =this;
    	   var examConcessionGrid = this.getExamconcessiongrid();
			if (examConcessionGrid.getSelectionModel().getSelection().length > 0) {
				var selectedRecord = examConcessionGrid.getSelectionModel().getSelection()[0];					
                var currentAl = this.getCurrentAcademyLocation();
				var examConcessionWindow = this.showWindow('addexamconcessionwin');
				var SubmitBtn = examConcessionWindow.down('#SubmitBtn');
				
				 var status =examConcessionWindow.down('#examConcessionStatusId');
				 var dependentCheckBox =examConcessionWindow.down('#isDependentFieldRequiredId');
				 var examConcessionCodeId= 	 examConcessionWindow.down('#examConcessionCodeId');
				 var examConcessionNameId = examConcessionWindow.down('#examConcessionNameId'); 
				 var examConcessionId = examConcessionWindow.down('#examConcessionId'); 
				 
			     status.show();
			     var allowblankFalse = '<span class="required" style="color:red"> *</span>';
			     status.setFieldLabel(getCommonTranslation('STATUS')+allowblankFalse);
			     status.allowBlank =false;
				
				if(status.hidden){
					dependentCheckBox.addCls('dependentCheckBoxCls');						
				}else{
					dependentCheckBox.addCls('dependentCheckBoxClsForStatus');
				}
				var concessionId = selectedRecord.data.id;
				
				examConcessionCodeId.setValue(selectedRecord.data.examConcessionCode);
				examConcessionNameId.setValue(selectedRecord.data.examConcessionName);
				status.setValue(selectedRecord.data.status);
				examConcessionId.setValue(concessionId);
				if(isView){
					examConcessionWindow.setTitle(getExaminationTranslation('VIEW_EXAM_CONCESSION'));	
					SubmitBtn.hide();
					examConcessionCodeId.setReadOnly(true);
					examConcessionNameId.setReadOnly(true);
					status.setReadOnly(true);
					dependentCheckBox.setReadOnly(true);

					
				}else{
					examConcessionWindow.setTitle(getExaminationTranslation('EDIT_EXAM_CONCESSION'));
					SubmitBtn.show();
					examConcessionCodeId.setReadOnly(false);
					examConcessionNameId.setReadOnly(false);
					status.setReadOnly(false);
					dependentCheckBox.setReadOnly(false);
					status.inputEl.dom.setAttribute('readOnly', true);
				}
				
					Ext.Ajax.request({
						type: 'rest',
						url:SERVERURL.PATH_EXAM_CONCESSION_EDIT,
						params: {
							examConcessionId: concessionId,
							academyLocationId: currentAl
						},
						method: 'GET',
						success: function(response, action) {
							if (!isNullOrEmpty(response.responseText)) {
								var data = Ext.decode(response.responseText);
								dependentCheckBox.setValue(data.dependentFieldRequired);
								if(data.wsExamConcessionDependentField.length > 0){
									var i=0;
	        						Ext.each(data.wsExamConcessionDependentField,function(dependentFieldInformation){
	        							var formWindow =examConcessionWindow.down('form');
                                    	
                                    	if(i == 0){
                                    		formWindow.down('#dependentFldTypeId').setValue(dependentFieldInformation.dependentFieldType);
    	        							formWindow.down('#dependentFldNameId').setValue(dependentFieldInformation.dependentFieldName);
    	        							formWindow.down('#dependentFldId').setValue(dependentFieldInformation.id);
    	        							
    	        							if(isView){
    	        								formWindow.down('#dependentFldNameId').setReadOnly(true)
                                        		formWindow.down('#dependentFldTypeId').setReadOnly(true);
    	        								formWindow.down('#addDetailedBtn').disable();
                                        		
                                    		}else{
                                    			formWindow.down('#dependentFldNameId').setReadOnly(false)
                                        		formWindow.down('#dependentFldTypeId').setReadOnly(false);
                                    		}
                                    	}
                                    	else{
                                    		var fldCont = $this.addMultipleDependentField(formWindow,dependentFieldInformation,isView); 
                                    		fldCont.items.items[i].down('#dependentFldTypeId').setValue(dependentFieldInformation.dependentFieldType);
                                    		fldCont.items.items[i].down('#dependentFldNameId').setValue(dependentFieldInformation.dependentFieldName)
                                    		fldCont.items.items[i].down('#dependentFldId').setValue(dependentFieldInformation.id); 
                                    		if(isView){
                                    			fldCont.items.items[i].down('#dependentFldTypeId').setReadOnly(true);
                                        		fldCont.items.items[i].down('#dependentFldNameId').setReadOnly(true)
                                        		
                                        		
                                    		}else{
                                    			fldCont.items.items[i].down('#dependentFldTypeId').setReadOnly(false);
                                        		fldCont.items.items[i].down('#dependentFldNameId').setReadOnly(false)
                                        		
                                    		}
                                    	}
	        							i++;
	        						});
								}
							
							}
						}
					});
				
			} else {
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			}

     },
     saveExamConcessionFormValue :function(btn) {
    	 btn.isClicked = true;
    	 btn.setDisabled(true);
    	 var form = this.getAddexamconcessionform();
    	 var concessionWin =form.up('addexamconcessionwin');
    	 var concessionGrid = this.getExamconcessiongrid();
    	 var concessionStatus =form.down('#examConcessionStatusId');
    	 var formValue =form.getForm().getValues();
    	 var dependentFldPanel =form.down('#dependentfieldPanelId');
    	 var panelFldLength =dependentFldPanel.items.items.length;
    	 var json = {};
    	 var dependentFldTypeArray =[];
    	 if(concessionStatus.hidden){
    		 var concessionStatus = "ACTIVE"
    	 }
    	 else{
    		 concessionStatus =formValue.examConcessionStatus
    	 }
    	 json = {
				 id : formValue.examConcessionId,
    			 examConcessionCode : formValue.examConcessionCode,
    			 examConcessionName : formValue.examConcessionName,
    			 status :  concessionStatus,
    			 dependentFieldRequired :formValue.dependentFieldRequired
    	 }
    	 if(panelFldLength > 1 && formValue.dependentFieldRequired) {
    		 for(var i=0; i< panelFldLength;i++ ){
         		 var obj = new Object();
         		  obj.id = formValue.dependentFldId[i],
         		  obj.dependentFieldName  = formValue.dependentFieldName[i],
         		  obj.dependentFieldType = formValue.dependentFieldType[i],
         		  obj.examConcessionId = formValue.examConcessionId,
         		 
         		 dependentFldTypeArray.push(obj);
         	}
    	 }
    	 else if(formValue.dependentFieldRequired && panelFldLength == 1 ) {
    		 var obj = new Object();
    		 obj.dependentFieldName  = formValue.dependentFieldName,
    		  obj.dependentFieldType = formValue.dependentFieldType,
    		  obj.id = formValue.dependentFldId,
    		  obj.examConcessionId = formValue.examConcessionId,
    		 dependentFldTypeArray.push(obj);
    	 }
    	 else if(!formValue.dependentFieldRequired) {
    		 dependentFldTypeArray =[];
    	 }
    	 json.wsExamConcessionDependentField = dependentFldTypeArray;
    	 var jsonDataEncode = Ext.encode(json);
    	 Ext.Ajax.request({
           	type: 'rest',
           	url: SERVERURL.PATH_EXAM_CONCESSION_CREATE_OR_UPDATE,
           	jsonData: jsonDataEncode,
           	method: 'POST',
            	success : function(response, action) {
            		btn.isClicked = false;
            		
            		if(response.responseText == "NOT_UNIQUE_EXAMCONCESSION_CODE") {
            			showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('NOT_UNIQUE_EXAMCONCESSION_CODE'));
            			btn.setDisabled(false); 
            			return false;
             				
            		}else if(response.responseText == "NOT_UNIQUE_EXAMCONCESSION_NAME") {
            			showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('NOT_UNIQUE_EXAMCONCESSION_NAME'));
            			btn.setDisabled(false); 
            			return false;
             				
            		}else if(response.responseText == "DUPLICATE_FIELD_NAME") {
            			showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('DUPLICATE_FIELD_NAME'));
            			btn.setDisabled(false); 
            			return false;
             				
            		}else{
            			 Ext.getBody().unmask();
      				   concessionWin.close();
      				   showSuccessMessage(getExaminationTranslation('EXAM_CONCESSION'), getExaminationTranslation('EXAM_CONCESSION_ADDED_SUCCESSFULLY'));
      				   concessionGrid.getStore().load();
      				 concessionGrid.getSelectionModel().deselectAll();
      				  
            		  }				   
                 	}				    
            	 });
     },
	disableToolbarButtonByPivileges :function(gridReference, permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var btnAdd = gridReference.down('#btnAdd');
		var btnEdit = gridReference.down('#btnEdit');
		var btnView = gridReference.down('#btnView');
		var btnDelete = gridReference.down('#btnDelete');
		var btnApplyTo =gridReference.down('#btnApplyTo');
		var exportPdfBtn = gridReference.down('#btnExportToPDF');
		var exportExcelbtn = gridReference.down('#btnExportToExcel');
		
		 btnAdd.setVisible(false);
	     btnEdit.setVisible(false);
	     btnView.setVisible(false);
	     btnDelete.setVisible(false);
	     btnApplyTo.setVisible(false);
		 exportPdfBtn.setVisible(false);
		 exportExcelbtn.setVisible(false);
		 exportPdfBtn.disable();
		 exportExcelbtn.disable();
		 
		 
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'CREATE') {
				if (!isNullOrEmpty(btnAdd)) {
					btnAdd.setVisible(true);
				}
			}
			if (privilege === 'UPDATE') {
				if (!isNullOrEmpty(btnEdit)) {
					btnEdit.setVisible(true);
				}
			}
			if (privilege === 'VIEW') {
				if (!isNullOrEmpty(btnView)) {
					btnView.setVisible(true);
				}
			}
			if (privilege === 'DELETE') {
				if (!isNullOrEmpty(btnDelete)) {
					btnDelete.setVisible(true);
				}
			}
			if (privilege === 'APPLY') {
				if (!isNullOrEmpty(btnApplyTo)) {
					btnApplyTo.setVisible(true);
				}
			}
			
			else if (privilege === 'EXPORT') {
				var buttonsArray = new Array();
        		buttonsArray.push( gridReference.down('#btnExportToPDF'));        		
        		buttonsArray.push(gridReference.down('#btnExportToExcel'));
        	    Ext.each(buttonsArray, function(button) {
        			if(!isNullOrEmpty(button)){
            			button.setVisible(true);
            		}  
        		});
			}
		});
	},
	
	saveAllMappings: function(formData){
		var me = this;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_SAVE_BATCH_MAPPING_EXAM_CONCESSION,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				var responseJson = Ext.decode(response.responseText);
				if(true){
					showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('EXAM_CONCESSION_MAPPED_SUCCESS_MSG'));	
					try{ 
						me.getContentPanel().getActiveTab().close();
						me.getExamconcessionapplytostructure().down('grid').getStore().loadPage(1);
					}
					catch(e){}
				}
				/*else if(responseJson.length>0){
					
					var notMappedArray = []; 
					Ext.each(responseJson, function(currentRecord){
						if(currentRecord.examConcessionId==me.getContentPanel().getActiveTab().down('examconcessionaddmappingstructure').examConcessionId){
							notMappedArray.push(currentRecord);
						}
					});
					
					if(notMappedArray.length==0){
						showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('EXAM_CONCESSION_ALREADY_MAPPED_MSG'));	
						try{
							me.getContentPanel().getActiveTab().close();
							me.getExamconcessionapplytostructure().down('grid').getStore().loadPage(1);
						}
						catch(e){}
					}
					else{
						var responseJson = notMappedArray; 
						var messageText = getExaminationTranslation('OTHER_EXAM_CONCESSION_ALREADY_MAPPED_WITH_THE_FOLLOWING_PROGRAMS_AND_BATCHES');
						messageText = messageText + "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
						Ext.each(responseJson, function(currentBatchDetail){
							messageText = messageText+currentBatchDetail.programName+" and "+currentBatchDetail.batchName+"<br />";
						});
						messageText = messageText+"</p><br />"+getExaminationTranslation('DO_YOU_STILL_WANT_TO_MAP_THE_EXAM_CONCESSION');

						var newFormData = [];
						Ext.each(responseJson, function(currentRecord){
							newFormData.push({
								examConcessionId:me.getContentPanel().getActiveTab().down('examconcessionaddmappingstructure').examConcessionId,
								academyLocationId:currentRecord.academyLocationId,
								programId:currentRecord.programId,
								batchId:currentRecord.batchId,
								id:currentRecord.id,
								examConcessionName:me.getContentPanel().getActiveTab().down('examconcessionaddmappingstructure').examConcessionName,
							});
						});

						showConfirmMessage(getCommonTranslation('APPLY_TO'),messageText, function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_FIND_ALL_EXAM_CONCESSION_BATCH_MAPPING_UPDATEALLBATCHMAPPING,
									jsonData: newFormData,
									method: 'POST',
									success: function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('EXAM_CONCESSION_MAPPED_SUCCESS_MSG'));	
										try{
											me.getContentPanel().getActiveTab().close();
											me.getExamconcessionapplytostructure().down('grid').getStore().loadPage(1);
										}
										catch(e){}
									}
								});
							}
							else{
								Ext.getBody().unmask();
								//showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));	
								try{
									me.getContentPanel().getActiveTab().close();
									me.getExamconcessionapplytostructure().down('grid').getStore().loadPage(1);
								}
								catch(e){}
							}
						});
					}
				}*/
				else{
					showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
				}
			},
			failure: function(response){
				console.log(response);
			}
		});
	},
	});