/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.examination.ExamConcessionStaffAllocationController', {
    extend: 'Academia.controller.base.BaseController',
    alias: 'widget.examConcessionStaffAllocationController',
    stores: [
        'common.AcademicTermStore',
        'examinationcenters.assessmentEvent.ManageAssessmentSchemeStore',
        'attendance.VariantMappedToSpecialGrade',
        'manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore',
        'examinationcenters.manageEvaluation.AssesmentEventStore',
        'examinationcenters.assessmentEvent.ManageAssessmentCoursesStore',
        'examinationcenters.assessmentEvent.ManageAssessmentStatusStore',
        'exam.examConcessionStaffAllocation.RequestTypeStore',
        'exam.examConcessionStaffAllocation.StudentStore',
        'exam.examConcessionStaffAllocation.ExamConcessionStaffAllocationGridStore'
    ],
    views: [
        'examinationcenters.assessmentEvent.ExamConcessionStaffAllocationStructure',
        'examinationcenters.assessmentEvent.ExamConcessionStaffAllocationFilter',
        'examinationcenters.assessmentEvent.ExamConcessionStaffAllocationGrid'
    ],
    model: [
        'common.IdValueCodeDataModel',
        'examinationcenters.remark.EvaluationLevelByEvalPlanModel'
    ],
    requires: [],
    refs: [{
        ref: 'examConcessionStaffAllocationFilter',
        selector: 'examConcessionStaffAllocationFilter'
    }, {
        ref: 'examConcessionStaffAllocationGrid',
        selector: 'examConcessionStaffAllocationGrid'
    }],
    config: {
        EXAM_CONCESSION_STAFF_ALLOCATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_CONCESSION_STAFF_ALLOCATION_PRIVILEGE')
    },
    init: function () {
        this.control({
            'examConcessionStaffAllocationFilter button[itemId=resetBtn]': {
                click: this.doResetexamConcessionStaffAllocationFilter
            },
            'examConcessionStaffAllocationGrid': {
                render: this.onExamConcessionStaffAllocationGridRender,
                selectionchange: this.onGridSelectionChange
            },
            'examConcessionStaffAllocationFilter customcombobox[itemId=assessmentSchemeAcademicTermExamConcessionStaffAllocation]': {
                change: this.onAcademicTermSelect
            },
            'examConcessionStaffAllocationFilter multiselectcombofield[itemId=assesmentSchemeIdExamConcessionStaffAllocation]': {
                change: this.onSchemeSelect
            },
            'examConcessionStaffAllocationFilter multiselectcombofield[itemId=courseManageItemIdExamConcessionStaffAllocation]': {
                change: this.onCourseSelect
            },
            'examConcessionStaffAllocationFilter groupingcombobox[itemId=evaluationLevelNameExamConcessionStaffAllocation]': {
                select: this.onEvalLevelSelect
            },
            'examConcessionStaffAllocationFilter button[itemId=searchBtnId]': {
                click: this.serachExamConcessionStaffAllocation
            },
            'examConcessionStaffAllocationFilter multiselectcombofield[itemId=detailSequenceItemIdExamConcessionStaffAllocation]': {
                change: this.onEventSelect
            },
            'examConcessionStaffAllocationFilter customcombobox[itemId=requestTypeExamConcessionStaffAllocation]': {
                select: this.onRequestTypeSelect
            },
            'examConcessionStaffAllocationStructure': {
            	afterrender: this.onStructureRender
            },
            'examConcessionStaffAllocationFilter customcombobox[itemId=administrativeByExamConcessionStaffAllocation]':{
            	select: this.onAdministrativeBySelect
            },
            'examConcessionStaffAllocationGrid button[itemId=deleteBtnId]': {
            	click: this.deleteConcessionAllocation
            },
            'examConcessionStaffAllocationGrid button[itemId=publishBtnId]': {
                click: this.publishTimetable
            },
            'examConcessionStaffAllocationFilter datefield[itemId=fromdateExamConcessionStaffAllocation]': {
            	change: this.onFromDateChange
            },
            'examConcessionStaffAllocationFilter datefield[itemId=tilldateExamConcessionStaffAllocation]': {
            	change: this.onTillDateChange
            }
        })
    },

    doResetexamConcessionStaffAllocationFilter: function (btn) {
        btn.up('form').getForm().reset();
        var form = btn.up('form');
        var scheme = form.down('#assesmentSchemeIdExamConcessionStaffAllocation');
        scheme.clearValue();
        scheme.disable();

        var course = form.down('#courseManageItemIdExamConcessionStaffAllocation');
        course.clearValue();
        course.disable();

        var fromDate = form.down('#fromdateExamConcessionStaffAllocation');
        fromDate.disable();

        var toDate = form.down('#tilldateExamConcessionStaffAllocation');
        toDate.disable();

        /*var level = form.down('#evaluationLevelNameExamConcessionStaffAllocation');
        level.disable();*/

        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.clearValue();
        event.disable();
        
        var academicTerm = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation');
        academicTerm.reset();
        academicTerm.disable();

        var requestCategory = form.down('#requestCategoryExamConcessionStaffAllocation');
        requestCategory.disable();

        var requestType = form.down('#requestTypeExamConcessionStaffAllocation');
        requestType.disable();

        var externalRef = form.down('#externalRef');
        externalRef.disable();
    },

    onExamConcessionStaffAllocationGridRender: function (grid) {
        grid.down('#deleteBtnId').setVisible(false);
        grid.down('#publishBtnId').setVisible(false);
        grid.down('#btnExportToPDF').setVisible(false);
        grid.down('#btnExportToExcel').setVisible(false);
        var permissionsMap = this.getEXAM_CONCESSION_STAFF_ALLOCATION_PERMISSION();
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        if (permissionList.indexOf('DELETE') != -1) {
            grid.down('#deleteBtnId').setVisible(true);
        }
        if (permissionList.indexOf('PUBLISH_TIMETABLE') != -1) {
            grid.down('#publishBtnId').setVisible(true);
        }
        if (permissionList.indexOf('EXPORT') != -1) {
            grid.down('#btnExportToPDF').setVisible(true);
            grid.down('#btnExportToExcel').setVisible(true);
        }
        if(permissionList.indexOf('GRID_CONFIGURATION') != -1) {
        	var concessionGridConfigBtnRunner = new Ext.util.TaskRunner();
        	var task = concessionGridConfigBtnRunner.start({
        		run: function() {
        			var columnBtn = grid.getHeader().query('button[text='+getCommonTranslation('COLUMNS')+']')[0];
        			if(columnBtn) {
        				columnBtn.show();
        				concessionGridConfigBtnRunner.destroy();
        			}
        		},
        		interval: 1000
        	});
        }
        var structure = grid.up('examConcessionStaffAllocationStructure');
        this.getGridHeaderFreezeForConcessionNonConcession(grid, structure);
        grid.getStore().removeAll();
    },

    onAcademicTermSelect: function (cmp, record) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var scheme = form.down('#assesmentSchemeIdExamConcessionStaffAllocation');
        scheme.reset();
        scheme.clearValue();
        if(isNullOrEmpty(cmp.getValue())) {
    		return;
    	}
        scheme.enable();
        var schemeStore = scheme.getStore();
        schemeStore.getProxy().extraParams = {
            academicTermId: cmp.getValue(),
            whetherDynamicScheme: true,
            administrativeBy: vals.administrativeBy
        };
        schemeStore.load();

        var course = form.down('#courseManageItemIdExamConcessionStaffAllocation');
        course.reset();
        course.clearValue();
        course.disable();

        var fromDate = form.down('#fromdateExamConcessionStaffAllocation');
        fromDate.reset();
        fromDate.disable();

        var toDate = form.down('#tilldateExamConcessionStaffAllocation');
        toDate.reset();
        toDate.disable();

        /*var level = form.down('#evaluationLevelNameExamConcessionStaffAllocation');
        level.reset();
        level.disable();*/

        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        event.disable();

        var requestCategory = form.down('#requestCategoryExamConcessionStaffAllocation');
        event.reset();
        requestCategory.disable();

        var requestType = form.down('#requestTypeExamConcessionStaffAllocation');
        event.reset();
        requestType.disable();

        var externalRef = form.down('#externalRef');
        event.reset();
        externalRef.disable();
    },

    onSchemeSelect: function (cmp, record) {
        var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        var academicTermRoomAndStaffAllocation = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation'),
            course = form.down('#courseManageItemIdExamConcessionStaffAllocation');
        course.reset();
        course.clearValue();
        course.enable();
        var courseStore = course.getStore();
        courseStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: academicTermRoomAndStaffAllocation.getValue(),
            administrativeBy: vals.administrativeBy
        };
        courseStore.load();

        var fromDate = form.down('#fromdateExamConcessionStaffAllocation');
        fromDate.reset();
        fromDate.enable();

        var toDate = form.down('#tilldateExamConcessionStaffAllocation');
        toDate.reset();
        toDate.enable();

        /*var level = form.down('#evaluationLevelNameExamConcessionStaffAllocation');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            evaluationPlanId: cmp.getValue(),
            administrativeBy: vals.administrativeBy
        };
        levelStore.load();*/

        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        event.enable();
        var eventStore = event.getStore();
        eventStore.getProxy().extraParams = {
        	academicTermId: vals.assessmentSchemeAcademicTerm,
        	evaluationPlanIds: schemeIds,
            administrativeBy: vals.administrativeBy
        };
        eventStore.load();
        
        var reqCategory =  form.down('#requestCategoryExamConcessionStaffAllocation');
        reqCategory.reset();
        reqCategory.enable();
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: '',
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	evaluationPlanLevelOneId: null,
        	evaluationPlanLevelTwoId: null,
        	evaluationSequenceId: null,
        	eventIds: '',
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
        if(vals.assesmentScheme && vals.assesmentScheme.length == 0) {
        	course.disable();
        	event.disable();
        	fromDate.disable();
        	toDate.disable();
        	reqCategory.disable();
        	reqType.disable();
        	externalRef.disable();
        }
    },

    onCourseSelect: function (cmp, record) {
        var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        var fromDate = form.down('#fromdateExamConcessionStaffAllocation');
        fromDate.reset();
        fromDate.enable();

        var toDate = form.down('#tilldateExamConcessionStaffAllocation');
        toDate.reset();
        toDate.enable();
        var academicTerm = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation');
        var assesmentScheme = form.down('#assesmentSchemeIdExamConcessionStaffAllocation');
        /*var level = form.down('#evaluationLevelNameExamConcessionStaffAllocation');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            academicTermId: academicTerm.getValue(),
            evaluationPlanId: assesmentScheme.getValue(),
            administrativeBy: vals.administrativeBy
        };
        levelStore.load();*/
        
        var reqCategory =  form.down('#requestCategoryExamConcessionStaffAllocation');
        reqCategory.reset();
        reqCategory.enable();
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	evaluationPlanLevelOneId: null,
        	evaluationPlanLevelTwoId: null,
        	evaluationSequenceId: null,
        	eventIds: '',
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        var eventStore = event.getStore();
        eventStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: academicTerm.getValue(),
            administrativeBy: vals.administrativeBy,
            courseIds: courseIds
        };
        eventStore.load();
    },

    onEvalLevelSelect: function (cmp, record) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        var administrativeBy = form.down('#administrativeByExamConcessionStaffAllocation');
        var academicTerm = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        event.enable();
        var eventStore = event.getStore();
        var levelOneId = null;
        var levelTwoId = null;
        var levelThreeId = null;
        if (!isNullOrEmpty(record[0].data.code)) {
            if (record[0].data.code == "Assessment Method") {
                levelThreeId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Sub Type") {
                levelTwoId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Type") {
                levelOneId = record[0].data.levelId;
            }
        }
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        eventStore.getProxy().extraParams = {
            evalPlanId: vals.assesmentScheme,
            academicTermId: academicTerm.getValue(),
            evaluationPlanLevelOneId: levelOneId,
            evaluationPlanLevelTwoId: levelTwoId,
            evaluationSequenceId: levelThreeId,
            administrativeBy: vals.administrativeBy,
            courseIds: courseIds
        };
        eventStore.load();
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanId: vals.assesmentScheme,
        	courseIds: '',
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	evaluationPlanLevelOneId: levelOneId,
        	evaluationPlanLevelTwoId: levelTwoId,
        	evaluationSequenceId: levelThreeId,
        	eventIds: '',
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
    },

    serachExamConcessionStaffAllocation: function (btn) {
        btn.setDisabled(true);
        var me = this,
            form = btn.up('form'),
            grid = me.getExamConcessionStaffAllocationGrid(),
            //record = form.down('#evaluationLevelNameExamConcessionStaffAllocation').lastSelection,
            reqType = form.down('#requestTypeExamConcessionStaffAllocation').lastSelection,
            val = form.getValues();
        
        if(val.assesmentScheme && val.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(val.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = val.assesmentScheme.join();
			}
		}else if(val.assesmentScheme){
			var schemeIds = val.assesmentScheme;
		}
        
        /*var levelOneId = null;
        var levelTwoId = null;
        var levelThreeId = null;
        if (record && record[0] && !isNullOrEmpty(record[0].data.code)) {
            if (record[0].data.code == "Assessment Method") {
                levelThreeId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Sub Type") {
                levelTwoId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Type") {
                levelOneId = record[0].data.levelId;
            }
        }*/
        if (val.courseManageItem && val.courseManageItem.length > 0) {
            try {
                var courseIds = Ext.Array.pluck(Ext.Array.pluck(val.courseManageItem, 'data'), 'id').join();
            } catch (e) {
                var courseIds = val.courseManageItem.join();
            }
        } else if (val.courseManageItem) {
            var courseIds = val.courseManageItem;
        }

        if (val.detailSequence && val.detailSequence.length > 0) {
            try {
                var eventIds = Ext.Array.pluck(Ext.Array.pluck(val.detailSequence, 'data'), 'id').join();
            } catch (e) {
                var eventIds = val.detailSequence.join();
            }
        } else if (val.detailSequence) {
            var eventIds = val.detailSequence;
        }
        grid.getStore().getProxy().extraParams = {
        	academicTermId: val.assessmentSchemeAcademicTerm,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
            fromDate: val.fromdate,
            toDate: val.tilldate,
            administeredBy: val.administrativeBy,
            //evaluationPlanLevelOneId: levelOneId,
            //evaluationPlanLevelTwoId: levelTwoId,
            //evaluationSequenceId: levelThreeId,
            eventIds: eventIds,
            requestTypeId: reqType[0] ? reqType[0].get('id') : null,
            admissionId: val.externalRef,
            //dependentFieldId: reqType[0] ? reqType[0].get('secondId') : null,
            dependentFieldName: reqType[0] ? reqType[0].get('secondValue') : null
        };
        this.resetPageSetting(grid.getStore(), grid);
    	grid.getStore().pageSize = 100;
        grid.getStore().load();
        grid.getSelectionModel().deselectAll();
        Ext.defer(function () {
            btn.setDisabled(false);
        }, 1000);
    },
    
    onEventSelect: function (cmp, record) {
        var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        var administrativeBy = form.down('#administrativeByExamConcessionStaffAllocation');
        var academicTerm = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation');
        /*var record =form.down('#evaluationLevelNameExamConcessionStaffAllocation').lastSelection;
        var levelOneId=null;
	    var levelTwoId=null;
	    var levelThreeId=null;
	    if(record && record[0] && !isNullOrEmpty(record[0].data.code)){
		   if(record[0].data.code=="Assessment Method"){
			   levelThreeId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Sub Type"){
			   levelTwoId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Type"){
			   levelOneId=record[0].data.levelId;
		   }
	    }*/
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        
        if(vals.detailSequence && vals.detailSequence.length > 0){
			try{
				var eventIds = Ext.Array.pluck(Ext.Array.pluck(vals.detailSequence, 'data'), 'id').join();
			} catch(e) {
				var eventIds = vals.detailSequence.join();
			}
		}else if(vals.detailSequence){
			var eventIds = vals.detailSequence;
		}
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	//evaluationPlanLevelOneId: levelOneId,
        	//evaluationPlanLevelTwoId: levelTwoId,
        	//evaluationSequenceId: levelThreeId,
        	eventIds: eventIds,
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
    },
    
    onRequestTypeSelect: function(cmp, rec) {
    	var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        /*var record =form.down('#evaluationLevelNameExamConcessionStaffAllocation').lastSelection;
        var levelOneId=null;
	    var levelTwoId=null;
	    var levelThreeId=null;
	    if(record && record[0] && !isNullOrEmpty(record[0].data.code)){
		   if(record[0].data.code=="Assessment Method"){
			   levelThreeId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Sub Type"){
			   levelTwoId=record[0].data.levelId;
		   }else if(record[0].data.code=="Assessment Type"){
			   levelOneId=record[0].data.levelId;
		   }
	    }*/
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        
        if(vals.detailSequence && vals.detailSequence.length > 0){
			try{
				var eventIds = Ext.Array.pluck(Ext.Array.pluck(vals.detailSequence, 'data'), 'id').join();
			} catch(e) {
				var eventIds = vals.detailSequence.join();
			}
		}else if(vals.detailSequence){
			var eventIds = vals.detailSequence;
		}
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        var reqType = form.down('#requestTypeExamConcessionStaffAllocation');
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	//evaluationPlanLevelOneId: levelOneId,
        	//evaluationPlanLevelTwoId: levelTwoId,
        	//evaluationSequenceId: levelThreeId,
        	eventIds: eventIds,
        	requestCategory: vals.requestCategory,
        	concessionid: rec[0].get('id'),
        	//concessionid: rec[0].get('id'),
        	//dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null,
        	dependentFieldName: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondValue') : null
        };
        externalRefStore.load();
    },
    
    onStructureRender: function(structure) {
		Ext.defer(function() {
			try {
    			structure.body.on('scroll', function() {
					if(Ext.query('.x-boundlist:visible').length) {
						var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
						if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse){
							boundListCombo.collapse();
						}
					}
				});
			}
			catch(e) {}
		}, 1000);
	},
	
	onAdministrativeBySelect: function(cmp, rec) {
		var form = cmp.up('form');
        var scheme = form.down('#assesmentSchemeIdExamConcessionStaffAllocation');
        scheme.reset();
        scheme.clearValue();
    	scheme.disable();
    	
    	var course = form.down('#courseManageItemIdExamConcessionStaffAllocation');
    	course.clearValue();
    	course.disable();
    	
    	var fromDate = form.down('#fromdateExamConcessionStaffAllocation');
    	fromDate.disable();
    	
    	var toDate = form.down('#tilldateExamConcessionStaffAllocation');
    	toDate.disable();
    	
    	/*var level = form.down('#evaluationLevelNameExamConcessionStaffAllocation');
    	level.disable();*/
    	
    	var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
    	event.clearValue();
    	event.disable();
    	
    	var academicTerm = form.down('#assessmentSchemeAcademicTermExamConcessionStaffAllocation');
    	academicTerm.reset();
    	academicTerm.enable();
    	academicTerm.getStore().load({
		    callback: function(records, operation, success) {
		    	records.forEach(function(rec){
		    		if(rec.data.whetherCurrentAcademicTerm){
		    			academicTerm.setValue(rec.data.id);
		    		}
		    	});
		    }
		});
	},
	
	deleteConcessionAllocation: function(btn) {
		var grid = btn.up('grid');
		var selection = grid.getSelectionModel().getSelection();
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var ids = [];
		for(var i = 0; i < selection.length; i++) {
			ids.push(selection[i].get('id'));
    	}
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_DELETE_CONCESSION_ALLOCATION + '?ids=' + ids.join(),
			method : 'DELETE',
			success : function(frm, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getExaminationTranslation('EXAM_CONCESSION_STAFF_ALLOCATION'), getExaminationTranslation('BUSINESS_RULE_DELETED_SUCCESSFULLY'));
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
			}
		});
	},
	
	publishTimetable: function(btn) {
		var grid = btn.up('grid');
		var selection = grid.getSelectionModel().getSelection();
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var data = [];
    	for(var i = 0; i < selection.length; i++) {
    		data.push(selection[i].get('id'));
    	}
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_PUBLISH_CONCESSION + '?resultResourceMappingIds=' + data.join(),
			jsonData: data,
			method : 'PUT',
			success : function(frm, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getExaminationTranslation('EXAM_CONCESSION_STAFF_ALLOCATION'), getExaminationTranslation('TIMETABLE_PUBLISH_SUCCESS'));
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
			}
		});
	},
	
	onGridSelectionChange: function(sm, selected) {
    	var deleteBtn = sm.view.up('grid').down('#deleteBtnId');
    	var publishBtn = sm.view.up('grid').down('#publishBtnId');
    	if(selected.length) {
    		deleteBtn.enable();
    		publishBtn.enable();
    	}
    	else {
    		deleteBtn.disable();
    		publishBtn.disable();
    	}
    },
    
    onFromDateChange: function(cmp) {
    	var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	evaluationPlanLevelOneId: null,
        	evaluationPlanLevelTwoId: null,
        	evaluationSequenceId: null,
        	eventIds: '',
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        var eventStore = event.getStore();
        eventStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: vals.assessmentSchemeAcademicTerm,
            administrativeBy: vals.administrativeBy,
            courseIds: courseIds,
            fromDate: vals.fromdate,
            toDate: vals.tilldate
        };
        eventStore.load();
    },
    
    onTillDateChange: function(cmp) {
    	var form = cmp.up('form');
        var vals = form.getValues();
        
        if(vals.assesmentScheme && vals.assesmentScheme.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.assesmentScheme, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.assesmentScheme.join();
			}
		}else if(vals.assesmentScheme){
			var schemeIds = vals.assesmentScheme;
		}
        
        var reqType =  form.down('#requestTypeExamConcessionStaffAllocation');
        reqType.reset();
        reqType.enable();
        var reqTypeStore = reqType.getStore();
        reqTypeStore.getProxy().extraParams = {
        	category: 'Exam Consession'
        };
        reqTypeStore.load();
        
        var externalRef =  form.down('#externalRef');
        externalRef.reset();
        externalRef.enable();
        var externalRefStore = externalRef.getStore();
        
        if(vals.courseManageItem && vals.courseManageItem.length > 0){
			try{
				var courseIds = Ext.Array.pluck(Ext.Array.pluck(vals.courseManageItem, 'data'), 'id').join();
			} catch(e) {
				var courseIds = vals.courseManageItem.join();
			}
		}else if(vals.courseManageItem){
			var courseIds = vals.courseManageItem;
		}
        
        externalRefStore.getProxy().extraParams = {
        	administrativeBy: vals.administrativeBy,
        	evaluationPlanIds: schemeIds,
        	courseIds: courseIds,
        	fromDate: vals.fromdate,
        	toDate: vals.tilldate,
        	evaluationPlanLevelOneId: null,
        	evaluationPlanLevelTwoId: null,
        	evaluationSequenceId: null,
        	eventIds: '',
        	requestCategory: vals.requestCategory,
        	concessionid: vals.requestType,
        	dependentFieldId: reqType.lastSelection[0] ? reqType.lastSelection[0].get('secondId') : null
        };
        externalRefStore.load();
        var event = form.down('#detailSequenceItemIdExamConcessionStaffAllocation');
        event.reset();
        event.clearValue();
        var eventStore = event.getStore();
        eventStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: vals.assessmentSchemeAcademicTerm,
            administrativeBy: vals.administrativeBy,
            courseIds: courseIds,
            fromDate: vals.fromdate,
            toDate: vals.tilldate
        };
        eventStore.load();
    }
});