/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.examination.ImportPreExamDetailController', {
    extend: 'Academia.controller.base.BaseController',
    alias: 'widget.importPreExamDetailController',
    stores: [
        'importutility.ModuleName',
        'common.AcademicTermStore',
        'examinationcenters.preExamDetails.EvalPlanStore',
        'examinationcenters.preExamDetails.CoursesStore',
        'examinationcenters.preExamDetails.EvalPlanLevels',
        'examinationcenters.preExamDetails.EventsStore',
        'examinationcenters.preExamDetails.ImportPreExamDetailGridStore'
    ],
    views: [
        'examinationcenters.assessmentEvent.ImportPreExamDetailStructure',
        'examinationcenters.preExamDetail.UploadPreExamDetailFilter',
        'examinationcenters.assessmentEvent.DownloadPreExamDetailFilter',
        'examinationcenters.preExamDetail.ImportPreExamDetailGrid'
    ],
    model: [
        'importutility.ModuleName',
        'common.IdValueCodeDataModel',
        'importutility.ImportUtilityDataModel'
    ],
    requires: [],
    refs: [{
    	ref: 'importPreExamDetailStructure',
    	selector: 'importPreExamDetailStructure'
    }, {
        ref: 'uploadPreExamDetailFilter',
        selector: 'uploadPreExamDetailFilter'
    }, {
        ref: 'downloadPreExamDetailFilter',
        selector: 'downloadPreExamDetailFilter'
    }, {
        ref: 'importPreExamDetailGrid',
        selector: 'importPreExamDetailGrid'
    }],
    config: {
        ROOM_AND_STAFF_ALLOCATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ROOM_AND_STAFF_ALLOCATION_PRIVILEGE')
    },
    init: function () {
        this.control({
            'importPreExamDetailStructure radiogroup[itemId=importPreExamDetailGroupId]': {
                change: this.importPreExamDetailGroupChange
            },
            'uploadPreExamDetailFilter customcombobox[itemId=uploadTemplateForItemId]': {
                select: this.onTemplateForChange
            },
            'uploadPreExamDetailFilter button[itemId=preExamDetailUpload]': {
                click: this.uploadPreExamDetailData
            },
            'downloadPreExamDetailFilter': {
                afterrender: this.onDownloadPreExamDetailFilterRender
            },
            'uploadPreExamDetailFilter customcombobox[itemId=preExamDetailAcademicTermId]': {
                select: this.onPreExamDetailAcademicTermSelect
            },
            'uploadPreExamDetailFilter multiselectcombofield[itemId=preExamDetailAssesmentSchemeId]': {
                change: this.onPreExamDetailAssesmentSchemeSelect
            },
            'uploadPreExamDetailFilter multiselectcombofield[itemId=preExamDetailCourseItemId]': {
                change: this.onPreExamDetailCourseChange
            },
            'uploadPreExamDetailFilter groupingcombobox[itemId=preExamDetailEvaluationLevelNameId]': {
                select: this.onPreExamDetailEvalLevelSelect
            },
            'uploadPreExamDetailFilter button[itemId=resetBtn]': {
                click: this.resetUploadPreExamDetailForm
            },
            'uploadPreExamDetailFilter multiselectcombofield[itemId=preExamDetailDetailSequenceItemId]': {
                change: this.onPreExamDetailEventChange
            },
            'downloadPreExamDetailFilter customcombobox[itemId=downloadTemplateForItemId]': {
                select: this.onDownoadTemplateForChange
            },
            'importPreExamDetailGrid button[itemId=btnForce]': {
                click: this.doForceRunPreExamDetailJob
            },
            'downloadPreExamDetailFilter customcombobox[itemId=downloadPreExamDetailAcademicTermId]': {
                select: this.onDownloadPreExamDetailAcademicTermSelect
            },
            'downloadPreExamDetailFilter multiselectcombofield[itemId=downloadPreExamDetailAssesmentSchemeId]': {
                change: this.onDownloadPreExamDetailAssesmentSchemeSelect
            },
            'downloadPreExamDetailFilter multiselectcombofield[itemId=downloadPreExamDetailCourseItemId]': {
                change: this.onDownloadPreExamDetailCourseChange
            },
            'downloadPreExamDetailFilter groupingcombobox[itemId=downloadPreExamDetailEvaluationLevelNameId]': {
                select: this.onDownloadPreExamDetailEvalLevelSelect
            },
            'downloadPreExamDetailFilter multiselectcombofield[itemId=downloadPreExamDetailDetailSequenceItemId]': {
                change: this.onDownloadPreExamDetailEventChange
            },
            'downloadPreExamDetailFilter button[itemId=preExamDetailDownload]': {
                click: this.getPreExamDetailDownload
            },
            'importPreExamDetailGrid': {
                cellclick: this.getDownloadLogFileForPreExamDetail
            },
            'downloadPreExamDetailFilter button[itemId=resetBtn]': {
                click: this.resetDownloadPreExamDetailForm
            },
            'downloadPreExamDetailFilter customcombobox[itemId=administrativeByRoomAndStaffAllocation]': {
                select: this.onDownloadPreExamDetailAdminBySelect
            },
            'downloadPreExamDetailFilter datefield[itemId=fromDateDownloadPreExam]': {
            	change: this.onFromDateChange
            },
            'downloadPreExamDetailFilter datefield[itemId=tillDateDownloadPreExam]': {
            	change: this.onTillDateChange
            }
        })
    },

    importPreExamDetailGroupChange: function (cmp, newVal, oldVal) {
        var form = cmp.up('form');
        var templateFor;
        var templateForStore;
        var uploadForm = this.getUploadPreExamDetailFilter();
        var downloadForm = this.getDownloadPreExamDetailFilter();
        var structure = this.getImportPreExamDetailStructure();

        uploadForm.getForm().reset();
        uploadForm.down('#preExamDetailDetailSequenceItemId').clearValue();
        uploadForm.down('#preExamDetailCourseItemId').clearValue();
        downloadForm.getForm().reset();
        if (newVal.downloadUploadTemplate == 'forUploadTemplate') {
            this.resetUploadPreExamDetailForm(uploadForm.down('#resetBtn'));
            templateFor = uploadForm.down('#uploadTemplateForItemId');
            templateFor.reset();
            templateForStore = templateFor.getStore();
            templateForStore.getProxy().extraParams = {};
            uploadForm.show();
            downloadForm.hide();
            templateFor = uploadForm.down('#uploadTemplateForItemId');
            templateForStore = templateFor.getStore();
            templateForStore.getProxy().extraParams = {
                isUpload: true
            };
            structure.down('#importPreExamDetailGridId').show();
        } else {
            this.resetUploadPreExamDetailForm(downloadForm.down('#resetBtn'));
            templateFor = downloadForm.down('#downloadTemplateForItemId');
            templateFor.reset();
            templateForStore = templateFor.getStore();
            templateForStore.getProxy().extraParams = {
                isUpload: false
            };
            downloadForm.show();
            uploadForm.hide();
            structure.down('#importPreExamDetailGridId').hide();
        }
    },

    onTemplateForChange: function (cmp, records) {
        var curVal = records[0].get('displayValue');
        var form = cmp.up('form');
        var moduleName = records[0].get('value');
        var combo = form.down('#moduleNamePreExamDetail');
        combo.getStore().load({
            callback: function (records, operation, success) {
                for (var i in records) {
                    if (records[i].data.value == moduleName) {
                        combo.setValue(records[i].data.id);
                        combo.setReadOnly(true);
                    }
                }
            }
        });
        var container1 = form.down('#container1');
        var container2 = form.down('#container2');
        //var container3 = form.down('#container3');
        var adminNote = form.down('#adminByNote');
        var invigilatorNote = form.down('#invigilatorNote');
        adminNote.hide();
        invigilatorNote.hide();
        if (curVal == getCommonTranslation('ImportAdministeredBy')) {
            container1.show();
            container1.enable();
            container2.show();
            container2.enable();
            //container3.show();
            //container3.enable();
            adminNote.show();
        } else if (curVal == getCommonTranslation('ImportInvigilators')) {
            invigilatorNote.show();
            container1.hide();
            container1.disable();
            container2.hide();
            container2.disable();
            //container3.hide();
            //container3.disable();
        } else {
            container1.hide();
            container1.disable();
            container2.hide();
            container2.disable();
            //container3.hide();
            //container3.disable();
        }
        var grid = this.getImportPreExamDetailGrid();
        var gridStore = grid.getStore();
        gridStore.getProxy().extraParams = {
            moduleName: records[0].get('value')
        };
        this.resetPageSetting(gridStore, grid);
        gridStore.pageSize = 100;
        gridStore.load();
        form.down('#uploadFileField').reset();
        form.down('#preExamDetailAcademicTermId').reset();
        form.down('#preExamDetailAssesmentSchemeId').reset();
        form.down('#preExamDetailAssesmentSchemeId').clearValue();
        form.down('#preExamDetailAssesmentSchemeId').disable();
        form.down('#preExamDetailCourseItemId').reset();
        form.down('#preExamDetailCourseItemId').clearValue();
        form.down('#preExamDetailCourseItemId').disable();
        form.down('#preExamDetailDetailSequenceItemId').reset();
        form.down('#preExamDetailDetailSequenceItemId').clearValue();
        form.down('#preExamDetailDetailSequenceItemId').disable();
        form.isValid();
        form.getForm().clearInvalid();
    },

    uploadPreExamDetailData: function (obj) {
        var $this = this;
        var grid = this.getImportPreExamDetailGrid();
        var form = this.getUploadPreExamDetailFilter();
        var vals = form.getValues();
        $this.getHashOfFile(form);
        var submitUrl;
        switch (vals.templateFor) {
        case getCommonTranslation('ImportAdministeredBy'):
            submitUrl = SERVERURL.PATH_CREATE_PRE_EXAM_DATA;
            break;
        case getCommonTranslation('ImportInvigilators'):
            submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
            break;
        case getCommonTranslation('ImportConcessionAllocation'):
	    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	break;
	    case getCommonTranslation('ImportNonConcessionAllocation'):
	    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	break;
        }
        setTimeout(function () {
            form.getForm().submit({
                method: 'POST',
                url: submitUrl,
                success: function (form, action) {
                    showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                    grid.getStore().load();
                    form.reset();
                    $this.resetUploadPreExamDetailForm($this.getUploadPreExamDetailFilter().down('#resetBtn'));
                },
                failure: function (form, action) {
                    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CONTENT_MISMATCH'));
                }
            });
        }, 1000);
    },

    onDownloadPreExamDetailFilterRender: function (form) {
        var academicTerm = form.down('#preExamDetailAcademicTermId');
        academicTerm.getStore().load();
    },

    onPreExamDetailAcademicTermSelect: function (cmp, records) {
        var form = cmp.up('form');
        var plan = form.down('#preExamDetailAssesmentSchemeId');
        plan.reset();
        plan.clearValue();
        plan.enable();
        var planStore = plan.getStore();
        planStore.getProxy().extraParams = {
            academicTermId: records[0].get('id'),
            whetherDynamicScheme: true
        };
        planStore.load();
        var course = form.down('#preExamDetailCourseItemId');
        course.reset();
        course.clearValue();
        course.disable();
        /*var level = form.down('#preExamDetailEvaluationLevelNameId');
        level.reset();
        level.disable();*/
        var event = form.down('#preExamDetailDetailSequenceItemId');
        event.reset();
        event.disable();
    },

    onPreExamDetailAssesmentSchemeSelect: function (cmp, records) {
        var form = cmp.up('form');
        var vals = form.getValues();
        if(vals.schemeId && vals.schemeId.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.schemeId.join();
			}
		}else if(val.schemeId){
			var schemeIds = vals.schemeId;
		}
        form.getForm().findField('assessmentSchemeId').setValue(schemeIds);
        var course = form.down('#preExamDetailCourseItemId');
        course.reset();
        course.clearValue();
        course.enable();
        var courseStore = course.getStore();
        courseStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: vals.academicTermId
        };
        courseStore.load();
        /*var level = form.down('#preExamDetailEvaluationLevelNameId');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            evaluationPlanId: vals.assessmentSchemeId
        };
        levelStore.load();*/
        var event = form.down('#preExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.enable();
        /*var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        var levelSelected = form.getForm().findField('assessmentLevelSelected');
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('3');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('2');
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('1');
            }
        }*/
        var eventStore = event.getStore();
        vals = form.getValues();
        var form = new FormData();
        form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
        /*if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }*/
        form.append('courseIds', vals.courseIds);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },

    onPreExamDetailCourseChange: function (cmp, nval, oval) {
        var form = cmp.up('form');
        var vals = form.getValues();
        /*var level = form.down('#preExamDetailEvaluationLevelNameId');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            evaluationPlanId: vals.assessmentSchemeId
        };
        levelStore.load();*/
        var event = form.down('#preExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.enable();
        var courseIds = [];
        for (var i = 0; i < vals.courseId.length; i++) {
            if (vals.courseId[i]) {
                if (isNaN(vals.courseId[i])) {
                    courseIds.push(vals.courseId[i].get('id'));
                } else {
                    courseIds.push(vals.courseId[i]);
                }
            }
        }
        form.getForm().findField('courseIds').setValue(courseIds.join());
        /*var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');;
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');;
            }
        }*/
        var eventStore = event.getStore();
        vals = form.getValues();
        if(vals.schemeId && vals.schemeId.length > 0){
			try{
				var schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				var schemeIds = vals.schemeId.join();
			}
		}else if(val.schemeId){
			var schemeIds = vals.schemeId;
		}
        var form = new FormData();
        form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
        /*if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }*/
        form.append('courseIds', vals.courseIds);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },

    onPreExamDetailEvalLevelSelect: function (cmp, records) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var event = form.down('#preExamDetailDetailSequenceItemId');
        var level = form.down('#preExamDetailEvaluationLevelNameId');
        var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        event.reset();
        event.enable();
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        var levelSelected = form.getForm().findField('assessmentLevelSelected');
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('3');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('2');
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('1');
            }
        }
        var eventStore = event.getStore();
        vals = form.getValues();
        var form = new FormData();
        form.append('evaluationPlanId', vals.assessmentSchemeId);
        form.append('academicTermId', vals.academicTermId);
        if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }
        form.append('courseIds', vals.courseIds);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },

    resetUploadPreExamDetailForm: function (btn) {
        var form = btn.up('form');
        form.getForm().reset();
        var idPart = 'p';
        if(form.xtype == 'downloadPreExamDetailFilter') {
        	idPart = 'downloadP';
        }
        form.down('#' + idPart + 'reExamDetailDetailSequenceItemId').clearValue();
        form.down('#' + idPart + 'reExamDetailCourseItemId').clearValue();
        form.down('#' + idPart + 'reExamDetailAssesmentSchemeId').clearValue();
        form.down('#container1').hide();
        form.down('#container2').hide();
        //form.down('#container3').hide();
        form.down('#' + idPart + 'reExamDetailAssesmentSchemeId').disable();
        form.down('#' + idPart + 'reExamDetailCourseItemId').disable();
        if(form.down('#' + idPart + 'reExamDetailEvaluationLevelNameId')) {
        	form.down('#' + idPart + 'reExamDetailEvaluationLevelNameId').disable();
        }
        form.down('#' + idPart + 'reExamDetailDetailSequenceItemId').disable();
        if(form.down('#adminByNote')) {
	        form.down('#adminByNote').hide();
	        form.down('#invigilatorNote').hide();
        }
    },

    onPreExamDetailEventChange: function (cmp, nval, oval) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var eventIds = [];
        for (var i = 0; i < vals.detailSequence.length; i++) {
            if (vals.detailSequence) {
                if (isNaN(vals.detailSequence[i])) {
                    eventIds.push(vals.detailSequence[i].get('eventId'));
                } else {
                    eventIds.push(vals.detailSequence[i]);
                }
            }
        }
        form.getForm().findField('assessmentEventIds').setValue(eventIds.join());
    },

    onDownoadTemplateForChange: function (cmp, records) {
        var curVal = records[0].get('displayValue');
        var form = cmp.up('form');
        var container1 = form.down('#container1');
        var container2 = form.down('#container2');
        var container3 = form.down('#container3');
        //if (curVal == getCommonTranslation('ImportConcessionAllocation')) {
            container1.show();
            container1.enable();
            container2.show();
            container2.enable();
            container3.show();
            container3.enable();
        /*} else {
            container1.hide();
            container1.disable();
            container2.hide();
            container2.disable();
            container3.hide();
            container3.disable();
        }*/
        var fields = form.getForm().getFields().items;
        for(var i = 00; i < fields.length; i++) {
        	if(fields[i].itemId != 'downloadTemplateForItemId') {
        		fields[i].reset();
        		if(fields[i].clearValue) {
        			fields[i].clearValue();
        		}
        		if(fields[i].itemId != 'administrativeByRoomAndStaffAllocation' && fields[i].xtype != 'hidden') {
        			fields[i].disable();
        		}
        	}
        }
        form.isValid();
        var grid = this.getImportPreExamDetailGrid();
        var gridStore = grid.getStore();
        gridStore.getProxy().extraParams = {
            moduleName: records[0].get('value')
        };
        gridStore.load();
    },

    doForceRunPreExamDetailJob: function (obj) {
        var grid = this.getImportPreExamDetailGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            if (grid.getSelectionModel().getCount() > 1) {
                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
            } else {
                var this$ = this;
                var id = grid.getSelectionModel().selectionStart.data.id;
                console.log(id);
                var urlAppend = "?jobName=" + id;
                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
                Ext.Ajax.request({
                    url: submitURL,
                    method: 'GET',
                    success: function (response) {
                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
                        } else if (response.responseText === "SUCCESS") {
                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
                        }
                    }
                });
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    onDownloadPreExamDetailAcademicTermSelect: function (cmp, records) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var plan = form.down('#downloadPreExamDetailAssesmentSchemeId');
        plan.reset();
        plan.clearValue();
        plan.enable();
        var planStore = plan.getStore();
        planStore.getProxy().extraParams = {
            academicTermId: records[0].get('id'),
            whetherDynamicScheme: true,
            administrativeBy: vals.administrativeBy
        };
        planStore.load();
        var course = form.down('#downloadPreExamDetailCourseItemId');
        course.reset();
        course.clearValue();
        course.disable();
        /*var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        level.reset();
        level.disable();*/
        var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.disable();
        
        var fromDate = form.down('#fromDateDownloadPreExam');
        fromDate.reset();
        fromDate.disable();
        
        var toDate = form.down('#tillDateDownloadPreExam');
        toDate.reset();
        toDate.disable();
    },

    onDownloadPreExamDetailAssesmentSchemeSelect: function (cmp, records) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var schemeIds = '';
        if(vals.schemeId && vals.schemeId.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.schemeId.join();
			}
		}else if(vals.schemeId){
			schemeIds = vals.schemeId;
		}
        form.getForm().findField('assessmentSchemeId').setValue(schemeIds);
        var course = form.down('#downloadPreExamDetailCourseItemId');
        course.reset();
        course.clearValue();
        course.enable();
        var courseStore = course.getStore();
        courseStore.getProxy().extraParams = {
        	evaluationPlanIds: schemeIds,
            academicTermId: vals.academicTermId,
            administeredBy: vals.administrativeBy
        };
        courseStore.load();
        /*var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            evaluationPlanId: vals.assessmentSchemeId
        };
        levelStore.load();*/
        var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.enable();
        /*var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        var levelSelected = form.getForm().findField('assessmentLevelSelected');
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('3');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('2');
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('1');
            }
        }*/
        
        var fromDate = form.down('#fromDateDownloadPreExam');
        fromDate.reset();
        fromDate.enable();
        
        var toDate = form.down('#tillDateDownloadPreExam');
        toDate.reset();
        toDate.enable();
        
        var eventStore = event.getStore();
        eventStore.removeAll();
        vals = form.getValues();
        var form = new FormData();
        form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
        /*if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }*/
        form.append('courseIds', vals.courseIds);
        form.append('administeredBy', vals.administrativeBy);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
        
        if(vals.schemeId && vals.schemeId.length == 0) {
        	course.disable();
        	event.disable();
        	fromDate.disable();
        	toDate.disable();
        }
    },

    onDownloadPreExamDetailCourseChange: function (cmp, nval, oval) {
        var form = cmp.up('form');
        var vals = form.getValues();
        /*var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        level.reset();
        level.enable();
        var levelStore = level.getStore();
        levelStore.getProxy().extraParams = {
            evaluationPlanId: vals.assessmentSchemeId
        };
        levelStore.load();*/
        var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.enable();
        var courseIds = [];
        for (var i = 0; i < vals.courseId.length; i++) {
            if (vals.courseId[i]) {
                if (isNaN(vals.courseId[i])) {
                    courseIds.push(vals.courseId[i].get('id'));
                } else {
                    courseIds.push(vals.courseId[i]);
                }
            }
        }
        form.getForm().findField('courseIds').setValue(courseIds.join());
        var schemeIds = '';
        if(vals.schemeId && vals.schemeId.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.schemeId.join();
			}
		}else if(vals.schemeId){
			schemeIds = vals.schemeId;
		}
        
        var fromDate = form.down('#fromDateDownloadPreExam');
        fromDate.reset();
        
        var toDate = form.down('#tillDateDownloadPreExam');
        toDate.reset();
        
        /*var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');;
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');;
            }
        }*/
        var eventStore = event.getStore();
        eventStore.removeAll();
        vals = form.getValues();
        var form = new FormData();
        if(isNullOrEmpty(vals.assessmentSchemeId)) {
        	return;
        }
        form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
        /*if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }*/
        form.append('courseIds', vals.courseIds);
        form.append('administeredBy', vals.administrativeBy);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },

    onDownloadPreExamDetailEvalLevelSelect: function (cmp, records) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        event.reset();
        event.clearValue();
        event.enable();
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        var levelSelected = form.getForm().findField('assessmentLevelSelected');
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('3');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('2');
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');
                levelSelected.setValue('1');
            }
        }
        var eventStore = event.getStore();
        eventStore.removeAll();
        vals = form.getValues();
        var form = new FormData();
        form.append('evaluationPlanId', vals.assessmentSchemeId);
        form.append('academicTermId', vals.academicTermId);
        if (!isNullOrEmpty(levelOneId)) {
            form.append('evaluationPlanLevelOneId', levelOneId);
        }
        if (!isNullOrEmpty(levelTwoId)) {
            form.append('evaluationPlanLevelTwoId', levelTwoId);
        }
        if (!isNullOrEmpty(levelThreeId)) {
            form.append('evaluationSequenceId', levelThreeId);
        }
        form.append('courseIds', vals.courseIds);
        form.append('administeredBy', vals.administrativeBy);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },

    onDownloadPreExamDetailEventChange: function (cmp, nval, oval) {
        var form = cmp.up('form');
        var vals = form.getValues();
        var eventIds = [];
        for (var i = 0; i < vals.detailSequence.length; i++) {
            if (vals.detailSequence[i]) {
                if (isNaN(vals.detailSequence[i])) {
                    eventIds.push(vals.detailSequence[i].get('id'));
                } else {
                    eventIds.push(vals.detailSequence[i]);
                }
            }
        }
        form.getForm().findField('assessmentEventIds').setValue(eventIds.join());
    },

    getPreExamDetailDownload: function (btn) {
        var form = this.getDownloadPreExamDetailFilter();
        var values = form.getValues();
        btn.setDisabled(true);
        Ext.defer(function () {
            btn.setDisabled(false);
        }, 2000, this);

        /*var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        var code;
        var type = level.lastSelection[0];
        if (type) {
            code = type.get('code');
        }
        var levelOneId;
        var levelTwoId;
        var levelThreeId;
        var levelSelected = form.getForm().findField('assessmentLevelSelected');
        if (!isNullOrEmpty(code)) {
            if (code == "Assessment Method") {
                levelThreeId = level.lastSelection[0].get('levelId');
            } else if (code == "Assessment Sub Type") {
                levelTwoId = level.lastSelection[0].get('levelId');
            } else if (code == "Assessment Type") {
                levelOneId = level.lastSelection[0].get('levelId');
            }
        }*/
        var csvForm = Ext.create('Ext.form.Panel');
        var submitUrl = SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_CONCESSION_ALLOCATION;
        if(values.templateFor == getCommonTranslation("ImportNonConcessionAllocation")) {
        	submitUrl = SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_NON_CONCESSION_ALLOCATION;
        }
        csvForm.getForm().submit({
            target: '_blank',
            method: 'POST',
            params: {
                access_token: Ext.Ajax.defaultHeaders.access_token,
                courseIds: values.courseIds,
                evaluationPlanIds: values.assessmentSchemeId,
                //evaluationSequenceId: levelThreeId,
                academicTermId: values.academicTermId,
                eventIds: values.assessmentEventIds,
                //evaluationPlanLevelOneId: levelOneId,
                //evaluationPlanLevelTwoId: levelTwoId,
                administeredBy: values.administrativeBy,
                fromDate: values.fromdate,
        		toDate: values.tilldate
            },
            headers: {
                'Authorization': Ext.Ajax.defaultHeaders.Authorization
            },
            url: submitUrl,
            standardSubmit: true
        });
    },

    getDownloadLogFileForPreExamDetail: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        if (e.target.tagName == 'A') {
            var fileType = null;
            if (cellIndex == 1) {
                fileType = 'successFile';
            } else if (cellIndex == 6) {
                fileType = 'errorFile';
            } else if (cellIndex == 7) {
                fileType = 'logFile';
            }
            var documentId = record.get("id");
            if (!isNullOrEmpty(documentId)) {
                this.getDownloadFileNew(documentId, fileType);
            }
        }
    },

    resetDownloadPreExamDetailForm: function (btn) {
        var form = btn.up('form');
        form.getForm().reset();
        form.down('#downloadPreExamDetailDetailSequenceItemId').clearValue();
        form.down('#downloadPreExamDetailCourseItemId').clearValue();
        form.down('#downloadPreExamDetailAssesmentSchemeId').clearValue();
        form.down('#container1').hide();
        form.down('#container2').hide();
        form.down('#container3').hide();
        form.down('#downloadPreExamDetailAssesmentSchemeId').disable();
        form.down('#downloadPreExamDetailCourseItemId').disable();
        form.down('#downloadPreExamDetailEvaluationLevelNameId').disable();
        form.down('#downloadPreExamDetailDetailSequenceItemId').disable();
    },
    
    getDownloadFileNew: function (documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        }
    },
    
    onDownloadPreExamDetailAdminBySelect: function(cmp, rec) {
    	var form = cmp.up('form');
    	var academicTerm = form.down('#downloadPreExamDetailAcademicTermId');
    	academicTerm.reset();
    	academicTerm.enable();
        academicTerm.getStore().load({
		    callback: function(records, operation, success) {
		    	records.forEach(function(rec){
		    		if(rec.data.whetherCurrentAcademicTerm){
		    			academicTerm.setValue(rec.data.id);
		    			academicTerm.fireEvent('select', academicTerm, [rec])
		    		}
		    	});
		    }
		});
        var plan = form.down('#downloadPreExamDetailAssesmentSchemeId');
        plan.reset();
        plan.clearValue();
        plan.disable();
        var course = form.down('#downloadPreExamDetailCourseItemId');
        course.reset();
        course.clearValue();
        course.disable();
        /*var level = form.down('#downloadPreExamDetailEvaluationLevelNameId');
        level.reset();
        level.disable();*/
        var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        event.disable();
        
        var fromDate = form.down('#fromDateDownloadPreExam');
        fromDate.reset();
        fromDate.disable();
        
        var toDate = form.down('#tillDateDownloadPreExam');
        toDate.reset();
        toDate.disable();
    },
    
    onFromDateChange: function(cmp) {
    	var form = cmp.up('form');
    	var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        var eventStore = event.getStore();
        eventStore.removeAll();
        vals = form.getValues();
		if(vals.schemeId && vals.schemeId.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.schemeId.join();
			}
		}else if(vals.schemeId){
			schemeIds = vals.schemeId;
		}
        var form = new FormData();
		form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
		form.append('courseIds', vals.courseIds);
        form.append('administeredBy', vals.administrativeBy);
        form.append('fromDate', vals.fromdate);
        form.append('tillDate', vals.tilldate);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    },
    
    onTillDateChange: function(cmp) {
    	var form = cmp.up('form');
    	var event = form.down('#downloadPreExamDetailDetailSequenceItemId');
        event.reset();
        event.clearValue();
        var eventStore = event.getStore();
        eventStore.removeAll();
        vals = form.getValues();
		if(vals.schemeId && vals.schemeId.length > 0){
			try{
				schemeIds = Ext.Array.pluck(Ext.Array.pluck(vals.schemeId, 'data'), 'id').join();
			} catch(e) {
				schemeIds = vals.schemeId.join();
			}
		}else if(vals.schemeId){
			schemeIds = vals.schemeId;
		}
        var form = new FormData();
		form.append('evaluationPlanIds', schemeIds);
        form.append('academicTermId', vals.academicTermId);
		form.append('courseIds', vals.courseIds);
        form.append('administeredBy', vals.administrativeBy);
        form.append('fromDate', vals.fromdate);
        form.append('tillDate', vals.tilldate);
        var xhr = new XMLHttpRequest();
        var userInfo = Academia.model.authentication.UserInfoModel;
        var access_token = userInfo.get("accessToken");
        var submitUrl = SERVERURL.PATH_EVENTS_FOR_PRE_EXAM_DETAILS + '?access_token=' + access_token;
        xhr.open('POST', submitUrl, true);
        xhr.onreadystatechange = function (resp) {
            if (resp.currentTarget.readyState == 4) {
                var responseText = Ext.decode(resp.currentTarget.responseText);
                if (responseText.length) {
                    eventStore.loadRawData(responseText);
                }
            }
        };
        xhr.send(form);
    }
});