/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.controller.examinationcenters.calculateAverage.CalculateAverageController', {
    //extend : 'Ext.app.Controller',
    extend: 'Academia.controller.base.BaseController',
    models: ['examinationcenters.StudentAverageModel'],
    stores: ['common.AssignedProgramStore', 'common.ProgramByAcademyLocationStore', 'common.BatchesByProgramId',
             'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'attendance.SectionAndFacultyByPeriodID', 'examinationcenters.marksheet.EvaluationLevelType',
             'examinationcenters.evaluation.CourseAndVariantsContainsEvaluation','examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId',
             'examinationcenters.marksheet.EvaluationLevelTypeNameStore','attendance.CoursesFromEvaluationPlan',
             'examinationcenters.marksheet.CalculateAverageEvaluationLevelType',
             'examinationcenters.calculateAverage.CalculateAverageGridStore',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
             'examinationcenters.calculateAverage.CalculateAverageEvalLevelTypeStore',
             'user.UserAcademyLocationStore','examinationcenters.reports.ExaminationPlanStore',
             'attendance.VariantMappedToPlanTemplate',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventsByLevelIdStore',
             'facilitiesresources.resourcemaster.ProgramsInEvluationPlanStore',
             'attendance.VariantMappedToPlan','examinationcenters.evaluation.CourseofAllPlan',
             'examinationcenters.reports.PendingMarksRemarksStudentListStore',
             'examinationcenters.reports.ExaminationReportStudentStore','attendance.VariantMappedToSpecialGrade',
             'examinationcenters.reports.ExaminationReportProgramStore','examinationcenters.reports.ExaminationReportPeriodStore',
             'examinationcenters.reports.ExaminationReportBatchStore',
             'examinationcenters.reports.SpecialGradeBatchStore','examinationcenters.reports.SpecialGradePeriodStore',
             'examinationcenters.reports.PeriodWiseExamLevelReportStudentStore','examinationcenters.reports.ExaminationReportCourseStore',
             'examinationcenters.calculateAverage.ExamResultDeletionGridStore',
             'examinationcenters.marksheet.AssessmentOtherLevelStore','examinationcenters.marksheet.EventEvaluationLevelType',
             'examinationcenters.marksheet.CalculateAverageEvaluationLevelStore','examinationcenters.calculateAverage.CalculateAverageEvalLevelTypeListStore',
             'examinationcenters.calculateAverage.AssessmentSubjectListGridStore',
             'examinationcenters.calculateAverage.calculateAverageYearly.ProgramStore',
             'examinationcenters.calculateAverage.calculateAverageYearly.BatchStore',
             'examinationcenters.calculateAverage.calculateAverageYearly.PeriodStore',
             'examinationcenters.calculateAverage.calculateAverageYearly.StudentStore',
             'examinationcenters.calculateAverage.calculateAverageLevelWise.ProgramStore',
             'examinationcenters.calculateAverage.calculateAverageLevelWise.BatchStore',
             'examinationcenters.calculateAverage.calculateAverageLevelWise.StudentStore',
             'examinationcenters.calculateAverage.calculateAverageLevelWise.CalculateAverageLevelWiseGridStore',
             'examinationcenters.calculateAverage.calculateAverageLevelWise.AssessmentLevelListGridStore'
             ],
    views: ['examinationcenters.calculateAverage.CalculateAverageStructure', 'examinationcenters.calculateAverage.CalculateAverageFilter',
            'examinationcenters.calculateAverage.CalculateAverageGrid','examinationcenters.calculateAverage.CalculateAverageWin',
            'examinationcenters.calculateAverage.ExamResultDeletionStructure','examinationcenters.calculateAverage.ExamResultDeletionFilter',
            'examinationcenters.calculateAverage.ExamResultDeletionGrid','examinationcenters.calculateAverage.AssessmentSubjectDetailsStructure',
            'examinationcenters.calculateAverage.SubjectAssessmentDetailsStructure',
            'examinationcenters.calculateAverage.CalculateAverageYearlyFilter',
            'examinationcenters.calculateAverage.CalculateAverageYearlyGrid',
            'examinationcenters.calculateAverage.CalculateAverageLevelWiseFilter',
            'examinationcenters.calculateAverage.CalculateAverageLevelWiseGrid',
            'examinationcenters.calculateAverage.AssessmentLevelList',
            'examinationcenters.calculateAverage.AssessmentLevelListGrid'
            ],
    config: {
        CALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CALCULATE_AVERAGE_PRIVILEGES'),
        EXAM_RESULT_DELETION_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_RESULT_DELETION_PRIVILEGES'),
        CALCULATE_AVERAGE_YEARLY_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CALCULATE_AVERAGE_YEARLY_PRIVILEGES'),
        CALCULATE_AVERAGE_LEVEL_WISE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CALCULATE_AVERAGE_LEVEL_WISE_PRIVILEGES')
    		},
    		refs: [{
    			ref: 'calculateaveragestructure',
    			selector: 'calculateaveragestructure'
    		},
    		{
    			ref: 'calculateaveragefilter',
    			selector: 'calculateaveragefilter'
    		},
    		{
    			ref: 'calculateaveragegrid',
    			selector: 'calculateaveragegrid'
    		},
    		{
    			ref: 'calculateaveragewin',
    			selector: 'calculateaveragewin'
    		},
    		{
    			ref: 'examresultdeletionfilter',
    			selector: 'examresultdeletionfilter'
    		},
    		{
    			ref: 'examresultdeletiongrid',
    			selector: 'examresultdeletiongrid'
    		},
    		{
    			ref: 'examresultdeletionstructure',
    			selector: 'examresultdeletionstructure'
    		},
    		{
	        	ref:'contentPanel',
	        	selector:'contentPanel'
	        },{
	        	ref:'assessmentsubjectdetailsstructure',
	        	selector:'assessmentsubjectdetailsstructure'
	        },{
	        	ref:'assessmentsubjectdetailform',
	        	selector:'assessmentsubjectdetailform'
	        },{
	        	ref:'subjectassessmentdetailsstructure',
	        	selector:'subjectassessmentdetailsstructure'
	        },{
	        	ref:'subjectassessmentdetailsstructure',
	        	selector:'subjectassessmentdetailsstructure[itemId=subjectAssessmentDetailGridItemId]'
	        }, {
	        	ref: 'calculateaverageyearlyfilter',
	        	selector: 'calculateaverageyearlyfilter'
	        }, {
	        	ref: 'calculateaverageyearlygrid',
	        	selector: 'calculateaverageyearlygrid'
	        }, {
	        	ref: 'calculateAverageLevelWiseFilter',
	        	selector: 'calculateAverageLevelWiseFilter'
	        }, {
	        	ref: 'calculateAverageLevelWiseGrid',
	        	selector: 'calculateAverageLevelWiseGrid'
	        }, {
	        	ref: 'assessmentLevelList',
	        	selector: 'assessmentLevelList'
	        }, {
	        	ref: 'assessmentLevelListGrid',
	        	selector: 'assessmentLevelListGrid'
	        }], 
    init: function() {
        this.control({
        	'calculateaveragestructure': {
        		beforerender: function(structure) {
        			var permissionsMap = this.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS();
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					//if(permissionList.indexOf('PC_M5_F_EXAM_CALCULATE_AVERAGE_TAB') != -1) { // commented for V2D-377469 as discussed with Amarnath Patel
						structure.add({
							xtype:'form',
							title: getCommonTranslation('CALCULATE_AVERAGE_TITLE'),
							tabCls: 'right-tab',
							autoScroll: true,
							frame:false,
							items:[{
								xtype:'calculateaveragefilter'  
							},{
								xtype:'panel',
								items:[{
									xtype:'calculateaveragegrid',  
									itemId: 'calculateaveragegrid'
								}]
							}]
						});
					//}
					var permissionMap = this.getCALCULATE_AVERAGE_YEARLY_PRIVILEGES_PERMISSIONS();
					var permissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
					if(permissionsList.indexOf('CALCULATE_AVERAGE_YEARLY_TAB') != -1) { // uncommented for V2D-377469 as discussed with Amarnath Patel
						structure.add({
							xtype:'form',
							title: getCommonTranslation('CALCULATE_AVERAGE_YEARLY_TITLE'),
							tabCls: 'right-tab',
							autoScroll: true,
							frame:false,
							items:[{
								xtype:'calculateaverageyearlyfilter'  
							},{
								xtype:'panel',
								items:[{
									xtype:'calculateaverageyearlygrid',  
									itemId: 'calculateaverageyearlygrid'
								}]
							}]
						});
					}
					var permission_map = this.getCALCULATE_AVERAGE_LEVEL_WISE_PERMISSIONS();
					var permission_list = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permission_map);
					if(permission_list.indexOf('CALCULATE_AVERAGE_LEVEL_WISE_TAB') != -1) {
						structure.add({
							xtype:'form',
							title: getCommonTranslation('CALCULATE_AVERAGE_LEVEL_WISE_TITLE'),
							tabCls: 'right-tab',
							autoScroll: true,
							frame:false,
							items:[{
								xtype:'calculateAverageLevelWiseFilter'  
							},{
								xtype:'panel',
								items:[{
									xtype:'calculateAverageLevelWiseGrid',  
									itemId: 'calculateAverageLevelWiseGrid'
								}]
							}]
						});
					}
        		},
        		afterrender:function(structure){
					var newStructure = structure.down('form');
					if(newStructure) {
						var grid = structure.down('calculateaveragegrid');
						if(grid) {
							this.getGridHeaderFreezeForCalculatAvrg(grid,newStructure,false);
						}
						var firstTab = structure.items.getAt(0);
						if(firstTab) {
							structure.setActiveTab(firstTab);
						}
					}
        		}
        	},
            'calculateaveragegrid': {
                afterrender: function(grid) {
                	var me =this;
                	setTimeout(function(){
            		me.addDataGridConfigButton(grid,me.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS());
                	},1500);
                    if (grid.getStore().getCount() > 0) {
                        grid.getStore().removeAll();
                    }
                    this.doAccessControlValidation(grid, this.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS());
                    permissionsMap = this.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS();
					this.disableMoreActionPivileges(grid, permissionsMap);
                },
                // start for
                cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
            	  if(e.target.tagName == 'A') {
            		  var me = this;
                	  var structure = Ext.widget('assessmentsubjectdetailsstructure');
            		  me.openAssessmentSubjectListTab(structure);
        		  	  var levelIdsArray = []; 
        		  	  if (!isNullOrEmpty(record.data.courseDetailsList)) {
              	           for (var i = 0; i < record.data.courseDetailsList.length; i++) {
               	               levelIdsArray.push(record.data.courseDetailsList[i].levelId);
               	           }
                   	  }
            		  var filterForm = structure.down('form').getForm();
            		  var grid = structure.down('grid');
            		 
            		  grid.getStore().getProxy().extraParams = {
            			  evaluationLevel: record.data.levelName,
            			  levelIds:levelIdsArray.join(),
            			  admissionId:record.data.admissionId,
            			  periodId:record.data.periodId,
            			  droolCode:record.data.droolCode
                      };
            		  
            		  grid.getStore().load({
            			 callback:function(record1) {
            				 if(!isNullOrEmpty(record1) && record1.length>0){
            					var newRecord = record1[0].data;
            					if(!isNullOrEmpty(newRecord.studentCode) && !isNullOrEmpty(newRecord.studentName)){
            						filterForm.findField('studentCodeName').setValue(newRecord.studentCode+'/'+newRecord.studentName);
            					}
            					if(!isNullOrEmpty(newRecord.programName) && !isNullOrEmpty(newRecord.batchName)){
            						 filterForm.findField('gradeIntake').setValue(newRecord.programName+'-'+newRecord.batchName);
            					}
                     		    filterForm.findField('sectionName').setValue(record.data.sectionName);
                     		    filterForm.findField('assessmentLevelName').setValue(getExaminationTranslation(record.data.levelName));
                     		    filterForm.findField('assessmentLevelValue').setValue(newRecord.levelValue);
                     		    filterForm.findField('droolName').setValue(newRecord.droolName);
                     		    
                     		    grid.down('#asl_gradeAverage').setValue(record.data.marks.toFixed(2));
            				 }
            			 }
            	  	  });
            	  }
                }
            },
           
            'calculateaveragegrid ':{
            	select:function(obj, record,rowIndex, e){
            		var grid=this.getCalculateaveragegrid();
            		var form=this.getCalculateaveragefilter();
            		var buttonsToolBar = grid.query('toolbar')[0];
            		var publishButton = buttonsToolBar.query('#DeleteButtonId')[0];
            		var condoneSubjectButton = buttonsToolBar.query('#condoneSubjectButtonId')[0];
            		if (grid.getSelectionModel().getCount() > 0) {
            			publishButton.enable();
            		}
            		if(grid.getSelectionModel().getCount() == 1 && (!isNullOrEmpty(grid.getSelectionModel().getSelection()[0]) &&
            				(grid.getSelectionModel().getSelection()[0].data.promotionStatus==="Fail" ||
            				grid.getSelectionModel().getSelection()[0].data.promotionStatus==="Condoned Subject Pass" ||
            				grid.getSelectionModel().getSelection()[0].data.promotionStatus==="DNMR"))){
            			condoneSubjectButton.enable();
            		} else {
            			condoneSubjectButton.disable();
            		}
            	},
            	deselect:function(obj, record, rowIndex, e){
            		var grid=this.getCalculateaveragegrid();
            		var form=this.getCalculateaveragefilter();
            		var buttonsToolBar = grid.query('toolbar')[0];
            		var publishButton = buttonsToolBar.query('#DeleteButtonId')[0];
            		var condoneSubjectButton = buttonsToolBar.query('#condoneSubjectButtonId')[0];
            		if (grid.getSelectionModel().getCount() <= 0) {
            			publishButton.disable();
            		}
            		if(grid.getSelectionModel().getCount() == 1 && (!isNullOrEmpty(grid.getSelectionModel().getSelection()[0]) &&
            				(grid.getSelectionModel().getSelection()[0].data.promotionStatus==="Fail" ||
                    				grid.getSelectionModel().getSelection()[0].data.promotionStatus==="Condoned Subject Pass" ||
                    				grid.getSelectionModel().getSelection()[0].data.promotionStatus==="DNMR"))){
            			condoneSubjectButton.enable();
            		} else {
            			condoneSubjectButton.disable();
            		}
            	}
            },
            'calculateaveragefilter': {
                render: function(obj) {
                    var $this = this;
                    var form = obj.getForm();
                    /* var locations = [];
									var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
									for(var i=0; i<academyLocationList.length; i++){
										locations.push(academyLocationList[i].id);
									}*/
                    var academyLocationId = this.getCurrentAcademyLocation();
                    /**
                     * Load program by academy location
                     */
                    var portalId = $this.getCurrentLoggedPortalId();
                    var facultyId = $this.getCurrentlyLoggedInUser();
                    var programField = form.findField('programId');
                    var evaluationLevelField=form.findField('evaluationLevel');
                    var evaluationLevelNameField=form.findField('evalLevelName');
                    evaluationLevelField.disable();
                    evaluationLevelNameField.disable();
                    var arr = [];
                    arr.push($this.getCurrentAcademyLocation());
                    programField.getStore().getProxy().extraParams = {
                        academyLocationIds: arr.join()
                    };
                  //  programField.getStore().load();
                    evaluationLevelStore=evaluationLevelField.getStore();
                    
                    var store = $this.getStore('examinationcenters.marksheet.CalculateAverageEvaluationLevelType');
                    evaluationLevelStore.on('load', function(){
                    	for(var i=0; i< store.data.items.length;i++){
                    		if(store.data.items[i].data.value == 'Assessment Event'){
                    			store.removeAt(i);
                    		} 
                    	}
                    });
                }
            },

            'calculateaveragefilter customcombobox[itemId=programItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var batchField = filterForm.findField('batchId');
                    var period = filterForm.findField('periodId');
                    var section = filterForm.findField('sectionId');
                    var evaluationLevel = filterForm.findField('evaluationLevel');
                    var evalLevelName = filterForm.findField('evalLevelName');
                    evaluationLevel.reset();
                    
                   /* evaluationLevel.getStore().loadRawData([]);
                    evaluationLevel.getStore().getProxy().extraParams = {
                        programId: data,
                        whetherCalculateAverage:true,
                    };
                    evaluationLevel.getStore().load();*/
                    evalLevelName.reset();
                    evalLevelName.setDisabled(true);
                    batchField.enable();
                    batchField.reset();
                    batchField.getStore().loadRawData([]);
                    batchField.getStore().getProxy().extraParams = {
                        id: data
                    };
                    batchField.getStore().load({
                    	callback:function(record) {
                    		if(record.length==1){
                    			batchField.setValue(record[0].data.id);
                    			period.setDisabled(false);
                    			period.getStore().getProxy().extraParams = {
        	                        id: record[0].data.id
        	                    };
                    			period.getStore().load({
                    				callback:function(records) {
                                		if(records.length==1){
                                			period.setValue(records[0].data.id);
                                            evaluationLevel.enable();
                                            evaluationLevel.reset();
                                            evaluationLevel.getStore().loadRawData([]);
                                            evaluationLevel.getStore().getProxy().extraParams = {
                                            	programId:data,
                                            	batchId:batchField.getValue(),
                                                periodId: period.getValue(),
                                                whetherCalculateAverage:true,
                                            };
                                            evaluationLevel.getStore().load();
                                            
                                            evalLevelName.enable();
                                            evalLevelName.reset();
                                            section.setDisabled(false);
                                            section.reset();
                                            section.getStore().getProxy().extraParams = {
                                                periodId: data
                                            };
                                            section.getStore().load();
                                		}else{
                                			
                                		}
                    				}
                    			})
                    		}else{
                    			period.reset();
                                period.setDisabled(true);
                                
                                section.reset();
                                section.setDisabled(true);
                    		}
                    	}
	                    
                    });
                    

                    
                    
                }
            },

            'calculateaveragefilter customcombobox[itemId=batchItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var programField = filterForm.findField('programId'); 
                    var batchField = filterForm.findField('batchId');
                    var periodField = filterForm.findField('periodId');
                    var section = filterForm.findField('sectionId');
                    var evaluationLevelFiled =filterForm.findField('evaluationLevel');
                    var evalLevelNameField = filterForm.findField('evalLevelName'); 
                    periodField.enable();
                    periodField.reset();
                    periodField.getStore().loadRawData([]);
                    periodField.getStore().getProxy().extraParams = {
                        id: data
                    };
                    periodField.getStore().load({
						 callback:function(records,value,rec){
						 if(records.length == 1){
								periodField.setValue(records[0].data.id);
								section.reset();
								section.enable();
                    	section.getStore().getProxy().extraParams = {
                        		periodId: records[0].data.id
                    };
                    section.getStore().load();
                    evaluationLevelFiled.reset();
					evaluationLevelFiled.enable();
                    evaluationLevelFiled.getStore().loadRawData([]);
                    evaluationLevelFiled.getStore().getProxy().extraParams = {
                    	programId:programField.getValue(),
                    	batchId:batchField.getValue(),
                        periodId: records[0].data.id,
                        whetherCalculateAverage:true,
                    };
                    evaluationLevelFiled.getStore().load();
					 }else{
								evaluationLevelFiled.reset();
								evaluationLevelFiled.getStore().loadRawData([]);
								 evaluationLevelFiled.enable();
						   }									   
					}});
					//periodField.getStore().load();
                    //section.reset();
                    //section.setDisabled(false);
                  //  evaluationLevelFiled.reset();
                  //  evaluationLevelFiled.getStore().loadRawData([]);
                   /* evaluationLevelFiled.getStore().getProxy().extraParams = {
                    	programId:programField.getValue(),
                        batchId: data,
                        whetherCalculateAverage:true,
                    };
                    evaluationLevelFiled.getStore().load();*/
                   // evaluationLevelFiled.enable();
                    evalLevelNameField.reset();
                    evalLevelNameField.disable(); 
                }
            },
            'calculateaveragefilter customcombobox[itemId=periodItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var sectionField = filterForm.findField('sectionId');
                    var programField = filterForm.findField('programId'); 
                    var batchField = filterForm.findField('batchId');
                    var evalPlanLevelField = filterForm.findField('evaluationLevel');
                    var evalLevelNameField = filterForm.findField('evalLevelName'); 
                    evalPlanLevelField.enable();
                    evalPlanLevelField.reset();
                    evalPlanLevelField.getStore().loadRawData([]);
                    evalPlanLevelField.getStore().getProxy().extraParams = {
                    	programId:programField.getValue(),
                    	batchId:batchField.getValue(),
                        periodId: data,
                        whetherCalculateAverage:true,
                    };
                    evalPlanLevelField.getStore().load();
                    
                    evalLevelNameField.enable();
                    evalLevelNameField.reset();
                    sectionField.enable();
                    sectionField.reset();
                    sectionField.getStore().getProxy().extraParams = {
                        periodId: data
                    };
                    sectionField.getStore().load();
                }
            },
            'calculateaveragefilter customcombobox[itemId=evalPlanLevelId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var sectionField = filterForm.findField('sectionId');
                    sectionField.enable();
                    sectionField.reset();
                    sectionField.getStore().getProxy().extraParams = {
                        periodId: data
                    };
                    sectionField.getStore().load();

                }
            },
            'calculateaveragefilter customcombobox[itemId=evaluationLevelItemId]': {
                select: function(obj, rec) {
                    var evalLevelData = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var calculateaveragefilter = this.getCalculateaveragefilter();
                    var filterFormValues = calculateaveragefilter.getForm().getValues();
                    var sectionArray = [];
                    if (!isNullOrEmpty(filterFormValues.sectionId)) {
                        for (var i = 0; i < filterFormValues.sectionId.length; i++) {
                            var sectionValue = filterFormValues.sectionId[i];
                            if (Ext.isObject(sectionValue)) {
                                sectionArray.push(sectionValue.data.sectionId);
                            } else {
                                sectionArray.push(sectionValue);
                            }
                        }
                    }
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var evalLevelField = filterForm.findField('evaluationLevel');
                    var evalLevelNameField = filterForm.findField('evalLevelName');
                    var programId = filterForm.findField('programId');
                    var batchId = filterForm.findField('batchId');
                    var periodId = filterForm.findField('periodId');
                    evalLevelNameField.enable();

                    evalLevelNameField.show();
                    evalLevelNameField.reset();
                    evalLevelNameField.allowBlank = false;
                    evalLevelNameField.getStore().getProxy().extraParams = {
                    	evaluationLevel: evalLevelData,
                    	//programId:programId.getValue(),
                    	//batchId:batchId.getValue(),
                    	periodId:periodId.getValue(),
                    	whetherCalculateAverage:true,
                    	//isGroupBy:true
                    };
                    
                    var evalLevelIds = [];
                    evalLevelNameField.getStore().load({
                    	callback:function(record) {
                    		for(var i in record) {
                    			for (var i = 0; i < record.length; i++) {
                    				evalLevelIds.push(record[i].data.id);
                    			}
                    		}
                    		filterForm.findField('evalLevelIds').setValue(evalLevelIds.join());
                    	}
                    });
                    
                }
            },
            'calculateaveragefilter button[itemId=searchBtn]': {
                click: function(obj) {
                    this.loadCalculateAverageFilterData();
                },
                disable: function() {
                	this.getCalculateaveragegrid().down('#calculateRankButtonId').disable();
                }
            },
            'calculateaveragefilter button[itemId=resetBtn]': {
                click: function(obj) {
                	var $this=this;
                    var filterForm = obj.up('form').getForm();
                    filterForm.findField('batchId').disable();
                    filterForm.findField('periodId').disable();
                    filterForm.findField('evaluationLevel').disable();
                    filterForm.findField('evalLevelName').disable();
                    filterForm.findField('sectionId').disable();
                    filterForm.reset();
                    var program=filterForm.findField('programId');
                    program.reset();
                    var arr = [];
                    arr.push($this.getCurrentAcademyLocation());
                    program.getStore().getProxy().extraParams = {
                        academyLocationIds: arr.join()
                    };
                    program.getStore().load();
                }
            },
            
            'calculateaveragegrid button[itemId=caclulateAverageButtonId]':{
            	click:function(obj){
            		var grid=this.getCalculateaveragegrid();
            		var isDroolCode=true;
            		if(grid.getSelectionModel().getCount()>0){
            			
            			var records=grid.getSelectionModel().getSelection();
            			for(var i=0; i< records.length;i++){
            				if(isNullOrEmpty(records[i].data.droolCode)){
            					isDroolCode=false;
            				}
                    	}
            			if(isDroolCode){
            				//this.openCalculateAverageWindow();
            				this.saveStudentAverageData(obj);
            			}else{
            				showWarningMessage(getExaminationTranslation('CALCULATE_AVERAGE'),getExaminationTranslation('CALCULATE_AVERAGE_DROOL_NOT_CONFIGURED'));
            			}
            			
            		}else{
            			showWarningMessage(getExaminationTranslation('CALCULATE_AVERAGE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		} 
            	}
            },
            'calculateaveragegrid button[itemId=DeleteButtonId]':{
            	click:function(obj){
            		
		        			  var $this = this;
		        			  var formWindow = $this.getCalculateaveragewin();
		        			  var grid = $this.getCalculateaveragegrid();
		        			  var filterForm = $this.getCalculateaveragefilter().getForm();
		        			  var evalLevelIds = filterForm.findField('evalLevelIds').getValue();
		        			  var evaluationLevelName = filterForm.findField('evaluationLevel').getValue();
		        			  var evalLevelName = filterForm.findField('evalLevelName').getValue();
		        			  var periodId = filterForm.findField('periodId').getValue();
		    				  var gridRecord=grid.getSelectionModel().getSelection();
		    				  var jsonData=[];
		    				  var levelIds=[];
		    				  var admissionIds=[];
	 	            		  if(grid.getSelectionModel().getCount() > 0){
	 	            			  for(var i in gridRecord) {
			        				  if(!isNullOrEmpty(gridRecord[i].data.examStudentAverageId)){
			        					  jsonData.push(gridRecord[i].data.examStudentAverageId);
			        				  }
			        				  if(!isNullOrEmpty(gridRecord[i].data.admissionId)){
			        					  admissionIds.push(gridRecord[i].data.admissionId);
			        				  }
			        			  }
	 	            			  
	 	            			 levelIds.push(evalLevelIds);
		 	            		  var submitUrl = SERVERURL.PATH_DELETE_EXAM_AVERAGE;
		 	            		  var data={
				 	       					'examStudentAverageIds':jsonData,
				 	       					 'planIds' : evalLevelIds,
				 	       					'levelValue':evalLevelName,
				 	       					'levelName' :evaluationLevelName ,
				 	       					'admissionIds':admissionIds,
				 	       					'periodId':periodId
		 	       						};
		 	                	  showConfirmMessage(getExaminationTranslation('AVERAGE_DELETION'),
		 	                			  getExaminationTranslation('AVERAGE_DELETE_POPUP_MESSAGE'),function(btn,text){
	 	                			 if (btn == 'yes') {
	 	                				Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
	 	                				if(grid.down('#calculateRankButtonId')) {
     				        				grid.down('#calculateRankButtonId').disable();
     				        			}
	 	                				Ext.Ajax.request({
	 	                					type : 'rest',
	 	                					url : submitUrl,
	 	                					jsonData : data,
	 	                					method : 'POST',
	 	                					success : function(response, action) {
	 	                						Ext.getBody().unmask();
	 	                						grid.getStore().load({
	 	                							callback: function(records, operation, success) {
	 	                				        		if(records && records.length) {
	 	                				        			var calcRankDisable = true;
	 	                				        			for(var j = 0; j < records.length; j++) {
	 	                				        				if(isNullOrEmpty(records[j].get('marks')) || records[j].get('marks') == '0' || records[j].get('marks') == '0.00' || records[j].get('marks') == '0.0') {
	 	                				        					calcRankDisable = true;
	 	                				        				}
	 	                				        				else {
	 	                				        					calcRankDisable = false;
	 	                				        					break;
	 	                				        				}
	 	                				        			}
	 	                				        			if(grid.down('#calculateRankButtonId') && calcRankDisable == false) {
	 	                				        				grid.down('#calculateRankButtonId').enable();
	 	                				        			}
	 	                				        		}
	 	                				        		else {
	 	                				        			if(grid.down('#calculateRankButtonId')) {
	 	                				        				grid.down('#calculateRankButtonId').disable();
	 	                				        			}
	 	                				        		}
	 	                				        	}
	 	                						});
	 	                						grid.getSelectionModel().deselectAll();
	 	                						showSuccessMessage(getExaminationTranslation('AVERAGE_DELETION'),
	 	                								 getExaminationTranslation('AVERAGE_DELETED_SUCCESSFULLY'));
	 	                					}
	 	                				});
	 	                			 }
		 	                	  });
	 	            		  }else{
	 		        			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 		        	      }
		        		  }
	        		  },
   
     
			
			'calculateaveragewin button[itemId=cancelBtn]':{
				click:function(obj){
					obj.up('window').close();
				}
			},
			
			'calculateaveragewin button[itemId=submitBtnWin]':{
				click:function(obj){
					this.saveStudentAverageData(obj);
				}
			},
			'calculateaveragewin':{
				render:function(obj){
					var drools = obj.down('#droolsItemId');
					drools.getStore().getProxy().extraParams={
						moduleName:'STUDENT_AVERAGE_CALCULATION'
					};
					drools.getStore().load();
			  }
		    },
		    
		    'examresultdeletionfilter':{
		    	render : function(structure){
		    		var $this = this;
		    		var form = $this.getExamresultdeletionfilter().getForm();
		    		var evaluationplan = form.findField('evaluationplan');
		    		var evaluationLevel = form.findField('evaluationLevel');
		    		var academyLocationIds =$this.getCurrentAcademyLocation();
		    		var alFilter = form.findField('multiselectAcademyLocation').getStore();
		    		var studentId = form.findField("studentId");
		    		var als = [];
					als.push(academyLocationIds);
		 			studentId.reset();
		    		var programStore = form.findField('program').getStore();
		    		alFilter.getProxy().extraParams={
		    			id:$this.getCurrentlyLoggedInUser().id
		    		};
		    		alFilter.load({
		    			callback:function(record) {
		    				for(var i in record) {
		    					if(record[i].data.id == academyLocationIds) {
		    						form.findField('multiselectAcademyLocation').setValue(record[i].data.id);
		    						programStore.getProxy().extraParams={
		    							academyLocationIds:record[i].data.id,
		    						};
		    						programStore.load();
		    					}
		    				}
		    			}
		    		});
		    		evaluationplan.setDisabled(false);
		    		evaluationplan.reset();
		    		evaluationplan.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    		};
		    		evaluationplan.getStore().load();
		    		evaluationLevel.reset();
		    		evaluationLevel.disable();
		    		
		    		studentId.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    		};
		    		studentId.getStore().load();
		    	}
		    },
		    
		    'examresultdeletionfilter customcombobox[itemId=multiselectAcademyLocationId]':{
		    	select:function(obj,rec){
		    		var $this=this;
		    		var filterForm = obj.up('form').getForm();
		    		var alId = rec[0].get("id");
		    		var form = this.getExamresultdeletionfilter();
		    		var multiselectAcademyLocation=filterForm.findField('multiselectAcademyLocation');
		    		var evaluationplanField = filterForm.findField('evaluationplan');
		    		var program = filterForm.findField('program');
		    		var studentId = filterForm.findField("studentId");
		    		var studentId = filterForm.findField("studentId");
		    		var evaluationPlan = filterForm.findField("evaluationplan");
		    		var evaluationLevel = filterForm.findField("evaluationLevel");
		    		var evaluationOtherLevel = filterForm.findField("evaluationOtherLevel");
		    		var evaluationLevelName = filterForm.findField("evaluationLevelName");
		    		var course = filterForm.findField("course");
		    		var courseVariant = filterForm.findField("courseVariant");
		    		var program = filterForm.findField("program");
		    		var batch = filterForm.findField("batch");
		    		var period = filterForm.findField("period");
		    		var academicCourseFieldContainer=form.down('#academicCourseFieldContainer');
	    			var otherProgramBatchPeriodContainer=form.down('#otherProgramBatchPeriodContainer');
	    			var otherStudentFieldContainer=form.down('#otherStudentFieldContainer');
	    			var academicProgramFieldContainer=form.down('#academicProgramFieldContainer');
		 			studentId.reset();
		    		var programStore = filterForm.findField('program').getStore();
		    		
		    		evaluationplanField.reset();
					evaluationLevelName.reset();
					course.reset();
					evaluationLevel.reset();
					courseVariant.reset();
		 			studentId.reset();
		    		var evaluationplanStore=evaluationplanField.getStore();
		    		evaluationplanStore.getProxy().extraParams={
		    			academyLocationIds:alId,
		    			whetherMarksheet:true,
		    		};
		    		evaluationplanStore.load();
		    		
		    		program.reset();
		    		var programStore=program.getStore();
		    		programStore.getProxy().extraParams={
						academyLocationIds:alId,
					};
					programStore.load();
					
					studentId.getStore().getProxy().extraParams={
		    			academyLocationIds:alId,
		    			whetherMarksheet:true,
		    		};
		    		studentId.getStore().load();
		    		
		    		course.disable();
		    		var courseStore=course.getStore();
		    		courseStore.getProxy().extraParams = {
	    				academyLocationId:alId,
	    			};
	    			courseStore.load();
	    			evaluationLevel.disable();
	    			evaluationLevelName.disable();
	    			courseVariant.disable();
	    			
	    			program.disable();
	    			batch.disable();
	    			academicCourseFieldContainer.show();
	    			otherProgramBatchPeriodContainer.hide();
	    			otherStudentFieldContainer.hide();
	    			academicProgramFieldContainer.show();
	    			evaluationOtherLevel.hide();
	    			evaluationOtherLevel.reset();
		    	}
 		   },
		    
		    'examresultdeletionfilter customcombobox[itemId=evaluationplanId]': {
		    	select: function(obj, rec) {
		    		var $this=this;
		    		var data = rec[0].data.id;
		    		var assessmentType=rec[0].data.code
		    		var filterForm = obj.up('form').getForm();
		    		var form = $this.getExamresultdeletionfilter();
	    			var academyLocationId = filterForm.findField('multiselectAcademyLocation');
	    			var evaluationLevel = filterForm.findField('evaluationLevel');
	    			var evaluationLevelName = filterForm.findField('evaluationLevelName');
	    			var programField = filterForm.findField('program');
	    			var courseField = filterForm.findField('course');
	    			var studentId = filterForm.findField("studentId");
	    			var courseVariant = filterForm.findField("courseVariant");
	    			var batch = filterForm.findField("batch");
	    			var period = filterForm.findField("period");
	    			var academicCourseFieldContainer=form.down('#academicCourseFieldContainer');
	    			var otherProgramBatchPeriodContainer=form.down('#otherProgramBatchPeriodContainer');
	    			var otherStudentFieldContainer=form.down('#otherStudentFieldContainer');
	    			var academicProgramFieldContainer=form.down('#academicProgramFieldContainer');
	    			var otherProgram = filterForm.findField('otherProgram');
	    			var otherBatch = filterForm.findField('otherBatch');
	    			var otherPeriod = filterForm.findField("otherPeriod");
	    			var otherStudentId = filterForm.findField("otherStudentId");
	    			var evaluationOtherLevel = filterForm.findField("evaluationOtherLevel");			
					
		    		if(assessmentType=="ACADEMICS"){
		    			programField.enable();
		    			academicCourseFieldContainer.show();
		    			otherProgramBatchPeriodContainer.hide();
		    			otherStudentFieldContainer.hide();
		    			academicProgramFieldContainer.show();
		    			
		    			var als = [];
		    			als.push(academyLocationId.getValue());
		    			studentId.reset();
		    			programField.reset();
		    			programField.getStore().getProxy().extraParams = {
		    				planId: data,
		    				academyLocationIds:academyLocationId.getValue()
		    			};
		    			programField.getStore().load();
		    			batch.reset();
		    			batch.disable();
		    			period.reset();
		    			period.disable();
		    			evaluationLevel.reset();
		    			evaluationLevel.enable();
		    			evaluationLevel.show();
	                    studentId.enable();
                        studentId.show();
		    			courseVariant.reset();
		    			courseVariant.disable();
		    			evaluationLevelName.reset();
	                    evaluationLevelName.disable();
		    			evaluationLevelStore=evaluationLevel.getStore();
		    			var store = $this.getStore('examinationcenters.marksheet.EventEvaluationLevelType');
		    			evaluationLevelStore.on('load', function(){
		    				for(var i=0; i< store.data.items.length;i++){
		    					if(store.data.items[i].data.value == 'Assessment Scheme'){
		    						store.removeAt(i);
		    					} 
		    				}
		    			});
		    			courseField.reset();
		    			courseField.enable();                    
		    			courseStore=courseField.getStore();
		    			courseStore.getProxy().extraParams = {
		    				academyLocationId:academyLocationId.getValue(),
		    				planId:data,
		    			};
		    			courseStore.load();

		    			studentId.getStore().getProxy().extraParams={
		    				academyLocationIds:als.join(),
		    				whetherMarksheet:true,
		    				planId:data
		    			};
		    			studentId.getStore().load();
		    			evaluationOtherLevel.hide();
		    		}else{
		    			otherProgram.enable();
		    			academicCourseFieldContainer.hide();
		    			otherProgramBatchPeriodContainer.show();
		    			otherStudentFieldContainer.show();
		    			academicProgramFieldContainer.hide();
		    			
		    			var als = [];
		    			als.push(academyLocationId.getValue());
		    			otherStudentId.reset();
		    			otherProgram.reset();
		    			otherProgram.getStore().getProxy().extraParams = {
		    				planId: data,
		    				academyLocationIds:als
		    			};
		    			otherProgram.getStore().load();
		    			otherBatch.reset();
		    			otherBatch.disable();
		    			otherPeriod.reset();
		    			otherPeriod.disable();
		    			evaluationLevel.reset();
		    			evaluationLevel.enable();
		    			evaluationLevel.hide();
		    			evaluationLevelName.reset();
	                    evaluationLevelName.disable();
		    			evaluationLevelStore=evaluationLevel.getStore();
		    			var store = $this.getStore('examinationcenters.marksheet.CalculateAverageEvaluationLevelType');
		    			evaluationLevelStore.on('load', function(){
		    				for(var i=0; i< store.data.items.length;i++){
		    					if(store.data.items[i].data.value == 'Assessment Scheme'){
		    						store.removeAt(i);
		    					} 
		    				}
		    			});
		    			otherStudentId.getStore().getProxy().extraParams={
		    				academyLocationIds:als.join(),
		    				whetherMarksheet:true,
		    				planId:data
		    			};
		    			otherStudentId.getStore().load();
		    			evaluationOtherLevel.show();
		    			evaluationOtherLevel.enable();
		    		}
		    	}
            },
            'examresultdeletionfilter customcombobox[itemId=evaluationLevelItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var evaluationplanField = filterForm.findField('evaluationplan');
                    var evaluationLevelName = filterForm.findField('evaluationLevelName');
                    evaluationLevelName.reset();
                    evaluationLevelName.enable();
                    evaluationLevelName.getStore().getProxy().extraParams = {
                    	evaluationPlanId: evaluationplanField.getValue(),
                    	evaluationLevel:data,
                    };
                    evaluationLevelName.getStore().load();
                }
            },
            
            'examresultdeletionfilter customcombobox[itemId=evaluationOtherLevelItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var evaluationplanField = filterForm.findField('evaluationplan');
                    var evaluationLevelName = filterForm.findField('evaluationLevelName');
                    evaluationLevelName.reset();
                    evaluationLevelName.enable();
                    evaluationLevelName.getStore().getProxy().extraParams = {
                    	evaluationPlanId: evaluationplanField.getValue(),
                    	evaluationLevel:data,
                    };
                    evaluationLevelName.getStore().load();
                }
            },
            
            'examresultdeletionfilter customcombobox[itemId=courseItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var evaluationplanField = filterForm.findField('evaluationplan');
                    var courseVariant = filterForm.findField('courseVariant');
                    var course = filterForm.findField('course');
                    var academyLocationId = filterForm.findField('multiselectAcademyLocation');
                    var studentId = filterForm.findField('studentId');
                    var als = [];
					als.push(academyLocationId.getValue());
		 			studentId.reset();
                    courseVariant.setDisabled(false);
                    courseVariant.reset();
                    courseVariant.getStore().getProxy().extraParams = {
                    	academyLocationId:academyLocationId.getValue(),
                    	courseId:course.getValue(),
                    	evaluationPlanId:evaluationplanField.getValue()
                    };
                    courseVariant.getStore().load();
                    
                    studentId.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    			planId:evaluationplanField.getValue(),
		    			courseId:data
		    		};
		    		studentId.getStore().load();
                }
            },
            
            'examresultdeletionfilter customcombobox[itemId=courseVariantItemId]': {
                select: function(obj, rec) {
                    var data = rec[0].data.id;
                    var filterForm = obj.up('form').getForm();
                    var evaluationplanField = filterForm.findField('evaluationplan');
                    var courseVariant = filterForm.findField('courseVariant');
                    var course = filterForm.findField('course');
                    var academyLocationId = filterForm.findField('multiselectAcademyLocation');
                    var studentId = filterForm.findField('studentId');
                    var als = [];
					als.push(academyLocationId.getValue());
		 			studentId.reset();
                    studentId.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    			planId:evaluationplanField.getValue(),
		    			courseId:course.getValue(),
		    			courseVariantId:data
		    			
		    		};
		    		studentId.getStore().load();
                }
            },
            
            'examresultdeletionfilter customcombobox[itemId=programItemId]':{
				select:function(obj, record){
					var $this = this;
					var form = $this.getExamresultdeletionfilter().getForm();
					var academyLocationId = form.findField('multiselectAcademyLocation');
					var evaluationplan = form.findField('evaluationplan');
					var als = [];
					als.push(academyLocationId.getValue());
					var batchId = form.findField("batch");
					batchId.reset();
					batchId.setDisabled(false);
					var period = form.findField("period");
					period.reset();
					period.disable();
					batchId.getStore().getProxy().extraParams = {
						programId:record[0].data.id,
						whetherMarksheet:true,
						//academyLocationIds:als.join(),
					}
					batchId.getStore().load();
				}	
			},
			
			'examresultdeletionfilter customcombobox[itemId=batchItemId]':{
				select:function(obj, record){
					var $this = this;
					var form = $this.getExamresultdeletionfilter().getForm();
					var academyLocationId = form.findField('multiselectAcademyLocation');
					var als = [];
					als.push(academyLocationId.getValue());
					var period = form.findField("period");
					period.reset();
					period.setDisabled(false);
					period.getStore().getProxy().extraParams = {
						batchId:record[0].data.id,
						whetherMarksheet:true,
						//academyLocationIds:als.join(),
					}
					period.getStore().load();
					
				}	
			},
			
			'examresultdeletionfilter customcombobox[itemId=otherProgramItemId]':{
				select:function(obj, record){
					var $this = this;
					var form = $this.getExamresultdeletionfilter().getForm();
					var academyLocationId = form.findField('multiselectAcademyLocation');
					var evaluationplan = form.findField('evaluationplan');
					var als = [];
					als.push(academyLocationId.getValue());
					var batchId = form.findField("otherBatch");
					batchId.reset();
					batchId.setDisabled(false);
					var period = form.findField("otherPeriod");
					period.reset();
					period.disable();
					batchId.getStore().getProxy().extraParams = {
						programId:record[0].data.id,
						whetherMarksheet:true,
						//academyLocationIds:als.join(),
					}
					batchId.getStore().load();
				}	
			},
			
			'examresultdeletionfilter customcombobox[itemId=otherBatchItemId]':{
				select:function(obj, record){
					var $this = this;
					var form = $this.getExamresultdeletionfilter().getForm();
					var academyLocationId = form.findField('multiselectAcademyLocation');
					var als = [];
					als.push(academyLocationId.getValue());
					var period = form.findField("otherPeriod");
					period.reset();
					period.setDisabled(false);
					period.getStore().getProxy().extraParams = {
						batchId:record[0].data.id,
						whetherMarksheet:true,
						//academyLocationIds:als.join(),
					}
					period.getStore().load();
					
				}	
			},
			
			'examresultdeletionfilter button[itemId=resetBtn]':{
				click: function(obj) {
					var $this=this;
					var filterForm = obj.up('form').getForm();
					filterForm.reset();
					var form = $this.getExamresultdeletionfilter();
					var academyLocationIds =$this.getCurrentAcademyLocation();
					var alFilter = filterForm.findField('multiselectAcademyLocation').getStore();
		    		var studentId = filterForm.findField("studentId");
		    		var evaluationPlan = filterForm.findField("evaluationplan");
		    		var evaluationLevel = filterForm.findField("evaluationLevel");
		    		var evaluationLevelName = filterForm.findField("evaluationLevelName");
		    		var course = filterForm.findField("course");
		    		var courseVariant = filterForm.findField("courseVariant");
		    		var program = filterForm.findField("program");
		    		var batch = filterForm.findField("batch");
		    		var period = filterForm.findField("period");
		    		var evaluationOtherLevel = filterForm.findField("evaluationOtherLevel");
		    		var als = [];
					als.push(academyLocationIds);
		 			studentId.reset();
		    		var programStore = filterForm.findField('program').getStore();
		    		alFilter.getProxy().extraParams={
		    			id:$this.getCurrentlyLoggedInUser().id
		    		};
		    		alFilter.load({
		    			callback:function(record) {
		    				for(var i in record) {
		    					if(record[i].data.id == academyLocationIds) {
		    						filterForm.findField('multiselectAcademyLocation').setValue(record[i].data.id);
		    						programStore.getProxy().extraParams={
		    							academyLocationIds:record[i].data.id,
		    						};
		    						programStore.load();
		    					}
		    				}
		    			}
		    		});
		    		studentId.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    		};
		    		studentId.getStore().load();
		    		
		    		evaluationPlan.getStore().getProxy().extraParams={
		    			academyLocationIds:als.join(),
		    			whetherMarksheet:true,
		    		};
		    		evaluationPlan.getStore().load();
		    		course.disable();
                    studentId.disable();
		    		var courseStore=course.getStore();
		    		courseStore.getProxy().extraParams = {
	    				academyLocationId:academyLocationIds,
	    			};
	    			courseStore.load();
	    			evaluationLevel.show();
	    			evaluationLevel.disable();
	    			evaluationLevelName.disable();
	    			courseVariant.disable();
	    			
	    			var academicCourseFieldContainer=form.down('#academicCourseFieldContainer');
	    			var otherProgramBatchPeriodContainer=form.down('#otherProgramBatchPeriodContainer');
	    			var otherStudentFieldContainer=form.down('#otherStudentFieldContainer');
	    			var academicProgramFieldContainer=form.down('#academicProgramFieldContainer');
	    			program.disable();
	    			batch.disable();
	    			academicCourseFieldContainer.show();
	    			otherProgramBatchPeriodContainer.hide();
	    			otherStudentFieldContainer.hide();
	    			academicProgramFieldContainer.show();
	    			evaluationOtherLevel.hide();
				}
			},
			

		    'examresultdeletionfilter button[itemId=searchBtn]':{
				click: function(obj) {
                    this.loadExamResultDeletionFilterData();
                }
			},
			
			'examresultdeletiongrid': {
				render: function(grid) {
					if (grid.getStore().getCount() > 0) {
						grid.getStore().removeAll();
					}
		    		grid.getStore().defaultStorePageSize=0;
		            grid.getStore().loadRawData([]);
					this.doAccessControlValidation(grid, this.getEXAM_RESULT_DELETION_PRIVILEGES_PERMISSIONS());
					//	permissionsMap = this.getEXAM_RESULT_DELETION_PRIVILEGES_PERMISSIONS();
					//	this.disableMoreActionPivileges(grid, permissionsMap);
				},
				beforerender: function(grid) {
					grid.getStore().removeAll();
				},
				afterrender: function(grid) {
					var me =this;
					setTimeout(function(){
					me.addDataGridConfigButton(grid,me.getEXAM_RESULT_DELETION_PRIVILEGES_PERMISSIONS());
					},1500);
				}
			},
			/*'examresultdeletiongrid': {
				afterrender: function(grid) {
					var me =this;
					setTimeout(function(){
					me.addDataGridConfigButton(grid,me.getEXAM_RESULT_DELETION_PRIVILEGES_PERMISSIONS());
					},1500);
				}
			},*/
			'examresultdeletiongrid button[itemId=btnDelete]' : {
				click : function() {
					this.deleteExamResultRecord();
				}
			},
			'examresultdeletionstructure' : {
				afterrender : function(structure){
					var form = structure.down('form');
					var grid = structure.down('examresultdeletiongrid');
					this.getGridHeaderFreeze(grid,form);
				}
			},
			
			'calculateaveragegrid button[itemId=condoneSubjectButtonId]':{
				click:function(obj){
					var me = this;
					var structure = Ext.widget('subjectassessmentdetailsstructure');
					me.openSubjectAssessmentDetailTab(structure);
					me.checkSavePermission(structure,me.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS());
					var filterForm = structure.down('form').getForm();
					var grid = structure.down('grid');
					var record=obj.up('grid').getSelectionModel().getSelection()[0];
					me.loaddynamicColumns(grid,record,filterForm);
					
				}
            },
            
            
            'subjectassessmentdetailsstructure checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var grid = obj.up('grid');
            		var store = grid.getStore();
            		var models = store.getRange();
            		
            		if(checked){
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i && store.data.items[i].data.revisedResultStatus!="PASS"){
            					Ext.defer(function() {
            						models[rowIndex].set('isCondoneSubject', true);
            						models[rowIndex].set('revisedResultStatus','CONDONED_SUBJECT_PASS');
            					}, 50, this);
            					break;
            				}
            			}
            		} else {
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i && store.data.items[i].data.revisedResultStatus!="PASS"){
            					Ext.defer(function() {
            						models[rowIndex].set('isCondoneSubject', false);
            						models[rowIndex].set('revisedResultStatus','FAIL');
            					}, 50, this);
            					break;
            				}
            			}
            		}
            	}
            },
            
            
            'subjectassessmentdetailsstructure button[itemId=btnsaveSubjectAssessmentDetail]':{
            	click:function(obj){
            		var $this=this;
            		var grid = this.getSubjectassessmentdetailsstructure().down('grid');
            		var selectionGrid=this.getCalculateaveragegrid();
            		calculateAverageRecord=selectionGrid.getSelectionModel().getSelection()[0];
            		var store = grid.getStore();
            		var saveData;
            		var statusArray = new Array();            		
            		var modifiedRecords = new Ext.util.HashMap();
					var marksheetRecords = new Ext.util.HashMap();
            		var batchName=store.data.items[0].data.batchName;
            		for(var i in store.data.items){
            			if(store.data.items[i].data.revisedResultStatus!='PASS'){
            				if(store.data.items[i].data.isCondoneSubject!=null){
            					modifiedRecords.add(parseInt(store.data.items[i].data.evalPlanRankId),store.data.items[i].data.isCondoneSubject);
								marksheetRecords.add(parseInt(store.data.items[i].data.marksheetId),store.data.items[i].data.isCondoneSubject);
            				}
            			}
            			statusArray.push(store.data.items[i].data.revisedResultStatus);
            			
            		}
            		
            		var formValues = Ext.encode(modifiedRecords.map);
            		var examStudentAvergeId=null;
            		if(!isNullOrEmpty(calculateAverageRecord.data.examStudentAverageId)){
            			examStudentAvergeId=calculateAverageRecord.data.examStudentAverageId;
            		}
            			
            		
            		saveData={
							'planRankData':modifiedRecords.map,
							'examStudentAverageId':examStudentAvergeId,
							'statusList':statusArray,
							'batchName':batchName,
							'marksheetData':marksheetRecords.map
					}
            		
            	
            		if(store.data.length > 0) {
            			Ext.Ajax.request({
            				type: 'rest',
            				jsonData:saveData,
            				url: SERVERURL.FIND_SAVE_CALCULATE_AVERAGE_DETAILS,
            				method: 'POST',
            				success: function(obj, action) {
            					Ext.getBody().unmask();
            					grid.store.load();
            					 var contentpanel = $this.getContentPanel();
            					 
            					  var tabName = getExaminationTranslation('SUBJECT_LEVEL_STATUS');
            					  var getcontroller=$this.getController('menu.CoreERPNavigationController');
            					  var getTab=getcontroller.getTab(tabName);
            					  if(getTab!=null){
            						  contentpanel.remove(getTab, true);
            					  }
            					selectionGrid.down('#condoneSubjectButtonId').disable();
            					selectionGrid.getStore().load();
            					showSuccessMessage(getExaminationTranslation('CALCULATE_AVERAGE'), getCommonTranslation('SUCCESS'));
            				}
            			});
            		}else{
            			showWarningMessage(getExaminationTranslation('CALCULATE_AVERAGE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		} 
            	}
            },
            
            'calculateaverageyearlyfilter': {
            	render: function(view) {
            		this.onCalculateAvgYearlyFilterRender(view);
            	}
            },
            
            'calculateaverageyearlyfilter customcombobox[itemId=programItemId]': {
                select: function(obj, rec) {
                	this.onProgramSelect(obj, rec);
                }
            },
            
            'calculateaverageyearlyfilter customcombobox[itemId=batchItemId]': {
                select: function(obj, rec) {
                	this.onBatchSelect(obj, rec);
                }
            },
            
            'calculateaverageyearlyfilter customcombobox[itemId=periodItemId]': {
                select: function(obj, rec) {
                	this.onPeriodSelect(obj, rec);
                }
            },
            
            'calculateaverageyearlyfilter button[itemId=resetBtn]': {
                click: function(obj) {
                	this.onResetFilterForm(obj);
                }
            },
            
            'calculateaverageyearlyfilter button[itemId=searchBtn]': {
                click: function(obj) {
                    this.loadCalculateAverageYearlyFilterData();
                }
            },
            'calculateaverageyearlygrid': {
                afterrender: function(grid) {
                	var me =this;
                    if (grid.getStore().getCount() > 0) {
                        grid.getStore().removeAll();
                    }
                    this.doAccessControlValidation(grid, this.getCALCULATE_AVERAGE_YEARLY_PRIVILEGES_PERMISSIONS());
                    permissionsMap = this.getCALCULATE_AVERAGE_YEARLY_PRIVILEGES_PERMISSIONS();
					this.applyGridButtonPivileges(grid, permissionsMap);
                },
                selectionchange: function(sm, selected) {
                	var grid = sm.view.up('grid');
                	grid.down('#caclulateAverageYearlyBtnId').setDisabled(!selected.length);
                	var progBtnFlag = true;
                	var deleteBtnFlag = true;
                	for(var i = 0; i < selected.length; i++) {
                		if(!Ext.isEmpty(selected[i].get('yearlyAverage'))) {
                			progBtnFlag = false;
                		}
                		else {
                			progBtnFlag = true;
                			break;
                		}
                	}
                	grid.down('#caclulateProgAverageYearlyBtnId').setDisabled(progBtnFlag);
                	
                	for(var j = 0; j < selected.length; j++) {
                		if(!Ext.isEmpty(selected[j].get('yearlyAverage')) || !Ext.isEmpty(selected[j].get('programAverage'))) {
                			deleteBtnFlag = false;
                		}
                		else {
                			deleteBtnFlag = true;
                			break;
                		}
                	}
                	grid.down('#deleteButtonId').setDisabled(deleteBtnFlag);
                }
            },
            'calculateaverageyearlygrid button[itemId=caclulateAverageYearlyBtnId]': {
				click: this.caclulateAverageYearly
			}
			,
            'calculateaverageyearlygrid button[itemId=caclulateProgAverageYearlyBtnId]': {
				click: this.caclulateProgramAverage
			},
            'calculateaverageyearlygrid button[itemId=deleteButtonId]': {
				click: this.deleteAverage
			},
			'calculateaveragegrid button[itemId=calculateRankButtonId]': {
				click: this.calculateRank
			},
			'calculateAverageLevelWiseGrid': {
				afterrender: this.levelWiseGridRender,
				selectionchange: this.onLevelWiseGridSelectionChange,
				cellclick: this.redirectToAverageDetails
			},
			'calculateAverageLevelWiseFilter customcombobox[itemId=programItemIdLvlWise]': {
                select: function(obj, rec) {
                	this.onProgramSelectLevelWise(obj, rec);
                }
            },
			'calculateAverageLevelWiseFilter customcombobox[itemId=batchItemIdLvlWise]': {
                select: function(obj, rec) {
                	this.onBatchSelectLevelWise(obj, rec);
                }
            },
			'calculateAverageLevelWiseFilter customcombobox[itemId=evaluationLevelItemIdLvlWise]': {
                select: function(obj, rec) {
                	this.onLevelSelectLevelWise(obj, rec);
                }
            },
            'calculateAverageLevelWiseFilter button[itemId=resetBtn]': {
                click: function(obj) {
                	this.resetLevelWiseFilter(obj);
                }
            },
            'calculateAverageLevelWiseFilter button[itemId=searchBtn]': {
                click: function(obj) {
                	this.loadCalculateAverageLevelWiseFilterData(obj);
                }
            },
            'calculateAverageLevelWiseGrid button[itemId=caclulateAverageLevelWiseBtnId]': {
				click: this.doCaclulateAverageLevelWise
			},
            'calculateAverageLevelWiseGrid button[itemId=deleteLevelWiseBtnId]': {
				click: this.deleteAverageLevelWise
			}
        });
    },
    loadCalculateAverageFilterData: function() {
        var $this = this;
        var filterForm = $this.getCalculateaveragefilter().getForm();
        var calFilterForm = $this.getCalculateaveragefilter();
        var calculateAverageGrid = $this.getCalculateaveragegrid();
        var filterFormValues = filterForm.getValues();
        
        var evalLevelNameField = filterForm.findField('evalLevelName');
        var evaluationLevelName = filterForm.findField('evaluationLevel').getValue();
        var evalPromotionStatus=filterForm.findField('evalPromotionStatus').getValue();
		/*
		STEP 1:  create a variable name promotionStatus and find the field lile evaluationLevelName:1239 
		STEP 2: get the value from the combobox 
		STEP 3": PASS the value in the as '$variable':Line:1307
		 */

        var academyLocationId = $this.getCurrentAcademyLocation();
        var sectionArray = [];
        var records;
        if (!isNullOrEmpty(filterFormValues.sectionId)) {
            for (var i = 0; i < filterFormValues.sectionId.length; i++) {
                var sectionValue = filterFormValues.sectionId[i];
                if (Ext.isObject(sectionValue)) {
                    sectionArray.push(sectionValue.data.sectionId);
                } else {
                    sectionArray.push(sectionValue);
                }
            }
        }
		var buttonsToolBar = calculateAverageGrid.query('toolbar')[0];
		var condoneSubjectButton = buttonsToolBar.query('#condoneSubjectButtonId')[0];
        if(evaluationLevelName=="EVALUATION_PLAN"){
        	condoneSubjectButton.setVisible(true);
        	permissionsMap = $this.getCALCULATE_AVERAGE_PRIVILEGES_PERMISSIONS();
			this.disableCondoneSubject(calculateAverageGrid, permissionsMap);
        } else {
        	condoneSubjectButton.hide();
        }
        
        
       /* var evalLevelNameArray = [];
        var records;
        var whetherSinglePlan;
        if (!isNullOrEmpty(filterFormValues.evalLevelName)) {
            for (var i = 0; i < filterFormValues.evalLevelName.length; i++) {
                var evalLevelNameValue = filterFormValues.evalLevelName[i];
                if (Ext.isObject(evalLevelNameValue)) {
                	evalLevelNameArray.push(evalLevelNameValue.data.id);
                } else {
                	evalLevelNameArray.push(evalLevelNameValue);
                }
                whetherSinglePlan=evalLevelNameValue.data.secondCheck;
            }
        }
        if(!isNullOrEmpty(whetherSinglePlan) && whetherSinglePlan && evalLevelNameArray.length>1) {
        	showWarningMessage(getCommonTranslation("ALERT"), 'More than one reporting cycle of same assessment scheme cannot be selected '+
        			'for student average calculation.');
        	return;
        }*/
        var evalLevelIds = filterForm.findField('evalLevelIds').getValue();
        var levelOneId=null;
        var levelTwoId=null;
        var methodId=null;
        var planId=null;
        var levelId=null;
        if (evaluationLevelName=="EVALUATION_PLAN"){
        	planId= evalLevelIds;
        } else if(evaluationLevelName=="EVALUATION_TYPE"){
        	//levelOneId= evalLevelNameArray.join();
        }  else if (evaluationLevelName=="EVALUATION_SUB_TYPE"){
        //	levelTwoId= evalLevelNameArray.join();
        } else if (evaluationLevelName=="EVALUATION_METHOD"){
        //	methodId=evalLevelNameArray.join();
        }
        levelId=evalLevelIds;
        calculateAverageGrid.getStore().getProxy().extraParams = {
            academyLocationId: academyLocationId,
            programId: filterFormValues.programId,
            batchId: filterFormValues.batchId,
            periodId: filterFormValues.periodId,
            sectionIds: sectionArray.join(),
            levelName: filterFormValues.evaluationLevel,
            levelValue: filterFormValues.evalLevelName,
            evaluationPlanLevelOneId:levelOneId,
            evaluationPlanLevelTwoId:levelTwoId,
            evalSeqId:methodId,
            evaluationPlanId:planId,
            levelId:evalLevelIds,
            promotionStatus:evalPromotionStatus
        };
        $this.resetGridSetting(calculateAverageGrid);
        calculateAverageGrid.getStore().load({
        	callback: function(records, operation, success) {
        		if(records && records.length) {
        			var calcRankDisable = true;
        			for(var i = 0; i < records.length; i++) {
        				if(isNullOrEmpty(records[i].get('marks')) || records[i].get('marks') == '0' || records[i].get('marks') == '0.00' || records[i].get('marks') == '0.0') {
        					calcRankDisable = true;
        				}
        				else {
        					calcRankDisable = false;
        					break;
        				}
        			}
        			if(calculateAverageGrid.down('#calculateRankButtonId') && calcRankDisable == false) {
        				calculateAverageGrid.down('#calculateRankButtonId').enable();
        			}
        		}
        		else {
        			if(calculateAverageGrid.down('#calculateRankButtonId')) {
        				calculateAverageGrid.down('#calculateRankButtonId').disable();
        			}
        		}
        	}
        });
        calculateAverageGrid.getSelectionModel().deselectAll();
        calculateAverageGrid.config.searchFilterForm = calFilterForm;
       
    },

    disableMoreActionPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var caclulateAverageButtonId = gridReference.down("#caclulateAverageButtonId");
        caclulateAverageButtonId.setVisible(false);
        var DeleteButtonId = gridReference.down("#DeleteButtonId");
        DeleteButtonId.setVisible(false);
        var calculateRankBtn = gridReference.down("#calculateRankButtonId");
        calculateRankBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'CALCULATE_AVERAGE') {
                if (!isNullOrEmpty(caclulateAverageButtonId)) {
                    caclulateAverageButtonId.setVisible(true);
                }
            } 
            if (privilege === 'DELETE') {
                if (!isNullOrEmpty(DeleteButtonId)) {
                    DeleteButtonId.setVisible(true);
                }
            }
            if (privilege === 'CALCULATE_RANK') {
                if (!isNullOrEmpty(calculateRankBtn)) {
                	calculateRankBtn.setVisible(true);
                }
            }
       }
        );
    },
    
    disableCondoneSubject: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
    
        var condoneSubjectButton = gridReference.down("#condoneSubjectButtonId");
        condoneSubjectButton.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'CONDONE_SUBJECTS') {
                if (!isNullOrEmpty(condoneSubjectButton)) {
                	condoneSubjectButton.setVisible(true);
                }
            }
       }
        );
    },
    
    openCalculateAverageWindow:function(){
 	   var formWindow = this.getCalculateaveragewin();
 	   if (!formWindow) {
 		   Ext.widget('calculateaveragewin');
 		   formWindow = this.getCalculateaveragewin();
 	   }
 	   formWindow.show();  
    },
    
    saveStudentAverageData:function(obj){
    	var $this=this;
    	var formWindow = $this.getCalculateaveragewin();
    	var calculateAverageGrid=$this.getCalculateaveragegrid();
    	var filterForm = $this.getCalculateaveragefilter().getForm();
    	var evaluationLevelName = filterForm.findField('evaluationLevel').getValue();
    	var levelValue=filterForm.findField('evalLevelName').valueModels[0].data.id;
    	//var droolId=formWindow.down('#droolsItemId').getValue();
    	var records = calculateAverageGrid.getSelectionModel().getSelection();
    	var ruleApplicable=records[0].data.droolCode.replaceAll(",$", "");
    	var droolId=records[0].data.droolId;
    	var arrayData=[];
    	var data=null;

    	var levelOneId=null;
    	var levelTwoId=null;
    	var methodId=null;
    	var planId=null;
    	if (evaluationLevelName=="EVALUATION_PLAN"){
    		planId= levelValue;
    	} else if(evaluationLevelName=="EVALUATION_TYPE"){
    		levelOneId= levelValue;
    	}  else if (evaluationLevelName=="EVALUATION_SUB_TYPE"){
    		levelTwoId=levelValue;
    	} else if (evaluationLevelName=="EVALUATION_METHOD"){
    		methodId=levelValue;
    	}
    	if(records.length > 0){
    		for(var i in records){
    			
    			data={
    					"id":records[i].data.examStudentAverageId,
    					"admissionId" : records[i].data.admissionId,
    					"periodId":records[i].data.periodId,
    					"evaluationPlanId" :planId ,
    					"evaluationPlanLevelOneId" :levelOneId ,
    					"evaluationPlanLevelTwoId" : levelTwoId,
    					"evaluationSequenceId": methodId,
    					"droolId" : droolId,
    					"courseDetailsList":records[i].data.courseDetailsList,
    					"ruleApplicable":ruleApplicable,
    					"roundingMode":records[i].data.roundingMode,
    					"roundingCount":records[i].data.roundingCount,
    					"levelName":records[i].data.levelName,
    					"levelIds":records[i].data.levelIds,
    					"examStudentAverageDetailList":records[i].data.examStudentAverageDetailList,
    					"revisedPromotionStatus":records[i].data.revisedPromotionStatus
    			};
    			arrayData.push(data);
    		}
    	}

    	var submitUrl;
    	submitUrl = SERVERURL.PATH_CALCULATE_STUDENT_AVERAGE;
    	Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : arrayData,
    		method : 'POST',
    		success : function(response, action) {
    			Ext.getBody().unmask();
    			obj.setDisabled(false);
    			showSuccessMessage(getExaminationTranslation('STUDENT_AVERAGE'),getExaminationTranslation('STUDENT_AVERAGE_SAVED_SUCCESSFULLY'));
    			/**
    			 * this condition is for window only
    			 */
    			//formWindow.close();
    			calculateAverageGrid.getStore().load({
						callback: function(records, operation, success) {
				        		if(records && records.length) {
				        			var calcRankDisable = true;
				        			for(var j = 0; j < records.length; j++) {
				        				if(isNullOrEmpty(records[j].get('marks')) || records[j].get('marks') == '0' || records[j].get('marks') == '0.00' || records[j].get('marks') == '0.0') {
				        					calcRankDisable = true;
				        				}
				        				else {
				        					calcRankDisable = false;
				        					break;
				        				}
				        			}
				        			if(calculateAverageGrid.down('#calculateRankButtonId') && calcRankDisable == false) {
				        				calculateAverageGrid.down('#calculateRankButtonId').enable();
				        			}
				        		}
				        		else {
				        			if(calculateAverageGrid.down('#calculateRankButtonId')) {
				        				calculateAverageGrid.down('#calculateRankButtonId').disable();
				        			}
				        		}
				        	}
						});
    			calculateAverageGrid.getSelectionModel().deselectAll();
    		}
    	});
    },
    
    loadExamResultDeletionFilterData: function() {
        var $this = this;
        var filterForm = $this.getExamresultdeletionfilter().getForm();
        var form = $this.getExamresultdeletionfilter();
        var examresultdeletiongrid = $this.getExamresultdeletiongrid();
        var filterFormValues = filterForm.getValues();
        
        var multiselectAcademyLocation = filterForm.findField('multiselectAcademyLocation');
        var evalLevelNameField = filterForm.findField('evalLevelName');
        var evaluationplan = filterForm.findField('evaluationplan');
        var evaluationLevelName = filterForm.findField('evaluationLevel').getValue();
        var evaluationOtherLevel = filterForm.findField('evaluationOtherLevel').getValue();
        var evaluationLevelNameId = filterForm.findField('evaluationLevelName').getValue();
        
        
        var assessmentType=evaluationplan.valueModels[0].data.code;
        var programId,batchId,periodId,courseId,courseVariantId,admissionId,admissionId,levelId=null;
        var levelOneId=null;
        var levelTwoId=null;
        var methodId=null;
        var eventId=null;
        if(evaluationLevelName=="EVALUATION_TYPE" || evaluationOtherLevel=="ASSESSMENT_CATEGORY"){
        	levelOneId=evaluationLevelNameId;
        }else if(evaluationLevelName=="EVALUATION_SUB_TYPE" || evaluationOtherLevel=="ASSESSMENT_SUB_CATEGORY"){
        	levelTwoId=evaluationLevelNameId;
        }else if(evaluationLevelName=="EVALUATION_METHOD" || evaluationOtherLevel=="ASSESSMENT_METHOD"){
        	methodId=evaluationLevelNameId;
        }else if(evaluationLevelName=="EVALUATION_EVENT" ||  evaluationOtherLevel=="ASSESSMENT_EVENT"){
        	eventId=evaluationLevelNameId;
        }
        if(assessmentType=="ACADEMICS"){
        	examresultdeletiongrid.columns[7].setVisible(true);
        	examresultdeletiongrid.columns[8].setVisible(true);
        	examresultdeletiongrid.columns[9].setVisible(true);
        	programId= filterFormValues.program;
        	batchId= filterFormValues.batch;
        	periodId= filterFormValues.period;     
        	admissionId=filterFormValues.studentId;
        }else{
        	examresultdeletiongrid.columns[7].setVisible(false);
        	examresultdeletiongrid.columns[8].setVisible(false);
        	examresultdeletiongrid.columns[9].setVisible(false);
        	programId= filterFormValues.otherProgram;
        	batchId= filterFormValues.otherBatch;
        	periodId= filterFormValues.otherPeriod;     
        	admissionId=filterFormValues.otherStudentId;
        }
     //   examresultdeletiongrid.getStore().pageSize=100;
     //   examresultdeletiongrid.getStore().limit=100;
        examresultdeletiongrid.getStore().getProxy().extraParams = {
            academyLocationId: filterFormValues.multiselectAcademyLocation,
            programId: programId,
            batchId: batchId,
            periodId: periodId,
            admissionId:admissionId,
          //  levelName: evaluationLevel,
          //  levelValue: filterFormValues.evalLevelName,
            evaluationPlanLevelOneId:levelOneId,
            evaluationPlanLevelTwoId:levelTwoId,
            evalSeqId:methodId,
            evalSeqDetailId:eventId,
            evaluationPlanId:filterFormValues.evaluationplan,
          //  levelId:levelId,
            courseId:filterFormValues.course,
            courseVariantId:filterFormValues.courseVariant,
            assessmentType:assessmentType
        };
        $this.resetGridSetting(examresultdeletiongrid);
        //examresultdeletiongrid.getStore().load();
        examresultdeletiongrid.config.searchFilterForm = form;
        
        $this.resetPageSetting(examresultdeletiongrid.getStore(), examresultdeletiongrid);
        examresultdeletiongrid.getStore().load();     
        examresultdeletiongrid.getSelectionModel().deselectAll();
        //examresultdeletiongrid.getStore().pageSize=;
    },
    
    deleteExamResultRecord:function(){
    	var $this=this;
    	var grid = $this.getExamresultdeletiongrid();
    	var records = grid.getSelectionModel().getSelection();
    	var arrayData=[];
    	var data=null;
    	var gridSelectionCount =grid.getSelectionModel().getCount()
    	if ( gridSelectionCount > 0) {
    		if(records.length > 0){
    			for(var i in records){
    				data={
    						"id": records[i].data.id /*,
    						"methodId":records[i].data.methodId,
    						"subTypeId":records[i].data.subTypeId,
    						"typeId":records[i].data.typeId,
    						"courseVariantId":records[i].data.courseVariantId,
    						"periodId":records[i].data.periodId,
    						"sectionId":records[i].data.sectionId,
    						"admissionId" : records[i].data.admissionId,
    						"evaluationPlanId" :records[i].data.evaluationPlanId,
    						"planType":records[i].data.planType,
    						"batchId":records[i].data.batchId*/
    				};
    				arrayData.push(data);
    			}
    		}
    		var submitUrl;
    		submitUrl = SERVERURL.PATH_FIND_DELETE_MARK_ENTRY;
    		showConfirmMessage(getExaminationTranslation('EXAM_RESULT_DELETION'),getExaminationTranslation('EXAM_RESULT_DELETE_POPUP_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : arrayData,
    					method : 'DELETE',
    					success : function(response, action) {
    						Ext.getBody().unmask();
    						grid.getStore().reload();
    						grid.getSelectionModel().deselectAll();
    						if(gridSelectionCount>100){
    							showWarningMessage(getExaminationTranslation('EXAM_RESULT_DELETION'), getExaminationTranslation('EXAM_RESULT_DELETION_PROGRESS'));
    						}else{
    							showSuccessMessage(getExaminationTranslation('EXAM_RESULT_DELETION'), getCommonTranslation('EXAM_RESULT_DELETED_SUCCESSFULLY'));
    						}
    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
    	}
    },
    
    openAssessmentSubjectListTab: function(structure) {
    	  var $this=this;
		  var contentpanel = $this.getContentPanel();
		 
		  var tabName = getExaminationTranslation('ASSESSMENT_SUBJECT_LIST');
		  /**
		   * This is to remove tab from content panel and open same tab again 
		   */
		  var getcontroller=$this.getController('menu.CoreERPNavigationController');
		  var getTab=getcontroller.getTab(tabName);
		  if(getTab!=null){
			  contentpanel.remove(getTab, true);
		  }
		 
		  openTab(contentpanel, tabName, structure);
    },
    
    openSubjectAssessmentDetailTab: function(structure) {
  	  var $this=this;
		  var contentpanel = $this.getContentPanel();
		 
		  var tabName = getExaminationTranslation('SUBJECT_LEVEL_STATUS');
		  /**
		   * This is to remove tab from content panel and open same tab again 
		   */
		  var getcontroller=$this.getController('menu.CoreERPNavigationController');
		  var getTab=getcontroller.getTab(tabName);
		  if(getTab!=null){
			  contentpanel.remove(getTab, true);
		  }
		 
		  openTab(contentpanel, tabName, structure);
  },
  
  checkSavePermission: function(gridReference, permissionsMap) {
	  var associatedAcadLocationIds = new Array();
	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	  var btnsaveSubjectAssessmentDetail = gridReference.down('#btnsaveSubjectAssessmentDetail');
	  btnsaveSubjectAssessmentDetail.setVisible(false);

	  Ext.each(permissionList, function(privilege) {
		  if (privilege === 'SAVE') {
			  if (!isNullOrEmpty(btnsaveSubjectAssessmentDetail)) {
				  btnsaveSubjectAssessmentDetail.setVisible(true);
			  }
		  } 
	  }
	  );
  },
  
  loaddynamicColumns:function(grid,record,filterForm){
	  var $this = this;

	  var levelIdsArray = []; 
	  if (!isNullOrEmpty(record.data.courseDetailsList)) {
		  for (var i = 0; i < record.data.courseDetailsList.length; i++) {
			  levelIdsArray.push(record.data.courseDetailsList[i].levelId);
		  }
	  }

	  grid.getStore().getProxy().extraParams = {
		  evaluationLevel: record.data.levelName,
		  levelIds:levelIdsArray.join(),
		  admissionId:record.data.admissionId,
		  periodId:record.data.periodId,
		  droolCode:record.data.droolCode
	  };
	  var models = grid.getStore().getRange();
	  grid.getStore().load({
		  callback:function(records) {
			  if(!isNullOrEmpty(records) && records.length>0){
				  var newRecord = records[0].data;
				  if(!isNullOrEmpty(newRecord.studentCode) && !isNullOrEmpty(newRecord.studentName)){
					  filterForm.findField('studentCodeName').setValue(newRecord.studentCode+'/'+newRecord.studentName);
				  }
				  if(!isNullOrEmpty(newRecord.programName) && !isNullOrEmpty(newRecord.batchName)){
					  filterForm.findField('gradeIntake').setValue(newRecord.programName+'-'+newRecord.batchName);
				  }
				  filterForm.findField('sectionName').setValue(record.data.sectionName);
				  filterForm.findField('assessmentLevelName').setValue(getExaminationTranslation(record.data.levelName));
				  filterForm.findField('assessmentLevelValue').setValue(newRecord.levelValue);
				  filterForm.findField('droolName').setValue(newRecord.droolName);
			  }
		  }
	  });
	
  },
  
  onCalculateAvgYearlyFilterRender: function(obj) {
	  var $this = this;
	  var form = obj.getForm();
	  var academyLocationId = this.getCurrentAcademyLocation();
	  var portalId = $this.getCurrentLoggedPortalId();
	  var facultyId = $this.getCurrentlyLoggedInUser();
	  var programField = form.findField('programId');
	  programField.getStore().load();
  },
  
  onProgramSelect: function(obj, rec) {
	  var data = rec[0].data.id;
	  var filterForm = obj.up('form').getForm();
	  var batchField = filterForm.findField('batchId');
	  var period = filterForm.findField('periodId');
	  batchField.enable();
	  batchField.reset();
	  batchField.getStore().loadRawData([]);
	  batchField.getStore().getProxy().extraParams = {
		  programId: data
	  };
	  batchField.getStore().load({
		  callback:function(record) {
			  if(record.length==1){
				  batchField.select(record[0]);
				  batchField.fireEvent('select', batchField, record[0]);
			  }else{
				  period.reset();
				  period.setDisabled(true);
			  }
		  }
	  });
  },
  
  onBatchSelect: function(obj, rec) {
	  if(Ext.isArray(rec)) {
		  rec = rec[0];
	  }
	  var data = rec.data.id;
	  var filterForm = obj.up('form').getForm();
	  var programField = filterForm.findField('programId'); 
	  var batchField = filterForm.findField('batchId');
	  var periodField = filterForm.findField('periodId'); 
	  periodField.enable();
	  periodField.reset();
	  periodField.getStore().loadRawData([]);
	  periodField.getStore().getProxy().extraParams = {
		  batchId: data
	  };
	  periodField.getStore().load({
		  callback:function(records,value,rec){
			  if(records.length == 1){
				  periodField.select(records[0]);
				  periodField.fireEvent('select', periodField, records[0]);
			  }								   
		  }
	  });
  },
  
  onPeriodSelect: function(obj, rec) {
	  if(Ext.isArray(rec)) {
		  rec = rec[0];
	  }
	  var data = rec.data.id;
	  var filterForm = obj.up('form').getForm();
	  var admissionCodeSTDNameField = filterForm.findField('admissionCodeSTDName'); 
	  var batchField = filterForm.findField('batchId');
	  var periodField = filterForm.findField('periodId'); 
	  admissionCodeSTDNameField.enable();
	  admissionCodeSTDNameField.reset();
	  admissionCodeSTDNameField.getStore().loadRawData([]);
	  admissionCodeSTDNameField.getStore().getProxy().extraParams = {
		  batchId: batchField.getValue(),
		  periodYearId: periodField.getValue(),
		  name: ''
	  };
	  admissionCodeSTDNameField.getStore().load();
  },
  
  onResetFilterForm: function(obj) {
	  var $this=this;
	  var filterForm = obj.up('form').getForm();
	  filterForm.findField('batchId').disable();
	  filterForm.findField('periodId').disable();
	  filterForm.findField('admissionCodeSTDName').disable();
	  filterForm.reset();
	  var program=filterForm.findField('programId');
	  program.getStore().load();
  },
  
  loadCalculateAverageYearlyFilterData: function() {
	  var $this = this;
	  var yearlyFilterForm = $this.getCalculateaverageyearlyfilter().getForm();
	  var calYearlyFilterForm = $this.getCalculateaverageyearlyfilter();
	  var calculateAverageYearlyGrid = $this.getCalculateaverageyearlygrid();
	  var yearlyFilterFormValues = yearlyFilterForm.getValues();

	  var academyLocationId = $this.getCurrentAcademyLocation();

	  calculateAverageYearlyGrid.getStore().getProxy().extraParams = {
		  admissionId: yearlyFilterFormValues.admissionCodeSTDName,
		  batchId: yearlyFilterFormValues.batchId,
		  periodYearId: yearlyFilterFormValues.periodId
	  };
	  $this.resetGridSetting(calculateAverageYearlyGrid);
	  calculateAverageYearlyGrid.getStore().load();
	  calculateAverageYearlyGrid.getSelectionModel().deselectAll();
	  calculateAverageYearlyGrid.config.searchFilterForm = calYearlyFilterForm;
  },
  
  applyGridButtonPivileges: function(gridReference, permissionsMap) {
      var associatedAcadLocationIds = new Array();
      associatedAcadLocationIds.push(this.getCurrentAcademyLocation());

      var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
      var buttonsToolBar = gridReference.query('toolbar')[0];
	  var btnRefArray = ['caclulateAverageYearlyBtnId', 'caclulateProgAverageYearlyBtnId', 'deleteButtonId'];
      Ext.each(btnRefArray, function(ref) {
    	  var btn = buttonsToolBar.down('#' + ref);
    	  if(btn) {
    		  btn.hide();
    	  }
    	  if(permissionList.indexOf('CALCULATE_AVERAGE_YEARLY_CALC_AVG') != -1) {
    		  buttonsToolBar.down('#caclulateAverageYearlyBtnId').show();
    	  }
    	  if(permissionList.indexOf('CALCULATE_AVERAGE_YEARLY_CALC_PROG_AVG') != -1) {
    		  buttonsToolBar.down('#caclulateProgAverageYearlyBtnId').show();
    	  }
    	  if(permissionList.indexOf('DELETE') != -1) {
    		  buttonsToolBar.down('#deleteButtonId').show();
    	  }
     });
  },
  
  caclulateAverageYearly: function(btn) {
	  btn.setDisabled(true);
	var grid = this.getCalculateaverageyearlygrid();
	var selections = grid.getSelectionModel().getSelection();
	var jsonData = [];
	if(selections.length) {
	for(var i = 0; i < selections.length; i++) {
		var obj = {
			admissionId: selections[i].get('admissionId'),
			batchId: selections[i].get('batchId'),
			periodYearId: selections[i].get('periodYearId'),
			periodYearName: selections[i].get('periodYearName'),
			programId: selections[i].get('programId'),
			yearlyAverageId: selections[i].get('yearlyAverageId')
		};
		jsonData.push(obj);
	}
	Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : SERVERURL.PATH_YEARLY_AVERAGE_CALCULATIONS,
		jsonData : jsonData,
		method : 'POST',
		success : function(response, action) {
			Ext.getBody().unmask();
			grid.getStore().load();
			grid.getSelectionModel().deselectAll();
			showSuccessMessage(getExaminationTranslation('STUDENT_AVERAGE'), getExaminationTranslation('YEARLY_AVG_SUCCESS'));
		}
	}); 
	}
	},
	  caclulateProgramAverage: function(btn) {
		  btn.setDisabled(true);
	var grid = this.getCalculateaverageyearlygrid();
	var selections = grid.getSelectionModel().getSelection();
	var jsonData = [];
	if(selections.length) {
	for(var i = 0; i < selections.length; i++) {
		var obj = {
			admissionId: selections[i].get('admissionId'),
			batchId: selections[i].get('batchId'),
			programId: selections[i].get('programId'),
			programAverageId: selections[i].get('programAverageId')
		};
		jsonData.push(obj);
	}
	Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : SERVERURL.PATH_PROGRAM_AVERAGE_CALCULATIONS,
		jsonData : jsonData,
		method : 'POST',
		success : function(response, action) {
			Ext.getBody().unmask();
			grid.getStore().load();
			grid.getSelectionModel().deselectAll();
			showSuccessMessage(getExaminationTranslation('STUDENT_AVERAGE'), getExaminationTranslation('PROG_AVG_SUCCESS'));
		}
	});
	}
},
	deleteAverage: function(btn) {
		btn.setDisabled(true);
		var grid = this.getCalculateaverageyearlygrid();
		var selections = grid.getSelectionModel().getSelection();
		var jsonData = [];
		for(var i = 0; i < selections.length; i++) {
			jsonData.push({
				id: selections[i].get('yearlyAverageId'),
				secondId: selections[i].get('programAverageId')
			});
		}
		Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_DELETE_YEARLY_AVERAGE,
			jsonData : jsonData,
			method : 'POST',
			success : function(response, action) {
				Ext.getBody().unmask();
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
				showSuccessMessage(getExaminationTranslation('AVERAGE_DELETION'), getExaminationTranslation('AVERAGE_DELETED_SUCCESSFULLY'));
			}
		});
	},
	
	calculateRank: function(btn) {
		var $this = this;
		var filterForm = $this.getCalculateaveragefilter().getForm();
		var filterFormValues = filterForm.getValues();
		var evalLevelId = filterForm.findField('evalLevelName').lastSelection[0].get('id');
		Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_CALC_RANK + '?periodId=' + filterFormValues.periodId + '&levelName=' + filterFormValues.evaluationLevel + '&levelId=' + evalLevelId,
			/*params : {
				periodId: filterFormValues.periodId,
				levelName: filterFormValues.evaluationLevel,
				levelId:evalLevelId
			},*/
			method : 'POST',
			success : function(response, action) {
				Ext.getBody().unmask();
				if(response.responseText == 'true') {
					var calculateAverageGrid = $this.getCalculateaveragegrid();
					$this.resetGridSetting(calculateAverageGrid);
					calculateAverageGrid.getStore().load();
					calculateAverageGrid.getSelectionModel().deselectAll();
				}
			}
		});
	},
	
	levelWiseGridRender: function (grid) {
	    var me = this;
	    if (grid.getStore().getCount() > 0) {
	        grid.getStore().removeAll();
	    }
	    var permissionsMap = this.getCALCULATE_AVERAGE_LEVEL_WISE_PERMISSIONS();
	    this.doAccessControlValidation(grid, permissionsMap);
	    var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    var buttonsToolBar = grid.query('toolbar')[0];
	    var btnRefArray = ['caclulateAverageLevelWiseBtnId', 'deleteLevelWiseBtnId'];
	    Ext.each(btnRefArray, function (ref) {
	        var btn = buttonsToolBar.down('#' + ref);
	        if (btn) {
	            btn.hide();
	        }
	        if (permissionList.indexOf('CALCULATE_AVERAGE_LEVEL_WISE_CALC_AVG') != -1) {
	        	buttonsToolBar.down('#caclulateAverageLevelWiseBtnId').show();
	        }
	        if (permissionList.indexOf('DELETE') != -1) {
	        	buttonsToolBar.down('#deleteLevelWiseBtnId').show();
	        }
	    });
	},
	
	onProgramSelectLevelWise: function (obj, rec) {
	    var data = rec[0].data.id;
	    var filterForm = obj.up('form').getForm();
	    var batchField = filterForm.findField('batchId');
	    var level = filterForm.findField('evaluationLevel');
	    var studentField = filterForm.findField('admissionCodeSTDName');
	    batchField.enable();
	    batchField.reset();
	    studentField.reset();
	    studentField.disable();
	    batchField.getStore().loadRawData([]);
	    batchField.getStore().getProxy().extraParams = {
	        programId: data
	    };
	    batchField.getStore().load({
	        callback: function (record) {
	            if (record.length == 1) {
	                batchField.select(record[0]);
	                batchField.fireEvent('select', batchField, record[0]);
	            } else {
	            	level.reset();
	            	level.setDisabled(true);
	            }
	        }
	    });
	},
	
	onBatchSelectLevelWise: function (obj, rec) {
	    if (Ext.isArray(rec)) {
	        rec = rec[0];
	    }
	    var data = rec.data.id;
	    var filterForm = obj.up('form').getForm();
	    var programField = filterForm.findField('programId');
	    var batchField = filterForm.findField('batchId');
	    var levelField = filterForm.findField('evaluationLevel');
	    var studentField = filterForm.findField('admissionCodeSTDName');
	    levelField.enable();
	    levelField.reset();
	    levelField.getStore().loadRawData([]);
	    levelField.getStore().load({
	        callback: function (records, value, rec) {
	            if (records.length == 1) {
	            	levelField.select(records[0]);
	            }
	            Ext.defer(function() {
	            	try {
	            		levelField.getStore().removeAt(4);
	            	}
	            	catch(err) {
	            		console.log(err);
	            	}
	            }, 500);
	        }
	    });
	    studentField.reset();
	    studentField.disable();
	},
	
	onLevelSelectLevelWise: function(obj, rec) {
		var filterForm = obj.up('form').getForm();
		var studentField = filterForm.findField('admissionCodeSTDName');
		studentField.reset();
		studentField.enable();
		var studentStore = studentField.getStore();
		var vals = filterForm.getValues();
		studentStore.getProxy().extraParams = {
			programId: vals.programId,
			batchId: vals.batchId
		};
		studentStore.load();
	},
	
	resetLevelWiseFilter: function (obj) {
	    var filterForm = obj.up('form').getForm();
	    filterForm.findField('batchId').disable();
	    filterForm.findField('evaluationLevel').disable();
	    filterForm.findField('admissionCodeSTDName').disable();
	    filterForm.reset();
	    var program = filterForm.findField('programId');
	    program.getStore().load();
	},
	
	loadCalculateAverageLevelWiseFilterData: function() {
		  var $this = this;
		  var form = $this.getCalculateAverageLevelWiseFilter().getForm();
		  var filterForm = $this.getCalculateAverageLevelWiseFilter();
		  var grid = $this.getCalculateAverageLevelWiseGrid();
		  var vals = form.getValues();

		  var academyLocationId = $this.getCurrentAcademyLocation();

		  grid.getStore().getProxy().extraParams = {
			  programId: vals.programId,
			  batchId: vals.batchId,
			  admissionId: vals.admissionCodeSTDName,
			  assessmentSchemeLevel: vals.evaluationLevel
		  };
		  $this.resetGridSetting(grid);
		  this.resetPageSetting(grid.getStore(), grid);
		  grid.getStore().pageSize = 100;
		  grid.getStore().load();
		  grid.getSelectionModel().deselectAll();
		  grid.config.searchFilterForm = filterForm;
	  },
	  
	  doCaclulateAverageLevelWise: function (btn) {
		    btn.setDisabled(true);
		    var grid = this.getCalculateAverageLevelWiseGrid();
		    var selections = grid.getSelectionModel().getSelection();
		    var jsonData = [];
		    if (selections.length) {
		        for (var i = 0; i < selections.length; i++) {
		            var obj = {
		                admissionId: selections[i].get('admissionId'),
		                batchId: selections[i].get('batchId'),
		                levelType: selections[i].get('assessmentSchemeLevel')
		            };
		            jsonData.push(obj);
		        }
		        Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
		        Ext.Ajax.request({
		            type: 'rest',
		            url: SERVERURL.PATH_CALCULATE_LEVEL_WISE_AVG,
		            jsonData: jsonData,
		            method: 'POST',
		            success: function (response, action) {
		                Ext.getBody().unmask();
		                if(response.responseText == 'DROOL_NOT_CONFIGURE') {
		                	showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('CALCULATE_AVERAGE_DROOL_NOT_CONFIGURED'));
		                	btn.setDisabled(false);
		                }
		                else if(response.responseText.indexOf('ERROR') != -1) {
		                	showWarningMessage(getCommonTranslation('ALERT'), response.responseText);
		                	btn.setDisabled(false);
		                }
		                else {
			                grid.getStore().load();
			                grid.getSelectionModel().deselectAll();
			                showSuccessMessage(getExaminationTranslation('STUDENT_AVERAGE'), getExaminationTranslation('STUDENT_AVERAGE_SAVED_SUCCESSFULLY'));
		                }
		            }
		        });
		    }
		},
		
		onLevelWiseGridSelectionChange: function(sm, selected) {
        	var grid = sm.view.up('grid');
        	grid.down('#caclulateAverageLevelWiseBtnId').setDisabled(!selected.length);
        	var deleteBtnFlag = true;
        	
        	for(var j = 0; j < selected.length; j++) {
        		if(!Ext.isEmpty(selected[j].get('isAvgCalculated'))) {
        			deleteBtnFlag = false;
        		}
        		else {
        			deleteBtnFlag = true;
        			break;
        		}
        	}
        	grid.down('#deleteLevelWiseBtnId').setDisabled(deleteBtnFlag);
        },
        
        redirectToAverageDetails: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
        	if(e.target.tagName == 'A') {
        		var contentpanel = this.getContentPanel();
        		var levelListView = Ext.widget('assessmentLevelList');
        		var tabName = getExaminationTranslation('ASSESSMENT_LEVEL_LIST');
        		var getcontroller = this.getController('menu.CoreERPNavigationController');
        		var getTab = getcontroller.getTab(tabName);
        		if(getTab != null){
        			contentpanel.remove(getTab, true);
        		}
        		openTab(contentpanel, tabName, levelListView);
        		var form = this.getAssessmentLevelList().getForm();
        		form.setValues({
        			studentIdName: record.get('studentCode') + '/' + record.get('studentName'),
        			programBatch: record.get('programName') + '-' + record.get('batchName'),
        			assessmentLevel: getCommonTranslation(record.get('assessmentSchemeLevel'))
        		});
        		var grid = this.getAssessmentLevelListGrid();
        		var store = grid.getStore();
        		store.getProxy().extraParams = {
        			programId: record.get('programId'),
        			batchId: record.get('batchId'),
        			admissionId: record.get('admissionId'),
        			assessmentSchemeLevel: record.get('assessmentSchemeLevel')
        		};
        		this.resetPageSetting(store, grid);
        		store.pageSize = 100;
        		store.load();
        	}
        },
        
        deleteAverageLevelWise: function (obj) {
            var $this = this;
            var formWindow = $this.getCalculateAverageLevelWiseFilter();
            var grid = $this.getCalculateAverageLevelWiseGrid();
            var filterForm = $this.getCalculateAverageLevelWiseFilter().getForm();
            var vals = filterForm.getValues();
            var gridRecord = grid.getSelectionModel().getSelection();
            /*var programIds = [];
            var batchIds = [];
            var admissionIds = [];*/
            var jsonData = [];
	        
            if (grid.getSelectionModel().getCount() > 0) {
                for (var i in gridRecord) {
					 jsonData.push({
	                	id: gridRecord[i].data.batchId,
	                	secondId: gridRecord[i].data.programId,
	                	longValue:gridRecord[i].data.admissionId,
	                	code:vals.evaluationLevel
	            	});
                 /*   if (!isNullOrEmpty(gridRecord[i].data.programId)) {
                        programIds.push(gridRecord[i].data.programId);
                    }
                    if (!isNullOrEmpty(gridRecord[i].data.batchId)) {
                        batchIds.push(gridRecord[i].data.batchId);
                    }
                    if (!isNullOrEmpty(gridRecord[i].data.admissionId)) {
                        admissionIds.push(gridRecord[i].data.admissionId);
                    }
                    */
                }

                var submitUrl = SERVERURL.PATH_DELETE_AVG_FOR_LEVEL_WISE;
              /*  var data = {
                    'levelName': vals.evaluationLevel,
                    'admissionIds': admissionIds,
                    'batchIds': batchIds,
                    'programIds': programIds
                };*/
                showConfirmMessage(getExaminationTranslation('AVERAGE_DELETION'),
                    getExaminationTranslation('DELETE_RECORDS_CONFIRMATION'),
                    function (btn, text) {
                        if (btn == 'yes') {
                            Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
                            if (grid.down('#calculateRankButtonId')) {
                                grid.down('#calculateRankButtonId').disable();
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: submitUrl,
                                jsonData: jsonData,
                                method: 'POST',
                                success: function (response, action) {
                                    Ext.getBody().unmask();
                                    grid.getStore().load({
                                        callback: function (records, operation, success) {
                                            if (records && records.length) {
                                                var calcRankDisable = true;
                                                for (var j = 0; j < records.length; j++) {
                                                    if (isNullOrEmpty(records[j].get('marks')) || records[j].get('marks') == '0' || records[j].get('marks') == '0.00' || records[j].get('marks') == '0.0') {
                                                        calcRankDisable = true;
                                                    } else {
                                                        calcRankDisable = false;
                                                        break;
                                                    }
                                                }
                                                if (grid.down('#calculateRankButtonId') && calcRankDisable == false) {
                                                    grid.down('#calculateRankButtonId').enable();
                                                }
                                            } else {
                                                if (grid.down('#calculateRankButtonId')) {
                                                    grid.down('#calculateRankButtonId').disable();
                                                }
                                            }
                                        }
                                    });
                                    grid.getSelectionModel().deselectAll();
                                    showSuccessMessage(getExaminationTranslation('AVERAGE_DELETION'), getExaminationTranslation('DELETE_RECORDS_SUCCESS'));
                                }
                            });
                        }
                    });
            } else {
                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            }
        }
});

