/*
 * @author Abhishek Chouhan
 */
Ext.define('Academia.controller.examinationcenters.evaluationresult.ExamResultPublishController', {
	extend: 'Academia.controller.base.BaseController',
	models: [],
	views: [
		'examinationcenters.examresultpublish.ExamResultPublishStructure',
		'examinationcenters.examresultpublish.ExamResultPublishFilter',
		'examinationcenters.examresultpublish.ExamResultPublishGrid',
		'examinationcenters.examresultpublish.ExamResultPublishSearchTab',
		'examinationcenters.examresultpublish.BulkExamResultPublishTab',
		'examinationcenters.examresultpublish.BulkExamResultPublishFilter',
		'examinationcenters.examresultpublish.BulkExamResultPublishGrid'
		],
		stores: [
			'user.UserAcademyLocationStore',
			'examinationcenters.reports.ExamResultPublishProgramStore',
			'examinationcenters.reports.ExamResultPublishBatchStore',
			'examinationcenters.marksheet.StudentAssessmentEvaluationLevelType',
			'examinationcenters.reports.SpecialGradePeriodStore',
			'attendance.SectionAndFacultyByPeriodID','examinationcenters.reports.ExaminationResultPublishCourseStore',
			'facilitiesresources.resourcebooking.ExamResultPublishCourseVariantsStore',
			'examinationcenters.reports.ExaminationReportEPStore','examinationcenters.evaluation.EvaluationTypeMapped',
			'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSubTypeMapped',
			'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationMethodMapped',
			'examinationcenters.evaluation.evaluationPlanHeirarchy.DetailSequenceEquivalentNo',
			'examinationcenters.reports.ExaminationReportStudentStore',
			'common.AcademyLocationNameSeparated',
			'examinationcenters.reports.ExaminationPlanStore',
			'examinationcenters.marksheet.EventEvaluationLevelType',
			'examinationcenters.marksheet.AssessmentOtherLevelStore',
			'coursetransaction.facultytopicassignment.AssignFacultyStore',
			'examinationcenters.examresultpublish.ExamResultPublishStatusStore',
			'examinationcenters.examresultpublish.ExamResultPublishGridStore',
			'examinationcenters.calculateAverage.ExamResultPublishLevelTypeStore',
			'examinationcenters.calculateAverage.ExamPublishResultLevelTypeStore',
			'examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanStore',
			'examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanLevelStore',
			'examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapPeriodForDynamic'
			],
			refs: [{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref : 'examresultpublishstructure',
				selector : 'examresultpublishstructure'
			},{
				ref : 'examresultpublishfilter',
				selector : 'examresultpublishfilter'
			},{
				ref : 'examresultpublishgrid',
				selector : 'examresultpublishgrid'
			}, {
				ref: 'examresultpublishsearchtab',
				selector: 'examresultpublishsearchtab'
			}, {
				ref: 'bulkExamResultPublishTab',
				selector: 'bulkExamResultPublishTab'
			}, {
				ref: 'bulkExamResultPublishFilter',
				selector: 'bulkExamResultPublishFilter'
			}, {
				ref: 'bulkExamResultPublishGrid',
				selector: 'bulkExamResultPublishGrid'
			}],
			config: {
				EXAM_RESULT_PUBLISH_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_RESULT_PUBLISH_PRIVILEGES'),
				BULK_EXAM_RESULT_PUBLISH_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('BULK_EXAM_RESULT_PUBLISH_PRIVILEGES')
			},
			init: function(application) {
				this.control({

					'examresultpublishgrid': {
						afterrender : function(grid){
							this.doAccessControlValidation(grid,this.getEXAM_RESULT_PUBLISH_PERMISSIONS());
							this.disableResultPublishBtnPivileges(grid,this.getEXAM_RESULT_PUBLISH_PERMISSIONS());
							var me =this;
							setTimeout(function(){
							me.addDataGridConfigButton(grid,me.getEXAM_RESULT_PUBLISH_PERMISSIONS());
							}, 1500);
							
						},
						selectionchange: function(grid, selected) {
							var unpublishBtn= grid.view.up('grid').down('#unpublishResultItemId');
							 var publishBtn= grid.view.up('grid').down('#publishResultItemId');
							// this.checkPublishUnpublishButtons(selected, publishBtn, unpublishBtn); 
							 if(selected.length) {
								var disableFlag = true;
								var disableFlagCnt = 0;
								var disableFlagCntt = 0;
								for(var i = 0; i < selected.length; i++) {
									if(!isNullOrEmpty(selected[i].get('resultPublishStatus')) && selected[i].get('resultPublishStatus')) {
										disableFlagCnt = disableFlagCnt + 1;
									}else {
                                        publishBtn.disable();
                                        disableFlagCntt = disableFlagCntt + 1;
                                    }
								}
								if(disableFlagCnt == selected.length) {
									unpublishBtn.enable();
								}
								else {
									unpublishBtn.disable();
								}
								 if (disableFlagCntt == selected.length) {
                                     publishBtn.enable();
                                 }
                                 else {
                                     publishBtn.disable();
                                 }
							}
							else {
								unpublishBtn.disable();
									publishBtn.disable();
							} 
						}
					},
					
					'examresultpublishfilter' : { 
						render:function(obj){
							var form=obj.up('form').getForm();
							var program = form.findField("programId").getStore();
							var courseId = form.findField("courseId").getStore();
							var courseVariant = form.findField("courseVariant").getStore();
							var studentId = form.findField("studentId").getStore();
							var academyLocation = form.findField("academyLocation");
							var intakeYear = form.findField("intakeYear");
							var resultPublishStatus = form.findField("resultPublishStatus");

							var counter = 0;
							var arr = [];
							var academyLocationArray= [];
 
							var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();

							for(var i in academyLocationPrivilegeList){
									arr.push(academyLocationPrivilegeList[i].accessibleAcademyLocation.academyLocationId);
							}
							
							academyLocation.getStore().load({
							    callback: function(records, operation, success) {
									//Extract the first 5 elements 
							        for (var i = 0; i < records.length; i++) {
							            if (counter != 5) {
											//find the matched accessible al location in the records
							                var matchedItem = arr.find(function(item) {
							                    return item == records[i].data.id
							                });
							                academyLocationArray.push(matchedItem);
							                counter++;
							            }
							        }
									
							        academyLocation.setValue(academyLocationArray);
									
								   //loading the store here 
									intakeYear.reset();
									intakeYear.getStore().getProxy().extraParams={
										academyLocationIds:academyLocationArray.join(),
										whetherMarksheet:true
									};
									//intakeYear.getStore().load();

									/*courseVariant.getProxy().extraParams={
										academyLocationIds:academyLocationArray.join(),
										whetherMarksheet:true
									};
									courseId.getProxy().extraParams={
										academyLocationIds:academyLocationArray.join(),
										whetherMarksheet:true
									};*/
							
									program.getProxy().extraParams={
										academyLocationIds:academyLocationArray.join(),
										whetherMarksheet:true
									};
									studentId.getProxy().extraParams = {
										academyLocationIds:academyLocationArray.join(),
										whetherMarksheet:true
									}

									var alinfomodel = Academia.model.authentication.ALInfoModel;
									var whetherSchool = alinfomodel.get('wheatherSchool');
									if(whetherSchool) {
										form.findField("periodId").setVisible(false);
									} else {
										form.findField("periodId").setVisible(true);
									}
							
									resultPublishStatus.reset();
									resultPublishStatus.getStore().load({
										callback: function(records, operation, success) {
											resultPublishStatus.setValue(records[0].data.value); 
										}
									});
									
								    }
								});	

						}
					},
					
					'examresultpublishfilter  combo[itemId=academyLocationId]': {
						change: function(obj,record) {
							this.changeAlEvent(obj,record);
						},
						beforeselect:function(obj,record){
							var values = obj.getValue();
							if(values.length==1 && isNullOrEmpty(values[0])){
								return true;
							}
							if(values.length>=5){
								//tood add alter messege
								showWarningMessage(getExaminationTranslation('RESULT_PUBLISH'),
												getCommonTranslation('MAX_FIVE_RECORDS_SELECTION'));
								return false;
							}
						},
						focus: function(obj,record) {
							var grid = this.getExamresultpublishgrid();
							grid.suspendEvents();
							obj.on('collapse', function() {
								grid.resumeEvents();
							});
						}
					},
					
					'examresultpublishfilter customcombobox#intakeYear' : {
						select : function(obj, record) {
							var $this = this;
							var id = record[0].get("id");
							var form = $this.getExamresultpublishfilter();
							var getForm=obj.up('form').getForm();
							var program = form.down('#programItemId');
							getForm.findField("batchId").reset();
							getForm.findField("batchId").setDisabled(true);
							getForm.findField("periodId").reset();
							getForm.findField("periodId").setDisabled(true);
							getForm.findField("courseId").reset();
							getForm.findField("courseId").setDisabled(true);
							getForm.findField("courseVariant").reset();
							getForm.findField("courseVariant").setDisabled(true);
							getForm.findField("studentId").reset();
							getForm.findField("evaluationLevelName").reset();
							getForm.findField("evaluationLevelName").setDisabled(true);
							getForm.findField("evaluationPlanId").reset();
							getForm.findField("evaluationLevel").reset();
							getForm.findField("evaluationLevel").setDisabled(true);
							var getForm=form.getForm();
							var academyLocations = this.getSelectedAcademyLocationIds();
							program.reset();
							program.getStore().getProxy().extraParams={
								academyLocationIds:academyLocations,
								intakeYearId : id,
								whetherMarksheet:true
							};
							program.getStore().load();
						}
					},
					
					'examresultpublishfilter customcombobox[itemId=studentItemId]' : {
						select:function(obj, rec){
							var admId=rec[0].data.id;
							var form=obj.up('form').getForm();
							var program = form.findField("programId").getStore();
							var courseId = form.findField("courseId").getStore();
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var sectionId=form.findField("sectionId");
							var evaluationLevelName = form.findField("evaluationLevel");
							form.findField("courseVariant").reset();
							courseId.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:admId,
								whetherMarksheet:true
							};
							courseId.load();
							form.findField("programId").reset();
							program.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:admId,
								whetherMarksheet:true
							};
							
							program.load({
								callback: function(records, operation, success) {
									if (success) {
										var programData=records[0].data.id;
										form.findField("programId").setValue(programData);
										form.findField("batchId").reset();
										var evaluationPlan = form.findField("evaluationPlanId").getStore();
										form.findField("evaluationPlanId").reset();
										evaluationPlan.getProxy().extraParams={
											academyLocationIds:academyLocationIds,
											admissionId:admId,
											whetherMarksheet:true,
											programId:records[0].data.id
										};
										evaluationPlan.load();
										
										var batchId = form.findField("batchId").getStore();
										batchId.getProxy().extraParams={
											academyLocationIds:academyLocationIds,
											admissionId:admId,
											programId:programData,
											whetherMarksheet:true,
											
										};
										batchId.load({
											callback: function(record, operation, success) {
												if (success) {
													if(record.length==1){
														var batchData=record[0].data.id;
														form.findField("batchId").setValue(batchData);
														var evaluationPlan = form.findField("evaluationPlanId").getStore();
														form.findField("evaluationPlanId").reset();
														form.findField("evaluationPlanId").enable();
														evaluationPlan.getProxy().extraParams={
															academyLocationIds:academyLocationIds,
															admissionId:admId,
															whetherMarksheet:true,
															programId:records[0].data.id
														};
														evaluationPlan.load();
														
														var periodId = form.findField("periodId").getStore();
														periodId.getProxy().extraParams={
															academyLocationIds:academyLocationIds,
															admissionId:admId,
															programId:programData,
															batchId:batchData,
															whetherMarksheet:true
														};
														periodId.load({
															callback: function(records, operation, success) {
																if (success) {
																	if(records.length==1){
																		var periodData=records[0].data.id;
																		form.findField("periodId").enable();
																		form.findField("periodId").setValue(records[0].data.id);
																		sectionId.enable();
																		sectionId.reset();
																		sectionId.getStore().getProxy().extraParams={
																			academyLocationIds:academyLocationIds,
																			admissionId:admId,
																			programId:programData,
																			batchId:batchData,
																			periodId:periodData,
																			whetherMarksheet:true
																		};
																		sectionId.getStore().load();
																		
																		form.findField("courseId").enable();
																		form.findField("courseId").reset();
																		
																		courseId.getProxy().extraParams={
																			academyLocationIds:academyLocationIds,
																			admissionId:admId,
																			programId:programData,
																			batchId:batchData,
																			periodId:periodData,
																			whetherMarksheet:true
																		};
																		courseId.load();
																		
																		form.findField("courseVariant").setDisabled(true);
																		form.findField("courseVariant").reset();
																		
																		evaluationLevelName.reset();
													            		evaluationLevelName.getStore().getProxy().extraParams = {
													            			programId:programData,
													            			batchId:batchData,
													            			periodId:periodData,
													            			isGroupBy:true
													            		};
													            		evaluationLevelName.getStore().load();
																		
																	} else{
																		sectionId.enable();
																		sectionId.reset();
																		sectionId.getStore().getProxy().extraParams={
																			academyLocationIds:academyLocationIds,
																			admissionId:admId,
																			programId:programData,
																			batchId:batchData,
																			whetherMarksheet:true
																		};
																		sectionId.getStore().load();
																	}
																}
															}
														});
													} 
												}
											}
										});
									}
								}	   
							});
							form.findField("batchId").setDisabled(false);
							form.findField("periodId").reset();
							form.findField("periodId").setDisabled(false);
							//form.findField("evaluationPlanId").setDisabled(true);
							//form.findField("evaluationPlanId").reset();
							form.findField("courseVariant").setDisabled(true);
							form.findField("courseVariant").reset();
							form.findField("evaluationLevel").reset();
							form.findField("evaluationLevelName").reset();
							form.findField("evaluationLevelName").setDisabled(true);
						}
					},
					'examresultpublishfilter customcombobox[itemId=programItemId]' : {
						select:function(obj, rec){
							var programId=rec[0].data.id;
							var form=this.getExamresultpublishfilter().getForm();
							var batchId = form.findField("batchId").getStore();
							form.findField("batchId").reset();
							form.findField("batchId").setDisabled(false);
							var studentId = form.findField("studentId");
							var sectionId=form.findField("sectionId");
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var courseId = form.findField("courseId").getStore();
							var evaluationLevelName = form.findField('evaluationLevelName');
							var intakeYear = form.findField('intakeYear');
							form.findField("evaluationLevel").reset();
							form.findField("evaluationLevel").setDisabled(true);
							form.findField("courseId").reset();
							form.findField("courseId").enable();
							
							courseId.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:programId,
								whetherMarksheet:true
							};
							courseId.load();
							
							form.findField("courseVariant").setDisabled(true);
							form.findField("courseVariant").reset();
							
							batchId.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:programId,
								whetherMarksheet:true,
								intakeYearId:intakeYear.getValue()
							};
							batchId.load({
								callback: function(record, operation, success) {
									if (success) {
										if(record.length==1){
											var batchData=record[0].data.id;
											form.findField("batchId").reset();
											form.findField("batchId").enable();
											form.findField("batchId").setValue(record[0].data.id);
											form.findField("periodId").reset();
											form.findField("periodId").enable();
											var periodId = form.findField("periodId").getStore();
											
											evaluationLevelName.reset();
						            		evaluationLevelName.getStore().getProxy().extraParams = {
						            			programId:form.findField("programId").getValue(),
						            			batchId:batchData,
						            			isGroupBy:true
						            		};
						            		evaluationLevelName.getStore().load();
											
											periodId.getProxy().extraParams={
												academyLocationIds:academyLocationIds,
												admissionId:studentId.getValue(),
												programId:programId,
												batchId:batchData,
												whetherMarksheet:true
											};
											periodId.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length==1){
															var periodData=records[0].data.id;
															form.findField("periodId").enable();
															form.findField("periodId").setValue(records[0].data.id);
															sectionId.enable();
															sectionId.reset();
															sectionId.getStore().getProxy().extraParams={
																academyLocationIds:academyLocationIds,
																admissionId:studentId.getValue(),
																programId:programId,
																batchId:batchData,
																periodId:periodData,
																whetherMarksheet:true
															};
															sectionId.getStore().load();
															
															form.findField("courseId").enable();
															form.findField("courseId").reset();
															
															courseId.getProxy().extraParams={
																academyLocationIds:academyLocationIds,
																admissionId:studentId.getValue(),
																programId:programId,
																batchId:batchData,
																periodId:periodData,
																whetherMarksheet:true
															};
															courseId.load();
															
															form.findField("courseVariant").setDisabled(true);
															form.findField("courseVariant").reset();
															
															evaluationLevelName.reset();
										            		evaluationLevelName.getStore().getProxy().extraParams = {
										            			programId:form.findField("programId").getValue(),
										            			batchId:batchData,
										            			periodId:periodData,
										            			isGroupBy:true
										            		};
										            		evaluationLevelName.getStore().load();
															
														} else{
															sectionId.enable();
															sectionId.reset();
															sectionId.getStore().getProxy().extraParams={
																academyLocationIds:academyLocationIds,
																admissionId:studentId.getValue(),
																programId:programId,
																batchId:batchData,
																whetherMarksheet:true
															};
															sectionId.getStore().load();
														}
													}
												}
											});
											
											form.findField("courseId").enable();
											form.findField("courseId").reset();
											
											courseId.getProxy().extraParams={
												academyLocationIds:academyLocationIds,
												admissionId:studentId.getValue(),
												programId:programId,
												batchId:batchData,
												whetherMarksheet:true
											};
											courseId.load();
											
											form.findField("courseVariant").setDisabled(true);
											form.findField("courseVariant").reset();
											form.findField("evaluationPlanId").reset();
											form.findField("evaluationPlanId").enable();
										} else{
											form.findField("batchId").reset();
											form.findField("periodId").reset();
											form.findField("periodId").disable();
											
										}
									}
								}
							});
							form.findField("sectionId").reset();
							form.findField("sectionId").setDisabled(true);
							
							var evaluationPlan = form.findField("evaluationPlanId").getStore();
							form.findField("evaluationPlanId").reset();
							evaluationPlan.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								whetherMarksheet:true,
								programId:programId
							};
							evaluationPlan.load();
							
							form.findField('evaluationLevel').reset();
							var evaluationLevelName = form.findField('evaluationLevelName');
		            		evaluationLevelName.disable();
		            		evaluationLevelName.getStore().getProxy().extraParams = {
		            			programId:programId,
		            		};
		            		evaluationLevelName.getStore().load();
						}
					},
					'examresultpublishfilter customcombobox[itemId=batchItemId]' : {
						select:function(obj, rec){
							var batchId=rec[0].data.id;
							var form=obj.up('form').getForm();
							var periodId = form.findField("periodId").getStore();
							var studentId = form.findField("studentId");
							form.findField("periodId").reset();
							//var academicTerm=form.findField("academicTerm").getValue();
							form.findField("periodId").setDisabled(false);
							form.findField("evaluationLevel").reset();
							form.findField("evaluationLevel").setDisabled(true);
							//var academyLocationIds = this.getAcademyLocationIds();
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var evaluationLevelName = form.findField('evaluationLevelName');
							var evaluationplanField = form.findField('evaluationPlanId');
							var courseId=form.findField("courseId");
							var sectionId=form.findField("sectionId");
							
							periodId.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:form.findField("programId").getValue(),
								batchId:batchId,
								whetherMarksheet:true,
							};
							periodId.load({
								callback: function(record, operation, success) {
									if (success) {
										if(record.length==1){
											form.findField("periodId").enable();
											form.findField("periodId").setValue(record[0].data.id);
											form.findField("sectionId").reset();
											
											form.findField("sectionId").setDisabled(false);
											
											sectionId.getStore().getProxy().extraParams={
												academyLocationIds:academyLocationIds,
												admissionId:studentId.getValue(),
												programId:form.findField("programId").getValue(),
												batchId:form.findField("batchId").getValue(),
												periodId:record[0].data.id,
												whetherMarksheet:true
											};
											sectionId.getStore().load();
											
										} else{
											form.findField("sectionId").reset();
											form.findField("sectionId").setDisabled(false);
											
											sectionId.getStore().getProxy().extraParams={
												academyLocationIds:academyLocationIds,
												admissionId:studentId.getValue(),
												programId:form.findField("programId").getValue(),
												batchId:form.findField("batchId").getValue(),
												whetherMarksheet:true
											};
											sectionId.getStore().load();
											
										}
									}
								}
							});
							
							periodId.load();
						//	form.findField("evaluationPlanId").setDisabled(true);
						//	form.findField("evaluationPlanId").reset();
							form.findField("courseVariant").setDisabled(true);
							form.findField("courseVariant").reset();
							
							form.findField("evaluationPlanId").reset();
							form.findField("evaluationPlanId").enable();
							var evaluationPlan = form.findField("evaluationPlanId").getStore();
							evaluationPlan.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								whetherMarksheet:true,
								programId:form.findField("programId").getValue(),
								batchId:batchId,
							};
							evaluationPlan.load();
							
							form.findField('evaluationLevel').reset();
							evaluationLevelName.reset();
		            		evaluationLevelName.getStore().getProxy().extraParams = {
		            			programId:form.findField("programId").getValue(),
		            			batchId:batchId,
		            			isGroupBy:true
		            		};
		            		evaluationLevelName.getStore().load();
		            		
		            		form.findField("courseId").enable();
							form.findField("courseId").reset();
							
							courseId.getStore().getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:form.findField("programId").getValue(),
								batchId:batchId,
								whetherMarksheet:true
							};
							courseId.enable();
							courseId.getStore().load();
							
							form.findField("courseVariant").setDisabled(true);
							form.findField("courseVariant").reset();
						}
					},
					
					'examresultpublishfilter customcombobox[itemId=periodItemId]' : {
						select:function(obj, rec){
							var periodId=rec[0].data.id;
							var form=obj.up('form').getForm();
							var sectionId = form.findField("sectionId").getStore();
							form.findField("sectionId").reset();
							form.findField("sectionId").setDisabled(false);
							form.findField("evaluationLevel").reset();
							form.findField("evaluationLevel").setDisabled(true);
							var studentId = form.findField("studentId");
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var evaluationLevelName = form.findField('evaluationLevelName');
							var evaluationplanField = form.findField('evaluationPlanId');
							sectionId.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:form.findField("programId").getValue(),
								batchId:form.findField("batchId").getValue(),
								periodId:periodId,
								whetherMarksheet:true
							};
							sectionId.load();

							var courseId = form.findField("courseId");
							courseId.reset();
							courseId.getStore().getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								programId:form.findField("programId").getValue(),
								batchId:form.findField("batchId").getValue(),
								periodId:periodId,
								whetherMarksheet:true
							};
							courseId.enable();
							courseId.getStore().load();

							//form.findField("evaluationPlanId").setDisabled(true);
							//form.findField("evaluationPlanId").reset();
							form.findField("courseVariant").setDisabled(true);
							form.findField("courseVariant").reset();
							
							form.findField("evaluationPlanId").reset();
							form.findField("evaluationPlanId").enable();
							var evaluationPlan = form.findField("evaluationPlanId").getStore();
							evaluationPlan.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								whetherMarksheet:true,
								programId:form.findField("programId").getValue(),
								batchId:form.findField("batchId").getValue(),
								periodId:periodId,
							};
							evaluationPlan.load();
							
							form.findField('evaluationLevel').reset();
							evaluationLevelName.reset();
		            		evaluationLevelName.getStore().getProxy().extraParams = {
		            			programId:form.findField("programId").getValue(),
		            			batchId:form.findField("batchId").getValue(),
		            			periodId:periodId,
		            			isGroupBy:true
		            		};
		            		evaluationLevelName.getStore().load();
						}
					},
					
					'examresultpublishfilter customcombobox[itemId=courseItemId]' : {
						select:function(obj, rec){
							var courseId=rec[0].data.id;
							var form=obj.up('form').getForm();
							var courseVariant = form.findField("courseVariant").getStore();
							var studentId = form.findField("studentId");
							form.findField("courseVariant").setDisabled(false);
							form.findField("courseVariant").reset();
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var values = form.getValues();
							courseVariant.getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								admissionId:studentId.getValue(),
								courseId:courseId,
								whetherMarksheet:true
							};
							courseVariant.load();
							var facultyName=form.findField("facultyName");
							facultyName.reset();
							facultyName.getStore().getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								courseId:courseId,
							};
							facultyName.getStore().load();
						}
					},
					'examresultpublishfilter customcombobox[itemId=courseVariantItemId]' : {
						select:function(obj, rec){
							var courseVariantId=rec[0].data.id;
							var form=obj.up('form').getForm();
							var academyLocationIds = this.getSelectedAcademyLocationIds();
							var facultyName=form.findField("facultyName");
							facultyName.reset();
							facultyName.getStore().getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								courseId:form.findField("courseId").getValue(),
								courseVariantId:courseVariantId
							};
							facultyName.enable();
							facultyName.getStore().load();
						}
					},
					'examresultpublishfilter customcombobox[itemId=evaluationPlanItemId]' : {
						select:function(obj, rec){
							var evaluationPlanId=rec[0].data.id;
							var form=obj.up('form').getForm();
							form.findField("evaluationTypeId").setDisabled(false);
							form.findField("evaluationTypeId").setDisabled(false);
							form.findField("evaluationSubTypeId").setDisabled(true);
							form.findField("evaluationSubTypeId").reset();
							form.findField("evaluationMethodId").setDisabled(true);
							form.findField("evaluationMethodId").reset();
							form.findField("evaluationEventId").setDisabled(true);
							form.findField("evaluationEventId").reset();
							var evaluationType = form.findField("evaluationTypeId").getStore();
							form.findField("evaluationTypeId").reset();
							var academyLocationIds = form.findField("academyLocation").getValue();
							var values = form.getValues();
							evaluationType.getProxy().extraParams={
								evaluationPlanId:evaluationPlanId
							};
							evaluationType.load();
						}
					},
					
					  'examresultpublishfilter customcombobox[itemId=evaluationPlanId]': {
						  select: function(obj, rec) {
							  var $this=this;
							  var data = rec[0].data.id;
							  var assessmentType=rec[0].data.code
							  var filterForm = obj.up('form').getForm();
							  var evaluationLevel = filterForm.findField('evaluationLevel');
							  var evaluationLevelName = filterForm.findField('evaluationLevelName');
							  var courseId=filterForm.findField("courseId");
							  var academyLocationIds = $this.getSelectedAcademyLocationIds();
							  var studentId = filterForm.findField("studentId");
							  var periodId=filterForm.findField("periodId");
							  evaluationLevel.reset();
							  evaluationLevelName.reset();
							  evaluationLevel.enable();
							  evaluationLevelName.disable();
							  courseId.reset();
							  

							  courseId.getStore().getProxy().extraParams={
								  academyLocationIds:academyLocationIds,
								  admissionId:studentId.getValue(),
								  programId:filterForm.findField("programId").getValue(),
								  batchId:filterForm.findField("batchId").getValue(),
								  periodId:periodId.getValue(),
								  whetherMarksheet:true
							  };
							  courseId.getStore().load();
						  }
			            },
			            
			            'examresultpublishfilter customcombobox[itemId=evaluationLevelItemId]': {
			            	select: function(obj, rec) {
			            		var $this=this;
			            		var data = rec[0].data.id;
			            		var filterForm = obj.up('form').getForm();
			            		var evaluationplanField = filterForm.findField('evaluationPlanId');
			            		var evaluationLevelName = filterForm.findField('evaluationLevelName');
			            		var programId=filterForm.findField("programId").getValue();
			            		var batchId=filterForm.findField("batchId").getValue();
			            		var periodId=filterForm.findField("periodId").getValue();
			            		var facultyName = filterForm.findField('facultyName');
			            		evaluationLevelName.enable();
			            		evaluationLevelName.getStore().getProxy().extraParams = {
			            			evaluationPlanId: evaluationplanField.getValue(),
			            			evaluationLevel:data,
			            			programId:programId,
			            			batchId:batchId,
			            			periodId:periodId,
			            			isGroupBy:true
			            		};
			            		evaluationLevelName.getStore().load();

			            		if(data==="EVALUATION_EVENT"){
			            			facultyName.enable();
			            		}else{
			            			facultyName.disable();
			            		}
			            	}
				            },
			            
			           /* 'examresultpublishfilter customcombobox[itemId=evaluationLevelNameId]': {
			                select: function(obj, rec) {
			                    var data = rec[0].data.id;
			                    var filterForm = obj.up('form').getForm();
			                    var evaluationplanField = filterForm.findField('evaluationplan');
			                    var evaluationLevelName = filterForm.findField('evaluationLevelName');
			                    evaluationLevelName.reset();
			                    evaluationLevelName.enable();
			                    evaluationLevelName.getStore().getProxy().extraParams = {
			                    	evaluationPlanId: evaluationplanField.getValue(),
			                    	evaluationLevel:data,
			                    	evaluationLevelName:evaluationLevelName.getValue()
			                    };
			                    evaluationLevelName.getStore().load();
			                }
			            },*/
				            
				            'examresultpublishfilter button[itemId=searchBtn]': {
								click: function(obj) {
									var $this = this;
									var grid = $this.getExamresultpublishgrid();
									var form = $this.getExamresultpublishfilter().getForm();
									var filterForm = $this.getExamresultpublishfilter();
									var program=form.findField("programId");
									/*if(program.valueModels[0].data.code == "M"){
										grid.columns[16].setVisible(true);
										grid.columns[17].setVisible(true);
									}else{
										grid.columns[17].setVisible(true); 
										grid.columns[16].setVisible(true); 
									}	*/                					 
									var evaluationLevel = form.findField("evaluationLevelId");
									var academyLocationIds = $this.getSelectedAcademyLocationIds();
									var values = form.getValues();
									var sections = [];
									if(!isNullOrEmpty(values.sectionId)){
										for (var i=0 ; i<values.sectionId.length; i++){
											if(values.sectionId[i].data!=undefined){
												sections.push(values.sectionId[i].data.sectionId);
											}
										}
									}
									var evaluationPlanLevelName=null;
									var whetherDynamicEvent=null;
									if(!isNullOrEmpty(form.findField("evaluationLevelName")) && 
											form.findField("evaluationLevelName").valueModels[0]!=undefined){
										evaluationPlanLevelName=form.findField("evaluationLevelName").valueModels[0].data.value;
										whetherDynamicEvent=form.findField("evaluationLevelName").valueModels[0].data.secondCheck;
									}
									//var resultPublishStatus=form.findField("resultPublishStatus").valueModels[0].data.name;
									var resultPublishStatus = null;
									if(form.findField("resultPublishStatus").valueModels[0]) {
										resultPublishStatus = form.findField("resultPublishStatus").valueModels[0].data.name;
									}
									//var resultPublishStatus=form.findField("resultPublishStatus").valueModels[0].data.name;
									var resultPublishStatus = null;
									if(form.findField("resultPublishStatus").valueModels[0]) {
										resultPublishStatus = form.findField("resultPublishStatus").valueModels[0].data.name;
									}
									grid.getStore().getProxy().extraParams = {
										admissionId: values.studentId,
										programId: values.programId,
										batchId: values.batchId,
										periodId: values.periodId,
										sectionIds: sections.join(),
										courseId: values.courseId,
										courseVariantId: values.courseVariant,
										evaluationLevel : values.evaluationLevelId,
										evaluationPlanId: values.evaluationPlanId,
										academyLocationIds:academyLocationIds,
										intakeYearId : values.intakeYear,
										facultyId:null,
										evaluationLevelName:evaluationPlanLevelName,
										evaluationLevel:values.evaluationLevel,
										whetherDynamicEvent:whetherDynamicEvent,
										resultPublishStatusValue:resultPublishStatus,
										facultyId:values.facultyName
									};
									$this.resetGridSetting(grid);
									$this.resetPageSetting(grid.getStore(), grid);
									grid.getStore().loadPage(1, {
										callback: function(records, operation, success) {
											if (success) {
												if(values.evaluationLevel == 'EVALUATION_PLAN') {
													grid.columns[10].setVisible(false);
													grid.columns[11].setVisible(false);
													grid.columns[12].setVisible(false);
													grid.columns[13].setVisible(false);
													
												} else if(values.evaluationLevel == 'EVALUATION_TYPE') {
													grid.columns[10].setVisible(true); 
													grid.columns[11].setVisible(false);
													grid.columns[12].setVisible(false);
													grid.columns[13].setVisible(false);
												} else if(values.evaluationLevel == 'EVALUATION_SUB_TYPE') {
													grid.columns[10].setVisible(true);
													grid.columns[11].setVisible(true);
													grid.columns[12].setVisible(false);
													grid.columns[13].setVisible(false);
												} else if(values.evaluationLevel == 'EVALUATION_METHOD') {
													grid.columns[10].setVisible(true);
													grid.columns[11].setVisible(true);
													grid.columns[12].setVisible(true);
													grid.columns[13].setVisible(false);
												} else{
													grid.columns[10].setVisible(true);
													grid.columns[11].setVisible(true);
													grid.columns[12].setVisible(true);
													grid.columns[13].setVisible(true);
												}
											}
										}	   
									});
									grid.config.searchFilterForm = filterForm;
								var store1=grid.getStore();
        		   grid.reconfigure(store1);
					$this.resetPageSetting(store1, grid);
        		   grid.bindStore(store1);
        		   grid.down('custompagingtoolbar').bindStore(store1);
					$this.resetPageSetting(store1, grid);
								}
							},
							
							'examresultpublishfilter button[itemId=resetBtn]' : {
								click:function(obj){
									var form=obj.up('form').getForm();
									form.reset();
									var program = form.findField("programId").getStore();
									var courseId = form.findField("courseId").getStore();
									var courseVariant = form.findField("courseVariant").getStore();
									var studentId = form.findField("studentId").getStore();
									var academyLocation = form.findField("academyLocation");
									var intakeYear = form.findField("intakeYear");
									var resultPublishStatus = form.findField("resultPublishStatus");
									form.findField("evaluationLevelName").setDisabled(true);
									form.findField("evaluationLevel").setDisabled(true);
									
									//Update the reset functionality for V2D-402227
									var counter = 0;
									var arr = [];
									var academyLocationArray= [];

									var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();

									for(var i in academyLocationPrivilegeList){
											arr.push(academyLocationPrivilegeList[i].accessibleAcademyLocation.academyLocationId);
									}
									
									var currentAl = this.getCurrentAcademyLocation();
									academyLocation.getStore().load({
									    callback: function(records, operation, success) {
									        /*for (var i = 0; i < records.length; i++) {
									
									            if (counter != 5) {
									                var matchedItem = arr.find(function(item) {
									                    return item == records[i].data.id
									                });
									                academyLocationArray.push(matchedItem);
									                counter++;
									            }
									        }
									        academyLocation.setValue(academyLocationArray);*/
											academyLocation.setValue(currentAl);
									
									        //loading the store here 
									
									        intakeYear.reset();
									        intakeYear.getStore().getProxy().extraParams = {
									            academyLocationIds: academyLocationArray.join(),
									            whetherMarksheet: true
									        };
									        intakeYear.getStore().load();
								
									//TOOD: recommended to stop loading the coursevariants and course store here for more optimization
									
									        courseVariant.getProxy().extraParams = {
									            academyLocationIds: academyLocationArray.join(),
									            whetherMarksheet: true
									        };
									        courseVariant.load();
									        courseId.getProxy().extraParams = {
									            academyLocationIds: academyLocationArray.join(),
									            whetherMarksheet: true
									        };
									        courseId.load();
									        program.getProxy().extraParams = {
									            academyLocationIds: academyLocationArray.join(),
									            whetherMarksheet: true
									        };
									        program.load();
									        studentId.getProxy().extraParams = {
									            academyLocationIds: academyLocationArray.join(),
									            whetherMarksheet: true
									        }
									        studentId.load();
									        var alinfomodel = Academia.model.authentication.ALInfoModel;
									        var whetherSchool = alinfomodel.get('wheatherSchool');
									        if (whetherSchool) {
									            form.findField("periodId").setVisible(false);
									        } else {
									            form.findField("periodId").setVisible(true);
									        }
									
									        resultPublishStatus.reset();
									        resultPublishStatus.getStore().load({
									            callback: function(records, operation, success) {
									                resultPublishStatus.setValue(records[0].data.id);
									            }
									        });
									
									    }
									});
									
								}
							},
							
							'examresultpublishgrid button[itemId=publishResultItemId]':{
								click:function(obj){
									var $this=this;
									var grid=this.getExamresultpublishgrid();
									if(grid.getSelectionModel().getCount()>0){
										var records=grid.getSelectionModel().getSelection();	
										var ids=[];
										
										var formFilter = $this.getExamresultpublishfilter();
										var form=formFilter.getForm();
										var message=null;
										var isPublish=null;
										if(!isNullOrEmpty(form.findField("evaluationLevelName")) && 
											form.findField("evaluationLevelName").valueModels[0]!=undefined){
										var isPublish=form.findField("evaluationLevelName").valueModels[0].data.activeStatus;
									    }
										var holdCount = 0;
										var holdStdIds = [];
										for(var i = 0; i < records.length; i++) {
											if(records[i].get('whetherResultPublishHold')) {
												holdStdIds.push(records[i].get('studentCode'));
											}
										}
										holdCount = holdStdIds.filter(onlyUnique);
										if(holdCount.length) {
											message = holdCount.length + ' ' + getExaminationTranslation('EXAMINATION_RESULT_PUBLISH_FOR_HOLD');
										}
										else if(form.getValues().evaluationLevel=="EVALUATION_EVENT" && isPublish){
											message=getExaminationTranslation('EXAM_DO_YOU_WANT_TO_PUBLISH_QUE_LEVEL_MARKS');
										}else {
											message=getExaminationTranslation('RESULT_PUBLISH_SELECTED_RECORDS')
										}
										
										showConfirmMessage(getExaminationTranslation('RESULT_PUBLISH'),
												message,
												function(btn,text){
											if (btn == 'yes') {
												for(var i in records){
													ids.push(records[i].data.levelId);
												}
												var evaluationLevel=records[0].data.evaluationLevel;

												saveResultPublishData={
														'levelIds':ids.join(),
														'evaluationLevel':evaluationLevel,
														'isResultUnPulished': false
												}
												Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
												Ext.Ajax.request({
													type: 'rest',
													jsonData: saveResultPublishData,
													method: 'POST',
													url : SERVERURL.EXAM_RESULT_PUBLISH_GRID_CREATE_UPDATE,
													success : function(response, action) {
														Ext.getBody().unmask();
														grid.getStore().reload();
														grid.getSelectionModel().deselectAll();
														showSuccessMessage(getExaminationTranslation('RESULT_PUBLISH'),
																getExaminationTranslation('RESULT_PUBLISHED_SUCCESSFULLY'));
																obj.disable(); // V2D-531116
													}
												});
											}
										});
									}else{
										showWarningMessage(getExaminationTranslation('RESULT_PUBLISH'),
												getCommonTranslation('PLEASE_SELECT_RECORD'));
									}
								}
							},
							'examresultpublishgrid button[itemId=unpublishResultItemId]':{
								click: this.onUnpublishBtnClick
							},
							'examresultpublishstructure': {
								afterrender: this.onExamResultPublishStructureRender
							},
							'bulkExamResultPublishFilter customcombobox[itemId=academicTermBulkPublish]': {
								select: this.onAcademicTermSelect
							},
							'bulkExamResultPublishFilter customcombobox[itemId=evaluationPlanIdBulkPublish]': {
								select: this.onEvalPlanSelect
							},
							'bulkExamResultPublishFilter customcombobox[itemId=programItemIdBulkPublish]': {
								select: this.onProgramSelect
							},
							'bulkExamResultPublishFilter customcombobox[itemId=batchItemIdBulkPublish]': {
								select: this.onBatchSelect
							},
							'bulkExamResultPublishFilter customcombobox[itemId=periodItemIdBulkPublish]': {
								select: this.onPeriodSelect
							},
							'bulkExamResultPublishFilter button[itemId=resetBtn]': {
								click: this.resetBulkPublishForm
							},
							'bulkExamResultPublishFilter button[itemId=searchBtn]': {
								click: this.getDataForBulkPublish
							},
							'bulkExamResultPublishGrid': {
								render: function(grid) {
    								this.addDataGridConfigButton(grid, this.getEXAM_RESULT_PUBLISH_PERMISSIONS());
    							},
    							selectionchange: this.togglePublishUnpublishBtns
							},
							'bulkExamResultPublishTab': {
								afterrender: this.disableBulkResultBtnPrivileges
							},
							'bulkExamResultPublishFilter button[itemId=bulkPublishBtn]': {
								click: this.doBulkPublishUnpublishResult
							},
							'bulkExamResultPublishGrid button[itemId=bulkPublishResultBtn]': {
								click: this.doPublishResult
							},
							'bulkExamResultPublishGrid button[itemId=bulkUnpublishResultBtn]': {
								click: this.doUnpublishResult
							},
							'bulkExamResultPublishFilter button[itemId=bulkUnpublishBtn]': {
								click: this.doBulkPublishUnpublishResult
							},
							'bulkExamResultPublishFilter multiselectcombofield[itemId=academyLocationIdBulkPublish]': {
								//select: this.doResetOtherFields,
							 	change: this.doResetOtherFields
							},
							'bulkExamResultPublishFilter': {
								render: function(cmp){
									var form = cmp.up('form');
									var loggedInUser = this.getCurrentlyLoggedInUser().id
									form.down('#academyLocationIdBulkPublish').setValue(loggedInUser);
									
									var permissionMap = this.getBULK_EXAM_RESULT_PUBLISH_PERMISSIONS();
									var associatedAcadLocationIds = new Array();
									associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
									var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
									Ext.each(permissionList, function(privilege) {
										if (privilege === 'HOST_FACULTY_CB') {
											cmp.insert(0, {
			        		                    xtype: 'fieldcontainer',
			        		                    layout: 'hbox',
			        		                    width: 500,
			        		                    items: [{
			        		                        xtype: 'checkboxfield',
			        		                        itemId: 'publishResultAsHostFaculty',
			        		                        boxLabel: getExaminationTranslation('PUBLISH_RESULT_AS_HOST_FACULTY'),
			        		                        name: 'publishResultAsHostFaculty',
			        		                        inputValue: true,
			        		                        style: 'width: 500px !important;',
			        		                        uncheckedValue: false
			        		                    }]
			        		                })
										}
									});
								}
							},
							'bulkExamResultPublishFilter checkboxfield[itemId=publishResultAsHostFaculty]': {
								change: function(cmp, nval) {
									var filterForm = cmp.up('form');
									var vals = filterForm.getValues();
									var academyLocationIdsArr = [];
									if(nval) {
										filterForm.down('#academyLocationIdBulkPublish').disable();
									}
									else {
										filterForm.down('#academyLocationIdBulkPublish').enable();
									}
									var scheme = filterForm.down('#evaluationPlanIdBulkPublish');
									if(scheme.isDisabled()) {
										return;
									}
									scheme.reset();
									var program = filterForm.down('#programItemIdBulkPublish');
									program.reset();
									program.disable();
									var batch = filterForm.down('#batchItemIdBulkPublish');
									batch.reset();
									batch.disable();
									var period = filterForm.down('#periodItemIdBulkPublish');
									period.reset();
									period.disable();
									var course = filterForm.down('#courseItemIdBulkPublish');
									course.reset();
									course.clearValue();
									course.show();
									course.disable();
									var level = filterForm.down('#evaluationLevelItemIdBulkPublish');
									level.reset();
									level.disable();
									var schemeStore = scheme.getStore();
									vals = filterForm.getValues();
									if(vals.academyLocation && typeof vals.academyLocation[0] == 'object'){
										vals.academyLocation.forEach(function(obj){
									  		academyLocationIdsArr.push(obj.get('id'));
									  	});
									}
									else{
										academyLocationIdsArr.push(vals.academyLocation)
									}
									schemeStore.getProxy().extraParams = {
										academicTermId: vals.academicTerm
									};
									if(!vals.publishResultAsHostFaculty) {
										Object.assign(schemeStore.getProxy().extraParams, {
											academyLocationIds: academyLocationIdsArr.join()
										});
									}
									schemeStore.load();
									filterForm.down('#academicTermBulkPublish').reset();
									scheme.disable();
								}
							}
							
				});
			},

			disableResultPublishBtnPivileges: function(gridReference, permissionsMap) {

				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

				var publishResultBtn = gridReference.down('#publishResultItemId');
				publishResultBtn.setVisible(false);
				var unpublishResultBtn = gridReference.down('#unpublishResultItemId');
				unpublishResultBtn.setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'PUBLISH_RESULT') {
						if (!isNullOrEmpty(publishResultBtn)) {
							publishResultBtn.setVisible(true);
						}
					}
					if (privilege === 'UNPUBLISH_RESULT') {
						if (!isNullOrEmpty(unpublishResultBtn)) {
							unpublishResultBtn.setVisible(true);
						}
					}
				});
			},
			
			changeAlEvent:function(obj,record){
				var $this=this;
				var formFilter = $this.getExamresultpublishfilter();
				var form=formFilter.getForm();
				
				if(record.length>0){
					var academyLocationIds=record.join();
				}else{
					var academyLocationIds=$this.getSelectedAcademyLocationIds();
				}
				
				var intakeYear=form.findField("intakeYear");
				form.findField("studentId").reset();
				form.findField("programId").reset();
				form.findField("batchId").reset();
				form.findField("batchId").setDisabled(true);
				form.findField("periodId").reset();
				form.findField("periodId").setDisabled(true);
				form.findField("sectionId").reset();
				form.findField("sectionId").setDisabled(true);
				form.findField("courseVariant").reset();
				form.findField("courseVariant").setDisabled(true);
				form.findField("courseId").reset();
				form.findField("courseId").setDisabled(true);
				form.findField("facultyName").reset();
				form.findField("facultyName").setDisabled(true);
				form.findField("evaluationPlanId").reset();
				form.findField("evaluationPlanId").setDisabled(true);
				form.findField("evaluationLevel").reset();
				form.findField("evaluationLevel").setDisabled(true);
				form.findField("evaluationLevelName").reset();
				form.findField("evaluationLevelName").setDisabled(true);
				var resultPublishStatus=form.findField("resultPublishStatus");
				
				//form.findField("evaluationPlanId").setDisabled(true);
				//var academyLocationIds = this.getAcademyLocationIds();
				var programId = form.findField("programId").getStore();
				var courseId = form.findField("courseId").getStore();
				var studentId = form.findField("studentId").getStore();
				var courseVariant = form.findField("courseVariant").getStore();
				form.findField("courseId").disable();
				
				
				form.findField("courseVariant").reset();
				


				intakeYear.reset();
				intakeYear.getStore().getProxy().extraParams={
					academyLocationIds:academyLocationIds,
					whetherMarksheet:true
				};
				intakeYear.getStore().load();
				
				studentId.getProxy().extraParams = {
					academyLocationIds:academyLocationIds,
					whetherMarksheet:true
				};
				studentId.load();
				
				programId.getProxy().extraParams = {
					academyLocationIds:academyLocationIds,
					whetherMarksheet:true
				};
				programId.load();
				
				resultPublishStatus.reset();
				resultPublishStatus.getStore().load({
					callback: function(records, operation, success) {
						resultPublishStatus.setValue(records[0].data.id); 
					}
				});
			},
			
			
			getSelectedAcademyLocationIds: function(){

				var form=this.getExamresultpublishfilter().getForm();
				//var academyLocationIds = [];
				var academyLocationIds = form.findField("academyLocation").getValue();
				var academyLocation;
				var mAL = form.findField("academyLocation").getValue();

				var mALArray=[];

				if(mAL !=undefined && mAL.length > 0 && mAL!=""){
					for(var i in mAL){
						if(!isNullOrEmpty(mAL[i])) {
							if(Ext.isObject(mAL[0])){
								mALArray.push(mAL[i].get("id"));
							}else{
								mALArray.push(mAL[i]);
							}
						}
					}
					academyLocation= mALArray.join();
				}else{
					academyLocation = this.getCurrentAcademyLocation();
				}
				return academyLocation;
			},
			
			onUnpublishBtnClick: function(btn) {
				var $this=this;
				var grid=this.getExamresultpublishgrid();
				if(grid.getSelectionModel().getCount()>0){
					var records=grid.getSelectionModel().getSelection();	
					var ids=[];
					
					var formFilter = $this.getExamresultpublishfilter();
					var form=formFilter.getForm();
					var message=null;
					var isPublish=null;
					if(!isNullOrEmpty(form.findField("evaluationLevelName")) && 
						form.findField("evaluationLevelName").valueModels[0]!=undefined){
					var isPublish=form.findField("evaluationLevelName").valueModels[0].data.activeStatus;
				    }
					
					if(form.getValues().evaluationLevel=="EVALUATION_EVENT" && isPublish){
						message=getExaminationTranslation('EXAM_DO_YOU_WANT_TO_PUBLISH_QUE_LEVEL_MARKS');
					}else {
						message=getExaminationTranslation('RESULT_PUBLISH_SELECTED_RECORDS')
					}
					
					for(var i in records){
						ids.push(records[i].data.levelId);
					}
					var evaluationLevel=records[0].data.evaluationLevel;

					saveResultPublishData={
							'levelIds':ids.join(),
							'evaluationLevel':evaluationLevel,
							'isResultUnPulished': true
					}
					Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
					Ext.Ajax.request({
						type: 'rest',
						jsonData: saveResultPublishData,
						method: 'POST',
						url : SERVERURL.EXAM_RESULT_PUBLISH_GRID_CREATE_UPDATE,
						success : function(response, action) {
							Ext.getBody().unmask();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							showSuccessMessage(getExaminationTranslation('RESULT_UNPUBLISH'),
									getExaminationTranslation('RESULT_UNPUBLISHED_SUCCESS'));
						}
					});
				}else{
					showWarningMessage(getExaminationTranslation('RESULT_PUBLISH'),
							getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			
			onExamResultPublishStructureRender: function(tabPanel) {
				//test1
				var permissionMap = this.getEXAM_RESULT_PUBLISH_PERMISSIONS();
   				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
				if(permissionsList.indexOf('BULK_EXAM_RESULT_PUBLISH_TAB') != -1) {
					tabPanel.add({
						xtype:'bulkExamResultPublishTab'
					});
					var currentAl = this.getCurrentAcademyLocation();
					var filterForm = this.getBulkExamResultPublishFilter();
					var alFld = filterForm.down('#academyLocationIdBulkPublish');
					var alFldStore = alFld.getStore();
					alFldStore.load({
						callback: function() {
							alFld.setValue(currentAl);
						}
					});
					var searchForm = this.getExamresultpublishfilter();
					var alField = searchForm.down('#academyLocationId');
					alField.getStore().load({
						callback: function() {
							alField.expand();
							alField.setValue(currentAl);
							alField.collapse();
						}
					});
				}
			},
			
			onAcademicTermSelect: function(combo, rec) {
				var academyLocationIdsArr = [];
				var filterForm = combo.up('form');
				var vals = filterForm.getValues();
				var scheme = filterForm.down('#evaluationPlanIdBulkPublish');
				scheme.reset();
				scheme.enable();
				var schemeStore = scheme.getStore();
				if(vals.academyLocation && typeof vals.academyLocation[0] == 'object'){
					vals.academyLocation.forEach(function(obj){
				  		academyLocationIdsArr.push(obj.get('id'));
				  	});
				}
				else{
					academyLocationIdsArr.push(vals.academyLocation)
				}
				schemeStore.getProxy().extraParams = {
					//academyLocationIds: academyLocationIdsArr.join(),
					academicTermId: vals.academicTerm
				};
				if(!vals.publishResultAsHostFaculty) {
					Object.assign(schemeStore.getProxy().extraParams, {
						academyLocationIds: academyLocationIdsArr.join()
					});
				}
				schemeStore.load();
				
				var program = filterForm.down('#programItemIdBulkPublish');
				program.reset();
				program.disable();
				
				var batch = filterForm.down('#batchItemIdBulkPublish');
				batch.reset();
				batch.disable();
				
				var period = filterForm.down('#periodItemIdBulkPublish');
				period.reset();
				period.disable();
				
				var course = filterForm.down('#courseItemIdBulkPublish');
				course.reset();
				course.disable();
				
				var planLevel = filterForm.down('#evaluationLevelItemIdBulkPublish');
				planLevel.reset();
				planLevel.disable();
			},
			
			onEvalPlanSelect: function(combo, rec) {
				var academyLocationIdsArr = []
				var filterForm = combo.up('form');
				var vals = filterForm.getValues();
				var program = filterForm.down('#programItemIdBulkPublish');
				program.reset();
				program.enable();
				var programStore = program.getStore();
				if(vals.academyLocation && typeof vals.academyLocation[0] == 'object'){
					vals.academyLocation.forEach(function(obj){
				  		academyLocationIdsArr.push(obj.get('id'));
				  	});
				}
				else{
					academyLocationIdsArr.push(vals.academyLocation)
				}
				if(rec[0].get('code') == 'OTHER') {
					programStore.getProxy().api.read = SERVERURL.PATH_FIND_PROG_BY_PLAN_FOR_OTHER;
				}
				else {
					programStore.getProxy().api.read = SERVERURL.PATH_FIND_ALL_PROGRAMS_BY_PLANANDAL;
				}
				programStore.getProxy().extraParams = {
					//academyLocationIds: academyLocationIdsArr.join(),
					evaluationPlanId: vals.evaluationPlanId,
					isPublisHostFaculty: vals.publishResultAsHostFaculty
				};
				if(!vals.publishResultAsHostFaculty) {
					Object.assign(programStore.getProxy().extraParams, {
						academyLocationIds: academyLocationIdsArr.join()
					});
				}
				programStore.load();
				
				this.loadCourseData(filterForm, vals);
				
				var batch = filterForm.down('#batchItemIdBulkPublish');
				batch.reset();
				batch.disable();
				
				var period = filterForm.down('#periodItemIdBulkPublish');
				period.reset();
				period.disable();
				
				var planLevel = filterForm.down('#evaluationLevelItemIdBulkPublish');
				planLevel.reset();
				planLevel.enable();				
				var planLevelStore = planLevel.getStore();
				planLevelStore.getProxy().extraParams = {
					evaluationPlanId: vals.evaluationPlanId
				};
				planLevelStore.load();
				
				if(rec && rec[0] && rec[0].get('code') == 'ACADEMICS') {
					filterForm.down('#courseItemIdBulkPublish').show();
					filterForm.down('#courseItemIdBulkPublish').setDisabled(false);
				}
				else {
				
					filterForm.down('#courseItemIdBulkPublish').hide();
					filterForm.down('#courseItemIdBulkPublish').setDisabled(true);
					filterForm.down('#courseItemIdBulkPublish').allowBlank=true;
				}
			},
			
			onProgramSelect: function(combo, rec) {
				var filterForm = combo.up('form');
				var vals = filterForm.getValues();
				var batch = filterForm.down('#batchItemIdBulkPublish');
				batch.reset();
				batch.enable();
				var batchStore = batch.getStore();
				batchStore.getProxy().extraParams = {
					programId: vals.programId
				};
				batchStore.load();
				
				var period = filterForm.down('#periodItemIdBulkPublish');
				period.reset();
				period.disable();
				
				this.loadCourseData(filterForm, vals);
			},
			onBatchSelect: function(combo, rec) {
				var filterForm = combo.up('form');
				var vals = filterForm.getValues();
				var period = filterForm.down('#periodItemIdBulkPublish');
				period.reset();
				period.enable();
				var periodStore = period.getStore();
				periodStore.getProxy().extraParams = {
					batchId: vals.batchId,
					academicTermId: vals.academicTerm
				};
				periodStore.load();
				
				this.loadCourseData(filterForm, vals);
			},
			
			onPeriodSelect: function(combo, rec) {
				var filterForm = combo.up('form');
				var vals = filterForm.getValues();
				this.loadCourseData(filterForm, vals);
			},
			
			resetBulkPublishForm: function(btn) {
				var form = btn.up('form');
				form.getForm().reset();
				
				var currentAl = this.getCurrentAcademyLocation();
				var alFld = form.down('#academyLocationIdBulkPublish');
				alFld.setValue(currentAl);
				
				form.down('#evaluationPlanIdBulkPublish').disable();
				form.down('#programItemIdBulkPublish').disable();
				form.down('#batchItemIdBulkPublish').disable();
				form.down('#periodItemIdBulkPublish').disable();
				form.down('#courseItemIdBulkPublish').disable();
				form.down('#evaluationLevelItemIdBulkPublish').disable();
			},
			
			loadCourseData: function(filterForm, vals) {
				var course = filterForm.down('#courseItemIdBulkPublish');
				var academyLocationIdsArr = []
				if(vals.academyLocation && typeof vals.academyLocation[0] == 'object'){
					vals.academyLocation.forEach(function(obj){
				  		academyLocationIdsArr.push(obj.get('id'));
				  	});
				}
				else{
					academyLocationIdsArr.push(vals.academyLocation)
				}					

				course.reset();
				//if (!course.disable()) {  
					course.enable()          // V2D-471577
		        //}
				var courseStore = course.getStore();
				courseStore.getProxy().extraParams = {
					evaluationPlanId: vals.evaluationPlanId,
					//academyLocationIds: academyLocationIdsArr.join(),
					academicTermId: vals.academicTerm,
					programId: vals.programId,
					batchId: vals.batchId,
					periodId: vals.periodId
				};
				if(!vals.publishResultAsHostFaculty) {
					Object.assign(courseStore.getProxy().extraParams, {
						academyLocationIds: academyLocationIdsArr.join()
					});
				}
				courseStore.proxy.api.read = SERVERURL.PATH_FIND_COURSE_AND_CV;
				courseStore.load();
			},
			getDataForBulkPublish: function(btn) {
				var academyLocationIdsArr = []
				var form = btn.up('form');
				var publishBtn = form.down('#bulkPublishBtn');
				var unpublishBtn = form.down('#bulkUnpublishBtn');
				publishBtn.disable();
				unpublishBtn.disable();
				var vals = form.getValues();
				var grid = this.getBulkExamResultPublishGrid();
				var store = grid.getStore();
				
				
				var courseIds = [];
				if(!isNullOrEmpty(vals.courseId) && !isNullOrEmpty(vals.courseId[0])) {
					for(var i = 0; i < vals.courseId.length; i++) {
						courseIds.push(vals.courseId[i].get('id'));
					}
				}
				var levelOneId=null;
				var levelTwoId=null;
				var levelThreeId=null;
				var levelFourId=null;
				var assessmentSchemeLevel = form.down('#evaluationLevelItemIdBulkPublish');
				var record = assessmentSchemeLevel.lastSelection;
				var filterPlanId = null;
				if(record && record.length && !isNullOrEmpty(record[0].data.code)) {
					if(record[0].data.code == "Assessment Method"){
						levelThreeId=record[0].data.levelId;
					}
					else if(record[0].data.code=="Assessment Sub Type"){
						levelTwoId=record[0].data.levelId;
					}
					else if(record[0].data.code=="Assessment Type"){
						levelOneId=record[0].data.levelId;
					}
					else if(record[0].data.code=="Assessment Event"){
						levelFourId=record[0].data.levelId;
					}
					else if(record[0].data.code=="Assessment Scheme"){
						filterPlanId = record[0].data.levelId;
					}
				}
				if(vals.academyLocation && typeof vals.academyLocation[0] == 'object'){
					vals.academyLocation.forEach(function(obj){
				  		academyLocationIdsArr.push(obj.get('id'));
				  	});
				}
				else{
					academyLocationIdsArr.push(vals.academyLocation)
				}
				store.getProxy().extraParams = {
					academicTermId: vals.academicTerm,					
					academyLocationIds: academyLocationIdsArr.join(),
					evaluationPlanId: vals.evaluationPlanId,
					programId: vals.programId,
					batchId: vals.batchId,
					periodId: vals.periodId,
					courseIds: courseIds.join(","),
					filterPlanId: filterPlanId,
					evaluationPlanOneId: levelOneId,
					evaluationPlanTwoId: levelTwoId,
					evaluationSequenceId: levelThreeId,
					eventId: levelFourId,
					isPublishHostFaculty: vals.publishResultAsHostFaculty
				};
				this.resetPageSetting(store, grid);
				grid.getStore().pageSize = 100;
				grid.getSelectionModel().deselectAll();
				store.load({
					callback: function(records, operation, success) {
						if (success) {
							if(grid.getStore().getCount()>0){
								publishBtn.enable();
								unpublishBtn.enable();
							}
							if(record && record.length && !isNullOrEmpty(record[0].data.code)) {
								
								switch(record[0].data.code) {
								case 'Assessment Scheme':
									grid.columns[10].setVisible(false);
									grid.columns[11].setVisible(false);
									grid.columns[12].setVisible(false);
									grid.columns[13].setVisible(false);
									break;
								case 'Assessment Type':
									grid.columns[10].setVisible(true); 
									grid.columns[11].setVisible(false);
									grid.columns[12].setVisible(false);
									grid.columns[13].setVisible(false);
									break;
								case 'Assessment Sub Type':
									grid.columns[10].setVisible(true);
									grid.columns[11].setVisible(true);
									grid.columns[12].setVisible(false);
									grid.columns[13].setVisible(false);
									break;
								case 'Assessment Method':
									grid.columns[10].setVisible(true);
									grid.columns[11].setVisible(true);
									grid.columns[12].setVisible(true);
									grid.columns[13].setVisible(false);
									break;
								default:
									grid.columns[10].setVisible(true);
								grid.columns[11].setVisible(true);
								grid.columns[12].setVisible(true);
								grid.columns[13].setVisible(true);
								break;
								}
							}
							else {
								grid.columns[10].setVisible(true);
								grid.columns[11].setVisible(true);
								grid.columns[12].setVisible(true);
								grid.columns[13].setVisible(true);
							}
							var courseVariant = searchColumnInArray('courseVariantName', grid.columns, true);
							var evaluationPlan = searchColumnInArray('evaluationPlanName', grid.columns, true);
							var cvWidth = courseVariant.getWidth();
							var epWidth = evaluationPlan.getWidth();
							Ext.defer(function() {
								courseVariant.flex = null;
								evaluationPlan.flex = null;
								courseVariant.setWidth(cvWidth + 5);
								courseVariant.setWidth(cvWidth - 5);
								evaluationPlan.setWidth(epWidth + 5);
								evaluationPlan.setWidth(epWidth - 5);
							}, 1000);
						}
					}
				});
			},
			
			disableBulkResultBtnPrivileges: function(panel) {
				//testSero25-06
				var $this=this;
    	    	var loggedAL = this.getCurrentAcademyLocation();
    	    	var academyLocationId = panel.down('#academyLocationIdBulkPublish')
				academyLocationId.getStore().load({
				    callback: function(){
				    	academyLocationId.expand();
				    	academyLocationId.setValue([loggedAL]);
				    	academyLocationId.collapse();
				    }
				});
				
				var grid = panel.down('bulkExamResultPublishGrid');
				this.getGridHeaderFreezeForAssessmentScheme(grid, panel);
				var permissionMap = this.getBULK_EXAM_RESULT_PUBLISH_PERMISSIONS();
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
				this.disableButtonsByPivileges(permissionList, grid);
				var bulkPublishBtn = panel.down('#bulkPublishBtn');
				bulkPublishBtn.hide();
				var bulkUnpublishBtn = panel.down('#bulkUnpublishBtn');
				bulkUnpublishBtn.hide();
				var publishResultBtn = panel.down('#bulkPublishResultBtn');
				publishResultBtn.hide();
				var unPublishResultBtn = panel.down('#bulkUnpublishResultBtn');
				unPublishResultBtn.hide();
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'BULK_PUBLISH_RESULT') {
						if (!isNullOrEmpty(bulkPublishBtn)) {
							bulkPublishBtn.setVisible(true);
						}
					}
					if (privilege === 'BULK_UNPUBLISH_RESULT') {
						if (!isNullOrEmpty(bulkUnpublishBtn)) {
							bulkUnpublishBtn.setVisible(true);
						}
					}
					if (privilege === 'PUBLISH_RESULT') {
						if (!isNullOrEmpty(publishResultBtn)) {
							publishResultBtn.setVisible(true);
							grid.removeCls('bulk-exam-result-publish-grid');
						}
					}
					if (privilege === 'UNPUBLISH_RESULT') {
						if (!isNullOrEmpty(unPublishResultBtn)) {
							unPublishResultBtn.setVisible(true);
							grid.removeCls('bulk-exam-result-publish-grid');
						}
					}
				});
				try{
					panel.body.on('scroll', function(){
						if(Ext.query('.x-boundlist:visible').length){
							var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
							if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse){
								boundListCombo.collapse();
							}
						}
					});
				}
				catch(e) { }
			},
			
			doBulkPublishUnpublishResult: function (btn) {
				var academyLocationIdsArr = []
				var $this = this;
				var form = btn.up('form');
				var vals = form.getValues();
				var evaluationLevelItemIdBulkPublish = form.down('#evaluationLevelItemIdBulkPublish');
				if(evaluationLevelItemIdBulkPublish.lastSelection[0]){
					var evaluationLevelId=evaluationLevelItemIdBulkPublish.lastSelection[0].data.levelId;
				}
				
				if(Ext.isArray(vals.academyLocation)){
					vals.academyLocation.forEach(function(obj){
				  		if(typeof obj == "number"){
							academyLocationIdsArr.push(obj);
						}
						else{
				  			academyLocationIdsArr.push(obj.get('id'));
						}
				  	});
				}
				else{
					academyLocationIdsArr.push(vals.academyLocation)
				}
			    var confirmTitle = getExaminationTranslation('BULK_RESULT_PUBLISH');
			    var confirmMsg = getExaminationTranslation('CONFIRM_BULK_PUBLISH_MSG');
			    if(btn.itemId == 'bulkUnpublishBtn') {
			    	confirmTitle = getExaminationTranslation('BULK_RESULT_UNPUBLISH');
				    confirmMsg = getExaminationTranslation('CONFIRM_BULK_UNPUBLISH_MSG');
			    }
			    showConfirmMessage(confirmTitle, confirmMsg, function (cbtn, text) {
			        if (cbtn == 'yes') {
			        	var courseIds = [];
						if(!isNullOrEmpty(vals.courseId) && !isNullOrEmpty(vals.courseId[0])) {
							for(var i = 0; i < vals.courseId.length; i++) {
								courseIds.push(vals.courseId[i].get('id'));
							}
						}
			            var levelOneId=null;
						var levelTwoId=null;
						var levelThreeId=null;
						var levelFourId=null;
						var assessmentSchemeLevel = form.down('#evaluationLevelItemIdBulkPublish');
						var record = assessmentSchemeLevel.lastSelection;
						var filterPlanId = null;
						if(record && record.length && !isNullOrEmpty(record[0].data.code)) {
							if(record[0].data.code == "Assessment Method"){
								levelThreeId=record[0].data.levelId;
							}
							else if(record[0].data.code=="Assessment Sub Type"){
								levelTwoId=record[0].data.levelId;
							}
							else if(record[0].data.code=="Assessment Type"){
								levelOneId=record[0].data.levelId;
							}
							else if(record[0].data.code=="Assessment Event"){
								levelFourId=record[0].data.levelId;
							}
							else if(evaluationLevelId && record[0].data.code=="Assessment Scheme"){
								filterPlanId = evaluationLevelId;
							}
						}
			            saveResultPublishData = {
			            	academicTermId: vals.academicTerm,
			            	academyLocationIds: academyLocationIdsArr.join(),
			            	evaluationPlanId: vals.evaluationPlanId,
			            	programId: vals.programId,
			            	batchId: vals.batchId,
			            	periodId: vals.periodId,
			            	courseIds: courseIds.join(","),
			            	filterPlanId: filterPlanId,
			            	evaluationPlanOneId: levelOneId,
			            	evaluationPlanTwoId: levelTwoId,
			            	evaluationSequenceId: levelThreeId,
			            	eventId: levelFourId,
			            	whetherPublish: btn.itemId == 'bulkUnpublishBtn' ? false : true,
			            	isPublisHostFaculty: vals.publishResultAsHostFaculty
			            };
			            Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
			            var submitUrl = SERVERURL.PATH_BULK_EXAM_RESULT_PUBLISH_JOB;
			            if(btn.itemId == 'bulkUnpublishBtn') {
			            	submitUrl = SERVERURL.PATH_BULK_EXAM_RESULT_UNPUBLISH;
			            }
			            Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
			            Ext.Ajax.request({
			                type: 'rest',
			                jsonData: saveResultPublishData,
			                method: 'POST',
			                url: submitUrl,
			                success: function (response, action) {
			                    Ext.getBody().unmask();
			                    $this.getDataForBulkPublish(btn);
			                    var successTitle = getExaminationTranslation('BULK_RESULT_PUBLISH');
			    			    var successMsg = getExaminationTranslation('BULK_RESULT_PUBLISHED_SUCCESSFULLY');
			    			    if(btn.itemId == 'bulkUnpublishBtn') {
			    			    	successTitle = getExaminationTranslation('BULK_RESULT_UNPUBLISH');
			    			    	successMsg = getExaminationTranslation('BULK_RESULT_UNPUBLISHED_SUCCESSFULLY');
			    			    }
			                    showSuccessMessage(successTitle, successMsg);
			                }
			            });
			        }
			    });
			},
			
			togglePublishUnpublishBtns: function(grid, selected) {
				var unpublishBtn= grid.view.up('grid').down('#bulkUnpublishResultBtn');
				var publishBtn= grid.view.up('grid').down('#bulkPublishResultBtn');
				if(selected.length) {
					var disableFlagCntUnpublish = 0;
					var disableFlagCntPublish = 0;
					for(var i = 0; i < selected.length; i++) {
						if(!isNullOrEmpty(selected[i].get('resultPublishStatus')) && selected[i].get('resultPublishStatus')) {
							disableFlagCntUnpublish = disableFlagCntUnpublish + 1;
						}
						else if(!isNullOrEmpty(selected[i].get('resultPublishStatus')) && !selected[i].get('resultPublishStatus')) {
							disableFlagCntPublish = disableFlagCntPublish + 1;
						}
					}
					if(disableFlagCntUnpublish == selected.length) {
						unpublishBtn.enable();
					}
					else {
						unpublishBtn.disable();
					}
					
					if(disableFlagCntPublish == selected.length) {
						publishBtn.enable();
					}
					else {
						publishBtn.disable();
					}
				}
				else {
					unpublishBtn.disable();
					publishBtn.disable();
				}
			},
			
			doPublishResult: function(btn) {
				var $this = this;
				var grid = btn.up('grid');
				if(grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();	
					var ids = [];
					var formFilter = $this.getBulkExamResultPublishFilter();
					var form = formFilter.getForm();
					var isPublish = null;
					var message=null;
					var isPublish=null;
					if(!isNullOrEmpty(form.findField("evaluationLevelItemIdBulkPublish")) && form.findField("evaluationLevelItemIdBulkPublish").valueModels[0] != undefined) {
						isPublish = form.findField("evaluationLevelItemIdBulkPublish").valueModels[0].data.activeStatus;
					}
					var holdCount = 0;
					var holdStdIds = [];
					for(var i = 0; i < records.length; i++) {
						if(records[i].get('whetherResultPublishHold')) {
							holdStdIds.push(records[i].get('studentCode'));
						}
					}
					holdCount = holdStdIds.filter(onlyUnique);
					if(holdCount.length) {
						message = holdCount.length + ' ' + getExaminationTranslation('STUDENTS_ON_HOLD_FOR_RESULT_PUBLISH');
					}
					else if(form.getValues().evaluationLevel=="EVALUATION_EVENT" && isPublish){
						message = getExaminationTranslation('EXAM_DO_YOU_WANT_TO_PUBLISH_QUE_LEVEL_MARKS');
					}
					else {
						message = getExaminationTranslation('RESULT_PUBLISH_SELECTED_RECORDS')
					}
					showConfirmMessage(getExaminationTranslation('RESULT_PUBLISH'),
							message,
							function(cbtn,text){
						if (cbtn == 'yes') {
							for(var i in records){
								ids.push(records[i].data.levelId);
							}
							var evaluationLevel = records[0].data.evaluationLevel;

							saveResultPublishData = {
									'levelIds': ids.join(),
									'evaluationLevel': evaluationLevel,
									'isResultUnPulished': false
							};
							Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
							Ext.Ajax.request({
								type: 'rest',
								jsonData: saveResultPublishData,
								method: 'POST',
								url: SERVERURL.EXAM_RESULT_PUBLISH_GRID_CREATE_UPDATE,
								success: function(response, action) {
									Ext.getBody().unmask();
									grid.getStore().reload();
									grid.getSelectionModel().deselectAll();
									showSuccessMessage(getExaminationTranslation('BULK_RESULT_PUBLISH'), getExaminationTranslation('RESULT_PUBLISHED_SUCCESSFULLY'));
								}
							});
						}
					});
				}
			},
			
			doUnpublishResult: function(btn) {
				var $this = this;
				var grid = btn.up('grid');
				if(grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();	
					var ids = [];
					var formFilter = $this.getBulkExamResultPublishFilter();
					var form = formFilter.getForm();
					var isPublish = null;
					if(!isNullOrEmpty(form.findField("evaluationLevel")) && form.findField("evaluationLevel").valueModels[0] != undefined){
						isPublish = form.findField("evaluationLevel").valueModels[0].data.activeStatus;
					}

					for(var i in records){
						ids.push(records[i].data.levelId);
					}
					var evaluationLevel = records[0].data.evaluationLevel;

					saveResultPublishData={
						'levelIds': ids.join(),
						'evaluationLevel': evaluationLevel,
						'isResultUnPulished': true
					}
					Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
					Ext.Ajax.request({
						type: 'rest',
						jsonData: saveResultPublishData,
						method: 'POST',
						url : SERVERURL.EXAM_RESULT_PUBLISH_GRID_CREATE_UPDATE,
						success : function(response, action) {
							Ext.getBody().unmask();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							showSuccessMessage(getExaminationTranslation('BULK_RESULT_UNPUBLISH'), getExaminationTranslation('RESULT_UNPUBLISHED_SUCCESS'));
						}
					});
				}
			},
			
			checkPublishUnpublishButtons: function(selected, publishBtn, unpublishBtn) { // V2D-531116
				if (!selected.length) { 
			        publishBtn.disable();
			        unpublishBtn.disable();
			        return;
			    }

			    var allPublished = selected.every(function(rec){
			        return rec.get('resultPublishStatus') === true;
			    });

			    var allUnpublished = selected.every(function(rec){
			        return !rec.get('resultPublishStatus');
			    });

			    publishBtn.setDisabled(!allUnpublished);
			    unpublishBtn.setDisabled(!allPublished);
			},
			doResetOtherFields: function(cmp) {
				var form = cmp.up('form');
				var academicAL = form.down('#academyLocationIdBulkPublish');
				var academicTerm = form.down('#academicTermBulkPublish');
				var evalPlan = form.down('#evaluationPlanIdBulkPublish');
				var program = form.down('#programItemIdBulkPublish');
				var batch = form.down('#batchItemIdBulkPublish');
				var period = form.down('#periodItemIdBulkPublish');
				var course = form.down('#courseItemIdBulkPublish');
				var evalLevel = form.down('#evaluationLevelItemIdBulkPublish');
				//academicAL.reset()
				academicTerm.reset();
				evalPlan.reset();
				program.reset();
				batch.reset();
				period.reset();
				course.reset();
				course.clearValue();
				evalLevel.reset();
				
				evalPlan.disable();
				program.disable();
				batch.disable();
				period.disable();
				course.disable();
				evalLevel.disable();
				
				var alVal = academicAL.getValue(); 
  				 var als=[];		       				
//        	    	if(typeof al[0] == 'object'){
//                       al.forEach(function(obj){
//                         als.push(obj.get('id'));
//	                     });
//	               }
//	               else{
//	                   als.push(al)
//	               }	 
        	    	
				if(!isNullOrEmpty(alVal && alVal.length > 0)){
  				//if(alVal && alVal.length > 0){
                    try{
                         als = Ext.Array.pluck(Ext.Array.pluck(alVal, 'data'), 'id').join();
                    } catch(e) {
                    	als = als.join();
                    }
                }
        	    	
        	     	
        	    	
        	    	academicTerm.getStore().getProxy().extraParams={
        	    		academyLocationIds:als
        	    	}
        	    	academicTerm.getStore().load();
        	    	
			},
//			onALchangeCall:  function(cmp){
//				var form = cmp.up('form');
//				var academicAL = form.down('#academyLocationIdBulkPublish');
//				var academicTerm = form.down('#academicTermBulkPublish');			
//			
//				//academicAL.reset()
//				academicTerm.reset();
//				
//				evalPlan.disable();
//				program.disable();
//				batch.disable();
//				period.disable();
//				course.disable();
//				evalLevel.disable();
//				
//				var al = form.academicAL;
//  				 var als=[];		       				
//        	    	if(typeof al == 'object'){
//                       al.forEach(function(obj){
//                         als.push(obj.get('id'));
//	                     });
//	               }
//	               else{
//	                   als.push(al)
//	               }
//        	    	
//        	    	academicTerm.getStore().getProxy().extraParams={
//        	    		academyLocationIds:als.join()
//        	    	}
//        	    	academicTerm.getStore().load();
//			}
});