/**
 * @author Bhanu PS
 * 
 **/
Ext.define('Academia.controller.examinationcenters.examinationRemark.ExaminationRemarkController', {
	extend : 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examCenter.AssignSequence.EvaluationType','examinationcenters.dashboard.EvaluationPlanByAcademyAndEvalType', 'examinationcenters.dashboard.CourseForExaminationRemark',
	          'examCenter.AssignSequence.ExamintionRemarkGridStore','examCenter.AssignSequence.ExamintionRemarkCourseGridStore','examCenter.AssignSequence.ExamintionRemarkProgramGridStore',
	          'examCenter.AssignSequence.ExamintionRemarkPlanGridStore', 'facilitiesresources.resourcemaster.ProgramGridStore',
	          'importutility.ImportExaminationRemark', 'importutility.ModuleName'],

	views : ['examinationcenters.examinationRemark.ExamRemarkFilter', 'examinationcenters.examinationRemark.ExaminationRemarkStructure','examinationcenters.examinationRemark.ExaminationRemarkProgramGrid',
	         'examinationcenters.examinationRemark.ExaminationRemarkGrid','examinationcenters.examinationRemark.ExaminationRemarkCourseGrid',
	         'examinationcenters.examinationRemark.ExaminationRemarkPlanGrid', 'examinationcenters.examinationRemark.AddRemarkWin',
	         'examinationcenters.examinationRemark.uploaddownload.ExaminationRemarkUploaddownloadStructure',
	         'examinationcenters.examinationRemark.uploaddownload.ExaminationRemarkDownloadForm',
	         'examinationcenters.examinationRemark.uploaddownload.ExaminationRemarkUploadForm',
	         'importutility.ImportByModule.ImportListExaminationRemark','UploadOptionRadioGroup'
	         ],	
	config:{
			    EXAMINATION_REMARK_LIST_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_REMARK_LIST_PRIVILEGES'),
			    EXAMINATION_REMARK_COURSE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_REMARK_COURSE_PRIVILEGES'),
			    EXAMINATION_REMARK_PLAN_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_REMARK_PLAN_PRIVILEGES'),
			    EXAMINATION_REMARK_PRIVILEGES_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap(' EXAMINATION_REMARK_PRIVILEGES'),
             	CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
	},	
	         refs : [{
	        	 ref:'examremarkfilter',
	        	 selector:'examremarkfilter'
	         },{
	        	 ref:'examinationremarkstructure',
	        	 selector:'examinationremarkstructure'
	         },{
	        	 ref:'examinationremarkcoursegrid',
	        	 selector:'examinationremarkcoursegrid'
	         },{
	        	 ref:'examinationremarkgrid',
	        	 selector:'examinationremarkgrid'
	         },{
	        	 ref:'examinationremarkplangrid',
	        	 selector:'examinationremarkplangrid'
	         },{
	        	 ref:'addremarkwin',
	        	 selector:'addremarkwin'
	         },{
	        	 ref:'examinationremarkprogramgrid',
	        	 selector:'examinationremarkprogramgrid'
	         },{
	        	 ref:'importlistexaminationremark',
	        	 selector:'importlistexaminationremark'
	         },{
            	 ref : 'uploadoptionradiogroup',
            	 selector : 'uploadoptionradiogroup[itemId=examinationremarkUploadOptionRadioGroupItemId]'
             }],
	         init : function() {
	        	 this.control({
	        		 'addremarkwin' : {
	        			 afterrender:function(window){
		        				$this = this;
		        				var filterForm = window.down('form');
		        				window.body.on('click',function() {
	          						$this.hideInvalidIconFromField(filterForm);
	        			       });
		        			}  
	        		 },
	        		 'examinationremarkcoursegrid':{
	        			 render:function(obj){
	        				 obj.getStore().clearData();
	        				 this.doAccessControlValidation(obj, this.getEXAMINATION_REMARK_COURSE_PERMISSION()); 
	        			 }
	        		 },
	        		 
	        		 'examinationremarkgrid':{
	        			 render:function(obj){
	        				 this.doAccessControlValidation(obj, this.getEXAMINATION_REMARK_LIST_PERMISSION()); 
	        			 }
	        		 },
	        		 
	        		 'examinationremarkplangrid':{
	        			 render:function(obj){
	        				 obj.getStore().clearData();
	        				 this.doAccessControlValidation(obj, this.getEXAMINATION_REMARK_PLAN_PERMISSION()); 
	        			 }
	        		 },
	        		 'examinationremarkstructure':{
	        			  render:function(form){
	        				  var $this = this;
	        				  var grid = $this.getExaminationremarkgrid();
	        				  this.doAccessControlValidation(grid, this.getEXAMINATION_REMARK_LIST_PERMISSION()); 
	        				  grid.getStore().getProxy().extraParams= {
	        					  id:92,
	        				  };
	        				  grid.getStore().load();
	        			  },
	        		 	  beforerender:function(form){
	        		 		  this.disableImportExaminationRemarkTab(form,this.getEXAMINATION_REMARK_LIST_PERMISSION()); 
	        		 	  }
	        		  },
	        		  'examinationremarkgrid':{
	        			  select: function(model, records) { 
	        				  var $this = this;
	        				  var grid = $this.getExaminationremarkgrid();
	        				  var childGrid1 = $this.getExaminationremarkcoursegrid();
	        				  var parentRecordId=records.data.id
	        				  var childGrid2 = $this.getExaminationremarkplangrid();
	        				  var childGrid3 = $this.getExaminationremarkprogramgrid();
	        				  $this.updateChildRemarkGrid(childGrid1, childGrid2, childGrid3, parentRecordId);
	        			  }
	        		  },
	        		  
	        		  'examinationremarkgrid button[itemId=btnAdd]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkgrid();
	        				  this.OpenAddRemarkWindow(false, grid);
	        			  }
	        		  },
	        		  
	        		  'examinationremarkgrid button[itemId=btnDelete]': {
	        			  click: function(obj) {
	        				  this.deleteRemark();
	        			  }
	        		  },
	        		  
	        		  'examinationremarkgrid button[itemId=btnEdit]': {
	        			  click: function(obj) {
	        				  var $this = this;
	        				  var grid = $this.getExaminationremarkgrid();
	        				  var record = grid.getSelectionModel().getSelection()[0];
	        				  if (grid.getSelectionModel().getCount() > 0) {
	        					  $this.OpenAddRemarkWindow(true, grid);
	        				  } else {
	        					  showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        				  }
	        			  }
	        		  },
	        		  
	        		  'addremarkwin button[itemId=submitButtonId]': {
	        			  click: function(obj) {
	        				  this.saveRemarkAddedRemark();
	        			  }
	        		  },
	        		  
	        		  'addremarkwin button[itemId=cancelButtonId]': {
	        			  click: function(obj) {
	        				  this.getAddremarkwin().close();
	        			  }
	        		  },

	        		  'examinationremarkcoursegrid button[itemId=btnAdd]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkcoursegrid();
	        				  this.OpenAddRemarkWindow(false, grid);
	        			  }
	        		  },	
	        		  'examinationremarkcoursegrid button[itemId=searchResultGridBtnEdit]': {
	        			  click: function(obj) {
	        				  var $this = this;
	        				  var grid = $this.getExaminationremarkcoursegrid();
	        				  var record = grid.getSelectionModel().getSelection()[0];
	        				  if (grid.getSelectionModel().getCount() > 0) {
	        					  $this.OpenAddRemarkWindow(true, grid);
	        				  } else {
	        					  showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        				  }
	        			  }
	        		  },	
	        		  
	        		  
	        		  'examinationremarkplangrid button[itemId=btnAdd]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkplangrid();
	        				  this.OpenAddRemarkWindow(false, grid);
	        			  }
	        		  },	
	        		  
	        		  'examinationremarkprogramgrid button[itemId=btnAdd]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkprogramgrid();
	        				  this.OpenAddRemarkWindow(false, grid);
	        			  }
	        		  },	
	        		  
	        		  'examinationremarkcoursegrid button[itemId=btnDelete]': {
	        			  click: function(obj) {
	        				  var $this = this;
	        				  var grid = $this.getExaminationremarkcoursegrid();
	        				  $this.deleteRemarkMapping(grid);
	        			  }
	        		  },	
	        		  
	        		  'examinationremarkplangrid button[itemId=btnDelete]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkplangrid();
	        				  this.deleteRemarkMapping(grid);
	        			  }
	        		  },	
	        		  
	        		  'examinationremarkprogramgrid button[itemId=btnDelete]': {
	        			  click: function(obj) {
	        				  var grid= this.getExaminationremarkprogramgrid();
	        				  this.deleteRemarkMapping(grid);
	        			  }
	        		  },
	        		  'examinationremarkuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	        			  change: this.examinationRemarkDownloadUploadFormChange
	        		  },
	        		  'examinationremarkdownloadform button[itemId=resetBtn]':{
	        			  click:function(obj){
	        				  var $this = this;
	        				  var form =obj.up('examinationremarkdownloadform').getForm();
	        				  form.reset();
	        			  }  
	        		  },
	        		  'examinationremarkdownloadform button[itemId=downoladBtnId]':{
	        			  click:function(obj){
	        				  var $this = this;
	        				  var form =obj.up('examinationremarkdownloadform').getForm();
	        				  var value = form.getValues();
	        				  var csvForm = Ext.create('Ext.form.Panel'); 
	        				  csvForm.getForm().submit({
	        					  target: '_blank',
	        					  method:'POST',
	        					  params :{
	        						  access_token : Ext.Ajax.defaultHeaders.access_token
	        					  },
	        					  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        					  url: SERVERURL.DOWNLOAD_TEMPLATE_EXAMINATION_REMARK,
	        					  standardSubmit :true
	        				  });
	        			  }  
	        		  },
	        		  'examinationremarkuploadform button[itemId=uploadId]':{
	        			  click:function(obj){
	        				  var $this=this;
	        				  var form=obj.up('examinationremarkuploadform');
							  var grid = $this.getImportlistexaminationremark();
	        				  submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        				  $this.getHashOfFile(form);
	        				  setTimeout(function() {
		        				  form.getForm().submit({
		        					  method : 'POST',
		        					  url : submitUrl,
		        					  success : function(form, action){
		        						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		        					  },
		        					  failure: function(form, action) {
		     		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		        					  }
		        				  });
	        				  },1000);
	        				  Ext.defer(function() {
	        					  var grid = $this.getImportlistexaminationremark();
	        					  var form = $this.getUploadoptionradiogroup();
	        					  var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        					  $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_EXAM_REMARK');
	        				  }, 2000, this);
                                   this.resetPageSetting(grid.getStore(), grid);  // V2D-411240 
                                        grid.getStore().load();     
                                        grid.getStore().pageSize=100;
	        			  }  
	        		  },
	        		  'examinationremarkuploadform button[itemId=resetBtn]':{
	        			  click:function(obj){
	        				  var $this = this;
	        				  var form =obj.up('examinationremarkuploadform').getForm();
	        				  form.findField('file').reset();
	        				  var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
            				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            					   isUploadAll: false
            				   });
	        				  form.isValid();    //comment Line for V2D-411504
	        				  form.findField('file').clearInvalid();
	        			  },
	        			  render :function(obj){
	        				  var $this = this;
	        				  var form =obj.up('examinationremarkuploadform').getForm();
	        				  var combo = form.findField('importUtilityMasterId');
	        				  combo.getStore().load({
	        					  callback: function(records, operation, success) {
	        						  for(var i in records){
	        							  if(records[i].data.value=='Bulk Exam Remark'){
	        								  combo.setValue(records[i].data.id);
	        								  combo.setReadOnly(true);
	        							  }
	        						  }
	        					  }	   
	        				  });
	        			  }  
	        		  },
            		   'examinationremarkuploadform uploadoptionradiogroup[itemId=examinationremarkUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
             			   change: function( radioGroup, newValue, oldValue, eOpts){
             				   var grid =this.getImportlistexaminationremark();
             				   var form =this.getUploadoptionradiogroup();
             				   var isUploadAll = newValue.isUploadAll;
             				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_EXAM_REMARK');
             			   }   
             		   },
	        		  'importlistexaminationremark':{
	        			  render:function(obj){
	        				  var $this = this;
	        				  var grid = $this.getImportlistexaminationremark();
	        				  var form = $this.getUploadoptionradiogroup();
        					  var isUploadAll = form.items.items[0].getValue().isUploadAll;
        					  $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_EXAM_REMARK');
	        			  },
	        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        				  if (e.target.tagName == 'A') {
	        					  var fileType=null;
	        					  if(cellIndex==1){
	        						  fileType='successFile';
	        					  }else if(cellIndex==6){
	        						  fileType='errorFile';
	        					  }else if(cellIndex==7){
	        						  fileType='logFile';
	        					  }
	        					  var documentId = record.get("id");
	        					  if (!isNullOrEmpty(documentId)) {
	        						  this.getExaminationRemarkDownloadFile(documentId, fileType);
	        					  }
	        				  }
	        			  }
	        		  },
	        		  'importlistexaminationremark button[itemId=btnForce]':{
	        			  click: function(obj) {
	        				  var grid = this.getImportlistexaminationremark();
	        				  if (grid.getSelectionModel().getCount() > 0) {
	        					  if(grid.getSelectionModel().getCount() > 1){
	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	        					  }else{
	        						  var this$ = this;
	        						  var id = grid.getSelectionModel().selectionStart.data.id;
	        						  console.log(id);
	        						  var urlAppend="?jobName="+id;
	        						  var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	        						  Ext.Ajax.request({
	        							  url: submitURL,
	        							  method: 'GET',
	        							  success: function(response) {
	        								  if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	        									  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	        								  }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	        									  //console.log("Manual trigger hit");
	        									  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	        								  }else if(response.responseText==="SUCCESS"){
	        									  //console.log("Manual trigger hit");
	        									  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	        									  grid.getStore().reload();
	        								  }
	        							  }
	        						  });
	        					  }
	        				  } else {
	        					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        				  }  
	        			  }
	        		  },
	        	 });
	         },
	         getExaminationRemarkDownloadFile : function(documentId,fileType){
	        	 if(!isNullOrEmpty(documentId)){
	        		 var csvForm = Ext.create('Ext.form.Panel'); 
	        		 csvForm.getForm().submit({
	        			 target: '_blank',
	        			 method:'POST',
	        			 params :{
	        				 access_token : Ext.Ajax.defaultHeaders.access_token
	        			 },
	        			 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        			 url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	        			 standardSubmit :true
	        		 });
	        	 }
	         },
	         examinationRemarkDownloadUploadFormChange : function(cb, nv, ov) {
	        	 var $this = this;
	        	 var structure = cb.up('examinationremarkuploaddownloadstructure');
	        	 var downloadTemplateForm = structure.down('examinationremarkdownloadform');
	        	 var uploadTemplateForm = structure.down('examinationremarkuploadform');
	        	 var grid = $this.getImportlistexaminationremark();
	        	 if(nv.downloadUploadTemplate == 'forDownloadTemplate') {
	        		 uploadTemplateForm.hide();
	        		 downloadTemplateForm.show();
	        		 grid.setVisible(false);
	        	 } else {
	        		 $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
	        		 var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
	        		 uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        			 isUploadAll: false
	        		 });
	        		 downloadTemplateForm.hide();
	        		 uploadTemplateForm.show();
	        		 grid.setVisible(true);
	        		 uploadTemplateForm.down("#uploadFileField").reset();
					 this.onChangeUploadOptionRadioGroup(false,grid,'IMPORT_BULK_EXAM_REMARK');  
					 this.resetPageSetting(grid.getStore(),grid); 
	        	 }
	         },
	         deleteRemark: function() {
	        	 var $this = this;
	        	 var grid = $this.getExaminationremarkgrid();
					if (grid.getSelectionModel().getCount() > 0) {
						showConfirmMessage(getCommonTranslation("WARNING"), getCommonTranslation("DELETE_CONFIRM_MESSAGE"),
						function(btn, text) {
							if (btn == 'yes') {
								var records = grid.getSelectionModel().getSelection()[0];
								var id = records.data.id;
								Ext.Ajax.request({
									method : "DELETE",
									type : 'rest',
									url : SERVERURL.DELETE_REAMRK_EVALUATION_PLAN_URl+ '?id='+ id,
									headers : {
										'Content-Type' : 'application/json'
									},
									params : {
										id : id
									},
									success : function(form,action) {
										showSuccessMessage(getCommonTranslation("STANDARD_MASTER_MSG_BOX_TITLE"),getCommonTranslation("SUCCESS"));
										grid.getStore().reload();
									}
								});
						  }
					   });
					}  else {
						 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
					}
	         },
	         
	         deleteRemarkMapping:function(selectedGrid){
	        	 if(selectedGrid.getSelectionModel().getCount()>0) {
	        		 	var this$ = this;
						var remarkGrid = this$.getExaminationremarkgrid(); 
						var courseGrid = this$.getExaminationremarkcoursegrid();
						var planGrid = this$.getExaminationremarkplangrid();
						var programGrid = this$.getExaminationremarkprogramgrid();
						var formData = new Object();
						if(remarkGrid.getSelectionModel().getCount()>0) {
							if(selectedGrid.title == getExaminationTranslation('MAPPED_COURSE_LIST')) {
								formData.evaluationPlan=null;
								formData.program=null;
								formData.course={
										"id" : courseGrid.getSelectionModel().getSelection()[0].data.id 
								};
								formData.evaluationPlan=null
								formData.examinationRemark={
										"id" : remarkGrid.getSelectionModel().getSelection()[0].data.id 
								};
							} else if(selectedGrid.title == getExaminationTranslation('MAPPED_PROGRAM_LIST')) {
								formData.evaluationPlan=null;
								formData.program=null;
								formData.program={
										"id" : programGrid.getSelectionModel().getSelection()[0].data.id 
								};
								formData.evaluationPlan=null
								formData.examinationRemark={
										"id" : remarkGrid.getSelectionModel().getSelection()[0].data.id 
								};
							} else {
								formData.evaluationPlan=null;
								formData.evaluationPlan={
										"id" : planGrid.getSelectionModel().getSelection()[0].data.id 
								};
								formData.course=null
								formData.examinationRemark={
										"id" : remarkGrid.getSelectionModel().getSelection()[0].data.id 
								};
							}
							showConfirmMessage(getCommonTranslation("WARNING"), getCommonTranslation("DELETE_CONFIRM_MESSAGE"),
									function(btn, text){
								if (btn == 'yes') {
									Ext.Ajax.request({
										method : "POST",
										type : 'rest',
										url : SERVERURL.EXAMINATION_REMARK_DELETE_MAPPING,
										jsonData : formData,
					        			 headers: {
					        				 'Content-Type': 'application/json'
					        			 },
										success : function(form,action) {
											showSuccessMessage(getCommonTranslation("STANDARD_MASTER_MSG_BOX_TITLE"),getCommonTranslation("SUCCESS"));
											selectedGrid.getStore().reload();
										}
									});
								}
							});
							
		        	 }
		        	 else{
		        		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_REMARK_RECORD"));
		        	 }
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	          },
	         
	         saveRemarkAddedRemark: function() {
	        	 var formWindow = this.getAddremarkwin();
	        	 var $this = this;
	        	 var grid = $this.getExaminationremarkgrid();
	        	 Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
	        	 var formData;
	        	 formWindow.down('#submitButtonId').setDisabled(true);
	        	 if(formWindow.title=="Remark" || formWindow.title=="Comment" || formWindow.title==getExaminationTranslation('REMARK')) {
	        		 if (formWindow.getIsEdit()==false) {
	        			 submitUrl = SERVERURL.SAVE_REAMRK_EVALUATION_PLAN_URl;
	        			 formData= {
	        					 "value":formWindow.down("#remarkItemId").getValue()
	        			 };
	        			 successMessge =  getCommonTranslation("RECORD_ADD_SUCCESS");
	        		 } else {
	        			 var record = grid.getSelectionModel().getSelection()[0];
	        			 submitUrl = SERVERURL.UPDATE_REAMRK_EVALUATION_PLAN_URl;
	        			 successMessge = getCommonTranslation("RECORD_UPDATE_SUCCESS");
	        			 formData= {
	        					 "id":record.data.id,
	        					 "value":formWindow.down("#remarkItemId").getValue()
	        			 };
	        		 }
	        		 Ext.Ajax.request({
	        			 type: 'rest',
	        			 method: 'POST',
	        			 url: submitUrl,
	        			 jsonData : formData,
	        			 headers: {
	        				 'Content-Type': 'application/json'
	        			 },
	        			 success: function(form, action) {
	        				 Ext.getBody().unmask();
	        				 showSuccessMessage(getCommonTranslation("STANDARD_MASTER_MSG_BOX_TITLE"), successMessge);
	        				 grid.getStore().reload();
	        				 formWindow.close();
	        			 }
	        		 });
	        		 grid.getSelectionModel().deselectAll();
	        	 }
	        	 if(formWindow.title==getExaminationTranslation("COURSE") || formWindow.title==getExaminationTranslation("EVALUATION_PLAN") || formWindow.title==getExaminationTranslation("PROGRAM")) {
	        		 var formData = new Object();
	        		 var record = grid.getSelectionModel().getSelection()[0];
	        		 if(formWindow.title==getExaminationTranslation("COURSE")) {
	        			 formData.evaluationPlan=null;
	        			 formData.program=null;
	        			 formData.course={
	        					 "id" : formWindow.down('#course_Id').getValue()	 
	        			 };
	        		 }
	        		 if(formWindow.title==getExaminationTranslation("EVALUATION_PLAN") ) {
	        			 formData.course=null;
	        			 formData.program=null;
	        			 formData.evaluationPlan={
	        					 "id" : formWindow.down('#evalautionPlanNoItemId').getValue()	 
	        			 };
	        		 }
	        		 if(formWindow.title==getExaminationTranslation("PROGRAM")) {
	        			 formData.course=null;
	        			 formData.evaluationPlan=null;
	        			 formData.program=null;
	        			 formData.program={
	        					 "id" : formWindow.down('#program_Id').getValue()	 
	        			 };
	        		 }
	        		 formData.examinationRemark={
        					 "id" : record.data.id 
        			 };
	        		 Ext.Ajax.request({
	        			 type: 'rest',
	        			 method: 'POST',
	        			 url: SERVERURL.SAVE_COURSE_OR_PLAN_MAPPING,
	        			 jsonData : formData,
	        			 headers: {
	        				 'Content-Type': 'application/json'
	        			 },
	        			 success: function(form, action) {
	        				 Ext.getBody().unmask();
	        				 if(form.responseText==0)
	        					 {
	        				showWarningMessage(getCommonTranslation("ALERT"),"Selected record already mapped.");
	        					 }
	        				 else
	        					 {
	        				 
	        				 showSuccessMessage(getCommonTranslation("STANDARD_MASTER_MSG_BOX_TITLE"), getCommonTranslation("RECORD_ADD_SUCCESS"));
	        				 if(formWindow.title==getExaminationTranslation("COURSE") ) {
	        					 $this.getExaminationremarkcoursegrid().getStore().reload();
	        				 }
	        				 if(formWindow.title==getExaminationTranslation("EVALUATION_PLAN")) {
	        					 $this.getExaminationremarkplangrid().getStore().reload();
	        				 }
	        				 if(formWindow.title==getExaminationTranslation("PROGRAM")) {
	        					 $this.getExaminationremarkprogramgrid().getStore().reload();
	        				 }
	        					 }
	        				 formWindow.close();
	        			 }
	        		 });
	        	 }
	         },
	         
	         OpenAddRemarkWindow: function(editable, grid) {
	        	 var $this = this;
	        	 var formWindow = this.getAddremarkwin();
	        	 if (!formWindow) {
	        		 Ext.widget('addremarkwin');
	        		 formWindow = this.getAddremarkwin();
	        	 }
	        	 Ext.apply(formWindow,{
	        		 isEdit:null,
	        		 setIsEdit : function(isEdit){
	        			 formWindow.isEdit = isEdit;
	        		 },
	        		 getIsEdit:function(){
	        			 return formWindow.isEdit;
	        		 }
	        	 });
	        	 formWindow.setIsEdit(editable);
	        	 var remark = formWindow.down('#remarkItemId');
	        	 var course = formWindow.down('#course_Id');
	        	 var plan = formWindow.down('#evalautionPlanNoItemId');
	        	 var program = formWindow.down('#program_Id');
	        	 remark.setVisible(false);
	        	 course.setVisible(false);
	        	 plan.setVisible(false);
	        	 program.setVisible(false);
	        	 plan.allowBlank=true;
	        	 remark.allowBlank=true;
	        	 course.allowBlank=true;
	        	 program.allowBlank=true;
	        	 var remarkGrid = $this.getExaminationremarkgrid();
	        	 
	        	 var locations = [];
	             var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	             for(var i=0; i<academyLocationList.length; i++){
	            	 locations.push(academyLocationList[i].id);
	             }
	        	 
	        	 if(grid.title == getExaminationTranslation('EXAM_REMARK_GRID')) {
	        		 formWindow.setTitle(getExaminationTranslation('REMARK'));
	        		 remark.setVisible(true);
		        	 remark.allowBlank=false;
		        	 if(editable) {
		        		 var record = grid.getSelectionModel().getSelection()[0];
			        	 remark.setValue(record.data.remark); 
		        	 }
		        	 formWindow.show();
			        	
	        	 }
	        	 if(grid.title ==  getExaminationTranslation('MAPPED_PROGRAM_LIST') || grid.title == "Mapped Program List") {
	        		 if(remarkGrid.getSelectionModel().getCount()>0){
		        		 formWindow.setTitle(getExaminationTranslation('PROGRAM'));
		        		 var record= grid.getSelectionModel().getSelection()[0];
		        		 program.setVisible(true);
		        		 program.allowBlank=false;
		        		 var location=[];
		        		 location.push($this.getCurrentAcademyLocation());
		        		 program.getStore().getProxy().extraParams= {
		        			 academyLocationIds:location.join()
		        		 };
		        		 program.getStore().load();
		        		 formWindow.show();
		 	        	
	        		 } else {
	        			 //formWindow.close();
	        			 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        		 }
	        	 }
	        	 if(grid.title == getExaminationTranslation('MAPPED_COURSE_LIST') ||  grid.title == 'Mapped Course List') {
	        		 if(remarkGrid.getSelectionModel().getCount()>0){
	        			 try{
		        			 formWindow.tools.close.setDisabled(true);
		        			 formWindow.down('#cancelButtonId').setDisabled(true);
	        			 }
	        			 catch(e){
	        				 
	        			 }
		        		 formWindow.setTitle(getExaminationTranslation('COURSE'));
		        		 var record= grid.getSelectionModel().getSelection()[0];
		        		 course.setVisible(true);
		        		 course.allowBlank=false;
		        		//V2D-35747
		        		// Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		        		// formWindow.down('#course_Id').setDisabled(true);
		        		 course.getStore().getProxy().extraParams= {
		        			 academyLocationIds:locations.join()
		        		 };
		        		 course.getStore().load({
		        			 callback:function(){
		        				 try{
				        			 formWindow.tools.close.setDisabled(false);
				        			 formWindow.down('#cancelButtonId').setDisabled(false);
			        			 }
			        			 catch(e){
			        				 
			        			 }
		        				// formWindow.down('#course_Id').enable();
		        				// Ext.getBody().unmask();
  						   }
		        		 });
		        		 formWindow.show();
		 	        	
	        		 } else {
	        			// formWindow.close();
	        			 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        		 }
	        	 }
	        	 if(grid.title ==  getExaminationTranslation('MAPPED_PLAN_LIST')) {
	        		 if(remarkGrid.getSelectionModel().getCount()>0){
		        		 formWindow.setTitle(getExaminationTranslation('EVALUATION_PLAN'));
		        		 var record= grid.getSelectionModel().getSelection()[0];
		        		 plan.setVisible(true);
		        		 plan.allowBlank=false;
		        		 plan.getStore().getProxy().extraParams= {
		        			 evaluationPlanType:'OTHER',
		        			 academyLocationIds:locations.join()
		        		 };
		        		 plan.getStore().load();
		        		 formWindow.show();
		 	        	
	        		 } else {
	        			// formWindow.close();
	        			 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        		 }
	        	 }
	         },
	         
	         updateChildRemarkGrid: function(childGrid1, childGrid2, childGrid3, parentRecordId) {
	             var store = childGrid1.getStore();
	             var locations = [];
	             var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	             for(var i=0; i<academyLocationList.length; i++){
	            	 locations.push(academyLocationList[i].id);
	             }
	             this.resetPageSetting(childGrid1.getStore(), childGrid1);
	             //childGrid1.getStore().load();     
	             //childGrid1.getStore().pageSize=100;
	             store.getProxy().extraParams = {
	            	 academyLocationIds: locations.join(),
	            	 remarkId: parentRecordId
	             };
	             store.reload();
	             var store = childGrid2.getStore();
	             this.resetPageSetting(childGrid2.getStore(), childGrid2);
	            // childGrid2.getStore().load();     
	             //childGrid2.getStore().pageSize=100;
	             store.getProxy().extraParams = {
	            	  academyLocationIds: locations.join(),
	            	  remarkId:parentRecordId
	             };
	             store.reload();
	             var store = childGrid3.getStore();
	             this.resetPageSetting(childGrid3.getStore(), childGrid3);
	             //childGrid3.getStore().load();     
	            // childGrid3.getStore().pageSize=100;
	             store.getProxy().extraParams = {
	            	  academyLocationIds: locations.join(),
	            	  remarkId:parentRecordId
	             };
	             store.reload();
	             Ext.defer(function() {
	            	 childGrid2.focus();
     	         }, 100, this);
	         },

	         /**
	          * Open Invigilator Details Window
	          * **/
	         openInvgDetailsWindow:function(record){
	        	 var $this = this;
	        	 var formWindow = $this.getRoomallocationinvgwindow();
	        	 if (!formWindow) {
	        		 Ext.widget('roomallocationinvgwindow');
	        		 formWindow = $this.getRoomallocationinvgwindow();
	        	 }
	        	 formWindow.show();
	        	 var grid = $this.getRoomallocationinvggrid();
	        	 var gridStore =  grid.getStore();
	        	 gridStore.removeAll();
	        	 var models = grid.getStore().getRange();
	        	 var details;
	        	 if(record.data.invigilators.length > 0){
	        		 for(var i in record.data.invigilators){
	        			 details={
	        					 'id':record.data.invigilators[i].id,
	        					 'value':record.data.invigilators[i].value,
	        			 };
	        			 gridStore.loadRawData(details, true);
	        		 }
	        	 }
	        	 console.log(grid);
	         },
	         /**
	          * Save Student Mapping
	          * **/
	         saveStudentMapping:function(){
	        	 var $this = this;
	        	 var form = $this.getAddroomstudentview().getForm();
	        	 var grid = $this.getRoomallocationgrid();
	        	 var studentListGrid = $this.getMappedstudentallocationgrid();
	        	 var availablestudentgrid = $this.getAvailablestudentallocationgrid();
	        	 var records = grid.getSelectionModel().getSelection()[0];
	        	 if (availablestudentgrid.getSelectionModel().getCount() > 0) {
	        		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        		 /***create Json for saving****/
	        		 var record = availablestudentgrid.getSelectionModel().getSelection();
	        		 var jsonToSave=[], json;
	        		 for(var i in record){
	        			 json ={
	        					 "examTimeSlotId":record[i].data.examTimeSlotId,
	        					 "examRoomAllocationId":records.data.id,
	        			 };
	        			 jsonToSave.push(json);
	        		 }
	        		 //PATH_ROOM_ALLOCATION_STUDENT_MAP_SAVING

	        		 var	submitUrl=SERVERURL.PATH_ROOM_ALLOCATION_STUDENT_MAP_SAVING;
	        		 Ext.Ajax.request({
	        			 type : 'rest',
	        			 url : submitUrl,
	        			 jsonData : jsonToSave,
	        			 method : 'POST',
	        			 success : function(form, action) {
	        				 Ext.getBody().unmask();
	        				 showSuccessMessage(getExaminationTranslation('ROOM_ALLOCATION'),getCommonTranslation("SUCCESS"));
	        				 availablestudentgrid.getStore().getProxy().extraParams={
	        					 groupDateBatchCenterId:records.data.groupDateBatchCenterId
	        				 };
	        				 availablestudentgrid.getStore().load();
	        				 studentListGrid.getStore().getProxy().extraParams={
	        					 groupDateBatchCenterId:records.data.groupDateBatchCenterId,
	        					 examRoomAllocationId:records.data.id,
	        					 evaluationGroupForPrint:records.data.evaluationGroupCode,
	        					 courseForPrint:records.data.courseName,
	        					 courseVariantForPrint:records.data.courseVariantName,
	        					 periodForPrint:records.data.periodName,
	        					 SectionForPrint:records.data.sectionName,
	        					 centerForPrint:records.data.centerName,
	        					 dateForPrint:records.data.scheduleDate,
	        					 timeSlotForPrint:records.data.batchName,
	        					 roomNoForPrint:records.data.roomNo
	        				 };
	        				 studentListGrid.getSelectionModel().deselectAll();
	        				 studentListGrid.getStore().load();
	        			 }
	        		 });
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },

	         /**
	          * Add Map Student tab open
	          * **/
	         openAddStudentTab:function(){
	        	 var me = this;
	        	 var grid = me.getRoomallocationgrid();
	        	 if (grid.getSelectionModel().getCount() > 0) {
	        		 var contentpanel = me.getContentPanel();
	        		 var studentRoomStructure = Ext.widget('studentaddmappingstructure');
	        		 var tabName = getExaminationTranslation('ADD_STUDENT_TO_ROOM');
	        		 /**
	        		  * This is to remove tab from content panel and open same tab again 
	        		  */
	        		 var getcontroller=this.getController('menu.CoreERPNavigationController');
	        		 var getTab=getcontroller.getTab(tabName);
	        		 if(getTab!=null){
	        			 contentpanel.remove(getTab, true);
	        		 }
	        		 openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_FOUR);
	        		 var availablestudentgrid = me.getAvailablestudentallocationgrid();
	        		 var records = grid.getSelectionModel().getSelection()[0];
	        		 availablestudentgrid.getStore().getProxy().extraParams={
	        			 groupDateBatchCenterId:records.data.groupDateBatchCenterId
	        		 };
	        		 availablestudentgrid.getStore().load();
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },

	         /**
	          * Save invigilator mapping
	          * **/
	         saveInvigilatorMapping:function(){
	        	 var $this = this;
	        	 var jsonToSave =[], submitData;
	        	 var grid = $this.getInvigilatorallocationgrid();
	        	 var roomAllocationGrid = $this.getRoomallocationgrid();
	        	 if (grid.getSelectionModel().getCount() > 0) {
	        		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        		 var records = grid.getSelectionModel().getSelection();
	        		 var roomAllocationGridValue = roomAllocationGrid.getSelectionModel().getSelection()[0];
	        		 var oldMapping = grid.getCode();
	        		 for(var i in records){
	        			 var flag = true;
	        			 if(oldMapping.length != 0){
	        				 for (var j in oldMapping){
	        					 if(oldMapping[j].data.id==records[i].data.id){
	        						 flag = false;
	        						 break;
	        					 }
	        				 }
	        			 }
	        			 if(flag){
	        				 submitData={"invigilatorId":records[i].data.id,
	        						 "examRoomAllocationId" :roomAllocationGridValue.data.id,
	        						 "invigilatorName" :records[i].data.value,
	        						 "isMapped":true};
	        				 jsonToSave.push(submitData);
	        			 }
	        		 }

	        		 if(oldMapping.length != 0){
	        			 for (var j in oldMapping){
	        				 var flag = false;
	        				 for(var i in records){
	        					 if(oldMapping[j].data.id==records[i].data.id){
	        						 flag = true;
	        					 } 
	        				 }
	        				 if(!flag){
	        					 submitData={"invigilatorId":oldMapping[j].data.id,
	        							 "examRoomAllocationId" :roomAllocationGridValue.data.id,
	        							 "invigilatorName" :oldMapping[j].data.value,
	        							 "isMapped":false};
	        					 jsonToSave.push(submitData);
	        				 }
	        			 }
	        		 }

	        		 if(jsonToSave.length!=0){
	        			 var	submitUrl=SERVERURL.PATH_ROOM_INVIGILATOR_ALLOCATION_SAVING;
	        			 Ext.Ajax.request({
	        				 type : 'rest',
	        				 url : submitUrl,
	        				 jsonData : jsonToSave,
	        				 method : 'POST',
	        				 success : function(form, action) {
	        					 Ext.getBody().unmask();
	        					 showSuccessMessage(getExaminationTranslation("LINK_ALS"), getCommonTranslation("SUCCESS"));
	        					 roomAllocationGrid.getStore().reload();
	        					 grid.getStore().getProxy().extraParams ={
	        						 examRoomAllocationId:roomAllocationGridValue.data.id,
	        						 groupDateBatchCenterId:roomAllocationGridValue.data.groupDateBatchCenterId,
	        						 academyLocationId:$this.getCurrentAcademyLocation(),
	        						 limit:-1
	        					 };
	        					 var arr = [];
	        					 grid.getStore().load({
	        						 callback: function(record, operation, success) {
	        							 if (success) {
	        								 if(record.length > 0){
	        									 grid.getSelectionModel().deselectAll();
	        									 for(i in record)
	        										 if(record[i].data.code=="MAPPED"){
	        											 arr.push(record[i]);
	        											 grid.getSelectionModel().select(record[i],true);
	        										 }
	        								 }
	        								 grid.setCode(arr);
	        							 }
	        						 }	   
	        					 });
	        				 }
	        			 });
	        		 }else{
	        			 Ext.getBody().unmask();
	        			 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        		 }
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },


	         /**
	          * Assign invigilator tab open
	          * **/
	         mapInvigilator:function(){
	        	 var me = this;
	        	 var grid = me.getRoomallocationgrid();
	        	 if (grid.getSelectionModel().getCount() > 0) {
	        		 var contentpanel = me.getContentPanel();
	        		 var studentRoomStructure = Ext.widget('assigninvigilatorstructure');
	        		 var tabName = getExaminationTranslation('ASSIGN_INVIGILATOR');
	        		 /**
	        		  * This is to remove tab from content panel and open same tab again 
	        		  */
	        		 var getcontroller=this.getController('menu.CoreERPNavigationController');
	        		 var getTab=getcontroller.getTab(tabName);
	        		 if(getTab!=null){
	        			 contentpanel.remove(getTab, true);
	        		 }
	        		 openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_FOUR);
	        		 var invigilatorGrid = me.getInvigilatorallocationgrid();
	        		 var records = grid.getSelectionModel().getSelection()[0];

	        		 var parts = records.data.scheduleDate.split("-");
	        		 var scheduleDate = new Date(parts[2], parts[1] - 1, parts[0]);


	        		 invigilatorGrid.getStore().getProxy().extraParams={
	        			 examRoomAllocationId:records.data.id,
	        			 groupDateBatchCenterId:records.data.groupDateBatchCenterId,
	        			 examDate:scheduleDate,
	        			 examBatch:records.data.batchName,
	        			 academyLocationId:me.getCurrentAcademyLocation(),
	        			 limit:-1
	        		 };
	        		 var oldMappingArr=[];
	        		 Ext.apply(invigilatorGrid,{
	        			 code:null,
	        			 setCode : function(code){
	        				 invigilatorGrid.code = code;
	        			 },
	        			 getCode:function(){
	        				 return invigilatorGrid.code;
	        			 }
	        		 });
	        		 invigilatorGrid.getStore().load({
	        			 callback: function(record, operation, success) {
	        				 if (success) {
	        					 if(record.length > 0){
	        						 invigilatorGrid.getSelectionModel().deselectAll();
	        						 for(i in record)
	        							 if(record[i].data.code=="MAPPED"){
	        								 invigilatorGrid.getSelectionModel().select(record[i],true);
	        								 oldMappingArr.push(record[i]);
	        							 }
	        						 invigilatorGrid.setCode(oldMappingArr);
	        					 }		 
	        				 }
	        			 }	   
	        		 });
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },

	         printButtonOpenWin:function(){
	        	 var $this = this;
	        	 var formWindow = this.getPrinttimetablefilterwin();
	        	 if (!formWindow) {
	        		 Ext.widget('printtimetablefilterwin');
	        		 formWindow = this.getPrinttimetablefilterwin();
	        	 }
	        	 formWindow.show();
	         },

	         printButtonFunctionality:function(){
	        	 var $this = this;
	        	 var formWindow = this.getPrinttimetablefilterwin();
	        	 var user=$this.getCurrentlyLoggedInUser();
	        	 var code ="EXAM_TIME_TABLE_COMMON"; 
	        	 var batch = formWindow.down('#batchIdQuickFiltr');
	        	 var period = formWindow.down('#periodItemId');
	        	 var evalGroupId = formWindow.down('#evalGroupId');
	        	 var program = formWindow.down('#programIdQuickFiltr');
	        	 var reportParams =new Object();
	        	 reportParams.userId=user.code;
	        	 reportParams.EVALUATION_GROUP_NAME = evalGroupId.getRawValue();
	        	 reportParams.ACADEMY_LOCATION_NAME = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].valueModels[0].data.academyLocationName;
	        	 reportParams.PROGRAM_NAME = program.getRawValue();
	        	 reportParams.PROGRAM_BATCH_NAME = batch.getRawValue();
	        	 reportParams.PERIOD_NAME = period.getRawValue();
	        	 reportParams.programId = program.getValue();
	        	 reportParams.batchId = batch.getValue();
	        	 reportParams.periodId = period.getValue();

	        	 reportParams.code = code;
	        	 //var reportTitle="";
	        	 var exportUrl = SERVERURL.PATH_TIME_TABLE_JASPER_URL;
	        	 var title = evalGroupId.getRawValue()+"_"+program.getRawValue()+"_"+batch.getRawValue()+"_"+period.getRawValue()+"_"+new Date().getTime();
	        	 $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);
	        	 formWindow.close();
	         },
	         /**
	          * Map student list tab open
	          * **/
	         mapStudent:function(){
	        	 var me = this;
	        	 var grid = me.getRoomallocationgrid();
	        	 if (grid.getSelectionModel().getCount() > 0) {
	        		 var contentpanel = me.getContentPanel();
	        		 var studentRoomStructure = Ext.widget('studentroommappingstructure');
	        		 var tabName = getExaminationTranslation('MAP_STUDENT_TO_ROOM');
	        		 /**
	        		  * This is to remove tab from content panel and open same tab again 
	        		  */
	        		 var getcontroller=this.getController('menu.CoreERPNavigationController');
	        		 var getTab=getcontroller.getTab(tabName);
	        		 if(getTab!=null){
	        			 contentpanel.remove(getTab, true);
	        		 }
	        		 openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_FOUR);
	        	 } else {
	        		 showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },

	         /**
	          * Load Date By evaluation group,course Id and center Id.
	          */
	         loadDateByEvalGroupCourseCenterId:function(){
	        	 var form=this.getAllocateroomsWin().getForm();
	        	 var evalGroupSchDateIdField=form.findField('evalGroupSchDateId');
	        	 var centerNameField=form.findField('evalGroupCenterId');
	        	 var evalGroupField=form.findField('evalGroup');
	        	 var courseField=form.findField('course');

	        	 var evalGroupIdsArray=[];
	        	 var evalGroupValue=evalGroupField.getValue();
	        	 if(evalGroupValue.length>0){
	        		 for(var i in evalGroupValue){
	        			 if(Ext.isObject(evalGroupValue[i])){
	        				 evalGroupIdsArray.push(evalGroupValue[i].get('id'));
	        			 }else{
	        				 evalGroupIdsArray.push(evalGroupValue[i]);
	        			 }
	        		 }
	        	 } 

	        	 var courseIdsArray=[];
	        	 var courseValue=courseField.getValue();
	        	 if(courseValue.length>0){
	        		 for(var i in courseValue){
	        			 if(Ext.isObject(courseValue[i])){
	        				 courseIdsArray.push(courseValue[i].get('id'));
	        			 }else{
	        				 courseIdsArray.push(courseValue[i]);
	        			 }
	        		 }
	        	 } 

	        	 if(evalGroupIdsArray.length>0&&courseIdsArray.length>0&&centerNameField.getValue()!=null){

	        		 evalGroupSchDateIdField.enable();
	        		 evalGroupSchDateIdField.reset();
	        		 evalGroupSchDateIdField.getStore().getProxy().extraParams={
	        			 evaluationGroupIds:evalGroupIdsArray.join(),
	        			 courseIds:courseIdsArray.join(),        		
	        			 examCenterIds:centerNameField.getValue()
	        		 };
	        		 evalGroupSchDateIdField.getStore().load();
	        	 }
	         },
	         /**
	          * Load time slot by eval group ,course  And Cente Id And date in allocate room window.
	          */
	         loadBatchByEvalgroupCourseAndCenterIdAndDate:function(){
	        	 var $this=this;
	        	 var form=$this.getAllocateroomsWin().getForm();
	        	 var evalGroupField=form.findField('evalGroup');
	        	 var courseField=form.findField('course');
	        	 var centerNameField=form.findField('evalGroupCenterId');
	        	 var dateField=form.findField('evalGroupSchDateId');
	        	 var timeSlotField=form.findField('groupScheduleBatchId');

	        	 var evalGroupIdsArray=[];
	        	 var evalGroupValue=evalGroupField.getValue();
	        	 if(evalGroupValue.length>0){
	        		 for(var i in evalGroupValue){
	        			 if(Ext.isObject(evalGroupValue[i])){
	        				 evalGroupIdsArray.push(evalGroupValue[i].get('id'));
	        			 }else{
	        				 evalGroupIdsArray.push(evalGroupValue[i]);
	        			 }
	        		 }
	        	 } 

	        	 var courseIdsArray=[];
	        	 var courseValue=courseField.getValue();
	        	 if(courseValue.length>0){
	        		 for(var i in courseValue){
	        			 if(Ext.isObject(courseValue[i])){
	        				 courseIdsArray.push(courseValue[i].get('id'));
	        			 }else{
	        				 courseIdsArray.push(courseValue[i]);
	        			 }
	        		 }
	        	 } 

	        	 if(evalGroupIdsArray.length>0&&courseIdsArray.length>0&&centerNameField.getValue()!=null&&dateField.getValue()!=null){

	        		 timeSlotField.enable();
	        		 timeSlotField.reset();
	        		 var timeSlotStore= timeSlotField.getStore();
	        		 timeSlotStore.getProxy().extraParams = {
	        			 evaluationGroupIds:evalGroupIdsArray.join(),
	        			 courseIds:courseIdsArray.join(),
	        			 examCenterIds:centerNameField.getValue(),
	        			 scheduleDate:dateField.getRawValue()
	        		 };
	        		 timeSlotStore.load();
	        	 }
	         },
	         /**
	          * Load batch by centerType And Cente Id And date in room allocation master filter
	          */
	         loadBatchByCenterTypeAndCenterIdAndDate:function(){
	        	 var $this=this;
	        	 var form=$this.getRoomallocationquickfilter().getForm();
	        	 var centerTypeField=form.findField('centerType');
	        	 var centerNameField=form.findField('centerName');
	        	 var dateField=form.findField('date');
	        	 var timeSlotField=form.findField('timeSlot');
	        	 if(centerNameField.getValue()!=null||dateField.getRawValue()!=null||centerTypeField.getValue()!=null){
	        		 timeSlotField.enable();
	        		 var timeSlotStore= timeSlotField.getStore();
	        		 timeSlotStore.getProxy().extraParams = {
	        			 centerType:centerTypeField.getValue(),
	        			 examCenterIds:centerNameField.getValue(),
	        			 scheduleDate:dateField.getRawValue()
	        		 };
	        		 timeSlotStore.load();
	        	 }
	         },
	         /**
	          * Load batch by center and date
	          */
	         loadRoomNoByCenterTypeAndCenterId:function(){
	        	 /* var $this=this;
	                	   var form=$this.getRoomallocationquickfilter().getForm();
	                	   var roomNoField=form.findField('roomNo');
	                	   var centerTypeField=form.findField('centerType');
	                	   var centerNameField=form.findField('centerName');

	                	   if(centerTypeField.getValue()!=null&&centerNameField.getValue()!=null){
	                		   roomNoField.enable();
	                		  var roomNoStore= roomNoField.getStore();
	                		  roomNoStore.getProxy().extraParams = {
	                			  centerType:centerTypeField.getValue(),
	                			  evaluationGroupCenterId:centerNameField.getValue()
    						   };
	                		  roomNoStore.load();
	                	   }*/
	         },
	         //************ Search Screen and grid According to Student and capacity *********
	         enableFiltersAndGrid : function(value,newValue){
	        	 var $this=this;
	        	 var filterForm = $this.getRoomallocationquickfilter();
	        	 filterForm.getForm().reset();
	        	 var getFilterForm = filterForm.getForm();
	        	 var evalCoursePanel = filterForm.down("#evalCoursePanelId");
	        	 var statusPanel = filterForm.down("#statusPanelId");
	        	 var centerNameField = getFilterForm.findField('centerName');
	        	 var dateField = getFilterForm.findField('date');
	        	 var timeSlotField = getFilterForm.findField('timeSlot');
	        	 centerNameField.setDisabled(true);
	        	 dateField.getStore().getProxy().extraParams={
	        		 examCenterIds:""
	        	 };
	        	 dateField.getStore().load();
	        	 timeSlotField.getStore().getProxy().extraParams={
	        		 centerType:"",
	        		 examCenterIds:"",
	        		 scheduleDate:""
	        	 };
	        	 timeSlotField.getStore().load();
	        	 if(newValue.roomallocation==1){
	        		 evalCoursePanel.setVisible(false);	
	        		 statusPanel.setVisible(false);	
	        	 }else{
	        		 evalCoursePanel.setVisible(true);	
	        		 statusPanel.setVisible(true);
	        	 }
	         },
	         //*********** Add Student Allocation Center Room Allocation Grid Open ************
	         getOpenCenterRoomAllocation : function(){
	        	 var contentpanel = this.getContentPanel();
	        	 var structure = Ext.widget('centerroomallocationstructure');
	        	 var tabName = getExaminationTranslation('CENTER_ROOM_ALLOCATION');
	        	 openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FOUR);
	         },
	         //************* Get open Allocate room Window from room Capacity *********** 
	         getOpenCenterRoomAllocatesWin : function(){	
	        	 var formWindow = this.getAllocateroomswin();
	        	 if (!formWindow) {
	        		 Ext.widget('allocateroomswin');
	        		 formWindow = this.getAllocateroomswin();
	        	 }
	        	 formWindow.show();
	         },
	         //***** Get Open Student Room Allocation Grid from Center Room Allocation**************
	         getOpenStudentRoomAllocation : function(){
	        	 var contentpanel = this.getContentPanel();
	        	 var structure = Ext.widget('studentroomallocationstructure');
	        	 var tabName = getExaminationTranslation('STUDENT_ROOM_ALLOCATION');

	        	 /**
	        	  * This is to remove tab from content panel and open same tab again 
	        	  */
	        	 var getcontroller=this.getController('menu.CoreERPNavigationController');
	        	 var getTab=getcontroller.getTab(tabName);
	        	 if(getTab!=null){
	        		 contentpanel.remove(getTab, true);
	        	 }
	        	 openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FOUR);



	         },
	         //***** Get Open Assign Invigilator win from Center Room Allocation**************
	         getOpenAssignInvigilatorWin : function(){
	        	 var formWindow = this.getAssigninvigilatorwin();
	        	 if (!formWindow) {
	        		 Ext.widget('assigninvigilatorwin');
	        		 formWindow = this.getAssigninvigilatorwin();
	        	 }
	        	 formWindow.show();
	         },
	         // ************* Save Allocate Rooms ******************\
	         getSaveAllocateRooms : function(){
	        	 var $this = this;
	        	 var grid =$this.getCenterRoomAllocationGrid();
	        	 var frm = $this.getAllocateroomsWin();
	        	 var form = frm.getForm();
	        	 var value = form.getValues();
	        	 var evalGroupSchDate=form.findField('evalGroupSchDateId').getRawValue();
	        	 var groupScheduleBatch=form.findField('groupScheduleBatchId').getRawValue();
	        	 var grid = $this.getCenterRoomAllocationGrid();
	        	 var StudentAllocateRoomModel = new Academia.model.examinationcenters.roomallocation.StudentRoomAllocation();
	        	 StudentAllocateRoomModel.set("examCenterId",value.evalGroupCenterId);
	        	 StudentAllocateRoomModel.set("groupScheduleBatch",groupScheduleBatch);
	        	 StudentAllocateRoomModel.set("scheduleDate",evalGroupSchDate);
	        	 var roomRecord = value.rooms;
	        	 var roomArray=[];
	        	 if(roomRecord.length>0){
	        		 for(var i in roomRecord){
	        			 if(Ext.isObject(roomRecord[i])){
	        				 roomArray.push({
	        					 "id":roomRecord[i].get('id')
	        				 });
	        			 }else{
	        				 roomArray.push({
	        					 "id":roomRecord[i]
	        				 });
	        			 }
	        		 }
	        	 }
	        	 StudentAllocateRoomModel.set("selectedRooms",roomArray);

	        	 var evalGroupRecord = value.evalGroup;
	        	 var evalGroupArray=[];
	        	 if(evalGroupRecord.length>0){
	        		 for(var i in evalGroupRecord){
	        			 if(Ext.isObject(evalGroupRecord[i])){
	        				 evalGroupArray.push(evalGroupRecord[i].get('id'));
	        			 }else{
	        				 evalGroupArray.push(evalGroupRecord[i]);
	        			 }
	        		 }
	        	 }
	        	 StudentAllocateRoomModel.set("evaluationGroupIds",evalGroupArray.join());

	        	 var courseField=form.findField('course');
	        	 var courseStore=courseField.getStore();
	        	 var courseRecord = value.course;
	        	 var courseArray=[];
	        	 var detailSeqArray=[];	
	        	 var courseData=null;
	        	 if(courseRecord.length>0){
	        		 for(var i in courseRecord){
	        			 if(Ext.isObject(courseRecord[i])){
	        				 // courseArray.push(courseRecord[i].get('id'));
	        				 courseData=courseStore.findRecord('id',courseRecord[i].get('id'),0,false,false,true);
	        				 courseArray.push(courseData.data.id);
	        				 detailSeqArray.push(courseData.data.detailSequenceId);
	        			 }else{
	        				 //courseArray.push(courseRecord[i]);
	        				 courseData=courseStore.findRecord('id',courseRecord[i],0,false,false,true);
	        				 courseArray.push(courseData.data.id);
	        				 detailSeqArray.push(courseData.data.detailSequenceId);
	        			 }
	        		 }
	        	 }
	        	 StudentAllocateRoomModel.set("courseIds",courseArray.join());
	        	 StudentAllocateRoomModel.set("detailSequenceIds",detailSeqArray.join());

	        	 var submitUrl;
	        	 if (form.findField('id').getSubmitValue() == null
	        			 || form.findField('id').getSubmitValue() == "") {
	        		 submitUrl = SERVERURL.ROOM_ALLOCATION_CREATE;
	        	 } 
	        	 delete StudentAllocateRoomModel.data.evalGroupCenterId;
	        	 delete StudentAllocateRoomModel.data.evalGroupSchDateId;
	        	 delete StudentAllocateRoomModel.data.groupScheduleBatchId;
	        	 var submitData = Ext.encode(StudentAllocateRoomModel.data);
	        	 $this.applyWindowMask();
	        	 Ext.Ajax.request({
	        		 type : 'rest',
	        		 url : submitUrl,
	        		 jsonData : submitData,
	        		 method : 'POST',
	        		 success : function(response, action) {
	        			 $this.hideWindowMask();
	        			 showSuccessMessage(getExaminationTranslation('ROOM_ALLOCATION'),getExaminationTranslation('ROOM_ALLOCATION_CREATED_SUCCESSFULLY'));
	        			 $this.getAllocateroomswin().close();
	        			 grid.getStore().reload();
	        		 }
	        	 });
	         },
	         // ************* Delete Student Room Allocate Rooms ******************
	         deleteStudentRoomAllocationRoom: function(){
	        	 var $this=this;
	        	 var grid =null;
	        	 var internalStndAllocationGrid=$this.getStudentAllocationGrid();
	        	 var externalStndAllocationGrid=$this.getStudentAllocationGridForExternal();
	        	 if(!internalStndAllocationGrid.isHidden()){
	        		 grid=internalStndAllocationGrid;
	        	 }else if(!externalStndAllocationGrid.isHidden()){
	        		 grid=externalStndAllocationGrid;
	        	 }
	        	 if(grid!=null){
	        		 var grdStore = grid.getStore();
	        		 if(grid.getSelectionModel().getCount()>0){
	        			 showConfirmMessage(getExaminationTranslation('ROOM_ALLOCATION'), getCommonTranslation("DELETE_CONFIRM_MESSAGE"), function(btn, text) {
	        				 if (btn == 'yes') {
	        					 var records=grid.getSelectionModel().getSelection();						        
	        					 var id=records[0].get("ID");
	        					 Ext.Ajax.request({
	        						 method: "DELETE",
	        						 type: 'rest',
	        						 url: SERVERURL.STUDENT_ROOM_ALLOCATION_DELETE_URL+'?id='+id,
	        						 headers: {
	        							 'Content-Type': 'application/json'
	        						 },
	        						 params:{
	        							 id:id
	        						 },
	        						 success:function(form, action){
	        							 grdStore.reload();
	        							 showSuccessMessage(getExaminationTranslation('ROOM_ALLOCATION'),getExaminationTranslation('ROOM_ALLOCATION_DELETED_SUCCESSFULLY'));
	        						 }
	        					 });
	        				 }
	        			 });
	        		 }else{
	        			 showWarningMessage(getExaminationTranslation('ROOM_ALLOCATION'),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        		 }
	        	 }
	         },
	         // ************* Delete Center Room Allocation Rooms ******************
	         deleteCenterRoomAllocationRoom: function(){
	        	 var $this=this;
	        	 var grid =$this.getCenterRoomAllocationGrid();
	        	 var grdStore = grid.getStore();
	        	 if(grid.getSelectionModel().getCount()>0){
	        		 showConfirmMessage(getExaminationTranslation('ROOM_ALLOCATION'), getCommonTranslation("DELETE_CONFIRM_MESSAGE"), function(btn, text) {
	        			 if (btn == 'yes') {
	        				 var records=grid.getSelectionModel().getSelection();						        
	        				 var id=records[0].get("id");
	        				 Ext.Ajax.request({
	        					 method: "DELETE",
	        					 type: 'rest',
	        					 url: SERVERURL.CENTER_ROOM_ALLOCATION_DELETE_URL+'?id='+id,
	        					 headers: {
	        						 'Content-Type': 'application/json'
	        					 },
	        					 params:{
	        						 id:id
	        					 },
	        					 success:function(form, action){
	        						 if(form.responseText=='true'){
	        							 showSuccessMessage(getExaminationTranslation('ROOM_ALLOCATION'),getExaminationTranslation('ROOM_ALLOCATION_DELETED_SUCCESSFULLY'));	 
	        						 }else{
	        							 showWarningMessage(getExaminationTranslation('ROOM_ALLOCATION'),getExaminationTranslation('ROOM_ALLOCATION_WARING_DELETED_MSG')); 
	        						 }
	        						 grdStore.reload();
	        					 }
	        				 });
	        			 }
	        		 });
	        	 }else{
	        		 showWarningMessage(getExaminationTranslation('ROOM_ALLOCATION'),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }
	         },
	         // ************* tbar for Student Allocation ******************
	         gridRenderFunctionForStudentAllocation:function(grid){
	        	 grid.addButtonToolbar();
	        	 var moreActionButton={
	        			 xtype : 'splitbutton',
	        			 itemId:'spBtnMoreActions',
	        			 text : getCommonTranslation("MOREACTIONS"),//More Actions
	        			 menu:[{
	        				 text:getExaminationTranslation('RESCHEDULE'),
	        				 itemId:'rescheduleLink'
	        			 }],
	        			 listeners: { click: function() { this.showMenu(); } }
	        	 };
	        	 grid.down('#functionButtonsToolbar').add(moreActionButton);
	         },
	         // ************* tbar for Room Capacity******************
	         gridRenderFunctionForRoomCapacity:function(grid){
	        	 grid.addButtonToolbar();
	        	 var moreActionButton={
	        			 xtype : 'splitbutton',
	        			 itemId:'spBtnMoreActions',
	        			 text : getCommonTranslation("MOREACTIONS"),
	        			 menu:[],
	        			 listeners: { click: function() { this.showMenu(); } }
	        	 };
	        	 grid.down('#functionButtonsToolbar').add(moreActionButton);
	         },
	         saveAssignedInvigilator:function(){
	        	 var $this=this;
	        	 var invigilatorWin=$this.getAssigninvigilatorwin();
	        	 var invigilatorForm=$this.getAssigninvigilatorWinForm().getForm();
	        	 var grid = $this.getCenterRoomAllocationGrid();
	        	 var records=grid.getSelectionModel().getSelection();
	        	 var invigilatorNameField=invigilatorForm.findField('invigilatorName');
	        	 var submitData={
	        			 "examRoomAllocationId":records[0].data.id,
	        			 "invigilatorId":invigilatorNameField.getValue()
	        	 };
	        	 submitUrl = SERVERURL.SAVE_INVIGILATOR_DATA_URL;
	        	 $this.applyWindowMask(); 
	        	 Ext.Ajax.request({
	        		 type : 'rest',
	        		 url : submitUrl,
	        		 jsonData : submitData,
	        		 method : 'POST',
	        		 success : function(response, action) {
	        			 $this.hideWindowMask();
	        			 showSuccessMessage(getExaminationTranslation('ASSIGN_INVIGILATOR'),getExaminationTranslation('ASSIGN_INVIGILATOR_SUCCESS_MSG'));
	        			 invigilatorWin.close();
	        			 grid.getStore().reload();
	        		 }
	        	 });
	         },
	         //******************* Load xml for student allocation and room capacity grids ****************			    
	         loadCommonGridRecord : function(respectiveLinkViewCode, respectiveLinkConfigCode,getResultGrid,model,records){

	        	 var  roomAllocationSearchForm = this.getRoomallocationquickfilter();
	        	 var jsonFormatFormData = this.createJsonFormat(roomAllocationSearchForm, respectiveLinkConfigCode,records);
	        	 var searchResultGrid = getResultGrid;
	        	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	        	 resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode);
	        	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	         },
	         createJsonFormat: function(roomAllocationSearchForm,respectiveLinkConfigCode ,record) {
	        	 var getForm=roomAllocationSearchForm.getForm();
	        	 var formValues = new Array();
	        	 var values = new Object();
	        	 var searchcriteria = new Array();
	        	 var courseField=getForm.findField('course');
	        	 var dateField=getForm.findField('date');
	        	 var timeSlotField=getForm.findField('timeSlot');
	        	 values.configCode = respectiveLinkConfigCode;
	        	 formValues = roomAllocationSearchForm.getValues();
	        	 var EVALUATION_GROUP_ID = this.getJsonObject('EVALUATION_GROUP_ID', formValues.evalGroup);
	        	 this.pushJsonObjectInArray(EVALUATION_GROUP_ID,searchcriteria);
	        	 if(courseField.getValue()!=null){
	        		 var courseIds=new Array();
	        		 Ext.Array.each(formValues.course,function(value,index){
	        			 var courseInt=parseInt(value.data.id);
	        			 courseIds.push(courseInt);
	        		 });
	        		 var COURSE_ID = this.getJsonObject('COURSE_ID', courseIds.join());
	        		 this.pushJsonObjectInArray(COURSE_ID,searchcriteria);   
	        	 }
	        	 var CENTER_TYPE = this.getJsonObject('CENTER_TYPE', formValues.centerType);
	        	 this.pushJsonObjectInArray(CENTER_TYPE,searchcriteria);
	        	 var EXAM_CENTER_ID = this.getJsonObject('EXAM_CENTER_ID', formValues.centerName);
	        	 this.pushJsonObjectInArray(EXAM_CENTER_ID,searchcriteria);
	        	 if(!isNullOrEmpty(dateField.valueModels[0])){
	        		 var EVAL_GROUP_SCH_DATE_ID = this.getJsonObject('EVAL_GROUP_SCH_DATE', dateField.valueModels[0].get('code'));
	        		 this.pushJsonObjectInArray(EVAL_GROUP_SCH_DATE_ID,searchcriteria);
	        	 }
	        	 var GROUP_SCHEDULE_BATCH_ID = this.getJsonObject('GROUP_SCHEDULE_BATCH', timeSlotField.getRawValue());
	        	 this.pushJsonObjectInArray(GROUP_SCHEDULE_BATCH_ID,searchcriteria);
	        	 var CENTER_ROOM_DETAILS_ID = this.getJsonObject('CENTER_ROOM_DETAILS_ID', formValues.roomNo);
	        	 this.pushJsonObjectInArray(CENTER_ROOM_DETAILS_ID,searchcriteria);
	        	 var ROOM_STATUS = this.getJsonObject('ROOM_STATUS', formValues.roomStatus);
	        	 this.pushJsonObjectInArray(ROOM_STATUS,searchcriteria);
	        	 var BOOKING_STATUS = this.getJsonObject('CENTER_BOOKING_STATUS', formValues.studentBookingStatus);
	        	 this.pushJsonObjectInArray(BOOKING_STATUS,searchcriteria);
	        	 values.searchCriterias = searchcriteria;
	        	 return values;
	         },
	         getJsonObject: function(key, value, additionalValue) {
	        	 if (value != '' && value != null && additionalValue == undefined) {
	        		 return {
	        			 "paramCode": key,
	        			 "paramValues": [value]
	        		 };
	        	 } else if (value != '' && additionalValue != undefined) {
	        		 return {
	        			 "paramCode": key,
	        			 "paramValues": [value, additionalValue]
	        		 };
	        	 }
	         },
	         pushJsonObjectInArray: function(object, array) {
	        	 if (object) {
	        		 array.push(object);
	        	 }

	         },
	         //********** save student room alloocation for booked and not assign records
	         saveStudentRoomAllocation : function(){
	        	 var $this=this;
	        	 var form = $this.getStudentroomallocationstructure();
	        	 var getForm=form.getForm();
	        	 var grid=$this.getRoomallocationforbookedstudentgrid();
	        	 var centerRoomAllocationGrig = $this.getCenterRoomAllocationGrid();
	        	 var centerRoomAllocationRecords=centerRoomAllocationGrig.getSelectionModel().getSelection()[0];
	        	 console.log('grid.getSelectionModel()',grid.getSelectionModel());
	        	 var balanceSeatForCheckField=getForm.findField('balanceSeatForCheck');
	        	 if(grid.getSelectionModel().getCount()>0){

	        		 if(balanceSeatForCheckField.getValue()>=grid.getSelectionModel().getCount()){
	        			 var records=grid.getSelectionModel().getSelection();
	        			 var stdBookngStatusField=getForm.findField('studentBookingStatus');
	        			 var idField=getForm.findField('id');

	        			 var myJson=[];
	        			 if(records.length>0){
	        				 for(var i in records){
	        					 myJson.push({
	        						 "examResultId":records[i].get("id"),
	        						 "examTimeSlotId":records[i].get("examTimeSlotId"),
	        						 "examRoomAllocationId":centerRoomAllocationRecords.data.id,
	        						 "evalGroupCenterId":records[i].get("evalGroupCenterId"),
	        						 "evalGroupSchDateId":records[i].get("groupScheduleDateId"),
	        						 "groupScheduleBatchId":records[i].get("groupScheduleBatchId"),
	        						 "admissionId":records[i].get("admissionId"),
	        						 "evaluationGroupId":records[i].get("evaluationGroupId"),
	        						 "courseId":records[i].get("courseId"),
	        						 "examCenterId":records[i].get("examCenterId")
	        					 });
	        				 }
	        			 }
	        			 var submitData = myJson;
	        			 if(stdBookngStatusField.getValue()==getExaminationTranslation('CNTRL_NOT_ASSIGNED')){
	        				 var submitUrl = SERVERURL.ASSIGN_EXAM_ROOMS_TO_STUDENTS_CREATE;
	        				 Ext.Ajax.request({
	        					 url: submitUrl,
	        					 jsonData: submitData,
	        					 method: 'POST',
	        					 success: function(response) {
	        						 showSuccessMessage(getExaminationTranslation('STUDENT_ALLOCATION'),getExaminationTranslation('STUDENT_ROOM_ALLOCATION_SUCCESS_MSG'));
	        						 /**
	        						  * It is used to check room capacity for students in below rest call also.
	        						  */
	        						 centerRoomAllocationGrig.getStore().reload({
	        							 callback:function(){
	        								 if(grid.getStore().getCount()>0){
	        									 var dataRec=centerRoomAllocationGrig.getStore().findRecord('id',idField.getValue(),0,false,false,true);

	        									 balanceSeatForCheckField.setValue(dataRec.data.balanceSeatForAllocateStudent); 
	        									 centerRoomAllocationGrig.getSelectionModel().select(dataRec);
	        								 }
	        							 }
	        						 });
	        						 grid.getSelectionModel().deselectAll(); 
	        						 grid.getStore().reload({
	        							 callback:function(){
	        								 if(centerRoomAllocationGrig.getStore().getCount()>0){
	        									 var dataRec=centerRoomAllocationGrig.getStore().findRecord('id',idField.getValue(),0,false,false,true);

	        									 balanceSeatForCheckField.setValue(dataRec.data.balanceSeatForAllocateStudent); 
	        									 centerRoomAllocationGrig.getSelectionModel().select(dataRec);
	        								 }
	        							 }
	        						 });
	        					 }
	        				 });
	        			 }else if(stdBookngStatusField.getValue()==getExaminationTranslation('CNTRL_BOOKED')){
	        				 var submitUrl = SERVERURL.BOOK_EXAM_TIME_SLOT_AND_ASSIGN_ROOM_TO_STUDENTS_CREATE;
	        				 Ext.Ajax.request({
	        					 url: submitUrl,
	        					 jsonData: submitData,
	        					 method: 'POST',
	        					 success: function(response) {
	        						 showSuccessMessage(getExaminationTranslation('STUDENT_ALLOCATION'),getExaminationTranslation('STUDENT_ROOM_ALLOCATION_SUCCESS_MSG'));
	        						 /**
	        						  * It is used to check room capacity for students in above rest call also.
	        						  */
	        						 centerRoomAllocationGrig.getStore().reload({
	        							 callback:function(){
	        								 if(grid.getStore().getCount()>0){
	        									 var dataRec=centerRoomAllocationGrig.getStore().findRecord('id',idField.getValue(),0,false,false,true);
	        									 console.log('dataRec in center room callback',dataRec);
	        									 balanceSeatForCheckField.setValue(dataRec.data.balanceSeatForAllocateStudent); 
	        									 centerRoomAllocationGrig.getSelectionModel().select(dataRec);
	        								 }
	        							 }
	        						 });
	        						 grid.getSelectionModel().deselectAll(); 
	        						 grid.getStore().reload({
	        							 callback:function(){
	        								 if(centerRoomAllocationGrig.getStore().getCount()>0){
	        									 var dataRec=centerRoomAllocationGrig.getStore().findRecord('id',idField.getValue(),0,false,false,true);
	        									 console.log('dataRec',dataRec);
	        									 balanceSeatForCheckField.setValue(dataRec.data.balanceSeatForAllocateStudent); 
	        									 centerRoomAllocationGrig.getSelectionModel().select(dataRec);
	        								 }
	        							 }
	        						 });
	        					 }
	        				 });
	        			 }
	        		 }else{
	        			 showWarningMessage(getExaminationTranslation('ROOM_ALLOCATION'),getExaminationTranslation('ROOM_CAPACITY_STUDENTS_WARING_MSG'));
	        		 }
	        	 }else{
	        		 showWarningMessage(getExaminationTranslation('ROOM_ALLOCATION'),getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	 }  
	         },
	         loadDataGridForStudentRoomAllocation:function(){
	        	 var $this=this;
	        	 var studetnRoomAllocationGrid=$this.getRoomallocationforbookedstudentgrid();
	        	 var quickSearchForm = $this.getStudentroomallocationstructure();
	        	 var form=quickSearchForm.getForm();
	        	 var studentBookingStatusField=form.findField('studentBookingStatus');
	        	 var centeRoomAllocationGrid=$this.getCenterRoomAllocationGrid();
	        	 var centerRoomsrecords=centeRoomAllocationGrid.getSelectionModel().getSelection()[0];
	        	 studetnRoomAllocationGrid.getStore().getProxy().extraParams={
	        		 roomAllocationStatus:'ALLOCATION_PENDING',
	        		 centerStatus:studentBookingStatusField.getValue(),
	        		 courseId:centerRoomsrecords.data.courseId,
	        		 evaluationGroupId:centerRoomsrecords.data.evaluationGroupId,
	        		 groupDateBatchCenterId:centerRoomsrecords.data.groupDateBatchCenterId,
	        		 detailSeqId:centerRoomsrecords.data.evalSeqDetailId,
	        		 centerType:centerRoomsrecords.data.centerType,
	        		 examCenterId:centerRoomsrecords.data.examCenterId
	        	 };
	        	 studetnRoomAllocationGrid.getStore().load();
	        	 /*var quickSearchForm = this.getStudentroomallocationstructure();
		             		var jsonFormatFormData = this.createJsonFormatForStudentRoomAllocation(quickSearchForm);
		             		var searchResultGrid = this.getStudentRoomAllocationGrid();
		             		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		                 	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.EXAM_STUDENT_ALLOCATION_BOOKED_LISTING_VIEWCODE);
		                	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);*/
	         },
	         /**
	          *It's not in use 
	          */
	         createJsonFormatForStudentRoomAllocation:function(quickSearchForm, record){			
	        	 var form = quickSearchForm.getForm();
	        	 var studentBookingStatusField=form.findField('studentBookingStatus');
	        	 var centeRoomAllocationGrid=this.getCenterRoomAllocationGrid();
	        	 var centerRoomsrecords=centeRoomAllocationGrid.getSelectionModel().getSelection()[0];
	        	 var values = new Object();
	        	 values.configCode = CONSTANTS.CB.EXAM_STUDENT_ALLOCATION_BOOKED_LISTING_CONFIGCODE;
	        	 var searchcriteria = new Array();
	        	 /**
	        	  * Here Room Allocation pending is pemanent parameter to send in the filter ,to fetch pending rooms only
	        	  */
	        	 searchcriteria.push({paramCode:"ROOM_ALLOCATION_STATUS", paramValues:["ALLOCATION_PENDING"]});
	        	 searchcriteria.push({paramCode:"EVALUATION_GROUP_ID", paramValues:[centerRoomsrecords.data.evaluationGroupId]});
	        	 searchcriteria.push({paramCode:"GROUP_DATE_BATCH_CENTER_ID", paramValues:[centerRoomsrecords.data.groupDateBatchCenterId]});
	        	 searchcriteria.push({paramCode:"EVAL_SEQ_DETAIL_ID", paramValues:[centerRoomsrecords.data.evalSeqDetailId]});
	        	 searchcriteria.push({paramCode:"COURSE_ID", paramValues:[centerRoomsrecords.data.courseId]});
	        	 if(studentBookingStatusField.getValue() != null){
	        		 searchcriteria.push({paramCode:"CENTER_STATUS", paramValues:[studentBookingStatusField.getValue()]});
	        	 }	
	        	 values.searchCriterias=searchcriteria;
	        	 return values;
	         },
	         /**
	          * Disable More Action Button in center Room Allocation 
	          */
	         disableMoreActionPivileges: function(gridReference,permissionsMap) {

	        	 var associatedAcadLocationIds = new Array();
	        	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	        	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        	 buttonsToolBar = gridReference.query('toolbar')[0];
	        	 var splitbuttons = buttonsToolBar.query('splitbutton')[0];
	        	 Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	        		 menuItems.setVisible(false);
	        	 });
	        	 Ext.each(permissionList, function(privilege) {
	        		 if (privilege === 'MOREACTION') {
	        			 var button = buttonsToolBar.query('#spBtnMoreActions')[0];
	        			 if(!isNullOrEmpty(button)){
	        				 button.setVisible(true);
	        			 }        		
	        		 }
	        		 if (privilege === 'STUDENTROOMAALOCATION') {
	        			 var button = buttonsToolBar.query('#mapStudentId')[0];
	        			 if(!isNullOrEmpty(button)){
	        				 button.setVisible(true);
	        			 }        		
	        		 }
	        		 if (privilege === 'ASSIGNINVIGILATOR') {
	        			 var button = buttonsToolBar.query('#assignInvigilatorId')[0];
	        			 if(!isNullOrEmpty(button)){
	        				 button.setVisible(true);
	        			 }        		
	        		 }
	        		 if (privilege === 'PRINTTIMETABLE') {
	        			 var button = buttonsToolBar.query('#printTimeTable')[0];
	        			 if(!isNullOrEmpty(button)){
	        				 button.setVisible(true);
	        			 }        		
	        		 }
	        	 });
	         },
	         //
	         exportUserList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
	        	 var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	        	 console.log('pagingtoolbaroptions',pagingtoolbaroptions);
	        	 var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        	 var jsonFormatFormData = this.createJsonFormat(quickSearchForm,configCode);
	        	 var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        	 var reportTitle=getCommonTranslation('ROOMALLOCATION_LIST');
	        	 
	        	 if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	        		 jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	        	 }
	        	 searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

	         },
	         createSearchCriteriaString: function(searchForm) {
	        	 var me=this;
	        	 var formValues = new Array();
	        	 formValues = searchForm.getValues();        
	        	 var searchCriteriaString="";
	        	 for (var key in formValues) {
	        		 var value = formValues[key];            
	        		 if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	        			 var keyValueJsonObject = me.getJsonObject( key , value);
	        			 searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	        		 }
	        	 }
	        	 searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        	 return searchCriteriaString;
	         },
	         
	         disableImportExaminationRemarkTab: function(structure, permissionsMap) {
	             var associatedAcadLocationIds = new Array();
	             associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	             var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	             var examinationRemarkImportTab = false;

	             for (var i = 0; i < permissionList.length; i++) {
	                 if (permissionList[i] === "IMPORT_BULK_EXAMINATION_REMARK") {
	                     examinationRemarkImportTab = true;
	                 }
	             }
	             this.showExaminationRemarkTab(examinationRemarkImportTab, structure);
	         },

	         showExaminationRemarkTab: function(examinationRemarkImportTab, structure) {
	             var panelItem = new Array();
	             var $this = this;
	             var newcont = structure.items.items.length;
	             var insertPosition = newcont + 1;
	             if (examinationRemarkImportTab) {
	                 panelItem.push({
	                     xtype: 'tabpanel',
	                     itemId: 'allVisibleTP',
	                     plain: true,
	                     style: {
	                         overflow: 'hidden !important'
	                     },
	                     frame: false,
	                     border: false,
	                     defaults: {
	                         labelAlign: 'top'
	                     },
	                     items: [{
	                         xtype: 'form',
	                         title: getCommonTranslation("SEARCH"),
	                         tabCls: 'right-tab',
	                         autoScroll: true,
	                         frame: false,
	                         items: [{
	                             xtype: 'fieldcontainer',
	                             layout: 'fit',
	                             defaults: {
	                                 width: '100%',
	                                 labelAlign: 'top'
	                             },
	                             items: [{
	                                 xtype: 'fieldcontainer',
	                                 layout: 'hbox',
	                                 defaults: {
	                                     width: '100%',
	                                     labelAlign: 'top'
	                                 },
	                                 items: [{
	                                	 xtype:'panel',
	                                		 items:[{
	    	                                     xtype: 'examinationremarkgrid',
	    	                                     title: getExaminationTranslation('EXAM_REMARK_GRID'),
	    	                                     itemId: 'remarkId',
	    	                                     defaults: {
	    	                                         labelAlign: 'top'
	    	                                     },
	    	                                 }]
	                                 }]
	                             }, {
	                                 xtype: 'fieldcontainer',
	                                 layout: 'hbox',
	                                 defaults: {
	                                     width: '33.33%',
	                                     labelAlign: 'top'
	                                 },
	                                
	                                 items: [{
	                                	 xtype:'panel',
	                                	 style:{
	                                    	 marginTop:'-8px !important'
	                                     },
	                                	 items:[{
		                                     xtype: 'examinationremarkcoursegrid',
		                                     itemId: 'examinationremarkcoursegridId',
		                                     title: getExaminationTranslation('MAPPED_COURSE_LIST'),
		                                     defaults: {
		                                         width: '33.33%',
		                                         labelAlign: 'top'
		                                     }
		                                 }]
	                                 }, {
	                                	 xtype:'panel',
	                                	 style:{
	                                    	 marginTop:'-8px !important'
	                                     },
	                                	 items:[{
		                                     xtype: 'examinationremarkplangrid',
		                                     title:  getExaminationTranslation('MAPPED_PLAN_LIST'),
		                                     itemId: 'examinationremarkplangridId',
		                                     defaults: {
		                                         width: '33.33%',
		                                         labelAlign: 'top'
		                                     }
		                                 }]
	                                 }, {
	                                	 xtype:'panel',
	                                	 style:{
	                                    	 marginTop:'-8px !important'
	                                     },
	                                	 items:[{
		                                     xtype: 'examinationremarkprogramgrid',
		                                     title:  getExaminationTranslation('MAPPED_PROGRAM_LIST'),
		                                     itemId: 'examinationremarkprogramgridId',
		                                     defaults: {
		                                         width: '33.33%',
		                                         labelAlign: 'top'
		                                     },
		                                     listeners:{
		                    	        			 render:function(obj){
		                    	        				 obj.getStore().clearData();
		                    	        				
		                    	        			 }
		                    	        		 
		                                     }
		                                     
		                                 }]
	                                 }]
	                             }],
	                         }]
	                     }, {
	                         xtype: 'examinationremarkuploaddownloadstructure',
	                         title: getCommonTranslation('IMPORT_EXAMINATION_REMARK'),
	                     }]
	                 });

	             } else {
	                 panelItem.push({
	                     xtype: 'tabpanel',
	                     itemId: 'allVisibleTP',
	                     plain: true,
	                     style: {
	                         overflow: 'hidden !important'
	                     },
	                     frame: false,
	                     border: false,
	                     defaults: {
	                         labelAlign: 'top'
	                     },
	                     items: [{
	                         xtype: 'form',
	                         title: getCommonTranslation("SEARCH"),
	                         tabCls: 'right-tab',
	                         autoScroll: true,
	                         frame: false,
	                         items: [{
	                             xtype: 'fieldcontainer',
	                             layout: 'vbox',
	                             defaults: {
	                                 width: '100%',
	                                 labelAlign: 'top'
	                             },
	                             items: [{
	                                 xtype: 'fieldcontainer',
	                                 layout: 'hbox',
	                                 defaults: {
	                                     width: '100%',
	                                     labelAlign: 'top'
	                                 },
	                                 items: [{
	                                     xtype: 'examinationremarkgrid',
	                                     title: getExaminationTranslation('EXAM_REMARK_GRID'),
	                                     itemId: 'remarkId',
	                                     defaults: {
	                                         labelAlign: 'top'
	                                     },
	                                 }]
	                             }, {
	                                 xtype: 'fieldcontainer',
	                                 layout: 'hbox',
	                                 defaults: {
	                                     width: '33.33%',
	                                     labelAlign: 'top'
	                                 },
	                                 items: [{
	                                     xtype: 'examinationremarkcoursegrid',
	                                     itemId: 'examinationremarkcoursegridId',
	                                     title: getExaminationTranslation("MAPPED_COURSE_LIST"),
	                                     defaults: {
	                                         width: '33.33%',
	                                         labelAlign: 'top'
	                                     },
	                                     maxWidth:400
	                                 }, {
	                                     xtype: 'examinationremarkplangrid',
	                                     title: getExaminationTranslation("MAPPED_PLAN_LIST"),
	                                     itemId: 'examinationremarkplangridId',
	                                     defaults: {
	                                         width: '33.33%',
	                                         labelAlign: 'top'
	                                     },
	                                     maxWidth:400
	                                 }, {
	                                     xtype: 'examinationremarkprogramgrid',
	                                     title: getExaminationTranslation("MAPPED_PROGRAM_LIST"),
	                                     itemId: 'examinationremarkprogramgridId',
	                                     defaults: {
	                                         width: '33.33%',
	                                         labelAlign: 'top'
	                                     },
	                                     maxWidth:400
	                                 }]
	                             }],
	                         }]
	                     }]
	                 });

	             }
	             structure.insert(insertPosition, panelItem);
	         }
});
